// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             (unknown)
// source: controller/api/services/v1/host_catalog_service.proto

package services

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	HostCatalogService_GetHostCatalog_FullMethodName    = "/controller.api.services.v1.HostCatalogService/GetHostCatalog"
	HostCatalogService_ListHostCatalogs_FullMethodName  = "/controller.api.services.v1.HostCatalogService/ListHostCatalogs"
	HostCatalogService_CreateHostCatalog_FullMethodName = "/controller.api.services.v1.HostCatalogService/CreateHostCatalog"
	HostCatalogService_UpdateHostCatalog_FullMethodName = "/controller.api.services.v1.HostCatalogService/UpdateHostCatalog"
	HostCatalogService_DeleteHostCatalog_FullMethodName = "/controller.api.services.v1.HostCatalogService/DeleteHostCatalog"
)

// HostCatalogServiceClient is the client API for HostCatalogService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type HostCatalogServiceClient interface {
	// GetHostCatalog returns a stored Host Catalog if present.  The provided
	// request must include the Catalog IDs for the Host Catalog being retrieved.
	// If missing, malformed, or referencing a non-existing resource an error is
	// returned.
	GetHostCatalog(ctx context.Context, in *GetHostCatalogRequest, opts ...grpc.CallOption) (*GetHostCatalogResponse, error)
	// ListHostCatalogs returns a list of stored Host Catalogs which exist inside
	// the scope referenced in the request. The request must include the scope
	// ID and if it is  missing, malformed, or references a non-existing resource
	// an error is returned.
	ListHostCatalogs(ctx context.Context, in *ListHostCatalogsRequest, opts ...grpc.CallOption) (*ListHostCatalogsResponse, error)
	// CreateHostCatalog creates and stores a Host Catalog in boundary.  The
	// provided request must include the scope ID in which the Catalog will be
	// created and the Catalog type to be created. If any of these required fields
	// are missing, malformed, or reference a non-existing parent resource an
	// error is returned.
	CreateHostCatalog(ctx context.Context, in *CreateHostCatalogRequest, opts ...grpc.CallOption) (*CreateHostCatalogResponse, error)
	// UpdateHostCatalog updates an existing Host Catalog in Boundary. The
	// provided Host Catalog must not have any read only fields set. The update
	// mask must be provided and include at least 1 mutable field. To unset a
	// field's value include that field name in the update mask and don't set the
	// field in the Host Catalog.
	UpdateHostCatalog(ctx context.Context, in *UpdateHostCatalogRequest, opts ...grpc.CallOption) (*UpdateHostCatalogResponse, error)
	// DeleteHostCatalog removes a Host Catalog and all associated Hosts and Host
	// sets from Boundary. If the provided Host Catalog IDs is malformed or not
	// provided DeleteHostCatalog returns an error.
	DeleteHostCatalog(ctx context.Context, in *DeleteHostCatalogRequest, opts ...grpc.CallOption) (*DeleteHostCatalogResponse, error)
}

type hostCatalogServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewHostCatalogServiceClient(cc grpc.ClientConnInterface) HostCatalogServiceClient {
	return &hostCatalogServiceClient{cc}
}

func (c *hostCatalogServiceClient) GetHostCatalog(ctx context.Context, in *GetHostCatalogRequest, opts ...grpc.CallOption) (*GetHostCatalogResponse, error) {
	out := new(GetHostCatalogResponse)
	err := c.cc.Invoke(ctx, HostCatalogService_GetHostCatalog_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hostCatalogServiceClient) ListHostCatalogs(ctx context.Context, in *ListHostCatalogsRequest, opts ...grpc.CallOption) (*ListHostCatalogsResponse, error) {
	out := new(ListHostCatalogsResponse)
	err := c.cc.Invoke(ctx, HostCatalogService_ListHostCatalogs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hostCatalogServiceClient) CreateHostCatalog(ctx context.Context, in *CreateHostCatalogRequest, opts ...grpc.CallOption) (*CreateHostCatalogResponse, error) {
	out := new(CreateHostCatalogResponse)
	err := c.cc.Invoke(ctx, HostCatalogService_CreateHostCatalog_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hostCatalogServiceClient) UpdateHostCatalog(ctx context.Context, in *UpdateHostCatalogRequest, opts ...grpc.CallOption) (*UpdateHostCatalogResponse, error) {
	out := new(UpdateHostCatalogResponse)
	err := c.cc.Invoke(ctx, HostCatalogService_UpdateHostCatalog_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hostCatalogServiceClient) DeleteHostCatalog(ctx context.Context, in *DeleteHostCatalogRequest, opts ...grpc.CallOption) (*DeleteHostCatalogResponse, error) {
	out := new(DeleteHostCatalogResponse)
	err := c.cc.Invoke(ctx, HostCatalogService_DeleteHostCatalog_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// HostCatalogServiceServer is the server API for HostCatalogService service.
// All implementations must embed UnimplementedHostCatalogServiceServer
// for forward compatibility
type HostCatalogServiceServer interface {
	// GetHostCatalog returns a stored Host Catalog if present.  The provided
	// request must include the Catalog IDs for the Host Catalog being retrieved.
	// If missing, malformed, or referencing a non-existing resource an error is
	// returned.
	GetHostCatalog(context.Context, *GetHostCatalogRequest) (*GetHostCatalogResponse, error)
	// ListHostCatalogs returns a list of stored Host Catalogs which exist inside
	// the scope referenced in the request. The request must include the scope
	// ID and if it is  missing, malformed, or references a non-existing resource
	// an error is returned.
	ListHostCatalogs(context.Context, *ListHostCatalogsRequest) (*ListHostCatalogsResponse, error)
	// CreateHostCatalog creates and stores a Host Catalog in boundary.  The
	// provided request must include the scope ID in which the Catalog will be
	// created and the Catalog type to be created. If any of these required fields
	// are missing, malformed, or reference a non-existing parent resource an
	// error is returned.
	CreateHostCatalog(context.Context, *CreateHostCatalogRequest) (*CreateHostCatalogResponse, error)
	// UpdateHostCatalog updates an existing Host Catalog in Boundary. The
	// provided Host Catalog must not have any read only fields set. The update
	// mask must be provided and include at least 1 mutable field. To unset a
	// field's value include that field name in the update mask and don't set the
	// field in the Host Catalog.
	UpdateHostCatalog(context.Context, *UpdateHostCatalogRequest) (*UpdateHostCatalogResponse, error)
	// DeleteHostCatalog removes a Host Catalog and all associated Hosts and Host
	// sets from Boundary. If the provided Host Catalog IDs is malformed or not
	// provided DeleteHostCatalog returns an error.
	DeleteHostCatalog(context.Context, *DeleteHostCatalogRequest) (*DeleteHostCatalogResponse, error)
	mustEmbedUnimplementedHostCatalogServiceServer()
}

// UnimplementedHostCatalogServiceServer must be embedded to have forward compatible implementations.
type UnimplementedHostCatalogServiceServer struct {
}

func (UnimplementedHostCatalogServiceServer) GetHostCatalog(context.Context, *GetHostCatalogRequest) (*GetHostCatalogResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetHostCatalog not implemented")
}
func (UnimplementedHostCatalogServiceServer) ListHostCatalogs(context.Context, *ListHostCatalogsRequest) (*ListHostCatalogsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListHostCatalogs not implemented")
}
func (UnimplementedHostCatalogServiceServer) CreateHostCatalog(context.Context, *CreateHostCatalogRequest) (*CreateHostCatalogResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateHostCatalog not implemented")
}
func (UnimplementedHostCatalogServiceServer) UpdateHostCatalog(context.Context, *UpdateHostCatalogRequest) (*UpdateHostCatalogResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateHostCatalog not implemented")
}
func (UnimplementedHostCatalogServiceServer) DeleteHostCatalog(context.Context, *DeleteHostCatalogRequest) (*DeleteHostCatalogResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteHostCatalog not implemented")
}
func (UnimplementedHostCatalogServiceServer) mustEmbedUnimplementedHostCatalogServiceServer() {}

// UnsafeHostCatalogServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to HostCatalogServiceServer will
// result in compilation errors.
type UnsafeHostCatalogServiceServer interface {
	mustEmbedUnimplementedHostCatalogServiceServer()
}

func RegisterHostCatalogServiceServer(s grpc.ServiceRegistrar, srv HostCatalogServiceServer) {
	s.RegisterService(&HostCatalogService_ServiceDesc, srv)
}

func _HostCatalogService_GetHostCatalog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetHostCatalogRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HostCatalogServiceServer).GetHostCatalog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HostCatalogService_GetHostCatalog_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HostCatalogServiceServer).GetHostCatalog(ctx, req.(*GetHostCatalogRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HostCatalogService_ListHostCatalogs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListHostCatalogsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HostCatalogServiceServer).ListHostCatalogs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HostCatalogService_ListHostCatalogs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HostCatalogServiceServer).ListHostCatalogs(ctx, req.(*ListHostCatalogsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HostCatalogService_CreateHostCatalog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateHostCatalogRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HostCatalogServiceServer).CreateHostCatalog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HostCatalogService_CreateHostCatalog_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HostCatalogServiceServer).CreateHostCatalog(ctx, req.(*CreateHostCatalogRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HostCatalogService_UpdateHostCatalog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateHostCatalogRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HostCatalogServiceServer).UpdateHostCatalog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HostCatalogService_UpdateHostCatalog_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HostCatalogServiceServer).UpdateHostCatalog(ctx, req.(*UpdateHostCatalogRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HostCatalogService_DeleteHostCatalog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteHostCatalogRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HostCatalogServiceServer).DeleteHostCatalog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HostCatalogService_DeleteHostCatalog_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HostCatalogServiceServer).DeleteHostCatalog(ctx, req.(*DeleteHostCatalogRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// HostCatalogService_ServiceDesc is the grpc.ServiceDesc for HostCatalogService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var HostCatalogService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "controller.api.services.v1.HostCatalogService",
	HandlerType: (*HostCatalogServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetHostCatalog",
			Handler:    _HostCatalogService_GetHostCatalog_Handler,
		},
		{
			MethodName: "ListHostCatalogs",
			Handler:    _HostCatalogService_ListHostCatalogs_Handler,
		},
		{
			MethodName: "CreateHostCatalog",
			Handler:    _HostCatalogService_CreateHostCatalog_Handler,
		},
		{
			MethodName: "UpdateHostCatalog",
			Handler:    _HostCatalogService_UpdateHostCatalog_Handler,
		},
		{
			MethodName: "DeleteHostCatalog",
			Handler:    _HostCatalogService_DeleteHostCatalog_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "controller/api/services/v1/host_catalog_service.proto",
}
