// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             (unknown)
// source: controller/api/services/v1/group_service.proto

package services

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	GroupService_GetGroup_FullMethodName           = "/controller.api.services.v1.GroupService/GetGroup"
	GroupService_ListGroups_FullMethodName         = "/controller.api.services.v1.GroupService/ListGroups"
	GroupService_CreateGroup_FullMethodName        = "/controller.api.services.v1.GroupService/CreateGroup"
	GroupService_UpdateGroup_FullMethodName        = "/controller.api.services.v1.GroupService/UpdateGroup"
	GroupService_DeleteGroup_FullMethodName        = "/controller.api.services.v1.GroupService/DeleteGroup"
	GroupService_AddGroupMembers_FullMethodName    = "/controller.api.services.v1.GroupService/AddGroupMembers"
	GroupService_SetGroupMembers_FullMethodName    = "/controller.api.services.v1.GroupService/SetGroupMembers"
	GroupService_RemoveGroupMembers_FullMethodName = "/controller.api.services.v1.GroupService/RemoveGroupMembers"
)

// GroupServiceClient is the client API for GroupService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type GroupServiceClient interface {
	// GetGroup returns a stored Group if present. The provided request must
	// include the Group id and if it is missing, malformed or referencing a
	// non existing resource an error is returned.
	GetGroup(ctx context.Context, in *GetGroupRequest, opts ...grpc.CallOption) (*GetGroupResponse, error)
	// ListGroups returns a list of stored Groups which exist inside the
	// provided scope id. If that id is missing, malformed, or
	// references a non-existing scope, an error is returned.
	ListGroups(ctx context.Context, in *ListGroupsRequest, opts ...grpc.CallOption) (*ListGroupsResponse, error)
	// CreateGroup creates and stores a Group in boundary. The provided
	// request must include the scope ID in which the Group will be created.
	// If the scope ID is missing, malformed or references a non existing
	// resource, an error is returned. If a name is provided that is in
	// use in another Group in the same scope, an error is returned.
	CreateGroup(ctx context.Context, in *CreateGroupRequest, opts ...grpc.CallOption) (*CreateGroupResponse, error)
	// UpdateGroup updates an existing Group in boundary. The provided Group
	// must not have any read only fields set. The update mask must be included in
	// the request and contain at least 1 mutable field. To unset a field's value,
	// include the field in the update mask and don't set it in the provided
	// Group. An error is returned if the Group id is missing or reference a
	// non-existing resource. An error is also returned if the request attempts
	// to update the name to one that is already used by another Group in the
	// same scope.
	UpdateGroup(ctx context.Context, in *UpdateGroupRequest, opts ...grpc.CallOption) (*UpdateGroupResponse, error)
	// DeleteGroup removes a Group from Boundary. If the provided Group
	// ID is malformed or not provided an error is returned.
	DeleteGroup(ctx context.Context, in *DeleteGroupRequest, opts ...grpc.CallOption) (*DeleteGroupResponse, error)
	// AddGroupMembers adds members to a Group.  The provided request must include
	// the scope id and the Group id which the members will be added to.
	// An error is returned if any provided id is missing, malformed or
	// references a non-existing resource.
	AddGroupMembers(ctx context.Context, in *AddGroupMembersRequest, opts ...grpc.CallOption) (*AddGroupMembersResponse, error)
	// SetGroupMembers sets the Group's members.  Any existing members on
	// the Group are deleted if they are not included in this request.  The provided
	// request must include the Group id which the members will be set to.
	// An error is returned if any provided id is missing, malformed or
	// references a non-existing resource.
	SetGroupMembers(ctx context.Context, in *SetGroupMembersRequest, opts ...grpc.CallOption) (*SetGroupMembersResponse, error)
	// RemoveGroupMembers removes members from the specified Group.
	// The provided request must include the the Group id to which the members
	// will be set.
	// An error is returned if any provided id is missing, malformed or
	// references a non-existing resource.
	RemoveGroupMembers(ctx context.Context, in *RemoveGroupMembersRequest, opts ...grpc.CallOption) (*RemoveGroupMembersResponse, error)
}

type groupServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewGroupServiceClient(cc grpc.ClientConnInterface) GroupServiceClient {
	return &groupServiceClient{cc}
}

func (c *groupServiceClient) GetGroup(ctx context.Context, in *GetGroupRequest, opts ...grpc.CallOption) (*GetGroupResponse, error) {
	out := new(GetGroupResponse)
	err := c.cc.Invoke(ctx, GroupService_GetGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupServiceClient) ListGroups(ctx context.Context, in *ListGroupsRequest, opts ...grpc.CallOption) (*ListGroupsResponse, error) {
	out := new(ListGroupsResponse)
	err := c.cc.Invoke(ctx, GroupService_ListGroups_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupServiceClient) CreateGroup(ctx context.Context, in *CreateGroupRequest, opts ...grpc.CallOption) (*CreateGroupResponse, error) {
	out := new(CreateGroupResponse)
	err := c.cc.Invoke(ctx, GroupService_CreateGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupServiceClient) UpdateGroup(ctx context.Context, in *UpdateGroupRequest, opts ...grpc.CallOption) (*UpdateGroupResponse, error) {
	out := new(UpdateGroupResponse)
	err := c.cc.Invoke(ctx, GroupService_UpdateGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupServiceClient) DeleteGroup(ctx context.Context, in *DeleteGroupRequest, opts ...grpc.CallOption) (*DeleteGroupResponse, error) {
	out := new(DeleteGroupResponse)
	err := c.cc.Invoke(ctx, GroupService_DeleteGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupServiceClient) AddGroupMembers(ctx context.Context, in *AddGroupMembersRequest, opts ...grpc.CallOption) (*AddGroupMembersResponse, error) {
	out := new(AddGroupMembersResponse)
	err := c.cc.Invoke(ctx, GroupService_AddGroupMembers_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupServiceClient) SetGroupMembers(ctx context.Context, in *SetGroupMembersRequest, opts ...grpc.CallOption) (*SetGroupMembersResponse, error) {
	out := new(SetGroupMembersResponse)
	err := c.cc.Invoke(ctx, GroupService_SetGroupMembers_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *groupServiceClient) RemoveGroupMembers(ctx context.Context, in *RemoveGroupMembersRequest, opts ...grpc.CallOption) (*RemoveGroupMembersResponse, error) {
	out := new(RemoveGroupMembersResponse)
	err := c.cc.Invoke(ctx, GroupService_RemoveGroupMembers_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// GroupServiceServer is the server API for GroupService service.
// All implementations must embed UnimplementedGroupServiceServer
// for forward compatibility
type GroupServiceServer interface {
	// GetGroup returns a stored Group if present. The provided request must
	// include the Group id and if it is missing, malformed or referencing a
	// non existing resource an error is returned.
	GetGroup(context.Context, *GetGroupRequest) (*GetGroupResponse, error)
	// ListGroups returns a list of stored Groups which exist inside the
	// provided scope id. If that id is missing, malformed, or
	// references a non-existing scope, an error is returned.
	ListGroups(context.Context, *ListGroupsRequest) (*ListGroupsResponse, error)
	// CreateGroup creates and stores a Group in boundary. The provided
	// request must include the scope ID in which the Group will be created.
	// If the scope ID is missing, malformed or references a non existing
	// resource, an error is returned. If a name is provided that is in
	// use in another Group in the same scope, an error is returned.
	CreateGroup(context.Context, *CreateGroupRequest) (*CreateGroupResponse, error)
	// UpdateGroup updates an existing Group in boundary. The provided Group
	// must not have any read only fields set. The update mask must be included in
	// the request and contain at least 1 mutable field. To unset a field's value,
	// include the field in the update mask and don't set it in the provided
	// Group. An error is returned if the Group id is missing or reference a
	// non-existing resource. An error is also returned if the request attempts
	// to update the name to one that is already used by another Group in the
	// same scope.
	UpdateGroup(context.Context, *UpdateGroupRequest) (*UpdateGroupResponse, error)
	// DeleteGroup removes a Group from Boundary. If the provided Group
	// ID is malformed or not provided an error is returned.
	DeleteGroup(context.Context, *DeleteGroupRequest) (*DeleteGroupResponse, error)
	// AddGroupMembers adds members to a Group.  The provided request must include
	// the scope id and the Group id which the members will be added to.
	// An error is returned if any provided id is missing, malformed or
	// references a non-existing resource.
	AddGroupMembers(context.Context, *AddGroupMembersRequest) (*AddGroupMembersResponse, error)
	// SetGroupMembers sets the Group's members.  Any existing members on
	// the Group are deleted if they are not included in this request.  The provided
	// request must include the Group id which the members will be set to.
	// An error is returned if any provided id is missing, malformed or
	// references a non-existing resource.
	SetGroupMembers(context.Context, *SetGroupMembersRequest) (*SetGroupMembersResponse, error)
	// RemoveGroupMembers removes members from the specified Group.
	// The provided request must include the the Group id to which the members
	// will be set.
	// An error is returned if any provided id is missing, malformed or
	// references a non-existing resource.
	RemoveGroupMembers(context.Context, *RemoveGroupMembersRequest) (*RemoveGroupMembersResponse, error)
	mustEmbedUnimplementedGroupServiceServer()
}

// UnimplementedGroupServiceServer must be embedded to have forward compatible implementations.
type UnimplementedGroupServiceServer struct {
}

func (UnimplementedGroupServiceServer) GetGroup(context.Context, *GetGroupRequest) (*GetGroupResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGroup not implemented")
}
func (UnimplementedGroupServiceServer) ListGroups(context.Context, *ListGroupsRequest) (*ListGroupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListGroups not implemented")
}
func (UnimplementedGroupServiceServer) CreateGroup(context.Context, *CreateGroupRequest) (*CreateGroupResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateGroup not implemented")
}
func (UnimplementedGroupServiceServer) UpdateGroup(context.Context, *UpdateGroupRequest) (*UpdateGroupResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateGroup not implemented")
}
func (UnimplementedGroupServiceServer) DeleteGroup(context.Context, *DeleteGroupRequest) (*DeleteGroupResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteGroup not implemented")
}
func (UnimplementedGroupServiceServer) AddGroupMembers(context.Context, *AddGroupMembersRequest) (*AddGroupMembersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddGroupMembers not implemented")
}
func (UnimplementedGroupServiceServer) SetGroupMembers(context.Context, *SetGroupMembersRequest) (*SetGroupMembersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetGroupMembers not implemented")
}
func (UnimplementedGroupServiceServer) RemoveGroupMembers(context.Context, *RemoveGroupMembersRequest) (*RemoveGroupMembersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveGroupMembers not implemented")
}
func (UnimplementedGroupServiceServer) mustEmbedUnimplementedGroupServiceServer() {}

// UnsafeGroupServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to GroupServiceServer will
// result in compilation errors.
type UnsafeGroupServiceServer interface {
	mustEmbedUnimplementedGroupServiceServer()
}

func RegisterGroupServiceServer(s grpc.ServiceRegistrar, srv GroupServiceServer) {
	s.RegisterService(&GroupService_ServiceDesc, srv)
}

func _GroupService_GetGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServiceServer).GetGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GroupService_GetGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServiceServer).GetGroup(ctx, req.(*GetGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GroupService_ListGroups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServiceServer).ListGroups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GroupService_ListGroups_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServiceServer).ListGroups(ctx, req.(*ListGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GroupService_CreateGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServiceServer).CreateGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GroupService_CreateGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServiceServer).CreateGroup(ctx, req.(*CreateGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GroupService_UpdateGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServiceServer).UpdateGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GroupService_UpdateGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServiceServer).UpdateGroup(ctx, req.(*UpdateGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GroupService_DeleteGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServiceServer).DeleteGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GroupService_DeleteGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServiceServer).DeleteGroup(ctx, req.(*DeleteGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GroupService_AddGroupMembers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddGroupMembersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServiceServer).AddGroupMembers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GroupService_AddGroupMembers_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServiceServer).AddGroupMembers(ctx, req.(*AddGroupMembersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GroupService_SetGroupMembers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetGroupMembersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServiceServer).SetGroupMembers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GroupService_SetGroupMembers_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServiceServer).SetGroupMembers(ctx, req.(*SetGroupMembersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GroupService_RemoveGroupMembers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveGroupMembersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GroupServiceServer).RemoveGroupMembers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GroupService_RemoveGroupMembers_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GroupServiceServer).RemoveGroupMembers(ctx, req.(*RemoveGroupMembersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// GroupService_ServiceDesc is the grpc.ServiceDesc for GroupService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var GroupService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "controller.api.services.v1.GroupService",
	HandlerType: (*GroupServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetGroup",
			Handler:    _GroupService_GetGroup_Handler,
		},
		{
			MethodName: "ListGroups",
			Handler:    _GroupService_ListGroups_Handler,
		},
		{
			MethodName: "CreateGroup",
			Handler:    _GroupService_CreateGroup_Handler,
		},
		{
			MethodName: "UpdateGroup",
			Handler:    _GroupService_UpdateGroup_Handler,
		},
		{
			MethodName: "DeleteGroup",
			Handler:    _GroupService_DeleteGroup_Handler,
		},
		{
			MethodName: "AddGroupMembers",
			Handler:    _GroupService_AddGroupMembers_Handler,
		},
		{
			MethodName: "SetGroupMembers",
			Handler:    _GroupService_SetGroupMembers_Handler,
		},
		{
			MethodName: "RemoveGroupMembers",
			Handler:    _GroupService_RemoveGroupMembers_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "controller/api/services/v1/group_service.proto",
}
