// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             (unknown)
// source: controller/api/services/v1/credential_store_service.proto

package services

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	CredentialStoreService_GetCredentialStore_FullMethodName    = "/controller.api.services.v1.CredentialStoreService/GetCredentialStore"
	CredentialStoreService_ListCredentialStores_FullMethodName  = "/controller.api.services.v1.CredentialStoreService/ListCredentialStores"
	CredentialStoreService_CreateCredentialStore_FullMethodName = "/controller.api.services.v1.CredentialStoreService/CreateCredentialStore"
	CredentialStoreService_UpdateCredentialStore_FullMethodName = "/controller.api.services.v1.CredentialStoreService/UpdateCredentialStore"
	CredentialStoreService_DeleteCredentialStore_FullMethodName = "/controller.api.services.v1.CredentialStoreService/DeleteCredentialStore"
)

// CredentialStoreServiceClient is the client API for CredentialStoreService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type CredentialStoreServiceClient interface {
	// GetCredentialStore returns a stored Credential Store if present.  The provided request
	// must include the Credential Store id. If missing, malformed or referencing a
	// non existing resource an error is returned.
	GetCredentialStore(ctx context.Context, in *GetCredentialStoreRequest, opts ...grpc.CallOption) (*GetCredentialStoreResponse, error)
	// ListCredentialStores returns a list of stored Credential Stores which are in the
	// provided scope. The request must include the scope id and if missing,
	// malformed, or referencing a non existing scope, an error is returned.
	ListCredentialStores(ctx context.Context, in *ListCredentialStoresRequest, opts ...grpc.CallOption) (*ListCredentialStoresResponse, error)
	// CreateCredentialStore creates and stores an Credential Store in boundary.  The
	// provided request must include the scope in which the Credential Store will be
	// created. If the scope id is missing, malformed or referencing a
	// non existing resource an error is returned.  If a name is provided that is
	// in use in another Credential Store in the same scope, an error is returned.
	CreateCredentialStore(ctx context.Context, in *CreateCredentialStoreRequest, opts ...grpc.CallOption) (*CreateCredentialStoreResponse, error)
	// UpdateCredentialStore updates an existing Credential Store in boundary.  The provided
	// Credential Store must not have any read only fields set.  The update mask must be
	// included in the request and contain at least 1 mutable field.  To unset
	// a field's value, include the field in the update mask and don't set it
	// in the provided user. An error is returned if the Credential Store id is missing
	// or reference a non existing resource.  An error is also returned if the
	// request attempts to update the name to one that is already in use by
	// another Credential Store in the parent scope.
	UpdateCredentialStore(ctx context.Context, in *UpdateCredentialStoreRequest, opts ...grpc.CallOption) (*UpdateCredentialStoreResponse, error)
	// DeleteCredentialStore removes a Credential Store from Boundary. If the Credential Store id
	// is malformed or not provided an error is returned.
	DeleteCredentialStore(ctx context.Context, in *DeleteCredentialStoreRequest, opts ...grpc.CallOption) (*DeleteCredentialStoreResponse, error)
}

type credentialStoreServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewCredentialStoreServiceClient(cc grpc.ClientConnInterface) CredentialStoreServiceClient {
	return &credentialStoreServiceClient{cc}
}

func (c *credentialStoreServiceClient) GetCredentialStore(ctx context.Context, in *GetCredentialStoreRequest, opts ...grpc.CallOption) (*GetCredentialStoreResponse, error) {
	out := new(GetCredentialStoreResponse)
	err := c.cc.Invoke(ctx, CredentialStoreService_GetCredentialStore_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *credentialStoreServiceClient) ListCredentialStores(ctx context.Context, in *ListCredentialStoresRequest, opts ...grpc.CallOption) (*ListCredentialStoresResponse, error) {
	out := new(ListCredentialStoresResponse)
	err := c.cc.Invoke(ctx, CredentialStoreService_ListCredentialStores_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *credentialStoreServiceClient) CreateCredentialStore(ctx context.Context, in *CreateCredentialStoreRequest, opts ...grpc.CallOption) (*CreateCredentialStoreResponse, error) {
	out := new(CreateCredentialStoreResponse)
	err := c.cc.Invoke(ctx, CredentialStoreService_CreateCredentialStore_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *credentialStoreServiceClient) UpdateCredentialStore(ctx context.Context, in *UpdateCredentialStoreRequest, opts ...grpc.CallOption) (*UpdateCredentialStoreResponse, error) {
	out := new(UpdateCredentialStoreResponse)
	err := c.cc.Invoke(ctx, CredentialStoreService_UpdateCredentialStore_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *credentialStoreServiceClient) DeleteCredentialStore(ctx context.Context, in *DeleteCredentialStoreRequest, opts ...grpc.CallOption) (*DeleteCredentialStoreResponse, error) {
	out := new(DeleteCredentialStoreResponse)
	err := c.cc.Invoke(ctx, CredentialStoreService_DeleteCredentialStore_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CredentialStoreServiceServer is the server API for CredentialStoreService service.
// All implementations must embed UnimplementedCredentialStoreServiceServer
// for forward compatibility
type CredentialStoreServiceServer interface {
	// GetCredentialStore returns a stored Credential Store if present.  The provided request
	// must include the Credential Store id. If missing, malformed or referencing a
	// non existing resource an error is returned.
	GetCredentialStore(context.Context, *GetCredentialStoreRequest) (*GetCredentialStoreResponse, error)
	// ListCredentialStores returns a list of stored Credential Stores which are in the
	// provided scope. The request must include the scope id and if missing,
	// malformed, or referencing a non existing scope, an error is returned.
	ListCredentialStores(context.Context, *ListCredentialStoresRequest) (*ListCredentialStoresResponse, error)
	// CreateCredentialStore creates and stores an Credential Store in boundary.  The
	// provided request must include the scope in which the Credential Store will be
	// created. If the scope id is missing, malformed or referencing a
	// non existing resource an error is returned.  If a name is provided that is
	// in use in another Credential Store in the same scope, an error is returned.
	CreateCredentialStore(context.Context, *CreateCredentialStoreRequest) (*CreateCredentialStoreResponse, error)
	// UpdateCredentialStore updates an existing Credential Store in boundary.  The provided
	// Credential Store must not have any read only fields set.  The update mask must be
	// included in the request and contain at least 1 mutable field.  To unset
	// a field's value, include the field in the update mask and don't set it
	// in the provided user. An error is returned if the Credential Store id is missing
	// or reference a non existing resource.  An error is also returned if the
	// request attempts to update the name to one that is already in use by
	// another Credential Store in the parent scope.
	UpdateCredentialStore(context.Context, *UpdateCredentialStoreRequest) (*UpdateCredentialStoreResponse, error)
	// DeleteCredentialStore removes a Credential Store from Boundary. If the Credential Store id
	// is malformed or not provided an error is returned.
	DeleteCredentialStore(context.Context, *DeleteCredentialStoreRequest) (*DeleteCredentialStoreResponse, error)
	mustEmbedUnimplementedCredentialStoreServiceServer()
}

// UnimplementedCredentialStoreServiceServer must be embedded to have forward compatible implementations.
type UnimplementedCredentialStoreServiceServer struct {
}

func (UnimplementedCredentialStoreServiceServer) GetCredentialStore(context.Context, *GetCredentialStoreRequest) (*GetCredentialStoreResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCredentialStore not implemented")
}
func (UnimplementedCredentialStoreServiceServer) ListCredentialStores(context.Context, *ListCredentialStoresRequest) (*ListCredentialStoresResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCredentialStores not implemented")
}
func (UnimplementedCredentialStoreServiceServer) CreateCredentialStore(context.Context, *CreateCredentialStoreRequest) (*CreateCredentialStoreResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCredentialStore not implemented")
}
func (UnimplementedCredentialStoreServiceServer) UpdateCredentialStore(context.Context, *UpdateCredentialStoreRequest) (*UpdateCredentialStoreResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCredentialStore not implemented")
}
func (UnimplementedCredentialStoreServiceServer) DeleteCredentialStore(context.Context, *DeleteCredentialStoreRequest) (*DeleteCredentialStoreResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCredentialStore not implemented")
}
func (UnimplementedCredentialStoreServiceServer) mustEmbedUnimplementedCredentialStoreServiceServer() {
}

// UnsafeCredentialStoreServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to CredentialStoreServiceServer will
// result in compilation errors.
type UnsafeCredentialStoreServiceServer interface {
	mustEmbedUnimplementedCredentialStoreServiceServer()
}

func RegisterCredentialStoreServiceServer(s grpc.ServiceRegistrar, srv CredentialStoreServiceServer) {
	s.RegisterService(&CredentialStoreService_ServiceDesc, srv)
}

func _CredentialStoreService_GetCredentialStore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCredentialStoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CredentialStoreServiceServer).GetCredentialStore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CredentialStoreService_GetCredentialStore_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CredentialStoreServiceServer).GetCredentialStore(ctx, req.(*GetCredentialStoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CredentialStoreService_ListCredentialStores_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCredentialStoresRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CredentialStoreServiceServer).ListCredentialStores(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CredentialStoreService_ListCredentialStores_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CredentialStoreServiceServer).ListCredentialStores(ctx, req.(*ListCredentialStoresRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CredentialStoreService_CreateCredentialStore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCredentialStoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CredentialStoreServiceServer).CreateCredentialStore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CredentialStoreService_CreateCredentialStore_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CredentialStoreServiceServer).CreateCredentialStore(ctx, req.(*CreateCredentialStoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CredentialStoreService_UpdateCredentialStore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCredentialStoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CredentialStoreServiceServer).UpdateCredentialStore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CredentialStoreService_UpdateCredentialStore_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CredentialStoreServiceServer).UpdateCredentialStore(ctx, req.(*UpdateCredentialStoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CredentialStoreService_DeleteCredentialStore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCredentialStoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CredentialStoreServiceServer).DeleteCredentialStore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CredentialStoreService_DeleteCredentialStore_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CredentialStoreServiceServer).DeleteCredentialStore(ctx, req.(*DeleteCredentialStoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// CredentialStoreService_ServiceDesc is the grpc.ServiceDesc for CredentialStoreService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var CredentialStoreService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "controller.api.services.v1.CredentialStoreService",
	HandlerType: (*CredentialStoreServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetCredentialStore",
			Handler:    _CredentialStoreService_GetCredentialStore_Handler,
		},
		{
			MethodName: "ListCredentialStores",
			Handler:    _CredentialStoreService_ListCredentialStores_Handler,
		},
		{
			MethodName: "CreateCredentialStore",
			Handler:    _CredentialStoreService_CreateCredentialStore_Handler,
		},
		{
			MethodName: "UpdateCredentialStore",
			Handler:    _CredentialStoreService_UpdateCredentialStore_Handler,
		},
		{
			MethodName: "DeleteCredentialStore",
			Handler:    _CredentialStoreService_DeleteCredentialStore_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "controller/api/services/v1/credential_store_service.proto",
}
