// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             (unknown)
// source: controller/api/services/v1/credential_service.proto

package services

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	CredentialService_GetCredential_FullMethodName    = "/controller.api.services.v1.CredentialService/GetCredential"
	CredentialService_ListCredentials_FullMethodName  = "/controller.api.services.v1.CredentialService/ListCredentials"
	CredentialService_CreateCredential_FullMethodName = "/controller.api.services.v1.CredentialService/CreateCredential"
	CredentialService_UpdateCredential_FullMethodName = "/controller.api.services.v1.CredentialService/UpdateCredential"
	CredentialService_DeleteCredential_FullMethodName = "/controller.api.services.v1.CredentialService/DeleteCredential"
)

// CredentialServiceClient is the client API for CredentialService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type CredentialServiceClient interface {
	// GetCredential returns a stored Credential if present.  The provided request
	// must include the Credential Store id. If missing, malformed or referencing a
	// non existing resource an error is returned.
	GetCredential(ctx context.Context, in *GetCredentialRequest, opts ...grpc.CallOption) (*GetCredentialResponse, error)
	// ListCredentials returns a list of stored Credentials which are in the
	// provided store. The request must include the Credential Store id and if missing,
	// malformed, or referencing a non existing scope, an error is returned.
	ListCredentials(ctx context.Context, in *ListCredentialsRequest, opts ...grpc.CallOption) (*ListCredentialsResponse, error)
	// CreateCredential creates and stores an Credential in boundary.  The
	// provided request must include the credential_store_id in which the Credential
	// will be created. If the store id is missing, malformed or referencing a
	// non existing resource an error is returned.  If a name is provided that is
	// in use in another Credential in the same store, an error is returned.
	CreateCredential(ctx context.Context, in *CreateCredentialRequest, opts ...grpc.CallOption) (*CreateCredentialResponse, error)
	// UpdateCredential updates an existing Credential in boundary.  The provided
	// Credential must not have any read only fields set.  The update mask must be
	// included in the request and contain at least 1 mutable field.  To unset
	// a field's value, include the field in the update mask and don't set it
	// in the provided user. An error is returned if the Credential id is missing
	// or reference a non existing resource.  An error is also returned if the
	// request attempts to update the name to one that is already in use by
	// another Credential in the parent scope.
	UpdateCredential(ctx context.Context, in *UpdateCredentialRequest, opts ...grpc.CallOption) (*UpdateCredentialResponse, error)
	// DeleteCredential removes an Credential from Boundary. If the Credential id
	// is malformed or not provided an error is returned.
	DeleteCredential(ctx context.Context, in *DeleteCredentialRequest, opts ...grpc.CallOption) (*DeleteCredentialResponse, error)
}

type credentialServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewCredentialServiceClient(cc grpc.ClientConnInterface) CredentialServiceClient {
	return &credentialServiceClient{cc}
}

func (c *credentialServiceClient) GetCredential(ctx context.Context, in *GetCredentialRequest, opts ...grpc.CallOption) (*GetCredentialResponse, error) {
	out := new(GetCredentialResponse)
	err := c.cc.Invoke(ctx, CredentialService_GetCredential_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *credentialServiceClient) ListCredentials(ctx context.Context, in *ListCredentialsRequest, opts ...grpc.CallOption) (*ListCredentialsResponse, error) {
	out := new(ListCredentialsResponse)
	err := c.cc.Invoke(ctx, CredentialService_ListCredentials_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *credentialServiceClient) CreateCredential(ctx context.Context, in *CreateCredentialRequest, opts ...grpc.CallOption) (*CreateCredentialResponse, error) {
	out := new(CreateCredentialResponse)
	err := c.cc.Invoke(ctx, CredentialService_CreateCredential_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *credentialServiceClient) UpdateCredential(ctx context.Context, in *UpdateCredentialRequest, opts ...grpc.CallOption) (*UpdateCredentialResponse, error) {
	out := new(UpdateCredentialResponse)
	err := c.cc.Invoke(ctx, CredentialService_UpdateCredential_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *credentialServiceClient) DeleteCredential(ctx context.Context, in *DeleteCredentialRequest, opts ...grpc.CallOption) (*DeleteCredentialResponse, error) {
	out := new(DeleteCredentialResponse)
	err := c.cc.Invoke(ctx, CredentialService_DeleteCredential_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CredentialServiceServer is the server API for CredentialService service.
// All implementations must embed UnimplementedCredentialServiceServer
// for forward compatibility
type CredentialServiceServer interface {
	// GetCredential returns a stored Credential if present.  The provided request
	// must include the Credential Store id. If missing, malformed or referencing a
	// non existing resource an error is returned.
	GetCredential(context.Context, *GetCredentialRequest) (*GetCredentialResponse, error)
	// ListCredentials returns a list of stored Credentials which are in the
	// provided store. The request must include the Credential Store id and if missing,
	// malformed, or referencing a non existing scope, an error is returned.
	ListCredentials(context.Context, *ListCredentialsRequest) (*ListCredentialsResponse, error)
	// CreateCredential creates and stores an Credential in boundary.  The
	// provided request must include the credential_store_id in which the Credential
	// will be created. If the store id is missing, malformed or referencing a
	// non existing resource an error is returned.  If a name is provided that is
	// in use in another Credential in the same store, an error is returned.
	CreateCredential(context.Context, *CreateCredentialRequest) (*CreateCredentialResponse, error)
	// UpdateCredential updates an existing Credential in boundary.  The provided
	// Credential must not have any read only fields set.  The update mask must be
	// included in the request and contain at least 1 mutable field.  To unset
	// a field's value, include the field in the update mask and don't set it
	// in the provided user. An error is returned if the Credential id is missing
	// or reference a non existing resource.  An error is also returned if the
	// request attempts to update the name to one that is already in use by
	// another Credential in the parent scope.
	UpdateCredential(context.Context, *UpdateCredentialRequest) (*UpdateCredentialResponse, error)
	// DeleteCredential removes an Credential from Boundary. If the Credential id
	// is malformed or not provided an error is returned.
	DeleteCredential(context.Context, *DeleteCredentialRequest) (*DeleteCredentialResponse, error)
	mustEmbedUnimplementedCredentialServiceServer()
}

// UnimplementedCredentialServiceServer must be embedded to have forward compatible implementations.
type UnimplementedCredentialServiceServer struct {
}

func (UnimplementedCredentialServiceServer) GetCredential(context.Context, *GetCredentialRequest) (*GetCredentialResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCredential not implemented")
}
func (UnimplementedCredentialServiceServer) ListCredentials(context.Context, *ListCredentialsRequest) (*ListCredentialsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCredentials not implemented")
}
func (UnimplementedCredentialServiceServer) CreateCredential(context.Context, *CreateCredentialRequest) (*CreateCredentialResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCredential not implemented")
}
func (UnimplementedCredentialServiceServer) UpdateCredential(context.Context, *UpdateCredentialRequest) (*UpdateCredentialResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCredential not implemented")
}
func (UnimplementedCredentialServiceServer) DeleteCredential(context.Context, *DeleteCredentialRequest) (*DeleteCredentialResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCredential not implemented")
}
func (UnimplementedCredentialServiceServer) mustEmbedUnimplementedCredentialServiceServer() {}

// UnsafeCredentialServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to CredentialServiceServer will
// result in compilation errors.
type UnsafeCredentialServiceServer interface {
	mustEmbedUnimplementedCredentialServiceServer()
}

func RegisterCredentialServiceServer(s grpc.ServiceRegistrar, srv CredentialServiceServer) {
	s.RegisterService(&CredentialService_ServiceDesc, srv)
}

func _CredentialService_GetCredential_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCredentialRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CredentialServiceServer).GetCredential(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CredentialService_GetCredential_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CredentialServiceServer).GetCredential(ctx, req.(*GetCredentialRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CredentialService_ListCredentials_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCredentialsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CredentialServiceServer).ListCredentials(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CredentialService_ListCredentials_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CredentialServiceServer).ListCredentials(ctx, req.(*ListCredentialsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CredentialService_CreateCredential_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCredentialRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CredentialServiceServer).CreateCredential(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CredentialService_CreateCredential_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CredentialServiceServer).CreateCredential(ctx, req.(*CreateCredentialRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CredentialService_UpdateCredential_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCredentialRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CredentialServiceServer).UpdateCredential(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CredentialService_UpdateCredential_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CredentialServiceServer).UpdateCredential(ctx, req.(*UpdateCredentialRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CredentialService_DeleteCredential_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCredentialRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CredentialServiceServer).DeleteCredential(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CredentialService_DeleteCredential_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CredentialServiceServer).DeleteCredential(ctx, req.(*DeleteCredentialRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// CredentialService_ServiceDesc is the grpc.ServiceDesc for CredentialService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var CredentialService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "controller.api.services.v1.CredentialService",
	HandlerType: (*CredentialServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetCredential",
			Handler:    _CredentialService_GetCredential_Handler,
		},
		{
			MethodName: "ListCredentials",
			Handler:    _CredentialService_ListCredentials_Handler,
		},
		{
			MethodName: "CreateCredential",
			Handler:    _CredentialService_CreateCredential_Handler,
		},
		{
			MethodName: "UpdateCredential",
			Handler:    _CredentialService_UpdateCredential_Handler,
		},
		{
			MethodName: "DeleteCredential",
			Handler:    _CredentialService_DeleteCredential_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "controller/api/services/v1/credential_service.proto",
}
