// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             (unknown)
// source: controller/api/services/v1/credential_library_service.proto

package services

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	CredentialLibraryService_GetCredentialLibrary_FullMethodName    = "/controller.api.services.v1.CredentialLibraryService/GetCredentialLibrary"
	CredentialLibraryService_ListCredentialLibraries_FullMethodName = "/controller.api.services.v1.CredentialLibraryService/ListCredentialLibraries"
	CredentialLibraryService_CreateCredentialLibrary_FullMethodName = "/controller.api.services.v1.CredentialLibraryService/CreateCredentialLibrary"
	CredentialLibraryService_UpdateCredentialLibrary_FullMethodName = "/controller.api.services.v1.CredentialLibraryService/UpdateCredentialLibrary"
	CredentialLibraryService_DeleteCredentialLibrary_FullMethodName = "/controller.api.services.v1.CredentialLibraryService/DeleteCredentialLibrary"
)

// CredentialLibraryServiceClient is the client API for CredentialLibraryService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type CredentialLibraryServiceClient interface {
	// GetCredentialLibrary returns a stored Credential Library if present.  The provided request
	// must include the Credential Store id. If missing, malformed or referencing a
	// non existing resource an error is returned.
	GetCredentialLibrary(ctx context.Context, in *GetCredentialLibraryRequest, opts ...grpc.CallOption) (*GetCredentialLibraryResponse, error)
	// ListCredentialLibraries returns a list of stored Credential Libraries which are in the
	// provided scope. The request must include the Credential Store id and if missing,
	// malformed, or referencing a non existing scope, an error is returned.
	ListCredentialLibraries(ctx context.Context, in *ListCredentialLibrariesRequest, opts ...grpc.CallOption) (*ListCredentialLibrariesResponse, error)
	// CreateCredentialLibrary creates and stores an Credential Library in boundary.  The
	// provided request must include the scope in which the Credential Library will be
	// created. If the scope id is missing, malformed or referencing a
	// non existing resource an error is returned.  If a name is provided that is
	// in use in another Credential Library in the same scope, an error is returned.
	CreateCredentialLibrary(ctx context.Context, in *CreateCredentialLibraryRequest, opts ...grpc.CallOption) (*CreateCredentialLibraryResponse, error)
	// UpdateCredentialLibrary updates an existing Credential Library in boundary.  The provided
	// Credential Library must not have any read only fields set.  The update mask must be
	// included in the request and contain at least 1 mutable field.  To unset
	// a field's value, include the field in the update mask and don't set it
	// in the provided user. An error is returned if the Credential Library id is missing
	// or reference a non existing resource.  An error is also returned if the
	// request attempts to update the name to one that is already in use by
	// another Credential Library in the parent scope.
	UpdateCredentialLibrary(ctx context.Context, in *UpdateCredentialLibraryRequest, opts ...grpc.CallOption) (*UpdateCredentialLibraryResponse, error)
	// DeleteCredentialLibrary removes an Credential Library from Boundary. If the Credential Library id
	// is malformed or not provided an error is returned.
	DeleteCredentialLibrary(ctx context.Context, in *DeleteCredentialLibraryRequest, opts ...grpc.CallOption) (*DeleteCredentialLibraryResponse, error)
}

type credentialLibraryServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewCredentialLibraryServiceClient(cc grpc.ClientConnInterface) CredentialLibraryServiceClient {
	return &credentialLibraryServiceClient{cc}
}

func (c *credentialLibraryServiceClient) GetCredentialLibrary(ctx context.Context, in *GetCredentialLibraryRequest, opts ...grpc.CallOption) (*GetCredentialLibraryResponse, error) {
	out := new(GetCredentialLibraryResponse)
	err := c.cc.Invoke(ctx, CredentialLibraryService_GetCredentialLibrary_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *credentialLibraryServiceClient) ListCredentialLibraries(ctx context.Context, in *ListCredentialLibrariesRequest, opts ...grpc.CallOption) (*ListCredentialLibrariesResponse, error) {
	out := new(ListCredentialLibrariesResponse)
	err := c.cc.Invoke(ctx, CredentialLibraryService_ListCredentialLibraries_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *credentialLibraryServiceClient) CreateCredentialLibrary(ctx context.Context, in *CreateCredentialLibraryRequest, opts ...grpc.CallOption) (*CreateCredentialLibraryResponse, error) {
	out := new(CreateCredentialLibraryResponse)
	err := c.cc.Invoke(ctx, CredentialLibraryService_CreateCredentialLibrary_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *credentialLibraryServiceClient) UpdateCredentialLibrary(ctx context.Context, in *UpdateCredentialLibraryRequest, opts ...grpc.CallOption) (*UpdateCredentialLibraryResponse, error) {
	out := new(UpdateCredentialLibraryResponse)
	err := c.cc.Invoke(ctx, CredentialLibraryService_UpdateCredentialLibrary_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *credentialLibraryServiceClient) DeleteCredentialLibrary(ctx context.Context, in *DeleteCredentialLibraryRequest, opts ...grpc.CallOption) (*DeleteCredentialLibraryResponse, error) {
	out := new(DeleteCredentialLibraryResponse)
	err := c.cc.Invoke(ctx, CredentialLibraryService_DeleteCredentialLibrary_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CredentialLibraryServiceServer is the server API for CredentialLibraryService service.
// All implementations must embed UnimplementedCredentialLibraryServiceServer
// for forward compatibility
type CredentialLibraryServiceServer interface {
	// GetCredentialLibrary returns a stored Credential Library if present.  The provided request
	// must include the Credential Store id. If missing, malformed or referencing a
	// non existing resource an error is returned.
	GetCredentialLibrary(context.Context, *GetCredentialLibraryRequest) (*GetCredentialLibraryResponse, error)
	// ListCredentialLibraries returns a list of stored Credential Libraries which are in the
	// provided scope. The request must include the Credential Store id and if missing,
	// malformed, or referencing a non existing scope, an error is returned.
	ListCredentialLibraries(context.Context, *ListCredentialLibrariesRequest) (*ListCredentialLibrariesResponse, error)
	// CreateCredentialLibrary creates and stores an Credential Library in boundary.  The
	// provided request must include the scope in which the Credential Library will be
	// created. If the scope id is missing, malformed or referencing a
	// non existing resource an error is returned.  If a name is provided that is
	// in use in another Credential Library in the same scope, an error is returned.
	CreateCredentialLibrary(context.Context, *CreateCredentialLibraryRequest) (*CreateCredentialLibraryResponse, error)
	// UpdateCredentialLibrary updates an existing Credential Library in boundary.  The provided
	// Credential Library must not have any read only fields set.  The update mask must be
	// included in the request and contain at least 1 mutable field.  To unset
	// a field's value, include the field in the update mask and don't set it
	// in the provided user. An error is returned if the Credential Library id is missing
	// or reference a non existing resource.  An error is also returned if the
	// request attempts to update the name to one that is already in use by
	// another Credential Library in the parent scope.
	UpdateCredentialLibrary(context.Context, *UpdateCredentialLibraryRequest) (*UpdateCredentialLibraryResponse, error)
	// DeleteCredentialLibrary removes an Credential Library from Boundary. If the Credential Library id
	// is malformed or not provided an error is returned.
	DeleteCredentialLibrary(context.Context, *DeleteCredentialLibraryRequest) (*DeleteCredentialLibraryResponse, error)
	mustEmbedUnimplementedCredentialLibraryServiceServer()
}

// UnimplementedCredentialLibraryServiceServer must be embedded to have forward compatible implementations.
type UnimplementedCredentialLibraryServiceServer struct {
}

func (UnimplementedCredentialLibraryServiceServer) GetCredentialLibrary(context.Context, *GetCredentialLibraryRequest) (*GetCredentialLibraryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCredentialLibrary not implemented")
}
func (UnimplementedCredentialLibraryServiceServer) ListCredentialLibraries(context.Context, *ListCredentialLibrariesRequest) (*ListCredentialLibrariesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCredentialLibraries not implemented")
}
func (UnimplementedCredentialLibraryServiceServer) CreateCredentialLibrary(context.Context, *CreateCredentialLibraryRequest) (*CreateCredentialLibraryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCredentialLibrary not implemented")
}
func (UnimplementedCredentialLibraryServiceServer) UpdateCredentialLibrary(context.Context, *UpdateCredentialLibraryRequest) (*UpdateCredentialLibraryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCredentialLibrary not implemented")
}
func (UnimplementedCredentialLibraryServiceServer) DeleteCredentialLibrary(context.Context, *DeleteCredentialLibraryRequest) (*DeleteCredentialLibraryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCredentialLibrary not implemented")
}
func (UnimplementedCredentialLibraryServiceServer) mustEmbedUnimplementedCredentialLibraryServiceServer() {
}

// UnsafeCredentialLibraryServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to CredentialLibraryServiceServer will
// result in compilation errors.
type UnsafeCredentialLibraryServiceServer interface {
	mustEmbedUnimplementedCredentialLibraryServiceServer()
}

func RegisterCredentialLibraryServiceServer(s grpc.ServiceRegistrar, srv CredentialLibraryServiceServer) {
	s.RegisterService(&CredentialLibraryService_ServiceDesc, srv)
}

func _CredentialLibraryService_GetCredentialLibrary_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCredentialLibraryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CredentialLibraryServiceServer).GetCredentialLibrary(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CredentialLibraryService_GetCredentialLibrary_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CredentialLibraryServiceServer).GetCredentialLibrary(ctx, req.(*GetCredentialLibraryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CredentialLibraryService_ListCredentialLibraries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCredentialLibrariesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CredentialLibraryServiceServer).ListCredentialLibraries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CredentialLibraryService_ListCredentialLibraries_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CredentialLibraryServiceServer).ListCredentialLibraries(ctx, req.(*ListCredentialLibrariesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CredentialLibraryService_CreateCredentialLibrary_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCredentialLibraryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CredentialLibraryServiceServer).CreateCredentialLibrary(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CredentialLibraryService_CreateCredentialLibrary_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CredentialLibraryServiceServer).CreateCredentialLibrary(ctx, req.(*CreateCredentialLibraryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CredentialLibraryService_UpdateCredentialLibrary_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCredentialLibraryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CredentialLibraryServiceServer).UpdateCredentialLibrary(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CredentialLibraryService_UpdateCredentialLibrary_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CredentialLibraryServiceServer).UpdateCredentialLibrary(ctx, req.(*UpdateCredentialLibraryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CredentialLibraryService_DeleteCredentialLibrary_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCredentialLibraryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CredentialLibraryServiceServer).DeleteCredentialLibrary(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CredentialLibraryService_DeleteCredentialLibrary_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CredentialLibraryServiceServer).DeleteCredentialLibrary(ctx, req.(*DeleteCredentialLibraryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// CredentialLibraryService_ServiceDesc is the grpc.ServiceDesc for CredentialLibraryService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var CredentialLibraryService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "controller.api.services.v1.CredentialLibraryService",
	HandlerType: (*CredentialLibraryServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetCredentialLibrary",
			Handler:    _CredentialLibraryService_GetCredentialLibrary_Handler,
		},
		{
			MethodName: "ListCredentialLibraries",
			Handler:    _CredentialLibraryService_ListCredentialLibraries_Handler,
		},
		{
			MethodName: "CreateCredentialLibrary",
			Handler:    _CredentialLibraryService_CreateCredentialLibrary_Handler,
		},
		{
			MethodName: "UpdateCredentialLibrary",
			Handler:    _CredentialLibraryService_UpdateCredentialLibrary_Handler,
		},
		{
			MethodName: "DeleteCredentialLibrary",
			Handler:    _CredentialLibraryService_DeleteCredentialLibrary_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "controller/api/services/v1/credential_library_service.proto",
}
