// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             (unknown)
// source: controller/api/services/v1/authtokens_service.proto

package services

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	AuthTokenService_GetAuthToken_FullMethodName    = "/controller.api.services.v1.AuthTokenService/GetAuthToken"
	AuthTokenService_ListAuthTokens_FullMethodName  = "/controller.api.services.v1.AuthTokenService/ListAuthTokens"
	AuthTokenService_DeleteAuthToken_FullMethodName = "/controller.api.services.v1.AuthTokenService/DeleteAuthToken"
)

// AuthTokenServiceClient is the client API for AuthTokenService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type AuthTokenServiceClient interface {
	// GetAuthToken returns a stored Auth Token if present.  The provided request
	// must include the Auth Token id and if it is missing, malformed or
	// referencing a non existing resource an error is returned.
	GetAuthToken(ctx context.Context, in *GetAuthTokenRequest, opts ...grpc.CallOption) (*GetAuthTokenResponse, error)
	// ListAuthTokens returns a list of stored Auth Tokens which exist inside
	// the provided scope.  The request must include the scope ids for
	// the Auth Tokens being listed.  If the scope id is missing, malformed, or
	// referencing a non existing resource, an error is returned.
	ListAuthTokens(ctx context.Context, in *ListAuthTokensRequest, opts ...grpc.CallOption) (*ListAuthTokensResponse, error)
	// DeleteAuthToken removes a Auth Token from Boundary. If the provided
	// Auth Token id is malformed or not provided an error is returned.
	DeleteAuthToken(ctx context.Context, in *DeleteAuthTokenRequest, opts ...grpc.CallOption) (*DeleteAuthTokenResponse, error)
}

type authTokenServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAuthTokenServiceClient(cc grpc.ClientConnInterface) AuthTokenServiceClient {
	return &authTokenServiceClient{cc}
}

func (c *authTokenServiceClient) GetAuthToken(ctx context.Context, in *GetAuthTokenRequest, opts ...grpc.CallOption) (*GetAuthTokenResponse, error) {
	out := new(GetAuthTokenResponse)
	err := c.cc.Invoke(ctx, AuthTokenService_GetAuthToken_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *authTokenServiceClient) ListAuthTokens(ctx context.Context, in *ListAuthTokensRequest, opts ...grpc.CallOption) (*ListAuthTokensResponse, error) {
	out := new(ListAuthTokensResponse)
	err := c.cc.Invoke(ctx, AuthTokenService_ListAuthTokens_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *authTokenServiceClient) DeleteAuthToken(ctx context.Context, in *DeleteAuthTokenRequest, opts ...grpc.CallOption) (*DeleteAuthTokenResponse, error) {
	out := new(DeleteAuthTokenResponse)
	err := c.cc.Invoke(ctx, AuthTokenService_DeleteAuthToken_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AuthTokenServiceServer is the server API for AuthTokenService service.
// All implementations must embed UnimplementedAuthTokenServiceServer
// for forward compatibility
type AuthTokenServiceServer interface {
	// GetAuthToken returns a stored Auth Token if present.  The provided request
	// must include the Auth Token id and if it is missing, malformed or
	// referencing a non existing resource an error is returned.
	GetAuthToken(context.Context, *GetAuthTokenRequest) (*GetAuthTokenResponse, error)
	// ListAuthTokens returns a list of stored Auth Tokens which exist inside
	// the provided scope.  The request must include the scope ids for
	// the Auth Tokens being listed.  If the scope id is missing, malformed, or
	// referencing a non existing resource, an error is returned.
	ListAuthTokens(context.Context, *ListAuthTokensRequest) (*ListAuthTokensResponse, error)
	// DeleteAuthToken removes a Auth Token from Boundary. If the provided
	// Auth Token id is malformed or not provided an error is returned.
	DeleteAuthToken(context.Context, *DeleteAuthTokenRequest) (*DeleteAuthTokenResponse, error)
	mustEmbedUnimplementedAuthTokenServiceServer()
}

// UnimplementedAuthTokenServiceServer must be embedded to have forward compatible implementations.
type UnimplementedAuthTokenServiceServer struct {
}

func (UnimplementedAuthTokenServiceServer) GetAuthToken(context.Context, *GetAuthTokenRequest) (*GetAuthTokenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAuthToken not implemented")
}
func (UnimplementedAuthTokenServiceServer) ListAuthTokens(context.Context, *ListAuthTokensRequest) (*ListAuthTokensResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAuthTokens not implemented")
}
func (UnimplementedAuthTokenServiceServer) DeleteAuthToken(context.Context, *DeleteAuthTokenRequest) (*DeleteAuthTokenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAuthToken not implemented")
}
func (UnimplementedAuthTokenServiceServer) mustEmbedUnimplementedAuthTokenServiceServer() {}

// UnsafeAuthTokenServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AuthTokenServiceServer will
// result in compilation errors.
type UnsafeAuthTokenServiceServer interface {
	mustEmbedUnimplementedAuthTokenServiceServer()
}

func RegisterAuthTokenServiceServer(s grpc.ServiceRegistrar, srv AuthTokenServiceServer) {
	s.RegisterService(&AuthTokenService_ServiceDesc, srv)
}

func _AuthTokenService_GetAuthToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAuthTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthTokenServiceServer).GetAuthToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AuthTokenService_GetAuthToken_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthTokenServiceServer).GetAuthToken(ctx, req.(*GetAuthTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuthTokenService_ListAuthTokens_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAuthTokensRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthTokenServiceServer).ListAuthTokens(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AuthTokenService_ListAuthTokens_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthTokenServiceServer).ListAuthTokens(ctx, req.(*ListAuthTokensRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuthTokenService_DeleteAuthToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAuthTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthTokenServiceServer).DeleteAuthToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AuthTokenService_DeleteAuthToken_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthTokenServiceServer).DeleteAuthToken(ctx, req.(*DeleteAuthTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// AuthTokenService_ServiceDesc is the grpc.ServiceDesc for AuthTokenService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var AuthTokenService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "controller.api.services.v1.AuthTokenService",
	HandlerType: (*AuthTokenServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAuthToken",
			Handler:    _AuthTokenService_GetAuthToken_Handler,
		},
		{
			MethodName: "ListAuthTokens",
			Handler:    _AuthTokenService_ListAuthTokens_Handler,
		},
		{
			MethodName: "DeleteAuthToken",
			Handler:    _AuthTokenService_DeleteAuthToken_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "controller/api/services/v1/authtokens_service.proto",
}
