// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        (unknown)
// source: controller/api/services/v1/auth_method_service.proto

package services

import (
	_ "github.com/grpc-ecosystem/grpc-gateway/v2/protoc-gen-openapiv2/options"
	authmethods "github.com/hashicorp/boundary/sdk/pbs/controller/api/resources/authmethods"
	authtokens "github.com/hashicorp/boundary/sdk/pbs/controller/api/resources/authtokens"
	_ "github.com/hashicorp/boundary/sdk/pbs/controller/protooptions"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	_ "google.golang.org/genproto/googleapis/api/visibility"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type GetAuthMethodRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the auth method being requested.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty" class:"public" eventstream:"observation"` // @gotags: `class:"public" eventstream:"observation"`
}

func (x *GetAuthMethodRequest) Reset() {
	*x = GetAuthMethodRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_services_v1_auth_method_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAuthMethodRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAuthMethodRequest) ProtoMessage() {}

func (x *GetAuthMethodRequest) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_services_v1_auth_method_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAuthMethodRequest.ProtoReflect.Descriptor instead.
func (*GetAuthMethodRequest) Descriptor() ([]byte, []int) {
	return file_controller_api_services_v1_auth_method_service_proto_rawDescGZIP(), []int{0}
}

func (x *GetAuthMethodRequest) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

type GetAuthMethodResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Item *authmethods.AuthMethod `protobuf:"bytes,1,opt,name=item,proto3" json:"item,omitempty"`
}

func (x *GetAuthMethodResponse) Reset() {
	*x = GetAuthMethodResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_services_v1_auth_method_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAuthMethodResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAuthMethodResponse) ProtoMessage() {}

func (x *GetAuthMethodResponse) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_services_v1_auth_method_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAuthMethodResponse.ProtoReflect.Descriptor instead.
func (*GetAuthMethodResponse) Descriptor() ([]byte, []int) {
	return file_controller_api_services_v1_auth_method_service_proto_rawDescGZIP(), []int{1}
}

func (x *GetAuthMethodResponse) GetItem() *authmethods.AuthMethod {
	if x != nil {
		return x.Item
	}
	return nil
}

type ListAuthMethodsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The scope ID in which to list auth methods.
	ScopeId string `protobuf:"bytes,1,opt,name=scope_id,proto3" json:"scope_id,omitempty" class:"public" eventstream:"observation"` // @gotags: `class:"public" eventstream:"observation"`
	// Whether to recursively list auth methods in the provided scope's child scopes.
	Recursive bool `protobuf:"varint,20,opt,name=recursive,proto3" json:"recursive,omitempty" class:"public" eventstream:"observation"` // @gotags: `class:"public" eventstream:"observation"`
	// You can specify that the filter should only return items that match.
	// Refer to [filter expressions](https://developer.hashicorp.com/boundary/docs/concepts/filtering) for more information.
	Filter string `protobuf:"bytes,30,opt,name=filter,proto3" json:"filter,omitempty" class:"public"` // @gotags: `class:"public"`
	// An opaque token that Boundary uses to continue an existing iteration or
	// request updated items. If you do not specify a token, pagination
	// starts from the beginning. To learn more about list pagination
	// in Boundary, refer to [list pagination](https://developer.hashicorp.com/boundary/docs/api-clients/api/pagination).
	ListToken string `protobuf:"bytes,40,opt,name=list_token,proto3" json:"list_token,omitempty" class:"public"` // @gotags: `class:"public"`
	// The maximum size of a page in this iteration.
	// If you do not set a page size, Boundary uses the configured default page size.
	// If the page_size is greater than the default page size configured,
	// Boundary truncates the page size to this number.
	PageSize uint32 `protobuf:"varint,50,opt,name=page_size,proto3" json:"page_size,omitempty" class:"public"` // @gotags: `class:"public"`
}

func (x *ListAuthMethodsRequest) Reset() {
	*x = ListAuthMethodsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_services_v1_auth_method_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAuthMethodsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAuthMethodsRequest) ProtoMessage() {}

func (x *ListAuthMethodsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_services_v1_auth_method_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAuthMethodsRequest.ProtoReflect.Descriptor instead.
func (*ListAuthMethodsRequest) Descriptor() ([]byte, []int) {
	return file_controller_api_services_v1_auth_method_service_proto_rawDescGZIP(), []int{2}
}

func (x *ListAuthMethodsRequest) GetScopeId() string {
	if x != nil {
		return x.ScopeId
	}
	return ""
}

func (x *ListAuthMethodsRequest) GetRecursive() bool {
	if x != nil {
		return x.Recursive
	}
	return false
}

func (x *ListAuthMethodsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListAuthMethodsRequest) GetListToken() string {
	if x != nil {
		return x.ListToken
	}
	return ""
}

func (x *ListAuthMethodsRequest) GetPageSize() uint32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

type ListAuthMethodsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The items returned in this page.
	Items []*authmethods.AuthMethod `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	// The type of response, either "delta" or "complete".
	// Delta signifies that this is part of a paginated result
	// or an update to a previously completed pagination.
	// Complete signifies that it is the last page.
	ResponseType string `protobuf:"bytes,2,opt,name=response_type,proto3" json:"response_type,omitempty" class:"public"` // @gotags: `class:"public"`
	// An opaque token used to continue an existing pagination or
	// request updated items. Use this token in the next list request
	// to request the next page.
	ListToken string `protobuf:"bytes,3,opt,name=list_token,proto3" json:"list_token,omitempty" class:"public"` // @gotags: `class:"public"`
	// The name of the field which the items are sorted by.
	SortBy string `protobuf:"bytes,4,opt,name=sort_by,proto3" json:"sort_by,omitempty" class:"public"` // @gotags: `class:"public"`
	// The direction of the sort, either "asc" or "desc".
	SortDir string `protobuf:"bytes,5,opt,name=sort_dir,proto3" json:"sort_dir,omitempty" class:"public"` // @gotags: `class:"public"`
	// A list of item IDs that have been removed since they were returned
	// as part of a pagination. They should be dropped from any client cache.
	// This may contain items that are not known to the cache, if they were
	// created and deleted between listings.
	RemovedIds []string `protobuf:"bytes,6,rep,name=removed_ids,proto3" json:"removed_ids,omitempty" class:"public"` // @gotags: `class:"public"`
	// An estimate at the total items available. This may change during pagination.
	EstItemCount uint32 `protobuf:"varint,7,opt,name=est_item_count,proto3" json:"est_item_count,omitempty" class:"public"` // @gotags: `class:"public"`
}

func (x *ListAuthMethodsResponse) Reset() {
	*x = ListAuthMethodsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_services_v1_auth_method_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAuthMethodsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAuthMethodsResponse) ProtoMessage() {}

func (x *ListAuthMethodsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_services_v1_auth_method_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAuthMethodsResponse.ProtoReflect.Descriptor instead.
func (*ListAuthMethodsResponse) Descriptor() ([]byte, []int) {
	return file_controller_api_services_v1_auth_method_service_proto_rawDescGZIP(), []int{3}
}

func (x *ListAuthMethodsResponse) GetItems() []*authmethods.AuthMethod {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *ListAuthMethodsResponse) GetResponseType() string {
	if x != nil {
		return x.ResponseType
	}
	return ""
}

func (x *ListAuthMethodsResponse) GetListToken() string {
	if x != nil {
		return x.ListToken
	}
	return ""
}

func (x *ListAuthMethodsResponse) GetSortBy() string {
	if x != nil {
		return x.SortBy
	}
	return ""
}

func (x *ListAuthMethodsResponse) GetSortDir() string {
	if x != nil {
		return x.SortDir
	}
	return ""
}

func (x *ListAuthMethodsResponse) GetRemovedIds() []string {
	if x != nil {
		return x.RemovedIds
	}
	return nil
}

func (x *ListAuthMethodsResponse) GetEstItemCount() uint32 {
	if x != nil {
		return x.EstItemCount
	}
	return 0
}

type CreateAuthMethodRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Item *authmethods.AuthMethod `protobuf:"bytes,1,opt,name=item,proto3" json:"item,omitempty"`
}

func (x *CreateAuthMethodRequest) Reset() {
	*x = CreateAuthMethodRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_services_v1_auth_method_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAuthMethodRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAuthMethodRequest) ProtoMessage() {}

func (x *CreateAuthMethodRequest) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_services_v1_auth_method_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAuthMethodRequest.ProtoReflect.Descriptor instead.
func (*CreateAuthMethodRequest) Descriptor() ([]byte, []int) {
	return file_controller_api_services_v1_auth_method_service_proto_rawDescGZIP(), []int{4}
}

func (x *CreateAuthMethodRequest) GetItem() *authmethods.AuthMethod {
	if x != nil {
		return x.Item
	}
	return nil
}

type CreateAuthMethodResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Uri  string                  `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty" class:"public" eventstream:"observation"` // @gotags: `class:"public" eventstream:"observation"`
	Item *authmethods.AuthMethod `protobuf:"bytes,2,opt,name=item,proto3" json:"item,omitempty"`
}

func (x *CreateAuthMethodResponse) Reset() {
	*x = CreateAuthMethodResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_services_v1_auth_method_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAuthMethodResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAuthMethodResponse) ProtoMessage() {}

func (x *CreateAuthMethodResponse) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_services_v1_auth_method_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAuthMethodResponse.ProtoReflect.Descriptor instead.
func (*CreateAuthMethodResponse) Descriptor() ([]byte, []int) {
	return file_controller_api_services_v1_auth_method_service_proto_rawDescGZIP(), []int{5}
}

func (x *CreateAuthMethodResponse) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *CreateAuthMethodResponse) GetItem() *authmethods.AuthMethod {
	if x != nil {
		return x.Item
	}
	return nil
}

type UpdateAuthMethodRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the auth method that should be updated
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty" class:"public" eventstream:"observation"` // @gotags: `class:"public" eventstream:"observation"`
	// A subset of the auth method containing the fields to update.
	Item       *authmethods.AuthMethod `protobuf:"bytes,2,opt,name=item,proto3" json:"item,omitempty"`
	UpdateMask *fieldmaskpb.FieldMask  `protobuf:"bytes,3,opt,name=update_mask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateAuthMethodRequest) Reset() {
	*x = UpdateAuthMethodRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_services_v1_auth_method_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateAuthMethodRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAuthMethodRequest) ProtoMessage() {}

func (x *UpdateAuthMethodRequest) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_services_v1_auth_method_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAuthMethodRequest.ProtoReflect.Descriptor instead.
func (*UpdateAuthMethodRequest) Descriptor() ([]byte, []int) {
	return file_controller_api_services_v1_auth_method_service_proto_rawDescGZIP(), []int{6}
}

func (x *UpdateAuthMethodRequest) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *UpdateAuthMethodRequest) GetItem() *authmethods.AuthMethod {
	if x != nil {
		return x.Item
	}
	return nil
}

func (x *UpdateAuthMethodRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

type UpdateAuthMethodResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Item *authmethods.AuthMethod `protobuf:"bytes,1,opt,name=item,proto3" json:"item,omitempty"`
}

func (x *UpdateAuthMethodResponse) Reset() {
	*x = UpdateAuthMethodResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_services_v1_auth_method_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateAuthMethodResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAuthMethodResponse) ProtoMessage() {}

func (x *UpdateAuthMethodResponse) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_services_v1_auth_method_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAuthMethodResponse.ProtoReflect.Descriptor instead.
func (*UpdateAuthMethodResponse) Descriptor() ([]byte, []int) {
	return file_controller_api_services_v1_auth_method_service_proto_rawDescGZIP(), []int{7}
}

func (x *UpdateAuthMethodResponse) GetItem() *authmethods.AuthMethod {
	if x != nil {
		return x.Item
	}
	return nil
}

type DeleteAuthMethodRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the auth method to delete.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty" class:"public" eventstream:"observation"` // @gotags: `class:"public" eventstream:"observation"`
}

func (x *DeleteAuthMethodRequest) Reset() {
	*x = DeleteAuthMethodRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_services_v1_auth_method_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAuthMethodRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAuthMethodRequest) ProtoMessage() {}

func (x *DeleteAuthMethodRequest) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_services_v1_auth_method_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAuthMethodRequest.ProtoReflect.Descriptor instead.
func (*DeleteAuthMethodRequest) Descriptor() ([]byte, []int) {
	return file_controller_api_services_v1_auth_method_service_proto_rawDescGZIP(), []int{8}
}

func (x *DeleteAuthMethodRequest) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

type DeleteAuthMethodResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeleteAuthMethodResponse) Reset() {
	*x = DeleteAuthMethodResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_services_v1_auth_method_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAuthMethodResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAuthMethodResponse) ProtoMessage() {}

func (x *DeleteAuthMethodResponse) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_services_v1_auth_method_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAuthMethodResponse.ProtoReflect.Descriptor instead.
func (*DeleteAuthMethodResponse) Descriptor() ([]byte, []int) {
	return file_controller_api_services_v1_auth_method_service_proto_rawDescGZIP(), []int{9}
}

// Attributes specific to changing the state of an OIDC auth method.
type OidcChangeStateAttributes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// state must be `inactive`, `active-private`, or `active-public`
	State string `protobuf:"bytes,1,opt,name=state,proto3" json:"state,omitempty" class:"public"` // @gotags: `class:"public"`
	// This flag is only useful for an OIDC auth method. It should not be used
	// unless the OIDC provider's config is incorrectly set and is stopping the
	// activation of this auth method.
	DisableDiscoveredConfigValidation bool `protobuf:"varint,2,opt,name=disable_discovered_config_validation,proto3" json:"disable_discovered_config_validation,omitempty" class:"public"` // @gotags: `class:"public"`
}

func (x *OidcChangeStateAttributes) Reset() {
	*x = OidcChangeStateAttributes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_services_v1_auth_method_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OidcChangeStateAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OidcChangeStateAttributes) ProtoMessage() {}

func (x *OidcChangeStateAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_services_v1_auth_method_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OidcChangeStateAttributes.ProtoReflect.Descriptor instead.
func (*OidcChangeStateAttributes) Descriptor() ([]byte, []int) {
	return file_controller_api_services_v1_auth_method_service_proto_rawDescGZIP(), []int{10}
}

func (x *OidcChangeStateAttributes) GetState() string {
	if x != nil {
		return x.State
	}
	return ""
}

func (x *OidcChangeStateAttributes) GetDisableDiscoveredConfigValidation() bool {
	if x != nil {
		return x.DisableDiscoveredConfigValidation
	}
	return false
}

type ChangeStateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty" class:"public"` // @gotags: `class:"public"`
	// Version is used to ensure this resource has not changed.
	// The mutation will fail if the version does not match the latest known good version.
	Version uint32 `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty" class:"public"` // @gotags: `class:"public"`
	// Types that are assignable to Attrs:
	//
	//	*ChangeStateRequest_Attributes
	//	*ChangeStateRequest_OidcChangeStateAttributes
	Attrs isChangeStateRequest_Attrs `protobuf_oneof:"attrs"`
}

func (x *ChangeStateRequest) Reset() {
	*x = ChangeStateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_services_v1_auth_method_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChangeStateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeStateRequest) ProtoMessage() {}

func (x *ChangeStateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_services_v1_auth_method_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeStateRequest.ProtoReflect.Descriptor instead.
func (*ChangeStateRequest) Descriptor() ([]byte, []int) {
	return file_controller_api_services_v1_auth_method_service_proto_rawDescGZIP(), []int{11}
}

func (x *ChangeStateRequest) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *ChangeStateRequest) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (m *ChangeStateRequest) GetAttrs() isChangeStateRequest_Attrs {
	if m != nil {
		return m.Attrs
	}
	return nil
}

func (x *ChangeStateRequest) GetAttributes() *structpb.Struct {
	if x, ok := x.GetAttrs().(*ChangeStateRequest_Attributes); ok {
		return x.Attributes
	}
	return nil
}

func (x *ChangeStateRequest) GetOidcChangeStateAttributes() *OidcChangeStateAttributes {
	if x, ok := x.GetAttrs().(*ChangeStateRequest_OidcChangeStateAttributes); ok {
		return x.OidcChangeStateAttributes
	}
	return nil
}

type isChangeStateRequest_Attrs interface {
	isChangeStateRequest_Attrs()
}

type ChangeStateRequest_Attributes struct {
	// The attributes specific to this auth method's state.
	Attributes *structpb.Struct `protobuf:"bytes,4,opt,name=attributes,proto3,oneof"`
}

type ChangeStateRequest_OidcChangeStateAttributes struct {
	OidcChangeStateAttributes *OidcChangeStateAttributes `protobuf:"bytes,5,opt,name=oidc_change_state_attributes,json=oidcChangeStateAttributes,proto3,oneof"`
}

func (*ChangeStateRequest_Attributes) isChangeStateRequest_Attrs() {}

func (*ChangeStateRequest_OidcChangeStateAttributes) isChangeStateRequest_Attrs() {}

type ChangeStateResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Item *authmethods.AuthMethod `protobuf:"bytes,1,opt,name=item,proto3" json:"item,omitempty"`
}

func (x *ChangeStateResponse) Reset() {
	*x = ChangeStateResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_services_v1_auth_method_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChangeStateResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeStateResponse) ProtoMessage() {}

func (x *ChangeStateResponse) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_services_v1_auth_method_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeStateResponse.ProtoReflect.Descriptor instead.
func (*ChangeStateResponse) Descriptor() ([]byte, []int) {
	return file_controller_api_services_v1_auth_method_service_proto_rawDescGZIP(), []int{12}
}

func (x *ChangeStateResponse) GetItem() *authmethods.AuthMethod {
	if x != nil {
		return x.Item
	}
	return nil
}

// The layout of the struct for "attributes" field in AuthenticateRequest for a password type.
// This message isn't directly referenced anywhere but is used here to define the expected
// field names and types.
type PasswordLoginAttributes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LoginName string `protobuf:"bytes,1,opt,name=login_name,proto3" json:"login_name,omitempty" class:"sensitive"` // @gotags: `class:"sensitive"`
	Password  string `protobuf:"bytes,2,opt,name=password,proto3" json:"password,omitempty" class:"secret"`     // @gotags: `class:"secret"`
}

func (x *PasswordLoginAttributes) Reset() {
	*x = PasswordLoginAttributes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_services_v1_auth_method_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PasswordLoginAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PasswordLoginAttributes) ProtoMessage() {}

func (x *PasswordLoginAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_services_v1_auth_method_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PasswordLoginAttributes.ProtoReflect.Descriptor instead.
func (*PasswordLoginAttributes) Descriptor() ([]byte, []int) {
	return file_controller_api_services_v1_auth_method_service_proto_rawDescGZIP(), []int{13}
}

func (x *PasswordLoginAttributes) GetLoginName() string {
	if x != nil {
		return x.LoginName
	}
	return ""
}

func (x *PasswordLoginAttributes) GetPassword() string {
	if x != nil {
		return x.Password
	}
	return ""
}

// The layout of the struct for "attributes" field in AuthenticateRequest for a OIDC type's start command. This message isn't directly referenced anywhere but is used here to define the expected field
// names and types.
type OidcStartAttributes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An object which will be marshaled as JSON and roundtripped in the token command call.
	RoundtripPayload *structpb.Struct `protobuf:"bytes,1,opt,name=roundtrip_payload,proto3" json:"roundtrip_payload,omitempty"`
	// Cached marshaled payload. This is not ingressed from the client; anything found will be thrown out.
	CachedRoundtripPayload string `protobuf:"bytes,2,opt,name=cached_roundtrip_payload,json=cachedRoundtripPayload,proto3" json:"cached_roundtrip_payload,omitempty" class:"sensitive"` // @gotags: `class:"sensitive"`
}

func (x *OidcStartAttributes) Reset() {
	*x = OidcStartAttributes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_services_v1_auth_method_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OidcStartAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OidcStartAttributes) ProtoMessage() {}

func (x *OidcStartAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_services_v1_auth_method_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OidcStartAttributes.ProtoReflect.Descriptor instead.
func (*OidcStartAttributes) Descriptor() ([]byte, []int) {
	return file_controller_api_services_v1_auth_method_service_proto_rawDescGZIP(), []int{14}
}

func (x *OidcStartAttributes) GetRoundtripPayload() *structpb.Struct {
	if x != nil {
		return x.RoundtripPayload
	}
	return nil
}

func (x *OidcStartAttributes) GetCachedRoundtripPayload() string {
	if x != nil {
		return x.CachedRoundtripPayload
	}
	return ""
}

// The layout of the struct for "attributes" field in AuthenticateRequest for an
// ldap type. This message isn't directly referenced anywhere but is used here
// to define the expected field names and types.
type LdapLoginAttributes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LoginName string `protobuf:"bytes,10,opt,name=login_name,proto3" json:"login_name,omitempty" class:"sensitive"` // @gotags: `class:"sensitive"`
	Password  string `protobuf:"bytes,20,opt,name=password,proto3" json:"password,omitempty" class:"secret"`     // @gotags: `class:"secret"`
}

func (x *LdapLoginAttributes) Reset() {
	*x = LdapLoginAttributes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_services_v1_auth_method_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LdapLoginAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LdapLoginAttributes) ProtoMessage() {}

func (x *LdapLoginAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_services_v1_auth_method_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LdapLoginAttributes.ProtoReflect.Descriptor instead.
func (*LdapLoginAttributes) Descriptor() ([]byte, []int) {
	return file_controller_api_services_v1_auth_method_service_proto_rawDescGZIP(), []int{15}
}

func (x *LdapLoginAttributes) GetLoginName() string {
	if x != nil {
		return x.LoginName
	}
	return ""
}

func (x *LdapLoginAttributes) GetPassword() string {
	if x != nil {
		return x.Password
	}
	return ""
}

type AuthenticateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the auth method in the system that should be used for authentication.
	AuthMethodId string `protobuf:"bytes,1,opt,name=auth_method_id,proto3" json:"auth_method_id,omitempty" class:"public" eventstream:"observation"` // @gotags: `class:"public" eventstream:"observation"`
	// This can be "cookie" or "token". If not provided, "token" will be used. "cookie" activates a split-cookie method where the token is split partially between http-only and regular cookies in order
	// to keep it safe from rogue JS in the browser. Deprecated, use "type" instead.
	//
	// Deprecated: Marked as deprecated in controller/api/services/v1/auth_method_service.proto.
	TokenType string `protobuf:"bytes,2,opt,name=token_type,proto3" json:"token_type,omitempty" class:"public"` // @gotags: `class:"public"`
	// This can be "cookie" or "token". If not provided, "token" will be used. "cookie" activates a split-cookie method where the token is split partially between http-only and regular cookies in order
	// to keep it safe from rogue JS in the browser.
	Type string `protobuf:"bytes,6,opt,name=type,proto3" json:"type,omitempty" class:"public" eventstream:"observation"` // @gotags: `class:"public" eventstream:"observation"`
	// Types that are assignable to Attrs:
	//
	//	*AuthenticateRequest_Attributes
	//	*AuthenticateRequest_PasswordLoginAttributes
	//	*AuthenticateRequest_OidcStartAttributes
	//	*AuthenticateRequest_OidcAuthMethodAuthenticateCallbackRequest
	//	*AuthenticateRequest_OidcAuthMethodAuthenticateTokenRequest
	//	*AuthenticateRequest_LdapLoginAttributes
	Attrs isAuthenticateRequest_Attrs `protobuf_oneof:"attrs"`
	// The command to perform. One of "login", "callback", or "token".
	Command string `protobuf:"bytes,5,opt,name=command,proto3" json:"command,omitempty" class:"public"` // @gotags: `class:"public"`
}

func (x *AuthenticateRequest) Reset() {
	*x = AuthenticateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_services_v1_auth_method_service_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthenticateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthenticateRequest) ProtoMessage() {}

func (x *AuthenticateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_services_v1_auth_method_service_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthenticateRequest.ProtoReflect.Descriptor instead.
func (*AuthenticateRequest) Descriptor() ([]byte, []int) {
	return file_controller_api_services_v1_auth_method_service_proto_rawDescGZIP(), []int{16}
}

func (x *AuthenticateRequest) GetAuthMethodId() string {
	if x != nil {
		return x.AuthMethodId
	}
	return ""
}

// Deprecated: Marked as deprecated in controller/api/services/v1/auth_method_service.proto.
func (x *AuthenticateRequest) GetTokenType() string {
	if x != nil {
		return x.TokenType
	}
	return ""
}

func (x *AuthenticateRequest) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (m *AuthenticateRequest) GetAttrs() isAuthenticateRequest_Attrs {
	if m != nil {
		return m.Attrs
	}
	return nil
}

func (x *AuthenticateRequest) GetAttributes() *structpb.Struct {
	if x, ok := x.GetAttrs().(*AuthenticateRequest_Attributes); ok {
		return x.Attributes
	}
	return nil
}

func (x *AuthenticateRequest) GetPasswordLoginAttributes() *PasswordLoginAttributes {
	if x, ok := x.GetAttrs().(*AuthenticateRequest_PasswordLoginAttributes); ok {
		return x.PasswordLoginAttributes
	}
	return nil
}

func (x *AuthenticateRequest) GetOidcStartAttributes() *OidcStartAttributes {
	if x, ok := x.GetAttrs().(*AuthenticateRequest_OidcStartAttributes); ok {
		return x.OidcStartAttributes
	}
	return nil
}

func (x *AuthenticateRequest) GetOidcAuthMethodAuthenticateCallbackRequest() *authmethods.OidcAuthMethodAuthenticateCallbackRequest {
	if x, ok := x.GetAttrs().(*AuthenticateRequest_OidcAuthMethodAuthenticateCallbackRequest); ok {
		return x.OidcAuthMethodAuthenticateCallbackRequest
	}
	return nil
}

func (x *AuthenticateRequest) GetOidcAuthMethodAuthenticateTokenRequest() *authmethods.OidcAuthMethodAuthenticateTokenRequest {
	if x, ok := x.GetAttrs().(*AuthenticateRequest_OidcAuthMethodAuthenticateTokenRequest); ok {
		return x.OidcAuthMethodAuthenticateTokenRequest
	}
	return nil
}

func (x *AuthenticateRequest) GetLdapLoginAttributes() *LdapLoginAttributes {
	if x, ok := x.GetAttrs().(*AuthenticateRequest_LdapLoginAttributes); ok {
		return x.LdapLoginAttributes
	}
	return nil
}

func (x *AuthenticateRequest) GetCommand() string {
	if x != nil {
		return x.Command
	}
	return ""
}

type isAuthenticateRequest_Attrs interface {
	isAuthenticateRequest_Attrs()
}

type AuthenticateRequest_Attributes struct {
	// Attributes are passed to the auth method. The valid keys and values depend on the type of auth method as well as the command.
	Attributes *structpb.Struct `protobuf:"bytes,4,opt,name=attributes,proto3,oneof"`
}

type AuthenticateRequest_PasswordLoginAttributes struct {
	// Note: these fields have a custom mapping function for transforming to and from the generic attributes,
	// they do not use the standard attribute transformation.
	PasswordLoginAttributes *PasswordLoginAttributes `protobuf:"bytes,7,opt,name=password_login_attributes,json=passwordLoginAttributes,proto3,oneof"`
}

type AuthenticateRequest_OidcStartAttributes struct {
	OidcStartAttributes *OidcStartAttributes `protobuf:"bytes,8,opt,name=oidc_start_attributes,json=oidcStartAttributes,proto3,oneof"`
}

type AuthenticateRequest_OidcAuthMethodAuthenticateCallbackRequest struct {
	OidcAuthMethodAuthenticateCallbackRequest *authmethods.OidcAuthMethodAuthenticateCallbackRequest `protobuf:"bytes,9,opt,name=oidc_auth_method_authenticate_callback_request,json=oidcAuthMethodAuthenticateCallbackRequest,proto3,oneof"`
}

type AuthenticateRequest_OidcAuthMethodAuthenticateTokenRequest struct {
	OidcAuthMethodAuthenticateTokenRequest *authmethods.OidcAuthMethodAuthenticateTokenRequest `protobuf:"bytes,10,opt,name=oidc_auth_method_authenticate_token_request,json=oidcAuthMethodAuthenticateTokenRequest,proto3,oneof"`
}

type AuthenticateRequest_LdapLoginAttributes struct {
	LdapLoginAttributes *LdapLoginAttributes `protobuf:"bytes,11,opt,name=ldap_login_attributes,json=ldapLoginAttributes,proto3,oneof"`
}

func (*AuthenticateRequest_Attributes) isAuthenticateRequest_Attrs() {}

func (*AuthenticateRequest_PasswordLoginAttributes) isAuthenticateRequest_Attrs() {}

func (*AuthenticateRequest_OidcStartAttributes) isAuthenticateRequest_Attrs() {}

func (*AuthenticateRequest_OidcAuthMethodAuthenticateCallbackRequest) isAuthenticateRequest_Attrs() {}

func (*AuthenticateRequest_OidcAuthMethodAuthenticateTokenRequest) isAuthenticateRequest_Attrs() {}

func (*AuthenticateRequest_LdapLoginAttributes) isAuthenticateRequest_Attrs() {}

type AuthenticateResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of the token returned. Either "cookie" or "token".
	Type string `protobuf:"bytes,3,opt,name=type,proto3" json:"type,omitempty" class:"public" eventstream:"observation"` // @gotags: `class:"public" eventstream:"observation"`
	// Types that are assignable to Attrs:
	//
	//	*AuthenticateResponse_Attributes
	//	*AuthenticateResponse_OidcAuthMethodAuthenticateStartResponse
	//	*AuthenticateResponse_OidcAuthMethodAuthenticateCallbackResponse
	//	*AuthenticateResponse_OidcAuthMethodAuthenticateTokenResponse
	//	*AuthenticateResponse_AuthTokenResponse
	Attrs isAuthenticateResponse_Attrs `protobuf_oneof:"attrs"`
	// The command that was performed.
	Command string `protobuf:"bytes,5,opt,name=command,proto3" json:"command,omitempty" class:"public"` // @gotags: `class:"public"`
}

func (x *AuthenticateResponse) Reset() {
	*x = AuthenticateResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_api_services_v1_auth_method_service_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthenticateResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthenticateResponse) ProtoMessage() {}

func (x *AuthenticateResponse) ProtoReflect() protoreflect.Message {
	mi := &file_controller_api_services_v1_auth_method_service_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthenticateResponse.ProtoReflect.Descriptor instead.
func (*AuthenticateResponse) Descriptor() ([]byte, []int) {
	return file_controller_api_services_v1_auth_method_service_proto_rawDescGZIP(), []int{17}
}

func (x *AuthenticateResponse) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (m *AuthenticateResponse) GetAttrs() isAuthenticateResponse_Attrs {
	if m != nil {
		return m.Attrs
	}
	return nil
}

func (x *AuthenticateResponse) GetAttributes() *structpb.Struct {
	if x, ok := x.GetAttrs().(*AuthenticateResponse_Attributes); ok {
		return x.Attributes
	}
	return nil
}

func (x *AuthenticateResponse) GetOidcAuthMethodAuthenticateStartResponse() *authmethods.OidcAuthMethodAuthenticateStartResponse {
	if x, ok := x.GetAttrs().(*AuthenticateResponse_OidcAuthMethodAuthenticateStartResponse); ok {
		return x.OidcAuthMethodAuthenticateStartResponse
	}
	return nil
}

func (x *AuthenticateResponse) GetOidcAuthMethodAuthenticateCallbackResponse() *authmethods.OidcAuthMethodAuthenticateCallbackResponse {
	if x, ok := x.GetAttrs().(*AuthenticateResponse_OidcAuthMethodAuthenticateCallbackResponse); ok {
		return x.OidcAuthMethodAuthenticateCallbackResponse
	}
	return nil
}

func (x *AuthenticateResponse) GetOidcAuthMethodAuthenticateTokenResponse() *authmethods.OidcAuthMethodAuthenticateTokenResponse {
	if x, ok := x.GetAttrs().(*AuthenticateResponse_OidcAuthMethodAuthenticateTokenResponse); ok {
		return x.OidcAuthMethodAuthenticateTokenResponse
	}
	return nil
}

func (x *AuthenticateResponse) GetAuthTokenResponse() *authtokens.AuthToken {
	if x, ok := x.GetAttrs().(*AuthenticateResponse_AuthTokenResponse); ok {
		return x.AuthTokenResponse
	}
	return nil
}

func (x *AuthenticateResponse) GetCommand() string {
	if x != nil {
		return x.Command
	}
	return ""
}

type isAuthenticateResponse_Attrs interface {
	isAuthenticateResponse_Attrs()
}

type AuthenticateResponse_Attributes struct {
	// Valid keys and values depend on the type of auth method as well as the command.
	Attributes *structpb.Struct `protobuf:"bytes,4,opt,name=attributes,proto3,oneof"`
}

type AuthenticateResponse_OidcAuthMethodAuthenticateStartResponse struct {
	// Note: these fields have a custom mapping function for transforming to and from the generic attributes,
	// they do not use the standard attribute transformation.
	OidcAuthMethodAuthenticateStartResponse *authmethods.OidcAuthMethodAuthenticateStartResponse `protobuf:"bytes,6,opt,name=oidc_auth_method_authenticate_start_response,json=oidcAuthMethodAuthenticateStartResponse,proto3,oneof"`
}

type AuthenticateResponse_OidcAuthMethodAuthenticateCallbackResponse struct {
	OidcAuthMethodAuthenticateCallbackResponse *authmethods.OidcAuthMethodAuthenticateCallbackResponse `protobuf:"bytes,7,opt,name=oidc_auth_method_authenticate_callback_response,json=oidcAuthMethodAuthenticateCallbackResponse,proto3,oneof"`
}

type AuthenticateResponse_OidcAuthMethodAuthenticateTokenResponse struct {
	OidcAuthMethodAuthenticateTokenResponse *authmethods.OidcAuthMethodAuthenticateTokenResponse `protobuf:"bytes,8,opt,name=oidc_auth_method_authenticate_token_response,json=oidcAuthMethodAuthenticateTokenResponse,proto3,oneof"`
}

type AuthenticateResponse_AuthTokenResponse struct {
	AuthTokenResponse *authtokens.AuthToken `protobuf:"bytes,9,opt,name=auth_token_response,json=authTokenResponse,proto3,oneof"`
}

func (*AuthenticateResponse_Attributes) isAuthenticateResponse_Attrs() {}

func (*AuthenticateResponse_OidcAuthMethodAuthenticateStartResponse) isAuthenticateResponse_Attrs() {}

func (*AuthenticateResponse_OidcAuthMethodAuthenticateCallbackResponse) isAuthenticateResponse_Attrs() {
}

func (*AuthenticateResponse_OidcAuthMethodAuthenticateTokenResponse) isAuthenticateResponse_Attrs() {}

func (*AuthenticateResponse_AuthTokenResponse) isAuthenticateResponse_Attrs() {}

var File_controller_api_services_v1_auth_method_service_proto protoreflect.FileDescriptor

var file_controller_api_services_v1_auth_method_service_proto_rawDesc = []byte{
	0x0a, 0x34, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x75, 0x74,
	0x68, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c,
	0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e,
	0x76, 0x31, 0x1a, 0x39, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x75, 0x74,
	0x68, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x75, 0x74, 0x68,
	0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x36, 0x63,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2a, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65,
	0x72, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x76, 0x31, 0x2f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x76, 0x69, 0x73, 0x69,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x63, 0x2d, 0x67, 0x65, 0x6e, 0x2d, 0x6f, 0x70, 0x65, 0x6e, 0x61, 0x70, 0x69,
	0x76, 0x32, 0x2f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x26, 0x0a, 0x14,
	0x47, 0x65, 0x74, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x02, 0x69, 0x64, 0x22, 0x60, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x41, 0x75, 0x74, 0x68, 0x4d,
	0x65, 0x74, 0x68, 0x6f, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x47, 0x0a,
	0x04, 0x69, 0x74, 0x65, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x61, 0x75, 0x74, 0x68, 0x6d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64,
	0x52, 0x04, 0x69, 0x74, 0x65, 0x6d, 0x22, 0xa8, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x41,
	0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x1a, 0x0a, 0x08, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x5f, 0x69, 0x64, 0x12, 0x1c, 0x0a,
	0x09, 0x72, 0x65, 0x63, 0x75, 0x72, 0x73, 0x69, 0x76, 0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x09, 0x72, 0x65, 0x63, 0x75, 0x72, 0x73, 0x69, 0x76, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x0a, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x28, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x32, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x22, 0xaa, 0x02, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65,
	0x74, 0x68, 0x6f, 0x64, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x49, 0x0a,
	0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x61, 0x75, 0x74, 0x68, 0x6d, 0x65, 0x74, 0x68,
	0x6f, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x52, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x12, 0x24, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x12, 0x1e,
	0x0a, 0x0a, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x18,
	0x0a, 0x07, 0x73, 0x6f, 0x72, 0x74, 0x5f, 0x62, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x73, 0x6f, 0x72, 0x74, 0x5f, 0x62, 0x79, 0x12, 0x1a, 0x0a, 0x08, 0x73, 0x6f, 0x72, 0x74,
	0x5f, 0x64, 0x69, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x6f, 0x72, 0x74,
	0x5f, 0x64, 0x69, 0x72, 0x12, 0x20, 0x0a, 0x0b, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x5f,
	0x69, 0x64, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x6d, 0x6f, 0x76,
	0x65, 0x64, 0x5f, 0x69, 0x64, 0x73, 0x12, 0x26, 0x0a, 0x0e, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x74,
	0x65, 0x6d, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0e,
	0x65, 0x73, 0x74, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x62,
	0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68,
	0x6f, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x69, 0x74, 0x65,
	0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2e, 0x61, 0x75, 0x74, 0x68, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x52, 0x04, 0x69, 0x74,
	0x65, 0x6d, 0x22, 0x75, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68,
	0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x10,
	0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69,
	0x12, 0x47, 0x0a, 0x04, 0x69, 0x74, 0x65, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x61, 0x75, 0x74, 0x68, 0x6d, 0x65,
	0x74, 0x68, 0x6f, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74,
	0x68, 0x6f, 0x64, 0x52, 0x04, 0x69, 0x74, 0x65, 0x6d, 0x22, 0xb0, 0x01, 0x0a, 0x17, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x47, 0x0a, 0x04, 0x69, 0x74, 0x65, 0x6d, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72,
	0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x61,
	0x75, 0x74, 0x68, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75,
	0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x52, 0x04, 0x69, 0x74, 0x65, 0x6d, 0x12, 0x3c,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x22, 0x63, 0x0a, 0x18,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x47, 0x0a, 0x04, 0x69, 0x74, 0x65, 0x6d,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2e, 0x61, 0x75, 0x74, 0x68, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x52, 0x04, 0x69, 0x74, 0x65,
	0x6d, 0x22, 0x29, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x4d,
	0x65, 0x74, 0x68, 0x6f, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x0e, 0x0a, 0x02,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x22, 0x1a, 0x0a, 0x18,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x85, 0x01, 0x0a, 0x19, 0x4f, 0x69, 0x64,
	0x63, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x41, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x52, 0x0a, 0x24,
	0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x24, 0x64, 0x69, 0x73, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x65, 0x64, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0xb3, 0x05, 0x0a, 0x12, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0xd4, 0x03, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42,
	0x98, 0x03, 0x92, 0x41, 0x89, 0x03, 0x32, 0xbb, 0x02, 0x54, 0x68, 0x65, 0x20, 0x61, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x61, 0x72, 0x65,
	0x20, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x62, 0x6c, 0x65, 0x20, 0x66, 0x6f, 0x72, 0x20,
	0x74, 0x68, 0x65, 0x20, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x20, 0x61, 0x75, 0x74,
	0x68, 0x20, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x20, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x20, 0x54,
	0x68, 0x65, 0x20, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x69,
	0x73, 0x20, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x20, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x73, 0x20,
	0x6f, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x74, 0x79, 0x70, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74,
	0x68, 0x65, 0x20, 0x61, 0x75, 0x74, 0x68, 0x20, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x2e, 0x20,
	0x54, 0x68, 0x65, 0x20, 0x6f, 0x6e, 0x6c, 0x79, 0x20, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74,
	0x65, 0x64, 0x20, 0x61, 0x75, 0x74, 0x68, 0x20, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x20, 0x74,
	0x79, 0x70, 0x65, 0x20, 0x69, 0x73, 0x20, 0x4f, 0x49, 0x44, 0x43, 0x2e, 0x0a, 0x46, 0x6f, 0x72,
	0x20, 0x4f, 0x49, 0x44, 0x43, 0x20, 0x61, 0x75, 0x74, 0x68, 0x20, 0x6d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x73, 0x2c, 0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x73, 0x20, 0x61, 0x72, 0x65, 0x3a, 0x0a, 0x60, 0x60, 0x60, 0x6a, 0x73, 0x6f, 0x6e, 0x0a,
	0x7b, 0x0a, 0x20, 0x20, 0x22, 0x73, 0x74, 0x61, 0x74, 0x65, 0x22, 0x3a, 0x20, 0x22, 0x61, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x2d, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x22, 0x2c, 0x0a, 0x20, 0x20,
	0x22, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x3a, 0x20, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x0a, 0x7d, 0x0a,
	0x60, 0x60, 0x60, 0x0a, 0x4a, 0x49, 0x7b, 0x22, 0x73, 0x74, 0x61, 0x74, 0x65, 0x22, 0x3a, 0x20,
	0x22, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x2d, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x22, 0x2c,
	0x20, 0x22, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x3a, 0x20, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x7d, 0x9a,
	0xe3, 0x29, 0x07, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x0a, 0x61, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x92, 0x01, 0x0a, 0x1c, 0x6f, 0x69, 0x64,
	0x63, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x61,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x35, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x69, 0x64,
	0x63, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x41, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x42, 0x18, 0x9a, 0xe3, 0x29, 0x04, 0x6f, 0x69, 0x64, 0x63,
	0xfa, 0xd2, 0xe4, 0x93, 0x02, 0x0a, 0x12, 0x08, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c,
	0x48, 0x00, 0x52, 0x19, 0x6f, 0x69, 0x64, 0x63, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x42, 0x07, 0x0a,
	0x05, 0x61, 0x74, 0x74, 0x72, 0x73, 0x22, 0x5e, 0x0a, 0x13, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x47, 0x0a,
	0x04, 0x69, 0x74, 0x65, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x61, 0x75, 0x74, 0x68, 0x6d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64,
	0x52, 0x04, 0x69, 0x74, 0x65, 0x6d, 0x22, 0x55, 0x0a, 0x17, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f,
	0x72, 0x64, 0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x22, 0x96, 0x01,
	0x0a, 0x13, 0x4f, 0x69, 0x64, 0x63, 0x53, 0x74, 0x61, 0x72, 0x74, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x45, 0x0a, 0x11, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x74, 0x72,
	0x69, 0x70, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x11, 0x72, 0x6f, 0x75, 0x6e, 0x64,
	0x74, 0x72, 0x69, 0x70, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x38, 0x0a, 0x18,
	0x63, 0x61, 0x63, 0x68, 0x65, 0x64, 0x5f, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x74, 0x72, 0x69, 0x70,
	0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x16,
	0x63, 0x61, 0x63, 0x68, 0x65, 0x64, 0x52, 0x6f, 0x75, 0x6e, 0x64, 0x74, 0x72, 0x69, 0x70, 0x50,
	0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x22, 0x51, 0x0a, 0x13, 0x4c, 0x64, 0x61, 0x70, 0x4c, 0x6f,
	0x67, 0x69, 0x6e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x1e, 0x0a,
	0x0a, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a,
	0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x14, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x22, 0xc8, 0x0f, 0x0a, 0x13, 0x41, 0x75,
	0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x26, 0x0a, 0x0e, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x61, 0x75, 0x74, 0x68, 0x5f,
	0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x5f, 0x69, 0x64, 0x12, 0x22, 0x0a, 0x0a, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x0a, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x12, 0x93, 0x08, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42,
	0xd7, 0x07, 0x92, 0x41, 0xd3, 0x07, 0x32, 0xa4, 0x07, 0x54, 0x68, 0x65, 0x20, 0x61, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x61, 0x72, 0x65,
	0x20, 0x75, 0x73, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x61, 0x75, 0x74,
	0x68, 0x20, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x2e, 0x20, 0x54, 0x68, 0x65, 0x20, 0x73, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x20, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x73, 0x20, 0x6f, 0x6e, 0x20, 0x74, 0x68,
	0x65, 0x20, 0x74, 0x79, 0x70, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x61, 0x75,
	0x74, 0x68, 0x20, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x2e, 0x20, 0x46, 0x6f, 0x72, 0x20, 0x70,
	0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x20, 0x61, 0x75, 0x74, 0x68, 0x20, 0x6d, 0x65, 0x74,
	0x68, 0x6f, 0x64, 0x73, 0x2c, 0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x73, 0x20, 0x61, 0x72, 0x65, 0x3a, 0x0a, 0x60, 0x60, 0x60, 0x6a, 0x73, 0x6f,
	0x6e, 0x0a, 0x7b, 0x0a, 0x20, 0x20, 0x22, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0x3a, 0x20, 0x22, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0x2c, 0x0a, 0x20, 0x20, 0x22, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x22, 0x3a, 0x20,
	0x22, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x22, 0x0a, 0x7d, 0x0a, 0x60, 0x60, 0x60,
	0x0a, 0x46, 0x6f, 0x72, 0x20, 0x4c, 0x44, 0x41, 0x50, 0x20, 0x61, 0x75, 0x74, 0x68, 0x20, 0x6d,
	0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x2c, 0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x20, 0x61, 0x72, 0x65, 0x3a, 0x0a, 0x60, 0x60, 0x60, 0x6a,
	0x73, 0x6f, 0x6e, 0x0a, 0x7b, 0x0a, 0x20, 0x20, 0x22, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x3a, 0x20, 0x22, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x22, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x22,
	0x3a, 0x20, 0x22, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x22, 0x0a, 0x7d, 0x0a, 0x60,
	0x60, 0x60, 0x0a, 0x46, 0x6f, 0x72, 0x20, 0x4f, 0x49, 0x44, 0x43, 0x20, 0x61, 0x75, 0x74, 0x68,
	0x20, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x2c, 0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x20, 0x61, 0x72, 0x65, 0x3a, 0x0a, 0x60, 0x60,
	0x60, 0x6a, 0x73, 0x6f, 0x6e, 0x0a, 0x7b, 0x0a, 0x20, 0x20, 0x22, 0x72, 0x6f, 0x75, 0x6e, 0x64,
	0x74, 0x72, 0x69, 0x70, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x22, 0x3a, 0x20, 0x7b,
	0x7d, 0x0a, 0x7d, 0x0a, 0x60, 0x60, 0x60, 0x0a, 0x4f, 0x49, 0x44, 0x43, 0x20, 0x61, 0x75, 0x74,
	0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x72, 0x65, 0x71, 0x75,
	0x69, 0x72, 0x65, 0x73, 0x20, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x70, 0x6c, 0x65, 0x20, 0x63, 0x61,
	0x6c, 0x6c, 0x73, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x65, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x20, 0x41, 0x66, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x20, 0x63, 0x61, 0x6c, 0x6c, 0x20, 0x61, 0x6e, 0x64,
	0x20, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x66, 0x75, 0x6c, 0x20, 0x61, 0x75, 0x74, 0x68,
	0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x4f, 0x49, 0x44, 0x43, 0x20, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x20, 0x6d, 0x75,
	0x73, 0x74, 0x20, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x75, 0x73, 0x65, 0x72, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x60, 0x63, 0x61, 0x6c,
	0x6c, 0x62, 0x61, 0x63, 0x6b, 0x60, 0x20, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x3a, 0x0a,
	0x60, 0x60, 0x60, 0x6a, 0x73, 0x6f, 0x6e, 0x0a, 0x7b, 0x0a, 0x20, 0x20, 0x22, 0x63, 0x6f, 0x64,
	0x65, 0x22, 0x3a, 0x20, 0x22, 0x63, 0x6f, 0x64, 0x65, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x22, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x22, 0x3a, 0x20, 0x22, 0x73, 0x74, 0x61, 0x74, 0x65, 0x22, 0x2c, 0x0a,
	0x20, 0x20, 0x22, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x22, 0x3a, 0x20, 0x22, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x22, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x3a, 0x20, 0x22, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x2c, 0x0a,
	0x20, 0x20, 0x22, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x75, 0x72, 0x69, 0x22, 0x3a, 0x20, 0x22,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x75, 0x72, 0x69, 0x22, 0x0a, 0x7d, 0x0a, 0x60, 0x60, 0x60,
	0x0a, 0x4f, 0x6e, 0x63, 0x65, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x68, 0x61, 0x73, 0x20, 0x73,
	0x75, 0x63, 0x63, 0x65, 0x64, 0x65, 0x64, 0x2c, 0x20, 0x74, 0x68, 0x65, 0x20, 0x69, 0x73, 0x73,
	0x75, 0x65, 0x64, 0x20, 0x61, 0x75, 0x74, 0x68, 0x20, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x20, 0x63,
	0x61, 0x6e, 0x20, 0x62, 0x65, 0x20, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x64, 0x20,
	0x62, 0x79, 0x20, 0x75, 0x73, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x20, 0x60, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x60, 0x20, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x3a, 0x0a, 0x60, 0x60,
	0x60, 0x6a, 0x73, 0x6f, 0x6e, 0x0a, 0x7b, 0x0a, 0x20, 0x20, 0x22, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x5f, 0x69, 0x64, 0x22, 0x3a, 0x20, 0x22, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x69, 0x64, 0x5f,
	0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x72, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x0a, 0x7d, 0x0a, 0x60, 0x60, 0x60, 0x0a, 0x4a, 0x2a, 0x7b,
	0x22, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x22, 0x3a, 0x20, 0x22, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x22,
	0x2c, 0x20, 0x22, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x22, 0x3a, 0x20, 0x22, 0x70,
	0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x22, 0x7d, 0x48, 0x00, 0x52, 0x0a, 0x61, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x83, 0x01, 0x0a, 0x19, 0x70, 0x61, 0x73, 0x73,
	0x77, 0x6f, 0x72, 0x64, 0x5f, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72,
	0x64, 0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
	0x42, 0x10, 0xfa, 0xd2, 0xe4, 0x93, 0x02, 0x0a, 0x12, 0x08, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e,
	0x41, 0x4c, 0x48, 0x00, 0x52, 0x17, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x4c, 0x6f,
	0x67, 0x69, 0x6e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x77, 0x0a,
	0x15, 0x6f, 0x69, 0x64, 0x63, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x61, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x69, 0x64, 0x63, 0x53, 0x74,
	0x61, 0x72, 0x74, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x42, 0x10, 0xfa,
	0xd2, 0xe4, 0x93, 0x02, 0x0a, 0x12, 0x08, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x48,
	0x00, 0x52, 0x13, 0x6f, 0x69, 0x64, 0x63, 0x53, 0x74, 0x61, 0x72, 0x74, 0x41, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0xc9, 0x01, 0x0a, 0x2e, 0x6f, 0x69, 0x64, 0x63, 0x5f,
	0x61, 0x75, 0x74, 0x68, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x5f, 0x61, 0x75, 0x74, 0x68,
	0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63,
	0x6b, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x52, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69,
	0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x61, 0x75, 0x74, 0x68, 0x6d,
	0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x69, 0x64, 0x63, 0x41, 0x75,
	0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x42, 0x10, 0xfa, 0xd2, 0xe4, 0x93, 0x02, 0x0a, 0x12, 0x08, 0x49, 0x4e, 0x54,
	0x45, 0x52, 0x4e, 0x41, 0x4c, 0x48, 0x00, 0x52, 0x29, 0x6f, 0x69, 0x64, 0x63, 0x41, 0x75, 0x74,
	0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0xc0, 0x01, 0x0a, 0x2b, 0x6f, 0x69, 0x64, 0x63, 0x5f, 0x61, 0x75, 0x74, 0x68,
	0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4f, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2e, 0x61, 0x75, 0x74, 0x68, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x4f, 0x69, 0x64, 0x63, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x10, 0xfa, 0xd2, 0xe4, 0x93, 0x02,
	0x0a, 0x12, 0x08, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x48, 0x00, 0x52, 0x26, 0x6f,
	0x69, 0x64, 0x63, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x41, 0x75, 0x74,
	0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x77, 0x0a, 0x15, 0x6c, 0x64, 0x61, 0x70, 0x5f, 0x6c, 0x6f,
	0x67, 0x69, 0x6e, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65,
	0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x64, 0x61, 0x70, 0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x73, 0x42, 0x10, 0xfa, 0xd2, 0xe4, 0x93, 0x02, 0x0a, 0x12, 0x08, 0x49,
	0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x48, 0x00, 0x52, 0x13, 0x6c, 0x64, 0x61, 0x70, 0x4c,
	0x6f, 0x67, 0x69, 0x6e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x18,
	0x0a, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x42, 0x07, 0x0a, 0x05, 0x61, 0x74, 0x74, 0x72,
	0x73, 0x4a, 0x04, 0x08, 0x03, 0x10, 0x04, 0x52, 0x0b, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x61, 0x6c, 0x73, 0x22, 0xdc, 0x0e, 0x0a, 0x14, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x12, 0x0a,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x12, 0x9c, 0x08, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42,
	0xe0, 0x07, 0x92, 0x41, 0xdc, 0x07, 0x32, 0xad, 0x07, 0x54, 0x68, 0x65, 0x20, 0x72, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x20, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
	0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x61, 0x72, 0x65, 0x20, 0x75, 0x73, 0x65, 0x64, 0x20, 0x74,
	0x6f, 0x20, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x20, 0x74,
	0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x61, 0x75, 0x74, 0x68, 0x20, 0x6d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x2e, 0x20, 0x54, 0x68, 0x65, 0x20, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x20, 0x6f, 0x66,
	0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x20, 0x64, 0x65, 0x70, 0x65,
	0x6e, 0x64, 0x73, 0x20, 0x6f, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x74, 0x79, 0x70, 0x65, 0x20,
	0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x61, 0x75, 0x74, 0x68, 0x20, 0x6d, 0x65, 0x74, 0x68,
	0x6f, 0x64, 0x2e, 0x20, 0x46, 0x6f, 0x72, 0x20, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64,
	0x2c, 0x20, 0x4f, 0x49, 0x44, 0x43, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x4c, 0x44, 0x41, 0x50, 0x20,
	0x61, 0x75, 0x74, 0x68, 0x20, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x2c, 0x20, 0x74, 0x68,
	0x65, 0x20, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x20, 0x69, 0x73, 0x20, 0x61, 0x6e,
	0x20, 0x61, 0x75, 0x74, 0x68, 0x20, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x3a, 0x0a, 0x60, 0x60, 0x60,
	0x6a, 0x73, 0x6f, 0x6e, 0x0a, 0x7b, 0x0a, 0x20, 0x20, 0x22, 0x69, 0x64, 0x22, 0x3a, 0x20, 0x22,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x69, 0x64, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x22, 0x73, 0x63,
	0x6f, 0x70, 0x65, 0x5f, 0x69, 0x64, 0x22, 0x3a, 0x20, 0x22, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x5f,
	0x69, 0x64, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x22, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x3a, 0x20,
	0x22, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x22, 0x2c, 0x0a,
	0x20, 0x20, 0x22, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x22, 0x3a, 0x20, 0x22, 0x75, 0x73,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x22, 0x61, 0x75, 0x74, 0x68, 0x5f,
	0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x5f, 0x69, 0x64, 0x22, 0x3a, 0x20, 0x22, 0x61, 0x75, 0x74,
	0x68, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x5f, 0x69, 0x64, 0x22, 0x2c, 0x0a, 0x20, 0x20,
	0x22, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x22, 0x3a, 0x20, 0x22, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x22, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x22, 0x3a, 0x20, 0x22, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x22, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x22, 0x3a, 0x20, 0x22, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x22, 0x2c, 0x0a, 0x20, 0x20, 0x22, 0x61,
	0x70, 0x70, 0x72, 0x6f, 0x78, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x5f, 0x6c, 0x61, 0x73, 0x74, 0x5f,
	0x75, 0x73, 0x65, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x22, 0x3a, 0x20, 0x22, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x5f, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x78, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x5f, 0x6c,
	0x61, 0x73, 0x74, 0x5f, 0x75, 0x73, 0x65, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x22, 0x2c, 0x0a,
	0x20, 0x20, 0x22, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x22, 0x3a, 0x20, 0x22, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x65, 0x78, 0x70, 0x69,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x22, 0x0a, 0x7d, 0x0a, 0x60,
	0x60, 0x60, 0x0a, 0x46, 0x6f, 0x72, 0x20, 0x4f, 0x49, 0x44, 0x43, 0x20, 0x61, 0x75, 0x74, 0x68,
	0x20, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x2c, 0x20, 0x74, 0x68, 0x65, 0x20, 0x69, 0x6e,
	0x69, 0x74, 0x69, 0x61, 0x6c, 0x20, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x20, 0x61, 0x72, 0x65, 0x3a, 0x0a, 0x60, 0x60, 0x60, 0x6a, 0x73, 0x6f, 0x6e, 0x0a, 0x7b, 0x0a,
	0x20, 0x20, 0x22, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x75, 0x72, 0x6c, 0x22, 0x3a, 0x20, 0x22, 0x4f,
	0x49, 0x44, 0x43, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x75, 0x72, 0x6c, 0x22, 0x2c, 0x0a, 0x20,
	0x20, 0x22, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x69, 0x64, 0x22, 0x3a, 0x20, 0x22, 0x4f, 0x49,
	0x44, 0x43, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x69, 0x64, 0x22, 0x0a, 0x7d, 0x0a, 0x60,
	0x60, 0x60, 0x0a, 0x54, 0x68, 0x65, 0x20, 0x60, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x75, 0x72, 0x6c,
	0x60, 0x20, 0x69, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20, 0x55, 0x52, 0x4c, 0x20, 0x74, 0x68, 0x61,
	0x74, 0x20, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6e, 0x67,
	0x20, 0x75, 0x73, 0x65, 0x72, 0x20, 0x73, 0x68, 0x6f, 0x75, 0x6c, 0x64, 0x20, 0x6f, 0x70, 0x65,
	0x6e, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x62, 0x72, 0x6f, 0x77, 0x73, 0x65, 0x72,
	0x20, 0x74, 0x6f, 0x20, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4f, 0x49, 0x44, 0x43, 0x20, 0x70,
	0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x2e, 0x20, 0x54, 0x68, 0x65, 0x20, 0x60, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x5f, 0x69, 0x64, 0x60, 0x20, 0x73, 0x68, 0x6f, 0x75, 0x6c, 0x64, 0x20, 0x62,
	0x65, 0x20, 0x75, 0x73, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x20, 0x73, 0x75, 0x62, 0x73, 0x65, 0x71,
	0x75, 0x65, 0x6e, 0x74, 0x20, 0x63, 0x61, 0x6c, 0x6c, 0x73, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68,
	0x65, 0x20, 0x60, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x60,
	0x20, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x20, 0x74, 0x6f, 0x20, 0x72, 0x65, 0x74,
	0x72, 0x69, 0x65, 0x76, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x61, 0x75, 0x74, 0x68, 0x20, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x2e, 0x0a, 0x4a, 0x2a, 0x7b, 0x22, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x22,
	0x3a, 0x20, 0x22, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x22, 0x2c, 0x20, 0x22, 0x70, 0x61, 0x73, 0x73,
	0x77, 0x6f, 0x72, 0x64, 0x22, 0x3a, 0x20, 0x22, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64,
	0x22, 0x7d, 0x48, 0x00, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
	0x12, 0xc3, 0x01, 0x0a, 0x2c, 0x6f, 0x69, 0x64, 0x63, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x6d,
	0x65, 0x74, 0x68, 0x6f, 0x64, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x50, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2e, 0x61, 0x75, 0x74, 0x68, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x4f, 0x69, 0x64, 0x63, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64,
	0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x72,
	0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x42, 0x10, 0xfa, 0xd2, 0xe4, 0x93, 0x02,
	0x0a, 0x12, 0x08, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x48, 0x00, 0x52, 0x27, 0x6f,
	0x69, 0x64, 0x63, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x41, 0x75, 0x74,
	0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x53, 0x74, 0x61, 0x72, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0xcc, 0x01, 0x0a, 0x2f, 0x6f, 0x69, 0x64, 0x63, 0x5f,
	0x61, 0x75, 0x74, 0x68, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x5f, 0x61, 0x75, 0x74, 0x68,
	0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63,
	0x6b, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x53, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70,
	0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x61, 0x75, 0x74, 0x68,
	0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x69, 0x64, 0x63, 0x41,
	0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x42, 0x10, 0xfa, 0xd2, 0xe4, 0x93, 0x02, 0x0a, 0x12, 0x08, 0x49,
	0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x48, 0x00, 0x52, 0x2a, 0x6f, 0x69, 0x64, 0x63, 0x41,
	0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0xc3, 0x01, 0x0a, 0x2c, 0x6f, 0x69, 0x64, 0x63, 0x5f, 0x61,
	0x75, 0x74, 0x68, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x65,
	0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x72, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x50, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x61, 0x75, 0x74, 0x68, 0x6d, 0x65, 0x74, 0x68,
	0x6f, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x69, 0x64, 0x63, 0x41, 0x75, 0x74, 0x68, 0x4d,
	0x65, 0x74, 0x68, 0x6f, 0x64, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x42, 0x10,
	0xfa, 0xd2, 0xe4, 0x93, 0x02, 0x0a, 0x12, 0x08, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c,
	0x48, 0x00, 0x52, 0x27, 0x6f, 0x69, 0x64, 0x63, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68,
	0x6f, 0x64, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x75, 0x0a, 0x13, 0x61,
	0x75, 0x74, 0x68, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2e, 0x61, 0x75, 0x74, 0x68, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x42, 0x10, 0xfa, 0xd2, 0xe4,
	0x93, 0x02, 0x0a, 0x12, 0x08, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x48, 0x00, 0x52,
	0x11, 0x61, 0x75, 0x74, 0x68, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x42, 0x07, 0x0a, 0x05,
	0x61, 0x74, 0x74, 0x72, 0x73, 0x4a, 0x04, 0x08, 0x01, 0x10, 0x02, 0x4a, 0x04, 0x08, 0x02, 0x10,
	0x03, 0x52, 0x04, 0x69, 0x74, 0x65, 0x6d, 0x52, 0x0a, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x32, 0xd2, 0x0e, 0x0a, 0x11, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68,
	0x6f, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xb8, 0x01, 0x0a, 0x0d, 0x47, 0x65,
	0x74, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x30, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x75, 0x74, 0x68,
	0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x75,
	0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x42, 0x92, 0x41, 0x1c, 0x12, 0x1a, 0x47, 0x65, 0x74, 0x73, 0x20, 0x61, 0x20, 0x73, 0x69,
	0x6e, 0x67, 0x6c, 0x65, 0x20, 0x61, 0x75, 0x74, 0x68, 0x20, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64,
	0x2e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1d, 0x62, 0x04, 0x69, 0x74, 0x65, 0x6d, 0x12, 0x15, 0x2f,
	0x76, 0x31, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2d, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x2f,
	0x7b, 0x69, 0x64, 0x7d, 0x12, 0xb0, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x75, 0x74,
	0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x12, 0x32, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65,
	0x74, 0x68, 0x6f, 0x64, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x75,
	0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x34, 0x92, 0x41, 0x19, 0x12, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x73, 0x20, 0x61, 0x6c,
	0x6c, 0x20, 0x61, 0x75, 0x74, 0x68, 0x20, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x2e, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x12, 0x12, 0x10, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2d,
	0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x12, 0xc5, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x33, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x46, 0x92, 0x41, 0x1f, 0x12, 0x1d, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x73, 0x20, 0x61, 0x20, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x20, 0x61,
	0x75, 0x74, 0x68, 0x20, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x2e, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x1e, 0x3a, 0x04, 0x69, 0x74, 0x65, 0x6d, 0x62, 0x04, 0x69, 0x74, 0x65, 0x6d, 0x22, 0x10, 0x2f,
	0x76, 0x31, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2d, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x12,
	0xc4, 0x01, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65,
	0x74, 0x68, 0x6f, 0x64, 0x12, 0x33, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65,
	0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68,
	0x6f, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74,
	0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x45, 0x92, 0x41, 0x19, 0x12, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x73, 0x20, 0x61, 0x6e,
	0x20, 0x61, 0x75, 0x74, 0x68, 0x20, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x2e, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x23, 0x3a, 0x04, 0x69, 0x74, 0x65, 0x6d, 0x62, 0x04, 0x69, 0x74, 0x65, 0x6d, 0x32,
	0x15, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2d, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64,
	0x73, 0x2f, 0x7b, 0x69, 0x64, 0x7d, 0x12, 0xb6, 0x01, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x33, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41,
	0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70,
	0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x37, 0x92, 0x41, 0x17, 0x12, 0x15, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x73, 0x20, 0x61, 0x6e, 0x20, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68,
	0x6f, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x17, 0x2a, 0x15, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x2d, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x2f, 0x7b, 0x69, 0x64, 0x7d, 0x12,
	0xcf, 0x01, 0x0a, 0x0b, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x2e, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2f, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x61, 0x70, 0x69,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x5f, 0x92, 0x41, 0x29, 0x12, 0x27, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x20, 0x74,
	0x68, 0x65, 0x20, 0x73, 0x74, 0x61, 0x74, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x61, 0x6e, 0x20, 0x4f,
	0x49, 0x44, 0x43, 0x20, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x2d, 0x3a, 0x01, 0x2a, 0x62, 0x04, 0x69, 0x74, 0x65, 0x6d, 0x22, 0x22, 0x2f,
	0x76, 0x31, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2d, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x2f,
	0x7b, 0x69, 0x64, 0x7d, 0x3a, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2d, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x12, 0xf7, 0x01, 0x0a, 0x0c, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x12, 0x2f, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e,
	0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72,
	0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x83, 0x01, 0x92, 0x41, 0x47, 0x12, 0x45, 0x41, 0x75, 0x74,
	0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x20, 0x61, 0x20, 0x75, 0x73, 0x65, 0x72,
	0x20, 0x74, 0x6f, 0x20, 0x61, 0x6e, 0x20, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x20, 0x61, 0x6e, 0x64,
	0x20, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x20, 0x61, 0x6e, 0x20, 0x61, 0x75, 0x74,
	0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x2e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x3a, 0x01, 0x2a, 0x22, 0x2e, 0x2f, 0x76, 0x31,
	0x2f, 0x61, 0x75, 0x74, 0x68, 0x2d, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x2f, 0x7b, 0x61,
	0x75, 0x74, 0x68, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x5f, 0x69, 0x64, 0x7d, 0x3a, 0x61,
	0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x1a, 0xba, 0x03, 0x92, 0x41,
	0xb6, 0x03, 0x0a, 0x13, 0x41, 0x75, 0x74, 0x68, 0x20, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x20,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x93, 0x02, 0x54, 0x68, 0x65, 0x20, 0x61, 0x75,
	0x74, 0x68, 0x20, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x20, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x20, 0x65, 0x78, 0x70, 0x6f, 0x73, 0x65, 0x73, 0x20, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x73, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74,
	0x69, 0x6e, 0x67, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x61, 0x75, 0x74, 0x68, 0x20, 0x6d, 0x65,
	0x74, 0x68, 0x6f, 0x64, 0x73, 0x20, 0x69, 0x6e, 0x20, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72,
	0x79, 0x2e, 0x20, 0x41, 0x6e, 0x20, 0x61, 0x75, 0x74, 0x68, 0x20, 0x6d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x20, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x73, 0x20, 0x68, 0x6f, 0x77, 0x20, 0x75, 0x73,
	0x65, 0x72, 0x73, 0x20, 0x63, 0x61, 0x6e, 0x20, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x20, 0x74, 0x68, 0x65, 0x6d, 0x73, 0x65, 0x6c, 0x76, 0x65, 0x73, 0x20,
	0x77, 0x69, 0x74, 0x68, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x79, 0x73, 0x74, 0x65,
	0x6d, 0x2e, 0x20, 0x49, 0x74, 0x20, 0x61, 0x63, 0x74, 0x73, 0x20, 0x61, 0x73, 0x20, 0x61, 0x20,
	0x62, 0x72, 0x69, 0x64, 0x67, 0x65, 0x20, 0x62, 0x65, 0x74, 0x77, 0x65, 0x65, 0x6e, 0x20, 0x42,
	0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x76, 0x61, 0x72, 0x69,
	0x6f, 0x75, 0x73, 0x20, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x20, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x20, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x73, 0x20,
	0x6f, 0x72, 0x20, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x20, 0x6d, 0x65, 0x63, 0x68, 0x61, 0x6e, 0x69, 0x73, 0x6d, 0x73, 0x2e, 0x1a, 0x88, 0x01,
	0x0a, 0x34, 0x52, 0x65, 0x61, 0x64, 0x20, 0x61, 0x62, 0x6f, 0x75, 0x74, 0x20, 0x61, 0x75, 0x74,
	0x68, 0x20, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x20, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e,
	0x20, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x50, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f,
	0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63,
	0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79,
	0x2f, 0x64, 0x6f, 0x63, 0x73, 0x2f, 0x63, 0x6f, 0x6e, 0x63, 0x65, 0x70, 0x74, 0x73, 0x2f, 0x64,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x2d, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2f, 0x61, 0x75, 0x74, 0x68,
	0x2d, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x42, 0x55, 0xa2, 0xe3, 0x29, 0x04, 0x61, 0x75,
	0x74, 0x68, 0x5a, 0x4b, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x68,
	0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72,
	0x79, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2f, 0x67, 0x65, 0x6e, 0x2f, 0x63,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x3b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_controller_api_services_v1_auth_method_service_proto_rawDescOnce sync.Once
	file_controller_api_services_v1_auth_method_service_proto_rawDescData = file_controller_api_services_v1_auth_method_service_proto_rawDesc
)

func file_controller_api_services_v1_auth_method_service_proto_rawDescGZIP() []byte {
	file_controller_api_services_v1_auth_method_service_proto_rawDescOnce.Do(func() {
		file_controller_api_services_v1_auth_method_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_controller_api_services_v1_auth_method_service_proto_rawDescData)
	})
	return file_controller_api_services_v1_auth_method_service_proto_rawDescData
}

var file_controller_api_services_v1_auth_method_service_proto_msgTypes = make([]protoimpl.MessageInfo, 18)
var file_controller_api_services_v1_auth_method_service_proto_goTypes = []any{
	(*GetAuthMethodRequest)(nil),                                   // 0: controller.api.services.v1.GetAuthMethodRequest
	(*GetAuthMethodResponse)(nil),                                  // 1: controller.api.services.v1.GetAuthMethodResponse
	(*ListAuthMethodsRequest)(nil),                                 // 2: controller.api.services.v1.ListAuthMethodsRequest
	(*ListAuthMethodsResponse)(nil),                                // 3: controller.api.services.v1.ListAuthMethodsResponse
	(*CreateAuthMethodRequest)(nil),                                // 4: controller.api.services.v1.CreateAuthMethodRequest
	(*CreateAuthMethodResponse)(nil),                               // 5: controller.api.services.v1.CreateAuthMethodResponse
	(*UpdateAuthMethodRequest)(nil),                                // 6: controller.api.services.v1.UpdateAuthMethodRequest
	(*UpdateAuthMethodResponse)(nil),                               // 7: controller.api.services.v1.UpdateAuthMethodResponse
	(*DeleteAuthMethodRequest)(nil),                                // 8: controller.api.services.v1.DeleteAuthMethodRequest
	(*DeleteAuthMethodResponse)(nil),                               // 9: controller.api.services.v1.DeleteAuthMethodResponse
	(*OidcChangeStateAttributes)(nil),                              // 10: controller.api.services.v1.OidcChangeStateAttributes
	(*ChangeStateRequest)(nil),                                     // 11: controller.api.services.v1.ChangeStateRequest
	(*ChangeStateResponse)(nil),                                    // 12: controller.api.services.v1.ChangeStateResponse
	(*PasswordLoginAttributes)(nil),                                // 13: controller.api.services.v1.PasswordLoginAttributes
	(*OidcStartAttributes)(nil),                                    // 14: controller.api.services.v1.OidcStartAttributes
	(*LdapLoginAttributes)(nil),                                    // 15: controller.api.services.v1.LdapLoginAttributes
	(*AuthenticateRequest)(nil),                                    // 16: controller.api.services.v1.AuthenticateRequest
	(*AuthenticateResponse)(nil),                                   // 17: controller.api.services.v1.AuthenticateResponse
	(*authmethods.AuthMethod)(nil),                                 // 18: controller.api.resources.authmethods.v1.AuthMethod
	(*fieldmaskpb.FieldMask)(nil),                                  // 19: google.protobuf.FieldMask
	(*structpb.Struct)(nil),                                        // 20: google.protobuf.Struct
	(*authmethods.OidcAuthMethodAuthenticateCallbackRequest)(nil),  // 21: controller.api.resources.authmethods.v1.OidcAuthMethodAuthenticateCallbackRequest
	(*authmethods.OidcAuthMethodAuthenticateTokenRequest)(nil),     // 22: controller.api.resources.authmethods.v1.OidcAuthMethodAuthenticateTokenRequest
	(*authmethods.OidcAuthMethodAuthenticateStartResponse)(nil),    // 23: controller.api.resources.authmethods.v1.OidcAuthMethodAuthenticateStartResponse
	(*authmethods.OidcAuthMethodAuthenticateCallbackResponse)(nil), // 24: controller.api.resources.authmethods.v1.OidcAuthMethodAuthenticateCallbackResponse
	(*authmethods.OidcAuthMethodAuthenticateTokenResponse)(nil),    // 25: controller.api.resources.authmethods.v1.OidcAuthMethodAuthenticateTokenResponse
	(*authtokens.AuthToken)(nil),                                   // 26: controller.api.resources.authtokens.v1.AuthToken
}
var file_controller_api_services_v1_auth_method_service_proto_depIdxs = []int32{
	18, // 0: controller.api.services.v1.GetAuthMethodResponse.item:type_name -> controller.api.resources.authmethods.v1.AuthMethod
	18, // 1: controller.api.services.v1.ListAuthMethodsResponse.items:type_name -> controller.api.resources.authmethods.v1.AuthMethod
	18, // 2: controller.api.services.v1.CreateAuthMethodRequest.item:type_name -> controller.api.resources.authmethods.v1.AuthMethod
	18, // 3: controller.api.services.v1.CreateAuthMethodResponse.item:type_name -> controller.api.resources.authmethods.v1.AuthMethod
	18, // 4: controller.api.services.v1.UpdateAuthMethodRequest.item:type_name -> controller.api.resources.authmethods.v1.AuthMethod
	19, // 5: controller.api.services.v1.UpdateAuthMethodRequest.update_mask:type_name -> google.protobuf.FieldMask
	18, // 6: controller.api.services.v1.UpdateAuthMethodResponse.item:type_name -> controller.api.resources.authmethods.v1.AuthMethod
	20, // 7: controller.api.services.v1.ChangeStateRequest.attributes:type_name -> google.protobuf.Struct
	10, // 8: controller.api.services.v1.ChangeStateRequest.oidc_change_state_attributes:type_name -> controller.api.services.v1.OidcChangeStateAttributes
	18, // 9: controller.api.services.v1.ChangeStateResponse.item:type_name -> controller.api.resources.authmethods.v1.AuthMethod
	20, // 10: controller.api.services.v1.OidcStartAttributes.roundtrip_payload:type_name -> google.protobuf.Struct
	20, // 11: controller.api.services.v1.AuthenticateRequest.attributes:type_name -> google.protobuf.Struct
	13, // 12: controller.api.services.v1.AuthenticateRequest.password_login_attributes:type_name -> controller.api.services.v1.PasswordLoginAttributes
	14, // 13: controller.api.services.v1.AuthenticateRequest.oidc_start_attributes:type_name -> controller.api.services.v1.OidcStartAttributes
	21, // 14: controller.api.services.v1.AuthenticateRequest.oidc_auth_method_authenticate_callback_request:type_name -> controller.api.resources.authmethods.v1.OidcAuthMethodAuthenticateCallbackRequest
	22, // 15: controller.api.services.v1.AuthenticateRequest.oidc_auth_method_authenticate_token_request:type_name -> controller.api.resources.authmethods.v1.OidcAuthMethodAuthenticateTokenRequest
	15, // 16: controller.api.services.v1.AuthenticateRequest.ldap_login_attributes:type_name -> controller.api.services.v1.LdapLoginAttributes
	20, // 17: controller.api.services.v1.AuthenticateResponse.attributes:type_name -> google.protobuf.Struct
	23, // 18: controller.api.services.v1.AuthenticateResponse.oidc_auth_method_authenticate_start_response:type_name -> controller.api.resources.authmethods.v1.OidcAuthMethodAuthenticateStartResponse
	24, // 19: controller.api.services.v1.AuthenticateResponse.oidc_auth_method_authenticate_callback_response:type_name -> controller.api.resources.authmethods.v1.OidcAuthMethodAuthenticateCallbackResponse
	25, // 20: controller.api.services.v1.AuthenticateResponse.oidc_auth_method_authenticate_token_response:type_name -> controller.api.resources.authmethods.v1.OidcAuthMethodAuthenticateTokenResponse
	26, // 21: controller.api.services.v1.AuthenticateResponse.auth_token_response:type_name -> controller.api.resources.authtokens.v1.AuthToken
	0,  // 22: controller.api.services.v1.AuthMethodService.GetAuthMethod:input_type -> controller.api.services.v1.GetAuthMethodRequest
	2,  // 23: controller.api.services.v1.AuthMethodService.ListAuthMethods:input_type -> controller.api.services.v1.ListAuthMethodsRequest
	4,  // 24: controller.api.services.v1.AuthMethodService.CreateAuthMethod:input_type -> controller.api.services.v1.CreateAuthMethodRequest
	6,  // 25: controller.api.services.v1.AuthMethodService.UpdateAuthMethod:input_type -> controller.api.services.v1.UpdateAuthMethodRequest
	8,  // 26: controller.api.services.v1.AuthMethodService.DeleteAuthMethod:input_type -> controller.api.services.v1.DeleteAuthMethodRequest
	11, // 27: controller.api.services.v1.AuthMethodService.ChangeState:input_type -> controller.api.services.v1.ChangeStateRequest
	16, // 28: controller.api.services.v1.AuthMethodService.Authenticate:input_type -> controller.api.services.v1.AuthenticateRequest
	1,  // 29: controller.api.services.v1.AuthMethodService.GetAuthMethod:output_type -> controller.api.services.v1.GetAuthMethodResponse
	3,  // 30: controller.api.services.v1.AuthMethodService.ListAuthMethods:output_type -> controller.api.services.v1.ListAuthMethodsResponse
	5,  // 31: controller.api.services.v1.AuthMethodService.CreateAuthMethod:output_type -> controller.api.services.v1.CreateAuthMethodResponse
	7,  // 32: controller.api.services.v1.AuthMethodService.UpdateAuthMethod:output_type -> controller.api.services.v1.UpdateAuthMethodResponse
	9,  // 33: controller.api.services.v1.AuthMethodService.DeleteAuthMethod:output_type -> controller.api.services.v1.DeleteAuthMethodResponse
	12, // 34: controller.api.services.v1.AuthMethodService.ChangeState:output_type -> controller.api.services.v1.ChangeStateResponse
	17, // 35: controller.api.services.v1.AuthMethodService.Authenticate:output_type -> controller.api.services.v1.AuthenticateResponse
	29, // [29:36] is the sub-list for method output_type
	22, // [22:29] is the sub-list for method input_type
	22, // [22:22] is the sub-list for extension type_name
	22, // [22:22] is the sub-list for extension extendee
	0,  // [0:22] is the sub-list for field type_name
}

func init() { file_controller_api_services_v1_auth_method_service_proto_init() }
func file_controller_api_services_v1_auth_method_service_proto_init() {
	if File_controller_api_services_v1_auth_method_service_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_controller_api_services_v1_auth_method_service_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*GetAuthMethodRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_services_v1_auth_method_service_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*GetAuthMethodResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_services_v1_auth_method_service_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*ListAuthMethodsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_services_v1_auth_method_service_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*ListAuthMethodsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_services_v1_auth_method_service_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*CreateAuthMethodRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_services_v1_auth_method_service_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*CreateAuthMethodResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_services_v1_auth_method_service_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateAuthMethodRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_services_v1_auth_method_service_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateAuthMethodResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_services_v1_auth_method_service_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*DeleteAuthMethodRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_services_v1_auth_method_service_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*DeleteAuthMethodResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_services_v1_auth_method_service_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*OidcChangeStateAttributes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_services_v1_auth_method_service_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*ChangeStateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_services_v1_auth_method_service_proto_msgTypes[12].Exporter = func(v any, i int) any {
			switch v := v.(*ChangeStateResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_services_v1_auth_method_service_proto_msgTypes[13].Exporter = func(v any, i int) any {
			switch v := v.(*PasswordLoginAttributes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_services_v1_auth_method_service_proto_msgTypes[14].Exporter = func(v any, i int) any {
			switch v := v.(*OidcStartAttributes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_services_v1_auth_method_service_proto_msgTypes[15].Exporter = func(v any, i int) any {
			switch v := v.(*LdapLoginAttributes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_services_v1_auth_method_service_proto_msgTypes[16].Exporter = func(v any, i int) any {
			switch v := v.(*AuthenticateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_api_services_v1_auth_method_service_proto_msgTypes[17].Exporter = func(v any, i int) any {
			switch v := v.(*AuthenticateResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_controller_api_services_v1_auth_method_service_proto_msgTypes[11].OneofWrappers = []any{
		(*ChangeStateRequest_Attributes)(nil),
		(*ChangeStateRequest_OidcChangeStateAttributes)(nil),
	}
	file_controller_api_services_v1_auth_method_service_proto_msgTypes[16].OneofWrappers = []any{
		(*AuthenticateRequest_Attributes)(nil),
		(*AuthenticateRequest_PasswordLoginAttributes)(nil),
		(*AuthenticateRequest_OidcStartAttributes)(nil),
		(*AuthenticateRequest_OidcAuthMethodAuthenticateCallbackRequest)(nil),
		(*AuthenticateRequest_OidcAuthMethodAuthenticateTokenRequest)(nil),
		(*AuthenticateRequest_LdapLoginAttributes)(nil),
	}
	file_controller_api_services_v1_auth_method_service_proto_msgTypes[17].OneofWrappers = []any{
		(*AuthenticateResponse_Attributes)(nil),
		(*AuthenticateResponse_OidcAuthMethodAuthenticateStartResponse)(nil),
		(*AuthenticateResponse_OidcAuthMethodAuthenticateCallbackResponse)(nil),
		(*AuthenticateResponse_OidcAuthMethodAuthenticateTokenResponse)(nil),
		(*AuthenticateResponse_AuthTokenResponse)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_controller_api_services_v1_auth_method_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   18,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_controller_api_services_v1_auth_method_service_proto_goTypes,
		DependencyIndexes: file_controller_api_services_v1_auth_method_service_proto_depIdxs,
		MessageInfos:      file_controller_api_services_v1_auth_method_service_proto_msgTypes,
	}.Build()
	File_controller_api_services_v1_auth_method_service_proto = out.File
	file_controller_api_services_v1_auth_method_service_proto_rawDesc = nil
	file_controller_api_services_v1_auth_method_service_proto_goTypes = nil
	file_controller_api_services_v1_auth_method_service_proto_depIdxs = nil
}
