// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: BUSL-1.1

package schema

import "github.com/hashicorp/boundary/internal/db/schema/migration"

// RepairMigrations is a set of migration versions grouped by edition that
// should have their coresponding repair functions run if the check function
// reports an error.
type RepairMigrations map[string]map[int]bool

// IsSet checks for the existence of the given edition and version.
func (r RepairMigrations) IsSet(edition string, version int) bool {
	e, ok := r[edition]
	if !ok {
		return false
	}

	_, ok = e[version]
	return ok
}

// Add adds the edition and version to the set.
func (r RepairMigrations) Add(edition string, version int) {
	e, ok := r[edition]
	if !ok {
		e = make(map[int]bool)
	}
	e[version] = true
	r[edition] = e
}

// RepairLog represents a log entry generated by a repair function.
type RepairLog struct {
	Edition string
	Version int
	Entry   migration.Repairs
}
