// Code generated by "make cli"; DO NOT EDIT.
// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: BUSL-1.1

package targetscmd

import (
	"errors"
	"fmt"

	"github.com/hashicorp/boundary/api"
	"github.com/hashicorp/boundary/api/targets"
	"github.com/hashicorp/boundary/internal/cmd/base"
	"github.com/hashicorp/boundary/internal/cmd/common"
	"github.com/hashicorp/go-secure-stdlib/strutil"
	"github.com/mitchellh/cli"
	"github.com/posener/complete"
)

func initTcpFlags() {
	flagsOnce.Do(func() {
		extraFlags := extraTcpActionsFlagsMapFunc()
		for k, v := range extraFlags {
			flagsTcpMap[k] = append(flagsTcpMap[k], v...)
		}
	})
}

var (
	_ cli.Command             = (*TcpCommand)(nil)
	_ cli.CommandAutocomplete = (*TcpCommand)(nil)
)

type TcpCommand struct {
	*base.Command

	Func string

	plural string

	extraTcpCmdVars
}

func (c *TcpCommand) AutocompleteArgs() complete.Predictor {
	initTcpFlags()
	return complete.PredictAnything
}

func (c *TcpCommand) AutocompleteFlags() complete.Flags {
	initTcpFlags()
	return c.Flags().Completions()
}

func (c *TcpCommand) Synopsis() string {
	if extra := extraTcpSynopsisFunc(c); extra != "" {
		return extra
	}

	synopsisStr := "target"

	synopsisStr = fmt.Sprintf("%s %s", "tcp-type", synopsisStr)

	return common.SynopsisFunc(c.Func, synopsisStr)
}

func (c *TcpCommand) Help() string {
	initTcpFlags()

	var helpStr string
	helpMap := common.HelpMap("target")

	switch c.Func {

	default:

		helpStr = c.extraTcpHelpFunc(helpMap)

	}

	// Keep linter from complaining if we don't actually generate code using it
	_ = helpMap
	return helpStr
}

var flagsTcpMap = map[string][]string{

	"create": {"scope-id", "name", "description"},

	"update": {"id", "name", "description", "version"},
}

func (c *TcpCommand) Flags() *base.FlagSets {
	if len(flagsTcpMap[c.Func]) == 0 {
		return c.FlagSet(base.FlagSetNone)
	}

	set := c.FlagSet(base.FlagSetHTTP | base.FlagSetClient | base.FlagSetOutputFormat)
	f := set.NewFlagSet("Command Options")
	common.PopulateCommonFlags(c.Command, f, "tcp-type target", flagsTcpMap, c.Func)

	extraTcpFlagsFunc(c, set, f)

	return set
}

func (c *TcpCommand) Run(args []string) int {
	initTcpFlags()

	switch c.Func {
	case "":
		return cli.RunResultHelp

	}

	c.plural = "tcp-type target"
	switch c.Func {
	case "list":
		c.plural = "tcp-type targets"
	}

	f := c.Flags()

	var alias string
	alias, args = base.ExtractAliasFromArgs(args)

	if alias != "" {
		if c.FlagId != "" {
			c.PrintCliError(errors.New("Cannot specify both an alias and id; choose one or the other"))
			return base.CommandUserError
		}
		c.FlagId = alias
	}

	if err := f.Parse(args); err != nil {
		c.PrintCliError(err)
		return base.CommandUserError
	}

	if strutil.StrListContains(flagsTcpMap[c.Func], "id") && c.FlagId == "" {
		c.PrintCliError(errors.New("ID is required but not passed in via -id"))
		return base.CommandUserError
	}

	var opts []targets.Option

	if strutil.StrListContains(flagsTcpMap[c.Func], "scope-id") {
		switch c.Func {

		case "create":
			if c.FlagScopeId == "" {
				c.PrintCliError(errors.New("Scope ID must be passed in via -scope-id or BOUNDARY_SCOPE_ID"))
				return base.CommandUserError
			}

		}
	}

	client, err := c.Client()
	if c.WrapperCleanupFunc != nil {
		defer func() {
			if err := c.WrapperCleanupFunc(); err != nil {
				c.PrintCliError(fmt.Errorf("Error cleaning kms wrapper: %w", err))
			}
		}()
	}
	if err != nil {
		c.PrintCliError(fmt.Errorf("Error creating API client: %w", err))
		return base.CommandCliError
	}
	targetsClient := targets.NewClient(client)

	switch c.FlagName {
	case "":
	case "null":
		opts = append(opts, targets.DefaultName())
	default:
		opts = append(opts, targets.WithName(c.FlagName))
	}

	switch c.FlagDescription {
	case "":
	case "null":
		opts = append(opts, targets.DefaultDescription())
	default:
		opts = append(opts, targets.WithDescription(c.FlagDescription))
	}

	switch c.FlagRecursive {
	case true:
		opts = append(opts, targets.WithRecursive(true))
	}

	if c.FlagFilter != "" {
		opts = append(opts, targets.WithFilter(c.FlagFilter))
	}

	var version uint32

	switch c.Func {

	case "update":
		switch c.FlagVersion {
		case 0:
			opts = append(opts, targets.WithAutomaticVersioning(true))
		default:
			version = uint32(c.FlagVersion)
		}

	}

	if ok := extraTcpFlagsHandlingFunc(c, f, &opts); !ok {
		return base.CommandUserError
	}

	var resp *api.Response
	var item *targets.Target

	var createResult *targets.TargetCreateResult

	var updateResult *targets.TargetUpdateResult

	switch c.Func {

	case "create":
		createResult, err = targetsClient.Create(c.Context, "tcp", c.FlagScopeId, opts...)
		if exitCode := c.checkFuncError(err); exitCode > 0 {
			return exitCode
		}
		resp = createResult.GetResponse()
		item = createResult.GetItem()

	case "update":
		updateResult, err = targetsClient.Update(c.Context, c.FlagId, version, opts...)
		if exitCode := c.checkFuncError(err); exitCode > 0 {
			return exitCode
		}
		resp = updateResult.GetResponse()
		item = updateResult.GetItem()

	}

	resp, item, err = executeExtraTcpActions(c, resp, item, err, targetsClient, version, opts)
	if exitCode := c.checkFuncError(err); exitCode > 0 {
		return exitCode
	}

	output, err := printCustomTcpActionOutput(c)
	if err != nil {
		c.PrintCliError(err)
		return base.CommandUserError
	}
	if output {
		return base.CommandSuccess
	}

	switch c.Func {

	}

	switch base.Format(c.UI) {
	case "table":
		c.UI.Output(printItemTable(item, resp))

	case "json":
		if ok := c.PrintJsonItem(resp); !ok {
			return base.CommandCliError
		}
	}

	return base.CommandSuccess
}

func (c *TcpCommand) checkFuncError(err error) int {
	if err == nil {
		return 0
	}
	if apiErr := api.AsServerError(err); apiErr != nil {
		c.PrintApiError(apiErr, fmt.Sprintf("Error from controller when performing %s on %s", c.Func, c.plural))
		return base.CommandApiError
	}
	c.PrintCliError(fmt.Errorf("Error trying to %s %s: %s", c.Func, c.plural, err.Error()))
	return base.CommandCliError
}

var (
	extraTcpActionsFlagsMapFunc = func() map[string][]string { return nil }
	extraTcpSynopsisFunc        = func(*TcpCommand) string { return "" }
	extraTcpFlagsFunc           = func(*TcpCommand, *base.FlagSets, *base.FlagSet) {}
	extraTcpFlagsHandlingFunc   = func(*TcpCommand, *base.FlagSets, *[]targets.Option) bool { return true }
	executeExtraTcpActions      = func(_ *TcpCommand, inResp *api.Response, inItem *targets.Target, inErr error, _ *targets.Client, _ uint32, _ []targets.Option) (*api.Response, *targets.Target, error) {
		return inResp, inItem, inErr
	}
	printCustomTcpActionOutput = func(*TcpCommand) (bool, error) { return false, nil }
)
