// Code generated by "make cli"; DO NOT EDIT.
// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: BUSL-1.1

package policiescmd

import (
	"errors"
	"fmt"

	"github.com/hashicorp/boundary/api"
	"github.com/hashicorp/boundary/api/policies"
	"github.com/hashicorp/boundary/internal/cmd/base"
	"github.com/hashicorp/boundary/internal/cmd/common"
	"github.com/hashicorp/go-secure-stdlib/strutil"
	"github.com/mitchellh/cli"
	"github.com/posener/complete"
)

func initStorageFlags() {
	flagsOnce.Do(func() {
		extraFlags := extraStorageActionsFlagsMapFunc()
		for k, v := range extraFlags {
			flagsStorageMap[k] = append(flagsStorageMap[k], v...)
		}
	})
}

var (
	_ cli.Command             = (*StorageCommand)(nil)
	_ cli.CommandAutocomplete = (*StorageCommand)(nil)
)

type StorageCommand struct {
	*base.Command

	Func string

	plural string

	extraStorageCmdVars
}

func (c *StorageCommand) AutocompleteArgs() complete.Predictor {
	initStorageFlags()
	return complete.PredictAnything
}

func (c *StorageCommand) AutocompleteFlags() complete.Flags {
	initStorageFlags()
	return c.Flags().Completions()
}

func (c *StorageCommand) Synopsis() string {
	if extra := extraStorageSynopsisFunc(c); extra != "" {
		return extra
	}

	synopsisStr := "policy"

	synopsisStr = fmt.Sprintf("%s %s", "storage-type", synopsisStr)

	return common.SynopsisFunc(c.Func, synopsisStr)
}

func (c *StorageCommand) Help() string {
	initStorageFlags()

	var helpStr string
	helpMap := common.HelpMap("policy")

	switch c.Func {

	default:

		helpStr = c.extraStorageHelpFunc(helpMap)

	}

	// Keep linter from complaining if we don't actually generate code using it
	_ = helpMap
	return helpStr
}

var flagsStorageMap = map[string][]string{

	"create": {"scope-id", "name", "description"},

	"update": {"id", "name", "description", "version"},
}

func (c *StorageCommand) Flags() *base.FlagSets {
	if len(flagsStorageMap[c.Func]) == 0 {
		return c.FlagSet(base.FlagSetNone)
	}

	set := c.FlagSet(base.FlagSetHTTP | base.FlagSetClient | base.FlagSetOutputFormat)
	f := set.NewFlagSet("Command Options")
	common.PopulateCommonFlags(c.Command, f, "storage-type policy", flagsStorageMap, c.Func)

	extraStorageFlagsFunc(c, set, f)

	return set
}

func (c *StorageCommand) Run(args []string) int {
	initStorageFlags()

	switch c.Func {
	case "":
		return cli.RunResultHelp

	}

	c.plural = "storage-type policy"
	switch c.Func {
	case "list":
		c.plural = "storage-type policies"
	}

	f := c.Flags()

	if err := f.Parse(args); err != nil {
		c.PrintCliError(err)
		return base.CommandUserError
	}

	if strutil.StrListContains(flagsStorageMap[c.Func], "id") && c.FlagId == "" {
		c.PrintCliError(errors.New("ID is required but not passed in via -id"))
		return base.CommandUserError
	}

	var opts []policies.Option

	if strutil.StrListContains(flagsStorageMap[c.Func], "scope-id") {
		switch c.Func {

		case "create":
			if c.FlagScopeId == "" {
				c.PrintCliError(errors.New("Scope ID must be passed in via -scope-id or BOUNDARY_SCOPE_ID"))
				return base.CommandUserError
			}

		}
	}

	client, err := c.Client()
	if c.WrapperCleanupFunc != nil {
		defer func() {
			if err := c.WrapperCleanupFunc(); err != nil {
				c.PrintCliError(fmt.Errorf("Error cleaning kms wrapper: %w", err))
			}
		}()
	}
	if err != nil {
		c.PrintCliError(fmt.Errorf("Error creating API client: %w", err))
		return base.CommandCliError
	}
	policiesClient := policies.NewClient(client)

	switch c.FlagName {
	case "":
	case "null":
		opts = append(opts, policies.DefaultName())
	default:
		opts = append(opts, policies.WithName(c.FlagName))
	}

	switch c.FlagDescription {
	case "":
	case "null":
		opts = append(opts, policies.DefaultDescription())
	default:
		opts = append(opts, policies.WithDescription(c.FlagDescription))
	}

	switch c.FlagRecursive {
	case true:
		opts = append(opts, policies.WithRecursive(true))
	}

	if c.FlagFilter != "" {
		opts = append(opts, policies.WithFilter(c.FlagFilter))
	}

	var version uint32

	switch c.Func {

	case "update":
		switch c.FlagVersion {
		case 0:
			opts = append(opts, policies.WithAutomaticVersioning(true))
		default:
			version = uint32(c.FlagVersion)
		}

	}

	if ok := extraStorageFlagsHandlingFunc(c, f, &opts); !ok {
		return base.CommandUserError
	}

	var resp *api.Response
	var item *policies.Policy

	var createResult *policies.PolicyCreateResult

	var updateResult *policies.PolicyUpdateResult

	switch c.Func {

	case "create":
		createResult, err = policiesClient.Create(c.Context, "storage", c.FlagScopeId, opts...)
		if exitCode := c.checkFuncError(err); exitCode > 0 {
			return exitCode
		}
		resp = createResult.GetResponse()
		item = createResult.GetItem()

	case "update":
		updateResult, err = policiesClient.Update(c.Context, c.FlagId, version, opts...)
		if exitCode := c.checkFuncError(err); exitCode > 0 {
			return exitCode
		}
		resp = updateResult.GetResponse()
		item = updateResult.GetItem()

	}

	resp, item, err = executeExtraStorageActions(c, resp, item, err, policiesClient, version, opts)
	if exitCode := c.checkFuncError(err); exitCode > 0 {
		return exitCode
	}

	output, err := printCustomStorageActionOutput(c)
	if err != nil {
		c.PrintCliError(err)
		return base.CommandUserError
	}
	if output {
		return base.CommandSuccess
	}

	switch c.Func {

	}

	switch base.Format(c.UI) {
	case "table":
		c.UI.Output(printItemTable(item, resp))

	case "json":
		if ok := c.PrintJsonItem(resp); !ok {
			return base.CommandCliError
		}
	}

	return base.CommandSuccess
}

func (c *StorageCommand) checkFuncError(err error) int {
	if err == nil {
		return 0
	}
	if apiErr := api.AsServerError(err); apiErr != nil {
		c.PrintApiError(apiErr, fmt.Sprintf("Error from controller when performing %s on %s", c.Func, c.plural))
		return base.CommandApiError
	}
	c.PrintCliError(fmt.Errorf("Error trying to %s %s: %s", c.Func, c.plural, err.Error()))
	return base.CommandCliError
}

var (
	extraStorageActionsFlagsMapFunc = func() map[string][]string { return nil }
	extraStorageSynopsisFunc        = func(*StorageCommand) string { return "" }
	extraStorageFlagsFunc           = func(*StorageCommand, *base.FlagSets, *base.FlagSet) {}
	extraStorageFlagsHandlingFunc   = func(*StorageCommand, *base.FlagSets, *[]policies.Option) bool { return true }
	executeExtraStorageActions      = func(_ *StorageCommand, inResp *api.Response, inItem *policies.Policy, inErr error, _ *policies.Client, _ uint32, _ []policies.Option) (*api.Response, *policies.Policy, error) {
		return inResp, inItem, inErr
	}
	printCustomStorageActionOutput = func(*StorageCommand) (bool, error) { return false, nil }
)
