// Code generated by "make cli"; DO NOT EDIT.
// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: BUSL-1.1

package managedgroupscmd

import (
	"errors"
	"fmt"

	"github.com/hashicorp/boundary/api"
	"github.com/hashicorp/boundary/api/managedgroups"
	"github.com/hashicorp/boundary/internal/cmd/base"
	"github.com/hashicorp/boundary/internal/cmd/common"
	"github.com/hashicorp/go-secure-stdlib/strutil"
	"github.com/mitchellh/cli"
	"github.com/posener/complete"
)

func initOidcFlags() {
	flagsOnce.Do(func() {
		extraFlags := extraOidcActionsFlagsMapFunc()
		for k, v := range extraFlags {
			flagsOidcMap[k] = append(flagsOidcMap[k], v...)
		}
	})
}

var (
	_ cli.Command             = (*OidcCommand)(nil)
	_ cli.CommandAutocomplete = (*OidcCommand)(nil)
)

type OidcCommand struct {
	*base.Command

	Func string

	plural string

	extraOidcCmdVars
}

func (c *OidcCommand) AutocompleteArgs() complete.Predictor {
	initOidcFlags()
	return complete.PredictAnything
}

func (c *OidcCommand) AutocompleteFlags() complete.Flags {
	initOidcFlags()
	return c.Flags().Completions()
}

func (c *OidcCommand) Synopsis() string {
	if extra := extraOidcSynopsisFunc(c); extra != "" {
		return extra
	}

	synopsisStr := "managed-group"

	synopsisStr = fmt.Sprintf("%s %s", "oidc-type", synopsisStr)

	return common.SynopsisFunc(c.Func, synopsisStr)
}

func (c *OidcCommand) Help() string {
	initOidcFlags()

	var helpStr string
	helpMap := common.HelpMap("managed group")

	switch c.Func {

	default:

		helpStr = c.extraOidcHelpFunc(helpMap)

	}

	// Keep linter from complaining if we don't actually generate code using it
	_ = helpMap
	return helpStr
}

var flagsOidcMap = map[string][]string{

	"create": {"auth-method-id", "name", "description"},

	"update": {"id", "name", "description", "version"},
}

func (c *OidcCommand) Flags() *base.FlagSets {
	if len(flagsOidcMap[c.Func]) == 0 {
		return c.FlagSet(base.FlagSetNone)
	}

	set := c.FlagSet(base.FlagSetHTTP | base.FlagSetClient | base.FlagSetOutputFormat)
	f := set.NewFlagSet("Command Options")
	common.PopulateCommonFlags(c.Command, f, "oidc-type managed group", flagsOidcMap, c.Func)

	extraOidcFlagsFunc(c, set, f)

	return set
}

func (c *OidcCommand) Run(args []string) int {
	initOidcFlags()

	switch c.Func {
	case "":
		return cli.RunResultHelp

	}

	c.plural = "oidc-type managed group"
	switch c.Func {
	case "list":
		c.plural = "oidc-type managed groups"
	}

	f := c.Flags()

	if err := f.Parse(args); err != nil {
		c.PrintCliError(err)
		return base.CommandUserError
	}

	if strutil.StrListContains(flagsOidcMap[c.Func], "id") && c.FlagId == "" {
		c.PrintCliError(errors.New("ID is required but not passed in via -id"))
		return base.CommandUserError
	}

	var opts []managedgroups.Option

	if strutil.StrListContains(flagsOidcMap[c.Func], "auth-method-id") {
		switch c.Func {

		case "create":
			if c.FlagAuthMethodId == "" {
				c.PrintCliError(errors.New("AuthMethod ID must be passed in via -auth-method-id or BOUNDARY_AUTH_METHOD_ID"))
				return base.CommandUserError
			}

		}
	}

	client, err := c.Client()
	if c.WrapperCleanupFunc != nil {
		defer func() {
			if err := c.WrapperCleanupFunc(); err != nil {
				c.PrintCliError(fmt.Errorf("Error cleaning kms wrapper: %w", err))
			}
		}()
	}
	if err != nil {
		c.PrintCliError(fmt.Errorf("Error creating API client: %w", err))
		return base.CommandCliError
	}
	managedgroupsClient := managedgroups.NewClient(client)

	switch c.FlagName {
	case "":
	case "null":
		opts = append(opts, managedgroups.DefaultName())
	default:
		opts = append(opts, managedgroups.WithName(c.FlagName))
	}

	switch c.FlagDescription {
	case "":
	case "null":
		opts = append(opts, managedgroups.DefaultDescription())
	default:
		opts = append(opts, managedgroups.WithDescription(c.FlagDescription))
	}

	if c.FlagFilter != "" {
		opts = append(opts, managedgroups.WithFilter(c.FlagFilter))
	}

	var version uint32

	switch c.Func {

	case "update":
		switch c.FlagVersion {
		case 0:
			opts = append(opts, managedgroups.WithAutomaticVersioning(true))
		default:
			version = uint32(c.FlagVersion)
		}

	}

	if ok := extraOidcFlagsHandlingFunc(c, f, &opts); !ok {
		return base.CommandUserError
	}

	var resp *api.Response
	var item *managedgroups.ManagedGroup

	var createResult *managedgroups.ManagedGroupCreateResult

	var updateResult *managedgroups.ManagedGroupUpdateResult

	switch c.Func {

	case "create":
		createResult, err = managedgroupsClient.Create(c.Context, c.FlagAuthMethodId, opts...)
		if exitCode := c.checkFuncError(err); exitCode > 0 {
			return exitCode
		}
		resp = createResult.GetResponse()
		item = createResult.GetItem()

	case "update":
		updateResult, err = managedgroupsClient.Update(c.Context, c.FlagId, version, opts...)
		if exitCode := c.checkFuncError(err); exitCode > 0 {
			return exitCode
		}
		resp = updateResult.GetResponse()
		item = updateResult.GetItem()

	}

	resp, item, err = executeExtraOidcActions(c, resp, item, err, managedgroupsClient, version, opts)
	if exitCode := c.checkFuncError(err); exitCode > 0 {
		return exitCode
	}

	output, err := printCustomOidcActionOutput(c)
	if err != nil {
		c.PrintCliError(err)
		return base.CommandUserError
	}
	if output {
		return base.CommandSuccess
	}

	switch c.Func {

	}

	switch base.Format(c.UI) {
	case "table":
		c.UI.Output(printItemTable(item, resp))

	case "json":
		if ok := c.PrintJsonItem(resp); !ok {
			return base.CommandCliError
		}
	}

	return base.CommandSuccess
}

func (c *OidcCommand) checkFuncError(err error) int {
	if err == nil {
		return 0
	}
	if apiErr := api.AsServerError(err); apiErr != nil {
		c.PrintApiError(apiErr, fmt.Sprintf("Error from controller when performing %s on %s", c.Func, c.plural))
		return base.CommandApiError
	}
	c.PrintCliError(fmt.Errorf("Error trying to %s %s: %s", c.Func, c.plural, err.Error()))
	return base.CommandCliError
}

var (
	extraOidcActionsFlagsMapFunc = func() map[string][]string { return nil }
	extraOidcSynopsisFunc        = func(*OidcCommand) string { return "" }
	extraOidcFlagsFunc           = func(*OidcCommand, *base.FlagSets, *base.FlagSet) {}
	extraOidcFlagsHandlingFunc   = func(*OidcCommand, *base.FlagSets, *[]managedgroups.Option) bool { return true }
	executeExtraOidcActions      = func(_ *OidcCommand, inResp *api.Response, inItem *managedgroups.ManagedGroup, inErr error, _ *managedgroups.Client, _ uint32, _ []managedgroups.Option) (*api.Response, *managedgroups.ManagedGroup, error) {
		return inResp, inItem, inErr
	}
	printCustomOidcActionOutput = func(*OidcCommand) (bool, error) { return false, nil }
)
