// Code generated by "make cli"; DO NOT EDIT.
// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: BUSL-1.1

package credentialscmd

import (
	"errors"
	"fmt"

	"github.com/hashicorp/boundary/api"
	"github.com/hashicorp/boundary/api/credentials"
	"github.com/hashicorp/boundary/internal/cmd/base"
	"github.com/hashicorp/boundary/internal/cmd/common"
	"github.com/hashicorp/go-secure-stdlib/strutil"
	"github.com/mitchellh/cli"
	"github.com/posener/complete"
)

func initUsernamePasswordFlags() {
	flagsOnce.Do(func() {
		extraFlags := extraUsernamePasswordActionsFlagsMapFunc()
		for k, v := range extraFlags {
			flagsUsernamePasswordMap[k] = append(flagsUsernamePasswordMap[k], v...)
		}
	})
}

var (
	_ cli.Command             = (*UsernamePasswordCommand)(nil)
	_ cli.CommandAutocomplete = (*UsernamePasswordCommand)(nil)
)

type UsernamePasswordCommand struct {
	*base.Command

	Func string

	plural string

	extraUsernamePasswordCmdVars
}

func (c *UsernamePasswordCommand) AutocompleteArgs() complete.Predictor {
	initUsernamePasswordFlags()
	return complete.PredictAnything
}

func (c *UsernamePasswordCommand) AutocompleteFlags() complete.Flags {
	initUsernamePasswordFlags()
	return c.Flags().Completions()
}

func (c *UsernamePasswordCommand) Synopsis() string {
	if extra := extraUsernamePasswordSynopsisFunc(c); extra != "" {
		return extra
	}

	synopsisStr := "credential"

	synopsisStr = fmt.Sprintf("%s %s", "username-password-type", synopsisStr)

	return common.SynopsisFunc(c.Func, synopsisStr)
}

func (c *UsernamePasswordCommand) Help() string {
	initUsernamePasswordFlags()

	var helpStr string
	helpMap := common.HelpMap("credential")

	switch c.Func {

	default:

		helpStr = c.extraUsernamePasswordHelpFunc(helpMap)

	}

	// Keep linter from complaining if we don't actually generate code using it
	_ = helpMap
	return helpStr
}

var flagsUsernamePasswordMap = map[string][]string{

	"create": {"credential-store-id", "name", "description"},

	"update": {"id", "name", "description", "version"},
}

func (c *UsernamePasswordCommand) Flags() *base.FlagSets {
	if len(flagsUsernamePasswordMap[c.Func]) == 0 {
		return c.FlagSet(base.FlagSetNone)
	}

	set := c.FlagSet(base.FlagSetHTTP | base.FlagSetClient | base.FlagSetOutputFormat)
	f := set.NewFlagSet("Command Options")
	common.PopulateCommonFlags(c.Command, f, "username-password-type credential", flagsUsernamePasswordMap, c.Func)

	extraUsernamePasswordFlagsFunc(c, set, f)

	return set
}

func (c *UsernamePasswordCommand) Run(args []string) int {
	initUsernamePasswordFlags()

	switch c.Func {
	case "":
		return cli.RunResultHelp

	}

	c.plural = "username-password-type credential"
	switch c.Func {
	case "list":
		c.plural = "username-password-type credentials"
	}

	f := c.Flags()

	if err := f.Parse(args); err != nil {
		c.PrintCliError(err)
		return base.CommandUserError
	}

	if strutil.StrListContains(flagsUsernamePasswordMap[c.Func], "id") && c.FlagId == "" {
		c.PrintCliError(errors.New("ID is required but not passed in via -id"))
		return base.CommandUserError
	}

	var opts []credentials.Option

	if strutil.StrListContains(flagsUsernamePasswordMap[c.Func], "credential-store-id") {
		switch c.Func {

		case "create":
			if c.FlagCredentialStoreId == "" {
				c.PrintCliError(errors.New("CredentialStore ID must be passed in via -credential-store-id or BOUNDARY_CREDENTIAL_STORE_ID"))
				return base.CommandUserError
			}

		}
	}

	client, err := c.Client()
	if c.WrapperCleanupFunc != nil {
		defer func() {
			if err := c.WrapperCleanupFunc(); err != nil {
				c.PrintCliError(fmt.Errorf("Error cleaning kms wrapper: %w", err))
			}
		}()
	}
	if err != nil {
		c.PrintCliError(fmt.Errorf("Error creating API client: %w", err))
		return base.CommandCliError
	}
	credentialsClient := credentials.NewClient(client)

	switch c.FlagName {
	case "":
	case "null":
		opts = append(opts, credentials.DefaultName())
	default:
		opts = append(opts, credentials.WithName(c.FlagName))
	}

	switch c.FlagDescription {
	case "":
	case "null":
		opts = append(opts, credentials.DefaultDescription())
	default:
		opts = append(opts, credentials.WithDescription(c.FlagDescription))
	}

	if c.FlagFilter != "" {
		opts = append(opts, credentials.WithFilter(c.FlagFilter))
	}

	var version uint32

	switch c.Func {

	case "update":
		switch c.FlagVersion {
		case 0:
			opts = append(opts, credentials.WithAutomaticVersioning(true))
		default:
			version = uint32(c.FlagVersion)
		}

	}

	if ok := extraUsernamePasswordFlagsHandlingFunc(c, f, &opts); !ok {
		return base.CommandUserError
	}

	var resp *api.Response
	var item *credentials.Credential

	var createResult *credentials.CredentialCreateResult

	var updateResult *credentials.CredentialUpdateResult

	switch c.Func {

	case "create":
		createResult, err = credentialsClient.Create(c.Context, "username_password", c.FlagCredentialStoreId, opts...)
		if exitCode := c.checkFuncError(err); exitCode > 0 {
			return exitCode
		}
		resp = createResult.GetResponse()
		item = createResult.GetItem()

	case "update":
		updateResult, err = credentialsClient.Update(c.Context, c.FlagId, version, opts...)
		if exitCode := c.checkFuncError(err); exitCode > 0 {
			return exitCode
		}
		resp = updateResult.GetResponse()
		item = updateResult.GetItem()

	}

	resp, item, err = executeExtraUsernamePasswordActions(c, resp, item, err, credentialsClient, version, opts)
	if exitCode := c.checkFuncError(err); exitCode > 0 {
		return exitCode
	}

	output, err := printCustomUsernamePasswordActionOutput(c)
	if err != nil {
		c.PrintCliError(err)
		return base.CommandUserError
	}
	if output {
		return base.CommandSuccess
	}

	switch c.Func {

	}

	switch base.Format(c.UI) {
	case "table":
		c.UI.Output(printItemTable(item, resp))

	case "json":
		if ok := c.PrintJsonItem(resp); !ok {
			return base.CommandCliError
		}
	}

	return base.CommandSuccess
}

func (c *UsernamePasswordCommand) checkFuncError(err error) int {
	if err == nil {
		return 0
	}
	if apiErr := api.AsServerError(err); apiErr != nil {
		c.PrintApiError(apiErr, fmt.Sprintf("Error from controller when performing %s on %s", c.Func, c.plural))
		return base.CommandApiError
	}
	c.PrintCliError(fmt.Errorf("Error trying to %s %s: %s", c.Func, c.plural, err.Error()))
	return base.CommandCliError
}

var (
	extraUsernamePasswordActionsFlagsMapFunc = func() map[string][]string { return nil }
	extraUsernamePasswordSynopsisFunc        = func(*UsernamePasswordCommand) string { return "" }
	extraUsernamePasswordFlagsFunc           = func(*UsernamePasswordCommand, *base.FlagSets, *base.FlagSet) {}
	extraUsernamePasswordFlagsHandlingFunc   = func(*UsernamePasswordCommand, *base.FlagSets, *[]credentials.Option) bool { return true }
	executeExtraUsernamePasswordActions      = func(_ *UsernamePasswordCommand, inResp *api.Response, inItem *credentials.Credential, inErr error, _ *credentials.Client, _ uint32, _ []credentials.Option) (*api.Response, *credentials.Credential, error) {
		return inResp, inItem, inErr
	}
	printCustomUsernamePasswordActionOutput = func(*UsernamePasswordCommand) (bool, error) { return false, nil }
)
