// Code generated by "make cli"; DO NOT EDIT.
// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: BUSL-1.1

package credentialscmd

import (
	"errors"
	"fmt"

	"github.com/hashicorp/boundary/api"
	"github.com/hashicorp/boundary/api/credentials"
	"github.com/hashicorp/boundary/internal/cmd/base"
	"github.com/hashicorp/boundary/internal/cmd/common"
	"github.com/hashicorp/go-secure-stdlib/strutil"
	"github.com/mitchellh/cli"
	"github.com/posener/complete"
)

func initSshPrivateKeyFlags() {
	flagsOnce.Do(func() {
		extraFlags := extraSshPrivateKeyActionsFlagsMapFunc()
		for k, v := range extraFlags {
			flagsSshPrivateKeyMap[k] = append(flagsSshPrivateKeyMap[k], v...)
		}
	})
}

var (
	_ cli.Command             = (*SshPrivateKeyCommand)(nil)
	_ cli.CommandAutocomplete = (*SshPrivateKeyCommand)(nil)
)

type SshPrivateKeyCommand struct {
	*base.Command

	Func string

	plural string

	extraSshPrivateKeyCmdVars
}

func (c *SshPrivateKeyCommand) AutocompleteArgs() complete.Predictor {
	initSshPrivateKeyFlags()
	return complete.PredictAnything
}

func (c *SshPrivateKeyCommand) AutocompleteFlags() complete.Flags {
	initSshPrivateKeyFlags()
	return c.Flags().Completions()
}

func (c *SshPrivateKeyCommand) Synopsis() string {
	if extra := extraSshPrivateKeySynopsisFunc(c); extra != "" {
		return extra
	}

	synopsisStr := "credential"

	synopsisStr = fmt.Sprintf("%s %s", "ssh-private-key-type", synopsisStr)

	return common.SynopsisFunc(c.Func, synopsisStr)
}

func (c *SshPrivateKeyCommand) Help() string {
	initSshPrivateKeyFlags()

	var helpStr string
	helpMap := common.HelpMap("credential")

	switch c.Func {

	default:

		helpStr = c.extraSshPrivateKeyHelpFunc(helpMap)

	}

	// Keep linter from complaining if we don't actually generate code using it
	_ = helpMap
	return helpStr
}

var flagsSshPrivateKeyMap = map[string][]string{

	"create": {"credential-store-id", "name", "description"},

	"update": {"id", "name", "description", "version"},
}

func (c *SshPrivateKeyCommand) Flags() *base.FlagSets {
	if len(flagsSshPrivateKeyMap[c.Func]) == 0 {
		return c.FlagSet(base.FlagSetNone)
	}

	set := c.FlagSet(base.FlagSetHTTP | base.FlagSetClient | base.FlagSetOutputFormat)
	f := set.NewFlagSet("Command Options")
	common.PopulateCommonFlags(c.Command, f, "ssh-private-key-type credential", flagsSshPrivateKeyMap, c.Func)

	extraSshPrivateKeyFlagsFunc(c, set, f)

	return set
}

func (c *SshPrivateKeyCommand) Run(args []string) int {
	initSshPrivateKeyFlags()

	switch c.Func {
	case "":
		return cli.RunResultHelp

	}

	c.plural = "ssh-private-key-type credential"
	switch c.Func {
	case "list":
		c.plural = "ssh-private-key-type credentials"
	}

	f := c.Flags()

	if err := f.Parse(args); err != nil {
		c.PrintCliError(err)
		return base.CommandUserError
	}

	if strutil.StrListContains(flagsSshPrivateKeyMap[c.Func], "id") && c.FlagId == "" {
		c.PrintCliError(errors.New("ID is required but not passed in via -id"))
		return base.CommandUserError
	}

	var opts []credentials.Option

	if strutil.StrListContains(flagsSshPrivateKeyMap[c.Func], "credential-store-id") {
		switch c.Func {

		case "create":
			if c.FlagCredentialStoreId == "" {
				c.PrintCliError(errors.New("CredentialStore ID must be passed in via -credential-store-id or BOUNDARY_CREDENTIAL_STORE_ID"))
				return base.CommandUserError
			}

		}
	}

	client, err := c.Client()
	if c.WrapperCleanupFunc != nil {
		defer func() {
			if err := c.WrapperCleanupFunc(); err != nil {
				c.PrintCliError(fmt.Errorf("Error cleaning kms wrapper: %w", err))
			}
		}()
	}
	if err != nil {
		c.PrintCliError(fmt.Errorf("Error creating API client: %w", err))
		return base.CommandCliError
	}
	credentialsClient := credentials.NewClient(client)

	switch c.FlagName {
	case "":
	case "null":
		opts = append(opts, credentials.DefaultName())
	default:
		opts = append(opts, credentials.WithName(c.FlagName))
	}

	switch c.FlagDescription {
	case "":
	case "null":
		opts = append(opts, credentials.DefaultDescription())
	default:
		opts = append(opts, credentials.WithDescription(c.FlagDescription))
	}

	if c.FlagFilter != "" {
		opts = append(opts, credentials.WithFilter(c.FlagFilter))
	}

	var version uint32

	switch c.Func {

	case "update":
		switch c.FlagVersion {
		case 0:
			opts = append(opts, credentials.WithAutomaticVersioning(true))
		default:
			version = uint32(c.FlagVersion)
		}

	}

	if ok := extraSshPrivateKeyFlagsHandlingFunc(c, f, &opts); !ok {
		return base.CommandUserError
	}

	var resp *api.Response
	var item *credentials.Credential

	var createResult *credentials.CredentialCreateResult

	var updateResult *credentials.CredentialUpdateResult

	switch c.Func {

	case "create":
		createResult, err = credentialsClient.Create(c.Context, "ssh_private_key", c.FlagCredentialStoreId, opts...)
		if exitCode := c.checkFuncError(err); exitCode > 0 {
			return exitCode
		}
		resp = createResult.GetResponse()
		item = createResult.GetItem()

	case "update":
		updateResult, err = credentialsClient.Update(c.Context, c.FlagId, version, opts...)
		if exitCode := c.checkFuncError(err); exitCode > 0 {
			return exitCode
		}
		resp = updateResult.GetResponse()
		item = updateResult.GetItem()

	}

	resp, item, err = executeExtraSshPrivateKeyActions(c, resp, item, err, credentialsClient, version, opts)
	if exitCode := c.checkFuncError(err); exitCode > 0 {
		return exitCode
	}

	output, err := printCustomSshPrivateKeyActionOutput(c)
	if err != nil {
		c.PrintCliError(err)
		return base.CommandUserError
	}
	if output {
		return base.CommandSuccess
	}

	switch c.Func {

	}

	switch base.Format(c.UI) {
	case "table":
		c.UI.Output(printItemTable(item, resp))

	case "json":
		if ok := c.PrintJsonItem(resp); !ok {
			return base.CommandCliError
		}
	}

	return base.CommandSuccess
}

func (c *SshPrivateKeyCommand) checkFuncError(err error) int {
	if err == nil {
		return 0
	}
	if apiErr := api.AsServerError(err); apiErr != nil {
		c.PrintApiError(apiErr, fmt.Sprintf("Error from controller when performing %s on %s", c.Func, c.plural))
		return base.CommandApiError
	}
	c.PrintCliError(fmt.Errorf("Error trying to %s %s: %s", c.Func, c.plural, err.Error()))
	return base.CommandCliError
}

var (
	extraSshPrivateKeyActionsFlagsMapFunc = func() map[string][]string { return nil }
	extraSshPrivateKeySynopsisFunc        = func(*SshPrivateKeyCommand) string { return "" }
	extraSshPrivateKeyFlagsFunc           = func(*SshPrivateKeyCommand, *base.FlagSets, *base.FlagSet) {}
	extraSshPrivateKeyFlagsHandlingFunc   = func(*SshPrivateKeyCommand, *base.FlagSets, *[]credentials.Option) bool { return true }
	executeExtraSshPrivateKeyActions      = func(_ *SshPrivateKeyCommand, inResp *api.Response, inItem *credentials.Credential, inErr error, _ *credentials.Client, _ uint32, _ []credentials.Option) (*api.Response, *credentials.Credential, error) {
		return inResp, inItem, inErr
	}
	printCustomSshPrivateKeyActionOutput = func(*SshPrivateKeyCommand) (bool, error) { return false, nil }
)
