// Code generated by "make cli"; DO NOT EDIT.
// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: BUSL-1.1

package credentialscmd

import (
	"errors"
	"fmt"

	"github.com/hashicorp/boundary/api"
	"github.com/hashicorp/boundary/api/credentials"
	"github.com/hashicorp/boundary/internal/cmd/base"
	"github.com/hashicorp/boundary/internal/cmd/common"
	"github.com/hashicorp/go-secure-stdlib/strutil"
	"github.com/mitchellh/cli"
	"github.com/posener/complete"
)

func initJsonFlags() {
	flagsOnce.Do(func() {
		extraFlags := extraJsonActionsFlagsMapFunc()
		for k, v := range extraFlags {
			flagsJsonMap[k] = append(flagsJsonMap[k], v...)
		}
	})
}

var (
	_ cli.Command             = (*JsonCommand)(nil)
	_ cli.CommandAutocomplete = (*JsonCommand)(nil)
)

type JsonCommand struct {
	*base.Command

	Func string

	plural string
}

func (c *JsonCommand) AutocompleteArgs() complete.Predictor {
	initJsonFlags()
	return complete.PredictAnything
}

func (c *JsonCommand) AutocompleteFlags() complete.Flags {
	initJsonFlags()
	return c.Flags().Completions()
}

func (c *JsonCommand) Synopsis() string {
	if extra := extraJsonSynopsisFunc(c); extra != "" {
		return extra
	}

	synopsisStr := "credential"

	synopsisStr = fmt.Sprintf("%s %s", "json-type", synopsisStr)

	return common.SynopsisFunc(c.Func, synopsisStr)
}

func (c *JsonCommand) Help() string {
	initJsonFlags()

	var helpStr string
	helpMap := common.HelpMap("credential")

	switch c.Func {

	default:

		helpStr = c.extraJsonHelpFunc(helpMap)

	}

	// Keep linter from complaining if we don't actually generate code using it
	_ = helpMap
	return helpStr
}

var flagsJsonMap = map[string][]string{

	"create": {"credential-store-id", "name", "description", "object", "kv", "string-kv", "bool-kv", "num-kv"},

	"update": {"id", "name", "description", "version", "object", "kv", "string-kv", "bool-kv", "num-kv"},
}

func (c *JsonCommand) Flags() *base.FlagSets {
	if len(flagsJsonMap[c.Func]) == 0 {
		return c.FlagSet(base.FlagSetNone)
	}

	set := c.FlagSet(base.FlagSetHTTP | base.FlagSetClient | base.FlagSetOutputFormat)
	f := set.NewFlagSet("Command Options")
	common.PopulateCommonFlags(c.Command, f, "json-type credential", flagsJsonMap, c.Func)

	f = set.NewFlagSet("Object Options")
	objsInput := common.CombinedSliceFlagValuePopulationInput{
		FlagSet:                          f,
		FlagNames:                        flagsJsonMap[c.Func],
		FullPopulationFlag:               &c.FlagObject,
		FullPopulationInputName:          "object",
		PiecewisePopulationFlag:          &c.FlagKv,
		PiecewisePopulationInputBaseName: "kv",
	}
	common.PopulateCombinedSliceFlagValue(objsInput)

	extraJsonFlagsFunc(c, set, f)

	return set
}

func (c *JsonCommand) Run(args []string) int {
	initJsonFlags()

	switch c.Func {
	case "":
		return cli.RunResultHelp

	}

	c.plural = "json-type credential"
	switch c.Func {
	case "list":
		c.plural = "json-type credentials"
	}

	f := c.Flags()

	if err := f.Parse(args); err != nil {
		c.PrintCliError(err)
		return base.CommandUserError
	}

	if strutil.StrListContains(flagsJsonMap[c.Func], "id") && c.FlagId == "" {
		c.PrintCliError(errors.New("ID is required but not passed in via -id"))
		return base.CommandUserError
	}

	if c.FlagObject != "" && len(c.FlagKv) > 0 {
		c.PrintCliError(errors.New("-object flag cannot be used along with the following flags: kv, bool-kv, num-kv, string-kv"))
		return base.CommandUserError
	}

	var opts []credentials.Option

	if strutil.StrListContains(flagsJsonMap[c.Func], "credential-store-id") {
		switch c.Func {

		case "create":
			if c.FlagCredentialStoreId == "" {
				c.PrintCliError(errors.New("CredentialStore ID must be passed in via -credential-store-id or BOUNDARY_CREDENTIAL_STORE_ID"))
				return base.CommandUserError
			}

		}
	}

	client, err := c.Client()
	if c.WrapperCleanupFunc != nil {
		defer func() {
			if err := c.WrapperCleanupFunc(); err != nil {
				c.PrintCliError(fmt.Errorf("Error cleaning kms wrapper: %w", err))
			}
		}()
	}
	if err != nil {
		c.PrintCliError(fmt.Errorf("Error creating API client: %w", err))
		return base.CommandCliError
	}
	credentialsClient := credentials.NewClient(client)

	switch c.FlagName {
	case "":
	case "null":
		opts = append(opts, credentials.DefaultName())
	default:
		opts = append(opts, credentials.WithName(c.FlagName))
	}

	switch c.FlagDescription {
	case "":
	case "null":
		opts = append(opts, credentials.DefaultDescription())
	default:
		opts = append(opts, credentials.WithDescription(c.FlagDescription))
	}

	if c.FlagFilter != "" {
		opts = append(opts, credentials.WithFilter(c.FlagFilter))
	}

	var version uint32

	switch c.Func {

	case "update":
		switch c.FlagVersion {
		case 0:
			opts = append(opts, credentials.WithAutomaticVersioning(true))
		default:
			version = uint32(c.FlagVersion)
		}

	}

	if err := common.HandleAttributeFlags(
		c.Command,
		"kv",
		c.FlagObject,
		c.FlagKv,
		func() {},
		func(in map[string]interface{}) {
			opts = append(opts, credentials.WithJsonCredentialObject(in))
		}); err != nil {
		c.PrintCliError(fmt.Errorf("Error evaluating kv flags to: %s", err.Error()))
		return base.CommandCliError
	}

	if ok := extraJsonFlagsHandlingFunc(c, f, &opts); !ok {
		return base.CommandUserError
	}

	var resp *api.Response
	var item *credentials.Credential

	var createResult *credentials.CredentialCreateResult

	var updateResult *credentials.CredentialUpdateResult

	switch c.Func {

	case "create":
		createResult, err = credentialsClient.Create(c.Context, "json", c.FlagCredentialStoreId, opts...)
		if exitCode := c.checkFuncError(err); exitCode > 0 {
			return exitCode
		}
		resp = createResult.GetResponse()
		item = createResult.GetItem()

	case "update":
		updateResult, err = credentialsClient.Update(c.Context, c.FlagId, version, opts...)
		if exitCode := c.checkFuncError(err); exitCode > 0 {
			return exitCode
		}
		resp = updateResult.GetResponse()
		item = updateResult.GetItem()

	}

	resp, item, err = executeExtraJsonActions(c, resp, item, err, credentialsClient, version, opts)
	if exitCode := c.checkFuncError(err); exitCode > 0 {
		return exitCode
	}

	output, err := printCustomJsonActionOutput(c)
	if err != nil {
		c.PrintCliError(err)
		return base.CommandUserError
	}
	if output {
		return base.CommandSuccess
	}

	switch c.Func {

	}

	switch base.Format(c.UI) {
	case "table":
		c.UI.Output(printItemTable(item, resp))

	case "json":
		if ok := c.PrintJsonItem(resp); !ok {
			return base.CommandCliError
		}
	}

	return base.CommandSuccess
}

func (c *JsonCommand) checkFuncError(err error) int {
	if err == nil {
		return 0
	}
	if apiErr := api.AsServerError(err); apiErr != nil {
		c.PrintApiError(apiErr, fmt.Sprintf("Error from controller when performing %s on %s", c.Func, c.plural))
		return base.CommandApiError
	}
	c.PrintCliError(fmt.Errorf("Error trying to %s %s: %s", c.Func, c.plural, err.Error()))
	return base.CommandCliError
}

var (
	extraJsonActionsFlagsMapFunc = func() map[string][]string { return nil }
	extraJsonSynopsisFunc        = func(*JsonCommand) string { return "" }
	extraJsonFlagsFunc           = func(*JsonCommand, *base.FlagSets, *base.FlagSet) {}
	extraJsonFlagsHandlingFunc   = func(*JsonCommand, *base.FlagSets, *[]credentials.Option) bool { return true }
	executeExtraJsonActions      = func(_ *JsonCommand, inResp *api.Response, inItem *credentials.Credential, inErr error, _ *credentials.Client, _ uint32, _ []credentials.Option) (*api.Response, *credentials.Credential, error) {
		return inResp, inItem, inErr
	}
	printCustomJsonActionOutput = func(*JsonCommand) (bool, error) { return false, nil }
)
