// Code generated by "make cli"; DO NOT EDIT.
// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: BUSL-1.1

package aliasescmd

import (
	"errors"
	"fmt"

	"github.com/hashicorp/boundary/api"
	"github.com/hashicorp/boundary/api/aliases"
	"github.com/hashicorp/boundary/internal/cmd/base"
	"github.com/hashicorp/boundary/internal/cmd/common"
	"github.com/hashicorp/go-secure-stdlib/strutil"
	"github.com/mitchellh/cli"
	"github.com/posener/complete"
)

func initTargetFlags() {
	flagsOnce.Do(func() {
		extraFlags := extraTargetActionsFlagsMapFunc()
		for k, v := range extraFlags {
			flagsTargetMap[k] = append(flagsTargetMap[k], v...)
		}
	})
}

var (
	_ cli.Command             = (*TargetCommand)(nil)
	_ cli.CommandAutocomplete = (*TargetCommand)(nil)
)

type TargetCommand struct {
	*base.Command

	Func string

	plural string

	extraTargetCmdVars
}

func (c *TargetCommand) AutocompleteArgs() complete.Predictor {
	initTargetFlags()
	return complete.PredictAnything
}

func (c *TargetCommand) AutocompleteFlags() complete.Flags {
	initTargetFlags()
	return c.Flags().Completions()
}

func (c *TargetCommand) Synopsis() string {
	if extra := extraTargetSynopsisFunc(c); extra != "" {
		return extra
	}

	synopsisStr := "alias"

	synopsisStr = fmt.Sprintf("%s %s", "target-type", synopsisStr)

	return common.SynopsisFunc(c.Func, synopsisStr)
}

func (c *TargetCommand) Help() string {
	initTargetFlags()

	var helpStr string
	helpMap := common.HelpMap("alias")

	switch c.Func {

	default:

		helpStr = c.extraTargetHelpFunc(helpMap)

	}

	// Keep linter from complaining if we don't actually generate code using it
	_ = helpMap
	return helpStr
}

var flagsTargetMap = map[string][]string{

	"create": {"scope-id", "name", "description"},

	"update": {"id", "name", "description", "version"},
}

func (c *TargetCommand) Flags() *base.FlagSets {
	if len(flagsTargetMap[c.Func]) == 0 {
		return c.FlagSet(base.FlagSetNone)
	}

	set := c.FlagSet(base.FlagSetHTTP | base.FlagSetClient | base.FlagSetOutputFormat)
	f := set.NewFlagSet("Command Options")
	common.PopulateCommonFlags(c.Command, f, "target-type alias", flagsTargetMap, c.Func)

	extraTargetFlagsFunc(c, set, f)

	return set
}

func (c *TargetCommand) Run(args []string) int {
	initTargetFlags()

	switch c.Func {
	case "":
		return cli.RunResultHelp

	}

	c.plural = "target-type alias"
	switch c.Func {
	case "list":
		c.plural = "target-type aliases"
	}

	f := c.Flags()

	if err := f.Parse(args); err != nil {
		c.PrintCliError(err)
		return base.CommandUserError
	}

	if strutil.StrListContains(flagsTargetMap[c.Func], "id") && c.FlagId == "" {
		c.PrintCliError(errors.New("ID is required but not passed in via -id"))
		return base.CommandUserError
	}

	var opts []aliases.Option

	if strutil.StrListContains(flagsTargetMap[c.Func], "scope-id") {
		switch c.Func {

		case "create":
			if c.FlagScopeId == "" {
				c.PrintCliError(errors.New("Scope ID must be passed in via -scope-id or BOUNDARY_SCOPE_ID"))
				return base.CommandUserError
			}

		}
	}

	client, err := c.Client()
	if c.WrapperCleanupFunc != nil {
		defer func() {
			if err := c.WrapperCleanupFunc(); err != nil {
				c.PrintCliError(fmt.Errorf("Error cleaning kms wrapper: %w", err))
			}
		}()
	}
	if err != nil {
		c.PrintCliError(fmt.Errorf("Error creating API client: %w", err))
		return base.CommandCliError
	}
	aliasesClient := aliases.NewClient(client)

	switch c.FlagName {
	case "":
	case "null":
		opts = append(opts, aliases.DefaultName())
	default:
		opts = append(opts, aliases.WithName(c.FlagName))
	}

	switch c.FlagDescription {
	case "":
	case "null":
		opts = append(opts, aliases.DefaultDescription())
	default:
		opts = append(opts, aliases.WithDescription(c.FlagDescription))
	}

	switch c.FlagRecursive {
	case true:
		opts = append(opts, aliases.WithRecursive(true))
	}

	if c.FlagFilter != "" {
		opts = append(opts, aliases.WithFilter(c.FlagFilter))
	}

	var version uint32

	switch c.Func {

	case "update":
		switch c.FlagVersion {
		case 0:
			opts = append(opts, aliases.WithAutomaticVersioning(true))
		default:
			version = uint32(c.FlagVersion)
		}

	}

	if ok := extraTargetFlagsHandlingFunc(c, f, &opts); !ok {
		return base.CommandUserError
	}

	var resp *api.Response
	var item *aliases.Alias

	var createResult *aliases.AliasCreateResult

	var updateResult *aliases.AliasUpdateResult

	switch c.Func {

	case "create":
		createResult, err = aliasesClient.Create(c.Context, "target", c.FlagScopeId, opts...)
		if exitCode := c.checkFuncError(err); exitCode > 0 {
			return exitCode
		}
		resp = createResult.GetResponse()
		item = createResult.GetItem()

	case "update":
		updateResult, err = aliasesClient.Update(c.Context, c.FlagId, version, opts...)
		if exitCode := c.checkFuncError(err); exitCode > 0 {
			return exitCode
		}
		resp = updateResult.GetResponse()
		item = updateResult.GetItem()

	}

	resp, item, err = executeExtraTargetActions(c, resp, item, err, aliasesClient, version, opts)
	if exitCode := c.checkFuncError(err); exitCode > 0 {
		return exitCode
	}

	output, err := printCustomTargetActionOutput(c)
	if err != nil {
		c.PrintCliError(err)
		return base.CommandUserError
	}
	if output {
		return base.CommandSuccess
	}

	switch c.Func {

	}

	switch base.Format(c.UI) {
	case "table":
		c.UI.Output(printItemTable(item, resp))

	case "json":
		if ok := c.PrintJsonItem(resp); !ok {
			return base.CommandCliError
		}
	}

	return base.CommandSuccess
}

func (c *TargetCommand) checkFuncError(err error) int {
	if err == nil {
		return 0
	}
	if apiErr := api.AsServerError(err); apiErr != nil {
		c.PrintApiError(apiErr, fmt.Sprintf("Error from controller when performing %s on %s", c.Func, c.plural))
		return base.CommandApiError
	}
	c.PrintCliError(fmt.Errorf("Error trying to %s %s: %s", c.Func, c.plural, err.Error()))
	return base.CommandCliError
}

var (
	extraTargetActionsFlagsMapFunc = func() map[string][]string { return nil }
	extraTargetSynopsisFunc        = func(*TargetCommand) string { return "" }
	extraTargetFlagsFunc           = func(*TargetCommand, *base.FlagSets, *base.FlagSet) {}
	extraTargetFlagsHandlingFunc   = func(*TargetCommand, *base.FlagSets, *[]aliases.Option) bool { return true }
	executeExtraTargetActions      = func(_ *TargetCommand, inResp *api.Response, inItem *aliases.Alias, inErr error, _ *aliases.Client, _ uint32, _ []aliases.Option) (*api.Response, *aliases.Alias, error) {
		return inResp, inItem, inErr
	}
	printCustomTargetActionOutput = func(*TargetCommand) (bool, error) { return false, nil }
)
