// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: BUSL-1.1

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        (unknown)
// source: ssh/v1/ssh_chunks.proto

package sshv1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// An UnknownRequest is an unrecognized SSH request. We'll record the type, want_reply, and payload
type UnknownRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The request type field
	RequestType string `protobuf:"bytes,1,opt,name=request_type,json=requestType,proto3" json:"request_type,omitempty"`
	// The want_reply field on the SSH request
	WantReply bool `protobuf:"varint,2,opt,name=want_reply,json=wantReply,proto3" json:"want_reply,omitempty"`
	// The Payload field on the SSH request
	Data []byte `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
}

func (x *UnknownRequest) Reset() {
	*x = UnknownRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ssh_v1_ssh_chunks_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UnknownRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UnknownRequest) ProtoMessage() {}

func (x *UnknownRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ssh_v1_ssh_chunks_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UnknownRequest.ProtoReflect.Descriptor instead.
func (*UnknownRequest) Descriptor() ([]byte, []int) {
	return file_ssh_v1_ssh_chunks_proto_rawDescGZIP(), []int{0}
}

func (x *UnknownRequest) GetRequestType() string {
	if x != nil {
		return x.RequestType
	}
	return ""
}

func (x *UnknownRequest) GetWantReply() bool {
	if x != nil {
		return x.WantReply
	}
	return false
}

func (x *UnknownRequest) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

// A session is started by sending the following message.
type SessionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The request type field. This should always be "session"
	RequestType string `protobuf:"bytes,1,opt,name=request_type,json=requestType,proto3" json:"request_type,omitempty"`
	// The sender channel
	SenderChannel uint32 `protobuf:"varint,2,opt,name=sender_channel,json=senderChannel,proto3" json:"sender_channel,omitempty"`
	// The initial window size
	InitialWindowSize uint32 `protobuf:"varint,3,opt,name=initial_window_size,json=initialWindowSize,proto3" json:"initial_window_size,omitempty"`
	// The maximum packet size
	MaximumPacketSize uint32 `protobuf:"varint,4,opt,name=maximum_packet_size,json=maximumPacketSize,proto3" json:"maximum_packet_size,omitempty"`
}

func (x *SessionRequest) Reset() {
	*x = SessionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ssh_v1_ssh_chunks_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SessionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SessionRequest) ProtoMessage() {}

func (x *SessionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ssh_v1_ssh_chunks_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SessionRequest.ProtoReflect.Descriptor instead.
func (*SessionRequest) Descriptor() ([]byte, []int) {
	return file_ssh_v1_ssh_chunks_proto_rawDescGZIP(), []int{1}
}

func (x *SessionRequest) GetRequestType() string {
	if x != nil {
		return x.RequestType
	}
	return ""
}

func (x *SessionRequest) GetSenderChannel() uint32 {
	if x != nil {
		return x.SenderChannel
	}
	return 0
}

func (x *SessionRequest) GetInitialWindowSize() uint32 {
	if x != nil {
		return x.InitialWindowSize
	}
	return 0
}

func (x *SessionRequest) GetMaximumPacketSize() uint32 {
	if x != nil {
		return x.MaximumPacketSize
	}
	return 0
}

// X11 channels are opened with a channel open request.  The resulting
// channels are independent of the session, and closing the session
// channel does not close the forwarded X11 channels.
type X11Request struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The request type field. This should always be "x11"
	RequestType string `protobuf:"bytes,1,opt,name=request_type,json=requestType,proto3" json:"request_type,omitempty"`
	// The sender channel
	SenderChannel uint32 `protobuf:"varint,2,opt,name=sender_channel,json=senderChannel,proto3" json:"sender_channel,omitempty"`
	// The initial window size
	InitialWindowSize uint32 `protobuf:"varint,3,opt,name=initial_window_size,json=initialWindowSize,proto3" json:"initial_window_size,omitempty"`
	// The maximum packet size
	MaximumPacketSize uint32 `protobuf:"varint,4,opt,name=maximum_packet_size,json=maximumPacketSize,proto3" json:"maximum_packet_size,omitempty"`
	// The originator address (e.g., "192.168.7.38")
	OriginatorAddress string `protobuf:"bytes,5,opt,name=originator_address,json=originatorAddress,proto3" json:"originator_address,omitempty"`
	// The originator port
	OriginatorPort uint32 `protobuf:"varint,6,opt,name=originator_port,json=originatorPort,proto3" json:"originator_port,omitempty"`
}

func (x *X11Request) Reset() {
	*x = X11Request{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ssh_v1_ssh_chunks_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *X11Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*X11Request) ProtoMessage() {}

func (x *X11Request) ProtoReflect() protoreflect.Message {
	mi := &file_ssh_v1_ssh_chunks_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use X11Request.ProtoReflect.Descriptor instead.
func (*X11Request) Descriptor() ([]byte, []int) {
	return file_ssh_v1_ssh_chunks_proto_rawDescGZIP(), []int{2}
}

func (x *X11Request) GetRequestType() string {
	if x != nil {
		return x.RequestType
	}
	return ""
}

func (x *X11Request) GetSenderChannel() uint32 {
	if x != nil {
		return x.SenderChannel
	}
	return 0
}

func (x *X11Request) GetInitialWindowSize() uint32 {
	if x != nil {
		return x.InitialWindowSize
	}
	return 0
}

func (x *X11Request) GetMaximumPacketSize() uint32 {
	if x != nil {
		return x.MaximumPacketSize
	}
	return 0
}

func (x *X11Request) GetOriginatorAddress() string {
	if x != nil {
		return x.OriginatorAddress
	}
	return ""
}

func (x *X11Request) GetOriginatorPort() uint32 {
	if x != nil {
		return x.OriginatorPort
	}
	return 0
}

// When a connection comes to a port for which remote forwarding has
// been requested, a channel is opened to forward the port to the other
// side.
type ForwardedTCPIPRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The request type field. This should always be "forwarded-tcpip"
	RequestType string `protobuf:"bytes,1,opt,name=request_type,json=requestType,proto3" json:"request_type,omitempty"`
	// The sender channel
	SenderChannel uint32 `protobuf:"varint,2,opt,name=sender_channel,json=senderChannel,proto3" json:"sender_channel,omitempty"`
	// The initial window size
	InitialWindowSize uint32 `protobuf:"varint,3,opt,name=initial_window_size,json=initialWindowSize,proto3" json:"initial_window_size,omitempty"`
	// The maximum packet size
	MaximumPacketSize uint32 `protobuf:"varint,4,opt,name=maximum_packet_size,json=maximumPacketSize,proto3" json:"maximum_packet_size,omitempty"`
	// The address that was connected
	Address string `protobuf:"bytes,5,opt,name=address,proto3" json:"address,omitempty"`
	// The port that was connected
	Port uint32 `protobuf:"varint,6,opt,name=port,proto3" json:"port,omitempty"`
	// The originator ip address (e.g., "192.168.7.38")
	OriginatorIpAddress string `protobuf:"bytes,7,opt,name=originator_ip_address,json=originatorIpAddress,proto3" json:"originator_ip_address,omitempty"`
	// The originator port
	OriginatorPort uint32 `protobuf:"varint,8,opt,name=originator_port,json=originatorPort,proto3" json:"originator_port,omitempty"`
}

func (x *ForwardedTCPIPRequest) Reset() {
	*x = ForwardedTCPIPRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ssh_v1_ssh_chunks_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ForwardedTCPIPRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ForwardedTCPIPRequest) ProtoMessage() {}

func (x *ForwardedTCPIPRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ssh_v1_ssh_chunks_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ForwardedTCPIPRequest.ProtoReflect.Descriptor instead.
func (*ForwardedTCPIPRequest) Descriptor() ([]byte, []int) {
	return file_ssh_v1_ssh_chunks_proto_rawDescGZIP(), []int{3}
}

func (x *ForwardedTCPIPRequest) GetRequestType() string {
	if x != nil {
		return x.RequestType
	}
	return ""
}

func (x *ForwardedTCPIPRequest) GetSenderChannel() uint32 {
	if x != nil {
		return x.SenderChannel
	}
	return 0
}

func (x *ForwardedTCPIPRequest) GetInitialWindowSize() uint32 {
	if x != nil {
		return x.InitialWindowSize
	}
	return 0
}

func (x *ForwardedTCPIPRequest) GetMaximumPacketSize() uint32 {
	if x != nil {
		return x.MaximumPacketSize
	}
	return 0
}

func (x *ForwardedTCPIPRequest) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *ForwardedTCPIPRequest) GetPort() uint32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *ForwardedTCPIPRequest) GetOriginatorIpAddress() string {
	if x != nil {
		return x.OriginatorIpAddress
	}
	return ""
}

func (x *ForwardedTCPIPRequest) GetOriginatorPort() uint32 {
	if x != nil {
		return x.OriginatorPort
	}
	return 0
}

// When a connection comes to a locally forwarded TCP/IP port, the
// following packet is sent to the other side.
type DirectTCPIPRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The request type field. This should always be "direct-tcpip"
	RequestType string `protobuf:"bytes,1,opt,name=request_type,json=requestType,proto3" json:"request_type,omitempty"`
	// The sender channel
	SenderChannel uint32 `protobuf:"varint,2,opt,name=sender_channel,json=senderChannel,proto3" json:"sender_channel,omitempty"`
	// The initial window size
	InitialWindowSize uint32 `protobuf:"varint,3,opt,name=initial_window_size,json=initialWindowSize,proto3" json:"initial_window_size,omitempty"`
	// The maximum packet size
	MaximumPacketSize uint32 `protobuf:"varint,4,opt,name=maximum_packet_size,json=maximumPacketSize,proto3" json:"maximum_packet_size,omitempty"`
	// The host to connect
	Host string `protobuf:"bytes,5,opt,name=host,proto3" json:"host,omitempty"`
	// The port to connect
	Port uint32 `protobuf:"varint,6,opt,name=port,proto3" json:"port,omitempty"`
	// The 'originator IP address' is the numeric IP address of the machine
	// from where the connection request originates
	OriginatorIpAddress string `protobuf:"bytes,7,opt,name=originator_ip_address,json=originatorIpAddress,proto3" json:"originator_ip_address,omitempty"`
	// The port on the host from where the connection originated.
	OriginatorPort uint32 `protobuf:"varint,8,opt,name=originator_port,json=originatorPort,proto3" json:"originator_port,omitempty"`
}

func (x *DirectTCPIPRequest) Reset() {
	*x = DirectTCPIPRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ssh_v1_ssh_chunks_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DirectTCPIPRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DirectTCPIPRequest) ProtoMessage() {}

func (x *DirectTCPIPRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ssh_v1_ssh_chunks_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DirectTCPIPRequest.ProtoReflect.Descriptor instead.
func (*DirectTCPIPRequest) Descriptor() ([]byte, []int) {
	return file_ssh_v1_ssh_chunks_proto_rawDescGZIP(), []int{4}
}

func (x *DirectTCPIPRequest) GetRequestType() string {
	if x != nil {
		return x.RequestType
	}
	return ""
}

func (x *DirectTCPIPRequest) GetSenderChannel() uint32 {
	if x != nil {
		return x.SenderChannel
	}
	return 0
}

func (x *DirectTCPIPRequest) GetInitialWindowSize() uint32 {
	if x != nil {
		return x.InitialWindowSize
	}
	return 0
}

func (x *DirectTCPIPRequest) GetMaximumPacketSize() uint32 {
	if x != nil {
		return x.MaximumPacketSize
	}
	return 0
}

func (x *DirectTCPIPRequest) GetHost() string {
	if x != nil {
		return x.Host
	}
	return ""
}

func (x *DirectTCPIPRequest) GetPort() uint32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *DirectTCPIPRequest) GetOriginatorIpAddress() string {
	if x != nil {
		return x.OriginatorIpAddress
	}
	return ""
}

func (x *DirectTCPIPRequest) GetOriginatorPort() uint32 {
	if x != nil {
		return x.OriginatorPort
	}
	return 0
}

// A pseudo-terminal can be allocated for the session by sending the
// following message.
type PtyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The request type field. This should always be "pty-req"
	RequestType string `protobuf:"bytes,1,opt,name=request_type,json=requestType,proto3" json:"request_type,omitempty"`
	// The want_reply field on the SSH request
	WantReply bool `protobuf:"varint,2,opt,name=want_reply,json=wantReply,proto3" json:"want_reply,omitempty"`
	// TERM environment variable value (e.g., vt100)
	TermEnvVar string `protobuf:"bytes,3,opt,name=term_env_var,json=termEnvVar,proto3" json:"term_env_var,omitempty"`
	// Terminal width, characters (e.g., 80)
	TerminalWidthCharacters uint32 `protobuf:"varint,4,opt,name=terminal_width_characters,json=terminalWidthCharacters,proto3" json:"terminal_width_characters,omitempty"`
	// Terminal height, rows (e.g., 24)
	TerminalHeightRows uint32 `protobuf:"varint,5,opt,name=terminal_height_rows,json=terminalHeightRows,proto3" json:"terminal_height_rows,omitempty"`
	// Terminal width, pixels (e.g., 640)
	TerminalWidthPixels uint32 `protobuf:"varint,6,opt,name=terminal_width_pixels,json=terminalWidthPixels,proto3" json:"terminal_width_pixels,omitempty"`
	// Terminal height, pixels (e.g., 480)
	TerminalHeightPixels uint32 `protobuf:"varint,7,opt,name=terminal_height_pixels,json=terminalHeightPixels,proto3" json:"terminal_height_pixels,omitempty"`
	// Encoded terminal modes
	EncodedTerminalMode []byte `protobuf:"bytes,8,opt,name=encoded_terminal_mode,json=encodedTerminalMode,proto3" json:"encoded_terminal_mode,omitempty"`
}

func (x *PtyRequest) Reset() {
	*x = PtyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ssh_v1_ssh_chunks_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PtyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PtyRequest) ProtoMessage() {}

func (x *PtyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ssh_v1_ssh_chunks_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PtyRequest.ProtoReflect.Descriptor instead.
func (*PtyRequest) Descriptor() ([]byte, []int) {
	return file_ssh_v1_ssh_chunks_proto_rawDescGZIP(), []int{5}
}

func (x *PtyRequest) GetRequestType() string {
	if x != nil {
		return x.RequestType
	}
	return ""
}

func (x *PtyRequest) GetWantReply() bool {
	if x != nil {
		return x.WantReply
	}
	return false
}

func (x *PtyRequest) GetTermEnvVar() string {
	if x != nil {
		return x.TermEnvVar
	}
	return ""
}

func (x *PtyRequest) GetTerminalWidthCharacters() uint32 {
	if x != nil {
		return x.TerminalWidthCharacters
	}
	return 0
}

func (x *PtyRequest) GetTerminalHeightRows() uint32 {
	if x != nil {
		return x.TerminalHeightRows
	}
	return 0
}

func (x *PtyRequest) GetTerminalWidthPixels() uint32 {
	if x != nil {
		return x.TerminalWidthPixels
	}
	return 0
}

func (x *PtyRequest) GetTerminalHeightPixels() uint32 {
	if x != nil {
		return x.TerminalHeightPixels
	}
	return 0
}

func (x *PtyRequest) GetEncodedTerminalMode() []byte {
	if x != nil {
		return x.EncodedTerminalMode
	}
	return nil
}

// X11 forwarding may be requested for a session using the following message
type X11ForwardingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The request type field. This should always be "x11-req"
	RequestType string `protobuf:"bytes,1,opt,name=request_type,json=requestType,proto3" json:"request_type,omitempty"`
	// The want_reply field on the SSH request
	WantReply bool `protobuf:"varint,2,opt,name=want_reply,json=wantReply,proto3" json:"want_reply,omitempty"`
	// Single connection
	SingleConnection bool `protobuf:"varint,3,opt,name=single_connection,json=singleConnection,proto3" json:"single_connection,omitempty"`
	// X11 authentication protocol
	X11AuthenticationProtocol string `protobuf:"bytes,4,opt,name=x11_authentication_protocol,json=x11AuthenticationProtocol,proto3" json:"x11_authentication_protocol,omitempty"`
	// X11 authentication cookie
	X11AuthenticationCookie string `protobuf:"bytes,5,opt,name=x11_authentication_cookie,json=x11AuthenticationCookie,proto3" json:"x11_authentication_cookie,omitempty"`
	// X11 screen number
	X11ScreenNumber uint32 `protobuf:"varint,6,opt,name=x11_screen_number,json=x11ScreenNumber,proto3" json:"x11_screen_number,omitempty"`
}

func (x *X11ForwardingRequest) Reset() {
	*x = X11ForwardingRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ssh_v1_ssh_chunks_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *X11ForwardingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*X11ForwardingRequest) ProtoMessage() {}

func (x *X11ForwardingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ssh_v1_ssh_chunks_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use X11ForwardingRequest.ProtoReflect.Descriptor instead.
func (*X11ForwardingRequest) Descriptor() ([]byte, []int) {
	return file_ssh_v1_ssh_chunks_proto_rawDescGZIP(), []int{6}
}

func (x *X11ForwardingRequest) GetRequestType() string {
	if x != nil {
		return x.RequestType
	}
	return ""
}

func (x *X11ForwardingRequest) GetWantReply() bool {
	if x != nil {
		return x.WantReply
	}
	return false
}

func (x *X11ForwardingRequest) GetSingleConnection() bool {
	if x != nil {
		return x.SingleConnection
	}
	return false
}

func (x *X11ForwardingRequest) GetX11AuthenticationProtocol() string {
	if x != nil {
		return x.X11AuthenticationProtocol
	}
	return ""
}

func (x *X11ForwardingRequest) GetX11AuthenticationCookie() string {
	if x != nil {
		return x.X11AuthenticationCookie
	}
	return ""
}

func (x *X11ForwardingRequest) GetX11ScreenNumber() uint32 {
	if x != nil {
		return x.X11ScreenNumber
	}
	return 0
}

// Environment variables may be passed to the shell/command to be
// started later.
type EnvRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The request type field. This should always be "env"
	RequestType string `protobuf:"bytes,1,opt,name=request_type,json=requestType,proto3" json:"request_type,omitempty"`
	// The want_reply field on the SSH request
	WantReply bool `protobuf:"varint,2,opt,name=want_reply,json=wantReply,proto3" json:"want_reply,omitempty"`
	// Variable name
	VariableName string `protobuf:"bytes,3,opt,name=variable_name,json=variableName,proto3" json:"variable_name,omitempty"`
	// Variable value
	VariableValue string `protobuf:"bytes,4,opt,name=variable_value,json=variableValue,proto3" json:"variable_value,omitempty"`
}

func (x *EnvRequest) Reset() {
	*x = EnvRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ssh_v1_ssh_chunks_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EnvRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnvRequest) ProtoMessage() {}

func (x *EnvRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ssh_v1_ssh_chunks_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnvRequest.ProtoReflect.Descriptor instead.
func (*EnvRequest) Descriptor() ([]byte, []int) {
	return file_ssh_v1_ssh_chunks_proto_rawDescGZIP(), []int{7}
}

func (x *EnvRequest) GetRequestType() string {
	if x != nil {
		return x.RequestType
	}
	return ""
}

func (x *EnvRequest) GetWantReply() bool {
	if x != nil {
		return x.WantReply
	}
	return false
}

func (x *EnvRequest) GetVariableName() string {
	if x != nil {
		return x.VariableName
	}
	return ""
}

func (x *EnvRequest) GetVariableValue() string {
	if x != nil {
		return x.VariableValue
	}
	return ""
}

// This message will request that the user's default shell (typically
// defined in /etc/passwd in UNIX systems) be started at the other end.
type ShellRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The request type field. This should always be "shell"
	RequestType string `protobuf:"bytes,1,opt,name=request_type,json=requestType,proto3" json:"request_type,omitempty"`
	// The want_reply field on the SSH request
	WantReply bool `protobuf:"varint,2,opt,name=want_reply,json=wantReply,proto3" json:"want_reply,omitempty"`
}

func (x *ShellRequest) Reset() {
	*x = ShellRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ssh_v1_ssh_chunks_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShellRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShellRequest) ProtoMessage() {}

func (x *ShellRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ssh_v1_ssh_chunks_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShellRequest.ProtoReflect.Descriptor instead.
func (*ShellRequest) Descriptor() ([]byte, []int) {
	return file_ssh_v1_ssh_chunks_proto_rawDescGZIP(), []int{8}
}

func (x *ShellRequest) GetRequestType() string {
	if x != nil {
		return x.RequestType
	}
	return ""
}

func (x *ShellRequest) GetWantReply() bool {
	if x != nil {
		return x.WantReply
	}
	return false
}

// This message will request that the server start the execution of the
// given command.  The 'command' string may contain a path.
type ExecRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The request type field. This should always be "exec"
	RequestType string `protobuf:"bytes,1,opt,name=request_type,json=requestType,proto3" json:"request_type,omitempty"`
	// The want_reply field on the SSH request
	WantReply bool `protobuf:"varint,2,opt,name=want_reply,json=wantReply,proto3" json:"want_reply,omitempty"`
	// The command to be executed
	Command string `protobuf:"bytes,3,opt,name=command,proto3" json:"command,omitempty"`
}

func (x *ExecRequest) Reset() {
	*x = ExecRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ssh_v1_ssh_chunks_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecRequest) ProtoMessage() {}

func (x *ExecRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ssh_v1_ssh_chunks_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecRequest.ProtoReflect.Descriptor instead.
func (*ExecRequest) Descriptor() ([]byte, []int) {
	return file_ssh_v1_ssh_chunks_proto_rawDescGZIP(), []int{9}
}

func (x *ExecRequest) GetRequestType() string {
	if x != nil {
		return x.RequestType
	}
	return ""
}

func (x *ExecRequest) GetWantReply() bool {
	if x != nil {
		return x.WantReply
	}
	return false
}

func (x *ExecRequest) GetCommand() string {
	if x != nil {
		return x.Command
	}
	return ""
}

// Execute a predefined subsystem. It is expected that
// these will include a general file transfer mechanism, and possibly
// other features.
type SubsystemRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The request type field. This should always be "subsystem"
	RequestType string `protobuf:"bytes,1,opt,name=request_type,json=requestType,proto3" json:"request_type,omitempty"`
	// The want_reply field on the SSH request
	WantReply bool `protobuf:"varint,2,opt,name=want_reply,json=wantReply,proto3" json:"want_reply,omitempty"`
	// The predefined subsystem to execute
	SubsystemName string `protobuf:"bytes,3,opt,name=subsystem_name,json=subsystemName,proto3" json:"subsystem_name,omitempty"`
}

func (x *SubsystemRequest) Reset() {
	*x = SubsystemRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ssh_v1_ssh_chunks_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubsystemRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubsystemRequest) ProtoMessage() {}

func (x *SubsystemRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ssh_v1_ssh_chunks_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubsystemRequest.ProtoReflect.Descriptor instead.
func (*SubsystemRequest) Descriptor() ([]byte, []int) {
	return file_ssh_v1_ssh_chunks_proto_rawDescGZIP(), []int{10}
}

func (x *SubsystemRequest) GetRequestType() string {
	if x != nil {
		return x.RequestType
	}
	return ""
}

func (x *SubsystemRequest) GetWantReply() bool {
	if x != nil {
		return x.WantReply
	}
	return false
}

func (x *SubsystemRequest) GetSubsystemName() string {
	if x != nil {
		return x.SubsystemName
	}
	return ""
}

// When the window (terminal) size changes on the client side, it MAY
// send a message to the other side to inform it of the new dimensions.
type WindowChangeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The request type field. This should always be "window-change"
	RequestType string `protobuf:"bytes,1,opt,name=request_type,json=requestType,proto3" json:"request_type,omitempty"`
	// The want_reply field on the SSH request. This should always be false.
	WantReply bool `protobuf:"varint,2,opt,name=want_reply,json=wantReply,proto3" json:"want_reply,omitempty"`
	// Terminal width, columns
	TerminalWidthColumns uint32 `protobuf:"varint,3,opt,name=terminal_width_columns,json=terminalWidthColumns,proto3" json:"terminal_width_columns,omitempty"`
	// Terminal height, rows
	TerminalHeightRows uint32 `protobuf:"varint,4,opt,name=terminal_height_rows,json=terminalHeightRows,proto3" json:"terminal_height_rows,omitempty"`
	// Terminal width, pixels
	TerminalWidthPixels uint32 `protobuf:"varint,5,opt,name=terminal_width_pixels,json=terminalWidthPixels,proto3" json:"terminal_width_pixels,omitempty"`
	// Terminal height, pixels
	TerminalHeightPixels uint32 `protobuf:"varint,6,opt,name=terminal_height_pixels,json=terminalHeightPixels,proto3" json:"terminal_height_pixels,omitempty"`
}

func (x *WindowChangeRequest) Reset() {
	*x = WindowChangeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ssh_v1_ssh_chunks_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WindowChangeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WindowChangeRequest) ProtoMessage() {}

func (x *WindowChangeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ssh_v1_ssh_chunks_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WindowChangeRequest.ProtoReflect.Descriptor instead.
func (*WindowChangeRequest) Descriptor() ([]byte, []int) {
	return file_ssh_v1_ssh_chunks_proto_rawDescGZIP(), []int{11}
}

func (x *WindowChangeRequest) GetRequestType() string {
	if x != nil {
		return x.RequestType
	}
	return ""
}

func (x *WindowChangeRequest) GetWantReply() bool {
	if x != nil {
		return x.WantReply
	}
	return false
}

func (x *WindowChangeRequest) GetTerminalWidthColumns() uint32 {
	if x != nil {
		return x.TerminalWidthColumns
	}
	return 0
}

func (x *WindowChangeRequest) GetTerminalHeightRows() uint32 {
	if x != nil {
		return x.TerminalHeightRows
	}
	return 0
}

func (x *WindowChangeRequest) GetTerminalWidthPixels() uint32 {
	if x != nil {
		return x.TerminalWidthPixels
	}
	return 0
}

func (x *WindowChangeRequest) GetTerminalHeightPixels() uint32 {
	if x != nil {
		return x.TerminalHeightPixels
	}
	return 0
}

// The message below is used by the server to inform the client when it
// can or cannot perform flow control (control-S/control-Q processing).
// If 'client can do' is TRUE, the client is allowed to do flow control
// using control-S and control-Q
type XonXoffRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The request type field. This should always be "xon-xoff"
	RequestType string `protobuf:"bytes,1,opt,name=request_type,json=requestType,proto3" json:"request_type,omitempty"`
	// The want_reply field on the SSH request. This should always be false.
	WantReply bool `protobuf:"varint,2,opt,name=want_reply,json=wantReply,proto3" json:"want_reply,omitempty"`
	// Client can do flow control
	ClientCanDo bool `protobuf:"varint,3,opt,name=client_can_do,json=clientCanDo,proto3" json:"client_can_do,omitempty"`
}

func (x *XonXoffRequest) Reset() {
	*x = XonXoffRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ssh_v1_ssh_chunks_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *XonXoffRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*XonXoffRequest) ProtoMessage() {}

func (x *XonXoffRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ssh_v1_ssh_chunks_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use XonXoffRequest.ProtoReflect.Descriptor instead.
func (*XonXoffRequest) Descriptor() ([]byte, []int) {
	return file_ssh_v1_ssh_chunks_proto_rawDescGZIP(), []int{12}
}

func (x *XonXoffRequest) GetRequestType() string {
	if x != nil {
		return x.RequestType
	}
	return ""
}

func (x *XonXoffRequest) GetWantReply() bool {
	if x != nil {
		return x.WantReply
	}
	return false
}

func (x *XonXoffRequest) GetClientCanDo() bool {
	if x != nil {
		return x.ClientCanDo
	}
	return false
}

// A signal can be delivered to the remote process/service using the
// following message.
type SignalRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The request type field. This should always be "signal"
	RequestType string `protobuf:"bytes,1,opt,name=request_type,json=requestType,proto3" json:"request_type,omitempty"`
	// The want_reply field on the SSH request. This should always be false
	WantReply bool `protobuf:"varint,2,opt,name=want_reply,json=wantReply,proto3" json:"want_reply,omitempty"`
	// Signal name, without the SIG prefix. The 'signal name' is one of the following (these are from [POSIX]).
	//
	//	ABRT   ALRM   FPE   HUP   ILL   INT   KILL
	//	PIPE   QUIT   SEGV  TERM  USR1  USR2
	SignalName string `protobuf:"bytes,3,opt,name=signal_name,json=signalName,proto3" json:"signal_name,omitempty"`
}

func (x *SignalRequest) Reset() {
	*x = SignalRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ssh_v1_ssh_chunks_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SignalRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SignalRequest) ProtoMessage() {}

func (x *SignalRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ssh_v1_ssh_chunks_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SignalRequest.ProtoReflect.Descriptor instead.
func (*SignalRequest) Descriptor() ([]byte, []int) {
	return file_ssh_v1_ssh_chunks_proto_rawDescGZIP(), []int{13}
}

func (x *SignalRequest) GetRequestType() string {
	if x != nil {
		return x.RequestType
	}
	return ""
}

func (x *SignalRequest) GetWantReply() bool {
	if x != nil {
		return x.WantReply
	}
	return false
}

func (x *SignalRequest) GetSignalName() string {
	if x != nil {
		return x.SignalName
	}
	return ""
}

// When the command running at the other end terminates, the following
//
//	message can be sent to return the exit status of the command.
type ExitStatusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The request type field. This should always be "exit-status"
	RequestType string `protobuf:"bytes,1,opt,name=request_type,json=requestType,proto3" json:"request_type,omitempty"`
	// The want_reply field on the SSH request. This should always be false.
	WantReply bool `protobuf:"varint,2,opt,name=want_reply,json=wantReply,proto3" json:"want_reply,omitempty"`
	// Exit status of the command
	ExitStatus uint32 `protobuf:"varint,3,opt,name=exit_status,json=exitStatus,proto3" json:"exit_status,omitempty"`
}

func (x *ExitStatusRequest) Reset() {
	*x = ExitStatusRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ssh_v1_ssh_chunks_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExitStatusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExitStatusRequest) ProtoMessage() {}

func (x *ExitStatusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ssh_v1_ssh_chunks_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExitStatusRequest.ProtoReflect.Descriptor instead.
func (*ExitStatusRequest) Descriptor() ([]byte, []int) {
	return file_ssh_v1_ssh_chunks_proto_rawDescGZIP(), []int{14}
}

func (x *ExitStatusRequest) GetRequestType() string {
	if x != nil {
		return x.RequestType
	}
	return ""
}

func (x *ExitStatusRequest) GetWantReply() bool {
	if x != nil {
		return x.WantReply
	}
	return false
}

func (x *ExitStatusRequest) GetExitStatus() uint32 {
	if x != nil {
		return x.ExitStatus
	}
	return 0
}

// The remote command may terminate violently due to a signal.
// Such a condition can be indicated by the following message.  A zero
// 'exit_status' usually means that the command terminated successfully.
type ExitSignalRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The request type field. This should always be "exit-signal"
	RequestType string `protobuf:"bytes,1,opt,name=request_type,json=requestType,proto3" json:"request_type,omitempty"`
	// The want_reply field on the SSH request. This should always be false.
	WantReply bool `protobuf:"varint,2,opt,name=want_reply,json=wantReply,proto3" json:"want_reply,omitempty"`
	// Signal name, without the SIG prefix. The 'signal name' is one of the following (these are from [POSIX]).
	//
	//	ABRT   ALRM   FPE   HUP   ILL   INT   KILL
	//	PIPE   QUIT   SEGV  TERM  USR1  USR2
	SignalName string `protobuf:"bytes,3,opt,name=signal_name,json=signalName,proto3" json:"signal_name,omitempty"`
	// Core dumped
	CoreDumped bool `protobuf:"varint,4,opt,name=core_dumped,json=coreDumped,proto3" json:"core_dumped,omitempty"`
	// Error message in ISO-10646 UTF-8 encoding
	ErrorMessage string `protobuf:"bytes,5,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	// Language tag from https://www.rfc-editor.org/rfc/rfc3066
	LanguageTag string `protobuf:"bytes,6,opt,name=language_tag,json=languageTag,proto3" json:"language_tag,omitempty"`
}

func (x *ExitSignalRequest) Reset() {
	*x = ExitSignalRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ssh_v1_ssh_chunks_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExitSignalRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExitSignalRequest) ProtoMessage() {}

func (x *ExitSignalRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ssh_v1_ssh_chunks_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExitSignalRequest.ProtoReflect.Descriptor instead.
func (*ExitSignalRequest) Descriptor() ([]byte, []int) {
	return file_ssh_v1_ssh_chunks_proto_rawDescGZIP(), []int{15}
}

func (x *ExitSignalRequest) GetRequestType() string {
	if x != nil {
		return x.RequestType
	}
	return ""
}

func (x *ExitSignalRequest) GetWantReply() bool {
	if x != nil {
		return x.WantReply
	}
	return false
}

func (x *ExitSignalRequest) GetSignalName() string {
	if x != nil {
		return x.SignalName
	}
	return ""
}

func (x *ExitSignalRequest) GetCoreDumped() bool {
	if x != nil {
		return x.CoreDumped
	}
	return false
}

func (x *ExitSignalRequest) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

func (x *ExitSignalRequest) GetLanguageTag() string {
	if x != nil {
		return x.LanguageTag
	}
	return ""
}

// The following channel-specific request can be sent over a session
// channel to request that the remote host perform
// a BREAK operation.
type BreakRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The request type field. This should always be "break"
	RequestType string `protobuf:"bytes,1,opt,name=request_type,json=requestType,proto3" json:"request_type,omitempty"`
	// The want_reply field on the SSH request. This should always be false.
	WantReply bool `protobuf:"varint,2,opt,name=want_reply,json=wantReply,proto3" json:"want_reply,omitempty"`
	// Break-length in milliseconds
	BreakLengthMs uint32 `protobuf:"varint,3,opt,name=break_length_ms,json=breakLengthMs,proto3" json:"break_length_ms,omitempty"`
}

func (x *BreakRequest) Reset() {
	*x = BreakRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ssh_v1_ssh_chunks_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BreakRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BreakRequest) ProtoMessage() {}

func (x *BreakRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ssh_v1_ssh_chunks_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BreakRequest.ProtoReflect.Descriptor instead.
func (*BreakRequest) Descriptor() ([]byte, []int) {
	return file_ssh_v1_ssh_chunks_proto_rawDescGZIP(), []int{16}
}

func (x *BreakRequest) GetRequestType() string {
	if x != nil {
		return x.RequestType
	}
	return ""
}

func (x *BreakRequest) GetWantReply() bool {
	if x != nil {
		return x.WantReply
	}
	return false
}

func (x *BreakRequest) GetBreakLengthMs() uint32 {
	if x != nil {
		return x.BreakLengthMs
	}
	return 0
}

// A party need not explicitly request forwardings from its own end to
// the other direction.  However, if it wishes that connections to a
// port on the other side be forwarded to the local side, it must
// explicitly request this.
type TCPIPForwardRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The request type field. This should always be "tcpip-forward"
	RequestType string `protobuf:"bytes,1,opt,name=request_type,json=requestType,proto3" json:"request_type,omitempty"`
	// The want_reply field on the SSH request. This should always be false.
	WantReply bool `protobuf:"varint,2,opt,name=want_reply,json=wantReply,proto3" json:"want_reply,omitempty"`
	// Address to bind (e.g., "0.0.0.0") on which connections for forwarding
	// are to be accepted
	AddressToBind string `protobuf:"bytes,3,opt,name=address_to_bind,json=addressToBind,proto3" json:"address_to_bind,omitempty"`
	// Port number to bind on which connections for forwarding
	// are to be accepted
	PortToBind uint32 `protobuf:"varint,4,opt,name=port_to_bind,json=portToBind,proto3" json:"port_to_bind,omitempty"`
}

func (x *TCPIPForwardRequest) Reset() {
	*x = TCPIPForwardRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ssh_v1_ssh_chunks_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TCPIPForwardRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TCPIPForwardRequest) ProtoMessage() {}

func (x *TCPIPForwardRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ssh_v1_ssh_chunks_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TCPIPForwardRequest.ProtoReflect.Descriptor instead.
func (*TCPIPForwardRequest) Descriptor() ([]byte, []int) {
	return file_ssh_v1_ssh_chunks_proto_rawDescGZIP(), []int{17}
}

func (x *TCPIPForwardRequest) GetRequestType() string {
	if x != nil {
		return x.RequestType
	}
	return ""
}

func (x *TCPIPForwardRequest) GetWantReply() bool {
	if x != nil {
		return x.WantReply
	}
	return false
}

func (x *TCPIPForwardRequest) GetAddressToBind() string {
	if x != nil {
		return x.AddressToBind
	}
	return ""
}

func (x *TCPIPForwardRequest) GetPortToBind() uint32 {
	if x != nil {
		return x.PortToBind
	}
	return 0
}

// A port forwarding can be canceled with the following message.  Note
// that channel open requests may be received until a reply to this
// message is received.
type CancelTCPIPForwardRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The request type field. This should always be "cancel-tcpip-forward"
	RequestType string `protobuf:"bytes,1,opt,name=request_type,json=requestType,proto3" json:"request_type,omitempty"`
	// The want_reply field on the SSH request. This should always be false.
	WantReply bool `protobuf:"varint,2,opt,name=want_reply,json=wantReply,proto3" json:"want_reply,omitempty"`
	// Address to bind (e.g., "0.0.0.0") on which connections for forwarding
	// are to be accepted
	AddressToBind string `protobuf:"bytes,3,opt,name=address_to_bind,json=addressToBind,proto3" json:"address_to_bind,omitempty"`
	// Port number to bind on which connections for forwarding
	// are to be accepted
	PortToBind uint32 `protobuf:"varint,4,opt,name=port_to_bind,json=portToBind,proto3" json:"port_to_bind,omitempty"`
}

func (x *CancelTCPIPForwardRequest) Reset() {
	*x = CancelTCPIPForwardRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_ssh_v1_ssh_chunks_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CancelTCPIPForwardRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelTCPIPForwardRequest) ProtoMessage() {}

func (x *CancelTCPIPForwardRequest) ProtoReflect() protoreflect.Message {
	mi := &file_ssh_v1_ssh_chunks_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelTCPIPForwardRequest.ProtoReflect.Descriptor instead.
func (*CancelTCPIPForwardRequest) Descriptor() ([]byte, []int) {
	return file_ssh_v1_ssh_chunks_proto_rawDescGZIP(), []int{18}
}

func (x *CancelTCPIPForwardRequest) GetRequestType() string {
	if x != nil {
		return x.RequestType
	}
	return ""
}

func (x *CancelTCPIPForwardRequest) GetWantReply() bool {
	if x != nil {
		return x.WantReply
	}
	return false
}

func (x *CancelTCPIPForwardRequest) GetAddressToBind() string {
	if x != nil {
		return x.AddressToBind
	}
	return ""
}

func (x *CancelTCPIPForwardRequest) GetPortToBind() uint32 {
	if x != nil {
		return x.PortToBind
	}
	return 0
}

var File_ssh_v1_ssh_chunks_proto protoreflect.FileDescriptor

var file_ssh_v1_ssh_chunks_proto_rawDesc = []byte{
	0x0a, 0x17, 0x73, 0x73, 0x68, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x73, 0x68, 0x5f, 0x63, 0x68, 0x75,
	0x6e, 0x6b, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x06, 0x73, 0x73, 0x68, 0x2e, 0x76,
	0x31, 0x22, 0x66, 0x0a, 0x0e, 0x55, 0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x77, 0x61, 0x6e, 0x74, 0x5f, 0x72,
	0x65, 0x70, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x77, 0x61, 0x6e, 0x74,
	0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x22, 0xba, 0x01, 0x0a, 0x0e, 0x53, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x25, 0x0a, 0x0e, 0x73, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0d, 0x73, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x43,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x2e, 0x0a, 0x13, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61,
	0x6c, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x11, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x57, 0x69, 0x6e, 0x64,
	0x6f, 0x77, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x2e, 0x0a, 0x13, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75,
	0x6d, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x11, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x50, 0x61, 0x63, 0x6b,
	0x65, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x8e, 0x02, 0x0a, 0x0a, 0x58, 0x31, 0x31, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x65, 0x6e, 0x64,
	0x65, 0x72, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x0d, 0x73, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12,
	0x2e, 0x0a, 0x13, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f,
	0x77, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x11, 0x69, 0x6e,
	0x69, 0x74, 0x69, 0x61, 0x6c, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x2e, 0x0a, 0x13, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x65,
	0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x11, 0x6d, 0x61,
	0x78, 0x69, 0x6d, 0x75, 0x6d, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x2d, 0x0a, 0x12, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x61, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x6f, 0x72, 0x69,
	0x67, 0x69, 0x6e, 0x61, 0x74, 0x6f, 0x72, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x27,
	0x0a, 0x0f, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x70, 0x6f, 0x72,
	0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0e, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61,
	0x74, 0x6f, 0x72, 0x50, 0x6f, 0x72, 0x74, 0x22, 0xcc, 0x02, 0x0a, 0x15, 0x46, 0x6f, 0x72, 0x77,
	0x61, 0x72, 0x64, 0x65, 0x64, 0x54, 0x43, 0x50, 0x49, 0x50, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x5f, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0d, 0x73, 0x65,
	0x6e, 0x64, 0x65, 0x72, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x2e, 0x0a, 0x13, 0x69,
	0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x11, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61,
	0x6c, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x2e, 0x0a, 0x13, 0x6d,
	0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x11, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75,
	0x6d, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x61,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x61, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x32, 0x0a, 0x15, 0x6f, 0x72, 0x69,
	0x67, 0x69, 0x6e, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e,
	0x61, 0x74, 0x6f, 0x72, 0x49, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x27, 0x0a,
	0x0f, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x70, 0x6f, 0x72, 0x74,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0e, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x74,
	0x6f, 0x72, 0x50, 0x6f, 0x72, 0x74, 0x22, 0xc3, 0x02, 0x0a, 0x12, 0x44, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x54, 0x43, 0x50, 0x49, 0x50, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a,
	0x0c, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x25, 0x0a, 0x0e, 0x73, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0d, 0x73, 0x65, 0x6e, 0x64, 0x65, 0x72,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x2e, 0x0a, 0x13, 0x69, 0x6e, 0x69, 0x74, 0x69,
	0x61, 0x6c, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x11, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x57, 0x69, 0x6e,
	0x64, 0x6f, 0x77, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x2e, 0x0a, 0x13, 0x6d, 0x61, 0x78, 0x69, 0x6d,
	0x75, 0x6d, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x11, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x50, 0x61, 0x63,
	0x6b, 0x65, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x68, 0x6f, 0x73, 0x74, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x68, 0x6f, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x70,
	0x6f, 0x72, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x12,
	0x32, 0x0a, 0x15, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x69, 0x70,
	0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13,
	0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x6f, 0x72, 0x49, 0x70, 0x41, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x6f,
	0x72, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0e, 0x6f, 0x72,
	0x69, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x6f, 0x72, 0x50, 0x6f, 0x72, 0x74, 0x22, 0xfc, 0x02, 0x0a,
	0x0a, 0x50, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x77, 0x61, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x09, 0x77, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x20, 0x0a,
	0x0c, 0x74, 0x65, 0x72, 0x6d, 0x5f, 0x65, 0x6e, 0x76, 0x5f, 0x76, 0x61, 0x72, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x74, 0x65, 0x72, 0x6d, 0x45, 0x6e, 0x76, 0x56, 0x61, 0x72, 0x12,
	0x3a, 0x0a, 0x19, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x77, 0x69, 0x64, 0x74,
	0x68, 0x5f, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x17, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x6c, 0x57, 0x69, 0x64, 0x74,
	0x68, 0x43, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x12, 0x30, 0x0a, 0x14, 0x74,
	0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x5f, 0x72,
	0x6f, 0x77, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x12, 0x74, 0x65, 0x72, 0x6d, 0x69,
	0x6e, 0x61, 0x6c, 0x48, 0x65, 0x69, 0x67, 0x68, 0x74, 0x52, 0x6f, 0x77, 0x73, 0x12, 0x32, 0x0a,
	0x15, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x77, 0x69, 0x64, 0x74, 0x68, 0x5f,
	0x70, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x13, 0x74, 0x65,
	0x72, 0x6d, 0x69, 0x6e, 0x61, 0x6c, 0x57, 0x69, 0x64, 0x74, 0x68, 0x50, 0x69, 0x78, 0x65, 0x6c,
	0x73, 0x12, 0x34, 0x0a, 0x16, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x68, 0x65,
	0x69, 0x67, 0x68, 0x74, 0x5f, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x14, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x6c, 0x48, 0x65, 0x69, 0x67, 0x68,
	0x74, 0x50, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x65, 0x6e, 0x63, 0x6f, 0x64,
	0x65, 0x64, 0x5f, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x6d, 0x6f, 0x64, 0x65,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x13, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x64, 0x54,
	0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x6c, 0x4d, 0x6f, 0x64, 0x65, 0x22, 0xad, 0x02, 0x0a, 0x14,
	0x58, 0x31, 0x31, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x77, 0x61, 0x6e, 0x74, 0x5f,
	0x72, 0x65, 0x70, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x77, 0x61, 0x6e,
	0x74, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x2b, 0x0a, 0x11, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x10, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x0a, 0x1b, 0x78, 0x31, 0x31, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x65,
	0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x6f, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x19, 0x78, 0x31, 0x31, 0x41, 0x75, 0x74,
	0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x12, 0x3a, 0x0a, 0x19, 0x78, 0x31, 0x31, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x65,
	0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6f, 0x6b, 0x69, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x17, 0x78, 0x31, 0x31, 0x41, 0x75, 0x74, 0x68, 0x65,
	0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x12,
	0x2a, 0x0a, 0x11, 0x78, 0x31, 0x31, 0x5f, 0x73, 0x63, 0x72, 0x65, 0x65, 0x6e, 0x5f, 0x6e, 0x75,
	0x6d, 0x62, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0f, 0x78, 0x31, 0x31, 0x53,
	0x63, 0x72, 0x65, 0x65, 0x6e, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x22, 0x9a, 0x01, 0x0a, 0x0a,
	0x45, 0x6e, 0x76, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x77, 0x61, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x09, 0x77, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x23, 0x0a, 0x0d,
	0x76, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x76, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x25, 0x0a, 0x0e, 0x76, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x76, 0x61, 0x72, 0x69, 0x61,
	0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x50, 0x0a, 0x0c, 0x53, 0x68, 0x65, 0x6c,
	0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x77,
	0x61, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x09, 0x77, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x22, 0x69, 0x0a, 0x0b, 0x45, 0x78,
	0x65, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x77, 0x61, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x09, 0x77, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x18, 0x0a, 0x07, 0x63,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x22, 0x7b, 0x0a, 0x10, 0x53, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74,
	0x65, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x77, 0x61, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x09, 0x77, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x25, 0x0a, 0x0e, 0x73,
	0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x4e, 0x61,
	0x6d, 0x65, 0x22, 0xa9, 0x02, 0x0a, 0x13, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x43, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x77, 0x61, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x09, 0x77, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x34, 0x0a, 0x16,
	0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x77, 0x69, 0x64, 0x74, 0x68, 0x5f, 0x63,
	0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x14, 0x74, 0x65,
	0x72, 0x6d, 0x69, 0x6e, 0x61, 0x6c, 0x57, 0x69, 0x64, 0x74, 0x68, 0x43, 0x6f, 0x6c, 0x75, 0x6d,
	0x6e, 0x73, 0x12, 0x30, 0x0a, 0x14, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x68,
	0x65, 0x69, 0x67, 0x68, 0x74, 0x5f, 0x72, 0x6f, 0x77, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x12, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x6c, 0x48, 0x65, 0x69, 0x67, 0x68, 0x74,
	0x52, 0x6f, 0x77, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x6c,
	0x5f, 0x77, 0x69, 0x64, 0x74, 0x68, 0x5f, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x13, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x6c, 0x57, 0x69, 0x64,
	0x74, 0x68, 0x50, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x12, 0x34, 0x0a, 0x16, 0x74, 0x65, 0x72, 0x6d,
	0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x5f, 0x70, 0x69, 0x78, 0x65,
	0x6c, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x14, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e,
	0x61, 0x6c, 0x48, 0x65, 0x69, 0x67, 0x68, 0x74, 0x50, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x22, 0x76,
	0x0a, 0x0e, 0x58, 0x6f, 0x6e, 0x58, 0x6f, 0x66, 0x66, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x77, 0x61, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x70, 0x6c,
	0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x77, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x70,
	0x6c, 0x79, 0x12, 0x22, 0x0a, 0x0d, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x61, 0x6e,
	0x5f, 0x64, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x43, 0x61, 0x6e, 0x44, 0x6f, 0x22, 0x72, 0x0a, 0x0d, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x77, 0x61,
	0x6e, 0x74, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09,
	0x77, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x69, 0x67,
	0x6e, 0x61, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x76, 0x0a, 0x11, 0x45, 0x78,
	0x69, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x21, 0x0a, 0x0c, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x77, 0x61, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x79,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x77, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x70, 0x6c,
	0x79, 0x12, 0x1f, 0x0a, 0x0b, 0x65, 0x78, 0x69, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0a, 0x65, 0x78, 0x69, 0x74, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x22, 0xdf, 0x01, 0x0a, 0x11, 0x45, 0x78, 0x69, 0x74, 0x53, 0x69, 0x67, 0x6e, 0x61,
	0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x77,
	0x61, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x09, 0x77, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x69,
	0x67, 0x6e, 0x61, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x63,
	0x6f, 0x72, 0x65, 0x5f, 0x64, 0x75, 0x6d, 0x70, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0a, 0x63, 0x6f, 0x72, 0x65, 0x44, 0x75, 0x6d, 0x70, 0x65, 0x64, 0x12, 0x23, 0x0a, 0x0d,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x12, 0x21, 0x0a, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x61,
	0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x54, 0x61, 0x67, 0x22, 0x78, 0x0a, 0x0c, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x77, 0x61, 0x6e, 0x74, 0x5f,
	0x72, 0x65, 0x70, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x77, 0x61, 0x6e,
	0x74, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x26, 0x0a, 0x0f, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x5f,
	0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x5f, 0x6d, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x0d, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x4d, 0x73, 0x22, 0xa1,
	0x01, 0x0a, 0x13, 0x54, 0x43, 0x50, 0x49, 0x50, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x77, 0x61, 0x6e,
	0x74, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x77,
	0x61, 0x6e, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x26, 0x0a, 0x0f, 0x61, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x5f, 0x74, 0x6f, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x54, 0x6f, 0x42, 0x69, 0x6e, 0x64,
	0x12, 0x20, 0x0a, 0x0c, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x74, 0x6f, 0x5f, 0x62, 0x69, 0x6e, 0x64,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0a, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x6f, 0x42, 0x69,
	0x6e, 0x64, 0x22, 0xa7, 0x01, 0x0a, 0x19, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x54, 0x43, 0x50,
	0x49, 0x50, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x77, 0x61, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x70, 0x6c,
	0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x77, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x70,
	0x6c, 0x79, 0x12, 0x26, 0x0a, 0x0f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x74, 0x6f,
	0x5f, 0x62, 0x69, 0x6e, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x61, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x54, 0x6f, 0x42, 0x69, 0x6e, 0x64, 0x12, 0x20, 0x0a, 0x0c, 0x70, 0x6f,
	0x72, 0x74, 0x5f, 0x74, 0x6f, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x0a, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x6f, 0x42, 0x69, 0x6e, 0x64, 0x42, 0x92, 0x01, 0x0a,
	0x0a, 0x63, 0x6f, 0x6d, 0x2e, 0x73, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x42, 0x0e, 0x53, 0x73, 0x68,
	0x43, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3b, 0x67,
	0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63,
	0x6f, 0x72, 0x70, 0x2f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x2f, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2f, 0x62, 0x73, 0x72, 0x2f, 0x67, 0x65, 0x6e, 0x2f, 0x73, 0x73,
	0x68, 0x2f, 0x76, 0x31, 0x3b, 0x73, 0x73, 0x68, 0x76, 0x31, 0xa2, 0x02, 0x03, 0x53, 0x58, 0x58,
	0xaa, 0x02, 0x06, 0x53, 0x73, 0x68, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x06, 0x53, 0x73, 0x68, 0x5c,
	0x56, 0x31, 0xe2, 0x02, 0x12, 0x53, 0x73, 0x68, 0x5c, 0x56, 0x31, 0x5c, 0x47, 0x50, 0x42, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xea, 0x02, 0x07, 0x53, 0x73, 0x68, 0x3a, 0x3a, 0x56,
	0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_ssh_v1_ssh_chunks_proto_rawDescOnce sync.Once
	file_ssh_v1_ssh_chunks_proto_rawDescData = file_ssh_v1_ssh_chunks_proto_rawDesc
)

func file_ssh_v1_ssh_chunks_proto_rawDescGZIP() []byte {
	file_ssh_v1_ssh_chunks_proto_rawDescOnce.Do(func() {
		file_ssh_v1_ssh_chunks_proto_rawDescData = protoimpl.X.CompressGZIP(file_ssh_v1_ssh_chunks_proto_rawDescData)
	})
	return file_ssh_v1_ssh_chunks_proto_rawDescData
}

var file_ssh_v1_ssh_chunks_proto_msgTypes = make([]protoimpl.MessageInfo, 19)
var file_ssh_v1_ssh_chunks_proto_goTypes = []any{
	(*UnknownRequest)(nil),            // 0: ssh.v1.UnknownRequest
	(*SessionRequest)(nil),            // 1: ssh.v1.SessionRequest
	(*X11Request)(nil),                // 2: ssh.v1.X11Request
	(*ForwardedTCPIPRequest)(nil),     // 3: ssh.v1.ForwardedTCPIPRequest
	(*DirectTCPIPRequest)(nil),        // 4: ssh.v1.DirectTCPIPRequest
	(*PtyRequest)(nil),                // 5: ssh.v1.PtyRequest
	(*X11ForwardingRequest)(nil),      // 6: ssh.v1.X11ForwardingRequest
	(*EnvRequest)(nil),                // 7: ssh.v1.EnvRequest
	(*ShellRequest)(nil),              // 8: ssh.v1.ShellRequest
	(*ExecRequest)(nil),               // 9: ssh.v1.ExecRequest
	(*SubsystemRequest)(nil),          // 10: ssh.v1.SubsystemRequest
	(*WindowChangeRequest)(nil),       // 11: ssh.v1.WindowChangeRequest
	(*XonXoffRequest)(nil),            // 12: ssh.v1.XonXoffRequest
	(*SignalRequest)(nil),             // 13: ssh.v1.SignalRequest
	(*ExitStatusRequest)(nil),         // 14: ssh.v1.ExitStatusRequest
	(*ExitSignalRequest)(nil),         // 15: ssh.v1.ExitSignalRequest
	(*BreakRequest)(nil),              // 16: ssh.v1.BreakRequest
	(*TCPIPForwardRequest)(nil),       // 17: ssh.v1.TCPIPForwardRequest
	(*CancelTCPIPForwardRequest)(nil), // 18: ssh.v1.CancelTCPIPForwardRequest
}
var file_ssh_v1_ssh_chunks_proto_depIdxs = []int32{
	0, // [0:0] is the sub-list for method output_type
	0, // [0:0] is the sub-list for method input_type
	0, // [0:0] is the sub-list for extension type_name
	0, // [0:0] is the sub-list for extension extendee
	0, // [0:0] is the sub-list for field type_name
}

func init() { file_ssh_v1_ssh_chunks_proto_init() }
func file_ssh_v1_ssh_chunks_proto_init() {
	if File_ssh_v1_ssh_chunks_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_ssh_v1_ssh_chunks_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*UnknownRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ssh_v1_ssh_chunks_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*SessionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ssh_v1_ssh_chunks_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*X11Request); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ssh_v1_ssh_chunks_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*ForwardedTCPIPRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ssh_v1_ssh_chunks_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*DirectTCPIPRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ssh_v1_ssh_chunks_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*PtyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ssh_v1_ssh_chunks_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*X11ForwardingRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ssh_v1_ssh_chunks_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*EnvRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ssh_v1_ssh_chunks_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*ShellRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ssh_v1_ssh_chunks_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*ExecRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ssh_v1_ssh_chunks_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*SubsystemRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ssh_v1_ssh_chunks_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*WindowChangeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ssh_v1_ssh_chunks_proto_msgTypes[12].Exporter = func(v any, i int) any {
			switch v := v.(*XonXoffRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ssh_v1_ssh_chunks_proto_msgTypes[13].Exporter = func(v any, i int) any {
			switch v := v.(*SignalRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ssh_v1_ssh_chunks_proto_msgTypes[14].Exporter = func(v any, i int) any {
			switch v := v.(*ExitStatusRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ssh_v1_ssh_chunks_proto_msgTypes[15].Exporter = func(v any, i int) any {
			switch v := v.(*ExitSignalRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ssh_v1_ssh_chunks_proto_msgTypes[16].Exporter = func(v any, i int) any {
			switch v := v.(*BreakRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ssh_v1_ssh_chunks_proto_msgTypes[17].Exporter = func(v any, i int) any {
			switch v := v.(*TCPIPForwardRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_ssh_v1_ssh_chunks_proto_msgTypes[18].Exporter = func(v any, i int) any {
			switch v := v.(*CancelTCPIPForwardRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_ssh_v1_ssh_chunks_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   19,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_ssh_v1_ssh_chunks_proto_goTypes,
		DependencyIndexes: file_ssh_v1_ssh_chunks_proto_depIdxs,
		MessageInfos:      file_ssh_v1_ssh_chunks_proto_msgTypes,
	}.Build()
	File_ssh_v1_ssh_chunks_proto = out.File
	file_ssh_v1_ssh_chunks_proto_rawDesc = nil
	file_ssh_v1_ssh_chunks_proto_goTypes = nil
	file_ssh_v1_ssh_chunks_proto_depIdxs = nil
}
