// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: BUSL-1.1

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        (unknown)
// source: controller/storage/auth/oidc/store/v1/oidc.proto

// Package store provides protobufs for storing types in the password package.

package store

import (
	timestamp "github.com/hashicorp/boundary/internal/db/timestamp"
	_ "github.com/hashicorp/boundary/sdk/pbs/controller/protooptions"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// AuthMethod represents an OIDC auth method.
type AuthMethod struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// @inject_tag: `gorm:"primary_key"`
	PublicId string `protobuf:"bytes,10,opt,name=public_id,json=publicId,proto3" json:"public_id,omitempty" gorm:"primary_key"`
	// The create_time is set by the database.
	// @inject_tag: `gorm:"default:current_timestamp"`
	CreateTime *timestamp.Timestamp `protobuf:"bytes,20,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty" gorm:"default:current_timestamp"`
	// The update_time is set by the database.
	// @inject_tag: `gorm:"default:current_timestamp"`
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,30,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty" gorm:"default:current_timestamp"`
	// name is optional. If set, it must be unique within scope_id.
	// @inject_tag: `gorm:"default:null"`
	Name string `protobuf:"bytes,40,opt,name=name,proto3" json:"name,omitempty" gorm:"default:null"`
	// description is optional.
	// @inject_tag: `gorm:"default:null"`
	Description string `protobuf:"bytes,50,opt,name=description,proto3" json:"description,omitempty" gorm:"default:null"`
	// The scope_id of the owning scope. Must be set.
	// @inject_tag: `gorm:"not_null"`
	ScopeId string `protobuf:"bytes,60,opt,name=scope_id,json=scopeId,proto3" json:"scope_id,omitempty" gorm:"not_null"`
	// @inject_tag: `gorm:"default:null"`
	Version uint32 `protobuf:"varint,70,opt,name=version,proto3" json:"version,omitempty" gorm:"default:null"`
	// is_primary_auth_method is a read-only output field which indicates if the
	// auth method is set as the scope's primary auth method.
	// @inject_tag: `gorm:"-"`
	IsPrimaryAuthMethod bool `protobuf:"varint,75,opt,name=is_primary_auth_method,json=isPrimaryAuthMethod,proto3" json:"is_primary_auth_method,omitempty" gorm:"-"`
	// operational_state is the current state of the auth_oidc_method (inactive,
	// active-private, or active-public).
	// @inject_tag: `gorm:"column:state;not_null"`
	OperationalState string `protobuf:"bytes,80,opt,name=operational_state,json=operationalState,proto3" json:"operational_state,omitempty" gorm:"column:state;not_null"`
	// disable_discovered_config_validation is a flag that when set to true
	// indicates the AuthMethod config was not validated against the IdP's
	// discovery info document when it was updated or its operational_state was
	// changed.
	// @inject_tag: `gorm:"not_null"`
	DisableDiscoveredConfigValidation bool `protobuf:"varint,89,opt,name=disable_discovered_config_validation,json=disableDiscoveredConfigValidation,proto3" json:"disable_discovered_config_validation,omitempty" gorm:"not_null"`
	// issuer is the OIDC Discovery URL without any .well-known component
	// @inject_tag: `gorm:"default:null"`
	Issuer string `protobuf:"bytes,90,opt,name=issuer,proto3" json:"issuer,omitempty" gorm:"default:null"`
	// client_id is the OIDC client identifier
	// @inject_tag: `gorm:"not_null"`
	ClientId string `protobuf:"bytes,100,opt,name=client_id,json=clientId,proto3" json:"client_id,omitempty" gorm:"not_null"`
	// ct_client_secret is the encrypted OIDC client secret which is stored in the db.
	// @inject_tag: `gorm:"column:client_secret;not_null" wrapping:"ct,client_secret"`
	CtClientSecret []byte `protobuf:"bytes,110,opt,name=ct_client_secret,json=ctClientSecret,proto3" json:"ct_client_secret,omitempty" gorm:"column:client_secret;not_null" wrapping:"ct,client_secret"`
	// client_secret is the unencrypted OIDC client secret which is not stored in the database.
	// @inject_tag: `gorm:"-" wrapping:"pt,client_secret"`
	ClientSecret string `protobuf:"bytes,120,opt,name=client_secret,json=clientSecret,proto3" json:"client_secret,omitempty" gorm:"-" wrapping:"pt,client_secret"`
	// client_secret_hmac is a sha256-hmac of the unencrypted client_secret that
	// is returned from the API for read.  It is recalculated everytime the raw
	// client_secret is updated.
	// @inject_tag: `gorm:"not_null"`
	ClientSecretHmac string `protobuf:"bytes,130,opt,name=client_secret_hmac,json=clientSecretHmac,proto3" json:"client_secret_hmac,omitempty" gorm:"not_null"`
	// key_id is the key ID that was used for the encryption operation. It can be
	// used to identify a specific version of the key needed to decrypt the value,
	// which is useful for caching purposes.
	// @inject_tag: `gorm:"not_null"`
	KeyId string `protobuf:"bytes,140,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty" gorm:"not_null"`
	// max_age is the allowed elapsed time in seconds since the last time the user
	// was actively authenticated by the OIDC provider. -1 indicates the user
	// should be re-authenticated immediately and would represent the zero value
	// for max age based on the oidc spec.
	// @inject_tag: `gorm:"default:null"`
	MaxAge int32 `protobuf:"varint,150,opt,name=max_age,json=maxAge,proto3" json:"max_age,omitempty" gorm:"default:null"`
	// api_url is the URLs prefix at which the Boundary api is reachable. This value
	// is used by the auth method in the different steps of the auth flow.
	// @inject_tag: `gorm:"default:null"`
	ApiUrl string `protobuf:"bytes,160,opt,name=api_url,json=apiUrl,proto3" json:"api_url,omitempty" gorm:"default:null"`
	// signing_algs are the signing algorithms allowed for an oidc auth method.
	// These are Value Objects that will be stored as SigningAlg messages, and are
	// operated on as a complete set.
	// @inject_tag: `gorm:"-"`
	SigningAlgs []string `protobuf:"bytes,170,rep,name=signing_algs,json=signingAlgs,proto3" json:"signing_algs,omitempty" gorm:"-"`
	// aud_claims are the audience claims for a specific oidc auth method. These
	// are Value Objects that will be stored as AudClaim messages, and are
	// operatated on as a complete set.
	// @inject_tag: `gorm:"-"`
	AudClaims []string `protobuf:"bytes,180,rep,name=aud_claims,json=audClaims,proto3" json:"aud_claims,omitempty" gorm:"-"`
	// certificates are optional PEM encoded x509 certificates that can be
	// used as trust anchors when connecting to an OIDC provider. These are Value
	// Objects that will be stored as Certificate messages, and are operatated on
	// as a complete set.
	// @inject_tag: `gorm:"-"`
	Certificates []string `protobuf:"bytes,190,rep,name=certificates,proto3" json:"certificates,omitempty" gorm:"-"`
	// claims_scopes are the optional claims scopes a specific oidc auth method.
	// These are Value Objects that will be stored as ClaimsScope messages, and
	// are operatated on as a complete set.
	// @inject_tag: `gorm:"-"`
	ClaimsScopes []string `protobuf:"bytes,200,rep,name=claims_scopes,json=claimsScopes,proto3" json:"claims_scopes,omitempty" gorm:"-"`
	// account_claim_maps are optional claim maps from custom claims to the
	// standard claims of sub, name and email.  These maps are represented as
	// key=value where the key equals the from_claim and the value equals the
	// to_claim.  For example "oid=sub".
	// @inject_tag: `gorm:"-"`
	AccountClaimMaps []string `protobuf:"bytes,210,rep,name=account_claim_maps,json=accountClaimMaps,proto3" json:"account_claim_maps,omitempty" gorm:"-"`
	// prompts are the optional prompts allowed for an oidc auth method.
	// These value objects specify whether the authorization server prompts
	// the end-user for reauthentication, account selection and consent.
	// These are Value Objects that will be stored as Prompt messages,
	// and are operatated on as a complete set.
	// @inject_tag: `gorm:"-"`
	Prompts []string `protobuf:"bytes,220,rep,name=prompts,proto3" json:"prompts,omitempty" gorm:"-"`
}

func (x *AuthMethod) Reset() {
	*x = AuthMethod{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_storage_auth_oidc_store_v1_oidc_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthMethod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthMethod) ProtoMessage() {}

func (x *AuthMethod) ProtoReflect() protoreflect.Message {
	mi := &file_controller_storage_auth_oidc_store_v1_oidc_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthMethod.ProtoReflect.Descriptor instead.
func (*AuthMethod) Descriptor() ([]byte, []int) {
	return file_controller_storage_auth_oidc_store_v1_oidc_proto_rawDescGZIP(), []int{0}
}

func (x *AuthMethod) GetPublicId() string {
	if x != nil {
		return x.PublicId
	}
	return ""
}

func (x *AuthMethod) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *AuthMethod) GetUpdateTime() *timestamp.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *AuthMethod) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AuthMethod) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *AuthMethod) GetScopeId() string {
	if x != nil {
		return x.ScopeId
	}
	return ""
}

func (x *AuthMethod) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *AuthMethod) GetIsPrimaryAuthMethod() bool {
	if x != nil {
		return x.IsPrimaryAuthMethod
	}
	return false
}

func (x *AuthMethod) GetOperationalState() string {
	if x != nil {
		return x.OperationalState
	}
	return ""
}

func (x *AuthMethod) GetDisableDiscoveredConfigValidation() bool {
	if x != nil {
		return x.DisableDiscoveredConfigValidation
	}
	return false
}

func (x *AuthMethod) GetIssuer() string {
	if x != nil {
		return x.Issuer
	}
	return ""
}

func (x *AuthMethod) GetClientId() string {
	if x != nil {
		return x.ClientId
	}
	return ""
}

func (x *AuthMethod) GetCtClientSecret() []byte {
	if x != nil {
		return x.CtClientSecret
	}
	return nil
}

func (x *AuthMethod) GetClientSecret() string {
	if x != nil {
		return x.ClientSecret
	}
	return ""
}

func (x *AuthMethod) GetClientSecretHmac() string {
	if x != nil {
		return x.ClientSecretHmac
	}
	return ""
}

func (x *AuthMethod) GetKeyId() string {
	if x != nil {
		return x.KeyId
	}
	return ""
}

func (x *AuthMethod) GetMaxAge() int32 {
	if x != nil {
		return x.MaxAge
	}
	return 0
}

func (x *AuthMethod) GetApiUrl() string {
	if x != nil {
		return x.ApiUrl
	}
	return ""
}

func (x *AuthMethod) GetSigningAlgs() []string {
	if x != nil {
		return x.SigningAlgs
	}
	return nil
}

func (x *AuthMethod) GetAudClaims() []string {
	if x != nil {
		return x.AudClaims
	}
	return nil
}

func (x *AuthMethod) GetCertificates() []string {
	if x != nil {
		return x.Certificates
	}
	return nil
}

func (x *AuthMethod) GetClaimsScopes() []string {
	if x != nil {
		return x.ClaimsScopes
	}
	return nil
}

func (x *AuthMethod) GetAccountClaimMaps() []string {
	if x != nil {
		return x.AccountClaimMaps
	}
	return nil
}

func (x *AuthMethod) GetPrompts() []string {
	if x != nil {
		return x.Prompts
	}
	return nil
}

// Account represents an OIDC account
// the scope_id column is not included here as it is used only to ensure
// data integrity in the database between iam users and auth methods.
type Account struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// @inject_tag: `gorm:"primary_key"`
	PublicId string `protobuf:"bytes,10,opt,name=public_id,json=publicId,proto3" json:"public_id,omitempty" gorm:"primary_key"`
	// The create_time is set by the database.
	// @inject_tag: `gorm:"default:current_timestamp"`
	CreateTime *timestamp.Timestamp `protobuf:"bytes,20,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty" gorm:"default:current_timestamp"`
	// The update_time is set by the database.
	// @inject_tag: `gorm:"default:current_timestamp"`
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,30,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty" gorm:"default:current_timestamp"`
	// name is optional. If set, it must be unique within scope_id.
	// @inject_tag: `gorm:"default:null"`
	Name string `protobuf:"bytes,40,opt,name=name,proto3" json:"name,omitempty" gorm:"default:null"`
	// description is optional.
	// @inject_tag: `gorm:"default:null"`
	Description string `protobuf:"bytes,50,opt,name=description,proto3" json:"description,omitempty" gorm:"default:null"`
	// @inject_tag: `gorm:"default:null"`
	Version uint32 `protobuf:"varint,60,opt,name=version,proto3" json:"version,omitempty" gorm:"default:null"`
	// auth_method_id is the fk to the account's auth method.
	// @inject_tag: `gorm:"not_null"`
	AuthMethodId string `protobuf:"bytes,70,opt,name=auth_method_id,json=authMethodId,proto3" json:"auth_method_id,omitempty" gorm:"not_null"`
	// issuer is a case sensitive URL that maps to the OIDC iss claim
	// @inject_tag: `gorm:"not_null"`
	Issuer string `protobuf:"bytes,80,opt,name=issuer,proto3" json:"issuer,omitempty" gorm:"not_null"`
	// subject is a case sensitive string that maps to the OIDC sub claim.
	// @inject_tag: `gorm:"not_null"`
	Subject string `protobuf:"bytes,90,opt,name=subject,proto3" json:"subject,omitempty" gorm:"not_null"`
	// full_name is a string that maps to the OIDC name claim
	// @inject_tag: `gorm:"default:null"`
	FullName string `protobuf:"bytes,100,opt,name=full_name,json=fullName,proto3" json:"full_name,omitempty" gorm:"default:null"`
	// email is a string that maps to the OIDC email claim.
	// @inject_tag: `gorm:"default:null"`
	Email string `protobuf:"bytes,110,opt,name=email,proto3" json:"email,omitempty" gorm:"default:null"`
	// token_claims are the marshaled claims from the token.
	// @inject_tag: `gorm:"default:null"`
	TokenClaims string `protobuf:"bytes,120,opt,name=token_claims,json=tokenClaims,proto3" json:"token_claims,omitempty" gorm:"default:null"`
	// userinfo_claims are the marshaled claims from userinfo.
	// @inject_tag: `gorm:"default:null"`
	UserinfoClaims string `protobuf:"bytes,130,opt,name=userinfo_claims,json=userinfoClaims,proto3" json:"userinfo_claims,omitempty" gorm:"default:null"`
}

func (x *Account) Reset() {
	*x = Account{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_storage_auth_oidc_store_v1_oidc_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Account) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Account) ProtoMessage() {}

func (x *Account) ProtoReflect() protoreflect.Message {
	mi := &file_controller_storage_auth_oidc_store_v1_oidc_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Account.ProtoReflect.Descriptor instead.
func (*Account) Descriptor() ([]byte, []int) {
	return file_controller_storage_auth_oidc_store_v1_oidc_proto_rawDescGZIP(), []int{1}
}

func (x *Account) GetPublicId() string {
	if x != nil {
		return x.PublicId
	}
	return ""
}

func (x *Account) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Account) GetUpdateTime() *timestamp.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Account) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Account) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Account) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *Account) GetAuthMethodId() string {
	if x != nil {
		return x.AuthMethodId
	}
	return ""
}

func (x *Account) GetIssuer() string {
	if x != nil {
		return x.Issuer
	}
	return ""
}

func (x *Account) GetSubject() string {
	if x != nil {
		return x.Subject
	}
	return ""
}

func (x *Account) GetFullName() string {
	if x != nil {
		return x.FullName
	}
	return ""
}

func (x *Account) GetEmail() string {
	if x != nil {
		return x.Email
	}
	return ""
}

func (x *Account) GetTokenClaims() string {
	if x != nil {
		return x.TokenClaims
	}
	return ""
}

func (x *Account) GetUserinfoClaims() string {
	if x != nil {
		return x.UserinfoClaims
	}
	return ""
}

// SigningAlg entries are the signing algorithms allowed for an oidc auth method.
type SigningAlg struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// @inject_tag: `gorm:"primary_key"`
	OidcMethodId string `protobuf:"bytes,10,opt,name=oidc_method_id,json=oidcMethodId,proto3" json:"oidc_method_id,omitempty" gorm:"primary_key"`
	// alg is an enum from the auth_oidc_signing_alg_enm table
	// @inject_tag: `gorm:"primary_key;column:signing_alg_name"`
	Alg string `protobuf:"bytes,20,opt,name=alg,proto3" json:"alg,omitempty" gorm:"primary_key;column:signing_alg_name"`
	// The create_time is set by the database.
	// @inject_tag: `gorm:"default:current_timestamp"`
	CreateTime *timestamp.Timestamp `protobuf:"bytes,30,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty" gorm:"default:current_timestamp"`
}

func (x *SigningAlg) Reset() {
	*x = SigningAlg{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_storage_auth_oidc_store_v1_oidc_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SigningAlg) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SigningAlg) ProtoMessage() {}

func (x *SigningAlg) ProtoReflect() protoreflect.Message {
	mi := &file_controller_storage_auth_oidc_store_v1_oidc_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SigningAlg.ProtoReflect.Descriptor instead.
func (*SigningAlg) Descriptor() ([]byte, []int) {
	return file_controller_storage_auth_oidc_store_v1_oidc_proto_rawDescGZIP(), []int{2}
}

func (x *SigningAlg) GetOidcMethodId() string {
	if x != nil {
		return x.OidcMethodId
	}
	return ""
}

func (x *SigningAlg) GetAlg() string {
	if x != nil {
		return x.Alg
	}
	return ""
}

func (x *SigningAlg) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

// AudClaim entries are the audience claims for a specific oidc auth method.
type AudClaim struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// @inject_tag: `gorm:"primary_key"`
	OidcMethodId string `protobuf:"bytes,10,opt,name=oidc_method_id,json=oidcMethodId,proto3" json:"oidc_method_id,omitempty" gorm:"primary_key"`
	// aud is an allowed audience claim for id_tokens
	// @inject_tag: `gorm:"primary_key;column:aud_claim""`
	Aud string `protobuf:"bytes,20,opt,name=aud,proto3" json:"aud,omitempty" gorm:"primary_key;column:aud_claim"`
	// The create_time is set by the database.
	// @inject_tag: `gorm:"default:current_timestamp"`
	CreateTime *timestamp.Timestamp `protobuf:"bytes,30,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty" gorm:"default:current_timestamp"`
}

func (x *AudClaim) Reset() {
	*x = AudClaim{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_storage_auth_oidc_store_v1_oidc_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AudClaim) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AudClaim) ProtoMessage() {}

func (x *AudClaim) ProtoReflect() protoreflect.Message {
	mi := &file_controller_storage_auth_oidc_store_v1_oidc_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AudClaim.ProtoReflect.Descriptor instead.
func (*AudClaim) Descriptor() ([]byte, []int) {
	return file_controller_storage_auth_oidc_store_v1_oidc_proto_rawDescGZIP(), []int{3}
}

func (x *AudClaim) GetOidcMethodId() string {
	if x != nil {
		return x.OidcMethodId
	}
	return ""
}

func (x *AudClaim) GetAud() string {
	if x != nil {
		return x.Aud
	}
	return ""
}

func (x *AudClaim) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

// Certificate entries are optional PEM encoded x509 certificates that can be
// used as trust anchors when connecting to an OIDC provider.
type Certificate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// @inject_tag: `gorm:"primary_key"`
	OidcMethodId string `protobuf:"bytes,10,opt,name=oidc_method_id,json=oidcMethodId,proto3" json:"oidc_method_id,omitempty" gorm:"primary_key"`
	// certificate is a PEM encoded x509
	// @inject_tag: `gorm:"column:certificate;primary_key"`
	Cert string `protobuf:"bytes,20,opt,name=cert,proto3" json:"cert,omitempty" gorm:"column:certificate;primary_key"`
	// The create_time is set by the database.
	// @inject_tag: `gorm:"default:current_timestamp"`
	CreateTime *timestamp.Timestamp `protobuf:"bytes,30,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty" gorm:"default:current_timestamp"`
}

func (x *Certificate) Reset() {
	*x = Certificate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_storage_auth_oidc_store_v1_oidc_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Certificate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Certificate) ProtoMessage() {}

func (x *Certificate) ProtoReflect() protoreflect.Message {
	mi := &file_controller_storage_auth_oidc_store_v1_oidc_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Certificate.ProtoReflect.Descriptor instead.
func (*Certificate) Descriptor() ([]byte, []int) {
	return file_controller_storage_auth_oidc_store_v1_oidc_proto_rawDescGZIP(), []int{4}
}

func (x *Certificate) GetOidcMethodId() string {
	if x != nil {
		return x.OidcMethodId
	}
	return ""
}

func (x *Certificate) GetCert() string {
	if x != nil {
		return x.Cert
	}
	return ""
}

func (x *Certificate) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

// ClaimsScope entries are optional OIDC scope values that are used to request
// claims, in addition to the default scope of "openid".
//
// see: https://openid.net/specs/openid-connect-core-1_0.html#ScopeClaims
type ClaimsScope struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// @inject_tag: `gorm:"primary_key"`
	OidcMethodId string `protobuf:"bytes,10,opt,name=oidc_method_id,json=oidcMethodId,proto3" json:"oidc_method_id,omitempty" gorm:"primary_key"`
	// scope is an OIDC scope
	// @inject_tag: `gorm:"column:scope;primary_key"`
	Scope string `protobuf:"bytes,20,opt,name=scope,proto3" json:"scope,omitempty" gorm:"column:scope;primary_key"`
	// The create_time is set by the database.
	// @inject_tag: `gorm:"default:current_timestamp"`
	CreateTime *timestamp.Timestamp `protobuf:"bytes,30,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty" gorm:"default:current_timestamp"`
}

func (x *ClaimsScope) Reset() {
	*x = ClaimsScope{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_storage_auth_oidc_store_v1_oidc_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClaimsScope) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClaimsScope) ProtoMessage() {}

func (x *ClaimsScope) ProtoReflect() protoreflect.Message {
	mi := &file_controller_storage_auth_oidc_store_v1_oidc_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClaimsScope.ProtoReflect.Descriptor instead.
func (*ClaimsScope) Descriptor() ([]byte, []int) {
	return file_controller_storage_auth_oidc_store_v1_oidc_proto_rawDescGZIP(), []int{5}
}

func (x *ClaimsScope) GetOidcMethodId() string {
	if x != nil {
		return x.OidcMethodId
	}
	return ""
}

func (x *ClaimsScope) GetScope() string {
	if x != nil {
		return x.Scope
	}
	return ""
}

func (x *ClaimsScope) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

// AccountClaimMap entries are optional from/to account claim maps.
type AccountClaimMap struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// @inject_tag: `gorm:"primary_key"`
	OidcMethodId string `protobuf:"bytes,10,opt,name=oidc_method_id,json=oidcMethodId,proto3" json:"oidc_method_id,omitempty" gorm:"primary_key"`
	// from_claim is the claim from the id_token that you need to map to a
	// standard account claim.
	// @inject_tag: `gorm:"not_null"`
	FromClaim string `protobuf:"bytes,20,opt,name=from_claim,json=fromClaim,proto3" json:"from_claim,omitempty" gorm:"not_null"`
	// to_claim is the standard account claim to map the from_claim to.  Valid
	// values are: sub, name, email
	// @inject_tag: `gorm:"column:to_claim;primary_key"`
	ToClaim string `protobuf:"bytes,30,opt,name=to_claim,json=toClaim,proto3" json:"to_claim,omitempty" gorm:"column:to_claim;primary_key"`
	// The create_time is set by the database.
	// @inject_tag: `gorm:"default:current_timestamp"`
	CreateTime *timestamp.Timestamp `protobuf:"bytes,40,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty" gorm:"default:current_timestamp"`
}

func (x *AccountClaimMap) Reset() {
	*x = AccountClaimMap{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_storage_auth_oidc_store_v1_oidc_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccountClaimMap) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccountClaimMap) ProtoMessage() {}

func (x *AccountClaimMap) ProtoReflect() protoreflect.Message {
	mi := &file_controller_storage_auth_oidc_store_v1_oidc_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccountClaimMap.ProtoReflect.Descriptor instead.
func (*AccountClaimMap) Descriptor() ([]byte, []int) {
	return file_controller_storage_auth_oidc_store_v1_oidc_proto_rawDescGZIP(), []int{6}
}

func (x *AccountClaimMap) GetOidcMethodId() string {
	if x != nil {
		return x.OidcMethodId
	}
	return ""
}

func (x *AccountClaimMap) GetFromClaim() string {
	if x != nil {
		return x.FromClaim
	}
	return ""
}

func (x *AccountClaimMap) GetToClaim() string {
	if x != nil {
		return x.ToClaim
	}
	return ""
}

func (x *AccountClaimMap) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

// ManagedGroup entries provide an OIDC auth method implementation of managed
// groups.
type ManagedGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// @inject_tag: `gorm:"primary_key"`
	PublicId string `protobuf:"bytes,10,opt,name=public_id,json=publicId,proto3" json:"public_id,omitempty" gorm:"primary_key"`
	// The create_time is set by the database.
	// @inject_tag: `gorm:"default:current_timestamp"`
	CreateTime *timestamp.Timestamp `protobuf:"bytes,20,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty" gorm:"default:current_timestamp"`
	// The update_time is set by the database.
	// @inject_tag: `gorm:"default:current_timestamp"`
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,30,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty" gorm:"default:current_timestamp"`
	// name is optional. If set, it must be unique within auth_method_id.
	// @inject_tag: `gorm:"default:null"`
	Name string `protobuf:"bytes,40,opt,name=name,proto3" json:"name,omitempty" gorm:"default:null"`
	// description is optional.
	// @inject_tag: `gorm:"default:null"`
	Description string `protobuf:"bytes,50,opt,name=description,proto3" json:"description,omitempty" gorm:"default:null"`
	// @inject_tag: `gorm:"default:null"`
	Version uint32 `protobuf:"varint,60,opt,name=version,proto3" json:"version,omitempty" gorm:"default:null"`
	// auth_method_id is the fk to the account's auth method.
	// @inject_tag: `gorm:"not_null"`
	AuthMethodId string `protobuf:"bytes,70,opt,name=auth_method_id,json=authMethodId,proto3" json:"auth_method_id,omitempty" gorm:"not_null"`
	// filter is a go-bexpr filter
	// @inject_tag: `gorm:"not_null"`
	Filter string `protobuf:"bytes,80,opt,name=filter,proto3" json:"filter,omitempty" gorm:"not_null"`
}

func (x *ManagedGroup) Reset() {
	*x = ManagedGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_storage_auth_oidc_store_v1_oidc_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ManagedGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ManagedGroup) ProtoMessage() {}

func (x *ManagedGroup) ProtoReflect() protoreflect.Message {
	mi := &file_controller_storage_auth_oidc_store_v1_oidc_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ManagedGroup.ProtoReflect.Descriptor instead.
func (*ManagedGroup) Descriptor() ([]byte, []int) {
	return file_controller_storage_auth_oidc_store_v1_oidc_proto_rawDescGZIP(), []int{7}
}

func (x *ManagedGroup) GetPublicId() string {
	if x != nil {
		return x.PublicId
	}
	return ""
}

func (x *ManagedGroup) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ManagedGroup) GetUpdateTime() *timestamp.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ManagedGroup) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ManagedGroup) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ManagedGroup) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *ManagedGroup) GetAuthMethodId() string {
	if x != nil {
		return x.AuthMethodId
	}
	return ""
}

func (x *ManagedGroup) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// ManagedGroupMemberAccount contains a mapping between a managed group and a
// member account.
type ManagedGroupMemberAccount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The create_time is set by the database.
	// @inject_tag: `gorm:"default:current_timestamp"`
	CreateTime *timestamp.Timestamp `protobuf:"bytes,10,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty" gorm:"default:current_timestamp"`
	// managed_group_id is the fk to the oidc managed group public id
	// @inject_tag: `gorm:"primary_key"`
	ManagedGroupId string `protobuf:"bytes,20,opt,name=managed_group_id,json=managedGroupId,proto3" json:"managed_group_id,omitempty" gorm:"primary_key"`
	// member_id is the fk to the oidc account public id
	// @inject_tag: `gorm:"primary_key"`
	MemberId string `protobuf:"bytes,30,opt,name=member_id,json=memberId,proto3" json:"member_id,omitempty" gorm:"primary_key"`
}

func (x *ManagedGroupMemberAccount) Reset() {
	*x = ManagedGroupMemberAccount{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_storage_auth_oidc_store_v1_oidc_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ManagedGroupMemberAccount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ManagedGroupMemberAccount) ProtoMessage() {}

func (x *ManagedGroupMemberAccount) ProtoReflect() protoreflect.Message {
	mi := &file_controller_storage_auth_oidc_store_v1_oidc_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ManagedGroupMemberAccount.ProtoReflect.Descriptor instead.
func (*ManagedGroupMemberAccount) Descriptor() ([]byte, []int) {
	return file_controller_storage_auth_oidc_store_v1_oidc_proto_rawDescGZIP(), []int{8}
}

func (x *ManagedGroupMemberAccount) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ManagedGroupMemberAccount) GetManagedGroupId() string {
	if x != nil {
		return x.ManagedGroupId
	}
	return ""
}

func (x *ManagedGroupMemberAccount) GetMemberId() string {
	if x != nil {
		return x.MemberId
	}
	return ""
}

// Prompt entries are the prompts allowed for an oidc auth method.
type Prompt struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// @inject_tag: `gorm:"primary_key"`
	OidcMethodId string `protobuf:"bytes,10,opt,name=oidc_method_id,json=oidcMethodId,proto3" json:"oidc_method_id,omitempty" gorm:"primary_key"`
	// prompt_param is an enum from the auth_oidc_prompt_enm table
	// @inject_tag: `gorm:"primary_key;column:prompt"`
	PromptParam string `protobuf:"bytes,20,opt,name=prompt_param,json=promptParam,proto3" json:"prompt_param,omitempty" gorm:"primary_key;column:prompt"`
	// The create_time is set by the database.
	// @inject_tag: `gorm:"default:current_timestamp"`
	CreateTime *timestamp.Timestamp `protobuf:"bytes,30,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty" gorm:"default:current_timestamp"`
}

func (x *Prompt) Reset() {
	*x = Prompt{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_storage_auth_oidc_store_v1_oidc_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Prompt) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Prompt) ProtoMessage() {}

func (x *Prompt) ProtoReflect() protoreflect.Message {
	mi := &file_controller_storage_auth_oidc_store_v1_oidc_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Prompt.ProtoReflect.Descriptor instead.
func (*Prompt) Descriptor() ([]byte, []int) {
	return file_controller_storage_auth_oidc_store_v1_oidc_proto_rawDescGZIP(), []int{9}
}

func (x *Prompt) GetOidcMethodId() string {
	if x != nil {
		return x.OidcMethodId
	}
	return ""
}

func (x *Prompt) GetPromptParam() string {
	if x != nil {
		return x.PromptParam
	}
	return ""
}

func (x *Prompt) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

var File_controller_storage_auth_oidc_store_v1_oidc_proto protoreflect.FileDescriptor

var file_controller_storage_auth_oidc_store_v1_oidc_proto_rawDesc = []byte{
	0x0a, 0x30, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2f, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x6f, 0x69, 0x64, 0x63, 0x2f, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x6f, 0x69, 0x64, 0x63, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x25, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x61, 0x75, 0x74, 0x68, 0x2e, 0x6f, 0x69, 0x64, 0x63,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x1a, 0x2a, 0x63, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65,
	0x72, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc1, 0x0b, 0x0a, 0x0a, 0x41, 0x75, 0x74, 0x68, 0x4d,
	0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f,
	0x69, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63,
	0x49, 0x64, 0x12, 0x4b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x4b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x1e,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65,
	0x72, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x28, 0x20, 0x01, 0x28, 0x09, 0x42, 0x10, 0xc2, 0xdd, 0x29, 0x0c,
	0x0a, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x32, 0x20, 0x01, 0x28, 0x09, 0x42, 0x1e, 0xc2, 0xdd, 0x29, 0x1a, 0x0a, 0x0b, 0x44,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x5f, 0x69, 0x64,
	0x18, 0x3c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x49, 0x64, 0x12,
	0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x46, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x33, 0x0a, 0x16, 0x69, 0x73, 0x5f,
	0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x6d, 0x65, 0x74,
	0x68, 0x6f, 0x64, 0x18, 0x4b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x69, 0x73, 0x50, 0x72, 0x69,
	0x6d, 0x61, 0x72, 0x79, 0x41, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x2b,
	0x0a, 0x11, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x50, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x4f, 0x0a, 0x24, 0x64,
	0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x65,
	0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x59, 0x20, 0x01, 0x28, 0x08, 0x52, 0x21, 0x64, 0x69, 0x73, 0x61, 0x62,
	0x6c, 0x65, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x37, 0x0a, 0x06,
	0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x18, 0x5a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x1f, 0xc2, 0xdd,
	0x29, 0x1b, 0x0a, 0x06, 0x49, 0x73, 0x73, 0x75, 0x65, 0x72, 0x12, 0x11, 0x61, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x52, 0x06, 0x69,
	0x73, 0x73, 0x75, 0x65, 0x72, 0x12, 0x41, 0x0a, 0x09, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x64, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xc2, 0xdd, 0x29, 0x20, 0x0a, 0x08,
	0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x14, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x73, 0x2e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x52, 0x08,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x10, 0x63, 0x74, 0x5f, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x6e, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x0e, 0x63, 0x74, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x12, 0x51, 0x0a, 0x0d, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x18, 0x78, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xc2, 0xdd, 0x29, 0x28, 0x0a,
	0x0c, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x18, 0x61,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x0c, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x53,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x2d, 0x0a, 0x12, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f,
	0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x68, 0x6d, 0x61, 0x63, 0x18, 0x82, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x10, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74,
	0x48, 0x6d, 0x61, 0x63, 0x12, 0x16, 0x0a, 0x06, 0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x8c,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6b, 0x65, 0x79, 0x49, 0x64, 0x12, 0x3a, 0x0a, 0x07,
	0x6d, 0x61, 0x78, 0x5f, 0x61, 0x67, 0x65, 0x18, 0x96, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x20,
	0xc2, 0xdd, 0x29, 0x1c, 0x0a, 0x06, 0x4d, 0x61, 0x78, 0x41, 0x67, 0x65, 0x12, 0x12, 0x61, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x6d, 0x61, 0x78, 0x5f, 0x61, 0x67, 0x65,
	0x52, 0x06, 0x6d, 0x61, 0x78, 0x41, 0x67, 0x65, 0x12, 0x41, 0x0a, 0x07, 0x61, 0x70, 0x69, 0x5f,
	0x75, 0x72, 0x6c, 0x18, 0xa0, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xc2, 0xdd, 0x29, 0x23,
	0x0a, 0x06, 0x41, 0x70, 0x69, 0x55, 0x72, 0x6c, 0x12, 0x19, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x73, 0x2e, 0x61, 0x70, 0x69, 0x5f, 0x75, 0x72, 0x6c, 0x5f, 0x70, 0x72, 0x65,
	0x66, 0x69, 0x78, 0x52, 0x06, 0x61, 0x70, 0x69, 0x55, 0x72, 0x6c, 0x12, 0x54, 0x0a, 0x0c, 0x73,
	0x69, 0x67, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x6c, 0x67, 0x73, 0x18, 0xaa, 0x01, 0x20, 0x03,
	0x28, 0x09, 0x42, 0x30, 0xc2, 0xdd, 0x29, 0x2c, 0x0a, 0x0b, 0x53, 0x69, 0x67, 0x6e, 0x69, 0x6e,
	0x67, 0x41, 0x6c, 0x67, 0x73, 0x12, 0x1d, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x73, 0x2e, 0x73, 0x69, 0x67, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69,
	0x74, 0x68, 0x6d, 0x73, 0x52, 0x0b, 0x73, 0x69, 0x67, 0x6e, 0x69, 0x6e, 0x67, 0x41, 0x6c, 0x67,
	0x73, 0x12, 0x4d, 0x0a, 0x0a, 0x61, 0x75, 0x64, 0x5f, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x73, 0x18,
	0xb4, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x2d, 0xc2, 0xdd, 0x29, 0x29, 0x0a, 0x09, 0x41, 0x75,
	0x64, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x73, 0x12, 0x1c, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x73, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x61, 0x75, 0x64, 0x69,
	0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x09, 0x61, 0x75, 0x64, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x73,
	0x12, 0x50, 0x0a, 0x0c, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73,
	0x18, 0xbe, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x2b, 0xc2, 0xdd, 0x29, 0x27, 0x0a, 0x0c, 0x43,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x12, 0x17, 0x61, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x69, 0x64, 0x70, 0x5f, 0x63, 0x61, 0x5f, 0x63,
	0x65, 0x72, 0x74, 0x73, 0x52, 0x0c, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x73, 0x12, 0x52, 0x0a, 0x0d, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x73, 0x5f, 0x73, 0x63, 0x6f,
	0x70, 0x65, 0x73, 0x18, 0xc8, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x2c, 0xc2, 0xdd, 0x29, 0x28,
	0x0a, 0x0c, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x73, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x12, 0x18,
	0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x63, 0x6c, 0x61, 0x69, 0x6d,
	0x73, 0x5f, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x52, 0x0c, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x73,
	0x53, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x12, 0x64, 0x0a, 0x12, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x5f, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x5f, 0x6d, 0x61, 0x70, 0x73, 0x18, 0xd2, 0x01, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x35, 0xc2, 0xdd, 0x29, 0x31, 0x0a, 0x10, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x4d, 0x61, 0x70, 0x73, 0x12, 0x1d, 0x61, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f,
	0x63, 0x6c, 0x61, 0x69, 0x6d, 0x5f, 0x6d, 0x61, 0x70, 0x73, 0x52, 0x10, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x4d, 0x61, 0x70, 0x73, 0x12, 0x3c, 0x0a, 0x07,
	0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x73, 0x18, 0xdc, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x21,
	0xc2, 0xdd, 0x29, 0x1d, 0x0a, 0x07, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x73, 0x12, 0x12, 0x61,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74,
	0x73, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x73, 0x22, 0x9a, 0x04, 0x0a, 0x07, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63,
	0x5f, 0x69, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x75, 0x62, 0x6c, 0x69,
	0x63, 0x49, 0x64, 0x12, 0x4b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x4b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x1e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c,
	0x65, 0x72, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x24, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x28, 0x20, 0x01, 0x28, 0x09, 0x42, 0x10, 0xc2, 0xdd, 0x29,
	0x0c, 0x0a, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x32, 0x20, 0x01, 0x28, 0x09, 0x42, 0x1e, 0xc2, 0xdd, 0x29, 0x1a, 0x0a, 0x0b,
	0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x3c, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x24, 0x0a, 0x0e, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x5f, 0x69,
	0x64, 0x18, 0x46, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74,
	0x68, 0x6f, 0x64, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x18,
	0x50, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x12, 0x18, 0x0a,
	0x07, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x5a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x66, 0x75, 0x6c, 0x6c, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x64, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x66, 0x75, 0x6c, 0x6c,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x6e, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x12, 0x21, 0x0a, 0x0c, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x5f, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x73, 0x18, 0x78, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x73, 0x12, 0x28, 0x0a,
	0x0f, 0x75, 0x73, 0x65, 0x72, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x73,
	0x18, 0x82, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x75, 0x73, 0x65, 0x72, 0x69, 0x6e, 0x66,
	0x6f, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x73, 0x22, 0x91, 0x01, 0x0a, 0x0a, 0x53, 0x69, 0x67, 0x6e,
	0x69, 0x6e, 0x67, 0x41, 0x6c, 0x67, 0x12, 0x24, 0x0a, 0x0e, 0x6f, 0x69, 0x64, 0x63, 0x5f, 0x6d,
	0x65, 0x74, 0x68, 0x6f, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x6f, 0x69, 0x64, 0x63, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x49, 0x64, 0x12, 0x10, 0x0a, 0x03,
	0x61, 0x6c, 0x67, 0x18, 0x14, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x61, 0x6c, 0x67, 0x12, 0x4b,
	0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x1e, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x8f, 0x01, 0x0a, 0x08,
	0x41, 0x75, 0x64, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x12, 0x24, 0x0a, 0x0e, 0x6f, 0x69, 0x64, 0x63,
	0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x6f, 0x69, 0x64, 0x63, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x49, 0x64, 0x12, 0x10,
	0x0a, 0x03, 0x61, 0x75, 0x64, 0x18, 0x14, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x61, 0x75, 0x64,
	0x12, 0x4b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x1e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c,
	0x65, 0x72, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x94, 0x01,
	0x0a, 0x0b, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x24, 0x0a,
	0x0e, 0x6f, 0x69, 0x64, 0x63, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x5f, 0x69, 0x64, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6f, 0x69, 0x64, 0x63, 0x4d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x63, 0x65, 0x72, 0x74, 0x18, 0x14, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x63, 0x65, 0x72, 0x74, 0x12, 0x4b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x22, 0x96, 0x01, 0x0a, 0x0b, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x73, 0x53,
	0x63, 0x6f, 0x70, 0x65, 0x12, 0x24, 0x0a, 0x0e, 0x6f, 0x69, 0x64, 0x63, 0x5f, 0x6d, 0x65, 0x74,
	0x68, 0x6f, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6f, 0x69,
	0x64, 0x63, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x63,
	0x6f, 0x70, 0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65,
	0x12, 0x4b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x1e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c,
	0x65, 0x72, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xbe, 0x01,
	0x0a, 0x0f, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x4d, 0x61,
	0x70, 0x12, 0x24, 0x0a, 0x0e, 0x6f, 0x69, 0x64, 0x63, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64,
	0x5f, 0x69, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6f, 0x69, 0x64, 0x63, 0x4d,
	0x65, 0x74, 0x68, 0x6f, 0x64, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x66, 0x72, 0x6f, 0x6d, 0x5f,
	0x63, 0x6c, 0x61, 0x69, 0x6d, 0x18, 0x14, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x66, 0x72, 0x6f,
	0x6d, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x6f, 0x5f, 0x63, 0x6c, 0x61,
	0x69, 0x6d, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x74, 0x6f, 0x43, 0x6c, 0x61, 0x69,
	0x6d, 0x12, 0x4b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x28, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x6c, 0x65, 0x72, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xa6,
	0x03, 0x0a, 0x0c, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12,
	0x1b, 0x0a, 0x09, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x69, 0x64, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x49, 0x64, 0x12, 0x4b, 0x0a, 0x0b,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x14, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x28,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x10, 0xc2, 0xdd, 0x29, 0x0c, 0x0a, 0x04, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x32, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x1e, 0xc2, 0xdd, 0x29, 0x1a, 0x0a, 0x0b, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x18,
	0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x3c, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0e, 0x61, 0x75, 0x74, 0x68,
	0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x46, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x61, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x49, 0x64, 0x12, 0x37,
	0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x50, 0x20, 0x01, 0x28, 0x09, 0x42, 0x1f,
	0xc2, 0xdd, 0x29, 0x1b, 0x0a, 0x06, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x11, 0x61, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xaf, 0x01, 0x0a, 0x19, 0x4d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x41, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x4b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x14, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09,
	0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x49, 0x64, 0x22, 0x9e, 0x01, 0x0a, 0x06, 0x50, 0x72,
	0x6f, 0x6d, 0x70, 0x74, 0x12, 0x24, 0x0a, 0x0e, 0x6f, 0x69, 0x64, 0x63, 0x5f, 0x6d, 0x65, 0x74,
	0x68, 0x6f, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6f, 0x69,
	0x64, 0x63, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x72,
	0x6f, 0x6d, 0x70, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x18, 0x14, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x12, 0x4b, 0x0a,
	0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x1e, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x42, 0x3e, 0x5a, 0x3c, 0x67, 0x69,
	0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f,
	0x72, 0x70, 0x2f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x2f, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x6f, 0x69, 0x64, 0x63, 0x2f, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x3b, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_controller_storage_auth_oidc_store_v1_oidc_proto_rawDescOnce sync.Once
	file_controller_storage_auth_oidc_store_v1_oidc_proto_rawDescData = file_controller_storage_auth_oidc_store_v1_oidc_proto_rawDesc
)

func file_controller_storage_auth_oidc_store_v1_oidc_proto_rawDescGZIP() []byte {
	file_controller_storage_auth_oidc_store_v1_oidc_proto_rawDescOnce.Do(func() {
		file_controller_storage_auth_oidc_store_v1_oidc_proto_rawDescData = protoimpl.X.CompressGZIP(file_controller_storage_auth_oidc_store_v1_oidc_proto_rawDescData)
	})
	return file_controller_storage_auth_oidc_store_v1_oidc_proto_rawDescData
}

var file_controller_storage_auth_oidc_store_v1_oidc_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_controller_storage_auth_oidc_store_v1_oidc_proto_goTypes = []any{
	(*AuthMethod)(nil),                // 0: controller.storage.auth.oidc.store.v1.AuthMethod
	(*Account)(nil),                   // 1: controller.storage.auth.oidc.store.v1.Account
	(*SigningAlg)(nil),                // 2: controller.storage.auth.oidc.store.v1.SigningAlg
	(*AudClaim)(nil),                  // 3: controller.storage.auth.oidc.store.v1.AudClaim
	(*Certificate)(nil),               // 4: controller.storage.auth.oidc.store.v1.Certificate
	(*ClaimsScope)(nil),               // 5: controller.storage.auth.oidc.store.v1.ClaimsScope
	(*AccountClaimMap)(nil),           // 6: controller.storage.auth.oidc.store.v1.AccountClaimMap
	(*ManagedGroup)(nil),              // 7: controller.storage.auth.oidc.store.v1.ManagedGroup
	(*ManagedGroupMemberAccount)(nil), // 8: controller.storage.auth.oidc.store.v1.ManagedGroupMemberAccount
	(*Prompt)(nil),                    // 9: controller.storage.auth.oidc.store.v1.Prompt
	(*timestamp.Timestamp)(nil),       // 10: controller.storage.timestamp.v1.Timestamp
}
var file_controller_storage_auth_oidc_store_v1_oidc_proto_depIdxs = []int32{
	10, // 0: controller.storage.auth.oidc.store.v1.AuthMethod.create_time:type_name -> controller.storage.timestamp.v1.Timestamp
	10, // 1: controller.storage.auth.oidc.store.v1.AuthMethod.update_time:type_name -> controller.storage.timestamp.v1.Timestamp
	10, // 2: controller.storage.auth.oidc.store.v1.Account.create_time:type_name -> controller.storage.timestamp.v1.Timestamp
	10, // 3: controller.storage.auth.oidc.store.v1.Account.update_time:type_name -> controller.storage.timestamp.v1.Timestamp
	10, // 4: controller.storage.auth.oidc.store.v1.SigningAlg.create_time:type_name -> controller.storage.timestamp.v1.Timestamp
	10, // 5: controller.storage.auth.oidc.store.v1.AudClaim.create_time:type_name -> controller.storage.timestamp.v1.Timestamp
	10, // 6: controller.storage.auth.oidc.store.v1.Certificate.create_time:type_name -> controller.storage.timestamp.v1.Timestamp
	10, // 7: controller.storage.auth.oidc.store.v1.ClaimsScope.create_time:type_name -> controller.storage.timestamp.v1.Timestamp
	10, // 8: controller.storage.auth.oidc.store.v1.AccountClaimMap.create_time:type_name -> controller.storage.timestamp.v1.Timestamp
	10, // 9: controller.storage.auth.oidc.store.v1.ManagedGroup.create_time:type_name -> controller.storage.timestamp.v1.Timestamp
	10, // 10: controller.storage.auth.oidc.store.v1.ManagedGroup.update_time:type_name -> controller.storage.timestamp.v1.Timestamp
	10, // 11: controller.storage.auth.oidc.store.v1.ManagedGroupMemberAccount.create_time:type_name -> controller.storage.timestamp.v1.Timestamp
	10, // 12: controller.storage.auth.oidc.store.v1.Prompt.create_time:type_name -> controller.storage.timestamp.v1.Timestamp
	13, // [13:13] is the sub-list for method output_type
	13, // [13:13] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_controller_storage_auth_oidc_store_v1_oidc_proto_init() }
func file_controller_storage_auth_oidc_store_v1_oidc_proto_init() {
	if File_controller_storage_auth_oidc_store_v1_oidc_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_controller_storage_auth_oidc_store_v1_oidc_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*AuthMethod); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_storage_auth_oidc_store_v1_oidc_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*Account); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_storage_auth_oidc_store_v1_oidc_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*SigningAlg); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_storage_auth_oidc_store_v1_oidc_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*AudClaim); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_storage_auth_oidc_store_v1_oidc_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*Certificate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_storage_auth_oidc_store_v1_oidc_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*ClaimsScope); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_storage_auth_oidc_store_v1_oidc_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*AccountClaimMap); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_storage_auth_oidc_store_v1_oidc_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*ManagedGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_storage_auth_oidc_store_v1_oidc_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*ManagedGroupMemberAccount); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_storage_auth_oidc_store_v1_oidc_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*Prompt); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_controller_storage_auth_oidc_store_v1_oidc_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_controller_storage_auth_oidc_store_v1_oidc_proto_goTypes,
		DependencyIndexes: file_controller_storage_auth_oidc_store_v1_oidc_proto_depIdxs,
		MessageInfos:      file_controller_storage_auth_oidc_store_v1_oidc_proto_msgTypes,
	}.Build()
	File_controller_storage_auth_oidc_store_v1_oidc_proto = out.File
	file_controller_storage_auth_oidc_store_v1_oidc_proto_rawDesc = nil
	file_controller_storage_auth_oidc_store_v1_oidc_proto_goTypes = nil
	file_controller_storage_auth_oidc_store_v1_oidc_proto_depIdxs = nil
}
