// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: BUSL-1.1

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        (unknown)
// source: controller/storage/auth/oidc/request/v1/request.proto

// Package store provides protobufs for storing types in the password package.

package request

import (
	timestamp "github.com/hashicorp/boundary/internal/db/timestamp"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// First, State is used in constructing the authorization URL, in the first
// leg of the authen flow. State represents the unique data used to construct
// an oidc.Request (see: https://github.com/hashicorp/cap/blob/main/oidc/request.go).
// State needs enough information, that when combined with a Boundary oidc auth method,
// a proper oidc.Request can be recreated during the second leg of the authen flow.  State
// also needs the provider.ConfigHash() used to from the first leg, so it can verify
// the Boundary's oidc auth method configuration hasn't changed since the authen flow
// began.
type State struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// token_request_id is the id. This id is used by the client to poll for a Boundary
	// token, once the final leg of the authen flow is compeleted.  The Callback uses this
	// id to create a "pending" token for that polling process.
	TokenRequestId string `protobuf:"bytes,10,opt,name=token_request_id,json=tokenRequestId,proto3" json:"token_request_id,omitempty"`
	// create_time of the request that started the authentication flow.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,20,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// expiration_time of the authenticaion flow.
	ExpirationTime *timestamp.Timestamp `protobuf:"bytes,30,opt,name=expiration_time,json=expirationTime,proto3" json:"expiration_time,omitempty"`
	// final_redirect_url that will be sent back to the client after the callback
	FinalRedirectUrl string `protobuf:"bytes,40,opt,name=final_redirect_url,json=finalRedirectUrl,proto3" json:"final_redirect_url,omitempty"`
	// nonce of the request which is used to verify the ID Token in the third leg
	// as a way to prevent replay attacks.
	//
	// See https://openid.net/specs/openid-connect-core-1_0.html#AuthRequest
	// and https://openid.net/specs/openid-connect-core-1_0.html#NonceNotes.
	Nonce string `protobuf:"bytes,50,opt,name=nonce,proto3" json:"nonce,omitempty"`
	// provider_config_hash can be used to see if the provider's config has changed
	// since the request started.
	ProviderConfigHash uint64 `protobuf:"varint,60,opt,name=provider_config_hash,json=providerConfigHash,proto3" json:"provider_config_hash,omitempty"`
}

func (x *State) Reset() {
	*x = State{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_storage_auth_oidc_request_v1_request_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *State) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*State) ProtoMessage() {}

func (x *State) ProtoReflect() protoreflect.Message {
	mi := &file_controller_storage_auth_oidc_request_v1_request_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use State.ProtoReflect.Descriptor instead.
func (*State) Descriptor() ([]byte, []int) {
	return file_controller_storage_auth_oidc_request_v1_request_proto_rawDescGZIP(), []int{0}
}

func (x *State) GetTokenRequestId() string {
	if x != nil {
		return x.TokenRequestId
	}
	return ""
}

func (x *State) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *State) GetExpirationTime() *timestamp.Timestamp {
	if x != nil {
		return x.ExpirationTime
	}
	return nil
}

func (x *State) GetFinalRedirectUrl() string {
	if x != nil {
		return x.FinalRedirectUrl
	}
	return ""
}

func (x *State) GetNonce() string {
	if x != nil {
		return x.Nonce
	}
	return ""
}

func (x *State) GetProviderConfigHash() uint64 {
	if x != nil {
		return x.ProviderConfigHash
	}
	return 0
}

// Token is the request token that's returned as part of the auth_token_url from
// oidc.StartAuth(...)
type Token struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// request_id for the token.
	RequestId string `protobuf:"bytes,10,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// expiration_time of the authenticaion flow.
	ExpirationTime *timestamp.Timestamp `protobuf:"bytes,20,opt,name=expiration_time,json=expirationTime,proto3" json:"expiration_time,omitempty"`
}

func (x *Token) Reset() {
	*x = Token{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_storage_auth_oidc_request_v1_request_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Token) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Token) ProtoMessage() {}

func (x *Token) ProtoReflect() protoreflect.Message {
	mi := &file_controller_storage_auth_oidc_request_v1_request_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Token.ProtoReflect.Descriptor instead.
func (*Token) Descriptor() ([]byte, []int) {
	return file_controller_storage_auth_oidc_request_v1_request_proto_rawDescGZIP(), []int{1}
}

func (x *Token) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *Token) GetExpirationTime() *timestamp.Timestamp {
	if x != nil {
		return x.ExpirationTime
	}
	return nil
}

// Wrapper wraps an encrypted cipher text with non-sensitive info
// which allows Boundary to determine how to decrypt
// the wrappered cipher text (ct) field.
type Wrapper struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// auth_method_id is the auth method of the oidc request
	AuthMethodId string `protobuf:"bytes,10,opt,name=auth_method_id,json=authMethodId,proto3" json:"auth_method_id,omitempty"`
	// scope_id is the auth method's scope
	ScopeId string `protobuf:"bytes,20,opt,name=scope_id,json=scopeId,proto3" json:"scope_id,omitempty"`
	// wrapper_key_id is the DEK wrapper key id which was used to derive the
	// cipher's key
	WrapperKeyId string `protobuf:"bytes,30,opt,name=wrapper_key_id,json=wrapperKeyId,proto3" json:"wrapper_key_id,omitempty"`
	// ct is the encrypted cipher text
	Ct []byte `protobuf:"bytes,40,opt,name=ct,proto3" json:"ct,omitempty"`
}

func (x *Wrapper) Reset() {
	*x = Wrapper{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_storage_auth_oidc_request_v1_request_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Wrapper) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Wrapper) ProtoMessage() {}

func (x *Wrapper) ProtoReflect() protoreflect.Message {
	mi := &file_controller_storage_auth_oidc_request_v1_request_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Wrapper.ProtoReflect.Descriptor instead.
func (*Wrapper) Descriptor() ([]byte, []int) {
	return file_controller_storage_auth_oidc_request_v1_request_proto_rawDescGZIP(), []int{2}
}

func (x *Wrapper) GetAuthMethodId() string {
	if x != nil {
		return x.AuthMethodId
	}
	return ""
}

func (x *Wrapper) GetScopeId() string {
	if x != nil {
		return x.ScopeId
	}
	return ""
}

func (x *Wrapper) GetWrapperKeyId() string {
	if x != nil {
		return x.WrapperKeyId
	}
	return ""
}

func (x *Wrapper) GetCt() []byte {
	if x != nil {
		return x.Ct
	}
	return nil
}

var File_controller_storage_auth_oidc_request_v1_request_proto protoreflect.FileDescriptor

var file_controller_storage_auth_oidc_request_v1_request_proto_rawDesc = []byte{
	0x0a, 0x35, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2f, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x6f, 0x69, 0x64, 0x63, 0x2f, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x27, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x6c, 0x65, 0x72, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x61, 0x75, 0x74, 0x68,
	0x2e, 0x6f, 0x69, 0x64, 0x63, 0x2e, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x76, 0x31,
	0x1a, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2f, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2f, 0x76,
	0x31, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0xc9, 0x02, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x4b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x53, 0x0a, 0x0f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0e, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x66, 0x69, 0x6e, 0x61, 0x6c,
	0x5f, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x28, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x10, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x52, 0x65, 0x64, 0x69, 0x72, 0x65,
	0x63, 0x74, 0x55, 0x72, 0x6c, 0x12, 0x14, 0x0a, 0x05, 0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x18, 0x32,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x12, 0x30, 0x0a, 0x14, 0x70,
	0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x68,
	0x61, 0x73, 0x68, 0x18, 0x3c, 0x20, 0x01, 0x28, 0x04, 0x52, 0x12, 0x70, 0x72, 0x6f, 0x76, 0x69,
	0x64, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x61, 0x73, 0x68, 0x22, 0x7b, 0x0a,
	0x05, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x53, 0x0a, 0x0f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0e, 0x65, 0x78, 0x70, 0x69,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x80, 0x01, 0x0a, 0x07, 0x57,
	0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x12, 0x24, 0x0a, 0x0e, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x6d,
	0x65, 0x74, 0x68, 0x6f, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x61, 0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x08,
	0x73, 0x63, 0x6f, 0x70, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x14, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x73, 0x63, 0x6f, 0x70, 0x65, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x0e, 0x77, 0x72, 0x61, 0x70, 0x70,
	0x65, 0x72, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x4b, 0x65, 0x79, 0x49, 0x64, 0x12, 0x0e, 0x0a,
	0x02, 0x63, 0x74, 0x18, 0x28, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x02, 0x63, 0x74, 0x42, 0x42, 0x5a,
	0x40, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x68, 0x61, 0x73, 0x68,
	0x69, 0x63, 0x6f, 0x72, 0x70, 0x2f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x2f, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x6f, 0x69, 0x64,
	0x63, 0x2f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x3b, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_controller_storage_auth_oidc_request_v1_request_proto_rawDescOnce sync.Once
	file_controller_storage_auth_oidc_request_v1_request_proto_rawDescData = file_controller_storage_auth_oidc_request_v1_request_proto_rawDesc
)

func file_controller_storage_auth_oidc_request_v1_request_proto_rawDescGZIP() []byte {
	file_controller_storage_auth_oidc_request_v1_request_proto_rawDescOnce.Do(func() {
		file_controller_storage_auth_oidc_request_v1_request_proto_rawDescData = protoimpl.X.CompressGZIP(file_controller_storage_auth_oidc_request_v1_request_proto_rawDescData)
	})
	return file_controller_storage_auth_oidc_request_v1_request_proto_rawDescData
}

var file_controller_storage_auth_oidc_request_v1_request_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_controller_storage_auth_oidc_request_v1_request_proto_goTypes = []any{
	(*State)(nil),               // 0: controller.storage.auth.oidc.request.v1.State
	(*Token)(nil),               // 1: controller.storage.auth.oidc.request.v1.Token
	(*Wrapper)(nil),             // 2: controller.storage.auth.oidc.request.v1.Wrapper
	(*timestamp.Timestamp)(nil), // 3: controller.storage.timestamp.v1.Timestamp
}
var file_controller_storage_auth_oidc_request_v1_request_proto_depIdxs = []int32{
	3, // 0: controller.storage.auth.oidc.request.v1.State.create_time:type_name -> controller.storage.timestamp.v1.Timestamp
	3, // 1: controller.storage.auth.oidc.request.v1.State.expiration_time:type_name -> controller.storage.timestamp.v1.Timestamp
	3, // 2: controller.storage.auth.oidc.request.v1.Token.expiration_time:type_name -> controller.storage.timestamp.v1.Timestamp
	3, // [3:3] is the sub-list for method output_type
	3, // [3:3] is the sub-list for method input_type
	3, // [3:3] is the sub-list for extension type_name
	3, // [3:3] is the sub-list for extension extendee
	0, // [0:3] is the sub-list for field type_name
}

func init() { file_controller_storage_auth_oidc_request_v1_request_proto_init() }
func file_controller_storage_auth_oidc_request_v1_request_proto_init() {
	if File_controller_storage_auth_oidc_request_v1_request_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_controller_storage_auth_oidc_request_v1_request_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*State); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_storage_auth_oidc_request_v1_request_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*Token); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_storage_auth_oidc_request_v1_request_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*Wrapper); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_controller_storage_auth_oidc_request_v1_request_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_controller_storage_auth_oidc_request_v1_request_proto_goTypes,
		DependencyIndexes: file_controller_storage_auth_oidc_request_v1_request_proto_depIdxs,
		MessageInfos:      file_controller_storage_auth_oidc_request_v1_request_proto_msgTypes,
	}.Build()
	File_controller_storage_auth_oidc_request_v1_request_proto = out.File
	file_controller_storage_auth_oidc_request_v1_request_proto_rawDesc = nil
	file_controller_storage_auth_oidc_request_v1_request_proto_goTypes = nil
	file_controller_storage_auth_oidc_request_v1_request_proto_depIdxs = nil
}
