// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: BUSL-1.1

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        (unknown)
// source: controller/storage/auth/ldap/store/v1/ldap.proto

// Package store provides protobufs for storing types in the ldap package.

package store

import (
	timestamp "github.com/hashicorp/boundary/internal/db/timestamp"
	_ "github.com/hashicorp/boundary/sdk/pbs/controller/protooptions"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// AuthMethod represents an LDAP auth method.
type AuthMethod struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// public_id is the PK and is the external public identifier of the auth
	// method.
	// @inject_tag: `gorm:"primary_key"`
	PublicId string `protobuf:"bytes,10,opt,name=public_id,json=publicId,proto3" json:"public_id,omitempty" gorm:"primary_key"`
	// create_time is set by the database.
	// @inject_tag: `gorm:"default:current_timestamp"`
	CreateTime *timestamp.Timestamp `protobuf:"bytes,20,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty" gorm:"default:current_timestamp"`
	// update_time is set by the database.
	// @inject_tag: `gorm:"default:current_timestamp"`
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,30,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty" gorm:"default:current_timestamp"`
	// name is optional. If set, it must be unique within scope_id.
	// @inject_tag: `gorm:"default:null"`
	Name string `protobuf:"bytes,40,opt,name=name,proto3" json:"name,omitempty" gorm:"default:null"`
	// description is optional.
	// @inject_tag: `gorm:"default:null"`
	Description string `protobuf:"bytes,50,opt,name=description,proto3" json:"description,omitempty" gorm:"default:null"`
	// The scope_id of the owning scope. Must be set.
	// @inject_tag: `gorm:"not_null"`
	ScopeId string `protobuf:"bytes,60,opt,name=scope_id,json=scopeId,proto3" json:"scope_id,omitempty" gorm:"not_null"`
	// @inject_tag: `gorm:"default:null"`
	Version uint32 `protobuf:"varint,70,opt,name=version,proto3" json:"version,omitempty" gorm:"default:null"`
	// operational_state is the current state of the auth_ldap_method (inactive,
	// active-private, or active-public).
	// @inject_tag: `gorm:"column:state;not_null"`
	OperationalState string `protobuf:"bytes,80,opt,name=operational_state,json=operationalState,proto3" json:"operational_state,omitempty" gorm:"column:state;not_null"`
	// start_tls if true, issues a StartTLS command after establishing an
	// unencrypted connection. Defaults to false.
	// @inject_tag: `gorm:"not_null"`
	StartTls bool `protobuf:"varint,90,opt,name=start_tls,json=startTls,proto3" json:"start_tls,omitempty" gorm:"not_null"`
	// insecure_tls if true, skips LDAP server SSL certificate validation -
	// insecure and use with caution. Defaults to false.
	// @inject_tag: `gorm:"not_null;default:false"`
	InsecureTls bool `protobuf:"varint,100,opt,name=insecure_tls,json=insecureTls,proto3" json:"insecure_tls,omitempty" gorm:"not_null;default:false"`
	// discover_dn if true, use anon bind to discover the bind DN of a user.
	// Defaults to false.
	// @inject_tag: `gorm:"not_null;default:false"`
	DiscoverDn bool `protobuf:"varint,110,opt,name=discover_dn,json=discoverDn,proto3" json:"discover_dn,omitempty" gorm:"not_null;default:false"`
	// anon_group_search if true, use anon bind when performing LDAP group
	// searches. Defaults to false.
	// @inject_tag: `gorm:"not_null;default:false"`
	AnonGroupSearch bool `protobuf:"varint,120,opt,name=anon_group_search,json=anonGroupSearch,proto3" json:"anon_group_search,omitempty" gorm:"not_null;default:false"`
	// upn_domain is the userPrincipalDomain used to construct the UPN string for
	// the authenticating user. The constructed UPN will appear as
	// [username]@UPNDomain  Example: example.com, which will cause Boundary to
	// bind as username@example.com when authenticating the user.
	// @inject_tag: `gorm:"default:null"`
	UpnDomain string `protobuf:"bytes,130,opt,name=upn_domain,json=upnDomain,proto3" json:"upn_domain,omitempty" gorm:"default:null"`
	// urls are the LDAP URLS that specify LDAP servers to connection to.  There
	// must be at lease on URL for each LDAP auth method. When attempting to
	// connect, the URLs are tried in the order specified. These are Value Objects
	// that will be stored as Url messages, and are operated on as a complete set
	// (not individually).
	// @inject_tag: `gorm:"-"`
	Urls []string `protobuf:"bytes,140,rep,name=urls,proto3" json:"urls,omitempty" gorm:"-"`
	// user_dn (optional) is the base DN under which to perform user search.
	// Example: ou=Users,dc=example,dc=com
	// @inject_tag: `gorm:"-"`
	UserDn string `protobuf:"bytes,150,opt,name=user_dn,json=userDn,proto3" json:"user_dn,omitempty" gorm:"-"`
	// user_attr (optional) is the attribute on user's entry matching the username
	// passed when authenticating.  Examples: cn, uid
	// @inject_tag: `gorm:"-"`
	UserAttr string `protobuf:"bytes,160,opt,name=user_attr,json=userAttr,proto3" json:"user_attr,omitempty" gorm:"-"`
	// user_filter (optional) is a go template used to construct a LDAP user
	// search filter. The template can access the following context variables:
	// [UserAttr, Username]. The default userfilter is
	// ({{.UserAttr}}={{.Username}}) or
	// (userPrincipalName={{.Username}}@UPNDomain) if the upndomain parameter is
	// set.
	// @inject_tag: `gorm:"-"`
	UserFilter string `protobuf:"bytes,170,opt,name=user_filter,json=userFilter,proto3" json:"user_filter,omitempty" gorm:"-"`
	// enable_groups if true, an authenticated user's groups will be found during
	// authentication. Defaults to false.
	// @inject_tag: `gorm:"not_null;default:false"`
	EnableGroups bool `protobuf:"varint,175,opt,name=enable_groups,json=enableGroups,proto3" json:"enable_groups,omitempty" gorm:"not_null;default:false"`
	// group_dn (optional) is the base DN under which to perform group search.
	// Example: ou=Groups,dc=example,dc=com
	//
	// Note: there is no default, so no base dn will be used for group searches if
	// it's not specified.
	// @inject_tag: `gorm:"-"`
	GroupDn string `protobuf:"bytes,180,opt,name=group_dn,json=groupDn,proto3" json:"group_dn,omitempty" gorm:"-"`
	// group_attr (optional) is the LDAP attribute to follow on objects returned
	// by GroupFilter in order to enumerate user group membership. Examples: for
	// GroupFilter queries returning group objects, use: cn. For queries returning
	// user objects, use: memberOf. The default is cn.
	// @inject_tag: `gorm:"-"`
	GroupAttr string `protobuf:"bytes,190,opt,name=group_attr,json=groupAttr,proto3" json:"group_attr,omitempty" gorm:"-"`
	// group_filter (optional) is a Go template used when constructing the group
	// membership query. The template can access the following context variables:
	// [UserDN, Username]. The default is
	// (|(memberUid={{.Username}})(member={{.UserDN}})(uniqueMember={{.UserDN}})),
	// which is compatible with several common directory schemas.
	// @inject_tag: `gorm:"-"`
	GroupFilter string `protobuf:"bytes,200,opt,name=group_filter,json=groupFilter,proto3" json:"group_filter,omitempty" gorm:"-"`
	// certificates are optional PEM encoded x509 certificates in ASN.1 DER form
	// that can be used as trust anchors when connecting to an LDAP provider.
	// These are Value Objects that will be stored as Certificate messages, and
	// are operated on as a complete set (not individually).
	// @inject_tag: `gorm:"-"`
	Certificates []string `protobuf:"bytes,210,rep,name=certificates,proto3" json:"certificates,omitempty" gorm:"-"`
	// client_certificate is the certificate in ASN.1 DER form encoded as PEM. It
	// must be set.
	// @inject_tag: `gorm:"-"`
	ClientCertificate string `protobuf:"bytes,220,opt,name=client_certificate,json=clientCertificate,proto3" json:"client_certificate,omitempty" gorm:"-"`
	// client_certificate_key (optional) is the plain-text of the certificate key
	// data in PKCS #8, ASN.1 DER form. We are not storing this plain-text key in
	// the database.
	// @inject_tag: `gorm:"-"`
	ClientCertificateKey []byte `protobuf:"bytes,230,opt,name=client_certificate_key,json=clientCertificateKey,proto3" json:"client_certificate_key,omitempty" gorm:"-"`
	// client_certificate_key_hmac is a sha256-hmac of the unencrypted
	// client_certificate_key_hmac that is returned from the API for read.  It is
	// recalculated everytime the raw client_certificate_key_hmac is updated in
	// the database.
	// @inject_tag: `gorm:"-"`
	ClientCertificateKeyHmac []byte `protobuf:"bytes,240,opt,name=client_certificate_key_hmac,json=clientCertificateKeyHmac,proto3" json:"client_certificate_key_hmac,omitempty" gorm:"-"`
	// bind_dn (optional) is the distinguished name of entry to bind when
	// performing user and group search. Example:
	// cn=vault,ou=Users,dc=example,dc=com
	// @inject_tag: `gorm:"-"`
	BindDn string `protobuf:"bytes,250,opt,name=bind_dn,json=bindDn,proto3" json:"bind_dn,omitempty" gorm:"-"`
	// bind_password (optional) is the password to use along with binddn when
	// performing user search. (This plaintext is not stored in the database)
	// @inject_tag: `gorm:"-"`
	BindPassword string `protobuf:"bytes,260,opt,name=bind_password,json=bindPassword,proto3" json:"bind_password,omitempty" gorm:"-"`
	// bind_password_hmac is a sha256-hmac of the unencrypted bind_password that
	// is returned from the API for read.  It is recalculated everytime the raw
	// password is updated in the database.
	// @inject_tag: `gorm:"-"`
	BindPasswordHmac []byte `protobuf:"bytes,270,opt,name=bind_password_hmac,json=bindPasswordHmac,proto3" json:"bind_password_hmac,omitempty" gorm:"-"`
	// is_primary_auth_method is a read-only output field which indicates if the
	// auth method is set as the scope's primary auth method.
	// @inject_tag: `gorm:"-"`
	IsPrimaryAuthMethod bool `protobuf:"varint,280,opt,name=is_primary_auth_method,json=isPrimaryAuthMethod,proto3" json:"is_primary_auth_method,omitempty" gorm:"-"`
	// use_token_groups if true, use the Active Directory tokenGroups constructed
	// attribute of the user to find the group memberships. This will find all
	// security groups including nested ones.
	// @inject_tag: `gorm:"not_null;default:false"`
	UseTokenGroups bool `protobuf:"varint,290,opt,name=use_token_groups,json=useTokenGroups,proto3" json:"use_token_groups,omitempty" gorm:"not_null;default:false"`
	// account_attribute_maps are optional attribute maps from custom attributes
	// to the standard attributes of fullname and email.  These maps are
	// represented as key=value where the key equals the from_attribute and the
	// value equals the to_attribute.  For example "preferredName=fullName".  All
	// attribute names are case insensitive.
	// @inject_tag: `gorm:"-"`
	AccountAttributeMaps []string `protobuf:"bytes,300,rep,name=account_attribute_maps,json=accountAttributeMaps,proto3" json:"account_attribute_maps,omitempty" gorm:"-"`
	// MaximumPageSize optionally specifies a maximum ldap search result size to
	// use when retrieving the authenticated user's group memberships. This can
	// be used to avoid reaching the LDAP server's max result size.
	// @inject_tag: `gorm:"not_null;default:0"`
	MaximumPageSize uint32 `protobuf:"varint,310,opt,name=maximum_page_size,json=maximumPageSize,proto3" json:"maximum_page_size,omitempty" gorm:"not_null;default:0"`
	// dereference_aliases will control how aliases are dereferenced when
	// performing the search. Possible values are: never, finding, searching,
	// and always. If unset, a default of "never" is used. When set to
	// "finding", it will only dereference aliases during name resolution of the
	// base. When set to "searching", it will dereference aliases after name
	// resolution.
	// @inject_tag: `gorm:"-"`
	DereferenceAliases string `protobuf:"bytes,320,opt,name=dereference_aliases,json=dereferenceAliases,proto3" json:"dereference_aliases,omitempty" gorm:"-"`
}

func (x *AuthMethod) Reset() {
	*x = AuthMethod{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_storage_auth_ldap_store_v1_ldap_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthMethod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthMethod) ProtoMessage() {}

func (x *AuthMethod) ProtoReflect() protoreflect.Message {
	mi := &file_controller_storage_auth_ldap_store_v1_ldap_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthMethod.ProtoReflect.Descriptor instead.
func (*AuthMethod) Descriptor() ([]byte, []int) {
	return file_controller_storage_auth_ldap_store_v1_ldap_proto_rawDescGZIP(), []int{0}
}

func (x *AuthMethod) GetPublicId() string {
	if x != nil {
		return x.PublicId
	}
	return ""
}

func (x *AuthMethod) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *AuthMethod) GetUpdateTime() *timestamp.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *AuthMethod) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AuthMethod) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *AuthMethod) GetScopeId() string {
	if x != nil {
		return x.ScopeId
	}
	return ""
}

func (x *AuthMethod) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *AuthMethod) GetOperationalState() string {
	if x != nil {
		return x.OperationalState
	}
	return ""
}

func (x *AuthMethod) GetStartTls() bool {
	if x != nil {
		return x.StartTls
	}
	return false
}

func (x *AuthMethod) GetInsecureTls() bool {
	if x != nil {
		return x.InsecureTls
	}
	return false
}

func (x *AuthMethod) GetDiscoverDn() bool {
	if x != nil {
		return x.DiscoverDn
	}
	return false
}

func (x *AuthMethod) GetAnonGroupSearch() bool {
	if x != nil {
		return x.AnonGroupSearch
	}
	return false
}

func (x *AuthMethod) GetUpnDomain() string {
	if x != nil {
		return x.UpnDomain
	}
	return ""
}

func (x *AuthMethod) GetUrls() []string {
	if x != nil {
		return x.Urls
	}
	return nil
}

func (x *AuthMethod) GetUserDn() string {
	if x != nil {
		return x.UserDn
	}
	return ""
}

func (x *AuthMethod) GetUserAttr() string {
	if x != nil {
		return x.UserAttr
	}
	return ""
}

func (x *AuthMethod) GetUserFilter() string {
	if x != nil {
		return x.UserFilter
	}
	return ""
}

func (x *AuthMethod) GetEnableGroups() bool {
	if x != nil {
		return x.EnableGroups
	}
	return false
}

func (x *AuthMethod) GetGroupDn() string {
	if x != nil {
		return x.GroupDn
	}
	return ""
}

func (x *AuthMethod) GetGroupAttr() string {
	if x != nil {
		return x.GroupAttr
	}
	return ""
}

func (x *AuthMethod) GetGroupFilter() string {
	if x != nil {
		return x.GroupFilter
	}
	return ""
}

func (x *AuthMethod) GetCertificates() []string {
	if x != nil {
		return x.Certificates
	}
	return nil
}

func (x *AuthMethod) GetClientCertificate() string {
	if x != nil {
		return x.ClientCertificate
	}
	return ""
}

func (x *AuthMethod) GetClientCertificateKey() []byte {
	if x != nil {
		return x.ClientCertificateKey
	}
	return nil
}

func (x *AuthMethod) GetClientCertificateKeyHmac() []byte {
	if x != nil {
		return x.ClientCertificateKeyHmac
	}
	return nil
}

func (x *AuthMethod) GetBindDn() string {
	if x != nil {
		return x.BindDn
	}
	return ""
}

func (x *AuthMethod) GetBindPassword() string {
	if x != nil {
		return x.BindPassword
	}
	return ""
}

func (x *AuthMethod) GetBindPasswordHmac() []byte {
	if x != nil {
		return x.BindPasswordHmac
	}
	return nil
}

func (x *AuthMethod) GetIsPrimaryAuthMethod() bool {
	if x != nil {
		return x.IsPrimaryAuthMethod
	}
	return false
}

func (x *AuthMethod) GetUseTokenGroups() bool {
	if x != nil {
		return x.UseTokenGroups
	}
	return false
}

func (x *AuthMethod) GetAccountAttributeMaps() []string {
	if x != nil {
		return x.AccountAttributeMaps
	}
	return nil
}

func (x *AuthMethod) GetMaximumPageSize() uint32 {
	if x != nil {
		return x.MaximumPageSize
	}
	return 0
}

func (x *AuthMethod) GetDereferenceAliases() string {
	if x != nil {
		return x.DereferenceAliases
	}
	return ""
}

// Url represents LDAP URLs that specify LDAP servers to connection to.  There
// must be at lease on URL for each LDAP auth method.
type Url struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// create_time is set by the database.
	// @inject_tag: `gorm:"default:current_timestamp"`
	CreateTime *timestamp.Timestamp `protobuf:"bytes,10,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty" gorm:"default:current_timestamp"`
	// ldap_method_id is the FK to the URL's LDAP auth method.
	// @inject_tag: `gorm:"primary_key"`
	LdapMethodId string `protobuf:"bytes,20,opt,name=ldap_method_id,json=ldapMethodId,proto3" json:"ldap_method_id,omitempty" gorm:"primary_key"`
	// connection_priority represents the priority (aka order) of the url in the
	// list of ldap urls for the auth method.
	// @inject_tag: `gorm:"primary_key"`
	ConnectionPriority uint32 `protobuf:"varint,30,opt,name=connection_priority,json=connectionPriority,proto3" json:"connection_priority,omitempty" gorm:"primary_key"`
	// server_url is the LDAP server URL. The URL scheme must be either ldap or ldaps.
	// The port is optional.If no port is specified, then a default of 389 is used
	// for ldap and a default of 689 is used for ldaps. (see rfc4516 for more
	// information about LDAP URLs)
	// @inject_tag: `gorm:"column:url;not_null"`
	ServerUrl string `protobuf:"bytes,40,opt,name=server_url,json=serverUrl,proto3" json:"server_url,omitempty" gorm:"column:url;not_null"`
}

func (x *Url) Reset() {
	*x = Url{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_storage_auth_ldap_store_v1_ldap_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Url) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Url) ProtoMessage() {}

func (x *Url) ProtoReflect() protoreflect.Message {
	mi := &file_controller_storage_auth_ldap_store_v1_ldap_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Url.ProtoReflect.Descriptor instead.
func (*Url) Descriptor() ([]byte, []int) {
	return file_controller_storage_auth_ldap_store_v1_ldap_proto_rawDescGZIP(), []int{1}
}

func (x *Url) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Url) GetLdapMethodId() string {
	if x != nil {
		return x.LdapMethodId
	}
	return ""
}

func (x *Url) GetConnectionPriority() uint32 {
	if x != nil {
		return x.ConnectionPriority
	}
	return 0
}

func (x *Url) GetServerUrl() string {
	if x != nil {
		return x.ServerUrl
	}
	return ""
}

// UserEntrySearchConf represent a set of optional configuration fields used to
// search for user entries.
type UserEntrySearchConf struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// create_time is set by the database.
	// @inject_tag: `gorm:"default:current_timestamp"`
	CreateTime *timestamp.Timestamp `protobuf:"bytes,10,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty" gorm:"default:current_timestamp"`
	// ldap_method_id is the FK to the UserEntrySearchConf's LDAP auth method.
	// @inject_tag: `gorm:"primary_key"`
	LdapMethodId string `protobuf:"bytes,20,opt,name=ldap_method_id,json=ldapMethodId,proto3" json:"ldap_method_id,omitempty" gorm:"primary_key"`
	// user_dn is the base DN under which to perform user search. Example:
	// ou=Users,dc=example,dc=com
	// @inject_tag: `gorm:"default:null"`
	UserDn string `protobuf:"bytes,30,opt,name=user_dn,json=userDn,proto3" json:"user_dn,omitempty" gorm:"default:null"`
	// user_attr is the attribute on user attribute entry matching the username
	// passed when authenticating.  Examples: cn, uid
	// @inject_tag: `gorm:"default:null"`
	UserAttr string `protobuf:"bytes,40,opt,name=user_attr,json=userAttr,proto3" json:"user_attr,omitempty" gorm:"default:null"`
	// user_filter is a go template used to construct a LDAP user search filter.
	// The template can access the following context variables: [UserAttr,
	// Username]. The default userfilter is ({{.UserAttr}}={{.Username}}) or
	// (userPrincipalName={{.Username}}@UPNDomain) if the upndomain parameter is
	// set.
	// @inject_tag: `gorm:"default:null"`
	UserFilter string `protobuf:"bytes,50,opt,name=user_filter,json=userFilter,proto3" json:"user_filter,omitempty" gorm:"default:null"`
}

func (x *UserEntrySearchConf) Reset() {
	*x = UserEntrySearchConf{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_storage_auth_ldap_store_v1_ldap_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserEntrySearchConf) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserEntrySearchConf) ProtoMessage() {}

func (x *UserEntrySearchConf) ProtoReflect() protoreflect.Message {
	mi := &file_controller_storage_auth_ldap_store_v1_ldap_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserEntrySearchConf.ProtoReflect.Descriptor instead.
func (*UserEntrySearchConf) Descriptor() ([]byte, []int) {
	return file_controller_storage_auth_ldap_store_v1_ldap_proto_rawDescGZIP(), []int{2}
}

func (x *UserEntrySearchConf) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *UserEntrySearchConf) GetLdapMethodId() string {
	if x != nil {
		return x.LdapMethodId
	}
	return ""
}

func (x *UserEntrySearchConf) GetUserDn() string {
	if x != nil {
		return x.UserDn
	}
	return ""
}

func (x *UserEntrySearchConf) GetUserAttr() string {
	if x != nil {
		return x.UserAttr
	}
	return ""
}

func (x *UserEntrySearchConf) GetUserFilter() string {
	if x != nil {
		return x.UserFilter
	}
	return ""
}

// GroupEntrySearchConf represent a set of optional configuration fields used to
// search for group entries.
type GroupEntrySearchConf struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// create_time is set by the database.
	// @inject_tag: `gorm:"default:current_timestamp"`
	CreateTime *timestamp.Timestamp `protobuf:"bytes,10,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty" gorm:"default:current_timestamp"`
	// ldap_method_id is the FK to the GroupEntrySearchConf's LDAP auth method.
	// @inject_tag: `gorm:"primary_key"`
	LdapMethodId string `protobuf:"bytes,20,opt,name=ldap_method_id,json=ldapMethodId,proto3" json:"ldap_method_id,omitempty" gorm:"primary_key"`
	// group_dn is the base DN under which to perform user search. Example:
	// ou=Groups,dc=example,dc=com
	// @inject_tag: `gorm:"default:null"`
	GroupDn string `protobuf:"bytes,30,opt,name=group_dn,json=groupDn,proto3" json:"group_dn,omitempty" gorm:"default:null"`
	// group_attr is the LDAP attribute to follow on objects returned by
	// GroupFilter in order to enumerate user group membership. Examples: for
	// GroupFilter queries returning group objects, use: cn. For queries returning
	// user objects, use: memberOf. The default is cn.
	// @inject_tag: `gorm:"default:null"`
	GroupAttr string `protobuf:"bytes,40,opt,name=group_attr,json=groupAttr,proto3" json:"group_attr,omitempty" gorm:"default:null"`
	// user_filter is a Go template used when constructing the group membership
	// query. The template can access the following context variables: [UserDN,
	// Username]. The default is
	// (|(memberUid={{.Username}})(member={{.UserDN}})(uniqueMember={{.UserDN}})),
	// which is compatible with several common directory schemas.
	// @inject_tag: `gorm:"default:null"`
	GroupFilter string `protobuf:"bytes,50,opt,name=group_filter,json=groupFilter,proto3" json:"group_filter,omitempty" gorm:"default:null"`
}

func (x *GroupEntrySearchConf) Reset() {
	*x = GroupEntrySearchConf{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_storage_auth_ldap_store_v1_ldap_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GroupEntrySearchConf) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupEntrySearchConf) ProtoMessage() {}

func (x *GroupEntrySearchConf) ProtoReflect() protoreflect.Message {
	mi := &file_controller_storage_auth_ldap_store_v1_ldap_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupEntrySearchConf.ProtoReflect.Descriptor instead.
func (*GroupEntrySearchConf) Descriptor() ([]byte, []int) {
	return file_controller_storage_auth_ldap_store_v1_ldap_proto_rawDescGZIP(), []int{3}
}

func (x *GroupEntrySearchConf) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *GroupEntrySearchConf) GetLdapMethodId() string {
	if x != nil {
		return x.LdapMethodId
	}
	return ""
}

func (x *GroupEntrySearchConf) GetGroupDn() string {
	if x != nil {
		return x.GroupDn
	}
	return ""
}

func (x *GroupEntrySearchConf) GetGroupAttr() string {
	if x != nil {
		return x.GroupAttr
	}
	return ""
}

func (x *GroupEntrySearchConf) GetGroupFilter() string {
	if x != nil {
		return x.GroupFilter
	}
	return ""
}

// Certificate entries are optional PEM encoded x509 certificates. Each entry is
// a single certificate.  An ldap auth method may have 0 or more of these
// optional x509s.  If an auth method has any cert entries, they are used as
// trust anchors when connecting to the auth method's ldap provider (instead of
// the host system's cert chain).
type Certificate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// create_time is set by the database.
	// @inject_tag: `gorm:"default:current_timestamp"`
	CreateTime *timestamp.Timestamp `protobuf:"bytes,10,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty" gorm:"default:current_timestamp"`
	// ldap_method_id is the FK to the Certificate's LDAP auth method.
	// @inject_tag: `gorm:"primary_key"`
	LdapMethodId string `protobuf:"bytes,20,opt,name=ldap_method_id,json=ldapMethodId,proto3" json:"ldap_method_id,omitempty" gorm:"primary_key"`
	// certificate is a PEM encoded x509 in ASN.1 DER form.
	// @inject_tag: `gorm:"column:certificate;primary_key"`
	Cert string `protobuf:"bytes,30,opt,name=cert,proto3" json:"cert,omitempty" gorm:"column:certificate;primary_key"`
}

func (x *Certificate) Reset() {
	*x = Certificate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_storage_auth_ldap_store_v1_ldap_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Certificate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Certificate) ProtoMessage() {}

func (x *Certificate) ProtoReflect() protoreflect.Message {
	mi := &file_controller_storage_auth_ldap_store_v1_ldap_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Certificate.ProtoReflect.Descriptor instead.
func (*Certificate) Descriptor() ([]byte, []int) {
	return file_controller_storage_auth_ldap_store_v1_ldap_proto_rawDescGZIP(), []int{4}
}

func (x *Certificate) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Certificate) GetLdapMethodId() string {
	if x != nil {
		return x.LdapMethodId
	}
	return ""
}

func (x *Certificate) GetCert() string {
	if x != nil {
		return x.Cert
	}
	return ""
}

// ClientCertificate represent a set of optional configuration fields used for
// specifying a mTLS client cert for LDAP connections.
type ClientCertificate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// create_time is set by the database.
	// @inject_tag: `gorm:"default:current_timestamp"`
	CreateTime *timestamp.Timestamp `protobuf:"bytes,10,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty" gorm:"default:current_timestamp"`
	// ldap_method_id is the FK to the ClientCertificate's LDAP auth method.
	// @inject_tag: `gorm:"primary_key"`
	LdapMethodId string `protobuf:"bytes,20,opt,name=ldap_method_id,json=ldapMethodId,proto3" json:"ldap_method_id,omitempty" gorm:"primary_key"`
	// certificate is the PEM encoded certificate in ASN.1 DER.
	// It must be set.
	// @inject_tag: `gorm:"not_null"`
	Certificate []byte `protobuf:"bytes,30,opt,name=certificate,proto3" json:"certificate,omitempty" gorm:"not_null"`
	// certificate_key is the plain-text of the certificate key data in PKCS #8,
	// ASN.1 DER form. We are not storing this plain-text key in the database.
	// @inject_tag: `gorm:"-" wrapping:"pt,certificate_key_data"`
	CertificateKey []byte `protobuf:"bytes,40,opt,name=certificate_key,json=certificateKey,proto3" json:"certificate_key,omitempty" gorm:"-" wrapping:"pt,certificate_key_data"`
	// ct_certificate_key is the ciphertext of the certificate key data. It
	// is stored in the database.
	// @inject_tag: `gorm:"column:certificate_key;not_null" wrapping:"ct,certificate_key_data"`
	CtCertificateKey []byte `protobuf:"bytes,50,opt,name=ct_certificate_key,json=ctCertificateKey,proto3" json:"ct_certificate_key,omitempty" gorm:"column:certificate_key;not_null" wrapping:"ct,certificate_key_data"`
	// certificate_key_hmac is a sha256-hmac of the unencrypted certificate_key that
	// is returned from the API for read.  It is recalculated everytime the raw
	// certificate_key is updated.
	// @inject_tag: `gorm:"not_null"`
	CertificateKeyHmac []byte `protobuf:"bytes,60,opt,name=certificate_key_hmac,json=certificateKeyHmac,proto3" json:"certificate_key_hmac,omitempty" gorm:"not_null"`
	// The key_id of the kms database key used for encrypting this entry.
	// It must be set.
	// @inject_tag: `gorm:"not_null"`
	KeyId string `protobuf:"bytes,70,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty" gorm:"not_null"`
}

func (x *ClientCertificate) Reset() {
	*x = ClientCertificate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_storage_auth_ldap_store_v1_ldap_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClientCertificate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClientCertificate) ProtoMessage() {}

func (x *ClientCertificate) ProtoReflect() protoreflect.Message {
	mi := &file_controller_storage_auth_ldap_store_v1_ldap_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClientCertificate.ProtoReflect.Descriptor instead.
func (*ClientCertificate) Descriptor() ([]byte, []int) {
	return file_controller_storage_auth_ldap_store_v1_ldap_proto_rawDescGZIP(), []int{5}
}

func (x *ClientCertificate) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ClientCertificate) GetLdapMethodId() string {
	if x != nil {
		return x.LdapMethodId
	}
	return ""
}

func (x *ClientCertificate) GetCertificate() []byte {
	if x != nil {
		return x.Certificate
	}
	return nil
}

func (x *ClientCertificate) GetCertificateKey() []byte {
	if x != nil {
		return x.CertificateKey
	}
	return nil
}

func (x *ClientCertificate) GetCtCertificateKey() []byte {
	if x != nil {
		return x.CtCertificateKey
	}
	return nil
}

func (x *ClientCertificate) GetCertificateKeyHmac() []byte {
	if x != nil {
		return x.CertificateKeyHmac
	}
	return nil
}

func (x *ClientCertificate) GetKeyId() string {
	if x != nil {
		return x.KeyId
	}
	return ""
}

// BindCredentail (optional) represent parameters which allow Boundary to bind
// (aka authenticate) using the credentials provided when searching for the user
// entry used to authenticate the end user.
type BindCredential struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// create_time is set by the database.
	// @inject_tag: `gorm:"default:current_timestamp"`
	CreateTime *timestamp.Timestamp `protobuf:"bytes,10,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty" gorm:"default:current_timestamp"`
	// ldap_method_id is the FK to the BindCredential's LDAP auth method.
	// @inject_tag: `gorm:"primary_key"`
	LdapMethodId string `protobuf:"bytes,20,opt,name=ldap_method_id,json=ldapMethodId,proto3" json:"ldap_method_id,omitempty" gorm:"primary_key"`
	// dn is the distinguished name of the entry to bind when performing
	// user and group search. Example: cn=vault,ou=Users,dc=example,dc=com
	// @inject_tag: `gorm:"not_null"`
	Dn string `protobuf:"bytes,30,opt,name=dn,proto3" json:"dn,omitempty" gorm:"not_null"`
	// password is the plain-text password to use along with dn. We are not
	// storing this plain-text key in the database.
	// @inject_tag: `gorm:"-" wrapping:"pt,password_data"`
	Password []byte `protobuf:"bytes,40,opt,name=password,proto3" json:"password,omitempty" gorm:"-" wrapping:"pt,password_data"`
	// ct_password_key is the ciphertext of the password. It is stored in the database.
	// @inject_tag: `gorm:"column:password;not_null" wrapping:"ct,password_data"`
	CtPassword []byte `protobuf:"bytes,50,opt,name=ct_password,json=ctPassword,proto3" json:"ct_password,omitempty" gorm:"column:password;not_null" wrapping:"ct,password_data"`
	// password_hmac is a sha256-hmac of the unencrypted password that is returned
	// from the API for read.  It is recalculated everytime the raw password is
	// updated.
	// @inject_tag: `gorm:"not_null"`
	PasswordHmac []byte `protobuf:"bytes,60,opt,name=password_hmac,json=passwordHmac,proto3" json:"password_hmac,omitempty" gorm:"not_null"`
	// The key_id of the kms database key used for encrypting this entry.
	// It must be set.
	// @inject_tag: `gorm:"not_null"`
	KeyId string `protobuf:"bytes,70,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty" gorm:"not_null"`
}

func (x *BindCredential) Reset() {
	*x = BindCredential{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_storage_auth_ldap_store_v1_ldap_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BindCredential) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BindCredential) ProtoMessage() {}

func (x *BindCredential) ProtoReflect() protoreflect.Message {
	mi := &file_controller_storage_auth_ldap_store_v1_ldap_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BindCredential.ProtoReflect.Descriptor instead.
func (*BindCredential) Descriptor() ([]byte, []int) {
	return file_controller_storage_auth_ldap_store_v1_ldap_proto_rawDescGZIP(), []int{6}
}

func (x *BindCredential) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *BindCredential) GetLdapMethodId() string {
	if x != nil {
		return x.LdapMethodId
	}
	return ""
}

func (x *BindCredential) GetDn() string {
	if x != nil {
		return x.Dn
	}
	return ""
}

func (x *BindCredential) GetPassword() []byte {
	if x != nil {
		return x.Password
	}
	return nil
}

func (x *BindCredential) GetCtPassword() []byte {
	if x != nil {
		return x.CtPassword
	}
	return nil
}

func (x *BindCredential) GetPasswordHmac() []byte {
	if x != nil {
		return x.PasswordHmac
	}
	return nil
}

func (x *BindCredential) GetKeyId() string {
	if x != nil {
		return x.KeyId
	}
	return ""
}

// Account respresent Accounts associated with an LDAP auth method.
type Account struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// public_id is the PK and is the external public identifier of the account
	// @inject_tag: `gorm:"primary_key"`
	PublicId string `protobuf:"bytes,10,opt,name=public_id,json=publicId,proto3" json:"public_id,omitempty" gorm:"primary_key"`
	// create_time is set by the database.
	// @inject_tag: `gorm:"default:current_timestamp"`
	CreateTime *timestamp.Timestamp `protobuf:"bytes,20,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty" gorm:"default:current_timestamp"`
	// update_time is set by the database.
	// @inject_tag: `gorm:"default:current_timestamp"`
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,30,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty" gorm:"default:current_timestamp"`
	// auth_method_id is the FK to the Account's LDAP auth method.
	// @inject_tag: `gorm:"not_null"`
	AuthMethodId string `protobuf:"bytes,40,opt,name=auth_method_id,json=authMethodId,proto3" json:"auth_method_id,omitempty" gorm:"not_null"`
	// name is optional. If set, it must be unique within scope_id.
	// @inject_tag: `gorm:"default:null"`
	Name string `protobuf:"bytes,50,opt,name=name,proto3" json:"name,omitempty" gorm:"default:null"`
	// description is optional.
	// @inject_tag: `gorm:"default:null"`
	Description string `protobuf:"bytes,60,opt,name=description,proto3" json:"description,omitempty" gorm:"default:null"`
	// The scope_id of the owning scope. Must be set. The scope_id column is not
	// included here as it is used only to ensure data integrity in the database
	// between iam users and auth methods.
	// @inject_tag: `gorm:"not_null"`
	ScopeId string `protobuf:"bytes,70,opt,name=scope_id,json=scopeId,proto3" json:"scope_id,omitempty" gorm:"not_null"`
	// @inject_tag: `gorm:"default:null"`
	Version uint32 `protobuf:"varint,80,opt,name=version,proto3" json:"version,omitempty" gorm:"default:null"`
	// login_name of the authenticated user.  This is the login_name (or username)
	// entered by the user when authenticating (typically the uid or cn
	// attribute).  Account login names must be lower case.
	// @inject_tag: `gorm:"not_null"`
	LoginName string `protobuf:"bytes,90,opt,name=login_name,json=loginName,proto3" json:"login_name,omitempty" gorm:"not_null"`
	// full_name is a string that maps to the name attribute for the authenticated
	// user.  This attribute is updated every time a user successfully
	// authenticates.
	// @inject_tag: `gorm:"default:null"`
	FullName string `protobuf:"bytes,100,opt,name=full_name,json=fullName,proto3" json:"full_name,omitempty" gorm:"default:null"`
	// email is a string that maps to the email address attribute for the
	// authenticated user.  This attribute is updated every time a user
	// successfully authenticates.
	// @inject_tag: `gorm:"default:null"`
	Email string `protobuf:"bytes,110,opt,name=email,proto3" json:"email,omitempty" gorm:"default:null"`
	// dn is the distinguished name authenticated user's entry.  Will be null until
	// the user's first successful authentication.  This attribute is updated
	// every time a user successfully authenticates.
	// @inject_tag: `gorm:"default:null"`
	Dn string `protobuf:"bytes,120,opt,name=dn,proto3" json:"dn,omitempty" gorm:"default:null"`
	// member_of_groups are the json marshalled groups the authenticated user is a
	// member of. Will be null until the user's first successful authentication.
	// This attribute is updated every time a user successfully authenticates.
	// @inject_tag: `gorm:"default:null"`
	MemberOfGroups string `protobuf:"bytes,140,opt,name=member_of_groups,json=memberOfGroups,proto3" json:"member_of_groups,omitempty" gorm:"default:null"`
}

func (x *Account) Reset() {
	*x = Account{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_storage_auth_ldap_store_v1_ldap_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Account) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Account) ProtoMessage() {}

func (x *Account) ProtoReflect() protoreflect.Message {
	mi := &file_controller_storage_auth_ldap_store_v1_ldap_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Account.ProtoReflect.Descriptor instead.
func (*Account) Descriptor() ([]byte, []int) {
	return file_controller_storage_auth_ldap_store_v1_ldap_proto_rawDescGZIP(), []int{7}
}

func (x *Account) GetPublicId() string {
	if x != nil {
		return x.PublicId
	}
	return ""
}

func (x *Account) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Account) GetUpdateTime() *timestamp.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Account) GetAuthMethodId() string {
	if x != nil {
		return x.AuthMethodId
	}
	return ""
}

func (x *Account) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Account) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Account) GetScopeId() string {
	if x != nil {
		return x.ScopeId
	}
	return ""
}

func (x *Account) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *Account) GetLoginName() string {
	if x != nil {
		return x.LoginName
	}
	return ""
}

func (x *Account) GetFullName() string {
	if x != nil {
		return x.FullName
	}
	return ""
}

func (x *Account) GetEmail() string {
	if x != nil {
		return x.Email
	}
	return ""
}

func (x *Account) GetDn() string {
	if x != nil {
		return x.Dn
	}
	return ""
}

func (x *Account) GetMemberOfGroups() string {
	if x != nil {
		return x.MemberOfGroups
	}
	return ""
}

// AccountAttributeMap entries are optional from/to account attribute maps.
type AccountAttributeMap struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// @inject_tag: `gorm:"primary_key"`
	LdapMethodId string `protobuf:"bytes,10,opt,name=ldap_method_id,json=ldapMethodId,proto3" json:"ldap_method_id,omitempty" gorm:"primary_key"`
	// from_attribute is the attribute from the user's entry that you need to map
	// to a standard account attribute.
	// @inject_tag: `gorm:"not_null"`
	FromAttribute string `protobuf:"bytes,20,opt,name=from_attribute,json=fromAttribute,proto3" json:"from_attribute,omitempty" gorm:"not_null"`
	// to_attribute is the standard account attribute to map the from_attribute
	// to.  Valid values are: fullname, email
	// @inject_tag: `gorm:"column:to_attribute;primary_key"`
	ToAttribute string `protobuf:"bytes,30,opt,name=to_attribute,json=toAttribute,proto3" json:"to_attribute,omitempty" gorm:"column:to_attribute;primary_key"`
	// The create_time is set by the database.
	// @inject_tag: `gorm:"default:current_timestamp"`
	CreateTime *timestamp.Timestamp `protobuf:"bytes,40,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty" gorm:"default:current_timestamp"`
}

func (x *AccountAttributeMap) Reset() {
	*x = AccountAttributeMap{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_storage_auth_ldap_store_v1_ldap_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccountAttributeMap) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccountAttributeMap) ProtoMessage() {}

func (x *AccountAttributeMap) ProtoReflect() protoreflect.Message {
	mi := &file_controller_storage_auth_ldap_store_v1_ldap_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccountAttributeMap.ProtoReflect.Descriptor instead.
func (*AccountAttributeMap) Descriptor() ([]byte, []int) {
	return file_controller_storage_auth_ldap_store_v1_ldap_proto_rawDescGZIP(), []int{8}
}

func (x *AccountAttributeMap) GetLdapMethodId() string {
	if x != nil {
		return x.LdapMethodId
	}
	return ""
}

func (x *AccountAttributeMap) GetFromAttribute() string {
	if x != nil {
		return x.FromAttribute
	}
	return ""
}

func (x *AccountAttributeMap) GetToAttribute() string {
	if x != nil {
		return x.ToAttribute
	}
	return ""
}

func (x *AccountAttributeMap) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

// DerefAliases represent aan optional configuration field used to
// determine how to derefence aliases when searching ldap.
type DerefAliases struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// create_time is set by the database.
	// @inject_tag: `gorm:"default:current_timestamp"`
	CreateTime *timestamp.Timestamp `protobuf:"bytes,10,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty" gorm:"default:current_timestamp"`
	// ldap_method_id is the FK to the UserEntrySearchConf's LDAP auth method.
	// @inject_tag: `gorm:"primary_key"`
	LdapMethodId string `protobuf:"bytes,20,opt,name=ldap_method_id,json=ldapMethodId,proto3" json:"ldap_method_id,omitempty" gorm:"primary_key"`
	// dereference_aliases will control how aliases are dereferenced when
	// performing the search. Possible values are: never, finding, searching,
	// and always. If unset, a default of "never" is used. When set to
	// "finding", it will only dereference aliases during name resolution of the
	// base. When set to "searching", it will dereference aliases after name
	// resolution.
	DereferenceAliases string `protobuf:"bytes,30,opt,name=dereference_aliases,json=dereferenceAliases,proto3" json:"dereference_aliases,omitempty"`
}

func (x *DerefAliases) Reset() {
	*x = DerefAliases{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_storage_auth_ldap_store_v1_ldap_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DerefAliases) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DerefAliases) ProtoMessage() {}

func (x *DerefAliases) ProtoReflect() protoreflect.Message {
	mi := &file_controller_storage_auth_ldap_store_v1_ldap_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DerefAliases.ProtoReflect.Descriptor instead.
func (*DerefAliases) Descriptor() ([]byte, []int) {
	return file_controller_storage_auth_ldap_store_v1_ldap_proto_rawDescGZIP(), []int{9}
}

func (x *DerefAliases) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *DerefAliases) GetLdapMethodId() string {
	if x != nil {
		return x.LdapMethodId
	}
	return ""
}

func (x *DerefAliases) GetDereferenceAliases() string {
	if x != nil {
		return x.DereferenceAliases
	}
	return ""
}

// ManagedGroup entries provide an LDAP auth method implementation of managed
// groups.
type ManagedGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// @inject_tag: `gorm:"primary_key"`
	PublicId string `protobuf:"bytes,10,opt,name=public_id,json=publicId,proto3" json:"public_id,omitempty" gorm:"primary_key"`
	// The create_time is set by the database.
	// @inject_tag: `gorm:"default:current_timestamp"`
	CreateTime *timestamp.Timestamp `protobuf:"bytes,20,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty" gorm:"default:current_timestamp"`
	// The update_time is set by the database.
	// @inject_tag: `gorm:"default:current_timestamp"`
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,30,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty" gorm:"default:current_timestamp"`
	// name is optional. If set, it must be unique within auth_method_id.
	// @inject_tag: `gorm:"default:null"`
	Name string `protobuf:"bytes,40,opt,name=name,proto3" json:"name,omitempty" gorm:"default:null"`
	// description is optional.
	// @inject_tag: `gorm:"default:null"`
	Description string `protobuf:"bytes,50,opt,name=description,proto3" json:"description,omitempty" gorm:"default:null"`
	// @inject_tag: `gorm:"default:null"`
	Version uint32 `protobuf:"varint,60,opt,name=version,proto3" json:"version,omitempty" gorm:"default:null"`
	// auth_method_id is the fk to the account's auth method.
	// @inject_tag: `gorm:"not_null"`
	AuthMethodId string `protobuf:"bytes,70,opt,name=auth_method_id,json=authMethodId,proto3" json:"auth_method_id,omitempty" gorm:"not_null"`
	// groups is json marshalled list of groups that make up the ManagedGroup
	// @inject_tag: `gorm:"not_null"`
	GroupNames string `protobuf:"bytes,80,opt,name=group_names,json=groupNames,proto3" json:"group_names,omitempty" gorm:"not_null"`
}

func (x *ManagedGroup) Reset() {
	*x = ManagedGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_storage_auth_ldap_store_v1_ldap_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ManagedGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ManagedGroup) ProtoMessage() {}

func (x *ManagedGroup) ProtoReflect() protoreflect.Message {
	mi := &file_controller_storage_auth_ldap_store_v1_ldap_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ManagedGroup.ProtoReflect.Descriptor instead.
func (*ManagedGroup) Descriptor() ([]byte, []int) {
	return file_controller_storage_auth_ldap_store_v1_ldap_proto_rawDescGZIP(), []int{10}
}

func (x *ManagedGroup) GetPublicId() string {
	if x != nil {
		return x.PublicId
	}
	return ""
}

func (x *ManagedGroup) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ManagedGroup) GetUpdateTime() *timestamp.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ManagedGroup) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ManagedGroup) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ManagedGroup) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *ManagedGroup) GetAuthMethodId() string {
	if x != nil {
		return x.AuthMethodId
	}
	return ""
}

func (x *ManagedGroup) GetGroupNames() string {
	if x != nil {
		return x.GroupNames
	}
	return ""
}

// ManagedGroupMemberAccount contains a mapping between a managed group and a
// member account.
type ManagedGroupMemberAccount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The create_time is set by the database.
	// @inject_tag: `gorm:"default:current_timestamp"`
	CreateTime *timestamp.Timestamp `protobuf:"bytes,10,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty" gorm:"default:current_timestamp"`
	// managed_group_id is the fk to the oidc managed group public id
	// @inject_tag: `gorm:"primary_key"`
	ManagedGroupId string `protobuf:"bytes,20,opt,name=managed_group_id,json=managedGroupId,proto3" json:"managed_group_id,omitempty" gorm:"primary_key"`
	// member_id is the fk to the oidc account public id
	// @inject_tag: `gorm:"primary_key"`
	MemberId string `protobuf:"bytes,30,opt,name=member_id,json=memberId,proto3" json:"member_id,omitempty" gorm:"primary_key"`
}

func (x *ManagedGroupMemberAccount) Reset() {
	*x = ManagedGroupMemberAccount{}
	if protoimpl.UnsafeEnabled {
		mi := &file_controller_storage_auth_ldap_store_v1_ldap_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ManagedGroupMemberAccount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ManagedGroupMemberAccount) ProtoMessage() {}

func (x *ManagedGroupMemberAccount) ProtoReflect() protoreflect.Message {
	mi := &file_controller_storage_auth_ldap_store_v1_ldap_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ManagedGroupMemberAccount.ProtoReflect.Descriptor instead.
func (*ManagedGroupMemberAccount) Descriptor() ([]byte, []int) {
	return file_controller_storage_auth_ldap_store_v1_ldap_proto_rawDescGZIP(), []int{11}
}

func (x *ManagedGroupMemberAccount) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ManagedGroupMemberAccount) GetManagedGroupId() string {
	if x != nil {
		return x.ManagedGroupId
	}
	return ""
}

func (x *ManagedGroupMemberAccount) GetMemberId() string {
	if x != nil {
		return x.MemberId
	}
	return ""
}

var File_controller_storage_auth_ldap_store_v1_ldap_proto protoreflect.FileDescriptor

var file_controller_storage_auth_ldap_store_v1_ldap_proto_rawDesc = []byte{
	0x0a, 0x30, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2f, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x6c, 0x64, 0x61, 0x70, 0x2f, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x6c, 0x64, 0x61, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x25, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x61, 0x75, 0x74, 0x68, 0x2e, 0x6c, 0x64, 0x61, 0x70,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x1a, 0x2a, 0x63, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65,
	0x72, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xee, 0x12, 0x0a, 0x0a, 0x41, 0x75, 0x74, 0x68, 0x4d,
	0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f,
	0x69, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63,
	0x49, 0x64, 0x12, 0x4b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x4b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x1e,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65,
	0x72, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x28, 0x20, 0x01, 0x28, 0x09, 0x42, 0x10, 0xc2, 0xdd, 0x29, 0x0c,
	0x0a, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x32, 0x20, 0x01, 0x28, 0x09, 0x42, 0x1e, 0xc2, 0xdd, 0x29, 0x1a, 0x0a, 0x0b, 0x44,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x5f, 0x69, 0x64,
	0x18, 0x3c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x49, 0x64, 0x12,
	0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x46, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x55, 0x0a, 0x11, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x50,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xc2, 0xdd, 0x29, 0x24, 0x0a, 0x10, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x10, 0x61, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x73, 0x74, 0x61, 0x74, 0x65, 0x52, 0x10,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x41, 0x0a, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x6c, 0x73, 0x18, 0x5a, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x24, 0xc2, 0xdd, 0x29, 0x20, 0x0a, 0x08, 0x53, 0x74, 0x61, 0x72, 0x74,
	0x54, 0x6c, 0x73, 0x12, 0x14, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x6c, 0x73, 0x52, 0x08, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x54, 0x6c, 0x73, 0x12, 0x4d, 0x0a, 0x0c, 0x69, 0x6e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x5f,
	0x74, 0x6c, 0x73, 0x18, 0x64, 0x20, 0x01, 0x28, 0x08, 0x42, 0x2a, 0xc2, 0xdd, 0x29, 0x26, 0x0a,
	0x0b, 0x49, 0x6e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x54, 0x6c, 0x73, 0x12, 0x17, 0x61, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x69, 0x6e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x65, 0x5f, 0x74, 0x6c, 0x73, 0x52, 0x0b, 0x69, 0x6e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x54,
	0x6c, 0x73, 0x12, 0x49, 0x0a, 0x0b, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x5f, 0x64,
	0x6e, 0x18, 0x6e, 0x20, 0x01, 0x28, 0x08, 0x42, 0x28, 0xc2, 0xdd, 0x29, 0x24, 0x0a, 0x0a, 0x44,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x44, 0x6e, 0x12, 0x16, 0x61, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x5f, 0x64,
	0x6e, 0x52, 0x0a, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x44, 0x6e, 0x12, 0x5f, 0x0a,
	0x11, 0x61, 0x6e, 0x6f, 0x6e, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x73, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x18, 0x78, 0x20, 0x01, 0x28, 0x08, 0x42, 0x33, 0xc2, 0xdd, 0x29, 0x2f, 0x0a, 0x0f,
	0x41, 0x6e, 0x6f, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12,
	0x1c, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x61, 0x6e, 0x6f, 0x6e,
	0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x0f, 0x61,
	0x6e, 0x6f, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0x46,
	0x0a, 0x0a, 0x75, 0x70, 0x6e, 0x5f, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x18, 0x82, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x26, 0xc2, 0xdd, 0x29, 0x22, 0x0a, 0x09, 0x55, 0x70, 0x6e, 0x44, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x12, 0x15, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
	0x2e, 0x75, 0x70, 0x6e, 0x5f, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x52, 0x09, 0x75, 0x70, 0x6e,
	0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x12, 0x30, 0x0a, 0x04, 0x75, 0x72, 0x6c, 0x73, 0x18, 0x8c,
	0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x1b, 0xc2, 0xdd, 0x29, 0x17, 0x0a, 0x04, 0x55, 0x72, 0x6c,
	0x73, 0x12, 0x0f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x75, 0x72,
	0x6c, 0x73, 0x52, 0x04, 0x75, 0x72, 0x6c, 0x73, 0x12, 0x3a, 0x0a, 0x07, 0x75, 0x73, 0x65, 0x72,
	0x5f, 0x64, 0x6e, 0x18, 0x96, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x20, 0xc2, 0xdd, 0x29, 0x1c,
	0x0a, 0x06, 0x55, 0x73, 0x65, 0x72, 0x44, 0x6e, 0x12, 0x12, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x73, 0x2e, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x64, 0x6e, 0x52, 0x06, 0x75, 0x73,
	0x65, 0x72, 0x44, 0x6e, 0x12, 0x42, 0x0a, 0x09, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x61, 0x74, 0x74,
	0x72, 0x18, 0xa0, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xc2, 0xdd, 0x29, 0x20, 0x0a, 0x08,
	0x55, 0x73, 0x65, 0x72, 0x41, 0x74, 0x74, 0x72, 0x12, 0x14, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x73, 0x2e, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x52, 0x08,
	0x75, 0x73, 0x65, 0x72, 0x41, 0x74, 0x74, 0x72, 0x12, 0x4a, 0x0a, 0x0b, 0x75, 0x73, 0x65, 0x72,
	0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0xaa, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28,
	0xc2, 0xdd, 0x29, 0x24, 0x0a, 0x0a, 0x55, 0x73, 0x65, 0x72, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x12, 0x16, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x75, 0x73, 0x65,
	0x72, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x12, 0x52, 0x0a, 0x0d, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0xaf, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x2c, 0xc2, 0xdd,
	0x29, 0x28, 0x0a, 0x0c, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73,
	0x12, 0x18, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x52, 0x0c, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x3e, 0x0a, 0x08, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x5f, 0x64, 0x6e, 0x18, 0xb4, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x22, 0xc2, 0xdd, 0x29,
	0x1e, 0x0a, 0x07, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x44, 0x6e, 0x12, 0x13, 0x61, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x64, 0x6e, 0x52,
	0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x44, 0x6e, 0x12, 0x46, 0x0a, 0x0a, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x18, 0xbe, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xc2,
	0xdd, 0x29, 0x22, 0x0a, 0x09, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x74, 0x74, 0x72, 0x12, 0x15,
	0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x5f, 0x61, 0x74, 0x74, 0x72, 0x52, 0x09, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x74, 0x74, 0x72,
	0x12, 0x4e, 0x0a, 0x0c, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x18, 0xc8, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xc2, 0xdd, 0x29, 0x26, 0x0a, 0x0b, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x17, 0x61, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x52, 0x0b, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x12, 0x50, 0x0a, 0x0c, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73,
	0x18, 0xd2, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x2b, 0xc2, 0xdd, 0x29, 0x27, 0x0a, 0x0c, 0x43,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x12, 0x17, 0x61, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x73, 0x52, 0x0c, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x73, 0x12, 0x66, 0x0a, 0x12, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0xdc, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x36, 0xc2, 0xdd, 0x29, 0x32, 0x0a, 0x11, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x1d, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x73, 0x2e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x11, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x74, 0x0a, 0x16, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x5f, 0x6b, 0x65, 0x79, 0x18, 0xe6, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x3d, 0xc2, 0xdd, 0x29,
	0x39, 0x0a, 0x14, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x12, 0x21, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x73, 0x2e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x52, 0x14, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79,
	0x12, 0x3e, 0x0a, 0x1b, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x68, 0x6d, 0x61, 0x63, 0x18,
	0xf0, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x18, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x48, 0x6d, 0x61, 0x63,
	0x12, 0x3a, 0x0a, 0x07, 0x62, 0x69, 0x6e, 0x64, 0x5f, 0x64, 0x6e, 0x18, 0xfa, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x20, 0xc2, 0xdd, 0x29, 0x1c, 0x0a, 0x06, 0x42, 0x69, 0x6e, 0x64, 0x44, 0x6e,
	0x12, 0x12, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x62, 0x69, 0x6e,
	0x64, 0x5f, 0x64, 0x6e, 0x52, 0x06, 0x62, 0x69, 0x6e, 0x64, 0x44, 0x6e, 0x12, 0x52, 0x0a, 0x0d,
	0x62, 0x69, 0x6e, 0x64, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x84, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xc2, 0xdd, 0x29, 0x28, 0x0a, 0x0c, 0x42, 0x69, 0x6e, 0x64,
	0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x18, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x73, 0x2e, 0x62, 0x69, 0x6e, 0x64, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f,
	0x72, 0x64, 0x52, 0x0c, 0x62, 0x69, 0x6e, 0x64, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64,
	0x12, 0x2d, 0x0a, 0x12, 0x62, 0x69, 0x6e, 0x64, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72,
	0x64, 0x5f, 0x68, 0x6d, 0x61, 0x63, 0x18, 0x8e, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x10, 0x62,
	0x69, 0x6e, 0x64, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x48, 0x6d, 0x61, 0x63, 0x12,
	0x34, 0x0a, 0x16, 0x69, 0x73, 0x5f, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x61, 0x75,
	0x74, 0x68, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x98, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x13, 0x69, 0x73, 0x50, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x41, 0x75, 0x74, 0x68, 0x4d,
	0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x5c, 0x0a, 0x10, 0x75, 0x73, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0xa2, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x31, 0xc2, 0xdd, 0x29, 0x2d, 0x0a, 0x0e, 0x55, 0x73, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x1b, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x73, 0x2e, 0x75, 0x73, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x73, 0x52, 0x0e, 0x75, 0x73, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x73, 0x12, 0x74, 0x0a, 0x16, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x61,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x70, 0x73, 0x18, 0xac, 0x02,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x3d, 0xc2, 0xdd, 0x29, 0x39, 0x0a, 0x14, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x73,
	0x12, 0x21, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x70, 0x73, 0x52, 0x14, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x41, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x73, 0x12, 0x60, 0x0a, 0x11, 0x6d, 0x61, 0x78,
	0x69, 0x6d, 0x75, 0x6d, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0xb6,
	0x02, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x33, 0xc2, 0xdd, 0x29, 0x2f, 0x0a, 0x0f, 0x4d, 0x61, 0x78,
	0x69, 0x6d, 0x75, 0x6d, 0x50, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1c, 0x61, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x52, 0x0f, 0x6d, 0x61, 0x78, 0x69,
	0x6d, 0x75, 0x6d, 0x50, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x6a, 0x0a, 0x13, 0x64,
	0x65, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x61, 0x6c, 0x69, 0x61, 0x73,
	0x65, 0x73, 0x18, 0xc0, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xc2, 0xdd, 0x29, 0x34, 0x0a,
	0x12, 0x44, 0x65, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x41, 0x6c, 0x69, 0x61,
	0x73, 0x65, 0x73, 0x12, 0x1e, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e,
	0x64, 0x65, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x61, 0x6c, 0x69, 0x61,
	0x73, 0x65, 0x73, 0x52, 0x12, 0x64, 0x65, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x41, 0x6c, 0x69, 0x61, 0x73, 0x65, 0x73, 0x22, 0xc8, 0x01, 0x0a, 0x03, 0x55, 0x72, 0x6c, 0x12,
	0x4b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65,
	0x72, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0e,
	0x6c, 0x64, 0x61, 0x70, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x14,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x64, 0x61, 0x70, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64,
	0x49, 0x64, 0x12, 0x2f, 0x0a, 0x13, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x12, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x69, 0x6f, 0x72,
	0x69, 0x74, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x75, 0x72,
	0x6c, 0x18, 0x28, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x55,
	0x72, 0x6c, 0x22, 0xdf, 0x01, 0x0a, 0x13, 0x55, 0x73, 0x65, 0x72, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x12, 0x4b, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0e, 0x6c, 0x64, 0x61, 0x70, 0x5f,
	0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x14, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x6c, 0x64, 0x61, 0x70, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x49, 0x64, 0x12, 0x17, 0x0a,
	0x07, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x64, 0x6e, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x75, 0x73, 0x65, 0x72, 0x44, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x61,
	0x74, 0x74, 0x72, 0x18, 0x28, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x41,
	0x74, 0x74, 0x72, 0x12, 0x1f, 0x0a, 0x0b, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x32, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x22, 0xe6, 0x01, 0x0a, 0x14, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x12, 0x4b, 0x0a,
	0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0e, 0x6c, 0x64,
	0x61, 0x70, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x14, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x6c, 0x64, 0x61, 0x70, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x49, 0x64,
	0x12, 0x19, 0x0a, 0x08, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x64, 0x6e, 0x18, 0x1e, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x44, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x18, 0x28, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x74, 0x74, 0x72, 0x12, 0x21, 0x0a, 0x0c, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x32, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x94, 0x01,
	0x0a, 0x0b, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x4b, 0x0a,
	0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0e, 0x6c, 0x64,
	0x61, 0x70, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x14, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x6c, 0x64, 0x61, 0x70, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x49, 0x64,
	0x12, 0x12, 0x0a, 0x04, 0x63, 0x65, 0x72, 0x74, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x63, 0x65, 0x72, 0x74, 0x22, 0xc8, 0x02, 0x0a, 0x11, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x4b, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0e, 0x6c, 0x64, 0x61, 0x70, 0x5f,
	0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x14, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x6c, 0x64, 0x61, 0x70, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x49, 0x64, 0x12, 0x20, 0x0a,
	0x0b, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x1e, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x0b, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12,
	0x27, 0x0a, 0x0f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x6b,
	0x65, 0x79, 0x18, 0x28, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x12, 0x2c, 0x0a, 0x12, 0x63, 0x74, 0x5f, 0x63,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x32,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x10, 0x63, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x12, 0x30, 0x0a, 0x14, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x68, 0x6d, 0x61, 0x63, 0x18, 0x3c,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x12, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x4b, 0x65, 0x79, 0x48, 0x6d, 0x61, 0x63, 0x12, 0x15, 0x0a, 0x06, 0x6b, 0x65, 0x79, 0x5f,
	0x69, 0x64, 0x18, 0x46, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6b, 0x65, 0x79, 0x49, 0x64, 0x22,
	0x8c, 0x02, 0x0a, 0x0e, 0x42, 0x69, 0x6e, 0x64, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x61, 0x6c, 0x12, 0x4b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x24, 0x0a, 0x0e, 0x6c, 0x64, 0x61, 0x70, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x5f, 0x69,
	0x64, 0x18, 0x14, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x64, 0x61, 0x70, 0x4d, 0x65, 0x74,
	0x68, 0x6f, 0x64, 0x49, 0x64, 0x12, 0x0e, 0x0a, 0x02, 0x64, 0x6e, 0x18, 0x1e, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x02, 0x64, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72,
	0x64, 0x18, 0x28, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72,
	0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x74, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64,
	0x18, 0x32, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x63, 0x74, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f,
	0x72, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x68,
	0x6d, 0x61, 0x63, 0x18, 0x3c, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0c, 0x70, 0x61, 0x73, 0x73, 0x77,
	0x6f, 0x72, 0x64, 0x48, 0x6d, 0x61, 0x63, 0x12, 0x15, 0x0a, 0x06, 0x6b, 0x65, 0x79, 0x5f, 0x69,
	0x64, 0x18, 0x46, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6b, 0x65, 0x79, 0x49, 0x64, 0x22, 0x90,
	0x04, 0x0a, 0x07, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x75,
	0x62, 0x6c, 0x69, 0x63, 0x5f, 0x69, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70,
	0x75, 0x62, 0x6c, 0x69, 0x63, 0x49, 0x64, 0x12, 0x4b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x24, 0x0a, 0x0e, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64,
	0x5f, 0x69, 0x64, 0x18, 0x28, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x75, 0x74, 0x68, 0x4d,
	0x65, 0x74, 0x68, 0x6f, 0x64, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x32, 0x20, 0x01, 0x28, 0x09, 0x42, 0x10, 0xc2, 0xdd, 0x29, 0x0c, 0x0a, 0x04, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x3c, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x1e, 0xc2, 0xdd, 0x29, 0x1a, 0x0a, 0x0b, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x19, 0x0a, 0x08, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x46, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x49, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x50, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x5a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x64, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x66, 0x75, 0x6c, 0x6c, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x14, 0x0a, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x6e, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x12, 0x0e, 0x0a, 0x02, 0x64, 0x6e, 0x18, 0x78, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x02, 0x64, 0x6e, 0x12, 0x29, 0x0a, 0x10, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x5f, 0x6f, 0x66, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x8c, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0e, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x4f, 0x66, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x73, 0x22, 0xd2, 0x01, 0x0a, 0x13, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x12, 0x24, 0x0a, 0x0e, 0x6c, 0x64, 0x61,
	0x70, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x6c, 0x64, 0x61, 0x70, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x49, 0x64, 0x12,
	0x25, 0x0a, 0x0e, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x66, 0x72, 0x6f, 0x6d, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x74, 0x6f, 0x5f, 0x61, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x74, 0x6f,
	0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x4b, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x28, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xb2, 0x01, 0x0a, 0x0c, 0x44, 0x65, 0x72, 0x65, 0x66,
	0x41, 0x6c, 0x69, 0x61, 0x73, 0x65, 0x73, 0x12, 0x4b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0e, 0x6c, 0x64, 0x61, 0x70, 0x5f, 0x6d, 0x65, 0x74,
	0x68, 0x6f, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x14, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x64,
	0x61, 0x70, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x49, 0x64, 0x12, 0x2f, 0x0a, 0x13, 0x64, 0x65,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x65,
	0x73, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x64, 0x65, 0x72, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x41, 0x6c, 0x69, 0x61, 0x73, 0x65, 0x73, 0x22, 0xb8, 0x03, 0x0a, 0x0c,
	0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x1b, 0x0a, 0x09,
	0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x69, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x49, 0x64, 0x12, 0x4b, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x28, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x10, 0xc2, 0xdd, 0x29, 0x0c, 0x0a, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x32, 0x20, 0x01, 0x28, 0x09, 0x42, 0x1e,
	0xc2, 0xdd, 0x29, 0x1a, 0x0a, 0x0b, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x3c, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0e, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x6d, 0x65,
	0x74, 0x68, 0x6f, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x46, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61,
	0x75, 0x74, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x49, 0x64, 0x12, 0x49, 0x0a, 0x0b, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x50, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x28, 0xc2, 0xdd, 0x29, 0x24, 0x0a, 0x0a, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4e, 0x61, 0x6d,
	0x65, 0x73, 0x12, 0x16, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x52, 0x0a, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x22, 0xaf, 0x01, 0x0a, 0x19, 0x4d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x4b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x28, 0x0a, 0x10, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x5f, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x14, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x6d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x49, 0x64, 0x42, 0x3e, 0x5a, 0x3c, 0x67, 0x69, 0x74, 0x68,
	0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70,
	0x2f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x6c, 0x64, 0x61, 0x70, 0x2f, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x3b, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_controller_storage_auth_ldap_store_v1_ldap_proto_rawDescOnce sync.Once
	file_controller_storage_auth_ldap_store_v1_ldap_proto_rawDescData = file_controller_storage_auth_ldap_store_v1_ldap_proto_rawDesc
)

func file_controller_storage_auth_ldap_store_v1_ldap_proto_rawDescGZIP() []byte {
	file_controller_storage_auth_ldap_store_v1_ldap_proto_rawDescOnce.Do(func() {
		file_controller_storage_auth_ldap_store_v1_ldap_proto_rawDescData = protoimpl.X.CompressGZIP(file_controller_storage_auth_ldap_store_v1_ldap_proto_rawDescData)
	})
	return file_controller_storage_auth_ldap_store_v1_ldap_proto_rawDescData
}

var file_controller_storage_auth_ldap_store_v1_ldap_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_controller_storage_auth_ldap_store_v1_ldap_proto_goTypes = []any{
	(*AuthMethod)(nil),                // 0: controller.storage.auth.ldap.store.v1.AuthMethod
	(*Url)(nil),                       // 1: controller.storage.auth.ldap.store.v1.Url
	(*UserEntrySearchConf)(nil),       // 2: controller.storage.auth.ldap.store.v1.UserEntrySearchConf
	(*GroupEntrySearchConf)(nil),      // 3: controller.storage.auth.ldap.store.v1.GroupEntrySearchConf
	(*Certificate)(nil),               // 4: controller.storage.auth.ldap.store.v1.Certificate
	(*ClientCertificate)(nil),         // 5: controller.storage.auth.ldap.store.v1.ClientCertificate
	(*BindCredential)(nil),            // 6: controller.storage.auth.ldap.store.v1.BindCredential
	(*Account)(nil),                   // 7: controller.storage.auth.ldap.store.v1.Account
	(*AccountAttributeMap)(nil),       // 8: controller.storage.auth.ldap.store.v1.AccountAttributeMap
	(*DerefAliases)(nil),              // 9: controller.storage.auth.ldap.store.v1.DerefAliases
	(*ManagedGroup)(nil),              // 10: controller.storage.auth.ldap.store.v1.ManagedGroup
	(*ManagedGroupMemberAccount)(nil), // 11: controller.storage.auth.ldap.store.v1.ManagedGroupMemberAccount
	(*timestamp.Timestamp)(nil),       // 12: controller.storage.timestamp.v1.Timestamp
}
var file_controller_storage_auth_ldap_store_v1_ldap_proto_depIdxs = []int32{
	12, // 0: controller.storage.auth.ldap.store.v1.AuthMethod.create_time:type_name -> controller.storage.timestamp.v1.Timestamp
	12, // 1: controller.storage.auth.ldap.store.v1.AuthMethod.update_time:type_name -> controller.storage.timestamp.v1.Timestamp
	12, // 2: controller.storage.auth.ldap.store.v1.Url.create_time:type_name -> controller.storage.timestamp.v1.Timestamp
	12, // 3: controller.storage.auth.ldap.store.v1.UserEntrySearchConf.create_time:type_name -> controller.storage.timestamp.v1.Timestamp
	12, // 4: controller.storage.auth.ldap.store.v1.GroupEntrySearchConf.create_time:type_name -> controller.storage.timestamp.v1.Timestamp
	12, // 5: controller.storage.auth.ldap.store.v1.Certificate.create_time:type_name -> controller.storage.timestamp.v1.Timestamp
	12, // 6: controller.storage.auth.ldap.store.v1.ClientCertificate.create_time:type_name -> controller.storage.timestamp.v1.Timestamp
	12, // 7: controller.storage.auth.ldap.store.v1.BindCredential.create_time:type_name -> controller.storage.timestamp.v1.Timestamp
	12, // 8: controller.storage.auth.ldap.store.v1.Account.create_time:type_name -> controller.storage.timestamp.v1.Timestamp
	12, // 9: controller.storage.auth.ldap.store.v1.Account.update_time:type_name -> controller.storage.timestamp.v1.Timestamp
	12, // 10: controller.storage.auth.ldap.store.v1.AccountAttributeMap.create_time:type_name -> controller.storage.timestamp.v1.Timestamp
	12, // 11: controller.storage.auth.ldap.store.v1.DerefAliases.create_time:type_name -> controller.storage.timestamp.v1.Timestamp
	12, // 12: controller.storage.auth.ldap.store.v1.ManagedGroup.create_time:type_name -> controller.storage.timestamp.v1.Timestamp
	12, // 13: controller.storage.auth.ldap.store.v1.ManagedGroup.update_time:type_name -> controller.storage.timestamp.v1.Timestamp
	12, // 14: controller.storage.auth.ldap.store.v1.ManagedGroupMemberAccount.create_time:type_name -> controller.storage.timestamp.v1.Timestamp
	15, // [15:15] is the sub-list for method output_type
	15, // [15:15] is the sub-list for method input_type
	15, // [15:15] is the sub-list for extension type_name
	15, // [15:15] is the sub-list for extension extendee
	0,  // [0:15] is the sub-list for field type_name
}

func init() { file_controller_storage_auth_ldap_store_v1_ldap_proto_init() }
func file_controller_storage_auth_ldap_store_v1_ldap_proto_init() {
	if File_controller_storage_auth_ldap_store_v1_ldap_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_controller_storage_auth_ldap_store_v1_ldap_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*AuthMethod); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_storage_auth_ldap_store_v1_ldap_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*Url); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_storage_auth_ldap_store_v1_ldap_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*UserEntrySearchConf); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_storage_auth_ldap_store_v1_ldap_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*GroupEntrySearchConf); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_storage_auth_ldap_store_v1_ldap_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*Certificate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_storage_auth_ldap_store_v1_ldap_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*ClientCertificate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_storage_auth_ldap_store_v1_ldap_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*BindCredential); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_storage_auth_ldap_store_v1_ldap_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*Account); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_storage_auth_ldap_store_v1_ldap_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*AccountAttributeMap); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_storage_auth_ldap_store_v1_ldap_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*DerefAliases); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_storage_auth_ldap_store_v1_ldap_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*ManagedGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_controller_storage_auth_ldap_store_v1_ldap_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*ManagedGroupMemberAccount); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_controller_storage_auth_ldap_store_v1_ldap_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_controller_storage_auth_ldap_store_v1_ldap_proto_goTypes,
		DependencyIndexes: file_controller_storage_auth_ldap_store_v1_ldap_proto_depIdxs,
		MessageInfos:      file_controller_storage_auth_ldap_store_v1_ldap_proto_msgTypes,
	}.Build()
	File_controller_storage_auth_ldap_store_v1_ldap_proto = out.File
	file_controller_storage_auth_ldap_store_v1_ldap_proto_rawDesc = nil
	file_controller_storage_auth_ldap_store_v1_ldap_proto_goTypes = nil
	file_controller_storage_auth_ldap_store_v1_ldap_proto_depIdxs = nil
}
