// Code generated by "make api"; DO NOT EDIT.
// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

package sessionrecordings

import (
	"fmt"

	"github.com/mitchellh/mapstructure"
)

type VaultCredentialStoreAttributes struct {
	Address       string `json:"address,omitempty"`
	Namespace     string `json:"namespace,omitempty"`
	TlsServerName string `json:"tls_server_name,omitempty"`
	TlsSkipVerify bool   `json:"tls_skip_verify,omitempty"`
	WorkerFilter  string `json:"worker_filter,omitempty"`
}

func AttributesMapToVaultCredentialStoreAttributes(in map[string]any) (*VaultCredentialStoreAttributes, error) {
	if in == nil {
		return nil, fmt.Errorf("nil input map")
	}
	var out VaultCredentialStoreAttributes
	dec, err := mapstructure.NewDecoder(&mapstructure.DecoderConfig{
		Result:  &out,
		TagName: "json",
	})
	if err != nil {
		return nil, fmt.Errorf("error creating mapstructure decoder: %w", err)
	}
	if err := dec.Decode(in); err != nil {
		return nil, fmt.Errorf("error decoding: %w", err)
	}
	return &out, nil
}

func (pt *CredentialStore) GetVaultCredentialStoreAttributes() (*VaultCredentialStoreAttributes, error) {
	if pt.Type != "vault" {
		return nil, fmt.Errorf("asked to fetch %s-type attributes but credential-store is of type %s", "vault", pt.Type)
	}
	return AttributesMapToVaultCredentialStoreAttributes(pt.Attributes)
}
