// Code generated by "make api"; DO NOT EDIT.
// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

package sessionrecordings

import (
	"fmt"

	"github.com/mitchellh/mapstructure"
)

type VaultCredentialLibraryAttributes struct {
	Path            string `json:"path,omitempty"`
	HttpMethod      string `json:"http_method,omitempty"`
	HttpRequestBody string `json:"http_request_body,omitempty"`
}

func AttributesMapToVaultCredentialLibraryAttributes(in map[string]any) (*VaultCredentialLibraryAttributes, error) {
	if in == nil {
		return nil, fmt.Errorf("nil input map")
	}
	var out VaultCredentialLibraryAttributes
	dec, err := mapstructure.NewDecoder(&mapstructure.DecoderConfig{
		Result:  &out,
		TagName: "json",
	})
	if err != nil {
		return nil, fmt.Errorf("error creating mapstructure decoder: %w", err)
	}
	if err := dec.Decode(in); err != nil {
		return nil, fmt.Errorf("error decoding: %w", err)
	}
	return &out, nil
}

func (pt *CredentialLibrary) GetVaultCredentialLibraryAttributes() (*VaultCredentialLibraryAttributes, error) {
	if pt.Type != "vault-generic" {
		return nil, fmt.Errorf("asked to fetch %s-type attributes but credential-library is of type %s", "vault-generic", pt.Type)
	}
	return AttributesMapToVaultCredentialLibraryAttributes(pt.Attributes)
}
