// Code generated by "make api"; DO NOT EDIT.
// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

package sessionrecordings

import (
	"fmt"

	"github.com/mitchellh/mapstructure"
)

type SshTargetAttributes struct {
	DefaultPort       uint32 `json:"default_port,omitempty"`
	DefaultClientPort uint32 `json:"default_client_port,omitempty"`
}

func AttributesMapToSshTargetAttributes(in map[string]any) (*SshTargetAttributes, error) {
	if in == nil {
		return nil, fmt.Errorf("nil input map")
	}
	var out SshTargetAttributes
	dec, err := mapstructure.NewDecoder(&mapstructure.DecoderConfig{
		Result:  &out,
		TagName: "json",
	})
	if err != nil {
		return nil, fmt.Errorf("error creating mapstructure decoder: %w", err)
	}
	if err := dec.Decode(in); err != nil {
		return nil, fmt.Errorf("error decoding: %w", err)
	}
	return &out, nil
}

func (pt *Target) GetSshTargetAttributes() (*SshTargetAttributes, error) {
	if pt.Type != "ssh" {
		return nil, fmt.Errorf("asked to fetch %s-type attributes but target is of type %s", "ssh", pt.Type)
	}
	return AttributesMapToSshTargetAttributes(pt.Attributes)
}
