// Code generated by "make api"; DO NOT EDIT.
// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

package sessionrecordings

import (
	"fmt"

	"github.com/mitchellh/mapstructure"
)

type SshPrivateKeyCredentialAttributes struct {
	Username                 string `json:"username,omitempty"`
	PrivateKeyHmac           string `json:"private_key_hmac,omitempty"`
	PrivateKeyPassphraseHmac string `json:"private_key_passphrase_hmac,omitempty"`
}

func AttributesMapToSshPrivateKeyCredentialAttributes(in map[string]any) (*SshPrivateKeyCredentialAttributes, error) {
	if in == nil {
		return nil, fmt.Errorf("nil input map")
	}
	var out SshPrivateKeyCredentialAttributes
	dec, err := mapstructure.NewDecoder(&mapstructure.DecoderConfig{
		Result:  &out,
		TagName: "json",
	})
	if err != nil {
		return nil, fmt.Errorf("error creating mapstructure decoder: %w", err)
	}
	if err := dec.Decode(in); err != nil {
		return nil, fmt.Errorf("error decoding: %w", err)
	}
	return &out, nil
}

func (pt *Credential) GetSshPrivateKeyCredentialAttributes() (*SshPrivateKeyCredentialAttributes, error) {
	if pt.Type != "ssh_private_key" {
		return nil, fmt.Errorf("asked to fetch %s-type attributes but credential is of type %s", "ssh_private_key", pt.Type)
	}
	return AttributesMapToSshPrivateKeyCredentialAttributes(pt.Attributes)
}
