// Code generated by "make api"; DO NOT EDIT.
// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

package sessionrecordings

import (
	"fmt"

	"github.com/mitchellh/mapstructure"
)

type JsonCredentialAttributes struct {
	ObjectHmac string `json:"object_hmac,omitempty"`
}

func AttributesMapToJsonCredentialAttributes(in map[string]any) (*JsonCredentialAttributes, error) {
	if in == nil {
		return nil, fmt.Errorf("nil input map")
	}
	var out JsonCredentialAttributes
	dec, err := mapstructure.NewDecoder(&mapstructure.DecoderConfig{
		Result:  &out,
		TagName: "json",
	})
	if err != nil {
		return nil, fmt.Errorf("error creating mapstructure decoder: %w", err)
	}
	if err := dec.Decode(in); err != nil {
		return nil, fmt.Errorf("error decoding: %w", err)
	}
	return &out, nil
}

func (pt *Credential) GetJsonCredentialAttributes() (*JsonCredentialAttributes, error) {
	if pt.Type != "json" {
		return nil, fmt.Errorf("asked to fetch %s-type attributes but credential is of type %s", "json", pt.Type)
	}
	return AttributesMapToJsonCredentialAttributes(pt.Attributes)
}
