// Code generated by "make api"; DO NOT EDIT.
// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

package authmethods

import (
	"fmt"

	"github.com/mitchellh/mapstructure"
)

type OidcAuthMethodAttributes struct {
	State                             string   `json:"state,omitempty"`
	Issuer                            string   `json:"issuer,omitempty"`
	ClientId                          string   `json:"client_id,omitempty"`
	ClientSecret                      string   `json:"client_secret,omitempty"`
	ClientSecretHmac                  string   `json:"client_secret_hmac,omitempty"`
	MaxAge                            uint32   `json:"max_age,omitempty"`
	SigningAlgorithms                 []string `json:"signing_algorithms,omitempty"`
	ApiUrlPrefix                      string   `json:"api_url_prefix,omitempty"`
	CallbackUrl                       string   `json:"callback_url,omitempty"`
	IdpCaCerts                        []string `json:"idp_ca_certs,omitempty"`
	AllowedAudiences                  []string `json:"allowed_audiences,omitempty"`
	ClaimsScopes                      []string `json:"claims_scopes,omitempty"`
	AccountClaimMaps                  []string `json:"account_claim_maps,omitempty"`
	DisableDiscoveredConfigValidation bool     `json:"disable_discovered_config_validation,omitempty"`
	DryRun                            bool     `json:"dry_run,omitempty"`
	Prompts                           []string `json:"prompts,omitempty"`
}

func AttributesMapToOidcAuthMethodAttributes(in map[string]any) (*OidcAuthMethodAttributes, error) {
	if in == nil {
		return nil, fmt.Errorf("nil input map")
	}
	var out OidcAuthMethodAttributes
	dec, err := mapstructure.NewDecoder(&mapstructure.DecoderConfig{
		Result:  &out,
		TagName: "json",
	})
	if err != nil {
		return nil, fmt.Errorf("error creating mapstructure decoder: %w", err)
	}
	if err := dec.Decode(in); err != nil {
		return nil, fmt.Errorf("error decoding: %w", err)
	}
	return &out, nil
}

func (pt *AuthMethod) GetOidcAuthMethodAttributes() (*OidcAuthMethodAttributes, error) {
	if pt.Type != "oidc" {
		return nil, fmt.Errorf("asked to fetch %s-type attributes but auth-method is of type %s", "oidc", pt.Type)
	}
	return AttributesMapToOidcAuthMethodAttributes(pt.Attributes)
}
