// Code generated by "make api"; DO NOT EDIT.
// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

package authmethods

import (
	"fmt"

	"github.com/mitchellh/mapstructure"
)

type LdapAuthMethodAttributes struct {
	State                    string   `json:"state,omitempty"`
	StartTls                 bool     `json:"start_tls,omitempty"`
	InsecureTls              bool     `json:"insecure_tls,omitempty"`
	DiscoverDn               bool     `json:"discover_dn,omitempty"`
	AnonGroupSearch          bool     `json:"anon_group_search,omitempty"`
	UpnDomain                string   `json:"upn_domain,omitempty"`
	Urls                     []string `json:"urls,omitempty"`
	UserDn                   string   `json:"user_dn,omitempty"`
	UserAttr                 string   `json:"user_attr,omitempty"`
	UserFilter               string   `json:"user_filter,omitempty"`
	EnableGroups             bool     `json:"enable_groups,omitempty"`
	GroupDn                  string   `json:"group_dn,omitempty"`
	GroupAttr                string   `json:"group_attr,omitempty"`
	GroupFilter              string   `json:"group_filter,omitempty"`
	Certificates             []string `json:"certificates,omitempty"`
	ClientCertificate        string   `json:"client_certificate,omitempty"`
	ClientCertificateKey     string   `json:"client_certificate_key,omitempty"`
	ClientCertificateKeyHmac string   `json:"client_certificate_key_hmac,omitempty"`
	BindDn                   string   `json:"bind_dn,omitempty"`
	BindPassword             string   `json:"bind_password,omitempty"`
	BindPasswordHmac         string   `json:"bind_password_hmac,omitempty"`
	UseTokenGroups           bool     `json:"use_token_groups,omitempty"`
	AccountAttributeMaps     []string `json:"account_attribute_maps,omitempty"`
	MaximumPageSize          uint32   `json:"maximum_page_size,omitempty"`
	DereferenceAliases       string   `json:"dereference_aliases,omitempty"`
}

func AttributesMapToLdapAuthMethodAttributes(in map[string]any) (*LdapAuthMethodAttributes, error) {
	if in == nil {
		return nil, fmt.Errorf("nil input map")
	}
	var out LdapAuthMethodAttributes
	dec, err := mapstructure.NewDecoder(&mapstructure.DecoderConfig{
		Result:  &out,
		TagName: "json",
	})
	if err != nil {
		return nil, fmt.Errorf("error creating mapstructure decoder: %w", err)
	}
	if err := dec.Decode(in); err != nil {
		return nil, fmt.Errorf("error decoding: %w", err)
	}
	return &out, nil
}

func (pt *AuthMethod) GetLdapAuthMethodAttributes() (*LdapAuthMethodAttributes, error) {
	if pt.Type != "ldap" {
		return nil, fmt.Errorf("asked to fetch %s-type attributes but auth-method is of type %s", "ldap", pt.Type)
	}
	return AttributesMapToLdapAuthMethodAttributes(pt.Attributes)
}
