// Code generated by "make api"; DO NOT EDIT.
// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

package accounts

import (
	"fmt"

	"github.com/mitchellh/mapstructure"
)

type LdapAccountAttributes struct {
	LoginName      string   `json:"login_name,omitempty"`
	FullName       string   `json:"full_name,omitempty"`
	Email          string   `json:"email,omitempty"`
	Dn             string   `json:"dn,omitempty"`
	MemberOfGroups []string `json:"member_of_groups,omitempty"`
}

func AttributesMapToLdapAccountAttributes(in map[string]any) (*LdapAccountAttributes, error) {
	if in == nil {
		return nil, fmt.Errorf("nil input map")
	}
	var out LdapAccountAttributes
	dec, err := mapstructure.NewDecoder(&mapstructure.DecoderConfig{
		Result:  &out,
		TagName: "json",
	})
	if err != nil {
		return nil, fmt.Errorf("error creating mapstructure decoder: %w", err)
	}
	if err := dec.Decode(in); err != nil {
		return nil, fmt.Errorf("error decoding: %w", err)
	}
	return &out, nil
}

func (pt *Account) GetLdapAccountAttributes() (*LdapAccountAttributes, error) {
	if pt.Type != "ldap" {
		return nil, fmt.Errorf("asked to fetch %s-type attributes but account is of type %s", "ldap", pt.Type)
	}
	return AttributesMapToLdapAccountAttributes(pt.Attributes)
}
