# Generated by Django 3.1.6 on 2021-02-14 23:39

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="DebianLogIndex",
            fields=[
                ("log_id", models.AutoField(primary_key=True, serialize=False)),
                ("ident", models.IntegerField(blank=True, null=True)),
                (
                    "kind",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("ITA", "ITA (Intent to adopt)"),
                            ("ITP", "ITP (Intent to package)"),
                            ("O", "O (Orphaned)"),
                            ("RFA", "RFA (Request for adoption)"),
                            ("RFH", "RFH (Request for help)"),
                            ("RFP", "RFP (request for packaging)"),
                        ],
                        db_column="type",
                        max_length=3,
                        null=True,
                    ),
                ),
                ("project", models.CharField(blank=True, max_length=255, null=True)),
                ("description", models.CharField(blank=True, max_length=255, null=True)),
                ("log_stamp", models.DateTimeField(blank=True, null=True)),
                (
                    "event",
                    models.CharField(
                        choices=[("MOD", "modified"), ("OPEN", "opened"), ("CLOSE", "closed")],
                        max_length=5,
                    ),
                ),
                ("event_stamp", models.DateTimeField(blank=True, null=True)),
            ],
            options={
                "db_table": "debian_log_index",
            },
        ),
        migrations.CreateModel(
            name="DebianPopcon",
            fields=[
                ("package", models.CharField(max_length=255, primary_key=True, serialize=False)),
                ("inst", models.IntegerField(blank=True, null=True)),
                ("vote", models.IntegerField(blank=True, null=True)),
                ("old", models.IntegerField(blank=True, null=True)),
                ("recent", models.IntegerField(blank=True, null=True)),
                ("nofiles", models.IntegerField(blank=True, null=True)),
            ],
            options={
                "db_table": "debian_popcon",
            },
        ),
        migrations.CreateModel(
            name="DebianLogMods",
            fields=[
                (
                    "log",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        primary_key=True,
                        related_name="kind_change",
                        related_query_name="kind_change",
                        serialize=False,
                        to="wnpp_debian_net.debianlogindex",
                    ),
                ),
                (
                    "old_kind",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("ITA", "ITA (Intent to adopt)"),
                            ("ITP", "ITP (Intent to package)"),
                            ("O", "O (Orphaned)"),
                            ("RFA", "RFA (Request for adoption)"),
                            ("RFH", "RFH (Request for help)"),
                            ("RFP", "RFP (request for packaging)"),
                        ],
                        db_column="before_type",
                        max_length=3,
                        null=True,
                    ),
                ),
                (
                    "new_kind",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("ITA", "ITA (Intent to adopt)"),
                            ("ITP", "ITP (Intent to package)"),
                            ("O", "O (Orphaned)"),
                            ("RFA", "RFA (Request for adoption)"),
                            ("RFH", "RFH (Request for help)"),
                            ("RFP", "RFP (request for packaging)"),
                        ],
                        db_column="after_type",
                        max_length=3,
                        null=True,
                    ),
                ),
            ],
            options={
                "db_table": "debian_log_mods",
            },
        ),
        migrations.CreateModel(
            name="DebianWnpp",
            fields=[
                ("ident", models.IntegerField(primary_key=True, serialize=False)),
                ("open_person", models.CharField(blank=True, max_length=255, null=True)),
                ("open_stamp", models.DateTimeField(blank=True, null=True)),
                ("mod_stamp", models.DateTimeField(blank=True, null=True)),
                (
                    "kind",
                    models.CharField(
                        choices=[
                            ("ITA", "ITA (Intent to adopt)"),
                            ("ITP", "ITP (Intent to package)"),
                            ("O", "O (Orphaned)"),
                            ("RFA", "RFA (Request for adoption)"),
                            ("RFH", "RFH (Request for help)"),
                            ("RFP", "RFP (request for packaging)"),
                        ],
                        db_column="type",
                        max_length=3,
                    ),
                ),
                ("description", models.CharField(blank=True, max_length=255, null=True)),
                ("charge_person", models.CharField(blank=True, max_length=255, null=True)),
                ("cron_stamp", models.DateTimeField()),
                (
                    "popcon",
                    models.ForeignKey(
                        db_column="project",
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        to="wnpp_debian_net.debianpopcon",
                    ),
                ),
            ],
            options={
                "db_table": "debian_wnpp",
            },
        ),
    ]
