---
sidebar_position: 14
title: .gitconfig
description: Пример файла .gitconfig
---

# .gitconfig

```bash
[user]
	name = John Smith
	email = john@mail.com
	username = johnsmith
[core]
	editor = vscode
	whitespace = fix,-indent-with-non-tab,trailing-space,cr-at-eol
	pager = delta
[web]
	browser = google-chrome
[instaweb]
	httpd = apache2 -f
[rerere]
	enabled = 1
	autoupdate = 1
[push]
	default = matching
[color]
	ui = auto
[color "branch"]
	current = yellow bold
	local = green bold
	remote = cyan bold
[color "diff"]
	meta = yellow bold
	frag = magenta bold
	old = red bold
	new = green bold
	whitespace = red reverse
[color "status"]
	added = green bold
	changed = yellow bold
	untracked = red bold
[difftool]
	prompt = false
[delta]
	features = line-numbers decorations
	line-numbers = true
[delta "decorations"]
	minus-style = red bold normal
	plus-style = green bold normal
	minus-emph-style = white bold red
	minus-non-emph-style = red bold normal
	plus-emph-style = white bold green
	plus-non-emph-style = green bold normal
	file-style = yellow bold none
	file-decoration-style = yellow box
	hunk-header-style = magenta bold
	hunk-header-decoration-style = magenta box
	minus-empty-line-marker-style = normal normal
	plus-empty-line-marker-style = normal normal
	line-numbers-right-format = "{np:^4}│ "
[github]
	user = johnsmith
	token = token
[gitflow "prefix"]
	versiontag = v
[sequence]
	editor = interactive-rebase-tool
[alias]
	aa = add .
	ai = add -i
	###
	ap = apply
	as = apply --stat
	ac = apply --check
	###
	ama = am --abort
	amr = am --resolved
	ams = am --skip
	###
	b = branch
	ba = branch -a
	bd = branch -d
	bdd = branch -D
	br = branch -r
	bc = rev-parse --abbrev-ref HEAD
	bu = !git rev-parse --abbrev-ref --symbolic-full-name "@{u}"
	bs = !git-branch-status
	###
	c = commit
	ca = commit -a
	cm = commit -m
	cam = commit -am
	cem = commit --allow-empty -m
	cd = commit --amend
	cad = commit -a --amend
	ced = commit --allow-empty --amend
	###
	cl = clone
	cld = clone --depth 1
	clg = !sh -c 'git clone git://github.com/$1 $(basename $1)' -
	clgp = !sh -c 'git clone git@github.com:$1 $(basename $1)' -
	clgu = !sh -c 'git clone git@github.com:$(git config --get user.username)/$1 $1' -
	###
	cp = cherry-pick
	cpa = cherry-pick --abort
	cpc = cherry-pick --continue
	###
	d = diff
	dp = diff --patience
	dc = diff --cached
	dk = diff --check
	dck = diff --cached --check
	dt = difftool
	dct = difftool --cached
	###
	f = fetch
	fo = fetch origin
	fu = fetch upstream
	###
	fp = format-patch
	###
	fk = fsck
	###
	g = grep -p
	###
	l = log --oneline
	lg = log --oneline --graph --decorate
	###
	ls = ls-files
	lsf = !git ls-files | grep -i
	###
	m = merge
	ma = merge --abort
	mc = merge --continue
	ms = merge --skip
	###
	o = checkout
	om = checkout master
	ob = checkout -b
	opr = !sh -c 'git fo pull/$1/head:pr-$1 && git o pr-$1'
	###
	pr = prune -v
	###
	ps = push
	psf = push -f
	psu = push -u
	pst = push --tags
	###
	pso = push origin
	psao = push --all origin
	psfo = push -f origin
	psuo = push -u origin
	###
	psom = push origin master
	psaom = push --all origin master
	psfom = push -f origin master
	psuom = push -u origin master
	psoc = !git push origin $(git bc)
	psaoc = !git push --all origin $(git bc)
	psfoc = !git push -f origin $(git bc)
	psuoc = !git push -u origin $(git bc)
	psdc = !git push origin :$(git bc)
	###
	pl = pull
	pb = pull --rebase
	###
	plo = pull origin
	pbo = pull --rebase origin
	plom = pull origin master
	ploc = !git pull origin $(git bc)
	pbom = pull --rebase origin master
	pboc = !git pull --rebase origin $(git bc)
	###
	plu = pull upstream
	plum = pull upstream master
	pluc = !git pull upstream $(git bc)
	pbum = pull --rebase upstream master
	pbuc = !git pull --rebase upstream $(git bc)
	###
	rb = rebase
	rba = rebase --abort
	rbc = rebase --continue
	rbi = rebase --interactive
	rbs = rebase --skip
	###
	re = reset
	rh = reset HEAD
	reh = reset --hard
	rem = reset --mixed
	res = reset --soft
	rehh = reset --hard HEAD
	remh = reset --mixed HEAD
	resh = reset --soft HEAD
	rehom = reset --hard origin/master
	###
	r = remote
	ra = remote add
	rr = remote rm
	rv = remote -v
	rn = remote rename
	rp = remote prune
	rs = remote show
	rao = remote add origin
	rau = remote add upstream
	rro = remote remove origin
	rru = remote remove upstream
	rso = remote show origin
	rsu = remote show upstream
	rpo = remote prune origin
	rpu = remote prune upstream
	###
	rmf = rm -f
	rmrf = rm -r -f
	###
	s = status
	sb = status -s -b
	###
	sa = stash apply
	sc = stash clear
	sd = stash drop
	sl = stash list
	sp = stash pop
	ss = stash save
	ssk = stash save -k
	sw = stash show
	st = !git stash list | wc -l 2>/dev/null | grep -oEi '[0-9][0-9]*'
	###
	t = tag
	td = tag -d
	###
	w = show
	wp = show -p
	wr = show -p --no-color
	###
	svnr = svn rebase
	svnd = svn dcommit
	svnl = svn log --oneline --show-commit
```