---
id: intro-links
title: Ссылки
hide_title: true
description: Полезные и проверенные ссылки на ресурсы по изучению JavaScript, React, TypeScript, Node.js и др.
---

# Полезные и проверенные ссылки

## JavaScript

- :link:&nbsp;&nbsp; ["Современный учебник JavaScript". Илья Кантор](https://learn.javascript.ru/)
- :link:&nbsp;&nbsp; [MDN Web Docs](https://developer.mozilla.org/ru/)
- :link:&nbsp;&nbsp; ["Вы не знаете JS". Кайл Симпсон](https://github.com/azat-io/you-dont-know-js-ru)
- :link:&nbsp;&nbsp; ["JavaScript. Подробное руководство". Дэвид Флэнаган](./assets/definitive_guide.pdf)

__Паттерны проектирования__

- :link:&nbsp;&nbsp; ["Паттерны проектирования". Refactoring Guru](https://refactoring.guru/ru/design-patterns)
- :link:&nbsp;&nbsp; ["Learning JavaScript Design Patterns". Addy Osmani](https://addyosmani.com/resources/essentialjsdesignpatterns/book/)

__Алгоритмы и структуры данных__

- :link:&nbsp;&nbsp; [JavaScript Algorithms](https://github.com/trekhleb/javascript-algorithms)
- :link:&nbsp;&nbsp; [The Algorithms - JavaScript](https://github.com/TheAlgorithms/JavaScript)
- :link:&nbsp;&nbsp; ["Грокаем алгоритмы". Адитья Бхаргава](./assets/grokking_algorithms.pdf)

__Вопросы и задачи__

- :link:&nbsp;&nbsp; [JavaScript Interview Questions & Answers](https://github.com/sudheerj/javascript-interview-questions)
- :link:&nbsp;&nbsp; [Frontend Interview Handbook](https://github.com/yangshun/front-end-interview-handbook/)
- :link:&nbsp;&nbsp; [JavaScript Questions](https://github.com/lydiahallie/javascript-questions)
- :link:&nbsp;&nbsp; [In JavaScript We Trust](https://github.com/yeungon/In-JavaScript-we-trust)
- :link:&nbsp;&nbsp; [Coding Practice Challenges](https://edabit.com/challenges)

## React

- :link:&nbsp;&nbsp; [Awesome React Hooks](https://github.com/rehooks/awesome-react-hooks) - большая коллекция кастомных хуков
- :link:&nbsp;&nbsp; [Curated List of React Components & Libraries](https://github.com/brillout/awesome-react-components) - подборка компонентов и библиотек для `React`
- :link:&nbsp;&nbsp; [React и TypeScript](https://reactdev.ru/types/)

## TypeScript

- :link:&nbsp;&nbsp; [Рекомендуемый `tsconfig.json`](https://www.npmjs.com/package/@tsconfig/recommended)
- :link:&nbsp;&nbsp; [Type Challenges](https://github.com/type-challenges/type-challenges) - изучение `TypeScript` на практике

## Node.js

- :link:&nbsp;&nbsp; [Документация Node.js с примерами](https://nodejsdev.ru/doc/)
- :link:&nbsp;&nbsp; [Node.js: лучшие практики](https://github.com/goldbergyoni/nodebestpractices/blob/master/README.russian.md)
- :link:&nbsp;&nbsp; [Insomnia](https://insomnia.rest/download) - сервис для тестирования `API`
- :link:&nbsp;&nbsp; [Mailtrap](https://mailtrap.io/) - сервис для тестирования отправки электронных писем

## Git

- :link:&nbsp;&nbsp; [GitHowTo](https://githowto.com/ru) - интерактивный курс по основам работы с `Git`
- :link:&nbsp;&nbsp; [GitZip](http://kinolien.github.io/gitzip/) - инструмент для скачивания определенной части репозитория по `URL`

## Другое

- :link:&nbsp;&nbsp; [Developer Roadmap](https://github.com/kamranahmedse/developer-roadmap) - "дорожная карта" веб-разработчика
- :link:&nbsp;&nbsp; [The Art of Command Line](https://github.com/jlevy/the-art-of-command-line) - искусство командной строки
- :link:&nbsp;&nbsp; [Bash Guide](https://github.com/Idnan/bash-guide) - краткое руководство/шпаргалка по `Bash`
- :link:&nbsp;&nbsp; [Mockaroo](https://www.mockaroo.com/) - сервис для генерации фиктивных данных, в том числе, в формате `SQL`
- :link:&nbsp;&nbsp; [Команды SQL (PostgreSQL)](https://postgrespro.ru/docs/postgresql/13/sql-commands)
- :link:&nbsp;&nbsp; [Команды psql (PostgreSQL)](https://postgrespro.ru/docs/postgresql/13/app-psql)
- :link:&nbsp;&nbsp; [Google Fonts](https://fonts.google.com/)
- :link:&nbsp;&nbsp; [FlatIcon](https://www.flaticon.com/)
- :link:&nbsp;&nbsp; [Настройки `Prettier`](https://prettier.io/docs/en/options.html)
- :link:&nbsp;&nbsp; [Список правил `ESLint`](https://eslint.org/docs/rules/)
- :link:&nbsp;&nbsp; [System Design (на английском)](./assets/system_design.pdf)