---
sidebar_position: 34
title: Вопросы по DevOps. Часть 1
description: Вопросы по DevOps. Часть 1
keywords: [devops, system, design, architecture, система, дизайн, архитектура]
tags: [devops, system, design, architecture, система, дизайн, архитектура]
---

> [Источник](https://github.com/bregman-arie/devops-exercises).

В первой части шпаргалки (вопросника, если угодно) на высоком уровне рассматриваются такие вещи, как сеть, HTTP, операционная система, виртуализация, хранилище etc., а также несколько технологий, используемых в сфере DevOps, таких как Prometheus, OpenStack, Puppet, Elastic etc. (вопросы с ответами из основного репозитория оригинала). Полагаю, шпаргалка будет интересна всем, кто связан с разработкой программного обеспечения, прежде всего, с разработкой веб-приложений.

<!-- truncate -->

- [Сеть](#сеть)
- [HTTP](#http)
- [Операционная система](#операционная-система)
- [Виртуализация](#виртуализация)
- [Хранилище](#хранилище)
- [Распределенные системы](#распределенные-системы)
- [Системный дизайн](#системный-дизайн)
- [Аппаратное обеспечение](#аппаратное-обеспечение)
- [Большие данные](#большие-данные)
- [Разное](#разное)
- [Go](#go)
- [SQL](#sql)
- [MongoDB](#mongodb)
- [Prometheus](#prometheus)
- [OpenStack](#openstack)
- [Puppet](#puppet)
- [Elastic](#elastic)
- [Packer](#packer)

## Сеть

### Что необходимо для взаимодействия по сети?

- общий язык (который понимают обе стороны)
- способ определения получателей
- соединение/подключение (средство доставки контента получателям)

### Что такое TCP/IP?

TCP/IP - это набор протоколов, определяющих как два и более устройства могут взаимодействовать между собой.

Подробнее о TCP/IP можно почитать [здесь](https://www.penguintutor.com/linux/basic-network-reference).

### Что такое Ethernet?

Ethernet - это самый популярный на сегодняшний день тип локальной сети (Local Area Network, LAN). LAN является противоположностью WAN (Wide Area Network - глобальная сеть) и представляет собой единую сеть компьютеров на небольшой площади, такой как офис, кампус или даже ваше жилище.

### Что такое MAC-адрес? Для чего он используется?

MAC-адрес - это уникальный номер идентификации или код, который используется для определения устройства в сети.

Пакеты данных, передаваемые по сети, всегда приходят из MAC-адреса и отправляются в MAC-адрес. При получении пакета сетевым адаптером, он сравнивает MAC-адрес назначения пакета с собственным MAC-адресом.

### Когда используется MAC-адрес FF:FF:FF:FF:FF:FF​?

Когда устройство отправляет пакет данных широковещательному (broadcast) MAC-адресу (FF:FF:FF:FF:FF:FF), пакет доставляется всем станциям в локальной сети. Широковещательные передачи Ethernet используются для преобразования IP-адресов в MAC-адреса (по ARP) на уровне канала передачи данных.

### Что такое IP-адрес?

IP-адрес (Internet Protocol - Интернет-протокол) — это числовая метка, присваиваемая каждому устройству, подключенному к сети, которое использует Интернет-протокол для связи. IP-адрес выполняет две основные функции: идентификацию хоста или сетевого интерфейса и адресацию местоположения.

### Что такое маска подсети?

Маска подсети (Subnet Mask) — это 32-битное число, которое маскирует IP-адрес и делит IP-адреса на сетевые адреса и адреса хостов. Маска подсети создается путем установки всех битов сети в "1" и всех битов хоста в "0". В каждой сети из общего количества используемых адресов хостов два всегда зарезервированы для определенных целей и не могут быть выделены ни одному хосту. Это первый адрес, который зарезервирован как сетевой адрес (он же идентификатор сети), и последний адрес, используемый для сетевой широковещательной передачи.

### Что такое приватный/частный IP-адрес? Для чего такие адреса используются?

Частные IP-адреса назначаются узлам в одной сети для связи друг с другом. Как следует из названия, устройства, которым назначены частные IP-адреса, недоступны устройствам из внешней сети. Например, если я живу в общежитии и хочу, чтобы мои друзья подключились к моему игровому серверу, я попрошу их подключаться через частный IP-адрес моего сервера, поскольку сеть является локальной для общежития.

### Что такое публичный/открытый IP-адрес? Для чего такие адреса используются?

Публичный IP-адрес — это общедоступный IP-адрес. Если мы хотим, чтобы наши друзья подключились к нашему игровому серверу, мы даем им общедоступный IP-адрес, чтобы их компьютеры могли идентифицировать и определить местонахождение нашей сети и сервера для установки соединения. Однако для этого, как правило, используются частные IP-адреса. Для обеспечения возможности подключения к нашему внутреннему серверу, нам необходимо настроить переадресацию порта (port forward), чтобы указать маршрутизатору пропускать трафик из общедоступного домена в нашу сеть, и наоборот.

### Что такое модель OSI? Из каких уровней/слоев она состоит? За что отвечает каждый уровень?

Модель OSI (The Open Systems Interconnection Model - модель взаимодействия открытых систем) состоит из следующих уровней:

- уровень приложения (Application) - пользователь (HTTP)
- уровень представления (Presentation) - установка контекста между сущностями уровня приложения (шифрование)
- уровень сессии (Session) - установка, управление и завершение подключений
- транспортный уровень (Transport) - передача последовательности данных переменной длины от источника к хосту назначения (TCP, UDP)
- сетевой уровень (Network) - передача датаграмм (datagrams) из одной сети в другую (IP)
- уровень канала передачи данных (data link) - предоставляет связь между двумя подключенными напрямую узлами (MAC)
- физический уровень (Physical) - электрические и физические характеристики подключения (биты)

Подробнее о модели OSI можно почитать [здесь](http://www.penguintutor.com/linux/basic-network-reference).

### Сопоставление кейсов и уровней OSI

- Исправление ошибок – уровень канала передачи данных
- маршрутизация пакетов - сетевой уровень
- кабели и электрические сигналы - физический уровень
- MAC-адрес - уровень канала передачи данных
- IP-адрес - сетевой уровень
- завершение соединения - уровень сессии
- трехстороннее рукопожатие - транспортный уровень

### Какие вы знаете схемы доставки данных?

Одноадресная рассылка (unicast) - связь "один-к-одному", один отправитель и один получатель.

Широковещательная рассылка (broadcast) - сообщение отправляется всем, кто подключен к сети. Для трансляции используется адрес ff:ff:ff:ff:ff:ff. Двумя распространенными протоколами, использующими широковещательную рассылку, являются ARP и DHCP.

Многоадресная рассылка (multicast) - сообщение отправляется группе подписчиков, связь "один-ко-многим" или "многие-ко-многим".

### Что такое CSMA/CD?

CSMA/CD означает Carrier Sense Multiple Access / Collision Detection (контролируемый множественный доступ / обнаружение конфликтов). Его основной целью является управление доступом к общей среде/шине (bus), где только один хост может передавать данные в определенный момент времени.

Алгоритм CSMA/CD:

1. Перед отправкой кадра (frame) проверяется, не отправляет ли кадр другой хост.
2. Если нет, начинается передача кадра.
3. Если два хоста передают данные одновременно, возникает коллизия.
4. Оба хоста прекращают отправку кадра и отправляют всем "jam signal" (сигнал о застревании/заклинивании) - уведомление о конфликте.
5. Хосты ждут случайное время, затем снова пытаются отправить кадр.
6. Цикл повторяется.

### В чем разница между маршрутизатором, коммутатором и концентратором?

Маршрутизатор (router), коммутатор (switch) и концентратор (hub) — это сетевые устройства, используемые для подключения устройств в локальной сети (Local Area Network, LAN). Однако каждое устройство работает по-разному и имеет конкретные варианты использования. Вот краткое описание каждого устройства и различий между ними:

1. Маршрутизатор - это сетевое устройство, которое объединяет в единое целое несколько сегментов сети. Он работает на сетевом уровне (уровень 3) модели OSI и использует протоколы маршрутизации для направления данных между сетями. Маршрутизаторы используют IP-адреса для идентификации устройств и маршрутизации пакетов данных в правильный пункт назначения.
2. Коммутатор - сетевое устройство, которое соединяет несколько устройств в локальной сети. Он работает на уровне канала передачи данных (уровень 2) модели OSI и использует MAC-адреса для идентификации устройств и направления пакетов данных в правильный пункт назначения. Коммутаторы позволяют устройствам в одной сети более эффективно взаимодействовать друг с другом и предотвращают конфликты данных, которые могут возникнуть, когда несколько устройств отправляют данные одновременно.
3. Концентратор - сетевое устройство, которое соединяет несколько устройств с помощью одного кабеля и используется для подключения нескольких устройств без сегментирования сети. Однако, в отличие от коммутатора, он работает на физическом уровне (уровень 1) модели OSI и просто передает пакеты данных всем подключенным к нему устройствам, независимо от того, является устройство получателем данных или нет. Это означает, что могут возникнуть конфликты данных, и, как следствие, может пострадать эффективность сети. Концентраторы обычно не используются в современных сетях, поскольку коммутаторы более эффективны и обеспечивают лучшую производительность.

### Что такое "домен коллизий"?

Домен коллизий (collision domain) - это сегмент сети, в котором устройства потенциально могут мешать друг другу, пытаясь передавать данные одновременно. Это может вызывать конфликты, приводящие к потере или повреждению данных. В домене коллизий все устройства используют один и тот же канал передачи данных, и любое устройство потенциально может мешать передаче данных другими устройствами.

### Что такое широковещательный домен?

Широковещательный домен (broadcast domain) - это сегмент сети, в котором все устройства могут взаимодействовать друг с другом посредством отправки широковещательных сообщений (broadcast messages). Широковещательное сообщение - это сообщение, которое отправляется всем устройствам, подключенным к сети. В широковещательном домене все устройства могут получать и обрабатывать любые сообщения, независимо от получателя.

### Три компьютера подключены к коммутатору. Сколько в данном случае существует доменов коллизий? А широковещательных доменов?

Три домена коллизий и один широковещательный домен.

### Как работает маршрутизатор?

Маршрутизатор — это физическое или виртуальное устройство, которое передает информацию между двумя или более компьютерными сетями с коммутацией пакетов (packet-switched computer networks). Маршрутизатор проверяет IP-адрес пункта назначения данного пакета данных, вычисляет лучший способ его достижения, а затем пересылает его соответствующим образом.

### Что такое NAT?

NAT (Network Address Translation - трансляция сетевых адресов) - это процесс, в котором один или несколько локальных IP-адресов преобразуются в один или несколько глобальных IP-адресов, и наоборот, чтобы обеспечить доступ в Интернет локальным хостам. Это способ сопоставления нескольких локальных частных адресов с общедоступным адресом перед передачей информации. Организации, которые хотят, чтобы несколько устройств использовали один IP-адрес, используют NAT, как и большинство домашних маршрутизаторов. Например, частный IP-адрес нашего компьютера - 192.168.1.100, но наш маршрутизатор сопоставляет трафик со своим общедоступным IP-адресом (например, 1.1.1.1). Любое устройство в Интернете будет видеть трафик, исходящий с общедоступного IP-адреса (1.1.1.1), а не с нашего частного IP-адреса (192.168.1.100).

### Что такое прокси? Как он работает? Для чего он нужен?

Прокси-сервер (proxy server) действует как шлюз (gateway) между нами и Интернетом. Это промежуточный сервер, отделяющий конечных пользователей от веб-сайтов, которые они просматривают.

При использовании прокси-сервера, интернет-трафик проходит через него на пути к запрошенному адресу. Запрос возвращается также через прокси-сервер (из этого правила могут быть исключения), а затем прокси-сервер пересылает данные нам.

Прокси-серверы обеспечивают различные уровни функциональности, безопасности и конфиденциальности в зависимости от варианта использования, потребностей или политики компании.

### Что такое TCP? Как он работает? Что такое трехстороннее рукопожатие?

Трехстороннее рукопожатие (three-way handshake) TCP — это процесс, который используется в сети TCP/IP для установления соединения между сервером и клиентом.

Трехстороннее рукопожатие в основном используется для создания соединения через сокет TCP. Это работает следующим образом:

- клиентский узел отправляет пакет данных SYN по IP-сети на сервер, находящийся в той же или внешней сети
- целевой сервер должен иметь открытые порты, которые могут принимать и создавать новые соединения. Сервер отвечает на SYN клиента подтверждением  — пакетом ACK или SYN/ACK
- клиент получает SYN/ACK от сервера и отвечает пакетом ACK

### Что такое задержка туда и обратно или время туда и обратно?

Задержка или время туда и обратно (round-trip delay/time, RTT) - это, согласно [Википедии](https://en.wikipedia.org/wiki/Round-trip_delay), время, необходимое для отправки сигнала, плюс время, необходимое для получения подтверждения о доставке этого сигнала.

### Как работает рукопожатие SSL?

Рукопожатие SSL (SSL-квитирование - SSL handshake) — это процесс, позволяющий устанавливать безопасное соединение между клиентом и сервером:

1. Клиент отправляет на сервер сообщение "Client Hello", включающее клиентскую версию протокола SSL/TLS, список криптографических алгоритмов, поддерживаемых клиентом, и случайное значение.
2. Сервер отвечает сообщением "Server Hello", которое включает версию протокола SSL/TLS сервера, случайное значение и идентификатор сеанса.
3. Сервер отправляет сертификат (сообщение "Certificate").
4. Сервер отправляет сообщение "Server Hello Done", которое указывает, что сервер завершил отправку сообщений для фазы приветствия.
5. Клиент отправляет сообщение "Client Key Exchange", содержащее открытый ключ клиента.
6. Клиент отправляет сообщение "Change Cipher Spec", которое уведомляет сервер о том, что клиент собирается отправить сообщение, зашифрованное с помощью новой спецификации шифрования.
7. Клиент отправляет сообщение "Encrypted Handshake", которое содержит предварительный секрет (pre-master secret), зашифрованный открытым ключом сервера.
8. Сервер отправляет сообщение "Change Cipher Spec", которое уведомляет клиента о том, что сервер собирается отправить сообщение, зашифрованное с помощью новой спецификации шифрования.
9. Сервер отправляет сообщение "Encrypted Handshake", которое содержит предварительный секрет, зашифрованный открытым ключом клиента.
10. Клиент и сервер теперь могут безопасно обмениваться данными.

### В чем разница между TCP и UDP?

TCP устанавливает соединение между клиентом и сервером, чтобы гарантировать порядок доставки пакетов данных, UDP не устанавливает соединение между клиентом и сервером и не гарантирует порядок доставки пакетов. Это делает UDP более легким, чем TCP, и отличным кандидатом для таких сервисов, как платформы потоковой передачи данных (streaming).

### Что такое "шлюз по умолчанию"?

Шлюз по умолчанию (default gateway) служит точкой доступа или IP-маршрутизатором, который сетевой компьютер использует для отправки информации на компьютер в другой сети или в Интернете.

### Что такое ARP?

ARP означает Address Resolution Protocol (протокол разрешения адресов). Когда мы пытаемся проверить IP-адрес в локальной сети, скажем, 192.168.1.1, наша система должна преобразовать его в MAC-адрес. Это предполагает использование ARP (отсюда и название).

Системы хранят справочную таблицу ARP, в которой хранятся связи IP-адресов с MAC-адресами. При отправке пакета на IP-адрес система сначала сверяется с этой таблицей. Если значение кэшировано, ARP не используется.

### Что такое TTL? Для чего он используется?

- TTL (Time to Live - время жизни/действия) — это значение, содержащееся в пакете IP, определяющее, сколько переходов или перенаправлений может совершить пакет, прежде чем он будет отброшен (discarded). При каждой пересылке пакета маршрутизатором, значение TTL уменьшается на единицу. Когда значение TTL достигает нуля, пакет отбрасывается, и отправитель получает сообщение ICMP (Internet Control Message Protocol - протокол управляющих сообщений Интернета), указывающее, что срок действия пакета истек
- TTL используется для предотвращения бесконечного обращения пакетов в сети, что может вызвать перегрузку и снизить производительность сети
- TTL также помогает предотвратить попадание пакетов в петли маршрутизации (routing loops), когда пакеты постоянно перемещаются между одним и тем же набором маршрутизаторов, не достигая пункта назначения
- кроме того, TTL может использоваться для обнаружения и предотвращения атак с подменой IP-адреса (IP spoofing attacks), когда злоумышленник пытается выдать себя за другое устройство в сети, используя ложный или поддельный IP-адрес

### Что такое DHCP? Для чего он используется?

DHCP означает Dynamic Host Configuration Protocol (протокол динамического конфигурирования сервера). Он выделяет хостам IP-адреса, маски подсети и шлюзы. DHCP работает следующим образом:

- при входе в сеть хост транслирует сообщение в поисках DHCP-сервера (DHCP DISCOVER)
- при получении сообщения от хоста DHCP-сервер отправляет в ответ сообщение с предложением (offer message) в виде пакета, содержащего время аренды (lease time), маску подсети, IP-адреса и т.п. (DHCP OFFER)
- клиент отправляет всем DHCP-серверам широковещательное сообщение о принятии им конкретного предложения (DHCP REQUEST)
- сервер отправляет подтверждение (DHCP ACK)

Подробнее о DHCP можно почитать [здесь](https://linuxjourney.com/lesson/dhcp-overview).

### Может ли в одной сети существовать два DHCP-сервера?

В одной сети может быть два DHCP-сервера, однако это не рекомендуется, и важно тщательно их настраивать, чтобы предотвратить конфликты и проблемы с настройкой устройств.

- Если два DHCP-сервера настроены в одной сети, существует риск того, что оба сервера назначат IP-адреса и другие параметры конфигурации сети одному и тому же устройству, что может вызвать конфликты и проблемы с подключением. Кроме того, если DHCP-серверы имеют разные сетевые параметры или настройки, устройства в сети могут получать конфликтующие или несогласованные параметры конфигурации
- однако в некоторых случаях может потребоваться наличие двух DHCP-серверов в одной сети, например, в больших сетях, где один DHCP-сервер может не справляться с обработкой всех запросов. В таких случаях DHCP-серверы можно настроить для обслуживания разных диапазонов IP-адресов или разных подсетей, чтобы они не мешали друг другу

### Что такое туннелирование SSL? Как оно работает?

Туннелирование SSL - это метод, который используется для установления безопасного зашифрованного соединения между двумя конечными точками через незащищенную сеть, такую как Интернет. Туннель SSL создается путем инкапсуляции трафика внутри соединения SSL, что обеспечивает конфиденциальность, целостность и аутентификацию.

Это работает следующим образом:

1. Клиент инициирует SSL-соединение с сервером, что включает процесс рукопожатия (handshake) для установления SSL-сессии.
2. После установки сеанса SSL клиент и сервер согласовывают параметры шифрования, такие как алгоритм шифрования и длину ключа, а затем обмениваются цифровыми сертификатами для аутентификации друг друга.
3. Затем клиент отправляет трафик через туннель SSL на сервер, который расшифровывает трафик и перенаправляет его по назначению.
4. Сервер отправляет трафик через туннель SSL обратно клиенту, который расшифровывает трафик и пересылает его приложению.

### Что такое сокет? Как получить список сокетов?

Сокет (socket) - это программная конечная точка, обеспечивающая двустороннюю связь между процессами по сети. Сокеты предоставляют стандартизированный интерфейс для сетевого взаимодействия, позволяя приложениям отправлять и получать данные по сети. Чтобы просмотреть список открытых сокетов в системе Linux, необходимо выполнить команду `netstat -an`. Эта команда отображает список всех открытых сокетов, а также их протокол, локальный адрес, внешний адрес и состояние.

### Что такое IPv6? Зачем он нужен, если есть IPv4?

IPv6 (Internet Protocol version 6 - Интернет-протокол версии 6) - это последняя версия Интернет-протокола (IP), которая используется для идентификации устройств в сети и связи с ними. Адреса IPv6 представляют собой 128-битные адреса и выражаются в шестнадцатеричном формате, например 2001:0db8:85a3:0000:0000:8a2e:0370:7334.

IPv6 имеет несколько преимуществ по сравнению с IPv4:

1. Адресное пространство (максимальное количество возможных адресов). IPv4 имеет ограниченное адресное пространство, которое во многих частях света уже исчерпано. IPv6 обеспечивает гораздо большее адресное пространство - триллионы уникальных IP-адресов.
2. Безопасность. IPv6 включает встроенную поддержку IPsec, которая обеспечивает сквозное шифрование и аутентификацию сетевого трафика.
3. Производительность. IPv6 включает функции для улучшения производительности сети, например многоадресную маршрутизацию (multicast routing), которая позволяет отправлять один пакет нескольким адресатам одновременно.
4. Упрощенная конфигурация сети. IPv6 включает функции для упрощения настройки сети, например автоконфигурацию без отслеживания состояния (stateless autoconfiguration), которая позволяет устройствам автоматически настраивать свои адреса IPv6 без необходимости использования DHCP-сервера.
5. Лучшая поддержка мобильности. IPv6 включает функции для улучшения поддержки мобильности, например Mobile IPv6, который позволяет устройствам сохранять свои адреса IPv6 при перемещении между различными сетями.

### Что такое VLAN?

VLAN (Virtual Local Area Network - виртуальная локальная сеть) - это логическая сеть, которая группирует набор устройств в физической сети независимо от их физического местоположения. Такие сети создаются путем настройки сетевых коммутаторов для назначения определенного идентификатора VLAN кадрам (frames), отправляемым устройствами, подключенным к определенному порту или группе портов коммутатора.

### Что такое MTU?

MTU означает Maximum Transmission Unit (максимальная единица передачи). Это размер наибольшего PDU (Protocol Data Unit - блока данных протокола), который может быть отправлен за одну транзакцию.

### Что случится при отправке пакета, превышающего MTU?

С помощью протокола IPv4 маршрутизатор может фрагментировать PDU, а затем отправить все фрагментированные PDU посредством транзакции.

При использовании протокола IPv6 на компьютере пользователя возникнет ошибка.

### Ping использует UDP, потому что надежность соединения для него не имеет значения: правда или ложь?

Ложь. Ping на самом деле использует ICMP (Internet Control Message Protocol - протокол управляющих сообщений Интернета), который представляет собой сетевой протокол, используемый для отправки диагностических и управляющих сообщений.

### Что такое SDN?

SDN означает Software Defined Networking (программно-определяемая сеть). Это подход к управлению сетью, который подчеркивает централизацию управления, позволяя администраторам управлять поведением сети с помощью программной абстракции.

В традиционных сетях сетевые устройства, такие как маршрутизаторы, коммутаторы и межсетевые экраны (firewalls), настраиваются и управляются индивидуально с использованием специализированного программного обеспечения или интерфейсов командной строки. SDN, напротив, отделяет плоскость управления сетью от плоскости данных, позволяя администраторам управлять поведением сети через централизованный программный контроллер.

### Что такое ICMP? Для чего он используется?

ICMP расшифровывается как Internet Control Message Protocol (протокол управляющих сообщений Интернета). Он используется для целей диагностики и управления IP-сетями. Это часть набора интернет-протоколов, работающая на сетевом уровне.

Сообщения ICMP используются для разных целей, в том числе:

1. Отчеты об ошибках. Сообщения ICMP используются для сообщений об ошибках, возникающих в сети, например о пакетах, которые не удалось доставить по назначению.
2. Ping. ICMP используется для отправки ping-сообщений для проверки доступности хоста или сети и для измерения времени прохождения пакетов туда и обратно (round-trip time).
3. Исследование MTU пути (path). ICMP используется для обнаружения MTU (Maximum Transmission Unit - максимальной единицы передачи) пути, который представляет собой наибольший размер пакета, который может быть передан без фрагментации.
4. Трассировка пути. ICMP используется утилитой трассировки для отслеживания пути, по которому пакеты проходят через сеть.
5. Обнаружение маршрутизатора. ICMP используется для обнаружения маршрутизаторов в сети.

### Какие номера портов используются протоколами SSH, SMTP, HTTP, DNS, HTTPS, FTP, SFTP?

- SSH - 22
- SMTP - 25
- HTTP - 80
- DNS - 53
- HTTPS - 443
- FTP - 21
- SFTP - 22

### Какие факторы влияют на производительность сети?

На производительность сети могут влиять такие факторы, как:

1. Пропускная способность (Bandwidth). Доступная пропускная способность сетевого подключения может существенно повлиять на его производительность. Сети с ограниченной пропускной способностью могут иметь низкую скорость передачи данных, большие задержки и плохую отзывчивость.
2. Задержка (Latency). Речь о задержке, которая возникает при передаче данных из одной точки сети в другую. Высокая задержка может привести к снижению производительности сети, особенно для приложений реального времени, таких как видеоконференции и онлайн-игры.
3. Перегрузка сети (Network Congestion). Когда слишком много устройств одновременно используют сеть, может возникнуть перегрузка сети, приводящая к снижению скорости передачи данных и общей производительности сети.
4. Потеря пакетов данных (Packet Loss). Иногда пакеты данных теряются во время передачи. Это может привести к снижению скорости передачи данных и общей производительности сети.
5. Топология сети (Network Topology). На производительность сети может влиять физическая схема сети - размещение коммутаторов, маршрутизаторов и других сетевых устройств.
6. Сетевой протокол. Разные сетевые протоколы имеют разные характеристики производительности. Например, TCP - это надежный протокол, гарантирующий доставку пакетов данных и их порядок, но дополнительные расходы, необходимые для проверки ошибок и повторной передачи данных, могут привести к снижению производительности сети.
7. Сетевая безопасность. Меры безопасности, такие как межсетевые экраны (firewalls) и шифрование, могут повлиять на производительность сети, особенно если они требуют значительной вычислительной мощности или приводят к дополнительной задержке.
8. Расстояние. Физическое расстояние между устройствами в сети может влиять на ее производительность, особенно для беспроводных сетей, где уровень сигнала и помехи могут влиять на скорость подключения и передачи данных.

### Что такое APIPA?

APIPA - это набор IP-адресов, которые назначаются устройствам, когда основной DHCP-сервер недоступен.

### Какой диапазон IP-адресов используется APIPA?

APIPA использует диапазон IP-адресов 169.254.0.1-169.254.255.254.

### Что такое "плоскость управления"?

Плоскость управления (control plane) - это часть сети, которая решает, как маршрутизировать и пересылать пакеты в другое место.

### Что такое "плоскость данных"?

Плоскость данных (data plane) - это часть сети, которая фактически пересылает данные/пакеты.

### К какой плоскости относится создание таблиц маршрутизации?

К плоскости управления.

### Что такое OSPF?

OSPF (Open Shortest Path First - сначала открываем кратчайший путь) - это протокол маршрутизации, который может быть реализован на маршрутизаторах разных типов. В целом, OSPF поддерживается большинством современных маршрутизаторов, в том числе таких производителей, как Cisco, Juniper и Huawei. Протокол предназначен для работы с сетями на базе IP, включая IPv4 и IPv6. Кроме того, он использует иерархическую структуру сети, в которой маршрутизаторы сгруппированы в области (areas), причем каждая область имеет свою собственную карту топологии и таблицу маршрутизации. Такая конструкция помогает уменьшить объем информации для обмена между маршрутизаторами и улучшить масштабируемость сети.

### Что такое задержка?

Задержка (latency) - это время, необходимое для передачи информации от отправителя к получателю.

### Что такое пропускная способность?

Пропускная способность (bandwidth) - это объем данных, который сеть может передать за определенный период времени. Чем выше пропускная способность сети, тем больше данных она может обработать за один и тот же временной интервал.

### Что важнее при выполнении поискового запроса: задержка или пропускная способность?

Задержка (latency). Для обеспечения минимальной задержки поисковый запрос должен перенаправляться в ближайший центр обработки данных.

### Что важнее при загрузке видео: задержка или пропускная способность?

Пропускная способность (bandwidth). Чтобы обеспечить хорошую пропускную способность, поток загрузки должен быть перенаправлен на малоиспользуемый канал (underutilized link).

### Какие еще соображения (кроме задержки и пропускной способности) необходимо учитывать при перенаправлении запросов?

Постоянное обновление кэша (для получения данных не нужно обращаться к базе или другому хранилищу данных).

### Что такое перегрузка сети? Что может ее вызывать?

Перегрузка сети (network congestion) возникает, когда в сети имеется слишком много данных для передачи, и у нее недостаточно возможностей для обработки запросов. Это может привести к увеличению задержки и потере пакетов. Причин может быть несколько, например, высокая загрузка сети, передача больших файлов, вредоносное ПО, проблемы с оборудованием или плохая архитектура сети. Для предотвращения перегрузки сети важно отслеживать ее использование и реализовывать стратегии по ограничению или управлению запросами.

### Приведите примеры протоколов уровня приложения

- HTTP (Hypertext Transfer Protocol - протокол передачи гипертекста) - используется веб-приложениями
- SMTP (Simple Mail Transfer Protocol - простой протокол передачи почты) - используется для передачи электронной почты
- TELNET (Telecommunications Network - телекоммуникационная сеть) - эмуляция терминала, позволяющая клиенту получить доступ к серверу Telnet
- FTP (File Transfer Protocol - протокол передачи файлов) - облегчает передачу файлов между компьютерами
- DNS (Domain Name System - система доменных имен) - преобразование доменных имен
- DHCP (Dynamic Host Configuration Protocol - протокол динамической конфигурации хоста) - назначает хостам IP-адреса, маски подсети и шлюзы
- SNMP (Simple Network Management Protocol - простой протокол управления сетью) - собирает данные об устройствах в сети

### Приведите примеры протоколов сетевого уровня

- IP (Internet Protocol - Интернет-протокол) - используется для передачи пакетов с одного компьютера на другой
- ICMP (Internet Control Message Protocol - протокол управляющих сообщений Интернета) - используется для получения сообщений об ошибках и отладочной информации

### Что такое HSTS?

HSTS (HTTP Strict Transport Security - строгая транспортная безопасность) - это директива веб-сервера, которая сообщает пользовательским агентам и веб-браузерам, как необходимо обрабатывать соединение, через заголовок ответа, отправляемый в самом начале. Это приводит к принудительному подключению через шифрование HTTPS, любое обращение к ресурсу по HTTP игнорируется.

Подробнее о HSTS можно почитать [здесь](https://www.globalsign.com/en/blog/what-is-hsts-and-how-do-i-use-it).

### Что такое Интернет? Это то же самое, что и Всемирная паутина?

Интернет - это сеть сетей, передающая огромные объемы данных по всему миру.

Всемирная паутина (World Wide Web, WWW) - это приложение, работающее на миллионах серверов поверх Интернета, доступ к которому осуществляется через так называемые пользовательские агенты - веб-браузеры.

### Что такое ISP?

ISP (Internet Service Provider - Интернет-провайдер) - это местная компания-провайдер Интернета.

## HTTP

### Что такое HTTP?

HTTP означает Hypertext Transfer Protocol (протокол передачи гипертекста). HTTP использует TCP-порт 80 для подключения к Интернету. Это часть прикладного уровня (application level, L7) модели OSI.

### Опишите жизненный цикл запроса HTTP

- получение IP-адреса по названию хоста с помощью сервера DNS
- клиентский SYN
- серверный SYN+ACK
- клиентский SYN
- HTTP-запрос
- HTTP-ответ

### HTTP обладает состоянием (stateful): правда или ложь?

Ложь. HTTP не хранит состояние входящих запросов.

### Как выглядит запрос HTTP?

Запрос HTTP состоит из:

- типа запроса (type)
- заголовков запроса (headers) - размер (длина) содержимого, кодировка и др.
- тела запроса (body) (содержится не во всех запросах)

### Какие существуют методы HTTP?

- GET
- POST
- PUT
- DELETE
- OPTIONS
- HEAD
- CONNECT
- TRACE

### Какие существуют коды/статусы ответа HTTP?

- 1xx - информационные
- 2xx - коды успеха
- 3xx - коды перенаправления
- 4xx - коды клиентских ошибок
- 5xx - коды серверных ошибок

### Что такое HTTPS?

HTTPS - это безопасная версия протокола HTTP, используемая для передачи данных между веб-браузером и веб-сервером. Он шифрует связь с использованием SSL/TLS, чтобы гарантировать конфиденциальность и безопасность данных.

Подробнее о HTTPS можно почитать [здесь](https://www.cloudflare.com/learning/ssl/why-is-http-not-secure/).

### Мы получили ошибку "504 Gateway Timeout". Что это значит?

Сервер не получил своевременно ответ от другого сервера, с которым он взаимодействует.

### Что такое прокси?

Прокси (proxy) - это сервер, который действует как посредник между клиентским устройством и целевым сервером. Он может использоваться для улучшения конфиденциальности, безопасности и производительности за счет скрытия IP-адреса клиента, фильтрации контента и кэширования часто используемых данных.

Прокси-серверы можно использовать для балансировки нагрузки, распределения трафика между несколькими серверами, чтобы предотвратить перегрузку сервера и повысить производительность веб-сайта или приложения. Их также можно использовать для анализа данных, поскольку они могут регистрировать запросы и трафик, предоставляя полезную информацию о поведении и предпочтениях пользователей.

### Что такое обратный прокси?

Обратный прокси (reverse proxy) - это тип прокси-сервера, который находится между клиентом и сервером, но используется для управления трафиком, идущим в направлении, противоположном традиционному прямому прокси (forward proxy). В прямом прокси клиент отправляет запросы на прокси-сервер, который передает их на целевой сервер. В обратном прокси клиент отправляет запросы на целевой сервер, но они перехватываются обратным прокси-сервером до того, как достигнут целевого сервера.

Обратные прокси обычно используются для повышения производительности веб-сервера, обеспечения высокой доступности и отказоустойчивости, а также повышения безопасности за счет предотвращения прямого доступа к внутренним сервисам. Они часто используются в крупномасштабных веб-приложениях и веб-сайтах с высоким трафиком для управления и распределения запросов на несколько серверов, что приводит к повышению масштабируемости и надежности.

### Что такое "X-Forwarded-For"?

Поле HTTP-заголовка "X-Forwarded-For" (XFF) - это распространенный метод определения исходного IP-адреса клиента, подключающегося к веб-серверу через HTTP-прокси или балансировщик нагрузки.

### Что такое балансировщик нагрузки?

Балансировщик нагрузки (load balancer) принимает (или отклоняет) входящий сетевой трафик от клиента и на основе некоторых критериев (связанных с приложением, сетью и т.п.) распределяет эти запросы между серверами (по крайней мере, одним).

### Зачем используются балансировщики нагрузки?

- Масштабируемость - балансировщик нагрузки позволяет добавить несколько серверов в серверную часть приложения для обработки большего количества запросов/трафика от клиентов
- Резервирование - если один сервер в серверной части приложения выйдет из строя, балансировщик нагрузки продолжит перенаправлять трафик/запросы на другой сервер, поэтому пользователи даже не заметят, что один из серверов вышел из строя

### Какие методы/алгоритмы балансировки нагрузки вы знаете?

- Циклический - Round Robin
- взвешенный циклический - Weighted Round Robin
- минимальное количество подключений - Least Connection
- взвешенный вариант предыдущего - Weighted Least Connection
- основанный на ресурсах - Resource Based
- фиксированная взвешенность - Fixed Weighting
- взвешенное время ответа - Weighted Response Time
- хэш источника IP - Source IP Hash
- хэш URL - URL Hash

### Каковы недостатки алгоритма циклического перебора при балансировке нагрузки?

Простой циклический алгоритм ничего не знает о нагрузке и характеристиках каждого сервера, на который он пересылает запросы. Вполне возможно, что несколько тяжелых запросов (с большой полезной нагрузкой) попадут на один и тот же сервер, в то время как другие серверы получат только легкие запросы, что приведет к тому, что один сервер будет выполнять большую часть работы, возможно, даже в какой-то момент выйдет из строя, поскольку не сможет справиться со всеми тяжелыми запросами самостоятельно.

Каждый запрос от клиента создает совершенно новую сессию. Это может стать проблемой в определенных сценариях, когда мы хотим выполнить несколько операций, предполагающих, что сервер знает о результатах предыдущих операций, то есть, по сути, владеет историей взаимодействия с клиентом. В таком сценарии при циклическом переборе первый запрос может попасть на сервер X, а второй запрос - на сервер Y и попросить продолжить обработку данных, которые были обработаны на сервере X.

### На каких уровнях может работать балансировщик нагрузки?

L4 и L7.

### Можем ли мы выполнить балансировку нагрузки без использования выделенного экземпляра балансировщика нагрузки?

Да, для балансировки нагрузки можно использовать DNS.

### Назовите хотя бы один случай использования липких сессий (sticky sessions)

Мы хотим убедиться, что пользователь не потеряет данные текущего сеанса.

### Что используется в липких сессиях для обеспечения "липкости"?

Cookie. Существуют файлы cookie на основе приложений (application based) и cookie на основе продолжительности (duration based).

### Что такое cookie на основе приложений?

- Создаются приложением и/или балансировщиком нагрузки
- обычно содержат пользовательские данные

### Что такое cookie на основе продолжительности?

- Создаются балансировщиком нагрузки
- по истечении продолжительности сессия уничтожается

### Назовите хотя бы один случай использования дренажа соединений

Дренаж соединений (connection draining) используется для обеспечения того, что классический балансировщик нагрузки перестает отправлять запросы вышедшим из строя экземплярам сервера, сохраняя при этом существующие соединения открытыми. Максимальное значение таймаута можно установить от 1 до 3600 секунд как на GCP, так и на AWS.

### Что вы знаете о "Creative Commons"?

Лицензия Creative Commons - это набор лицензий на авторские права, которые позволяют авторам делиться своей работой с общественностью, сохраняя при этом некоторый контроль над тем, как ее можно использовать. Лицензия была разработана как ответ на ограничительные стандарты традиционных законов об авторском праве, которые ограничивали доступ к творческим произведениям. Владельцы лицензии сами определяют условия, на которых их произведения могут передаваться, распространяться и использоваться другими. Существует шесть основных типов лицензий Creative Commons, каждый из которых имеет разные уровни ограничений и разрешений:

- Attribution (CC BY) - позволяет другим распространять, создавать ремиксы и дополнять произведение, даже в коммерческих целях, при условии, что они указывают автора оригинального произведения
- Attribution-ShareAlike (CC BY-SA) - позволяет другим создавать ремиксы и использовать произведение, даже в коммерческих целях, при условии, что они указывают автора и выпускают любые новые произведения под той же лицензией
- Attribution-NoDerivs (CC BY-ND) - позволяет другим распространять произведение, даже в коммерческих целях, с указанием автора, но делать ремиксы или изменять произведение каким-либо образом нельзя
- Attribution-NonCommercial (CC BY-NC) - позволяет другим создавать ремиксы и использовать произведение с указанием автора, но использовать произведение в коммерческих целях нельзя
- Attribution-NonCommercial-ShareAlike (CC BY-NC-SA) - позволяет другим создавать ремиксы и использовать произведение с указанием автора, но использовать произведение в коммерческих целях нельзя, и любые новые произведения должны выпускаться под той же лицензией
- Attribution-NonCommercial-NoDerivs (CC BY-NC-ND) - позволяет другим загружать и делиться произведением с указанием автора, но использовать произведение в коммерческих целях, создавать ремиксы или изменять его каким-либо образом нельзя

Лицензии Creative Commons способствуют творчеству, инновациям и сотрудничеству, а также уважают права авторов и поощряют ответственное использование творческих произведений.

Подробнее о Creative Commons можно почитать [здесь](https://creativecommons.org/licenses/).

### В чем разница между Copyleft и разрешительной лицензией?

В Copyleft любая производная работа должна выпускаться под той же лицензией, что и оригинал, тогда как в разрешительном лицензировании такого условия нет. GPL-3 - это пример лицензии с Copyleft, а BSD - пример разрешительной лицензии.

### Что быстрее оперативной памяти?

Кэш центрального процессора.

### Что такое утечка памяти?

Утечка памяти (memory leak) - это программная ошибка, которая возникает, когда программе не удается освободить память, которая больше не нужна, в результате чего программа со временем потребляет все больший объем памяти.

Утечки памяти могут привести к множеству проблем, включая сбои системы, снижение производительности и нестабильность системы.

## Операционная система

### Что такое операционная система?

ОС "отвечает за упрощение запуска программ (даже за возможность запускать несколько программ одновременно), разрешение программам совместно использовать память, разрешение программам взаимодействовать с устройствами и другие забавные вещи в этом роде" (из книги "Операционные системы. Три легких части").

### Что такое процесс?

Процесс (process) - это работающая программа. Программа - это одна или несколько инструкций. Программа (или процесс) выполняется операционной системой.

### Если бы вам пришлось разрабатывать API для процессов в операционной системе, как бы этот API выглядел?

Он бы поддерживал выполнение следующих операций:

- Create - создание новых процессов
- Delete - удаление/уничтожение процессов
- State - проверка состояния процесса (выполняется, остановлен, ожидает и т.п.)
- Stop - остановка запущенных процессов

### Как создается процесс?

- операционная система (ОС) читает код программы и любые дополнительные данные
- код программы загружается в память, а точнее, в адресное пространство (address space) процесса
- для стека программы (стека времени выполнения - runtime stack) выделяется память. Стек инициализируется ОС с помощью argv, argc и параметров для main()
- память также выделяется для кучи (heap) программы, которая необходима для динамических структур данных, таких как связанные списки и хеш-таблицы
- выполняются задачи инициализации ввода-вывода, как в системах на базе Unix/Linux, где каждый процесс имеет 3 файловых дескриптора (ввод, вывод и ошибка)
- ОС запускает программу, начиная с main()

### Загрузка программы в память происходит жадно (eagerly) (все сразу): правда или ложь?

Ложь. Это было правдой в прошлом, но сегодняшние операционные системы выполняют отложенную загрузку (lazy loading) - сначала загружаются только те части, которые необходимы для запуска процесса.

### В каких состояниях может находиться процесс?

- Running - выполнение инструкций
- Ready - готов к запуску, но по какой-то причине приостановлен
- Blocked - заблокирован, ожидает завершения какой-либо операции

### Что может заблокировать процесс?

- Операции ввода-вывода (например, чтение данных с диска)
- ожидание пакета данных из сети

### Что такое "разделение времени"?

Даже при использовании системы с одним физическим процессором можно разрешить нескольким пользователям работать на ней и запускать программы. Это возможно при разделении времени (time sharing), когда вычислительные ресурсы распределяются таким образом, что пользователю кажется, что система имеет несколько процессоров, но на самом деле это один процессор, используемый совместно с применением мультипрограммирования и многозадачности.

### Что такое "разделение пространства"?

Это своего рода противоположность разделению времени (time sharing). При разделении времени ресурс используется некоторое время одним пользователем, а затем другим пользователем. При разделении пространства (space sharing), пространство используется несколькими пользователями одновременно, но не является совместным, т.е. каждый пользователь использует свою изолированную часть пространства. Часть пространства используется одной сущностью до тех пор, пока эта сущность не решит от него избавиться. Возьмем, к примеру, хранилище. Наш файл будет "лежать" в хранилище, пока мы его не удалим.

### Какой компонент операционной системы определяет порядок запуска процессов?

Планировщик процессора (CPU Scheduler).

### Что такое виртуальная память? Для чего она используется?

Виртуальная память объединяет оперативную память компьютера и временное пространство на жестком диске. Когда оперативная память заканчивается, виртуальная память помогает переместить данные из ОЗУ в пространство, называемое файлом подкачки (paging file). Перемещение данных в файл подкачки может освободить оперативную память, чтобы компьютер мог завершить свою работу. В общем, чем больше оперативной памяти имеется в распоряжении компьютера, тем быстрее работают программы.

Подробнее о виртуальной памяти можно почитать [здесь](https://www.minitool.com/lib/virtual-memory.html).

### Что такое копирование при записи?

Копирование при записи (copy-on-write, COW) — это концепция управления ресурсами, целью которой является сокращение ненужного копирования информации. Это концепция, которая реализована, например, в системном вызове разветвления (fork syscall) POSIX, который дублирует вызывающий процесс вместо создания нового. Идея состоит в следующем:

1. Если ресурсы совместно используются двумя или более сущностями (например, сегменты общей памяти, используемые двумя процессами), ресурсы не нужно копировать для каждой сущности, достаточно предоставить им разрешение на доступ к операции READ к общему ресурсу (общие сегменты помечены как доступные только для чтения) (каждая сущность содержит указатель на расположение общего ресурса, который можно разыменовать, чтобы прочитать его значение).
2. Если одна сущность выполнит операцию WRITE над общим ресурсом, возникнет проблема, поскольку ресурс также будет навсегда изменен для всех сущностей, совместно использующих его (допустим, сущность меняет переменные в стеке или динамически распределяет данные в куче. Эти изменения в общем ресурсе повлияют на другие процессы - такое поведение является нежелательным).
3. Поэтому при выполнении над общим ресурсом операции WRITE, этот ресурс сначала копируется, а затем к нему применяются изменения.

### Что такое ядро? За что оно отвечает?

Ядро (kernel) - это часть операционной системы, которая отвечает за такие задачи, как:

- выделение памяти
- планирование процессов
- управление процессором

### Некоторые части кода ядра загружаются в защищенные области памяти, поэтому приложения не могут их перезаписать: правда или ложь?

Правда.

### Что такое буфер? Что такое кэш?

Буфер (buffer) - это зарезервированное место в оперативной памяти, которое используется для временного хранения данных. Кэш обычно используется в процессах чтения и записи на диск, чтобы ускорить чтение за счет облегчения доступа к одинаковым данным, используемым разными программами.

## Виртуализация

### Что такое виртуализация?

Виртуализация (virtualization) использует программное обеспечение для создания уровня абстракции над компьютерным оборудованием, который позволяет аппаратным элементам одного компьютера - процессорам, памяти, хранилищу и др. быть разделенными на несколько виртуальных компьютеров, обычно называемых виртуальными машинами (virtual machines, VMs).

### Какие существуют типы виртуализации?

- Виртуализация операционной системы
- виртуализация сетевых функций
- виртуализация настольных компьютеров

### Что такое гипервизор?

Red Hat: "Гипервизор (hypervisor) — это программное обеспечение, которое создает и запускает виртуальные машины (virtual machines, VMs). Гипервизор, иногда называемый монитором виртуальных машин (virtual machine monitor, VMM), изолирует операционную систему и ресурсы гипервизора от виртуальных машин и позволяет создавать и управлять ими".

Подробнее о гипервизоре можно почитать [здесь](https://www.redhat.com/en/topics/virtualization/what-is-a-hypervisor).

### Какие существуют типы гипервизоров?

Хостинговые (host) гипервизоры и гипервизоры без операционной системы (bare-metal).

### В чем преимущества и недостатки гипервизора без операционной системы по сравнению с хостинговым гипервизором?

Благодаря наличию собственных драйверов и прямому доступу к аппаратным компонентам "голый" (bare-metal) гипервизор зачастую имеет более высокую производительность, а также стабильность и масштабируемость.

С другой стороны, хостинговый гипервизор обычно выигрывает от лучшей совместимости с другим оборудованием.

### Является ли контейнеризация типом виртуализации?

Да, это виртуализация на уровне операционной системы, где ядро ​​является общим и позволяет использовать несколько изолированных экземпляров пользовательского пространства.

### Как внедрение виртуальных машин изменило отрасль и способы деплоя приложений?

Внедрение виртуальных машин позволило компаниям развертывать несколько бизнес-приложений на одном оборудовании, при этом каждое приложение независимо от других и работает в отдельной операционной системе.

### Нужны ли нам виртуальные машины в эпоху контейнеров?

Виртуальные машины по-прежнему актуальны даже в эпоху контейнеров. Хотя контейнеры представляют собой легкую и портативную альтернативу виртуальным машинам, у них есть определенные ограничения, например, проблемы с распределением ядра хоста. Виртуальные машины по-прежнему имеют значение, поскольку обеспечивают изоляцию и безопасность, могут работать под управлением различных операционных систем и подходят для устаревших приложений.

## Хранилище

### Какие существуют типы хранилищ?

- Файловые
- блочные
- объектные

### Что такое объектное хранилище?

- Данные разделены на автономные объекты
- объекты могут содержать метаданные

### В чем преимущества и недостатки объектных хранилищ?

Преимущества:

- обычно мы платим за то, что используем, в отличие от других типов хранилищ, где мы платим за выделенное пространство для хранения
- объектное хранилище основано на модели, в которой мы получаем то, что используем, и можем добавлять новые хранилища по мере необходимости

Недостатки:

- обычно работает медленнее, чем другие типы хранилищ
- для модификации объекта его приходится создавать заново

### Что такое файловое хранилище?

- Используется для хранения данных в файлах, в иерархической структуре
- устройствами для файлового хранилища могут быть жесткий диск, флеш-накопитель, облачные файловые хранилища
- файлы обычно организованы в директории

### В чем преимущества файловых хранилищ?

- Пользователи имеют полный контроль над своими файлами и могут выполнять с ними различные операции: удалять, читать, записывать и перемещать
- механизм безопасности позволяет пользователям лучше контролировать такие вещи, как блокировка файлов

### Приведите примеры файловых хранилищ

- Локальная файловая система
- Dropbox
- Google Drive

### Что такое файловая система?

Файловая система (file system) - это способ организации и хранения файлов данных на компьютерах и других электронных устройствах. Он обеспечивает структуру, которая помогает организовывать данные в файлы и директории, что упрощает поиск информации и управление ею. Файловая система имеет решающее значение для обеспечения организованного хранения данных и управления ими.

Часто используемые файловые системы:

Windows

- NTFS
- exFAT

MacOS

- HFS + *APFS

## Распределенные системы

### Что такое распределенное вычисление (распределенная система)?

По словам Martin Kleppmann:

"Несколько процессов, выполняемых на нескольких машинах... только передача сообщений через ненадежную сеть с переменными задержками, и система может страдать от частичных сбоев, ненадежных часов и приостановок процессов".

Другое определение: "Системы, которые физически разделены, но логически связаны".

### Что может привести к сбою системы?

- Сеть
- центральный процессор
- память
- жесткий диск

### Что такое "теорема CAP" (теорема Брюера)?

Согласно теореме CAP, распределенное хранилище данных не может одновременно обеспечивать более двух из следующих функций:

- Доступность (availability) - на каждый запрос поступает ответ (это не обязательно должны быть самые свежие данные)
- согласованность (consistency) - на каждый запрос поступает ответ с самыми свежими данными
- устойчивость к разделению (partition tolerance) - даже если некоторые данные потеряны/удалены, система продолжает работать

### В чем проблема следующей архитектуры? Как ее улучшить?

<img src="https://habrastorage.org/webt/hs/t1/us/hst1us-cs8w2cnekbjoui3a0fe0.png" />
<br />

Резервный сервер (standby application) - это пустая трата ресурсов: если первый сервер работает, резервный ничего не делает.

### В чем проблема следующей архитектуры? Как ее улучшить?

<img src="https://habrastorage.org/webt/rs/gw/cx/rsgwcxbbuttlcdufsjwwriowsi4.png" />
<br />

Проблема: если балансировщик нагрузки (load balancer) выходит из строя, мы потеряем связь с приложением.

Способы решения проблемы:

- добавить еще один балансировщик нагрузки
- использовать запись A DNS для обоих балансировщиков
- использовать очередь сообщений (message queue)

### Что такое архитектура "Shared-Nothing"?

Это архитектура, в которой данные извлекаются из одного, нераспределенного источника, обычно подключенного исключительно к одному узлу, в отличие от архитектур, в которых запрос может попасть на один из многих узлов, и данные будут получены из одного общего места (хранилище, память и т.п.).

## Системный дизайн

### Что такое CDN?

CDN (Content Delivery Network - сеть доставки контента) отвечает за географическое распределение контента. Частично это так называемые периферийные местоположения (edge locations), также известные как прокси-серверы кэша (cache proxies), которые позволяют пользователям быстро получать контент благодаря функциям кэширования и географическому распределению.

### Что такое Multi-CDN?

В Single CDN весь контент создается из сети доставки контента. В Multi-CDN контент распределяется по нескольким CDN, каждый из которых может находиться у совершенно разных провайдеров/облаков.

### Каковы преимущества Multi-CDN по сравнению с Single CDN?

- Устойчивость - использование одной CDN означает отсутствие резерва. Благодаря нескольким CDN нам не нужно беспокоиться о том, что наш CDN не работает
- гибкость затрат - использование одного CDN означает зависимость от его тарифов
- производительность - при использовании Multi-CDN появляется выбор лучших мест, которые ближе к клиенту, запрашивающему контент
- масштабирование - несколько CDN позволяют масштабировать сервисы для поддержки более экстремальных условий

### Каковы недостатки монолитной архитектуры?

- Не подходит для частого изменения кода и добавления новых функций
- не предназначена для современной инфраструктуры (например, публичных облаков)
- масштабировать команду для работы с монолитной архитектурой сложнее

### Каковы преимущества микросервисной архитектуры перед монолитной?

- Сбой одного сервиса не влечет сбой всего приложения
- каждый сервис может разрабатываться и поддерживаться отдельной командой, и эта команда может выбирать свои собственные инструменты и язык программирования

### Что такое масштабируемость?

Масштабируемость (scalability) - это возможность легкого увеличения размера и емкости системы в зависимости от спроса и использования.

### Что такое эластичность?

Эластичность (elasticity) - это способность системы как расти, так и сокращаться в зависимости от того, что требуется в данный момент.

### Что такое аварийное восстановление?

Аварийное восстановление (disaster recovery) - это процесс восстановления критически важных бизнес-систем и данных после разрушительного события. Цель состоит в том, чтобы минимизировать негативные последствия и быстро возобновить нормальное функционирование. Это включает в себя создание плана, его тестирование, резервное копирование важных данных и их хранение в безопасных местах. В случае катастрофы план выполняется, резервные копии восстанавливаются, системы снова подключаются к сети. Процесс восстановления может занять часы или дни в зависимости от повреждений инфраструктуры. Это делает бизнес-планирование важным, поскольку хорошо разработанный и проверенный план аварийного восстановления может минимизировать воздействие катастрофы и обеспечить бесперебойную работу системы.

### Что такое отказоустойчивость и высокая доступность?

Отказоустойчивость (fault tolerance) - это способность к самовосстановлению и возвращению к нормальной работоспособности. Это способность противостоять сбоям и сохранять работоспособность.

Высокая доступность (high availability) - это возможность доступа к ресурсу (в некоторых случаях с помощью разных платформ).

### В чем разница между высокой доступностью и аварийным восстановлением?

Высокая доступность устраняет единые точки отказа (single points of failure), а аварийное восстановление - это процесс возврата системы в рабочее состояние, когда система становится неработоспособной. По сути, аварийное восстановление начинается при сбое высокой доступности, поэтому сначала следует обеспечить высокую доступность.

### Что такое вертикальное масштабирование?

Вертикальное масштабирование (vertical scaling) - это процесс добавления ресурсов для увеличения мощности существующих серверов. Например, добавление процессоров, оперативной памяти и т.д.

### Каковы недостатки вертикального масштабирования?

Даже при вертикальном масштабировании компонент остается единственной точкой отказа (single point of failure). Кроме того, существуют аппаратные ограничения: если у нас недостаточно ресурсов, мы не сможем масштабироваться по вертикали.

### Что такое горизонтальное масштабирование?

Горизонтальное масштабирование (horizontal scaling) - это процесс добавления дополнительных ресурсов (серверов), которые смогут обрабатывать запросы как единое целое.

### В чем недостаток горизонтального масштабирования? Что требуется для его реализации?

Балансировщик нагрузки. Мы может добавить больше ресурсов, но если мы хотим, чтобы они участвовали в работе, нам нужно предоставлять им запросы для обработки. Кроме того, при горизонтальном масштабировании часто возникает несогласованность данных.

### Почему бы не записывать все данные в кэш вместо базы данных/хранилища данных?

Кэширование и базы данных (БД) служат разным целям и оптимизированы для разных случаев использования.

Кэширование используется для ускорения операций чтения за счет хранения часто используемых данных в памяти или на быстром носителе. Храня данные близко к приложению, кэширование уменьшает задержку и накладные расходы на доступ к данным из более медленной и удаленной системы хранения, такой как БД или диск.

С другой стороны, БД оптимизированы для хранения и управления постоянными данными. БД предназначены для обработки одновременных операций чтения и записи, обеспечения соблюдения ограничений согласованности и целостности, а также предоставления таких функций, как индексирование и запросы.

## Аппаратное обеспечение

### Что такое CPU?

CPU (Central Processing Unit - центральный процессор, ЦП) выполняет основные арифметические, логические, управляющие операции и операции ввода-вывода (input/output, I/O), определенные в инструкциях программы. Это контрастирует с внешними компонентами, такими как основная память и схемы ввода-вывода, а также специализированными процессорами, такими как графические процессоры (Graphical Processing Unit, GPU).

### Что такое RAM?

RAM (Random Access Memory - оперативное запоминающее устройство, ОЗУ) - это аппаратное обеспечение вычислительного устройства, в котором хранятся операционная система (ОС), прикладные программы и текущие используемые данные, чтобы процессор устройства мог быстро получить к ним доступ. Чтение и запись в оперативную память происходят намного быстрее, чем на другие виды накопителей, такие как жесткий диск (HDD), твердотельный накопитель (SSD) или оптический привод.

### Что такое GPU?

GPU (Graphics Processing Unit - графический процессор) - это специализированная электронная схема, предназначенная для ускорения обработки изображений и видео для их отображения на экране компьютера.

### Что такое встроенная система?

Встроенная система (embedded system) - это компьютерная система, представляющая собой комбинацию компьютерного процессора, компьютерной памяти и периферийных устройств ввода-вывода, которая выполняет специальную функцию в рамках более крупной механической или электронной системы. Встроенная система является частью целостного устройства, часто включающего электрическое или электронное оборудование и механические части.

### Приведите пример встроенной системы

Типичным примером встроенной системы является цифровая панель управления микроволновой печью, которой управляет микроконтроллер.

Raspberry Pi также в определенных случаях может служить встроенной системой.

### Какие существуют типы накопителей?

Существует несколько типов накопителей, включая жесткие диски (HDD), твердотельные накопители (SSD) и оптические приводы (CD/DVD/Blu-ray). Другие типы накопителей включают USB-накопители, карты памяти и сетевые хранилища (NAS).

### Какие соображения следует учитывать командам DevOps при выборе оборудования для работы?

Выбор правильного оборудования DevOps имеет важное значение для реализации оптимизированных конвейеров CI/CD, своевременных циклов обратной связи и стабильной доступности услуг. Помимо прочего, командам DevOps необходимо учитывать следующее:

1. Понимание рабочих нагрузок (workloads):
   - ЦП - рассмотрите необходимость использования многоядерных или высокочастотных ЦП
   - ОЗУ - достаточный объем памяти жизненно важен для таких действий, как крупномасштабная разработка или интенсивная автоматизация
   - хранилище - оцените скорость и емкость хранилища. SSD могут быть предпочтительнее для быстрых операций
2. Расширяемость:
   - горизонтальный рост - убедитесь, что можете увеличивать емкость за счет добавления дополнительных устройств
   - вертикальный рост - убедитесь, что возможны обновления (например, ОЗУ, ЦП) на отдельных машинах
3. Подключение:
   - передача данных - обеспечьте высокоскоростное сетевое соединение для таких действий, как получение кода и передача данных
   - скорость - стремитесь к сетям с низкой задержкой, что особенно важно для распределенных задач
   - резервные маршруты - подумайте о резервных сетевых маршрутах во избежание простоев
4. Постоянное время безотказной работы:
   - планируйте резервное копирование данных, например конфигураций RAID, наличие резервных источников питания или альтернативных сетевых подключений, чтобы обеспечить непрерывное обслуживание
5. Совместимость системы:
   - убедитесь, что оборудование соответствует программному обеспечению, операционной системе и предполагаемым платформам использования
6. Энергоэффективность:
   - оборудование, которое эффективно использует энергию, может снизить затраты в долгосрочной перспективе, особенно в крупных системах
7. Меры предосторожности:
   - изучите функции безопасности на аппаратном уровне, такие как TPM, для повышения уровня защиты
8. Надзор и контроль:
   - такие инструменты, как ILOM, могут быть полезны для удаленного управления
   - убедитесь, что оборудование можно беспрепятственно контролировать на предмет работоспособности и производительности
9. Бюджетирование:
   - при составлении бюджета учитывайте как первоначальные расходы, так и долгосрочные затраты
10. Поддержка и сообщество:
    - выбирайте оборудование от надежных поставщиков, известных хорошей поддержкой
    - проверьте наличие доступных драйверов, обновлений и обсуждений сообщества по поводу оборудования
11. Планирование наперед:
    - выбирайте оборудование, которое может удовлетворить как текущие, так и будущие требования
12. Операционная среда:
    - контроль температуры - убедитесь, что системы охлаждения отводят тепло от высокопроизводительных агрегатов
    - управление пространством - оцените размер оборудования с учетом доступного места в стойке
    - надежное питание - обеспечьте наличие постоянных и резервных источников питания
13. Облачная координация:
    - если вы склоняетесь к настройке гибридного облака, сосредоточьтесь на том, как локальное оборудование будет взаимодействовать с облачными ресурсами
14. Срок службы оборудования:
    - помните о сроке службы оборудования и о том, когда может потребоваться его замена или обновление
15. Оптимизация для виртуализации:
    - при использовании виртуальных машин или контейнеров убедитесь, что оборудование совместимо и оптимизировано для таких рабочих нагрузок
16. Адаптивность:
    - модульное оборудование позволяет заменять отдельные компоненты, обеспечивая большую гибкость
17. Зависимость от одного поставщика:
    - старайтесь не полагаться на одного поставщика, если у него нет явных преимуществ
18. Экологичный выбор:
    - отдавайте предпочтение энергоэффективному экологически безопасному оборудованию

Таким образом, команды DevOps должны выбирать оборудование, совместимое с их задачами, универсальное, обеспечивающее хорошую производительность и не выходящее за рамки их бюджета. Приоритетными должны быть долгосрочные соображения, такие как техническое обслуживание, потенциальные обновления и совместимость с будущим оборудованием.

### Какова роль оборудования в планировании и реализации аварийного восстановления?

Аппаратное обеспечение имеет решающее значение в аварийном восстановлении (Disaster Recovery, DR). Хотя аварийное восстановление также включает в себя такие вещи, как стандартные процедуры, нормы и роли людей, именно оборудование обеспечивает бесперебойную работу бизнес-процессов. Оборудование связано с аварийным восстановлением следующим образом.

1. Хранение данных и обеспечение их дублирования:
   - оборудование для резервного копирования - такие устройства, как ленточные накопители, серверы резервного копирования и внешние жесткие диски, обеспечивают безопасное хранение важных данных в другом месте
   - дисковые массивы - такие системы, как RAID, обеспечивают защиту. Если один диск выходит из строя, остальные это компенсируют
2. Альтернативные системы восстановления:
   - резервные серверы вступают в действие, когда основные серверы выходят из строя, поддерживая поток обслуживания
   - распределители трафика - такие устройства, как балансировщики нагрузки, распределяют трафик между серверами. Если сервер выходит из строя, они перенаправляют пользователей на рабочие сервера
3. Альтернативные операционные центры (Operation Hubs):
   - готовые к использованию центры (Ready-to-use Centers) - места, оборудованные и подготовленные для немедленного принятия на себя ответственность в случае выхода из строя главного центра
   - основные объекты (Basic Facilities) - локации, активация которых занимает много времени, с необходимым оборудованием, но без последних данных
   - полуготовые объекты (Semi-prepped Facilities) - локации, в некоторой степени подготовленные с использованием выбранных систем и данных, активация которых занимает мешьше времени, чем активация основных объектов
4. Механизмы резервного питания:
   - мгновенное резервное питание (Instant Power Backup) - такие устройства, как источники бесперебойного питания (ИБП), обеспечивают питание во время кратковременных отключений, гарантируя отсутствие резких отключений
   - долгосрочные решения в области электропитания (Long-term Power Solutions) - генераторы поддерживают работоспособность жизненно важных систем во время длительных потерь электроэнергии
5. Сетевое оборудование:
   - резервные подключения к Интернету - наличие альтернатив гарантирует подключение, даже если у одного провайдера возникли проблемы
   - инструменты безопасного подключения - устройства, обеспечивающие безопасный удаленный доступ, что особенно важно в ситуациях аварийного восстановления
6. Физическая установка на месте:
   - организованное размещение - такие конструкции, как стеллажи, для аккуратного хранения оборудования и управления им
   - аварийный контроль температуры - резервные механизмы охлаждения для предотвращения перегрева сервера при неисправностях системы отопления, вентиляции и кондиционирования
7. Альтернативные каналы связи:
   - орбитальные телефоны - удобны, когда обычные методы связи не работают
   - устройства прямой связи - такие устройства, как радиоприемники, полезные, когда основные системы не работают
8. Механизмы защиты:
   - электронные барьеры и системы оповещения - такие устройства, как межсетевые экраны (firewalls) и системы обнаружения вторжений, обеспечивают безопасность систем аварийного восстановления
   - физический контроль входа - системы контроля входа и мониторинга, обеспечивающие доступ только допущенному персоналу
9. Единообразие и совместимость аппаратного обеспечения:
    - управлять оборудованием и заменять его в чрезвычайных ситуациях проще, если конфигурации оборудования согласованы и совместимы
10. Оборудование для испытаний и обслуживания:
    - в учениях по аварийному восстановлению может использоваться специальное оборудование, чтобы гарантировать, что основные системы не будут затронуты. Это подтверждает готовность и способность оборудования справляться с реальными кризисами

Подводя итог, можно сказать, что хотя программное обеспечение и вмешательство человека важны в операциях аварийного восстановления, именно оборудование обеспечивает базовую поддержку. Для эффективного аварийного восстановления крайне важно поддерживать отказоустойчивость, дублирование и регулярную оценку этого оборудования.

### Что такое RAID?

RAID означает Redundant Array of Independent Disks (избыточный массив независимых дисков). Это объединение множества жестких дисков в одно устройство, известное как массив (array), для повышения производительности, расширения емкости хранилища и/или обеспечения избыточности для предотвращения потери данных.

### Что такое микроконтроллер?

Микроконтроллер (microcontroller) - это небольшая интегральная схема, которая управляет определенными задачами во встроенной системе. Обычно он включает в себя процессор, память и периферийные устройства ввода-вывода.

### Что такое NIC?

NIC (Network Interface Controller - контроллер сетевого интерфейса) - это аппаратное обеспечение, которое подключает компьютер к сети и позволяет ему взаимодействовать с другими устройствами.

### Что такое DMA?

DMA (Direct Memory Access - прямой доступ к памяти) - это функция компьютерных систем, которая позволяет определенным аппаратным подсистемам получать доступ к основной системной памяти независимо от центрального процессора. DMA позволяет устройствам обмениваться данными и получать их из основной памяти компьютера. Он делает это, позволяя процессору выполнять другие задачи.

### Что такое RTOS?

RTOS (Real-time Operating System - операционная система реального времени) - это операционная система для вычислительных приложений реального времени, которая обрабатывает данные и события, имеющие критически важные временные ограничения. RTOS отличается от ОС с разделением времени (Time-sharing Operating System), такой как Unix, которая управляет разделением системных ресурсов с помощью планировщика (scheduler), буферов данных или фиксированной приоритизации задач в многозадачной или многопрограммной среде. Требования ко времени обработки должны быть полностью поняты и связаны (bound), а не просто сведены к минимуму. Вся обработка должна происходить в пределах установленных ограничений. RTOS управляются событиями и упреждают друг друга. Это означает, что ОС может отслеживать приоритет конкурирующих задач и вносить в него изменения.

### Какие существуют типы прерываний?

Возможны шесть классов прерываний:

- внешние
- проверка машины (machine check)
- ввод-вывод
- программные
- перезагрузка
- вызов супервизора (supervisor, SVC)

## Большие данные

### Что такое большие данные?

По определению Doug Laney:

- Объем (volume) - чрезвычайно большие объемы данных
- скорость (velocity) - в реальном времени, пакетно (batch), потоки данных (streams)
- разнообразие (variety) - различные формы данных: структурированные, полуструктурированные и неструктурированные
- достоверность/изменчивость (Veracity/Variability) - противоречивые, иногда неточные, различающиеся данные

### Что такое DataOps? Как это связано с DevOps?

DataOps стремится сократить время сквозного (end-to-end) цикла анализа данных, от зарождения идеи до создания диаграмм, графиков и моделей, представляющих ценность. DataOps сочетает в себе гибкую разработку (Agile development), DevOps и статистический контроль процессов и применяет их к анализу данных.

### Что такое архитектура данных?

Архитектура данных (data architecture) - это процесс стандартизации того, как организации собирают, хранят, преобразовывают, распространяют и используют данные. Цель состоит в том, чтобы предоставить актуальные данные людям, которые в них нуждаются, тогда, когда они им нужны, и помочь им разобраться в них.

### Какие существуют форматы данных?

- Структурированные (structured) - данные, имеющие определенный формат и длину (например, числа, слова)
- полуструктурированные (semi-structured) - не соответствует определенному формату, но описывают сами себя (например, XML, SWIFT)
- неструктурированные (unstructured) - не соответствует определенному формату (например, изображения, тестовые сообщения)

### Что такое Data Warehouse?

- [Википедия](https://en.wikipedia.org/wiki/Data_warehouse)
- [Amazon](https://aws.amazon.com/data-warehouse)

### Что такое Data Lake?

- [Википедия](https://en.wikipedia.org/wiki/Data_lake)

### Что такое Apache Hadoop?

- [Википедия](https://en.wikipedia.org/wiki/Apache_Hadoop)

### Что такое Hadoop YARN?

Hadoop YARN отвечает за управление вычислительными ресурсами в кластерах и планирование пользовательских приложений.

### Что такое Hadoop MapReduce?

Hadoop MapReduce - модель программирования для крупномасштабной обработки данных.

### Что такое HDFS?

HDFS означает Hadoop Distributed File Systems (распределенные файловые системы Hadoop).

- Распределенная файловая система обеспечивает высокую совокупную пропускную способность по всему кластеру
- для пользователя это выглядит как обычная файловая система, но за кулисами она распределена по нескольким машинам в кластере
- типичный размер системы составляет 1 ТБ, она может масштабироваться и поддерживать миллионы файлов
- система отказоустойчива - после сбоев восстанавливается автоматически
- она лучше всего подходит для выполнения длительных пакетных операций, но не для анализа в реальном времени

### Опишите архитектуру HDFS

- Архитектура "Господин-раб" (master-slave)
- Namenode - главный, Datanodes - подчиненные
- файлы разбиты на блоки
- блоки хранятся на узлах данных (datanodes)
- Namenode контролирует все метаданные

## Разное

### API

### Что происходит, когда мы вводим URL в браузере?

1. Браузер ищет запись IP-адреса доменного имени в DNS в следующем порядке:
   1. Кэш браузера.
   2. Кэш операционной системы (ОС).
   3. DNS-сервер, настроенный в системе пользователя (это может быть DNS Интернет-провайдера, общедоступный DNS и т.д.).
2. Если не удалось найти локальную запись DNS, запускается полное разрешение (resolution) DNS.
3. Браузер подключается к серверу по протоколу TCP.
4. Браузер отправляет HTTP-запрос на сервер.
5. Сервер отправляет HTTP-ответ обратно в браузер.
6. Браузер отображает ответ (например, HTML).
7. Затем браузер отправляет на сервер запросы на получение CSS, изображений, JavaScript и т.д., и шаги 3-5 повторяются.

### Что такое API?

API (Application Programming Interface - интерфейс прикладного программирования) - явно и целенаправленно определенный интерфейс, предназначенный для вызова по сети, который позволяет разработчикам программного обеспечения получать программный доступ к данным и функциям внутри организации контролируемым и удобным способом.

### Что такое спецификация API?

Спецификация API (API Specification) содержит описание того, как ведет себя API и как этот API связан с другими API. В ней объясняется, как функционирует API и какие результаты следует ожидать при его использовании.

### Определение (Definition) API и спецификация (Specification) API - это одно и тоже: правда или ложь?

Ложь. Определение API похоже на спецификацию API в том смысле, что оно обеспечивает понимание того, как API организован и как он функционирует. Но определение API предназначено для машины, а не для людей.

### Что такое шлюз API?

Шлюз API (API Gateway) похож на привратника, который контролирует, как разные части системы взаимодействуют друг с другом и как между ними происходит обмен информацией.

Шлюз API обеспечивает единую точку входа для клиентов и может выполнять несколько задач, включая маршрутизацию запросов к соответствующей внутренней службе, балансировку нагрузки, безопасность и аутентификацию, ограничение частоты запросов, кэширование и мониторинг.

Используя шлюз API, организации могут упростить управление своими API, обеспечить согласованную безопасность и управление, а также повысить производительность и масштабируемость своих серверных служб. Он часто используются в архитектурах микросервисов, где имеется множество небольших независимых сервисов, к которым должны иметь доступ разные клиенты.

### В чем заключаются преимущества использования шлюза API?

- Упрощение управлением API. Шлюз API предоставляет единую точку входа для всех запросов, что упрощает управление и мониторинг нескольких API
- повышение безопасности. Шлюз API предоставляет возможность реализации функций безопасности, таких как аутентификация, авторизация и шифрование, для защиты серверных служб от несанкционированного доступа
- повышение масштабируемости. Шлюз API может обрабатывать всплески трафика и распределять запросы к серверным службам таким образом, чтобы максимизировать использование ресурсов и повысить общую производительность системы
- обеспечение композиции сервисов. Шлюз API позволяет объединять различные серверные сервисы в единый API, обеспечивая более детальный контроль над сервисами, доступными клиентам
- упрощение интеграции с внешними системами. Шлюз API может использоваться для предоставления внутренних сервисов внешним партнерам или клиентам, что упрощает интеграцию с внешними системами и позволяет использовать новые бизнес-модели

### Что такое автоматизация и чем она отличается от оркестрации?

Автоматизация (automation) - это процесс автоматизации задач, позволяющий уменьшить вмешательство человека или его взаимодействие с технологиями и системами. В то время как автоматизация фокусируется на уровне задач, оркестровка (orchestration) - это процесс автоматизации рабочих процессов, состоящих из множества задач, обычно выполняемых в нескольких системах.

### Какие сервисы могут существовать в приложении?

- Аутентификация/авторизация
- логгирование
- сервис заказов
- сервис оплаты
- фронтенд
- бэкенд

### Что такое метаданные?

Метаданные (metadata) - это данные о данных. Обычно метаданные описывают, какой тип информации содержат данные.

### Что такое Domain Specific Language?

DSL (Domain Specific Language - язык, специфичный для предметной области) используется для создания индивидуального языка, который представляет предметную область так, чтобы эксперты в предметной области могли легко его интерпретировать.

### YAML

### Что такое YAML?

YAML - это язык сериализации данных (data serialization language), используемый сегодня во многих технологиях, таких как Kubernetes, Ansible и др.

### Любой валидный файл JSON также является валидным файлом YAML: правда или ложь?

Правда, поскольку YAML - это расширение (superset) JSON.

### Каков формат следующих данных?

```
{
    applications: [
        {
            name: "my_app",
            language: "python",
            version: 20.17
        }
    ]
}
```

JSON.

### Каков формат следующих данных?

```
applications:
  - app: "my_app"
    language: "python"
    version: 20.17
```

YAML.

### Как написать многострочную строку в YAML?

```
someMultiLineString: |
  look ma
  I can write a multi-line string
  I love YAML
```

Это может пригодиться при написании сценария оболочки (shell script), когда каждая строка сценария - это отдельная команда.

### В чем разница между `someMultiLineString: |` и `someMultiLineString: >`?

При использовании `>` многострочная строка сворачивается (fold) в одну строку:

```
someMultiLineString: >
  This is actually
  a single line
  do not let appearances fool you
```

### Что такое заполнители в YAML?

Заполнители/заменители (placeholders) позволяют ссылаться на значения вместо их прямого использования:

```
username: {{ user.user_name }}
```

### Как определить несколько компонентов YAML в одном файле?

Это можно сделать с помощью `---`:

```
document_number: 1
---
document_number: 2
```

### Что такое модульные тесты?

Модульное тестирование (юнит-тестирование - unit test) - это метод тестирования программного обеспечения, который предполагает разделение системы на части и тестирование каждой части по-отдельности. Эти тесты автоматизированы и могут выполняться неоднократно, что позволяет разработчикам быстро выявлять крайние случаи (edge cases) или ошибки во время разработки.

Основная цель модульных тестов - проверить, что каждая функция выдает правильные выходные данные с учетом набора входных данных.

### Регулярные выражения

У нас есть некоторый текстовый файл. Необходимо сделать следующее.

### Извлечь все числа

`\d+`

### Извлечь первое слово каждой строки

`^\w+`

Извлечь последнее слово каждой строки.

`\w+(?=\W*$)` (зависит от форматирования строки).

### Извлечь IP-адрес

`\b(?:\d{1,3}\ .){3}\d{1,3}\b` (IPv4)

### Извлечь email

`\b[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\ .[A-Za-z]{2,}\b`

### Что такое семантическое версионирование?

Семантическое версионирование (semantic versioning) выглядит как MAJOR.MINOR.PATCH (например, 1.2.3), где:

- MAJOR означает внесение в интерфейс несовместимых изменений
- MINOR означает добавление функционала с обратной совместимостью
- PATCH означает исправление ошибок с обратной совместимостью

Дополнительные метки (labels) для метаданных предварительной версии (beta) и сборки доступны как расширения формата MAJOR.MINOR.PATCH.

## Go

### Назовите некоторые характеристики языка программирования Go

- Строгая и статическая типизация - тип переменной должны быть определен во время компиляции и не может быть изменен впоследствии
- простота
- быстрое время компиляции
- встроенный параллелизм
- сборка мусора
- независимость от платформы
- компиляция в автономный двоичный файл - все, что нужно для запуска приложения, компилируется в один двоичный файл. Это очень полезно для управления версиями во время выполнения

У Go также хорошее сообщество.

### В чем разница между `var x int = 2` и `x := 2`?

Результат одинаковый: переменная со значением 2.

При использовании `var x int = 2` мы устанавливаем целочисленный тип переменной, а при использовании `x := 2` мы позволяем Go определить тип самостоятельно.

### В Go мы можем повторно объявлять переменные, и после объявления переменных мы обязаны их использовать: правда или ложь?

Мы не можем переобъявлять переменные, но да, мы должны использовать переменные, которые были объявлены.

### В следующем коде мы пытаемся преобразовать число 101 в строку, но получаем "e". Почему? Как это исправить?

```go
package main

import "fmt"

func main() {
  var x int = 101
  var y string
  y = string(x)
  fmt.Println(y)
}
```

`string()` "смотрит", какое значение Юникода соответствует 101, и использует его для преобразования целого числа в строку. Для того, чтобы получить "101", следует использовать пакет `strconv` и заменить `y = string(x)` на `y = strconv.Itoa(x)`.

### Что не так со следующим кодом?

```go
package main

func main() {
  var x = 2
  var y = 3
  const someConst = x + y
}
```

Константы в Go можно объявлять только с помощью константных выражений. Однако `x`, `y` и их сумма являются переменными. Поэтому мы получаем сообщение об ошибке `const initializer x + y is not a constant`.

### Каким будет вывод следующего кода?

```go
package main

import "fmt"

const (
	x = iota
	y = iota
)
const z = iota

func main() {
	fmt.Printf("%v\n", x)
	fmt.Printf("%v\n", y)
	fmt.Printf("%v\n", z)
}
```

Идентификатор `iota` в Go используется в объявлениях `const` для упрощения определения возрастающих чисел. Поскольку его можно использовать в выражениях, он обеспечивает общность, выходящую за рамки простых перечислений. `x` и `y` в первой группе `iota`, `z` во второй.

### Для чего в Go используется _?

Это позволяет избежать объявления всех переменных для возвращаемых значений. Он называется пустым идентификатором.

### Каким будет вывод следующего кода?

```go
package main

import "fmt"

const (
	_ = iota + 3
	x
)

func main() {
	fmt.Printf("%v\n", x)
}
```

Поскольку первая `iota` объявлена ​​со значением `3` (`+3`), следующая имеет значение `4`.

### Каким будет вывод следующего кода?

```go
package main

import (
	"fmt"
	"sync"
	"time"
)

func main() {
	var wg sync.WaitGroup

	wg.Add(1)
	go func() {
		time.Sleep(time.Second * 2)
		fmt.Println("1")
		wg.Done()
	}()

	go func() {
		fmt.Println("2")
	}()

	wg.Wait()
	fmt.Println("3")
}
```

2 1 3.

### Каким будет вывод следующего кода?

```go
package main

import (
	"fmt"
)

func mod1(a []int) {
	for i := range a {
		a[i] = 5
	}

	fmt.Println("1:", a)
}

func mod2(a []int) {
	a = append(a, 125) // !

	for i := range a {
		a[i] = 5
	}

	fmt.Println("2:", a)
}

func main() {
	s1 := []int{1, 2, 3, 4}
	mod1(s1)
	fmt.Println("1:", s1)

	s2 := []int{1, 2, 3, 4}
	mod2(s2)
	fmt.Println("2:", s2)
}
```

1 [5 5 5 5]
1 [5 5 5 5]
2 [5 5 5 5 5]
2 [1 2 3 4]

В `mod1` `a` - это ссылка, и когда мы используем `a[i]`, мы меняем значение `s1`. Но в `mod2` `append` создает новый срез (slice), и мы меняем значение только `a`, а не `s2`.

### Каким будет вывод следующего кода?

```go
package main

import (
	"container/heap"
	"fmt"
)

// IntHeap — это минимальная куча целых чисел.
type IntHeap []int

func (h IntHeap) Len() int           { return len(h) }
func (h IntHeap) Less(i, j int) bool { return h[i] < h[j] }
func (h IntHeap) Swap(i, j int)      { h[i], h[j] = h[j], h[i] }

func (h *IntHeap) Push(x interface{}) {
  // Push и Pop используют приемники указателей (pointer receivers), поскольку они изменяют длину среза (slice),
  // а не только его содержимое.
	*h = append(*h, x.(int))
}

func (h *IntHeap) Pop() interface{} {
	old := *h
	n := len(old)
	x := old[n-1]
	*h = old[0 : n-1]
	return x
}

func main() {
	h := &IntHeap{4, 8, 3, 6}
	heap.Init(h)
	heap.Push(h, 7)

  fmt.Println((*h)[0])
}
```

3.

## SQL

### Что такое SQL?

SQL (Structured Query Language - язык структурированных запросов) - это стандартный язык для реляционных баз данных (таких как MySQL, PostgreSQL, MariaDB и т.д.). Он используется для создания, чтения, обновления и удаления данных в реляционных БД.

### В чем разница между SQL и NoSQL?

Основное отличие состоит в том, что базы данных SQL структурированы (данные хранятся в виде таблиц со строками и столбцами - как таблицы Excel), а базы данных NoSQL неструктурированы. Хранение данных в NoSQL БД зависит от настроек БД. Например, данные могут храниться в виде пар ключ-значение, документов и т.д.

### Когда лучше использовать SQL, а когда NoSQL?

SQL лучше всего использовать, когда целостность данных имеет решающее значение. SQL применяется во многих областях финансовой сферы из-за его соответствия требованиям ACID.

NoSQL отлично подходит для быстрого масштабирования. NoSQL был разработан для веб-приложений, поэтому он отлично подходит для быстрого распределения данных между несколькими серверами.

Кроме того, поскольку NoSQL не придерживается строгой структуры таблиц со столбцами и строками, необходимой для реляционных баз данных, можно хранить разные типы данных вместе.

### Практика

Для следующих вопросов будут использоваться следующие таблицы.

**Customers**

Customer_ID | Customer_name | Items_in_cart | Cash_spent_to_date
------------ | ------------- | ------------- | -------------
100204 | John Smith | 0 | 20.00
100205 | Jane Smith | 3 | 40.00
100206 | Bobby Frank | 1 | 100.20

**Orders**

Customer_ID | Order_ID | Item | Price | Date_sold
------------ | ------------- | ------------- | ------------- | -------------
100206 | A123 | Rubber Ducky | 2.20 | 2019-09-18
100206 | A123 | Bubble Bath | 8.00 | 2019-09-18
100206 | Q987 | 80-Pack TP | 90.00 | 2019-09-20
100205 | Z001 | Cat Food - Tuna Fish | 10.00 | 2019-08-05
100205 | Z001 | Cat Food - Chicken | 10.00 | 2019-08-05
100205 | Z001 | Cat Food - Beef | 10.00 | 2019-08-05
100205 | Z001 | Cat Food - Kitty quesadilla | 10.00 | 2019-08-05
100204 | X202 | Coffee | 20.00 | 2019-04-29

### Как выбрать все поля таблицы "Customers"?

```sql
SELECT *
FROM Customers;
```

### Сколько товаров в корзине John Smith?

```sql
SELECT Items_in_cart
FROM Customers
WHERE Customer_name = "John Smith";
```

### Сколько денег потратили все клиенты?

```sql
SELECT SUM(Cash_spent_to_date) as Sum_cash
FROM Customers;
```

### Сколько людей имеют товары в корзине?

```sql
SELECT count(1) as Number_of_people_with_items_in_cart
FROM Customers
WHERE Items_in_cart > 0;
```

### Как бы вы объединили таблицу "Customers" с таблицей "Orders"?

Их можно объединить их по уникальному ключу. В данном случае таким ключом является `Customer_ID`.

### Какой клиент какой товар заказал?

```sql
SELECT c.Customer_name, o.Item
FROM Customers c
LEFT JOIN Orders o
ON c.Customer_ID = o.Customer_ID;
```

### Как с помощью оператора `WITH` показать, кто заказал кошачий корм и сколько потратил на это денег?

```sql
with Сat_food AS (
SELECT Customer_ID, SUM(Price) AS Total_price
FROM Orders
WHERE Item LIKE "%Cat Food%"
GROUP BY Customer_ID
)
SELECT Customer_name, Total_price
FROM Customers c
INNER JOIN cat_food f
ON c.Customer_ID = f.Customer_ID
WHERE c.Customer_ID IN (SELECT Customer_ID FROM Cat_food);
```

Мощь оператора `WITH` проявляется в случаях, когда необходимо выполнить сложный запрос к таблице перед ее присоединением к другой таблице. Оператор `WITH` создает временную структуру данных вместо создания новой таблицы.

Сумма всех покупок кошачьего корма отсутствовала, поэтому мы использовали оператор `WITH` для создания псевдотаблицы с этими данными, а затем объединили таблицы обычным способом.

### Какой из следующих запросов лучше?

```sql
SELECT count(*)
FROM shawarma_purchases
WHERE
  YEAR(purchased_at) == '2017'
```

```sql
FROM shawarma_purchases
WHERE
	purchased_at >= '2017-01-01' AND
	purchased_at <= '2017-31-12'
```

Второй запрос лучше, поскольку функция `YEAR(purchased_at)` сканирует всю базу данных вместо использования индексов и столбца в его, если можно так выразиться, естественном состоянии.

## MongoDB

### Каковы преимущества MongoDB? Или, другими словами, почему стоит выбрать MongoDB, а не другую реализацию NoSQL?

Преимущества MongoDB заключаются в следующем:

- отсутствие схемы
- легкая масштабируемость
- отсутствие сложных объединений (joins)
- понятная структура отдельного объекта

### В чем разница между SQL и NoSQL?

Основное отличие состоит в том, что базы данных SQL структурированы (данные хранятся в виде таблиц со строками и столбцами - как таблицы Excel), а базы данных NoSQL неструктурированы. Хранение данных в NoSQL БД зависит от настроек БД. Например, данные могут храниться в виде пар ключ-значение, документов и т.д.

### В каких сценариях вы бы предпочли использовать NoSQL/MongoDB вместо SQL?

- Разнородные данные, которые часто меняются
- согласованность и целостность данных не являются главным приоритетом
- базу данных необходимо быстро масштабировать

### Что такое документ? Что такое коллекция?

Документ (document) - это запись в MongoDB, которая хранится в формате BSON (двоичный JSON) и является базовой единицей данных в MongoDB. Коллекция (collection) - это группа связанных документов, хранящихся в одной базе данных MongoDB.

### Что такое агрегатор?

Агрегатор (aggregator) - это платформа в MongoDB, которая выполняет операции с набором данных и возвращает один вычисленный результат.

### Встроенные документы или ссылки: что лучше?

Ответ зависит от конкретного варианта использования базы данных и потребностей приложения. Например, встроенные (embedded) документы обеспечивают атомарные обновления, а ссылочные (referenced) документы обеспечивают лучшую нормализацию.

### Как оптимизировать медленный поиск данных в MongoDB?

Некоторые способы оптимизации поиска данных в MongoDB: индексирование, оптимизация схемы, оптимизация запросов и балансировка нагрузки базы данных.

### В чем разница между `find()` и `find_one()`?

- `find()` возвращает все документы, соответствующие условиям запроса
- `find_one()` возвращает только один документ, соответствующий условиям запроса (или `null`, если совпадение не найдено)

### Как экспортировать данные из MongoDB?

- mongoexport
- языки программирования

## Prometheus

### Что такое Prometheus? Какие возможности он предоставляет?

Prometheus - это популярный набор инструментов для мониторинга систем и оповещения с открытым исходным кодом, первоначально разработанный в SoundCloud. Он предназначен для сбора и хранения данных временных рядов (time-series data), а также позволяет запрашивать и анализировать эти данные с помощью мощного языка запросов под названием PromQL. Prometheus часто используется для мониторинга облачных приложений, микросервисов и другой современной инфраструктуры.

Основные возможности Prometheus:

1. Модель данных (data model). Prometheus использует гибкую модель данных, которая позволяет пользователям организовывать и маркировать свои данные временных рядов таким образом, чтобы это имело смысл для их конкретного случая использования. Метки используются для идентификации различных аспектов данных, таких как источник данных или среда, в которой они были собраны.
2. Архитектура на основе извлечения (pull-based architecture). Prometheus использует модель на основе pull для сбора данных от целей. Это означает, что сервер Prometheus активно запрашивает у своих целей данные метрик через регулярные промежутки времени. Эта архитектура более масштабируема и надежна, чем модель на основе push, которая требует от каждой цели отправлять данные на сервер самостоятельно.
3. База данных временных рядов (time-series database). Prometheus хранит все свои данные в БД временных рядов, что позволяет пользователям выполнять запросы по временным диапазонам, а также агрегировать и анализировать данные разными способами. БД оптимизирована для рабочих нагрузок с большим объемом записи и может обрабатывать большие объемы данных с низкой задержкой.
4. Оповещения (alerting). Prometheus включает в себя мощную систему оповещений, которая позволяет пользователям определять правила на основе метрик и отправлять оповещения при выполнении определенных условий. Оповещения могут отправляться по электронной почте, в чате или по другим каналам, а также могут быть настроены для включения конкретных сведений о проблеме.
5. Визуализация (visualization). Prometheus имеет встроенный инструмент построения графиков и визуализации PromDash, который позволяет пользователям создавать информационные панели для мониторинга систем и приложений. PromDash поддерживает различные типы графиков и варианты визуализации и может быть настроен с помощью CSS и JavaScript.

В целом, Prometheus - это мощный и гибкий инструмент мониторинга и анализа систем и приложений, который широко используется в отрасли для мониторинга и наблюдения за облачными сервисами.

### Опишите архитектуру и компоненты Prometheus

Архитектура Prometheus состоит из четырех основных компонентов:

1. Сервер Prometheus. Сервер Prometheus отвечает за сбор и хранение метрик. Он имеет простое встроенное хранилище, которое позволяет хранить данные временных рядов в упорядоченной по времени БД.
2. Клиентские библиотеки. Prometheus предоставляет несколько клиентских библиотек, которые позволяют приложениям предоставлять метрики в формате, удобном для сервера Prometheus. Эти библиотеки доступны для нескольких языков программирования, включая Java, Python и Go.
3. Экспортеры (exporters). Экспортеры - это программные компоненты, которые предоставляют существующие метрики из сторонних систем и делают их доступными для сервера Prometheus. Prometheus предоставляет экспортеры нескольких популярных технологий, включая MySQL, PostgreSQL и Apache.
4. Alertmanager. Компонент Alertmanager отвечает за обработку сообщений, генерируемых сервером Prometheus. Он может обрабатывать оповещения из нескольких источников и предоставляет ряд функций для дедупликации, группировки и маршрутизации оповещений по соответствующим каналам.

В целом, архитектура Prometheus спроектирована с учетом высокой масштабируемости и отказоустойчивости. Серверные и клиентские библиотеки могут быть развернуты распределенным образом для поддержки мониторинга в крупномасштабных высокодинамичных средах.

### Сравните Prometheus с другими решениями, например, с InfluxDB

По сравнению с другими решениями для мониторинга, такими как InfluxDB, Prometheus известен своей высокой производительностью и масштабируемостью. Он может обрабатывать большие объемы данных и легко интегрируется с другими инструментами в экосистеме мониторинга. InfluxDB, с другой стороны, известен простотой использования. Он имеет удобный интерфейс и предоставляет простые в использовании API для сбора и запроса данных.

Другое популярное решение, Nagios, представляет собой более традиционную систему мониторинга, основанную на модели сбора данных на основе push-уведомлений. Nagios существует уже давно и известен своей стабильностью и надежностью. Однако по сравнению с Prometheus в Nagios отсутствуют некоторые более продвинутые функции, такие как многомерная модель данных (multi-dimensional data model) и мощный язык запросов.

В целом, выбор решения для мониторинга зависит от конкретных потребностей и требований организации. Хотя Prometheus — отличный выбор для крупномасштабного мониторинга и оповещения, InfluxDB может лучше подойти для небольших сред, требующих простоты использования. Nagios является хорошим выбором для организаций, которые отдают предпочтение стабильности и надежности перед расширенным функционалом.

### Что такое оповещение?

В Prometheus оповещение (alert) - это уведомление, которое активируется при достижении определенного условия или порогового значения. Оповещения можно настроить на срабатывание, когда определенные показатели пересекают определенный порог или происходят определенные события. После срабатывания оповещения его можно перенаправить по различным каналам, таким как электронная почта или чат, чтобы уведомить соответствующие группы или отдельных лиц о необходимости принятия соответствующих мер. Оповещения являются важнейшим компонентом любой системы мониторинга, поскольку позволяют командам активно выявлять проблемы и реагировать на них до того, как они повлияют на пользователей или приведут к простою системы.

### Что такое экземпляр? Что такое задание?

В Prometheus экземпляр (instance) - это одна из отслеживаемых целей, например, сервер или служба. Задание (job) - это набор экземпляров, выполняющих одну и ту же функцию, например, набор веб-серверов, обслуживающих одно приложение. Задания позволяют определять и управлять группой целей.

По сути, экземпляр - это отдельная цель, из которой Prometheus собирает метрики, а задание - это набор похожих экземпляров, которыми можно управлять как группой.

### Какие основные типы метрик поддерживает Prometheus?

Prometheus поддерживает несколько типов метрик, в том числе:

1. Счетчик (counter). Монотонно возрастающее значение, используемое для отслеживания количества событий или выборок, например, количество обработанных запросов или обнаруженных ошибок.
2. Индикатор/датчик (gauge). Значение, которое может увеличиваться или уменьшаться, например, загрузка процессора или использование памяти. В отличие от счетчиков, значения индикаторов могут быть динамическими, то есть могут меняться при изменениях в отслеживаемой системе.
3. Гистограмма (histogram). Набор наблюдений или событий, разделенных на сегменты (buckets) в зависимости от значения. Гистограммы помогают анализировать распределение таких показателей, как задержки запросов или размеры ответов.
4. Сводка (summary). Сводка аналогична гистограмме, но вместо сегментов она предоставляет набор квантилей (quantiles) для наблюдаемых значений. Сводки полезны для мониторинга распределения задержек запросов или размеров ответов во времени.

Prometheus также поддерживает различные функции и операторы для агрегирования и управления метриками, такие как сумма, максимум, минимум и скорость. Эти функции делают его мощным инструментом для мониторинга и оповещения о метриках системы.

### Что такое экспортер? Для чего он используется?

Экспортер служит мостом между сторонней системой или приложением и Prometheus, позволяя Prometheus отслеживать и собирать данные из этой системы или приложения. Экспортер действует как сервер, прослушивая определенный сетевой порт на предмет запросов от Prometheus на получение метрик. Он собирает метрики из сторонней системы или приложения и преобразует их в формат, понятный Prometheus. Затем экспортер предоставляет эти метрики Prometheus через конечную точку HTTP, делая их доступными для сбора и анализа.

Экспортеры обычно используются для мониторинга различных типов компонентов инфраструктуры, таких как базы данных, веб-серверы и системы хранения данных. Например, существуют экспортеры для мониторинга популярных БД, таких как MySQL и PostgreSQL, а также веб-серверов, таких как Apache и Nginx.

Экспортеры являются важнейшим компонентом экосистемы Prometheus, позволяющим отслеживать широкий спектр систем и приложений, обеспечивая высокую степень гибкости и расширяемости платформы.

### Назовите лучшие практики использования Prometheus

1. Тщательная маркировка. Тщательная и последовательная маркировка метрик имеет решающее значение для их эффективного сбора и оповещения. Метки должны быть четкими, краткими и включать всю необходимую информацию о показателе.
2. Простота метрик. Метрики, предоставляемые экспортерами, должны быть простыми и фокусироваться на одном аспекте отслеживаемой системы. Это помогает избежать путаницы и гарантирует, что метрики будут легко понятны всем членам команды.
3. Экономное использование оповещений. Хотя оповещения являются мощной функцией Prometheus, их следует использовать умеренно и только для самых критических проблем. Настройка слишком большого количества оповещений может привести к перенасыщению и игнорированию важных сообщений. Рекомендуется настраивать только самые важные оповещения и корректировать пороговые значения с течением времени в зависимости от фактической частоты уведомлений.

### Как получить общее количество запросов за определенный период времени?

Чтобы получить общее количество запросов за определенный период времени с помощью Prometheus можно использовать функцию `sum()` вместе с функцией `rate()`. Пример запроса, который вернет общее количество запросов за последний час:

```
sum(rate(http_requests_total[1h]))
```

В этом запросе `http_requests_total` - это название метрики, которая отслеживает общее количество HTTP-запросов, а функция `rate()` вычисляет посекундную частоту запросов. Затем функция `sum()` суммирует все запросы и возвращает их общее количество за последний час.

Временной диапазон можно настроить, изменив продолжительность в функции `rate()`. Например, общее количество запросов за последний день можно получить с помощью `rate(http_requests_total[1d])`.

### Что означает HA в Prometheus?

HA означает High Availability (высокую доступность). Это означает, что система спроектирована так, чтобы быть надежной и доступной, даже в случае сбоев или других проблем. На практике это обычно включает в себя настройку нескольких экземпляров Prometheus и обеспечение их синхронизации и возможности беспрепятственной совместной работы. Этого можно достичь с помощью различных методов, таких как балансировка нагрузки, репликация (replication) и механизмы аварийного переключения. Внедрение HA в Prometheus гарантирует, что данные мониторинга всегда будут доступны и актуальны, даже в случае сбоев оборудования или программного обеспечения, проблем с сетью или других проблем, которые могут привести к простою или потере данных.

### Как объединить две метрики?

В Prometheus объединение двух метрик выполняется с помощью функции `join()`. `join()` объединяет два или более временных ряда на основе значений их меток. Она принимает два обязательных аргумента: `on` и `table`. Аргумент `on` указывает метрики для объединения, а аргумент `table` - временной ряд для объединения. Пример объединения двух метрик с помощью функции `join()`:

```
sum_series(
  join(
    on(service, instance) request_count_total,
    on(service, instance) error_count_total,
  )
)
```

В этом примере функция `join()` объединяет временные ряды `request_count_total` и `error_count_total` на основе значений их меток `service` и `instance`.

### Как написать запрос, который возвращает значение метки?

Чтобы написать запрос, возвращающий значение метки в Prometheus, можно использовать функцию `label_values()`. Она принимает два аргумента: название метки и название метрики. Например, если у нас есть метрика `http_requests_total` с меткой `method`, и мы хотим получить все значения этой метки, можно использовать следующий запрос:

```
label_values(http_requests_total, method)
```

Этот запрос вернет список всех значений метки `method` в метрике `http_requests_total`. Этот список можно использовать в последующих запросах или для фильтрации данных.

### Как преобразовать `cpu_user_seconds` в процент использования ресурсов процессора?

Чтобы преобразовать `cpu_user_seconds` в загрузку процессора в процентах, сначала необходимо разделить его на общее затраченное время и количество ядер ЦП, а затем умножить на 100. Формула:

```
100 * sum(rate(process_cpu_user_seconds_total{job="<job-name>"}[<time-period>])) by (instance) / (<time-period> * <num-cpu-cores>)
```

Здесь указывается название задания (`job-name`), временной диапазон (`time-period`) (например, `5m` - 5 минут, `1h` - 1 час), которые мы хотим запросить, и количество ядер процессора на запрашиваемой машине.

Например, для того, чтобы получить процент использования ЦП за последние 5 минут для задания `my-job`, выполняемого на компьютере с 4 ядрами процессора, можно использовать следующий запрос:

```
100 * sum(rate(process_cpu_user_seconds_total{job="my-job"}[5m])) by (instance) / (5m * 4)
```

## OpenStack

### За что отвечают сервисы/проекты Nova, Neutron, Cinder, Glance и Keystone?

- Nova - управление виртуальными экземплярами
- Neutron - управление сетью, предоставление сети как услуги (Network as a Service, NaaS)
- Cinder - хранилище блоков
- Glance - управление образами виртуальных машин и контейнеров (поиск, получение и регистрация)
- Keystone - служба аутентификации в облаке

### Сопоставление сервиса/проекта и назначения

- Glance - сервис образов. Также используется для копирования или создания снимков
- Horizon - графический интерфейс для просмотра и модификации ресурсов
- Cinder - хранилище блоков
- Nova - управление виртуальными экземплярами

### Опишите Nova

- Используется для предоставления виртуальных экземпляров и управления ими
- поддерживает мультитенантность (Multi-Tenancy) на разных уровнях - ведение журнала, контроль конечных пользователей, аудит и т.д.
- высокая масштабируемость
- аутентификация может быть выполнена с использованием внутренней системы или LDAP
- поддержка нескольких типов блочного хранилища
- стремление к независимости от аппаратного обеспечения и гипервизора (hypervisor)

### Что вы знаете об архитектуре и компонентах Nova?

- nova-api - сервер, который обслуживает метаданные и вычисляет API
- различные компоненты Nova взаимодействуют между собой, используя очередь (обычно RabbitMQ) и базу данных
- запрос на создание экземпляра проверяется nova-scheduler, который определяет, где экземпляр будет создан и запущен
- nova-compute - компонент, отвечающий за связь с гипервизором для создания экземпляра и управления его жизненным циклом

### С какими типами прокси Nova вы знакомы?

- Nova-novncproxy — доступ через несколько соединений VNC
- Nova-spicehtml5proxy — доступ через SPICE
- Nova-xvpvncproxy — доступ через одно соединение VNC

### Опишите Neutron

- Один из основных компонентов OpenStack и отдельный проект
- ориентирован на предоставление сети как услуги (Network as a Service, NaaS)
- позволяет пользователям настраивать сети в облаке, а также настраивать и управлять различными сетевыми сервисами
- взаимодействует с:
  - Keystone - авторизация вызовов API
  - Nova - подключение сетевых карт к сети
  - Horizon - поддерживает сетевые объекты в панели мониторинга (dashboard), а также предоставляет топологическое отображение (topology view), включающее сведения о сети

### Из каких компонентов состоит Neutron?

- neutron-l3-agent - переадресация L3/NAT (например, обеспечение доступа к внешней сети для виртуальных машин)
- neutron-dhcp-agent - службы DHCP
- neutron-metering-agent - измерение трафика L3
- neutron-*-agtent - управляет локальной конфигурацией vSwitch на каждом компьютере (в зависимости от выбранного плагина)
- neutron-server - предоставляет сетевой API и при необходимости передает запросы другим плагинам

### Какие типы сетей используются в OpenStack?

- Сеть управления (management network) - используется для внутренней связи между компонентами OpenStack
- гостевая сеть (guest network) - используется для связи между экземплярами/виртуальными машинами
- сеть API (API network) - используется для связи служб API
- внешняя сеть (external network) - используется для публичной коммуникации. Любой IP-адрес в этой сети доступен любому пользователю в Интернете

### В каком порядке следует удалять следующие сущности: сеть, порт, маршрутизатор, подсеть?

- Порт
- подсеть
- маршрутизатор
- сеть

Для этого есть много причин. Например, мы не можем удалить маршрутизатор, если ему назначены активные порты.

### Опишите Glance

- Glance - это сервис образов (image service) OpenStack
- он обрабатывает запросы, связанные с экземплярами дисков и образов
- он также используется для создания снимков (snapshots) для быстрого резервного копирования экземпляров
- пользователи могут использовать Glance для создания новых образов или загрузки существующих

### Опишите архитектуру Glance

- glance-api - отвечает за обработку вызовов API образов, таких как поиск и хранение. Он состоит из двух API: API реестра (registry-api) - отвечает за внутренние запросы; пользовательский API (user API) - доступен публично
- glance-registry - отвечает за обработку запросов метаданных образов (размера, типа и т.д.). Этот компонент является частным, т.е. недоступен публично
- служба определения метаданных (metadata definition service) - API для пользовательских метаданных
- база данных - хранение метаданных образов
- репозиторий образов - хранение образов. Это может быть файловая система, хранилище объектов Swift, HTTP и т.д.

### Опишите Swift

- Swift - это служба хранилища объектов, высокодоступное, распределенное и согласованное хранилище, предназначенное для хранения большого количества данных
- Swift распределяет данные по нескольким серверам и записывает их на несколько дисков
- для масштабирования кластера можно добавлять дополнительные серверы. При этом обеспечивается целостность информации и репликация (replication) данных

### Могут ли пользователи по умолчанию хранить объект размером 100 ГБ?

По умолчанию не могут. API хранилища объектов ограничивает максимальный размер 5 ГБ на объект, но это можно изменить.

### Что такое контейнер, аккаунт и объект применительно к Swift?

- Контейнер (container) определяет пространство имен (namespace) для объектов
- аккаунт (account) определяет пространство имен для контейнеров
- объект (object) - содержимое данных (изображение, документ и т.п.)

### В одном контейнере может быть два объекта с одинаковым названием: правда или ложь?

Ложь. Два объекта могут иметь одинаковое название, только если они находятся в разных контейнерах.

### Опишите Cinder

- Cinder - это служба блочного хранилища OpenStack
- он предоставляет ресурсы хранилища, которые могут использоваться другими сервисами, такими как Nova
- одной из наиболее часто используемых реализаций хранилища, поддерживаемых Cinder, является LVM
- пользователь не знает, где за кулисами находится хранилище или какой тип хранилища используется

### Опишите компоненты Cinder

- cinder-api - получает запросы API
- cinder-volume - управляет подключенными блочными устройствами
- cinder-scheduler - отвечает за хранение томов (volumes)

### Опишите Keystone

- Нельзя развернуть OpenStack без Keystone
- он предоставляет службы идентификации, политик безопасности и токенов
  - аутентификация предназначена как для пользователей, так и для служб
  - поддерживается авторизация на основе токенов и пользователей
- существует политика, определенная на основе RBAC, хранящаяся в файле JSON, и каждая строка в этом файле определяет уровень доступа, который необходимо применить

### Опишите концепции Keystone

- Роль (role) - список прав и привилегий, определяющий, что может делать пользователь или проект
- арендатор/проект (tenant/project) — логическое представление группы ресурсов, изолированной от других групп. Это может быть аккаунт, организация и т.п.
- служба (service) - конечная точка, которую пользователь может использовать для доступа к различным ресурсам
- конечная точка (endpoint) - сетевой адрес для доступа к определенному сервису OpenStack
- токен (token) - используется для доступа к ресурсам при описании того. К каким ресурсам можно получить доступ определяется областью действия (scope) токена

### Опишите архитектуру Keystone

- Существуют API служб и API администратора, через которые Keystone получает запросы
- Keystone имеет четыре бэкэнда:
  - Token Backend - временные токены для пользователей и сервисов
  - Policy Backend - управление политиками безопасности и авторизацией
  - Identity Backend - пользователи и группы (автономная БД, LDAP и др.)
  - Catalog Backend - конечные точки
- Он имеет подключаемую среду, в которую можно интегрировать:
  - LDAP
	- KVS (хранилище ключ-значение)
	- SQL
	- PAM
	- Memcached

### Опишите процесс аутентификации Keystone

- Keystone получает запрос и проверяет, поступил ли он от авторизованного пользователя, используя имя пользователя, пароль и authURL
- после подтверждения Keystone предоставляет токен
- токен содержит список проектов, доступных пользователю, поэтому нет необходимости каждый раз проходить аутентификацию

### Как идентифицируется сервис?

- Название
- идентификатор
- тип
- описание

### Что такое PublicURL, InternalURL и AdminURL?

- PublicURL - адрес, доступный любому пользователю Интернета
- InternalURL используется для связи между службами
- AdminURL используется для административного управления

### Что такое каталог сервисов?

Список сервисов и их конечных точек.

### Назовите и опишите несколько сервисов OpenStack

- Swift - высокодоступное, распределенное, согласованное хранилище объектов/blob
- Sahara - служба управления кластерами Hadoop
- Ironic - служба обеспечения "голым" (bare) железом
- Trove - база данных как сервис, работающий на OpenStack
- Aodh - служба оповещения
- Ceilometer - служба отслеживания и мониторинга использования

### Сопоставьте службы и назначения

- База данных как сервис, работающий на OpenStack - Trove
- обеспечение "голым" (bare) железом - Ironic
- отслеживание и мониторинг использования - Ceilometer
- служба оповещения - Aodh
- управление кластерами Hadoop - Sahara
- высокодоступное, распределенное, согласованное хранилище объектов/blob - Swift

### Опишите Horizon

- Horizon - это проект на основе Django, ориентированный на предоставление информационной панели OpenStack и возможности создания дополнительных настраиваемых информационных панелей
- он может использоваться для доступа к различным ресурсам сервисов OpenStack - экземплярам, образам, сетям и т.д.
  - получив доступ к панели управления, пользователи могут использовать ее для перечисления, создания, удаления и изменения различных ресурсов
- он также легко настраивается, поэтому мы можем легко изменять и дополнять его в соответствии с нашими потребностями

### Опишите архитектуру Horizon

- Horizon API является обратно совместимым
- существует три типа панелей мониторинга: пользовательские, системные и панель настроек
- базовая поддержка всех основных проектов OpenStack: Neutron, Nova и др. (из коробки, нет необходимости устанавливать дополнительные пакеты или плагины)
- любой может расширять информационные панели и добавлять новые компоненты
- Horizon предоставляет шаблоны и основные классы, на основе которых можно построить собственную панель мониторинга

## Puppet

### Что такое Puppet?

Puppet - это инструмент управления конфигурацией (configuration management tool), обеспечивающий настройку всех систем до желаемого и предсказуемого состояния.

### Опишите архитектуру Puppet

Puppet имеет архитектуру первично-вторичного узла (primary-secondary node). Клиенты распределены по сети и взаимодействуют с первично-вторичной средой, в которой присутствуют модули Puppet. Агент клиента отправляет сертификат со своим идентификатором на сервер. Сервер подписывает этот сертификат и возвращает его клиенту. Эта аутентификация обеспечивает безопасную и надежную связь между клиентом и сервером.

### Сравните Puppet с другими инструментами управления конфигурациями

Puppet часто сравнивают с другими инструментами управления конфигурацией, такими как Chef, Ansible, SaltStack и cfengine. Выбор Puppet часто обуславливается такими потребностями организации, как простота использования, масштабируемость и поддержка сообщества.

### Что такое модуль, манифест и узел?

- Модуль (module) - это набор манифестов (manifests), шаблонов (templates) и файлов
- манифест - это код (code) для настройки клиента
- узел (node) позволяет устанавливать конфигурацию, специфичную для конкретного узла

### Что такое Facter?

Facter - это автономный инструмент Puppet, который собирает информацию о системе и ее конфигурации, такую ​​как операционная система, IP-адреса, память и сетевые интерфейсы. Эта информация используется в манифестах Puppet для принятия решений о том, как следует управлять ресурсами, а также для настройки поведения Puppet на основе характеристик системы. Facter интегрирован в Puppet, и его данные можно использовать в манифестах Puppet для принятия решений об управлении ресурсами.

### Что такое MCollective?

MCollective - это промежуточное программное обеспечение (посредник - middleware), которое интегрируется с Puppet для обеспечения оркестрации, удаленного и параллельного выполнения заданий (jobs).

### Что такое Hiera?

Hiera - это иерархическое хранилище данных в Puppet, которое используется для отделения данных от кода, что упрощает разделение, управление и повторное использование данных.

## Elastic

### Что такое Elastic Stack?

Elastic Stack состоит из:

- Elasticsearch
- Kibana
- Logstash
- Beats
- Elastic Hadoop
- APM Server

Elasticsearch, Logstash и Kibana также известны как стек ELK.

### Что такое Elasticsearch?

Elasticsearch - это распределенное хранилище документов (distributed document store). Вместо хранения информации в виде таблиц Elasticsearch хранит сложные структуры данных, сериализованные в документы JSON.

### Что такое Logstash?

Logstash - это мощный и гибкий конвейер (pipeline), который собирает, обогащает (enriches) и транспортирует данные. Он работает как инструмент извлечения, преобразования и загрузки (extract, transform, load - ETL) отчетов (логов).

### Что такое beats?

Beats - это легкие поставщики (snippets) данных. Они устанавливаются на клиенте, где находятся данные. Примеры beats: Filebeat, Metricbeat, Auditbeat.

### Что такое Kibana?

Kibana - это платформа аналитики и визуализации с открытым исходным кодом, предназначенная для работы с Elasticsearch. Она используется для поиска, просмотра и взаимодействия с данными, хранящимися в индексах Elasticsearch. Kibana позволяет легко выполнять расширенный анализ данных и визуализировать их в виде диаграмм, таблиц и карт.

### Опишите процесс записи и отображения информации на информационной панели при использовании стека Elastic

Этот процесс может варьироваться в зависимости от выбранной архитектуры и обработки, которая применяется к журналам (логам). Один из возможных вариантов:

1. Логи приложения собираются с помощью Filebeat и отправляются в Logstash.
2. Logstash обрабатывает логи на основе определенных фильтров, результаты обработки отправляются в Elasticsearch.
3. Elasticsearch сохраняет полученный документ и индексирует его для быстрого доступа в будущем.
4. Пользователь создает визуализации в Kibana на основе проиндексированных данных.
5. Пользователь создает панель мониторинга, включающую визуализации, созданные на предыдущем шаге.

### Что такое узел данных?

Узел данных (data node) - это место, в котором хранятся и обрабатываются (например, при поиске) данные.

### Что такое главный узел?

Часть обязанностей главного узла (master node):

- Отслеживание состояния всех узлов кластера
- обеспечение работоспособности реплик (replicas) и доступности данных в каждом узле данных (data node)
- обеспечение отсутствия горячих узлов (hot nodes) - узлов, которые выполняют гораздо больше работы, чем другие

### Что такое узел приема?

Узел приема (ingest node) - это узел, отвечающий за обработку данных в соответствии с конвейером приема (ingest pipeline). Этот узел может получать данные из Beats и обрабатывать их аналогично тому, как это делает Logstash.

### Что такое координационный узел?

Координационный узел (coordinating only node) может быть полезен большим кластерам, принимая на себя роль координирующего узла от узлов данных и узлов, претендующих на статус главных узлов (master-eligible nodes). Они подключаются к кластеру и получают полное состояние кластера, как и любой другой узел, и используют состояние кластера для маршрутизации запросов непосредственно в пункты назначения.

### Как данные хранятся в Elasticsearch?

- Данные хранятся в индексе
- Индекс распределяется по кластеру с помощью сегментов (shards)

### Что такое индекс?

Индекс в Elasticsearch в большинстве случаев сравнивают со всей базой данных SQL/NoSQL.

Можно выбрать один индекс для хранения всех данных приложения или несколько индексов, где каждый индекс будет содержать разные типы данных приложения (например, индекс для каждой службы, которая выполняется в приложении).

Вот как индекс определяется в официальной документации:

"Индекс можно рассматривать как оптимизированную коллекцию документов, в которой каждый документ представляет собой набор полей, которые представляют собой пары ключ-значение, содержащие ваши данные".

### Что такое сегменты?

Индекс разбивается на сегменты (shards), и документы хешируются с конкретным сегментом. Каждый сегмент может находиться на отдельном узле кластера и представляет собой автономный индекс. Это позволяет Elasticsearch масштабироваться до целого кластера серверов.

### Что такое инвертированный индекс?

Инвертированный индекс (inverted index) перечисляет каждое уникальное слово, встречающееся в любом документе, и идентифицирует все документы, в которых встречается каждое слово.

### Что такое документ?

Продолжая сравнение с SQL/NoSQL, документ (document) в Elasticsearch - это строка в таблице в случае SQL или документ в коллекции в случае NoSQL. Как и в NoSQL, документ представляет собой объект JSON, содержащий единицу данных приложения. Что это за единица зависит от документа. Если приложение связано с книгами, тогда каждый документ описывает книгу. Если приложение связано с рубашками, то каждый документ - это рубашка.

### Что означает красный, желтый и зеленый статусы в Elasticsearch?

Красный статус означает, что некоторые данные недоступны в кластере. Некоторые сегменты индексов не назначены. Желтый означает, что в кластере есть неназначенные сегменты. Этот статус может означать,что у нас есть один узел и наши индексы имеют реплики (replicas). Зеленый означает, что все сегменты в кластере назначены узлам и кластер полностью работоспособен.

### Elasticsearch индексирует все данные в каждом поле, и каждое индексированное поле имеет одинаковую структуру данных для унифицированных и быстрых запросов: правда или ложь?

Ложь. Из официальной документации:

"Каждое индексированное поле имеет специальную оптимизированную структуру данных. Например, текстовые поля хранятся в инвертированных индексах, а числовые и географические поля - в деревьях BKD".

### Какие зарезервированные поля имеются в документе?

- _index
- _id
- _type

### Каковы преимущества определения собственной карты (map)?

- Можно оптимизировать поля для частичного совпадения (partial mapping)
- можно определить собственные форматы (например, даты)
- можно выполнить языковой анализ

### Что такое реплики?

В сетевой/облачной среде, где сбои можно ожидать в любой момент, очень полезно и настоятельно рекомендуется иметь механизм аварийного переключения (failover mechanism) на случай, если сегмент/узел (shard/node) отключится или исчезнет. С этой целью Elasticsearch позволяет превратить одну или несколько копий фрагментов индекса в так называемые фрагменты реплик (replica shards) или, для краткости, реплики (replicas).

### Что такое частота терминов и частота документов?

Частота термина (term frequency) - это то, как часто термин встречается в данном документе, а частота документа (document frequency) - это то, как часто термин встречается во всех документах. Они используются для определения релевантности термина путем деления частоты термина на частоту документа.

### Мы проверяем "Current phase" (текущую фазу) в разделе "Index lifecycle management" (управление жизненным циклом индекса) и видим, что установлено значение "hot" (горячий). Что это значит?

Это значит, что индекс активно записывается.

### Что делает команда `curl -X PUT "localhost:9200/customer/_doc/1?pretty" -H 'Content-Type: application/json' -d'{ "name": "John Doe" }'`?

Она создает индекс `customer`, если он не существует, и добавляет новый документ с полем `name`, для которого установлено значение `"John Doe"`. Если это первый документ, он получит идентификатор `1`.

### Что произойдет, если мы выполним предыдущую команду дважды? А как насчет того, чтобы выполнить ее 100 раз?

1. Если значение поля `name` будет другим, это поле будет обновлено новым значением.
2. Версия поля (field version) увеличивается на единицу при выполнении любой операции.

### Что такое Bulk API? Для чего он используется?

Bulk API используется для одновременной индексации нескольких документов. Он позволяет группировать запросы по каждому документу в один массовый (bulk) запрос, что снижает нагрузку на сеть и сервер.

### Что такое контекст запроса? А контекст фильтра?

В контексте запроса (query context) содержится ответ на вопрос "Насколько хорошо этот документ соответствует этому запросу?". Также в контексте запроса (в поле `_score`) содержится оценка релевантности документа.

В контексте фильтра (filter context) содержится ответ на вопрос "Соответствует ли этот документ этому запросу?" Ответ прост: "Да" или "Нет" - баллы не подсчитываются. Контекст фильтра в основном используется для фильтрации структурированных данных.

### Опишите, чем архитектура производственной среды с большими объемами данных будет отличаться от маломасштабной (small-scale) среды

Один из возможных ответов заключается в следующем.

Небольшая архитектура Elastic будет состоять из стека Elastic как такового. Это означает, что у нас будут Beats, Logstash, Elastcsearch и Kibana.

Производственная среда с большими объемами данных может включать в себя какой-либо компонент буферизации (например, Reddis или RabbitMQ), а также компонент безопасности, такой как Nginx.

### Какие типы плагинов Logstash существуют?

- Плагины ввода (input plugins) определяют, как собирать данные из разных источников
- плагины фильтров (filter plugins) отвечают за обработку данных
- плагины вывода (output plugins) передают данные на различные выходы/сервисы/платформы

### Что такое Grok?

Grok - это плагин Logstash, который модифицирует информацию в одном формате и погружает (immerse) ее в другой.

### Что находится в разделе "Discover" в Kibana?

Необработанные данные (raw data) в том виде, в каком они хранятся в индексе. Их можно фильтровать, по ним можно выполнять поиск.

### Мы нажали "Discover" в Kibana и видим "561 hits". Что это значит?

Общее количество документов, соответствующих критериям поиска. Если запрос (query) не используется, то это просто общее количество документов.

### Что находится в разделе "Visualize" в Kibana?

"Visualize" позволяет создавать визуальные представления данных (круговые диаграммы, графики и т.д.).

### Что такое Filebeat?

Filebeat используется для мониторинга каталогов журналов (logging directories) внутри виртуальных машин или монтируется в качестве вспомогательного устройства при экспорте журналов из контейнеров, а затем пересылает эти журналы для дальнейшей обработки, обычно в Logstash.

### Обязательно ли использовать Filebeat при использовании ELK? В каких сценариях полезно использовать Filebeat?

Filebeat - типичный компонент стека ELK, поскольку он был разработан Elastic для работы с другими продуктами (Logstash и Kibana). Можно отправлять журналы непосредственно в Logstash, хотя это часто требует внесения изменений в код приложения. Использование Filebeat может быть лучшим вариантом, особенно для устаревших приложений с небольшим тестовым покрытием (test coverage), поскольку нам не нужно вносить какие-либо изменения в код приложения.

### Один комбайн (harvester) собирает несколько файлов в соответствии с ограничениями, установленными в filebeat.yml: правда или ложь?

Ложь. Один комбайн собирает один файл.

### Что такое модули Filebeat?

Модули Filebeat - это предварительно настроенные модули для определенных типов мест регистрации журналов (например, Traefik, Fargate, HAProxy), которые упрощают настройку пересылки журналов с помощью Filebeat. Они имеют разные конфигурации в зависимости от того, откуда собираются отчеты.

### Как защитить стек Elastic?

Мы можем создавать сертификаты с помощью утилит Elastic и изменить конфигурацию, чтобы включить безопасность с использованием модели сертификатов.

## Packer

### Что такое Packer? Для чего он используется?

В целом, Packer автоматизирует создание образов машин. Это позволяет нам сосредоточиться на настройке перед развертыванием при создании образов. В большинстве случаев это позволяет запускать экземпляры намного быстрее.

### Какой модели следует Packer: "конфигурация->развертывание" или "развертывание->конфигурация"?

Packer следует модели "конфигурация->развертывание", которая имеет следующие преимущества:

1. Скорость развертывания - настройка выполняется один раз перед развертыванием, а не при каждом развертывании. Это позволяет запускать экземпляры/сервисы намного быстрее.
2. Более стабильная инфраструктура - при "настройке->развертывании" развертывания вряд ли будут сильно различаться, поскольку большая часть настройки выполняется до развертывания.
