# Contributing

When contributing to this repository, please first discuss the change you wish to make via issue,
email, or any other method with the owners of this repository before making a change. 

Please note we have a code of conduct. Please follow it in all your interactions with the project.

## Rules
1. [Clean architecture](https://learn.microsoft.com/en-us/dotnet/architecture/modern-web-apps-azure/common-web-application-architectures#clean-architecture) is the primary principle at YATsDb.
1. Thus it is good to make micro-optimization for better speed and less memory usage. For example, use for loop instead of a foreach iteration.
1. Add unit tests that cover the functionality of your changes including edge cases.
1. By contributing YATsDb, you agree that your changes are included in YATsDb with the [BSD 3-Clause License](https://github.com/harrison314/YATsDb?tab=BSD-3-Clause-1-ov-file#readme). This license agreement cannot be undone.
1. Make sure you are not violating some other 3rd party licenses with your contribution. For example, don't copy source code from other open source or commercial software without adding the necessary LICENSE copyright notice!
1. Rules are subject to change. Please add your complaints and suggestions to the discussion page.
