<img align="left" src="https://user-images.githubusercontent.com/28951144/190144379-364185ea-3e3e-4f41-87fd-9581acfc7f7f.png" width="64" height="64"></img>

<h1 align="left">Harmonoid</h1>

**🎵 Plays & manages your music library. Looks beautiful & juicy.**

[Website](https://harmonoid.com) • [Download](https://harmonoid.com/downloads) • [Discord](https://discord.gg/2Rc3edFWd8) • Available for Windows, Linux & Android!

![](https://github.com/harmonoid/harmonoid/blob/assets/win32/0.webp?raw=true)
![](https://github.com/harmonoid/harmonoid/blob/assets/win32/1.webp?raw=true)
![](https://github.com/harmonoid/harmonoid/blob/assets/win32/2.webp?raw=true)
![](https://github.com/harmonoid/harmonoid/blob/assets/win32/3.webp?raw=true)

## Videos

Enjoy that 🧈 buttery experience.

https://user-images.githubusercontent.com/28951144/220771329-de074abb-41c6-4168-910a-d9e973f68421.mp4

https://user-images.githubusercontent.com/28951144/220771351-c58f125c-6495-4a06-8109-77fd8f061db1.mp4

## Features

- Music library management based on metadata tags.
- Capable of indexing 30+ files/second & saves cache for future app start-ups.
- Very strictly follows Material Design guidelines for UI & animations.
- mpv based music playback for strong format support (on Linux & Windows) using `dart:ffi`.
- Taskbar & System Media Transport Controls for Windows.
- D-Bus MPRIS controls for Linux.
- Small installer (≈ 35 MB) & low RAM usage (≈ 150 MB).
- Time synced lyrics for all your music.
- Ability to create persistent or "Now playing" playlists.
- Context menu integrations & file associations (exclusive to setup version).
- Discord RPC integration with album art support & "Find"/"Listen" buttons.
- Portable (if you wish).
- Pitch shifting.
- Volume boost.
- Speed adjustment.
- Details editor.
- Cross-platform (currently aiming Windows, Linux & Android).
- Does not use electron.js.
- Music visuals.
- Metadata reader.
- Gapless playback.
- Multiple artist support.
- Online URLs player.
- .LRC file compatibility (mannual loading or automatic lookup in folder).
- Fallback cover support. e.g. `cover.jpg`, `Folder.jpg` etc.
- User specific libmpv flags & options.
- Window position & maximize state remembering.
- Excellent backward compatibility. Windows 7 or higher. Android 5.0 or higher.
- Built-in YouTube Music client.

## Why

It's really hard to find software with good design & animations on desktop. It's almost like desktop app developers don't have faith in adding animations to their UI. Other music players, which look kind-of good don't work properly, refuse to support an audio format, read tags incorrectly, don't have my favorite feature or simply use [electron.js](https://electronjs.org).

Harmonoid very strictly implements [Material Design](https://user-images.githubusercontent.com/28951144/187515841-265b2f6e-4ee3-4db5-b06d-0f7f5d684da9.webm) to be a consistent, cohesive & modern music player for all platforms.

There are no inconsistent paddings, spacings or weird alignments to make me feel uncomfortable. It's built with care & proper time is given to everything. Learn more about the project on [official website](https://harmonoid.com/) [until I can afford this domain].

## Supporters

### Patreons

- [Oleks](https://www.patreon.com/user/creators?u=28979760) • 4.50 € per month.
- [Tse Loki](https://www.patreon.com/user/creators?u=2866352) • 2 € per month.

## Support

If you enjoy using this music player, please consider buying me a coffee.

- [PayPal](https://paypal.me/alexmercerind)
- [Patreon](https://patreon.com/harmonoid)
- [GitHub Sponsors](https://github.com/sponsors/alexmercerind)

## Planned Features

May be found at: [What's next for Harmonoid? & Release Goals](https://github.com/harmonoid/harmonoid/issues/348).

## Mobile

<table>
  <tr>
    <td>
      <img src='https://github.com/harmonoid/harmonoid/blob/assets/android/0.webp?raw=true'>
    </td>
    <td>
      <img src='https://github.com/harmonoid/harmonoid/blob/assets/android/1.webp?raw=true'>
    </td>
    <td>
      <img src='https://github.com/harmonoid/harmonoid/blob/assets/android/2.webp?raw=true'>
    </td>
    <td>
      <img src='https://github.com/harmonoid/harmonoid/blob/assets/android/3.webp?raw=true'>
    </td>
  </tr>
  <tr>
    <td>
      <img src='https://github.com/harmonoid/harmonoid/blob/assets/android/4.webp?raw=true'>
    </td>
    <td>
      <img src='https://github.com/harmonoid/harmonoid/blob/assets/android/5.webp?raw=true'>
    </td>
    <td>
      <img src='https://github.com/harmonoid/harmonoid/blob/assets/android/6.webp?raw=true'>
    </td>
    <td>
      <img src='https://github.com/harmonoid/harmonoid/blob/assets/android/7.webp?raw=true'>
    </td>
  </tr>
</table>

## Translate

You can help me by adding or updating translations for Harmonoid at [harmonoid/translations](https://github.com/harmonoid/translations) repository.

## License

Harmonoid & the source code in this repository is under [End-User License Agreement for Harmonoid](https://github.com/harmonoid/harmonoid/blob/master/EULA.txt?raw=true).
