> 本文内容参考资料为《深度学习》和《解析卷积神经网络》两本书，以及部分网络资料。

## 前言

机器学习中的一个核心问题是设计不仅在训练数据上表现好，并且能在新输入（测试集）上泛化好的算法。

**通过对学习算法的修改，旨在显示地减少泛化误差（可能会以增大训练误差为代价）的策略被称为正则化**，**正则化是一种思想（策略）**。

目前有许多正则化策略。有些策略向机器学习模型添加限制参数值的额外约束。有些策略向目标函数增加额外项来对参数值进行软约束。如果我们细心选择，这些额外的约束和惩罚可以改善模型在测试集上的表现。有时侯，这些 约束和惩罚被设计为编码特定类型的先验知识; 其他时候，这些约束和惩罚被设计为偏好简单模型，以便提高泛化能力。有时惩罚和约束对于确定一个未确定的问题是必要的。其他形式的正则化，如被称为集成的方法，则结合多个假说来解释训练数据。
> 《深度学习》第五章介绍了**泛化、欠拟合、过拟合、偏差、方差和正则化**的基本概念。

## 网络参数范数惩罚

许多正则化方法通过对目标函数 $J$ 添加一个**参数范数惩罚** $\Omega (\theta )$，限制模型（如神经网络、线性回归或逻辑回归）的学习能力。我们将正则化后的目标函数记为 $\tilde{J}$：

$$\tilde{J}(\theta; X,y) = J(\theta; X,y) + \alpha \Omega (\theta )$$

$\alpha $ 为 0 则没有正则化，$\alpha $ 越大，对应正则化惩罚越大。

### L2 参数正则化

`L2` 参数正则化策略通过向目标函数添加一个正则项 $\Omega (\theta ) = \frac{1}{2} \left \| w \right \|_{2}^{2} $，使权重更加接近原点。在其他学术圈，`L2` 正则化也被称为岭回归或 Tikhonov 正则。


## 参考资料

- 《深度学习-第七章 深度学习中的正则化》
- 《解析卷积神经网络-章 10 网络正则化》