---
layout: post
title: 深度学习数学基础-概率与信息论
date: 2022-11-01 23:00:00
summary: 概率论是用于表示不确定性声明的数学框架。它不仅提供了量化不确定性的方法，也提供了用于导出新的不确定性声明（statement）的公理。概率论的知识在机器学习和深度学习领域都有广泛应用，是学习这两门学科的基础。
categories: DeepLearning
---

- [前言](#前言)
  - [概率论学科定义](#概率论学科定义)
  - [概率与信息论在人工智能领域的应用](#概率与信息论在人工智能领域的应用)
- [3.1，为什么要使用概率论](#31为什么要使用概率论)
- [3.2，随机变量](#32随机变量)
- [3.3，概率分布](#33概率分布)
  - [3.3.1，离散型变量和概率质量函数](#331离散型变量和概率质量函数)
  - [3.3.2，连续型变量和概率密度分布函数](#332连续型变量和概率密度分布函数)
- [3.4，边缘概率](#34边缘概率)
- [3.5，条件概率](#35条件概率)
  - [3.5.1，条件概率的链式法则](#351条件概率的链式法则)
  - [3.6，独立性和条件独立性](#36独立性和条件独立性)
- [3.7，条件概率、联合概率和边缘概率总结](#37条件概率联合概率和边缘概率总结)
- [3.8，期望、方差和协方差](#38期望方差和协方差)
  - [3.8.1，期望](#381期望)
    - [期望数学定义](#期望数学定义)
    - [期望应用](#期望应用)
    - [总体均值数学定义](#总体均值数学定义)
  - [3.8.2，方差](#382方差)
    - [方差数学定义](#方差数学定义)
    - [总体方差数学定义](#总体方差数学定义)
  - [3.8.3，期望与方差的运算性质](#383期望与方差的运算性质)
  - [3.8.4，协方差](#384协方差)
    - [协方差数学定义](#协方差数学定义)
- [3.9，常用概率分布](#39常用概率分布)
  - [3.9.1，伯努利分布](#391伯努利分布)
  - [3.9.2，Multinoulli 分布](#392multinoulli-分布)
  - [3.9.3，高斯分布](#393高斯分布)
  - [3.9.4，指数分布和 Laplace 分布](#394指数分布和-laplace-分布)
- [3.10，常用函数的有用性质](#310常用函数的有用性质)
- [3.11，贝叶斯定理](#311贝叶斯定理)
  - [3.11.1，贝叶斯定理公式](#3111贝叶斯定理公式)
  - [3.11.2，贝叶斯理论与概率密度函数](#3112贝叶斯理论与概率密度函数)
- [3.12，连续型变量的技术细节](#312连续型变量的技术细节)
- [3.13，信息论-相对熵和交叉熵](#313信息论-相对熵和交叉熵)
- [3.14，结构化概率模型](#314结构化概率模型)
- [参考资料](#参考资料)

> 本文内容大多来自《深度学习》（花书）第三章概率与信息论。目录的生成是参考此篇 [文章](https://ecotrust-canada.github.io/markdown-toc/)。

## 前言

### 概率论学科定义

概率论是用于表示**不确定性声明的数学框架**。它不仅提供了量化不确定性的方法，也提供了用于导出新的不确定性**声明**（`statement`）的公理。概率论的知识在机器学习和深度学习领域都有广泛应用，是学习这两门学科的基础。

### 概率与信息论在人工智能领域的应用

在人工智能领域，概率论主要有两种用途。
- 首先，概率定律告诉我们 `AI` 系统应该如何推理，基于此我们设计一些算法来计算或者估算由概率论导出的表达式。
- 其次，我们可以用概率和统计从理论上分析我们提出的 `AI` 系统的行为。

虽然概率论允许我们在存在不确定性的情况下**做出不确定的陈述和推理**，但信息论允许我们量化概率分布中不确定性的数量。


## 3.1，为什么要使用概率论

这是因为机器学习必须始终**处理不确定的量**，有时可能还需要处理随机（非确定性）的量，这里的不确定性和随机性可能来自多个方面。而使用使用概率论来量化不确定性的论据，是来源于 20 世纪 80 年代的 Pearl (1988) 的工作。

不确定性有三种可能的来源:
1. 被建模系统内在的随机性。
2. 不完全观测。
3. 不完全建模：使用了一些必须舍弃某些观测信息的模型。

## 3.2，随机变量

**随机变量**（`random variable`）是可以随机地取不同值的变量，它可以是离散或者连续的。

离散随机变量拥有有限或者可数无限多的状态。注意这些状态不一定非要是整数; 它们也可能只是一些被命名的状态而没有数值。连续随机变量伴随着实数值。注意，随机变量只是对可能状态的描述；它必须与指定这些状态中的每一个的可能性的概率分布相结合。

我们通常用无格式字体 (`plain typeface`) 中的小写字母来表示随机变量本身，而用手写体中的小写字母来表示随机变量能够取到的值。例如， $x_1$ 和 $x_2$ 都是**随机变量** $\textrm{x}$ 可能的取值。对于向量值变量，我们会将随机变量写成 $\mathbf{x}$，它的一个可能取值为 $\boldsymbol{x}$。
> 中文维基百科用 $X$ 表示随机变量，用 $f_{X}(x)$ 表示概率密度函数，本文笔记，不同小节内容两者混用。

## 3.3，概率分布

**概率分布**（`probability distribution`）是用来描述随机变量或一簇随机变量在每一个可能取到的状态的可能性大小。

如果狭义地讲，它是指**随机变量的概率分布函数**。具有相同概率分布函数的随机变量一定是相同分布的。连续型和离散型随机变量的**概率分布描述方式**是不同的。

### 3.3.1，离散型变量和概率质量函数

**离散型变量的概率分布可以用概率质量函数**（`probability mass function`, `PMF`，也称概率密度函数）来描述。我们通常用大写字母 $P$ 来表示概率质量函数，用 $\textrm{x} \sim P(\textrm{x})$ **表示随机变量 $\textrm{x}$ 遵循的分布**。

虽然通常每一个随机变量都会有一个不同的概率质量函数，但是概率质量函数也可以同时作用于多个随机变量，这种多个变量的概率分布被称为**联合概率分布**（`joint probability distribution`）。 $P(\textrm{x} = x, \textrm{y} = y)$ 表示 $\textrm{x} = x$ 和 $\textrm{y} = y$ 同时发生的概率，有时也可简写为 $P(x，y)$。

如果一个函数 $P$ 是随机变量 $\textrm{x}$ 的 `PMF`，必须满足以下条件：

+ $P$ 的定义域必须是 $\textrm{x}$ 所有可能状态的集合。
+ $\forall x \in \textrm{x}, 0 \leq  P(x)\leq 1$。不可能发生的事件概率为 `0`，能够确保一定发生的事件概率为 `1`。
+ $\sum_{x \in \textrm{x}}P(x)=1$，**归一化**（`normalized`）。

**常见的离散概率分布族有**：
+ 伯努利分布
+ 二项分布：一般用二项分布来计算概率的前提是，每次抽出样品后再放回去，并且只能有两种试验结果，比如黑球或红球，正品或次品等。
+ 几何分布
+ `Poisson` 分布（泊松分布）：`Poisson` 近似是二项分布的一种极限形式。
+ 离散均匀分布：即对于随机变量 $\textrm{x}$，因为其是均匀分布(`uniform distribution`)，所以它的 `PMF` 为 $P(\textrm{x}=x_{i}) = \frac{1}{k}$，同时 $\sum_{i}P(\textrm{x} = x_{i}) = \sum_{i}\frac{1}{k} = \frac{k}{k} = 1$。


### 3.3.2，连续型变量和概率密度分布函数

**连续型随机变量的概率分布可以用概率密度函数**（`probability desity function, PDF`）来描述。

通常用小写字母 $p$ 来表示随机变量 $\textrm{x}$ 的概率密度函数 `PDF`，其必须满足以下条件：
+ $p$ 的定义域必须是 $\textrm{x}$ 所有可能状态的集合。
+ $\forall x \in \textrm{x}, p(x)\geq 0$。注意，并不要求 $p(x)\leq 1$。
+ $\int p(x)dx=1$。

概率密度函数 $p(x)$ 给出的是落在面积为 $\delta x$ 的无限小的区域内的概率为 $p(x)\delta x$。

因此，我们可以对概率密度函数求积分来获得点集的真实概率质量。特别地，$x$ 落在集合 $\mathbb{S}$ 中的概率可以通过 $p(x)$ 对这个集合求积分来得到。在单变量的例子中，$x$ 落在区间 $[a,b]$ 的概率是 $\int_{[a,b]}p(x)dx$。

**常见的连续概率分布族有**：
+ 均匀分布
+ **正态分布**：连续型随机变量的概率密度函数如下所示。其密度函数的曲线呈对称钟形，因此又被称之为钟形曲线，其中$\mu$ 是平均值，$\sigma$ 是标准差。正态分布是一种理想分布。$${f(x)={\frac {1}{\sigma {\sqrt {2\pi }}}}e^{\left(-{\frac {1}{2}}\left({\frac {x-\mu }{\sigma }}\right)^{2}\right)}}$$
+ 伽玛分布
+ 指数分布

## 3.4，边缘概率
> 边缘概率好像应用并不多，所以这里理解定义和概念即可。
> 边缘概率的通俗理解描述，来源于 [数学篇 - 概率之联合概率、条件概率、边缘概率和贝叶斯法则(笔记)](https://alili.tech/archive/haz1cu03hf/)。

有时候，我们知道了一组变量的联合概率分布，但想要了解其中一个子集的概率分布。这种定义在子集上的概率分布被称为**边缘概率分布**(`marginal probability distribution`)。

对于离散型随机变量 $\textrm{x}$ 和 $\textrm{y}$，知道 $P(\textrm{x}, \textrm{y})$，可以依据下面的**求和法则**（`sum rule`）来计算边缘概率 $P(\textrm{x})$：

$$\forall x \in \textrm{x},P(\textrm{x}=x)=\sum_{y}P(\textrm{x}=x, \textrm{y}=y)$$

“边缘概率”的名称来源于手算边缘概率的计算过程。当 $P(x,y)$ 的每个值被写在由每行表示不同的 $x$ 值，每列表示不同的 $y$ 值形成的网格中时，对网格中的每行求和是很自然的事情，然后将求和的结果 $P(x)$ 写在每行右边的纸的边缘处。

连续性变量的边缘概率则用积分代替求和：

$$p(x) = \int p(x,y)dy$$

## 3.5，条件概率

**条件概率（`conditional probability`）就是事件 A 在事件 B 发生的条件下发生的概率**，表示为 $P(A|B)$。

设 $A$ 与 $B$ 为样本空间 Ω 中的两个事件，其中 $P(B)$ > 0。那么在事件 $B$ 发生的条件下，事件 $A$ 发生的条件概率为：

$$P(A|B)={\frac {P(A\cap B)}{P(B)}}$$

> 花书中期望的条件概率定义（表达式不一样，但意义是一样的，维基百科的定义更容易理解名字意义，花书中的公式更多的是从数学中表达）:

> 将给定 $\textrm{x} = x$ 时， $\textrm{y} = y$ 发生的条件概率记为 $P(\textrm{y} = y|\textrm{x} = x)$，这个条件概率的计算公式如下：
> $$P(\textrm{y}=y|\textrm{x}=x)=\frac{P(\textrm{y}=y, \textrm{x}=x)}{P(\textrm{x}=x)}$$
> 条件概率只在 $P(\textrm{x}=x)\geq 0$ 时有定义，即不能计算以从未发生的事件为条件的条件概率。

### 3.5.1，条件概率的链式法则

任何多维随机变量的联合概率分布，都可以分解成只有一个变量的条件概率相乘的形式，这个规则被称为概率的**链式法则**（`chain rule`）。条件概率的链式法则如下:

$$
\begin{align}
P(a,b,c) &= P(a|b,c)P(b,c) \nonumber \\
P(b,c) &= P(b|c)P(c) \nonumber \\
P(a,b,c) &= P(s|b,c)P(b|c)P(c) \nonumber
\end{align}
$$

### 3.6，独立性和条件独立性

两个随机变量 $\textrm{x}$ 和 $\textrm{y}$，如果它们的概率分布可以表示成两个因子的乘积形式，并且一个因子只包含 $\textrm{x}$ 另一个因子只包含 $\textrm{y}$，我们就称这两个随机变量是**相互独立**的（`independent`）：

$$\forall x \in \textrm{x},y \in \textrm{y},p(\textrm{x}=x, \textrm{y}=y)=p(\textrm{x}=x)\cdot p(\textrm{y}=y)$$

两个相互独立的随机变量同时发生的概率可以通过各自发生的概率的乘积得到。

如果关于 $x$ 和 $y$ 的条件概率分布对于 $z$ 的每一个值都可以写成乘积的形式，那么这两个随机变量 $x$ 和 $y$ 在给定随机变量 $z$ 时是条件独立的(conditionally independent):

$$\forall x \in ,y \in \textrm{y},z \in \textrm{z}, p(\textrm{x}=x, \textrm{y}=y|z \in \textrm{z})= p(\textrm{x}=x|z \in \textrm{z})\cdot p(\textrm{y}=y|z \in \textrm{z})$$

采用一种简化形式来表示独立性和条件独立性: $\textrm{x}\perp\textrm{y}$ 表示 $\textrm{x}$ 和 $\textrm{y}$ 相互独立，$\textrm{x}\perp\textrm{y}\vert\textrm{z}$ 表示 $\textrm{x}$ 和 $\textrm{y}$ 在给定 $\textrm{z}$ 时条件独立。

## 3.7，条件概率、联合概率和边缘概率总结

1. **条件概率（`conditional probability`）就是事件 A 在事件 B 发生的条件下发生的概率**。条件概率表示为 $P(A\vert B)$，读作“A 在 B 发生的条件下发生的概率”。
2. 联合概率表示两个事件共同发生的概率。`A` 与 `B` 的联合概率表示为 $P(A\cap B)$ 或者 $P(A,B)$ 或者 $P(AB)$。
3. 仅与单个随机变量有关的概率称为边缘概率。

## 3.8，期望、方差和协方差
> 为了便于理解，本章中的期望和方差的数学定义主要采用中文维基百科中的定义。

在概率分布中，期望值和方差或标准差是一种分布的重要特征，期望、数学期望、均值都是一个意思。统计中的方差（样本方差）是每个样本值与全体样本值的平均数之差的平方值的平均数，其意义和概率分布中的方差是不一样的。

### 3.8.1，期望

在概率论和统计学中，一个离散性随机变量的期望值（或数学期望，亦简称期望，物理学中称为期待值）是试验中**每次可能的结果乘以其结果概率的总和**。换句话说，期望值像是随机试验在同样的机会下重复多次，所有那些可能状态平均的结果，也可理解为**该变量输出值的加权平均**。

#### 期望数学定义

如果 $X$ 是在概率空间 $(\Omega ,F,P)$ 中的随机变量，那么它的期望值 $\operatorname{E}(X)$ 的定义是：

$$\operatorname {E}(X)=\int_{\Omega }X {d}P$$

**并不是每一个随机变量都有期望值的，因为有的时候上述积分不存在。如果两个随机变量的分布相同，则它们的期望值也相同**。

1，如果 $X$ 是**离散的随机变量**，输出值为 $x_{1},x_{2},\ldots x_{1},x_{2},\ldots$，和输出值相应的概率为 ${\displaystyle p_{1},p_{2},\ldots }p_{1},p_{2},\ldots$（概率和为 `1`）。

若级数 $\sum_{i}p_{i}x_{i}$ 绝对收敛，那么期望值 $\operatorname {E}(X)$ 是一个无限数列的和。

$$\operatorname {E}(X)=\sum_{i}p_{i}x_{i}$$

2，如果 $X$ 是**连续的随机变量**，且存在一个相应的概率密度函数 $f(x)$，若积分 $\int _{-\infty }^{\infty }xf(x)\,\mathrm {d} x$ 绝对收敛，那么 $X$ 的期望值可以计算为：

$$\operatorname {E} (X)=\int _{-\infty }^{\infty }xf(x)\,\mathrm {d} x$$

虽然是针对于连续的随机变量的，但与离散随机变量的期望值的计算算法却同出一辙，由于输出值是连续的，所以**只是把求和改成了积分**。

**期望值 $E$ 是线性函数**:

$$\operatorname {E}(aX+bY)=a\operatorname {E}(X)+b\operatorname {E}(Y)$$

$X$ 和 $Y$ 为**在同一概率空间的两个随机变量**（可以独立或者非独立），$a$ 和 $b$ 为任意实数。

> 花书中期望的数学定义（表达式不一样，但意义是一样的）:
>
> 1，某个函数 $f(x)$ 相对于概率分布 $P(x)$ 的期望（期望值）是当从 $P$ 中抽取 $x$ 时 $f$ 所取的平均或平均值。对于离散型随机变量，期望可以通过**求和**得到：
> $$\mathbb{E}_{\textrm{x}\sim P}[f(x)] = \sum_{x} P(x)f(x)$$
>
> 2，对于连续型随机变量可以通过求**积分**得到：
> $$\mathbb {E}_{\textrm{x}\sim p}[f(x)] = \int p(x)f(x)dx$$

#### 期望应用

1. 在**统计学**中，估算变量的期望值时，经常用到的方法是重复测量此变量的值，再用所得数据的平均值来估计此变量的期望值。
2. 在**概率分布**中，期望值和方差或标准差是一种分布的重要特征。

#### 总体均值数学定义

一般而言，一个有限的容量为 $N$、元素的值为 $x_{i}$ 的总体的总体均值为：

$$\mu = \frac{\sum_i^N x_{i}}{N}$$

### 3.8.2，方差

在概率论和统计学中，方差（英语：`variance`）又称变异数、变方，描述的是**一个随机变量的离散程度，即该变量离其期望值的距离**，是随机变量与其总体均值或样本均值的离差的平方的期望值。

方差差是标准差的平方、分布的二阶矩，以及随机变量与其自身的协方差，其常用的符号表示有 $\sigma^2$、$s^2$、$\operatorname {Var} (X)$、$\displaystyle V(X)$，以及 $\displaystyle \mathbb {V} (X)$。

方差作为离散度量的优点是，它比其他离散度量（如平均差）更易于代数运算，但缺点是它与随机变量的单位不同，而标准差则单位相同，这就是计算完成后通常采用标准差来衡量离散程度的原因。
> 方差的正平方根称为该随机变量的标准差。

有两个不同的概念都被称为“方差”。一种如上所述，是理论概率分布的方差。而另一种方差是一组观测值的特征，分别是**总体方差**（所有可能的观测）和**样本方差**（总体的一个子集）。

#### 方差数学定义

设 $X$ 为服从分布 $F$ 的随机变量，如果 $\operatorname{E}[X]$ 是随机变量 $X$ 的期望值（均值 $\mu=\operatorname{E}[X]$），则随机变量 $X$ 或者分布 $F$ 的**方差**为 $X$ 的**离差平方的期望值**:

$$\operatorname{E}(X) = \operatorname{E}[(X - \mu)]^2 = \operatorname{E}[X - \operatorname{E}(X)]^2$$

方差的表达式可展开如下：

$$
\begin{align}
\operatorname{Var}(X) &=\operatorname{E} \left[(X-\operatorname {E} [X])^{2}\right] \nonumber \\
&=\operatorname{E} \left[X^{2}-2X\operatorname {E} [X]+\operatorname{E}[X]^{2}\right] \nonumber \\
&=\operatorname{E} \left[X^{2}\right]-2\operatorname{E}[X]\operatorname{E}[X]+\operatorname{E}[X]^{2} \nonumber \\
&=\operatorname{E} \left[X^{2}\right]-\operatorname{E}[X]^{2} \nonumber \\
\end{align}
$$

也就是说，$X$ 的方差等于 $X$ 平方的均值减去 $X$ 均值的平方。

#### 总体方差数学定义

一般而言，一个有限的容量为 $N$、元素的值为 $x_{i}$ 的总体的总体方差为：

$$\sigma^{2} = {\frac {1}{N}}\sum _{i=1}^{N}\left(x_{i}-\mu \right)^{2}$$

> 花书中方差的定义: **方差**（`variance`）衡量的是当我们对 $x$ 依据它的概率分布进行采样时，随机变量 $\textrm{x}$ 的函数值会呈现多大的差异，或者说一个随机变量的方差描述的是它的离散程度，也就是该变量离其期望值的距离。方差定义如下：
> $$Var(f(x)) = \mathbb{E}[(f(x) - \mathbb{E}[f(x)])^2]$$

### 3.8.3，期望与方差的运算性质

**期望与方差运算性质**如下:

![期望运算性质](../images/ml/expected_properties.png)

![方差运算性质](../images/ml/variance_operation_properties.png)
> 来源: 知乎文章-[【AP统计】期望E(X)与方差Var(X)](https://zhuanlan.zhihu.com/p/64859161)。

### 3.8.4，协方差

协方差也叫共变异数（英语：Covariance），在概率论与统计学中用于**衡量两个随机变量的联合变化程度**。

#### 协方差数学定义

期望值分别为 $\operatorname E(X)=\mu$ 与 $\operatorname E(Y)=\nu$ 的两个具有有限二阶矩的实数随机变量 $X$ 与 $Y$ 之间的协方差定义为：

$$\operatorname {cov} (X,Y)=\operatorname {E} ((X-\mu )(Y-\nu ))=\operatorname {E} (X\cdot Y)-\mu \nu$$

协方差表示的是两个变量的总体的误差，这与只表示一个变量误差的方差不同。

协方差的绝对值如果很大则意味着变量值变化很大并且它们同时距离各自的均值很 远。如果协方差是正的，那么两个变量都倾向于同时取得相对较大的值。如果协方 差是负的，那么其中一个变量倾向于取得相对较大的值的同时，另一个变量倾向于 取得相对较小的值，反之亦然。其他的衡量指标如 相关系数(`correlation`)将每个变 量的贡献归一化，为了只衡量变量的相关性而不受各个变量尺度大小的影响。

## 3.9，常用概率分布

下表列出了一些常用概率分布的方差。

![probability_distributions](../images/dl/probability_distributions.png)

### 3.9.1，伯努利分布

**伯努利分布**（英语：`Bernoulli distribution`），又名两点分布或者 `0-1` 分布，是一个离散型概率分布，为纪念瑞士科学家雅各布·伯努利而命名。若伯努利试验成功，则伯努利随机变量取值为 `1`。若伯努利试验失败，则伯努利随机变量取值为 `0`。记其成功概率为 $0\leq p\leq 1$，失败概率为 $q = 1-p$。其有如下性质:

1. 其**概率质量函数**为:

$$
f_{X}(x) = p^{x}(1-p)^{1-x} = \left\lbrace\begin{matrix}
p \quad if \;x = 1 \\ 
1-p \quad  if \; x = 0
\end{matrix}\right.
$$

2. 其**期望值**为: 
$$\operatorname {E} [X] = \sum_{i=0}^{1} x_{i}f_X(x) = 0 + p = p$$
3. 其**方差**为:

$$\begin{aligned}
Var[X] &= \sum_{i=0}^{1} (x_{i}-\operatorname {E} [X])^2f_{X}(x) \\
&= (0-P)^2(1-P) + (1-P)^2P \\
&= p(1-p) \\
&= p\cdot q \\
\end{aligned}$$

### 3.9.2，Multinoulli 分布

`Multinoulli` 分布(多项式分布，也叫范畴分布 `categorical dis- tribution`)是一种离散概率分布，它描述了随机变量的可能结果，该随机变量可以采用 $k$ 个可能类别之一，概率为每个类别分别指定，其中 $k$ 是一个有限值。

### 3.9.3，高斯分布
> 有几种不同的方法用来说明一个随机变量。最直观的方法是**概率密度函数**，这种方法能够表示随机变量每个取值有多大的可能性。

高斯分布 `Gaussian distribution`（也称正态分布 `Normal distribution`）是一个非常常见的**连续概率分布**。高斯分布在统计学上十分重要，经常用在自然和社会科学来代表一个不确定的随机变量。

若随机变量 $X$ 服从一个位置参数为 $\mu$ 、尺度参数为 $\sigma$ 的正态分布，记为：

$$X \sim N(\mu,\sigma^2)$$

则其**概率密度函数**为 $$f(x;\mu, \sigma) = \frac {1}{\sigma {\sqrt {2\pi }}}\;e^{-{\frac {\left(x-\mu \right)^{2}}{2\sigma ^{2}}}}$$

正态分布的数学期望值 $\mu$ 等于位置参数，决定了分布的**位置**；其方差 $\sigma^2$ 的开平方或标准差 $\sigma$ 等于尺度参数，决定了分布的**幅度**。

正态分布概率密度函数曲线呈钟形，也称之为钟形曲线（类似于寺庙里的大钟，因此得名）。我们通常所说的**标准常态分布**是位置参数 $\mu = 0$，尺度参数 $\sigma ^{2} = 1$ 的正态分布（见右图中红色曲线）。

![四个不同参数集的概率密度函数（红色线代表标准正态分布）](../images/dl/2880px-Normal_Distribution_PDF.png)

采用正态分布在很多应用中都是一个明智的选择。当我们由于缺乏关于某个实 数上分布的先验知识而不知道该选择怎样的形式时，正态分布是默认的比较好的选择，其中有两个原因。

1. 第一，我们想要建模的很多分布的真实情况是比较接近正态分布的。
2. 第二，在具有相同方差的所有可能的概率分布中，正态分布在实数上具有最 的不确定性。因此，我们可以认为正态分布是对模型加入的先验知识量最少的分布。

### 3.9.4，指数分布和 Laplace 分布

在概率论和统计学中，**指数分布**（`Exponential distribution`）是一种连续概率分布，表示一个在 $x = 0$ 点处取得边界点 (`sharp point`) 的分布，其使用指示函数(`indicator function`) $1_{x\geq0}$ 来使得当 $x$ 取负值时的概率为零。指数分布可以等同于形状母数 $\alpha$为 $1$的**伽玛分布**。

指数分布可以用来表示独立随机事件发生的时间间隔，比如旅客进入机场的时间间隔、电话打进客服中心的时间间隔等。

若随机变量 $X$ 服从母数为 $\lambda$ 或 $\beta$ 的指数分布，则记作

$X\sim {\text{Exp}}(\lambda )$ 或 $X\sim {\text{Exp}}(\beta )$

两者意义相同，只是 $\lambda$ 与 $\beta$ 互为倒数关系。**指数分布的概率密度函数**为：

$$
f(x;{\color {Red}\lambda })=\left\lbrace{\begin{matrix}{\color {Red}\lambda }e^{-{\color {Red}\lambda }x}&x\geq 0,\\0&,\;x<0.\end{matrix}}\right.
$$

**指数分配概率密度函数曲线**如下所示。

![指数分配概率密度函数](../images/dl/Exponential_distribution_pdf.png)

## 3.10，常用函数的有用性质

深度学习中的概率分布有一些经常出现的函数，比如 `logistic sigmoid` 函数:

$$\sigma(x) = \frac{1}{1+exp(-x)}$$

`logistic sigmoid` 函数通常用来产生伯努利分布的参数 $p$，因为它的范围是 $(0, 1)$，位于 $p$ 参数值的有效范围内。下图 3.3 给出了 `sigmoid` 函数的图示。从图中可以明显看出，`sigmoid` 函数在变量取绝对值非常大的正值或负值时会出现**饱和(`saturate`)现象**，意味着函数会变得**很平**，并且对输入的微小改变会变得**不敏感**。

![sigmoid函数示意图](../images/dl/schematic_diagram_of_sigmoid_function.png)

`sigmoid` 函数的一些性质在后续学习 `BP` 算法等内容时会很有用，我们需要牢记：

$$
\begin{align}
\sigma(x) &= \frac{exp(x)}{exp(x)+exp(0)} \nonumber \\
\frac{d}{dx}\sigma(x) &= \sigma(x)(1 - \sigma(x)) \nonumber \\
1 - \sigma(x) &= \sigma(-x) \nonumber \\
\end{align}
$$

## 3.11，贝叶斯定理
> 本小节只是简单介绍基本概念和公式，更全面和深入的理解建议看《机器学习》书籍。

贝叶斯定理（英语：`Bayes' theorem`）是概率论中的一个定理，描述**在已知一些条件下，某事件的发生概率**。比如，如果已知某种健康问题与寿命有关，使用贝叶斯定理则可以通过得知某人年龄，来更加准确地计算出某人有某种健康问题的概率。

通常，事件 A 在事件 B 已发生的条件下发生的概率，与事件 B 在事件 A 已发生的条件下发生的概率是不一样的。但是，这两者是有确定的关系的，贝叶斯定理就是这种关系的陈述。贝叶斯公式的一个用途，即透过已知的三个概率而推出第四个概率。贝叶斯定理跟随机变量的条件概率以及边际概率分布有关。

作为一个普遍的原理，贝叶斯定理对于所有概率的解释是有效的。这一定理的主要应用为贝叶斯推断，是推论统计学中的一种推断法。这一定理名称来自于托马斯·贝叶斯。

> 来源[中文维基百科-贝叶斯定理](https://zh.wikipedia.org/wiki/%E8%B4%9D%E5%8F%B6%E6%96%AF%E5%AE%9A%E7%90%86)

### 3.11.1，贝叶斯定理公式

贝叶斯定理是关于随机事件 A 和 B 的条件概率的一则定理。

$$P(A\mid B)={\frac {P(A)P(B\mid A)}{P(B)}}$$

其中 A 以及 B 为随机事件，且 $P(B)$ 不为零。$P(A\mid B)$ 是指在事件 B 发生的情况下事件 A 发生的概率。

在贝叶斯定理中，每个名词都有约定俗成的名称：
- $P(A\mid B)$ 是已知 B 发生后，A 的**条件概率**。也称作 A 的事后概率。
- $P(A)$ 是 A 的先验概率（或边缘概率）。其不考虑任何 B 方面的因素。
- $P(B\mid A)$ 是已知 A 发生后，B 的条件概率。也可称为 B 的后验概率。某些文献又称其为在特定 B 时，A 的似然性，因为 $P(B\mid A)=L(A\mid B)$。
- $P(B)$是 B 的**先验概率**。

### 3.11.2，贝叶斯理论与概率密度函数

贝叶斯理论亦可用于概率分布，贝叶斯理论与概率密度的关系是由求极限的方式建立：

$$P(\textrm{x}|\textrm{y}) = \frac{P(\textrm{x})P(\textrm{y}|\textrm{x})}{P(\textrm{y})}$$

注意到 $P(y)$ 出现在上面的公式中，它通常使用 $P(\textrm{y}) = \sum_{x} P(\textrm{y}|x)P(x)$ 来计算所以我们并不需要事先知道 $P(\textrm{y})$ 的信息。

> 中文维基百科中贝叶斯理论与概率密度关系定义:
> $$f(x|y)={\frac {f(x,y)}{f(y)}}={\frac {f(y|x)\,f(x)}{f(y)}}$$

## 3.12，连续型变量的技术细节

连续型随机变量和概率密度函数的深入理解需要用到数学分支**测度论**(`measure theory`)的相关内容来扩展概率论，测度论超出了本文范畴。《深度学习》原书中有测度论的简要介绍，本笔记不做记录和摘抄，感兴趣的可以阅读原书。

## 3.13，信息论-相对熵和交叉熵

信息论是应用数学、电子学和计算机科学的一个分支，早期备用在无线通信领域。在深度学习中，主要是使用信息论的一些关键思想来**表征(`characterize`)概率分布**或者**量化概率分布之间的相似性**。

信息论的基本想法是一个不太可能的事件居然发生了，要比一个非常可能的事件发生，能提供更多的信息。

定义一个事件 $\textrm{x} = x$ 的自信息(self-information) 为

$$
I(x) = -\text{log}P(x)
$$

在本文中，我们总是用 $\text{log}$ 来表示自然对数，其底数为 $e$。因此我们定义的 $I(x)$ 单位是**奈特**(nats)。一奈特是以 $\frac{1}{e}$ 的概率观测到一个事件时获得的信息量。其他的材料中可能使用底数为 2 的对数，单位是**比特**(bit)或者香农(shannons); 通过比特度量的信息只是通过奈特度量信息的常数倍。

自信息只处理单个的输出。我们可以用**香农熵**(`Shannon entropy`)来对整个概率分布中的不确定性总量进行量化:

$$H(P) = H(\textrm{x}) = E_{x∼P}[I(x)] = −E_{x∼P}[log P(x)]$$

换句话说，一个概率分布的香农熵是指遵循这个分布的事件所产生的期望信息总量。

如果我们对于同一个随机变量 $\textrm{x}$ 有两个单独的概率分布 $P(\textrm{x})$ 和 $Q(\textrm{x})$，则可以用 **KL 散度**（ `Kullback-Leibler (KL) divergence`，也叫相对熵）来**衡量这两个概率分布的差异**：

$$D_{KL}(P\parallel Q) = \mathbb{E}_{\textrm{x}\sim p}\begin{bmatrix}
log \frac{P(x)}{Q(x)} \end{bmatrix} = \mathbb{E}_{\textrm{x}\sim p}[log P(x) - log Q(x)]$$

KL 散度有很多有用的性质，最重要的是它是非负的。KL 散度为 0 当且仅当 $P$ 和 $Q$ 在离散型变量的情况下是相同的概率分布，或者在连续型变量的情况下是 “几乎处处” 相同的。

一个和 KL 散度密切联系的量是**交叉熵**(`cross-entropy`)$H(P, Q) = H(P) + D_{KL}(P\vert\vert Q)$，其计算公式如下:

$$H(P, Q)  = -\mathbb{E}_{\textrm{x}\sim p}log Q(x)$$

和 KL 散度相比，少了左边一项，即熵 $H(P)$。可以看出，最小化 KL 散度其实就是在最小化分布之间的交叉熵。

> 上式的写法是在前面所学内容**数学期望**的基础上给出的，还有一个写法是《机器学习-周志华》书中附录 C 中给出的公式，更为直观理解：
> $$KL(P\parallel Q) = \int_{-\infty }^{+\infty} p(x)log \frac{p(x)}{q(x)} dx$$
> 其中 $p(x)$ 和 $q(x)$ 分别为 $P$ 和 $Q$ 的概率密度函数。
> 这里假设两个分布均为连续型概率分布，对于离散型概率分布，只需要将积分替换为对所有离散值遍历求和。

> `KL` 散度满足非负性和不满足对称性。将上式展开可得：
> $$\text{KL 散度} KL(P\parallel Q) = \int_{-\infty }^{+\infty}p(x)logp(x)dx - \int_{-\infty }^{+\infty}p(x) logq(x)dx = -H(P) + H(P,Q)$$
> $$\text{交叉熵} H(P,Q) = \mathbb{E}_{\textrm{x}\sim p} log Q(x) = - \int_{-\infty }^{+\infty} p(x) logq(x)dx$$

> 其中，$H(P)$ 为熵（`entropy`），$H(P,Q)$ 为交叉熵（`cross entropy`）。

>在信息论中，熵 $H(P)$ 表示对来自 $P$ 的随机遍历进行编码所需的最小字节数，而交叉熵 $H(P,Q)$ 表示使用 $Q$ 的编码对来自 $P$ 的变量进行编码所需的字节数。因此 KL  散度可认为是使用基于 $Q$ 的编码对来自 $P$ 的变量进行编码所需的“额外字节数”；显然，额外字节数非负，当且仅当 $P=Q$ 时额外字节数为 `0`。

## 3.14，结构化概率模型

略

## 参考资料

+ https://zh.m.wikipedia.org/zh-hans/%E6%96%B9%E5%B7%AE#
+ 《深度学习》
+ 《机器学习》