---
layout: post
title: 深度学习基础-机器学习基本原理
date: 2022-11-04 23:00:00
summary: 深度学习是机器学习的一个特定分支。我们要想充分理解深度学习，必须对机器学习的基本原理有深刻的理解。大部分机器学习算法都有超参数（必须在学习算法外手动设定）。机器学习本质上属于应用统计学，其更加强调使用计算机对复杂函数进行统计估计。
categories: DeepLearning
---

- [前言](#前言)
- [5.1 学习算法](#51-学习算法)
  - [5.1.1 任务 $T$](#511-任务-t)
  - [5.1.2 性能度量 $P$](#512-性能度量-p)
  - [5.1.3 经验 $E$](#513-经验-e)
  - [5.1.4 示例: 线性回归](#514-示例-线性回归)
- [5.2 容量、过拟合和欠拟合](#52-容量过拟合和欠拟合)
  - [5.2.1 没有免费午餐定理](#521-没有免费午餐定理)
  - [5.2.2 正则化](#522-正则化)
- [5.3 超参数和验证集](#53-超参数和验证集)
  - [5.3.1 验证集的作用](#531-验证集的作用)
  - [5.3.2 交叉验证](#532-交叉验证)
- [5.4 估计、偏差和方差](#54-估计偏差和方差)
  - [5.4.1 点估计](#541-点估计)
  - [5.4.2 偏差](#542-偏差)
  - [5.4.3 方差和标准差](#543-方差和标准差)
  - [5.4.4 权衡偏差和方差以最小化均方误差](#544-权衡偏差和方差以最小化均方误差)
- [5.5 最大似然估计](#55-最大似然估计)
- [5.6 贝叶斯统计](#56-贝叶斯统计)
- [5.7 监督学习算法](#57-监督学习算法)
- [5.8 无监督学习算法](#58-无监督学习算法)
  - [5.8.1 PCA 降维](#581-pca-降维)
  - [5.8.2 k-均值聚类](#582-k-均值聚类)
- [5.9 随机梯度下降](#59-随机梯度下降)
- [5.10 构建机器学习算法 pipeline](#510-构建机器学习算法-pipeline)
- [参考资料](#参考资料)

> 本文大部分内容参考《深度学习》书籍，从中抽取重要的知识点，并对部分概念和原理加以自己的总结，适合当作原书的补充资料阅读，也可当作快速阅览机器学习原理基础知识的参考资料。

## 前言

**深度学习是机器学习的一个特定分支**。我们要想充分理解深度学习，必须对机器学习的基本原理有深刻的理解。

大部分机器学习算法都有**超参数**（必须在学习算法外**手动设定**）。**机器学习本质上属于应用统计学**，其更加强调使用计算机对复杂函数进行**统计估计**，而较少强调围绕这些函数证明置信区间；因此我们会探讨两种统计学的主要方法: **频率派估计和贝叶斯推断**。同时，大部分机器学习算法又可以分成**监督学习**和**无监督学习**两类；本文会介绍这两类算法定义，并给出每个类别中一些算法示例。

本章内容还会介绍如何组合不同的算法部分，例如优化算法、代价函数、模型和数据 集，来建立一个机器学习算法。最后，在 5.11 节中，我们描述了一些限制传统机器学习泛化能力的因素。正是这些挑战推动了克服这些障碍的深度学习算法的发展。
> 大部分深度学习算法都是基于随机梯度下降算法进行求解的。

## 5.1 学习算法

机器学习算法是一种能够从数据中学习的算法。这里所谓的“学习“是指：“如果计算机程序在任务 $T$ 中的性能（以 $P$ 衡量）随着经验 $E$ 而提高，则可以说计算机程序从经验 $E$ 中学习某类任务 $T$ 和性能度量 $P$。”-来自 `Mitchell` (`1997`)
> 经验 $E$，任务 $T$ 和性能度量 $P$ 的定义范围非常宽广，本文不做详细解释。

### 5.1.1 任务 $T$

从 “任务” 的相对正式的定义上说，学习过程本身不能算是任务。学习是我们所谓的获取完成任务的能力。机器学习可以解决很多类型的任务，一些非常常见的机器学习任务列举如下：
1. **分类**：在这类任务中，计算机程序需要指定某些输入属于 $k$ 类中的哪一类，例如图像分类中的二分类问题，多分类、单标签问题、多分类多标签问题。
2. **回归**：在这类任务中，计算机程序需要对给定输入预测数值。为了解决这个任务，学习算法需要输出函数 $f : \mathbb{R}^n \to \mathbb{R}$。除了返回结果的形式不一样外，这类 问题和分类问题是很像的。
3. **机器翻译**
4. **结构化输出**
5. **异常检测**
6. **合成和采样**
7. **去噪**
8. **密度估计或概率质量函数估计**
9. **输入缺失分类**
10. **转录**
11. **缺失值填补**

### 5.1.2 性能度量 $P$

为了评估机器学习算法的能力，我们必须设计其性能的**定量度量**，即算法的精度指标。通常，性能度量 $P$ 特定于系统正在执行的任务 $T$。
> 可以理解为不同的任务有不同的性能度量。

对于诸如分类、缺失输入分类和转录任务，我们通常度量模型的**准确率**(`accu- racy`)。准确率是指该模型输出正确结果的样本比率。我们也可以通过**错误率**(`error rate`)得到相同的信息。错误率是指该模型输出错误结果的样本比率。

我们使用测试集（`test set`）数据来评估系统性能，将其与训练机器学习系统的训练集数据分开。

值得注意的是，性能度量的选择或许看上去简单且客观，但是选择一个与系统理想表现能对应上的性能度量通常是很难的。

### 5.1.3 经验 $E$

根据学习过程中的不同经验，机器学习算法可以大致分类为两类

- **无监督**(`unsuper-vised`)算法
- **监督**(`supervised`)算法

**无监督学习算法**(`unsupervised learning algorithm`)训练含有很多特征的数据集，然后学习出这个数据集上有用的结构性质。在深度学习中，我们通常要学习生成数据集的整个概率分布，显式地，比如密度估计，或是隐式地，比如合成或去噪。 还有一些其他类型的无监督学习任务，例如聚类，将数据集分成相似样本的集合。

**监督学习算法**(`supervised learning algorithm`)也训练含有很多特征的数据集，但与无监督学习算法不同的是**数据集中的样本都有一个标签**(`label`)或目标(`target`)。例如，`Iris` 数据集注明了每个鸢尾花卉样本属于什么品种。监督学习算法通过研究 `Iris` 数据集，学习如何根据测量结果将样本划分为三个不同品种。

**半监督学习算法**中，一部分样本有监督目标，另外一部分样本则没有。在多实例学习中，样本的整个集合被标记为含有或者不含有该类的样本，但是集合中单独的样本是没有标记的。

大致说来，无监督学习涉及到观察随机向量 $x$ 的好几个样本，试图显式或隐式地学习出概率分布 $p(x)$，或者是该分布一些有意思的性质; 而监督学习包含观察随机向量 $x$ 及其相关联的值或向量 $y$，然后从 $x$ 预测 $y$，通常是估计 $p(y\vert x)$。术语监督学习(`supervised learning`)源自这样一个视角，教员或者老师提供目标 $y$ 给机器学习系统，指导其应该做什么。在无监督学习中，没有教员或者老师，算法必须学会在没有指导的情况下理解数据。

无监督学习和监督学习并不是严格定义的术语。它们之间界线通常是模糊的。很多机器学习技术可以用于这两个任务。

尽管无监督学习和监督学习并非完全没有交集的正式概念，它们确实有助于粗略分类我们研究机器学习算法时遇到的问题。传统地，人们将回归、分类或者结构化输出问题称为监督学习。支持其他任务的密度估计通常被称为无监督学习。

表示数据集的常用方法是**设计矩阵**(`design matrix`)。

### 5.1.4 示例: 线性回归

我们将机器学习算法定义为，通过经验以提高计算机程序在某些任务上性能的算法。这个定义有点抽象。为了使这个定义更具体点，我们展示一个简单的机器学习示例: **线性回归**(`linear regression`)。

顾名思义，**线性回归解决回归问题**。 换句话说，目标是构建一个系统，该系统可以将向量 $x \in \mathbb{R}$ 作为输入，并预测标量 $y \in \mathbb{R}$ 作为输出。在线性回归的情况下，输出是输入的线性函数。令 $\hat{y}$ 表示模型预测值。我们定义输出为

$$\hat{y} = w^{⊤}x \tag{5.3}$$

其中 $w \in \mathbb{R}^{n}$ 是**参数**(`parameter`)向量。

参数是控制系统行为的值。在这种情况下，$w_i$ 是系数，会和特征 $x_i$ 相乘之 后全部相加起来。我们可以将 $w$ 看作是一组决定每个特征如何影响预测的权重 (weight)。

通过上述描述，我们可以定义任务 $T$ : 通过输出 $\hat{y} = w^{⊤}x$ 从 $x$ 预测 $y$。

我们使用**测试集**（`test set`）来评估模型性能如何，将输入的设计矩 阵记作 $\textit{X}$(test)，回归目标向量记作 $y$(test)。

**回归任务**常用的一种模型性能度量方法是计算模型在测试集上的 **均方误差**(`mean squared error`)。如果 $\hat{y}$(`test`) 表示模型在测试集上的预测值，那么均方误差表示为:

$$MSE_{test} = \frac{1}{m} \sum_{i}(\hat{y}^{(test)}-y^{(test)})_{i}^{2} \tag{5.4}$$

直观上，当 $\hat{y}^{(test)}$ = $y^{(test)}$ 时，我们会发现误差降为 0。

图 5.1 展示了线性回归算法的使用示例。

![图5.1-一个线性回归的例子](../images/ml_basc_principle/figure_5_1_an_example_of_linear_regression.png)

## 5.2 容量、过拟合和欠拟合

机器学习的挑战主要在于算法如何在测试集（先前未观测的新输入数据）上表现良好，而不只是在训练集上表现良好，即训练误差和泛化误差读比较小，也可理解为算法泛化性比较好。所谓泛化性（generalized）好指的是，算法在在测试集（以前未观察到的输入）上表现良好。

机器学习算法的两个主要挑战是: **欠拟合**（`underfitting`）和**过拟合**（`overfitting`）。
- 欠拟合是指模型不能在训练集上获得足够低的误差。
- 而过拟合是指训练误差和和测试误差之间的差距太大。

通过调整模型的**容量**（`capacity`），我们可以控制模型是否偏向于过拟合或者欠拟合。通俗地讲，**模型的容量是指其拟合各种函数的能力**。容量低的模型可能很难拟合训练集，容量高的模型可能会过拟合，因为记住了不适用于测试集的训练集性质。

一种控制训练算法容量的方法是选择**假设空间**(`hypothesis space`)，即**学习算法可以选择作为解决方案的函数集**。例如，线性回归算法将其输入的所有线性函数的集合作为其假设空间。我们可以推广线性回归以在其假设空间中包含多项式，而不仅仅是线性函数。这样做就增加模型的容量。

> 注意，学习算法的效果不仅很大程度上受影响于假设空间的函数数量，也取决于这些函数的具体形式。

当机器学习算法的容量适合于所执行任务的复杂度和所提供训练数据的数量时，算法效果通常会最佳。容量不足的模型不能解决复杂任务。容量高的模型能够解决复杂的任务，但是当其容量高于任务所需时，有可能会过拟合。

图 5.2 展示了上述原理的使用情况。我们比较了线性，二次和 `9` 次预测器拟合真实二次函数的效果。

![图5-2三个模型拟合二次函数](../images/ml_basc_principle/figure_5_2_three_models_fitting_quadratic_functions.png)

提高机器学习模型泛化性的早期思想是**奥卡姆剃刀**原则，即选择“最简单”的那一个模型。

统计学习理论提供了量化模型容量的不同方法。在这些中，最有名的是 **Vapnik- Chervonenkis 维度**(Vapnik-Chervonenkis dimension, VC)。`VC` 维度量二元分类 器的容量。`VC` 维定义为该分类器能够分类的训练样本的最大数目。假设存在 $m$ 个 不同 $x$ 点的训练集，分类器可以任意地标记该 $m$ 个不同的 $x$ 点，`VC` 维被定义为 $m$ 的最大可能值。

因为可以量化模型的容量，所以使得统计学习理论可以进行量化预测。统计学习理论中最重要的结论阐述了训练误差和泛化误差之间差异的上界随着模型容量增长而增长，但随着训练样本增多而下降 (`Vapnik and Chervonenkis, 1971`; `Vapnik, 1982`; `Blumer et al., 1989`; `Vapnik, 1995`)。这些边界为机器学习算法可以有效解决问题提供了理论 验证，但是它们**很少应用于实际中的深度学习算法**。一部分原因是边界太松，另一部分原因是**很难确定深度学习算法的容量**。由于有效容量受限于优化算法的能力，所以确定深度学习模型容量的问题特别困难。而且我们对深度学习中涉及的非常普遍的**非凸优化问题**的理论了解很少。

虽然更简单的函数更可能泛化(训练误差和测试误差的差距小)，但我们仍然必须选择一个足够复杂的假设来实现低训练误差。通常，随着模型容量的增加，训练误差会减小，直到它逐渐接近最小可能的误差值（假设误差度量具有最小值）。通常，**泛化误差是一个关于模型容量的 U 形曲线函数**。如下图 `5.3` 所示。

![容量和误差之间的典型关系](../images/ml_basc_principle/figure_5_3_model_capacity.png)

### 5.2.1 没有免费午餐定理

机器学习的**没有免费午餐定理**（`Wolpert，1996`）指出，对所有可能的数据生成分布进行平均，每个分类算法在对以前未观察到的点进行分类时具有相同的错误率。换句话说，在某种意义上，**没有任何机器学习算法普遍优于其他任何算法**。

上述这个结论听着真的让人伤感，但庆幸的是，这些结论仅在我们考虑**所有可能的数据生成分布**时才成立。如果我们对实际应用中遇到的概率分布类型做出假设，那么我们可以**设计出在这些分布上表现良好的学习算法**。

这意味着机器学习研究的目标**不是找一个通用学习算法或是绝对最好的学习算法**。反之，我们的目标是理解什么样的分布与人工智能获取经验的 “真实世界” 相关，**什么样的学习算法在我们关注的数据生成分布上效果最好**。

**总结**：没有免费午餐定理清楚地阐述了没有最优的学习算法，即暗示我们必须在特定任务上设计性能良好的机器学习算法。

### 5.2.2 正则化

所谓正则化（Regularization），是指我们通过**修改学习算法，使其降低泛化误差而非训练误差**的方法。

**正则化是一种思想（策略）**，它是机器学习领域的中心问题之一，其重要性只有优化能与其相媲美。

一般正则化一个模型，通常通过对**原始损失函数**引入**额外信息**（也叫惩罚项/正则化项），新的损失函数变成了**原始损失函数 + 惩罚项**对形式。惩罚项通常是对权重参数做一些限制，如 L1/L2 范数：

- L1: $\lambda \cdot \lVert x \rVert_{1}$，即所有元素的绝对值之和
- L2: $\lambda \cdot \lVert x \rVert_{2}$，即所有元素的绝对值平方和

如果正则化项是 $\Omega(w) = w^{\top}w$，则称为**权重衰减**（weight decay）。

在标准的随机梯度下降中，权重衰减正则化和 L2 正则化的效果相同。因此，权重衰减在一些深度学习框架中通过 L2 正则化来实现。加入了正则化项后的损失函数的变化如下：

对于均方差损失函数：

$$J(w,b)=\frac{1}{2m}\sum_{i=1}^m (z_i-y_i)^2 + \frac{\lambda}{2m}\sum_{j=1}^n{w_j^2}$$

对于交叉熵损失函数：

$$J(w,b)= -\frac{1}{m} \sum_{i=1}^m [y_i \ln a_i + (1-y_i) \ln (1-a_i)]+ \frac{\lambda}{2m}\sum_{j=1}^n{w_j^2}$$

其中 $J(w, b)$ 是最终损失函数，$w$ 是权重参数。$\lambda$ 是正则化项的超参数，需提前设置，**其控制我们对较小权重的偏好强度**。当 $\lambda = 0$，我们没有任何偏好。$\lambda$ 越大，则权重越小。最小化 $J(w)$ 会导致权重的选择在**拟合训练数据和较小权重之间进行权衡**。
> 值得注意的是。在较为复杂的优化方法(比如 Adam)中，权重衰减正则化和 L2 正则化并不等价 [Loshchilov et al., 2017b]。

**和上一节没有最优的学习算法一样，一样的，也没有最优的正则化形式**。反之，我们必须挑选一个非常适合于我们所要解决的任务的正则形式。

那么，**L2 正则化为什么能防止过拟合**呢？

我个人理解是，我们一般默认模型参数越小、模型越简单，越简单的模型越不容易过拟合。而 L2 正则化的模型拟合过程中通常都倾向于让权值尽可能小，即最后能构造出一个所有参数都比较小的模型。

有[文章](https://zhuanlan.zhihu.com/p/41631717)通过可视化加入 L1/L2 正则化后的权重分布，得出 L1/L2 正则化如实地将权重往 `0` 的方向赶，即会让权值尽可能小，但是 L1 赶得快，L2 比较慢一些，在 30 epoc h以上 L2 才有类似于 L1 的一枝独秀的分布。

## 5.3 超参数和验证集

**超参数的值不是通过学习算法本身学习出来的，而是需要算法定义者手动指定的**。

### 5.3.1 验证集的作用

通常，`80%` 的训练数据用于训练，`20%` 用于验证。验证集是用于估计训练中或训练后的泛化误差，从而**更新超参数**。

### 5.3.2 交叉验证

一个**小规模的测试集**意味着平均测试误差估计的统计不确定性，使得很难判断算法 A 是否比算法 B 在给定的任务上做得更好。解决办法是基于在原始数据上**随机采样或分离**出的不同数据集上**重复训练和测试**，最常见的就是 $k$-折交叉验证，即将数据集分成 $k$ 个 不重合的子集。测试误差可以估计为 $k$ 次计算后的平均测试误差。在第 $i$ 次测试时， 数据的第 $i$ 个子集用于测试集，其他的数据用于训练集。算法过程如下所示。
> k 折交叉验证虽然一定程度上可以解决小数据集上测试误差的不确定性问题，但代价则是增加了计算量。

![k-折交叉验证算法](../images/ml_basc_principle/k-fold.png)

## 5.4 估计、偏差和方差

统计领域为我们提供了很多工具来实现机器学习目标，不仅可以解决训练集上 的任务，还可以泛化。基本的概念，例如参数估计、偏差和方差，对于正式地刻画泛化、欠拟合和过拟合都非常有帮助。

### 5.4.1 点估计

点估计试图为一些感兴趣的量提供单个 ‘‘最优’’ 预测。一般地，感兴趣的量可以是单个参数也可以是一个向量参数，例如第 5.1.4 节线性回归中的权重，但是也有可能是整个函数。

为了区分参数估计和真实值，我们习惯将参数 $\theta$ 的点估计表示为 $\hat{\theta}$。

令 $x^{(1)}, . . . , x^{(m)}$ 是 $m$ 个独立同分布（i.i.d.）的数据点。 点估计(point esti-mator)或统计量(statistics)是这些数据的任意函数:

$$
\hat{\theta_m} =g(x^{(1)},...,x^{(m)}). \tag{5.19}
$$

### 5.4.2 偏差

估计的偏差定义如下:

$$
bias(\hat{\theta_m}) = E(\hat{\theta_m}) − \theta, \tag{5.19}
$$

其中期望作用在所有数据(看作是从随机变量采样得到的)上，$\hat{\theta}$ 是用于定义数据生成分布的 $\theta$ 的真实值。如果 $bias(\hat{\theta_m}) = 0$，那么估计量 $\hat{\theta_m}$ 则被称为是**无偏** (unbiased)，同时意味着 $E(\hat{\theta_m}) = \theta$。

### 5.4.3 方差和标准差

方差记为 $Var(\hat{\theta})$ 或 $\sigma^{2}$，方差的平方根被称为标准差。

### 5.4.4 权衡偏差和方差以最小化均方误差

偏差和方差度量着估计量的两个不同误差来源。偏差度量着偏离真实函数或参数的误差期望。而方差度量着数据上任意特定采样可能导致的估计期望的偏差。

**偏差和方差的关系和机器学习容量、欠拟合和过拟合的概念紧密相联**。用 MSE 度量泛化误差(偏差和方差对于泛化误差都是有意义的)时，增加容量会增加方差，降低偏差。如图 5.6 所示，我们再次在关于容量的函数中，看到泛化误差的 U 形曲线。

![偏差方差泛化误差和模型容量的关系](../images/ml_basc_principle/figure_5_6.png)

## 5.5 最大似然估计

与其猜测某个函数可能是一个好的估计器，然后分析它的偏差和方差，我们更希望有一些原则，我们可以从中推导出特定的函数，这些函数是不同模型的良好估计器。最大似然估计就是其中最为常用的准则。

## 5.6 贝叶斯统计

到目前为止，我们已经描述了**频率统计**（frequentist statistics）和基于估计单一 $\theta$  值的方法，然后基于该估计作所有的预测。 另一种方法是在进行预测时考虑所有可能的 $\theta$ 值。 后者属于**贝叶斯统计**（Bayesian statistics）的范畴。

如 5.4.1 节中讨论的，频率派的视角是真实参数 $\theta$  是未知的定值，而点估计  $\hat{\theta}$ 是考虑数据集上函数(可以看作是随机的)的随机变量。

贝叶斯统计的视角完全不同。贝叶斯用概率反映知识状态的确定性程度。数据集能够被直接观测到，因此不是随机的。另一方面，真实参数 $\theta$ 是未知或不确定的， 因此可以表示成随机变量。

## 5.7 监督学习算法

回顾 5.1.3 节内容，简单来说，监督学习算法是给定一组输入 $x$ 和输出 $y$ 的训练 集，学习如何关联输入和输出。在许多情况下，输出 $y$ 可能难以自动收集，必须由人类“监督者”提供，但即使训练集目标是自动收集的，该术语仍然适用。

## 5.8 无监督学习算法

回顾第5.1.3节，无监督算法只处理 “特征’’，不操作监督信号。监督和无监督算法之间的区别没有规范严格的定义，因为没有客观的测试来区分一个值是特征还是监督者提供的目标。通俗地说，无监督学习的大多数尝试是指从不需要人为注释的样本的分布中提取信息。该术语通常与密度估计相关，学习从分布中采样、学习从分布中去噪、寻找数据分布的流形或是将数据中相关的样本聚类。

### 5.8.1 PCA 降维

`PCA`（Principal Component Analysis）是学习数据表示的无监督学习算法，常用于高维数据的降维，可用于提取数据的主要特征分量。

PCA 的数学推导可以从最大可分型和最近重构性两方面进行，前者的优化条件为划分后方差最大，后者的优化条件为点到划分平面距离最小。

### 5.8.2 k-均值聚类

另外一个简单的表示学习算法是 $k$-均值聚类。$k$-均值聚类算法将训练集分成 $k$ 个靠近彼此的不同样本聚类。因此我们可以认为该算法提供了 $k$-维的 one-hot 编码向量 $h$ 以表示输入 $x$。当 $x$ 属于聚类 $i$ 时，有 $h_i = 1$，$h$ 的其他项为零。

$k$-均值聚类初始化 k 个不同的中心点 ${μ^{(1)}, . . . , μ^{(k)}}$，然后迭代交换以下两个不同的步骤直到算法收敛。

1. 步骤一，每个训练样本分配到最近的中心点 $μ^{(i) }$ 所代表的聚类 $i$。 
2. 步骤二，每一个中心点 $μ^{(i) }$ 更新为聚类 $i$ 中所有训练样本 $x^{(j)}$ 的均值。

关于聚类的一个问题是**聚类问题本身是病态的**。这是说没有单一的标准去度量聚类的数据在真实世界中效果如何。我们可以度量聚类的性质，例如类中元素到类中心点的欧几里得距离的均值。这使我们可以判断从聚类分配中重建训练数据的效果如何。然而我们不知道聚类的性质是否很好地对应到真实世界的性质。此外，可能有许多不同的聚类都能很好地对应到现实世界的某些属性。我们可能希望找到和 一个特征相关的聚类，但是得到了一个和任务无关的，同样是合理的不同聚类。

例如，假设我们在包含红色卡车图片、红色汽车图片、灰色卡车图片和灰色汽车图片的数据集上运行两个聚类算法。如果每个聚类算法聚两类，那么可能一个算法将汽车和卡车各聚一类，另一个根据红色和灰色各聚一类。假设我们还运行了第三个聚类算法，用来决定类别的数目。这有可能聚成了四类，红色卡车、红色汽车、灰色卡 车和灰色汽车。现在这个新的聚类至少抓住了属性的信息，但是丢失了相似性信息。 红色汽车和灰色汽车在不同的类中，正如红色汽车和灰色卡车也在不同的类中。该聚类算法没有告诉我们灰色汽车和红色汽车的相似度比灰色卡车和红色汽车的相似度更高，我们只知道它们是不同的。

## 5.9 随机梯度下降

几乎所有的深度学习算法都用到了一个非常重要的优化算法: **随机梯度下降** (stochastic gradient descent, `SGD`)。

机器学习中反复出现的一个问题是好的泛化需要大的训练集，但大的训练集的 计算代价也更大。

机器学习算法中的代价函数通常可以分解成每个样本的代价函数的总和。

![sgd](../images/ml_basc_principle/sgd.png)

随机梯度下降的核心是，**梯度是期望**，而期望可使用小规模的样本近似估计。具体来说，在算法的每一步，我们从训练集中均匀抽出一小批量(`minibatch`)样本 $B={x^{(1)},...,x^{(m′)}}$。小批量的数目 $m′$ 通常是一个相对较小的数，一般为 $2^n$（取决于显卡显卡）。重要的是，当训练集大小 m 增长时，$m′$ 通常是固定的。我们可能在拟合几十亿的样本时，但每次更新计算只用到几百个样本。

![sgd2](../images/ml_basc_principle/sgd2.png)

梯度下降往往被认为很慢或不可靠。以前，将梯度下降应用到非凸优化问题被认为很鲁莽或没有原则。但现在，我们知道梯度下降用于深度神经网络模型的训练时效果是不错的。优化算法不一定能保证在合理的时间内达到一个局部最小值，但它通常能及时地找到代价函数一个很小的值，并且是有用的。

随机梯度下降在深度学习之外有很多重要的应用。它是在大规模数据上训练大型线性模型的主要方法。对于固定大小的模型，每一步随机梯度下降更新的计算量 不取决于训练集的大小 m。在实践中，当训练集大小增长时，我们通常会使用一个更大的模型，但这并非是必须的。达到收敛所需的更新次数通常会随训练集规模增大而增加。然而，当 m 趋向于无穷大时，该模型最终会在随机梯度下降抽样完训练 集上的所有样本之前收敛到可能的最优测试误差。继续增加 m 不会延长达到模型可能的最优测试误差的时间。从这点来看，我们可以认为用 SGD 训练模型的渐近代价是关于 m 的函数的 $O(1)$ 级别。

## 5.10 构建机器学习算法 pipeline

几乎所有的深度学习算法都可以被描述为一个相当简单的 `pipeline`: 

1. 特定的数据集
2. 代价函数
3. 优化过程
4. 神经网络模型。

## 参考资料

- 《深度学习》
- [【机器学习】降维——PCA（非常详细）](https://zhuanlan.zhihu.com/p/77151308)
- [更好地理解正则化：可视化模型权重分布](https://zhuanlan.zhihu.com/p/41631717)
