## API Report File for "@handtracking.io/yoha"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

/// <reference types="@types/offscreencanvas" />

// @public
export function ApplyPaddingToCoordinates(padding: number, coords: number[][]): number[][];

// @public
export function CreateMaxFpsMaxResStream(): Promise<IMediaStreamResult>;

// @public
export function CreateVideoElementFromStream(stream: MediaStream): HTMLVideoElement;

// @public
export function DownloadMultipleYohaTfjsModelBlobs(boxUrl: string, lanUrl: string, progressCb: IDownloadProgressCb): Promise<IYohaTfjsModelBlobs>;

// @public
export interface IBlobs {
    blobs: Map<string, Blob>;
}

// @public
export type IDownloadProgressCb = (received: number, total: number) => void;

// @public
export interface IEngineConfig {
    __boxSlack?: number;
    __userFriendlyCoordinateOrder?: boolean;
    minHandPresenceProbabilityThreshold?: number;
    mirrorX?: boolean;
    padding?: number;
}

// @public
export interface IMediaStreamResult {
    error?: ObjValues<typeof MediaStreamErrorEnum>;
    stream?: MediaStream;
}

// @public
export interface IPoseProbabilities {
    fistProb: number;
    pinchProb: number;
}

// @public
export interface IStopEngineCb {
    // (undocumented)
    (): void;
}

// @public
export interface ITfjsWasmBackendConfig {
    wasmPaths: string;
}

// @public
export interface ITrackResult {
    coordinates: number[][];
    isHandPresentProb: number;
    isLeftHandProb: number;
    poses: IPoseProbabilities;
}

// @public
export type ITrackResultCb = (res: ITrackResult) => void;

// @public
export type ITrackSource = HTMLCanvasElement | HTMLVideoElement | HTMLImageElement | OffscreenCanvas;

// @public
export interface IYohaTfjsModelBlobs {
    box: IBlobs;
    lan: IBlobs;
    modelType: 'tfjs';
}

// @public
export const MediaStreamErrorEnum: {
    readonly ABORT_ERROR: "AbortError";
    readonly NOT_ALLOWED_ERROR: "NotAllowedError";
    readonly NOT_FOUND_ERROR: "NotFoundError";
    readonly NOT_READABLE_ERROR: "NotReadableError";
    readonly OVERCONSTRAINTED_ERROR: "OverconstrainedError";
    readonly SECURITY_ERROR: "SecurityError";
    readonly TYPE_ERROR: "TypeError";
};

// @public
export function MirrorCoordinatesHorizontally(coords: number[][]): number[][];

// @public
export type ObjValues<T> = T[keyof T];

// @public
export const RecommendedHandPoseProbabilityThresholds: {
    PINCH: number;
    FIST: number;
    IS_HAND_PRESENT: number;
    IS_LEFT_HAND: number;
};

// @public
export function StartTfjsWasmEngine(engineConfig: IEngineConfig, backendConfig: ITfjsWasmBackendConfig, trackSource: ITrackSource, yohaModels: IYohaTfjsModelBlobs, resCb: ITrackResultCb): Promise<IStopEngineCb>;

// @public
export function StartTfjsWebglEngine(engineConfig: IEngineConfig, trackSource: ITrackSource, yohaModels: IYohaTfjsModelBlobs, resCb: ITrackResultCb): Promise<IStopEngineCb>;

```
