

/**
  ******************************************************************************
  * @file    bluenrg_lp_types.h
  * @author  AMS - RF Application team
  * @date    13 April 2021
  * @brief   Autogenerated files, do not edit!!
  ******************************************************************************
  * @attention
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  *
  * <h2><center>&copy; COPYRIGHT STMicroelectronics</center></h2>
  ******************************************************************************
  */
#ifndef _BLUENRG_LP_TYPES_H_
#define _BLUENRG_LP_TYPES_H_

#include "compiler.h"
#include "ble_const.h"
#include "hal_types.h"
#include "hci.h"
typedef uint8_t tBleStatus;

#include <stdint.h>
typedef tBleStatus (*hci_event_process)(uint8_t *buffer_in);
typedef struct hci_command_table_type_s {
  uint16_t evt_code;
  hci_event_process process;
} hci_events_table_type, hci_le_meta_events_table_type, hci_vendor_specific_events_table_type;

extern const hci_events_table_type hci_events_table[8];
extern const hci_le_meta_events_table_type hci_le_meta_events_table[25];
extern const hci_vendor_specific_events_table_type hci_vendor_specific_events_table[46];
#include <stdint.h>

/** Documentation for C struct Advertising_Set_Parameters_t */
typedef PACKED(struct) packed_Advertising_Set_Parameters_t_s {
  /** It is used to identify an advertising set.
   *  Values:
   *  - 0x00 ... 0xEF
   */
  uint8_t Advertising_Handle;
  /** The Duration[i] parameter indicates the duration for which that advertising set
   *  is enabled. The duration begins at the start of the first advertising
   *  event of this advertising set. The Controller should not start an extended
   *  advertising event that it cannot complete within the duration. Time = N *
   *  10 ms 0x00 means no advertising duration: advertising will continue until
   *  the Host disables it.
   *  Values:
   *  - 0x0000 (0 ms) : No advertising duration
   *  - 0x0001 (10 ms)  ... 0xFFFF (655350 ms) 
   */
  uint16_t Duration;
  /** The Max_Extended_Advertising_Events[i] parameter, if non-zero, indicates the
   *  maximum number of extended advertising events that shall be sent prior to
   *  disabling the extended advertising set even if the Duration[i] parameter
   *  has not expired.
   *  Values:
   *  - 0x00: No maximum number of advertising events.
   *  - 0x01 ... 0xFF: Maximum number of extended advertising events.
   */
  uint8_t Max_Extended_Advertising_Events;
} packed_Advertising_Set_Parameters_t;
/** Documentation for C struct Extended_Scan_Parameters_t */
typedef PACKED(struct) packed_Extended_Scan_Parameters_t_s {
  /** The Scan_Type parameter specifies the type of scan to perform. 0: Passive
   *  Scanning. No scan request PDUs shall be sent. 1: Active Scanning. Scan
   *  request PDUs may be sent.
   *  Values:
   *  - 0x00: Passive Scanning
   *  - 0x01: Active Scanning
   */
  uint8_t Scan_Type;
  /** Time interval from when the Controller started its last scan until it begins the
   *  subsequent scan on the primary advertising channel.  Time = N * 0.625 ms
   *  Values:
   *  - 0x0004 (2.500 ms)  ... 0xFFFF (40959.375 ms) 
   */
  uint16_t Scan_Interval;
  /** Duration of the scan on the primary advertising channel.  Time = N * 0.625 ms
   *  Values:
   *  - 0x0004 (2.500 ms)  ... 0xFFFF (40959.375 ms) 
   */
  uint16_t Scan_Window;
} packed_Extended_Scan_Parameters_t;
/** Documentation for C struct Extended_Create_Connection_Parameters_t */
typedef PACKED(struct) packed_Extended_Create_Connection_Parameters_t_s {
  /** Time interval from when the Controller started its last scan until it begins the
   *  subsequent scan on the primary advertising channel. Time = N * 0.625 ms;
   *  Time Range: 2.5 ms to 40.959375 s.
   *  Values:
   *  - 0x0004 (2.500 ms)  ... 0xFFFF (40959.375 ms) 
   */
  uint16_t Scan_Interval;
  /** Duration of the scan on the primary advertising channel. Time = N * 0.625 ms;
   *  Time Range: 2.5 ms to 40.959375 s.
   *  Values:
   *  - 0x0004 (2.500 ms)  ... 0xFFFF (40959.375 ms) 
   */
  uint16_t Scan_Window;
  /** Mimimun value for the connection interval. This shall be less than or equal to
   *  Conn_Interval_Max[i]. Time = N * 1.25 ms; Time Range: 7.5 ms to 4 s.
   *  Values:
   *  - 0x0006 (7.50 ms)  ... 0x0C80 (4000.00 ms) 
   */
  uint16_t Conn_Interval_Min;
  /** Maximum value for the connection interval. This shall be less than or equal to
   *  Conn_Interval_Max[i]. Time = N * 1.25 ms; Time Range: 7.5 ms to 4 s.
   *  Values:
   *  - 0x0006 (7.50 ms)  ... 0x0C80 (4000.00 ms) 
   */
  uint16_t Conn_Interval_Max;
  /** Slave latency for the connection in number of connection events
   *  Values:
   *  - 0x0000 ... 0x01F3
   */
  uint16_t Conn_Latency;
  /** Supervision timeout for the LE Link. (See [Vol 6] Part B, Section 4.5.2) Time =
   *  N * 10 ms; Time Range: 100 ms to 32 s.
   *  Values:
   *  - 0x000A (100 ms)  ... 0x0C80 (32000 ms) 
   */
  uint16_t Supervision_Timeout;
  /** Informative parameter recommending the minimum length of connection event needed
   *  for this LE connection. Time = N * 0.625 ms.
   *  Values:
   *  - 0x0000 (0.000 ms)  ... 0xFFFF (40959.375 ms) 
   */
  uint16_t Minimum_CE_Length;
  /** Informative parameter recommending the maximum length of connection event needed
   *  for this LE connection. Time = N * 0.625 ms.
   *  Values:
   *  - 0x0000 (0.000 ms)  ... 0xFFFF (40959.375 ms) 
   */
  uint16_t Maximum_CE_Length;
} packed_Extended_Create_Connection_Parameters_t;
/** Documentation for C struct Bonded_Device_Entry_t */
typedef PACKED(struct) packed_Bonded_Device_Entry_t_s {
  /** Address type.
   *  Values:
   *  - 0x00: Public Device Address
   *  - 0x01: Random Device Address
   */
  uint8_t Address_Type;
  /** Identity Address (Public or Random) of the device.
   */
  uint8_t Address[6];
} packed_Bonded_Device_Entry_t;
/** Documentation for C struct List_Entry_t */
typedef PACKED(struct) packed_List_Entry_t_s {
  /** Address type.
   *  Values:
   *  - 0x00: Public Device Address
   *  - 0x01: Random Device Address
   */
  uint8_t Peer_Address_Type;
  /** Public Device Address or Random Device Address of the device to be added to the
   *  list.
   */
  uint8_t Peer_Address[6];
} packed_List_Entry_t;
/** Documentation for C union Service_UUID_t */
typedef PACKED(union) packed_Service_UUID_t_s {
  /** 16-bit UUID
   */
  uint16_t Service_UUID_16;
  /** 128-bit UUID
   */
  uint8_t Service_UUID_128[16];
} packed_Service_UUID_t;
/** Documentation for C union Char_UUID_t */
typedef PACKED(union) packed_Char_UUID_t_s {
  /** 16-bit UUID
   */
  uint16_t Char_UUID_16;
  /** 128-bit UUID
   */
  uint8_t Char_UUID_128[16];
} packed_Char_UUID_t;
/** Documentation for C union Char_Desc_Uuid_t */
typedef PACKED(union) packed_Char_Desc_Uuid_t_s {
  /** 16-bit UUID
   */
  uint16_t Char_UUID_16;
  /** 128-bit UUID
   */
  uint8_t Char_UUID_128[16];
} packed_Char_Desc_Uuid_t;
/** Documentation for C union UUID_t */
typedef PACKED(union) packed_UUID_t_s {
  /** 16-bit UUID
   */
  uint16_t UUID_16;
  /** 128-bit UUID
   */
  uint8_t UUID_128[16];
} packed_UUID_t;
/** Documentation for C struct Handle_Entry_t */
typedef PACKED(struct) packed_Handle_Entry_t_s {
  /** The handles for which the attribute value has to be read
   *  Values:
   *  - 0x0001 ... 0xFFFF
   */
  uint16_t Handle;
} packed_Handle_Entry_t;
/** Documentation for C struct Handle_Packets_Pair_Entry_t */
typedef PACKED(struct) packed_Handle_Packets_Pair_Entry_t_s {
  /** Connection handle
   */
  uint16_t Connection_Handle;
  /** The number of HCI Data Packets that have been completed (transmitted or flushed)
   *  for the associated Connection_Handle since the previous time the event was
   *  returned.
   */
  uint16_t HC_Num_Of_Completed_Packets;
} packed_Handle_Packets_Pair_Entry_t;
/** Documentation for C struct Attribute_Group_Handle_Pair_t */
typedef PACKED(struct) packed_Attribute_Group_Handle_Pair_t_s {
  /** Found Attribute handle
   */
  uint16_t Found_Attribute_Handle;
  /** Group End handle
   */
  uint16_t Group_End_Handle;
} packed_Attribute_Group_Handle_Pair_t;
/** Documentation for C struct Advertising_Report_t */
typedef PACKED(struct) packed_Advertising_Report_t_s {
  /** Type of advertising report event: ADV_IND: Connectable undirected advertising',
   *  ADV_DIRECT_IND: Connectable directed advertising, ADV_SCAN_IND: Scannable
   *  undirected advertising, ADV_NONCONN_IND: Non connectable undirected
   *  advertising, SCAN_RSP: Scan response.
   *  Values:
   *  - 0x00: ADV_IND
   *  - 0x01: ADV_DIRECT_IND
   *  - 0x02: ADV_SCAN_IND
   *  - 0x03: ADV_NONCONN_IND
   *  - 0x04: SCAN_RSP
   */
  uint8_t Event_Type;
  /** 0x00 Public Device Address 0x01 Random Device Address 0x02 Public Identity
   *  Address (Corresponds to Resolved Private Address) 0x03 Random (Static)
   *  Identity Address (Corresponds to Resolved Private Address)
   *  Values:
   *  - 0x00: Public Device Address
   *  - 0x01: Random Device Address
   *  - 0x02: Public Identity Address
   *  - 0x03: Random (Static) Identity Address
   */
  uint8_t Address_Type;
  /** Public Device Address, Random Device Address, Public Identity Address or Random
   *  (static) Identity Address of the advertising device.
   */
  uint8_t Address[6];
  /** Length of the Data[i] field for each device which responded.
   *  Values:
   *  - 0 ... 31
   */
  uint8_t Data_Length;
  /** Data_Length octets of advertising or scan response data formatted as defined in
   *  [Vol 3] Part C, Section 8.
   */
  uint8_t Data[1];
  /** N Size: 1 Octet (signed integer) Units: dBm
   *  Values:
   *  - 127: RSSI not available
   *  - -127 ... 20
   */
  int8_t RSSI;
} packed_Advertising_Report_t;
/** Documentation for C struct Direct_Advertising_Report_t */
typedef PACKED(struct) packed_Direct_Advertising_Report_t_s {
  /** Advertising type
   *  Values:
   *  - 0x01: Connectable directed advertising (ADV_DIRECT_IND)
   */
  uint8_t Event_Type;
  /** 0x00 Public Device Address 0x01 Random Device Address 0x02 Public Identity
   *  Address (Corresponds to Resolved Private Address) 0x03 Random (Static)
   *  Identity Address (Corresponds to Resolved Private Address)
   *  Values:
   *  - 0x00: Public Device Address
   *  - 0x01: Random Device Address
   *  - 0x02: Public Identity Address
   *  - 0x03: Random (Static) Identity Address
   */
  uint8_t Address_Type;
  /** Public Device Address, Random Device Address, Public Identity Address or Random
   *  (static) Identity Address of the advertising device.
   */
  uint8_t Address[6];
  /** 0x01 Random Device Address
   *  Values:
   *  - 0x01: Random Device Address
   */
  uint8_t Direct_Address_Type;
  /** Random Device Address
   */
  uint8_t Direct_Address[6];
  /** N Size: 1 Octet (signed integer) Units: dBm
   *  Values:
   *  - 127: RSSI not available
   *  - -127 ... 20
   */
  int8_t RSSI;
} packed_Direct_Advertising_Report_t;
/** Documentation for C struct Extended_Advertising_Report_t */
typedef PACKED(struct) packed_Extended_Advertising_Report_t_s {
  /** Event Type parameter. Bits from 0 to 4: 0 Connectable advertising 1 Scannable
   *  advertising 2 Directed advertising 3 Scan response 4 Legacy advertising
   *  PDUs used Bits 5-6 Data status: 00b = Complete 01b = Incomplete, more data
   *  to come 10b = Incomplete, data truncated, no more to come 11b = Reserved
   *  for future use
   *  Flags:
   *  - 0x0001: Connectable advertising
   *  - 0x0002: Scannable advertising
   *  - 0x0004: Directed advertising
   *  - 0x0008: Scan response
   *  - 0x0010: Legacy advertising PDUs used
   */
  uint16_t Event_Type;
  /** Address Type
   *  Values:
   *  - 0x00: Public Device Address
   *  - 0x01: Random Device Address
   *  - 0x02: Public Identity Address (corresponds to Resolved Private Address)
   *  - 0x03: Random (static) Identity Address (corresponds to Resolved Private
Address)
   *  - 0xFF: No address provided (anonymous advertisement)
   */
  uint8_t Address_Type;
  /** Public Device Address, Random Device Address, Public Identity Address or Random
   *  (static) Identity Address of the advertising device.
   */
  uint8_t Address[6];
  /** PHY used to send the advertising PDU on the primary advertising physical
   *  channel.
   *  Values:
   *  - 0x01: LE_1M_PHY
   *  - 0x03: LE_CODED_PHY
   */
  uint8_t Primary_PHY;
  /** This parameter indicates the PHY used to send the advertising PDU(s), if any, on
   *  the secondary advertising physical channel.
   *  Values:
   *  - 0x00: No packets
   *  - 0x01: LE_1M_PHY
   *  - 0x02: LE_2M_PHY
   *  - 0x03: LE_CODED_PHY
   */
  uint8_t Secondary_PHY;
  /** Advertising SID subfield in the ADI field of the PDU
   *  Values:
   *  - 0xFF: No ADI field in the PDU
   *  - 0x00 ... 0x0F: Value of the Advertising SID subfield in the ADI field of the PDU
   */
  uint8_t Advertising_SID;
  /** Tx Power. Units: dBm.
   *  Values:
   *  - 127: NA
   *  - -127 ... 126
   */
  int8_t TX_Power;
  /** RSSI value; Units: dBm; All other values Reserved for future use.
   *  Values:
   *  - 127: NA
   *  - -127 ... 20
   */
  int8_t RSSI;
  /** Interval of the periodic advertising. Time = N * 1.25 ms; Time Range: 7.5 ms to
   *  81,918.75 s.
   *  Values:
   *  - 0x0000 (NaN) : No periodic advertising
   *  - 0x0006 (7.50 ms)  ... 0xFFFF (NaN) : Interval of the periodic advertising
   */
  uint16_t Periodic_Advertising_Interval;
  /** Direct address type
   *  Values:
   *  - 0x00: Public Device Address
   *  - 0x01: Random Device Address
   *  - 0x02: Public Identity Address (Corresponds to Resolved Private
Address)
   *  - 0x03: Random (static) Identity Address (Corresponds to Resolved Private
Address)
   *  - 0xFE: Random Device Address (Controller unable to resolve)
   *  - 0xFF: Reserved for future use
   *  - 0x04 ... 0xFD: Reserved for future use
   */
  uint8_t Direct_Address_Type;
  /** Public Device Address, Random Device Address, Public Identity Address or Random
   *  (static) Identity Address of the target device
   */
  uint8_t Direct_Address[6];
  /** Length of the Data[i] field for each device which responded
   *  Values:
   *  - 0 ... 229: Length of the Data[i] field for each device which responded
   *  - 229 ... 255: Reserved for future use
   */
  uint8_t Data_Length;
  /** Data_Length[i] octets of advertising or scan response data formatted as defined
   *  in [Vol 3] Part C, Section 11. Note: Each element of this array has a
   *  variable length.
   */
  uint8_t Data[1];
} packed_Extended_Advertising_Report_t;
/** Documentation for C struct Samples_t */
typedef PACKED(struct) packed_Samples_t_s {
  /** The list of I samples for the reported packet. Each sample is a signed integer.
   *  The list is in the order of the sampling points within the packet.
   */
  uint8_t I_Sample;
  /** The list of Q samples for the reported packet. Each sample is a signed integer.
   *  The list is in the order of the sampling points within the packet.
   */
  uint8_t Q_Sample;
} packed_Samples_t;
typedef PACKED(struct) hci_disconnect_cp0_s {
  uint16_t Connection_Handle;
  uint8_t Reason;
} hci_disconnect_cp0;

typedef PACKED(struct) hci_disconnect_rp0_s {
  uint8_t Status;
} hci_disconnect_rp0;

typedef PACKED(struct) hci_read_remote_version_information_cp0_s {
  uint16_t Connection_Handle;
} hci_read_remote_version_information_cp0;

typedef PACKED(struct) hci_read_remote_version_information_rp0_s {
  uint8_t Status;
} hci_read_remote_version_information_rp0;

typedef PACKED(struct) hci_set_event_mask_cp0_s {
  uint8_t Event_Mask[8];
} hci_set_event_mask_cp0;

typedef PACKED(struct) hci_set_event_mask_rp0_s {
  uint8_t Status;
} hci_set_event_mask_rp0;

typedef PACKED(struct) hci_reset_rp0_s {
  uint8_t Status;
} hci_reset_rp0;

typedef PACKED(struct) hci_read_transmit_power_level_cp0_s {
  uint16_t Connection_Handle;
  uint8_t Type;
} hci_read_transmit_power_level_cp0;

typedef PACKED(struct) hci_read_transmit_power_level_rp0_s {
  uint8_t Status;
  uint16_t Connection_Handle;
  int8_t Transmit_Power_Level;
} hci_read_transmit_power_level_rp0;

typedef PACKED(struct) hci_set_event_mask_page_2_cp0_s {
  uint8_t Event_Mask_Page_2[8];
} hci_set_event_mask_page_2_cp0;

typedef PACKED(struct) hci_set_event_mask_page_2_rp0_s {
  uint8_t Status;
} hci_set_event_mask_page_2_rp0;

typedef PACKED(struct) hci_read_authenticated_payload_timeout_cp0_s {
  uint16_t Connection_Handle;
} hci_read_authenticated_payload_timeout_cp0;

typedef PACKED(struct) hci_read_authenticated_payload_timeout_rp0_s {
  uint8_t Status;
  uint16_t Connection_Handle;
  uint16_t Authenticated_Payload_Timeout;
} hci_read_authenticated_payload_timeout_rp0;

typedef PACKED(struct) hci_write_authenticated_payload_timeout_cp0_s {
  uint16_t Connection_Handle;
  uint16_t Authenticated_Payload_Timeout;
} hci_write_authenticated_payload_timeout_cp0;

typedef PACKED(struct) hci_write_authenticated_payload_timeout_rp0_s {
  uint8_t Status;
  uint16_t Connection_Handle;
} hci_write_authenticated_payload_timeout_rp0;

typedef PACKED(struct) hci_read_local_version_information_rp0_s {
  uint8_t Status;
  uint8_t HCI_Version;
  uint16_t HCI_Revision;
  uint8_t LMP_PAL_Version;
  uint16_t Manufacturer_Name;
  uint16_t LMP_PAL_Subversion;
} hci_read_local_version_information_rp0;

typedef PACKED(struct) hci_read_local_supported_commands_rp0_s {
  uint8_t Status;
  uint8_t Supported_Commands[64];
} hci_read_local_supported_commands_rp0;

typedef PACKED(struct) hci_read_local_supported_features_rp0_s {
  uint8_t Status;
  uint8_t LMP_Features[8];
} hci_read_local_supported_features_rp0;

typedef PACKED(struct) hci_read_bd_addr_rp0_s {
  uint8_t Status;
  uint8_t BD_ADDR[6];
} hci_read_bd_addr_rp0;

typedef PACKED(struct) hci_read_rssi_cp0_s {
  uint16_t Connection_Handle;
} hci_read_rssi_cp0;

typedef PACKED(struct) hci_read_rssi_rp0_s {
  uint8_t Status;
  uint16_t Connection_Handle;
  int8_t RSSI;
} hci_read_rssi_rp0;

typedef PACKED(struct) hci_le_set_event_mask_cp0_s {
  uint8_t LE_Event_Mask[8];
} hci_le_set_event_mask_cp0;

typedef PACKED(struct) hci_le_set_event_mask_rp0_s {
  uint8_t Status;
} hci_le_set_event_mask_rp0;

typedef PACKED(struct) hci_le_read_buffer_size_rp0_s {
  uint8_t Status;
  uint16_t HC_LE_ACL_Data_Packet_Length;
  uint8_t HC_Total_Num_LE_ACL_Data_Packets;
} hci_le_read_buffer_size_rp0;

typedef PACKED(struct) hci_le_read_local_supported_features_rp0_s {
  uint8_t Status;
  uint8_t LE_Features[8];
} hci_le_read_local_supported_features_rp0;

typedef PACKED(struct) hci_le_set_random_address_cp0_s {
  uint8_t Random_Address[6];
} hci_le_set_random_address_cp0;

typedef PACKED(struct) hci_le_set_random_address_rp0_s {
  uint8_t Status;
} hci_le_set_random_address_rp0;

typedef PACKED(struct) hci_le_set_advertising_parameters_cp0_s {
  uint16_t Advertising_Interval_Min;
  uint16_t Advertising_Interval_Max;
  uint8_t Advertising_Type;
  uint8_t Own_Address_Type;
  uint8_t Peer_Address_Type;
  uint8_t Peer_Address[6];
  uint8_t Advertising_Channel_Map;
  uint8_t Advertising_Filter_Policy;
} hci_le_set_advertising_parameters_cp0;

typedef PACKED(struct) hci_le_set_advertising_parameters_rp0_s {
  uint8_t Status;
} hci_le_set_advertising_parameters_rp0;

typedef PACKED(struct) hci_le_read_advertising_channel_tx_power_rp0_s {
  uint8_t Status;
  int8_t Transmit_Power_Level;
} hci_le_read_advertising_channel_tx_power_rp0;

typedef PACKED(struct) hci_le_set_advertising_data_cp0_s {
  uint8_t Advertising_Data_Length;
  uint8_t Advertising_Data[31];
} hci_le_set_advertising_data_cp0;

typedef PACKED(struct) hci_le_set_advertising_data_rp0_s {
  uint8_t Status;
} hci_le_set_advertising_data_rp0;

typedef PACKED(struct) hci_le_set_scan_response_data_cp0_s {
  uint8_t Scan_Response_Data_Length;
  uint8_t Scan_Response_Data[31];
} hci_le_set_scan_response_data_cp0;

typedef PACKED(struct) hci_le_set_scan_response_data_rp0_s {
  uint8_t Status;
} hci_le_set_scan_response_data_rp0;

typedef PACKED(struct) hci_le_set_advertising_enable_cp0_s {
  uint8_t Advertising_Enable;
} hci_le_set_advertising_enable_cp0;

typedef PACKED(struct) hci_le_set_advertising_enable_rp0_s {
  uint8_t Status;
} hci_le_set_advertising_enable_rp0;

typedef PACKED(struct) hci_le_set_scan_parameters_cp0_s {
  uint8_t LE_Scan_Type;
  uint16_t LE_Scan_Interval;
  uint16_t LE_Scan_Window;
  uint8_t Own_Address_Type;
  uint8_t Scanning_Filter_Policy;
} hci_le_set_scan_parameters_cp0;

typedef PACKED(struct) hci_le_set_scan_parameters_rp0_s {
  uint8_t Status;
} hci_le_set_scan_parameters_rp0;

typedef PACKED(struct) hci_le_set_scan_enable_cp0_s {
  uint8_t LE_Scan_Enable;
  uint8_t Filter_Duplicates;
} hci_le_set_scan_enable_cp0;

typedef PACKED(struct) hci_le_set_scan_enable_rp0_s {
  uint8_t Status;
} hci_le_set_scan_enable_rp0;

typedef PACKED(struct) hci_le_create_connection_cp0_s {
  uint16_t LE_Scan_Interval;
  uint16_t LE_Scan_Window;
  uint8_t Initiator_Filter_Policy;
  uint8_t Peer_Address_Type;
  uint8_t Peer_Address[6];
  uint8_t Own_Address_Type;
  uint16_t Conn_Interval_Min;
  uint16_t Conn_Interval_Max;
  uint16_t Conn_Latency;
  uint16_t Supervision_Timeout;
  uint16_t Minimum_CE_Length;
  uint16_t Maximum_CE_Length;
} hci_le_create_connection_cp0;

typedef PACKED(struct) hci_le_create_connection_rp0_s {
  uint8_t Status;
} hci_le_create_connection_rp0;

typedef PACKED(struct) hci_le_create_connection_cancel_rp0_s {
  uint8_t Status;
} hci_le_create_connection_cancel_rp0;

typedef PACKED(struct) hci_le_read_white_list_size_rp0_s {
  uint8_t Status;
  uint8_t White_List_Size;
} hci_le_read_white_list_size_rp0;

typedef PACKED(struct) hci_le_clear_white_list_rp0_s {
  uint8_t Status;
} hci_le_clear_white_list_rp0;

typedef PACKED(struct) hci_le_add_device_to_white_list_cp0_s {
  uint8_t Address_Type;
  uint8_t Address[6];
} hci_le_add_device_to_white_list_cp0;

typedef PACKED(struct) hci_le_add_device_to_white_list_rp0_s {
  uint8_t Status;
} hci_le_add_device_to_white_list_rp0;

typedef PACKED(struct) hci_le_remove_device_from_white_list_cp0_s {
  uint8_t Address_Type;
  uint8_t Address[6];
} hci_le_remove_device_from_white_list_cp0;

typedef PACKED(struct) hci_le_remove_device_from_white_list_rp0_s {
  uint8_t Status;
} hci_le_remove_device_from_white_list_rp0;

typedef PACKED(struct) hci_le_connection_update_cp0_s {
  uint16_t Connection_Handle;
  uint16_t Conn_Interval_Min;
  uint16_t Conn_Interval_Max;
  uint16_t Conn_Latency;
  uint16_t Supervision_Timeout;
  uint16_t Minimum_CE_Length;
  uint16_t Maximum_CE_Length;
} hci_le_connection_update_cp0;

typedef PACKED(struct) hci_le_connection_update_rp0_s {
  uint8_t Status;
} hci_le_connection_update_rp0;

typedef PACKED(struct) hci_le_set_host_channel_classification_cp0_s {
  uint8_t LE_Channel_Map[5];
} hci_le_set_host_channel_classification_cp0;

typedef PACKED(struct) hci_le_set_host_channel_classification_rp0_s {
  uint8_t Status;
} hci_le_set_host_channel_classification_rp0;

typedef PACKED(struct) hci_le_read_channel_map_cp0_s {
  uint16_t Connection_Handle;
} hci_le_read_channel_map_cp0;

typedef PACKED(struct) hci_le_read_channel_map_rp0_s {
  uint8_t Status;
  uint16_t Connection_Handle;
  uint8_t LE_Channel_Map[5];
} hci_le_read_channel_map_rp0;

typedef PACKED(struct) hci_le_read_remote_used_features_cp0_s {
  uint16_t Connection_Handle;
} hci_le_read_remote_used_features_cp0;

typedef PACKED(struct) hci_le_read_remote_used_features_rp0_s {
  uint8_t Status;
} hci_le_read_remote_used_features_rp0;

typedef PACKED(struct) hci_le_encrypt_cp0_s {
  uint8_t Key[16];
  uint8_t Plaintext_Data[16];
} hci_le_encrypt_cp0;

typedef PACKED(struct) hci_le_encrypt_rp0_s {
  uint8_t Status;
  uint8_t Encrypted_Data[16];
} hci_le_encrypt_rp0;

typedef PACKED(struct) hci_le_rand_rp0_s {
  uint8_t Status;
  uint8_t Random_Number[8];
} hci_le_rand_rp0;

typedef PACKED(struct) hci_le_start_encryption_cp0_s {
  uint16_t Connection_Handle;
  uint8_t Random_Number[8];
  uint16_t Encrypted_Diversifier;
  uint8_t Long_Term_Key[16];
} hci_le_start_encryption_cp0;

typedef PACKED(struct) hci_le_start_encryption_rp0_s {
  uint8_t Status;
} hci_le_start_encryption_rp0;

typedef PACKED(struct) hci_le_long_term_key_request_reply_cp0_s {
  uint16_t Connection_Handle;
  uint8_t Long_Term_Key[16];
} hci_le_long_term_key_request_reply_cp0;

typedef PACKED(struct) hci_le_long_term_key_request_reply_rp0_s {
  uint8_t Status;
  uint16_t Connection_Handle;
} hci_le_long_term_key_request_reply_rp0;

typedef PACKED(struct) hci_le_long_term_key_requested_negative_reply_cp0_s {
  uint16_t Connection_Handle;
} hci_le_long_term_key_requested_negative_reply_cp0;

typedef PACKED(struct) hci_le_long_term_key_requested_negative_reply_rp0_s {
  uint8_t Status;
  uint16_t Connection_Handle;
} hci_le_long_term_key_requested_negative_reply_rp0;

typedef PACKED(struct) hci_le_read_supported_states_rp0_s {
  uint8_t Status;
  uint8_t LE_States[8];
} hci_le_read_supported_states_rp0;

typedef PACKED(struct) hci_le_receiver_test_cp0_s {
  uint8_t RX_Frequency;
} hci_le_receiver_test_cp0;

typedef PACKED(struct) hci_le_receiver_test_rp0_s {
  uint8_t Status;
} hci_le_receiver_test_rp0;

typedef PACKED(struct) hci_le_transmitter_test_cp0_s {
  uint8_t TX_Frequency;
  uint8_t Length_Of_Test_Data;
  uint8_t Packet_Payload;
} hci_le_transmitter_test_cp0;

typedef PACKED(struct) hci_le_transmitter_test_rp0_s {
  uint8_t Status;
} hci_le_transmitter_test_rp0;

typedef PACKED(struct) hci_le_test_end_rp0_s {
  uint8_t Status;
  uint16_t Number_Of_Packets;
} hci_le_test_end_rp0;

typedef PACKED(struct) hci_le_set_data_length_cp0_s {
  uint16_t Connection_Handle;
  uint16_t TxOctets;
  uint16_t TxTime;
} hci_le_set_data_length_cp0;

typedef PACKED(struct) hci_le_set_data_length_rp0_s {
  uint8_t Status;
  uint16_t Connection_Handle;
} hci_le_set_data_length_rp0;

typedef PACKED(struct) hci_le_read_suggested_default_data_length_rp0_s {
  uint8_t Status;
  uint16_t SuggestedMaxTxOctets;
  uint16_t SuggestedMaxTxTime;
} hci_le_read_suggested_default_data_length_rp0;

typedef PACKED(struct) hci_le_write_suggested_default_data_length_cp0_s {
  uint16_t SuggestedMaxTxOctets;
  uint16_t SuggestedMaxTxTime;
} hci_le_write_suggested_default_data_length_cp0;

typedef PACKED(struct) hci_le_write_suggested_default_data_length_rp0_s {
  uint8_t Status;
} hci_le_write_suggested_default_data_length_rp0;

typedef PACKED(struct) hci_le_read_local_p256_public_key_rp0_s {
  uint8_t Status;
} hci_le_read_local_p256_public_key_rp0;

typedef PACKED(struct) hci_le_generate_dhkey_cp0_s {
  uint8_t Remote_P256_Public_Key[64];
} hci_le_generate_dhkey_cp0;

typedef PACKED(struct) hci_le_generate_dhkey_rp0_s {
  uint8_t Status;
} hci_le_generate_dhkey_rp0;

typedef PACKED(struct) hci_le_add_device_to_resolving_list_cp0_s {
  uint8_t Peer_Identity_Address_Type;
  uint8_t Peer_Identity_Address[6];
  uint8_t Peer_IRK[16];
  uint8_t Local_IRK[16];
} hci_le_add_device_to_resolving_list_cp0;

typedef PACKED(struct) hci_le_add_device_to_resolving_list_rp0_s {
  uint8_t Status;
} hci_le_add_device_to_resolving_list_rp0;

typedef PACKED(struct) hci_le_remove_device_from_resolving_list_cp0_s {
  uint8_t Peer_Identity_Address_Type;
  uint8_t Peer_Identity_Address[6];
} hci_le_remove_device_from_resolving_list_cp0;

typedef PACKED(struct) hci_le_remove_device_from_resolving_list_rp0_s {
  uint8_t Status;
} hci_le_remove_device_from_resolving_list_rp0;

typedef PACKED(struct) hci_le_clear_resolving_list_rp0_s {
  uint8_t Status;
} hci_le_clear_resolving_list_rp0;

typedef PACKED(struct) hci_le_read_resolving_list_size_rp0_s {
  uint8_t Status;
  uint8_t Resolving_List_Size;
} hci_le_read_resolving_list_size_rp0;

typedef PACKED(struct) hci_le_read_peer_resolvable_address_cp0_s {
  uint8_t Peer_Identity_Address_Type;
  uint8_t Peer_Identity_Address[6];
} hci_le_read_peer_resolvable_address_cp0;

typedef PACKED(struct) hci_le_read_peer_resolvable_address_rp0_s {
  uint8_t Status;
  uint8_t Peer_Resolvable_Address[6];
} hci_le_read_peer_resolvable_address_rp0;

typedef PACKED(struct) hci_le_read_local_resolvable_address_cp0_s {
  uint8_t Peer_Identity_Address_Type;
  uint8_t Peer_Identity_Address[6];
} hci_le_read_local_resolvable_address_cp0;

typedef PACKED(struct) hci_le_read_local_resolvable_address_rp0_s {
  uint8_t Status;
  uint8_t Local_Resolvable_Address[6];
} hci_le_read_local_resolvable_address_rp0;

typedef PACKED(struct) hci_le_set_address_resolution_enable_cp0_s {
  uint8_t Address_Resolution_Enable;
} hci_le_set_address_resolution_enable_cp0;

typedef PACKED(struct) hci_le_set_address_resolution_enable_rp0_s {
  uint8_t Status;
} hci_le_set_address_resolution_enable_rp0;

typedef PACKED(struct) hci_le_set_resolvable_private_address_timeout_cp0_s {
  uint16_t RPA_Timeout;
} hci_le_set_resolvable_private_address_timeout_cp0;

typedef PACKED(struct) hci_le_set_resolvable_private_address_timeout_rp0_s {
  uint8_t Status;
} hci_le_set_resolvable_private_address_timeout_rp0;

typedef PACKED(struct) hci_le_read_maximum_data_length_rp0_s {
  uint8_t Status;
  uint16_t supportedMaxTxOctets;
  uint16_t supportedMaxTxTime;
  uint16_t supportedMaxRxOctets;
  uint16_t supportedMaxRxTime;
} hci_le_read_maximum_data_length_rp0;

typedef PACKED(struct) hci_le_read_phy_cp0_s {
  uint16_t Connection_Handle;
} hci_le_read_phy_cp0;

typedef PACKED(struct) hci_le_read_phy_rp0_s {
  uint8_t Status;
  uint16_t Connection_Handle;
  uint8_t TX_PHY;
  uint8_t RX_PHY;
} hci_le_read_phy_rp0;

typedef PACKED(struct) hci_le_set_default_phy_cp0_s {
  uint8_t ALL_PHYS;
  uint8_t TX_PHYS;
  uint8_t RX_PHYS;
} hci_le_set_default_phy_cp0;

typedef PACKED(struct) hci_le_set_default_phy_rp0_s {
  uint8_t Status;
} hci_le_set_default_phy_rp0;

typedef PACKED(struct) hci_le_set_phy_cp0_s {
  uint16_t Connection_Handle;
  uint8_t ALL_PHYS;
  uint8_t TX_PHYS;
  uint8_t RX_PHYS;
  uint16_t PHY_options;
} hci_le_set_phy_cp0;

typedef PACKED(struct) hci_le_set_phy_rp0_s {
  uint8_t Status;
} hci_le_set_phy_rp0;

typedef PACKED(struct) hci_le_enhanced_receiver_test_cp0_s {
  uint8_t RX_Channel;
  uint8_t PHY;
  uint8_t Modulation_index;
} hci_le_enhanced_receiver_test_cp0;

typedef PACKED(struct) hci_le_enhanced_receiver_test_rp0_s {
  uint8_t Status;
} hci_le_enhanced_receiver_test_rp0;

typedef PACKED(struct) hci_le_enhanced_transmitter_test_cp0_s {
  uint8_t TX_Channel;
  uint8_t Length_Of_Test_Data;
  uint8_t Packet_Payload;
  uint8_t PHY;
} hci_le_enhanced_transmitter_test_cp0;

typedef PACKED(struct) hci_le_enhanced_transmitter_test_rp0_s {
  uint8_t Status;
} hci_le_enhanced_transmitter_test_rp0;

typedef PACKED(struct) hci_le_set_advertising_set_random_address_cp0_s {
  uint8_t Advertising_Handle;
  uint8_t Advertising_Random_Address[6];
} hci_le_set_advertising_set_random_address_cp0;

typedef PACKED(struct) hci_le_set_advertising_set_random_address_rp0_s {
  uint8_t Status;
} hci_le_set_advertising_set_random_address_rp0;

typedef PACKED(struct) hci_le_set_extended_advertising_parameters_cp0_s {
  uint8_t Advertising_Handle;
  uint16_t Advertising_Event_Properties;
  uint8_t Primary_Advertising_Interval_Min[3];
  uint8_t Primary_Advertising_Interval_Max[3];
  uint8_t Primary_Advertising_Channel_Map;
  uint8_t Own_Address_Type;
  uint8_t Peer_Address_Type;
  uint8_t Peer_Address[6];
  uint8_t Advertising_Filter_Policy;
  int8_t Advertising_Tx_Power;
  uint8_t Primary_Advertising_PHY;
  uint8_t Secondary_Advertising_Max_Skip;
  uint8_t Secondary_Advertising_PHY;
  uint8_t Advertising_SID;
  uint8_t Scan_Request_Notification_Enable;
} hci_le_set_extended_advertising_parameters_cp0;

typedef PACKED(struct) hci_le_set_extended_advertising_parameters_rp0_s {
  uint8_t Status;
  int8_t Selected_Tx_Power;
} hci_le_set_extended_advertising_parameters_rp0;

typedef PACKED(struct) hci_le_set_extended_advertising_data_cp0_s {
  uint8_t Advertising_Handle;
  uint8_t Operation;
  uint8_t Fragment_Preference;
  uint8_t Advertising_Data_Length;
  uint8_t Advertising_Data[(HCI_MAX_PAYLOAD_SIZE - 4)/sizeof(uint8_t)];
} hci_le_set_extended_advertising_data_cp0;

typedef PACKED(struct) hci_le_set_extended_advertising_data_rp0_s {
  uint8_t Status;
} hci_le_set_extended_advertising_data_rp0;

typedef PACKED(struct) hci_le_set_extended_scan_response_data_cp0_s {
  uint8_t Advertising_Handle;
  uint8_t Operation;
  uint8_t Fragment_Preference;
  uint8_t Scan_Response_Data_Length;
  uint8_t Scan_Response_Data[(HCI_MAX_PAYLOAD_SIZE - 4)/sizeof(uint8_t)];
} hci_le_set_extended_scan_response_data_cp0;

typedef PACKED(struct) hci_le_set_extended_scan_response_data_rp0_s {
  uint8_t Status;
} hci_le_set_extended_scan_response_data_rp0;

typedef PACKED(struct) hci_le_set_extended_advertising_enable_cp0_s {
  uint8_t Enable;
  uint8_t Number_of_Sets;
  packed_Advertising_Set_Parameters_t Advertising_Set_Parameters[(HCI_MAX_PAYLOAD_SIZE - 2)/sizeof(packed_Advertising_Set_Parameters_t)];
} hci_le_set_extended_advertising_enable_cp0;

typedef PACKED(struct) hci_le_set_extended_advertising_enable_rp0_s {
  uint8_t Status;
} hci_le_set_extended_advertising_enable_rp0;

typedef PACKED(struct) hci_le_read_maximum_advertising_data_length_rp0_s {
  uint8_t Status;
  uint16_t Maximum_Advertising_Data_Length;
} hci_le_read_maximum_advertising_data_length_rp0;

typedef PACKED(struct) hci_le_read_number_of_supported_advertising_sets_rp0_s {
  uint8_t Status;
  uint8_t Num_Supported_Advertising_Sets;
} hci_le_read_number_of_supported_advertising_sets_rp0;

typedef PACKED(struct) hci_le_remove_advertising_set_cp0_s {
  uint8_t Advertising_Handle;
} hci_le_remove_advertising_set_cp0;

typedef PACKED(struct) hci_le_remove_advertising_set_rp0_s {
  uint8_t Status;
} hci_le_remove_advertising_set_rp0;

typedef PACKED(struct) hci_le_clear_advertising_sets_rp0_s {
  uint8_t Status;
} hci_le_clear_advertising_sets_rp0;

typedef PACKED(struct) hci_le_set_periodic_advertising_parameters_cp0_s {
  uint8_t Advertising_Handle;
  uint16_t Periodic_Advertising_Interval_Min;
  uint16_t Periodic_Advertising_Interval_Max;
  uint16_t Periodic_Advertising_Properties;
} hci_le_set_periodic_advertising_parameters_cp0;

typedef PACKED(struct) hci_le_set_periodic_advertising_parameters_rp0_s {
  uint8_t Status;
} hci_le_set_periodic_advertising_parameters_rp0;

typedef PACKED(struct) hci_le_set_periodic_advertising_data_cp0_s {
  uint8_t Advertising_Handle;
  uint8_t Operation;
  uint8_t Advertising_Data_Length;
  uint8_t Advertising_Data[(HCI_MAX_PAYLOAD_SIZE - 3)/sizeof(uint8_t)];
} hci_le_set_periodic_advertising_data_cp0;

typedef PACKED(struct) hci_le_set_periodic_advertising_data_rp0_s {
  uint8_t Status;
} hci_le_set_periodic_advertising_data_rp0;

typedef PACKED(struct) hci_le_set_periodic_advertising_enable_cp0_s {
  uint8_t Enable;
  uint8_t Advertising_Handle;
} hci_le_set_periodic_advertising_enable_cp0;

typedef PACKED(struct) hci_le_set_periodic_advertising_enable_rp0_s {
  uint8_t Status;
} hci_le_set_periodic_advertising_enable_rp0;

typedef PACKED(struct) hci_le_set_extended_scan_parameters_cp0_s {
  uint8_t Own_Address_Type;
  uint8_t Scanning_Filter_Policy;
  uint8_t Scanning_PHYs;
  packed_Extended_Scan_Parameters_t Extended_Scan_Parameters[(HCI_MAX_PAYLOAD_SIZE - 3)/sizeof(packed_Extended_Scan_Parameters_t)];
} hci_le_set_extended_scan_parameters_cp0;

typedef PACKED(struct) hci_le_set_extended_scan_parameters_rp0_s {
  uint8_t Status;
} hci_le_set_extended_scan_parameters_rp0;

typedef PACKED(struct) hci_le_set_extended_scan_enable_cp0_s {
  uint8_t Enable;
  uint8_t Filter_Duplicates;
  uint16_t Duration;
  uint16_t Period;
} hci_le_set_extended_scan_enable_cp0;

typedef PACKED(struct) hci_le_set_extended_scan_enable_rp0_s {
  uint8_t Status;
} hci_le_set_extended_scan_enable_rp0;

typedef PACKED(struct) hci_le_extended_create_connection_cp0_s {
  uint8_t Initiating_Filter_Policy;
  uint8_t Own_Address_Type;
  uint8_t Peer_Address_Type;
  uint8_t Peer_Address[6];
  uint8_t Initiating_PHYs;
  packed_Extended_Create_Connection_Parameters_t Extended_Create_Connection_Parameters[(HCI_MAX_PAYLOAD_SIZE - 10)/sizeof(packed_Extended_Create_Connection_Parameters_t)];
} hci_le_extended_create_connection_cp0;

typedef PACKED(struct) hci_le_extended_create_connection_rp0_s {
  uint8_t Status;
} hci_le_extended_create_connection_rp0;

typedef PACKED(struct) hci_le_periodic_advertising_create_sync_cp0_s {
  uint8_t Options;
  uint8_t Advertising_SID;
  uint8_t Advertising_Address_Type;
  uint8_t Advertiser_Address[6];
  uint16_t Skip;
  uint16_t Sync_Timeout;
  uint8_t Sync_CTE_Type;
} hci_le_periodic_advertising_create_sync_cp0;

typedef PACKED(struct) hci_le_periodic_advertising_create_sync_rp0_s {
  uint8_t Status;
} hci_le_periodic_advertising_create_sync_rp0;

typedef PACKED(struct) hci_le_periodic_advertising_create_sync_cancel_rp0_s {
  uint8_t Status;
} hci_le_periodic_advertising_create_sync_cancel_rp0;

typedef PACKED(struct) hci_le_periodic_advertising_terminate_sync_cp0_s {
  uint16_t Sync_Handle;
} hci_le_periodic_advertising_terminate_sync_cp0;

typedef PACKED(struct) hci_le_periodic_advertising_terminate_sync_rp0_s {
  uint8_t Status;
} hci_le_periodic_advertising_terminate_sync_rp0;

typedef PACKED(struct) hci_le_add_device_to_periodic_advertiser_list_cp0_s {
  uint8_t Advertiser_Address_Type;
  uint8_t Advertiser_Address[6];
  uint8_t Advertising_SID;
} hci_le_add_device_to_periodic_advertiser_list_cp0;

typedef PACKED(struct) hci_le_add_device_to_periodic_advertiser_list_rp0_s {
  uint8_t Status;
} hci_le_add_device_to_periodic_advertiser_list_rp0;

typedef PACKED(struct) hci_le_remove_device_from_periodic_advertising_list_cp0_s {
  uint8_t Advertiser_Address_Type;
  uint8_t Advertiser_Address[6];
  uint8_t Advertising_SID;
} hci_le_remove_device_from_periodic_advertising_list_cp0;

typedef PACKED(struct) hci_le_remove_device_from_periodic_advertising_list_rp0_s {
  uint8_t Status;
} hci_le_remove_device_from_periodic_advertising_list_rp0;

typedef PACKED(struct) hci_le_clear_periodic_advertiser_list_rp0_s {
  uint8_t Status;
} hci_le_clear_periodic_advertiser_list_rp0;

typedef PACKED(struct) hci_le_read_periodic_advertiser_list_size_rp0_s {
  uint8_t Status;
  uint8_t Periodic_Advertiser_List_Size;
} hci_le_read_periodic_advertiser_list_size_rp0;

typedef PACKED(struct) hci_le_read_transmit_power_rp0_s {
  uint8_t Status;
  int8_t Min_Tx_Power;
  int8_t Max_Tx_Power;
} hci_le_read_transmit_power_rp0;

typedef PACKED(struct) hci_le_read_rf_path_compensation_rp0_s {
  uint8_t Status;
  int16_t RF_TX_Path_Compensation_Value;
  int16_t RF_RX_Path_Compensation_Value;
} hci_le_read_rf_path_compensation_rp0;

typedef PACKED(struct) hci_le_write_rf_path_compensation_cp0_s {
  int16_t RF_TX_Path_Compensation_Value;
  int16_t RF_RX_Path_Compensation_Value;
} hci_le_write_rf_path_compensation_cp0;

typedef PACKED(struct) hci_le_write_rf_path_compensation_rp0_s {
  uint8_t Status;
} hci_le_write_rf_path_compensation_rp0;

typedef PACKED(struct) hci_le_set_privacy_mode_cp0_s {
  uint8_t Peer_Identity_Address_Type;
  uint8_t Peer_Identity_Address[6];
  uint8_t Privacy_Mode;
} hci_le_set_privacy_mode_cp0;

typedef PACKED(struct) hci_le_set_privacy_mode_rp0_s {
  uint8_t Status;
} hci_le_set_privacy_mode_rp0;

typedef PACKED(struct) hci_le_receiver_test_v3_cp0_s {
  uint8_t RX_Channel;
  uint8_t PHY;
  uint8_t Modulation_Index;
  uint8_t Expected_CTE_Length;
  uint8_t Expected_CTE_Type;
  uint8_t Slot_Durations;
  uint8_t Switching_Pattern_Length;
  uint8_t Antenna_IDs[(HCI_MAX_PAYLOAD_SIZE - 7)/sizeof(uint8_t)];
} hci_le_receiver_test_v3_cp0;

typedef PACKED(struct) hci_le_receiver_test_v3_rp0_s {
  uint8_t Status;
} hci_le_receiver_test_v3_rp0;

typedef PACKED(struct) hci_le_transmitter_test_v3_cp0_s {
  uint8_t TX_Channel;
  uint8_t Test_Data_Length;
  uint8_t Packet_Payload;
  uint8_t PHY;
  uint8_t CTE_Length;
  uint8_t CTE_Type;
  uint8_t Switching_Pattern_Length;
  uint8_t Antenna_IDs[(HCI_MAX_PAYLOAD_SIZE - 7)/sizeof(uint8_t)];
} hci_le_transmitter_test_v3_cp0;

typedef PACKED(struct) hci_le_transmitter_test_v3_rp0_s {
  uint8_t Status;
} hci_le_transmitter_test_v3_rp0;

typedef PACKED(struct) hci_le_set_connectionless_cte_transmit_parameters_cp0_s {
  uint8_t Advertising_Handle;
  uint8_t CTE_Length;
  uint8_t CTE_Type;
  uint8_t CTE_Count;
  uint8_t Switching_Pattern_Length;
  uint8_t Antenna_IDs[(HCI_MAX_PAYLOAD_SIZE - 5)/sizeof(uint8_t)];
} hci_le_set_connectionless_cte_transmit_parameters_cp0;

typedef PACKED(struct) hci_le_set_connectionless_cte_transmit_parameters_rp0_s {
  uint8_t Status;
} hci_le_set_connectionless_cte_transmit_parameters_rp0;

typedef PACKED(struct) hci_le_set_connectionless_cte_transmit_enable_cp0_s {
  uint8_t Advertising_Handle;
  uint8_t CTE_Enable;
} hci_le_set_connectionless_cte_transmit_enable_cp0;

typedef PACKED(struct) hci_le_set_connectionless_cte_transmit_enable_rp0_s {
  uint8_t Status;
} hci_le_set_connectionless_cte_transmit_enable_rp0;

typedef PACKED(struct) hci_le_set_connectionless_iq_sampling_enable_cp0_s {
  uint16_t Sync_Handle;
  uint8_t Sampling_Enable;
  uint8_t Slot_Durations;
  uint8_t Max_Sampled_CTEs;
  uint8_t Switching_Pattern_Length;
  uint8_t Antenna_IDs[(HCI_MAX_PAYLOAD_SIZE - 6)/sizeof(uint8_t)];
} hci_le_set_connectionless_iq_sampling_enable_cp0;

typedef PACKED(struct) hci_le_set_connectionless_iq_sampling_enable_rp0_s {
  uint8_t Status;
  uint16_t Sync_Handle;
} hci_le_set_connectionless_iq_sampling_enable_rp0;

typedef PACKED(struct) hci_le_set_connection_cte_receive_parameters_cp0_s {
  uint16_t Connection_Handle;
  uint8_t Sampling_Enable;
  uint8_t Slot_Durations;
  uint8_t Switching_Pattern_Length;
  uint8_t Antenna_IDs[(HCI_MAX_PAYLOAD_SIZE - 5)/sizeof(uint8_t)];
} hci_le_set_connection_cte_receive_parameters_cp0;

typedef PACKED(struct) hci_le_set_connection_cte_receive_parameters_rp0_s {
  uint8_t Status;
  uint16_t Connection_Handle;
} hci_le_set_connection_cte_receive_parameters_rp0;

typedef PACKED(struct) hci_le_set_connection_cte_transmit_parameters_cp0_s {
  uint16_t Connection_Handle;
  uint8_t CTE_Type;
  uint8_t Switching_Pattern_Length;
  uint8_t Antenna_IDs[(HCI_MAX_PAYLOAD_SIZE - 4)/sizeof(uint8_t)];
} hci_le_set_connection_cte_transmit_parameters_cp0;

typedef PACKED(struct) hci_le_set_connection_cte_transmit_parameters_rp0_s {
  uint8_t Status;
  uint16_t Connection_Handle;
} hci_le_set_connection_cte_transmit_parameters_rp0;

typedef PACKED(struct) hci_le_connection_cte_request_enable_cp0_s {
  uint16_t Connection_Handle;
  uint8_t Enable;
  uint16_t CTE_Request_Interval;
  uint8_t Requested_CTE_Length;
  uint8_t Requested_CTE_Type;
} hci_le_connection_cte_request_enable_cp0;

typedef PACKED(struct) hci_le_connection_cte_request_enable_rp0_s {
  uint8_t Status;
  uint16_t Connection_Handle;
} hci_le_connection_cte_request_enable_rp0;

typedef PACKED(struct) hci_le_connection_cte_response_enable_cp0_s {
  uint16_t Connection_Handle;
  uint8_t Enable;
} hci_le_connection_cte_response_enable_cp0;

typedef PACKED(struct) hci_le_connection_cte_response_enable_rp0_s {
  uint8_t Status;
  uint16_t Connection_Handle;
} hci_le_connection_cte_response_enable_rp0;

typedef PACKED(struct) hci_le_read_antenna_information_rp0_s {
  uint8_t Status;
  uint8_t Supported_Switching_Sampling_Rates;
  uint8_t Num_Antennae;
  uint8_t Max_Switching_Pattern_Length;
  uint8_t Max_CTE_Length;
} hci_le_read_antenna_information_rp0;

typedef PACKED(struct) hci_le_set_periodic_advertising_receive_enable_cp0_s {
  uint16_t Sync_Handle;
  uint8_t Enable;
} hci_le_set_periodic_advertising_receive_enable_cp0;

typedef PACKED(struct) hci_le_set_periodic_advertising_receive_enable_rp0_s {
  uint8_t Status;
} hci_le_set_periodic_advertising_receive_enable_rp0;

typedef PACKED(struct) hci_le_periodic_advertising_sync_transfer_cp0_s {
  uint16_t Connection_Handle;
  uint16_t Service_Data;
  uint16_t Sync_Handle;
} hci_le_periodic_advertising_sync_transfer_cp0;

typedef PACKED(struct) hci_le_periodic_advertising_sync_transfer_rp0_s {
  uint8_t Status;
  uint16_t Connection_Handle;
} hci_le_periodic_advertising_sync_transfer_rp0;

typedef PACKED(struct) hci_le_periodic_advertising_set_info_transfer_cp0_s {
  uint16_t Connection_Handle;
  uint16_t Service_Data;
  uint8_t Advertising_Handle;
} hci_le_periodic_advertising_set_info_transfer_cp0;

typedef PACKED(struct) hci_le_periodic_advertising_set_info_transfer_rp0_s {
  uint8_t Status;
  uint16_t Connection_Handle;
} hci_le_periodic_advertising_set_info_transfer_rp0;

typedef PACKED(struct) hci_le_set_periodic_advertising_sync_transfer_parameters_cp0_s {
  uint16_t Connection_Handle;
  uint8_t Mode;
  uint16_t Skip;
  uint16_t Sync_Timeout;
  uint8_t CTE_Type;
} hci_le_set_periodic_advertising_sync_transfer_parameters_cp0;

typedef PACKED(struct) hci_le_set_periodic_advertising_sync_transfer_parameters_rp0_s {
  uint8_t Status;
  uint16_t Connection_Handle;
} hci_le_set_periodic_advertising_sync_transfer_parameters_rp0;

typedef PACKED(struct) hci_le_set_default_periodic_advertising_sync_transfer_parameters_cp0_s {
  uint8_t Mode;
  uint16_t Skip;
  uint16_t Sync_Timeout;
  uint8_t CTE_Type;
} hci_le_set_default_periodic_advertising_sync_transfer_parameters_cp0;

typedef PACKED(struct) hci_le_set_default_periodic_advertising_sync_transfer_parameters_rp0_s {
  uint8_t Status;
} hci_le_set_default_periodic_advertising_sync_transfer_parameters_rp0;

typedef PACKED(struct) hci_le_enhanced_read_transmit_power_level_cp0_s {
  uint16_t Connection_Handle;
  uint8_t PHY;
} hci_le_enhanced_read_transmit_power_level_cp0;

typedef PACKED(struct) hci_le_enhanced_read_transmit_power_level_rp0_s {
  uint8_t Status;
  uint16_t Connection_Handle;
  uint8_t PHY;
  int8_t Current_Transmit_Power_Level;
  int8_t Max_Transmit_Power_Level;
} hci_le_enhanced_read_transmit_power_level_rp0;

typedef PACKED(struct) hci_le_read_remote_transmit_power_level_cp0_s {
  uint16_t Connection_Handle;
  uint8_t PHY;
} hci_le_read_remote_transmit_power_level_cp0;

typedef PACKED(struct) hci_le_read_remote_transmit_power_level_rp0_s {
  uint8_t Status;
} hci_le_read_remote_transmit_power_level_rp0;

typedef PACKED(struct) hci_le_set_path_loss_reporting_parameters_cp0_s {
  uint16_t Connection_Handle;
  uint8_t High_Threshold;
  uint8_t High_Hysteresis;
  uint8_t Low_Threshold;
  uint8_t Low_Hysteresis;
  uint16_t Min_Time_Spent;
} hci_le_set_path_loss_reporting_parameters_cp0;

typedef PACKED(struct) hci_le_set_path_loss_reporting_parameters_rp0_s {
  uint8_t Status;
  uint16_t Connection_Handle;
} hci_le_set_path_loss_reporting_parameters_rp0;

typedef PACKED(struct) hci_le_set_path_loss_reporting_enable_cp0_s {
  uint16_t Connection_Handle;
  uint8_t Enable;
} hci_le_set_path_loss_reporting_enable_cp0;

typedef PACKED(struct) hci_le_set_path_loss_reporting_enable_rp0_s {
  uint8_t Status;
  uint16_t Connection_Handle;
} hci_le_set_path_loss_reporting_enable_rp0;

typedef PACKED(struct) hci_le_set_transmit_power_reporting_enable_cp0_s {
  uint16_t Connection_Handle;
  uint8_t Local_Enable;
  uint8_t Remote_Enable;
} hci_le_set_transmit_power_reporting_enable_cp0;

typedef PACKED(struct) hci_le_set_transmit_power_reporting_enable_rp0_s {
  uint8_t Status;
  uint16_t Connection_Handle;
} hci_le_set_transmit_power_reporting_enable_rp0;

typedef PACKED(struct) hci_le_transmitter_test_v4_cp0_s {
  uint8_t TX_Channel;
  uint8_t Test_Data_Length;
  uint8_t Packet_Payload;
  uint8_t PHY;
  uint8_t CTE_Length;
  uint8_t CTE_Type;
  uint8_t Switching_Pattern_Length;
  uint8_t Antenna_IDs[(HCI_MAX_PAYLOAD_SIZE - 7)/sizeof(uint8_t)];
} hci_le_transmitter_test_v4_cp0;

typedef PACKED(struct) hci_le_transmitter_test_v4_cp1_s {
  int8_t Transmit_Power_Level;
} hci_le_transmitter_test_v4_cp1;

typedef PACKED(struct) hci_le_transmitter_test_v4_rp0_s {
  uint8_t Status;
} hci_le_transmitter_test_v4_rp0;

typedef PACKED(struct) aci_hal_get_fw_build_number_rp0_s {
  uint8_t Status;
  uint16_t Build_Number;
} aci_hal_get_fw_build_number_rp0;

typedef PACKED(struct) aci_hal_get_firmware_details_rp0_s {
  uint8_t Status;
  uint8_t DTM_version_major;
  uint8_t DTM_version_minor;
  uint8_t DTM_version_patch;
  uint8_t DTM_variant;
  uint16_t DTM_Build_Number;
  uint8_t BTLE_Stack_version_major;
  uint8_t BTLE_Stack_version_minor;
  uint8_t BTLE_Stack_version_patch;
  uint8_t BTLE_Stack_development;
  uint16_t BTLE_Stack_variant;
  uint16_t BTLE_Stack_Build_Number;
} aci_hal_get_firmware_details_rp0;

typedef PACKED(struct) aci_hal_write_config_data_cp0_s {
  uint8_t Offset;
  uint8_t Length;
  uint8_t Value[(HCI_MAX_PAYLOAD_SIZE - 2)/sizeof(uint8_t)];
} aci_hal_write_config_data_cp0;

typedef PACKED(struct) aci_hal_write_config_data_rp0_s {
  uint8_t Status;
} aci_hal_write_config_data_rp0;

typedef PACKED(struct) aci_hal_read_config_data_cp0_s {
  uint8_t Offset;
} aci_hal_read_config_data_cp0;

typedef PACKED(struct) aci_hal_read_config_data_rp0_s {
  uint8_t Status;
  uint8_t Data_Length;
  uint8_t Data[(HCI_MAX_PAYLOAD_SIZE - 2)/sizeof(uint8_t)];
} aci_hal_read_config_data_rp0;

typedef PACKED(struct) aci_hal_set_tx_power_level_cp0_s {
  uint8_t En_High_Power;
  uint8_t PA_Level;
} aci_hal_set_tx_power_level_cp0;

typedef PACKED(struct) aci_hal_set_tx_power_level_rp0_s {
  uint8_t Status;
} aci_hal_set_tx_power_level_rp0;

typedef PACKED(struct) aci_hal_le_tx_test_packet_number_rp0_s {
  uint8_t Status;
  uint32_t Number_Of_Packets;
} aci_hal_le_tx_test_packet_number_rp0;

typedef PACKED(struct) aci_hal_tone_start_cp0_s {
  uint8_t RF_Channel;
  uint8_t Offset;
} aci_hal_tone_start_cp0;

typedef PACKED(struct) aci_hal_tone_start_rp0_s {
  uint8_t Status;
} aci_hal_tone_start_rp0;

typedef PACKED(struct) aci_hal_tone_stop_rp0_s {
  uint8_t Status;
} aci_hal_tone_stop_rp0;

typedef PACKED(struct) aci_hal_get_link_status_cp0_s {
  uint8_t Bank_index;
} aci_hal_get_link_status_cp0;

typedef PACKED(struct) aci_hal_get_link_status_rp0_s {
  uint8_t Status;
  uint8_t Link_Status[8];
  uint16_t Link_Connection_Handle[16 / 2];
} aci_hal_get_link_status_rp0;

typedef PACKED(struct) aci_hal_set_radio_activity_mask_cp0_s {
  uint16_t Radio_Activity_Mask;
} aci_hal_set_radio_activity_mask_cp0;

typedef PACKED(struct) aci_hal_set_radio_activity_mask_rp0_s {
  uint8_t Status;
} aci_hal_set_radio_activity_mask_rp0;

typedef PACKED(struct) aci_hal_set_event_mask_cp0_s {
  uint32_t Event_Mask;
} aci_hal_set_event_mask_cp0;

typedef PACKED(struct) aci_hal_set_event_mask_rp0_s {
  uint8_t Status;
} aci_hal_set_event_mask_rp0;

typedef PACKED(struct) aci_hal_set_le_power_control_cp0_s {
  uint8_t Enable;
  uint8_t PHY;
  int8_t RSSI_Target;
  uint8_t RSSI_Hysteresis;
  int8_t Initial_TX_Power;
  uint8_t RSSI_Filtering_Coefficient;
} aci_hal_set_le_power_control_cp0;

typedef PACKED(struct) aci_hal_set_le_power_control_rp0_s {
  uint8_t Status;
} aci_hal_set_le_power_control_rp0;

typedef PACKED(struct) aci_hal_updater_start_rp0_s {
  uint8_t Status;
} aci_hal_updater_start_rp0;

typedef PACKED(struct) aci_hal_get_updater_version_rp0_s {
  uint8_t Status;
  uint8_t Version;
} aci_hal_get_updater_version_rp0;

typedef PACKED(struct) aci_hal_get_updater_bufsize_rp0_s {
  uint8_t Status;
  uint8_t Buffer_Size;
} aci_hal_get_updater_bufsize_rp0;

typedef PACKED(struct) aci_hal_updater_erase_blue_flag_rp0_s {
  uint8_t Status;
} aci_hal_updater_erase_blue_flag_rp0;

typedef PACKED(struct) aci_hal_updater_reset_blue_flag_rp0_s {
  uint8_t Status;
} aci_hal_updater_reset_blue_flag_rp0;

typedef PACKED(struct) aci_hal_updater_erase_sector_cp0_s {
  uint32_t Address;
} aci_hal_updater_erase_sector_cp0;

typedef PACKED(struct) aci_hal_updater_erase_sector_rp0_s {
  uint8_t Status;
} aci_hal_updater_erase_sector_rp0;

typedef PACKED(struct) aci_hal_updater_prog_data_blk_cp0_s {
  uint32_t Address;
  uint16_t Data_Length;
  uint8_t Data[(HCI_MAX_PAYLOAD_SIZE - 6)/sizeof(uint8_t)];
} aci_hal_updater_prog_data_blk_cp0;

typedef PACKED(struct) aci_hal_updater_prog_data_blk_rp0_s {
  uint8_t Status;
} aci_hal_updater_prog_data_blk_rp0;

typedef PACKED(struct) aci_hal_updater_read_data_blk_cp0_s {
  uint32_t Address;
  uint16_t Data_Length;
} aci_hal_updater_read_data_blk_cp0;

typedef PACKED(struct) aci_hal_updater_read_data_blk_rp0_s {
  uint8_t Status;
  uint8_t Data[(HCI_MAX_PAYLOAD_SIZE - 1)/sizeof(uint8_t)];
} aci_hal_updater_read_data_blk_rp0;

typedef PACKED(struct) aci_hal_updater_calc_crc_cp0_s {
  uint32_t Address;
  uint8_t Num_Of_Sectors;
} aci_hal_updater_calc_crc_cp0;

typedef PACKED(struct) aci_hal_updater_calc_crc_rp0_s {
  uint8_t Status;
  uint32_t crc;
} aci_hal_updater_calc_crc_rp0;

typedef PACKED(struct) aci_hal_updater_hw_version_rp0_s {
  uint8_t Status;
  uint8_t HW_Version;
} aci_hal_updater_hw_version_rp0;

typedef PACKED(struct) aci_hal_transmitter_test_packets_cp0_s {
  uint8_t TX_Frequency;
  uint8_t Length_Of_Test_Data;
  uint8_t Packet_Payload;
  uint16_t Number_Of_Packets;
  uint8_t PHY;
} aci_hal_transmitter_test_packets_cp0;

typedef PACKED(struct) aci_hal_transmitter_test_packets_rp0_s {
  uint8_t Status;
} aci_hal_transmitter_test_packets_rp0;

typedef PACKED(struct) aci_hal_set_priority_cp0_s {
  uint8_t BLE_State;
  uint16_t Connection_Handle;
  uint8_t Priority_Max;
  uint8_t Priority_Min;
} aci_hal_set_priority_cp0;

typedef PACKED(struct) aci_hal_set_priority_rp0_s {
  uint8_t Status;
} aci_hal_set_priority_rp0;

typedef PACKED(struct) aci_hal_set_ce_length_cp0_s {
  uint16_t CE_Length;
} aci_hal_set_ce_length_cp0;

typedef PACKED(struct) aci_hal_set_ce_length_rp0_s {
  uint8_t Status;
} aci_hal_set_ce_length_rp0;

typedef PACKED(struct) aci_hal_write_radio_reg_cp0_s {
  uint32_t Start_Address;
  uint8_t Num_Bytes;
  uint8_t Data[(HCI_MAX_PAYLOAD_SIZE - 5)/sizeof(uint8_t)];
} aci_hal_write_radio_reg_cp0;

typedef PACKED(struct) aci_hal_write_radio_reg_rp0_s {
  uint8_t Status;
} aci_hal_write_radio_reg_rp0;

typedef PACKED(struct) aci_hal_read_radio_reg_cp0_s {
  uint32_t Start_Address;
  uint8_t Num_Bytes;
} aci_hal_read_radio_reg_cp0;

typedef PACKED(struct) aci_hal_read_radio_reg_rp0_s {
  uint8_t Status;
  uint8_t Data_Length;
  uint8_t Data[(HCI_MAX_PAYLOAD_SIZE - 2)/sizeof(uint8_t)];
} aci_hal_read_radio_reg_rp0;

typedef PACKED(struct) aci_gap_set_io_capability_cp0_s {
  uint8_t IO_Capability;
} aci_gap_set_io_capability_cp0;

typedef PACKED(struct) aci_gap_set_io_capability_rp0_s {
  uint8_t Status;
} aci_gap_set_io_capability_rp0;

typedef PACKED(struct) aci_gap_set_authentication_requirement_cp0_s {
  uint8_t Bonding_Mode;
  uint8_t MITM_Mode;
  uint8_t SC_Support;
  uint8_t KeyPress_Notification_Support;
  uint8_t Min_Encryption_Key_Size;
  uint8_t Max_Encryption_Key_Size;
  uint8_t Use_Fixed_Pin;
  uint32_t Fixed_Pin;
} aci_gap_set_authentication_requirement_cp0;

typedef PACKED(struct) aci_gap_set_authentication_requirement_rp0_s {
  uint8_t Status;
} aci_gap_set_authentication_requirement_rp0;

typedef PACKED(struct) aci_gap_set_authorization_requirement_cp0_s {
  uint16_t Connection_Handle;
  uint8_t Authorization_Enable;
} aci_gap_set_authorization_requirement_cp0;

typedef PACKED(struct) aci_gap_set_authorization_requirement_rp0_s {
  uint8_t Status;
} aci_gap_set_authorization_requirement_rp0;

typedef PACKED(struct) aci_gap_pass_key_resp_cp0_s {
  uint16_t Connection_Handle;
  uint32_t Pass_Key;
} aci_gap_pass_key_resp_cp0;

typedef PACKED(struct) aci_gap_pass_key_resp_rp0_s {
  uint8_t Status;
} aci_gap_pass_key_resp_rp0;

typedef PACKED(struct) aci_gap_authorization_resp_cp0_s {
  uint16_t Connection_Handle;
  uint8_t Authorize;
} aci_gap_authorization_resp_cp0;

typedef PACKED(struct) aci_gap_authorization_resp_rp0_s {
  uint8_t Status;
} aci_gap_authorization_resp_rp0;

typedef PACKED(struct) aci_gap_init_cp0_s {
  uint8_t Role;
  uint8_t Privacy_Type;
  uint8_t Device_Name_Char_Len;
  uint8_t Identity_Address_Type;
} aci_gap_init_cp0;

typedef PACKED(struct) aci_gap_init_rp0_s {
  uint8_t Status;
  uint16_t Service_Handle;
  uint16_t Dev_Name_Char_Handle;
  uint16_t Appearance_Char_Handle;
} aci_gap_init_rp0;

typedef PACKED(struct) aci_gap_slave_security_req_cp0_s {
  uint16_t Connection_Handle;
} aci_gap_slave_security_req_cp0;

typedef PACKED(struct) aci_gap_slave_security_req_rp0_s {
  uint8_t Status;
} aci_gap_slave_security_req_rp0;

typedef PACKED(struct) aci_gap_get_security_level_cp0_s {
  uint16_t Connection_Handle;
} aci_gap_get_security_level_cp0;

typedef PACKED(struct) aci_gap_get_security_level_rp0_s {
  uint8_t Status;
  uint8_t Security_Mode;
  uint8_t Security_Level;
} aci_gap_get_security_level_rp0;

typedef PACKED(struct) aci_gap_set_event_mask_cp0_s {
  uint16_t GAP_Evt_Mask;
} aci_gap_set_event_mask_cp0;

typedef PACKED(struct) aci_gap_set_event_mask_rp0_s {
  uint8_t Status;
} aci_gap_set_event_mask_rp0;

typedef PACKED(struct) aci_gap_terminate_cp0_s {
  uint16_t Connection_Handle;
  uint8_t Reason;
} aci_gap_terminate_cp0;

typedef PACKED(struct) aci_gap_terminate_rp0_s {
  uint8_t Status;
} aci_gap_terminate_rp0;

typedef PACKED(struct) aci_gap_clear_security_db_rp0_s {
  uint8_t Status;
} aci_gap_clear_security_db_rp0;

typedef PACKED(struct) aci_gap_allow_rebond_cp0_s {
  uint16_t Connection_Handle;
} aci_gap_allow_rebond_cp0;

typedef PACKED(struct) aci_gap_allow_rebond_rp0_s {
  uint8_t Status;
} aci_gap_allow_rebond_rp0;

typedef PACKED(struct) aci_gap_create_connection_cp0_s {
  uint8_t Initiating_PHY;
  uint8_t Peer_Address_Type;
  uint8_t Peer_Address[6];
} aci_gap_create_connection_cp0;

typedef PACKED(struct) aci_gap_create_connection_rp0_s {
  uint8_t Status;
} aci_gap_create_connection_rp0;

typedef PACKED(struct) aci_gap_terminate_proc_cp0_s {
  uint8_t Procedure_Code;
} aci_gap_terminate_proc_cp0;

typedef PACKED(struct) aci_gap_terminate_proc_rp0_s {
  uint8_t Status;
} aci_gap_terminate_proc_rp0;

typedef PACKED(struct) aci_gap_start_connection_update_cp0_s {
  uint16_t Connection_Handle;
  uint16_t Conn_Interval_Min;
  uint16_t Conn_Interval_Max;
  uint16_t Conn_Latency;
  uint16_t Supervision_Timeout;
  uint16_t Minimum_CE_Length;
  uint16_t Maximum_CE_Length;
} aci_gap_start_connection_update_cp0;

typedef PACKED(struct) aci_gap_start_connection_update_rp0_s {
  uint8_t Status;
} aci_gap_start_connection_update_rp0;

typedef PACKED(struct) aci_gap_send_pairing_req_cp0_s {
  uint16_t Connection_Handle;
  uint8_t Force_Rebond;
} aci_gap_send_pairing_req_cp0;

typedef PACKED(struct) aci_gap_send_pairing_req_rp0_s {
  uint8_t Status;
} aci_gap_send_pairing_req_rp0;

typedef PACKED(struct) aci_gap_resolve_private_addr_cp0_s {
  uint8_t Address[6];
} aci_gap_resolve_private_addr_cp0;

typedef PACKED(struct) aci_gap_resolve_private_addr_rp0_s {
  uint8_t Status;
  uint8_t Actual_Address[6];
} aci_gap_resolve_private_addr_rp0;

typedef PACKED(struct) aci_gap_get_bonded_devices_cp0_s {
  uint8_t Offset;
  uint8_t Max_Num_Of_Addresses;
} aci_gap_get_bonded_devices_cp0;

typedef PACKED(struct) aci_gap_get_bonded_devices_rp0_s {
  uint8_t Status;
  uint8_t Num_of_Addresses;
  packed_Bonded_Device_Entry_t Bonded_Device_Entry[(HCI_MAX_PAYLOAD_SIZE - 2)/sizeof(packed_Bonded_Device_Entry_t)];
} aci_gap_get_bonded_devices_rp0;

typedef PACKED(struct) aci_gap_is_device_bonded_cp0_s {
  uint8_t Peer_Address_Type;
  uint8_t Peer_Address[6];
} aci_gap_is_device_bonded_cp0;

typedef PACKED(struct) aci_gap_is_device_bonded_rp0_s {
  uint8_t Status;
} aci_gap_is_device_bonded_rp0;

typedef PACKED(struct) aci_gap_numeric_comparison_value_confirm_yesno_cp0_s {
  uint16_t Connection_Handle;
  uint8_t Confirm_Yes_No;
} aci_gap_numeric_comparison_value_confirm_yesno_cp0;

typedef PACKED(struct) aci_gap_numeric_comparison_value_confirm_yesno_rp0_s {
  uint8_t Status;
} aci_gap_numeric_comparison_value_confirm_yesno_rp0;

typedef PACKED(struct) aci_gap_passkey_input_cp0_s {
  uint16_t Connection_Handle;
  uint8_t Input_Type;
} aci_gap_passkey_input_cp0;

typedef PACKED(struct) aci_gap_passkey_input_rp0_s {
  uint8_t Status;
} aci_gap_passkey_input_rp0;

typedef PACKED(struct) aci_gap_get_oob_data_cp0_s {
  uint8_t OOB_Data_Type;
} aci_gap_get_oob_data_cp0;

typedef PACKED(struct) aci_gap_get_oob_data_rp0_s {
  uint8_t Status;
  uint8_t Address_Type;
  uint8_t Address[6];
  uint8_t OOB_Data_Type;
  uint8_t OOB_Data_Len;
  uint8_t OOB_Data[16];
} aci_gap_get_oob_data_rp0;

typedef PACKED(struct) aci_gap_set_oob_data_cp0_s {
  uint8_t Device_Type;
  uint8_t Address_Type;
  uint8_t Address[6];
  uint8_t OOB_Data_Type;
  uint8_t OOB_Data_Len;
  uint8_t OOB_Data[16];
} aci_gap_set_oob_data_cp0;

typedef PACKED(struct) aci_gap_set_oob_data_rp0_s {
  uint8_t Status;
} aci_gap_set_oob_data_rp0;

typedef PACKED(struct) aci_gap_remove_bonded_device_cp0_s {
  uint8_t Peer_Identity_Address_Type;
  uint8_t Peer_Identity_Address[6];
} aci_gap_remove_bonded_device_cp0;

typedef PACKED(struct) aci_gap_remove_bonded_device_rp0_s {
  uint8_t Status;
} aci_gap_remove_bonded_device_rp0;

typedef PACKED(struct) aci_gap_set_advertising_configuration_cp0_s {
  uint8_t Advertising_Handle;
  uint8_t Discoverable_Mode;
  uint16_t Advertising_Event_Properties;
  uint32_t Primary_Advertising_Interval_Min;
  uint32_t Primary_Advertising_Interval_Max;
  uint8_t Primary_Advertising_Channel_Map;
  uint8_t Peer_Address_Type;
  uint8_t Peer_Address[6];
  uint8_t Advertising_Filter_Policy;
  int8_t Advertising_Tx_Power;
  uint8_t Primary_Advertising_PHY;
  uint8_t Secondary_Advertising_Max_Skip;
  uint8_t Secondary_Advertising_PHY;
  uint8_t Advertising_SID;
  uint8_t Scan_Request_Notification_Enable;
} aci_gap_set_advertising_configuration_cp0;

typedef PACKED(struct) aci_gap_set_advertising_configuration_rp0_s {
  uint8_t Status;
} aci_gap_set_advertising_configuration_rp0;

typedef PACKED(struct) aci_gap_set_advertising_enable_cp0_s {
  uint8_t Enable;
  uint8_t Number_of_Sets;
  packed_Advertising_Set_Parameters_t Advertising_Set_Parameters[(HCI_MAX_PAYLOAD_SIZE - 2)/sizeof(packed_Advertising_Set_Parameters_t)];
} aci_gap_set_advertising_enable_cp0;

typedef PACKED(struct) aci_gap_set_advertising_enable_rp0_s {
  uint8_t Status;
} aci_gap_set_advertising_enable_rp0;

typedef PACKED(struct) aci_gap_set_advertising_data_nwk_cp0_s {
  uint8_t Advertising_Handle;
  uint8_t Operation;
  uint8_t Advertising_Data_Length;
  uint8_t Advertising_Data[(HCI_MAX_PAYLOAD_SIZE - 3)/sizeof(uint8_t)];
} aci_gap_set_advertising_data_nwk_cp0;

typedef PACKED(struct) aci_gap_set_advertising_data_nwk_rp0_s {
  uint8_t Status;
} aci_gap_set_advertising_data_nwk_rp0;

typedef PACKED(struct) aci_gap_set_scan_response_data_nwk_cp0_s {
  uint8_t Advertising_Handle;
  uint8_t Operation;
  uint8_t Scan_Response_Data_Length;
  uint8_t Scan_Response_Data[(HCI_MAX_PAYLOAD_SIZE - 3)/sizeof(uint8_t)];
} aci_gap_set_scan_response_data_nwk_cp0;

typedef PACKED(struct) aci_gap_set_scan_response_data_nwk_rp0_s {
  uint8_t Status;
} aci_gap_set_scan_response_data_nwk_rp0;

typedef PACKED(struct) aci_gap_set_scan_configuration_cp0_s {
  uint8_t Filter_Duplicates;
  uint8_t Scanning_Filter_Policy;
  uint8_t Scanning_PHY;
  uint8_t Scan_Type;
  uint16_t Scan_Interval;
  uint16_t Scan_Window;
} aci_gap_set_scan_configuration_cp0;

typedef PACKED(struct) aci_gap_set_scan_configuration_rp0_s {
  uint8_t Status;
} aci_gap_set_scan_configuration_rp0;

typedef PACKED(struct) aci_gap_set_connection_configuration_cp0_s {
  uint8_t Initiating_PHY;
  uint16_t Conn_Interval_Min;
  uint16_t Conn_Interval_Max;
  uint16_t Conn_Latency;
  uint16_t Supervision_Timeout;
  uint16_t Minimum_CE_Length;
  uint16_t Maximum_CE_Length;
} aci_gap_set_connection_configuration_cp0;

typedef PACKED(struct) aci_gap_set_connection_configuration_rp0_s {
  uint8_t Status;
} aci_gap_set_connection_configuration_rp0;

typedef PACKED(struct) aci_gap_start_procedure_cp0_s {
  uint8_t Procedure_Code;
  uint8_t PHYs;
  uint16_t Duration;
  uint16_t Period;
} aci_gap_start_procedure_cp0;

typedef PACKED(struct) aci_gap_start_procedure_rp0_s {
  uint8_t Status;
} aci_gap_start_procedure_rp0;

typedef PACKED(struct) aci_gap_discover_name_cp0_s {
  uint8_t PHYs;
  uint8_t Peer_Address_Type;
  uint8_t Peer_Address[6];
} aci_gap_discover_name_cp0;

typedef PACKED(struct) aci_gap_discover_name_rp0_s {
  uint8_t Status;
} aci_gap_discover_name_rp0;

typedef PACKED(struct) aci_gap_add_devices_to_white_and_resolving_list_cp0_s {
  uint8_t Lists;
  uint8_t Clear_Lists;
  uint8_t Num_of_List_Entries;
  packed_List_Entry_t List_Entry[(HCI_MAX_PAYLOAD_SIZE - 3)/sizeof(packed_List_Entry_t)];
} aci_gap_add_devices_to_white_and_resolving_list_cp0;

typedef PACKED(struct) aci_gap_add_devices_to_white_and_resolving_list_rp0_s {
  uint8_t Status;
} aci_gap_add_devices_to_white_and_resolving_list_rp0;

typedef PACKED(struct) aci_gap_configure_white_and_resolving_list_cp0_s {
  uint8_t Lists;
} aci_gap_configure_white_and_resolving_list_cp0;

typedef PACKED(struct) aci_gap_configure_white_and_resolving_list_rp0_s {
  uint8_t Status;
} aci_gap_configure_white_and_resolving_list_rp0;

typedef PACKED(struct) aci_gap_set_periodic_advertising_configuration_cp0_s {
  uint8_t Advertising_Handle;
  uint16_t Periodic_Advertising_Interval_Min;
  uint16_t Periodic_Advertising_Interval_Max;
  uint16_t Periodic_Advertising_Properties;
} aci_gap_set_periodic_advertising_configuration_cp0;

typedef PACKED(struct) aci_gap_set_periodic_advertising_configuration_rp0_s {
  uint8_t Status;
} aci_gap_set_periodic_advertising_configuration_rp0;

typedef PACKED(struct) aci_gap_set_periodic_advertising_data_nwk_cp0_s {
  uint8_t Advertising_Handle;
  uint8_t Operation;
  uint8_t Advertising_Data_Length;
  uint8_t Advertising_Data[(HCI_MAX_PAYLOAD_SIZE - 3)/sizeof(uint8_t)];
} aci_gap_set_periodic_advertising_data_nwk_cp0;

typedef PACKED(struct) aci_gap_set_periodic_advertising_data_nwk_rp0_s {
  uint8_t Status;
} aci_gap_set_periodic_advertising_data_nwk_rp0;

typedef PACKED(struct) aci_gap_set_periodic_advertising_enable_cp0_s {
  uint8_t Enable;
  uint8_t Advertising_Handle;
} aci_gap_set_periodic_advertising_enable_cp0;

typedef PACKED(struct) aci_gap_set_periodic_advertising_enable_rp0_s {
  uint8_t Status;
} aci_gap_set_periodic_advertising_enable_rp0;

typedef PACKED(struct) aci_gap_periodic_advertising_create_sync_cp0_s {
  uint8_t Options;
  uint8_t Advertising_SID;
  uint8_t Advertising_Address_Type;
  uint8_t Advertiser_Address[6];
  uint16_t Skip;
  uint16_t Sync_Timeout;
  uint8_t Sync_CTE_Type;
} aci_gap_periodic_advertising_create_sync_cp0;

typedef PACKED(struct) aci_gap_periodic_advertising_create_sync_rp0_s {
  uint8_t Status;
} aci_gap_periodic_advertising_create_sync_rp0;

typedef PACKED(struct) aci_gap_periodic_advertising_create_sync_cancel_rp0_s {
  uint8_t Status;
} aci_gap_periodic_advertising_create_sync_cancel_rp0;

typedef PACKED(struct) aci_gap_remove_advertising_set_cp0_s {
  uint8_t Advertising_Handle;
} aci_gap_remove_advertising_set_cp0;

typedef PACKED(struct) aci_gap_remove_advertising_set_rp0_s {
  uint8_t Status;
} aci_gap_remove_advertising_set_rp0;

typedef PACKED(struct) aci_gap_clear_advertising_sets_rp0_s {
  uint8_t Status;
} aci_gap_clear_advertising_sets_rp0;

typedef PACKED(struct) aci_gap_periodic_advertising_terminate_sync_cp0_s {
  uint16_t Sync_Handle;
} aci_gap_periodic_advertising_terminate_sync_cp0;

typedef PACKED(struct) aci_gap_periodic_advertising_terminate_sync_rp0_s {
  uint8_t Status;
} aci_gap_periodic_advertising_terminate_sync_rp0;

typedef PACKED(struct) aci_gap_add_device_to_periodic_advertiser_list_cp0_s {
  uint8_t Advertiser_Address_Type;
  uint8_t Advertiser_Address[6];
  uint8_t Advertising_SID;
} aci_gap_add_device_to_periodic_advertiser_list_cp0;

typedef PACKED(struct) aci_gap_add_device_to_periodic_advertiser_list_rp0_s {
  uint8_t Status;
} aci_gap_add_device_to_periodic_advertiser_list_rp0;

typedef PACKED(struct) aci_gap_remove_device_from_periodic_advertising_list_cp0_s {
  uint8_t Advertiser_Address_Type;
  uint8_t Advertiser_Address[6];
  uint8_t Advertising_SID;
} aci_gap_remove_device_from_periodic_advertising_list_cp0;

typedef PACKED(struct) aci_gap_remove_device_from_periodic_advertising_list_rp0_s {
  uint8_t Status;
} aci_gap_remove_device_from_periodic_advertising_list_rp0;

typedef PACKED(struct) aci_gap_clear_periodic_advertiser_list_rp0_s {
  uint8_t Status;
} aci_gap_clear_periodic_advertiser_list_rp0;

typedef PACKED(struct) aci_gap_read_periodic_advertiser_list_size_rp0_s {
  uint8_t Status;
  uint8_t Periodic_Advertiser_List_Size;
} aci_gap_read_periodic_advertiser_list_size_rp0;

typedef PACKED(struct) aci_gap_set_periodic_advertising_receive_enable_cp0_s {
  uint16_t Sync_Handle;
  uint8_t Enable;
} aci_gap_set_periodic_advertising_receive_enable_cp0;

typedef PACKED(struct) aci_gap_set_periodic_advertising_receive_enable_rp0_s {
  uint8_t Status;
} aci_gap_set_periodic_advertising_receive_enable_rp0;

typedef PACKED(struct) aci_gap_periodic_advertising_sync_transfer_cp0_s {
  uint16_t Connection_Handle;
  uint16_t Service_Data;
  uint16_t Sync_Handle;
} aci_gap_periodic_advertising_sync_transfer_cp0;

typedef PACKED(struct) aci_gap_periodic_advertising_sync_transfer_rp0_s {
  uint8_t Status;
  uint16_t Connection_Handle;
} aci_gap_periodic_advertising_sync_transfer_rp0;

typedef PACKED(struct) aci_gap_periodic_advertising_set_info_transfer_cp0_s {
  uint16_t Connection_Handle;
  uint16_t Service_Data;
  uint8_t Advertising_Handle;
} aci_gap_periodic_advertising_set_info_transfer_cp0;

typedef PACKED(struct) aci_gap_periodic_advertising_set_info_transfer_rp0_s {
  uint8_t Status;
  uint16_t Connection_Handle;
} aci_gap_periodic_advertising_set_info_transfer_rp0;

typedef PACKED(struct) aci_gap_set_periodic_advertising_sync_transfer_parameters_cp0_s {
  uint16_t Connection_Handle;
  uint8_t Mode;
  uint16_t Skip;
  uint16_t Sync_Timeout;
  uint8_t CTE_Type;
} aci_gap_set_periodic_advertising_sync_transfer_parameters_cp0;

typedef PACKED(struct) aci_gap_set_periodic_advertising_sync_transfer_parameters_rp0_s {
  uint8_t Status;
  uint16_t Connection_Handle;
} aci_gap_set_periodic_advertising_sync_transfer_parameters_rp0;

typedef PACKED(struct) aci_gap_set_default_periodic_advertising_sync_transfer_parameters_cp0_s {
  uint8_t Mode;
  uint16_t Skip;
  uint16_t Sync_Timeout;
  uint8_t CTE_Type;
} aci_gap_set_default_periodic_advertising_sync_transfer_parameters_cp0;

typedef PACKED(struct) aci_gap_set_default_periodic_advertising_sync_transfer_parameters_rp0_s {
  uint8_t Status;
} aci_gap_set_default_periodic_advertising_sync_transfer_parameters_rp0;

typedef PACKED(struct) aci_gatt_srv_init_rp0_s {
  uint8_t Status;
} aci_gatt_srv_init_rp0;

typedef PACKED(struct) aci_gatt_srv_add_service_nwk_cp0_s {
  uint8_t Service_UUID_Type;
  packed_Service_UUID_t Service_UUID;
} aci_gatt_srv_add_service_nwk_cp0;

typedef PACKED(struct) aci_gatt_srv_add_service_nwk_cp1_s {
  uint8_t Service_Type;
  uint8_t Max_Attribute_Records;
} aci_gatt_srv_add_service_nwk_cp1;

typedef PACKED(struct) aci_gatt_srv_add_service_nwk_rp0_s {
  uint8_t Status;
  uint16_t Service_Handle;
} aci_gatt_srv_add_service_nwk_rp0;

typedef PACKED(struct) aci_gatt_srv_include_service_nwk_cp0_s {
  uint16_t Service_Handle;
  uint16_t Included_Service_Handle;
} aci_gatt_srv_include_service_nwk_cp0;

typedef PACKED(struct) aci_gatt_srv_include_service_nwk_rp0_s {
  uint8_t Status;
  uint16_t Include_Handle;
} aci_gatt_srv_include_service_nwk_rp0;

typedef PACKED(struct) aci_gatt_srv_add_char_nwk_cp0_s {
  uint16_t Service_Handle;
  uint8_t Char_UUID_Type;
  packed_Char_UUID_t Char_UUID;
} aci_gatt_srv_add_char_nwk_cp0;

typedef PACKED(struct) aci_gatt_srv_add_char_nwk_cp1_s {
  uint16_t Char_Value_Length;
  uint8_t Char_Properties;
  uint8_t Security_Permissions;
  uint8_t GATT_Evt_Mask;
  uint8_t Enc_Key_Size;
  uint8_t Is_Variable;
} aci_gatt_srv_add_char_nwk_cp1;

typedef PACKED(struct) aci_gatt_srv_add_char_nwk_rp0_s {
  uint8_t Status;
  uint16_t Char_Handle;
} aci_gatt_srv_add_char_nwk_rp0;

typedef PACKED(struct) aci_gatt_srv_add_char_desc_nwk_cp0_s {
  uint16_t Char_Handle;
  uint8_t Char_Desc_Uuid_Type;
  packed_Char_Desc_Uuid_t Char_Desc_Uuid;
} aci_gatt_srv_add_char_desc_nwk_cp0;

typedef PACKED(struct) aci_gatt_srv_add_char_desc_nwk_cp1_s {
  uint16_t Char_Desc_Value_Max_Len;
  uint16_t Char_Desc_Value_Length;
  uint8_t Char_Desc_Value[(HCI_MAX_PAYLOAD_SIZE - 4)/sizeof(uint8_t)];
} aci_gatt_srv_add_char_desc_nwk_cp1;

typedef PACKED(struct) aci_gatt_srv_add_char_desc_nwk_cp2_s {
  uint8_t Security_Permissions;
  uint8_t Access_Permissions;
  uint8_t GATT_Evt_Mask;
  uint8_t Enc_Key_Size;
  uint8_t Is_Variable;
} aci_gatt_srv_add_char_desc_nwk_cp2;

typedef PACKED(struct) aci_gatt_srv_add_char_desc_nwk_rp0_s {
  uint8_t Status;
  uint16_t Char_Desc_Handle;
} aci_gatt_srv_add_char_desc_nwk_rp0;

typedef PACKED(struct) aci_gatt_srv_write_handle_value_nwk_cp0_s {
  uint16_t Attr_Handle;
  uint16_t Val_Offset;
  uint16_t Value_Length;
  uint8_t Value[(HCI_MAX_PAYLOAD_SIZE - 6)/sizeof(uint8_t)];
} aci_gatt_srv_write_handle_value_nwk_cp0;

typedef PACKED(struct) aci_gatt_srv_write_handle_value_nwk_rp0_s {
  uint8_t Status;
} aci_gatt_srv_write_handle_value_nwk_rp0;

typedef PACKED(struct) aci_gatt_srv_rm_char_nwk_cp0_s {
  uint16_t Char_Handle;
} aci_gatt_srv_rm_char_nwk_cp0;

typedef PACKED(struct) aci_gatt_srv_rm_char_nwk_rp0_s {
  uint8_t Status;
} aci_gatt_srv_rm_char_nwk_rp0;

typedef PACKED(struct) aci_gatt_srv_rm_service_nwk_cp0_s {
  uint16_t Serv_Handle;
} aci_gatt_srv_rm_service_nwk_cp0;

typedef PACKED(struct) aci_gatt_srv_rm_service_nwk_rp0_s {
  uint8_t Status;
} aci_gatt_srv_rm_service_nwk_rp0;

typedef PACKED(struct) aci_gatt_srv_rm_include_service_nwk_cp0_s {
  uint16_t Include_Handle;
} aci_gatt_srv_rm_include_service_nwk_cp0;

typedef PACKED(struct) aci_gatt_srv_rm_include_service_nwk_rp0_s {
  uint8_t Status;
} aci_gatt_srv_rm_include_service_nwk_rp0;

typedef PACKED(struct) aci_gatt_set_event_mask_cp0_s {
  uint32_t GATT_Evt_Mask;
} aci_gatt_set_event_mask_cp0;

typedef PACKED(struct) aci_gatt_set_event_mask_rp0_s {
  uint8_t Status;
} aci_gatt_set_event_mask_rp0;

typedef PACKED(struct) aci_gatt_clt_exchange_config_cp0_s {
  uint16_t Connection_Handle;
} aci_gatt_clt_exchange_config_cp0;

typedef PACKED(struct) aci_gatt_clt_exchange_config_rp0_s {
  uint8_t Status;
} aci_gatt_clt_exchange_config_rp0;

typedef PACKED(struct) aci_gatt_clt_prepare_write_req_cp0_s {
  uint16_t Connection_Handle;
  uint16_t Attr_Handle;
  uint16_t Val_Offset;
  uint16_t Attribute_Val_Length;
  uint8_t Attribute_Val[(HCI_MAX_PAYLOAD_SIZE - 8)/sizeof(uint8_t)];
} aci_gatt_clt_prepare_write_req_cp0;

typedef PACKED(struct) aci_gatt_clt_prepare_write_req_rp0_s {
  uint8_t Status;
} aci_gatt_clt_prepare_write_req_rp0;

typedef PACKED(struct) aci_gatt_clt_execute_write_req_cp0_s {
  uint16_t Connection_Handle;
  uint8_t Execute;
} aci_gatt_clt_execute_write_req_cp0;

typedef PACKED(struct) aci_gatt_clt_execute_write_req_rp0_s {
  uint8_t Status;
} aci_gatt_clt_execute_write_req_rp0;

typedef PACKED(struct) aci_gatt_clt_disc_all_primary_services_cp0_s {
  uint16_t Connection_Handle;
} aci_gatt_clt_disc_all_primary_services_cp0;

typedef PACKED(struct) aci_gatt_clt_disc_all_primary_services_rp0_s {
  uint8_t Status;
} aci_gatt_clt_disc_all_primary_services_rp0;

typedef PACKED(struct) aci_gatt_clt_disc_primary_service_by_uuid_cp0_s {
  uint16_t Connection_Handle;
  uint8_t UUID_Type;
  packed_UUID_t UUID;
} aci_gatt_clt_disc_primary_service_by_uuid_cp0;

typedef PACKED(struct) aci_gatt_clt_disc_primary_service_by_uuid_rp0_s {
  uint8_t Status;
} aci_gatt_clt_disc_primary_service_by_uuid_rp0;

typedef PACKED(struct) aci_gatt_clt_find_included_services_cp0_s {
  uint16_t Connection_Handle;
  uint16_t Start_Handle;
  uint16_t End_Handle;
} aci_gatt_clt_find_included_services_cp0;

typedef PACKED(struct) aci_gatt_clt_find_included_services_rp0_s {
  uint8_t Status;
} aci_gatt_clt_find_included_services_rp0;

typedef PACKED(struct) aci_gatt_clt_disc_all_char_of_service_cp0_s {
  uint16_t Connection_Handle;
  uint16_t Start_Handle;
  uint16_t End_Handle;
} aci_gatt_clt_disc_all_char_of_service_cp0;

typedef PACKED(struct) aci_gatt_clt_disc_all_char_of_service_rp0_s {
  uint8_t Status;
} aci_gatt_clt_disc_all_char_of_service_rp0;

typedef PACKED(struct) aci_gatt_clt_disc_char_by_uuid_cp0_s {
  uint16_t Connection_Handle;
  uint16_t Start_Handle;
  uint16_t End_Handle;
  uint8_t UUID_Type;
  packed_UUID_t UUID;
} aci_gatt_clt_disc_char_by_uuid_cp0;

typedef PACKED(struct) aci_gatt_clt_disc_char_by_uuid_rp0_s {
  uint8_t Status;
} aci_gatt_clt_disc_char_by_uuid_rp0;

typedef PACKED(struct) aci_gatt_clt_disc_all_char_desc_cp0_s {
  uint16_t Connection_Handle;
  uint16_t Char_Handle;
  uint16_t End_Handle;
} aci_gatt_clt_disc_all_char_desc_cp0;

typedef PACKED(struct) aci_gatt_clt_disc_all_char_desc_rp0_s {
  uint8_t Status;
} aci_gatt_clt_disc_all_char_desc_rp0;

typedef PACKED(struct) aci_gatt_clt_read_cp0_s {
  uint16_t Connection_Handle;
  uint16_t Attr_Handle;
} aci_gatt_clt_read_cp0;

typedef PACKED(struct) aci_gatt_clt_read_rp0_s {
  uint8_t Status;
} aci_gatt_clt_read_rp0;

typedef PACKED(struct) aci_gatt_clt_read_using_char_uuid_cp0_s {
  uint16_t Connection_Handle;
  uint16_t Start_Handle;
  uint16_t End_Handle;
  uint8_t UUID_Type;
  packed_UUID_t UUID;
} aci_gatt_clt_read_using_char_uuid_cp0;

typedef PACKED(struct) aci_gatt_clt_read_using_char_uuid_rp0_s {
  uint8_t Status;
} aci_gatt_clt_read_using_char_uuid_rp0;

typedef PACKED(struct) aci_gatt_clt_read_long_cp0_s {
  uint16_t Connection_Handle;
  uint16_t Attr_Handle;
  uint16_t Val_Offset;
} aci_gatt_clt_read_long_cp0;

typedef PACKED(struct) aci_gatt_clt_read_long_rp0_s {
  uint8_t Status;
} aci_gatt_clt_read_long_rp0;

typedef PACKED(struct) aci_gatt_clt_read_multiple_char_value_cp0_s {
  uint16_t Connection_Handle;
  uint8_t Number_of_Handles;
  packed_Handle_Entry_t Handle_Entry[(HCI_MAX_PAYLOAD_SIZE - 3)/sizeof(packed_Handle_Entry_t)];
} aci_gatt_clt_read_multiple_char_value_cp0;

typedef PACKED(struct) aci_gatt_clt_read_multiple_char_value_rp0_s {
  uint8_t Status;
} aci_gatt_clt_read_multiple_char_value_rp0;

typedef PACKED(struct) aci_gatt_clt_write_nwk_cp0_s {
  uint16_t Connection_Handle;
  uint16_t Attr_Handle;
  uint16_t Attribute_Val_Length;
  uint8_t Attribute_Val[(HCI_MAX_PAYLOAD_SIZE - 6)/sizeof(uint8_t)];
} aci_gatt_clt_write_nwk_cp0;

typedef PACKED(struct) aci_gatt_clt_write_nwk_rp0_s {
  uint8_t Status;
} aci_gatt_clt_write_nwk_rp0;

typedef PACKED(struct) aci_gatt_clt_write_long_nwk_cp0_s {
  uint16_t Connection_Handle;
  uint16_t Attr_Handle;
  uint16_t Val_Offset;
  uint16_t Attribute_Val_Length;
  uint8_t Attribute_Val[(HCI_MAX_PAYLOAD_SIZE - 8)/sizeof(uint8_t)];
} aci_gatt_clt_write_long_nwk_cp0;

typedef PACKED(struct) aci_gatt_clt_write_long_nwk_rp0_s {
  uint8_t Status;
} aci_gatt_clt_write_long_nwk_rp0;

typedef PACKED(struct) aci_gatt_clt_write_char_reliable_nwk_cp0_s {
  uint16_t Connection_Handle;
  uint16_t Attr_Handle;
  uint16_t Val_Offset;
  uint16_t Attribute_Val_Length;
  uint8_t Attribute_Val[(HCI_MAX_PAYLOAD_SIZE - 8)/sizeof(uint8_t)];
} aci_gatt_clt_write_char_reliable_nwk_cp0;

typedef PACKED(struct) aci_gatt_clt_write_char_reliable_nwk_rp0_s {
  uint8_t Status;
} aci_gatt_clt_write_char_reliable_nwk_rp0;

typedef PACKED(struct) aci_gatt_clt_write_without_resp_cp0_s {
  uint16_t Connection_Handle;
  uint16_t Attr_Handle;
  uint16_t Attribute_Val_Length;
  uint8_t Attribute_Val[(HCI_MAX_PAYLOAD_SIZE - 6)/sizeof(uint8_t)];
} aci_gatt_clt_write_without_resp_cp0;

typedef PACKED(struct) aci_gatt_clt_write_without_resp_rp0_s {
  uint8_t Status;
} aci_gatt_clt_write_without_resp_rp0;

typedef PACKED(struct) aci_gatt_clt_signed_write_without_resp_cp0_s {
  uint16_t Connection_Handle;
  uint16_t Attr_Handle;
  uint16_t Attribute_Val_Length;
  uint8_t Attribute_Val[(HCI_MAX_PAYLOAD_SIZE - 6)/sizeof(uint8_t)];
} aci_gatt_clt_signed_write_without_resp_cp0;

typedef PACKED(struct) aci_gatt_clt_signed_write_without_resp_rp0_s {
  uint8_t Status;
} aci_gatt_clt_signed_write_without_resp_rp0;

typedef PACKED(struct) aci_gatt_clt_confirm_indication_cp0_s {
  uint16_t Connection_Handle;
} aci_gatt_clt_confirm_indication_cp0;

typedef PACKED(struct) aci_gatt_clt_confirm_indication_rp0_s {
  uint8_t Status;
} aci_gatt_clt_confirm_indication_rp0;

typedef PACKED(struct) aci_gatt_srv_set_security_permission_nwk_cp0_s {
  uint16_t Attr_Handle;
  uint8_t Security_Permissions;
} aci_gatt_srv_set_security_permission_nwk_cp0;

typedef PACKED(struct) aci_gatt_srv_set_security_permission_nwk_rp0_s {
  uint8_t Status;
} aci_gatt_srv_set_security_permission_nwk_rp0;

typedef PACKED(struct) aci_gatt_srv_read_handle_value_nwk_cp0_s {
  uint16_t Attr_Handle;
  uint16_t Offset;
  uint16_t Value_Length_Requested;
} aci_gatt_srv_read_handle_value_nwk_cp0;

typedef PACKED(struct) aci_gatt_srv_read_handle_value_nwk_rp0_s {
  uint8_t Status;
  uint16_t Length;
  uint16_t Value_Length;
  uint8_t Value[(HCI_MAX_PAYLOAD_SIZE - 5)/sizeof(uint8_t)];
} aci_gatt_srv_read_handle_value_nwk_rp0;

typedef PACKED(struct) aci_gatt_srv_set_access_permission_nwk_cp0_s {
  uint16_t Attr_Handle;
  uint8_t Access_Permissions;
} aci_gatt_srv_set_access_permission_nwk_cp0;

typedef PACKED(struct) aci_gatt_srv_set_access_permission_nwk_rp0_s {
  uint8_t Status;
} aci_gatt_srv_set_access_permission_nwk_rp0;

typedef PACKED(struct) aci_gatt_srv_notify_cp0_s {
  uint16_t Connection_Handle;
  uint16_t Attr_Handle;
  uint8_t Flags;
  uint16_t Val_Length;
  uint8_t Val[(HCI_MAX_PAYLOAD_SIZE - 7)/sizeof(uint8_t)];
} aci_gatt_srv_notify_cp0;

typedef PACKED(struct) aci_gatt_srv_notify_rp0_s {
  uint8_t Status;
} aci_gatt_srv_notify_rp0;

typedef PACKED(struct) aci_gatt_srv_exec_write_resp_nwk_cp0_s {
  uint16_t Conn_Handle;
  uint8_t Exec;
} aci_gatt_srv_exec_write_resp_nwk_cp0;

typedef PACKED(struct) aci_gatt_srv_exec_write_resp_nwk_rp0_s {
  uint8_t Status;
} aci_gatt_srv_exec_write_resp_nwk_rp0;

typedef PACKED(struct) aci_gatt_srv_authorize_resp_nwk_cp0_s {
  uint16_t Conn_Handle;
  uint16_t Attr_Handle;
  uint8_t Operation_Type;
  uint8_t Error_Code;
  uint16_t Attr_Val_Offset;
  uint16_t Data_Length;
  uint8_t Data[(HCI_MAX_PAYLOAD_SIZE - 10)/sizeof(uint8_t)];
} aci_gatt_srv_authorize_resp_nwk_cp0;

typedef PACKED(struct) aci_gatt_srv_authorize_resp_nwk_rp0_s {
  uint8_t Status;
} aci_gatt_srv_authorize_resp_nwk_rp0;

typedef PACKED(struct) aci_gatt_srv_read_prepare_queue_nwk_cp0_s {
  uint16_t Conn_Handle;
  uint8_t Item_Index;
} aci_gatt_srv_read_prepare_queue_nwk_cp0;

typedef PACKED(struct) aci_gatt_srv_read_prepare_queue_nwk_rp0_s {
  uint8_t Status;
  uint16_t Attr_Handle;
  uint16_t Value_Offset;
  uint16_t Value_Length;
  uint8_t Value[(HCI_MAX_PAYLOAD_SIZE - 7)/sizeof(uint8_t)];
} aci_gatt_srv_read_prepare_queue_nwk_rp0;

typedef PACKED(struct) aci_gatt_srv_write_multiple_instance_handle_value_cp0_s {
  uint16_t Connection_Handle;
  uint16_t Attr_Handle;
  uint16_t Value_Length;
  uint8_t Value[(HCI_MAX_PAYLOAD_SIZE - 6)/sizeof(uint8_t)];
} aci_gatt_srv_write_multiple_instance_handle_value_cp0;

typedef PACKED(struct) aci_gatt_srv_write_multiple_instance_handle_value_rp0_s {
  uint8_t Status;
} aci_gatt_srv_write_multiple_instance_handle_value_rp0;

typedef PACKED(struct) aci_gatt_srv_read_multiple_instance_handle_value_nwk_cp0_s {
  uint16_t Connection_Handle;
  uint16_t Attr_Handle;
} aci_gatt_srv_read_multiple_instance_handle_value_nwk_cp0;

typedef PACKED(struct) aci_gatt_srv_read_multiple_instance_handle_value_nwk_rp0_s {
  uint8_t Status;
  uint16_t Value_Length;
  uint8_t Value[(HCI_MAX_PAYLOAD_SIZE - 3)/sizeof(uint8_t)];
} aci_gatt_srv_read_multiple_instance_handle_value_nwk_rp0;

typedef PACKED(struct) aci_l2cap_connection_parameter_update_req_cp0_s {
  uint16_t Connection_Handle;
  uint16_t Conn_Interval_Min;
  uint16_t Conn_Interval_Max;
  uint16_t Slave_latency;
  uint16_t Timeout_Multiplier;
} aci_l2cap_connection_parameter_update_req_cp0;

typedef PACKED(struct) aci_l2cap_connection_parameter_update_req_rp0_s {
  uint8_t Status;
} aci_l2cap_connection_parameter_update_req_rp0;

typedef PACKED(struct) aci_l2cap_connection_parameter_update_resp_cp0_s {
  uint16_t Connection_Handle;
  uint16_t Conn_Interval_Min;
  uint16_t Conn_Interval_Max;
  uint16_t Slave_latency;
  uint16_t Timeout_Multiplier;
  uint16_t Minimum_CE_Length;
  uint16_t Maximum_CE_Length;
  uint8_t Identifier;
  uint8_t Accept;
} aci_l2cap_connection_parameter_update_resp_cp0;

typedef PACKED(struct) aci_l2cap_connection_parameter_update_resp_rp0_s {
  uint8_t Status;
} aci_l2cap_connection_parameter_update_resp_rp0;

typedef PACKED(struct) aci_l2cap_cfc_connection_req_nwk_cp0_s {
  uint16_t Connection_Handle;
  uint16_t SPSM;
  uint16_t CID;
  uint16_t MTU;
  uint16_t MPS;
  uint8_t CFC_Policy;
} aci_l2cap_cfc_connection_req_nwk_cp0;

typedef PACKED(struct) aci_l2cap_cfc_connection_req_nwk_rp0_s {
  uint8_t Status;
} aci_l2cap_cfc_connection_req_nwk_rp0;

typedef PACKED(struct) aci_l2cap_cfc_connection_resp_nwk_cp0_s {
  uint16_t Connection_Handle;
  uint8_t Identifier;
  uint16_t CID;
  uint16_t MTU;
  uint16_t MPS;
  uint16_t Result;
  uint8_t CFC_Policy;
} aci_l2cap_cfc_connection_resp_nwk_cp0;

typedef PACKED(struct) aci_l2cap_cfc_connection_resp_nwk_rp0_s {
  uint8_t Status;
} aci_l2cap_cfc_connection_resp_nwk_rp0;

typedef PACKED(struct) aci_l2cap_send_flow_control_credits_cp0_s {
  uint16_t Connection_Handle;
  uint16_t CID;
  uint16_t RX_Credits;
  uint8_t CFC_Policy;
} aci_l2cap_send_flow_control_credits_cp0;

typedef PACKED(struct) aci_l2cap_send_flow_control_credits_rp0_s {
  uint8_t Status;
  uint16_t RX_Credit_Balance;
} aci_l2cap_send_flow_control_credits_rp0;

typedef PACKED(struct) aci_l2cap_disconnect_cp0_s {
  uint16_t Connection_Handle;
  uint16_t CID;
} aci_l2cap_disconnect_cp0;

typedef PACKED(struct) aci_l2cap_disconnect_rp0_s {
  uint8_t Status;
} aci_l2cap_disconnect_rp0;

typedef PACKED(struct) aci_l2cap_transmit_sdu_data_nwk_cp0_s {
  uint16_t Connection_Handle;
  uint16_t CID;
  uint16_t SDU_Length;
  uint8_t SDU_Data[(HCI_MAX_PAYLOAD_SIZE - 6)/sizeof(uint8_t)];
} aci_l2cap_transmit_sdu_data_nwk_cp0;

typedef PACKED(struct) aci_l2cap_transmit_sdu_data_nwk_rp0_s {
  uint8_t Status;
} aci_l2cap_transmit_sdu_data_nwk_rp0;

typedef PACKED(struct) aci_test_tx_notification_start_cp0_s {
  uint16_t Connection_Handle;
  uint16_t Service_Handle;
  uint16_t Char_Handle;
  uint16_t Value_Length;
} aci_test_tx_notification_start_cp0;

typedef PACKED(struct) aci_test_tx_notification_start_rp0_s {
  uint8_t Status;
} aci_test_tx_notification_start_rp0;

typedef PACKED(struct) aci_test_tx_write_command_start_cp0_s {
  uint16_t Connection_Handle;
  uint16_t Attr_Handle;
  uint16_t Value_Length;
} aci_test_tx_write_command_start_cp0;

typedef PACKED(struct) aci_test_tx_write_command_start_rp0_s {
  uint8_t Status;
} aci_test_tx_write_command_start_rp0;

typedef PACKED(struct) aci_test_rx_start_cp0_s {
  uint16_t Connection_Handle;
  uint16_t Attr_Handle;
  uint8_t Notifications_WriteCmds;
} aci_test_rx_start_cp0;

typedef PACKED(struct) aci_test_rx_start_rp0_s {
  uint8_t Status;
} aci_test_rx_start_rp0;

typedef PACKED(struct) aci_test_stop_cp0_s {
  uint8_t TX_RX;
} aci_test_stop_cp0;

typedef PACKED(struct) aci_test_stop_rp0_s {
  uint8_t Status;
} aci_test_stop_rp0;

typedef PACKED(struct) aci_test_report_rp0_s {
  uint8_t Status;
  uint32_t TX_Packets;
  uint32_t RX_Packets;
  uint16_t RX_Data_Length;
  uint32_t RX_Sequence_Errors;
} aci_test_report_rp0;

typedef PACKED(struct) hci_disconnection_complete_event_rp0_s {
  uint8_t Status;
  uint16_t Connection_Handle;
  uint8_t Reason;
} hci_disconnection_complete_event_rp0;

typedef PACKED(struct) hci_encryption_change_event_rp0_s {
  uint8_t Status;
  uint16_t Connection_Handle;
  uint8_t Encryption_Enabled;
} hci_encryption_change_event_rp0;

typedef PACKED(struct) hci_read_remote_version_information_complete_event_rp0_s {
  uint8_t Status;
  uint16_t Connection_Handle;
  uint8_t Version;
  uint16_t Manufacturer_Name;
  uint16_t Subversion;
} hci_read_remote_version_information_complete_event_rp0;

typedef PACKED(struct) hci_hardware_error_event_rp0_s {
  uint8_t Hardware_Code;
} hci_hardware_error_event_rp0;

typedef PACKED(struct) hci_number_of_completed_packets_event_rp0_s {
  uint8_t Number_of_Handles;
  packed_Handle_Packets_Pair_Entry_t Handle_Packets_Pair_Entry[(HCI_MAX_PAYLOAD_SIZE - 1)/sizeof(packed_Handle_Packets_Pair_Entry_t)];
} hci_number_of_completed_packets_event_rp0;

typedef PACKED(struct) hci_data_buffer_overflow_event_rp0_s {
  uint8_t Link_Type;
} hci_data_buffer_overflow_event_rp0;

typedef PACKED(struct) hci_encryption_key_refresh_complete_event_rp0_s {
  uint8_t Status;
  uint16_t Connection_Handle;
} hci_encryption_key_refresh_complete_event_rp0;

typedef PACKED(struct) hci_authenticated_payload_timeout_expired_event_rp0_s {
  uint16_t Connection_Handle;
} hci_authenticated_payload_timeout_expired_event_rp0;

typedef PACKED(struct) aci_blue_initialized_event_rp0_s {
  uint8_t Reason_Code;
} aci_blue_initialized_event_rp0;

typedef PACKED(struct) aci_blue_events_lost_event_rp0_s {
  uint8_t Lost_Events[8];
} aci_blue_events_lost_event_rp0;

typedef PACKED(struct) aci_blue_crash_info_event_rp0_s {
  uint8_t Crash_Type;
  uint32_t SP;
  uint32_t R0;
  uint32_t R1;
  uint32_t R2;
  uint32_t R3;
  uint32_t R12;
  uint32_t LR;
  uint32_t PC;
  uint32_t xPSR;
  uint8_t Debug_Data_Length;
  uint8_t Debug_Data[(HCI_MAX_PAYLOAD_SIZE - 38)/sizeof(uint8_t)];
} aci_blue_crash_info_event_rp0;

typedef PACKED(struct) aci_hal_end_of_radio_activity_event_rp0_s {
  uint8_t Last_State;
  uint8_t Next_State;
  uint32_t Next_State_SysTime;
} aci_hal_end_of_radio_activity_event_rp0;

typedef PACKED(struct) aci_hal_scan_req_report_event_rp0_s {
  int8_t RSSI;
  uint8_t Peer_Address_Type;
  uint8_t Peer_Address[6];
} aci_hal_scan_req_report_event_rp0;

typedef PACKED(struct) aci_hal_fw_error_event_rp0_s {
  uint8_t FW_Error_Type;
  uint8_t Data_Length;
  uint8_t Data[(HCI_MAX_PAYLOAD_SIZE - 2)/sizeof(uint8_t)];
} aci_hal_fw_error_event_rp0;

typedef PACKED(struct) aci_hal_le_test_end_event_rp0_s {
  uint16_t Number_Of_Packets;
} aci_hal_le_test_end_event_rp0;

typedef PACKED(struct) aci_gap_pairing_complete_event_rp0_s {
  uint16_t Connection_Handle;
  uint8_t Status;
  uint8_t Reason;
} aci_gap_pairing_complete_event_rp0;

typedef PACKED(struct) aci_gap_pass_key_req_event_rp0_s {
  uint16_t Connection_Handle;
} aci_gap_pass_key_req_event_rp0;

typedef PACKED(struct) aci_gap_proc_complete_event_rp0_s {
  uint8_t Procedure_Code;
  uint8_t Status;
  uint8_t Data_Length;
  uint8_t Data[(HCI_MAX_PAYLOAD_SIZE - 3)/sizeof(uint8_t)];
} aci_gap_proc_complete_event_rp0;

typedef PACKED(struct) aci_gap_addr_not_resolved_event_rp0_s {
  uint16_t Connection_Handle;
} aci_gap_addr_not_resolved_event_rp0;

typedef PACKED(struct) aci_gap_numeric_comparison_value_event_rp0_s {
  uint16_t Connection_Handle;
  uint32_t Numeric_Value;
} aci_gap_numeric_comparison_value_event_rp0;

typedef PACKED(struct) aci_gap_keypress_notification_event_rp0_s {
  uint16_t Connection_Handle;
  uint8_t Notification_Type;
} aci_gap_keypress_notification_event_rp0;

typedef PACKED(struct) aci_l2cap_connection_update_resp_event_rp0_s {
  uint16_t Connection_Handle;
  uint16_t Result;
} aci_l2cap_connection_update_resp_event_rp0;

typedef PACKED(struct) aci_l2cap_proc_timeout_event_rp0_s {
  uint16_t Connection_Handle;
  uint8_t Data_Length;
  uint8_t Data[(HCI_MAX_PAYLOAD_SIZE - 3)/sizeof(uint8_t)];
} aci_l2cap_proc_timeout_event_rp0;

typedef PACKED(struct) aci_l2cap_connection_update_req_event_rp0_s {
  uint16_t Connection_Handle;
  uint8_t Identifier;
  uint16_t L2CAP_Length;
  uint16_t Interval_Min;
  uint16_t Interval_Max;
  uint16_t Slave_Latency;
  uint16_t Timeout_Multiplier;
} aci_l2cap_connection_update_req_event_rp0;

typedef PACKED(struct) aci_l2cap_cfc_connection_event_rp0_s {
  uint16_t Connection_Handle;
  uint8_t Event_Type;
  uint16_t Result;
  uint8_t Identifier;
  uint16_t SPSM;
  uint16_t CID;
  uint16_t Remote_CID;
  uint16_t Peer_MTU;
  uint16_t Peer_MPS;
  uint16_t Initial_Credits;
} aci_l2cap_cfc_connection_event_rp0;

typedef PACKED(struct) aci_l2cap_disconnection_complete_event_rp0_s {
  uint16_t Connection_Handle;
  uint16_t CID;
} aci_l2cap_disconnection_complete_event_rp0;

typedef PACKED(struct) aci_l2cap_flow_control_credit_event_rp0_s {
  uint16_t Connection_Handle;
  uint16_t CID;
  uint16_t TX_Credits;
  uint16_t TX_Credit_Balance;
} aci_l2cap_flow_control_credit_event_rp0;

typedef PACKED(struct) aci_l2cap_sdu_data_tx_nwk_event_rp0_s {
  uint16_t Connection_Handle;
  uint16_t CID;
  uint16_t SDU_Length;
  uint16_t TX_Credit_Balance;
} aci_l2cap_sdu_data_tx_nwk_event_rp0;

typedef PACKED(struct) aci_l2cap_sdu_data_rx_nwk_event_rp0_s {
  uint16_t Connection_Handle;
  uint16_t CID;
  uint16_t RX_Credit_Balance;
  uint16_t SDU_Length;
  uint8_t SDU_Data[(HCI_MAX_PAYLOAD_SIZE - 8)/sizeof(uint8_t)];
} aci_l2cap_sdu_data_rx_nwk_event_rp0;

typedef PACKED(struct) aci_l2cap_command_reject_event_rp0_s {
  uint16_t Connection_Handle;
  uint8_t Identifier;
  uint16_t Reason;
  uint8_t Data_Length;
  uint8_t Data[(HCI_MAX_PAYLOAD_SIZE - 6)/sizeof(uint8_t)];
} aci_l2cap_command_reject_event_rp0;

typedef PACKED(struct) aci_gatt_srv_attribute_modified_event_rp0_s {
  uint16_t Connection_Handle;
  uint16_t Attr_Handle;
  uint16_t Attr_Data_Length;
  uint8_t Attr_Data[(HCI_MAX_PAYLOAD_SIZE - 6)/sizeof(uint8_t)];
} aci_gatt_srv_attribute_modified_event_rp0;

typedef PACKED(struct) aci_gatt_proc_timeout_event_rp0_s {
  uint16_t Connection_Handle;
} aci_gatt_proc_timeout_event_rp0;

typedef PACKED(struct) aci_att_exchange_mtu_resp_event_rp0_s {
  uint16_t Connection_Handle;
  uint16_t Server_RX_MTU;
} aci_att_exchange_mtu_resp_event_rp0;

typedef PACKED(struct) aci_att_clt_find_info_resp_event_rp0_s {
  uint16_t Connection_Handle;
  uint8_t Format;
  uint16_t Event_Data_Length;
  uint8_t Handle_UUID_Pair[(HCI_MAX_PAYLOAD_SIZE - 5)/sizeof(uint8_t)];
} aci_att_clt_find_info_resp_event_rp0;

typedef PACKED(struct) aci_att_clt_find_by_type_value_resp_event_rp0_s {
  uint16_t Connection_Handle;
  uint8_t Num_of_Handle_Pair;
  packed_Attribute_Group_Handle_Pair_t Attribute_Group_Handle_Pair[(HCI_MAX_PAYLOAD_SIZE - 3)/sizeof(packed_Attribute_Group_Handle_Pair_t)];
} aci_att_clt_find_by_type_value_resp_event_rp0;

typedef PACKED(struct) aci_att_clt_read_by_type_resp_event_rp0_s {
  uint16_t Connection_Handle;
  uint8_t Handle_Value_Pair_Length;
  uint16_t Data_Length;
  uint8_t Handle_Value_Pair_Data[(HCI_MAX_PAYLOAD_SIZE - 5)/sizeof(uint8_t)];
} aci_att_clt_read_by_type_resp_event_rp0;

typedef PACKED(struct) aci_att_clt_read_resp_event_rp0_s {
  uint16_t Connection_Handle;
  uint16_t Event_Data_Length;
  uint8_t Attribute_Value[(HCI_MAX_PAYLOAD_SIZE - 4)/sizeof(uint8_t)];
} aci_att_clt_read_resp_event_rp0;

typedef PACKED(struct) aci_att_clt_read_blob_resp_event_rp0_s {
  uint16_t Connection_Handle;
  uint16_t Event_Data_Length;
  uint8_t Attribute_Value[(HCI_MAX_PAYLOAD_SIZE - 4)/sizeof(uint8_t)];
} aci_att_clt_read_blob_resp_event_rp0;

typedef PACKED(struct) aci_att_clt_read_multiple_resp_event_rp0_s {
  uint16_t Connection_Handle;
  uint16_t Event_Data_Length;
  uint8_t Set_Of_Values[(HCI_MAX_PAYLOAD_SIZE - 4)/sizeof(uint8_t)];
} aci_att_clt_read_multiple_resp_event_rp0;

typedef PACKED(struct) aci_att_clt_read_by_group_type_resp_event_rp0_s {
  uint16_t Connection_Handle;
  uint8_t Attribute_Data_Length;
  uint16_t Data_Length;
  uint8_t Attribute_Data_List[(HCI_MAX_PAYLOAD_SIZE - 5)/sizeof(uint8_t)];
} aci_att_clt_read_by_group_type_resp_event_rp0;

typedef PACKED(struct) aci_att_clt_prepare_write_resp_event_rp0_s {
  uint16_t Connection_Handle;
  uint16_t Attribute_Handle;
  uint16_t Offset;
  uint16_t Part_Attribute_Value_Length;
  uint8_t Part_Attribute_Value[(HCI_MAX_PAYLOAD_SIZE - 8)/sizeof(uint8_t)];
} aci_att_clt_prepare_write_resp_event_rp0;

typedef PACKED(struct) aci_att_clt_exec_write_resp_event_rp0_s {
  uint16_t Connection_Handle;
} aci_att_clt_exec_write_resp_event_rp0;

typedef PACKED(struct) aci_gatt_clt_indication_event_rp0_s {
  uint16_t Connection_Handle;
  uint16_t Attribute_Handle;
  uint16_t Attribute_Value_Length;
  uint8_t Attribute_Value[(HCI_MAX_PAYLOAD_SIZE - 6)/sizeof(uint8_t)];
} aci_gatt_clt_indication_event_rp0;

typedef PACKED(struct) aci_gatt_clt_notification_event_rp0_s {
  uint16_t Connection_Handle;
  uint16_t Attribute_Handle;
  uint16_t Attribute_Value_Length;
  uint8_t Attribute_Value[(HCI_MAX_PAYLOAD_SIZE - 6)/sizeof(uint8_t)];
} aci_gatt_clt_notification_event_rp0;

typedef PACKED(struct) aci_gatt_clt_proc_complete_event_rp0_s {
  uint16_t Connection_Handle;
  uint8_t Error_Code;
} aci_gatt_clt_proc_complete_event_rp0;

typedef PACKED(struct) aci_gatt_clt_error_resp_event_rp0_s {
  uint16_t Connection_Handle;
  uint8_t Req_Opcode;
  uint16_t Attribute_Handle;
  uint8_t Error_Code;
} aci_gatt_clt_error_resp_event_rp0;

typedef PACKED(struct) aci_gatt_clt_disc_read_char_by_uuid_resp_event_rp0_s {
  uint16_t Connection_Handle;
  uint16_t Attribute_Handle;
  uint8_t Attribute_Value_Length;
  uint8_t Attribute_Value[(HCI_MAX_PAYLOAD_SIZE - 5)/sizeof(uint8_t)];
} aci_gatt_clt_disc_read_char_by_uuid_resp_event_rp0;

typedef PACKED(struct) aci_gatt_tx_pool_available_event_rp0_s {
  uint16_t Connection_Handle;
  uint16_t Available_Buffers;
} aci_gatt_tx_pool_available_event_rp0;

typedef PACKED(struct) aci_gatt_srv_confirmation_event_rp0_s {
  uint16_t Connection_Handle;
} aci_gatt_srv_confirmation_event_rp0;

typedef PACKED(struct) aci_att_srv_exec_write_req_event_rp0_s {
  uint16_t Connection_Handle;
  uint8_t Flags;
} aci_att_srv_exec_write_req_event_rp0;

typedef PACKED(struct) aci_gatt_srv_authorize_nwk_event_rp0_s {
  uint16_t Conn_Handle;
  uint16_t Attr_Handle;
  uint8_t Operation_Type;
  uint16_t Attr_Val_Offset;
  uint8_t Data_Length;
  uint8_t Data[(HCI_MAX_PAYLOAD_SIZE - 8)/sizeof(uint8_t)];
} aci_gatt_srv_authorize_nwk_event_rp0;

typedef PACKED(struct) hci_le_connection_complete_event_rp0_s {
  uint8_t Status;
  uint16_t Connection_Handle;
  uint8_t Role;
  uint8_t Peer_Address_Type;
  uint8_t Peer_Address[6];
  uint16_t Conn_Interval;
  uint16_t Conn_Latency;
  uint16_t Supervision_Timeout;
  uint8_t Master_Clock_Accuracy;
} hci_le_connection_complete_event_rp0;

typedef PACKED(struct) hci_le_advertising_report_event_rp0_s {
  uint8_t Num_Reports;
  packed_Advertising_Report_t Advertising_Report[(HCI_MAX_PAYLOAD_SIZE - 1)/sizeof(packed_Advertising_Report_t)];
} hci_le_advertising_report_event_rp0;

typedef PACKED(struct) hci_le_connection_update_complete_event_rp0_s {
  uint8_t Status;
  uint16_t Connection_Handle;
  uint16_t Conn_Interval;
  uint16_t Conn_Latency;
  uint16_t Supervision_Timeout;
} hci_le_connection_update_complete_event_rp0;

typedef PACKED(struct) hci_le_read_remote_used_features_complete_event_rp0_s {
  uint8_t Status;
  uint16_t Connection_Handle;
  uint8_t LE_Features[8];
} hci_le_read_remote_used_features_complete_event_rp0;

typedef PACKED(struct) hci_le_long_term_key_request_event_rp0_s {
  uint16_t Connection_Handle;
  uint8_t Random_Number[8];
  uint16_t Encrypted_Diversifier;
} hci_le_long_term_key_request_event_rp0;

typedef PACKED(struct) hci_le_data_length_change_event_rp0_s {
  uint16_t Connection_Handle;
  uint16_t MaxTxOctets;
  uint16_t MaxTxTime;
  uint16_t MaxRxOctets;
  uint16_t MaxRxTime;
} hci_le_data_length_change_event_rp0;

typedef PACKED(struct) hci_le_read_local_p256_public_key_complete_event_rp0_s {
  uint8_t Status;
  uint8_t Local_P256_Public_Key[64];
} hci_le_read_local_p256_public_key_complete_event_rp0;

typedef PACKED(struct) hci_le_generate_dhkey_complete_event_rp0_s {
  uint8_t Status;
  uint8_t DHKey[32];
} hci_le_generate_dhkey_complete_event_rp0;

typedef PACKED(struct) hci_le_enhanced_connection_complete_event_rp0_s {
  uint8_t Status;
  uint16_t Connection_Handle;
  uint8_t Role;
  uint8_t Peer_Address_Type;
  uint8_t Peer_Address[6];
  uint8_t Local_Resolvable_Private_Address[6];
  uint8_t Peer_Resolvable_Private_Address[6];
  uint16_t Conn_Interval;
  uint16_t Conn_Latency;
  uint16_t Supervision_Timeout;
  uint8_t Master_Clock_Accuracy;
} hci_le_enhanced_connection_complete_event_rp0;

typedef PACKED(struct) hci_le_direct_advertising_report_event_rp0_s {
  uint8_t Num_Reports;
  packed_Direct_Advertising_Report_t Direct_Advertising_Report[(HCI_MAX_PAYLOAD_SIZE - 1)/sizeof(packed_Direct_Advertising_Report_t)];
} hci_le_direct_advertising_report_event_rp0;

typedef PACKED(struct) hci_le_phy_update_complete_event_rp0_s {
  uint8_t Status;
  uint16_t Connection_Handle;
  uint8_t TX_PHY;
  uint8_t RX_PHY;
} hci_le_phy_update_complete_event_rp0;

typedef PACKED(struct) hci_le_extended_advertising_report_event_rp0_s {
  uint8_t Num_Reports;
  packed_Extended_Advertising_Report_t Extended_Advertising_Report[(HCI_MAX_PAYLOAD_SIZE - 1)/sizeof(packed_Extended_Advertising_Report_t)];
} hci_le_extended_advertising_report_event_rp0;

typedef PACKED(struct) hci_le_periodic_advertising_sync_established_event_rp0_s {
  uint8_t Status;
  uint16_t Sync_Handle;
  uint8_t Advertising_SID;
  uint8_t Advertiser_Address_Type;
  uint8_t Advertiser_Address[6];
  uint8_t Advertiser_PHY;
  uint16_t Periodic_Advertising_Interval;
  uint8_t Advertiser_Clock_Accuracy;
} hci_le_periodic_advertising_sync_established_event_rp0;

typedef PACKED(struct) hci_le_periodic_advertising_report_event_rp0_s {
  uint16_t Sync_Handle;
  int8_t TX_Power;
  int8_t RSSI;
  uint8_t CTE_Type;
  uint8_t Data_Status;
  uint8_t Data_Length;
  uint8_t Data[(HCI_MAX_PAYLOAD_SIZE - 7)/sizeof(uint8_t)];
} hci_le_periodic_advertising_report_event_rp0;

typedef PACKED(struct) hci_le_periodic_advertising_sync_lost_event_rp0_s {
  uint16_t Sync_Handle;
} hci_le_periodic_advertising_sync_lost_event_rp0;

typedef PACKED(struct) hci_le_advertising_set_terminated_event_rp0_s {
  uint8_t Status;
  uint8_t Advertising_Handle;
  uint16_t Connection_Handle;
  uint8_t Num_Completed_Extended_Advertising_Events;
} hci_le_advertising_set_terminated_event_rp0;

typedef PACKED(struct) hci_le_scan_request_received_event_rp0_s {
  uint8_t Advertising_Handle;
  uint8_t Scanner_Address_Type;
  uint8_t Scanner_Address[6];
} hci_le_scan_request_received_event_rp0;

typedef PACKED(struct) hci_le_channel_selection_algorithm_event_rp0_s {
  uint16_t Connection_Handle;
  uint8_t Channel_Selection_Algorithm;
} hci_le_channel_selection_algorithm_event_rp0;

typedef PACKED(struct) hci_le_connectionless_iq_report_event_rp0_s {
  uint16_t Sync_Handle;
  uint8_t Channel_Index;
  uint16_t RSSI;
  uint8_t RSSI_Antenna_ID;
  uint8_t CTE_Type;
  uint8_t Slot_Durations;
  uint8_t Packet_Status;
  uint16_t Periodic_Event_Counter;
  uint8_t Sample_Count;
  packed_Samples_t Samples[(HCI_MAX_PAYLOAD_SIZE - 12)/sizeof(packed_Samples_t)];
} hci_le_connectionless_iq_report_event_rp0;

typedef PACKED(struct) hci_le_connection_iq_report_event_rp0_s {
  uint16_t Connection_Handle;
  uint8_t RX_PHY;
  uint8_t Data_Channel_Index;
  uint16_t RSSI;
  uint8_t RSSI_Antenna_ID;
  uint8_t CTE_Type;
  uint8_t Slot_Durations;
  uint8_t Packet_Status;
  uint16_t Connection_Event_Counter;
  uint8_t Sample_Count;
  packed_Samples_t Samples[(HCI_MAX_PAYLOAD_SIZE - 13)/sizeof(packed_Samples_t)];
} hci_le_connection_iq_report_event_rp0;

typedef PACKED(struct) hci_le_cte_request_failed_event_rp0_s {
  uint8_t Status;
  uint16_t Connection_Handle;
} hci_le_cte_request_failed_event_rp0;

typedef PACKED(struct) hci_le_periodic_advertising_sync_transfer_received_event_rp0_s {
  uint8_t Status;
  uint16_t Connection_Handle;
  uint16_t Service_data;
  uint16_t Sync_Handle;
  uint8_t Advertising_SID;
  uint8_t Advertiser_Address_Type;
  uint8_t Advertiser_Address[6];
  uint8_t Advertiser_PHY;
  uint16_t Periodic_Advertising_Interval;
  uint8_t Advertiser_Clock_Accuracy;
} hci_le_periodic_advertising_sync_transfer_received_event_rp0;

typedef PACKED(struct) hci_le_path_loss_threshold_event_rp0_s {
  uint16_t Connection_Handle;
  uint8_t Current_Path_Loss;
  uint8_t Zone_Entered;
} hci_le_path_loss_threshold_event_rp0;

typedef PACKED(struct) hci_le_transmit_power_reporting_event_rp0_s {
  uint8_t Status;
  uint16_t Connection_Handle;
  uint8_t Reason;
  uint8_t PHY;
  int8_t Transmit_Power_Level;
  uint8_t Transmit_Power_Level_Flag;
  int8_t Delta;
} hci_le_transmit_power_reporting_event_rp0;

#endif /* _BLUENRG_LP_TYPES_H_ */
