

/**
  ******************************************************************************
  * @file    bluenrg_lp_hci_le.h
  * @author  AMS - RF Application team
  * @date    07 May 2021
  * @brief   Header file for external uC - BlueNRG-x in network coprocessor mode (hci_le)
  *          Autogenerated files, do not edit!!
  ******************************************************************************
  * @attention
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  *
  * <h2><center>&copy; COPYRIGHT STMicroelectronics</center></h2>
  ******************************************************************************
  */
#ifndef _BLUENRG_LP_HCI_LE_H_
#define _BLUENRG_LP_HCI_LE_H_

#include "bluenrg_lp_types.h"
/** Documentation for C struct Advertising_Set_Parameters_t */
typedef struct Advertising_Set_Parameters_t_s {
  /** It is used to identify an advertising set.
   *  Values:
   *  - 0x00 ... 0xEF
   */
  uint8_t Advertising_Handle;
  /** The Duration[i] parameter indicates the duration for which that advertising set
   *  is enabled. The duration begins at the start of the first advertising
   *  event of this advertising set. The Controller should not start an extended
   *  advertising event that it cannot complete within the duration. Time = N *
   *  10 ms 0x00 means no advertising duration: advertising will continue until
   *  the Host disables it.
   *  Values:
   *  - 0x0000 (0 ms) : No advertising duration
   *  - 0x0001 (10 ms)  ... 0xFFFF (655350 ms) 
   */
  uint16_t Duration;
  /** The Max_Extended_Advertising_Events[i] parameter, if non-zero, indicates the
   *  maximum number of extended advertising events that shall be sent prior to
   *  disabling the extended advertising set even if the Duration[i] parameter
   *  has not expired.
   *  Values:
   *  - 0x00: No maximum number of advertising events.
   *  - 0x01 ... 0xFF: Maximum number of extended advertising events.
   */
  uint8_t Max_Extended_Advertising_Events;
} Advertising_Set_Parameters_t;
/** Documentation for C struct Extended_Scan_Parameters_t */
typedef struct Extended_Scan_Parameters_t_s {
  /** The Scan_Type parameter specifies the type of scan to perform. 0: Passive
   *  Scanning. No scan request PDUs shall be sent. 1: Active Scanning. Scan
   *  request PDUs may be sent.
   *  Values:
   *  - 0x00: Passive Scanning
   *  - 0x01: Active Scanning
   */
  uint8_t Scan_Type;
  /** Time interval from when the Controller started its last scan until it begins the
   *  subsequent scan on the primary advertising channel.  Time = N * 0.625 ms
   *  Values:
   *  - 0x0004 (2.500 ms)  ... 0xFFFF (40959.375 ms) 
   */
  uint16_t Scan_Interval;
  /** Duration of the scan on the primary advertising channel.  Time = N * 0.625 ms
   *  Values:
   *  - 0x0004 (2.500 ms)  ... 0xFFFF (40959.375 ms) 
   */
  uint16_t Scan_Window;
} Extended_Scan_Parameters_t;
/** Documentation for C struct Extended_Create_Connection_Parameters_t */
typedef struct Extended_Create_Connection_Parameters_t_s {
  /** Time interval from when the Controller started its last scan until it begins the
   *  subsequent scan on the primary advertising channel. Time = N * 0.625 ms;
   *  Time Range: 2.5 ms to 40.959375 s.
   *  Values:
   *  - 0x0004 (2.500 ms)  ... 0xFFFF (40959.375 ms) 
   */
  uint16_t Scan_Interval;
  /** Duration of the scan on the primary advertising channel. Time = N * 0.625 ms;
   *  Time Range: 2.5 ms to 40.959375 s.
   *  Values:
   *  - 0x0004 (2.500 ms)  ... 0xFFFF (40959.375 ms) 
   */
  uint16_t Scan_Window;
  /** Mimimun value for the connection interval. This shall be less than or equal to
   *  Conn_Interval_Max[i]. Time = N * 1.25 ms; Time Range: 7.5 ms to 4 s.
   *  Values:
   *  - 0x0006 (7.50 ms)  ... 0x0C80 (4000.00 ms) 
   */
  uint16_t Conn_Interval_Min;
  /** Maximum value for the connection interval. This shall be less than or equal to
   *  Conn_Interval_Max[i]. Time = N * 1.25 ms; Time Range: 7.5 ms to 4 s.
   *  Values:
   *  - 0x0006 (7.50 ms)  ... 0x0C80 (4000.00 ms) 
   */
  uint16_t Conn_Interval_Max;
  /** Slave latency for the connection in number of connection events
   *  Values:
   *  - 0x0000 ... 0x01F3
   */
  uint16_t Conn_Latency;
  /** Supervision timeout for the LE Link. (See [Vol 6] Part B, Section 4.5.2) Time =
   *  N * 10 ms; Time Range: 100 ms to 32 s.
   *  Values:
   *  - 0x000A (100 ms)  ... 0x0C80 (32000 ms) 
   */
  uint16_t Supervision_Timeout;
  /** Informative parameter recommending the minimum length of connection event needed
   *  for this LE connection. Time = N * 0.625 ms.
   *  Values:
   *  - 0x0000 (0.000 ms)  ... 0xFFFF (40959.375 ms) 
   */
  uint16_t Minimum_CE_Length;
  /** Informative parameter recommending the maximum length of connection event needed
   *  for this LE connection. Time = N * 0.625 ms.
   *  Values:
   *  - 0x0000 (0.000 ms)  ... 0xFFFF (40959.375 ms) 
   */
  uint16_t Maximum_CE_Length;
} Extended_Create_Connection_Parameters_t;
/**
 * @brief The @ref hci_disconnect is used to terminate an existing connection.
 *        The Connection_Handle command parameter indicates which connection is
 *        to be disconnected. The Reason command parameter indicates the reason
 *        for ending the connection. The remote Controller will receive the
 *        Reason command parameter in the @ref hci_disconnection_complete_event
 *        event. All synchronous connections on a physical link should be
 *        disconnected before the ACL connection on the same physical connection
 *        is disconnected. (See Bluetooth Specification v.4.1, Vol. 2, Part E,
 *        7.1.6) It is important to leave an 100 ms blank window before sending
 *        any new command (including system hardware reset), since immediately
 *        after @ref hci_disconnection_complete_event event, system could save
 *        important information in non volatile memory.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Reason The reason for ending the connection.
 *        Values:
 *        - 0x05: Authentication Failure
 *        - 0x13: Remote User Terminated Connection
 *        - 0x14: Remote Device Terminated Connection due to Low Resources
 *        - 0x15: Remote Device Terminated Connection due to Power Off
 *        - 0x1A: Unsupported Remote Feature
 *        - 0x3B: Unacceptable Connection Parameters
 * @retval Value indicating success or error code.
 */
tBleStatus hci_disconnect(uint16_t Connection_Handle,
                          uint8_t Reason);
/**
 * @brief This command will obtain the values for the version information for
 *        the remote device identified by the Connection_Handle parameter. The
 *        Connection_Handle must be a Connection_Handle for an ACL or LE
 *        connection. (See Bluetooth Specification v.4.1, Vol. 2, Part E,
 *        7.1.23)
 * @param Connection_Handle Specifies which Connection_Handle's version
 *        information to get.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @retval Value indicating success or error code.
 */
tBleStatus hci_read_remote_version_information(uint16_t Connection_Handle);
/**
 * @brief The Set_Event_Mask command is used to control which events are
 *        generated by the HCI for the Host.  If the bit in the Event_Mask is
 *        set to a one, then the event associated with that bit will be enabled.
 *        For an LE Controller, the LE Meta Event bit in the Event_Mask shall
 *        enable or disable all LE events in the LE Meta Event (see Section
 *        7.7.65). The Host has to deal with each event that occurs. The event
 *        mask allows the Host to control how much it is interrupted. (See
 *        Bluetooth Specification v.4.1, Vol. 2, Part E, 7.3.1)
 * @param Event_Mask Event mask. Default: 0x00001FFFFFFFFFFF
 *        Flags:
 *        - 0x0000000000000000: No events specified
 *        - 0x0000000000000001: Inquiry Complete Event
 *        - 0x0000000000000002: Inquiry Result Event
 *        - 0x0000000000000004: Connection Complete Event
 *        - 0x0000000000000008: Connection Request Event
 *        - 0x0000000000000010: Disconnection Complete Event
 *        - 0x0000000000000020: Authentication Complete Event
 *        - 0x0000000000000040: Remote Name Request Complete Event
 *        - 0x0000000000000080: Encryption Change Event
 *        - 0x0000000000000100: Change Connection Link Key Complete Event
 *        - 0x0000000000000200: Master Link Key Complete Event
 *        - 0x0000000000000400: Read Remote Supported Features Complete Event
 *        - 0x0000000000000800: Read Remote Version Information Complete Event
 *        - 0x0000000000001000: QoS Setup Complete Event
 *        - 0x0000000000008000: Hardware Error Event
 *        - 0x0000000000010000: Flush Occurred Event
 *        - 0x0000000000020000: Role Change Event
 *        - 0x0000000000080000: Mode Change Event
 *        - 0x0000000000100000: Return Link Keys Event
 *        - 0x0000000000200000: PIN Code Request Event
 *        - 0x0000000000400000: Link Key Request Event
 *        - 0x0000000000800000: Link Key Notification Event
 *        - 0x0000000001000000: Loopback Command Event
 *        - 0x0000000002000000: Data Buffer Overflow Event
 *        - 0x0000000004000000: Max Slots Change Event
 *        - 0x0000000008000000: Read Clock Offset Complete Event
 *        - 0x0000000010000000: Connection Packet Type Changed Event
 *        - 0x0000000020000000: QoS Violation Event
 *        - 0x0000000040000000: Page Scan Mode Change Event
 *        - 0x0000000080000000: Page Scan Repetition Mode Change Event
 *        - 0x0000000100000000: Flow Specification Complete Event
 *        - 0x0000000200000000: Inquiry Result with RSSI Event
 *        - 0x0000000400000000: Read Remote Extended Features Complete Event
 *        - 0x0000080000000000: Synchronous Connection Complete Event
 *        - 0x0000100000000000: Synchronous Connection Changed Event
 *        - 0x0000200000000000: Sniff Subrating Event
 *        - 0x0000400000000000: Extended Inquiry Result Event
 *        - 0x0000800000000000: Encryption Key Refresh Complete Event
 *        - 0x0001000000000000: IO Capability Request Event
 *        - 0x0002000000000000: IO Capability Request Reply Event
 *        - 0x0004000000000000: User Confirmation Request Event
 *        - 0x0008000000000000: User Passkey Request Event
 *        - 0x0010000000000000: Remote OOB Data Request Event
 *        - 0x0020000000000000: Simple Pairing Complete Event
 *        - 0x0080000000000000: Link Supervision Timeout Changed Event
 *        - 0x0100000000000000: Enhanced Flush Complete Event
 *        - 0x0400000000000000: User Passkey Notification Event
 *        - 0x0800000000000000: Keypress Notification Event
 *        - 0x1000000000000000: Remote Host Supported Features Notification Event
 *        - 0x2000000000000000: LE Meta-Event
 * @retval Value indicating success or error code.
 */
tBleStatus hci_set_event_mask(uint8_t Event_Mask[8]);
/**
 * @brief The Reset command will reset the Link Layer on an LE Controller.  The
 *        Reset command shall not affect the used HCI transport layer since the
 *        HCI transport layers may have reset mechanisms of their own. After the
 *        reset is completed, the current operational state will be lost, the
 *        Controller will enter standby mode and the Controller will
 *        automatically revert to the default values for the parameters for
 *        which default values are defined in the specification. Note: The Reset
 *        command will not necessarily perform a hardware reset. This is
 *        implementation defined.  The Host shall not send additional HCI
 *        commands before the Command Complete event related to the Reset
 *        command has been received. (See Bluetooth Specification v.4.1, Vol. 2,
 *        Part E, 7.3.2)
 * @retval Value indicating success or error code.
 */
tBleStatus hci_reset(void);
/**
 * @brief This command reads the values for the Transmit_Power_Level parameter
 *        for the specified Connection_Handle. The Connection_Handle shall be a
 *        Connection_Handle for an ACL connection. (See Bluetooth Specification
 *        v.4.1, Vol. 2, Part E, 7.3.35)
 * @param Connection_Handle Specifies which Connection_Handle's Transmit Power
 *        Level setting to read.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Type Current or maximum transmit power level.
 *        Values:
 *        - 0x00: Read Current Transmit Power Level.
 *        - 0x01: Read Maximum Transmit Power Level.
 * @param[out] Transmit_Power_Level Size: 1 Octet (signed integer) Units: dBm
 *             Values:
 *             - -30 ... 20
 * @retval Value indicating success or error code.
 */
tBleStatus hci_read_transmit_power_level(uint16_t Connection_Handle,
                                         uint8_t Type,
                                         int8_t *Transmit_Power_Level);
/**
 * @brief The HCI_Set_Event_Mask_Page_2 command is used to control which events
 *        are generated by the HCI for the Host. The Event_Mask_Page_2 is a
 *        logical extension to the Event_Mask parameter of the
 *        HCI_Set_Event_Mask command. If the bit in the Event_Mask_Page_2 is set
 *        to a one, then the event associated with that bit shall be enabled.
 *        The event mask allows the Host to control how much it is interrupted.
 *        The Controller shall ignore those bits which are reserved for future
 *        use or represent events which it does not support. If the Host sets
 *        any of these bits to 1, the Controller shall act as if they were set
 *        to 0.
 * @param Event_Mask_Page_2 For the complete list of bits tha can be set, see
 *        Core v5.1, Vol 2, part E, chapter 7.3.69. The only bit that is not
 *        ignored is: Bit 23: Authenticated Payload Timeout Expired event.
 *        Flags:
 *        - 0x0000000000800000: AUTHENTICATED_PAYLOAD_TIMEOUT_EXPIRED_EVENT
 * @retval Value indicating success or error code.
 */
tBleStatus hci_set_event_mask_page_2(uint8_t Event_Mask_Page_2[8]);
/**
 * @brief This command reads the Authenticated_Payload_Timeout parameter in the
 *        Primary Controller on the specified Connection_Handle.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param[out] Authenticated_Payload_Timeout Maximum amount of time specified
 *             between packets authenticated by a MIC. Time = N * 10 ms.
 *             Values:
 *             - 0x0001 (10 ms)  ... 0xFFFF (655350 ms) 
 * @retval Value indicating success or error code.
 */
tBleStatus hci_read_authenticated_payload_timeout(uint16_t Connection_Handle,
                                                  uint16_t *Authenticated_Payload_Timeout);
/**
 * @brief This command writes the Authenticated_Payload_Timeout parameter in the
 *        Primary Controller for the specified Connection_Handle. The
 *        Authenticated_Payload_Timeout shall be equal to or greater than
 *        connInterval * (1 + connSlaveLatency). The Link Layer will use this
 *        parameter to determine when to use the LE ping sequence.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Authenticated_Payload_Timeout Maximum amount of time specified between
 *        packets authenticated by a valid MIC. Time = N * 10 ms.
 *        Values:
 *        - 0x0001 (10 ms)  ... 0xFFFF (655350 ms) 
 * @retval Value indicating success or error code.
 */
tBleStatus hci_write_authenticated_payload_timeout(uint16_t Connection_Handle,
                                                   uint16_t Authenticated_Payload_Timeout);
/**
 * @brief This command reads the values for the version information for the
 *        local Controller. The HCI Version information defines the version
 *        information of the HCI layer. The LMP/PAL Version information defines
 *        the version of the LMP or PAL. The Manufacturer_Name information
 *        indicates the manufacturer of the local device. The HCI Revision and
 *        LMP/PAL Subversion are implementation dependent. (See Bluetooth
 *        Specification v.4.1, Vol. 2, Part E, 7.4.1)
 * @param[out] HCI_Version See Bluetooth Assigned Numbers
 *             (https://www.bluetooth.org/en-us/specification/assigned-numbers)
 * @param[out] HCI_Revision Revision of the Current HCI in the BR/EDR
 *             Controller.
 * @param[out] LMP_PAL_Version Version of the Current LMP or PAL in the
 *             Controller. See Bluetooth Assigned Numbers
 *             (https://www.bluetooth.org/en-us/specification/assigned-numbers)
 * @param[out] Manufacturer_Name Manufacturer Name of the BR/EDR Controller. See
 *             Bluetooth Assigned Numbers (https://www.bluetooth.org/en-
 *             us/specification/assigned-numbers)
 * @param[out] LMP_PAL_Subversion Subversion of the Current LMP or PAL in the
 *             Controller. This value is implementation dependent.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_read_local_version_information(uint8_t *HCI_Version,
                                              uint16_t *HCI_Revision,
                                              uint8_t *LMP_PAL_Version,
                                              uint16_t *Manufacturer_Name,
                                              uint16_t *LMP_PAL_Subversion);
/**
 * @brief This command reads the list of HCI commands supported for the local
 *        Controller. This command shall return the Supported_Commands
 *        configuration parameter. It is implied that if a command is listed as
 *        supported, the feature underlying that command is also supported. (See
 *        Bluetooth Specification v.4.1, Vol. 2, Part E, 7.4.2)
 * @param[out] Supported_Commands Bit mask for each HCI Command. If a bit is 1,
 *             the Controller supports the corresponding command and the
 *             features required for the command. Unsupported or undefined
 *             commands shall be set to 0.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_read_local_supported_commands(uint8_t Supported_Commands[64]);
/**
 * @brief This command requests a list of the supported features for the local
 *        Controller. This command will return a list of the LMP features. For
 *        details see Part C, Link Manager Protocol Specification on page 227.
 *        (See Bluetooth Specification v.4.1, Vol. 2, Part E, 7.4.3)
 * @param[out] LMP_Features Bit Mask List of LMP features.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_read_local_supported_features(uint8_t LMP_Features[8]);
/**
 * @brief On an LE Controller, this command shall read the Public Device Address
 *        as defined in [Vol 6] Part B, Section 1.3, Device Address. If this
 *        Controller does not have a Public Device Address, the value
 *        0x000000000000 shall be returned. On an LE Controller, the public
 *        address shall be the same as the BD_ADDR. (See Bluetooth Specification
 *        v.4.1, Vol. 2, Part E, 7.4.6)
 * @param[out] BD_ADDR BD_ADDR ( Bluetooth Device Address) of the Device.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_read_bd_addr(uint8_t BD_ADDR[6]);
/**
 * @brief This command reads the Received Signal Strength Indication (RSSI)
 *        value from a Controller. For an LE transport, a Connection_Handle is
 *        used as the Handle command parameter and return parameter. The meaning
 *        of the RSSI metric is an absolute receiver signal strength value in
 *        dBm to +/- 6 dB accuracy. If the RSSI cannot be read, the RSSI metric
 *        shall be set to 127. (See Bluetooth Specification v.4.1, Vol. 2, Part
 *        E, 7.5.4)
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param[out] RSSI N Size: 1 Octet (signed integer) Units: dBm
 *             Values:
 *             - 127: RSSI not available
 *             - -127 ... 20
 * @retval Value indicating success or error code.
 */
tBleStatus hci_read_rssi(uint16_t Connection_Handle,
                         int8_t *RSSI);
/**
 * @brief The LE_Set_Event_Mask command is used to control which LE events are
 *        generated by the HCI for the Host. If the bit in the LE_Event_Mask is
 *        set to a one, then the event associated with that bit will be enabled.
 *        The Host has to deal with each event that is generated by an LE
 *        Controller. The event mask allows the Host to control which events
 *        will interrupt it. For LE events to be generated, the LE Meta-Event
 *        bit in the Event_Mask shall also be set. If that bit is not set, then
 *        LE events shall not be generated, regardless of how the LE_Event_Mask
 *        is set. (See Bluetooth Specification v.4.1, Vol. 2, Part E, 7.8.1)
 * @param LE_Event_Mask LE event mask. Default: 0x000000000000001F.
 *        Flags:
 *        - 0x0000000000000000: No LE events specified
 *        - 0x0000000000000001: LE Connection Complete Event
 *        - 0x0000000000000002: LE Advertising Report Event
 *        - 0x0000000000000004: LE Connection Update Complete Event
 *        - 0x0000000000000008: LE Read Remote Used Features Complete Event
 *        - 0x0000000000000010: LE Long Term Key Request Event
 *        - 0x0000000000000020: LE Remote Connection Parameter Request Event
 *        - 0x0000000000000040: LE Data Length Change Event
 *        - 0x0000000000000080: LE Read Local P-256 Public Key Complete Event
 *        - 0x0000000000000100: LE Generate DHKey Complete Event
 *        - 0x0000000000000200: LE Enhanced Connection Complete Event
 *        - 0x0000000000000400: LE Directed Advertising Report Event
 *        - 0x0000000000000800: LE PHY Update Complete event
 *        - 0x0000000000001000: LE Extended Advertising Report event
 *        - 0x0000000000002000: LE Periodic Advertising Sync Established event
 *        - 0x0000000000004000: LE Periodic Advertising Report event
 *        - 0x0000000000008000: LE Periodic Advertising Sync Lost event
 *        - 0x0000000000010000: LE Scan Timeout event
 *        - 0x0000000000020000: LE Advertising Set Terminated event
 *        - 0x0000000000040000: LE Scan Request Received event
 *        - 0x0000000000080000: LE Channel Selection Algorithm event
 *        - 0x0000000000100000: LE Connectionless IQ Report event
 *        - 0x0000000000200000: LE Connection IQ Report event
 *        - 0x0000000000400000: LE CTE Request Failed event
 *        - 0x0000000000800000: LE Periodic Advertising Sync Transfer Received event
 *        - 0x0000000001000000: LE CIS Established event
 *        - 0x0000000002000000: LE CIS Request event
 *        - 0x0000000004000000: LE Create BIG Complete event
 *        - 0x0000000008000000: LE Terminate BIG Complete event
 *        - 0x0000000010000000: LE BIG Sync Established event
 *        - 0x0000000020000000: LE BIG Sync Lost event
 *        - 0x0000000040000000: LE Request Peer SCA Complete event
 *        - 0x0000000080000000: LE Path Loss Threshold event
 *        - 0x0000000100000000: LE Transmit Power Reporting event
 *        - 0x0000000200000000: LE BIGInfo Advertising Report event
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_event_mask(uint8_t LE_Event_Mask[8]);
/**
 * @brief The LE_Read_Buffer_Size command is used to read the maximum size of
 *        the data portion of HCI LE ACL Data Packets sent from the Host to the
 *        Controller. The Host will segment the data transmitted to the
 *        Controller according to these values, so that the HCI Data Packets
 *        will contain data with up to this size. The LE_Read_Buffer_Size
 *        command also returns the total number of HCI LE ACL Data Packets that
 *        can be stored in the data buffers of the Controller. The
 *        LE_Read_Buffer_Size command must be issued by the Host before it sends
 *        any data to an LE Controller (see Section 4.1.1). If the Controller
 *        returns a length value of zero, the Host shall use the
 *        Read_Buffer_Size command to determine the size of the data buffers
 *        Note: Both the Read_Buffer_Size and LE_Read_Buffer_Size commands may
 *        return buffer length and number of packets parameter values that are
 *        nonzero. The HC_LE_ACL_Data_Packet_Length return parameter shall be
 *        used to determine the size of the L2CAP PDU segments contained in ACL
 *        Data Packets, which are transferred from the Host to the Controller to
 *        be broken up into packets by the Link Layer. Both the Host and the
 *        Controller shall support command and event packets, where the data
 *        portion (excluding header) contained in the packets is 255 octets in
 *        size. The HC_Total_Num_LE_ACL_Data_Packets return parameter contains
 *        the total number of HCI ACL Data Packets that can be stored in the
 *        data buffers of the Controller. The Host determines how the buffers
 *        are to be divided between different Connection Handles. Note: The
 *        HC_LE_ACL_Data_Packet_Length return parameter does not include the
 *        length of the HCI Data Packet header. (See Bluetooth Specification
 *        v.4.1, Vol. 2, Part E, 7.8.2)
 * @param[out] HC_LE_ACL_Data_Packet_Length 0x0000: No dedicated LE Buffer
 *             exists. Use the HCI_Read_Buffer_Size command. 0x001B - 0xFFFF
 *             Maximum length (in octets) of the data portion of each HCI ACL
 *             data packet.
 *             Values:
 *             - 0x0000: NO_BUFFER
 *             - 0x001B ... 0xFFFF
 * @param[out] HC_Total_Num_LE_ACL_Data_Packets 0x00: No dedicated LE Buffer
 *             exists. Use the HCI_Read_Buffer_Size command. 0x01 - 0xFF: Total
 *             number of HCI ACL Data Packets that can be stored in the data
 *             buffers of the Controller.
 *             Values:
 *             - 0x00: NO_BUFFER
 *             - 0x01 ... 0xFF
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_read_buffer_size(uint16_t *HC_LE_ACL_Data_Packet_Length,
                                   uint8_t *HC_Total_Num_LE_ACL_Data_Packets);
/**
 * @brief This command requests the list of the supported LE features for the
 *        Controller. (See Bluetooth Specification v.4.1, Vol. 2, Part E, 7.8.3)
 * @param[out] LE_Features Bit Mask List of LE features. See Core v4.1, Vol. 6,
 *             Part B, Section 4.6.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_read_local_supported_features(uint8_t LE_Features[8]);
/**
 * @brief The LE_Set_Random_Address command is used by the Host to set the LE
 *        Random Device Address in the Controller (see [Vol 6] Part B, Section
 *        1.3). (See Bluetooth Specification v.4.1, Vol. 2, Part E, 7.8.4)
 * @param Random_Address Random Device Address.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_random_address(uint8_t Random_Address[6]);
/**
 * @brief The LE_Set_Advertising_Parameters command is used by the Host to set
 *        the advertising parameters. The Advertising_Interval_Min shall be less
 *        than or equal to the Advertising_Interval_Max. The
 *        Advertising_Interval_Min and Advertising_Interval_Max should not be
 *        the same value to enable the Controller to determine the best
 *        advertising interval given other activities. For high duty cycle
 *        directed advertising, i.e. when Advertising_Type is 0x01
 *        (ADV_DIRECT_IND, high duty cycle), the Advertising_Interval_Min and
 *        Advertising_Interval_Max parameters are not used and shall be ignored.
 *        The Advertising_Type is used to determine the packet type that is used
 *        for advertising when advertising is enabled. Own_Address_Type
 *        parameter indicates the type of address being used in the advertising
 *        packets. If Own_Address_Type equals 0x02 or 0x03, the Peer_Address
 *        parameter contains the peer's Identity Address and the
 *        Peer_Address_Type parameter contains the Peer's Identity Type (i.e.
 *        0x00 or 0x01). These parameters are used to locate the corresponding
 *        local IRK in the resolving list; this IRK is used to generate the own
 *        address used in the advertisement. If directed advertising is
 *        performed, i.e. when Advertising_Type is set to 0x01 (ADV_DIRECT_IND,
 *        high duty cycle) or 0x04 (ADV_DIRECT_IND, low duty cycle mode), then
 *        the Peer_Address_Type and Peer_Address shall be valid. If
 *        Own_Address_Type equals 0x02 or 0x03, the Controller generates the
 *        peer's Resolvable Private Address using the peer's IRK corresponding
 *        to the peer's Identity Address contained in the Peer_Address parameter
 *        and peer's Identity Address Type (i.e. 0x00 or 0x01) contained in the
 *        Peer_Address_Type parameter. The Advertising_Channel_Map is a bit
 *        field that indicates the advertising channels that shall be used when
 *        transmitting advertising packets. At least one channel bit shall be
 *        set in the Advertising_Channel_Map parameter. The
 *        Advertising_Filter_Policy parameter shall be ignored when directed
 *        advertising is enabled. The Host shall not issue this command when
 *        advertising is enabled in the Controller; if it is the Command
 *        Disallowed error code shall be used. If the advertising interval range
 *        provided by the Host (Advertising_Interval_Min,
 *        Advertising_Interval_Max) is outside the advertising interval range
 *        supported by the Controller, then the Controller shall return the
 *        Unsupported Feature or Parameter Value (0x11) error code.
 * @param Advertising_Interval_Min Minimum advertising interval for undirected
 *        and low duty cycle directed advertising. Time = N * 0.625 msec.
 *        Values:
 *        - 0x0020 (20.000 ms)  ... 0x4000 (10240.000 ms) 
 * @param Advertising_Interval_Max Maximum advertising interval. Time = N *
 *        0.625 msec.
 *        Values:
 *        - 0x0020 (20.000 ms)  ... 0x4000 (10240.000 ms) 
 * @param Advertising_Type Advertising type.
 *        Values:
 *        - 0x00: ADV_IND (Connectable undirected advertising)
 *        - 0x01: ADV_DIRECT_IND, high duty cycle (Connectable high duty cycle directed advertising)
 *        - 0x02: ADV_SCAN_IND (Scannable undirected advertising)
 *        - 0x03: ADV_NONCONN_IND (Non connectable undirected advertising)
 *        - 0x04: ADV_DIRECT_IND, low duty cycle (Connectable low duty cycle directed advertising)
 * @param Own_Address_Type Own address type.  - 0x00: Public Device Address  -
 *        0x01 Random Device Address  - 0x02: Controller generates Resolvable
 *        Private Address based on the local          IRK from resolving list.
 *        If resolving list contains no matching entry,          use public
 *        address.  - 0x03: Controller generates Resolvable Private Address
 *        based on the local          IRK from resolving list. If resolving list
 *        contains no matching entry,          use random address from
 *        LE_Set_Random_Address.
 *        Values:
 *        - 0x00: Public Device Address
 *        - 0x01: Random Device Address
 *        - 0x02: Resolvable Private Address or Public Address
 *        - 0x03: Resolvable Private Address or Random Address
 * @param Peer_Address_Type Peer Address type.
 *        Values:
 *        - 0x00: Public Device Address or Public Identity Address
 *        - 0x01: Random Device Address or Random (static) Identity Address
 * @param Peer_Address Public Device Address, Random Device Address, Public
 *        Identity Address or Random (static) Identity Address of the device to
 *        be connected.
 * @param Advertising_Channel_Map Advertising channel map. Default: 00000111b
 *        (all channels enabled).
 *        Flags:
 *        - 0x01: ch 37
 *        - 0x02: ch 38
 *        - 0x04: ch 39
 * @param Advertising_Filter_Policy Advertising Filter Policy. This parameter is
 *        ignored when directed advertising is enabled.  0x00 Process scan and
 *        connection requests from all devices (i.e., the White List is not in
 *        use) 0x01 Process connection requests from all devices and scan
 *        requests only from devices that are in the White List 0x02 Process
 *        scan requests from all devices and connection requests only from
 *        devices that are in the White List. 0x03 Process scan and connection
 *        requests only from devices in the White List. All other values
 *        Reserved for future use
 *        Values:
 *        - 0x00: ADV_NO_WHITE_LIST_USE
 *        - 0x01: ADV_WHITE_LIST_FOR_ONLY_SCAN
 *        - 0x02: ADV_WHITE_LIST_FOR_ONLY_CONN
 *        - 0x03: ADV_WHITE_LIST_FOR_ALL
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_advertising_parameters(uint16_t Advertising_Interval_Min,
                                             uint16_t Advertising_Interval_Max,
                                             uint8_t Advertising_Type,
                                             uint8_t Own_Address_Type,
                                             uint8_t Peer_Address_Type,
                                             uint8_t Peer_Address[6],
                                             uint8_t Advertising_Channel_Map,
                                             uint8_t Advertising_Filter_Policy);
/**
 * @brief The LE_Read_Advertising_Channel_Tx_Power command is used by the Host
 *        to read the transmit power level used for LE advertising channel
 *        packets. (See Bluetooth Specification v.4.1, Vol. 2, Part E, 7.8.6)
 * @param[out] Transmit_Power_Level Size: 1 Octet (signed integer) Units: dBm
 *             Accuracy: +/- 4 dBm
 *             Values:
 *             - -20 ... 10
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_read_advertising_channel_tx_power(int8_t *Transmit_Power_Level);
/**
 * @brief The LE_Set_Advertising_Data command is used to set the data used in
 *        advertising packets that have a data field. Only the significant part
 *        of the Advertising_Data is transmitted in the advertising packets, as
 *        defined in [Vol 3] Part C, Section 11., (See Bluetooth Specification
 *        v.4.1, Vol. 2, Part E, 7.8.7)
 * @param Advertising_Data_Length The number of significant octets in the
 *        following data field
 *        Values:
 *        - 0 ... 31
 * @param Advertising_Data 31 octets of data formatted as defined in [Vol 3]
 *        Part C, Section 11.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_advertising_data(uint8_t Advertising_Data_Length,
                                       uint8_t Advertising_Data[31]);
/**
 * @brief This command is used to provide data used in Scanning Packets that
 *        have a data field. Only the significant part of the Scan_Response_Data
 *        is transmitted in the Scanning Packets, as defined in [Vol 3] Part C,
 *        Section 11. (See Bluetooth Specification v.4.1, Vol. 2, Part E, 7.8.8)
 * @param Scan_Response_Data_Length The number of significant octets in the
 *        following data field
 *        Values:
 *        - 0 ... 31
 * @param Scan_Response_Data 31 octets of data formatted as defined in [Vol 3]
 *        Part C, Section 11.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_scan_response_data(uint8_t Scan_Response_Data_Length,
                                         uint8_t Scan_Response_Data[31]);
/**
 * @brief The LE_Set_Advertise_Enable command is used to request the Controller
 *        to start or stop advertising. The Controller manages the timing of
 *        advertisements as per the advertising parameters given in the
 *        LE_Set_Advertising_Parameters command. The Controller shall continue
 *        advertising until the Host issues an LE_Set_Advertise_Enable command
 *        with Advertising_Enable set to 0x00 (Advertising is disabled) or until
 *        a connection is created or until the Advertising is timed out due to
 *        high duty cycle Directed Advertising. In these cases, advertising is
 *        then disabled. (See Bluetooth Specification v.4.1, Vol. 2, Part E,
 *        7.8.9)
 * @param Advertising_Enable Enable/disable advertise. Default is 0 (disabled).
 *        Values:
 *        - 0x00: Disable
 *        - 0x01: Enable
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_advertising_enable(uint8_t Advertising_Enable);
/**
 * @brief The LE_Set_Scan_Parameters command is used to set the scan parameters.
 *        The LE_Scan_Type parameter controls the type of scan to perform. The
 *        LE_Scan_Interval and LE_Scan_Window parameters are recommendations
 *        from the Host on how long (LE_Scan_Window) and how frequently
 *        (LE_Scan_Interval) the Controller should scan (See [Vol 6] Part B,
 *        Section 4.5.3). The LE_Scan_Window parameter shall always be set to a
 *        value smaller or equal to the value set for the LE_Scan_Interval
 *        parameter. If they are set to the same value scanning should be run
 *        continuously. The Own_Address_Type parameter determines the address
 *        used (Public or Random Device Address) when performing active scan.
 *        The Host shall not issue this command when scanning is enabled in the
 *        Controller; if it is the Command Disallowed error code shall be used.
 *        (See Bluetooth Specification v.4.1, Vol. 2, Part E, 7.8.10)
 * @param LE_Scan_Type Passive or active scanning. With active scanning SCAN_REQ
 *        packets are sent.
 *        Values:
 *        - 0x00: Passive Scanning
 *        - 0x01: Active scanning
 * @param LE_Scan_Interval This is defined as the time interval from when the
 *        Controller started its last LE scan until it begins the subsequent LE
 *        scan. Time = N * 0.625 msec.
 *        Values:
 *        - 0x0004 (2.500 ms)  ... 0x4000 (10240.000 ms) 
 * @param LE_Scan_Window The duration of the LE scan. LE_Scan_Window shall be
 *        less than or equal to LE_Scan_Interval. Time = N * 0.625 msec.
 *        Values:
 *        - 0x0004 (2.500 ms)  ... 0x4000 (10240.000 ms) 
 * @param Own_Address_Type Own address type.  - 0x00: Public Device Address  -
 *        0x01 Random Device Address  - 0x02: Controller generates Resolvable
 *        Private Address based on the local          IRK from resolving list.
 *        If resolving list contains no matching entry,          use public
 *        address.  - 0x03: Controller generates Resolvable Private Address
 *        based on the local          IRK from resolving list. If resolving list
 *        contains no matching entry,          use random address from
 *        LE_Set_Random_Address.
 *        Values:
 *        - 0x00: Public Device Address
 *        - 0x01: Random Device Address
 *        - 0x02: Resolvable Private Address or Public Address
 *        - 0x03: Resolvable Private Address or Random Address
 * @param Scanning_Filter_Policy 0x00 Accept all advertisement packets. Directed
 *        advertising packets which are not addressed for this device shall be
 *        ignored. 0x01 Ignore advertisement packets from devices not in the
 *        White List Only. Directed advertising packets which are not addressed
 *        for this device shall be ignored 0x02 Accept all undirected
 *        advertisement packets. Directed advertisement packets where initiator
 *        address is a RPA and  Directed advertisement packets addressed to this
 *        device shall be accepted. 0x03 Accept all undirected advertisement
 *        packets from devices that are in the White List.Directed advertisement
 *        packets where initiator address is RPA and Directed advertisement
 *        packets addressed to this device shall be accepted.
 *        Values:
 *        - 0x00: Accept all
 *        - 0x01: Ignore devices not in the White List
 *        - 0x02: Accept all (use resolving list)
 *        - 0x03: Ignore devices not in the White List (use resolving list)
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_scan_parameters(uint8_t LE_Scan_Type,
                                      uint16_t LE_Scan_Interval,
                                      uint16_t LE_Scan_Window,
                                      uint8_t Own_Address_Type,
                                      uint8_t Scanning_Filter_Policy);
/**
 * @brief The LE_Set_Scan_Enable command is used to start scanning. Scanning is
 *        used to discover advertising devices nearby. The Filter_Duplicates
 *        parameter controls whether the Link Layer shall filter duplicate
 *        advertising reports to the Host, or if the Link Layer should generate
 *        advertising reports for each packet received. (See Bluetooth
 *        Specification v.4.1, Vol. 2, Part E, 7.8.11)
 * @param LE_Scan_Enable Enable/disable scan. Default is 0 (disabled).
 *        Values:
 *        - 0x00: Scanning disabled
 *        - 0x01: Scanning enabled
 * @param Filter_Duplicates Enable/disable duplicate filtering.
 *        Values:
 *        - 0x00: Duplicate filtering disabled
 *        - 0x01: Duplicate filtering enabled
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_scan_enable(uint8_t LE_Scan_Enable,
                                  uint8_t Filter_Duplicates);
/**
 * @brief The LE_Create_Connection command is used to create a Link Layer
 *        connection to a connectable advertiser. The LE_Scan_Interval and
 *        LE_Scan_Window parameters are recommendations from the Host on how
 *        long (LE_Scan_Window) and how frequently (LE_Scan_Interval) the
 *        Controller should scan. The LE_Scan_Window parameter shall be set to a
 *        value smaller or equal to the value set for the LE_Scan_Interval
 *        parameter. If both are set to the same value, scanning should run
 *        continuously. The Initiator_Filter_Policy is used to determine whether
 *        the White List is used. If the White List is not used, the
 *        Peer_Address_Type and the Peer_Address parameters specify the address
 *        type and address of the advertising device to connect to. The Link
 *        Layer shall set the address in the CONNECT_REQ packets to either the
 *        Public Device Address or the Random Device Addressed based on the
 *        Own_Address_Type parameter. The Conn_Interval_Min and
 *        Conn_Interval_Max parameters define the minimum and maximum allowed
 *        connection interval. The Conn_Interval_Min parameter shall not be
 *        greater than the Conn_Interval_Max parameter. The Conn_Latency
 *        parameter defines the maximum allowed connection latency (see [Vol 6]
 *        Part B, Section 4.5.1). The Supervision_Timeout parameter defines the
 *        link supervision timeout for the connection. The Supervision_Timeout
 *        in milliseconds shall be larger than (1 + Conn_Latency) *
 *        Conn_Interval_Max * 2, where Conn_Interval_Max is given in
 *        milliseconds. (See [Vol 6] Part B, Section 4.5.2). The
 *        Minimum_CE_Length and Maximum_CE_Length parameters are informative
 *        parameters providing the Controller with the expected minimum and
 *        maximum length of the connection events. The Minimum_CE_Length
 *        parameter shall be less than or equal to the Maximum_CE_Length
 *        parameter. The Host shall not issue this command when another
 *        LE_Create_Connection is pending in the Controller; if this does occur
 *        the Controller shall return the Command Disallowed error code shall be
 *        used. (See Bluetooth Specification v.4.1, Vol. 2, Part E, 7.8.12)
 * @param LE_Scan_Interval This is defined as the time interval from when the
 *        Controller started its last LE scan until it begins the subsequent LE
 *        scan. Time = N * 0.625 msec.
 *        Values:
 *        - 0x0004 (2.500 ms)  ... 0x4000 (10240.000 ms) 
 * @param LE_Scan_Window The duration of the LE scan. LE_Scan_Window shall be
 *        less than or equal to LE_Scan_Interval. Time = N * 0.625 msec.
 *        Values:
 *        - 0x0004 (2.500 ms)  ... 0x4000 (10240.000 ms) 
 * @param Initiator_Filter_Policy 0x00 White list is not used to determine which
 *        advertiser to connect to. Peer_Address_Type and Peer_Address shall be
 *        used. 0x01 White list is used to determine which advertiser to connect
 *        to. Peer_Address_Type and Peer_Address shall be ignored.
 *        Values:
 *        - 0x00: White list not used
 *        - 0x01: White list used
 * @param Peer_Address_Type 0x00 Public Device Address 0x01 Random Device
 *        Address 0x02 Public Identity Address (Corresponds to Resolved Private
 *        Address) 0x03 Random (Static) Identity Address (Corresponds to
 *        Resolved Private Address)
 *        Values:
 *        - 0x00: Public Device Address
 *        - 0x01: Random Device Address
 *        - 0x02: Public Identity Address
 *        - 0x03: Random (Static) Identity Address
 * @param Peer_Address Public Device Address, Random Device Address, Public
 *        Identity Address or Random (static) Identity Address of the
 *        advertising device.
 * @param Own_Address_Type Own address type.  - 0x00: Public Device Address  -
 *        0x01 Random Device Address  - 0x02: Controller generates Resolvable
 *        Private Address based on the local          IRK from resolving list.
 *        If resolving list contains no matching entry,          use public
 *        address.  - 0x03: Controller generates Resolvable Private Address
 *        based on the local          IRK from resolving list. If resolving list
 *        contains no matching entry,          use random address from
 *        LE_Set_Random_Address.
 *        Values:
 *        - 0x00: Public Device Address
 *        - 0x01: Random Device Address
 *        - 0x02: Resolvable Private Address or Public Address
 *        - 0x03: Resolvable Private Address or Random Address
 * @param Conn_Interval_Min Minimum value for the connection event interval.
 *        This shall be less than or equal to Conn_Interval_Max. Time = N * 1.25
 *        msec.
 *        Values:
 *        - 0x0006 (7.50 ms)  ... 0x0C80 (4000.00 ms) 
 * @param Conn_Interval_Max Maximum value for the connection event interval.
 *        This shall be greater than or equal to Conn_Interval_Min. Time = N *
 *        1.25 msec.
 *        Values:
 *        - 0x0006 (7.50 ms)  ... 0x0C80 (4000.00 ms) 
 * @param Conn_Latency Slave latency for the connection in number of connection
 *        events.
 *        Values:
 *        - 0x0000 ... 0x01F3
 * @param Supervision_Timeout Supervision timeout for the LE Link. It shall be a
 *        multiple of 10 ms and larger than (1 + connSlaveLatency) *
 *        connInterval * 2. Time = N * 10 msec.
 *        Values:
 *        - 0x000A (100 ms)  ... 0x0C80 (32000 ms) 
 * @param Minimum_CE_Length Information parameter about the minimum length of
 *        connection needed for this LE connection. Time = N * 0.625 msec.
 * @param Maximum_CE_Length Information parameter about the maximum length of
 *        connection needed for this LE connection. Time = N * 0.625 msec.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_create_connection(uint16_t LE_Scan_Interval,
                                    uint16_t LE_Scan_Window,
                                    uint8_t Initiator_Filter_Policy,
                                    uint8_t Peer_Address_Type,
                                    uint8_t Peer_Address[6],
                                    uint8_t Own_Address_Type,
                                    uint16_t Conn_Interval_Min,
                                    uint16_t Conn_Interval_Max,
                                    uint16_t Conn_Latency,
                                    uint16_t Supervision_Timeout,
                                    uint16_t Minimum_CE_Length,
                                    uint16_t Maximum_CE_Length);
/**
 * @brief The LE_Create_Connection_Cancel command is used to cancel the
 *        LE_Create_Connection command. This command shall only be issued after
 *        the LE_Create_Connection command has been issued, a Command Status
 *        event has been received for the LE Create Connection command and
 *        before the LE Connection Complete event. (See Bluetooth Specification
 *        v.4.1, Vol. 2, Part E, 7.8.13)
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_create_connection_cancel(void);
/**
 * @brief The LE_Read_White_List_Size command is used to read the total number
 *        of white list entries that can be stored in the Controller. (See
 *        Bluetooth Specification v.4.1, Vol. 2, Part E, 7.8.14)
 * @param[out] White_List_Size Total number of white list entries that can be
 *             stored in the Controller.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_read_white_list_size(uint8_t *White_List_Size);
/**
 * @brief The LE_Clear_White_List command is used to clear the white list stored
 *        in the Controller. This command can be used at any time except when: -
 *        the advertising filter policy uses the white list and advertising is
 *        enabled. - the scanning filter policy uses the white list and scanning
 *        is enabled. - the initiator filter policy uses the white list and an
 *        LE_Create_Connection command is outstanding. (See Bluetooth
 *        Specification v.4.1, Vol. 2, Part E, 7.8.15)
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_clear_white_list(void);
/**
 * @brief The LE_Add_Device_To_White_List command is used to add a single device
 *        to the white list stored in the Controller. This command can be used
 *        at any time except when: - the advertising filter policy uses the
 *        white list and advertising is enabled. - the scanning filter policy
 *        uses the white list and scanning is enabled. - the initiator filter
 *        policy uses the white list and a create connection command is
 *        outstanding. (See Bluetooth Specification v.4.1, Vol. 2, Part E,
 *        7.8.16)
 * @param Address_Type Address type.
 *        Values:
 *        - 0x00: Public Device Address
 *        - 0x01: Random Device Address
 * @param Address Public Device Address or Random Device Address of the device
 *        to be added to the list.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_add_device_to_white_list(uint8_t Address_Type,
                                           uint8_t Address[6]);
/**
 * @brief The LE_Remove_Device_From_White_List command is used to remove a
 *        single device from the white list stored in the Controller. This
 *        command can be used at any time except when: - the advertising filter
 *        policy uses the white list and advertising is enabled. - the scanning
 *        filter policy uses the white list and scanning is enabled. - the
 *        initiator filter policy uses the white list and a create connection
 *        command is outstanding. (See Bluetooth Specification v.4.1, Vol. 2,
 *        Part E, 7.8.17)
 * @param Address_Type Address type.
 *        Values:
 *        - 0x00: Public Device Address
 *        - 0x01: Random Device Address
 * @param Address Public Device Address or Random Device Address of the device
 *        to be removed from the white list.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_remove_device_from_white_list(uint8_t Address_Type,
                                                uint8_t Address[6]);
/**
 * @brief The LE_Connection_Update command is used to change the Link Layer
 *        connection parameters of a connection. This command is supported only
 *        on master side. The Conn_Interval_Min and Conn_Interval_Max parameters
 *        are used to define the minimum and maximum allowed connection
 *        interval. The Conn_Interval_Min parameter shall not be greater than
 *        the Conn_Interval_Max parameter. The Conn_Latency parameter shall
 *        define the maximum allowed connection latency. The Supervision_Timeout
 *        parameter shall define the link supervision timeout for the LE link.
 *        The Supervision_Timeout in milliseconds shall be larger than (1 +
 *        Conn_Latency) * Conn_Interval_Max * 2, where Conn_Interval_Max is
 *        given in milliseconds. The Minimum_CE_Length and Maximum_CE_Length are
 *        information parameters providing the Controller with a hint about the
 *        expected minimum and maximum length of the connection events. The
 *        Minimum_CE_Length shall be less than or equal to the
 *        Maximum_CE_Length. The actual parameter values selected by the Link
 *        Layer may be different from the parameter values provided by the Host
 *        through this command. (See Bluetooth Specification v.4.1, Vol. 2, Part
 *        E, 7.8.18)
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Conn_Interval_Min Minimum value for the connection event interval.
 *        This shall be less than or equal to Conn_Interval_Max. Time = N * 1.25
 *        msec.
 *        Values:
 *        - 0x0006 (7.50 ms)  ... 0x0C80 (4000.00 ms) 
 * @param Conn_Interval_Max Maximum value for the connection event interval.
 *        This shall be greater than or equal to Conn_Interval_Min. Time = N *
 *        1.25 msec.
 *        Values:
 *        - 0x0006 (7.50 ms)  ... 0x0C80 (4000.00 ms) 
 * @param Conn_Latency Slave latency for the connection in number of connection
 *        events.
 *        Values:
 *        - 0x0000 ... 0x01F3
 * @param Supervision_Timeout Supervision timeout for the LE Link. It shall be a
 *        multiple of 10 ms and larger than (1 + connSlaveLatency) *
 *        connInterval * 2. Time = N * 10 msec.
 *        Values:
 *        - 0x000A (100 ms)  ... 0x0C80 (32000 ms) 
 * @param Minimum_CE_Length Information parameter about the minimum length of
 *        connection needed for this LE connection. Time = N * 0.625 msec.
 * @param Maximum_CE_Length Information parameter about the maximum length of
 *        connection needed for this LE connection. Time = N * 0.625 msec.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_connection_update(uint16_t Connection_Handle,
                                    uint16_t Conn_Interval_Min,
                                    uint16_t Conn_Interval_Max,
                                    uint16_t Conn_Latency,
                                    uint16_t Supervision_Timeout,
                                    uint16_t Minimum_CE_Length,
                                    uint16_t Maximum_CE_Length);
/**
 * @brief The LE_Set_Host_Channel_Classification command allows the Host to
 *        specify a channel classification for data channels based on its "local
 *        information". This classification persists until overwritten with a
 *        subsequent LE_Set_Host_Channel_Classification command or until the
 *        Controller is reset using the Reset command (see [Vol 6] Part B,
 *        Section 4.5.8.1). If this command is used, the Host should send it
 *        within 10 seconds of knowing that the channel classification has
 *        changed. The interval between two successive commands sent shall be at
 *        least one second. This command shall only be used when the local
 *        device supports the Master role. (See Bluetooth Specification v.4.1,
 *        Vol. 2, Part E, 7.8.19)
 * @param LE_Channel_Map This parameter contains 37 1-bit fields. The nth such
 *        field (in the range 0 to 36) contains the value for the link layer
 *        channel index n. Channel n is bad = 0. Channel n is unknown = 1. The
 *        most significant bits are reserved and shall be set to 0. At least one
 *        channel shall be marked as unknown.
 *        Flags:
 *        - 0x0000000000 ... 0x1FFFFFFFFF
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_host_channel_classification(uint8_t LE_Channel_Map[5]);
/**
 * @brief The LE_Read_Channel_Map command returns the current Channel_Map for
 *        the specified Connection_Handle. The returned value indicates the
 *        state of the Channel_Map specified by the last transmitted or received
 *        Channel_Map (in a CONNECT_REQ or LL_CHANNEL_MAP_REQ message) for the
 *        specified Connection_Handle, regardless of whether the Master has
 *        received an acknowledgement. (See Bluetooth Specification v.4.1, Vol.
 *        2, Part E, 7.8.20)
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param[out] LE_Channel_Map This parameter contains 37 1-bit fields. The nth
 *             such field (in the range 0 to 36) contains the value for the link
 *             layer channel index n. Channel n is unused = 0. Channel n is used
 *             = 1. The most significant bits are reserved and shall be set to
 *             0.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_read_channel_map(uint16_t Connection_Handle,
                                   uint8_t LE_Channel_Map[5]);
/**
 * @brief This command requests a list of the used LE features from the remote
 *        device. This command shall return a list of the used LE features. For
 *        details see [Vol 6] Part B, Section 4.6. This command may be issued on
 *        both the master and slave. (See Bluetooth Specification v.4.1, Vol. 2,
 *        Part E, 7.8.21)
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_read_remote_used_features(uint16_t Connection_Handle);
/**
 * @brief The LE_Encrypt command is used to request the Controller to encrypt
 *        the Plaintext_Data in the command using the Key given in the command
 *        and returns the Encrypted_Data to the Host. The AES-128 bit block
 *        cypher is defined in NIST Publication FIPS-197
 *        (http://csrc.nist.gov/publications/fips/ fips197/fips-197.pdf). (See
 *        Bluetooth Specification v.4.1, Vol. 2, Part E, 7.8.22)
 * @param Key 128 bit key for the encryption of the data given in the command.
 * @param Plaintext_Data 128 bit data block that is requested to be encrypted.
 * @param[out] Encrypted_Data 128 bit encrypted data block.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_encrypt(uint8_t Key[16],
                          uint8_t Plaintext_Data[16],
                          uint8_t Encrypted_Data[16]);
/**
 * @brief The LE_Rand command is used to request the Controller to generate 8
 *        octets of random data to be sent to the Host. The Random_Number shall
 *        be generated according to [Vol 2] Part H, Section 2 if the LE Feature
 *        (LL Encryption) is supported. (See Bluetooth Specification v.4.1, Vol.
 *        2, Part E, 7.8.23)
 * @param[out] Random_Number Random Number
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_rand(uint8_t Random_Number[8]);
/**
 * @brief The LE_Start_Encryption command is used to authenticate the given
 *        encryption key associated with the remote device specified by the
 *        connection handle, and once authenticated will encrypt the connection.
 *        The parameters are as defined in [Vol 3] Part H, Section 2.4.4. If the
 *        connection is already encrypted then the Controller shall pause
 *        connection encryption before attempting to authenticate the given
 *        encryption key, and then re-encrypt the connection. While encryption
 *        is paused no user data shall be transmitted. On an authentication
 *        failure, the connection shall be automatically disconnected by the
 *        Link Layer. If this command succeeds, then the connection shall be
 *        encrypted. This command shall only be used when the local device's
 *        role is Master. (See Bluetooth Specification v.4.1, Vol. 2, Part E,
 *        7.8.24)
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Random_Number 64 bit random number.
 * @param Encrypted_Diversifier 16 bit encrypted diversifier.
 * @param Long_Term_Key 128 bit long term key.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_start_encryption(uint16_t Connection_Handle,
                                   uint8_t Random_Number[8],
                                   uint16_t Encrypted_Diversifier,
                                   uint8_t Long_Term_Key[16]);
/**
 * @brief The LE_Long_Term_Key_Request_Reply command is used to reply to an LE
 *        Long Term Key Request event from the Controller, and specifies the
 *        Long_Term_Key parameter that shall be used for this Connection_Handle.
 *        The Long_Term_Key is used as defined in [Vol 6] Part B, Section 5.1.3.
 *        (See Bluetooth Specification v.4.1, Vol. 2, Part E, 7.8.25)
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Long_Term_Key 128 bit long term key.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_long_term_key_request_reply(uint16_t Connection_Handle,
                                              uint8_t Long_Term_Key[16]);
/**
 * @brief The LE_Long_Term_Key_Request_Negative_Reply command is used to reply
 *        to an LE Long Term Key Request event from the Controller if the Host
 *        cannot provide a Long Term Key for this Connection_Handle. (See
 *        Bluetooth Specification v.4.1, Vol. 2, Part E, 7.8.26)
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_long_term_key_requested_negative_reply(uint16_t Connection_Handle);
/**
 * @brief The LE_Read_Supported_States command reads the states and state
 *        combinations that the link layer supports. See [Vol 6] Part B, Section
 *        1.1.1. LE_States is an 8-octet bit field. If a bit is set to 1 then
 *        this state or state combination is supported by the Controller.
 *        Multiple bits in LE_States may be set to 1 to indicate support for
 *        multiple state and state combinations. All the Advertising type with
 *        the Initiate State combinations shall be set only if the corresponding
 *        Advertising types and Master Role combination are set. All the
 *        Scanning types and the Initiate State combinations shall be set only
 *        if the corresponding Scanning types and Master Role combination are
 *        set. (See Bluetooth Specification v.4.1, Vol. 2, Part E, 7.8.27)
 * @param[out] LE_States State or state combination is supported by the
 *             Controller. See Core v4.1, Vol.2, part E, Ch. 7.8.27.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_read_supported_states(uint8_t LE_States[8]);
/**
 * @brief This command is used to start a test where the DUT receives test
 *        reference packets at a fixed interval. The tester generates the test
 *        reference packets. (See Bluetooth Specification v.4.1, Vol. 2, Part E,
 *        7.8.28)
 * @param RX_Frequency
 *        Values:
 *        - 0x00 ... 0x27: N = (F - 2402) / 2.Frequency Range : 2402 MHz to 2480 MHz
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_receiver_test(uint8_t RX_Frequency);
/**
 * @brief This command is used to start a test where the DUT generates test
 *        reference packets at a fixed interval. The Controller shall transmit
 *        at maximum power. An LE Controller supporting the LE_Transmitter_Test
 *        command shall support Packet_Payload values 0x00, 0x01 and 0x02. An LE
 *        Controller may support other values of Packet_Payload. (See Bluetooth
 *        Specification v.4.1, Vol. 2, Part E, 7.8.29)
 * @param TX_Frequency N = (F - 2402) / 2
 *        Frequency Range : 2402 MHz to 2480 MHz
 *        Values:
 *        - 0x00 ... 0x27
 * @param Length_Of_Test_Data Length in bytes of payload data in each packet.
 *        Supported ranges:       - (0x00,0x25): BlueNRG-1 and BlueNRG-2 with
 *        BLE stack version < 2.1       - (0x00,0xFF): BlueNRG-2 with BLE stack
 *        version >= 2.1 and extended packet length.
 *        Values:
 *        - 0x00 ... 0xFF
 * @param Packet_Payload Content of the Payload of the test reference packets.
 *        0: PRBS9 sequence '11111111100000111101...' (in transmission order) 1:
 *        Repeated '11110000' (in transmission order) sequence 2: Repeated
 *        '10101010' (in transmission order) sequence 3: PRBS15 sequence 4:
 *        Repeated '11111111' (in transmission order) sequence 5: Repeated
 *        '00000000' (in transmission order) sequence 6: Repeated '00001111' (in
 *        transmission order) sequence 7: Repeated '01010101' (in transmission
 *        order) sequence
 *        Values:
 *        - 0x00: PRBS9
 *        - 0x01: Repeated '11110000'
 *        - 0x02: Repeated '10101010'
 *        - 0x03: PRBS15
 *        - 0x04: Repeated '11111111'
 *        - 0x05: Repeated '00000000'
 *        - 0x06: Repeated '00001111'
 *        - 0x07: Repeated '01010101'
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_transmitter_test(uint8_t TX_Frequency,
                                   uint8_t Length_Of_Test_Data,
                                   uint8_t Packet_Payload);
/**
 * @brief This command is used to stop any test which is in progress. The
 *        Number_Of_Packets for a transmitter test shall be reported as 0x0000.
 *        The Number_Of_Packets is an unsigned number and contains the number of
 *        received packets. (See Bluetooth Specification v.4.1, Vol. 2, Part E,
 *        7.8.30)
 * @param[out] Number_Of_Packets Number of packets received.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_test_end(uint16_t *Number_Of_Packets);
/**
 * @brief The LE_Set_Data_Length command allows the Host to suggest maximum
 *        transmission packet size and maximum packet transmission time
 *        (connMaxTxOctets and connMaxTxTime - see [Vol 6] Part B, Section
 *        4.5.10) to be used for a given connection. The Controller may use
 *        smaller or larger values based on local information.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param TxOctets Preferred maximum number of payload octets that the local
 *        Controller should include in a single Link Layer Data Channel PDU.
 *        Range 0x001B-0x00FB (0x0000 - 0x001A and 0x00FC - 0xFFFF) Reserved for
 *        future use). Default: 27 bytes.
 *        Values:
 *        - 0x001B ... 0x00FB
 * @param TxTime Preferred maximum number of microseconds that the local
 *        Controller should use to transmit a single Link Layer Data Channel
 *        PDU. Range 0x0148-0x0848 (0x0000 - 0x0147 and 0x0849 - 0xFFFF Reserved
 *        for future use). Default: 328 bytes.
 *        Values:
 *        - 0x0148 ... 0x0848
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_data_length(uint16_t Connection_Handle,
                                  uint16_t TxOctets,
                                  uint16_t TxTime);
/**
 * @brief The LE_Read_Suggested_Default_Data_Length command allows the Host to
 *        read the Host preferred values for the Controller maximum transmitted
 *        number of payload octets and maximum packet transmission time to be
 *        used for new connections (connInitialMaxTxOctets and
 *        connInitialMaxTxTime - see ([Vol 6] Part B, Section 4.5.10).
 * @param[out] SuggestedMaxTxOctets The Host suggested value for the Controller
 *             maximum transmitted number of payload octets to be used for new
 *             connections - connInitialMaxTxOctets. Range 0x001B-0x00FB (0x0000
 *             - 0x001A and 0x00FC - 0xFFFF Reserved for future use) Default:
 *             0x001B
 * @param[out] SuggestedMaxTxTime The Host suggested value for the Controller
 *             maximum packet transmission time to be used for new connections -
 *             connInitialMaxTx-Time. Range 0x0148-0x0848 (0x0000 - 0x0147 and
 *             0x0849 - 0xFFFF Reserved for future use) Default: 0x0148
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_read_suggested_default_data_length(uint16_t *SuggestedMaxTxOctets,
                                                     uint16_t *SuggestedMaxTxTime);
/**
 * @brief The LE_Write_Suggested_Default_Data_Length command allows the Host to
 *        specify its preferred values for the Controller maximum transmission
 *        number of payload octets and maximum packet transmission time to be
 *        used for new connections (connInitialMaxTxOctets and
 *        connInitialMaxTxTime - see [Vol 6] Part B, Section 4.5.10). The
 *        Controller may use smaller or larger values based on local
 *        information.
 * @param SuggestedMaxTxOctets The Host suggested value for the Controller
 *        maximum transmitted number of payload octets to be used for new
 *        connections - connInitialMaxTxOctets. Range 0x001B-0x00FB (0x0000 -
 *        0x001A and 0x00FC - 0xFFFF Reserved for future use)
 *        Values:
 *        - 0x001B ... 0x00FB
 * @param SuggestedMaxTxTime The Host suggested value for the Controller maximum
 *        packet transmission time to be used for new connections -
 *        connInitialMaxTx-Time. Range 0x0148-0x0848 (0x0000 - 0x0147 and 0x0849
 *        - 0xFFFF Reserved for future use)
 *        Values:
 *        - 0x0148 ... 0x0848
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_write_suggested_default_data_length(uint16_t SuggestedMaxTxOctets,
                                                      uint16_t SuggestedMaxTxTime);
/**
 * @brief The LE_Read_Local_P-256_Public_Key command is used to return the local
 *        P-256 public key from the Controller. The Controller shall generate a
 *        new P-256 public/private key pair upon receipt of this command. (See
 *        Bluetooth Specification v.4.2, Vol. 2, Part E, 7.8.36)
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_read_local_p256_public_key(void);
/**
 * @brief The LE_Generate_DHKey command is used to initiate generation of a
 *        Diffie- Hellman key in the Controller for use over the LE transport.
 *        This command takes the remote P-256 public key as input. The Diffie-
 *        Hellman key generation uses the private key generated by
 *        LE_Read_Local_P256_Public_Key command. (See Bluetooth Specification
 *        v.4.2, Vol. 2, Part E, 7.8.37)
 * @param Remote_P256_Public_Key The remote P-256 public key: X, Y format Octets
 *        31-0: X co-ordinate Octets 63-32: Y co-ordinate Little Endian Format
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_generate_dhkey(uint8_t Remote_P256_Public_Key[64]);
/**
 * @brief The LE_Add_Device_To_Resolving_List command is used to add one device
 *        to the list of address translations used to resolve Resolvable Private
 *        Addresses in the Controller. This command cannot be used when address
 *        translation is enabled in the Controller and: - Advertising is enabled
 *        - Scanning is enabled - Create connection command is outstanding This
 *        command can be used at any time when address translation is disabled
 *        in the Controller. When a Controller cannot add a device to the
 *        resolving list because the list is full, it shall respond with error
 *        code 0x07 (Memory Capacity Exceeded). (See Bluetooth Specification
 *        v.4.2, Vol. 2, Part E, 7.8.38)
 * @param Peer_Identity_Address_Type Identity address type.
 *        Values:
 *        - 0x00: Public Identity Address
 *        - 0x01: Random (static) Identity Address
 * @param Peer_Identity_Address Public or Random (static) Identity address of
 *        the peer device
 * @param Peer_IRK IRK of the peer device
 * @param Local_IRK IRK of the local device
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_add_device_to_resolving_list(uint8_t Peer_Identity_Address_Type,
                                               uint8_t Peer_Identity_Address[6],
                                               uint8_t Peer_IRK[16],
                                               uint8_t Local_IRK[16]);
/**
 * @brief The LE_Remove_Device_From_Resolving_List command is used to remove one
 *        device from the list of address translations used to resolve
 *        Resolvable Private Addresses in the controller. This command cannot be
 *        used when address translation is enabled in the Controller and: -
 *        Advertising is enabled - Scanning is enabled - Create connection
 *        command is outstanding This command can be used at any time when
 *        address translation is disabled in the Controller. When a Controller
 *        cannot remove a device from the resolving list because it is not
 *        found, it shall respond with error code 0x02 (Unknown Connection
 *        Identifier). (See Bluetooth Specification v.4.2, Vol. 2, Part E,
 *        7.8.39)
 * @param Peer_Identity_Address_Type Identity address type.
 *        Values:
 *        - 0x00: Public Identity Address
 *        - 0x01: Random (static) Identity Address
 * @param Peer_Identity_Address Public or Random (static) Identity address of
 *        the peer device
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_remove_device_from_resolving_list(uint8_t Peer_Identity_Address_Type,
                                                    uint8_t Peer_Identity_Address[6]);
/**
 * @brief The LE_Clear_Resolving_List command is used to remove all devices from
 *        the list of address translations used to resolve Resolvable Private
 *        Addresses in the Controller. This command cannot be used when address
 *        translation is enabled in the Controller and: - Advertising is enabled
 *        - Scanning is enabled - Create connection command is outstanding This
 *        command can be used at any time when address translation is disabled
 *        in the Controller. (See Bluetooth Specification v.4.2, Vol. 2, Part E,
 *        7.8.40)
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_clear_resolving_list(void);
/**
 * @brief The LE_Read_Resolving_List_Size command is used to read the total
 *        number of address translation entries in the resolving list that can
 *        be stored in the Controller. (See Bluetooth Specification v.4.2, Vol.
 *        2, Part E, 7.8.41)
 * @param[out] Resolving_List_Size Number of address translation entries in the
 *             resolving list
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_read_resolving_list_size(uint8_t *Resolving_List_Size);
/**
 * @brief The LE_Read_Peer_Resolvable_Address command is used to get the current
 *        peer Resolvable Private Address being used for the corresponding peer
 *        Public and Random (static) Identity Address. The peer's resolvable
 *        address being used may change after the command is called. This
 *        command can be used at any time. When a Controller cannot find a
 *        Resolvable Private Address associated with the Peer Identity Address,
 *        it shall respond with error code 0x02 (Unknown Connection Identifier).
 *        (See Bluetooth Specification v.4.2, Vol. 2, Part E, 7.8.42)
 * @param Peer_Identity_Address_Type Identity address type.
 *        Values:
 *        - 0x00: Public Identity Address
 *        - 0x01: Random (static) Identity Address
 * @param Peer_Identity_Address Public or Random (static) Identity address of
 *        the peer device
 * @param[out] Peer_Resolvable_Address Resolvable Private Address being used by
 *             the peer device
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_read_peer_resolvable_address(uint8_t Peer_Identity_Address_Type,
                                               uint8_t Peer_Identity_Address[6],
                                               uint8_t Peer_Resolvable_Address[6]);
/**
 * @brief The LE_Read_Local_Resolvable_Address command is used to get the
 *        current local Resolvable Private Address being used for the
 *        corresponding peer Identity Address. The local's resolvable address
 *        being used may change after the command is called. This command can be
 *        used at any time. When a Controller cannot find a Resolvable Private
 *        Address associated with the Peer Identity Address, it shall respond
 *        with error code 0x02 (Unknown Connection Identifier). (See Bluetooth
 *        Specification v.4.2, Vol. 2, Part E, 7.8.43)
 * @param Peer_Identity_Address_Type Identity address type.
 *        Values:
 *        - 0x00: Public Identity Address
 *        - 0x01: Random (static) Identity Address
 * @param Peer_Identity_Address Public or Random (static) Identity address of
 *        the peer device
 * @param[out] Local_Resolvable_Address Resolvable Private Address being used by
 *             the local device
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_read_local_resolvable_address(uint8_t Peer_Identity_Address_Type,
                                                uint8_t Peer_Identity_Address[6],
                                                uint8_t Local_Resolvable_Address[6]);
/**
 * @brief The LE_Set_Address_Resolution_Enable command is used to enable
 *        resolution of Resolvable Private Addresses in the Controller. This
 *        causes the Controller to use the resolving list whenever the
 *        Controller receives a local or peer Resolvable Private Address. This
 *        command can be used at any time except when: - Advertising is enabled
 *        - Scanning is enabled - Create connection command is outstanding (See
 *        Bluetooth Specification v.4.2, Vol. 2, Part E, 7.8.44)
 * @param Address_Resolution_Enable Enable/disable address resolution in the
 *        controller. 0x00: Address Resolution in controller disabled (default),
 *        0x01: Address Resolution in controller enabled
 *        Values:
 *        - 0x00: Address Resolution in controller disabled (default)
 *        - 0x01: Address Resolution in controller enabled
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_address_resolution_enable(uint8_t Address_Resolution_Enable);
/**
 * @brief The LE_Set_Resolvable_Private_Address_Timeout command set the length
 *        of time the controller uses a Resolvable Private Address before a new
 *        resolvable private address is generated and starts being used. This
 *        timeout applies to all addresses generated by the controller. (See
 *        Bluetooth Specification v.4.2, Vol. 2, Part E, 7.8.45)
 * @param RPA_Timeout RPA_Timeout measured in seconds. Range for N: 0x0001 -
 *        0xA1B8 (1 sec - approximately 11.5 hours) Default: N= 0x0384 (900 secs
 *        or 15 minutes)
 *        Values:
 *        - 0x0001 ... 0xA1B8
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_resolvable_private_address_timeout(uint16_t RPA_Timeout);
/**
 * @brief The LE_Read_Maximum_Data_Length command allows the Host to read the
 *        Controller  maximum supported payload octets and packet duration times
 *        for transmission and reception (supportedMaxTxOctets and
 *        supportedMaxTxTime, supportedMaxRxOctets, and supportedMaxRxTime, see
 *        [Vol 6] Part B, Section 4.5.10).
 * @param[out] supportedMaxTxOctets Maximum number of payload octets that the
 *             local Controller supports for transmission of a single Link Layer
 *             Data Channel PDU. Range 0x001B-0x00FB (0x0000 - 0x001A and 0x00FC
 *             - 0xFFFF Reserved for future use)
 * @param[out] supportedMaxTxTime Maximum time, in microseconds, that the local
 *             Controller supports for transmission of a single Link Layer Data
 *             Channel PDU. Range 0x0148-0x0848 (0x0000 - 0x0147 and 0x0849 -
 *             0xFFFF Reserved for future use)
 * @param[out] supportedMaxRxOctets Maximum number of payload octets that the
 *             local Controller supports for reception of a single Link Layer
 *             Data Channel PDU. Range 0x001B-0x00FB (0x0000 - 0x001A and 0x00FC
 *             - 0xFFFF Reserved for future use)
 * @param[out] supportedMaxRxTime Maximum time, in microseconds, that the local
 *             Controller supports for reception of a single Link Layer Data
 *             Channel PDU. Range 0x0148-0x0848 (0x0000 - 0x0147 and 0x0849 -
 *             0xFFFF Reserved for future use)
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_read_maximum_data_length(uint16_t *supportedMaxTxOctets,
                                           uint16_t *supportedMaxTxTime,
                                           uint16_t *supportedMaxRxOctets,
                                           uint16_t *supportedMaxRxTime);
/**
 * @brief The LE_Read_PHY command is used to read the current transmitter PHY
 *        and receiver PHY on the connection identified by the
 *        Connection_Handle.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param[out] TX_PHY Transmitter PHY for the connection 0x01: The transmitter
 *             PHY for the connection is LE 1M 0x02: The transmitter PHY for the
 *             connection is LE 2M 0x03: The transmitter PHY for the connection
 *             is LE Coded
 *             Values:
 *             - 0x01: LE_1M_PHY
 *             - 0x02: LE_2M_PHY
 *             - 0x03: LE_CODED_PHY
 * @param[out] RX_PHY Receiver PHY for the connection. 0x01: The receiver PHY
 *             for the connection is LE 1M 0x02: The receiver PHY for the
 *             connection is LE 2M 0x03: The receiver PHY for the connection is
 *             LE Coded All other values: Reserved for future use
 *             Values:
 *             - 0x01: The receiver PHY for the connection is LE 1M
 *             - 0x02: The receiver PHY for the connection is LE 2M
 *             - 0x03: The receiver PHY for the connection is LE Coded
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_read_phy(uint16_t Connection_Handle,
                           uint8_t *TX_PHY,
                           uint8_t *RX_PHY);
/**
 * @brief The LE_Set_Default_PHY command allows the Host to specify its
 *        preferred values for the transmitter PHY and receiver PHY to be used
 *        for all subsequent connections over the LE transport.
 * @param ALL_PHYS The ALL_PHYS parameter is a bit field that allows the Host to
 *        specify, for each direction, whether it has no preference among the
 *        PHYs that the Controller supports in a given direction or whether it
 *        has specified particular PHYs that it prefers in the TX_PHYS or
 *        RX_PHYS parameter. Bits: 0: The Host has no preference among the
 *        transmitter PHYs supported by the Controller 1: The Host has no
 *        preference among the receiver PHYs supported by the Controller
 *        Flags:
 *        - 0x01: No preference for TX
 *        - 0x02: No preference for RX
 * @param TX_PHYS The TX_PHYS parameter is a bit field that indicates the
 *        transmitter PHYs that the Host prefers the Controller to use. If the
 *        ALL_PHYS parameter specifies that the Host has no preference, the
 *        TX_PHYS parameter is ignored; otherwise at least one bit shall be set
 *        to 1. Bits: 0: The Host prefers to use the LE 1M transmitter PHY
 *        (possibly among others) 1: The Host prefers to use the LE 2M
 *        transmitter PHY (possibly among others) 2: The Host prefers to use the
 *        LE Coded transmitter PHY (possibly among others) 3-7: Reserved for
 *        future use
 *        Flags:
 *        - 0x01: LE_1M_PHY_BIT
 *        - 0x02: LE_2M_PHY_BIT
 *        - 0x04: LE_CODED_PHY_BIT
 * @param RX_PHYS The RX_PHYS parameter is a bit field that indicates the
 *        receiver PHYs that the Host prefers the Controller to use. If the
 *        ALL_PHYS parameter specifies that the Host has no preference, the
 *        RX_PHYS parameter is ignored; otherwise at least one bit shall be set
 *        to 1. Bits: 0: The Host prefers to use the LE 1M receiver PHY
 *        (possibly among others) 1: The Host prefers to use the LE 2M receiver
 *        PHY (possibly among others) 2: The Host prefers to use the LE Coded
 *        receiver PHY (possibly among others) 3-7: Reserved for future use
 *        Flags:
 *        - 0x01: LE_1M_PHY_BIT
 *        - 0x02: LE_2M_PHY_BIT
 *        - 0x04: LE_CODED_PHY_BIT
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_default_phy(uint8_t ALL_PHYS,
                                  uint8_t TX_PHYS,
                                  uint8_t RX_PHYS);
/**
 * @brief The LE_Set_PHY command is used to set the PHY preferences for the
 *        connection identified by the Connection_Handle. The Controller might
 *        not be able to make the change (e.g. because the peer does not support
 *        the requested PHY) or may decide that the current PHY is preferable.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param ALL_PHYS The ALL_PHYS parameter is a bit field that allows the Host to
 *        specify, for each direction, whether it has no preference among the
 *        PHYs that the Controller supports in a given direction or whether it
 *        has specified particular PHYs that it prefers in the TX_PHYS or
 *        RX_PHYS parameter. Bits: 0: The Host has no preference among the
 *        transmitter PHYs supported by the Controller 1: The Host has no
 *        preference among the receiver PHYs supported by the Controller
 *        Flags:
 *        - 0x01: No preference for TX
 *        - 0x02: No preference for RX
 * @param TX_PHYS The TX_PHYS parameter is a bit field that indicates the
 *        transmitter PHYs that the Host prefers the Controller to use. If the
 *        ALL_PHYS parameter specifies that the Host has no preference, the
 *        TX_PHYS parameter is ignored; otherwise at least one bit shall be set
 *        to 1. Bits: 0: The Host prefers to use the LE 1M transmitter PHY
 *        (possibly among others) 1: The Host prefers to use the LE 2M
 *        transmitter PHY (possibly among others) 2: The Host prefers to use the
 *        LE Coded transmitter PHY (possibly among others) 3-7: Reserved for
 *        future use
 *        Flags:
 *        - 0x01: LE_1M_PHY_BIT
 *        - 0x02: LE_2M_PHY_BIT
 *        - 0x04: LE_CODED_PHY_BIT
 * @param RX_PHYS The RX_PHYS parameter is a bit field that indicates the
 *        receiver PHYs that the Host prefers the Controller to use. If the
 *        ALL_PHYS parameter specifies that the Host has no preference, the
 *        RX_PHYS parameter is ignored; otherwise at least one bit shall be set
 *        to 1. Bits: 0: The Host prefers to use the LE 1M receiver PHY
 *        (possibly among others) 1: The Host prefers to use the LE 2M receiver
 *        PHY (possibly among others) 2: The Host prefers to use the LE Coded
 *        receiver PHY (possibly among others) 3-7: Reserved for future use
 *        Flags:
 *        - 0x01: LE_1M_PHY_BIT
 *        - 0x02: LE_2M_PHY_BIT
 *        - 0x04: LE_CODED_PHY_BIT
 * @param PHY_options The PHY_options parameter is a bit field that allows the
 *        Host to specify options for PHYs. The default value for a new
 *        connection shall be all zero bits. The Controller may override any
 *        preferred coding for transmitting on the LE Coded PHY. The Host may
 *        specify a preferred coding even if it prefers not to use the LE Coded
 *        transmitter PHY since the Controller may override the PHY preference.
 *        0 = the Host has no preferred coding when transmitting on the LE Coded
 *        PHY 1 = the Host prefers that S=2 coding be used when transmitting on
 *        the LE Coded PHY 2 = the Host prefers that S=8 coding be used when
 *        transmitting on the LE Coded PHY
 *        Values:
 *        - 0: No preferred LE Coded PHY
 *        - 1: S=2 preferred on LE Coded PHY
 *        - 2: S=8 preferred on LE Coded PHY
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_phy(uint16_t Connection_Handle,
                          uint8_t ALL_PHYS,
                          uint8_t TX_PHYS,
                          uint8_t RX_PHYS,
                          uint16_t PHY_options);
/**
 * @brief This command is used to start a test where the DUT receives test
 *        reference packets at a fixed interval. The tester generates the test
 *        reference packets.
 * @param RX_Channel Frequency Range : 2402 MHz to 2480 MHz N = (F - 2402) / 2.
 *        Values:
 *        - 0x00 ... 0x27: Frequency Range : 2402 MHz to 2480 MHz
 * @param PHY PHY to be used by the receiver.
 *        Values:
 *        - 0x01: LE_1M_PHY
 *        - 0x02: LE_2M_PHY
 *        - 0x03: LE_CODED_PHY
 * @param Modulation_index The Modulation_Index parameter specifies whether or
 *        not the Controller should assume the receiver has a stable modulation
 *        index.
 *        Values:
 *        - 0x00: Standard modulation index
 *        - 0x01: Stable modulation index
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_enhanced_receiver_test(uint8_t RX_Channel,
                                         uint8_t PHY,
                                         uint8_t Modulation_index);
/**
 * @brief This command is used to start a test where the DUT generates test
 *        reference packets at a fixed interval. The Controller shall transmit
 *        at maximum power. An LE Controller supporting the LE_Enhanced
 *        Transmitter_Test command shall support Packet_Payload values 0x00,
 *        0x01 and 0x02. An LE Controller supporting the LE Coded PHY shall also
 *        support Packet_Payload value 0x04. An LE Controller may support other
 *        values of Packet_Payload.
 * @param TX_Channel Frequency Range: 2402 MHz to 2480 MHz N = (F-2402) / 2
 *        Values:
 *        - 0x00 ... 0x27: Frequency Range: 2402 MHz to 2480 MHz
 * @param Length_Of_Test_Data
 *        Values:
 *        - 0x00 ... 0xFF: Length in bytes of payload data in each packet
 * @param Packet_Payload Content of the Payload of the test reference packets.
 *        0: PRBS9 sequence '11111111100000111101...' (in transmission order) 1:
 *        Repeated '11110000' (in transmission order) sequence 2: Repeated
 *        '10101010' (in transmission order) sequence 3: PRBS15 sequence 4:
 *        Repeated '11111111' (in transmission order) sequence 5: Repeated
 *        '00000000' (in transmission order) sequence 6: Repeated '00001111' (in
 *        transmission order) sequence 7: Repeated '01010101' (in transmission
 *        order) sequence
 *        Values:
 *        - 0x00: PRBS9
 *        - 0x01: Repeated '11110000'
 *        - 0x02: Repeated '10101010'
 *        - 0x03: PRBS15
 *        - 0x04: Repeated '11111111'
 *        - 0x05: Repeated '00000000'
 *        - 0x06: Repeated '00001111'
 *        - 0x07: Repeated '01010101'
 * @param PHY PHY to be used by the transmitter.
 *        Values:
 *        - 0x01: LE_1M_PHY
 *        - 0x02: LE_2M_PHY
 *        - 0x03: LE_CODED_PHY_S8
 *        - 0x04: LE_CODED_PHY_S2
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_enhanced_transmitter_test(uint8_t TX_Channel,
                                            uint8_t Length_Of_Test_Data,
                                            uint8_t Packet_Payload,
                                            uint8_t PHY);
/**
 * @brief The LE_Set_Advertising_Set_Random_Address command is used by the Host
 *        to set the random device address specified by the Random_Address
 *        parameter. This address is used in the Controller (see [Vol 6] Part B,
 *        Section 1.3.2) for the advertiser's address contained in the
 *        advertising PDUs for the advertising set specified by the
 *        Advertising_Handle parameter. If the Host issues this command while an
 *        advertising set using connectable advertising is enabled, the
 *        Controller shall return the error code Command Disallowed (0x0C). The
 *        Host may issue this command at any other time. If this command is used
 *        to change the address, the new random address shall take effect for
 *        advertising no later than the next successful LE Extended Set
 *        Advertising Enable Command and for periodic advertising no later than
 *        the next successful LE Periodic Advertising Enable Command.
 * @param Advertising_Handle It is used to identify an advertising set
 *        Values:
 *        - 0x00 ... 0xEF
 * @param Advertising_Random_Address Random Device Address as defined by [Vol 6]
 *        Part B, Section 1.3.2
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_advertising_set_random_address(uint8_t Advertising_Handle,
                                                     uint8_t Advertising_Random_Address[6]);
/**
 * @brief The LE_Set_Extended_Advertising_Parameters command is used by the Host
 *        to set the advertising parameters. The Advertising_Handle parameter
 *        identifies the advertising set whose parameters are being configured.
 *        The Advertising_Event_Properties parameter describes the type of
 *        advertising event that is being configured and its basic properties.
 *        The type shall be one supported by the Controller.
 * @param Advertising_Handle The Advertising_Handle parameter identifies the
 *        advertising set whose parameters are being configured.
 *        Values:
 *        - 0x00 ... 0xEF
 * @param Advertising_Event_Properties The Advertising_Event_Properties
 *        parameter describes the type of advertising event that is being
 *        configured and its basic properties. The type shall be one supported
 *        by the Controller. Bits: 0 Connectable advertising 1 Scannable
 *        advertising 2 Directed advertising 3 High Duty Cycle Directed
 *        Connectable advertising (<= 3.75 ms Advertising Interval) 4 Use legacy
 *        advertising PDUs 5 Omit advertiser's address from all PDUs ("anonymous
 *        advertising") 6 Include TxPower in the extended header of the
 *        advertising PDU
 *        Flags:
 *        - 0x0001: Connectable
 *        - 0x0002: Scannable
 *        - 0x0004: Directed
 *        - 0x0008: HDC Directed Connectable
 *        - 0x0010: Legacy
 *        - 0x0020: Anonymous
 *        - 0x0040: TxPower in ext header
 * @param Primary_Advertising_Interval_Min Minimum advertising interval for
 *        undirected and low duty cycle directed advertising. Time = N * 0.625
 *        ms; Time Range: 20 ms to 10,485.759375 s.
 *        Values:
 *        - 0x000020 (20.000 ms)  ... 0xFFFFFF (10485759.375 ms) 
 * @param Primary_Advertising_Interval_Max Maximum advertising interval for
 *        undirected and low duty cycle directed advertising. Time = N * 0.625
 *        ms; Time Range: 20 ms to 10,485.759375 s.
 *        Values:
 *        - 0x000020 (20.000 ms)  ... 0xFFFFFF (10485759.375 ms) 
 * @param Primary_Advertising_Channel_Map The Primary_Advertising_Channel_Map is
 *        a bit field that indicates the advertising channels that shall be used
 *        when transmitting advertising packets. At least one channel bit shall
 *        be set in the Primary_Advertising_Channel_Map parameter.
 *        Flags:
 *        - 0x01: CH_37
 *        - 0x02: CH_38
 *        - 0x04: CH_39
 * @param Own_Address_Type The Own_Address_Type parameter specifies the type of
 *        address being used in the advertising packets. For random addresses,
 *        the address is specified by the LE_Set_Advertising_Set_Random_Address
 *        command.  0x00 Public Device Address 0x01 Random Device Address 0x02
 *        Controller generates the Resolvable Private Address based on the local
 *        IRK from the resolving list. If the resolving list contains no
 *        matching entry, use the public address. 0x03 Controller generates the
 *        Resolvable Private Address based on the local IRK from the resolving
 *        list. If the resolving list contains no matching entry, use the random
 *        address from LE_Set_Advertising_Set_Random_Address. All other values
 *        Reserved for future use
 *        Values:
 *        - 0x00: Public Device Address
 *        - 0x01: Random Device Address
 *        - 0x02: Resolvable Private Address / Public Address
 *        - 0x03: Resolvable Private Address / Random Address
 * @param Peer_Address_Type Peer Address type
 *        Values:
 *        - 0x00: Public Device Address or Public Identity Address
 *        - 0x01: Random Device Address or Random (static) Identity Address
 * @param Peer_Address Public Device Address, Random Device Address, Public
 *        Identity Address, or Random (static) Identity Address of the device to
 *        be connected.
 * @param Advertising_Filter_Policy Advertising Filter Policy. This parameter is
 *        ignored when directed advertising is enabled.  0x00 Process scan and
 *        connection requests from all devices (i.e., the White List is not in
 *        use) 0x01 Process connection requests from all devices and scan
 *        requests only from devices that are in the White List 0x02 Process
 *        scan requests from all devices and connection requests only from
 *        devices that are in the White List. 0x03 Process scan and connection
 *        requests only from devices in the White List. All other values
 *        Reserved for future use
 *        Values:
 *        - 0x00: ADV_NO_WHITE_LIST_USE
 *        - 0x01: ADV_WHITE_LIST_FOR_ONLY_SCAN
 *        - 0x02: ADV_WHITE_LIST_FOR_ONLY_CONN
 *        - 0x03: ADV_WHITE_LIST_FOR_ALL
 * @param Advertising_Tx_Power Units: dBm  The Advertising_Tx_Power parameter
 *        indicates the maximum power level at which the advertising packets are
 *        to be transmitted on the advertising channels. The Controller shall
 *        choose a power level lower than or equal to the one specified by the
 *        Host.
 *        Values:
 *        - 127: No preference
 *        - -127 ... 126
 * @param Primary_Advertising_PHY The Primary_Advertising_PHY parameter
 *        indicates the PHY on which the advertising packets are transmitted on
 *        the primary advertising channel. If legacy advertising PDUs are being
 *        used, the Primary_Advertising_PHY shall indicate the LE 1M PHY.
 *        Values:
 *        - 0x01: LE_1M_PHY
 *        - 0x03: LE_CODED_PHY
 * @param Secondary_Advertising_Max_Skip The Secondary_Advertising_Max_Skip
 *        parameter is the maximum number of advertising events that can be
 *        skipped before the AUX_ADV_IND can be sent. 0x00 AUX_ADV_IND shall be
 *        sent prior to the next advertising event 0x01-0xFF Maximum advertising
 *        events the Controller can skip before sending the AUX_ADV_IND packets
 *        on the secondary advertising channel
 *        Values:
 *        - 0x00 ... 0xFF
 * @param Secondary_Advertising_PHY The Secondary_Advertising_PHY parameter
 *        indicates the PHY on which the advertising packets are transmitted on
 *        the secondary advertising channel.
 *        Values:
 *        - 0x01: LE_1M_PHY
 *        - 0x02: LE_2M_PHY
 *        - 0x03: LE_CODED_PHY
 * @param Advertising_SID The Advertising_SID parameter specifies the value to
 *        be transmitted in the Advertising SID subfield of the ADI field of the
 *        Extended Header of those advertising channel PDUs that have an ADI
 *        field. If the advertising set only uses PDUs that do not contain an
 *        ADI field, Advertising_SID is ignored.
 *        Values:
 *        - 0x00 ... 0x0F
 * @param Scan_Request_Notification_Enable The Scan_Request_Notification_Enable
 *        parameter indicates whether the Controller shall send notifications
 *        upon the receipt of a scan request PDU that is in response to an
 *        advertisement from the specified advertising set that contains its
 *        device address and is from a scanner that is allowed by the
 *        advertising filter policy.
 *        Values:
 *        - 0x00: Scan request notifications disabled
 *        - 0x01: Scan request notifications enabled
 * @param[out] Selected_Tx_Power Units: dBm. The Selected_Tx_Power return
 *             parameter indicates the transmit power selected by the
 *             Controller. The Controller shall not change the transmit power
 *             for this advertising set without being directed to by the Host.
 *             Values:
 *             - -127 ... 126
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_extended_advertising_parameters(uint8_t Advertising_Handle,
                                                      uint16_t Advertising_Event_Properties,
                                                      uint8_t Primary_Advertising_Interval_Min[3],
                                                      uint8_t Primary_Advertising_Interval_Max[3],
                                                      uint8_t Primary_Advertising_Channel_Map,
                                                      uint8_t Own_Address_Type,
                                                      uint8_t Peer_Address_Type,
                                                      uint8_t Peer_Address[6],
                                                      uint8_t Advertising_Filter_Policy,
                                                      int8_t Advertising_Tx_Power,
                                                      uint8_t Primary_Advertising_PHY,
                                                      uint8_t Secondary_Advertising_Max_Skip,
                                                      uint8_t Secondary_Advertising_PHY,
                                                      uint8_t Advertising_SID,
                                                      uint8_t Scan_Request_Notification_Enable,
                                                      int8_t *Selected_Tx_Power);
/**
 * @brief The LE_Set_Extended_Advertising_Data command is used to set the data
 *        used in advertising PDUs that have a data field. This command may be
 *        issued at any time after an advertising set identified by the
 *        Advertising_Handle parameter has been created using the LE Set
 *        Extended Advertising Parameters Command (see Section 7.8.53),
 *        regardless of whether advertising in that set is enabled or disabled.
 * @param Advertising_Handle It is used to identify an advertising set
 *        Values:
 *        - 0x00 ... 0xEF
 * @param Operation The Host may set the advertising data in one or more
 *        operations using this parameter. 0x00: Intermediate fragment of
 *        fragmented extended advertising data 0x01: First fragment of
 *        fragmented extended advertising data 0x02: Last fragment of fragmented
 *        extended advertising data 0x03: Complete extended advertising data
 *        0x04: Unchanged data (just update the Advertising DID) All other
 *        values: Reserved for future use
 *        Values:
 *        - 0x00: Intermediate fragment
 *        - 0x01: First fragment
 *        - 0x02: Last fragment
 *        - 0x03: Complete data
 *        - 0x04: Unchanged data
 * @param Fragment_Preference The Fragment_Preference parameter provides a hint
 *        to the Controller as to whether advertising data should be fragmented.
 *        Values:
 *        - 0x00: The Controller may fragment
 *        - 0x01: The Controller should not fragment or should minimize fragmentation
 * @param Advertising_Data_Length The number of octets in the Advertising Data
 *        parameter
 *        Values:
 *        - 0 ... 251
 * @param Advertising_Data Advertising data formatted as defined in [Vol 3] Part
 *        C, Section 11 Note: This parameter has a variable length.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_extended_advertising_data(uint8_t Advertising_Handle,
                                                uint8_t Operation,
                                                uint8_t Fragment_Preference,
                                                uint8_t Advertising_Data_Length,
                                                uint8_t Advertising_Data[]);
/**
 * @brief The LE_Set_Extended_Scan_Response_Data command is used to provide scan
 *        response data used in scanning response PDUs. This command may be
 *        issued at any time after the advertising set identified by the
 *        Advertising_Handle parameter has been created using the LE Set
 *        Extended Advertising Parameters Command (see Section 7.8.53)
 *        regardless of whether advertising in that set is enabled or disabled.
 * @param Advertising_Handle It is used to identify an advertising set
 *        Values:
 *        - 0x00 ... 0xEF: Used to identify an advertising set
 * @param Operation The Host may set the scan response data in one or more
 *        operations using the Operation parameter in the command. 0x00:
 *        Intermediate fragment of fragmented scan response data 0x01: First
 *        fragment of fragmented scan response data 0x02: Last fragment of
 *        fragmented scan response data 0x03: Complete scan response data All
 *        other values: Reserved for future use
 *        Values:
 *        - 0x00: Intermediate fragment
 *        - 0x01: First fragment
 *        - 0x02: Last fragment
 *        - 0x03: Complete data
 * @param Fragment_Preference The Fragment_Preference parameter provides a hint
 *        to the Controller as to whether advertising data should be fragmented.
 *        Values:
 *        - 0x00: The Controller may fragment all scan response data
 *        - 0x01: The Controller should not fragment or should minimize fragmentation of
scan response data
 * @param Scan_Response_Data_Length The number of octets in the Scan_Response
 *        Data parameter
 *        Values:
 *        - 0x00 ... 0xFB: The number of octets in the Scan_Response Data parameter
 * @param Scan_Response_Data Scan response data formatted as defined in [Vol 3]
 *        Part C, Section 11 Note: This parameter has a variable length.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_extended_scan_response_data(uint8_t Advertising_Handle,
                                                  uint8_t Operation,
                                                  uint8_t Fragment_Preference,
                                                  uint8_t Scan_Response_Data_Length,
                                                  uint8_t Scan_Response_Data[]);
/**
 * @brief The LE_Set_Extended_Advertising_Enable command is used to request the
 *        Controller to enable or disable one or more advertising sets using the
 *        advertising sets identified by the Advertising_Handle[i] parameter.
 *        The Controller manages the timing of advertisements in accordance with
 *        the advertising parameters given in the
 *        LE_Set_Extended_Advertising_Parameters command.
 * @param Enable It allows to enable or disable one or more advertising sets
 *        using the advertising sets identified by the Advertising_Handle[i]
 *        parameter.
 *        Values:
 *        - 0x00: Disable
 *        - 0x01: Enable
 * @param Number_of_Sets The Number_of_Sets parameter is the number of
 *        advertising sets contained in the parameter arrays.
 *        Values:
 *        - 0x00: Disable all advertising sets
 *        - 0x01 ... 0x3F: Number of advertising sets to enable or disable
 * @param Advertising_Set_Parameters See @ref Advertising_Set_Parameters_t
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_extended_advertising_enable(uint8_t Enable,
                                                  uint8_t Number_of_Sets,
                                                  Advertising_Set_Parameters_t Advertising_Set_Parameters[]);
/**
 * @brief The LE_Read_Maximum_Advertising_Data_Length command is used to read
 *        the maximum length of data supported by the Controller for use as
 *        advertisement data or scan response data in an advertising event or as
 *        periodic advertisement data. Note: The maximum amount may be
 *        fragmented across multiple PDUs (see [Vol 6] Part B, Section 2.3.4.9).
 * @param[out] Maximum_Advertising_Data_Length Maximum length of data supported
 *             by the Controller for use as advertisement data or scan response
 *             data in an advertising event or as periodic advertisement data.
 *             Values:
 *             - 0x001F ... 0x0672: Maximum supported advertising data length
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_read_maximum_advertising_data_length(uint16_t *Maximum_Advertising_Data_Length);
/**
 * @brief The LE_Read_Number_of_Supported_Advertising_Sets command is used to
 *        read the maximum number of advertising sets supported by the
 *        advertising Controller at the same time. Note: The number of
 *        advertising sets that can be supported is not fixed and the Controller
 *        can change it at any time because the memory used to store advertising
 *        sets can also be used for other purposes.
 * @param[out] Num_Supported_Advertising_Sets Maximum number of advertising sets
 *             supported by the advertising Controller at the same time.
 *             Values:
 *             - 0x01 ... 0xF0: Number of advertising sets supported at the same time
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_read_number_of_supported_advertising_sets(uint8_t *Num_Supported_Advertising_Sets);
/**
 * @brief The LE_Remove_Advertising_Set command is used to remove an advertising
 *        set from the Controller. If the advertising set corresponding to the
 *        Advertising_Handle parameter does not exist, then the Controller shall
 *        return the error code Unknown Advertising Identifier (0x42). If
 *        advertising on the advertising set is enabled, then the Controller
 *        shall return the error code Command Disallowed (0x0C).
 * @param Advertising_Handle It is used to identify an advertising set
 *        Values:
 *        - 0x00 ... 0xEF: Used to identify an advertising set
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_remove_advertising_set(uint8_t Advertising_Handle);
/**
 * @brief The LE_Clear_Advertising_Sets command is used to remove all existing
 *        advertising sets from the Controller. If advertising is enabled on any
 *        advertising set, then the Controller shall return the error code
 *        Command Disallowed (0x0C). Note: All advertising sets are cleared on
 *        HCI reset.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_clear_advertising_sets(void);
/**
 * @brief The LE_Set_Periodic_Advertising_Parameters command is used by the Host
 *        to set the parameters for periodic advertising. The Advertising_Handle
 *        parameter identifies the advertising set whose periodic advertising
 *        parameters are being configured. If the corresponding advertising set
 *        does not already exist, then the Controller shall return the error
 *        code Unknown Advertising Identifier (0x42). The
 *        Periodic_Advertising_Interval_Min parameter shall be less than or
 *        equal to the Periodic_Advertising_Interval_Max parameter. The
 *        Periodic_Advertising_Interval_Min and
 *        Periodic_Advertising_Interval_Max parameters should not be the same
 *        value to enable the Controller to determine the best advertising
 *        interval given other activities. The Periodic_Advertising_Properties
 *        parameter indicates which fields should be included in the advertising
 *        packet. If the advertising set identified by the Advertising_Handle
 *        specified anonymous advertising, the Controller shall return the error
 *        code Invalid HCI Parameters (0x12). If the Host issues this command
 *        when periodic advertising is enabled for the specified advertising
 *        set, the Controller shall return the error code Command Disallowed
 *        (0x0C). If the Advertising_Handle does not identify an advertising set
 *        that is already configured for periodic advertising and the Controller
 *        is unable to support more periodic advertising at present, the
 *        Controller shall return the error code Memory Capacity Exceeded (0x07)
 * @param Advertising_Handle It is used to identify an advertising set
 *        Values:
 *        - 0x00 ... 0xEF: Used to identify a periodic advertisement
 * @param Periodic_Advertising_Interval_Min Minimum advertising interval for
 *        periodic advertising. Time = N * 1.25 ms; Time Range: 7.5ms to
 *        81.91875 s.
 *        Values:
 *        - 0x0006 (7.50 ms)  ... 0xFFFF (NaN) : Minimum advertising interval for periodic advertising.
 * @param Periodic_Advertising_Interval_Max Maximum advertising interval for
 *        periodic advertising. Time = N * 1.25 ms; Time Range: 7.5ms to
 *        81.91875 s.
 *        Values:
 *        - 0x0006 (7.50 ms)  ... 0xFFFF (NaN) : Maximum advertising interval for periodic advertising.
 * @param Periodic_Advertising_Properties The Periodic_Advertising_Properties
 *        parameter indicates which fields should be included in the advertising
 *        packet.
 *        Flags:
 *        - 0x0040: Include TxPower in the advertising PDU
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_periodic_advertising_parameters(uint8_t Advertising_Handle,
                                                      uint16_t Periodic_Advertising_Interval_Min,
                                                      uint16_t Periodic_Advertising_Interval_Max,
                                                      uint16_t Periodic_Advertising_Properties);
/**
 * @brief The LE_Set_Periodic_Advertising_Data command is used to set the data
 *        used in periodic advertising PDUs. This command may be issued at any
 *        time after the advertising set identified by the Advertising_Handle
 *        parameter has been configured for periodic advertising using the
 *        LE_Set_Periodic_Advertising_Parameters Command (see Section 7.8.61),
 *        regardless of whether advertising in that set is enabled or disabled.
 *        If the advertising set has not been configured for periodic
 *        advertising, then the Controller shall return the error code Command
 *        Disallowed (0x0C). If advertising is currently enabled for the
 *        specified advertising set, the Controller shall use the new data in
 *        subsequent periodic advertising events for this advertising set. If a
 *        periodic advertising event is in progress when this command is issued,
 *        the Controller may use the old or new data for that event. If periodic
 *        advertising is currently disabled for the specified advertising set,
 *        the data shall be kept by the Controller and used once periodic
 *        advertising is enabled for that set. The data shall be discarded when
 *        the advertising set is removed. Only the significant part of the
 *        periodic advertising data should be transmitted in the advertising
 *        packets as defined in [Vol 3] Part C, Section 11. The Host may set the
 *        periodic advertising data in one or more operations using the
 *        Operation parameter in the command. If the combined length of the data
 *        exceeds the capacity of the advertising set identified by the
 *        Advertising_Handle parameter (see Section 7.8.57 LE Read Maximum
 *        Advertising Data Length Command) or the amount of memory currently
 *        available, all the data shall be discarded and the Controller shall
 *        return the error code Memory Capacity Exceeded (0x07). If Operation
 *        indicates the start of new data (values 0x01 or 0x03), then any
 *        existing partial or complete data shall be discarded. If the
 *        Advertising_Data_Length parameter is 0, then Operation shall be 0x03;
 *        this indicates that any existing partial or complete data shall be
 *        deleted and no new data provided.
 * @param Advertising_Handle It is used to identify an advertising set
 *        Values:
 *        - 0x00 ... 0xEF: Used to identify an advertising set
 * @param Operation The Host may set the periodic advertising data in one or
 *        more operations using the Operation parameter in the command.
 *        Values:
 *        - 0x00: Intermediate fragment of fragmented periodic advertising data
 *        - 0x01: First fragment of fragmented periodic advertising data
 *        - 0x02: Last fragment of fragmented periodic advertising data
 *        - 0x03: Complete periodic advertising data
 * @param Advertising_Data_Length The number of octets in the Advertising Data
 *        parameter
 *        Values:
 *        - 0 ... 252: The number of octets in the Advertising Data parameter
 * @param Advertising_Data Periodic advertising data formatted as defined in
 *        [Vol 3] Part C, Section 11. Note: This parameter has a variable
 *        length.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_periodic_advertising_data(uint8_t Advertising_Handle,
                                                uint8_t Operation,
                                                uint8_t Advertising_Data_Length,
                                                uint8_t Advertising_Data[]);
/**
 * @brief The LE_Set_Periodic_Advertising_Enable command is used to request the
 *        Controller to enable or disable the periodic advertising for the
 *        advertising set specified by the Advertising_Handle parameter
 *        (ordinary advertising is not affected). If the advertising set is not
 *        currently enabled (see the LE_Set_Extended_Advertising_Enable
 *        command), the periodic advertising is not started until the
 *        advertising set is enabled. Once the advertising set has been enabled,
 *        the Controller shall continue periodic advertising until the Host
 *        issues an LE_Set_Periodic_Advertising_Enable command with Enable set
 *        to 0x00 (periodic advertising is disabled). Disabling the advertising
 *        set has no effect on the periodic advertising once the advertising set
 *        has been enabled. The Controller manages the timing of advertisements
 *        in accordance with the advertising parameters given in the
 *        LE_Set_Periodic_Advertising_Parameters command. If the advertising set
 *        corresponding to the Advertising_Handle parameter does not exist, the
 *        Controller shall return the error code Unknown Advertising Identifier
 *        (0x42). If the periodic advertising data in the advertising set is not
 *        complete, the Controller shall return the error code Command
 *        Disallowed (0x0C). Note: Enabling periodic advertising when it is
 *        already enabled can cause the random address to change. Disabling
 *        periodic advertising when it is already disabled has no effect.
 * @param Enable It is used to request the Controller to enable or disable the
 *        periodic advertising for the advertising set specified by the
 *        Advertising_Handle parameter (ordinary advertising is not affected).
 *        Values:
 *        - 0x00: Periodic advertising is disabled (default)
 *        - 0x01: Periodic advertising is enabled
 * @param Advertising_Handle
 *        Values:
 *        - 0x00 ... 0xEF: Used to identify an advertising set
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_periodic_advertising_enable(uint8_t Enable,
                                                  uint8_t Advertising_Handle);
/**
 * @brief The LE_Set_Extended_Scan_Parameters command is used to set the
 *        extended scan parameters to be used on the advertising channels. The
 *        Scanning_PHYs parameter indicates the PHY(s) on which the advertising
 *        packets should be received on the primary advertising channel. The
 *        Host may enable one or more scanning PHYs. The Scan_Type[i],
 *        Scan_Interval[i], and Scan_Window[i] parameters array elements are
 *        ordered in the same order as the set bits in the Scanning_PHY
 *        parameter, starting from bit 0. The number of array elements is
 *        determined by the number of bits set in the Scanning_PHY parameter.
 *        The Scan_Type[i] parameter specifies the type of scan to perform. The
 *        Scan_Interval[i] and Scan_Window[i] parameters are recommendations
 *        from the Host on how long (Scan_Window[i]) and how frequently
 *        (Scan_Interval[i]) the Controller should scan (see [Vol 6] Part B,
 *        Section 4.5.3); however the frequency and length of the scan is
 *        implementation specific. If the requested scan cannot be supported by
 *        the implementation, the Controller shall return the error code Invalid
 *        HCI Command Parameters (0x12). The Own_Address_Type parameter
 *        indicates the type of address being used in the scan request packets.
 *        If the Host issues this command when scanning is enabled in the
 *        Controller, the Controller shall return the error code Command
 *        Disallowed (0x0C).
 * @param Own_Address_Type The Own_Address_Type parameter indicates the type of
 *        address being used in the scan request packets.
 *        Values:
 *        - 0x00: Public Device Address
 *        - 0x01: Random Device Address
 *        - 0x02: Controller generates the Resolvable Private Address based on the local
IRK from the resolving list. If the resolving list contains no matching
entry, then use the public address.
 *        - 0x03: Controller generates the Resolvable Private Address based on the local
IRK from the resolving list. If the resolving list contains no matching
entry, then use the random address from LE_Set_Random_Address.
 * @param Scanning_Filter_Policy 0x00 Accept all advertisement packets. Directed
 *        advertising packets which are not addressed for this device shall be
 *        ignored. 0x01 Ignore advertisement packets from devices not in the
 *        White List Only. Directed advertising packets which are not addressed
 *        for this device shall be ignored 0x02 Accept all undirected
 *        advertisement packets. Directed advertisement packets where initiator
 *        address is a RPA and  Directed advertisement packets addressed to this
 *        device shall be accepted. 0x03 Accept all undirected advertisement
 *        packets from devices that are in the White List.Directed advertisement
 *        packets where initiator address is RPA and Directed advertisement
 *        packets addressed to this device shall be accepted.
 *        Values:
 *        - 0x00: Accept all
 *        - 0x01: Ignore devices not in the White List
 *        - 0x02: Accept all (use resolving list)
 *        - 0x03: Ignore devices not in the White List (use resolving list)
 * @param Scanning_PHYs The Scanning_PHYs parameter indicates the PHY(s) on
 *        which the advertising packets should be received on the primary
 *        advertising channel. The Host may enable one or more scanning PHYs.
 *        Flags:
 *        - 0x01: LE_1M_PHY_BIT
 *        - 0x04: LE_CODED_PHY_BIT
 * @param Extended_Scan_Parameters See @ref Extended_Scan_Parameters_t
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_extended_scan_parameters(uint8_t Own_Address_Type,
                                               uint8_t Scanning_Filter_Policy,
                                               uint8_t Scanning_PHYs,
                                               Extended_Scan_Parameters_t Extended_Scan_Parameters[]);
/**
 * @brief The LE_Set_Extended_Scan_Enable command is used to enable or disable
 *        scanning. The Enable parameter determines whether scanning is enabled
 *        or disabled. If it is disabled, the remaining parameters are ignored.
 *        The Filter_Duplicates parameter controls whether the Link Layer should
 *        filter out duplicate advertising reports (filtering duplicates
 *        enabled) to the Host or if the Link Layer should generate advertising
 *        reports for each packet received (filtering duplicates disabled). See
 *        [Vol 6] Part B, Section 4.4.3.5. If the Filter_Duplicates parameter is
 *        set to 0x00, all advertisements received from advertisers shall be
 *        sent to the Host in advertising report events. If the
 *        Filter_Duplicates parameter is set to 0x01, duplicate advertisements
 *        should not be sent to the Host in advertising report events until
 *        scanning is disabled. If the Filter_Duplicates parameter is set to
 *        0x02, duplicate advertisements in a single scan period should not be
 *        sent to the Host in advertising report events; this setting shall only
 *        be used if Period is non-zero. If Filter_Duplicates is set to 0x2 and
 *        Period to zero, the Controller shall return the Invalid error code HCI
 *        Command Parameters (0x12). If the Duration parameter is zero or both
 *        the Duration parameter and Period parameter are non-zero, the
 *        Controller shall continue scanning until scanning is disabled by the
 *        Host issuing an LE_Set_Extended_Scan_Enable command with the Enable
 *        parameter set to 0x00 (Scanning is disabled). The Period parameter is
 *        ignored when the Duration parameter is zero. If the Duration parameter
 *        is non-zero and the Period parameter is zero, the Controller shall
 *        continue scanning until the duration specified in the Duration
 *        parameter has expired. If both the Duration and Period parameters are
 *        non-zero and the Duration parameter is greater than or equal to the
 *        Period parameter, the Controller shall return the error code Invalid
 *        HCI Command Parameters (0x12). When the Duration and Period parameters
 *        are non-zero, the Controller shall scan for the duration of the
 *        Duration parameter within a scan period specified by the Period
 *        parameter. After the scan period has expired, a new scan period shall
 *        begin and scanning shall begin again for the duration specified. The
 *        scan periods continue until the Host disables scanning. If the
 *        LE_Set_Extended_Scan_Enable command is sent while scanning is enabled,
 *        the timers used for duration and period are reset to the new parameter
 *        values and a new scan period is started. Any change to the
 *        Filter_Duplicates setting or the random address shall take effect.
 *        Note: Disabling scanning when it is disabled has no effect. Note: The
 *        duration of a scan period refers to the time spent scanning on both
 *        the primary and secondary advertising channels. However, expiry of the
 *        duration does not prevent the Link Layer from scanning for and
 *        receiving auxiliary packets of received advertisements. If the
 *        scanning parameters' Own_Address_Type parameter is set to 0x01 or 0x03
 *        and the random address for the device has not been initialized, the
 *        Controller shall return the error code Invalid HCI Command Parameters
 *        (0x12).
 * @param Enable The Enable parameter determines whether scanning is enabled or
 *        disabled. If it is disabled, the remaining parameters are ignored.
 *        Values:
 *        - 0x00: Scanning disabled
 *        - 0x01: Scanning enabled
 * @param Filter_Duplicates The Filter_Duplicates parameter controls whether the
 *        Link Layer should filter out duplicate advertising reports (filtering
 *        duplicates enabled) to the Host or if the Link Layer should generate
 *        advertising reports for each packet received (filtering duplicates
 *        disabled). See [Vol 6] Part B, Section 4.4.3.5.
 *        Values:
 *        - 0x00: Duplicate filtering disabled
 *        - 0x01: Duplicate filtering enabled
 *        - 0x02: Duplicate filtering enabled, reset for each scan period
 * @param Duration Scan duration. Time = N * 10 ms; Time Range: 10 ms to 655.35
 *        s.
 *        Values:
 *        - 0x0000 (0.000 ms) : Scan continuously until explicitly disable
 *        - 0x0001 (0.625 ms)  ... 0xFFFF (40959.375 ms) : Scan duration
 * @param Period Time interval from when the Controller started its last
 *        Scan_Duration until it begins the subsequent Scan_Duration. Time = N *
 *        1.28 sec; Time Range: 1.28 s to 83,884.8 s.
 *        Values:
 *        - 0x0000: Periodic scanning disabled
 *        - 0x0001 ... 0xFFFF: Time interval from when the Controller started its last Scan_Duration
until it begins the subsequent Scan_Duration
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_extended_scan_enable(uint8_t Enable,
                                           uint8_t Filter_Duplicates,
                                           uint16_t Duration,
                                           uint16_t Period);
/**
 * @brief The LE_Extended_Create_Connection command is used to create a Link
 *        Layer connection to a connectable advertiser.
 *        LE_Extended_Create_Connection command can be used in place of
 *        LE_Create_Connection command.
 * @param Initiating_Filter_Policy The Initiator_Filter_Policy parameter is used
 *        to determine whether the White List is used. If the White List is not
 *        used, the Peer_Address_Type and the Peer_Address parameters specify
 *        the address type and address of the advertising device to connect to.
 *        0x00 - White List is not used to determine which advertiser to connect
 *        to. Peer_Address_Type and Peer_Address shall be used. 0x01 - White
 *        List is used to determine which advertiser to connect to.
 *        Peer_Address_Type and Peer_Address shall be ignored.
 *        Values:
 *        - 0x00: WHITELIST_IS_NOT_USED
 *        - 0x01: WHITELIST_IS_USED
 * @param Own_Address_Type The Own_Address_Type parameter indicates the type of
 *        address being used in the connection request packets.
 *        Values:
 *        - 0x00: Public Device Address
 *        - 0x01: Random Device Address
 *        - 0x02: Controller generates the Resolvable Private Address based on the local
IRK from the resolving list. If the resolving list contains no matching
entry, then use the public address.
 *        - 0x03: Controller generates the Resolvable Private Address based on the local
IRK from the resolving list. If the resolving list contains no matching
entry, then use the random address from the most recent successful
LE_Set_Random_Address Command.
 * @param Peer_Address_Type The Peer_Address_Type parameter indicates the type
 *        of address used in the connectable advertisement sent by the peer.
 *        0x00: Public Device Address or Public Identity Address 0x01: Random
 *        Device Address or Random (static) Identity Address
 *        Values:
 *        - 0x00: Public Address
 *        - 0x01: Random Address
 * @param Peer_Address Public Device Address, Random Device Address, Public
 *        Identity Address, or Random (static) Identity Address of the device to
 *        be connected.
 * @param Initiating_PHYs The Initiating_PHYs parameter indicates the PHY(s) on
 *        which the advertising packets should be received on the primary
 *        advertising channel and the PHYs for which connection parameters have
 *        been specified. The Host may enable one or more initiating PHYs. 0x01:
 *        Scan connectable advertisements on the LE 1M PHY. Connection
 *        parameters for the LE 1M PHY are provided. 0x02: Connection parameters
 *        for the LE 2M PHY are provided 0x04: Scan connectable advertisements
 *        on the LE Coded PHY. Connection parameters for the LE Coded PHY are
 *        provided.
 *        Flags:
 *        - 0x01: LE_1M_PHY_BIT
 *        - 0x02: LE_2M_PHY_BIT
 *        - 0x04: LE_CODED_PHY_BIT
 * @param Extended_Create_Connection_Parameters See @ref
 *        Extended_Create_Connection_Parameters_t
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_extended_create_connection(uint8_t Initiating_Filter_Policy,
                                             uint8_t Own_Address_Type,
                                             uint8_t Peer_Address_Type,
                                             uint8_t Peer_Address[6],
                                             uint8_t Initiating_PHYs,
                                             Extended_Create_Connection_Parameters_t Extended_Create_Connection_Parameters[]);
/**
 * @brief The LE_Periodic_Advertising_Create_Sync command is used to synchronize
 *        with periodic advertising from an advertiser and begin receiving
 *        periodic advertising packets. This command may be issued whether or
 *        not scanning is enabled and scanning may be enabled and disabled (see
 *        the LE Set Extended Scan Enable Command) while this command is
 *        pending. However, synchronization can only occur when scanning is
 *        enabled. While scanning is disabled, no attempt to synchronize will
 *        take place. The Filter_Policy parameter is used to determine whether
 *        the Periodic Advertiser List is used. If the Periodic Advertiser List
 *        is not used, the Advertising_SID, Advertiser Address_Type, and
 *        Advertiser Address parameters specify the periodic advertising device
 *        to listen to; otherwise they are ignored. The Advertising_SID
 *        parameter, if used, specifies the value that must match the
 *        Advertising SID subfield in the ADI field of the received
 *        advertisement for it to be used to synchronize. The Skip parameter
 *        specifies the number of consecutive periodic advertising packets that
 *        the receiver may skip after successfully receiving a periodic
 *        advertising packet. The Sync_Timeout parameter specifies the maximum
 *        permitted time between successful receives. If this time is exceeded,
 *        synchronization is lost. The Unused parameter is reserved for future
 *        use. Irrespective of the value of the Skip parameter, the Controller
 *        should stop skipping packets before the Sync_Timeout would be
 *        exceeded. If the Host issues this command when another
 *        LE_Periodic_Advertising_Create_Sync command is pending (see page
 *        1380), the Controller shall return the error code Command Disallowed
 *        (0x0C). If the Host issues this command for a periodic advertising set
 *        from an advertiser that the Controller is already synchronized to, the
 *        Controller shall return the error code Connection Already Exists
 *        (0x0B).
 * @param Options The Options parameter is used to determine whether the
 *        Periodic Advertiser List is used and whether
 *        HCI_Periodic_Advertising_Report events for this periodic advertising
 *        train are initially enabled or disabled. If the Periodic Advertiser
 *        List is not used, the Advertising_SID, Advertiser Address_Type, and
 *        Advertiser Address parameters specify the periodic advertising device
 *        to listen to; otherwise they shall be ignored.
 *        Flags:
 *        - 0x01: ): Use the Advertising_SID, Advertising_Address_Type, and Advertising_
Address parameters to determine which advertiser to listen to. 1:Use the Periodic Advertiser List to determine which advertiser to listen
to.
 *        - 0x02: 0: Reporting initially enabled. 1: Reporting initially disabled.
 * @param Advertising_SID The Advertising_SID parameter, if used, specifies the
 *        value that must match the Advertising SID subfield in the ADI field of
 *        the received advertisement for it to be used to synchronize.
 *        Values:
 *        - 0x00 ... 0x0F: Advertising SID subfield in the ADI field used to identify the Periodic
Advertising
 * @param Advertising_Address_Type Advertising address type
 *        Values:
 *        - 0x00: Public Device Address
 *        - 0x01: Random Device Address
 * @param Advertiser_Address Public Device Address, Random Device Address,
 *        Public Identity Address, or Random (static) Identity Address of the
 *        advertiser
 * @param Skip The Skip parameter specifies the number of consecutive periodic
 *        advertising packets that the receiver may skip after successfully
 *        receiving a periodic advertising packet.
 *        Values:
 *        - 0x0000 ... 0x01F3: The number of periodic advertising packets that can be skipped after a
successful receive
 * @param Sync_Timeout The Skip parameter specifies the number of consecutive
 *        periodic advertising packets that the receiver may skip after
 *        successfully receiving a periodic advertising packet. Time = N*10 ms;
 *        Time Range: 100 ms to 163.84 s.
 *        Values:
 *        - 0x000A (100 ms)  ... 0x4000 (163840 ms) : Synchronization timeout for the periodic advertising
 * @param Sync_CTE_Type The Sync_CTE_Type parameter specifies whether to only
 *        synchronize to periodic advertising with certain types of Constant
 *        Tone Extension (a value of 0 indicates that the presence or absence of
 *        a Constant Tone Extension is irrelevant). If the periodic advertising
 *        has the wrong type of Constant Tone Extension then: - If bit 0 of
 *        Options is set, the Controller shall ignore this address and SID and
 *        continue to search for other periodic advertisements. - Otherwise, the
 *        Controller shall cancel the synchronization with the error code
 *        Unsupported Remote Feature/Unsupported LMP Feature (0x1A).
 *        Flags:
 *        - 0x01: Do not sync to packets with an AoA Constant Tone Extension
 *        - 0x02: Do not sync to packets with an AoD Constant Tone Extension with 1 microsecond
slots
 *        - 0x04: Do not sync to packets with an AoD Constant Tone Extension with 2 microseconds
slots
 *        - 0x08: Do not sync to packets with a type 3 Constant Tone Extension (currently
reserved for future use)
 *        - 0x10: Do not sync to packets without a Constant Tone Extension
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_periodic_advertising_create_sync(uint8_t Options,
                                                   uint8_t Advertising_SID,
                                                   uint8_t Advertising_Address_Type,
                                                   uint8_t Advertiser_Address[6],
                                                   uint16_t Skip,
                                                   uint16_t Sync_Timeout,
                                                   uint8_t Sync_CTE_Type);
/**
 * @brief The LE_Periodic_Advertising_Create_Sync_Cancel command is used to
 *        cancel the LE_Periodic_Advertising_Create_Sync command while it is
 *        pending. If the Host issues this command while no
 *        LE_Periodic_Advertising_Create_Sync command is pending, the Controller
 *        shall return the error code Command Disallowed (0x0C).
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_periodic_advertising_create_sync_cancel(void);
/**
 * @brief The LE_Periodic_Advertising_Terminate_Sync command is used to stop
 *        reception of the periodic advertising identified by the Sync_Handle
 *        parameter. If the Host issues this command when another
 *        LE_Periodic_Advertising_Create_Sync command is pending (see below),
 *        the Controller shall return the error code Command Disallowed (0x0C).
 *        If the periodic advertising corresponding to the Sync_Handle parameter
 *        does not exist, then the Controller shall return the error code
 *        Unknown Advertising Identifier (0x42).
 * @param Sync_Handle It is used to identify the periodic advertiser
 *        Values:
 *        - 0x0000 ... 0x0EFF: Sync_Handle to be used to identify the periodic advertiser
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_periodic_advertising_terminate_sync(uint16_t Sync_Handle);
/**
 * @brief The LE_Add_Device_To_Periodic_Advertiser_List command is used to add a
 *        single device to the Periodic Advertiser list stored in the
 *        Controller. Any additions to the Periodic Advertiser list take effect
 *        immediately. If the device is already on the list, the Controller
 *        shall return the error code Invalid HCI Command Parameters (0x12). If
 *        the Host issues this command when an
 *        LE_Periodic_Advertising_Create_Sync command is pending, the Controller
 *        shall return the error code Command Disallowed (0x0C). When a
 *        Controller cannot add a device to the Periodic Advertiser list because
 *        the list is full, the Controller shall return the error code Memory
 *        Capacity Exceeded (0x07).
 * @param Advertiser_Address_Type Advertiser Address Type
 *        Values:
 *        - 0x00: Public Device Address or Public Identity Address
 *        - 0x01: Random Device Address or Random (static) Identity Address
 * @param Advertiser_Address Public Device Address, Random Device Address,
 *        Public Identity Address, or Random (static) Identity Address of the
 *        advertiser
 * @param Advertising_SID Advertising SID subfield in the ADI field used to
 *        identify the Periodic Advertising
 *        Values:
 *        - 0x00 ... 0x0F: Advertising SID subfield in the ADI field used to identify the Periodic
Advertising
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_add_device_to_periodic_advertiser_list(uint8_t Advertiser_Address_Type,
                                                         uint8_t Advertiser_Address[6],
                                                         uint8_t Advertising_SID);
/**
 * @brief The LE_Remove_Device_From_Periodic_Advertiser_List command is used to
 *        remove one device from the list of Periodic Advertisers stored in the
 *        Controller. Removals from the Periodic Advertisers List take effect
 *        immediately. If the Host issues this command when an
 *        LE_Periodic_Advertising_Create_Sync command is pending, the Controller
 *        shall return the error code Command Disallowed (0x0C). When a
 *        Controller cannot remove a device from the Periodic Advertiser list
 *        because it is not found, the Controller shall return the error code
 *        Unknown Advertising Identifier (0x42).
 * @param Advertiser_Address_Type Advertising Address type
 *        Values:
 *        - 0x00: Public Device Address or Public Identity Address
 *        - 0x01: Random Device Address or Random (static) Identity Address
 * @param Advertiser_Address Public Device Address, Random Device Address,
 *        Public Identity Address, or Random (static) Identity Address of the
 *        advertiser
 * @param Advertising_SID It is used to  identify the Periodic Advertising
 *        Values:
 *        - 0x00 ... 0x0F: Advertising SID subfield in the ADI field used to identify the Periodic
Advertising
All other values Reserved for future
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_remove_device_from_periodic_advertising_list(uint8_t Advertiser_Address_Type,
                                                               uint8_t Advertiser_Address[6],
                                                               uint8_t Advertising_SID);
/**
 * @brief The LE_Clear_Periodic_Advertiser_List command is used to remove all
 *        devices from the list of Periodic Advertisers in the Controller. If
 *        this command is used when an LE_Periodic_Advertising_Create_Sync
 *        command is pending, the Controller shall return the error code Command
 *        Disallowed (0x0C).
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_clear_periodic_advertiser_list(void);
/**
 * @brief The LE_Read_Periodic_Advertiser_List_Size command is used to read the
 *        total number of Periodic Advertiser list entries that can be stored in
 *        the Controller. Note: The number of entries that can be stored is not
 *        fixed and the Controller can change it at any time (e.g., because the
 *        memory used to store the list can also be used for other purposes).
 * @param[out] Periodic_Advertiser_List_Size Total number of Periodic Advertiser
 *             list entries that can be stored in the Controller
 *             Values:
 *             - 0x1F ... 0xFF: Total number of Periodic Advertiser list entries that can be stored in the
Controller
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_read_periodic_advertiser_list_size(uint8_t *Periodic_Advertiser_List_Size);
/**
 * @brief The HCI_LE_Read_Transmit_Power command is used to read the minimum and
 *        maximum transmit powers supported by the Controller.
 * @param[out] Min_Tx_Power Minimum supported TX power (units: dBm).
 *             Values:
 *             - -127 ... 20
 * @param[out] Max_Tx_Power Maximum supported TX power (units: dBm).
 *             Values:
 *             - -127 ... 20
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_read_transmit_power(int8_t *Min_Tx_Power,
                                      int8_t *Max_Tx_Power);
/**
 * @brief The HCI_LE_Read_RF_Path_Compensation command is used to read the RF
 *        Path Compensation Values parameter used in the Tx Power Level and RSSI
 *        calculation.
 * @param[out] RF_TX_Path_Compensation_Value
 * @param[out] RF_RX_Path_Compensation_Value
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_read_rf_path_compensation(int16_t *RF_TX_Path_Compensation_Value,
                                            int16_t *RF_RX_Path_Compensation_Value);
/**
 * @brief The HCI_LE_Write_RF_Path_Compensation command is used to indicate the
 *        RF path gain or loss between the RF transceiver and the antenna
 *        contributed by intermediate components. A positive value means a net
 *        RF path gain and a negative value means a net RF path loss. The RF Tx
 *        Path Compensation Value parameter shall be used by the Controller to
 *        calculate radiative Tx Power Level used in HCI commands, HCI events,
 *        Advertising physical channel PDUs, and Link Layer Control PDUs using
 *        the following equation: Radiative Tx Power Level = Tx Power Level at
 *        RF transceiver output + RF Tx Path Compensation Value. For example, if
 *        the Tx Power Level is +4 (dBm) at RF transceiver output and the RF
 *        Path Compensation Value is -1.5 (dB), the radiative Tx Power Level is
 *        +4+(-1.5) = 2.5 (dBm). The RF Rx Path Compensation Value parameter
 *        shall be used by the Controller to calculate the RSSI value reported
 *        to the Host.
 * @param RF_TX_Path_Compensation_Value
 * @param RF_RX_Path_Compensation_Value
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_write_rf_path_compensation(int16_t RF_TX_Path_Compensation_Value,
                                             int16_t RF_RX_Path_Compensation_Value);
/**
 * @brief The HCI_LE_Set_Privacy_Mode command is used to allow the Host to
 *        specify the privacy mode to be used for a given entry on the resolving
 *        list. The effect of this setting is specified in [Vol 6] Part B,
 *        Section 4.7. When an entry on the resolving list is removed, the mode
 *        associated with that entry shall also be removed. This command cannot
 *        be used when address translation is enabled in the Controller and:
 *        Advertising is enabled Scanning is enabled Create connection command
 *        is outstanding This command can be used at any time when address
 *        translation is disabled in the Controller. If the device is not on the
 *        resolving list, the Controller shall return the error code Unknown
 *        Connection Identifier (0x02).
 * @param Peer_Identity_Address_Type Peer Address type
 *        Values:
 *        - 0x00: Public Identity Address
 *        - 0x01: Random (static) Identity Address
 * @param Peer_Identity_Address Public Identity Address or Random (static)
 *        Identity Address of the advertiser
 * @param Privacy_Mode 0x00 Use Network Privacy Mode for this peer device
 *        (default) 0x01 Use Device Privacy Mode for this peer device
 *        Values:
 *        - 0x00: Network Privacy Mode
 *        - 0x01: Device Privacy Mode
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_privacy_mode(uint8_t Peer_Identity_Address_Type,
                                   uint8_t Peer_Identity_Address[6],
                                   uint8_t Privacy_Mode);
/**
 * @brief This command is used to start a test where the DUT receives test
 *        reference packets at a fixed interval. The tester generates the test
 *        reference packets. The RX_Channel and PHY parameters specify the RF
 *        channel and PHY to be used by the receiver. If the Host sets the PHY
 *        parameter to a PHY that the Controller does not support, including a
 *        value that is reserved for future use, the Controller shall return the
 *        error code Unsupported Feature or Parameter Value (0x11). The
 *        Modulation_Index parameter specifies whether or not the Controller
 *        should assume the receiver has a stable modulation index. The
 *        Expected_CTE_Length and Expected_CTE_Type parameters specify the
 *        expected length and type of the Constant Tone Extensions in received
 *        test reference packets. When receiving on a PHY that allows Constant
 *        Tone Extensions, if the Constant Tone Extension in a received test
 *        reference packet does not match both of these, the DUT shall discard
 *        that packet. If Expected_CTE_Length is not zero and PHY specifies a
 *        PHY that does not allow Constant Tone Extensions, the Controller shall
 *        return the error code Command Disallowed (0x0C). If the Slot_Durations
 *        parameter is set to 0x01 and the Controller does not support 1
 *        microsecond switching and sampling, the Controller shall return the
 *        error code Unsupported Feature or Parameter Value (0x11).
 *        Slot_Durations, Switching_Pattern_Length, and Antenna_IDs[i] are only
 *        used when expecting an AoA Constant Tone Extension and shall be
 *        ignored when expecting an AoD Constant Tone Extension. If the
 *        Controller determines that any of the Antenna_IDs[i] values do not
 *        identify an antenna in the device's antenna array, it shall return the
 *        error code Unsupported Feature or Parameter Value (0x11). Note: Some
 *        Controllers may be unable to determine which values do or do not
 *        identify an antenna.
 * @param RX_Channel
 *        Values:
 *        - 0x00 ... 0x27: N = (F - 2402) / 2.Frequency Range : 2402 MHz to 2480 MHz
 * @param PHY PHY to be used by the receiver.
 *        Values:
 *        - 0x01: LE_1M_PHY
 *        - 0x02: LE_2M_PHY
 *        - 0x03: LE_CODED_PHY
 * @param Modulation_Index
 *        Values:
 *        - 0x00: Assume transmitter will have a standard modulation index
 *        - 0x01: Assume transmitter will have a stable modulation index
 * @param Expected_CTE_Length
 *        Values:
 *        - 0x00: No Constant Tone Extension expected (default)
 *        - 0x02 ... 0x14: Expected length of the Constant Tone Extension in 8 microseconds units.
 * @param Expected_CTE_Type
 *        Values:
 *        - 0x00: Expect AoA Constant Tone Extension
 *        - 0x01: Expect AoD Constant Tone Extension with 1 microsecond slots
 *        - 0x02: Expect AoD Constant Tone Extension with 2 microseconds slots
 * @param Slot_Durations Sampling rate used by the Controller.
 *        Values:
 *        - 0x01: SLOT_1us
 *        - 0x02: SLOT_2us
 * @param Switching_Pattern_Length
 *        Values:
 *        - 0x02 ... 0x4B: The number of Antenna IDs in the pattern.
 * @param Antenna_IDs List of Antenna IDs in the pattern
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_receiver_test_v3(uint8_t RX_Channel,
                                   uint8_t PHY,
                                   uint8_t Modulation_Index,
                                   uint8_t Expected_CTE_Length,
                                   uint8_t Expected_CTE_Type,
                                   uint8_t Slot_Durations,
                                   uint8_t Switching_Pattern_Length,
                                   uint8_t Antenna_IDs[]);
/**
 * @brief This command is used to start a test where the DUT generates test
 *        reference packets at a fixed interval. The Controller shall transmit
 *        at the power level indicated by the Transmit_Power_Level parameter.
 *        The TX_Channel and PHY parameters specify the RF channel and PHY to be
 *        used by the transmitter. If the Host sets the PHY parameter to a PHY
 *        that the Controller does not support, including a value that is
 *        reserved for future use, the Controller shall return the error code
 *        Unsupported Feature or Parameter Value (0x11). The Test_Data_Length
 *        and Packet_Payload parameters specify the length and contents of the
 *        Payload of the test reference packets. An LE Controller supporting the
 *        HCI_LE_Transmitter_Test command shall support Packet_Payload values
 *        0x00, 0x01 and 0x02. An LE Controller supporting the LE Coded PHY
 *        shall also support Packet_Payload value 0x04. An LE Controller may
 *        support other values of Packet_Payload. The CTE_Length and CTE_Type
 *        parameters specify the length and type of the Constant Tone Extension
 *        in the test reference packets. If the CTE_Type parameter is set to
 *        0x01 and the Controller does not support 1 microsecond switching, the
 *        Controller shall return the error code Unsupported Feature or
 *        Parameter Value (0x11). If CTE_Length is not zero and PHY specifies a
 *        PHY that does not allow Constant Tone Extensions, the Controller shall
 *        return the error code Command Disallowed (0x0C). The
 *        Switching_Pattern_Length and Antenna_IDs[i] parameters specify the
 *        antenna switching pattern. They are only used when transmitting an AoD
 *        Constant Tone Extension and shall be ignored when transmitting an AoA
 *        Constant Tone Extension. If the Controller determines that any of the
 *        Antenna_IDs[i] values do not identify an antenna in the device's
 *        antenna array, it shall return the error code Unsupported Feature or
 *        Parameter Value (0x11). Note: Some Controllers may be unable to
 *        determine which values do or do not identify an antenna. The
 *        Transmit_Power_Level parameter specifies the transmit power level to
 *        be used by the transmitter. If the parameter is set to a value other
 *        than 0x7E or 0x7F, then the Controller shall make the requested change
 *        or shall make the nearest change that it is capable of doing.
 * @param TX_Channel N = (F - 2402) / 2
 *        Frequency Range : 2402 MHz to 2480 MHz
 *        Values:
 *        - 0x00 ... 0x27
 * @param Test_Data_Length Length in bytes of payload data in each packet
 * @param Packet_Payload Content of the Payload of the test reference packets.
 *        0: PRBS9 sequence '11111111100000111101...' (in transmission order) 1:
 *        Repeated '11110000' (in transmission order) sequence 2: Repeated
 *        '10101010' (in transmission order) sequence 3: PRBS15 sequence 4:
 *        Repeated '11111111' (in transmission order) sequence 5: Repeated
 *        '00000000' (in transmission order) sequence 6: Repeated '00001111' (in
 *        transmission order) sequence 7: Repeated '01010101' (in transmission
 *        order) sequence
 *        Values:
 *        - 0x00: PRBS9
 *        - 0x01: Repeated '11110000'
 *        - 0x02: Repeated '10101010'
 *        - 0x03: PRBS15
 *        - 0x04: Repeated '11111111'
 *        - 0x05: Repeated '00000000'
 *        - 0x06: Repeated '00001111'
 *        - 0x07: Repeated '01010101'
 * @param PHY PHY to be used by the transmitter.
 *        Values:
 *        - 0x01: LE_1M_PHY
 *        - 0x02: LE_2M_PHY
 *        - 0x03: LE_CODED_PHY_S8
 *        - 0x04: LE_CODED_PHY_S2
 * @param CTE_Length
 *        Values:
 *        - 0x00: No Constant Tone Extension expected (default)
 *        - 0x02 ... 0x14: Expected length of the Constant Tone Extension in 8 microseconds units.
 * @param CTE_Type
 *        Values:
 *        - 0x00: Expect AoA Constant Tone Extension
 *        - 0x01: Expect AoD Constant Tone Extension with 1 microsecond slots
 *        - 0x02: Expect AoD Constant Tone Extension with 2 microseconds slots
 * @param Switching_Pattern_Length
 *        Values:
 *        - 0x02 ... 0x4B: The number of Antenna IDs in the pattern.
 * @param Antenna_IDs List of Antenna IDs in the pattern
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_transmitter_test_v3(uint8_t TX_Channel,
                                      uint8_t Test_Data_Length,
                                      uint8_t Packet_Payload,
                                      uint8_t PHY,
                                      uint8_t CTE_Length,
                                      uint8_t CTE_Type,
                                      uint8_t Switching_Pattern_Length,
                                      uint8_t Antenna_IDs[]);
/**
 * @brief The HCI_LE_Set_Connectionless_CTE_Transmit_Parameters command is used
 *        to set the type, length, and antenna switching pattern for the
 *        transmission of Constant Tone Extensions in any periodic advertising
 *        on the advertising set identified by the Advertising_Handle parameter.
 *        The CTE_Count parameter specifies how many packets with a Constant
 *        Tone Extension are to be transmitted in each periodic advertising
 *        event. If the number of packets that would otherwise be transmitted is
 *        less than this, the Controller shall transmit sufficient AUX_CHAIN_IND
 *        PDUs with no AdvData to make up the number. However, if a change in
 *        circumstances since this command was issued means that the Controller
 *        can no longer schedule all of these packets, it should transmit as
 *        many as possible. If the Host issues this command when Constant Tone
 *        Extensions have been enabled in the advertising set, the Controller
 *        shall return the error code Command Disallowed (0x0C). The
 *        Switching_Pattern_Length and Antenna_IDs[i] parameters are only used
 *        when transmitting an AoD Constant Tone Extension and shall be ignored
 *        if CTE_Type specifies an AoA Constant Tone Extension. If the
 *        CTE_Length parameter is greater than the maximum length of Constant
 *        Tone Extension supported, the Controller shall return the error code
 *        Unsupported Feature or Parameter Value (0x11). If the Host requests a
 *        type of Constant Tone Extension that the Controller does not support,
 *        the Controller shall return the error code Unsupported Feature or
 *        Parameter Value (0x11). If the Controller is unable to schedule
 *        CTE_Count packets in each event, the Controller shall return the error
 *        code Unsupported Feature or Parameter Value (0x11). If the advertising
 *        set corresponding to the Advertising_Handle parameter does not exist,
 *        the Controller shall return the error code Unknown Advertising
 *        Identifier (0x42). If Switching_Pattern_Length is greater than the
 *        maximum length of switching pattern supported by the Controller (see
 *        Section 7.8.87), the Controller shall return the error code
 *        Unsupported Feature or Parameter Value (0x11). If the Controller
 *        determines that any of the Antenna_IDs[i] values do not identify an
 *        antenna in the device's antenna array, it shall return the error code
 *        Unsupported Feature or Parameter Value (0x11). Note: Some Controllers
 *        may be unable to determine which values do or do not identify an
 *        antenna.
 * @param Advertising_Handle It is used to identify an advertising set
 *        Values:
 *        - 0x00 ... 0xEF
 * @param CTE_Length
 *        Values:
 *        - 0x02 ... 0x14: Constant Tone Extension length in 8 microseconds units
 * @param CTE_Type
 *        Values:
 *        - 0x00: AoA Constant Tone Extension
 *        - 0x01: AoD Constant Tone Extension with 1 microsecond slots
 *        - 0x02: AoD Constant Tone Extension with 2 microseconds slots
 * @param CTE_Count The CTE_Count parameter specifies how many packets with a
 *        Constant Tone Extension are to be transmitted in each periodic
 *        advertising event. If the number of packets that would otherwise be
 *        transmitted is less than this, the Controller shall transmit
 *        sufficient AUX_CHAIN_IND PDUs with no AdvData to make up the number.
 *        However, if a change in circumstances since this command was issued
 *        means that the Controller can no longer schedule all of these packets,
 *        it should transmit as many as possible.
 *        Values:
 *        - 0x01 ... 0x10: The number of Constant Tone Extensions to transmit in each periodic advertising interval
 * @param Switching_Pattern_Length
 *        Values:
 *        - 0x02 ... 0x4B: The number of Antenna IDs in the pattern.
 * @param Antenna_IDs List of Antenna IDs in the pattern
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_connectionless_cte_transmit_parameters(uint8_t Advertising_Handle,
                                                             uint8_t CTE_Length,
                                                             uint8_t CTE_Type,
                                                             uint8_t CTE_Count,
                                                             uint8_t Switching_Pattern_Length,
                                                             uint8_t Antenna_IDs[]);
/**
 * @brief The HCI_LE_Set_Connectionless_CTE_Transmit_Enable command is used to
 *        request that the Controller enables or disables the use of Constant
 *        Tone Extensions in any periodic advertising on the advertising set
 *        identified by Advertising_Handle. In order to start sending periodic
 *        advertisements containing a Constant Tone Extension, the Host must
 *        also enable periodic advertising using the
 *        HCI_LE_Set_Periodic_Advertising_Enable command (see Section 7.8.63).
 *        Note: Periodic advertising can only be enabled when advertising is
 *        enabled on the same advertising set, but can continue after
 *        advertising has been disabled. If the Host issues this command before
 *        it has issued the HCI_LE_Set_Periodic_Advertising_Parameters command
 *        (see Section 7.8.61) for the advertising set, the Controller shall
 *        return the error code Command Disallowed (0x0C). Once enabled, the
 *        Controller shall continue advertising with Constant Tone Extensions
 *        until either one of the following occurs: - The Host issues an
 *        HCI_LE_Set_Connectionless_CTE_Transmit_Enable command with CTE_Enable
 *        set to 0x00 (disabling Constant Tone Extensions but allowing periodic
 *        advertising to continue). - The Host issues an
 *        HCI_LE_Set_Periodic_Advertising_Enable command (see Section 7.8.63)
 *        with Enable set to 0x00 (disabling periodic advertising). If periodic
 *        advertising is re-enabled then it shall continue to contain Constant
 *        Tone Extensions. If the Host issues this command before it has issued
 *        the HCI_LE_Set_Connectionless_CTE_Transmit_Parameters command for the
 *        advertising set, the Controller shall return the error code Command
 *        Disallowed (0x0C). If the periodic advertising is on a PHY that does
 *        not allow Constant Tone Extensions, the Controller shall return the
 *        error code Command Disallowed (0x0C).
 * @param Advertising_Handle Identifier for the advertising set in which
 *        Constant Tone Extension is being enabled or disabled
 *        Values:
 *        - 0x00 ... 0xEF
 * @param CTE_Enable It enables or disables the use of Constant Tone Extensions.
 *        Values:
 *        - 0x00: Advertising with Constant Tone Extension is disabled (default)
 *        - 0x01: Advertising with Constant Tone Extension is enabled
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_connectionless_cte_transmit_enable(uint8_t Advertising_Handle,
                                                         uint8_t CTE_Enable);
/**
 * @brief The HCI_LE_Set_Connectionless_IQ_Sampling_Enable command is used to
 *        request that the Controller enables or disables capturing IQ samples
 *        from the Constant Tone Extension of periodic advertising packets in
 *        the periodic advertising train identified by the Sync_Handle
 *        parameter. If that periodic advertising train does not exist, then the
 *        Controller shall return the error code Unknown Advertising Identifier
 *        (0x42). The Max_Sampled_CTEs parameter specifies the maximum number of
 *        Constant Tone Extensions in each periodic advertising event that the
 *        Controller should collect and report IQ samples from. The Controller
 *        should sample all Constant Tone Extensions up to this number. If the
 *        Sampling_Enable parameter is set to 0x01 (sampling is enabled), the
 *        Controller starts attempting to capture IQ samples from the periodic
 *        advertisements. Once sampling has been enabled, the Controller shall
 *        continue taking IQ samples until the Host issues an
 *        HCI_LE_Set_Connectionless_IQ_Enable command with Sampling_Enable set
 *        to 0x00 (sampling is disabled) or synchronization with the periodic
 *        advertising train is lost. If Sampling_Enable is set to 0x00,
 *        Slot_Durations, Max_Sampled_CTEs, Switching_Pattern_Length, and
 *        Antenna_IDs shall be ignored. The command is also used to set the
 *        antenna switching pattern and switching and sampling slot durations to
 *        be used while receiving the Constant Tone Extension. If Slot_Durations
 *        is set to 0x01 and the Controller does not support 1 microsecond
 *        switching and sampling, the Controller shall return the error code
 *        Unsupported Feature or Parameter Value (0x11). The Slot_Durations,
 *        Switching_Pattern_Length, and Antenna_IDs parameters are only used
 *        when receiving an AoA Constant Tone Extension and do not affect the
 *        reception of an AoD Constant Tone Extension. If
 *        Switching_Pattern_Length is greater than the maximum length of
 *        switching pattern supported by the Controller, the Controller shall
 *        return the error code Unsupported Feature or Parameter Value (0x11).
 *        If the Controller determines that any of the Antenna_IDs[i] values do
 *        not identify an antenna in the device's antenna array, it shall return
 *        the error code Unsupported Feature or Parameter Value (0x11). Note:
 *        Some Controllers may be unable to determine which values do or do not
 *        identify an antenna. If Sampling_Enable is set to 0x01 and the
 *        periodic advertising is on a PHY that does not allow Constant Tone
 *        Extensions, the Controller shall return the error code Command
 *        Disallowed (0x0C).
 * @param Sync_Handle Sync handle that identifies the synchronization
 *        information about the periodic advertising train.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Sampling_Enable If the Sampling_Enable parameter is set to 0x01
 *        (sampling is enabled), the Controller starts attempting to capture IQ
 *        samples from the periodic advertisements.
 *        Values:
 *        - 0x00: DISABLE
 *        - 0x01: ENABLE
 * @param Slot_Durations Sampling rate used by the Controller.
 *        Values:
 *        - 0x01: SLOT_1us
 *        - 0x02: SLOT_2us
 * @param Max_Sampled_CTEs It specifies the maximum number of Constant Tone
 *        Extensions in each periodic advertising event that the Controller
 *        should collect and report IQ samples from. The Controller should
 *        sample all Constant Tone Extensions up to this number.
 *        Values:
 *        - 0x00: REPORT_ALL_CTES
 *        - 0x01 ... 0x10
 * @param Switching_Pattern_Length The number of Antenna IDs in the pattern.
 *        Values:
 *        - 0x02 ... 0x4B
 * @param Antenna_IDs List of Antenna IDs in the pattern
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_connectionless_iq_sampling_enable(uint16_t Sync_Handle,
                                                        uint8_t Sampling_Enable,
                                                        uint8_t Slot_Durations,
                                                        uint8_t Max_Sampled_CTEs,
                                                        uint8_t Switching_Pattern_Length,
                                                        uint8_t Antenna_IDs[]);
/**
 * @brief The HCI_LE_Set_Connection_CTE_Receive_Parameters command is used to
 *        enable or disable sampling received Constant Tone Extension fields on
 *        the connection identified by the Connection_Handle parameter and to
 *        set the antenna switching pattern and switching and sampling slot
 *        durations to be used. If the Sampling_Enable parameter is set to 0x01,
 *        the Controller shall sample Constant Tone Extensions on the specified
 *        connection and report the samples to the Host. If it is set to 0x00,
 *        the Controller shall cease sampling on the specified connection; the
 *        remaining parameters shall be ignored. If Slot_Durations is set to
 *        0x01 and the Controller does not support 1 microsecond switching and
 *        sampling, the Controller shall return the error code Unsupported
 *        Feature or Parameter Value (0x11). The Slot_Durations,
 *        Switching_Pattern_Length, and Antenna_IDs parameters are only used
 *        when receiving an AoA Constant Tone Extension and do not affect the
 *        reception of an AoD Constant Tone Extension. If
 *        Switching_Pattern_Length is greater than the maximum length of
 *        switching pattern supported by the Controller, the Controller shall
 *        return the error code Unsupported Feature or Parameter Value (0x11).
 *        If the Controller determines that any of the Antenna_IDs[i] values do
 *        not identify an antenna in the device's antenna array, it shall return
 *        the error code Unsupported Feature or Parameter Value (0x11). Note:
 *        Some Controllers may be unable to determine which values do or do not
 *        identify an antenna.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Sampling_Enable
 *        Values:
 *        - 0x00: Connection IQ sampling is disabled (default)
 *        - 0x01: Connection IQ sampling is enabled
 * @param Slot_Durations Sampling rate used by the Controller.
 *        Values:
 *        - 0x01: SLOT_1us
 *        - 0x02: SLOT_2us
 * @param Switching_Pattern_Length
 *        Values:
 *        - 0x02 ... 0x4B: The number of Antenna IDs in the pattern.
 * @param Antenna_IDs List of Antenna IDs in the pattern
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_connection_cte_receive_parameters(uint16_t Connection_Handle,
                                                        uint8_t Sampling_Enable,
                                                        uint8_t Slot_Durations,
                                                        uint8_t Switching_Pattern_Length,
                                                        uint8_t Antenna_IDs[]);
/**
 * @brief The HCI_LE_Set_Connection_CTE_Transmit_Parameters command is used to
 *        set the antenna switching pattern and permitted Constant Tone
 *        Extension types used for transmitting Constant Tone Extensions
 *        requested by the peer device on the connection identified by the
 *        Connection_Handle parameter. If the Host issues this command when
 *        Constant Tone Extension responses have been enabled on the connection,
 *        the Controller shall return the error code Command Disallowed (0x0C).
 *        If the CTE_Types parameter has a bit set for a type of Constant Tone
 *        Extension that the Controller does not support, the Controller shall
 *        return the error code Unsupported Feature or Parameter Value (0x11).
 *        The Switching_Pattern_Length and Antenna_IDs[i] parameters are only
 *        used when transmitting an AoD Constant Tone Extension and shall be
 *        ignored when CTE_Types does not have a bit set for an AoD Constant
 *        Tone Extension; they do not affect the transmission of an AoA Constant
 *        Tone Extension. If Switching_Pattern_Length is greater than the
 *        maximum length of switching pattern supported by the Controller, the
 *        Controller shall return the error code Unsupported Feature or
 *        Parameter Value (0x11). If the Controller determines that any of the
 *        Antenna_IDs[i] values do not identify an antenna in the device's
 *        antenna array, it shall return the error code Unsupported Feature or
 *        Parameter Value (0x11). Note: Some Controllers may be unable to
 *        determine which values do or do not identify an antenna.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param CTE_Type
 *        Flags:
 *        - 0x01: Allow AoA Constant Tone Extension Response
 *        - 0x02: Allow AoD Constant Tone Extension Response with 1 microsecond slots
 *        - 0x04: Allow AoD Constant Tone Extension Response with 2 microseconds slots
 * @param Switching_Pattern_Length
 *        Values:
 *        - 0x02 ... 0x4B: The number of Antenna IDs in the pattern.
 * @param Antenna_IDs List of Antenna IDs in the pattern
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_connection_cte_transmit_parameters(uint16_t Connection_Handle,
                                                         uint8_t CTE_Type,
                                                         uint8_t Switching_Pattern_Length,
                                                         uint8_t Antenna_IDs[]);
/**
 * @brief The HCI_LE_Connection_CTE_Request_Enable command is used to request
 *        the Controller to start or stop initiating the Constant Tone Extension
 *        Request procedure (see [Vol 6] Part B, Section 5.1.12) on a connection
 *        identified by the Connection_Handle parameter. If the Host issues this
 *        command when the Controller is aware (e.g. through a previous feature
 *        exchange) that the peer device's Link Layer does not support the
 *        Connection CTE Response feature, the Controller shall return the error
 *        code Unsupported Remote Feature / Unsupported LMP Feature (0x1A). If
 *        the Host issues this command when the Controller is aware that the
 *        peer device's Link Layer does not support the requested CTE type, the
 *        Controller should return the error code Unsupported Remote Feature /
 *        Unsupported LMP Feature (0x1A). If Enable is set to 0x00, the
 *        remaining parameters shall be ignored. The CTE_Request_Interval
 *        parameter defines whether the Constant Tone Extension Request
 *        procedure is initiated only once or periodically. In the case of
 *        periodic operation, the procedure is initiated every
 *        CTE_Request_Interval. However, the Controller may delay initiating the
 *        procedure beyond the requested interval (e.g., in order to prioritize
 *        other activities). The Requested_CTE_Length parameter indicates the
 *        minimum length of the Constant Tone Extension and the
 *        Requested_CTE_Type parameter indicates the type of Constant Tone
 *        Extension that the Controller shall request from the remote device. A
 *        request is active on a connection from when the Host issues a
 *        successful command with Enable set to 0x01 until the single procedure
 *        has been performed, the period specified by CTE_Request_Interval has
 *        ended, or a command with Enable set to 0x00 has succeeded, whichever
 *        happens first. If the Host issues this command with Enable set to 0x01
 *        while a request is active for the specified connection, the Controller
 *        shall return the error code Command Disallowed (0x0C). Note: The
 *        failed command will not affect the behavior of the Link Layer in
 *        respect of the currently-active request. If the Host issues this
 *        command before issuing the
 *        HCI_LE_Set_Connection_CTE_Receive_Parameters command at least once on
 *        the connection, the Controller shall return the error code Command
 *        Disallowed (0x0C). If the Host issues this command when the receiver
 *        PHY for the connection is not a PHY that allows Constant Tone
 *        Extensions, the Controller shall return the error code Command
 *        Disallowed (0x0C). If the Host sets CTE_Request_Interval to a non-zero
 *        value less than or equal to connSlaveLatency, the Controller shall
 *        return the error code Command Disallowed (0x0C). If Enable is set to
 *        0x01 and the receiver PHY for the connection changes to a PHY that
 *        does not allow Constant Tone Extensions, then the Controller shall
 *        automatically disable Constant Tone Extension requests as if the Host
 *        had issued this command with Enable set to 0x00. Note: If the PHY
 *        changes back to a PHY that allows Constant Tone Extensions, then the
 *        Controller will not automatically re-enable Constant Tone Extension
 *        requests.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Enable If it is set to 0x00, the remaining parameters shall be
 *        ignored.
 *        Values:
 *        - 0x00: Disable Constant Tone Extension Request for the connection (default)
 *        - 0x01: Enable Constant Tone Extension Request for the connection
 * @param CTE_Request_Interval It defines whether the Constant Tone Extension
 *        Request procedure is initiated only once or periodically. In the case
 *        of periodic operation, the procedure is initiated every
 *        CTE_Request_Interval. However, the Controller may delay initiating the
 *        procedure beyond the requested interval (e.g., in order to prioritize
 *        other activities).
 *        Values:
 *        - 0x0000: Initiate the Constant Tone Extension Request procedure once, at the nearliest practical opportunity.
 *        - 0x0001 ... 0xFFFF: Requested interval for initiating the Constant Tone Extension Request procedure in number of connection events.
 * @param Requested_CTE_Length It indicates the minimum length of the Constant
 *        Tone Extension and the Requested_CTE_Type parameter indicates the type
 *        of Constant Tone Extension that the Controller shall request from the
 *        remote device.
 *        Values:
 *        - 0x02 ... 0x14: Minimum length of the Constant Tone Extension being requested in 8 nmicroseconds units
 * @param Requested_CTE_Type
 *        Flags:
 *        - 0x00: AoA Constant Tone Extension
 *        - 0x01: AoD Constant Tone Extension with 1 microsecond slots
 *        - 0x02: AoD Constant Tone Extension with 2 microseconds slots
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_connection_cte_request_enable(uint16_t Connection_Handle,
                                                uint8_t Enable,
                                                uint16_t CTE_Request_Interval,
                                                uint8_t Requested_CTE_Length,
                                                uint8_t Requested_CTE_Type);
/**
 * @brief The HCI_LE_Connection_CTE_Response_Enable command is used to request
 *        the Controller to respond to LL_CTE_REQ PDUs with LL_CTE_RSP PDUs on
 *        the specified connection. If the Host issues this command before
 *        issuing the HCI_LE_Set_Connection_CTE_Transmit_Parameters command at
 *        least once on the connection, the Controller shall return the error
 *        code Command Disallowed (0x0C). If the Host issues this command when
 *        the transmitter PHY for the connection is not a PHY that allows
 *        Constant Tone Extensions, the Controller shall return the error code
 *        Command Disallowed (0x0C). If the transmitter PHY for the connection
 *        changes to a PHY that does not allow Constant Tone Extensions, then
 *        the Controller shall automatically disable Constant Tone Extension
 *        responses.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Enable
 *        Values:
 *        - 0x00: Disable Constant Tone Extension Response for the connection (default)
 *        - 0x01: Enable Constant Tone Extension Response for the connection
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_connection_cte_response_enable(uint16_t Connection_Handle,
                                                 uint8_t Enable);
/**
 * @brief The HCI_LE_Read_Antenna_Information command allows the Host to read
 *        the switching rates, the sampling rates, the number of antennae, and
 *        the maximum length of a transmitted Constant Tone Extension supported
 *        by the Controller.
 * @param[out] Supported_Switching_Sampling_Rates
 *             Flags:
 *             - 0x00: 1 microsecond switching supported for AoD transmission
 *             - 0x02: 1 microsecond switching supported for AoD reception
 *             - 0x04: 1 microsecond switching and sampling supported for AoA reception
 * @param[out] Num_Antennae
 *             Values:
 *             - 0x01 ... 0x4B: The number of antennae supported by the Controller
 * @param[out] Max_Switching_Pattern_Length
 *             Values:
 *             - 0x02 ... 0x4B: Maximum length of antenna switching pattern supported by the Controller
 * @param[out] Max_CTE_Length
 *             Values:
 *             - 0x02 ... 0x14: Maximum length of a transmitted Constant Tone Extension supported in 8 microseconds units
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_read_antenna_information(uint8_t *Supported_Switching_Sampling_Rates,
                                           uint8_t *Num_Antennae,
                                           uint8_t *Max_Switching_Pattern_Length,
                                           uint8_t *Max_CTE_Length);
/**
 * @brief The HCI_LE_Set_Periodic_Advertising_Receive_Enable command will enable
 *        or disable reports for the periodic advertising train identified by
 *        the Sync_Handle parameter. The Enable parameter determines whether
 *        reporting is enabled or disabled. If the value is the same as the
 *        current state, the command has no effect. If the periodic advertising
 *        train corresponding to the Sync_Handle parameter does not exist, the
 *        Controller shall return the error code Unknown Advertising Identifier
 *        (0x42).
 * @param Sync_Handle Sync_Handle identifying the periodic advertising train
 *        Values:
 *        - 0x0000 ... 0x0EFF: Sync_Handle identifying the periodic advertising train
 * @param Enable It determines whether reporting is enabled or disabled
 *        Values:
 *        - 0x00: Reporting disabled
 *        - 0x01: Reporting enabled
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_periodic_advertising_receive_enable(uint16_t Sync_Handle,
                                                          uint8_t Enable);
/**
 * @brief The HCI_LE_Periodic_Advertising_Sync_Transfer command is used to
 *        instruct the Controller to send synchronization information about the
 *        periodic advertising train identified by the Sync_Handle parameter to
 *        a connected device. The Service_Data parameter is a value provided by
 *        the Host for use by the Host of the peer device. It is not used by the
 *        Controller. The connected device is identified by the
 *        Connection_Handle parameter. If the periodic advertising train
 *        corresponding to the Sync_Handle parameter does not exist, the
 *        Controller shall return the error code Unknown Advertising Identifier
 *        (0x42). If the Connection_Handle parameter does not identify a current
 *        connection, the Controller shall return the error code Unknown
 *        Connection Identifier (0x02). If the remote device has not indicated
 *        support for the Periodic Advertising Sync Transfer - Recipient
 *        feature, the Controller shall return the error code Unsupported Remote
 *        Feature / Unsupported LMP Feature (0x1A). Note: This command may
 *        complete before the periodic advertising synchronization information
 *        is sent. No indication is given as to how the recipient handled the
 *        information.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Service_Data The Service_Data parameter is a value provided by the
 *        Host for use by the Host of the peer device. It is not used by the
 *        Controller.
 * @param Sync_Handle Sync handle that identifies the synchronization
 *        information about the periodic advertising train.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_periodic_advertising_sync_transfer(uint16_t Connection_Handle,
                                                     uint16_t Service_Data,
                                                     uint16_t Sync_Handle);
/**
 * @brief The HCI_LE_Periodic_Advertising_Set_Info_Transfer command is used to
 *        instruct the Controller to send synchronization information about the
 *        periodic advertising in an advertising set to a connected device. The
 *        Advertising_Handle parameter identifies the advertising set. If the
 *        parameters in the advertising set have changed since the periodic
 *        advertising was first enabled, the current parameters - not the
 *        original ones - are sent. The Service_Data parameter is a value
 *        provided by the Host to identify the periodic advertising train to the
 *        peer device. It is not used by the Controller. The connected device is
 *        identified by the Connection_Handle parameter. If the advertising set
 *        corresponding to the Advertising_Handle parameter does not exist, the
 *        Controller shall return the error code Unknown Advertising Identifier
 *        (0x42). If periodic advertising is not currently in progress for the
 *        advertising set, the Controller shall return the error code Command
 *        Disallowed (0x0C). If the Connection_Handle parameter does not
 *        identify a current connection, the Controller shall return the error
 *        code Unknown Connection Identifier (0x02). If the remote device has
 *        not indicated support for the Periodic Advertising Sync Transfer -
 *        Recipient feature, the Controller shall return the error code
 *        Unsupported Remote Feature / Unsupported LMP Feature (0x1A). Note:
 *        This command may complete before the periodic advertising
 *        synchronization information is sent. No indication is given as to how
 *        the recipient handled the information.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Service_Data It is a value provided by the Host to identify the
 *        periodic advertising train to the peer device. It is not used by the
 *        Controller.
 * @param Advertising_Handle It is used to identify an advertising set
 *        Values:
 *        - 0x00 ... 0xEF
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_periodic_advertising_set_info_transfer(uint16_t Connection_Handle,
                                                         uint16_t Service_Data,
                                                         uint8_t Advertising_Handle);
/**
 * @brief The HCI_LE_Set_Periodic_Advertising_Sync_Transfer_Parameters command
 *        is used to specify how the Controller will process periodic
 *        advertising synchronization information received from the device
 *        identified by the Connection_Handle parameter (the "transfer mode").
 *        The Mode parameter specifies the action to be taken when periodic
 *        advertising synchronization information is received. If Mode is 0x00,
 *        the Controller will ignore the information. Otherwise it will notify
 *        the Host and synchronize to the periodic advertising. Mode also
 *        specifies whether periodic advertising reports are initially enabled
 *        or disabled. The Skip parameter specifies the number of consecutive
 *        periodic advertising packets that the receiver may skip after
 *        successfully receiving a periodic advertising packet. The Sync_Timeout
 *        parameter specifies the maximum permitted time between successful
 *        receives. If this time is exceeded, synchronization is lost.
 *        Irrespective of the value of the Skip parameter, the Controller should
 *        stop skipping packets before the Sync_Timeout would be exceeded. The
 *        CTE_Type parameter specifies whether to only synchronize to periodic
 *        advertising with certain types of Constant Tone Extension. If the
 *        periodic advertiser changes the type of the Constant Tone Extension
 *        after the Controller has synchronized with the periodic advertising,
 *        it shall remain synchronized. Note: A value of 0 (i.e. all bits clear)
 *        indicates that the presence or absence of a Constant Tone Extension is
 *        irrelevant. This command does not affect any processing of any
 *        periodic advertising synchronization information already received from
 *        the peer device, whether or not the Controller has yet synchronized to
 *        the periodic advertising train it describes. The parameter values
 *        provided by this command override those provided via the
 *        HCI_LE_Set_Default_Periodic_Advertising_Sync_Transfer_Parameters
 *        command (Section 7.8.92) or any preferences previously set using the
 *        HCI_LE_Set_Periodic_Advertising_Sync_Transfer_Parameters command on
 *        the same connection. If the Connection_Handle parameter does not
 *        identify a current connection, the Controller shall return the error
 *        code Unknown Connection Identifier (0x02).
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Mode The Mode parameter specifies the action to be taken when periodic
 *        advertising synchronization information is received. If Mode is 0x00,
 *        the Controller will ignore the information. Otherwise it will notify
 *        the Host and synchronize to the periodic advertising. Mode also
 *        specifies whether periodic advertising reports are initially enabled
 *        or disabled.
 *        Values:
 *        - 0x00: No attempt is made to synchronize to the periodic advertising and no HCI_LE_Periodic_Advertising_Sync_Transfer_Received event is sent to the Host.
 *        - 0x01: An HCI_LE_Periodic_Advertising_Sync_Transfer_Received event is sent to the Host. HCI_LE_Periodic_Advertising_Report events will be disabled.
 *        - 0x02: An HCI_LE_Periodic_Advertising_Sync_Transfer_Received event is sent to the Host. HCI_LE_Periodic_Advertising_Report events will be enabled.
 * @param Skip The Skip parameter specifies the number of consecutive periodic
 *        advertising packets that the receiver may skip after successfully
 *        receiving a periodic advertising packet.
 *        Values:
 *        - 0x0000 ... 0x01F3: The number of periodic advertising packets that can be skipped after a successful receive
 * @param Sync_Timeout The Skip parameter specifies the number of consecutive
 *        periodic advertising packets that the receiver may skip after
 *        successfully receiving a periodic advertising packet. Time = N*10 ms;
 *        Time Range: 100 ms to 163.84 s.
 *        Values:
 *        - 0x000A (100 ms)  ... 0x4000 (163840 ms) : Synchronization timeout for the periodic advertising
 * @param CTE_Type It specifies whether to only synchronize to periodic
 *        advertising with certain types of Constant Tone Extension. If the
 *        periodic advertiser changes the type of the Constant Tone Extension
 *        after the Controller has synchronized with the periodic advertising,
 *        it shall remain synchronized.
 *        Flags:
 *        - 0x01: Do not sync to packets with an AoA Constant Tone Extension
 *        - 0x02: Do not sync to packets with an AoD Constant Tone Extension with 1 microsecond slots
 *        - 0x04: Do not sync to packets with an AoD Constant Tone Extension with 2 microseconds slots
 *        - 0x10: Do not sync to packets without a Constant Tone Extension
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_periodic_advertising_sync_transfer_parameters(uint16_t Connection_Handle,
                                                                    uint8_t Mode,
                                                                    uint16_t Skip,
                                                                    uint16_t Sync_Timeout,
                                                                    uint8_t CTE_Type);
/**
 * @brief The HCI_LE_Set_Default_Periodic_Advertising_Sync_Transfer_Parameters
 *        command is used to specify the initial value for the mode, skip,
 *        timeout, and Constant Tone Extension type (set by the
 *        HCI_LE_Set_Periodic_Advertising_Sync_Transfer_Parameters command; see
 *        Section 7.8.91) to be used for all subsequent connections over the LE
 *        transport. The Mode parameter specifies the initial action to be
 *        taken. If Mode is 0x00, the Controller will ignore the information.
 *        Otherwise it will notify the Host and synchronize to the periodic
 *        advertising. Mode also specifies whether periodic advertising reports
 *        are initially enabled or disabled. The Skip parameter specifies the
 *        number of consecutive periodic advertising packets that the receiver
 *        may skip after successfully receiving a periodic advertising packet.
 *        The Sync_Timeout parameter specifies the maximum permitted time
 *        between successful receives. If this time is exceeded, synchronization
 *        is lost. The CTE_Type parameter specifies whether to only synchronize
 *        to periodic advertising with certain types of Constant Tone Extension.
 *        If the periodic advertiser changes the type of the Constant Tone
 *        Extension after the Controller has synchronized with the periodic
 *        advertising, it shall remain synchronized. Note: A value of 0 (i.e.
 *        all bits clear) indicates that the presence or absence of a Constant
 *        Tone Extension is irrelevant. This command does not affect any
 *        existing connection.
 * @param Mode The Mode parameter specifies the initial action to be taken. If
 *        Mode is 0x00, the Controller will ignore the information. Otherwise it
 *        will notify the Host and synchronize to the periodic advertising. Mode
 *        also specifies whether periodic advertising reports are initially
 *        enabled or disabled.
 *        Values:
 *        - 0x00: No attempt is made to synchronize to the periodic advertising and no HCI_LE_Periodic_Advertising_Sync_Transfer_Received event is sent to the Host.
 *        - 0x01: An HCI_LE_Periodic_Advertising_Sync_Transfer_Received event is sent to the Host. HCI_LE_Periodic_Advertising_Report events will be disabled.
 *        - 0x02: An HCI_LE_Periodic_Advertising_Sync_Transfer_Received event is sent to the Host. HCI_LE_Periodic_Advertising_Report events will be enabled.
 * @param Skip The Skip parameter specifies the number of consecutive periodic
 *        advertising packets that the receiver may skip after successfully
 *        receiving a periodic advertising packet.
 *        Values:
 *        - 0x0000 ... 0x01F3: The number of periodic advertising packets that can be skipped after a successful receive
 * @param Sync_Timeout The Skip parameter specifies the number of consecutive
 *        periodic advertising packets that the receiver may skip after
 *        successfully receiving a periodic advertising packet. Time = N*10 ms;
 *        Time Range: 100 ms to 163.84 s.
 *        Values:
 *        - 0x000A (100 ms)  ... 0x4000 (163840 ms) : Synchronization timeout for the periodic advertising
 * @param CTE_Type The CTE_Type parameter specifies whether to only synchronize
 *        to periodic advertising with certain types of Constant Tone Extension.
 *        If the periodic advertiser changes the type of the Constant Tone
 *        Extension after the Controller has synchronized with the periodic
 *        advertising, it shall remain synchronized.
 *        Flags:
 *        - 0x01: Do not sync to packets with an AoA Constant Tone Extension
 *        - 0x02: Do not sync to packets with an AoD Constant Tone Extension with 1 microsecond slots
 *        - 0x04: Do not sync to packets with an AoD Constant Tone Extension with 2 microseconds slots
 *        - 0x10: Do not sync to packets without a Constant Tone Extension
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_default_periodic_advertising_sync_transfer_parameters(uint8_t Mode,
                                                                            uint16_t Skip,
                                                                            uint16_t Sync_Timeout,
                                                                            uint8_t CTE_Type);
/**
 * @brief Read the current and maximum transmit power levels of the local
 *        Controller on the ACL connection identified by the Connection_Handle
 *        parameter and the PHY indicated by the PHY parameter.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param PHY PHY associated with the connection  (not necessarily the currently
 *        used one).
 *        Values:
 *        - 0x01: LE_1M_PHY
 *        - 0x02: LE_2M_PHY
 *        - 0x03: LE_CODED_PHY_S8
 *        - 0x04: LE_CODED_PHY_S2
 * @param[out] Current_Transmit_Power_Level Current TX power level (dBm).
 *             Values:
 *             - 127: NA
 *             - -127 ... 20
 * @param[out] Max_Transmit_Power_Level Maximum TX power level (dBm).
 *             Values:
 *             - -127 ... 20
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_enhanced_read_transmit_power_level(uint16_t Connection_Handle,
                                                     uint8_t PHY,
                                                     int8_t *Current_Transmit_Power_Level,
                                                     int8_t *Max_Transmit_Power_Level);
/**
 * @brief Read the transmit power level used by the remote Controller on the ACL
 *        connection that is identified by the Connection_Handle parameter and
 *        the PHY indicated by the PHY parameter. Initiate a Power Control
 *        Request procedure to obtain the remote transmit power level if no
 *        prior value is available or used.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param PHY PHY associated with the connection  (not necessarily the currently
 *        used one).
 *        Values:
 *        - 0x01: LE_1M_PHY
 *        - 0x02: LE_2M_PHY
 *        - 0x03: LE_CODED_PHY_S8
 *        - 0x04: LE_CODED_PHY_S2
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_read_remote_transmit_power_level(uint16_t Connection_Handle,
                                                   uint8_t PHY);
/**
 * @brief Set the path loss threshold reporting parameters for the ACL
 *        connection identified by the Connection_Handle parameter.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param High_Threshold High threshold for the path loss. Units: dB.
 *        Values:
 *        - 255: UNUSED
 *        - 0 ... 254
 * @param High_Hysteresis Hysteresis value for the high threshold. Units: dB.
 * @param Low_Threshold Low threshold for the path loss. Units: dB.
 * @param Low_Hysteresis Hysteresis value for the low threshold. Units: dB.
 * @param Min_Time_Spent Minimum time in number of connection events to be
 *        observed once the path crosses the threshold before an event is
 *        generated.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_path_loss_reporting_parameters(uint16_t Connection_Handle,
                                                     uint8_t High_Threshold,
                                                     uint8_t High_Hysteresis,
                                                     uint8_t Low_Threshold,
                                                     uint8_t Low_Hysteresis,
                                                     uint16_t Min_Time_Spent);
/**
 * @brief Enable or disable path loss reporting for the ACL connection
 *        identified by the Connection_Handle parameter. Initiate a new Power
 *        Control Request procedure to obtain the remote transmit power level if
 *        no prior value is available or used and no prior Power Control Request
 *        procedure has been initiated. Path loss reporting is disabled when the
 *        connection is first created.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Enable Enable (1) or disable (0) reportinig.
 *        Values:
 *        - 0x00: DISABLE
 *        - 0x01: ENABLE
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_path_loss_reporting_enable(uint16_t Connection_Handle,
                                                 uint8_t Enable);
/**
 * @brief Enable or disable the reporting of transmit power level changes in the
 *        local and remote Controllers for the ACL connection identified by the
 *        Connection_Handle parameter. Initiate a new Power Control Request
 *        procedure to obtain the remote transmit power level if Remote_Enable
 *        is 0x01, and no prior value is available or used, and no prior Power
 *        Control Request procedure has been initiated.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Local_Enable Enable (1) or disable (0) local transmit power reports.
 *        Values:
 *        - 0x00: DISABLE
 *        - 0x01: ENABLE
 * @param Remote_Enable Enable (1) or disable (0) remote transmit power reports.
 *        Values:
 *        - 0x00: DISABLE
 *        - 0x01: ENABLE
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_transmit_power_reporting_enable(uint16_t Connection_Handle,
                                                      uint8_t Local_Enable,
                                                      uint8_t Remote_Enable);
/**
 * @brief This command is used to start a test where the DUT generates test
 *        reference packets at a fixed interval. The Controller shall transmit
 *        at the power level indicated by the Transmit_Power_Level parameter.
 *        The TX_Channel and PHY parameters specify the RF channel and PHY to be
 *        used by the transmitter. If the Host sets the PHY parameter to a PHY
 *        that the Controller does not support, including a value that is
 *        reserved for future use, the Controller shall return the error code
 *        Unsupported Feature or Parameter Value (0x11). The Test_Data_Length
 *        and Packet_Payload parameters specify the length and contents of the
 *        Payload of the test reference packets. An LE Controller supporting the
 *        HCI_LE_Transmitter_Test command shall support Packet_Payload values
 *        0x00, 0x01 and 0x02. An LE Controller supporting the LE Coded PHY
 *        shall also support Packet_Payload value 0x04. An LE Controller may
 *        support other values of Packet_Payload. The CTE_Length and CTE_Type
 *        parameters specify the length and type of the Constant Tone Extension
 *        in the test reference packets. If the CTE_Type parameter is set to
 *        0x01 and the Controller does not support 1 microsecond switching, the
 *        Controller shall return the error code Unsupported Feature or
 *        Parameter Value (0x11). If CTE_Length is not zero and PHY specifies a
 *        PHY that does not allow Constant Tone Extensions, the Controller shall
 *        return the error code Command Disallowed (0x0C). The
 *        Switching_Pattern_Length and Antenna_IDs[i] parameters specify the
 *        antenna switching pattern. They are only used when transmitting an AoD
 *        Constant Tone Extension and shall be ignored when transmitting an AoA
 *        Constant Tone Extension. If the Controller determines that any of the
 *        Antenna_IDs[i] values do not identify an antenna in the device's
 *        antenna array, it shall return the error code Unsupported Feature or
 *        Parameter Value (0x11). Note: Some Controllers may be unable to
 *        determine which values do or do not identify an antenna. The
 *        Transmit_Power_Level parameter specifies the transmit power level to
 *        be used by the transmitter. If the parameter is set to a value other
 *        than 0x7E or 0x7F, then the Controller shall make the requested change
 *        or shall make the nearest change that it is capable of doing.
 * @param TX_Channel N = (F - 2402) / 2
 *        Frequency Range : 2402 MHz to 2480 MHz
 *        Values:
 *        - 0x00 ... 0x27
 * @param Test_Data_Length Length in bytes of payload data in each packet
 * @param Packet_Payload Content of the Payload of the test reference packets.
 *        0: PRBS9 sequence '11111111100000111101...' (in transmission order) 1:
 *        Repeated '11110000' (in transmission order) sequence 2: Repeated
 *        '10101010' (in transmission order) sequence 3: PRBS15 sequence 4:
 *        Repeated '11111111' (in transmission order) sequence 5: Repeated
 *        '00000000' (in transmission order) sequence 6: Repeated '00001111' (in
 *        transmission order) sequence 7: Repeated '01010101' (in transmission
 *        order) sequence
 *        Values:
 *        - 0x00: PRBS9
 *        - 0x01: Repeated '11110000'
 *        - 0x02: Repeated '10101010'
 *        - 0x03: PRBS15
 *        - 0x04: Repeated '11111111'
 *        - 0x05: Repeated '00000000'
 *        - 0x06: Repeated '00001111'
 *        - 0x07: Repeated '01010101'
 * @param PHY PHY to be used by the transmitter.
 *        Values:
 *        - 0x01: LE_1M_PHY
 *        - 0x02: LE_2M_PHY
 *        - 0x03: LE_CODED_PHY_S8
 *        - 0x04: LE_CODED_PHY_S2
 * @param CTE_Length
 *        Values:
 *        - 0x00: No Constant Tone Extension expected (default)
 *        - 0x02 ... 0x14: Expected length of the Constant Tone Extension in 8 microseconds units.
 * @param CTE_Type
 *        Values:
 *        - 0x00: Expect AoA Constant Tone Extension
 *        - 0x01: Expect AoD Constant Tone Extension with 1 microsecond slots
 *        - 0x02: Expect AoD Constant Tone Extension with 2 microseconds slots
 * @param Switching_Pattern_Length
 *        Values:
 *        - 0x02 ... 0x4B: The number of Antenna IDs in the pattern.
 * @param Antenna_IDs List of Antenna IDs in the pattern
 * @param Transmit_Power_Level
 *        Values:
 *        - 126: Set transmitter to minimum transmit power level
 *        - 127: Set transmitter to maximum transmit power level
 *        - -127 ... 20: Set transmitter to the specified or the nearest transmit power level.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_transmitter_test_v4(uint8_t TX_Channel,
                                      uint8_t Test_Data_Length,
                                      uint8_t Packet_Payload,
                                      uint8_t PHY,
                                      uint8_t CTE_Length,
                                      uint8_t CTE_Type,
                                      uint8_t Switching_Pattern_Length,
                                      uint8_t Antenna_IDs[],
                                      int8_t Transmit_Power_Level);
/**
     * @}
     */
    #endif /* _BLUENRG_LP_HCI_LE_H_ */
