

/**
  ******************************************************************************
  * @file    bluenrg_lp_gatt_aci.h
  * @author  AMS - RF Application team
  * @date    18 March 2021
  * @brief   Header file for external uC - BlueNRG-x in network coprocessor mode (gatt_aci)
  *          Autogenerated files, do not edit!!
  ******************************************************************************
  * @attention
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  *
  * <h2><center>&copy; COPYRIGHT STMicroelectronics</center></h2>
  ******************************************************************************
  */
#ifndef _BLUENRG_LP_GATT_ACI_H_
#define _BLUENRG_LP_GATT_ACI_H_

#include "bluenrg_lp_types.h"
/** Documentation for C union Service_UUID_t */
typedef union Service_UUID_t_s {
  /** 16-bit UUID
   */
  uint16_t Service_UUID_16;
  /** 128-bit UUID
   */
  uint8_t Service_UUID_128[16];
} Service_UUID_t;
/** Documentation for C union Char_UUID_t */
typedef union Char_UUID_t_s {
  /** 16-bit UUID
   */
  uint16_t Char_UUID_16;
  /** 128-bit UUID
   */
  uint8_t Char_UUID_128[16];
} Char_UUID_t;
/** Documentation for C union Char_Desc_Uuid_t */
typedef union Char_Desc_Uuid_t_s {
  /** 16-bit UUID
   */
  uint16_t Char_UUID_16;
  /** 128-bit UUID
   */
  uint8_t Char_UUID_128[16];
} Char_Desc_Uuid_t;
/** Documentation for C union UUID_t */
typedef union UUID_t_s {
  /** 16-bit UUID
   */
  uint16_t UUID_16;
  /** 128-bit UUID
   */
  uint8_t UUID_128[16];
} UUID_t;
/** Documentation for C struct Handle_Entry_t */
typedef struct Handle_Entry_t_s {
  /** The handles for which the attribute value has to be read
   *  Values:
   *  - 0x0001 ... 0xFFFF
   */
  uint16_t Handle;
} Handle_Entry_t;
/**
 * @brief Adds the GATT service to the database.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_srv_init(void);
/**
 * @brief Adds a service to GATT Server. When a service is created, the host may
 *        reserve a range of handles for this service. The handle for the
 *        created service is returned.
 * @param Service_UUID_Type UUID type.
 *        Values:
 *        - 0x01: 16-bit UUID
 *        - 0x02: 128-bit UUID
 * @param Service_UUID See @ref Service_UUID_t
 * @param Service_Type Service type.
 *        Values:
 *        - 0x01: Primary Service
 *        - 0x02: Secondary Service
 * @param Max_Attribute_Records Number of handles reserved for the service. If
 *        0, no handles are served and when the next service is added to the
 *        GATT database, the first available handle is assigned to that service
 *        (this means that no more attributes can be assigned to the previously
 *        created service).
 * @param[out] Service_Handle Handle of the Service. When this service is added,
 *             a handle is allocated by the server for this service.  Server
 *             also allocates a range of handles for this service from
 *             serviceHandle to <serviceHandle + max_attr_records - 1>
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_srv_add_service_nwk(uint8_t Service_UUID_Type,
                                        Service_UUID_t *Service_UUID,
                                        uint8_t Service_Type,
                                        uint8_t Max_Attribute_Records,
                                        uint16_t *Service_Handle);
/**
 * @brief Includes a service given by Included_Handle to another  service given
 *        by Service_Handle. Attribute server creates an Include definition
 *        attribute and returns the handle of this attribute.
 * @param Service_Handle Handle of the Service to which another service has to
 *        be included.
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param Included_Service_Handle Attribute Handle of the Service which has to
 *        be included in service
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param[out] Include_Handle Handle of the include declaration
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_srv_include_service_nwk(uint16_t Service_Handle,
                                            uint16_t Included_Service_Handle,
                                            uint16_t *Include_Handle);
/**
 * @brief Adds a characteristic to a service.
 * @param Service_Handle Handle of the Service to which the characteristic will
 *        be added.
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param Char_UUID_Type UUID type.
 *        Values:
 *        - 0x01: 16-bit UUID
 *        - 0x02: 128-bit UUID
 * @param Char_UUID See @ref Char_UUID_t
 * @param Char_Value_Length Maximum length of the characteristic value.
 *        Values:
 *        - 0 ... 512
 * @param Char_Properties Characteristic Properties (Volume 3, Part G, section
 *        3.3.1.1 of Bluetooth Specification 4.1)
 *        Flags:
 *        - 0x00: CHAR_PROP_NONE
 *        - 0x01: CHAR_PROP_BROADCAST (Broadcast)
 *        - 0x02: CHAR_PROP_READ (Read)
 *        - 0x04: CHAR_PROP_WRITE_WITHOUT_RESP (Write w/o resp)
 *        - 0x08: CHAR_PROP_WRITE (Write)
 *        - 0x10: CHAR_PROP_NOTIFY (Notify)
 *        - 0x20: CHAR_PROP_INDICATE (Indicate)
 *        - 0x40: CHAR_PROP_SIGNED_WRITE (Authenticated Signed Writes)
 *        - 0x80: CHAR_PROP_EXT (Extended Properties)
 * @param Security_Permissions Security permission flags.
 *        Flags:
 *        - 0x00
 *        - 0x01: AUTHEN_READ (Need authentication to read)
 *        - 0x04: ENCRY_READ (Need encryption to read)
 *        - 0x08: AUTHEN_WRITE (need authentication to write)
 *        - 0x20: ENCRY_WRITE (need encryption to write)
 * @param GATT_Evt_Mask GATT event mask. - GATT_NOTIFY_ATTRIBUTE_WRITE:
 *        aci_gatt_srv_attribute_modified_event() is generated when
 *        characteristic value is modified. -
 *        GATT_NOTIFY_WRITE_REQ_AND_WAIT_FOR_APPL_RESP:
 *        aci_gatt_srv_authorize_nwk_event() is generated when a write operation
 *        is received on the characteristic value. -
 *        GATT_NOTIFY_READ_REQ_AND_WAIT_FOR_APPL_RESP:
 *        aci_gatt_srv_authorize_nwk_event() is generated when a read request is
 *        received on the characteristic value.
 *        Flags:
 *        - 0x00: GATT_DONT_NOTIFY_EVENTS
 *        - 0x01: GATT_NOTIFY_ATTRIBUTE_WRITE
 *        - 0x02: GATT_NOTIFY_WRITE_REQ_AND_WAIT_FOR_APPL_RESP
 *        - 0x04: GATT_NOTIFY_READ_REQ_AND_WAIT_FOR_APPL_RESP
 * @param Enc_Key_Size Minimum encryption key size required to read the
 *        characteristic.
 *        Values:
 *        - 0x07 ... 0x10
 * @param Is_Variable Specify if the characteristic value has a fixed length or
 *        a variable length.
 *        Values:
 *        - 0x00: Fixed length
 *        - 0x01: Variable length
 * @param[out] Char_Handle Handle of the Characteristic that has been added.  It
 *             is the handle of the characteristic declaration.  The attribute
 *             that holds the characteristic value is allocated at the next
 *             handle,  followed by the Client Characteristic Configuration
 *             descriptor if the characteristic  has CHAR_PROP_NOTIFY or
 *             CHAR_PROP_INDICATE properties.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_srv_add_char_nwk(uint16_t Service_Handle,
                                     uint8_t Char_UUID_Type,
                                     Char_UUID_t *Char_UUID,
                                     uint16_t Char_Value_Length,
                                     uint8_t Char_Properties,
                                     uint8_t Security_Permissions,
                                     uint8_t GATT_Evt_Mask,
                                     uint8_t Enc_Key_Size,
                                     uint8_t Is_Variable,
                                     uint16_t *Char_Handle);
/**
 * @brief Adds a characteristic descriptor to a characteristic.
 * @param Char_Handle Handle of the characteristic to which description has to
 *        be added
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param Char_Desc_Uuid_Type UUID type.
 *        Values:
 *        - 0x01: 16-bit UUID
 *        - 0x02: 128-bit UUID
 * @param Char_Desc_Uuid See @ref Char_Desc_Uuid_t
 * @param Char_Desc_Value_Max_Len The maximum length of the descriptor value
 *        Values:
 *        - 0 ... 512
 * @param Char_Desc_Value_Length Current Length of the characteristic descriptor
 *        value
 *        Values:
 *        - 0 ... 512
 * @param Char_Desc_Value Value of the characteristic description
 * @param Security_Permissions Security permission flags.
 *        Flags:
 *        - 0x00
 *        - 0x01: AUTHEN_READ (Need authentication to read)
 *        - 0x04: ENCRY_READ (Need encryption to read)
 *        - 0x08: AUTHEN_WRITE (need authentication to write)
 *        - 0x20: ENCRY_WRITE (need encryption to write)
 * @param Access_Permissions Access permission
 *        Flags:
 *        - 0x00: None
 *        - 0x01: READ
 *        - 0x02: WRITE
 *        - 0x04: WRITE_WO_RESP
 *        - 0x08: SIGNED_WRITE
 * @param GATT_Evt_Mask GATT event mask. - GATT_NOTIFY_ATTRIBUTE_WRITE:
 *        aci_gatt_srv_attribute_modified_event() is generated when
 *        characteristic value is modified. -
 *        GATT_NOTIFY_WRITE_REQ_AND_WAIT_FOR_APPL_RESP:
 *        aci_gatt_srv_authorize_nwk_event() is generated when a write operation
 *        is received on the characteristic value. -
 *        GATT_NOTIFY_READ_REQ_AND_WAIT_FOR_APPL_RESP:
 *        aci_gatt_srv_authorize_nwk_event() is generated when a read request is
 *        received on the characteristic value.
 *        Flags:
 *        - 0x00: GATT_DONT_NOTIFY_EVENTS
 *        - 0x01: GATT_NOTIFY_ATTRIBUTE_WRITE
 *        - 0x02: GATT_NOTIFY_WRITE_REQ_AND_WAIT_FOR_APPL_RESP
 *        - 0x04: GATT_NOTIFY_READ_REQ_AND_WAIT_FOR_APPL_RESP
 * @param Enc_Key_Size Minimum encryption key size required to read the
 *        characteristic.
 *        Values:
 *        - 0x07 ... 0x10
 * @param Is_Variable Specify if the characteristic value has a fixed length or
 *        a variable length.
 *        Values:
 *        - 0x00: Fixed length
 *        - 0x01: Variable length
 * @param[out] Char_Desc_Handle Handle of the characteristic descriptor
 *             Values:
 *             - 0x0001 ... 0xFFFF
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_srv_add_char_desc_nwk(uint16_t Char_Handle,
                                          uint8_t Char_Desc_Uuid_Type,
                                          Char_Desc_Uuid_t *Char_Desc_Uuid,
                                          uint16_t Char_Desc_Value_Max_Len,
                                          uint16_t Char_Desc_Value_Length,
                                          uint8_t Char_Desc_Value[],
                                          uint8_t Security_Permissions,
                                          uint8_t Access_Permissions,
                                          uint8_t GATT_Evt_Mask,
                                          uint8_t Enc_Key_Size,
                                          uint8_t Is_Variable,
                                          uint16_t *Char_Desc_Handle);
/**
 * @brief Updates an attribute value.
 * @param Attr_Handle Handle of the attribute
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param Val_Offset The offset from which the attribute value has to be
 *        updated.  If this is set to 0 and the attribute value is of variable
 *        length, then the length of the attribute will be set to the
 *        Char_Value_Length.  If the Val_Offset is set to a value greater than
 *        0, then the length of the attribute will be set to the maximum length
 *        as  specified for the attribute while adding the characteristic.
 *        Values:
 *        - 0 ... 511
 * @param Value_Length Length of the attribute value in octets
 * @param Value Attribute value
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_srv_write_handle_value_nwk(uint16_t Attr_Handle,
                                               uint16_t Val_Offset,
                                               uint16_t Value_Length,
                                               uint8_t Value[]);
/**
 * @brief Deletes the specified characteristic from the service.
 * @param Char_Handle Handle of the characteristic which has to be deleted
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_srv_rm_char_nwk(uint16_t Char_Handle);
/**
 * @brief Deletes the specified service from the GATT server database.
 * @param Serv_Handle Handle of the service to be deleted
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_srv_rm_service_nwk(uint16_t Serv_Handle);
/**
 * @brief Deletes the include definition from the service.
 * @param Include_Handle Handle of the included service which has to be deleted
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_srv_rm_include_service_nwk(uint16_t Include_Handle);
/**
 * @brief Masks events from the GATT. The default configuration is all the
 *        events unmasked (enabled).
 * @param GATT_Evt_Mask GATT/ATT event mask.
 *        Values:
 *        - 0x00000001: ACI_GATT_ATTRIBUTE_MODIFIED_EVENT
 *        - 0x00000002: ACI_GATT_PROC_TIMEOUT_EVENT
 *        - 0x00000004: ACI_ATT_EXCHANGE_MTU_RESP_EVENT
 *        - 0x00000008: ACI_ATT_FIND_INFO_RESP_EVENT
 *        - 0x00000010: ACI_ATT_FIND_BY_TYPE_VALUE_RESP_EVENT
 *        - 0x00000020: ACI_ATT_READ_BY_TYPE_RESP_EVENT
 *        - 0x00000040: ACI_ATT_READ_RESP_EVENT
 *        - 0x00000080: ACI_ATT_READ_BLOB_RESP_EVENT
 *        - 0x00000100: ACI_ATT_READ_MULTIPLE_RESP_EVENT
 *        - 0x00000200: ACI_ATT_READ_BY_GROUP_TYPE_RESP_EVENT
 *        - 0x00000800: ACI_ATT_PREPARE_WRITE_RESP_EVENT
 *        - 0x00001000: ACI_ATT_EXEC_WRITE_RESP_EVENT
 *        - 0x00002000: ACI_GATT_INDICATION_EVENT
 *        - 0x00004000: ACI_GATT_NOTIFICATION_EVENT
 *        - 0x00008000: ACI_GATT_ERROR_RESP_EVENT
 *        - 0x00010000: ACI_GATT_PROC_COMPLETE_EVENT
 *        - 0x00020000: ACI_GATT_DISC_READ_CHAR_BY_UUID_RESP_EVENT
 *        - 0x00040000: ACI_GATT_TX_POOL_AVAILABLE_EVENT
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_set_event_mask(uint32_t GATT_Evt_Mask);
/**
 * @brief Performs an ATT MTU exchange procedure. When the ATT MTU exchange
 *        procedure is completed, a @ref aci_att_exchange_mtu_resp_event event
 *        is generated. A @ref aci_gatt_clt_proc_complete_event event is also
 *        generated to indicate the end of the procedure.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_clt_exchange_config(uint16_t Connection_Handle);
/**
 * @brief Sends a Prepare Write Request. The Prepare Write Request is used to
 *        request the server to prepare to write the value of an attribute.  The
 *        responses of the procedure are given through the @ref
 *        aci_att_clt_prepare_write_resp_event event.  The end of the procedure
 *        is indicated by a @ref aci_gatt_clt_proc_complete_event.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Attr_Handle Handle of the attribute to be written
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param Val_Offset The offset of the first octet to be written
 *        Values:
 *        - 0 ... 511
 * @param Attribute_Val_Length Length of attribute value (maximum value is
 *        ATT_MTU - 5).
 * @param Attribute_Val The value of the attribute to be written
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_clt_prepare_write_req(uint16_t Connection_Handle,
                                          uint16_t Attr_Handle,
                                          uint16_t Val_Offset,
                                          uint16_t Attribute_Val_Length,
                                          uint8_t Attribute_Val[]);
/**
 * @brief Sends an Execute Write Request. The Execute Write Request is used to
 *        request the server to write or cancel the write of all the prepared
 *        values currently held in the prepare queue from this client.  The
 *        result of the procedure is given through the @ref
 *        aci_att_clt_exec_write_resp_event event.  The end of the procedure is
 *        indicated by a @ref aci_gatt_clt_proc_complete_event event.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Execute Execute or cancel writes.
 *        Values:
 *        - 0x00: Cancel all prepared writes
 *        - 0x01: Immediately write all pending prepared values
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_clt_execute_write_req(uint16_t Connection_Handle,
                                          uint8_t Execute);
/**
 * @brief Starts the GATT client procedure to discover all primary services on
 *        the server. The responses of the procedure are given through the @ref
 *        aci_att_clt_read_by_group_type_resp_event event.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_clt_disc_all_primary_services(uint16_t Connection_Handle);
/**
 * @brief Starts the procedure to discover the primary services of the specified
 *        UUID on the server. The responses of the procedure are given through
 *        the @ref aci_att_clt_find_by_type_value_resp_event event. The end of
 *        the procedure is indicated by a @ref aci_gatt_clt_proc_complete_event
 *        event.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param UUID_Type UUID type.
 *        Values:
 *        - 0x01: 16-bit UUID
 *        - 0x02: 128-bit UUID
 * @param UUID See @ref UUID_t
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_clt_disc_primary_service_by_uuid(uint16_t Connection_Handle,
                                                     uint8_t UUID_Type,
                                                     UUID_t *UUID);
/**
 * @brief Starts the procedure to find all included services. The responses of
 *        the procedure are given through the @ref
 *        aci_att_clt_read_by_type_resp_event event. The end of the procedure is
 *        indicated by a @ref aci_gatt_clt_proc_complete_event event.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Start_Handle Start attribute handle of the service
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param End_Handle End attribute handle of the service
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_clt_find_included_services(uint16_t Connection_Handle,
                                               uint16_t Start_Handle,
                                               uint16_t End_Handle);
/**
 * @brief Starts the procedure to discover all the characteristics of a given
 *        service. When the procedure is completed, a @ref
 *        aci_gatt_clt_proc_complete_event event is generated. Before procedure
 *        completion the response packets are given through @ref
 *        aci_att_clt_read_by_type_resp_event event.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Start_Handle Start attribute handle of the service
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param End_Handle End attribute handle of the service
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_clt_disc_all_char_of_service(uint16_t Connection_Handle,
                                                 uint16_t Start_Handle,
                                                 uint16_t End_Handle);
/**
 * @brief Starts the procedure to discover all the characteristics specified by
 *        a UUID. When the procedure is completed, a @ref
 *        aci_gatt_clt_proc_complete_event event is generated. Before procedure
 *        completion the response packets are given through @ref
 *        aci_gatt_clt_disc_read_char_by_uuid_resp_event event.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Start_Handle Start attribute handle of the service
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param End_Handle End attribute handle of the service
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param UUID_Type UUID type.
 *        Values:
 *        - 0x01: 16-bit UUID
 *        - 0x02: 128-bit UUID
 * @param UUID See @ref UUID_t
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_clt_disc_char_by_uuid(uint16_t Connection_Handle,
                                          uint16_t Start_Handle,
                                          uint16_t End_Handle,
                                          uint8_t UUID_Type,
                                          UUID_t *UUID);
/**
 * @brief Starts the procedure to discover all characteristic descriptors on the
 *        server. When the procedure is completed, a @ref
 *        aci_gatt_clt_proc_complete_event event is generated. Before procedure
 *        completion the response packets are given through @ref
 *        aci_att_clt_find_info_resp_event event.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Char_Handle Handle of the characteristic value
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param End_Handle End handle of the characteristic
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_clt_disc_all_char_desc(uint16_t Connection_Handle,
                                           uint16_t Char_Handle,
                                           uint16_t End_Handle);
/**
 * @brief Starts the procedure to read an attribute value. When the procedure is
 *        completed, a @ref aci_gatt_clt_proc_complete_event event is generated.
 *        Before procedure completion the response packet is given through @ref
 *        aci_att_clt_read_resp_event event.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Attr_Handle Handle of the attribute to be read
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_clt_read(uint16_t Connection_Handle,
                             uint16_t Attr_Handle);
/**
 * @brief Starts the procedure to read all the characteristics specified by the
 *        UUID. When the procedure is completed, a @ref
 *        aci_gatt_clt_proc_complete_event event is generated. Before procedure
 *        completion the response packets are given through @ref
 *        aci_gatt_clt_disc_read_char_by_uuid_resp_event event.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Start_Handle Starting handle of the range to be searched
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param End_Handle End handle of the range to be searched
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param UUID_Type UUID type.
 *        Values:
 *        - 0x01: 16-bit UUID
 *        - 0x02: 128-bit UUID
 * @param UUID See @ref UUID_t
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_clt_read_using_char_uuid(uint16_t Connection_Handle,
                                             uint16_t Start_Handle,
                                             uint16_t End_Handle,
                                             uint8_t UUID_Type,
                                             UUID_t *UUID);
/**
 * @brief Starts the procedure to read a long attribute value. the procedure is
 *        completed, a @ref aci_gatt_clt_proc_complete_event event is generated.
 *        Before procedure completion the response packets are given through
 *        @ref aci_att_clt_read_blob_resp_event event.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Attr_Handle Handle of the attribute to be read
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param Val_Offset Offset from which the value needs to be read
 *        Values:
 *        - 0 ... 511
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_clt_read_long(uint16_t Connection_Handle,
                                  uint16_t Attr_Handle,
                                  uint16_t Val_Offset);
/**
 * @brief Starts a procedure to read multiple characteristic values from a
 *        server. This sub-procedure is used to read multiple Characteristic
 *        Values from a server when the client knows the Characteristic Value
 *        Handles. When the procedure is completed, a @ref
 *        aci_gatt_clt_proc_complete_event event is generated. Before procedure
 *        completion the response packets are given through @ref
 *        aci_att_clt_read_multiple_resp_event event.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Number_of_Handles The number of handles for which the value has to be
 *        read. From 2 to (ATT_MTU-1)/2
 *        Values:
 *        - 0x02 ... 0xFF
 * @param Handle_Entry See @ref Handle_Entry_t
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_clt_read_multiple_char_value(uint16_t Connection_Handle,
                                                 uint8_t Number_of_Handles,
                                                 Handle_Entry_t Handle_Entry[]);
/**
 * @brief Starts the procedure to write an attribute (characteristic value or
 *        descriptor). When the procedure is completed, a @ref
 *        aci_gatt_clt_proc_complete_event event is generated.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Attr_Handle Handle of the attribute to be written
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param Attribute_Val_Length Length of the value to be written
 * @param Attribute_Val Value to be written
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_clt_write_nwk(uint16_t Connection_Handle,
                                  uint16_t Attr_Handle,
                                  uint16_t Attribute_Val_Length,
                                  uint8_t Attribute_Val[]);
/**
 * @brief Starts the procedure to write a long attribute value (i.e. an
 *        attribute with a length greater than the current ATT MTU). When the
 *        procedure is completed, a @ref aci_gatt_clt_proc_complete_event event
 *        is generated. During the procedure, @ref
 *        aci_att_clt_prepare_write_resp_event and @ref
 *        aci_att_clt_exec_write_resp_event events are raised.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Attr_Handle Handle of the attribute to be written
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param Val_Offset Offset at which the attribute has to be written
 *        Values:
 *        - 0 ... 511
 * @param Attribute_Val_Length Length of the value to be written
 * @param Attribute_Val Value to be written
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_clt_write_long_nwk(uint16_t Connection_Handle,
                                       uint16_t Attr_Handle,
                                       uint16_t Val_Offset,
                                       uint16_t Attribute_Val_Length,
                                       uint8_t Attribute_Val[]);
/**
 * @brief Starts the procedure to write a characteristic reliably (a check is
 *        made on the written values). When the procedure is completed, a  @ref
 *        aci_gatt_clt_proc_complete_event event is generated. During the
 *        procedure, @ref aci_att_clt_prepare_write_resp_event and @ref
 *        aci_att_clt_exec_write_resp_event events are raised.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Attr_Handle Handle of the attribute to be written
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param Val_Offset Offset at which the attribute has to be written
 *        Values:
 *        - 0 ... 511
 * @param Attribute_Val_Length Length of the value to be written
 * @param Attribute_Val Value to be written
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_clt_write_char_reliable_nwk(uint16_t Connection_Handle,
                                                uint16_t Attr_Handle,
                                                uint16_t Val_Offset,
                                                uint16_t Attribute_Val_Length,
                                                uint8_t Attribute_Val[]);
/**
 * @brief Starts the procedure to write a characteristic value without waiting
 *        for any response from the server. No events are generated after this
 *        command is executed. Writing attributes using this function is not
 *        considered reliable by the standard: packets may be discarded by the
 *        peer if too many write commands are received.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Attr_Handle Handle of the attribute to be written
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param Attribute_Val_Length Length of the value to be written (maximum value
 *        is ATT_MTU - 3)
 * @param Attribute_Val Value to be written
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_clt_write_without_resp(uint16_t Connection_Handle,
                                           uint16_t Attr_Handle,
                                           uint16_t Attribute_Val_Length,
                                           uint8_t Attribute_Val[]);
/**
 * @brief Starts a signed write without response from the server. The procedure
 *        is used to write a characteristic value with an authentication
 *        signature without waiting for any response from the server. It cannot
 *        be used when the link is encrypted.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Attr_Handle Handle of the attribute to be written
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param Attribute_Val_Length Length of the value to be written (up to ATT_MTU
 *        - 13)
 * @param Attribute_Val Value to be written
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_clt_signed_write_without_resp(uint16_t Connection_Handle,
                                                  uint16_t Attr_Handle,
                                                  uint16_t Attribute_Val_Length,
                                                  uint8_t Attribute_Val[]);
/**
 * @brief Allow application to confirm indication. This command has to be sent
 *        when the application receives the event @ref
 *        aci_gatt_clt_indication_event.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_clt_confirm_indication(uint16_t Connection_Handle);
/**
 * @brief This command sets the security permission for the attribute handle
 *        specified. Currently the setting of security permission is allowed
 *        only for client characteristic configuration descriptor.
 * @param Attr_Handle Handle of the attribute whose security permission has to
 *        be modified
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param Security_Permissions Security permission flags.
 *        Flags:
 *        - 0x00
 *        - 0x01: AUTHEN_READ (Need authentication to read)
 *        - 0x04: ENCRY_READ (Need encryption to read)
 *        - 0x08: AUTHEN_WRITE (need authentication to write)
 *        - 0x20: ENCRY_WRITE (need encryption to write)
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_srv_set_security_permission_nwk(uint16_t Attr_Handle,
                                                    uint8_t Security_Permissions);
/**
 * @brief Reads the value of the attribute handle specified from the local GATT
 *        database. Client Characteristic Configuration Descriptor is not
 *        supported.
 * @param Attr_Handle Handle of the attribute to read
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param Offset Offset from which the value needs to be read
 *        Values:
 *        - 0 ... 511
 * @param Value_Length_Requested Maximum number of octets to be returned as
 *        attribute value
 *        Values:
 *        - 0 ... 512
 * @param[out] Length Length of the attribute value
 * @param[out] Value_Length Length in octets of the Value parameter
 * @param[out] Value Attribute value
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_srv_read_handle_value_nwk(uint16_t Attr_Handle,
                                              uint16_t Offset,
                                              uint16_t Value_Length_Requested,
                                              uint16_t *Length,
                                              uint16_t *Value_Length,
                                              uint8_t Value[]);
/**
 * @brief This command sets the access permission for the attribute handle
 *        specified.
 * @param Attr_Handle Handle of the attribute whose security permission has to
 *        be modified
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param Access_Permissions Access permission
 *        Values:
 *        - 0x00: None
 *        - 0x01: READ
 *        - 0x02: WRITE
 *        - 0x04: WRITE_NO_RESP
 *        - 0x08: SIGNED_WRITE
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_srv_set_access_permission_nwk(uint16_t Attr_Handle,
                                                  uint8_t Access_Permissions);
/**
 * @brief Send an indication or notification for the provided attribute handle.
 *        The Flags parameter indicate what kind of message will be sent: -)
 *        0x00 Send a notification -) 0x02 Send an indication
 * @param Connection_Handle Connection handle to be used to identify the
 *        connection with the peer device.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Attr_Handle Handle of the attribute to be notified
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param Flags Select the notification type.
 *        Values:
 *        - 0x00: GATT_NOTIFICATION
 *        - 0x02: GATT_INDICATION
 * @param Val_Length Length of the Val field.
 * @param Val
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_srv_notify(uint16_t Connection_Handle,
                               uint16_t Attr_Handle,
                               uint8_t Flags,
                               uint16_t Val_Length,
                               uint8_t Val[]);
/**
 * @brief Response to an aci_att_srv_exec_write_req_event.
 * @param Conn_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Exec If 1, allow execution of queued writes. If 0 flush all queued
 *        writes for the given connection handle.
 *        Values:
 *        - 0x00: FLUSH
 *        - 0x01: EXECUTE
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_srv_exec_write_resp_nwk(uint16_t Conn_Handle,
                                            uint8_t Exec);
/**
 * @brief This command should be sent when ACI_GATT_SRV_AUTHORIZE_NWK_EVENT is
 *        received.
 * @param Conn_Handle Connection handle to be used to identify the connection
 *        with the peer device.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Attr_Handle Offset from which the value needs to be read or write
 *        Values:
 *        - 0 ... 511
 * @param Operation_Type
 *        Values:
 *        - 0x00: Read
 *        - 0x10: Write Request
 *        - 0x11: Write Command or Signed Write Command
 *        - 0x12: Prepare Write Request
 * @param Error_Code Set to 0 if operation is authorized, otherwise Error_Code
 *        is the ATT error code that will be sent to the peer in reaponse to the
 *        request.
 *        Values:
 *        - 0: Authorize
 *        - 0 ... 255
 * @param Attr_Val_Offset Offset from which the attribute needs to be read or
 *        written. For a read operation it is always 0.
 *        Values:
 *        - 0 ... 511
 * @param Data_Length Length of Data field
 * @param Data The data that the client has requested to write.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_srv_authorize_resp_nwk(uint16_t Conn_Handle,
                                           uint16_t Attr_Handle,
                                           uint8_t Operation_Type,
                                           uint8_t Error_Code,
                                           uint16_t Attr_Val_Offset,
                                           uint16_t Data_Length,
                                           uint8_t Data[]);
/**
 * @brief Reads the content of the prepare write queue. This command should be
 *        used to atomically read all the queued write operations after a
 *        aci_att_srv_exec_write_req_event is received and before sending the
 *        aci_gatt_srv_exec_write_resp.
 * @param Conn_Handle Connection handle to be used to identify the connection
 *        with the peer device.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Item_Index The index of the entry in the queue for the selected
 *        connection handle.
 * @param[out] Attr_Handle The attribute handle of the returned entry.
 * @param[out] Value_Offset The offset from which the peer is requesting to
 *             start writing.
 * @param[out] Value_Length Length in octets of the Value parameter
 * @param[out] Value The value to be written.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_srv_read_prepare_queue_nwk(uint16_t Conn_Handle,
                                               uint8_t Item_Index,
                                               uint16_t *Attr_Handle,
                                               uint16_t *Value_Offset,
                                               uint16_t *Value_Length,
                                               uint8_t Value[]);
/**
 * @brief Updates an attribute value for that kind of attributes that have
 *        different values for each connection, i.e. the Client Characteristic
 *        Configuration Descriptors. WARNING: use of this function can affect
 *        interoperability. Do not use the function unless you are aware of what
 *        you are doing.
 * @param Connection_Handle Connection handle for which the attribute value will
 *        be written.
 * @param Attr_Handle Handle of the attribute
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param Value_Length Length of the attribute value in octets.
 * @param Value Attribute value.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_srv_write_multiple_instance_handle_value(uint16_t Connection_Handle,
                                                             uint16_t Attr_Handle,
                                                             uint16_t Value_Length,
                                                             uint8_t Value[]);
/**
 * @brief Read the value for that kind of attributes that have different values
 *        for each connection, i.e. the Client Characteristic Configuration
 *        Descriptors.
 * @param Connection_Handle Connection handle for which the attribute value will
 *        be read.
 * @param Attr_Handle Handle of the attribute
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param[out] Value_Length Length of the attribute value in octets.
 * @param[out] Value Attribute value.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_srv_read_multiple_instance_handle_value_nwk(uint16_t Connection_Handle,
                                                                uint16_t Attr_Handle,
                                                                uint16_t *Value_Length,
                                                                uint8_t Value[]);
/**
     * @}
     */
    #endif /* _BLUENRG_LP_GATT_ACI_H_ */
