

/**
  ******************************************************************************
  * @file    bluenrg_lp_gap_aci.h
  * @author  AMS - RF Application team
  * @date    26 April 2021
  * @brief   Header file for external uC - BlueNRG-x in network coprocessor mode (gap_aci)
  *          Autogenerated files, do not edit!!
  ******************************************************************************
  * @attention
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  *
  * <h2><center>&copy; COPYRIGHT STMicroelectronics</center></h2>
  ******************************************************************************
  */
#ifndef _BLUENRG_LP_GAP_ACI_H_
#define _BLUENRG_LP_GAP_ACI_H_

#include "bluenrg_lp_types.h"
#include "bluenrg_lp_hci_le.h"

/** Documentation for C struct Bonded_Device_Entry_t */
typedef struct Bonded_Device_Entry_t_s {
  /** Address type.
   *  Values:
   *  - 0x00: Public Device Address
   *  - 0x01: Random Device Address
   */
  uint8_t Address_Type;
  /** Identity Address (Public or Random) of the device.
   */
  uint8_t Address[6];
} Bonded_Device_Entry_t;

/** Documentation for C struct List_Entry_t */
typedef struct List_Entry_t_s {
  /** Address type.
   *  Values:
   *  - 0x00: Public Device Address
   *  - 0x01: Random Device Address
   */
  uint8_t Peer_Address_Type;
  /** Public Device Address or Random Device Address of the device to be added to the
   *  list.
   */
  uint8_t Peer_Address[6];
} List_Entry_t;
/**
 * @brief Set the IO capabilities of the device. This command has to be given
 *        only when the device is not in a connected state.
 * @param IO_Capability IO capability of the device.
 *        Values:
 *        - 0x00: IO_CAP_DISPLAY_ONLY
 *        - 0x01: IO_CAP_DISPLAY_YES_NO
 *        - 0x02: IO_CAP_KEYBOARD_ONLY
 *        - 0x03: IO_CAP_NO_INPUT_NO_OUTPUT
 *        - 0x04: IO_CAP_KEYBOARD_DISPLAY
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_set_io_capability(uint8_t IO_Capability);
/**
 * @brief Set the authentication requirements for the device. If the command is
 *        given during pairing, the command returns  BLE_STATUS_NOT_ALLOWED.
 * @param Bonding_Mode Bonding mode. Only if bonding is enabled (0x01), the
 *        bonding information is stored in flash
 *        Values:
 *        - 0x00: NO_BONDING
 *        - 0x01: BONDING
 * @param MITM_Mode MITM mode.
 *        Values:
 *        - 0x00: MITM_PROTECTION_NOT_REQUIRED
 *        - 0x01: MITM_PROTECTION_REQUIRED
 * @param SC_Support LE Secure connections support. - 0x00: Secure Connections
 *        Pairing not supported - 0x01: Secure Connections Pairing supported but
 *        optional - 0x02: Secure Connections Pairing supported and mandatory
 *        (SC Only Mode)
 *        Values:
 *        - 0x00: SC_IS_NOT_SUPPORTED
 *        - 0x01: SC_IS_SUPPORTED
 *        - 0x02: SC_IS_MANDATORY
 * @param KeyPress_Notification_Support Keypress notification support
 *        Values:
 *        - 0x00: KEYPRESS_IS_NOT_SUPPORTED
 *        - 0x01: KEYPRESS_IS_SUPPORTED
 * @param Min_Encryption_Key_Size Minimum encryption key size to be used during
 *        pairing
 *        Values:
 *        - 7 ... 16
 * @param Max_Encryption_Key_Size Maximum encryption key size to be used during
 *        pairing
 *        Values:
 *        - 7 ... 16
 * @param Use_Fixed_Pin Use or not fixed pin. If set to 0x00, then during the
 *        pairing process the application will not be requested for a pin
 *        (Fixed_Pin will be used). If set to 0x01, then during pairing process
 *        if a passkey is required the application will be notified
 *        Values:
 *        - 0x00: USE_FIXED_PIN_FOR_PAIRING
 *        - 0x01: DONOT_USE_FIXED_PIN_FOR_PAIRING
 * @param Fixed_Pin Fixed pin to be used during pairing if MIMT protection is
 *        enabled. Any random value between 0 to 999999
 *        Values:
 *        - 0 ... 999999
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_set_authentication_requirement(uint8_t Bonding_Mode,
                                                  uint8_t MITM_Mode,
                                                  uint8_t SC_Support,
                                                  uint8_t KeyPress_Notification_Support,
                                                  uint8_t Min_Encryption_Key_Size,
                                                  uint8_t Max_Encryption_Key_Size,
                                                  uint8_t Use_Fixed_Pin,
                                                  uint32_t Fixed_Pin);
/**
 * @brief Set the authorization requirements of the device. This command has to
 *        be given when connected to a device if authorization is required to
 *        access services which require authorization. DEPRECATED API (still
 *        supported but not recommended)
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Authorization_Enable Enable the authorization in the device and when a
 *        remote device tries to read/write a characteristic with authorization
 *        requirements, the stack will send back an error response with
 *        "Insufficient authorization" error code. After pairing is complete a
 *        ACI_GAP_AUTHORIZATION_REQ_EVENT will be sent to the Host.
 *        Values:
 *        - 0x00: AUTHORIZATION_NOT_REQUIRED
 *        - 0x01: AUTHORIZATION_REQUIRED
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_set_authorization_requirement(uint16_t Connection_Handle,
                                                 uint8_t Authorization_Enable);
/**
 * @brief This command should be send by the host in response to @ref
 *        aci_gap_pass_key_req_event event. The command parameter contains the
 *        pass key which will be used during the pairing process.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Pass_Key Pass key that will be used during the pairing process.  Must
 *        be a six-digit decimal number.
 *        Values:
 *        - 0 ... 999999
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_pass_key_resp(uint16_t Connection_Handle,
                                 uint32_t Pass_Key);
/**
 * @brief Authorize a device to access attributes. This command should be send
 *        by the host in response to @ref aci_gap_authorization_req_event event.
 *        DEPRECATED API (still supported but not recommended)
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Authorize Authorization response.
 *        Values:
 *        - 0x01: Authorize
 *        - 0x02: Reject
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_authorization_resp(uint16_t Connection_Handle,
                                      uint8_t Authorize);
/**
 * @brief Initialize the GAP layer. Register the GAP service with the GATT.
 *        Depending on the role, presence of standard GAP characteristics will
 *        be checked (Device Name, Appearance, Peripheral Preferred Connection
 *        Parameters).  WARNING: A section of the Flash memory is used by this
 *        procedure. When this section is empty, data are written inside. This
 *        normally happens once during the lifetime of the device, when the
 *        command is executed for the first time (unless the section is erased).
 *        Do not power off the device while this function is writing into Flash
 *        memory.
 * @param Role Bitmap of allowed roles.
 *        Flags:
 *        - 0x01: Peripheral
 *        - 0x02: Broadcaster
 *        - 0x04: Central
 *        - 0x08: Observer
 * @param Privacy_Type Specify if privacy is enabled or not and which one .
 *        Values:
 *        - 0x00: Privacy disabled
 *        - 0x01: Privacy host enabled
 *        - 0x02: Privacy controller enabled
 * @param Device_Name_Char_Len Length of the device name characteristic
 *        Values:
 *        - 0 ... 248
 * @param Identity_Address_Type Specify which address has to be used as Identity
 *        Address. 0x00: The public address is used as identity address 0x01:
 *        The static random address is used as identity address
 *        Values:
 *        - 0x00: Public Address
 *        - 0x01: Static Random Address
 * @param[out] Service_Handle Handle of the GAP service
 * @param[out] Dev_Name_Char_Handle Device Name Characteristic handle
 * @param[out] Appearance_Char_Handle Appearance Characteristic handle
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_init(uint8_t Role,
                        uint8_t Privacy_Type,
                        uint8_t Device_Name_Char_Len,
                        uint8_t Identity_Address_Type,
                        uint16_t *Service_Handle,
                        uint16_t *Dev_Name_Char_Handle,
                        uint16_t *Appearance_Char_Handle);
/**
 * @brief Send a slave security request to the master. This command has to be
 *        issued to notify the master of the security requirements of the slave.
 *        The master may encrypt the link, initiate the pairing procedure, or
 *        reject the request.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_slave_security_req(uint16_t Connection_Handle);
/**
 * @brief This command can be used to get the current security settings of the
 *        device.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param[out] Security_Mode Security mode.
 *             Values:
 *             - 0x01: Security Mode 1
 *             - 0x02: Security Mode 2
 * @param[out] Security_Level Security Level.
 *             Values:
 *             - 0x01: Security Level 1
 *             - 0x02: Security Level 2
 *             - 0x03: Security Level 3
 *             - 0x04: Security Level 4
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_get_security_level(uint16_t Connection_Handle,
                                      uint8_t *Security_Mode,
                                      uint8_t *Security_Level);
/**
 * @brief It allows masking events from the GAP. The default configuration is
 *        all the events masked.
 * @param GAP_Evt_Mask GAP event mask. Default: 0xFFFF.
 *        Flags:
 *        - 0x0000: No events
 *        - 0x0001: ACI_GAP_LIMITED_DISCOVERABLE_EVENT
 *        - 0x0002: ACI_GAP_PAIRING_COMPLETE_EVENT
 *        - 0x0004: ACI_GAP_PASS_KEY_REQ_EVENT
 *        - 0x0008: ACI_GAP_AUTHORIZATION_REQ_EVENT
 *        - 0x0010: ACI_GAP_SLAVE_SECURITY_INITIATED_EVENT
 *        - 0x0020: ACI_GAP_BOND_LOST_EVENT
 *        - 0x0080: ACI_GAP_PROC_COMPLETE_EVENT
 *        - 0x0100: ACI_L2CAP_CONNECTION_UPDATE_REQ_EVENT
 *        - 0x0200: ACI_L2CAP_CONNECTION_UPDATE_RESP_EVENT
 *        - 0x0400: ACI_L2CAP_PROC_TIMEOUT_EVENT
 *        - 0x0800: ACI_GAP_ADDR_NOT_RESOLVED_EVENT
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_set_event_mask(uint16_t GAP_Evt_Mask);
/**
 * @brief Command the controller to terminate the connection. A @ref
 *        hci_disconnection_complete_event event will be generated when the link
 *        is disconnected. It is important to leave an 100 ms blank window
 *        before sending any new command (including system hardware reset),
 *        since immediately after @ref hci_disconnection_complete_event event,
 *        system could save important information in non volatile memory.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Reason The reason for ending the connection.
 *        Values:
 *        - 0x05: Authentication Failure
 *        - 0x13: Remote User Terminated Connection
 *        - 0x14: Remote Device Terminated Connection due to Low Resources
 *        - 0x15: Remote Device Terminated Connection due to Power Off
 *        - 0x1A: Unsupported Remote Feature
 *        - 0x3B: Unacceptable Connection Parameters
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_terminate(uint16_t Connection_Handle,
                             uint8_t Reason);
/**
 * @brief Clear the security database. All the devices in the security database
 *        will be removed. ATTENTION: It is strongly recommended not to give
 *        this command during intense radio activity (e.g. during advertising or
 *        connection with short intervals, i.e. less than 30 ms, or during
 *        scanning), since it will trigger an erase of a Flash sector.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_clear_security_db(void);
/**
 * @brief Allows the security manager to complete the pairing procedure and re-
 *        bond with the master. This command should be given by the application
 *        when it receives the ACI_GAP_BOND_LOST_EVENT if it wants the re-
 *        bonding to happen successfully. If this command is not given on
 *        receiving the event, the bonding procedure will timeout.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_allow_rebond(uint16_t Connection_Handle);
/**
 * @brief Creates a direct connection to a device.
 * @param Initiating_PHY PHYs that will be used for initiating the connection.
 *        Flags:
 *        - 0x01: LE_1M_PHY_BIT
 *        - 0x04: LE_CODED_PHY_BIT
 * @param Peer_Address_Type The Peer_Address_Type parameter indicates the type
 *        of address used in the connectable advertisement sent by the peer. 0:
 *        Public Device Address or Public Identity Address 1: Random Device
 *        Address or Random (static) Identity Address
 *        Values:
 *        - 0x00: Public Address
 *        - 0x01: Random Address
 * @param Peer_Address Public Device Address, Random Device Address, Public
 *        Identity Address, or Random (static) Identity Address of the device to
 *        be connected.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_create_connection(uint8_t Initiating_PHY,
                                     uint8_t Peer_Address_Type,
                                     uint8_t Peer_Address[6]);
/**
 * @brief Terminate the specified GAP procedure. An @ref
 *        aci_gap_proc_complete_event event is generated when the procedure has
 *        been completed, with the procedure code set to the corresponding
 *        procedure.
 * @param Procedure_Code Code identifying the procedure.
 *        Values:
 *        - 0x00: GAP_LIMITED_DISCOVERY_PROC
 *        - 0x01: GAP_GENERAL_DISCOVERY_PROC
 *        - 0x02: GAP_AUTO_CONNECTION_ESTABLISHMENT_PROC
 *        - 0x03: GAP_GENERAL_CONNECTION_ESTABLISHMENT_PROC
 *        - 0x04: GAP_SELECTIVE_CONNECTION_ESTABLISHMENT_PROC
 *        - 0x05: GAP_OBSERVATION_PROC
 *        - 0x06: GAP_DIRECT_CONNECTION_ESTABLISHMENT_PROC
 *        - 0x07: GAP_NAME_DISCOVERY_PROC
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_terminate_proc(uint8_t Procedure_Code);
/**
 * @brief Start the connection update procedure (only when role is Master). A
 *        @ref hci_le_connection_update is called. On completion of the
 *        procedure, an @ref hci_le_connection_update_complete_event event is
 *        returned to the upper layer.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Conn_Interval_Min Minimum value for the connection event interval.
 *        This shall be less than or equal to Conn_Interval_Max. Time = N * 1.25
 *        msec.
 *        Values:
 *        - 0x0006 (7.50 ms)  ... 0x0C80 (4000.00 ms) 
 * @param Conn_Interval_Max Maximum value for the connection event interval.
 *        This shall be greater than or equal to Conn_Interval_Min. Time = N *
 *        1.25 msec.
 *        Values:
 *        - 0x0006 (7.50 ms)  ... 0x0C80 (4000.00 ms) 
 * @param Conn_Latency Slave latency for the connection in number of connection
 *        events.
 *        Values:
 *        - 0x0000 ... 0x01F3
 * @param Supervision_Timeout Supervision timeout for the LE Link. It shall be a
 *        multiple of 10 ms and larger than (1 + connSlaveLatency) *
 *        connInterval * 2. Time = N * 10 msec.
 *        Values:
 *        - 0x000A (100 ms)  ... 0x0C80 (32000 ms) 
 * @param Minimum_CE_Length Information parameter about the minimum length of
 *        connection needed for this LE connection. Time = N * 0.625 msec.
 * @param Maximum_CE_Length Information parameter about the maximum length of
 *        connection needed for this LE connection. Time = N * 0.625 msec.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_start_connection_update(uint16_t Connection_Handle,
                                           uint16_t Conn_Interval_Min,
                                           uint16_t Conn_Interval_Max,
                                           uint16_t Conn_Latency,
                                           uint16_t Supervision_Timeout,
                                           uint16_t Minimum_CE_Length,
                                           uint16_t Maximum_CE_Length);
/**
 * @brief Send the SM pairing request to start a pairing process. The
 *        authentication requirements and IO capabilities should be set before
 *        issuing this command using the @ref aci_gap_set_io_capability and @ref
 *        aci_gap_set_authentication_requirement commands. A @ref
 *        aci_gap_pairing_complete_event event is returned after the pairing
 *        process is completed.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Force_Rebond If 1, Pairing request will be sent even if the device was
 *        previously bonded,  otherwise pairing request is not sent.
 *        Values:
 *        - 0x00: NO
 *        - 0x01: YES
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_send_pairing_req(uint16_t Connection_Handle,
                                    uint8_t Force_Rebond);
/**
 * @brief This command tries to resolve the address provided with the IRKs
 *        present in its database. If the address is resolved successfully with
 *        any one of the IRKs present in the database, it returns success and
 *        also the corresponding public/static random address stored with the
 *        IRK in the database.
 * @param Address Address to be resolved
 * @param[out] Actual_Address The public or static random address of the peer
 *             device, distributed during pairing phase.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_resolve_private_addr(uint8_t Address[6],
                                        uint8_t Actual_Address[6]);
/**
 * @brief This command returns the identity addresses of the bonded devices.
 * @param Offset Index of the first record to be returned.
 * @param Max_Num_Of_Addresses Used to specify the maximum number of devices to
 *        be returned.
 * @param[out] Num_of_Addresses The number of bonded devices returned by this
 *             command.
 * @param[out] Bonded_Device_Entry See @ref Bonded_Device_Entry_t
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_get_bonded_devices(uint8_t Offset,
                                      uint8_t Max_Num_Of_Addresses,
                                      uint8_t *Num_of_Addresses,
                                      Bonded_Device_Entry_t Bonded_Device_Entry[]);
/**
 * @brief The command finds whether the device, whose address is specified in
 *        the command, is bonded. If the device is using a resolvable private
 *        address and it has been bonded, then the command will return
 *        BLE_STATUS_SUCCESS.
 * @param Peer_Address_Type Address type.
 *        Values:
 *        - 0x00: Public Device Address
 *        - 0x01: Random Device Address
 * @param Peer_Address Address used by the peer device while advertising
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_is_device_bonded(uint8_t Peer_Address_Type,
                                    uint8_t Peer_Address[6]);
/**
 * @brief This command allows the User to validate/confirm or not the Numeric
 *        Comparison value showed through the
 *        ACI_GAP_Numeric_Comparison_Value_Event.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Confirm_Yes_No 0 : The Numeric Values showed on both local and peer
 *        device are different! 1 : The Numeric Values showed on both local and
 *        peer device are equal!
 *        Values:
 *        - 0x00: No
 *        - 0x01: YES
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_numeric_comparison_value_confirm_yesno(uint16_t Connection_Handle,
                                                          uint8_t Confirm_Yes_No);
/**
 * @brief This command permits to signal to the Stack the input type detected
 *        during Passkey input.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Input_Type Passkey input type detected
 *        Values:
 *        - 0x00: Passkey entry started
 *        - 0x01: Passkey digit entered
 *        - 0x02: Passkey digit erased
 *        - 0x03: Passkey cleared
 *        - 0x04: Passkey entry completed
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_passkey_input(uint16_t Connection_Handle,
                                 uint8_t Input_Type);
/**
 * @brief This command is sent by the User to get (i.e. to extract from the
 *        Stack) the OOB data generated by the Stack itself. In a complete
 *        system (i.e. having an OOB channel fully handled) this command should
 *        be invoked by the OOB Channel manager to require the local OOB data
 *        (hence without user interaction) to be sent via OOB to the remote peer
 *        candidate device. The requested OOB data are returned in response to
 *        the incoming command. The OOB data are not generated on the fly, but
 *        they are already available in the Stack.
 * @param OOB_Data_Type OOB Data type. - 0x00: Legacy Privacy (LP) v.4.1 TK
 *        (Temporary Key) - 0x01: Secure Connections (SC) v.4.2 Random value r
 *        used for generation of Confirm - 0x02: Secure Connections (SC) v.4.2
 *        Confirm value C generated through AES-CMAC-128 based cryptographic
 *        function: C=f4(PKx, PKx, r, 0)
 *        Values:
 *        - 0x00: SM_TK
 *        - 0x01: SM_RANDOM_VALUE
 *        - 0x02: SM_CONFIRM_VALUE
 * @param[out] Address_Type Identity address type.
 *             Values:
 *             - 0x00: Public Identity Address
 *             - 0x01: Random (static) Identity Address
 * @param[out] Address Public or Random (static) address of this  device
 * @param[out] OOB_Data_Len Length of OOB Data carried by next data field
 * @param[out] OOB_Data OOB Data to be exported via OOB.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_get_oob_data(uint8_t OOB_Data_Type,
                                uint8_t *Address_Type,
                                uint8_t Address[6],
                                uint8_t *OOB_Data_Len,
                                uint8_t OOB_Data[16]);
/**
 * @brief This command is sent (by the User) to input the OOB data arrived via
 *        OOB communication. It may be sent to set either the OOB Authentication
 *        data of the Local device, or the data received via OOB by the Remote
 *        peer candidate device. It can be used with OOB_Data_Len set to 0 to
 *        generate OOB authentication data for Secure Connections. In a complete
 *        system (i.e. having an OOB channel fully handled) this command should
 *        be invoked by the OOB Channel manager when receiving the OOB data
 *        (hence without user interaction). Since the BLE stack v 2.x
 *        implementation supports just one entry for the Remote peer candidate
 *        list containing the OOB data, at every command invocation the data
 *        existing in that entry are overwritten.
 * @param Device_Type OOB Device type:  - 0x00: The Address information are
 *        ignored.    - OOB_Data_Len= 0x00: this triggers the automatic
 *        regeneration of OOB Authentication data (for Secure Connections only;
 *        a ECDH-Public Key must).    - OOB_Data_Len in [0..16]: the OOB_Data
 *        carried by the command will overwrite the current local Authentication
 *        OOB Data.  - 0x01: The Address information is used to search the entry
 *        of the Remote peer candidate list containing the OOB data for that
 *        specific remote device; if no entry exists, the a new entry is used,
 *        if available (current implementation supports just 1 entry in this
 *        list).    - OOB_Data_Len in [0..16]: the OOB_Data carried by the
 *        command overwrites (if present) the remote Authentication OOB Data.
 *        Values:
 *        - 0x00: Local device
 *        - 0x01: Remote device
 * @param Address_Type Identity address type.
 *        Values:
 *        - 0x00: Public Identity Address
 *        - 0x01: Random (static) Identity Address
 * @param Address Public or Random (static) address of the peer device
 * @param OOB_Data_Type OOB Data type. - 0x00: Legacy Privacy (LP) v.4.1 TK
 *        (Temporary Key) - 0x01: Secure Connections (SC) v.4.2 Random value r
 *        used for generation of Confirm - 0x02: Secure Connections (SC) v.4.2
 *        Confirm value C generated through AES-CMAC-128 based cryptographic
 *        function: C=f4(PKx, PKx, r, 0)
 *        Values:
 *        - 0x00: SM_TK
 *        - 0x01: SM_RANDOM_VALUE
 *        - 0x02: SM_CONFIRM_VALUE
 * @param OOB_Data_Len Length of OOB Data carried by next data field
 *        Values:
 *        - 0x00 ... 0x10
 * @param OOB_Data OOB Data to be exported via OOB.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_set_oob_data(uint8_t Device_Type,
                                uint8_t Address_Type,
                                uint8_t Address[6],
                                uint8_t OOB_Data_Type,
                                uint8_t OOB_Data_Len,
                                uint8_t OOB_Data[16]);
/**
 * @brief This command can be used to remove a specified device from the bonding
 *        table.
 * @param Peer_Identity_Address_Type Identity address type.
 *        Values:
 *        - 0x00: Public Identity Address
 *        - 0x01: Random (static) Identity Address
 * @param Peer_Identity_Address Public or Random (static) Identity address of
 *        the peer device
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_remove_bonded_device(uint8_t Peer_Identity_Address_Type,
                                        uint8_t Peer_Identity_Address[6]);
/**
 * @brief This commands configures the advertising parameters for the legacy
 *        advertising or for a given extended advertising set.
 * @param Advertising_Handle Used to identify an advertising set. This parameter
 *        is only meaningful if Extended Advertising Feature is enabled.
 *        Values:
 *        - 0x00 ... 0xEF
 * @param Discoverable_Mode Specifies the discoverable mode of the device.
 *        Values:
 *        - 0: Not Discoverable
 *        - 1: Limited Discoverable
 *        - 2: General Discoverable
 *        - 3: Broadcast
 * @param Advertising_Event_Properties The Advertising_Event_Properties
 *        parameter describes the type of advertising event that is being
 *        configured and its basic properties according to V5.1, Vol 2, Part E,
 *        section 7.8.53.
 *        Flags:
 *        - 0x0001: Connectable
 *        - 0x0002: Scannable
 *        - 0x0004: Directed
 *        - 0x0008: High Duty Cycle Directed Connectable
 *        - 0x0010: Legacy
 *        - 0x0020: Anonymous
 *        - 0x0040: Include TX Power
 * @param Primary_Advertising_Interval_Min Minimum advertising interval for
 *        undirected and low duty cycle directed advertising. Time = N * 0.625
 *        msec.
 *        Values:
 *        - 0x00000020 (20.000 ms)  ... 0x00FFFFFF (10485759.375 ms) 
 * @param Primary_Advertising_Interval_Max Maximum advertising interval for
 *        undirected and low duty cycle directed advertising. Time = N * 0.625
 *        msec.
 *        Values:
 *        - 0x00000020 (20.000 ms)  ... 0x00FFFFFF (10485759.375 ms) 
 * @param Primary_Advertising_Channel_Map It is a bit field that indicates the
 *        advertising channels that shall be used when transmitting advertising
 *        packets.
 *        Flags:
 *        - 0x01: CH_37
 *        - 0x02: CH_38
 *        - 0x04: CH_39
 * @param Peer_Address_Type The peer address type.
 *        Values:
 *        - 0x00: Public
 *        - 0x01: Random
 * @param Peer_Address Public Device Address, Random Device Address, Public
 *        Identity Address, or Random (static) Identity Address of the device to
 *        be connected.
 * @param Advertising_Filter_Policy Advertising Filter Policy. If Directed
 *        advertising is selected, the Peer_Address_Type and Peer_Address shall
 *        be valid and the Advertising_Filter_Policy parameter shall be ignored.
 *        0x00 Process scan and connection requests from all devices (i.e., the
 *        White List is not in use) 0x01 Process connection requests from all
 *        devices and scan requests only from devices that are in the White List
 *        0x02 Process scan requests from all devices and connection requests
 *        only from devices that are in the White List. 0x03 Process scan and
 *        connection requests only from devices in the White List. All other
 *        values Reserved for future use
 *        Values:
 *        - 0x00: Scan and Connection requests from any
 *        - 0x01: Connection requests from any, scan requests from White List only
 *        - 0x02: Scan requests from any, connection requests from White List only
 *        - 0x03: Scan and connection requests from White
List only
 * @param Advertising_Tx_Power The Advertising_Tx_Power parameter indicates the
 *        maximum power level at which the advertising packets are to be
 *        transmitted on the advertising channels. The Controller shall choose a
 *        power level lower than or equal to the one specified by the Host.
 *        (Units: dBm). This parameter is ignored if extended advertising is not
 *        enabled.
 *        Values:
 *        - 127: No preference
 *        - -127 ... 126
 * @param Primary_Advertising_PHY The Primary_Advertising_PHY parameter
 *        indicates the PHY on which the advertising packets are transmitted on
 *        the primary advertising channel. If legacy advertising PDUs are being
 *        used, the Primary_Advertising_PHY shall indicate the LE 1M PHY. This
 *        parameter is ignored if extended advertising is not enabled.
 *        Values:
 *        - 0x01: LE_1M_PHY
 *        - 0x03: LE_CODED_PHY
 * @param Secondary_Advertising_Max_Skip The Secondary_Advertising_Max_Skip
 *        parameter is the maximum number of advertising events that can be
 *        skipped before the AUX_ADV_IND can be sent. This parameter is ignored
 *        if extended advertising is not enabled. 0x00 AUX_ADV_IND shall be sent
 *        prior to the next advertising event 0x01-0xFF Maximum advertising
 *        events the Controller can skip before sending the AUX_ADV_IND packets
 *        on the secondary advertising channel
 * @param Secondary_Advertising_PHY The Secondary_Advertising_PHY parameter
 *        indicates the PHY on which the advertising packets are be transmitted
 *        on the secondary advertising channel. This parameter is ignored if
 *        extended advertising is not enabled.
 *        Values:
 *        - 0x01: LE_1M_PHY
 *        - 0x02: LE_2M_PHY
 *        - 0x03: LE_CODED_PHY
 * @param Advertising_SID The Advertising_SID parameter specifies the value to
 *        be transmitted in the Advertising SID subfield of the ADI field of the
 *        Extended Header of those advertising channel PDUs that have an ADI
 *        field. If the advertising set only uses PDUs that do not contain an
 *        ADI field, Advertising_SID is ignored. This parameter is ignored if
 *        extended advertising is not enabled.
 *        Values:
 *        - 0x00 ... 0x0F
 * @param Scan_Request_Notification_Enable The Scan_Request_Notification_Enable
 *        parameter indicates whether the Controller shall send notifications
 *        upon the receipt of a scan request PDU that is in response to an
 *        advertisement from the specified advertising set that contains its
 *        device address and is from a scanner that is allowed by the
 *        advertising filter policy. This parameter is ignored if extended
 *        advertising is not enabled.
 *        Values:
 *        - 0x00: Scan request notifications disabled
 *        - 0x01: Scan request notifications enabled
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_set_advertising_configuration(uint8_t Advertising_Handle,
                                                 uint8_t Discoverable_Mode,
                                                 uint16_t Advertising_Event_Properties,
                                                 uint32_t Primary_Advertising_Interval_Min,
                                                 uint32_t Primary_Advertising_Interval_Max,
                                                 uint8_t Primary_Advertising_Channel_Map,
                                                 uint8_t Peer_Address_Type,
                                                 uint8_t Peer_Address[6],
                                                 uint8_t Advertising_Filter_Policy,
                                                 int8_t Advertising_Tx_Power,
                                                 uint8_t Primary_Advertising_PHY,
                                                 uint8_t Secondary_Advertising_Max_Skip,
                                                 uint8_t Secondary_Advertising_PHY,
                                                 uint8_t Advertising_SID,
                                                 uint8_t Scan_Request_Notification_Enable);
/**
 * @brief The LE_Set_Extended_Advertising_Enable command is used to request the
 *        Controller to enable or disable one or more advertising sets using the
 *        advertising sets identified by the Advertising_Handle[i] parameter.
 *        The Controller manages the timing of advertisements in accordance with
 *        the advertising parameters given in the
 *        LE_Set_Extended_Advertising_Parameters command. Only Enable parameter
 *        is used if extended advertising feature is disabled through modular
 *        configuration (CONTROLLER_EXT_ADV_SCAN_ENABLED=0).
 * @param Enable It allows to enable or disable one or more advertising sets
 *        using the advertising sets identified by the Advertising_Handle[i]
 *        parameter.
 *        Values:
 *        - 0x00: Disable
 *        - 0x01: Enable
 * @param Number_of_Sets The Number_of_Sets parameter is the number of
 *        advertising sets contained in the parameter arrays. 0x00: Disable all
 *        advertising sets 0x01 to 0x3F: Number of advertising sets to enable or
 *        disable. Ignored if extended advertising feature is disabled through
 *        modular configuration (CONTROLLER_EXT_ADV_SCAN_ENABLED=0).
 *        Values:
 *        - 0x00: Disable all sets
 *        - 0x01 ... 0x3F
 * @param Advertising_Set_Parameters See @ref Advertising_Set_Parameters_t
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_set_advertising_enable(uint8_t Enable,
                                          uint8_t Number_of_Sets,
                                          Advertising_Set_Parameters_t Advertising_Set_Parameters[]);
/**
 * @brief The ACI_GAP_SET_ADVERTISING_DATA_NWK function is used to set the data
 *        in advertising PDUs.  If the device is in Limited Discoverable Mode,
 *        Flags data type in advertising data must have the flags set as
 *        described: - The LE Limited Discoverable Mode flag set to one. - The
 *        'BR/EDR Not Supported' flag set to one. - All other flags set to zero.
 *        If the device is in General Discoverable Mode, Flags data type in
 *        advertising data must have the flags set as described: - The LE
 *        General Discoverable Mode flag set to one. - The 'BR/EDR Not
 *        Supported' flag set to one. - All other flags set to zero.  If the
 *        device is in one of the other modes, Flags data type in advertising
 *        data must have the flags set as described: - The 'BR/EDR Not
 *        Supported' flag set to one. - All other flags set to zero.  If a
 *        device is sending non connectable events, Flags data type may be
 *        omitted, otherwise it must be present.
 * @param Advertising_Handle Used to identify an advertising set. This parameter
 *        is only meaningful if Extended Advertising Feature is enabled.
 *        Values:
 *        - 0x00 ... 0xEF
 * @param Operation The Host may set the advertising data in one or more
 *        operations using this parameter. 0x00: Intermediate fragment of
 *        fragmented extended advertising data 0x01: First fragment of
 *        fragmented extended advertising data 0x02: Last fragment of fragmented
 *        extended advertising data 0x03: Complete extended advertising data
 *        0x04: Unchanged data (just update the Advertising DID) All other
 *        values: Reserved for future use
 *        Values:
 *        - 0x00: Intermediate fragment
 *        - 0x01: First fragment
 *        - 0x02: Last fragment
 *        - 0x03: Complete data
 *        - 0x04: Unchanged data
 * @param Advertising_Data_Length Length of advertising data. For legacy PDUs
 *        which supports advertising data maximum value is 31 octets.
 *        Values:
 *        - 0 ... 251
 * @param Advertising_Data Advertising data, that must be properly formatted
 *        (see Core v5.1 Vol 3, part C, chapter 11).
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_set_advertising_data_nwk(uint8_t Advertising_Handle,
                                            uint8_t Operation,
                                            uint8_t Advertising_Data_Length,
                                            uint8_t Advertising_Data[]);
/**
 * @brief The ACI_GAP_SET_SCAN_RESPONSE_DATA function configures the scan
 *        response data as requested by the application.
 * @param Advertising_Handle Used to identify an advertising set. This parameter
 *        is only meaningful if Extended Advertising Feature is enabled.
 *        Values:
 *        - 0x00 ... 0xEF
 * @param Operation The Host may set the scan response data in one or more
 *        operations using the Operation parameter in the command. 0x00:
 *        Intermediate fragment of fragmented scan response data 0x01: First
 *        fragment of fragmented scan response data 0x02: Last fragment of
 *        fragmented scan response data 0x03: Complete scan response data All
 *        other values: Reserved for future use
 *        Values:
 *        - 0x00: Intermediate fragment
 *        - 0x01: First fragment
 *        - 0x02: Last fragment
 *        - 0x03: Complete data
 * @param Scan_Response_Data_Length Length of scan response data. If the
 *        advertising set uses scannable legacy advertising PDUs maximum length
 *        is 31 octets.
 *        Values:
 *        - 0 ... 251
 * @param Scan_Response_Data Scan response data, that must be properly formatted
 *        (see Core v5.1 Vol 3, part C, chapter 11).
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_set_scan_response_data_nwk(uint8_t Advertising_Handle,
                                              uint8_t Operation,
                                              uint8_t Scan_Response_Data_Length,
                                              uint8_t Scan_Response_Data[]);
/**
 * @brief The ACI_GAP_SET_SCAN_CONFIGURATION function configures the scan
 *        parameters for a given PHY. To configure more than one PHY, this
 *        function must be called more times.
 * @param Filter_Duplicates The Filter_Duplicates parameter controls whether the
 *        Link Layer should filter out duplicate advertising reports (filtering
 *        duplicates enabled) to the Host or if the Link Layer should generate
 *        advertising reports for each packet received (filtering duplicates
 *        disabled). See [Vol 6] Part B, Section 4.4.3.5.
 *        Values:
 *        - 0x00: Duplicate filtering disabled
 *        - 0x01: Duplicate filtering enabled
 *        - 0x02: Duplicate filtering enabled, reset for each scan period
 * @param Scanning_Filter_Policy 0x00 Accept all advertisement packets. Directed
 *        advertising packets which are not addressed for this device shall be
 *        ignored. 0x01 Ignore advertisement packets from devices not in the
 *        White List Only. Directed advertising packets which are not addressed
 *        for this device shall be ignored 0x02 Accept all undirected
 *        advertisement packets. Directed advertisement packets where initiator
 *        address is a RPA and  Directed advertisement packets addressed to this
 *        device shall be accepted. 0x03 Accept all undirected advertisement
 *        packets from devices that are in the White List.Directed advertisement
 *        packets where initiator address is RPA and Directed advertisement
 *        packets addressed to this device shall be accepted.
 *        Values:
 *        - 0x00: Accept All
 *        - 0x01: White List Only
 *        - 0x02: Accept All (use resolving list)
 *        - 0x03: White List Only (use resolving list)
 * @param Scanning_PHY PHY that is going to be configured. Only one bit can be
 *        set.
 *        Flags:
 *        - 0x01: LE_1M_PHY_BIT
 *        - 0x04: LE_CODED_PHY_BIT
 * @param Scan_Type The Scan_Type parameter specifies the type of scan to
 *        perform. 0: Passive Scanning. No scan request PDUs shall be sent. 1:
 *        Active Scanning. Scan request PDUs may be sent.
 *        Values:
 *        - 0x00: Passive Scanning
 *        - 0x01: Active Scanning
 * @param Scan_Interval Time interval from when the Controller started its last
 *        scan until it begins the subsequent scan on the primary advertising
 *        physical channel.  Time = N * 0.625 ms
 *        Values:
 *        - 0x0004 (2.500 ms)  ... 0xFFFF (40959.375 ms) 
 * @param Scan_Window Time interval from when the Controller started its last
 *        scan until it begins the subsequent scan on the primary advertising
 *        physical channel. Time = N * 0.625 msec.
 *        Values:
 *        - 0x0004 (2.500 ms)  ... 0xFFFF (40959.375 ms) 
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_set_scan_configuration(uint8_t Filter_Duplicates,
                                          uint8_t Scanning_Filter_Policy,
                                          uint8_t Scanning_PHY,
                                          uint8_t Scan_Type,
                                          uint16_t Scan_Interval,
                                          uint16_t Scan_Window);
/**
 * @brief This function configures the connection parameters. To configure more
 *        than one PHY, this function must be called more times.
 * @param Initiating_PHY PHY that is going to be configured. Only one bit can be
 *        set.
 *        Flags:
 *        - 0x01: LE_1M_PHY_BIT
 *        - 0x02: LE_2M_PHY_BIT
 *        - 0x04: LE_CODED_PHY_BIT
 * @param Conn_Interval_Min Minimum value for the connection event interval.
 *        This shall be less than or equal to Conn_Interval_Max. Time = N * 1.25
 *        msec.
 *        Values:
 *        - 0x0006 (7.50 ms)  ... 0x0C80 (4000.00 ms) 
 * @param Conn_Interval_Max Maximum value for the connection event interval.
 *        This shall be greater than or equal to Conn_Interval_Min. Time = N *
 *        1.25 msec.
 *        Values:
 *        - 0x0006 (7.50 ms)  ... 0x0C80 (4000.00 ms) 
 * @param Conn_Latency Slave latency for the connection in number of connection
 *        events.
 *        Values:
 *        - 0x0000 ... 0x01F3
 * @param Supervision_Timeout Supervision timeout for the LE Link. It shall be a
 *        multiple of 10 ms and larger than (1 + connSlaveLatency) *
 *        connInterval * 2. Time = N * 10 msec.
 *        Values:
 *        - 0x000A (100 ms)  ... 0x0C80 (32000 ms) 
 * @param Minimum_CE_Length Information parameter about the minimum length of
 *        connection needed for this LE connection. Time = N * 0.625 msec.
 * @param Maximum_CE_Length Information parameter about the maximum length of
 *        connection needed for this LE connection. Time = N * 0.625 msec.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_set_connection_configuration(uint8_t Initiating_PHY,
                                                uint16_t Conn_Interval_Min,
                                                uint16_t Conn_Interval_Max,
                                                uint16_t Conn_Latency,
                                                uint16_t Supervision_Timeout,
                                                uint16_t Minimum_CE_Length,
                                                uint16_t Maximum_CE_Length);
/**
 * @brief Starts a GAP procedure according to the procedure code.
 * @param Procedure_Code Procedure to be started.
 *        Values:
 *        - 0x00: GAP_LIMITED_DISCOVERY_PROC
 *        - 0x01: GAP_GENERAL_DISCOVERY_PROC
 *        - 0x02: GAP_AUTO_CONNECTION_ESTABLISHMENT_PROC
 *        - 0x03: GAP_GENERAL_CONNECTION_ESTABLISHMENT_PROC
 *        - 0x04: GAP_SELECTIVE_CONNECTION_ESTABLISHMENT_PROC
 *        - 0x05: GAP_OBSERVATION_PROC
 * @param PHYs PHYs that will be used for Scanning or Initiating .
 *        Flags:
 *        - 0x01: LE_1M_PHY_BIT
 *        - 0x04: LE_CODED_PHY_BIT
 * @param Duration Ignored. Reserved for future use.
 * @param Period Ignored. Reserved for future use.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_start_procedure(uint8_t Procedure_Code,
                                   uint8_t PHYs,
                                   uint16_t Duration,
                                   uint16_t Period);
/**
 * @brief Creates a direct connection to a device and read the name
 *        characteristic.
 * @param PHYs PHYs that will be used for initiating the connection.
 *        Flags:
 *        - 0x01: LE_1M_PHY_BIT
 *        - 0x04: LE_CODED_PHY_BIT
 * @param Peer_Address_Type The Peer_Address_Type parameter indicates the type
 *        of address used in the connectable advertisement sent by the peer. 0:
 *        Public Device Address or Public Identity Address 1: Random Device
 *        Address or Random (static) Identity Address
 *        Values:
 *        - 0x00: Public Address
 *        - 0x01: Random Address
 * @param Peer_Address Public Device Address, Random Device Address, Public
 *        Identity Address, or Random (static) Identity Address of the device to
 *        be connected.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_discover_name(uint8_t PHYs,
                                 uint8_t Peer_Address_Type,
                                 uint8_t Peer_Address[6]);
/**
 * @brief Add specific device addresses to the white and/or resolving list.
 * @param Lists Select in which list the device addresses will be added: white
 *        list, resolving list or both.
 *        Flags:
 *        - 0x01: Withe List
 *        - 0x02: Resolving List
 * @param Clear_Lists Clear the selected lists before adding the device
 *        addresses.
 *        Values:
 *        - 0x00: Do not clear
 *        - 0x01: Clear before adding
 * @param Num_of_List_Entries Number of devices that have to be added to the
 *        whitelist.
 *        Values:
 *        - 0x00 ... 0xFF
 * @param List_Entry See @ref List_Entry_t
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_add_devices_to_white_and_resolving_list(uint8_t Lists,
                                                           uint8_t Clear_Lists,
                                                           uint8_t Num_of_List_Entries,
                                                           List_Entry_t List_Entry[]);
/**
 * @brief Clear the specified lists and add all bonded devices.
 * @param Lists Select in which list the device addresses will be added: white
 *        list, resolving list or both.
 *        Flags:
 *        - 0x01: White List
 *        - 0x02: Resolving List
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_configure_white_and_resolving_list(uint8_t Lists);
/**
 * @brief The GAP_Set_Periodic_Advertising_Configuration command is used by the
 *        Host to set the parameters for periodic advertising. See
 *        hci_le_set_periodic_advertising_parameters().
 * @param Advertising_Handle It is used to identify an advertising set
 *        Values:
 *        - 0x00 ... 0xEF: Used to identify a periodic advertisement
 * @param Periodic_Advertising_Interval_Min Minimum advertising interval for
 *        periodic advertising. Time = N * 1.25 ms; Time Range: 7.5ms to
 *        81.91875 s.
 *        Values:
 *        - 0x0006 (7.50 ms)  ... 0xFFFF (NaN) : Minimum advertising interval for periodic advertising.
 * @param Periodic_Advertising_Interval_Max Maximum advertising interval for
 *        periodic advertising. Time = N * 1.25 ms; Time Range: 7.5ms to
 *        81.91875 s.
 *        Values:
 *        - 0x0006 (7.50 ms)  ... 0xFFFF (NaN) : Maximum advertising interval for periodic advertising.
 * @param Periodic_Advertising_Properties The Periodic_Advertising_Properties
 *        parameter indicates which fields should be included in the advertising
 *        packet.
 *        Flags:
 *        - 0x0040: Include TxPower in the advertising PDU
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_set_periodic_advertising_configuration(uint8_t Advertising_Handle,
                                                          uint16_t Periodic_Advertising_Interval_Min,
                                                          uint16_t Periodic_Advertising_Interval_Max,
                                                          uint16_t Periodic_Advertising_Properties);
/**
 * @brief The GAP_Set_Periodic_Advertising_Data command is used to set the data
 *        used in periodic advertising PDUs. See
 *        hci_le_set_periodic_advertising_data().
 * @param Advertising_Handle It is used to identify an advertising set
 *        Values:
 *        - 0x00 ... 0xEF: Used to identify an advertising set
 * @param Operation The Host may set the periodic advertising data in one or
 *        more operations using the Operation parameter in the command.
 *        Values:
 *        - 0x00: Intermediate fragment of fragmented periodic advertising data
 *        - 0x01: First fragment of fragmented periodic advertising data
 *        - 0x02: Last fragment of fragmented periodic advertising data
 *        - 0x03: Complete periodic advertising data
 * @param Advertising_Data_Length The number of octets in the Advertising Data
 *        parameter
 *        Values:
 *        - 0 ... 252: The number of octets in the Advertising Data parameter
 * @param Advertising_Data Periodic advertising data formatted as defined in
 *        [Vol 3] Part C, Section 11. Note: This parameter has a variable
 *        length.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_set_periodic_advertising_data_nwk(uint8_t Advertising_Handle,
                                                     uint8_t Operation,
                                                     uint8_t Advertising_Data_Length,
                                                     uint8_t Advertising_Data[]);
/**
 * @brief The GAP_Set_Periodic_Advertising_Enable command is used to request the
 *        Controller to enable or disable the periodic advertising for the
 *        advertising set specified by the Advertising_Handle parameter
 *        (ordinary advertising is not affected). See
 *        hci_le_set_periodic_advertising_enable().
 * @param Enable It is used to request the Controller to enable or disable the
 *        periodic advertising for the advertising set specified by the
 *        Advertising_Handle parameter (ordinary advertising is not affected).
 *        Values:
 *        - 0x00: Periodic advertising is disabled (default)
 *        - 0x01: Periodic advertising is enabled
 * @param Advertising_Handle
 *        Values:
 *        - 0x00 ... 0xEF: Used to identify an advertising set
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_set_periodic_advertising_enable(uint8_t Enable,
                                                   uint8_t Advertising_Handle);
/**
 * @brief The AGP_Periodic_Advertising_Create_Sync command is used to
 *        synchronize with periodic advertising from an advertiser and begin
 *        receiving periodic advertising packets. See
 *        hci_le_periodic_advertising_create_sync().
 * @param Options The Options parameter is used to determine whether the
 *        Periodic Advertiser List is used and whether
 *        HCI_Periodic_Advertising_Report events for this periodic advertising
 *        train are initially enabled or disabled. If the Periodic Advertiser
 *        List is not used, the Advertising_SID, Advertiser Address_Type, and
 *        Advertiser Address parameters specify the periodic advertising device
 *        to listen to; otherwise they shall be ignored.
 *        Flags:
 *        - 0x01: ): Use the Advertising_SID, Advertising_Address_Type, and Advertising_
Address parameters to determine which advertiser to listen to. 1:Use the Periodic Advertiser List to determine which advertiser to listen
to.
 *        - 0x02: 0: Reporting initially enabled. 1: Reporting initially disabled.
 * @param Advertising_SID The Advertising_SID parameter, if used, specifies the
 *        value that must match the Advertising SID subfield in the ADI field of
 *        the received advertisement for it to be used to synchronize.
 *        Values:
 *        - 0x00 ... 0x0F: Advertising SID subfield in the ADI field used to identify the Periodic
Advertising
 * @param Advertising_Address_Type Advertising address type
 *        Values:
 *        - 0x00: Public Device Address
 *        - 0x01: Random Device Address
 * @param Advertiser_Address Public Device Address, Random Device Address,
 *        Public Identity Address, or Random (static) Identity Address of the
 *        advertiser
 * @param Skip The Skip parameter specifies the number of consecutive periodic
 *        advertising packets that the receiver may skip after successfully
 *        receiving a periodic advertising packet.
 *        Values:
 *        - 0x0000 ... 0x01F3: The number of periodic advertising packets that can be skipped after a
successful receive
 * @param Sync_Timeout The Skip parameter specifies the number of consecutive
 *        periodic advertising packets that the receiver may skip after
 *        successfully receiving a periodic advertising packet. Time = N*10 ms;
 *        Time Range: 100 ms to 163.84 s.
 *        Values:
 *        - 0x000A (100 ms)  ... 0x4000 (163840 ms) : Synchronization timeout for the periodic advertising
 * @param Sync_CTE_Type The Sync_CTE_Type parameter specifies whether to only
 *        synchronize to periodic advertising with certain types of Constant
 *        Tone Extension (a value of 0 indicates that the presence or absence of
 *        a Constant Tone Extension is irrelevant). If the periodic advertising
 *        has the wrong type of Constant Tone Extension then: - If bit 0 of
 *        Options is set, the Controller shall ignore this address and SID and
 *        continue to search for other periodic advertisements. - Otherwise, the
 *        Controller shall cancel the synchronization with the error code
 *        Unsupported Remote Feature/Unsupported LMP Feature (0x1A).
 *        Flags:
 *        - 0x01: Do not sync to packets with an AoA Constant Tone Extension
 *        - 0x02: Do not sync to packets with an AoD Constant Tone Extension with 1 microsecond
slots
 *        - 0x04: Do not sync to packets with an AoD Constant Tone Extension with 2 microseconds
slots
 *        - 0x08: Do not sync to packets with a type 3 Constant Tone Extension (currently
reserved for future use)
 *        - 0x10: Do not sync to packets without a Constant Tone Extension
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_periodic_advertising_create_sync(uint8_t Options,
                                                    uint8_t Advertising_SID,
                                                    uint8_t Advertising_Address_Type,
                                                    uint8_t Advertiser_Address[6],
                                                    uint16_t Skip,
                                                    uint16_t Sync_Timeout,
                                                    uint8_t Sync_CTE_Type);
/**
 * @brief The GAP_Periodic_Advertising_Create_Sync_Cancel command is used to
 *        cancel the GAP_Periodic_Advertising_Create_Sync command while it is
 *        pending. See hci_le_periodic_advertising_create_sync_cancel().
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_periodic_advertising_create_sync_cancel(void);
/**
 * @brief The GAP_Remove_Advertising_Set command is used to remove an
 *        advertising set from the Controller. If the advertising set
 *        corresponding to the Advertising_Handle parameter does not exist, then
 *        the Controller shall return the error code Unknown Advertising
 *        Identifier (0x42). If advertising on the advertising set is enabled,
 *        then the Controller shall return the error code Command Disallowed
 *        (0x0C).
 * @param Advertising_Handle It is used to identify an advertising set
 *        Values:
 *        - 0x00 ... 0xEF: Used to identify an advertising set
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_remove_advertising_set(uint8_t Advertising_Handle);
/**
 * @brief The GAP_Clear_Advertising_Sets command is used to remove all existing
 *        advertising sets from the Controller. If advertising is enabled on any
 *        advertising set, then the Controller shall return the error code
 *        Command Disallowed (0x0C). Note: All advertising sets are cleared on
 *        HCI reset.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_clear_advertising_sets(void);
/**
 * @brief The GAP_Periodic_Advertising_Terminate_Sync command is used to stop
 *        reception of the periodic advertising identified by the Sync_Handle
 *        parameter. See hci_le_periodic_advertising_terminate_sync().
 * @param Sync_Handle It is used to identify the periodic advertiser
 *        Values:
 *        - 0x0000 ... 0x0EFF: Sync_Handle to be used to identify the periodic advertiser
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_periodic_advertising_terminate_sync(uint16_t Sync_Handle);
/**
 * @brief The GAP_Add_Device_To_Periodic_Advertiser_List command is used to add
 *        a single device to the Periodic Advertiser list stored in the
 *        Controller. See hci_le_add_device_to_periodic_advertiser_list().
 * @param Advertiser_Address_Type Advertiser Address Type
 *        Values:
 *        - 0x00: Public Device Address or Public Identity Address
 *        - 0x01: Random Device Address or Random (static) Identity Address
 * @param Advertiser_Address Public Device Address, Random Device Address,
 *        Public Identity Address, or Random (static) Identity Address of the
 *        advertiser
 * @param Advertising_SID Advertising SID subfield in the ADI field used to
 *        identify the Periodic Advertising
 *        Values:
 *        - 0x00 ... 0x0F: Advertising SID subfield in the ADI field used to identify the Periodic
Advertising
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_add_device_to_periodic_advertiser_list(uint8_t Advertiser_Address_Type,
                                                          uint8_t Advertiser_Address[6],
                                                          uint8_t Advertising_SID);
/**
 * @brief The GAP_Remove_Device_From_Periodic_Advertiser_List command is used to
 *        remove one device from the list of Periodic Advertisers stored in the
 *        Controller. See hci_le_remove_device_from_periodic_advertising_list().
 * @param Advertiser_Address_Type Advertising Address type
 *        Values:
 *        - 0x00: Public Device Address or Public Identity Address
 *        - 0x01: Random Device Address or Random (static) Identity Address
 * @param Advertiser_Address Public Device Address, Random Device Address,
 *        Public Identity Address, or Random (static) Identity Address of the
 *        advertiser
 * @param Advertising_SID It is used to  identify the Periodic Advertising
 *        Values:
 *        - 0x00 ... 0x0F: Advertising SID subfield in the ADI field used to identify the Periodic
Advertising
All other values Reserved for future
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_remove_device_from_periodic_advertising_list(uint8_t Advertiser_Address_Type,
                                                                uint8_t Advertiser_Address[6],
                                                                uint8_t Advertising_SID);
/**
 * @brief The GAP_Clear_Periodic_Advertiser_List command is used to remove all
 *        devices from the list of Periodic Advertisers in the Controller. See
 *        hci_le_clear_periodic_advertiser_list().
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_clear_periodic_advertiser_list(void);
/**
 * @brief The GAP_Read_Periodic_Advertiser_List_Size command is used to read the
 *        total number of Periodic Advertiser list entries that can be stored in
 *        the Controller. Note: The number of entries that can be stored is not
 *        fixed and the Controller can change it at any time (e.g., because the
 *        memory used to store the list can also be used for other purposes).
 * @param[out] Periodic_Advertiser_List_Size Total number of Periodic Advertiser
 *             list entries that can be stored in the Controller
 *             Values:
 *             - 0x1F ... 0xFF: Total number of Periodic Advertiser list entries that can be stored in the
Controller
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_read_periodic_advertiser_list_size(uint8_t *Periodic_Advertiser_List_Size);
/**
 * @brief The ACI_GAP_Set_Periodic_Advertising_Receive_Enable command will
 *        enable or disable reports for the periodic advertising train
 *        identified by the Sync_Handle parameter. See
 *        hci_le_set_periodic_advertising_receive_enable().
 * @param Sync_Handle Sync_Handle identifying the periodic advertising train
 *        Values:
 *        - 0x0000 ... 0x0EFF: Sync_Handle identifying the periodic advertising train
 * @param Enable It determines whether reporting is enabled or disabled
 *        Values:
 *        - 0x00: Reporting disabled
 *        - 0x01: Reporting enabled
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_set_periodic_advertising_receive_enable(uint16_t Sync_Handle,
                                                           uint8_t Enable);
/**
 * @brief The ACI_GAP_Periodic_Advertising_Sync_Transfer command is used to
 *        instruct the Controller to send synchronization information about the
 *        periodic advertising train identified by the Sync_Handle parameter to
 *        a connected device. See hci_le_periodic_advertising_sync_transfer().
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Service_Data The Service_Data parameter is a value provided by the
 *        Host for use by the Host of the peer device. It is not used by the
 *        Controller.
 * @param Sync_Handle Sync handle that identifies the synchronization
 *        information about the periodic advertising train.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_periodic_advertising_sync_transfer(uint16_t Connection_Handle,
                                                      uint16_t Service_Data,
                                                      uint16_t Sync_Handle);
/**
 * @brief The ACI_GAP_Periodic_Advertising_Set_Info_Transfer command is used to
 *        instruct the Controller to send synchronization information about the
 *        periodic advertising in an advertising set to a connected device. See
 *        hci_le_periodic_advertising_set_info_transfer()
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Service_Data It is a value provided by the Host to identify the
 *        periodic advertising train to the peer device. It is not used by the
 *        Controller.
 * @param Advertising_Handle It is used to identify an advertising set
 *        Values:
 *        - 0x00 ... 0xEF
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_periodic_advertising_set_info_transfer(uint16_t Connection_Handle,
                                                          uint16_t Service_Data,
                                                          uint8_t Advertising_Handle);
/**
 * @brief The ACI_GAP_Set_Periodic_Advertising_Sync_Transfer_Parameters command
 *        is used to specify how the Controller will process periodic
 *        advertising synchronization information received from the device
 *        identified by the Connection_Handle parameter (the "transfer mode").
 *        See hci_le_set_periodic_advertising_sync_transfer_parameters().
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Mode The Mode parameter specifies the action to be taken when periodic
 *        advertising synchronization information is received. If Mode is 0x00,
 *        the Controller will ignore the information. Otherwise it will notify
 *        the Host and synchronize to the periodic advertising. Mode also
 *        specifies whether periodic advertising reports are initially enabled
 *        or disabled.
 *        Values:
 *        - 0x00: No attempt is made to synchronize to the periodic advertising and no HCI_LE_Periodic_Advertising_Sync_Transfer_Received event is sent to the Host.
 *        - 0x01: An HCI_LE_Periodic_Advertising_Sync_Transfer_Received event is sent to the Host. HCI_LE_Periodic_Advertising_Report events will be disabled.
 *        - 0x02: An HCI_LE_Periodic_Advertising_Sync_Transfer_Received event is sent to the Host. HCI_LE_Periodic_Advertising_Report events will be enabled.
 * @param Skip The Skip parameter specifies the number of consecutive periodic
 *        advertising packets that the receiver may skip after successfully
 *        receiving a periodic advertising packet.
 *        Values:
 *        - 0x0000 ... 0x01F3: The number of periodic advertising packets that can be skipped after a successful receive
 * @param Sync_Timeout The Skip parameter specifies the number of consecutive
 *        periodic advertising packets that the receiver may skip after
 *        successfully receiving a periodic advertising packet. Time = N*10 ms;
 *        Time Range: 100 ms to 163.84 s.
 *        Values:
 *        - 0x000A (100 ms)  ... 0x4000 (163840 ms) : Synchronization timeout for the periodic advertising
 * @param CTE_Type It specifies whether to only synchronize to periodic
 *        advertising with certain types of Constant Tone Extension. If the
 *        periodic advertiser changes the type of the Constant Tone Extension
 *        after the Controller has synchronized with the periodic advertising,
 *        it shall remain synchronized.
 *        Flags:
 *        - 0x00: Do not sync to packets with an AoA Constant Tone Extension
 *        - 0x02: Do not sync to packets with an AoD Constant Tone Extension with 1 microsecond slots
 *        - 0x04: Do not sync to packets with an AoD Constant Tone Extension with 2 microseconds slots
 *        - 0x10: Do not sync to packets without a Constant Tone Extension
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_set_periodic_advertising_sync_transfer_parameters(uint16_t Connection_Handle,
                                                                     uint8_t Mode,
                                                                     uint16_t Skip,
                                                                     uint16_t Sync_Timeout,
                                                                     uint8_t CTE_Type);
/**
 * @brief The ACI_GAP_Set_Default_Periodic_Advertising_Sync_Transfer_Parameters
 *        command is used to specify the initial value for the mode, skip,
 *        timeout, and Constant Tone Extension type to be used for all
 *        subsequent connections over the LE transport. See
 *        hci_le_set_default_periodic_advertising_sync_transfer_parameters().
 * @param Mode The Mode parameter specifies the initial action to be taken. If
 *        Mode is 0x00, the Controller will ignore the information. Otherwise it
 *        will notify the Host and synchronize to the periodic advertising. Mode
 *        also specifies whether periodic advertising reports are initially
 *        enabled or disabled.
 *        Values:
 *        - 0x00: No attempt is made to synchronize to the periodic advertising and no HCI_LE_Periodic_Advertising_Sync_Transfer_Received event is sent to the Host.
 *        - 0x01: An HCI_LE_Periodic_Advertising_Sync_Transfer_Received event is sent to the Host. HCI_LE_Periodic_Advertising_Report events will be disabled.
 *        - 0x02: An HCI_LE_Periodic_Advertising_Sync_Transfer_Received event is sent to the Host. HCI_LE_Periodic_Advertising_Report events will be enabled.
 * @param Skip The Skip parameter specifies the number of consecutive periodic
 *        advertising packets that the receiver may skip after successfully
 *        receiving a periodic advertising packet.
 *        Values:
 *        - 0x0000 ... 0x01F3: The number of periodic advertising packets that can be skipped after a successful receive
 * @param Sync_Timeout The Skip parameter specifies the number of consecutive
 *        periodic advertising packets that the receiver may skip after
 *        successfully receiving a periodic advertising packet. Time = N*10 ms;
 *        Time Range: 100 ms to 163.84 s.
 *        Values:
 *        - 0x000A (100 ms)  ... 0x4000 (163840 ms) : Synchronization timeout for the periodic advertising
 * @param CTE_Type The CTE_Type parameter specifies whether to only synchronize
 *        to periodic advertising with certain types of Constant Tone Extension.
 *        If the periodic advertiser changes the type of the Constant Tone
 *        Extension after the Controller has synchronized with the periodic
 *        advertising, it shall remain synchronized.
 *        Flags:
 *        - 0x00: Do not sync to packets with an AoA Constant Tone Extension
 *        - 0x02: Do not sync to packets with an AoD Constant Tone Extension with 1 microsecond slots
 *        - 0x04: Do not sync to packets with an AoD Constant Tone Extension with 2 microseconds slots
 *        - 0x10: Do not sync to packets without a Constant Tone Extension
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_set_default_periodic_advertising_sync_transfer_parameters(uint8_t Mode,
                                                                             uint16_t Skip,
                                                                             uint16_t Sync_Timeout,
                                                                             uint8_t CTE_Type);
/**
     * @}
     */
    #endif /* _BLUENRG_LP_GAP_ACI_H_ */
