

/**
  ******************************************************************************
  * @file    bluenrg_lp_gatt_aci.c
  * @author  AMS - RF Application team
  * @date    18 March 2021
  * @brief   Source file for external uC - BlueNRG-x in network coprocessor mode (gatt_aci)
  *          Autogenerated files, do not edit!!
  ******************************************************************************
  * @attention
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  *
  * <h2><center>&copy; COPYRIGHT STMicroelectronics</center></h2>
  ******************************************************************************
  */
#include "bluenrg_lp_gatt_aci.h"
#include "osal.h"
tBleStatus aci_gatt_srv_init(void)
{
  struct hci_request rq;
  tBleStatus status = 0;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x101;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gatt_srv_add_service_nwk(uint8_t Service_UUID_Type,
                                        Service_UUID_t *Service_UUID,
                                        uint8_t Service_Type,
                                        uint8_t Max_Attribute_Records,
                                        uint16_t *Service_Handle)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gatt_srv_add_service_nwk_cp0 *cp0 = (aci_gatt_srv_add_service_nwk_cp0*)(cmd_buffer);
  aci_gatt_srv_add_service_nwk_cp1 *cp1 = (aci_gatt_srv_add_service_nwk_cp1*)(cmd_buffer + 1 + (Service_UUID_Type == 1 ? 2 : (Service_UUID_Type == 2 ? 16 : 0)));
  aci_gatt_srv_add_service_nwk_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  uint8_t index_input = 0;
  cp0->Service_UUID_Type = htob(Service_UUID_Type, 1);
  index_input += 1;
  /* var_len_data input */
  {
    uint8_t size;
    switch (Service_UUID_Type) {
      case 1: size = 2; break;
      case 2: size = 16; break;
      default: return BLE_STATUS_ERROR;
    }
    Osal_MemCpy((void *) &cp0->Service_UUID, (const void *) Service_UUID, size);
    index_input += size;
    {
      cp1->Service_Type = htob(Service_Type, 1);
    }
    index_input += 1;
    {
      cp1->Max_Attribute_Records = htob(Max_Attribute_Records, 1);
    }
    index_input += 1;
  }
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x102;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  *Service_Handle = btoh(resp.Service_Handle, 2);
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gatt_srv_include_service_nwk(uint16_t Service_Handle,
                                            uint16_t Included_Service_Handle,
                                            uint16_t *Include_Handle)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gatt_srv_include_service_nwk_cp0 *cp0 = (aci_gatt_srv_include_service_nwk_cp0*)(cmd_buffer);
  aci_gatt_srv_include_service_nwk_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  uint8_t index_input = 0;
  cp0->Service_Handle = htob(Service_Handle, 2);
  index_input += 2;
  cp0->Included_Service_Handle = htob(Included_Service_Handle, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x103;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  *Include_Handle = btoh(resp.Include_Handle, 2);
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gatt_srv_add_char_nwk(uint16_t Service_Handle,
                                     uint8_t Char_UUID_Type,
                                     Char_UUID_t *Char_UUID,
                                     uint16_t Char_Value_Length,
                                     uint8_t Char_Properties,
                                     uint8_t Security_Permissions,
                                     uint8_t GATT_Evt_Mask,
                                     uint8_t Enc_Key_Size,
                                     uint8_t Is_Variable,
                                     uint16_t *Char_Handle)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gatt_srv_add_char_nwk_cp0 *cp0 = (aci_gatt_srv_add_char_nwk_cp0*)(cmd_buffer);
  aci_gatt_srv_add_char_nwk_cp1 *cp1 = (aci_gatt_srv_add_char_nwk_cp1*)(cmd_buffer + 2 + 1 + (Char_UUID_Type == 1 ? 2 : (Char_UUID_Type == 2 ? 16 : 0)));
  aci_gatt_srv_add_char_nwk_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  uint8_t index_input = 0;
  cp0->Service_Handle = htob(Service_Handle, 2);
  index_input += 2;
  cp0->Char_UUID_Type = htob(Char_UUID_Type, 1);
  index_input += 1;
  /* var_len_data input */
  {
    uint8_t size;
    switch (Char_UUID_Type) {
      case 1: size = 2; break;
      case 2: size = 16; break;
      default: return BLE_STATUS_ERROR;
    }
    Osal_MemCpy((void *) &cp0->Char_UUID, (const void *) Char_UUID, size);
    index_input += size;
    {
      cp1->Char_Value_Length = htob(Char_Value_Length, 2);
    }
    index_input += 2;
    {
      cp1->Char_Properties = htob(Char_Properties, 1);
    }
    index_input += 1;
    {
      cp1->Security_Permissions = htob(Security_Permissions, 1);
    }
    index_input += 1;
    {
      cp1->GATT_Evt_Mask = htob(GATT_Evt_Mask, 1);
    }
    index_input += 1;
    {
      cp1->Enc_Key_Size = htob(Enc_Key_Size, 1);
    }
    index_input += 1;
    {
      cp1->Is_Variable = htob(Is_Variable, 1);
    }
    index_input += 1;
  }
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x104;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  *Char_Handle = btoh(resp.Char_Handle, 2);
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gatt_srv_add_char_desc_nwk(uint16_t Char_Handle,
                                          uint8_t Char_Desc_Uuid_Type,
                                          Char_Desc_Uuid_t *Char_Desc_Uuid,
                                          uint16_t Char_Desc_Value_Max_Len,
                                          uint16_t Char_Desc_Value_Length,
                                          uint8_t Char_Desc_Value[],
                                          uint8_t Security_Permissions,
                                          uint8_t Access_Permissions,
                                          uint8_t GATT_Evt_Mask,
                                          uint8_t Enc_Key_Size,
                                          uint8_t Is_Variable,
                                          uint16_t *Char_Desc_Handle)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gatt_srv_add_char_desc_nwk_cp0 *cp0 = (aci_gatt_srv_add_char_desc_nwk_cp0*)(cmd_buffer);
  aci_gatt_srv_add_char_desc_nwk_cp1 *cp1 = (aci_gatt_srv_add_char_desc_nwk_cp1*)(cmd_buffer + 2 + 1 + (Char_Desc_Uuid_Type == 1 ? 2 : (Char_Desc_Uuid_Type == 2 ? 16 : 0)));
  aci_gatt_srv_add_char_desc_nwk_cp2 *cp2 = (aci_gatt_srv_add_char_desc_nwk_cp2*)(cmd_buffer + 2 + 1 + (Char_Desc_Uuid_Type == 1 ? 2 : (Char_Desc_Uuid_Type == 2 ? 16 : 0)) + 2 + 2 + Char_Desc_Value_Length * (sizeof(uint8_t)));
  aci_gatt_srv_add_char_desc_nwk_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  uint8_t index_input = 0;
  cp0->Char_Handle = htob(Char_Handle, 2);
  index_input += 2;
  cp0->Char_Desc_Uuid_Type = htob(Char_Desc_Uuid_Type, 1);
  index_input += 1;
  /* var_len_data input */
  {
    uint8_t size;
    switch (Char_Desc_Uuid_Type) {
      case 1: size = 2; break;
      case 2: size = 16; break;
      default: return BLE_STATUS_ERROR;
    }
    Osal_MemCpy((void *) &cp0->Char_Desc_Uuid, (const void *) Char_Desc_Uuid, size);
    index_input += size;
    {
      cp1->Char_Desc_Value_Max_Len = htob(Char_Desc_Value_Max_Len, 2);
    }
    index_input += 2;
    {
      cp1->Char_Desc_Value_Length = htob(Char_Desc_Value_Length, 2);
    }
    index_input += 2;
    Osal_MemCpy((void *) &cp1->Char_Desc_Value, (const void *) Char_Desc_Value, Char_Desc_Value_Length*sizeof(uint8_t));
    index_input += Char_Desc_Value_Length*sizeof(uint8_t);
    {
      cp2->Security_Permissions = htob(Security_Permissions, 1);
    }
    index_input += 1;
    {
      cp2->Access_Permissions = htob(Access_Permissions, 1);
    }
    index_input += 1;
    {
      cp2->GATT_Evt_Mask = htob(GATT_Evt_Mask, 1);
    }
    index_input += 1;
    {
      cp2->Enc_Key_Size = htob(Enc_Key_Size, 1);
    }
    index_input += 1;
    {
      cp2->Is_Variable = htob(Is_Variable, 1);
    }
    index_input += 1;
  }
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x105;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  *Char_Desc_Handle = btoh(resp.Char_Desc_Handle, 2);
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gatt_srv_write_handle_value_nwk(uint16_t Attr_Handle,
                                               uint16_t Val_Offset,
                                               uint16_t Value_Length,
                                               uint8_t Value[])
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gatt_srv_write_handle_value_nwk_cp0 *cp0 = (aci_gatt_srv_write_handle_value_nwk_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Attr_Handle = htob(Attr_Handle, 2);
  index_input += 2;
  cp0->Val_Offset = htob(Val_Offset, 2);
  index_input += 2;
  cp0->Value_Length = htob(Value_Length, 2);
  index_input += 2;
  /* var_len_data input */
  {
    Osal_MemCpy((void *) &cp0->Value, (const void *) Value, Value_Length*sizeof(uint8_t));
    index_input += Value_Length*sizeof(uint8_t);
  }
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x106;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gatt_srv_rm_char_nwk(uint16_t Char_Handle)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gatt_srv_rm_char_nwk_cp0 *cp0 = (aci_gatt_srv_rm_char_nwk_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Char_Handle = htob(Char_Handle, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x107;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gatt_srv_rm_service_nwk(uint16_t Serv_Handle)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gatt_srv_rm_service_nwk_cp0 *cp0 = (aci_gatt_srv_rm_service_nwk_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Serv_Handle = htob(Serv_Handle, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x108;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gatt_srv_rm_include_service_nwk(uint16_t Include_Handle)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gatt_srv_rm_include_service_nwk_cp0 *cp0 = (aci_gatt_srv_rm_include_service_nwk_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Include_Handle = htob(Include_Handle, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x109;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gatt_set_event_mask(uint32_t GATT_Evt_Mask)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gatt_set_event_mask_cp0 *cp0 = (aci_gatt_set_event_mask_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->GATT_Evt_Mask = htob(GATT_Evt_Mask, 4);
  index_input += 4;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x10a;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gatt_clt_exchange_config(uint16_t Connection_Handle)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gatt_clt_exchange_config_cp0 *cp0 = (aci_gatt_clt_exchange_config_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x10b;
  rq.event = 0x0F;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gatt_clt_prepare_write_req(uint16_t Connection_Handle,
                                          uint16_t Attr_Handle,
                                          uint16_t Val_Offset,
                                          uint16_t Attribute_Val_Length,
                                          uint8_t Attribute_Val[])
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gatt_clt_prepare_write_req_cp0 *cp0 = (aci_gatt_clt_prepare_write_req_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->Attr_Handle = htob(Attr_Handle, 2);
  index_input += 2;
  cp0->Val_Offset = htob(Val_Offset, 2);
  index_input += 2;
  cp0->Attribute_Val_Length = htob(Attribute_Val_Length, 2);
  index_input += 2;
  /* var_len_data input */
  {
    Osal_MemCpy((void *) &cp0->Attribute_Val, (const void *) Attribute_Val, Attribute_Val_Length*sizeof(uint8_t));
    index_input += Attribute_Val_Length*sizeof(uint8_t);
  }
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x110;
  rq.event = 0x0F;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gatt_clt_execute_write_req(uint16_t Connection_Handle,
                                          uint8_t Execute)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gatt_clt_execute_write_req_cp0 *cp0 = (aci_gatt_clt_execute_write_req_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->Execute = htob(Execute, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x111;
  rq.event = 0x0F;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gatt_clt_disc_all_primary_services(uint16_t Connection_Handle)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gatt_clt_disc_all_primary_services_cp0 *cp0 = (aci_gatt_clt_disc_all_primary_services_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x112;
  rq.event = 0x0F;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gatt_clt_disc_primary_service_by_uuid(uint16_t Connection_Handle,
                                                     uint8_t UUID_Type,
                                                     UUID_t *UUID)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gatt_clt_disc_primary_service_by_uuid_cp0 *cp0 = (aci_gatt_clt_disc_primary_service_by_uuid_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->UUID_Type = htob(UUID_Type, 1);
  index_input += 1;
  /* var_len_data input */
  {
    uint8_t size;
    switch (UUID_Type) {
      case 1: size = 2; break;
      case 2: size = 16; break;
      default: return BLE_STATUS_ERROR;
    }
    Osal_MemCpy((void *) &cp0->UUID, (const void *) UUID, size);
    index_input += size;
  }
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x113;
  rq.event = 0x0F;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gatt_clt_find_included_services(uint16_t Connection_Handle,
                                               uint16_t Start_Handle,
                                               uint16_t End_Handle)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gatt_clt_find_included_services_cp0 *cp0 = (aci_gatt_clt_find_included_services_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->Start_Handle = htob(Start_Handle, 2);
  index_input += 2;
  cp0->End_Handle = htob(End_Handle, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x114;
  rq.event = 0x0F;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gatt_clt_disc_all_char_of_service(uint16_t Connection_Handle,
                                                 uint16_t Start_Handle,
                                                 uint16_t End_Handle)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gatt_clt_disc_all_char_of_service_cp0 *cp0 = (aci_gatt_clt_disc_all_char_of_service_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->Start_Handle = htob(Start_Handle, 2);
  index_input += 2;
  cp0->End_Handle = htob(End_Handle, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x115;
  rq.event = 0x0F;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gatt_clt_disc_char_by_uuid(uint16_t Connection_Handle,
                                          uint16_t Start_Handle,
                                          uint16_t End_Handle,
                                          uint8_t UUID_Type,
                                          UUID_t *UUID)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gatt_clt_disc_char_by_uuid_cp0 *cp0 = (aci_gatt_clt_disc_char_by_uuid_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->Start_Handle = htob(Start_Handle, 2);
  index_input += 2;
  cp0->End_Handle = htob(End_Handle, 2);
  index_input += 2;
  cp0->UUID_Type = htob(UUID_Type, 1);
  index_input += 1;
  /* var_len_data input */
  {
    uint8_t size;
    switch (UUID_Type) {
      case 1: size = 2; break;
      case 2: size = 16; break;
      default: return BLE_STATUS_ERROR;
    }
    Osal_MemCpy((void *) &cp0->UUID, (const void *) UUID, size);
    index_input += size;
  }
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x116;
  rq.event = 0x0F;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gatt_clt_disc_all_char_desc(uint16_t Connection_Handle,
                                           uint16_t Char_Handle,
                                           uint16_t End_Handle)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gatt_clt_disc_all_char_desc_cp0 *cp0 = (aci_gatt_clt_disc_all_char_desc_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->Char_Handle = htob(Char_Handle, 2);
  index_input += 2;
  cp0->End_Handle = htob(End_Handle, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x117;
  rq.event = 0x0F;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gatt_clt_read(uint16_t Connection_Handle,
                             uint16_t Attr_Handle)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gatt_clt_read_cp0 *cp0 = (aci_gatt_clt_read_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->Attr_Handle = htob(Attr_Handle, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x118;
  rq.event = 0x0F;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gatt_clt_read_using_char_uuid(uint16_t Connection_Handle,
                                             uint16_t Start_Handle,
                                             uint16_t End_Handle,
                                             uint8_t UUID_Type,
                                             UUID_t *UUID)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gatt_clt_read_using_char_uuid_cp0 *cp0 = (aci_gatt_clt_read_using_char_uuid_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->Start_Handle = htob(Start_Handle, 2);
  index_input += 2;
  cp0->End_Handle = htob(End_Handle, 2);
  index_input += 2;
  cp0->UUID_Type = htob(UUID_Type, 1);
  index_input += 1;
  /* var_len_data input */
  {
    uint8_t size;
    switch (UUID_Type) {
      case 1: size = 2; break;
      case 2: size = 16; break;
      default: return BLE_STATUS_ERROR;
    }
    Osal_MemCpy((void *) &cp0->UUID, (const void *) UUID, size);
    index_input += size;
  }
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x119;
  rq.event = 0x0F;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gatt_clt_read_long(uint16_t Connection_Handle,
                                  uint16_t Attr_Handle,
                                  uint16_t Val_Offset)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gatt_clt_read_long_cp0 *cp0 = (aci_gatt_clt_read_long_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->Attr_Handle = htob(Attr_Handle, 2);
  index_input += 2;
  cp0->Val_Offset = htob(Val_Offset, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x11a;
  rq.event = 0x0F;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gatt_clt_read_multiple_char_value(uint16_t Connection_Handle,
                                                 uint8_t Number_of_Handles,
                                                 Handle_Entry_t Handle_Entry[])
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gatt_clt_read_multiple_char_value_cp0 *cp0 = (aci_gatt_clt_read_multiple_char_value_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->Number_of_Handles = htob(Number_of_Handles, 1);
  index_input += 1;
  /* var_len_data input */
  {
    for (int i = 0; i < Number_of_Handles; i++) {
      cp0->Handle_Entry[i].Handle = Handle_Entry[i].Handle;
    }
    index_input += Number_of_Handles*2;
  }
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x11b;
  rq.event = 0x0F;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gatt_clt_write_nwk(uint16_t Connection_Handle,
                                  uint16_t Attr_Handle,
                                  uint16_t Attribute_Val_Length,
                                  uint8_t Attribute_Val[])
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gatt_clt_write_nwk_cp0 *cp0 = (aci_gatt_clt_write_nwk_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->Attr_Handle = htob(Attr_Handle, 2);
  index_input += 2;
  cp0->Attribute_Val_Length = htob(Attribute_Val_Length, 2);
  index_input += 2;
  /* var_len_data input */
  {
    Osal_MemCpy((void *) &cp0->Attribute_Val, (const void *) Attribute_Val, Attribute_Val_Length*sizeof(uint8_t));
    index_input += Attribute_Val_Length*sizeof(uint8_t);
  }
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x11c;
  rq.event = 0x0F;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gatt_clt_write_long_nwk(uint16_t Connection_Handle,
                                       uint16_t Attr_Handle,
                                       uint16_t Val_Offset,
                                       uint16_t Attribute_Val_Length,
                                       uint8_t Attribute_Val[])
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gatt_clt_write_long_nwk_cp0 *cp0 = (aci_gatt_clt_write_long_nwk_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->Attr_Handle = htob(Attr_Handle, 2);
  index_input += 2;
  cp0->Val_Offset = htob(Val_Offset, 2);
  index_input += 2;
  cp0->Attribute_Val_Length = htob(Attribute_Val_Length, 2);
  index_input += 2;
  /* var_len_data input */
  {
    Osal_MemCpy((void *) &cp0->Attribute_Val, (const void *) Attribute_Val, Attribute_Val_Length*sizeof(uint8_t));
    index_input += Attribute_Val_Length*sizeof(uint8_t);
  }
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x11d;
  rq.event = 0x0F;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gatt_clt_write_char_reliable_nwk(uint16_t Connection_Handle,
                                                uint16_t Attr_Handle,
                                                uint16_t Val_Offset,
                                                uint16_t Attribute_Val_Length,
                                                uint8_t Attribute_Val[])
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gatt_clt_write_char_reliable_nwk_cp0 *cp0 = (aci_gatt_clt_write_char_reliable_nwk_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->Attr_Handle = htob(Attr_Handle, 2);
  index_input += 2;
  cp0->Val_Offset = htob(Val_Offset, 2);
  index_input += 2;
  cp0->Attribute_Val_Length = htob(Attribute_Val_Length, 2);
  index_input += 2;
  /* var_len_data input */
  {
    Osal_MemCpy((void *) &cp0->Attribute_Val, (const void *) Attribute_Val, Attribute_Val_Length*sizeof(uint8_t));
    index_input += Attribute_Val_Length*sizeof(uint8_t);
  }
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x11e;
  rq.event = 0x0F;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gatt_clt_write_without_resp(uint16_t Connection_Handle,
                                           uint16_t Attr_Handle,
                                           uint16_t Attribute_Val_Length,
                                           uint8_t Attribute_Val[])
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gatt_clt_write_without_resp_cp0 *cp0 = (aci_gatt_clt_write_without_resp_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->Attr_Handle = htob(Attr_Handle, 2);
  index_input += 2;
  cp0->Attribute_Val_Length = htob(Attribute_Val_Length, 2);
  index_input += 2;
  /* var_len_data input */
  {
    Osal_MemCpy((void *) &cp0->Attribute_Val, (const void *) Attribute_Val, Attribute_Val_Length*sizeof(uint8_t));
    index_input += Attribute_Val_Length*sizeof(uint8_t);
  }
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x123;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gatt_clt_signed_write_without_resp(uint16_t Connection_Handle,
                                                  uint16_t Attr_Handle,
                                                  uint16_t Attribute_Val_Length,
                                                  uint8_t Attribute_Val[])
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gatt_clt_signed_write_without_resp_cp0 *cp0 = (aci_gatt_clt_signed_write_without_resp_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->Attr_Handle = htob(Attr_Handle, 2);
  index_input += 2;
  cp0->Attribute_Val_Length = htob(Attribute_Val_Length, 2);
  index_input += 2;
  /* var_len_data input */
  {
    Osal_MemCpy((void *) &cp0->Attribute_Val, (const void *) Attribute_Val, Attribute_Val_Length*sizeof(uint8_t));
    index_input += Attribute_Val_Length*sizeof(uint8_t);
  }
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x124;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gatt_clt_confirm_indication(uint16_t Connection_Handle)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gatt_clt_confirm_indication_cp0 *cp0 = (aci_gatt_clt_confirm_indication_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x125;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gatt_srv_set_security_permission_nwk(uint16_t Attr_Handle,
                                                    uint8_t Security_Permissions)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gatt_srv_set_security_permission_nwk_cp0 *cp0 = (aci_gatt_srv_set_security_permission_nwk_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Attr_Handle = htob(Attr_Handle, 2);
  index_input += 2;
  cp0->Security_Permissions = htob(Security_Permissions, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x128;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gatt_srv_read_handle_value_nwk(uint16_t Attr_Handle,
                                              uint16_t Offset,
                                              uint16_t Value_Length_Requested,
                                              uint16_t *Length,
                                              uint16_t *Value_Length,
                                              uint8_t Value[])
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gatt_srv_read_handle_value_nwk_cp0 *cp0 = (aci_gatt_srv_read_handle_value_nwk_cp0*)(cmd_buffer);
  aci_gatt_srv_read_handle_value_nwk_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  uint8_t index_input = 0;
  cp0->Attr_Handle = htob(Attr_Handle, 2);
  index_input += 2;
  cp0->Offset = htob(Offset, 2);
  index_input += 2;
  cp0->Value_Length_Requested = htob(Value_Length_Requested, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x12a;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  *Length = btoh(resp.Length, 2);
  *Value_Length = btoh(resp.Value_Length, 2);
  Osal_MemCpy((void *) Value, (const void *) resp.Value, *Value_Length*sizeof(uint8_t));
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gatt_srv_set_access_permission_nwk(uint16_t Attr_Handle,
                                                  uint8_t Access_Permissions)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gatt_srv_set_access_permission_nwk_cp0 *cp0 = (aci_gatt_srv_set_access_permission_nwk_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Attr_Handle = htob(Attr_Handle, 2);
  index_input += 2;
  cp0->Access_Permissions = htob(Access_Permissions, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x12e;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gatt_srv_notify(uint16_t Connection_Handle,
                               uint16_t Attr_Handle,
                               uint8_t Flags,
                               uint16_t Val_Length,
                               uint8_t Val[])
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gatt_srv_notify_cp0 *cp0 = (aci_gatt_srv_notify_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->Attr_Handle = htob(Attr_Handle, 2);
  index_input += 2;
  cp0->Flags = htob(Flags, 1);
  index_input += 1;
  cp0->Val_Length = htob(Val_Length, 2);
  index_input += 2;
  /* var_len_data input */
  {
    Osal_MemCpy((void *) &cp0->Val, (const void *) Val, Val_Length*sizeof(uint8_t));
    index_input += Val_Length*sizeof(uint8_t);
  }
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x12f;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gatt_srv_exec_write_resp_nwk(uint16_t Conn_Handle,
                                            uint8_t Exec)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gatt_srv_exec_write_resp_nwk_cp0 *cp0 = (aci_gatt_srv_exec_write_resp_nwk_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Conn_Handle = htob(Conn_Handle, 2);
  index_input += 2;
  cp0->Exec = htob(Exec, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x131;
  rq.event = 0x0F;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gatt_srv_authorize_resp_nwk(uint16_t Conn_Handle,
                                           uint16_t Attr_Handle,
                                           uint8_t Operation_Type,
                                           uint8_t Error_Code,
                                           uint16_t Attr_Val_Offset,
                                           uint16_t Data_Length,
                                           uint8_t Data[])
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gatt_srv_authorize_resp_nwk_cp0 *cp0 = (aci_gatt_srv_authorize_resp_nwk_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Conn_Handle = htob(Conn_Handle, 2);
  index_input += 2;
  cp0->Attr_Handle = htob(Attr_Handle, 2);
  index_input += 2;
  cp0->Operation_Type = htob(Operation_Type, 1);
  index_input += 1;
  cp0->Error_Code = htob(Error_Code, 1);
  index_input += 1;
  cp0->Attr_Val_Offset = htob(Attr_Val_Offset, 2);
  index_input += 2;
  cp0->Data_Length = htob(Data_Length, 2);
  index_input += 2;
  /* var_len_data input */
  {
    Osal_MemCpy((void *) &cp0->Data, (const void *) Data, Data_Length*sizeof(uint8_t));
    index_input += Data_Length*sizeof(uint8_t);
  }
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x133;
  rq.event = 0x0F;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gatt_srv_read_prepare_queue_nwk(uint16_t Conn_Handle,
                                               uint8_t Item_Index,
                                               uint16_t *Attr_Handle,
                                               uint16_t *Value_Offset,
                                               uint16_t *Value_Length,
                                               uint8_t Value[])
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gatt_srv_read_prepare_queue_nwk_cp0 *cp0 = (aci_gatt_srv_read_prepare_queue_nwk_cp0*)(cmd_buffer);
  aci_gatt_srv_read_prepare_queue_nwk_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  uint8_t index_input = 0;
  cp0->Conn_Handle = htob(Conn_Handle, 2);
  index_input += 2;
  cp0->Item_Index = htob(Item_Index, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x135;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  *Attr_Handle = btoh(resp.Attr_Handle, 2);
  *Value_Offset = btoh(resp.Value_Offset, 2);
  *Value_Length = btoh(resp.Value_Length, 2);
  Osal_MemCpy((void *) Value, (const void *) resp.Value, *Value_Length*sizeof(uint8_t));
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gatt_srv_write_multiple_instance_handle_value(uint16_t Connection_Handle,
                                                             uint16_t Attr_Handle,
                                                             uint16_t Value_Length,
                                                             uint8_t Value[])
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gatt_srv_write_multiple_instance_handle_value_cp0 *cp0 = (aci_gatt_srv_write_multiple_instance_handle_value_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->Attr_Handle = htob(Attr_Handle, 2);
  index_input += 2;
  cp0->Value_Length = htob(Value_Length, 2);
  index_input += 2;
  /* var_len_data input */
  {
    Osal_MemCpy((void *) &cp0->Value, (const void *) Value, Value_Length*sizeof(uint8_t));
    index_input += Value_Length*sizeof(uint8_t);
  }
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x136;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gatt_srv_read_multiple_instance_handle_value_nwk(uint16_t Connection_Handle,
                                                                uint16_t Attr_Handle,
                                                                uint16_t *Value_Length,
                                                                uint8_t Value[])
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gatt_srv_read_multiple_instance_handle_value_nwk_cp0 *cp0 = (aci_gatt_srv_read_multiple_instance_handle_value_nwk_cp0*)(cmd_buffer);
  aci_gatt_srv_read_multiple_instance_handle_value_nwk_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->Attr_Handle = htob(Attr_Handle, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x137;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  *Value_Length = btoh(resp.Value_Length, 2);
  Osal_MemCpy((void *) Value, (const void *) resp.Value, *Value_Length*sizeof(uint8_t));
  return BLE_STATUS_SUCCESS;
}
