

/**
  ******************************************************************************
  * @file    bluenrg_lp_gap_aci.c
  * @author  AMS - RF Application team
  * @date    26 April 2021
  * @brief   Source file for external uC - BlueNRG-x in network coprocessor mode (gap_aci)
  *          Autogenerated files, do not edit!!
  ******************************************************************************
  * @attention
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  *
  * <h2><center>&copy; COPYRIGHT STMicroelectronics</center></h2>
  ******************************************************************************
  */
#include "bluenrg_lp_gap_aci.h"
#include "osal.h"
tBleStatus aci_gap_set_io_capability(uint8_t IO_Capability)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_set_io_capability_cp0 *cp0 = (aci_gap_set_io_capability_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->IO_Capability = htob(IO_Capability, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x085;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_set_authentication_requirement(uint8_t Bonding_Mode,
                                                  uint8_t MITM_Mode,
                                                  uint8_t SC_Support,
                                                  uint8_t KeyPress_Notification_Support,
                                                  uint8_t Min_Encryption_Key_Size,
                                                  uint8_t Max_Encryption_Key_Size,
                                                  uint8_t Use_Fixed_Pin,
                                                  uint32_t Fixed_Pin)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_set_authentication_requirement_cp0 *cp0 = (aci_gap_set_authentication_requirement_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Bonding_Mode = htob(Bonding_Mode, 1);
  index_input += 1;
  cp0->MITM_Mode = htob(MITM_Mode, 1);
  index_input += 1;
  cp0->SC_Support = htob(SC_Support, 1);
  index_input += 1;
  cp0->KeyPress_Notification_Support = htob(KeyPress_Notification_Support, 1);
  index_input += 1;
  cp0->Min_Encryption_Key_Size = htob(Min_Encryption_Key_Size, 1);
  index_input += 1;
  cp0->Max_Encryption_Key_Size = htob(Max_Encryption_Key_Size, 1);
  index_input += 1;
  cp0->Use_Fixed_Pin = htob(Use_Fixed_Pin, 1);
  index_input += 1;
  cp0->Fixed_Pin = htob(Fixed_Pin, 4);
  index_input += 4;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x086;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_set_authorization_requirement(uint16_t Connection_Handle,
                                                 uint8_t Authorization_Enable)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_set_authorization_requirement_cp0 *cp0 = (aci_gap_set_authorization_requirement_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->Authorization_Enable = htob(Authorization_Enable, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x087;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_pass_key_resp(uint16_t Connection_Handle,
                                 uint32_t Pass_Key)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_pass_key_resp_cp0 *cp0 = (aci_gap_pass_key_resp_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->Pass_Key = htob(Pass_Key, 4);
  index_input += 4;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x088;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_authorization_resp(uint16_t Connection_Handle,
                                      uint8_t Authorize)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_authorization_resp_cp0 *cp0 = (aci_gap_authorization_resp_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->Authorize = htob(Authorize, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x089;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_init(uint8_t Role,
                        uint8_t Privacy_Type,
                        uint8_t Device_Name_Char_Len,
                        uint8_t Identity_Address_Type,
                        uint16_t *Service_Handle,
                        uint16_t *Dev_Name_Char_Handle,
                        uint16_t *Appearance_Char_Handle)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_init_cp0 *cp0 = (aci_gap_init_cp0*)(cmd_buffer);
  aci_gap_init_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  uint8_t index_input = 0;
  cp0->Role = htob(Role, 1);
  index_input += 1;
  cp0->Privacy_Type = htob(Privacy_Type, 1);
  index_input += 1;
  cp0->Device_Name_Char_Len = htob(Device_Name_Char_Len, 1);
  index_input += 1;
  cp0->Identity_Address_Type = htob(Identity_Address_Type, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x08a;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  *Service_Handle = btoh(resp.Service_Handle, 2);
  *Dev_Name_Char_Handle = btoh(resp.Dev_Name_Char_Handle, 2);
  *Appearance_Char_Handle = btoh(resp.Appearance_Char_Handle, 2);
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_slave_security_req(uint16_t Connection_Handle)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_slave_security_req_cp0 *cp0 = (aci_gap_slave_security_req_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x08d;
  rq.event = 0x0F;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_get_security_level(uint16_t Connection_Handle,
                                      uint8_t *Security_Mode,
                                      uint8_t *Security_Level)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_get_security_level_cp0 *cp0 = (aci_gap_get_security_level_cp0*)(cmd_buffer);
  aci_gap_get_security_level_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x090;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  *Security_Mode = btoh(resp.Security_Mode, 1);
  *Security_Level = btoh(resp.Security_Level, 1);
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_set_event_mask(uint16_t GAP_Evt_Mask)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_set_event_mask_cp0 *cp0 = (aci_gap_set_event_mask_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->GAP_Evt_Mask = htob(GAP_Evt_Mask, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x091;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_terminate(uint16_t Connection_Handle,
                             uint8_t Reason)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_terminate_cp0 *cp0 = (aci_gap_terminate_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->Reason = htob(Reason, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x093;
  rq.event = 0x0F;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_clear_security_db(void)
{
  struct hci_request rq;
  tBleStatus status = 0;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x094;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_allow_rebond(uint16_t Connection_Handle)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_allow_rebond_cp0 *cp0 = (aci_gap_allow_rebond_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x095;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_create_connection(uint8_t Initiating_PHY,
                                     uint8_t Peer_Address_Type,
                                     uint8_t Peer_Address[6])
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_create_connection_cp0 *cp0 = (aci_gap_create_connection_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Initiating_PHY = htob(Initiating_PHY, 1);
  index_input += 1;
  cp0->Peer_Address_Type = htob(Peer_Address_Type, 1);
  index_input += 1;
  Osal_MemCpy((void *) &cp0->Peer_Address, (const void *) Peer_Address, 6);
  index_input += 6;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x09c;
  rq.event = 0x0F;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_terminate_proc(uint8_t Procedure_Code)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_terminate_proc_cp0 *cp0 = (aci_gap_terminate_proc_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Procedure_Code = htob(Procedure_Code, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x09d;
  rq.event = 0x0F;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_start_connection_update(uint16_t Connection_Handle,
                                           uint16_t Conn_Interval_Min,
                                           uint16_t Conn_Interval_Max,
                                           uint16_t Conn_Latency,
                                           uint16_t Supervision_Timeout,
                                           uint16_t Minimum_CE_Length,
                                           uint16_t Maximum_CE_Length)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_start_connection_update_cp0 *cp0 = (aci_gap_start_connection_update_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->Conn_Interval_Min = htob(Conn_Interval_Min, 2);
  index_input += 2;
  cp0->Conn_Interval_Max = htob(Conn_Interval_Max, 2);
  index_input += 2;
  cp0->Conn_Latency = htob(Conn_Latency, 2);
  index_input += 2;
  cp0->Supervision_Timeout = htob(Supervision_Timeout, 2);
  index_input += 2;
  cp0->Minimum_CE_Length = htob(Minimum_CE_Length, 2);
  index_input += 2;
  cp0->Maximum_CE_Length = htob(Maximum_CE_Length, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x09e;
  rq.event = 0x0F;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_send_pairing_req(uint16_t Connection_Handle,
                                    uint8_t Force_Rebond)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_send_pairing_req_cp0 *cp0 = (aci_gap_send_pairing_req_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->Force_Rebond = htob(Force_Rebond, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x09f;
  rq.event = 0x0F;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_resolve_private_addr(uint8_t Address[6],
                                        uint8_t Actual_Address[6])
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_resolve_private_addr_cp0 *cp0 = (aci_gap_resolve_private_addr_cp0*)(cmd_buffer);
  aci_gap_resolve_private_addr_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  uint8_t index_input = 0;
  Osal_MemCpy((void *) &cp0->Address, (const void *) Address, 6);
  index_input += 6;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x0a0;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  Osal_MemCpy((void *) Actual_Address, (const void *) resp.Actual_Address, 6);
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_get_bonded_devices(uint8_t Offset,
                                      uint8_t Max_Num_Of_Addresses,
                                      uint8_t *Num_of_Addresses,
                                      Bonded_Device_Entry_t Bonded_Device_Entry[])
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_get_bonded_devices_cp0 *cp0 = (aci_gap_get_bonded_devices_cp0*)(cmd_buffer);
  aci_gap_get_bonded_devices_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  uint8_t index_input = 0;
  cp0->Offset = htob(Offset, 1);
  index_input += 1;
  cp0->Max_Num_Of_Addresses = htob(Max_Num_Of_Addresses, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x0a3;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  *Num_of_Addresses = btoh(resp.Num_of_Addresses, 1);
  Osal_MemCpy((void *) Bonded_Device_Entry, (const void *) resp.Bonded_Device_Entry, *Num_of_Addresses*sizeof(Bonded_Device_Entry_t));
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_is_device_bonded(uint8_t Peer_Address_Type,
                                    uint8_t Peer_Address[6])
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_is_device_bonded_cp0 *cp0 = (aci_gap_is_device_bonded_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Peer_Address_Type = htob(Peer_Address_Type, 1);
  index_input += 1;
  Osal_MemCpy((void *) &cp0->Peer_Address, (const void *) Peer_Address, 6);
  index_input += 6;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x0a4;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_numeric_comparison_value_confirm_yesno(uint16_t Connection_Handle,
                                                          uint8_t Confirm_Yes_No)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_numeric_comparison_value_confirm_yesno_cp0 *cp0 = (aci_gap_numeric_comparison_value_confirm_yesno_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->Confirm_Yes_No = htob(Confirm_Yes_No, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x0a5;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_passkey_input(uint16_t Connection_Handle,
                                 uint8_t Input_Type)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_passkey_input_cp0 *cp0 = (aci_gap_passkey_input_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->Input_Type = htob(Input_Type, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x0a6;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_get_oob_data(uint8_t OOB_Data_Type,
                                uint8_t *Address_Type,
                                uint8_t Address[6],
                                uint8_t *OOB_Data_Len,
                                uint8_t OOB_Data[16])
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_get_oob_data_cp0 *cp0 = (aci_gap_get_oob_data_cp0*)(cmd_buffer);
  aci_gap_get_oob_data_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  uint8_t index_input = 0;
  cp0->OOB_Data_Type = htob(OOB_Data_Type, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x0a7;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  *Address_Type = btoh(resp.Address_Type, 1);
  Osal_MemCpy((void *) Address, (const void *) resp.Address, 6);
  *OOB_Data_Len = btoh(resp.OOB_Data_Len, 1);
  Osal_MemCpy((void *) OOB_Data, (const void *) resp.OOB_Data, 16);
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_set_oob_data(uint8_t Device_Type,
                                uint8_t Address_Type,
                                uint8_t Address[6],
                                uint8_t OOB_Data_Type,
                                uint8_t OOB_Data_Len,
                                uint8_t OOB_Data[16])
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_set_oob_data_cp0 *cp0 = (aci_gap_set_oob_data_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Device_Type = htob(Device_Type, 1);
  index_input += 1;
  cp0->Address_Type = htob(Address_Type, 1);
  index_input += 1;
  Osal_MemCpy((void *) &cp0->Address, (const void *) Address, 6);
  index_input += 6;
  cp0->OOB_Data_Type = htob(OOB_Data_Type, 1);
  index_input += 1;
  cp0->OOB_Data_Len = htob(OOB_Data_Len, 1);
  index_input += 1;
  Osal_MemCpy((void *) &cp0->OOB_Data, (const void *) OOB_Data, 16);
  index_input += 16;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x0a8;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_remove_bonded_device(uint8_t Peer_Identity_Address_Type,
                                        uint8_t Peer_Identity_Address[6])
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_remove_bonded_device_cp0 *cp0 = (aci_gap_remove_bonded_device_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Peer_Identity_Address_Type = htob(Peer_Identity_Address_Type, 1);
  index_input += 1;
  Osal_MemCpy((void *) &cp0->Peer_Identity_Address, (const void *) Peer_Identity_Address, 6);
  index_input += 6;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x0aa;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_set_advertising_configuration(uint8_t Advertising_Handle,
                                                 uint8_t Discoverable_Mode,
                                                 uint16_t Advertising_Event_Properties,
                                                 uint32_t Primary_Advertising_Interval_Min,
                                                 uint32_t Primary_Advertising_Interval_Max,
                                                 uint8_t Primary_Advertising_Channel_Map,
                                                 uint8_t Peer_Address_Type,
                                                 uint8_t Peer_Address[6],
                                                 uint8_t Advertising_Filter_Policy,
                                                 int8_t Advertising_Tx_Power,
                                                 uint8_t Primary_Advertising_PHY,
                                                 uint8_t Secondary_Advertising_Max_Skip,
                                                 uint8_t Secondary_Advertising_PHY,
                                                 uint8_t Advertising_SID,
                                                 uint8_t Scan_Request_Notification_Enable)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_set_advertising_configuration_cp0 *cp0 = (aci_gap_set_advertising_configuration_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Advertising_Handle = htob(Advertising_Handle, 1);
  index_input += 1;
  cp0->Discoverable_Mode = htob(Discoverable_Mode, 1);
  index_input += 1;
  cp0->Advertising_Event_Properties = htob(Advertising_Event_Properties, 2);
  index_input += 2;
  cp0->Primary_Advertising_Interval_Min = htob(Primary_Advertising_Interval_Min, 4);
  index_input += 4;
  cp0->Primary_Advertising_Interval_Max = htob(Primary_Advertising_Interval_Max, 4);
  index_input += 4;
  cp0->Primary_Advertising_Channel_Map = htob(Primary_Advertising_Channel_Map, 1);
  index_input += 1;
  cp0->Peer_Address_Type = htob(Peer_Address_Type, 1);
  index_input += 1;
  Osal_MemCpy((void *) &cp0->Peer_Address, (const void *) Peer_Address, 6);
  index_input += 6;
  cp0->Advertising_Filter_Policy = htob(Advertising_Filter_Policy, 1);
  index_input += 1;
  cp0->Advertising_Tx_Power = htob(Advertising_Tx_Power, 1);
  index_input += 1;
  cp0->Primary_Advertising_PHY = htob(Primary_Advertising_PHY, 1);
  index_input += 1;
  cp0->Secondary_Advertising_Max_Skip = htob(Secondary_Advertising_Max_Skip, 1);
  index_input += 1;
  cp0->Secondary_Advertising_PHY = htob(Secondary_Advertising_PHY, 1);
  index_input += 1;
  cp0->Advertising_SID = htob(Advertising_SID, 1);
  index_input += 1;
  cp0->Scan_Request_Notification_Enable = htob(Scan_Request_Notification_Enable, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x0ab;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_set_advertising_enable(uint8_t Enable,
                                          uint8_t Number_of_Sets,
                                          Advertising_Set_Parameters_t Advertising_Set_Parameters[])
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_set_advertising_enable_cp0 *cp0 = (aci_gap_set_advertising_enable_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Enable = htob(Enable, 1);
  index_input += 1;
  cp0->Number_of_Sets = htob(Number_of_Sets, 1);
  index_input += 1;
  /* var_len_data input */
  {
    for (int i = 0; i < Number_of_Sets; i++) {
      cp0->Advertising_Set_Parameters[i].Advertising_Handle = Advertising_Set_Parameters[i].Advertising_Handle;
      cp0->Advertising_Set_Parameters[i].Duration = Advertising_Set_Parameters[i].Duration;
      cp0->Advertising_Set_Parameters[i].Max_Extended_Advertising_Events = Advertising_Set_Parameters[i].Max_Extended_Advertising_Events;
    }
    index_input += Number_of_Sets*4;
  }
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x0ac;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_set_advertising_data_nwk(uint8_t Advertising_Handle,
                                            uint8_t Operation,
                                            uint8_t Advertising_Data_Length,
                                            uint8_t Advertising_Data[])
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_set_advertising_data_nwk_cp0 *cp0 = (aci_gap_set_advertising_data_nwk_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Advertising_Handle = htob(Advertising_Handle, 1);
  index_input += 1;
  cp0->Operation = htob(Operation, 1);
  index_input += 1;
  cp0->Advertising_Data_Length = htob(Advertising_Data_Length, 1);
  index_input += 1;
  /* var_len_data input */
  {
    Osal_MemCpy((void *) &cp0->Advertising_Data, (const void *) Advertising_Data, Advertising_Data_Length*sizeof(uint8_t));
    index_input += Advertising_Data_Length*sizeof(uint8_t);
  }
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x0ad;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_set_scan_response_data_nwk(uint8_t Advertising_Handle,
                                              uint8_t Operation,
                                              uint8_t Scan_Response_Data_Length,
                                              uint8_t Scan_Response_Data[])
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_set_scan_response_data_nwk_cp0 *cp0 = (aci_gap_set_scan_response_data_nwk_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Advertising_Handle = htob(Advertising_Handle, 1);
  index_input += 1;
  cp0->Operation = htob(Operation, 1);
  index_input += 1;
  cp0->Scan_Response_Data_Length = htob(Scan_Response_Data_Length, 1);
  index_input += 1;
  /* var_len_data input */
  {
    Osal_MemCpy((void *) &cp0->Scan_Response_Data, (const void *) Scan_Response_Data, Scan_Response_Data_Length*sizeof(uint8_t));
    index_input += Scan_Response_Data_Length*sizeof(uint8_t);
  }
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x0ae;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_set_scan_configuration(uint8_t Filter_Duplicates,
                                          uint8_t Scanning_Filter_Policy,
                                          uint8_t Scanning_PHY,
                                          uint8_t Scan_Type,
                                          uint16_t Scan_Interval,
                                          uint16_t Scan_Window)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_set_scan_configuration_cp0 *cp0 = (aci_gap_set_scan_configuration_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Filter_Duplicates = htob(Filter_Duplicates, 1);
  index_input += 1;
  cp0->Scanning_Filter_Policy = htob(Scanning_Filter_Policy, 1);
  index_input += 1;
  cp0->Scanning_PHY = htob(Scanning_PHY, 1);
  index_input += 1;
  cp0->Scan_Type = htob(Scan_Type, 1);
  index_input += 1;
  cp0->Scan_Interval = htob(Scan_Interval, 2);
  index_input += 2;
  cp0->Scan_Window = htob(Scan_Window, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x0af;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_set_connection_configuration(uint8_t Initiating_PHY,
                                                uint16_t Conn_Interval_Min,
                                                uint16_t Conn_Interval_Max,
                                                uint16_t Conn_Latency,
                                                uint16_t Supervision_Timeout,
                                                uint16_t Minimum_CE_Length,
                                                uint16_t Maximum_CE_Length)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_set_connection_configuration_cp0 *cp0 = (aci_gap_set_connection_configuration_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Initiating_PHY = htob(Initiating_PHY, 1);
  index_input += 1;
  cp0->Conn_Interval_Min = htob(Conn_Interval_Min, 2);
  index_input += 2;
  cp0->Conn_Interval_Max = htob(Conn_Interval_Max, 2);
  index_input += 2;
  cp0->Conn_Latency = htob(Conn_Latency, 2);
  index_input += 2;
  cp0->Supervision_Timeout = htob(Supervision_Timeout, 2);
  index_input += 2;
  cp0->Minimum_CE_Length = htob(Minimum_CE_Length, 2);
  index_input += 2;
  cp0->Maximum_CE_Length = htob(Maximum_CE_Length, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x0b0;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_start_procedure(uint8_t Procedure_Code,
                                   uint8_t PHYs,
                                   uint16_t Duration,
                                   uint16_t Period)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_start_procedure_cp0 *cp0 = (aci_gap_start_procedure_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Procedure_Code = htob(Procedure_Code, 1);
  index_input += 1;
  cp0->PHYs = htob(PHYs, 1);
  index_input += 1;
  cp0->Duration = htob(Duration, 2);
  index_input += 2;
  cp0->Period = htob(Period, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x0b1;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_discover_name(uint8_t PHYs,
                                 uint8_t Peer_Address_Type,
                                 uint8_t Peer_Address[6])
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_discover_name_cp0 *cp0 = (aci_gap_discover_name_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->PHYs = htob(PHYs, 1);
  index_input += 1;
  cp0->Peer_Address_Type = htob(Peer_Address_Type, 1);
  index_input += 1;
  Osal_MemCpy((void *) &cp0->Peer_Address, (const void *) Peer_Address, 6);
  index_input += 6;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x0b2;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_add_devices_to_white_and_resolving_list(uint8_t Lists,
                                                           uint8_t Clear_Lists,
                                                           uint8_t Num_of_List_Entries,
                                                           List_Entry_t List_Entry[])
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_add_devices_to_white_and_resolving_list_cp0 *cp0 = (aci_gap_add_devices_to_white_and_resolving_list_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Lists = htob(Lists, 1);
  index_input += 1;
  cp0->Clear_Lists = htob(Clear_Lists, 1);
  index_input += 1;
  cp0->Num_of_List_Entries = htob(Num_of_List_Entries, 1);
  index_input += 1;
  /* var_len_data input */
  {
    for (int i = 0; i < Num_of_List_Entries; i++) {
      cp0->List_Entry[i].Peer_Address_Type = List_Entry[i].Peer_Address_Type;
      Osal_MemCpy((void *) &cp0->List_Entry[i].Peer_Address, (const void *) &List_Entry[i].Peer_Address, 6);
    }
    index_input += Num_of_List_Entries*7;
  }
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x0b3;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_configure_white_and_resolving_list(uint8_t Lists)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_configure_white_and_resolving_list_cp0 *cp0 = (aci_gap_configure_white_and_resolving_list_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Lists = htob(Lists, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x0b4;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_set_periodic_advertising_configuration(uint8_t Advertising_Handle,
                                                          uint16_t Periodic_Advertising_Interval_Min,
                                                          uint16_t Periodic_Advertising_Interval_Max,
                                                          uint16_t Periodic_Advertising_Properties)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_set_periodic_advertising_configuration_cp0 *cp0 = (aci_gap_set_periodic_advertising_configuration_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Advertising_Handle = htob(Advertising_Handle, 1);
  index_input += 1;
  cp0->Periodic_Advertising_Interval_Min = htob(Periodic_Advertising_Interval_Min, 2);
  index_input += 2;
  cp0->Periodic_Advertising_Interval_Max = htob(Periodic_Advertising_Interval_Max, 2);
  index_input += 2;
  cp0->Periodic_Advertising_Properties = htob(Periodic_Advertising_Properties, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x0b5;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_set_periodic_advertising_data_nwk(uint8_t Advertising_Handle,
                                                     uint8_t Operation,
                                                     uint8_t Advertising_Data_Length,
                                                     uint8_t Advertising_Data[])
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_set_periodic_advertising_data_nwk_cp0 *cp0 = (aci_gap_set_periodic_advertising_data_nwk_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Advertising_Handle = htob(Advertising_Handle, 1);
  index_input += 1;
  cp0->Operation = htob(Operation, 1);
  index_input += 1;
  cp0->Advertising_Data_Length = htob(Advertising_Data_Length, 1);
  index_input += 1;
  /* var_len_data input */
  {
    Osal_MemCpy((void *) &cp0->Advertising_Data, (const void *) Advertising_Data, Advertising_Data_Length*sizeof(uint8_t));
    index_input += Advertising_Data_Length*sizeof(uint8_t);
  }
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x0b6;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_set_periodic_advertising_enable(uint8_t Enable,
                                                   uint8_t Advertising_Handle)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_set_periodic_advertising_enable_cp0 *cp0 = (aci_gap_set_periodic_advertising_enable_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Enable = htob(Enable, 1);
  index_input += 1;
  cp0->Advertising_Handle = htob(Advertising_Handle, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x0b7;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_periodic_advertising_create_sync(uint8_t Options,
                                                    uint8_t Advertising_SID,
                                                    uint8_t Advertising_Address_Type,
                                                    uint8_t Advertiser_Address[6],
                                                    uint16_t Skip,
                                                    uint16_t Sync_Timeout,
                                                    uint8_t Sync_CTE_Type)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_periodic_advertising_create_sync_cp0 *cp0 = (aci_gap_periodic_advertising_create_sync_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Options = htob(Options, 1);
  index_input += 1;
  cp0->Advertising_SID = htob(Advertising_SID, 1);
  index_input += 1;
  cp0->Advertising_Address_Type = htob(Advertising_Address_Type, 1);
  index_input += 1;
  Osal_MemCpy((void *) &cp0->Advertiser_Address, (const void *) Advertiser_Address, 6);
  index_input += 6;
  cp0->Skip = htob(Skip, 2);
  index_input += 2;
  cp0->Sync_Timeout = htob(Sync_Timeout, 2);
  index_input += 2;
  cp0->Sync_CTE_Type = htob(Sync_CTE_Type, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x0b8;
  rq.event = 0x0F;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_periodic_advertising_create_sync_cancel(void)
{
  struct hci_request rq;
  tBleStatus status = 0;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x0b9;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_remove_advertising_set(uint8_t Advertising_Handle)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_remove_advertising_set_cp0 *cp0 = (aci_gap_remove_advertising_set_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Advertising_Handle = htob(Advertising_Handle, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x0ba;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_clear_advertising_sets(void)
{
  struct hci_request rq;
  tBleStatus status = 0;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x0bb;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_periodic_advertising_terminate_sync(uint16_t Sync_Handle)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_periodic_advertising_terminate_sync_cp0 *cp0 = (aci_gap_periodic_advertising_terminate_sync_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Sync_Handle = htob(Sync_Handle, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x0c0;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_add_device_to_periodic_advertiser_list(uint8_t Advertiser_Address_Type,
                                                          uint8_t Advertiser_Address[6],
                                                          uint8_t Advertising_SID)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_add_device_to_periodic_advertiser_list_cp0 *cp0 = (aci_gap_add_device_to_periodic_advertiser_list_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Advertiser_Address_Type = htob(Advertiser_Address_Type, 1);
  index_input += 1;
  Osal_MemCpy((void *) &cp0->Advertiser_Address, (const void *) Advertiser_Address, 6);
  index_input += 6;
  cp0->Advertising_SID = htob(Advertising_SID, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x0c1;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_remove_device_from_periodic_advertising_list(uint8_t Advertiser_Address_Type,
                                                                uint8_t Advertiser_Address[6],
                                                                uint8_t Advertising_SID)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_remove_device_from_periodic_advertising_list_cp0 *cp0 = (aci_gap_remove_device_from_periodic_advertising_list_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Advertiser_Address_Type = htob(Advertiser_Address_Type, 1);
  index_input += 1;
  Osal_MemCpy((void *) &cp0->Advertiser_Address, (const void *) Advertiser_Address, 6);
  index_input += 6;
  cp0->Advertising_SID = htob(Advertising_SID, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x0c2;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_clear_periodic_advertiser_list(void)
{
  struct hci_request rq;
  tBleStatus status = 0;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x0c3;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_read_periodic_advertiser_list_size(uint8_t *Periodic_Advertiser_List_Size)
{
  struct hci_request rq;
  aci_gap_read_periodic_advertiser_list_size_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x0c4;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  *Periodic_Advertiser_List_Size = btoh(resp.Periodic_Advertiser_List_Size, 1);
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_set_periodic_advertising_receive_enable(uint16_t Sync_Handle,
                                                           uint8_t Enable)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_set_periodic_advertising_receive_enable_cp0 *cp0 = (aci_gap_set_periodic_advertising_receive_enable_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Sync_Handle = htob(Sync_Handle, 2);
  index_input += 2;
  cp0->Enable = htob(Enable, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x0c5;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_periodic_advertising_sync_transfer(uint16_t Connection_Handle,
                                                      uint16_t Service_Data,
                                                      uint16_t Sync_Handle)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_periodic_advertising_sync_transfer_cp0 *cp0 = (aci_gap_periodic_advertising_sync_transfer_cp0*)(cmd_buffer);
  aci_gap_periodic_advertising_sync_transfer_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->Service_Data = htob(Service_Data, 2);
  index_input += 2;
  cp0->Sync_Handle = htob(Sync_Handle, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x0c6;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_periodic_advertising_set_info_transfer(uint16_t Connection_Handle,
                                                          uint16_t Service_Data,
                                                          uint8_t Advertising_Handle)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_periodic_advertising_set_info_transfer_cp0 *cp0 = (aci_gap_periodic_advertising_set_info_transfer_cp0*)(cmd_buffer);
  aci_gap_periodic_advertising_set_info_transfer_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->Service_Data = htob(Service_Data, 2);
  index_input += 2;
  cp0->Advertising_Handle = htob(Advertising_Handle, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x0c7;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_set_periodic_advertising_sync_transfer_parameters(uint16_t Connection_Handle,
                                                                     uint8_t Mode,
                                                                     uint16_t Skip,
                                                                     uint16_t Sync_Timeout,
                                                                     uint8_t CTE_Type)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_set_periodic_advertising_sync_transfer_parameters_cp0 *cp0 = (aci_gap_set_periodic_advertising_sync_transfer_parameters_cp0*)(cmd_buffer);
  aci_gap_set_periodic_advertising_sync_transfer_parameters_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->Mode = htob(Mode, 1);
  index_input += 1;
  cp0->Skip = htob(Skip, 2);
  index_input += 2;
  cp0->Sync_Timeout = htob(Sync_Timeout, 2);
  index_input += 2;
  cp0->CTE_Type = htob(CTE_Type, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x0c8;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus aci_gap_set_default_periodic_advertising_sync_transfer_parameters(uint8_t Mode,
                                                                             uint16_t Skip,
                                                                             uint16_t Sync_Timeout,
                                                                             uint8_t CTE_Type)
{
  struct hci_request rq;
  uint8_t cmd_buffer[532];
  aci_gap_set_default_periodic_advertising_sync_transfer_parameters_cp0 *cp0 = (aci_gap_set_default_periodic_advertising_sync_transfer_parameters_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Mode = htob(Mode, 1);
  index_input += 1;
  cp0->Skip = htob(Skip, 2);
  index_input += 2;
  cp0->Sync_Timeout = htob(Sync_Timeout, 2);
  index_input += 2;
  cp0->CTE_Type = htob(CTE_Type, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ext_aci = TRUE;
  rq.ogf = 0x3f;
  rq.ocf = 0x0c9;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
