

/**
  ******************************************************************************
  * @file    bluenrg_lp_hci_le.c
  * @author  AMS - RF Application team
  * @date    18 March 2021
  * @brief   Source file for external uC - BlueNRG-x in network coprocessor mode (hci_le)
  *          Autogenerated files, do not edit!!
  ******************************************************************************
  * @attention
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  *
  * <h2><center>&copy; COPYRIGHT STMicroelectronics</center></h2>
  ******************************************************************************
  */
#include "bluenrg_lp_hci_le.h"
#include "osal.h"
tBleStatus hci_disconnect(uint16_t Connection_Handle,
                          uint8_t Reason)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_disconnect_cp0 *cp0 = (hci_disconnect_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->Reason = htob(Reason, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x01;
  rq.ocf = 0x006;
  rq.event = 0x0F;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_read_remote_version_information(uint16_t Connection_Handle)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_read_remote_version_information_cp0 *cp0 = (hci_read_remote_version_information_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x01;
  rq.ocf = 0x01d;
  rq.event = 0x0F;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_set_event_mask(uint8_t Event_Mask[8])
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_set_event_mask_cp0 *cp0 = (hci_set_event_mask_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  Osal_MemCpy((void *) &cp0->Event_Mask, (const void *) Event_Mask, 8);
  index_input += 8;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x03;
  rq.ocf = 0x001;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_reset(void)
{
  struct hci_request rq;
  tBleStatus status = 0;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x03;
  rq.ocf = 0x003;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_read_transmit_power_level(uint16_t Connection_Handle,
                                         uint8_t Type,
                                         int8_t *Transmit_Power_Level)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_read_transmit_power_level_cp0 *cp0 = (hci_read_transmit_power_level_cp0*)(cmd_buffer);
  hci_read_transmit_power_level_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->Type = htob(Type, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x03;
  rq.ocf = 0x02d;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  *Transmit_Power_Level = btoh(resp.Transmit_Power_Level, 1);
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_set_event_mask_page_2(uint8_t Event_Mask_Page_2[8])
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_set_event_mask_page_2_cp0 *cp0 = (hci_set_event_mask_page_2_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  Osal_MemCpy((void *) &cp0->Event_Mask_Page_2, (const void *) Event_Mask_Page_2, 8);
  index_input += 8;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x03;
  rq.ocf = 0x063;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_read_authenticated_payload_timeout(uint16_t Connection_Handle,
                                                  uint16_t *Authenticated_Payload_Timeout)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_read_authenticated_payload_timeout_cp0 *cp0 = (hci_read_authenticated_payload_timeout_cp0*)(cmd_buffer);
  hci_read_authenticated_payload_timeout_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x03;
  rq.ocf = 0x07b;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  *Authenticated_Payload_Timeout = btoh(resp.Authenticated_Payload_Timeout, 2);
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_write_authenticated_payload_timeout(uint16_t Connection_Handle,
                                                   uint16_t Authenticated_Payload_Timeout)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_write_authenticated_payload_timeout_cp0 *cp0 = (hci_write_authenticated_payload_timeout_cp0*)(cmd_buffer);
  hci_write_authenticated_payload_timeout_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->Authenticated_Payload_Timeout = htob(Authenticated_Payload_Timeout, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x03;
  rq.ocf = 0x07c;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_read_local_version_information(uint8_t *HCI_Version,
                                              uint16_t *HCI_Revision,
                                              uint8_t *LMP_PAL_Version,
                                              uint16_t *Manufacturer_Name,
                                              uint16_t *LMP_PAL_Subversion)
{
  struct hci_request rq;
  hci_read_local_version_information_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x04;
  rq.ocf = 0x001;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  *HCI_Version = btoh(resp.HCI_Version, 1);
  *HCI_Revision = btoh(resp.HCI_Revision, 2);
  *LMP_PAL_Version = btoh(resp.LMP_PAL_Version, 1);
  *Manufacturer_Name = btoh(resp.Manufacturer_Name, 2);
  *LMP_PAL_Subversion = btoh(resp.LMP_PAL_Subversion, 2);
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_read_local_supported_commands(uint8_t Supported_Commands[64])
{
  struct hci_request rq;
  hci_read_local_supported_commands_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x04;
  rq.ocf = 0x002;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  Osal_MemCpy((void *) Supported_Commands, (const void *) resp.Supported_Commands, 64);
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_read_local_supported_features(uint8_t LMP_Features[8])
{
  struct hci_request rq;
  hci_read_local_supported_features_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x04;
  rq.ocf = 0x003;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  Osal_MemCpy((void *) LMP_Features, (const void *) resp.LMP_Features, 8);
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_read_bd_addr(uint8_t BD_ADDR[6])
{
  struct hci_request rq;
  hci_read_bd_addr_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x04;
  rq.ocf = 0x009;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  Osal_MemCpy((void *) BD_ADDR, (const void *) resp.BD_ADDR, 6);
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_read_rssi(uint16_t Connection_Handle,
                         int8_t *RSSI)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_read_rssi_cp0 *cp0 = (hci_read_rssi_cp0*)(cmd_buffer);
  hci_read_rssi_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x05;
  rq.ocf = 0x005;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  *RSSI = btoh(resp.RSSI, 1);
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_set_event_mask(uint8_t LE_Event_Mask[8])
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_set_event_mask_cp0 *cp0 = (hci_le_set_event_mask_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  Osal_MemCpy((void *) &cp0->LE_Event_Mask, (const void *) LE_Event_Mask, 8);
  index_input += 8;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x001;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_read_buffer_size(uint16_t *HC_LE_ACL_Data_Packet_Length,
                                   uint8_t *HC_Total_Num_LE_ACL_Data_Packets)
{
  struct hci_request rq;
  hci_le_read_buffer_size_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x002;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  *HC_LE_ACL_Data_Packet_Length = btoh(resp.HC_LE_ACL_Data_Packet_Length, 2);
  *HC_Total_Num_LE_ACL_Data_Packets = btoh(resp.HC_Total_Num_LE_ACL_Data_Packets, 1);
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_read_local_supported_features(uint8_t LE_Features[8])
{
  struct hci_request rq;
  hci_le_read_local_supported_features_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x003;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  Osal_MemCpy((void *) LE_Features, (const void *) resp.LE_Features, 8);
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_set_random_address(uint8_t Random_Address[6])
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_set_random_address_cp0 *cp0 = (hci_le_set_random_address_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  Osal_MemCpy((void *) &cp0->Random_Address, (const void *) Random_Address, 6);
  index_input += 6;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x005;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_set_advertising_parameters(uint16_t Advertising_Interval_Min,
                                             uint16_t Advertising_Interval_Max,
                                             uint8_t Advertising_Type,
                                             uint8_t Own_Address_Type,
                                             uint8_t Peer_Address_Type,
                                             uint8_t Peer_Address[6],
                                             uint8_t Advertising_Channel_Map,
                                             uint8_t Advertising_Filter_Policy)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_set_advertising_parameters_cp0 *cp0 = (hci_le_set_advertising_parameters_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Advertising_Interval_Min = htob(Advertising_Interval_Min, 2);
  index_input += 2;
  cp0->Advertising_Interval_Max = htob(Advertising_Interval_Max, 2);
  index_input += 2;
  cp0->Advertising_Type = htob(Advertising_Type, 1);
  index_input += 1;
  cp0->Own_Address_Type = htob(Own_Address_Type, 1);
  index_input += 1;
  cp0->Peer_Address_Type = htob(Peer_Address_Type, 1);
  index_input += 1;
  Osal_MemCpy((void *) &cp0->Peer_Address, (const void *) Peer_Address, 6);
  index_input += 6;
  cp0->Advertising_Channel_Map = htob(Advertising_Channel_Map, 1);
  index_input += 1;
  cp0->Advertising_Filter_Policy = htob(Advertising_Filter_Policy, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x006;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_read_advertising_channel_tx_power(int8_t *Transmit_Power_Level)
{
  struct hci_request rq;
  hci_le_read_advertising_channel_tx_power_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x007;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  *Transmit_Power_Level = btoh(resp.Transmit_Power_Level, 1);
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_set_advertising_data(uint8_t Advertising_Data_Length,
                                       uint8_t Advertising_Data[31])
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_set_advertising_data_cp0 *cp0 = (hci_le_set_advertising_data_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Advertising_Data_Length = htob(Advertising_Data_Length, 1);
  index_input += 1;
  Osal_MemCpy((void *) &cp0->Advertising_Data, (const void *) Advertising_Data, 31);
  index_input += 31;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x008;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_set_scan_response_data(uint8_t Scan_Response_Data_Length,
                                         uint8_t Scan_Response_Data[31])
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_set_scan_response_data_cp0 *cp0 = (hci_le_set_scan_response_data_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Scan_Response_Data_Length = htob(Scan_Response_Data_Length, 1);
  index_input += 1;
  Osal_MemCpy((void *) &cp0->Scan_Response_Data, (const void *) Scan_Response_Data, 31);
  index_input += 31;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x009;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_set_advertising_enable(uint8_t Advertising_Enable)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_set_advertising_enable_cp0 *cp0 = (hci_le_set_advertising_enable_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Advertising_Enable = htob(Advertising_Enable, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x00a;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_set_scan_parameters(uint8_t LE_Scan_Type,
                                      uint16_t LE_Scan_Interval,
                                      uint16_t LE_Scan_Window,
                                      uint8_t Own_Address_Type,
                                      uint8_t Scanning_Filter_Policy)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_set_scan_parameters_cp0 *cp0 = (hci_le_set_scan_parameters_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->LE_Scan_Type = htob(LE_Scan_Type, 1);
  index_input += 1;
  cp0->LE_Scan_Interval = htob(LE_Scan_Interval, 2);
  index_input += 2;
  cp0->LE_Scan_Window = htob(LE_Scan_Window, 2);
  index_input += 2;
  cp0->Own_Address_Type = htob(Own_Address_Type, 1);
  index_input += 1;
  cp0->Scanning_Filter_Policy = htob(Scanning_Filter_Policy, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x00b;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_set_scan_enable(uint8_t LE_Scan_Enable,
                                  uint8_t Filter_Duplicates)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_set_scan_enable_cp0 *cp0 = (hci_le_set_scan_enable_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->LE_Scan_Enable = htob(LE_Scan_Enable, 1);
  index_input += 1;
  cp0->Filter_Duplicates = htob(Filter_Duplicates, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x00c;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_create_connection(uint16_t LE_Scan_Interval,
                                    uint16_t LE_Scan_Window,
                                    uint8_t Initiator_Filter_Policy,
                                    uint8_t Peer_Address_Type,
                                    uint8_t Peer_Address[6],
                                    uint8_t Own_Address_Type,
                                    uint16_t Conn_Interval_Min,
                                    uint16_t Conn_Interval_Max,
                                    uint16_t Conn_Latency,
                                    uint16_t Supervision_Timeout,
                                    uint16_t Minimum_CE_Length,
                                    uint16_t Maximum_CE_Length)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_create_connection_cp0 *cp0 = (hci_le_create_connection_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->LE_Scan_Interval = htob(LE_Scan_Interval, 2);
  index_input += 2;
  cp0->LE_Scan_Window = htob(LE_Scan_Window, 2);
  index_input += 2;
  cp0->Initiator_Filter_Policy = htob(Initiator_Filter_Policy, 1);
  index_input += 1;
  cp0->Peer_Address_Type = htob(Peer_Address_Type, 1);
  index_input += 1;
  Osal_MemCpy((void *) &cp0->Peer_Address, (const void *) Peer_Address, 6);
  index_input += 6;
  cp0->Own_Address_Type = htob(Own_Address_Type, 1);
  index_input += 1;
  cp0->Conn_Interval_Min = htob(Conn_Interval_Min, 2);
  index_input += 2;
  cp0->Conn_Interval_Max = htob(Conn_Interval_Max, 2);
  index_input += 2;
  cp0->Conn_Latency = htob(Conn_Latency, 2);
  index_input += 2;
  cp0->Supervision_Timeout = htob(Supervision_Timeout, 2);
  index_input += 2;
  cp0->Minimum_CE_Length = htob(Minimum_CE_Length, 2);
  index_input += 2;
  cp0->Maximum_CE_Length = htob(Maximum_CE_Length, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x00d;
  rq.event = 0x0F;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_create_connection_cancel(void)
{
  struct hci_request rq;
  tBleStatus status = 0;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x00e;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_read_white_list_size(uint8_t *White_List_Size)
{
  struct hci_request rq;
  hci_le_read_white_list_size_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x00f;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  *White_List_Size = btoh(resp.White_List_Size, 1);
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_clear_white_list(void)
{
  struct hci_request rq;
  tBleStatus status = 0;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x010;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_add_device_to_white_list(uint8_t Address_Type,
                                           uint8_t Address[6])
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_add_device_to_white_list_cp0 *cp0 = (hci_le_add_device_to_white_list_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Address_Type = htob(Address_Type, 1);
  index_input += 1;
  Osal_MemCpy((void *) &cp0->Address, (const void *) Address, 6);
  index_input += 6;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x011;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_remove_device_from_white_list(uint8_t Address_Type,
                                                uint8_t Address[6])
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_remove_device_from_white_list_cp0 *cp0 = (hci_le_remove_device_from_white_list_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Address_Type = htob(Address_Type, 1);
  index_input += 1;
  Osal_MemCpy((void *) &cp0->Address, (const void *) Address, 6);
  index_input += 6;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x012;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_connection_update(uint16_t Connection_Handle,
                                    uint16_t Conn_Interval_Min,
                                    uint16_t Conn_Interval_Max,
                                    uint16_t Conn_Latency,
                                    uint16_t Supervision_Timeout,
                                    uint16_t Minimum_CE_Length,
                                    uint16_t Maximum_CE_Length)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_connection_update_cp0 *cp0 = (hci_le_connection_update_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->Conn_Interval_Min = htob(Conn_Interval_Min, 2);
  index_input += 2;
  cp0->Conn_Interval_Max = htob(Conn_Interval_Max, 2);
  index_input += 2;
  cp0->Conn_Latency = htob(Conn_Latency, 2);
  index_input += 2;
  cp0->Supervision_Timeout = htob(Supervision_Timeout, 2);
  index_input += 2;
  cp0->Minimum_CE_Length = htob(Minimum_CE_Length, 2);
  index_input += 2;
  cp0->Maximum_CE_Length = htob(Maximum_CE_Length, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x013;
  rq.event = 0x0F;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_set_host_channel_classification(uint8_t LE_Channel_Map[5])
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_set_host_channel_classification_cp0 *cp0 = (hci_le_set_host_channel_classification_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  Osal_MemCpy((void *) &cp0->LE_Channel_Map, (const void *) LE_Channel_Map, 5);
  index_input += 5;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x014;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_read_channel_map(uint16_t Connection_Handle,
                                   uint8_t LE_Channel_Map[5])
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_read_channel_map_cp0 *cp0 = (hci_le_read_channel_map_cp0*)(cmd_buffer);
  hci_le_read_channel_map_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x015;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  Osal_MemCpy((void *) LE_Channel_Map, (const void *) resp.LE_Channel_Map, 5);
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_read_remote_used_features(uint16_t Connection_Handle)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_read_remote_used_features_cp0 *cp0 = (hci_le_read_remote_used_features_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x016;
  rq.event = 0x0F;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_encrypt(uint8_t Key[16],
                          uint8_t Plaintext_Data[16],
                          uint8_t Encrypted_Data[16])
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_encrypt_cp0 *cp0 = (hci_le_encrypt_cp0*)(cmd_buffer);
  hci_le_encrypt_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  uint8_t index_input = 0;
  Osal_MemCpy((void *) &cp0->Key, (const void *) Key, 16);
  index_input += 16;
  Osal_MemCpy((void *) &cp0->Plaintext_Data, (const void *) Plaintext_Data, 16);
  index_input += 16;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x017;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  Osal_MemCpy((void *) Encrypted_Data, (const void *) resp.Encrypted_Data, 16);
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_rand(uint8_t Random_Number[8])
{
  struct hci_request rq;
  hci_le_rand_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x018;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  Osal_MemCpy((void *) Random_Number, (const void *) resp.Random_Number, 8);
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_start_encryption(uint16_t Connection_Handle,
                                   uint8_t Random_Number[8],
                                   uint16_t Encrypted_Diversifier,
                                   uint8_t Long_Term_Key[16])
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_start_encryption_cp0 *cp0 = (hci_le_start_encryption_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  Osal_MemCpy((void *) &cp0->Random_Number, (const void *) Random_Number, 8);
  index_input += 8;
  cp0->Encrypted_Diversifier = htob(Encrypted_Diversifier, 2);
  index_input += 2;
  Osal_MemCpy((void *) &cp0->Long_Term_Key, (const void *) Long_Term_Key, 16);
  index_input += 16;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x019;
  rq.event = 0x0F;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_long_term_key_request_reply(uint16_t Connection_Handle,
                                              uint8_t Long_Term_Key[16])
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_long_term_key_request_reply_cp0 *cp0 = (hci_le_long_term_key_request_reply_cp0*)(cmd_buffer);
  hci_le_long_term_key_request_reply_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  Osal_MemCpy((void *) &cp0->Long_Term_Key, (const void *) Long_Term_Key, 16);
  index_input += 16;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x01a;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_long_term_key_requested_negative_reply(uint16_t Connection_Handle)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_long_term_key_requested_negative_reply_cp0 *cp0 = (hci_le_long_term_key_requested_negative_reply_cp0*)(cmd_buffer);
  hci_le_long_term_key_requested_negative_reply_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x01b;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_read_supported_states(uint8_t LE_States[8])
{
  struct hci_request rq;
  hci_le_read_supported_states_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x01c;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  Osal_MemCpy((void *) LE_States, (const void *) resp.LE_States, 8);
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_receiver_test(uint8_t RX_Frequency)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_receiver_test_cp0 *cp0 = (hci_le_receiver_test_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->RX_Frequency = htob(RX_Frequency, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x01d;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_transmitter_test(uint8_t TX_Frequency,
                                   uint8_t Length_Of_Test_Data,
                                   uint8_t Packet_Payload)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_transmitter_test_cp0 *cp0 = (hci_le_transmitter_test_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->TX_Frequency = htob(TX_Frequency, 1);
  index_input += 1;
  cp0->Length_Of_Test_Data = htob(Length_Of_Test_Data, 1);
  index_input += 1;
  cp0->Packet_Payload = htob(Packet_Payload, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x01e;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_test_end(uint16_t *Number_Of_Packets)
{
  struct hci_request rq;
  hci_le_test_end_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x01f;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  *Number_Of_Packets = btoh(resp.Number_Of_Packets, 2);
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_set_data_length(uint16_t Connection_Handle,
                                  uint16_t TxOctets,
                                  uint16_t TxTime)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_set_data_length_cp0 *cp0 = (hci_le_set_data_length_cp0*)(cmd_buffer);
  hci_le_set_data_length_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->TxOctets = htob(TxOctets, 2);
  index_input += 2;
  cp0->TxTime = htob(TxTime, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x022;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_read_suggested_default_data_length(uint16_t *SuggestedMaxTxOctets,
                                                     uint16_t *SuggestedMaxTxTime)
{
  struct hci_request rq;
  hci_le_read_suggested_default_data_length_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x023;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  *SuggestedMaxTxOctets = btoh(resp.SuggestedMaxTxOctets, 2);
  *SuggestedMaxTxTime = btoh(resp.SuggestedMaxTxTime, 2);
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_write_suggested_default_data_length(uint16_t SuggestedMaxTxOctets,
                                                      uint16_t SuggestedMaxTxTime)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_write_suggested_default_data_length_cp0 *cp0 = (hci_le_write_suggested_default_data_length_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->SuggestedMaxTxOctets = htob(SuggestedMaxTxOctets, 2);
  index_input += 2;
  cp0->SuggestedMaxTxTime = htob(SuggestedMaxTxTime, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x024;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_read_local_p256_public_key(void)
{
  struct hci_request rq;
  tBleStatus status = 0;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x025;
  rq.event = 0x0F;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_generate_dhkey(uint8_t Remote_P256_Public_Key[64])
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_generate_dhkey_cp0 *cp0 = (hci_le_generate_dhkey_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  Osal_MemCpy((void *) &cp0->Remote_P256_Public_Key, (const void *) Remote_P256_Public_Key, 64);
  index_input += 64;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x026;
  rq.event = 0x0F;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_add_device_to_resolving_list(uint8_t Peer_Identity_Address_Type,
                                               uint8_t Peer_Identity_Address[6],
                                               uint8_t Peer_IRK[16],
                                               uint8_t Local_IRK[16])
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_add_device_to_resolving_list_cp0 *cp0 = (hci_le_add_device_to_resolving_list_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Peer_Identity_Address_Type = htob(Peer_Identity_Address_Type, 1);
  index_input += 1;
  Osal_MemCpy((void *) &cp0->Peer_Identity_Address, (const void *) Peer_Identity_Address, 6);
  index_input += 6;
  Osal_MemCpy((void *) &cp0->Peer_IRK, (const void *) Peer_IRK, 16);
  index_input += 16;
  Osal_MemCpy((void *) &cp0->Local_IRK, (const void *) Local_IRK, 16);
  index_input += 16;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x027;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_remove_device_from_resolving_list(uint8_t Peer_Identity_Address_Type,
                                                    uint8_t Peer_Identity_Address[6])
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_remove_device_from_resolving_list_cp0 *cp0 = (hci_le_remove_device_from_resolving_list_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Peer_Identity_Address_Type = htob(Peer_Identity_Address_Type, 1);
  index_input += 1;
  Osal_MemCpy((void *) &cp0->Peer_Identity_Address, (const void *) Peer_Identity_Address, 6);
  index_input += 6;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x028;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_clear_resolving_list(void)
{
  struct hci_request rq;
  tBleStatus status = 0;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x029;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_read_resolving_list_size(uint8_t *Resolving_List_Size)
{
  struct hci_request rq;
  hci_le_read_resolving_list_size_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x02a;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  *Resolving_List_Size = btoh(resp.Resolving_List_Size, 1);
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_read_peer_resolvable_address(uint8_t Peer_Identity_Address_Type,
                                               uint8_t Peer_Identity_Address[6],
                                               uint8_t Peer_Resolvable_Address[6])
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_read_peer_resolvable_address_cp0 *cp0 = (hci_le_read_peer_resolvable_address_cp0*)(cmd_buffer);
  hci_le_read_peer_resolvable_address_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  uint8_t index_input = 0;
  cp0->Peer_Identity_Address_Type = htob(Peer_Identity_Address_Type, 1);
  index_input += 1;
  Osal_MemCpy((void *) &cp0->Peer_Identity_Address, (const void *) Peer_Identity_Address, 6);
  index_input += 6;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x02b;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  Osal_MemCpy((void *) Peer_Resolvable_Address, (const void *) resp.Peer_Resolvable_Address, 6);
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_read_local_resolvable_address(uint8_t Peer_Identity_Address_Type,
                                                uint8_t Peer_Identity_Address[6],
                                                uint8_t Local_Resolvable_Address[6])
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_read_local_resolvable_address_cp0 *cp0 = (hci_le_read_local_resolvable_address_cp0*)(cmd_buffer);
  hci_le_read_local_resolvable_address_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  uint8_t index_input = 0;
  cp0->Peer_Identity_Address_Type = htob(Peer_Identity_Address_Type, 1);
  index_input += 1;
  Osal_MemCpy((void *) &cp0->Peer_Identity_Address, (const void *) Peer_Identity_Address, 6);
  index_input += 6;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x02c;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  Osal_MemCpy((void *) Local_Resolvable_Address, (const void *) resp.Local_Resolvable_Address, 6);
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_set_address_resolution_enable(uint8_t Address_Resolution_Enable)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_set_address_resolution_enable_cp0 *cp0 = (hci_le_set_address_resolution_enable_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Address_Resolution_Enable = htob(Address_Resolution_Enable, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x02d;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_set_resolvable_private_address_timeout(uint16_t RPA_Timeout)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_set_resolvable_private_address_timeout_cp0 *cp0 = (hci_le_set_resolvable_private_address_timeout_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->RPA_Timeout = htob(RPA_Timeout, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x02e;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_read_maximum_data_length(uint16_t *supportedMaxTxOctets,
                                           uint16_t *supportedMaxTxTime,
                                           uint16_t *supportedMaxRxOctets,
                                           uint16_t *supportedMaxRxTime)
{
  struct hci_request rq;
  hci_le_read_maximum_data_length_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x02f;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  *supportedMaxTxOctets = btoh(resp.supportedMaxTxOctets, 2);
  *supportedMaxTxTime = btoh(resp.supportedMaxTxTime, 2);
  *supportedMaxRxOctets = btoh(resp.supportedMaxRxOctets, 2);
  *supportedMaxRxTime = btoh(resp.supportedMaxRxTime, 2);
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_read_phy(uint16_t Connection_Handle,
                           uint8_t *TX_PHY,
                           uint8_t *RX_PHY)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_read_phy_cp0 *cp0 = (hci_le_read_phy_cp0*)(cmd_buffer);
  hci_le_read_phy_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x030;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  *TX_PHY = btoh(resp.TX_PHY, 1);
  *RX_PHY = btoh(resp.RX_PHY, 1);
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_set_default_phy(uint8_t ALL_PHYS,
                                  uint8_t TX_PHYS,
                                  uint8_t RX_PHYS)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_set_default_phy_cp0 *cp0 = (hci_le_set_default_phy_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->ALL_PHYS = htob(ALL_PHYS, 1);
  index_input += 1;
  cp0->TX_PHYS = htob(TX_PHYS, 1);
  index_input += 1;
  cp0->RX_PHYS = htob(RX_PHYS, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x031;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_set_phy(uint16_t Connection_Handle,
                          uint8_t ALL_PHYS,
                          uint8_t TX_PHYS,
                          uint8_t RX_PHYS,
                          uint16_t PHY_options)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_set_phy_cp0 *cp0 = (hci_le_set_phy_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->ALL_PHYS = htob(ALL_PHYS, 1);
  index_input += 1;
  cp0->TX_PHYS = htob(TX_PHYS, 1);
  index_input += 1;
  cp0->RX_PHYS = htob(RX_PHYS, 1);
  index_input += 1;
  cp0->PHY_options = htob(PHY_options, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x032;
  rq.event = 0x0F;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_enhanced_receiver_test(uint8_t RX_Channel,
                                         uint8_t PHY,
                                         uint8_t Modulation_index)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_enhanced_receiver_test_cp0 *cp0 = (hci_le_enhanced_receiver_test_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->RX_Channel = htob(RX_Channel, 1);
  index_input += 1;
  cp0->PHY = htob(PHY, 1);
  index_input += 1;
  cp0->Modulation_index = htob(Modulation_index, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x033;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_enhanced_transmitter_test(uint8_t TX_Channel,
                                            uint8_t Length_Of_Test_Data,
                                            uint8_t Packet_Payload,
                                            uint8_t PHY)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_enhanced_transmitter_test_cp0 *cp0 = (hci_le_enhanced_transmitter_test_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->TX_Channel = htob(TX_Channel, 1);
  index_input += 1;
  cp0->Length_Of_Test_Data = htob(Length_Of_Test_Data, 1);
  index_input += 1;
  cp0->Packet_Payload = htob(Packet_Payload, 1);
  index_input += 1;
  cp0->PHY = htob(PHY, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x034;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_set_advertising_set_random_address(uint8_t Advertising_Handle,
                                                     uint8_t Advertising_Random_Address[6])
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_set_advertising_set_random_address_cp0 *cp0 = (hci_le_set_advertising_set_random_address_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Advertising_Handle = htob(Advertising_Handle, 1);
  index_input += 1;
  Osal_MemCpy((void *) &cp0->Advertising_Random_Address, (const void *) Advertising_Random_Address, 6);
  index_input += 6;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x035;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_set_extended_advertising_parameters(uint8_t Advertising_Handle,
                                                      uint16_t Advertising_Event_Properties,
                                                      uint8_t Primary_Advertising_Interval_Min[3],
                                                      uint8_t Primary_Advertising_Interval_Max[3],
                                                      uint8_t Primary_Advertising_Channel_Map,
                                                      uint8_t Own_Address_Type,
                                                      uint8_t Peer_Address_Type,
                                                      uint8_t Peer_Address[6],
                                                      uint8_t Advertising_Filter_Policy,
                                                      int8_t Advertising_Tx_Power,
                                                      uint8_t Primary_Advertising_PHY,
                                                      uint8_t Secondary_Advertising_Max_Skip,
                                                      uint8_t Secondary_Advertising_PHY,
                                                      uint8_t Advertising_SID,
                                                      uint8_t Scan_Request_Notification_Enable,
                                                      int8_t *Selected_Tx_Power)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_set_extended_advertising_parameters_cp0 *cp0 = (hci_le_set_extended_advertising_parameters_cp0*)(cmd_buffer);
  hci_le_set_extended_advertising_parameters_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  uint8_t index_input = 0;
  cp0->Advertising_Handle = htob(Advertising_Handle, 1);
  index_input += 1;
  cp0->Advertising_Event_Properties = htob(Advertising_Event_Properties, 2);
  index_input += 2;
  Osal_MemCpy((void *) &cp0->Primary_Advertising_Interval_Min, (const void *) Primary_Advertising_Interval_Min, 3);
  index_input += 3;
  Osal_MemCpy((void *) &cp0->Primary_Advertising_Interval_Max, (const void *) Primary_Advertising_Interval_Max, 3);
  index_input += 3;
  cp0->Primary_Advertising_Channel_Map = htob(Primary_Advertising_Channel_Map, 1);
  index_input += 1;
  cp0->Own_Address_Type = htob(Own_Address_Type, 1);
  index_input += 1;
  cp0->Peer_Address_Type = htob(Peer_Address_Type, 1);
  index_input += 1;
  Osal_MemCpy((void *) &cp0->Peer_Address, (const void *) Peer_Address, 6);
  index_input += 6;
  cp0->Advertising_Filter_Policy = htob(Advertising_Filter_Policy, 1);
  index_input += 1;
  cp0->Advertising_Tx_Power = htob(Advertising_Tx_Power, 1);
  index_input += 1;
  cp0->Primary_Advertising_PHY = htob(Primary_Advertising_PHY, 1);
  index_input += 1;
  cp0->Secondary_Advertising_Max_Skip = htob(Secondary_Advertising_Max_Skip, 1);
  index_input += 1;
  cp0->Secondary_Advertising_PHY = htob(Secondary_Advertising_PHY, 1);
  index_input += 1;
  cp0->Advertising_SID = htob(Advertising_SID, 1);
  index_input += 1;
  cp0->Scan_Request_Notification_Enable = htob(Scan_Request_Notification_Enable, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x036;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  *Selected_Tx_Power = btoh(resp.Selected_Tx_Power, 1);
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_set_extended_advertising_data(uint8_t Advertising_Handle,
                                                uint8_t Operation,
                                                uint8_t Fragment_Preference,
                                                uint8_t Advertising_Data_Length,
                                                uint8_t Advertising_Data[])
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_set_extended_advertising_data_cp0 *cp0 = (hci_le_set_extended_advertising_data_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Advertising_Handle = htob(Advertising_Handle, 1);
  index_input += 1;
  cp0->Operation = htob(Operation, 1);
  index_input += 1;
  cp0->Fragment_Preference = htob(Fragment_Preference, 1);
  index_input += 1;
  cp0->Advertising_Data_Length = htob(Advertising_Data_Length, 1);
  index_input += 1;
  /* var_len_data input */
  {
    Osal_MemCpy((void *) &cp0->Advertising_Data, (const void *) Advertising_Data, Advertising_Data_Length*sizeof(uint8_t));
    index_input += Advertising_Data_Length*sizeof(uint8_t);
  }
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x037;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_set_extended_scan_response_data(uint8_t Advertising_Handle,
                                                  uint8_t Operation,
                                                  uint8_t Fragment_Preference,
                                                  uint8_t Scan_Response_Data_Length,
                                                  uint8_t Scan_Response_Data[])
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_set_extended_scan_response_data_cp0 *cp0 = (hci_le_set_extended_scan_response_data_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Advertising_Handle = htob(Advertising_Handle, 1);
  index_input += 1;
  cp0->Operation = htob(Operation, 1);
  index_input += 1;
  cp0->Fragment_Preference = htob(Fragment_Preference, 1);
  index_input += 1;
  cp0->Scan_Response_Data_Length = htob(Scan_Response_Data_Length, 1);
  index_input += 1;
  /* var_len_data input */
  {
    Osal_MemCpy((void *) &cp0->Scan_Response_Data, (const void *) Scan_Response_Data, Scan_Response_Data_Length*sizeof(uint8_t));
    index_input += Scan_Response_Data_Length*sizeof(uint8_t);
  }
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x038;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_set_extended_advertising_enable(uint8_t Enable,
                                                  uint8_t Number_of_Sets,
                                                  Advertising_Set_Parameters_t Advertising_Set_Parameters[])
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_set_extended_advertising_enable_cp0 *cp0 = (hci_le_set_extended_advertising_enable_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Enable = htob(Enable, 1);
  index_input += 1;
  cp0->Number_of_Sets = htob(Number_of_Sets, 1);
  index_input += 1;
  /* var_len_data input */
  {
    for (int i = 0; i < Number_of_Sets; i++) {
      cp0->Advertising_Set_Parameters[i].Advertising_Handle = Advertising_Set_Parameters[i].Advertising_Handle;
      cp0->Advertising_Set_Parameters[i].Duration = Advertising_Set_Parameters[i].Duration;
      cp0->Advertising_Set_Parameters[i].Max_Extended_Advertising_Events = Advertising_Set_Parameters[i].Max_Extended_Advertising_Events;
    }
    index_input += Number_of_Sets*4;
  }
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x039;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_read_maximum_advertising_data_length(uint16_t *Maximum_Advertising_Data_Length)
{
  struct hci_request rq;
  hci_le_read_maximum_advertising_data_length_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x03a;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  *Maximum_Advertising_Data_Length = btoh(resp.Maximum_Advertising_Data_Length, 2);
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_read_number_of_supported_advertising_sets(uint8_t *Num_Supported_Advertising_Sets)
{
  struct hci_request rq;
  hci_le_read_number_of_supported_advertising_sets_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x03b;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  *Num_Supported_Advertising_Sets = btoh(resp.Num_Supported_Advertising_Sets, 1);
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_remove_advertising_set(uint8_t Advertising_Handle)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_remove_advertising_set_cp0 *cp0 = (hci_le_remove_advertising_set_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Advertising_Handle = htob(Advertising_Handle, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x03c;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_clear_advertising_sets(void)
{
  struct hci_request rq;
  tBleStatus status = 0;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x03d;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_set_periodic_advertising_parameters(uint8_t Advertising_Handle,
                                                      uint16_t Periodic_Advertising_Interval_Min,
                                                      uint16_t Periodic_Advertising_Interval_Max,
                                                      uint16_t Periodic_Advertising_Properties)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_set_periodic_advertising_parameters_cp0 *cp0 = (hci_le_set_periodic_advertising_parameters_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Advertising_Handle = htob(Advertising_Handle, 1);
  index_input += 1;
  cp0->Periodic_Advertising_Interval_Min = htob(Periodic_Advertising_Interval_Min, 2);
  index_input += 2;
  cp0->Periodic_Advertising_Interval_Max = htob(Periodic_Advertising_Interval_Max, 2);
  index_input += 2;
  cp0->Periodic_Advertising_Properties = htob(Periodic_Advertising_Properties, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x03e;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_set_periodic_advertising_data(uint8_t Advertising_Handle,
                                                uint8_t Operation,
                                                uint8_t Advertising_Data_Length,
                                                uint8_t Advertising_Data[])
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_set_periodic_advertising_data_cp0 *cp0 = (hci_le_set_periodic_advertising_data_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Advertising_Handle = htob(Advertising_Handle, 1);
  index_input += 1;
  cp0->Operation = htob(Operation, 1);
  index_input += 1;
  cp0->Advertising_Data_Length = htob(Advertising_Data_Length, 1);
  index_input += 1;
  /* var_len_data input */
  {
    Osal_MemCpy((void *) &cp0->Advertising_Data, (const void *) Advertising_Data, Advertising_Data_Length*sizeof(uint8_t));
    index_input += Advertising_Data_Length*sizeof(uint8_t);
  }
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x03f;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_set_periodic_advertising_enable(uint8_t Enable,
                                                  uint8_t Advertising_Handle)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_set_periodic_advertising_enable_cp0 *cp0 = (hci_le_set_periodic_advertising_enable_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Enable = htob(Enable, 1);
  index_input += 1;
  cp0->Advertising_Handle = htob(Advertising_Handle, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x040;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_set_extended_scan_parameters(uint8_t Own_Address_Type,
                                               uint8_t Scanning_Filter_Policy,
                                               uint8_t Scanning_PHYs,
                                               Extended_Scan_Parameters_t Extended_Scan_Parameters[])
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_set_extended_scan_parameters_cp0 *cp0 = (hci_le_set_extended_scan_parameters_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Own_Address_Type = htob(Own_Address_Type, 1);
  index_input += 1;
  cp0->Scanning_Filter_Policy = htob(Scanning_Filter_Policy, 1);
  index_input += 1;
  cp0->Scanning_PHYs = htob(Scanning_PHYs, 1);
  index_input += 1;
  int len = 0;

  for (int i = 0; i < sizeof( cp0->Scanning_PHYs)*8; i++) {
    if((cp0->Scanning_PHYs >> i) & 0x01){
      len++;
    }
  }
  /* var_len_data input */
  {
    for (int i = 0; i < len; i++) {
      cp0->Extended_Scan_Parameters[i].Scan_Type = Extended_Scan_Parameters[i].Scan_Type;
      cp0->Extended_Scan_Parameters[i].Scan_Interval = Extended_Scan_Parameters[i].Scan_Interval;
      cp0->Extended_Scan_Parameters[i].Scan_Window = Extended_Scan_Parameters[i].Scan_Window;
    }
    index_input += len*5;
  }
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x041;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_set_extended_scan_enable(uint8_t Enable,
                                           uint8_t Filter_Duplicates,
                                           uint16_t Duration,
                                           uint16_t Period)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_set_extended_scan_enable_cp0 *cp0 = (hci_le_set_extended_scan_enable_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Enable = htob(Enable, 1);
  index_input += 1;
  cp0->Filter_Duplicates = htob(Filter_Duplicates, 1);
  index_input += 1;
  cp0->Duration = htob(Duration, 2);
  index_input += 2;
  cp0->Period = htob(Period, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x042;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_extended_create_connection(uint8_t Initiating_Filter_Policy,
                                             uint8_t Own_Address_Type,
                                             uint8_t Peer_Address_Type,
                                             uint8_t Peer_Address[6],
                                             uint8_t Initiating_PHYs,
                                             Extended_Create_Connection_Parameters_t Extended_Create_Connection_Parameters[])
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_extended_create_connection_cp0 *cp0 = (hci_le_extended_create_connection_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Initiating_Filter_Policy = htob(Initiating_Filter_Policy, 1);
  index_input += 1;
  cp0->Own_Address_Type = htob(Own_Address_Type, 1);
  index_input += 1;
  cp0->Peer_Address_Type = htob(Peer_Address_Type, 1);
  index_input += 1;
  Osal_MemCpy((void *) &cp0->Peer_Address, (const void *) Peer_Address, 6);
  index_input += 6;
  cp0->Initiating_PHYs = htob(Initiating_PHYs, 1);
  index_input += 1;
  int len = 0;

  for (int i = 0; i < sizeof( cp0->Initiating_PHYs)*8; i++) {
    if((cp0->Initiating_PHYs >> i) & 0x01){
      len++;
    }
  }
  /* var_len_data input */
  {
    for (int i = 0; i < len; i++) {
      cp0->Extended_Create_Connection_Parameters[i].Scan_Interval = Extended_Create_Connection_Parameters[i].Scan_Interval;
      cp0->Extended_Create_Connection_Parameters[i].Scan_Window = Extended_Create_Connection_Parameters[i].Scan_Window;
      cp0->Extended_Create_Connection_Parameters[i].Conn_Interval_Min = Extended_Create_Connection_Parameters[i].Conn_Interval_Min;
      cp0->Extended_Create_Connection_Parameters[i].Conn_Interval_Max = Extended_Create_Connection_Parameters[i].Conn_Interval_Max;
      cp0->Extended_Create_Connection_Parameters[i].Conn_Latency = Extended_Create_Connection_Parameters[i].Conn_Latency;
      cp0->Extended_Create_Connection_Parameters[i].Supervision_Timeout = Extended_Create_Connection_Parameters[i].Supervision_Timeout;
      cp0->Extended_Create_Connection_Parameters[i].Minimum_CE_Length = Extended_Create_Connection_Parameters[i].Minimum_CE_Length;
      cp0->Extended_Create_Connection_Parameters[i].Maximum_CE_Length = Extended_Create_Connection_Parameters[i].Maximum_CE_Length;
    }
    index_input += len*16;
  }
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x043;
  rq.event = 0x0F;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_periodic_advertising_create_sync(uint8_t Options,
                                                   uint8_t Advertising_SID,
                                                   uint8_t Advertising_Address_Type,
                                                   uint8_t Advertiser_Address[6],
                                                   uint16_t Skip,
                                                   uint16_t Sync_Timeout,
                                                   uint8_t Sync_CTE_Type)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_periodic_advertising_create_sync_cp0 *cp0 = (hci_le_periodic_advertising_create_sync_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Options = htob(Options, 1);
  index_input += 1;
  cp0->Advertising_SID = htob(Advertising_SID, 1);
  index_input += 1;
  cp0->Advertising_Address_Type = htob(Advertising_Address_Type, 1);
  index_input += 1;
  Osal_MemCpy((void *) &cp0->Advertiser_Address, (const void *) Advertiser_Address, 6);
  index_input += 6;
  cp0->Skip = htob(Skip, 2);
  index_input += 2;
  cp0->Sync_Timeout = htob(Sync_Timeout, 2);
  index_input += 2;
  cp0->Sync_CTE_Type = htob(Sync_CTE_Type, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x044;
  rq.event = 0x0F;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_periodic_advertising_create_sync_cancel(void)
{
  struct hci_request rq;
  tBleStatus status = 0;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x045;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_periodic_advertising_terminate_sync(uint16_t Sync_Handle)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_periodic_advertising_terminate_sync_cp0 *cp0 = (hci_le_periodic_advertising_terminate_sync_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Sync_Handle = htob(Sync_Handle, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x046;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_add_device_to_periodic_advertiser_list(uint8_t Advertiser_Address_Type,
                                                         uint8_t Advertiser_Address[6],
                                                         uint8_t Advertising_SID)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_add_device_to_periodic_advertiser_list_cp0 *cp0 = (hci_le_add_device_to_periodic_advertiser_list_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Advertiser_Address_Type = htob(Advertiser_Address_Type, 1);
  index_input += 1;
  Osal_MemCpy((void *) &cp0->Advertiser_Address, (const void *) Advertiser_Address, 6);
  index_input += 6;
  cp0->Advertising_SID = htob(Advertising_SID, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x047;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_remove_device_from_periodic_advertising_list(uint8_t Advertiser_Address_Type,
                                                               uint8_t Advertiser_Address[6],
                                                               uint8_t Advertising_SID)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_remove_device_from_periodic_advertising_list_cp0 *cp0 = (hci_le_remove_device_from_periodic_advertising_list_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Advertiser_Address_Type = htob(Advertiser_Address_Type, 1);
  index_input += 1;
  Osal_MemCpy((void *) &cp0->Advertiser_Address, (const void *) Advertiser_Address, 6);
  index_input += 6;
  cp0->Advertising_SID = htob(Advertising_SID, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x048;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_clear_periodic_advertiser_list(void)
{
  struct hci_request rq;
  tBleStatus status = 0;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x049;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_read_periodic_advertiser_list_size(uint8_t *Periodic_Advertiser_List_Size)
{
  struct hci_request rq;
  hci_le_read_periodic_advertiser_list_size_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x04a;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  *Periodic_Advertiser_List_Size = btoh(resp.Periodic_Advertiser_List_Size, 1);
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_read_transmit_power(int8_t *Min_Tx_Power,
                                      int8_t *Max_Tx_Power)
{
  struct hci_request rq;
  hci_le_read_transmit_power_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x04b;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  *Min_Tx_Power = btoh(resp.Min_Tx_Power, 1);
  *Max_Tx_Power = btoh(resp.Max_Tx_Power, 1);
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_read_rf_path_compensation(int16_t *RF_TX_Path_Compensation_Value,
                                            int16_t *RF_RX_Path_Compensation_Value)
{
  struct hci_request rq;
  hci_le_read_rf_path_compensation_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x04c;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  *RF_TX_Path_Compensation_Value = btoh(resp.RF_TX_Path_Compensation_Value, 2);
  *RF_RX_Path_Compensation_Value = btoh(resp.RF_RX_Path_Compensation_Value, 2);
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_write_rf_path_compensation(int16_t RF_TX_Path_Compensation_Value,
                                             int16_t RF_RX_Path_Compensation_Value)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_write_rf_path_compensation_cp0 *cp0 = (hci_le_write_rf_path_compensation_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->RF_TX_Path_Compensation_Value = htob(RF_TX_Path_Compensation_Value, 2);
  index_input += 2;
  cp0->RF_RX_Path_Compensation_Value = htob(RF_RX_Path_Compensation_Value, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x04d;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_set_privacy_mode(uint8_t Peer_Identity_Address_Type,
                                   uint8_t Peer_Identity_Address[6],
                                   uint8_t Privacy_Mode)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_set_privacy_mode_cp0 *cp0 = (hci_le_set_privacy_mode_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Peer_Identity_Address_Type = htob(Peer_Identity_Address_Type, 1);
  index_input += 1;
  Osal_MemCpy((void *) &cp0->Peer_Identity_Address, (const void *) Peer_Identity_Address, 6);
  index_input += 6;
  cp0->Privacy_Mode = htob(Privacy_Mode, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x04e;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_receiver_test_v3(uint8_t RX_Channel,
                                   uint8_t PHY,
                                   uint8_t Modulation_Index,
                                   uint8_t Expected_CTE_Length,
                                   uint8_t Expected_CTE_Type,
                                   uint8_t Slot_Durations,
                                   uint8_t Switching_Pattern_Length,
                                   uint8_t Antenna_IDs[])
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_receiver_test_v3_cp0 *cp0 = (hci_le_receiver_test_v3_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->RX_Channel = htob(RX_Channel, 1);
  index_input += 1;
  cp0->PHY = htob(PHY, 1);
  index_input += 1;
  cp0->Modulation_Index = htob(Modulation_Index, 1);
  index_input += 1;
  cp0->Expected_CTE_Length = htob(Expected_CTE_Length, 1);
  index_input += 1;
  cp0->Expected_CTE_Type = htob(Expected_CTE_Type, 1);
  index_input += 1;
  cp0->Slot_Durations = htob(Slot_Durations, 1);
  index_input += 1;
  cp0->Switching_Pattern_Length = htob(Switching_Pattern_Length, 1);
  index_input += 1;
  /* var_len_data input */
  {
    Osal_MemCpy((void *) &cp0->Antenna_IDs, (const void *) Antenna_IDs, Switching_Pattern_Length*sizeof(uint8_t));
    index_input += Switching_Pattern_Length*sizeof(uint8_t);
  }
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x04f;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_transmitter_test_v3(uint8_t TX_Channel,
                                      uint8_t Test_Data_Length,
                                      uint8_t Packet_Payload,
                                      uint8_t PHY,
                                      uint8_t CTE_Length,
                                      uint8_t CTE_Type,
                                      uint8_t Switching_Pattern_Length,
                                      uint8_t Antenna_IDs[])
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_transmitter_test_v3_cp0 *cp0 = (hci_le_transmitter_test_v3_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->TX_Channel = htob(TX_Channel, 1);
  index_input += 1;
  cp0->Test_Data_Length = htob(Test_Data_Length, 1);
  index_input += 1;
  cp0->Packet_Payload = htob(Packet_Payload, 1);
  index_input += 1;
  cp0->PHY = htob(PHY, 1);
  index_input += 1;
  cp0->CTE_Length = htob(CTE_Length, 1);
  index_input += 1;
  cp0->CTE_Type = htob(CTE_Type, 1);
  index_input += 1;
  cp0->Switching_Pattern_Length = htob(Switching_Pattern_Length, 1);
  index_input += 1;
  /* var_len_data input */
  {
    Osal_MemCpy((void *) &cp0->Antenna_IDs, (const void *) Antenna_IDs, Switching_Pattern_Length*sizeof(uint8_t));
    index_input += Switching_Pattern_Length*sizeof(uint8_t);
  }
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x050;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_set_connectionless_cte_transmit_parameters(uint8_t Advertising_Handle,
                                                             uint8_t CTE_Length,
                                                             uint8_t CTE_Type,
                                                             uint8_t CTE_Count,
                                                             uint8_t Switching_Pattern_Length,
                                                             uint8_t Antenna_IDs[])
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_set_connectionless_cte_transmit_parameters_cp0 *cp0 = (hci_le_set_connectionless_cte_transmit_parameters_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Advertising_Handle = htob(Advertising_Handle, 1);
  index_input += 1;
  cp0->CTE_Length = htob(CTE_Length, 1);
  index_input += 1;
  cp0->CTE_Type = htob(CTE_Type, 1);
  index_input += 1;
  cp0->CTE_Count = htob(CTE_Count, 1);
  index_input += 1;
  cp0->Switching_Pattern_Length = htob(Switching_Pattern_Length, 1);
  index_input += 1;
  /* var_len_data input */
  {
    Osal_MemCpy((void *) &cp0->Antenna_IDs, (const void *) Antenna_IDs, Switching_Pattern_Length*sizeof(uint8_t));
    index_input += Switching_Pattern_Length*sizeof(uint8_t);
  }
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x051;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_set_connectionless_cte_transmit_enable(uint8_t Advertising_Handle,
                                                         uint8_t CTE_Enable)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_set_connectionless_cte_transmit_enable_cp0 *cp0 = (hci_le_set_connectionless_cte_transmit_enable_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Advertising_Handle = htob(Advertising_Handle, 1);
  index_input += 1;
  cp0->CTE_Enable = htob(CTE_Enable, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x052;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_set_connectionless_iq_sampling_enable(uint16_t Sync_Handle,
                                                        uint8_t Sampling_Enable,
                                                        uint8_t Slot_Durations,
                                                        uint8_t Max_Sampled_CTEs,
                                                        uint8_t Switching_Pattern_Length,
                                                        uint8_t Antenna_IDs[])
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_set_connectionless_iq_sampling_enable_cp0 *cp0 = (hci_le_set_connectionless_iq_sampling_enable_cp0*)(cmd_buffer);
  hci_le_set_connectionless_iq_sampling_enable_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  uint8_t index_input = 0;
  cp0->Sync_Handle = htob(Sync_Handle, 2);
  index_input += 2;
  cp0->Sampling_Enable = htob(Sampling_Enable, 1);
  index_input += 1;
  cp0->Slot_Durations = htob(Slot_Durations, 1);
  index_input += 1;
  cp0->Max_Sampled_CTEs = htob(Max_Sampled_CTEs, 1);
  index_input += 1;
  cp0->Switching_Pattern_Length = htob(Switching_Pattern_Length, 1);
  index_input += 1;
  /* var_len_data input */
  {
    Osal_MemCpy((void *) &cp0->Antenna_IDs, (const void *) Antenna_IDs, Switching_Pattern_Length*sizeof(uint8_t));
    index_input += Switching_Pattern_Length*sizeof(uint8_t);
  }
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x053;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_set_connection_cte_receive_parameters(uint16_t Connection_Handle,
                                                        uint8_t Sampling_Enable,
                                                        uint8_t Slot_Durations,
                                                        uint8_t Switching_Pattern_Length,
                                                        uint8_t Antenna_IDs[])
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_set_connection_cte_receive_parameters_cp0 *cp0 = (hci_le_set_connection_cte_receive_parameters_cp0*)(cmd_buffer);
  hci_le_set_connection_cte_receive_parameters_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->Sampling_Enable = htob(Sampling_Enable, 1);
  index_input += 1;
  cp0->Slot_Durations = htob(Slot_Durations, 1);
  index_input += 1;
  cp0->Switching_Pattern_Length = htob(Switching_Pattern_Length, 1);
  index_input += 1;
  /* var_len_data input */
  {
    Osal_MemCpy((void *) &cp0->Antenna_IDs, (const void *) Antenna_IDs, Switching_Pattern_Length*sizeof(uint8_t));
    index_input += Switching_Pattern_Length*sizeof(uint8_t);
  }
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x054;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_set_connection_cte_transmit_parameters(uint16_t Connection_Handle,
                                                         uint8_t CTE_Type,
                                                         uint8_t Switching_Pattern_Length,
                                                         uint8_t Antenna_IDs[])
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_set_connection_cte_transmit_parameters_cp0 *cp0 = (hci_le_set_connection_cte_transmit_parameters_cp0*)(cmd_buffer);
  hci_le_set_connection_cte_transmit_parameters_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->CTE_Type = htob(CTE_Type, 1);
  index_input += 1;
  cp0->Switching_Pattern_Length = htob(Switching_Pattern_Length, 1);
  index_input += 1;
  /* var_len_data input */
  {
    Osal_MemCpy((void *) &cp0->Antenna_IDs, (const void *) Antenna_IDs, Switching_Pattern_Length*sizeof(uint8_t));
    index_input += Switching_Pattern_Length*sizeof(uint8_t);
  }
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x055;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_connection_cte_request_enable(uint16_t Connection_Handle,
                                                uint8_t Enable,
                                                uint16_t CTE_Request_Interval,
                                                uint8_t Requested_CTE_Length,
                                                uint8_t Requested_CTE_Type)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_connection_cte_request_enable_cp0 *cp0 = (hci_le_connection_cte_request_enable_cp0*)(cmd_buffer);
  hci_le_connection_cte_request_enable_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->Enable = htob(Enable, 1);
  index_input += 1;
  cp0->CTE_Request_Interval = htob(CTE_Request_Interval, 2);
  index_input += 2;
  cp0->Requested_CTE_Length = htob(Requested_CTE_Length, 1);
  index_input += 1;
  cp0->Requested_CTE_Type = htob(Requested_CTE_Type, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x056;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_connection_cte_response_enable(uint16_t Connection_Handle,
                                                 uint8_t Enable)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_connection_cte_response_enable_cp0 *cp0 = (hci_le_connection_cte_response_enable_cp0*)(cmd_buffer);
  hci_le_connection_cte_response_enable_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->Enable = htob(Enable, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x057;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_read_antenna_information(uint8_t *Supported_Switching_Sampling_Rates,
                                           uint8_t *Num_Antennae,
                                           uint8_t *Max_Switching_Pattern_Length,
                                           uint8_t *Max_CTE_Length)
{
  struct hci_request rq;
  hci_le_read_antenna_information_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x058;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  *Supported_Switching_Sampling_Rates = btoh(resp.Supported_Switching_Sampling_Rates, 1);
  *Num_Antennae = btoh(resp.Num_Antennae, 1);
  *Max_Switching_Pattern_Length = btoh(resp.Max_Switching_Pattern_Length, 1);
  *Max_CTE_Length = btoh(resp.Max_CTE_Length, 1);
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_set_periodic_advertising_receive_enable(uint16_t Sync_Handle,
                                                          uint8_t Enable)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_set_periodic_advertising_receive_enable_cp0 *cp0 = (hci_le_set_periodic_advertising_receive_enable_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Sync_Handle = htob(Sync_Handle, 2);
  index_input += 2;
  cp0->Enable = htob(Enable, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x059;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_periodic_advertising_sync_transfer(uint16_t Connection_Handle,
                                                     uint16_t Service_Data,
                                                     uint16_t Sync_Handle)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_periodic_advertising_sync_transfer_cp0 *cp0 = (hci_le_periodic_advertising_sync_transfer_cp0*)(cmd_buffer);
  hci_le_periodic_advertising_sync_transfer_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->Service_Data = htob(Service_Data, 2);
  index_input += 2;
  cp0->Sync_Handle = htob(Sync_Handle, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x05a;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_periodic_advertising_set_info_transfer(uint16_t Connection_Handle,
                                                         uint16_t Service_Data,
                                                         uint8_t Advertising_Handle)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_periodic_advertising_set_info_transfer_cp0 *cp0 = (hci_le_periodic_advertising_set_info_transfer_cp0*)(cmd_buffer);
  hci_le_periodic_advertising_set_info_transfer_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->Service_Data = htob(Service_Data, 2);
  index_input += 2;
  cp0->Advertising_Handle = htob(Advertising_Handle, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x05b;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_set_periodic_advertising_sync_transfer_parameters(uint16_t Connection_Handle,
                                                                    uint8_t Mode,
                                                                    uint16_t Skip,
                                                                    uint16_t Sync_Timeout,
                                                                    uint8_t CTE_Type)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_set_periodic_advertising_sync_transfer_parameters_cp0 *cp0 = (hci_le_set_periodic_advertising_sync_transfer_parameters_cp0*)(cmd_buffer);
  hci_le_set_periodic_advertising_sync_transfer_parameters_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->Mode = htob(Mode, 1);
  index_input += 1;
  cp0->Skip = htob(Skip, 2);
  index_input += 2;
  cp0->Sync_Timeout = htob(Sync_Timeout, 2);
  index_input += 2;
  cp0->CTE_Type = htob(CTE_Type, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x05c;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_set_default_periodic_advertising_sync_transfer_parameters(uint8_t Mode,
                                                                            uint16_t Skip,
                                                                            uint16_t Sync_Timeout,
                                                                            uint8_t CTE_Type)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_set_default_periodic_advertising_sync_transfer_parameters_cp0 *cp0 = (hci_le_set_default_periodic_advertising_sync_transfer_parameters_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Mode = htob(Mode, 1);
  index_input += 1;
  cp0->Skip = htob(Skip, 2);
  index_input += 2;
  cp0->Sync_Timeout = htob(Sync_Timeout, 2);
  index_input += 2;
  cp0->CTE_Type = htob(CTE_Type, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x05d;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_enhanced_read_transmit_power_level(uint16_t Connection_Handle,
                                                     uint8_t PHY,
                                                     int8_t *Current_Transmit_Power_Level,
                                                     int8_t *Max_Transmit_Power_Level)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_enhanced_read_transmit_power_level_cp0 *cp0 = (hci_le_enhanced_read_transmit_power_level_cp0*)(cmd_buffer);
  hci_le_enhanced_read_transmit_power_level_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->PHY = htob(PHY, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x076;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  *Current_Transmit_Power_Level = btoh(resp.Current_Transmit_Power_Level, 1);
  *Max_Transmit_Power_Level = btoh(resp.Max_Transmit_Power_Level, 1);
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_read_remote_transmit_power_level(uint16_t Connection_Handle,
                                                   uint8_t PHY)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_read_remote_transmit_power_level_cp0 *cp0 = (hci_le_read_remote_transmit_power_level_cp0*)(cmd_buffer);
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->PHY = htob(PHY, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x077;
  rq.event = 0x0F;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_set_path_loss_reporting_parameters(uint16_t Connection_Handle,
                                                     uint8_t High_Threshold,
                                                     uint8_t High_Hysteresis,
                                                     uint8_t Low_Threshold,
                                                     uint8_t Low_Hysteresis,
                                                     uint16_t Min_Time_Spent)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_set_path_loss_reporting_parameters_cp0 *cp0 = (hci_le_set_path_loss_reporting_parameters_cp0*)(cmd_buffer);
  hci_le_set_path_loss_reporting_parameters_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->High_Threshold = htob(High_Threshold, 1);
  index_input += 1;
  cp0->High_Hysteresis = htob(High_Hysteresis, 1);
  index_input += 1;
  cp0->Low_Threshold = htob(Low_Threshold, 1);
  index_input += 1;
  cp0->Low_Hysteresis = htob(Low_Hysteresis, 1);
  index_input += 1;
  cp0->Min_Time_Spent = htob(Min_Time_Spent, 2);
  index_input += 2;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x078;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_set_path_loss_reporting_enable(uint16_t Connection_Handle,
                                                 uint8_t Enable)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_set_path_loss_reporting_enable_cp0 *cp0 = (hci_le_set_path_loss_reporting_enable_cp0*)(cmd_buffer);
  hci_le_set_path_loss_reporting_enable_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->Enable = htob(Enable, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x079;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_set_transmit_power_reporting_enable(uint16_t Connection_Handle,
                                                      uint8_t Local_Enable,
                                                      uint8_t Remote_Enable)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_set_transmit_power_reporting_enable_cp0 *cp0 = (hci_le_set_transmit_power_reporting_enable_cp0*)(cmd_buffer);
  hci_le_set_transmit_power_reporting_enable_rp0 resp;
  Osal_MemSet(&resp, 0, sizeof(resp));
  uint8_t index_input = 0;
  cp0->Connection_Handle = htob(Connection_Handle, 2);
  index_input += 2;
  cp0->Local_Enable = htob(Local_Enable, 1);
  index_input += 1;
  cp0->Remote_Enable = htob(Remote_Enable, 1);
  index_input += 1;
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x07a;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &resp;
  rq.rlen = sizeof(resp);
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (resp.Status) {
    return resp.Status;
  }
  return BLE_STATUS_SUCCESS;
}
tBleStatus hci_le_transmitter_test_v4(uint8_t TX_Channel,
                                      uint8_t Test_Data_Length,
                                      uint8_t Packet_Payload,
                                      uint8_t PHY,
                                      uint8_t CTE_Length,
                                      uint8_t CTE_Type,
                                      uint8_t Switching_Pattern_Length,
                                      uint8_t Antenna_IDs[],
                                      int8_t Transmit_Power_Level)
{
  struct hci_request rq;
  uint8_t cmd_buffer[258];
  hci_le_transmitter_test_v4_cp0 *cp0 = (hci_le_transmitter_test_v4_cp0*)(cmd_buffer);
  hci_le_transmitter_test_v4_cp1 *cp1 = (hci_le_transmitter_test_v4_cp1*)(cmd_buffer + 1 + 1 + 1 + 1 + 1 + 1 + 1 + Switching_Pattern_Length * (sizeof(uint8_t)));
  tBleStatus status = 0;
  uint8_t index_input = 0;
  cp0->TX_Channel = htob(TX_Channel, 1);
  index_input += 1;
  cp0->Test_Data_Length = htob(Test_Data_Length, 1);
  index_input += 1;
  cp0->Packet_Payload = htob(Packet_Payload, 1);
  index_input += 1;
  cp0->PHY = htob(PHY, 1);
  index_input += 1;
  cp0->CTE_Length = htob(CTE_Length, 1);
  index_input += 1;
  cp0->CTE_Type = htob(CTE_Type, 1);
  index_input += 1;
  cp0->Switching_Pattern_Length = htob(Switching_Pattern_Length, 1);
  index_input += 1;
  /* var_len_data input */
  {
    Osal_MemCpy((void *) &cp0->Antenna_IDs, (const void *) Antenna_IDs, Switching_Pattern_Length*sizeof(uint8_t));
    index_input += Switching_Pattern_Length*sizeof(uint8_t);
    {
      cp1->Transmit_Power_Level = htob(Transmit_Power_Level, 1);
    }
    index_input += 1;
  }
  Osal_MemSet(&rq, 0, sizeof(rq));
  rq.ogf = 0x08;
  rq.ocf = 0x07b;
  rq.cparam = cmd_buffer;
  rq.clen = index_input;
  rq.rparam = &status;
  rq.rlen = 1;
  if (hci_send_req(&rq, FALSE) < 0)
    return BLE_STATUS_TIMEOUT;
  if (status) {
    return status;
  }
  return BLE_STATUS_SUCCESS;
}
