

/**
  ******************************************************************************
  * @file    bluenrg_lp_stack_init_if.c
  * @author  AMS - RF Application team
  * @date    13 April 2021
  * @brief   Autogenerated files, do not edit!!
  ******************************************************************************
  * @attention
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  *
  * <h2><center>&copy; COPYRIGHT STMicroelectronics</center></h2>
  ******************************************************************************
  */
#include "bluenrg_lp_stack.h"
#include "bluenrg_lp_ev_if.h"
#include "compiler.h"

WEAK_FUNCTION(void hci_disconnection_complete_event(uint8_t Status,
                                      uint16_t Connection_Handle,
                                      uint8_t Reason){});
WEAK_FUNCTION(void hci_encryption_change_event(uint8_t Status,
                                 uint16_t Connection_Handle,
                                 uint8_t Encryption_Enabled){});
WEAK_FUNCTION(void hci_read_remote_version_information_complete_event(uint8_t Status,
                                                        uint16_t Connection_Handle,
                                                        uint8_t Version,
                                                        uint16_t Manufacturer_Name,
                                                        uint16_t Subversion){});
WEAK_FUNCTION(void hci_hardware_error_event(uint8_t Hardware_Code){});
WEAK_FUNCTION(void hci_number_of_completed_packets_event(uint8_t Number_of_Handles,
                                           Handle_Packets_Pair_Entry_t Handle_Packets_Pair_Entry[]){});
WEAK_FUNCTION(void hci_data_buffer_overflow_event(uint8_t Link_Type){});
WEAK_FUNCTION(void hci_encryption_key_refresh_complete_event(uint8_t Status,
                                               uint16_t Connection_Handle){});
WEAK_FUNCTION(void hci_authenticated_payload_timeout_expired_event(uint16_t Connection_Handle){});
WEAK_FUNCTION(void aci_hal_end_of_radio_activity_event(uint8_t Last_State,
                                         uint8_t Next_State,
                                         uint32_t Next_State_SysTime){});
WEAK_FUNCTION(void aci_hal_scan_req_report_event(int8_t RSSI,
                                   uint8_t Peer_Address_Type,
                                   uint8_t Peer_Address[6]){});
WEAK_FUNCTION(void aci_hal_fw_error_event(uint8_t FW_Error_Type,
                            uint8_t Data_Length,
                            uint8_t Data[]){});
WEAK_FUNCTION(void aci_hal_adv_scan_resp_data_update_event(void * Old_Pointer,
                                             void * New_Pointer){});
WEAK_FUNCTION(void aci_gap_limited_discoverable_event(void){});
WEAK_FUNCTION(void aci_gap_pairing_complete_event(uint16_t Connection_Handle,
                                    uint8_t Status,
                                    uint8_t Reason){});
WEAK_FUNCTION(void aci_gap_pass_key_req_event(uint16_t Connection_Handle){});
WEAK_FUNCTION(void aci_gap_slave_security_initiated_event(void){});
WEAK_FUNCTION(void aci_gap_bond_lost_event(void){});
WEAK_FUNCTION(void aci_gap_proc_complete_event(uint8_t Procedure_Code,
                                 uint8_t Status,
                                 uint8_t Data_Length,
                                 uint8_t Data[]){});
WEAK_FUNCTION(void aci_gap_addr_not_resolved_event(uint16_t Connection_Handle){});
WEAK_FUNCTION(void aci_gap_numeric_comparison_value_event(uint16_t Connection_Handle,
                                            uint32_t Numeric_Value){});
WEAK_FUNCTION(void aci_gap_keypress_notification_event(uint16_t Connection_Handle,
                                         uint8_t Notification_Type){});
WEAK_FUNCTION(void aci_l2cap_connection_update_resp_event(uint16_t Connection_Handle,
                                            uint16_t Result){});
WEAK_FUNCTION(void aci_l2cap_proc_timeout_event(uint16_t Connection_Handle,
                                  uint8_t Data_Length,
                                  uint8_t Data[]){});
WEAK_FUNCTION(void aci_l2cap_connection_update_req_event(uint16_t Connection_Handle,
                                           uint8_t Identifier,
                                           uint16_t L2CAP_Length,
                                           uint16_t Interval_Min,
                                           uint16_t Interval_Max,
                                           uint16_t Slave_Latency,
                                           uint16_t Timeout_Multiplier){});
WEAK_FUNCTION(void aci_l2cap_cfc_connection_event(uint16_t Connection_Handle,
                                    uint8_t Event_Type,
                                    uint16_t Result,
                                    uint8_t Identifier,
                                    uint16_t SPSM,
                                    uint16_t CID,
                                    uint16_t Remote_CID,
                                    uint16_t Peer_MTU,
                                    uint16_t Peer_MPS,
                                    uint16_t Initial_Credits){});
WEAK_FUNCTION(void aci_l2cap_disconnection_complete_event(uint16_t Connection_Handle,
                                            uint16_t CID){});
WEAK_FUNCTION(void aci_l2cap_flow_control_credit_event(uint16_t Connection_Handle,
                                         uint16_t CID,
                                         uint16_t TX_Credits,
                                         uint16_t TX_Credit_Balance){});
WEAK_FUNCTION(void aci_l2cap_command_reject_event(uint16_t Connection_Handle,
                                    uint8_t Identifier,
                                    uint16_t Reason,
                                    uint8_t Data_Length,
                                    uint8_t Data[]){});
WEAK_FUNCTION(void aci_l2cap_sdu_data_tx_event(uint16_t Connection_Handle,
                                 uint16_t CID,
                                 uint16_t SDU_Length,
                                 void * SDU_Data_Buffer,
                                 uint16_t TX_Credit_Balance){});
WEAK_FUNCTION(void aci_l2cap_sdu_data_rx_event(uint16_t Connection_Handle,
                                 uint16_t CID,
                                 uint16_t RX_Credit_Balance,
                                 uint16_t SDU_Length){});
WEAK_FUNCTION(void aci_gatt_srv_attribute_modified_event(uint16_t Connection_Handle,
                                           uint16_t Attr_Handle,
                                           uint16_t Attr_Data_Length,
                                           uint8_t Attr_Data[]){});
WEAK_FUNCTION(void aci_gatt_proc_timeout_event(uint16_t Connection_Handle){});
WEAK_FUNCTION(void aci_att_exchange_mtu_resp_event(uint16_t Connection_Handle,
                                     uint16_t Server_RX_MTU){});
WEAK_FUNCTION(void aci_att_clt_find_info_resp_event(uint16_t Connection_Handle,
                                      uint8_t Format,
                                      uint16_t Event_Data_Length,
                                      uint8_t Handle_UUID_Pair[]){});
WEAK_FUNCTION(void aci_att_clt_find_by_type_value_resp_event(uint16_t Connection_Handle,
                                               uint8_t Num_of_Handle_Pair,
                                               Attribute_Group_Handle_Pair_t Attribute_Group_Handle_Pair[]){});
WEAK_FUNCTION(void aci_att_clt_read_by_type_resp_event(uint16_t Connection_Handle,
                                         uint8_t Handle_Value_Pair_Length,
                                         uint16_t Data_Length,
                                         uint8_t Handle_Value_Pair_Data[]){});
WEAK_FUNCTION(void aci_att_clt_read_resp_event(uint16_t Connection_Handle,
                                 uint16_t Event_Data_Length,
                                 uint8_t Attribute_Value[]){});
WEAK_FUNCTION(void aci_att_clt_read_blob_resp_event(uint16_t Connection_Handle,
                                      uint16_t Event_Data_Length,
                                      uint8_t Attribute_Value[]){});
WEAK_FUNCTION(void aci_att_clt_read_multiple_resp_event(uint16_t Connection_Handle,
                                          uint16_t Event_Data_Length,
                                          uint8_t Set_Of_Values[]){});
WEAK_FUNCTION(void aci_att_clt_read_by_group_type_resp_event(uint16_t Connection_Handle,
                                               uint8_t Attribute_Data_Length,
                                               uint16_t Data_Length,
                                               uint8_t Attribute_Data_List[]){});
WEAK_FUNCTION(void aci_att_clt_prepare_write_resp_event(uint16_t Connection_Handle,
                                          uint16_t Attribute_Handle,
                                          uint16_t Offset,
                                          uint16_t Part_Attribute_Value_Length,
                                          uint8_t Part_Attribute_Value[]){});
WEAK_FUNCTION(void aci_att_clt_exec_write_resp_event(uint16_t Connection_Handle){});
WEAK_FUNCTION(void aci_gatt_clt_indication_event(uint16_t Connection_Handle,
                                   uint16_t Attribute_Handle,
                                   uint16_t Attribute_Value_Length,
                                   uint8_t Attribute_Value[]){});
WEAK_FUNCTION(void aci_gatt_clt_notification_event(uint16_t Connection_Handle,
                                     uint16_t Attribute_Handle,
                                     uint16_t Attribute_Value_Length,
                                     uint8_t Attribute_Value[]){});
WEAK_FUNCTION(void aci_gatt_clt_proc_complete_event(uint16_t Connection_Handle,
                                      uint8_t Error_Code){});
WEAK_FUNCTION(void aci_gatt_clt_error_resp_event(uint16_t Connection_Handle,
                                   uint8_t Req_Opcode,
                                   uint16_t Attribute_Handle,
                                   uint8_t Error_Code){});
WEAK_FUNCTION(void aci_gatt_clt_disc_read_char_by_uuid_resp_event(uint16_t Connection_Handle,
                                                    uint16_t Attribute_Handle,
                                                    uint8_t Attribute_Value_Length,
                                                    uint8_t Attribute_Value[]){});
WEAK_FUNCTION(void aci_gatt_tx_pool_available_event(uint16_t Connection_Handle,
                                      uint16_t Available_Buffers){});
WEAK_FUNCTION(void aci_gatt_srv_confirmation_event(uint16_t Connection_Handle){});
WEAK_FUNCTION(void aci_gatt_srv_read_event(uint16_t Connection_Handle,
                             uint16_t Attribute_Handle,
                             uint16_t Data_Offset){});
WEAK_FUNCTION(void aci_gatt_srv_write_event(uint16_t Connection_Handle,
                              uint8_t Resp_Needed,
                              uint16_t Attribute_Handle,
                              uint16_t Data_Length,
                              uint8_t Data[]){});
WEAK_FUNCTION(void aci_att_srv_prepare_write_req_event(uint16_t Connection_Handle,
                                         uint16_t Attribute_Handle,
                                         uint16_t Data_Offset,
                                         uint16_t Data_Length,
                                         uint8_t Data[]){});
WEAK_FUNCTION(void aci_att_srv_exec_write_req_event(uint16_t Connection_Handle,
                                      uint8_t Flags){});
WEAK_FUNCTION(void hci_le_connection_complete_event(uint8_t Status,
                                      uint16_t Connection_Handle,
                                      uint8_t Role,
                                      uint8_t Peer_Address_Type,
                                      uint8_t Peer_Address[6],
                                      uint16_t Conn_Interval,
                                      uint16_t Conn_Latency,
                                      uint16_t Supervision_Timeout,
                                      uint8_t Master_Clock_Accuracy){});
WEAK_FUNCTION(void hci_le_advertising_report_event(uint8_t Num_Reports,
                                     Advertising_Report_t Advertising_Report[]){});
WEAK_FUNCTION(void hci_le_connection_update_complete_event(uint8_t Status,
                                             uint16_t Connection_Handle,
                                             uint16_t Conn_Interval,
                                             uint16_t Conn_Latency,
                                             uint16_t Supervision_Timeout){});
WEAK_FUNCTION(void hci_le_read_remote_used_features_complete_event(uint8_t Status,
                                                     uint16_t Connection_Handle,
                                                     uint8_t LE_Features[8]){});
WEAK_FUNCTION(void hci_le_long_term_key_request_event(uint16_t Connection_Handle,
                                        uint8_t Random_Number[8],
                                        uint16_t Encrypted_Diversifier){});
WEAK_FUNCTION(void hci_le_data_length_change_event(uint16_t Connection_Handle,
                                     uint16_t MaxTxOctets,
                                     uint16_t MaxTxTime,
                                     uint16_t MaxRxOctets,
                                     uint16_t MaxRxTime){});
WEAK_FUNCTION(void hci_le_read_local_p256_public_key_complete_event(uint8_t Status,
                                                      uint8_t Local_P256_Public_Key[64]){});
WEAK_FUNCTION(void hci_le_generate_dhkey_complete_event(uint8_t Status,
                                          uint8_t DHKey[32]){});
WEAK_FUNCTION(void hci_le_enhanced_connection_complete_event(uint8_t Status,
                                               uint16_t Connection_Handle,
                                               uint8_t Role,
                                               uint8_t Peer_Address_Type,
                                               uint8_t Peer_Address[6],
                                               uint8_t Local_Resolvable_Private_Address[6],
                                               uint8_t Peer_Resolvable_Private_Address[6],
                                               uint16_t Conn_Interval,
                                               uint16_t Conn_Latency,
                                               uint16_t Supervision_Timeout,
                                               uint8_t Master_Clock_Accuracy){});
WEAK_FUNCTION(void hci_le_direct_advertising_report_event(uint8_t Num_Reports,
                                            Direct_Advertising_Report_t Direct_Advertising_Report[]){});
WEAK_FUNCTION(void hci_le_phy_update_complete_event(uint8_t Status,
                                      uint16_t Connection_Handle,
                                      uint8_t TX_PHY,
                                      uint8_t RX_PHY){});
WEAK_FUNCTION(void hci_le_extended_advertising_report_event(uint8_t Num_Reports,
                                              Extended_Advertising_Report_t Extended_Advertising_Report[]){});
WEAK_FUNCTION(void hci_le_periodic_advertising_sync_established_event(uint8_t Status,
                                                        uint16_t Sync_Handle,
                                                        uint8_t Advertising_SID,
                                                        uint8_t Advertiser_Address_Type,
                                                        uint8_t Advertiser_Address[6],
                                                        uint8_t Advertiser_PHY,
                                                        uint16_t Periodic_Advertising_Interval,
                                                        uint8_t Advertiser_Clock_Accuracy){});
WEAK_FUNCTION(void hci_le_periodic_advertising_report_event(uint16_t Sync_Handle,
                                              int8_t TX_Power,
                                              int8_t RSSI,
                                              uint8_t CTE_Type,
                                              uint8_t Data_Status,
                                              uint8_t Data_Length,
                                              uint8_t Data[]){});
WEAK_FUNCTION(void hci_le_periodic_advertising_sync_lost_event(uint16_t Sync_Handle){});
WEAK_FUNCTION(void hci_le_scan_timeout_event(void){});
WEAK_FUNCTION(void hci_le_advertising_set_terminated_event(uint8_t Status,
                                             uint8_t Advertising_Handle,
                                             uint16_t Connection_Handle,
                                             uint8_t Num_Completed_Extended_Advertising_Events){});
WEAK_FUNCTION(void hci_le_scan_request_received_event(uint8_t Advertising_Handle,
                                        uint8_t Scanner_Address_Type,
                                        uint8_t Scanner_Address[6]){});
WEAK_FUNCTION(void hci_le_channel_selection_algorithm_event(uint16_t Connection_Handle,
                                              uint8_t Channel_Selection_Algorithm){});
WEAK_FUNCTION(void hci_le_connectionless_iq_report_event(uint16_t Sync_Handle,
                                           uint8_t Channel_Index,
                                           uint16_t RSSI,
                                           uint8_t RSSI_Antenna_ID,
                                           uint8_t CTE_Type,
                                           uint8_t Slot_Durations,
                                           uint8_t Packet_Status,
                                           uint16_t Periodic_Event_Counter,
                                           uint8_t Sample_Count,
                                           Samples_t Samples[]){});
WEAK_FUNCTION(void hci_le_connection_iq_report_event(uint16_t Connection_Handle,
                                       uint8_t RX_PHY,
                                       uint8_t Data_Channel_Index,
                                       uint16_t RSSI,
                                       uint8_t RSSI_Antenna_ID,
                                       uint8_t CTE_Type,
                                       uint8_t Slot_Durations,
                                       uint8_t Packet_Status,
                                       uint16_t Connection_Event_Counter,
                                       uint8_t Sample_Count,
                                       Samples_t Samples[]){});
WEAK_FUNCTION(void hci_le_cte_request_failed_event(uint8_t Status,
                                     uint16_t Connection_Handle){});
WEAK_FUNCTION(void hci_le_periodic_advertising_sync_transfer_received_event(uint8_t Status,
                                                              uint16_t Connection_Handle,
                                                              uint16_t Service_data,
                                                              uint16_t Sync_Handle,
                                                              uint8_t Advertising_SID,
                                                              uint8_t Advertiser_Address_Type,
                                                              uint8_t Advertiser_Address[6],
                                                              uint8_t Advertiser_PHY,
                                                              uint16_t Periodic_Advertising_Interval,
                                                              uint8_t Advertiser_Clock_Accuracy){});
WEAK_FUNCTION(void hci_le_path_loss_threshold_event(uint16_t Connection_Handle,
                                      uint8_t Current_Path_Loss,
                                      uint8_t Zone_Entered){});
WEAK_FUNCTION(void hci_le_transmit_power_reporting_event(uint8_t Status,
                                           uint16_t Connection_Handle,
                                           uint8_t Reason,
                                           uint8_t PHY,
                                           int8_t Transmit_Power_Level,
                                           uint8_t Transmit_Power_Level_Flag,
                                           int8_t Delta){});
WEAK_FUNCTION(void HAL_VTimerTimeoutCallback(uint8_t timerNum){});


tBleStatus BLE_STACK_Init_nocallbacks(const BLE_STACK_InitTypeDef *BLE_STACK_InitStruct);

tBleStatus BLE_STACK_Init(const BLE_STACK_InitTypeDef *BLE_STACK_InitStruct)
{
  REGISTER_CALLBACK(HCI_DISCONNECTION_COMPLETE_EVENT, hci_disconnection_complete_event);
  REGISTER_CALLBACK(HCI_ENCRYPTION_CHANGE_EVENT, hci_encryption_change_event);
  REGISTER_CALLBACK(HCI_READ_REMOTE_VERSION_INFORMATION_COMPLETE_EVENT, hci_read_remote_version_information_complete_event);
  REGISTER_CALLBACK(HCI_HARDWARE_ERROR_EVENT, hci_hardware_error_event);
  REGISTER_CALLBACK(HCI_NUMBER_OF_COMPLETED_PACKETS_EVENT, hci_number_of_completed_packets_event);
  REGISTER_CALLBACK(HCI_DATA_BUFFER_OVERFLOW_EVENT, hci_data_buffer_overflow_event);
  REGISTER_CALLBACK(HCI_ENCRYPTION_KEY_REFRESH_COMPLETE_EVENT, hci_encryption_key_refresh_complete_event);
  REGISTER_CALLBACK(HCI_AUTHENTICATED_PAYLOAD_TIMEOUT_EXPIRED_EVENT, hci_authenticated_payload_timeout_expired_event);
  REGISTER_CALLBACK(ACI_HAL_END_OF_RADIO_ACTIVITY_EVENT, aci_hal_end_of_radio_activity_event);
  REGISTER_CALLBACK(ACI_HAL_SCAN_REQ_REPORT_EVENT, aci_hal_scan_req_report_event);
  REGISTER_CALLBACK(ACI_HAL_FW_ERROR_EVENT, aci_hal_fw_error_event);
  REGISTER_CALLBACK(ACI_HAL_ADV_SCAN_RESP_DATA_UPDATE_EVENT, aci_hal_adv_scan_resp_data_update_event);
  REGISTER_CALLBACK(ACI_GAP_LIMITED_DISCOVERABLE_EVENT, aci_gap_limited_discoverable_event);
  REGISTER_CALLBACK(ACI_GAP_PAIRING_COMPLETE_EVENT, aci_gap_pairing_complete_event);
  REGISTER_CALLBACK(ACI_GAP_PASS_KEY_REQ_EVENT, aci_gap_pass_key_req_event);
  REGISTER_CALLBACK(ACI_GAP_SLAVE_SECURITY_INITIATED_EVENT, aci_gap_slave_security_initiated_event);
  REGISTER_CALLBACK(ACI_GAP_BOND_LOST_EVENT, aci_gap_bond_lost_event);
  REGISTER_CALLBACK(ACI_GAP_PROC_COMPLETE_EVENT, aci_gap_proc_complete_event);
  REGISTER_CALLBACK(ACI_GAP_ADDR_NOT_RESOLVED_EVENT, aci_gap_addr_not_resolved_event);
  REGISTER_CALLBACK(ACI_GAP_NUMERIC_COMPARISON_VALUE_EVENT, aci_gap_numeric_comparison_value_event);
  REGISTER_CALLBACK(ACI_GAP_KEYPRESS_NOTIFICATION_EVENT, aci_gap_keypress_notification_event);
  REGISTER_CALLBACK(ACI_L2CAP_CONNECTION_UPDATE_RESP_EVENT, aci_l2cap_connection_update_resp_event);
  REGISTER_CALLBACK(ACI_L2CAP_PROC_TIMEOUT_EVENT, aci_l2cap_proc_timeout_event);
  REGISTER_CALLBACK(ACI_L2CAP_CONNECTION_UPDATE_REQ_EVENT, aci_l2cap_connection_update_req_event);
  REGISTER_CALLBACK(ACI_L2CAP_CFC_CONNECTION_EVENT, aci_l2cap_cfc_connection_event);
  REGISTER_CALLBACK(ACI_L2CAP_DISCONNECTION_COMPLETE_EVENT, aci_l2cap_disconnection_complete_event);
  REGISTER_CALLBACK(ACI_L2CAP_FLOW_CONTROL_CREDIT_EVENT, aci_l2cap_flow_control_credit_event);
  REGISTER_CALLBACK(ACI_L2CAP_COMMAND_REJECT_EVENT, aci_l2cap_command_reject_event);
  REGISTER_CALLBACK(ACI_L2CAP_SDU_DATA_TX_EVENT, aci_l2cap_sdu_data_tx_event);
  REGISTER_CALLBACK(ACI_L2CAP_SDU_DATA_RX_EVENT, aci_l2cap_sdu_data_rx_event);
  REGISTER_CALLBACK(ACI_GATT_SRV_ATTRIBUTE_MODIFIED_EVENT, aci_gatt_srv_attribute_modified_event);
  REGISTER_CALLBACK(ACI_GATT_PROC_TIMEOUT_EVENT, aci_gatt_proc_timeout_event);
  REGISTER_CALLBACK(ACI_ATT_EXCHANGE_MTU_RESP_EVENT, aci_att_exchange_mtu_resp_event);
  REGISTER_CALLBACK(ACI_ATT_CLT_FIND_INFO_RESP_EVENT, aci_att_clt_find_info_resp_event);
  REGISTER_CALLBACK(ACI_ATT_CLT_FIND_BY_TYPE_VALUE_RESP_EVENT, aci_att_clt_find_by_type_value_resp_event);
  REGISTER_CALLBACK(ACI_ATT_CLT_READ_BY_TYPE_RESP_EVENT, aci_att_clt_read_by_type_resp_event);
  REGISTER_CALLBACK(ACI_ATT_CLT_READ_RESP_EVENT, aci_att_clt_read_resp_event);
  REGISTER_CALLBACK(ACI_ATT_CLT_READ_BLOB_RESP_EVENT, aci_att_clt_read_blob_resp_event);
  REGISTER_CALLBACK(ACI_ATT_CLT_READ_MULTIPLE_RESP_EVENT, aci_att_clt_read_multiple_resp_event);
  REGISTER_CALLBACK(ACI_ATT_CLT_READ_BY_GROUP_TYPE_RESP_EVENT, aci_att_clt_read_by_group_type_resp_event);
  REGISTER_CALLBACK(ACI_ATT_CLT_PREPARE_WRITE_RESP_EVENT, aci_att_clt_prepare_write_resp_event);
  REGISTER_CALLBACK(ACI_ATT_CLT_EXEC_WRITE_RESP_EVENT, aci_att_clt_exec_write_resp_event);
  REGISTER_CALLBACK(ACI_GATT_CLT_INDICATION_EVENT, aci_gatt_clt_indication_event);
  REGISTER_CALLBACK(ACI_GATT_CLT_NOTIFICATION_EVENT, aci_gatt_clt_notification_event);
  REGISTER_CALLBACK(ACI_GATT_CLT_PROC_COMPLETE_EVENT, aci_gatt_clt_proc_complete_event);
  REGISTER_CALLBACK(ACI_GATT_CLT_ERROR_RESP_EVENT, aci_gatt_clt_error_resp_event);
  REGISTER_CALLBACK(ACI_GATT_CLT_DISC_READ_CHAR_BY_UUID_RESP_EVENT, aci_gatt_clt_disc_read_char_by_uuid_resp_event);
  REGISTER_CALLBACK(ACI_GATT_TX_POOL_AVAILABLE_EVENT, aci_gatt_tx_pool_available_event);
  REGISTER_CALLBACK(ACI_GATT_SRV_CONFIRMATION_EVENT, aci_gatt_srv_confirmation_event);
  REGISTER_CALLBACK(ACI_GATT_SRV_READ_EVENT, aci_gatt_srv_read_event);
  REGISTER_CALLBACK(ACI_GATT_SRV_WRITE_EVENT, aci_gatt_srv_write_event);
  REGISTER_CALLBACK(ACI_ATT_SRV_PREPARE_WRITE_REQ_EVENT, aci_att_srv_prepare_write_req_event);
  REGISTER_CALLBACK(ACI_ATT_SRV_EXEC_WRITE_REQ_EVENT, aci_att_srv_exec_write_req_event);
  REGISTER_CALLBACK(HCI_LE_CONNECTION_COMPLETE_EVENT, hci_le_connection_complete_event);
  REGISTER_CALLBACK(HCI_LE_ADVERTISING_REPORT_EVENT, hci_le_advertising_report_event);
  REGISTER_CALLBACK(HCI_LE_CONNECTION_UPDATE_COMPLETE_EVENT, hci_le_connection_update_complete_event);
  REGISTER_CALLBACK(HCI_LE_READ_REMOTE_USED_FEATURES_COMPLETE_EVENT, hci_le_read_remote_used_features_complete_event);
  REGISTER_CALLBACK(HCI_LE_LONG_TERM_KEY_REQUEST_EVENT, hci_le_long_term_key_request_event);
  REGISTER_CALLBACK(HCI_LE_DATA_LENGTH_CHANGE_EVENT, hci_le_data_length_change_event);
  REGISTER_CALLBACK(HCI_LE_READ_LOCAL_P256_PUBLIC_KEY_COMPLETE_EVENT, hci_le_read_local_p256_public_key_complete_event);
  REGISTER_CALLBACK(HCI_LE_GENERATE_DHKEY_COMPLETE_EVENT, hci_le_generate_dhkey_complete_event);
  REGISTER_CALLBACK(HCI_LE_ENHANCED_CONNECTION_COMPLETE_EVENT, hci_le_enhanced_connection_complete_event);
  REGISTER_CALLBACK(HCI_LE_DIRECT_ADVERTISING_REPORT_EVENT, hci_le_direct_advertising_report_event);
  REGISTER_CALLBACK(HCI_LE_PHY_UPDATE_COMPLETE_EVENT, hci_le_phy_update_complete_event);
  REGISTER_CALLBACK(HCI_LE_EXTENDED_ADVERTISING_REPORT_EVENT, hci_le_extended_advertising_report_event);
  REGISTER_CALLBACK(HCI_LE_PERIODIC_ADVERTISING_SYNC_ESTABLISHED_EVENT, hci_le_periodic_advertising_sync_established_event);
  REGISTER_CALLBACK(HCI_LE_PERIODIC_ADVERTISING_REPORT_EVENT, hci_le_periodic_advertising_report_event);
  REGISTER_CALLBACK(HCI_LE_PERIODIC_ADVERTISING_SYNC_LOST_EVENT, hci_le_periodic_advertising_sync_lost_event);
  REGISTER_CALLBACK(HCI_LE_SCAN_TIMEOUT_EVENT, hci_le_scan_timeout_event);
  REGISTER_CALLBACK(HCI_LE_ADVERTISING_SET_TERMINATED_EVENT, hci_le_advertising_set_terminated_event);
  REGISTER_CALLBACK(HCI_LE_SCAN_REQUEST_RECEIVED_EVENT, hci_le_scan_request_received_event);
  REGISTER_CALLBACK(HCI_LE_CHANNEL_SELECTION_ALGORITHM_EVENT, hci_le_channel_selection_algorithm_event);
  REGISTER_CALLBACK(HCI_LE_CONNECTIONLESS_IQ_REPORT_EVENT, hci_le_connectionless_iq_report_event);
  REGISTER_CALLBACK(HCI_LE_CONNECTION_IQ_REPORT_EVENT, hci_le_connection_iq_report_event);
  REGISTER_CALLBACK(HCI_LE_CTE_REQUEST_FAILED_EVENT, hci_le_cte_request_failed_event);
  REGISTER_CALLBACK(HCI_LE_PERIODIC_ADVERTISING_SYNC_TRANSFER_RECEIVED_EVENT, hci_le_periodic_advertising_sync_transfer_received_event);
  REGISTER_CALLBACK(HCI_LE_PATH_LOSS_THRESHOLD_EVENT, hci_le_path_loss_threshold_event);
  REGISTER_CALLBACK(HCI_LE_TRANSMIT_POWER_REPORTING_EVENT, hci_le_transmit_power_reporting_event);

  return BLE_STACK_Init_nocallbacks(BLE_STACK_InitStruct);
}
