

/**
  ******************************************************************************
  * @file    bluenrg_lp_api.h
  * @author  AMS - RF Application team
  * @date    07 May 2021
  * @brief   Header file for Bluetooth Low Energy stack APIs.
  *          Autogenerated files, do not edit!!
  ******************************************************************************
  * @attention
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  *
  * <h2><center>&copy; COPYRIGHT STMicroelectronics</center></h2>
  ******************************************************************************
  */
#ifndef _BLUENRG_LP_API_H_
#define _BLUENRG_LP_API_H_

#include "bluenrg_lp_gatt.h"
#include <stdint.h>
#include "ble_status.h"
#include "system_util.h"
    
/** Documentation for C struct Advertising_Set_Parameters_t */
typedef struct Advertising_Set_Parameters_t_s {
  /** It is used to identify an advertising set.
   *  Values:
   *  - 0x00 ... 0xEF
   */
  uint8_t Advertising_Handle;
  /** The Duration[i] parameter indicates the duration for which that advertising set
   *  is enabled. The duration begins at the start of the first advertising
   *  event of this advertising set. The Controller should not start an extended
   *  advertising event that it cannot complete within the duration. Time = N *
   *  10 ms 0x00 means no advertising duration: advertising will continue until
   *  the Host disables it.
   *  Values:
   *  - 0x0000 (0 ms) : No advertising duration
   *  - 0x0001 (10 ms)  ... 0xFFFF (655350 ms) 
   */
  uint16_t Duration;
  /** The Max_Extended_Advertising_Events[i] parameter, if non-zero, indicates the
   *  maximum number of extended advertising events that shall be sent prior to
   *  disabling the extended advertising set even if the Duration[i] parameter
   *  has not expired.
   *  Values:
   *  - 0x00: No maximum number of advertising events.
   *  - 0x01 ... 0xFF: Maximum number of extended advertising events.
   */
  uint8_t Max_Extended_Advertising_Events;
} Advertising_Set_Parameters_t;
/** Documentation for C struct Extended_Scan_Parameters_t */
typedef struct Extended_Scan_Parameters_t_s {
  /** The Scan_Type parameter specifies the type of scan to perform. 0: Passive
   *  Scanning. No scan request PDUs shall be sent. 1: Active Scanning. Scan
   *  request PDUs may be sent.
   *  Values:
   *  - 0x00: Passive Scanning
   *  - 0x01: Active Scanning
   */
  uint8_t Scan_Type;
  /** Time interval from when the Controller started its last scan until it begins the
   *  subsequent scan on the primary advertising channel.  Time = N * 0.625 ms
   *  Values:
   *  - 0x0004 (2.500 ms)  ... 0xFFFF (40959.375 ms) 
   */
  uint16_t Scan_Interval;
  /** Duration of the scan on the primary advertising channel.  Time = N * 0.625 ms
   *  Values:
   *  - 0x0004 (2.500 ms)  ... 0xFFFF (40959.375 ms) 
   */
  uint16_t Scan_Window;
} Extended_Scan_Parameters_t;
/** Documentation for C struct Extended_Create_Connection_Parameters_t */
typedef struct Extended_Create_Connection_Parameters_t_s {
  /** Time interval from when the Controller started its last scan until it begins the
   *  subsequent scan on the primary advertising channel. Time = N * 0.625 ms;
   *  Time Range: 2.5 ms to 40.959375 s.
   *  Values:
   *  - 0x0004 (2.500 ms)  ... 0xFFFF (40959.375 ms) 
   */
  uint16_t Scan_Interval;
  /** Duration of the scan on the primary advertising channel. Time = N * 0.625 ms;
   *  Time Range: 2.5 ms to 40.959375 s.
   *  Values:
   *  - 0x0004 (2.500 ms)  ... 0xFFFF (40959.375 ms) 
   */
  uint16_t Scan_Window;
  /** Mimimun value for the connection interval. This shall be less than or equal to
   *  Conn_Interval_Max[i]. Time = N * 1.25 ms; Time Range: 7.5 ms to 4 s.
   *  Values:
   *  - 0x0006 (7.50 ms)  ... 0x0C80 (4000.00 ms) 
   */
  uint16_t Conn_Interval_Min;
  /** Maximum value for the connection interval. This shall be less than or equal to
   *  Conn_Interval_Max[i]. Time = N * 1.25 ms; Time Range: 7.5 ms to 4 s.
   *  Values:
   *  - 0x0006 (7.50 ms)  ... 0x0C80 (4000.00 ms) 
   */
  uint16_t Conn_Interval_Max;
  /** Slave latency for the connection in number of connection events
   *  Values:
   *  - 0x0000 ... 0x01F3
   */
  uint16_t Conn_Latency;
  /** Supervision timeout for the LE Link. (See [Vol 6] Part B, Section 4.5.2) Time =
   *  N * 10 ms; Time Range: 100 ms to 32 s.
   *  Values:
   *  - 0x000A (100 ms)  ... 0x0C80 (32000 ms) 
   */
  uint16_t Supervision_Timeout;
  /** Informative parameter recommending the minimum length of connection event needed
   *  for this LE connection. Time = N * 0.625 ms.
   *  Values:
   *  - 0x0000 (0.000 ms)  ... 0xFFFF (40959.375 ms) 
   */
  uint16_t Minimum_CE_Length;
  /** Informative parameter recommending the maximum length of connection event needed
   *  for this LE connection. Time = N * 0.625 ms.
   *  Values:
   *  - 0x0000 (0.000 ms)  ... 0xFFFF (40959.375 ms) 
   */
  uint16_t Maximum_CE_Length;
} Extended_Create_Connection_Parameters_t;
/** Documentation for C struct Bonded_Device_Entry_t */
typedef struct Bonded_Device_Entry_t_s {
  /** Address type.
   *  Values:
   *  - 0x00: Public Device Address
   *  - 0x01: Random Device Address
   */
  uint8_t Address_Type;
  /** Identity Address (Public or Random) of the device.
   */
  uint8_t Address[6];
} Bonded_Device_Entry_t;
/** Documentation for C struct List_Entry_t */
typedef struct List_Entry_t_s {
  /** Address type.
   *  Values:
   *  - 0x00: Public Device Address
   *  - 0x01: Random Device Address
   */
  uint8_t Peer_Address_Type;
  /** Public Device Address or Random Device Address of the device to be added to the
   *  list.
   */
  uint8_t Peer_Address[6];
} List_Entry_t;
/** Documentation for C union UUID_t */
typedef union UUID_t_s {
  /** 16-bit UUID
   */
  uint16_t UUID_16;
  /** 128-bit UUID
   */
  uint8_t UUID_128[16];
} UUID_t;
/** Documentation for C struct Handle_Entry_t */
typedef struct Handle_Entry_t_s {
  /** The handles for which the attribute value has to be read
   *  Values:
   *  - 0x0001 ... 0xFFFF
   */
  uint16_t Handle;
} Handle_Entry_t;

/**
 *@addtogroup HCI HCI
 *@brief Host Controller Interface
 *@{
 */
/**
 *@defgroup HCI_Commands HCI Commands
 *@brief Standard HCI Commands
 *@{
 */
/**
 * @brief The @ref hci_disconnect is used to terminate an existing connection.
 *        The Connection_Handle command parameter indicates which connection is
 *        to be disconnected. The Reason command parameter indicates the reason
 *        for ending the connection. The remote Controller will receive the
 *        Reason command parameter in the @ref hci_disconnection_complete_event
 *        event. All synchronous connections on a physical link should be
 *        disconnected before the ACL connection on the same physical connection
 *        is disconnected. (See Bluetooth Specification v.4.1, Vol. 2, Part E,
 *        7.1.6) It is important to leave an 100 ms blank window before sending
 *        any new command (including system hardware reset), since immediately
 *        after @ref hci_disconnection_complete_event event, system could save
 *        important information in non volatile memory.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Reason The reason for ending the connection.
 *        Values:
 *        - 0x05: Authentication Failure
 *        - 0x13: Remote User Terminated Connection
 *        - 0x14: Remote Device Terminated Connection due to Low Resources
 *        - 0x15: Remote Device Terminated Connection due to Power Off
 *        - 0x1A: Unsupported Remote Feature
 *        - 0x3B: Unacceptable Connection Parameters
 * @retval Value indicating success or error code.
 */
tBleStatus hci_disconnect(uint16_t Connection_Handle,
                          uint8_t Reason);
/**
 * @brief This command will obtain the values for the version information for
 *        the remote device identified by the Connection_Handle parameter. The
 *        Connection_Handle must be a Connection_Handle for an ACL or LE
 *        connection. (See Bluetooth Specification v.4.1, Vol. 2, Part E,
 *        7.1.23)
 * @param Connection_Handle Specifies which Connection_Handle's version
 *        information to get.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @retval Value indicating success or error code.
 */
tBleStatus hci_read_remote_version_information(uint16_t Connection_Handle);
/**
 * @brief The Set_Event_Mask command is used to control which events are
 *        generated by the HCI for the Host.  If the bit in the Event_Mask is
 *        set to a one, then the event associated with that bit will be enabled.
 *        For an LE Controller, the LE Meta Event bit in the Event_Mask shall
 *        enable or disable all LE events in the LE Meta Event (see Section
 *        7.7.65). The Host has to deal with each event that occurs. The event
 *        mask allows the Host to control how much it is interrupted. (See
 *        Bluetooth Specification v.4.1, Vol. 2, Part E, 7.3.1)
 * @param Event_Mask Event mask. Default: 0x00001FFFFFFFFFFF
 *        Flags:
 *        - 0x0000000000000000: No events specified
 *        - 0x0000000000000001: Inquiry Complete Event
 *        - 0x0000000000000002: Inquiry Result Event
 *        - 0x0000000000000004: Connection Complete Event
 *        - 0x0000000000000008: Connection Request Event
 *        - 0x0000000000000010: Disconnection Complete Event
 *        - 0x0000000000000020: Authentication Complete Event
 *        - 0x0000000000000040: Remote Name Request Complete Event
 *        - 0x0000000000000080: Encryption Change Event
 *        - 0x0000000000000100: Change Connection Link Key Complete Event
 *        - 0x0000000000000200: Master Link Key Complete Event
 *        - 0x0000000000000400: Read Remote Supported Features Complete Event
 *        - 0x0000000000000800: Read Remote Version Information Complete Event
 *        - 0x0000000000001000: QoS Setup Complete Event
 *        - 0x0000000000008000: Hardware Error Event
 *        - 0x0000000000010000: Flush Occurred Event
 *        - 0x0000000000020000: Role Change Event
 *        - 0x0000000000080000: Mode Change Event
 *        - 0x0000000000100000: Return Link Keys Event
 *        - 0x0000000000200000: PIN Code Request Event
 *        - 0x0000000000400000: Link Key Request Event
 *        - 0x0000000000800000: Link Key Notification Event
 *        - 0x0000000001000000: Loopback Command Event
 *        - 0x0000000002000000: Data Buffer Overflow Event
 *        - 0x0000000004000000: Max Slots Change Event
 *        - 0x0000000008000000: Read Clock Offset Complete Event
 *        - 0x0000000010000000: Connection Packet Type Changed Event
 *        - 0x0000000020000000: QoS Violation Event
 *        - 0x0000000040000000: Page Scan Mode Change Event
 *        - 0x0000000080000000: Page Scan Repetition Mode Change Event
 *        - 0x0000000100000000: Flow Specification Complete Event
 *        - 0x0000000200000000: Inquiry Result with RSSI Event
 *        - 0x0000000400000000: Read Remote Extended Features Complete Event
 *        - 0x0000080000000000: Synchronous Connection Complete Event
 *        - 0x0000100000000000: Synchronous Connection Changed Event
 *        - 0x0000200000000000: Sniff Subrating Event
 *        - 0x0000400000000000: Extended Inquiry Result Event
 *        - 0x0000800000000000: Encryption Key Refresh Complete Event
 *        - 0x0001000000000000: IO Capability Request Event
 *        - 0x0002000000000000: IO Capability Request Reply Event
 *        - 0x0004000000000000: User Confirmation Request Event
 *        - 0x0008000000000000: User Passkey Request Event
 *        - 0x0010000000000000: Remote OOB Data Request Event
 *        - 0x0020000000000000: Simple Pairing Complete Event
 *        - 0x0080000000000000: Link Supervision Timeout Changed Event
 *        - 0x0100000000000000: Enhanced Flush Complete Event
 *        - 0x0400000000000000: User Passkey Notification Event
 *        - 0x0800000000000000: Keypress Notification Event
 *        - 0x1000000000000000: Remote Host Supported Features Notification Event
 *        - 0x2000000000000000: LE Meta-Event
 * @retval Value indicating success or error code.
 */
tBleStatus hci_set_event_mask(uint8_t Event_Mask[8]);
/**
 * @brief This command reads the values for the Transmit_Power_Level parameter
 *        for the specified Connection_Handle. The Connection_Handle shall be a
 *        Connection_Handle for an ACL connection. (See Bluetooth Specification
 *        v.4.1, Vol. 2, Part E, 7.3.35)
 * @param Connection_Handle Specifies which Connection_Handle's Transmit Power
 *        Level setting to read.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Type Current or maximum transmit power level.
 *        Values:
 *        - 0x00: Read Current Transmit Power Level.
 *        - 0x01: Read Maximum Transmit Power Level.
 * @param[out] Transmit_Power_Level Size: 1 Octet (signed integer) Units: dBm
 *             Values:
 *             - -30 ... 20
 * @retval Value indicating success or error code.
 */
tBleStatus hci_read_transmit_power_level(uint16_t Connection_Handle,
                                         uint8_t Type,
                                         int8_t *Transmit_Power_Level);
/**
 * @brief The HCI_Set_Event_Mask_Page_2 command is used to control which events
 *        are generated by the HCI for the Host. The Event_Mask_Page_2 is a
 *        logical extension to the Event_Mask parameter of the
 *        HCI_Set_Event_Mask command. If the bit in the Event_Mask_Page_2 is set
 *        to a one, then the event associated with that bit shall be enabled.
 *        The event mask allows the Host to control how much it is interrupted.
 *        The Controller shall ignore those bits which are reserved for future
 *        use or represent events which it does not support. If the Host sets
 *        any of these bits to 1, the Controller shall act as if they were set
 *        to 0.
 * @param Event_Mask_Page_2 For the complete list of bits tha can be set, see
 *        Core v5.1, Vol 2, part E, chapter 7.3.69. The only bit that is not
 *        ignored is: Bit 23: Authenticated Payload Timeout Expired event.
 *        Flags:
 *        - 0x0000000000800000: AUTHENTICATED_PAYLOAD_TIMEOUT_EXPIRED_EVENT
 * @retval Value indicating success or error code.
 */
tBleStatus hci_set_event_mask_page_2(uint8_t Event_Mask_Page_2[8]);
/**
 * @brief This command reads the Authenticated_Payload_Timeout parameter in the
 *        Primary Controller on the specified Connection_Handle.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param[out] Authenticated_Payload_Timeout Maximum amount of time specified
 *             between packets authenticated by a MIC. Time = N * 10 ms.
 *             Values:
 *             - 0x0001 (10 ms)  ... 0xFFFF (655350 ms) 
 * @retval Value indicating success or error code.
 */
tBleStatus hci_read_authenticated_payload_timeout(uint16_t Connection_Handle,
                                                  uint16_t *Authenticated_Payload_Timeout);
/**
 * @brief This command writes the Authenticated_Payload_Timeout parameter in the
 *        Primary Controller for the specified Connection_Handle. The
 *        Authenticated_Payload_Timeout shall be equal to or greater than
 *        connInterval * (1 + connSlaveLatency). The Link Layer will use this
 *        parameter to determine when to use the LE ping sequence.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Authenticated_Payload_Timeout Maximum amount of time specified between
 *        packets authenticated by a valid MIC. Time = N * 10 ms.
 *        Values:
 *        - 0x0001 (10 ms)  ... 0xFFFF (655350 ms) 
 * @retval Value indicating success or error code.
 */
tBleStatus hci_write_authenticated_payload_timeout(uint16_t Connection_Handle,
                                                   uint16_t Authenticated_Payload_Timeout);
/**
 * @brief This command reads the values for the version information for the
 *        local Controller. The HCI Version information defines the version
 *        information of the HCI layer. The LMP/PAL Version information defines
 *        the version of the LMP or PAL. The Manufacturer_Name information
 *        indicates the manufacturer of the local device. The HCI Revision and
 *        LMP/PAL Subversion are implementation dependent. (See Bluetooth
 *        Specification v.4.1, Vol. 2, Part E, 7.4.1)
 * @param[out] HCI_Version See Bluetooth Assigned Numbers
 *             (https://www.bluetooth.org/en-us/specification/assigned-numbers)
 * @param[out] HCI_Revision Revision of the Current HCI in the BR/EDR
 *             Controller.
 * @param[out] LMP_PAL_Version Version of the Current LMP or PAL in the
 *             Controller. See Bluetooth Assigned Numbers
 *             (https://www.bluetooth.org/en-us/specification/assigned-numbers)
 * @param[out] Manufacturer_Name Manufacturer Name of the BR/EDR Controller. See
 *             Bluetooth Assigned Numbers (https://www.bluetooth.org/en-
 *             us/specification/assigned-numbers)
 * @param[out] LMP_PAL_Subversion Subversion of the Current LMP or PAL in the
 *             Controller. This value is implementation dependent.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_read_local_version_information(uint8_t *HCI_Version,
                                              uint16_t *HCI_Revision,
                                              uint8_t *LMP_PAL_Version,
                                              uint16_t *Manufacturer_Name,
                                              uint16_t *LMP_PAL_Subversion);
/**
 * @brief This command reads the list of HCI commands supported for the local
 *        Controller. This command shall return the Supported_Commands
 *        configuration parameter. It is implied that if a command is listed as
 *        supported, the feature underlying that command is also supported. (See
 *        Bluetooth Specification v.4.1, Vol. 2, Part E, 7.4.2)
 * @param[out] Supported_Commands Bit mask for each HCI Command. If a bit is 1,
 *             the Controller supports the corresponding command and the
 *             features required for the command. Unsupported or undefined
 *             commands shall be set to 0.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_read_local_supported_commands(uint8_t Supported_Commands[64]);
/**
 * @brief This command requests a list of the supported features for the local
 *        Controller. This command will return a list of the LMP features. For
 *        details see Part C, Link Manager Protocol Specification on page 227.
 *        (See Bluetooth Specification v.4.1, Vol. 2, Part E, 7.4.3)
 * @param[out] LMP_Features Bit Mask List of LMP features.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_read_local_supported_features(uint8_t LMP_Features[8]);
/**
 * @brief On an LE Controller, this command shall read the Public Device Address
 *        as defined in [Vol 6] Part B, Section 1.3, Device Address. If this
 *        Controller does not have a Public Device Address, the value
 *        0x000000000000 shall be returned. On an LE Controller, the public
 *        address shall be the same as the BD_ADDR. (See Bluetooth Specification
 *        v.4.1, Vol. 2, Part E, 7.4.6)
 * @param[out] BD_ADDR BD_ADDR ( Bluetooth Device Address) of the Device.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_read_bd_addr(uint8_t BD_ADDR[6]);
/**
 * @brief This command reads the Received Signal Strength Indication (RSSI)
 *        value from a Controller. For an LE transport, a Connection_Handle is
 *        used as the Handle command parameter and return parameter. The meaning
 *        of the RSSI metric is an absolute receiver signal strength value in
 *        dBm to +/- 6 dB accuracy. If the RSSI cannot be read, the RSSI metric
 *        shall be set to 127. (See Bluetooth Specification v.4.1, Vol. 2, Part
 *        E, 7.5.4)
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param[out] RSSI N Size: 1 Octet (signed integer) Units: dBm
 *             Values:
 *             - 127: RSSI not available
 *             - -127 ... 20
 * @retval Value indicating success or error code.
 */
tBleStatus hci_read_rssi(uint16_t Connection_Handle,
                         int8_t *RSSI);
/**
 * @brief The LE_Set_Event_Mask command is used to control which LE events are
 *        generated by the HCI for the Host. If the bit in the LE_Event_Mask is
 *        set to a one, then the event associated with that bit will be enabled.
 *        The Host has to deal with each event that is generated by an LE
 *        Controller. The event mask allows the Host to control which events
 *        will interrupt it. For LE events to be generated, the LE Meta-Event
 *        bit in the Event_Mask shall also be set. If that bit is not set, then
 *        LE events shall not be generated, regardless of how the LE_Event_Mask
 *        is set. (See Bluetooth Specification v.4.1, Vol. 2, Part E, 7.8.1)
 * @param LE_Event_Mask LE event mask. Default: 0x000000000000001F.
 *        Flags:
 *        - 0x0000000000000000: No LE events specified
 *        - 0x0000000000000001: LE Connection Complete Event
 *        - 0x0000000000000002: LE Advertising Report Event
 *        - 0x0000000000000004: LE Connection Update Complete Event
 *        - 0x0000000000000008: LE Read Remote Used Features Complete Event
 *        - 0x0000000000000010: LE Long Term Key Request Event
 *        - 0x0000000000000020: LE Remote Connection Parameter Request Event
 *        - 0x0000000000000040: LE Data Length Change Event
 *        - 0x0000000000000080: LE Read Local P-256 Public Key Complete Event
 *        - 0x0000000000000100: LE Generate DHKey Complete Event
 *        - 0x0000000000000200: LE Enhanced Connection Complete Event
 *        - 0x0000000000000400: LE Directed Advertising Report Event
 *        - 0x0000000000000800: LE PHY Update Complete event
 *        - 0x0000000000001000: LE Extended Advertising Report event
 *        - 0x0000000000002000: LE Periodic Advertising Sync Established event
 *        - 0x0000000000004000: LE Periodic Advertising Report event
 *        - 0x0000000000008000: LE Periodic Advertising Sync Lost event
 *        - 0x0000000000010000: LE Scan Timeout event
 *        - 0x0000000000020000: LE Advertising Set Terminated event
 *        - 0x0000000000040000: LE Scan Request Received event
 *        - 0x0000000000080000: LE Channel Selection Algorithm event
 *        - 0x0000000000100000: LE Connectionless IQ Report event
 *        - 0x0000000000200000: LE Connection IQ Report event
 *        - 0x0000000000400000: LE CTE Request Failed event
 *        - 0x0000000000800000: LE Periodic Advertising Sync Transfer Received event
 *        - 0x0000000001000000: LE CIS Established event
 *        - 0x0000000002000000: LE CIS Request event
 *        - 0x0000000004000000: LE Create BIG Complete event
 *        - 0x0000000008000000: LE Terminate BIG Complete event
 *        - 0x0000000010000000: LE BIG Sync Established event
 *        - 0x0000000020000000: LE BIG Sync Lost event
 *        - 0x0000000040000000: LE Request Peer SCA Complete event
 *        - 0x0000000080000000: LE Path Loss Threshold event
 *        - 0x0000000100000000: LE Transmit Power Reporting event
 *        - 0x0000000200000000: LE BIGInfo Advertising Report event
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_event_mask(uint8_t LE_Event_Mask[8]);
/**
 * @brief The LE_Read_Buffer_Size command is used to read the maximum size of
 *        the data portion of HCI LE ACL Data Packets sent from the Host to the
 *        Controller. The Host will segment the data transmitted to the
 *        Controller according to these values, so that the HCI Data Packets
 *        will contain data with up to this size. The LE_Read_Buffer_Size
 *        command also returns the total number of HCI LE ACL Data Packets that
 *        can be stored in the data buffers of the Controller. The
 *        LE_Read_Buffer_Size command must be issued by the Host before it sends
 *        any data to an LE Controller (see Section 4.1.1). If the Controller
 *        returns a length value of zero, the Host shall use the
 *        Read_Buffer_Size command to determine the size of the data buffers
 *        Note: Both the Read_Buffer_Size and LE_Read_Buffer_Size commands may
 *        return buffer length and number of packets parameter values that are
 *        nonzero. The HC_LE_ACL_Data_Packet_Length return parameter shall be
 *        used to determine the size of the L2CAP PDU segments contained in ACL
 *        Data Packets, which are transferred from the Host to the Controller to
 *        be broken up into packets by the Link Layer. Both the Host and the
 *        Controller shall support command and event packets, where the data
 *        portion (excluding header) contained in the packets is 255 octets in
 *        size. The HC_Total_Num_LE_ACL_Data_Packets return parameter contains
 *        the total number of HCI ACL Data Packets that can be stored in the
 *        data buffers of the Controller. The Host determines how the buffers
 *        are to be divided between different Connection Handles. Note: The
 *        HC_LE_ACL_Data_Packet_Length return parameter does not include the
 *        length of the HCI Data Packet header. (See Bluetooth Specification
 *        v.4.1, Vol. 2, Part E, 7.8.2)
 * @param[out] HC_LE_ACL_Data_Packet_Length 0x0000: No dedicated LE Buffer
 *             exists. Use the HCI_Read_Buffer_Size command. 0x001B - 0xFFFF
 *             Maximum length (in octets) of the data portion of each HCI ACL
 *             data packet.
 *             Values:
 *             - 0x0000: NO_BUFFER
 *             - 0x001B ... 0xFFFF
 * @param[out] HC_Total_Num_LE_ACL_Data_Packets 0x00: No dedicated LE Buffer
 *             exists. Use the HCI_Read_Buffer_Size command. 0x01 - 0xFF: Total
 *             number of HCI ACL Data Packets that can be stored in the data
 *             buffers of the Controller.
 *             Values:
 *             - 0x00: NO_BUFFER
 *             - 0x01 ... 0xFF
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_read_buffer_size(uint16_t *HC_LE_ACL_Data_Packet_Length,
                                   uint8_t *HC_Total_Num_LE_ACL_Data_Packets);
/**
 * @brief This command requests the list of the supported LE features for the
 *        Controller. (See Bluetooth Specification v.4.1, Vol. 2, Part E, 7.8.3)
 * @param[out] LE_Features Bit Mask List of LE features. See Core v4.1, Vol. 6,
 *             Part B, Section 4.6.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_read_local_supported_features(uint8_t LE_Features[8]);
/**
 * @brief The LE_Set_Random_Address command is used by the Host to set the LE
 *        Random Device Address in the Controller (see [Vol 6] Part B, Section
 *        1.3). (See Bluetooth Specification v.4.1, Vol. 2, Part E, 7.8.4)
 * @param Random_Address Random Device Address.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_random_address(uint8_t Random_Address[6]);
/**
 * @brief The LE_Set_Advertising_Parameters command is used by the Host to set
 *        the advertising parameters. The Advertising_Interval_Min shall be less
 *        than or equal to the Advertising_Interval_Max. The
 *        Advertising_Interval_Min and Advertising_Interval_Max should not be
 *        the same value to enable the Controller to determine the best
 *        advertising interval given other activities. For high duty cycle
 *        directed advertising, i.e. when Advertising_Type is 0x01
 *        (ADV_DIRECT_IND, high duty cycle), the Advertising_Interval_Min and
 *        Advertising_Interval_Max parameters are not used and shall be ignored.
 *        The Advertising_Type is used to determine the packet type that is used
 *        for advertising when advertising is enabled. Own_Address_Type
 *        parameter indicates the type of address being used in the advertising
 *        packets. If Own_Address_Type equals 0x02 or 0x03, the Peer_Address
 *        parameter contains the peer's Identity Address and the
 *        Peer_Address_Type parameter contains the Peer's Identity Type (i.e.
 *        0x00 or 0x01). These parameters are used to locate the corresponding
 *        local IRK in the resolving list; this IRK is used to generate the own
 *        address used in the advertisement. If directed advertising is
 *        performed, i.e. when Advertising_Type is set to 0x01 (ADV_DIRECT_IND,
 *        high duty cycle) or 0x04 (ADV_DIRECT_IND, low duty cycle mode), then
 *        the Peer_Address_Type and Peer_Address shall be valid. If
 *        Own_Address_Type equals 0x02 or 0x03, the Controller generates the
 *        peer's Resolvable Private Address using the peer's IRK corresponding
 *        to the peer's Identity Address contained in the Peer_Address parameter
 *        and peer's Identity Address Type (i.e. 0x00 or 0x01) contained in the
 *        Peer_Address_Type parameter. The Advertising_Channel_Map is a bit
 *        field that indicates the advertising channels that shall be used when
 *        transmitting advertising packets. At least one channel bit shall be
 *        set in the Advertising_Channel_Map parameter. The
 *        Advertising_Filter_Policy parameter shall be ignored when directed
 *        advertising is enabled. The Host shall not issue this command when
 *        advertising is enabled in the Controller; if it is the Command
 *        Disallowed error code shall be used. If the advertising interval range
 *        provided by the Host (Advertising_Interval_Min,
 *        Advertising_Interval_Max) is outside the advertising interval range
 *        supported by the Controller, then the Controller shall return the
 *        Unsupported Feature or Parameter Value (0x11) error code.
 * @param Advertising_Interval_Min Minimum advertising interval for undirected
 *        and low duty cycle directed advertising. Time = N * 0.625 msec.
 *        Values:
 *        - 0x0020 (20.000 ms)  ... 0x4000 (10240.000 ms) 
 * @param Advertising_Interval_Max Maximum advertising interval. Time = N *
 *        0.625 msec.
 *        Values:
 *        - 0x0020 (20.000 ms)  ... 0x4000 (10240.000 ms) 
 * @param Advertising_Type Advertising type.
 *        Values:
 *        - 0x00: ADV_IND (Connectable undirected advertising)
 *        - 0x01: ADV_DIRECT_IND, high duty cycle (Connectable high duty cycle directed advertising)
 *        - 0x02: ADV_SCAN_IND (Scannable undirected advertising)
 *        - 0x03: ADV_NONCONN_IND (Non connectable undirected advertising)
 *        - 0x04: ADV_DIRECT_IND, low duty cycle (Connectable low duty cycle directed advertising)
 * @param Own_Address_Type Own address type.  - 0x00: Public Device Address  -
 *        0x01 Random Device Address  - 0x02: Controller generates Resolvable
 *        Private Address based on the local          IRK from resolving list.
 *        If resolving list contains no matching entry,          use public
 *        address.  - 0x03: Controller generates Resolvable Private Address
 *        based on the local          IRK from resolving list. If resolving list
 *        contains no matching entry,          use random address from
 *        LE_Set_Random_Address.
 *        Values:
 *        - 0x00: Public Device Address
 *        - 0x01: Random Device Address
 *        - 0x02: Resolvable Private Address or Public Address
 *        - 0x03: Resolvable Private Address or Random Address
 * @param Peer_Address_Type Peer Address type.
 *        Values:
 *        - 0x00: Public Device Address or Public Identity Address
 *        - 0x01: Random Device Address or Random (static) Identity Address
 * @param Peer_Address Public Device Address, Random Device Address, Public
 *        Identity Address or Random (static) Identity Address of the device to
 *        be connected.
 * @param Advertising_Channel_Map Advertising channel map. Default: 00000111b
 *        (all channels enabled).
 *        Flags:
 *        - 0x01: ch 37
 *        - 0x02: ch 38
 *        - 0x04: ch 39
 * @param Advertising_Filter_Policy Advertising Filter Policy. This parameter is
 *        ignored when directed advertising is enabled.  0x00 Process scan and
 *        connection requests from all devices (i.e., the White List is not in
 *        use) 0x01 Process connection requests from all devices and scan
 *        requests only from devices that are in the White List 0x02 Process
 *        scan requests from all devices and connection requests only from
 *        devices that are in the White List. 0x03 Process scan and connection
 *        requests only from devices in the White List. All other values
 *        Reserved for future use
 *        Values:
 *        - 0x00: ADV_NO_WHITE_LIST_USE
 *        - 0x01: ADV_WHITE_LIST_FOR_ONLY_SCAN
 *        - 0x02: ADV_WHITE_LIST_FOR_ONLY_CONN
 *        - 0x03: ADV_WHITE_LIST_FOR_ALL
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_advertising_parameters(uint16_t Advertising_Interval_Min,
                                             uint16_t Advertising_Interval_Max,
                                             uint8_t Advertising_Type,
                                             uint8_t Own_Address_Type,
                                             uint8_t Peer_Address_Type,
                                             uint8_t Peer_Address[6],
                                             uint8_t Advertising_Channel_Map,
                                             uint8_t Advertising_Filter_Policy);
/**
 * @brief The LE_Read_Advertising_Channel_Tx_Power command is used by the Host
 *        to read the transmit power level used for LE advertising channel
 *        packets. (See Bluetooth Specification v.4.1, Vol. 2, Part E, 7.8.6)
 * @param[out] Transmit_Power_Level Size: 1 Octet (signed integer) Units: dBm
 *             Accuracy: +/- 4 dBm
 *             Values:
 *             - -20 ... 10
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_read_advertising_channel_tx_power(int8_t *Transmit_Power_Level);
/**
 * @brief The LE_Set_Advertise_Enable command is used to request the Controller
 *        to start or stop advertising. The Controller manages the timing of
 *        advertisements as per the advertising parameters given in the
 *        LE_Set_Advertising_Parameters command. The Controller shall continue
 *        advertising until the Host issues an LE_Set_Advertise_Enable command
 *        with Advertising_Enable set to 0x00 (Advertising is disabled) or until
 *        a connection is created or until the Advertising is timed out due to
 *        high duty cycle Directed Advertising. In these cases, advertising is
 *        then disabled. (See Bluetooth Specification v.4.1, Vol. 2, Part E,
 *        7.8.9)
 * @param Advertising_Enable Enable/disable advertise. Default is 0 (disabled).
 *        Values:
 *        - 0x00: Disable
 *        - 0x01: Enable
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_advertising_enable(uint8_t Advertising_Enable);
/**
 * @brief The LE_Set_Scan_Parameters command is used to set the scan parameters.
 *        The LE_Scan_Type parameter controls the type of scan to perform. The
 *        LE_Scan_Interval and LE_Scan_Window parameters are recommendations
 *        from the Host on how long (LE_Scan_Window) and how frequently
 *        (LE_Scan_Interval) the Controller should scan (See [Vol 6] Part B,
 *        Section 4.5.3). The LE_Scan_Window parameter shall always be set to a
 *        value smaller or equal to the value set for the LE_Scan_Interval
 *        parameter. If they are set to the same value scanning should be run
 *        continuously. The Own_Address_Type parameter determines the address
 *        used (Public or Random Device Address) when performing active scan.
 *        The Host shall not issue this command when scanning is enabled in the
 *        Controller; if it is the Command Disallowed error code shall be used.
 *        (See Bluetooth Specification v.4.1, Vol. 2, Part E, 7.8.10)
 * @param LE_Scan_Type Passive or active scanning. With active scanning SCAN_REQ
 *        packets are sent.
 *        Values:
 *        - 0x00: Passive Scanning
 *        - 0x01: Active scanning
 * @param LE_Scan_Interval This is defined as the time interval from when the
 *        Controller started its last LE scan until it begins the subsequent LE
 *        scan. Time = N * 0.625 msec.
 *        Values:
 *        - 0x0004 (2.500 ms)  ... 0x4000 (10240.000 ms) 
 * @param LE_Scan_Window The duration of the LE scan. LE_Scan_Window shall be
 *        less than or equal to LE_Scan_Interval. Time = N * 0.625 msec.
 *        Values:
 *        - 0x0004 (2.500 ms)  ... 0x4000 (10240.000 ms) 
 * @param Own_Address_Type Own address type.  - 0x00: Public Device Address  -
 *        0x01 Random Device Address  - 0x02: Controller generates Resolvable
 *        Private Address based on the local          IRK from resolving list.
 *        If resolving list contains no matching entry,          use public
 *        address.  - 0x03: Controller generates Resolvable Private Address
 *        based on the local          IRK from resolving list. If resolving list
 *        contains no matching entry,          use random address from
 *        LE_Set_Random_Address.
 *        Values:
 *        - 0x00: Public Device Address
 *        - 0x01: Random Device Address
 *        - 0x02: Resolvable Private Address or Public Address
 *        - 0x03: Resolvable Private Address or Random Address
 * @param Scanning_Filter_Policy 0x00 Accept all advertisement packets. Directed
 *        advertising packets which are not addressed for this device shall be
 *        ignored. 0x01 Ignore advertisement packets from devices not in the
 *        White List Only. Directed advertising packets which are not addressed
 *        for this device shall be ignored 0x02 Accept all undirected
 *        advertisement packets. Directed advertisement packets where initiator
 *        address is a RPA and  Directed advertisement packets addressed to this
 *        device shall be accepted. 0x03 Accept all undirected advertisement
 *        packets from devices that are in the White List.Directed advertisement
 *        packets where initiator address is RPA and Directed advertisement
 *        packets addressed to this device shall be accepted.
 *        Values:
 *        - 0x00: Accept all
 *        - 0x01: Ignore devices not in the White List
 *        - 0x02: Accept all (use resolving list)
 *        - 0x03: Ignore devices not in the White List (use resolving list)
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_scan_parameters(uint8_t LE_Scan_Type,
                                      uint16_t LE_Scan_Interval,
                                      uint16_t LE_Scan_Window,
                                      uint8_t Own_Address_Type,
                                      uint8_t Scanning_Filter_Policy);
/**
 * @brief The LE_Set_Scan_Enable command is used to start scanning. Scanning is
 *        used to discover advertising devices nearby. The Filter_Duplicates
 *        parameter controls whether the Link Layer shall filter duplicate
 *        advertising reports to the Host, or if the Link Layer should generate
 *        advertising reports for each packet received. (See Bluetooth
 *        Specification v.4.1, Vol. 2, Part E, 7.8.11)
 * @param LE_Scan_Enable Enable/disable scan. Default is 0 (disabled).
 *        Values:
 *        - 0x00: Scanning disabled
 *        - 0x01: Scanning enabled
 * @param Filter_Duplicates Enable/disable duplicate filtering.
 *        Values:
 *        - 0x00: Duplicate filtering disabled
 *        - 0x01: Duplicate filtering enabled
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_scan_enable(uint8_t LE_Scan_Enable,
                                  uint8_t Filter_Duplicates);
/**
 * @brief The LE_Create_Connection command is used to create a Link Layer
 *        connection to a connectable advertiser. The LE_Scan_Interval and
 *        LE_Scan_Window parameters are recommendations from the Host on how
 *        long (LE_Scan_Window) and how frequently (LE_Scan_Interval) the
 *        Controller should scan. The LE_Scan_Window parameter shall be set to a
 *        value smaller or equal to the value set for the LE_Scan_Interval
 *        parameter. If both are set to the same value, scanning should run
 *        continuously. The Initiator_Filter_Policy is used to determine whether
 *        the White List is used. If the White List is not used, the
 *        Peer_Address_Type and the Peer_Address parameters specify the address
 *        type and address of the advertising device to connect to. The Link
 *        Layer shall set the address in the CONNECT_REQ packets to either the
 *        Public Device Address or the Random Device Addressed based on the
 *        Own_Address_Type parameter. The Conn_Interval_Min and
 *        Conn_Interval_Max parameters define the minimum and maximum allowed
 *        connection interval. The Conn_Interval_Min parameter shall not be
 *        greater than the Conn_Interval_Max parameter. The Conn_Latency
 *        parameter defines the maximum allowed connection latency (see [Vol 6]
 *        Part B, Section 4.5.1). The Supervision_Timeout parameter defines the
 *        link supervision timeout for the connection. The Supervision_Timeout
 *        in milliseconds shall be larger than (1 + Conn_Latency) *
 *        Conn_Interval_Max * 2, where Conn_Interval_Max is given in
 *        milliseconds. (See [Vol 6] Part B, Section 4.5.2). The
 *        Minimum_CE_Length and Maximum_CE_Length parameters are informative
 *        parameters providing the Controller with the expected minimum and
 *        maximum length of the connection events. The Minimum_CE_Length
 *        parameter shall be less than or equal to the Maximum_CE_Length
 *        parameter. The Host shall not issue this command when another
 *        LE_Create_Connection is pending in the Controller; if this does occur
 *        the Controller shall return the Command Disallowed error code shall be
 *        used. (See Bluetooth Specification v.4.1, Vol. 2, Part E, 7.8.12)
 * @param LE_Scan_Interval This is defined as the time interval from when the
 *        Controller started its last LE scan until it begins the subsequent LE
 *        scan. Time = N * 0.625 msec.
 *        Values:
 *        - 0x0004 (2.500 ms)  ... 0x4000 (10240.000 ms) 
 * @param LE_Scan_Window The duration of the LE scan. LE_Scan_Window shall be
 *        less than or equal to LE_Scan_Interval. Time = N * 0.625 msec.
 *        Values:
 *        - 0x0004 (2.500 ms)  ... 0x4000 (10240.000 ms) 
 * @param Initiator_Filter_Policy 0x00 White list is not used to determine which
 *        advertiser to connect to. Peer_Address_Type and Peer_Address shall be
 *        used. 0x01 White list is used to determine which advertiser to connect
 *        to. Peer_Address_Type and Peer_Address shall be ignored.
 *        Values:
 *        - 0x00: White list not used
 *        - 0x01: White list used
 * @param Peer_Address_Type 0x00 Public Device Address 0x01 Random Device
 *        Address 0x02 Public Identity Address (Corresponds to Resolved Private
 *        Address) 0x03 Random (Static) Identity Address (Corresponds to
 *        Resolved Private Address)
 *        Values:
 *        - 0x00: Public Device Address
 *        - 0x01: Random Device Address
 *        - 0x02: Public Identity Address
 *        - 0x03: Random (Static) Identity Address
 * @param Peer_Address Public Device Address, Random Device Address, Public
 *        Identity Address or Random (static) Identity Address of the
 *        advertising device.
 * @param Own_Address_Type Own address type.  - 0x00: Public Device Address  -
 *        0x01 Random Device Address  - 0x02: Controller generates Resolvable
 *        Private Address based on the local          IRK from resolving list.
 *        If resolving list contains no matching entry,          use public
 *        address.  - 0x03: Controller generates Resolvable Private Address
 *        based on the local          IRK from resolving list. If resolving list
 *        contains no matching entry,          use random address from
 *        LE_Set_Random_Address.
 *        Values:
 *        - 0x00: Public Device Address
 *        - 0x01: Random Device Address
 *        - 0x02: Resolvable Private Address or Public Address
 *        - 0x03: Resolvable Private Address or Random Address
 * @param Conn_Interval_Min Minimum value for the connection event interval.
 *        This shall be less than or equal to Conn_Interval_Max. Time = N * 1.25
 *        msec.
 *        Values:
 *        - 0x0006 (7.50 ms)  ... 0x0C80 (4000.00 ms) 
 * @param Conn_Interval_Max Maximum value for the connection event interval.
 *        This shall be greater than or equal to Conn_Interval_Min. Time = N *
 *        1.25 msec.
 *        Values:
 *        - 0x0006 (7.50 ms)  ... 0x0C80 (4000.00 ms) 
 * @param Conn_Latency Slave latency for the connection in number of connection
 *        events.
 *        Values:
 *        - 0x0000 ... 0x01F3
 * @param Supervision_Timeout Supervision timeout for the LE Link. It shall be a
 *        multiple of 10 ms and larger than (1 + connSlaveLatency) *
 *        connInterval * 2. Time = N * 10 msec.
 *        Values:
 *        - 0x000A (100 ms)  ... 0x0C80 (32000 ms) 
 * @param Minimum_CE_Length Information parameter about the minimum length of
 *        connection needed for this LE connection. Time = N * 0.625 msec.
 * @param Maximum_CE_Length Information parameter about the maximum length of
 *        connection needed for this LE connection. Time = N * 0.625 msec.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_create_connection(uint16_t LE_Scan_Interval,
                                    uint16_t LE_Scan_Window,
                                    uint8_t Initiator_Filter_Policy,
                                    uint8_t Peer_Address_Type,
                                    uint8_t Peer_Address[6],
                                    uint8_t Own_Address_Type,
                                    uint16_t Conn_Interval_Min,
                                    uint16_t Conn_Interval_Max,
                                    uint16_t Conn_Latency,
                                    uint16_t Supervision_Timeout,
                                    uint16_t Minimum_CE_Length,
                                    uint16_t Maximum_CE_Length);
/**
 * @brief The LE_Create_Connection_Cancel command is used to cancel the
 *        LE_Create_Connection command. This command shall only be issued after
 *        the LE_Create_Connection command has been issued, a Command Status
 *        event has been received for the LE Create Connection command and
 *        before the LE Connection Complete event. (See Bluetooth Specification
 *        v.4.1, Vol. 2, Part E, 7.8.13)
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_create_connection_cancel(void);
/**
 * @brief The LE_Read_White_List_Size command is used to read the total number
 *        of white list entries that can be stored in the Controller. (See
 *        Bluetooth Specification v.4.1, Vol. 2, Part E, 7.8.14)
 * @param[out] White_List_Size Total number of white list entries that can be
 *             stored in the Controller.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_read_white_list_size(uint8_t *White_List_Size);
/**
 * @brief The LE_Clear_White_List command is used to clear the white list stored
 *        in the Controller. This command can be used at any time except when: -
 *        the advertising filter policy uses the white list and advertising is
 *        enabled. - the scanning filter policy uses the white list and scanning
 *        is enabled. - the initiator filter policy uses the white list and an
 *        LE_Create_Connection command is outstanding. (See Bluetooth
 *        Specification v.4.1, Vol. 2, Part E, 7.8.15)
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_clear_white_list(void);
/**
 * @brief The LE_Add_Device_To_White_List command is used to add a single device
 *        to the white list stored in the Controller. This command can be used
 *        at any time except when: - the advertising filter policy uses the
 *        white list and advertising is enabled. - the scanning filter policy
 *        uses the white list and scanning is enabled. - the initiator filter
 *        policy uses the white list and a create connection command is
 *        outstanding. (See Bluetooth Specification v.4.1, Vol. 2, Part E,
 *        7.8.16)
 * @param Address_Type Address type.
 *        Values:
 *        - 0x00: Public Device Address
 *        - 0x01: Random Device Address
 * @param Address Public Device Address or Random Device Address of the device
 *        to be added to the list.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_add_device_to_white_list(uint8_t Address_Type,
                                           uint8_t Address[6]);
/**
 * @brief The LE_Remove_Device_From_White_List command is used to remove a
 *        single device from the white list stored in the Controller. This
 *        command can be used at any time except when: - the advertising filter
 *        policy uses the white list and advertising is enabled. - the scanning
 *        filter policy uses the white list and scanning is enabled. - the
 *        initiator filter policy uses the white list and a create connection
 *        command is outstanding. (See Bluetooth Specification v.4.1, Vol. 2,
 *        Part E, 7.8.17)
 * @param Address_Type Address type.
 *        Values:
 *        - 0x00: Public Device Address
 *        - 0x01: Random Device Address
 * @param Address Public Device Address or Random Device Address of the device
 *        to be removed from the white list.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_remove_device_from_white_list(uint8_t Address_Type,
                                                uint8_t Address[6]);
/**
 * @brief The LE_Connection_Update command is used to change the Link Layer
 *        connection parameters of a connection. This command is supported only
 *        on master side. The Conn_Interval_Min and Conn_Interval_Max parameters
 *        are used to define the minimum and maximum allowed connection
 *        interval. The Conn_Interval_Min parameter shall not be greater than
 *        the Conn_Interval_Max parameter. The Conn_Latency parameter shall
 *        define the maximum allowed connection latency. The Supervision_Timeout
 *        parameter shall define the link supervision timeout for the LE link.
 *        The Supervision_Timeout in milliseconds shall be larger than (1 +
 *        Conn_Latency) * Conn_Interval_Max * 2, where Conn_Interval_Max is
 *        given in milliseconds. The Minimum_CE_Length and Maximum_CE_Length are
 *        information parameters providing the Controller with a hint about the
 *        expected minimum and maximum length of the connection events. The
 *        Minimum_CE_Length shall be less than or equal to the
 *        Maximum_CE_Length. The actual parameter values selected by the Link
 *        Layer may be different from the parameter values provided by the Host
 *        through this command. (See Bluetooth Specification v.4.1, Vol. 2, Part
 *        E, 7.8.18)
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Conn_Interval_Min Minimum value for the connection event interval.
 *        This shall be less than or equal to Conn_Interval_Max. Time = N * 1.25
 *        msec.
 *        Values:
 *        - 0x0006 (7.50 ms)  ... 0x0C80 (4000.00 ms) 
 * @param Conn_Interval_Max Maximum value for the connection event interval.
 *        This shall be greater than or equal to Conn_Interval_Min. Time = N *
 *        1.25 msec.
 *        Values:
 *        - 0x0006 (7.50 ms)  ... 0x0C80 (4000.00 ms) 
 * @param Conn_Latency Slave latency for the connection in number of connection
 *        events.
 *        Values:
 *        - 0x0000 ... 0x01F3
 * @param Supervision_Timeout Supervision timeout for the LE Link. It shall be a
 *        multiple of 10 ms and larger than (1 + connSlaveLatency) *
 *        connInterval * 2. Time = N * 10 msec.
 *        Values:
 *        - 0x000A (100 ms)  ... 0x0C80 (32000 ms) 
 * @param Minimum_CE_Length Information parameter about the minimum length of
 *        connection needed for this LE connection. Time = N * 0.625 msec.
 * @param Maximum_CE_Length Information parameter about the maximum length of
 *        connection needed for this LE connection. Time = N * 0.625 msec.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_connection_update(uint16_t Connection_Handle,
                                    uint16_t Conn_Interval_Min,
                                    uint16_t Conn_Interval_Max,
                                    uint16_t Conn_Latency,
                                    uint16_t Supervision_Timeout,
                                    uint16_t Minimum_CE_Length,
                                    uint16_t Maximum_CE_Length);
/**
 * @brief The LE_Set_Host_Channel_Classification command allows the Host to
 *        specify a channel classification for data channels based on its "local
 *        information". This classification persists until overwritten with a
 *        subsequent LE_Set_Host_Channel_Classification command or until the
 *        Controller is reset using the Reset command (see [Vol 6] Part B,
 *        Section 4.5.8.1). If this command is used, the Host should send it
 *        within 10 seconds of knowing that the channel classification has
 *        changed. The interval between two successive commands sent shall be at
 *        least one second. This command shall only be used when the local
 *        device supports the Master role. (See Bluetooth Specification v.4.1,
 *        Vol. 2, Part E, 7.8.19)
 * @param LE_Channel_Map This parameter contains 37 1-bit fields. The nth such
 *        field (in the range 0 to 36) contains the value for the link layer
 *        channel index n. Channel n is bad = 0. Channel n is unknown = 1. The
 *        most significant bits are reserved and shall be set to 0. At least one
 *        channel shall be marked as unknown.
 *        Flags:
 *        - 0x0000000000 ... 0x1FFFFFFFFF
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_host_channel_classification(uint8_t LE_Channel_Map[5]);
/**
 * @brief The LE_Read_Channel_Map command returns the current Channel_Map for
 *        the specified Connection_Handle. The returned value indicates the
 *        state of the Channel_Map specified by the last transmitted or received
 *        Channel_Map (in a CONNECT_REQ or LL_CHANNEL_MAP_REQ message) for the
 *        specified Connection_Handle, regardless of whether the Master has
 *        received an acknowledgement. (See Bluetooth Specification v.4.1, Vol.
 *        2, Part E, 7.8.20)
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param[out] LE_Channel_Map This parameter contains 37 1-bit fields. The nth
 *             such field (in the range 0 to 36) contains the value for the link
 *             layer channel index n. Channel n is unused = 0. Channel n is used
 *             = 1. The most significant bits are reserved and shall be set to
 *             0.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_read_channel_map(uint16_t Connection_Handle,
                                   uint8_t LE_Channel_Map[5]);
/**
 * @brief This command requests a list of the used LE features from the remote
 *        device. This command shall return a list of the used LE features. For
 *        details see [Vol 6] Part B, Section 4.6. This command may be issued on
 *        both the master and slave. (See Bluetooth Specification v.4.1, Vol. 2,
 *        Part E, 7.8.21)
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_read_remote_used_features(uint16_t Connection_Handle);
/**
 * @brief The LE_Encrypt command is used to request the Controller to encrypt
 *        the Plaintext_Data in the command using the Key given in the command
 *        and returns the Encrypted_Data to the Host. The AES-128 bit block
 *        cypher is defined in NIST Publication FIPS-197
 *        (http://csrc.nist.gov/publications/fips/ fips197/fips-197.pdf). (See
 *        Bluetooth Specification v.4.1, Vol. 2, Part E, 7.8.22)
 * @param Key 128 bit key for the encryption of the data given in the command.
 * @param Plaintext_Data 128 bit data block that is requested to be encrypted.
 * @param[out] Encrypted_Data 128 bit encrypted data block.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_encrypt(uint8_t Key[16],
                          uint8_t Plaintext_Data[16],
                          uint8_t Encrypted_Data[16]);
/**
 * @brief The LE_Rand command is used to request the Controller to generate 8
 *        octets of random data to be sent to the Host. The Random_Number shall
 *        be generated according to [Vol 2] Part H, Section 2 if the LE Feature
 *        (LL Encryption) is supported. (See Bluetooth Specification v.4.1, Vol.
 *        2, Part E, 7.8.23)
 * @param[out] Random_Number Random Number
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_rand(uint8_t Random_Number[8]);
/**
 * @brief The LE_Start_Encryption command is used to authenticate the given
 *        encryption key associated with the remote device specified by the
 *        connection handle, and once authenticated will encrypt the connection.
 *        The parameters are as defined in [Vol 3] Part H, Section 2.4.4. If the
 *        connection is already encrypted then the Controller shall pause
 *        connection encryption before attempting to authenticate the given
 *        encryption key, and then re-encrypt the connection. While encryption
 *        is paused no user data shall be transmitted. On an authentication
 *        failure, the connection shall be automatically disconnected by the
 *        Link Layer. If this command succeeds, then the connection shall be
 *        encrypted. This command shall only be used when the local device's
 *        role is Master. (See Bluetooth Specification v.4.1, Vol. 2, Part E,
 *        7.8.24)
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Random_Number 64 bit random number.
 * @param Encrypted_Diversifier 16 bit encrypted diversifier.
 * @param Long_Term_Key 128 bit long term key.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_start_encryption(uint16_t Connection_Handle,
                                   uint8_t Random_Number[8],
                                   uint16_t Encrypted_Diversifier,
                                   uint8_t Long_Term_Key[16]);
/**
 * @brief The LE_Long_Term_Key_Request_Reply command is used to reply to an LE
 *        Long Term Key Request event from the Controller, and specifies the
 *        Long_Term_Key parameter that shall be used for this Connection_Handle.
 *        The Long_Term_Key is used as defined in [Vol 6] Part B, Section 5.1.3.
 *        (See Bluetooth Specification v.4.1, Vol. 2, Part E, 7.8.25)
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Long_Term_Key 128 bit long term key.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_long_term_key_request_reply(uint16_t Connection_Handle,
                                              uint8_t Long_Term_Key[16]);
/**
 * @brief The LE_Long_Term_Key_Request_Negative_Reply command is used to reply
 *        to an LE Long Term Key Request event from the Controller if the Host
 *        cannot provide a Long Term Key for this Connection_Handle. (See
 *        Bluetooth Specification v.4.1, Vol. 2, Part E, 7.8.26)
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_long_term_key_requested_negative_reply(uint16_t Connection_Handle);
/**
 * @brief The LE_Read_Supported_States command reads the states and state
 *        combinations that the link layer supports. See [Vol 6] Part B, Section
 *        1.1.1. LE_States is an 8-octet bit field. If a bit is set to 1 then
 *        this state or state combination is supported by the Controller.
 *        Multiple bits in LE_States may be set to 1 to indicate support for
 *        multiple state and state combinations. All the Advertising type with
 *        the Initiate State combinations shall be set only if the corresponding
 *        Advertising types and Master Role combination are set. All the
 *        Scanning types and the Initiate State combinations shall be set only
 *        if the corresponding Scanning types and Master Role combination are
 *        set. (See Bluetooth Specification v.4.1, Vol. 2, Part E, 7.8.27)
 * @param[out] LE_States State or state combination is supported by the
 *             Controller. See Core v4.1, Vol.2, part E, Ch. 7.8.27.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_read_supported_states(uint8_t LE_States[8]);
/**
 * @brief The LE_Set_Data_Length command allows the Host to suggest maximum
 *        transmission packet size and maximum packet transmission time
 *        (connMaxTxOctets and connMaxTxTime - see [Vol 6] Part B, Section
 *        4.5.10) to be used for a given connection. The Controller may use
 *        smaller or larger values based on local information.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param TxOctets Preferred maximum number of payload octets that the local
 *        Controller should include in a single Link Layer Data Channel PDU.
 *        Range 0x001B-0x00FB (0x0000 - 0x001A and 0x00FC - 0xFFFF) Reserved for
 *        future use). Default: 27 bytes.
 *        Values:
 *        - 0x001B ... 0x00FB
 * @param TxTime Preferred maximum number of microseconds that the local
 *        Controller should use to transmit a single Link Layer Data Channel
 *        PDU. Range 0x0148-0x0848 (0x0000 - 0x0147 and 0x0849 - 0xFFFF Reserved
 *        for future use). Default: 328 bytes.
 *        Values:
 *        - 0x0148 ... 0x0848
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_data_length(uint16_t Connection_Handle,
                                  uint16_t TxOctets,
                                  uint16_t TxTime);
/**
 * @brief The LE_Read_Suggested_Default_Data_Length command allows the Host to
 *        read the Host preferred values for the Controller maximum transmitted
 *        number of payload octets and maximum packet transmission time to be
 *        used for new connections (connInitialMaxTxOctets and
 *        connInitialMaxTxTime - see ([Vol 6] Part B, Section 4.5.10).
 * @param[out] SuggestedMaxTxOctets The Host suggested value for the Controller
 *             maximum transmitted number of payload octets to be used for new
 *             connections - connInitialMaxTxOctets. Range 0x001B-0x00FB (0x0000
 *             - 0x001A and 0x00FC - 0xFFFF Reserved for future use) Default:
 *             0x001B
 * @param[out] SuggestedMaxTxTime The Host suggested value for the Controller
 *             maximum packet transmission time to be used for new connections -
 *             connInitialMaxTx-Time. Range 0x0148-0x0848 (0x0000 - 0x0147 and
 *             0x0849 - 0xFFFF Reserved for future use) Default: 0x0148
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_read_suggested_default_data_length(uint16_t *SuggestedMaxTxOctets,
                                                     uint16_t *SuggestedMaxTxTime);
/**
 * @brief The LE_Write_Suggested_Default_Data_Length command allows the Host to
 *        specify its preferred values for the Controller maximum transmission
 *        number of payload octets and maximum packet transmission time to be
 *        used for new connections (connInitialMaxTxOctets and
 *        connInitialMaxTxTime - see [Vol 6] Part B, Section 4.5.10). The
 *        Controller may use smaller or larger values based on local
 *        information.
 * @param SuggestedMaxTxOctets The Host suggested value for the Controller
 *        maximum transmitted number of payload octets to be used for new
 *        connections - connInitialMaxTxOctets. Range 0x001B-0x00FB (0x0000 -
 *        0x001A and 0x00FC - 0xFFFF Reserved for future use)
 *        Values:
 *        - 0x001B ... 0x00FB
 * @param SuggestedMaxTxTime The Host suggested value for the Controller maximum
 *        packet transmission time to be used for new connections -
 *        connInitialMaxTx-Time. Range 0x0148-0x0848 (0x0000 - 0x0147 and 0x0849
 *        - 0xFFFF Reserved for future use)
 *        Values:
 *        - 0x0148 ... 0x0848
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_write_suggested_default_data_length(uint16_t SuggestedMaxTxOctets,
                                                      uint16_t SuggestedMaxTxTime);
/**
 * @brief The LE_Read_Local_P-256_Public_Key command is used to return the local
 *        P-256 public key from the Controller. The Controller shall generate a
 *        new P-256 public/private key pair upon receipt of this command. (See
 *        Bluetooth Specification v.4.2, Vol. 2, Part E, 7.8.36)
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_read_local_p256_public_key(void);
/**
 * @brief The LE_Generate_DHKey command is used to initiate generation of a
 *        Diffie- Hellman key in the Controller for use over the LE transport.
 *        This command takes the remote P-256 public key as input. The Diffie-
 *        Hellman key generation uses the private key generated by
 *        LE_Read_Local_P256_Public_Key command. (See Bluetooth Specification
 *        v.4.2, Vol. 2, Part E, 7.8.37)
 * @param Remote_P256_Public_Key The remote P-256 public key: X, Y format Octets
 *        31-0: X co-ordinate Octets 63-32: Y co-ordinate Little Endian Format
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_generate_dhkey(uint8_t Remote_P256_Public_Key[64]);
/**
 * @brief The LE_Add_Device_To_Resolving_List command is used to add one device
 *        to the list of address translations used to resolve Resolvable Private
 *        Addresses in the Controller. This command cannot be used when address
 *        translation is enabled in the Controller and: - Advertising is enabled
 *        - Scanning is enabled - Create connection command is outstanding This
 *        command can be used at any time when address translation is disabled
 *        in the Controller. When a Controller cannot add a device to the
 *        resolving list because the list is full, it shall respond with error
 *        code 0x07 (Memory Capacity Exceeded). (See Bluetooth Specification
 *        v.4.2, Vol. 2, Part E, 7.8.38)
 * @param Peer_Identity_Address_Type Identity address type.
 *        Values:
 *        - 0x00: Public Identity Address
 *        - 0x01: Random (static) Identity Address
 * @param Peer_Identity_Address Public or Random (static) Identity address of
 *        the peer device
 * @param Peer_IRK IRK of the peer device
 * @param Local_IRK IRK of the local device
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_add_device_to_resolving_list(uint8_t Peer_Identity_Address_Type,
                                               uint8_t Peer_Identity_Address[6],
                                               uint8_t Peer_IRK[16],
                                               uint8_t Local_IRK[16]);
/**
 * @brief The LE_Remove_Device_From_Resolving_List command is used to remove one
 *        device from the list of address translations used to resolve
 *        Resolvable Private Addresses in the controller. This command cannot be
 *        used when address translation is enabled in the Controller and: -
 *        Advertising is enabled - Scanning is enabled - Create connection
 *        command is outstanding This command can be used at any time when
 *        address translation is disabled in the Controller. When a Controller
 *        cannot remove a device from the resolving list because it is not
 *        found, it shall respond with error code 0x02 (Unknown Connection
 *        Identifier). (See Bluetooth Specification v.4.2, Vol. 2, Part E,
 *        7.8.39)
 * @param Peer_Identity_Address_Type Identity address type.
 *        Values:
 *        - 0x00: Public Identity Address
 *        - 0x01: Random (static) Identity Address
 * @param Peer_Identity_Address Public or Random (static) Identity address of
 *        the peer device
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_remove_device_from_resolving_list(uint8_t Peer_Identity_Address_Type,
                                                    uint8_t Peer_Identity_Address[6]);
/**
 * @brief The LE_Clear_Resolving_List command is used to remove all devices from
 *        the list of address translations used to resolve Resolvable Private
 *        Addresses in the Controller. This command cannot be used when address
 *        translation is enabled in the Controller and: - Advertising is enabled
 *        - Scanning is enabled - Create connection command is outstanding This
 *        command can be used at any time when address translation is disabled
 *        in the Controller. (See Bluetooth Specification v.4.2, Vol. 2, Part E,
 *        7.8.40)
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_clear_resolving_list(void);
/**
 * @brief The LE_Read_Resolving_List_Size command is used to read the total
 *        number of address translation entries in the resolving list that can
 *        be stored in the Controller. (See Bluetooth Specification v.4.2, Vol.
 *        2, Part E, 7.8.41)
 * @param[out] Resolving_List_Size Number of address translation entries in the
 *             resolving list
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_read_resolving_list_size(uint8_t *Resolving_List_Size);
/**
 * @brief The LE_Read_Peer_Resolvable_Address command is used to get the current
 *        peer Resolvable Private Address being used for the corresponding peer
 *        Public and Random (static) Identity Address. The peer's resolvable
 *        address being used may change after the command is called. This
 *        command can be used at any time. When a Controller cannot find a
 *        Resolvable Private Address associated with the Peer Identity Address,
 *        it shall respond with error code 0x02 (Unknown Connection Identifier).
 *        (See Bluetooth Specification v.4.2, Vol. 2, Part E, 7.8.42)
 * @param Peer_Identity_Address_Type Identity address type.
 *        Values:
 *        - 0x00: Public Identity Address
 *        - 0x01: Random (static) Identity Address
 * @param Peer_Identity_Address Public or Random (static) Identity address of
 *        the peer device
 * @param[out] Peer_Resolvable_Address Resolvable Private Address being used by
 *             the peer device
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_read_peer_resolvable_address(uint8_t Peer_Identity_Address_Type,
                                               uint8_t Peer_Identity_Address[6],
                                               uint8_t Peer_Resolvable_Address[6]);
/**
 * @brief The LE_Read_Local_Resolvable_Address command is used to get the
 *        current local Resolvable Private Address being used for the
 *        corresponding peer Identity Address. The local's resolvable address
 *        being used may change after the command is called. This command can be
 *        used at any time. When a Controller cannot find a Resolvable Private
 *        Address associated with the Peer Identity Address, it shall respond
 *        with error code 0x02 (Unknown Connection Identifier). (See Bluetooth
 *        Specification v.4.2, Vol. 2, Part E, 7.8.43)
 * @param Peer_Identity_Address_Type Identity address type.
 *        Values:
 *        - 0x00: Public Identity Address
 *        - 0x01: Random (static) Identity Address
 * @param Peer_Identity_Address Public or Random (static) Identity address of
 *        the peer device
 * @param[out] Local_Resolvable_Address Resolvable Private Address being used by
 *             the local device
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_read_local_resolvable_address(uint8_t Peer_Identity_Address_Type,
                                                uint8_t Peer_Identity_Address[6],
                                                uint8_t Local_Resolvable_Address[6]);
/**
 * @brief The LE_Set_Address_Resolution_Enable command is used to enable
 *        resolution of Resolvable Private Addresses in the Controller. This
 *        causes the Controller to use the resolving list whenever the
 *        Controller receives a local or peer Resolvable Private Address. This
 *        command can be used at any time except when: - Advertising is enabled
 *        - Scanning is enabled - Create connection command is outstanding (See
 *        Bluetooth Specification v.4.2, Vol. 2, Part E, 7.8.44)
 * @param Address_Resolution_Enable Enable/disable address resolution in the
 *        controller. 0x00: Address Resolution in controller disabled (default),
 *        0x01: Address Resolution in controller enabled
 *        Values:
 *        - 0x00: Address Resolution in controller disabled (default)
 *        - 0x01: Address Resolution in controller enabled
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_address_resolution_enable(uint8_t Address_Resolution_Enable);
/**
 * @brief The LE_Set_Resolvable_Private_Address_Timeout command set the length
 *        of time the controller uses a Resolvable Private Address before a new
 *        resolvable private address is generated and starts being used. This
 *        timeout applies to all addresses generated by the controller. (See
 *        Bluetooth Specification v.4.2, Vol. 2, Part E, 7.8.45)
 * @param RPA_Timeout RPA_Timeout measured in seconds. Range for N: 0x0001 -
 *        0xA1B8 (1 sec - approximately 11.5 hours) Default: N= 0x0384 (900 secs
 *        or 15 minutes)
 *        Values:
 *        - 0x0001 ... 0xA1B8
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_resolvable_private_address_timeout(uint16_t RPA_Timeout);
/**
 * @brief The LE_Read_Maximum_Data_Length command allows the Host to read the
 *        Controller  maximum supported payload octets and packet duration times
 *        for transmission and reception (supportedMaxTxOctets and
 *        supportedMaxTxTime, supportedMaxRxOctets, and supportedMaxRxTime, see
 *        [Vol 6] Part B, Section 4.5.10).
 * @param[out] supportedMaxTxOctets Maximum number of payload octets that the
 *             local Controller supports for transmission of a single Link Layer
 *             Data Channel PDU. Range 0x001B-0x00FB (0x0000 - 0x001A and 0x00FC
 *             - 0xFFFF Reserved for future use)
 * @param[out] supportedMaxTxTime Maximum time, in microseconds, that the local
 *             Controller supports for transmission of a single Link Layer Data
 *             Channel PDU. Range 0x0148-0x0848 (0x0000 - 0x0147 and 0x0849 -
 *             0xFFFF Reserved for future use)
 * @param[out] supportedMaxRxOctets Maximum number of payload octets that the
 *             local Controller supports for reception of a single Link Layer
 *             Data Channel PDU. Range 0x001B-0x00FB (0x0000 - 0x001A and 0x00FC
 *             - 0xFFFF Reserved for future use)
 * @param[out] supportedMaxRxTime Maximum time, in microseconds, that the local
 *             Controller supports for reception of a single Link Layer Data
 *             Channel PDU. Range 0x0148-0x0848 (0x0000 - 0x0147 and 0x0849 -
 *             0xFFFF Reserved for future use)
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_read_maximum_data_length(uint16_t *supportedMaxTxOctets,
                                           uint16_t *supportedMaxTxTime,
                                           uint16_t *supportedMaxRxOctets,
                                           uint16_t *supportedMaxRxTime);
/**
 * @brief The LE_Read_PHY command is used to read the current transmitter PHY
 *        and receiver PHY on the connection identified by the
 *        Connection_Handle.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param[out] TX_PHY Transmitter PHY for the connection 0x01: The transmitter
 *             PHY for the connection is LE 1M 0x02: The transmitter PHY for the
 *             connection is LE 2M 0x03: The transmitter PHY for the connection
 *             is LE Coded
 *             Values:
 *             - 0x01: LE_1M_PHY
 *             - 0x02: LE_2M_PHY
 *             - 0x03: LE_CODED_PHY
 * @param[out] RX_PHY Receiver PHY for the connection. 0x01: The receiver PHY
 *             for the connection is LE 1M 0x02: The receiver PHY for the
 *             connection is LE 2M 0x03: The receiver PHY for the connection is
 *             LE Coded All other values: Reserved for future use
 *             Values:
 *             - 0x01: The receiver PHY for the connection is LE 1M
 *             - 0x02: The receiver PHY for the connection is LE 2M
 *             - 0x03: The receiver PHY for the connection is LE Coded
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_read_phy(uint16_t Connection_Handle,
                           uint8_t *TX_PHY,
                           uint8_t *RX_PHY);
/**
 * @brief The LE_Set_Default_PHY command allows the Host to specify its
 *        preferred values for the transmitter PHY and receiver PHY to be used
 *        for all subsequent connections over the LE transport.
 * @param ALL_PHYS The ALL_PHYS parameter is a bit field that allows the Host to
 *        specify, for each direction, whether it has no preference among the
 *        PHYs that the Controller supports in a given direction or whether it
 *        has specified particular PHYs that it prefers in the TX_PHYS or
 *        RX_PHYS parameter. Bits: 0: The Host has no preference among the
 *        transmitter PHYs supported by the Controller 1: The Host has no
 *        preference among the receiver PHYs supported by the Controller
 *        Flags:
 *        - 0x01: No preference for TX
 *        - 0x02: No preference for RX
 * @param TX_PHYS The TX_PHYS parameter is a bit field that indicates the
 *        transmitter PHYs that the Host prefers the Controller to use. If the
 *        ALL_PHYS parameter specifies that the Host has no preference, the
 *        TX_PHYS parameter is ignored; otherwise at least one bit shall be set
 *        to 1. Bits: 0: The Host prefers to use the LE 1M transmitter PHY
 *        (possibly among others) 1: The Host prefers to use the LE 2M
 *        transmitter PHY (possibly among others) 2: The Host prefers to use the
 *        LE Coded transmitter PHY (possibly among others) 3-7: Reserved for
 *        future use
 *        Flags:
 *        - 0x01: LE_1M_PHY_BIT
 *        - 0x02: LE_2M_PHY_BIT
 *        - 0x04: LE_CODED_PHY_BIT
 * @param RX_PHYS The RX_PHYS parameter is a bit field that indicates the
 *        receiver PHYs that the Host prefers the Controller to use. If the
 *        ALL_PHYS parameter specifies that the Host has no preference, the
 *        RX_PHYS parameter is ignored; otherwise at least one bit shall be set
 *        to 1. Bits: 0: The Host prefers to use the LE 1M receiver PHY
 *        (possibly among others) 1: The Host prefers to use the LE 2M receiver
 *        PHY (possibly among others) 2: The Host prefers to use the LE Coded
 *        receiver PHY (possibly among others) 3-7: Reserved for future use
 *        Flags:
 *        - 0x01: LE_1M_PHY_BIT
 *        - 0x02: LE_2M_PHY_BIT
 *        - 0x04: LE_CODED_PHY_BIT
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_default_phy(uint8_t ALL_PHYS,
                                  uint8_t TX_PHYS,
                                  uint8_t RX_PHYS);
/**
 * @brief The LE_Set_PHY command is used to set the PHY preferences for the
 *        connection identified by the Connection_Handle. The Controller might
 *        not be able to make the change (e.g. because the peer does not support
 *        the requested PHY) or may decide that the current PHY is preferable.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param ALL_PHYS The ALL_PHYS parameter is a bit field that allows the Host to
 *        specify, for each direction, whether it has no preference among the
 *        PHYs that the Controller supports in a given direction or whether it
 *        has specified particular PHYs that it prefers in the TX_PHYS or
 *        RX_PHYS parameter. Bits: 0: The Host has no preference among the
 *        transmitter PHYs supported by the Controller 1: The Host has no
 *        preference among the receiver PHYs supported by the Controller
 *        Flags:
 *        - 0x01: No preference for TX
 *        - 0x02: No preference for RX
 * @param TX_PHYS The TX_PHYS parameter is a bit field that indicates the
 *        transmitter PHYs that the Host prefers the Controller to use. If the
 *        ALL_PHYS parameter specifies that the Host has no preference, the
 *        TX_PHYS parameter is ignored; otherwise at least one bit shall be set
 *        to 1. Bits: 0: The Host prefers to use the LE 1M transmitter PHY
 *        (possibly among others) 1: The Host prefers to use the LE 2M
 *        transmitter PHY (possibly among others) 2: The Host prefers to use the
 *        LE Coded transmitter PHY (possibly among others) 3-7: Reserved for
 *        future use
 *        Flags:
 *        - 0x01: LE_1M_PHY_BIT
 *        - 0x02: LE_2M_PHY_BIT
 *        - 0x04: LE_CODED_PHY_BIT
 * @param RX_PHYS The RX_PHYS parameter is a bit field that indicates the
 *        receiver PHYs that the Host prefers the Controller to use. If the
 *        ALL_PHYS parameter specifies that the Host has no preference, the
 *        RX_PHYS parameter is ignored; otherwise at least one bit shall be set
 *        to 1. Bits: 0: The Host prefers to use the LE 1M receiver PHY
 *        (possibly among others) 1: The Host prefers to use the LE 2M receiver
 *        PHY (possibly among others) 2: The Host prefers to use the LE Coded
 *        receiver PHY (possibly among others) 3-7: Reserved for future use
 *        Flags:
 *        - 0x01: LE_1M_PHY_BIT
 *        - 0x02: LE_2M_PHY_BIT
 *        - 0x04: LE_CODED_PHY_BIT
 * @param PHY_options The PHY_options parameter is a bit field that allows the
 *        Host to specify options for PHYs. The default value for a new
 *        connection shall be all zero bits. The Controller may override any
 *        preferred coding for transmitting on the LE Coded PHY. The Host may
 *        specify a preferred coding even if it prefers not to use the LE Coded
 *        transmitter PHY since the Controller may override the PHY preference.
 *        0 = the Host has no preferred coding when transmitting on the LE Coded
 *        PHY 1 = the Host prefers that S=2 coding be used when transmitting on
 *        the LE Coded PHY 2 = the Host prefers that S=8 coding be used when
 *        transmitting on the LE Coded PHY
 *        Values:
 *        - 0: No preferred LE Coded PHY
 *        - 1: S=2 preferred on LE Coded PHY
 *        - 2: S=8 preferred on LE Coded PHY
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_phy(uint16_t Connection_Handle,
                          uint8_t ALL_PHYS,
                          uint8_t TX_PHYS,
                          uint8_t RX_PHYS,
                          uint16_t PHY_options);
/**
 * @brief The LE_Set_Advertising_Set_Random_Address command is used by the Host
 *        to set the random device address specified by the Random_Address
 *        parameter. This address is used in the Controller (see [Vol 6] Part B,
 *        Section 1.3.2) for the advertiser's address contained in the
 *        advertising PDUs for the advertising set specified by the
 *        Advertising_Handle parameter. If the Host issues this command while an
 *        advertising set using connectable advertising is enabled, the
 *        Controller shall return the error code Command Disallowed (0x0C). The
 *        Host may issue this command at any other time. If this command is used
 *        to change the address, the new random address shall take effect for
 *        advertising no later than the next successful LE Extended Set
 *        Advertising Enable Command and for periodic advertising no later than
 *        the next successful LE Periodic Advertising Enable Command.
 * @param Advertising_Handle It is used to identify an advertising set
 *        Values:
 *        - 0x00 ... 0xEF
 * @param Advertising_Random_Address Random Device Address as defined by [Vol 6]
 *        Part B, Section 1.3.2
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_advertising_set_random_address(uint8_t Advertising_Handle,
                                                     uint8_t Advertising_Random_Address[6]);
/**
 * @brief The LE_Set_Extended_Advertising_Parameters command is used by the Host
 *        to set the advertising parameters. The Advertising_Handle parameter
 *        identifies the advertising set whose parameters are being configured.
 *        The Advertising_Event_Properties parameter describes the type of
 *        advertising event that is being configured and its basic properties.
 *        The type shall be one supported by the Controller.
 * @param Advertising_Handle The Advertising_Handle parameter identifies the
 *        advertising set whose parameters are being configured.
 *        Values:
 *        - 0x00 ... 0xEF
 * @param Advertising_Event_Properties The Advertising_Event_Properties
 *        parameter describes the type of advertising event that is being
 *        configured and its basic properties. The type shall be one supported
 *        by the Controller. Bits: 0 Connectable advertising 1 Scannable
 *        advertising 2 Directed advertising 3 High Duty Cycle Directed
 *        Connectable advertising (<= 3.75 ms Advertising Interval) 4 Use legacy
 *        advertising PDUs 5 Omit advertiser's address from all PDUs ("anonymous
 *        advertising") 6 Include TxPower in the extended header of the
 *        advertising PDU
 *        Flags:
 *        - 0x0001: Connectable
 *        - 0x0002: Scannable
 *        - 0x0004: Directed
 *        - 0x0008: HDC Directed Connectable
 *        - 0x0010: Legacy
 *        - 0x0020: Anonymous
 *        - 0x0040: TxPower in ext header
 * @param Primary_Advertising_Interval_Min Minimum advertising interval for
 *        undirected and low duty cycle directed advertising. Time = N * 0.625
 *        ms; Time Range: 20 ms to 10,485.759375 s.
 *        Values:
 *        - 0x000020 (20.000 ms)  ... 0xFFFFFF (10485759.375 ms) 
 * @param Primary_Advertising_Interval_Max Maximum advertising interval for
 *        undirected and low duty cycle directed advertising. Time = N * 0.625
 *        ms; Time Range: 20 ms to 10,485.759375 s.
 *        Values:
 *        - 0x000020 (20.000 ms)  ... 0xFFFFFF (10485759.375 ms) 
 * @param Primary_Advertising_Channel_Map The Primary_Advertising_Channel_Map is
 *        a bit field that indicates the advertising channels that shall be used
 *        when transmitting advertising packets. At least one channel bit shall
 *        be set in the Primary_Advertising_Channel_Map parameter.
 *        Flags:
 *        - 0x01: CH_37
 *        - 0x02: CH_38
 *        - 0x04: CH_39
 * @param Own_Address_Type The Own_Address_Type parameter specifies the type of
 *        address being used in the advertising packets. For random addresses,
 *        the address is specified by the LE_Set_Advertising_Set_Random_Address
 *        command.  0x00 Public Device Address 0x01 Random Device Address 0x02
 *        Controller generates the Resolvable Private Address based on the local
 *        IRK from the resolving list. If the resolving list contains no
 *        matching entry, use the public address. 0x03 Controller generates the
 *        Resolvable Private Address based on the local IRK from the resolving
 *        list. If the resolving list contains no matching entry, use the random
 *        address from LE_Set_Advertising_Set_Random_Address. All other values
 *        Reserved for future use
 *        Values:
 *        - 0x00: Public Device Address
 *        - 0x01: Random Device Address
 *        - 0x02: Resolvable Private Address / Public Address
 *        - 0x03: Resolvable Private Address / Random Address
 * @param Peer_Address_Type Peer Address type
 *        Values:
 *        - 0x00: Public Device Address or Public Identity Address
 *        - 0x01: Random Device Address or Random (static) Identity Address
 * @param Peer_Address Public Device Address, Random Device Address, Public
 *        Identity Address, or Random (static) Identity Address of the device to
 *        be connected.
 * @param Advertising_Filter_Policy Advertising Filter Policy. This parameter is
 *        ignored when directed advertising is enabled.  0x00 Process scan and
 *        connection requests from all devices (i.e., the White List is not in
 *        use) 0x01 Process connection requests from all devices and scan
 *        requests only from devices that are in the White List 0x02 Process
 *        scan requests from all devices and connection requests only from
 *        devices that are in the White List. 0x03 Process scan and connection
 *        requests only from devices in the White List. All other values
 *        Reserved for future use
 *        Values:
 *        - 0x00: ADV_NO_WHITE_LIST_USE
 *        - 0x01: ADV_WHITE_LIST_FOR_ONLY_SCAN
 *        - 0x02: ADV_WHITE_LIST_FOR_ONLY_CONN
 *        - 0x03: ADV_WHITE_LIST_FOR_ALL
 * @param Advertising_Tx_Power Units: dBm  The Advertising_Tx_Power parameter
 *        indicates the maximum power level at which the advertising packets are
 *        to be transmitted on the advertising channels. The Controller shall
 *        choose a power level lower than or equal to the one specified by the
 *        Host.
 *        Values:
 *        - 127: No preference
 *        - -127 ... 126
 * @param Primary_Advertising_PHY The Primary_Advertising_PHY parameter
 *        indicates the PHY on which the advertising packets are transmitted on
 *        the primary advertising channel. If legacy advertising PDUs are being
 *        used, the Primary_Advertising_PHY shall indicate the LE 1M PHY.
 *        Values:
 *        - 0x01: LE_1M_PHY
 *        - 0x03: LE_CODED_PHY
 * @param Secondary_Advertising_Max_Skip The Secondary_Advertising_Max_Skip
 *        parameter is the maximum number of advertising events that can be
 *        skipped before the AUX_ADV_IND can be sent. 0x00 AUX_ADV_IND shall be
 *        sent prior to the next advertising event 0x01-0xFF Maximum advertising
 *        events the Controller can skip before sending the AUX_ADV_IND packets
 *        on the secondary advertising channel
 *        Values:
 *        - 0x00 ... 0xFF
 * @param Secondary_Advertising_PHY The Secondary_Advertising_PHY parameter
 *        indicates the PHY on which the advertising packets are transmitted on
 *        the secondary advertising channel.
 *        Values:
 *        - 0x01: LE_1M_PHY
 *        - 0x02: LE_2M_PHY
 *        - 0x03: LE_CODED_PHY
 * @param Advertising_SID The Advertising_SID parameter specifies the value to
 *        be transmitted in the Advertising SID subfield of the ADI field of the
 *        Extended Header of those advertising channel PDUs that have an ADI
 *        field. If the advertising set only uses PDUs that do not contain an
 *        ADI field, Advertising_SID is ignored.
 *        Values:
 *        - 0x00 ... 0x0F
 * @param Scan_Request_Notification_Enable The Scan_Request_Notification_Enable
 *        parameter indicates whether the Controller shall send notifications
 *        upon the receipt of a scan request PDU that is in response to an
 *        advertisement from the specified advertising set that contains its
 *        device address and is from a scanner that is allowed by the
 *        advertising filter policy.
 *        Values:
 *        - 0x00: Scan request notifications disabled
 *        - 0x01: Scan request notifications enabled
 * @param[out] Selected_Tx_Power Units: dBm. The Selected_Tx_Power return
 *             parameter indicates the transmit power selected by the
 *             Controller. The Controller shall not change the transmit power
 *             for this advertising set without being directed to by the Host.
 *             Values:
 *             - -127 ... 126
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_extended_advertising_parameters(uint8_t Advertising_Handle,
                                                      uint16_t Advertising_Event_Properties,
                                                      uint8_t Primary_Advertising_Interval_Min[3],
                                                      uint8_t Primary_Advertising_Interval_Max[3],
                                                      uint8_t Primary_Advertising_Channel_Map,
                                                      uint8_t Own_Address_Type,
                                                      uint8_t Peer_Address_Type,
                                                      uint8_t Peer_Address[6],
                                                      uint8_t Advertising_Filter_Policy,
                                                      int8_t Advertising_Tx_Power,
                                                      uint8_t Primary_Advertising_PHY,
                                                      uint8_t Secondary_Advertising_Max_Skip,
                                                      uint8_t Secondary_Advertising_PHY,
                                                      uint8_t Advertising_SID,
                                                      uint8_t Scan_Request_Notification_Enable,
                                                      int8_t *Selected_Tx_Power);
/**
 * @brief The LE_Set_Extended_Advertising_Enable command is used to request the
 *        Controller to enable or disable one or more advertising sets using the
 *        advertising sets identified by the Advertising_Handle[i] parameter.
 *        The Controller manages the timing of advertisements in accordance with
 *        the advertising parameters given in the
 *        LE_Set_Extended_Advertising_Parameters command.
 * @param Enable It allows to enable or disable one or more advertising sets
 *        using the advertising sets identified by the Advertising_Handle[i]
 *        parameter.
 *        Values:
 *        - 0x00: Disable
 *        - 0x01: Enable
 * @param Number_of_Sets The Number_of_Sets parameter is the number of
 *        advertising sets contained in the parameter arrays.
 *        Values:
 *        - 0x00: Disable all advertising sets
 *        - 0x01 ... 0x3F: Number of advertising sets to enable or disable
 * @param Advertising_Set_Parameters See @ref Advertising_Set_Parameters_t
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_extended_advertising_enable(uint8_t Enable,
                                                  uint8_t Number_of_Sets,
                                                  Advertising_Set_Parameters_t Advertising_Set_Parameters[]);
/**
 * @brief The LE_Read_Number_of_Supported_Advertising_Sets command is used to
 *        read the maximum number of advertising sets supported by the
 *        advertising Controller at the same time. Note: The number of
 *        advertising sets that can be supported is not fixed and the Controller
 *        can change it at any time because the memory used to store advertising
 *        sets can also be used for other purposes.
 * @param[out] Num_Supported_Advertising_Sets Maximum number of advertising sets
 *             supported by the advertising Controller at the same time.
 *             Values:
 *             - 0x01 ... 0xF0: Number of advertising sets supported at the same time
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_read_number_of_supported_advertising_sets(uint8_t *Num_Supported_Advertising_Sets);
/**
 * @brief The LE_Remove_Advertising_Set command is used to remove an advertising
 *        set from the Controller. If the advertising set corresponding to the
 *        Advertising_Handle parameter does not exist, then the Controller shall
 *        return the error code Unknown Advertising Identifier (0x42). If
 *        advertising on the advertising set is enabled, then the Controller
 *        shall return the error code Command Disallowed (0x0C).
 * @param Advertising_Handle It is used to identify an advertising set
 *        Values:
 *        - 0x00 ... 0xEF: Used to identify an advertising set
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_remove_advertising_set(uint8_t Advertising_Handle);
/**
 * @brief The LE_Clear_Advertising_Sets command is used to remove all existing
 *        advertising sets from the Controller. If advertising is enabled on any
 *        advertising set, then the Controller shall return the error code
 *        Command Disallowed (0x0C). Note: All advertising sets are cleared on
 *        HCI reset.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_clear_advertising_sets(void);
/**
 * @brief The LE_Set_Periodic_Advertising_Parameters command is used by the Host
 *        to set the parameters for periodic advertising. The Advertising_Handle
 *        parameter identifies the advertising set whose periodic advertising
 *        parameters are being configured. If the corresponding advertising set
 *        does not already exist, then the Controller shall return the error
 *        code Unknown Advertising Identifier (0x42). The
 *        Periodic_Advertising_Interval_Min parameter shall be less than or
 *        equal to the Periodic_Advertising_Interval_Max parameter. The
 *        Periodic_Advertising_Interval_Min and
 *        Periodic_Advertising_Interval_Max parameters should not be the same
 *        value to enable the Controller to determine the best advertising
 *        interval given other activities. The Periodic_Advertising_Properties
 *        parameter indicates which fields should be included in the advertising
 *        packet. If the advertising set identified by the Advertising_Handle
 *        specified anonymous advertising, the Controller shall return the error
 *        code Invalid HCI Parameters (0x12). If the Host issues this command
 *        when periodic advertising is enabled for the specified advertising
 *        set, the Controller shall return the error code Command Disallowed
 *        (0x0C). If the Advertising_Handle does not identify an advertising set
 *        that is already configured for periodic advertising and the Controller
 *        is unable to support more periodic advertising at present, the
 *        Controller shall return the error code Memory Capacity Exceeded (0x07)
 * @param Advertising_Handle It is used to identify an advertising set
 *        Values:
 *        - 0x00 ... 0xEF: Used to identify a periodic advertisement
 * @param Periodic_Advertising_Interval_Min Minimum advertising interval for
 *        periodic advertising. Time = N * 1.25 ms; Time Range: 7.5ms to
 *        81.91875 s.
 *        Values:
 *        - 0x0006 (7.50 ms)  ... 0xFFFF (NaN) : Minimum advertising interval for periodic advertising.
 * @param Periodic_Advertising_Interval_Max Maximum advertising interval for
 *        periodic advertising. Time = N * 1.25 ms; Time Range: 7.5ms to
 *        81.91875 s.
 *        Values:
 *        - 0x0006 (7.50 ms)  ... 0xFFFF (NaN) : Maximum advertising interval for periodic advertising.
 * @param Periodic_Advertising_Properties The Periodic_Advertising_Properties
 *        parameter indicates which fields should be included in the advertising
 *        packet.
 *        Flags:
 *        - 0x0040: Include TxPower in the advertising PDU
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_periodic_advertising_parameters(uint8_t Advertising_Handle,
                                                      uint16_t Periodic_Advertising_Interval_Min,
                                                      uint16_t Periodic_Advertising_Interval_Max,
                                                      uint16_t Periodic_Advertising_Properties);
/**
 * @brief The LE_Set_Periodic_Advertising_Enable command is used to request the
 *        Controller to enable or disable the periodic advertising for the
 *        advertising set specified by the Advertising_Handle parameter
 *        (ordinary advertising is not affected). If the advertising set is not
 *        currently enabled (see the LE_Set_Extended_Advertising_Enable
 *        command), the periodic advertising is not started until the
 *        advertising set is enabled. Once the advertising set has been enabled,
 *        the Controller shall continue periodic advertising until the Host
 *        issues an LE_Set_Periodic_Advertising_Enable command with Enable set
 *        to 0x00 (periodic advertising is disabled). Disabling the advertising
 *        set has no effect on the periodic advertising once the advertising set
 *        has been enabled. The Controller manages the timing of advertisements
 *        in accordance with the advertising parameters given in the
 *        LE_Set_Periodic_Advertising_Parameters command. If the advertising set
 *        corresponding to the Advertising_Handle parameter does not exist, the
 *        Controller shall return the error code Unknown Advertising Identifier
 *        (0x42). If the periodic advertising data in the advertising set is not
 *        complete, the Controller shall return the error code Command
 *        Disallowed (0x0C). Note: Enabling periodic advertising when it is
 *        already enabled can cause the random address to change. Disabling
 *        periodic advertising when it is already disabled has no effect.
 * @param Enable It is used to request the Controller to enable or disable the
 *        periodic advertising for the advertising set specified by the
 *        Advertising_Handle parameter (ordinary advertising is not affected).
 *        Values:
 *        - 0x00: Periodic advertising is disabled (default)
 *        - 0x01: Periodic advertising is enabled
 * @param Advertising_Handle
 *        Values:
 *        - 0x00 ... 0xEF: Used to identify an advertising set
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_periodic_advertising_enable(uint8_t Enable,
                                                  uint8_t Advertising_Handle);
/**
 * @brief The LE_Set_Extended_Scan_Parameters command is used to set the
 *        extended scan parameters to be used on the advertising channels. The
 *        Scanning_PHYs parameter indicates the PHY(s) on which the advertising
 *        packets should be received on the primary advertising channel. The
 *        Host may enable one or more scanning PHYs. The Scan_Type[i],
 *        Scan_Interval[i], and Scan_Window[i] parameters array elements are
 *        ordered in the same order as the set bits in the Scanning_PHY
 *        parameter, starting from bit 0. The number of array elements is
 *        determined by the number of bits set in the Scanning_PHY parameter.
 *        The Scan_Type[i] parameter specifies the type of scan to perform. The
 *        Scan_Interval[i] and Scan_Window[i] parameters are recommendations
 *        from the Host on how long (Scan_Window[i]) and how frequently
 *        (Scan_Interval[i]) the Controller should scan (see [Vol 6] Part B,
 *        Section 4.5.3); however the frequency and length of the scan is
 *        implementation specific. If the requested scan cannot be supported by
 *        the implementation, the Controller shall return the error code Invalid
 *        HCI Command Parameters (0x12). The Own_Address_Type parameter
 *        indicates the type of address being used in the scan request packets.
 *        If the Host issues this command when scanning is enabled in the
 *        Controller, the Controller shall return the error code Command
 *        Disallowed (0x0C).
 * @param Own_Address_Type The Own_Address_Type parameter indicates the type of
 *        address being used in the scan request packets.
 *        Values:
 *        - 0x00: Public Device Address
 *        - 0x01: Random Device Address
 *        - 0x02: Controller generates the Resolvable Private Address based on the local
IRK from the resolving list. If the resolving list contains no matching
entry, then use the public address.
 *        - 0x03: Controller generates the Resolvable Private Address based on the local
IRK from the resolving list. If the resolving list contains no matching
entry, then use the random address from LE_Set_Random_Address.
 * @param Scanning_Filter_Policy 0x00 Accept all advertisement packets. Directed
 *        advertising packets which are not addressed for this device shall be
 *        ignored. 0x01 Ignore advertisement packets from devices not in the
 *        White List Only. Directed advertising packets which are not addressed
 *        for this device shall be ignored 0x02 Accept all undirected
 *        advertisement packets. Directed advertisement packets where initiator
 *        address is a RPA and  Directed advertisement packets addressed to this
 *        device shall be accepted. 0x03 Accept all undirected advertisement
 *        packets from devices that are in the White List.Directed advertisement
 *        packets where initiator address is RPA and Directed advertisement
 *        packets addressed to this device shall be accepted.
 *        Values:
 *        - 0x00: Accept all
 *        - 0x01: Ignore devices not in the White List
 *        - 0x02: Accept all (use resolving list)
 *        - 0x03: Ignore devices not in the White List (use resolving list)
 * @param Scanning_PHYs The Scanning_PHYs parameter indicates the PHY(s) on
 *        which the advertising packets should be received on the primary
 *        advertising channel. The Host may enable one or more scanning PHYs.
 *        Flags:
 *        - 0x01: LE_1M_PHY_BIT
 *        - 0x04: LE_CODED_PHY_BIT
 * @param Extended_Scan_Parameters See @ref Extended_Scan_Parameters_t
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_extended_scan_parameters(uint8_t Own_Address_Type,
                                               uint8_t Scanning_Filter_Policy,
                                               uint8_t Scanning_PHYs,
                                               Extended_Scan_Parameters_t Extended_Scan_Parameters[]);
/**
 * @brief The LE_Set_Extended_Scan_Enable command is used to enable or disable
 *        scanning. The Enable parameter determines whether scanning is enabled
 *        or disabled. If it is disabled, the remaining parameters are ignored.
 *        The Filter_Duplicates parameter controls whether the Link Layer should
 *        filter out duplicate advertising reports (filtering duplicates
 *        enabled) to the Host or if the Link Layer should generate advertising
 *        reports for each packet received (filtering duplicates disabled). See
 *        [Vol 6] Part B, Section 4.4.3.5. If the Filter_Duplicates parameter is
 *        set to 0x00, all advertisements received from advertisers shall be
 *        sent to the Host in advertising report events. If the
 *        Filter_Duplicates parameter is set to 0x01, duplicate advertisements
 *        should not be sent to the Host in advertising report events until
 *        scanning is disabled. If the Filter_Duplicates parameter is set to
 *        0x02, duplicate advertisements in a single scan period should not be
 *        sent to the Host in advertising report events; this setting shall only
 *        be used if Period is non-zero. If Filter_Duplicates is set to 0x2 and
 *        Period to zero, the Controller shall return the Invalid error code HCI
 *        Command Parameters (0x12). If the Duration parameter is zero or both
 *        the Duration parameter and Period parameter are non-zero, the
 *        Controller shall continue scanning until scanning is disabled by the
 *        Host issuing an LE_Set_Extended_Scan_Enable command with the Enable
 *        parameter set to 0x00 (Scanning is disabled). The Period parameter is
 *        ignored when the Duration parameter is zero. If the Duration parameter
 *        is non-zero and the Period parameter is zero, the Controller shall
 *        continue scanning until the duration specified in the Duration
 *        parameter has expired. If both the Duration and Period parameters are
 *        non-zero and the Duration parameter is greater than or equal to the
 *        Period parameter, the Controller shall return the error code Invalid
 *        HCI Command Parameters (0x12). When the Duration and Period parameters
 *        are non-zero, the Controller shall scan for the duration of the
 *        Duration parameter within a scan period specified by the Period
 *        parameter. After the scan period has expired, a new scan period shall
 *        begin and scanning shall begin again for the duration specified. The
 *        scan periods continue until the Host disables scanning. If the
 *        LE_Set_Extended_Scan_Enable command is sent while scanning is enabled,
 *        the timers used for duration and period are reset to the new parameter
 *        values and a new scan period is started. Any change to the
 *        Filter_Duplicates setting or the random address shall take effect.
 *        Note: Disabling scanning when it is disabled has no effect. Note: The
 *        duration of a scan period refers to the time spent scanning on both
 *        the primary and secondary advertising channels. However, expiry of the
 *        duration does not prevent the Link Layer from scanning for and
 *        receiving auxiliary packets of received advertisements. If the
 *        scanning parameters' Own_Address_Type parameter is set to 0x01 or 0x03
 *        and the random address for the device has not been initialized, the
 *        Controller shall return the error code Invalid HCI Command Parameters
 *        (0x12).
 * @param Enable The Enable parameter determines whether scanning is enabled or
 *        disabled. If it is disabled, the remaining parameters are ignored.
 *        Values:
 *        - 0x00: Scanning disabled
 *        - 0x01: Scanning enabled
 * @param Filter_Duplicates The Filter_Duplicates parameter controls whether the
 *        Link Layer should filter out duplicate advertising reports (filtering
 *        duplicates enabled) to the Host or if the Link Layer should generate
 *        advertising reports for each packet received (filtering duplicates
 *        disabled). See [Vol 6] Part B, Section 4.4.3.5.
 *        Values:
 *        - 0x00: Duplicate filtering disabled
 *        - 0x01: Duplicate filtering enabled
 *        - 0x02: Duplicate filtering enabled, reset for each scan period
 * @param Duration Scan duration. Time = N * 10 ms; Time Range: 10 ms to 655.35
 *        s.
 *        Values:
 *        - 0x0000 (0.000 ms) : Scan continuously until explicitly disable
 *        - 0x0001 (0.625 ms)  ... 0xFFFF (40959.375 ms) : Scan duration
 * @param Period Time interval from when the Controller started its last
 *        Scan_Duration until it begins the subsequent Scan_Duration. Time = N *
 *        1.28 sec; Time Range: 1.28 s to 83,884.8 s.
 *        Values:
 *        - 0x0000: Periodic scanning disabled
 *        - 0x0001 ... 0xFFFF: Time interval from when the Controller started its last Scan_Duration
until it begins the subsequent Scan_Duration
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_extended_scan_enable(uint8_t Enable,
                                           uint8_t Filter_Duplicates,
                                           uint16_t Duration,
                                           uint16_t Period);
/**
 * @brief The LE_Extended_Create_Connection command is used to create a Link
 *        Layer connection to a connectable advertiser.
 *        LE_Extended_Create_Connection command can be used in place of
 *        LE_Create_Connection command.
 * @param Initiating_Filter_Policy The Initiator_Filter_Policy parameter is used
 *        to determine whether the White List is used. If the White List is not
 *        used, the Peer_Address_Type and the Peer_Address parameters specify
 *        the address type and address of the advertising device to connect to.
 *        0x00 - White List is not used to determine which advertiser to connect
 *        to. Peer_Address_Type and Peer_Address shall be used. 0x01 - White
 *        List is used to determine which advertiser to connect to.
 *        Peer_Address_Type and Peer_Address shall be ignored.
 *        Values:
 *        - 0x00: WHITELIST_IS_NOT_USED
 *        - 0x01: WHITELIST_IS_USED
 * @param Own_Address_Type The Own_Address_Type parameter indicates the type of
 *        address being used in the connection request packets.
 *        Values:
 *        - 0x00: Public Device Address
 *        - 0x01: Random Device Address
 *        - 0x02: Controller generates the Resolvable Private Address based on the local
IRK from the resolving list. If the resolving list contains no matching
entry, then use the public address.
 *        - 0x03: Controller generates the Resolvable Private Address based on the local
IRK from the resolving list. If the resolving list contains no matching
entry, then use the random address from the most recent successful
LE_Set_Random_Address Command.
 * @param Peer_Address_Type The Peer_Address_Type parameter indicates the type
 *        of address used in the connectable advertisement sent by the peer.
 *        0x00: Public Device Address or Public Identity Address 0x01: Random
 *        Device Address or Random (static) Identity Address
 *        Values:
 *        - 0x00: Public Address
 *        - 0x01: Random Address
 * @param Peer_Address Public Device Address, Random Device Address, Public
 *        Identity Address, or Random (static) Identity Address of the device to
 *        be connected.
 * @param Initiating_PHYs The Initiating_PHYs parameter indicates the PHY(s) on
 *        which the advertising packets should be received on the primary
 *        advertising channel and the PHYs for which connection parameters have
 *        been specified. The Host may enable one or more initiating PHYs. 0x01:
 *        Scan connectable advertisements on the LE 1M PHY. Connection
 *        parameters for the LE 1M PHY are provided. 0x02: Connection parameters
 *        for the LE 2M PHY are provided 0x04: Scan connectable advertisements
 *        on the LE Coded PHY. Connection parameters for the LE Coded PHY are
 *        provided.
 *        Flags:
 *        - 0x01: LE_1M_PHY_BIT
 *        - 0x02: LE_2M_PHY_BIT
 *        - 0x04: LE_CODED_PHY_BIT
 * @param Extended_Create_Connection_Parameters See @ref
 *        Extended_Create_Connection_Parameters_t
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_extended_create_connection(uint8_t Initiating_Filter_Policy,
                                             uint8_t Own_Address_Type,
                                             uint8_t Peer_Address_Type,
                                             uint8_t Peer_Address[6],
                                             uint8_t Initiating_PHYs,
                                             Extended_Create_Connection_Parameters_t Extended_Create_Connection_Parameters[]);
/**
 * @brief The LE_Periodic_Advertising_Create_Sync command is used to synchronize
 *        with periodic advertising from an advertiser and begin receiving
 *        periodic advertising packets. This command may be issued whether or
 *        not scanning is enabled and scanning may be enabled and disabled (see
 *        the LE Set Extended Scan Enable Command) while this command is
 *        pending. However, synchronization can only occur when scanning is
 *        enabled. While scanning is disabled, no attempt to synchronize will
 *        take place. The Filter_Policy parameter is used to determine whether
 *        the Periodic Advertiser List is used. If the Periodic Advertiser List
 *        is not used, the Advertising_SID, Advertiser Address_Type, and
 *        Advertiser Address parameters specify the periodic advertising device
 *        to listen to; otherwise they are ignored. The Advertising_SID
 *        parameter, if used, specifies the value that must match the
 *        Advertising SID subfield in the ADI field of the received
 *        advertisement for it to be used to synchronize. The Skip parameter
 *        specifies the number of consecutive periodic advertising packets that
 *        the receiver may skip after successfully receiving a periodic
 *        advertising packet. The Sync_Timeout parameter specifies the maximum
 *        permitted time between successful receives. If this time is exceeded,
 *        synchronization is lost. The Unused parameter is reserved for future
 *        use. Irrespective of the value of the Skip parameter, the Controller
 *        should stop skipping packets before the Sync_Timeout would be
 *        exceeded. If the Host issues this command when another
 *        LE_Periodic_Advertising_Create_Sync command is pending (see page
 *        1380), the Controller shall return the error code Command Disallowed
 *        (0x0C). If the Host issues this command for a periodic advertising set
 *        from an advertiser that the Controller is already synchronized to, the
 *        Controller shall return the error code Connection Already Exists
 *        (0x0B).
 * @param Options The Options parameter is used to determine whether the
 *        Periodic Advertiser List is used and whether
 *        HCI_Periodic_Advertising_Report events for this periodic advertising
 *        train are initially enabled or disabled. If the Periodic Advertiser
 *        List is not used, the Advertising_SID, Advertiser Address_Type, and
 *        Advertiser Address parameters specify the periodic advertising device
 *        to listen to; otherwise they shall be ignored.
 *        Flags:
 *        - 0x01: ): Use the Advertising_SID, Advertising_Address_Type, and Advertising_
Address parameters to determine which advertiser to listen to. 1:Use the Periodic Advertiser List to determine which advertiser to listen
to.
 *        - 0x02: 0: Reporting initially enabled. 1: Reporting initially disabled.
 * @param Advertising_SID The Advertising_SID parameter, if used, specifies the
 *        value that must match the Advertising SID subfield in the ADI field of
 *        the received advertisement for it to be used to synchronize.
 *        Values:
 *        - 0x00 ... 0x0F: Advertising SID subfield in the ADI field used to identify the Periodic
Advertising
 * @param Advertising_Address_Type Advertising address type
 *        Values:
 *        - 0x00: Public Device Address
 *        - 0x01: Random Device Address
 * @param Advertiser_Address Public Device Address, Random Device Address,
 *        Public Identity Address, or Random (static) Identity Address of the
 *        advertiser
 * @param Skip The Skip parameter specifies the number of consecutive periodic
 *        advertising packets that the receiver may skip after successfully
 *        receiving a periodic advertising packet.
 *        Values:
 *        - 0x0000 ... 0x01F3: The number of periodic advertising packets that can be skipped after a
successful receive
 * @param Sync_Timeout The Skip parameter specifies the number of consecutive
 *        periodic advertising packets that the receiver may skip after
 *        successfully receiving a periodic advertising packet. Time = N*10 ms;
 *        Time Range: 100 ms to 163.84 s.
 *        Values:
 *        - 0x000A (100 ms)  ... 0x4000 (163840 ms) : Synchronization timeout for the periodic advertising
 * @param Sync_CTE_Type The Sync_CTE_Type parameter specifies whether to only
 *        synchronize to periodic advertising with certain types of Constant
 *        Tone Extension (a value of 0 indicates that the presence or absence of
 *        a Constant Tone Extension is irrelevant). If the periodic advertising
 *        has the wrong type of Constant Tone Extension then: - If bit 0 of
 *        Options is set, the Controller shall ignore this address and SID and
 *        continue to search for other periodic advertisements. - Otherwise, the
 *        Controller shall cancel the synchronization with the error code
 *        Unsupported Remote Feature/Unsupported LMP Feature (0x1A).
 *        Flags:
 *        - 0x01: Do not sync to packets with an AoA Constant Tone Extension
 *        - 0x02: Do not sync to packets with an AoD Constant Tone Extension with 1 microsecond
slots
 *        - 0x04: Do not sync to packets with an AoD Constant Tone Extension with 2 microseconds
slots
 *        - 0x08: Do not sync to packets with a type 3 Constant Tone Extension (currently
reserved for future use)
 *        - 0x10: Do not sync to packets without a Constant Tone Extension
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_periodic_advertising_create_sync(uint8_t Options,
                                                   uint8_t Advertising_SID,
                                                   uint8_t Advertising_Address_Type,
                                                   uint8_t Advertiser_Address[6],
                                                   uint16_t Skip,
                                                   uint16_t Sync_Timeout,
                                                   uint8_t Sync_CTE_Type);
/**
 * @brief The LE_Periodic_Advertising_Create_Sync_Cancel command is used to
 *        cancel the LE_Periodic_Advertising_Create_Sync command while it is
 *        pending. If the Host issues this command while no
 *        LE_Periodic_Advertising_Create_Sync command is pending, the Controller
 *        shall return the error code Command Disallowed (0x0C).
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_periodic_advertising_create_sync_cancel(void);
/**
 * @brief The LE_Periodic_Advertising_Terminate_Sync command is used to stop
 *        reception of the periodic advertising identified by the Sync_Handle
 *        parameter. If the Host issues this command when another
 *        LE_Periodic_Advertising_Create_Sync command is pending (see below),
 *        the Controller shall return the error code Command Disallowed (0x0C).
 *        If the periodic advertising corresponding to the Sync_Handle parameter
 *        does not exist, then the Controller shall return the error code
 *        Unknown Advertising Identifier (0x42).
 * @param Sync_Handle It is used to identify the periodic advertiser
 *        Values:
 *        - 0x0000 ... 0x0EFF: Sync_Handle to be used to identify the periodic advertiser
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_periodic_advertising_terminate_sync(uint16_t Sync_Handle);
/**
 * @brief The LE_Add_Device_To_Periodic_Advertiser_List command is used to add a
 *        single device to the Periodic Advertiser list stored in the
 *        Controller. Any additions to the Periodic Advertiser list take effect
 *        immediately. If the device is already on the list, the Controller
 *        shall return the error code Invalid HCI Command Parameters (0x12). If
 *        the Host issues this command when an
 *        LE_Periodic_Advertising_Create_Sync command is pending, the Controller
 *        shall return the error code Command Disallowed (0x0C). When a
 *        Controller cannot add a device to the Periodic Advertiser list because
 *        the list is full, the Controller shall return the error code Memory
 *        Capacity Exceeded (0x07).
 * @param Advertiser_Address_Type Advertiser Address Type
 *        Values:
 *        - 0x00: Public Device Address or Public Identity Address
 *        - 0x01: Random Device Address or Random (static) Identity Address
 * @param Advertiser_Address Public Device Address, Random Device Address,
 *        Public Identity Address, or Random (static) Identity Address of the
 *        advertiser
 * @param Advertising_SID Advertising SID subfield in the ADI field used to
 *        identify the Periodic Advertising
 *        Values:
 *        - 0x00 ... 0x0F: Advertising SID subfield in the ADI field used to identify the Periodic
Advertising
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_add_device_to_periodic_advertiser_list(uint8_t Advertiser_Address_Type,
                                                         uint8_t Advertiser_Address[6],
                                                         uint8_t Advertising_SID);
/**
 * @brief The LE_Remove_Device_From_Periodic_Advertiser_List command is used to
 *        remove one device from the list of Periodic Advertisers stored in the
 *        Controller. Removals from the Periodic Advertisers List take effect
 *        immediately. If the Host issues this command when an
 *        LE_Periodic_Advertising_Create_Sync command is pending, the Controller
 *        shall return the error code Command Disallowed (0x0C). When a
 *        Controller cannot remove a device from the Periodic Advertiser list
 *        because it is not found, the Controller shall return the error code
 *        Unknown Advertising Identifier (0x42).
 * @param Advertiser_Address_Type Advertising Address type
 *        Values:
 *        - 0x00: Public Device Address or Public Identity Address
 *        - 0x01: Random Device Address or Random (static) Identity Address
 * @param Advertiser_Address Public Device Address, Random Device Address,
 *        Public Identity Address, or Random (static) Identity Address of the
 *        advertiser
 * @param Advertising_SID It is used to  identify the Periodic Advertising
 *        Values:
 *        - 0x00 ... 0x0F: Advertising SID subfield in the ADI field used to identify the Periodic
Advertising
All other values Reserved for future
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_remove_device_from_periodic_advertising_list(uint8_t Advertiser_Address_Type,
                                                               uint8_t Advertiser_Address[6],
                                                               uint8_t Advertising_SID);
/**
 * @brief The LE_Clear_Periodic_Advertiser_List command is used to remove all
 *        devices from the list of Periodic Advertisers in the Controller. If
 *        this command is used when an LE_Periodic_Advertising_Create_Sync
 *        command is pending, the Controller shall return the error code Command
 *        Disallowed (0x0C).
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_clear_periodic_advertiser_list(void);
/**
 * @brief The LE_Read_Periodic_Advertiser_List_Size command is used to read the
 *        total number of Periodic Advertiser list entries that can be stored in
 *        the Controller. Note: The number of entries that can be stored is not
 *        fixed and the Controller can change it at any time (e.g., because the
 *        memory used to store the list can also be used for other purposes).
 * @param[out] Periodic_Advertiser_List_Size Total number of Periodic Advertiser
 *             list entries that can be stored in the Controller
 *             Values:
 *             - 0x1F ... 0xFF: Total number of Periodic Advertiser list entries that can be stored in the
Controller
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_read_periodic_advertiser_list_size(uint8_t *Periodic_Advertiser_List_Size);
/**
 * @brief The HCI_LE_Read_Transmit_Power command is used to read the minimum and
 *        maximum transmit powers supported by the Controller.
 * @param[out] Min_Tx_Power Minimum supported TX power (units: dBm).
 *             Values:
 *             - -127 ... 20
 * @param[out] Max_Tx_Power Maximum supported TX power (units: dBm).
 *             Values:
 *             - -127 ... 20
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_read_transmit_power(int8_t *Min_Tx_Power,
                                      int8_t *Max_Tx_Power);
/**
 * @brief The HCI_LE_Read_RF_Path_Compensation command is used to read the RF
 *        Path Compensation Values parameter used in the Tx Power Level and RSSI
 *        calculation.
 * @param[out] RF_TX_Path_Compensation_Value
 * @param[out] RF_RX_Path_Compensation_Value
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_read_rf_path_compensation(int16_t *RF_TX_Path_Compensation_Value,
                                            int16_t *RF_RX_Path_Compensation_Value);
/**
 * @brief The HCI_LE_Write_RF_Path_Compensation command is used to indicate the
 *        RF path gain or loss between the RF transceiver and the antenna
 *        contributed by intermediate components. A positive value means a net
 *        RF path gain and a negative value means a net RF path loss. The RF Tx
 *        Path Compensation Value parameter shall be used by the Controller to
 *        calculate radiative Tx Power Level used in HCI commands, HCI events,
 *        Advertising physical channel PDUs, and Link Layer Control PDUs using
 *        the following equation: Radiative Tx Power Level = Tx Power Level at
 *        RF transceiver output + RF Tx Path Compensation Value. For example, if
 *        the Tx Power Level is +4 (dBm) at RF transceiver output and the RF
 *        Path Compensation Value is -1.5 (dB), the radiative Tx Power Level is
 *        +4+(-1.5) = 2.5 (dBm). The RF Rx Path Compensation Value parameter
 *        shall be used by the Controller to calculate the RSSI value reported
 *        to the Host.
 * @param RF_TX_Path_Compensation_Value
 * @param RF_RX_Path_Compensation_Value
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_write_rf_path_compensation(int16_t RF_TX_Path_Compensation_Value,
                                             int16_t RF_RX_Path_Compensation_Value);
/**
 * @brief The HCI_LE_Set_Privacy_Mode command is used to allow the Host to
 *        specify the privacy mode to be used for a given entry on the resolving
 *        list. The effect of this setting is specified in [Vol 6] Part B,
 *        Section 4.7. When an entry on the resolving list is removed, the mode
 *        associated with that entry shall also be removed. This command cannot
 *        be used when address translation is enabled in the Controller and:
 *        Advertising is enabled Scanning is enabled Create connection command
 *        is outstanding This command can be used at any time when address
 *        translation is disabled in the Controller. If the device is not on the
 *        resolving list, the Controller shall return the error code Unknown
 *        Connection Identifier (0x02).
 * @param Peer_Identity_Address_Type Peer Address type
 *        Values:
 *        - 0x00: Public Identity Address
 *        - 0x01: Random (static) Identity Address
 * @param Peer_Identity_Address Public Identity Address or Random (static)
 *        Identity Address of the advertiser
 * @param Privacy_Mode 0x00 Use Network Privacy Mode for this peer device
 *        (default) 0x01 Use Device Privacy Mode for this peer device
 *        Values:
 *        - 0x00: Network Privacy Mode
 *        - 0x01: Device Privacy Mode
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_privacy_mode(uint8_t Peer_Identity_Address_Type,
                                   uint8_t Peer_Identity_Address[6],
                                   uint8_t Privacy_Mode);
/**
 * @brief The HCI_LE_Set_Connectionless_CTE_Transmit_Parameters command is used
 *        to set the type, length, and antenna switching pattern for the
 *        transmission of Constant Tone Extensions in any periodic advertising
 *        on the advertising set identified by the Advertising_Handle parameter.
 *        The CTE_Count parameter specifies how many packets with a Constant
 *        Tone Extension are to be transmitted in each periodic advertising
 *        event. If the number of packets that would otherwise be transmitted is
 *        less than this, the Controller shall transmit sufficient AUX_CHAIN_IND
 *        PDUs with no AdvData to make up the number. However, if a change in
 *        circumstances since this command was issued means that the Controller
 *        can no longer schedule all of these packets, it should transmit as
 *        many as possible. If the Host issues this command when Constant Tone
 *        Extensions have been enabled in the advertising set, the Controller
 *        shall return the error code Command Disallowed (0x0C). The
 *        Switching_Pattern_Length and Antenna_IDs[i] parameters are only used
 *        when transmitting an AoD Constant Tone Extension and shall be ignored
 *        if CTE_Type specifies an AoA Constant Tone Extension. If the
 *        CTE_Length parameter is greater than the maximum length of Constant
 *        Tone Extension supported, the Controller shall return the error code
 *        Unsupported Feature or Parameter Value (0x11). If the Host requests a
 *        type of Constant Tone Extension that the Controller does not support,
 *        the Controller shall return the error code Unsupported Feature or
 *        Parameter Value (0x11). If the Controller is unable to schedule
 *        CTE_Count packets in each event, the Controller shall return the error
 *        code Unsupported Feature or Parameter Value (0x11). If the advertising
 *        set corresponding to the Advertising_Handle parameter does not exist,
 *        the Controller shall return the error code Unknown Advertising
 *        Identifier (0x42). If Switching_Pattern_Length is greater than the
 *        maximum length of switching pattern supported by the Controller (see
 *        Section 7.8.87), the Controller shall return the error code
 *        Unsupported Feature or Parameter Value (0x11). If the Controller
 *        determines that any of the Antenna_IDs[i] values do not identify an
 *        antenna in the device's antenna array, it shall return the error code
 *        Unsupported Feature or Parameter Value (0x11). Note: Some Controllers
 *        may be unable to determine which values do or do not identify an
 *        antenna.
 * @param Advertising_Handle It is used to identify an advertising set
 *        Values:
 *        - 0x00 ... 0xEF
 * @param CTE_Length
 *        Values:
 *        - 0x02 ... 0x14: Constant Tone Extension length in 8 microseconds units
 * @param CTE_Type
 *        Values:
 *        - 0x00: AoA Constant Tone Extension
 *        - 0x01: AoD Constant Tone Extension with 1 microsecond slots
 *        - 0x02: AoD Constant Tone Extension with 2 microseconds slots
 * @param CTE_Count The CTE_Count parameter specifies how many packets with a
 *        Constant Tone Extension are to be transmitted in each periodic
 *        advertising event. If the number of packets that would otherwise be
 *        transmitted is less than this, the Controller shall transmit
 *        sufficient AUX_CHAIN_IND PDUs with no AdvData to make up the number.
 *        However, if a change in circumstances since this command was issued
 *        means that the Controller can no longer schedule all of these packets,
 *        it should transmit as many as possible.
 *        Values:
 *        - 0x01 ... 0x10: The number of Constant Tone Extensions to transmit in each periodic advertising interval
 * @param Switching_Pattern_Length
 *        Values:
 *        - 0x02 ... 0x4B: The number of Antenna IDs in the pattern.
 * @param Antenna_IDs List of Antenna IDs in the pattern
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_connectionless_cte_transmit_parameters(uint8_t Advertising_Handle,
                                                             uint8_t CTE_Length,
                                                             uint8_t CTE_Type,
                                                             uint8_t CTE_Count,
                                                             uint8_t Switching_Pattern_Length,
                                                             uint8_t Antenna_IDs[]);
/**
 * @brief The HCI_LE_Set_Connectionless_CTE_Transmit_Enable command is used to
 *        request that the Controller enables or disables the use of Constant
 *        Tone Extensions in any periodic advertising on the advertising set
 *        identified by Advertising_Handle. In order to start sending periodic
 *        advertisements containing a Constant Tone Extension, the Host must
 *        also enable periodic advertising using the
 *        HCI_LE_Set_Periodic_Advertising_Enable command (see Section 7.8.63).
 *        Note: Periodic advertising can only be enabled when advertising is
 *        enabled on the same advertising set, but can continue after
 *        advertising has been disabled. If the Host issues this command before
 *        it has issued the HCI_LE_Set_Periodic_Advertising_Parameters command
 *        (see Section 7.8.61) for the advertising set, the Controller shall
 *        return the error code Command Disallowed (0x0C). Once enabled, the
 *        Controller shall continue advertising with Constant Tone Extensions
 *        until either one of the following occurs: - The Host issues an
 *        HCI_LE_Set_Connectionless_CTE_Transmit_Enable command with CTE_Enable
 *        set to 0x00 (disabling Constant Tone Extensions but allowing periodic
 *        advertising to continue). - The Host issues an
 *        HCI_LE_Set_Periodic_Advertising_Enable command (see Section 7.8.63)
 *        with Enable set to 0x00 (disabling periodic advertising). If periodic
 *        advertising is re-enabled then it shall continue to contain Constant
 *        Tone Extensions. If the Host issues this command before it has issued
 *        the HCI_LE_Set_Connectionless_CTE_Transmit_Parameters command for the
 *        advertising set, the Controller shall return the error code Command
 *        Disallowed (0x0C). If the periodic advertising is on a PHY that does
 *        not allow Constant Tone Extensions, the Controller shall return the
 *        error code Command Disallowed (0x0C).
 * @param Advertising_Handle Identifier for the advertising set in which
 *        Constant Tone Extension is being enabled or disabled
 *        Values:
 *        - 0x00 ... 0xEF
 * @param CTE_Enable It enables or disables the use of Constant Tone Extensions.
 *        Values:
 *        - 0x00: Advertising with Constant Tone Extension is disabled (default)
 *        - 0x01: Advertising with Constant Tone Extension is enabled
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_connectionless_cte_transmit_enable(uint8_t Advertising_Handle,
                                                         uint8_t CTE_Enable);
/**
 * @brief The HCI_LE_Set_Connectionless_IQ_Sampling_Enable command is used to
 *        request that the Controller enables or disables capturing IQ samples
 *        from the Constant Tone Extension of periodic advertising packets in
 *        the periodic advertising train identified by the Sync_Handle
 *        parameter. If that periodic advertising train does not exist, then the
 *        Controller shall return the error code Unknown Advertising Identifier
 *        (0x42). The Max_Sampled_CTEs parameter specifies the maximum number of
 *        Constant Tone Extensions in each periodic advertising event that the
 *        Controller should collect and report IQ samples from. The Controller
 *        should sample all Constant Tone Extensions up to this number. If the
 *        Sampling_Enable parameter is set to 0x01 (sampling is enabled), the
 *        Controller starts attempting to capture IQ samples from the periodic
 *        advertisements. Once sampling has been enabled, the Controller shall
 *        continue taking IQ samples until the Host issues an
 *        HCI_LE_Set_Connectionless_IQ_Enable command with Sampling_Enable set
 *        to 0x00 (sampling is disabled) or synchronization with the periodic
 *        advertising train is lost. If Sampling_Enable is set to 0x00,
 *        Slot_Durations, Max_Sampled_CTEs, Switching_Pattern_Length, and
 *        Antenna_IDs shall be ignored. The command is also used to set the
 *        antenna switching pattern and switching and sampling slot durations to
 *        be used while receiving the Constant Tone Extension. If Slot_Durations
 *        is set to 0x01 and the Controller does not support 1 microsecond
 *        switching and sampling, the Controller shall return the error code
 *        Unsupported Feature or Parameter Value (0x11). The Slot_Durations,
 *        Switching_Pattern_Length, and Antenna_IDs parameters are only used
 *        when receiving an AoA Constant Tone Extension and do not affect the
 *        reception of an AoD Constant Tone Extension. If
 *        Switching_Pattern_Length is greater than the maximum length of
 *        switching pattern supported by the Controller, the Controller shall
 *        return the error code Unsupported Feature or Parameter Value (0x11).
 *        If the Controller determines that any of the Antenna_IDs[i] values do
 *        not identify an antenna in the device's antenna array, it shall return
 *        the error code Unsupported Feature or Parameter Value (0x11). Note:
 *        Some Controllers may be unable to determine which values do or do not
 *        identify an antenna. If Sampling_Enable is set to 0x01 and the
 *        periodic advertising is on a PHY that does not allow Constant Tone
 *        Extensions, the Controller shall return the error code Command
 *        Disallowed (0x0C).
 * @param Sync_Handle Sync handle that identifies the synchronization
 *        information about the periodic advertising train.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Sampling_Enable If the Sampling_Enable parameter is set to 0x01
 *        (sampling is enabled), the Controller starts attempting to capture IQ
 *        samples from the periodic advertisements.
 *        Values:
 *        - 0x00: DISABLE
 *        - 0x01: ENABLE
 * @param Slot_Durations Sampling rate used by the Controller.
 *        Values:
 *        - 0x01: SLOT_1us
 *        - 0x02: SLOT_2us
 * @param Max_Sampled_CTEs It specifies the maximum number of Constant Tone
 *        Extensions in each periodic advertising event that the Controller
 *        should collect and report IQ samples from. The Controller should
 *        sample all Constant Tone Extensions up to this number.
 *        Values:
 *        - 0x00: REPORT_ALL_CTES
 *        - 0x01 ... 0x10
 * @param Switching_Pattern_Length The number of Antenna IDs in the pattern.
 *        Values:
 *        - 0x02 ... 0x4B
 * @param Antenna_IDs List of Antenna IDs in the pattern
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_connectionless_iq_sampling_enable(uint16_t Sync_Handle,
                                                        uint8_t Sampling_Enable,
                                                        uint8_t Slot_Durations,
                                                        uint8_t Max_Sampled_CTEs,
                                                        uint8_t Switching_Pattern_Length,
                                                        uint8_t Antenna_IDs[]);
/**
 * @brief The HCI_LE_Set_Connection_CTE_Receive_Parameters command is used to
 *        enable or disable sampling received Constant Tone Extension fields on
 *        the connection identified by the Connection_Handle parameter and to
 *        set the antenna switching pattern and switching and sampling slot
 *        durations to be used. If the Sampling_Enable parameter is set to 0x01,
 *        the Controller shall sample Constant Tone Extensions on the specified
 *        connection and report the samples to the Host. If it is set to 0x00,
 *        the Controller shall cease sampling on the specified connection; the
 *        remaining parameters shall be ignored. If Slot_Durations is set to
 *        0x01 and the Controller does not support 1 microsecond switching and
 *        sampling, the Controller shall return the error code Unsupported
 *        Feature or Parameter Value (0x11). The Slot_Durations,
 *        Switching_Pattern_Length, and Antenna_IDs parameters are only used
 *        when receiving an AoA Constant Tone Extension and do not affect the
 *        reception of an AoD Constant Tone Extension. If
 *        Switching_Pattern_Length is greater than the maximum length of
 *        switching pattern supported by the Controller, the Controller shall
 *        return the error code Unsupported Feature or Parameter Value (0x11).
 *        If the Controller determines that any of the Antenna_IDs[i] values do
 *        not identify an antenna in the device's antenna array, it shall return
 *        the error code Unsupported Feature or Parameter Value (0x11). Note:
 *        Some Controllers may be unable to determine which values do or do not
 *        identify an antenna.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Sampling_Enable
 *        Values:
 *        - 0x00: Connection IQ sampling is disabled (default)
 *        - 0x01: Connection IQ sampling is enabled
 * @param Slot_Durations Sampling rate used by the Controller.
 *        Values:
 *        - 0x01: SLOT_1us
 *        - 0x02: SLOT_2us
 * @param Switching_Pattern_Length
 *        Values:
 *        - 0x02 ... 0x4B: The number of Antenna IDs in the pattern.
 * @param Antenna_IDs List of Antenna IDs in the pattern
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_connection_cte_receive_parameters(uint16_t Connection_Handle,
                                                        uint8_t Sampling_Enable,
                                                        uint8_t Slot_Durations,
                                                        uint8_t Switching_Pattern_Length,
                                                        uint8_t Antenna_IDs[]);
/**
 * @brief The HCI_LE_Set_Connection_CTE_Transmit_Parameters command is used to
 *        set the antenna switching pattern and permitted Constant Tone
 *        Extension types used for transmitting Constant Tone Extensions
 *        requested by the peer device on the connection identified by the
 *        Connection_Handle parameter. If the Host issues this command when
 *        Constant Tone Extension responses have been enabled on the connection,
 *        the Controller shall return the error code Command Disallowed (0x0C).
 *        If the CTE_Types parameter has a bit set for a type of Constant Tone
 *        Extension that the Controller does not support, the Controller shall
 *        return the error code Unsupported Feature or Parameter Value (0x11).
 *        The Switching_Pattern_Length and Antenna_IDs[i] parameters are only
 *        used when transmitting an AoD Constant Tone Extension and shall be
 *        ignored when CTE_Types does not have a bit set for an AoD Constant
 *        Tone Extension; they do not affect the transmission of an AoA Constant
 *        Tone Extension. If Switching_Pattern_Length is greater than the
 *        maximum length of switching pattern supported by the Controller, the
 *        Controller shall return the error code Unsupported Feature or
 *        Parameter Value (0x11). If the Controller determines that any of the
 *        Antenna_IDs[i] values do not identify an antenna in the device's
 *        antenna array, it shall return the error code Unsupported Feature or
 *        Parameter Value (0x11). Note: Some Controllers may be unable to
 *        determine which values do or do not identify an antenna.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param CTE_Type
 *        Flags:
 *        - 0x01: Allow AoA Constant Tone Extension Response
 *        - 0x02: Allow AoD Constant Tone Extension Response with 1 microsecond slots
 *        - 0x04: Allow AoD Constant Tone Extension Response with 2 microseconds slots
 * @param Switching_Pattern_Length
 *        Values:
 *        - 0x02 ... 0x4B: The number of Antenna IDs in the pattern.
 * @param Antenna_IDs List of Antenna IDs in the pattern
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_connection_cte_transmit_parameters(uint16_t Connection_Handle,
                                                         uint8_t CTE_Type,
                                                         uint8_t Switching_Pattern_Length,
                                                         uint8_t Antenna_IDs[]);
/**
 * @brief The HCI_LE_Connection_CTE_Request_Enable command is used to request
 *        the Controller to start or stop initiating the Constant Tone Extension
 *        Request procedure (see [Vol 6] Part B, Section 5.1.12) on a connection
 *        identified by the Connection_Handle parameter. If the Host issues this
 *        command when the Controller is aware (e.g. through a previous feature
 *        exchange) that the peer device's Link Layer does not support the
 *        Connection CTE Response feature, the Controller shall return the error
 *        code Unsupported Remote Feature / Unsupported LMP Feature (0x1A). If
 *        the Host issues this command when the Controller is aware that the
 *        peer device's Link Layer does not support the requested CTE type, the
 *        Controller should return the error code Unsupported Remote Feature /
 *        Unsupported LMP Feature (0x1A). If Enable is set to 0x00, the
 *        remaining parameters shall be ignored. The CTE_Request_Interval
 *        parameter defines whether the Constant Tone Extension Request
 *        procedure is initiated only once or periodically. In the case of
 *        periodic operation, the procedure is initiated every
 *        CTE_Request_Interval. However, the Controller may delay initiating the
 *        procedure beyond the requested interval (e.g., in order to prioritize
 *        other activities). The Requested_CTE_Length parameter indicates the
 *        minimum length of the Constant Tone Extension and the
 *        Requested_CTE_Type parameter indicates the type of Constant Tone
 *        Extension that the Controller shall request from the remote device. A
 *        request is active on a connection from when the Host issues a
 *        successful command with Enable set to 0x01 until the single procedure
 *        has been performed, the period specified by CTE_Request_Interval has
 *        ended, or a command with Enable set to 0x00 has succeeded, whichever
 *        happens first. If the Host issues this command with Enable set to 0x01
 *        while a request is active for the specified connection, the Controller
 *        shall return the error code Command Disallowed (0x0C). Note: The
 *        failed command will not affect the behavior of the Link Layer in
 *        respect of the currently-active request. If the Host issues this
 *        command before issuing the
 *        HCI_LE_Set_Connection_CTE_Receive_Parameters command at least once on
 *        the connection, the Controller shall return the error code Command
 *        Disallowed (0x0C). If the Host issues this command when the receiver
 *        PHY for the connection is not a PHY that allows Constant Tone
 *        Extensions, the Controller shall return the error code Command
 *        Disallowed (0x0C). If the Host sets CTE_Request_Interval to a non-zero
 *        value less than or equal to connSlaveLatency, the Controller shall
 *        return the error code Command Disallowed (0x0C). If Enable is set to
 *        0x01 and the receiver PHY for the connection changes to a PHY that
 *        does not allow Constant Tone Extensions, then the Controller shall
 *        automatically disable Constant Tone Extension requests as if the Host
 *        had issued this command with Enable set to 0x00. Note: If the PHY
 *        changes back to a PHY that allows Constant Tone Extensions, then the
 *        Controller will not automatically re-enable Constant Tone Extension
 *        requests.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Enable If it is set to 0x00, the remaining parameters shall be
 *        ignored.
 *        Values:
 *        - 0x00: Disable Constant Tone Extension Request for the connection (default)
 *        - 0x01: Enable Constant Tone Extension Request for the connection
 * @param CTE_Request_Interval It defines whether the Constant Tone Extension
 *        Request procedure is initiated only once or periodically. In the case
 *        of periodic operation, the procedure is initiated every
 *        CTE_Request_Interval. However, the Controller may delay initiating the
 *        procedure beyond the requested interval (e.g., in order to prioritize
 *        other activities).
 *        Values:
 *        - 0x0000: Initiate the Constant Tone Extension Request procedure once, at the nearliest practical opportunity.
 *        - 0x0001 ... 0xFFFF: Requested interval for initiating the Constant Tone Extension Request procedure in number of connection events.
 * @param Requested_CTE_Length It indicates the minimum length of the Constant
 *        Tone Extension and the Requested_CTE_Type parameter indicates the type
 *        of Constant Tone Extension that the Controller shall request from the
 *        remote device.
 *        Values:
 *        - 0x02 ... 0x14: Minimum length of the Constant Tone Extension being requested in 8 nmicroseconds units
 * @param Requested_CTE_Type
 *        Flags:
 *        - 0x00: AoA Constant Tone Extension
 *        - 0x01: AoD Constant Tone Extension with 1 microsecond slots
 *        - 0x02: AoD Constant Tone Extension with 2 microseconds slots
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_connection_cte_request_enable(uint16_t Connection_Handle,
                                                uint8_t Enable,
                                                uint16_t CTE_Request_Interval,
                                                uint8_t Requested_CTE_Length,
                                                uint8_t Requested_CTE_Type);
/**
 * @brief The HCI_LE_Connection_CTE_Response_Enable command is used to request
 *        the Controller to respond to LL_CTE_REQ PDUs with LL_CTE_RSP PDUs on
 *        the specified connection. If the Host issues this command before
 *        issuing the HCI_LE_Set_Connection_CTE_Transmit_Parameters command at
 *        least once on the connection, the Controller shall return the error
 *        code Command Disallowed (0x0C). If the Host issues this command when
 *        the transmitter PHY for the connection is not a PHY that allows
 *        Constant Tone Extensions, the Controller shall return the error code
 *        Command Disallowed (0x0C). If the transmitter PHY for the connection
 *        changes to a PHY that does not allow Constant Tone Extensions, then
 *        the Controller shall automatically disable Constant Tone Extension
 *        responses.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Enable
 *        Values:
 *        - 0x00: Disable Constant Tone Extension Response for the connection (default)
 *        - 0x01: Enable Constant Tone Extension Response for the connection
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_connection_cte_response_enable(uint16_t Connection_Handle,
                                                 uint8_t Enable);
/**
 * @brief The HCI_LE_Read_Antenna_Information command allows the Host to read
 *        the switching rates, the sampling rates, the number of antennae, and
 *        the maximum length of a transmitted Constant Tone Extension supported
 *        by the Controller.
 * @param[out] Supported_Switching_Sampling_Rates
 *             Flags:
 *             - 0x00: 1 microsecond switching supported for AoD transmission
 *             - 0x02: 1 microsecond switching supported for AoD reception
 *             - 0x04: 1 microsecond switching and sampling supported for AoA reception
 * @param[out] Num_Antennae
 *             Values:
 *             - 0x01 ... 0x4B: The number of antennae supported by the Controller
 * @param[out] Max_Switching_Pattern_Length
 *             Values:
 *             - 0x02 ... 0x4B: Maximum length of antenna switching pattern supported by the Controller
 * @param[out] Max_CTE_Length
 *             Values:
 *             - 0x02 ... 0x14: Maximum length of a transmitted Constant Tone Extension supported in 8 microseconds units
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_read_antenna_information(uint8_t *Supported_Switching_Sampling_Rates,
                                           uint8_t *Num_Antennae,
                                           uint8_t *Max_Switching_Pattern_Length,
                                           uint8_t *Max_CTE_Length);
/**
 * @brief The HCI_LE_Set_Periodic_Advertising_Receive_Enable command will enable
 *        or disable reports for the periodic advertising train identified by
 *        the Sync_Handle parameter. The Enable parameter determines whether
 *        reporting is enabled or disabled. If the value is the same as the
 *        current state, the command has no effect. If the periodic advertising
 *        train corresponding to the Sync_Handle parameter does not exist, the
 *        Controller shall return the error code Unknown Advertising Identifier
 *        (0x42).
 * @param Sync_Handle Sync_Handle identifying the periodic advertising train
 *        Values:
 *        - 0x0000 ... 0x0EFF: Sync_Handle identifying the periodic advertising train
 * @param Enable It determines whether reporting is enabled or disabled
 *        Values:
 *        - 0x00: Reporting disabled
 *        - 0x01: Reporting enabled
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_periodic_advertising_receive_enable(uint16_t Sync_Handle,
                                                          uint8_t Enable);
/**
 * @brief The HCI_LE_Periodic_Advertising_Sync_Transfer command is used to
 *        instruct the Controller to send synchronization information about the
 *        periodic advertising train identified by the Sync_Handle parameter to
 *        a connected device. The Service_Data parameter is a value provided by
 *        the Host for use by the Host of the peer device. It is not used by the
 *        Controller. The connected device is identified by the
 *        Connection_Handle parameter. If the periodic advertising train
 *        corresponding to the Sync_Handle parameter does not exist, the
 *        Controller shall return the error code Unknown Advertising Identifier
 *        (0x42). If the Connection_Handle parameter does not identify a current
 *        connection, the Controller shall return the error code Unknown
 *        Connection Identifier (0x02). If the remote device has not indicated
 *        support for the Periodic Advertising Sync Transfer - Recipient
 *        feature, the Controller shall return the error code Unsupported Remote
 *        Feature / Unsupported LMP Feature (0x1A). Note: This command may
 *        complete before the periodic advertising synchronization information
 *        is sent. No indication is given as to how the recipient handled the
 *        information.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Service_Data The Service_Data parameter is a value provided by the
 *        Host for use by the Host of the peer device. It is not used by the
 *        Controller.
 * @param Sync_Handle Sync handle that identifies the synchronization
 *        information about the periodic advertising train.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_periodic_advertising_sync_transfer(uint16_t Connection_Handle,
                                                     uint16_t Service_Data,
                                                     uint16_t Sync_Handle);
/**
 * @brief The HCI_LE_Periodic_Advertising_Set_Info_Transfer command is used to
 *        instruct the Controller to send synchronization information about the
 *        periodic advertising in an advertising set to a connected device. The
 *        Advertising_Handle parameter identifies the advertising set. If the
 *        parameters in the advertising set have changed since the periodic
 *        advertising was first enabled, the current parameters - not the
 *        original ones - are sent. The Service_Data parameter is a value
 *        provided by the Host to identify the periodic advertising train to the
 *        peer device. It is not used by the Controller. The connected device is
 *        identified by the Connection_Handle parameter. If the advertising set
 *        corresponding to the Advertising_Handle parameter does not exist, the
 *        Controller shall return the error code Unknown Advertising Identifier
 *        (0x42). If periodic advertising is not currently in progress for the
 *        advertising set, the Controller shall return the error code Command
 *        Disallowed (0x0C). If the Connection_Handle parameter does not
 *        identify a current connection, the Controller shall return the error
 *        code Unknown Connection Identifier (0x02). If the remote device has
 *        not indicated support for the Periodic Advertising Sync Transfer -
 *        Recipient feature, the Controller shall return the error code
 *        Unsupported Remote Feature / Unsupported LMP Feature (0x1A). Note:
 *        This command may complete before the periodic advertising
 *        synchronization information is sent. No indication is given as to how
 *        the recipient handled the information.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Service_Data It is a value provided by the Host to identify the
 *        periodic advertising train to the peer device. It is not used by the
 *        Controller.
 * @param Advertising_Handle It is used to identify an advertising set
 *        Values:
 *        - 0x00 ... 0xEF
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_periodic_advertising_set_info_transfer(uint16_t Connection_Handle,
                                                         uint16_t Service_Data,
                                                         uint8_t Advertising_Handle);
/**
 * @brief The HCI_LE_Set_Periodic_Advertising_Sync_Transfer_Parameters command
 *        is used to specify how the Controller will process periodic
 *        advertising synchronization information received from the device
 *        identified by the Connection_Handle parameter (the "transfer mode").
 *        The Mode parameter specifies the action to be taken when periodic
 *        advertising synchronization information is received. If Mode is 0x00,
 *        the Controller will ignore the information. Otherwise it will notify
 *        the Host and synchronize to the periodic advertising. Mode also
 *        specifies whether periodic advertising reports are initially enabled
 *        or disabled. The Skip parameter specifies the number of consecutive
 *        periodic advertising packets that the receiver may skip after
 *        successfully receiving a periodic advertising packet. The Sync_Timeout
 *        parameter specifies the maximum permitted time between successful
 *        receives. If this time is exceeded, synchronization is lost.
 *        Irrespective of the value of the Skip parameter, the Controller should
 *        stop skipping packets before the Sync_Timeout would be exceeded. The
 *        CTE_Type parameter specifies whether to only synchronize to periodic
 *        advertising with certain types of Constant Tone Extension. If the
 *        periodic advertiser changes the type of the Constant Tone Extension
 *        after the Controller has synchronized with the periodic advertising,
 *        it shall remain synchronized. Note: A value of 0 (i.e. all bits clear)
 *        indicates that the presence or absence of a Constant Tone Extension is
 *        irrelevant. This command does not affect any processing of any
 *        periodic advertising synchronization information already received from
 *        the peer device, whether or not the Controller has yet synchronized to
 *        the periodic advertising train it describes. The parameter values
 *        provided by this command override those provided via the
 *        HCI_LE_Set_Default_Periodic_Advertising_Sync_Transfer_Parameters
 *        command (Section 7.8.92) or any preferences previously set using the
 *        HCI_LE_Set_Periodic_Advertising_Sync_Transfer_Parameters command on
 *        the same connection. If the Connection_Handle parameter does not
 *        identify a current connection, the Controller shall return the error
 *        code Unknown Connection Identifier (0x02).
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Mode The Mode parameter specifies the action to be taken when periodic
 *        advertising synchronization information is received. If Mode is 0x00,
 *        the Controller will ignore the information. Otherwise it will notify
 *        the Host and synchronize to the periodic advertising. Mode also
 *        specifies whether periodic advertising reports are initially enabled
 *        or disabled.
 *        Values:
 *        - 0x00: No attempt is made to synchronize to the periodic advertising and no HCI_LE_Periodic_Advertising_Sync_Transfer_Received event is sent to the Host.
 *        - 0x01: An HCI_LE_Periodic_Advertising_Sync_Transfer_Received event is sent to the Host. HCI_LE_Periodic_Advertising_Report events will be disabled.
 *        - 0x02: An HCI_LE_Periodic_Advertising_Sync_Transfer_Received event is sent to the Host. HCI_LE_Periodic_Advertising_Report events will be enabled.
 * @param Skip The Skip parameter specifies the number of consecutive periodic
 *        advertising packets that the receiver may skip after successfully
 *        receiving a periodic advertising packet.
 *        Values:
 *        - 0x0000 ... 0x01F3: The number of periodic advertising packets that can be skipped after a successful receive
 * @param Sync_Timeout The Skip parameter specifies the number of consecutive
 *        periodic advertising packets that the receiver may skip after
 *        successfully receiving a periodic advertising packet. Time = N*10 ms;
 *        Time Range: 100 ms to 163.84 s.
 *        Values:
 *        - 0x000A (100 ms)  ... 0x4000 (163840 ms) : Synchronization timeout for the periodic advertising
 * @param CTE_Type It specifies whether to only synchronize to periodic
 *        advertising with certain types of Constant Tone Extension. If the
 *        periodic advertiser changes the type of the Constant Tone Extension
 *        after the Controller has synchronized with the periodic advertising,
 *        it shall remain synchronized.
 *        Flags:
 *        - 0x01: Do not sync to packets with an AoA Constant Tone Extension
 *        - 0x02: Do not sync to packets with an AoD Constant Tone Extension with 1 microsecond slots
 *        - 0x04: Do not sync to packets with an AoD Constant Tone Extension with 2 microseconds slots
 *        - 0x10: Do not sync to packets without a Constant Tone Extension
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_periodic_advertising_sync_transfer_parameters(uint16_t Connection_Handle,
                                                                    uint8_t Mode,
                                                                    uint16_t Skip,
                                                                    uint16_t Sync_Timeout,
                                                                    uint8_t CTE_Type);
/**
 * @brief The HCI_LE_Set_Default_Periodic_Advertising_Sync_Transfer_Parameters
 *        command is used to specify the initial value for the mode, skip,
 *        timeout, and Constant Tone Extension type (set by the
 *        HCI_LE_Set_Periodic_Advertising_Sync_Transfer_Parameters command; see
 *        Section 7.8.91) to be used for all subsequent connections over the LE
 *        transport. The Mode parameter specifies the initial action to be
 *        taken. If Mode is 0x00, the Controller will ignore the information.
 *        Otherwise it will notify the Host and synchronize to the periodic
 *        advertising. Mode also specifies whether periodic advertising reports
 *        are initially enabled or disabled. The Skip parameter specifies the
 *        number of consecutive periodic advertising packets that the receiver
 *        may skip after successfully receiving a periodic advertising packet.
 *        The Sync_Timeout parameter specifies the maximum permitted time
 *        between successful receives. If this time is exceeded, synchronization
 *        is lost. The CTE_Type parameter specifies whether to only synchronize
 *        to periodic advertising with certain types of Constant Tone Extension.
 *        If the periodic advertiser changes the type of the Constant Tone
 *        Extension after the Controller has synchronized with the periodic
 *        advertising, it shall remain synchronized. Note: A value of 0 (i.e.
 *        all bits clear) indicates that the presence or absence of a Constant
 *        Tone Extension is irrelevant. This command does not affect any
 *        existing connection.
 * @param Mode The Mode parameter specifies the initial action to be taken. If
 *        Mode is 0x00, the Controller will ignore the information. Otherwise it
 *        will notify the Host and synchronize to the periodic advertising. Mode
 *        also specifies whether periodic advertising reports are initially
 *        enabled or disabled.
 *        Values:
 *        - 0x00: No attempt is made to synchronize to the periodic advertising and no HCI_LE_Periodic_Advertising_Sync_Transfer_Received event is sent to the Host.
 *        - 0x01: An HCI_LE_Periodic_Advertising_Sync_Transfer_Received event is sent to the Host. HCI_LE_Periodic_Advertising_Report events will be disabled.
 *        - 0x02: An HCI_LE_Periodic_Advertising_Sync_Transfer_Received event is sent to the Host. HCI_LE_Periodic_Advertising_Report events will be enabled.
 * @param Skip The Skip parameter specifies the number of consecutive periodic
 *        advertising packets that the receiver may skip after successfully
 *        receiving a periodic advertising packet.
 *        Values:
 *        - 0x0000 ... 0x01F3: The number of periodic advertising packets that can be skipped after a successful receive
 * @param Sync_Timeout The Skip parameter specifies the number of consecutive
 *        periodic advertising packets that the receiver may skip after
 *        successfully receiving a periodic advertising packet. Time = N*10 ms;
 *        Time Range: 100 ms to 163.84 s.
 *        Values:
 *        - 0x000A (100 ms)  ... 0x4000 (163840 ms) : Synchronization timeout for the periodic advertising
 * @param CTE_Type The CTE_Type parameter specifies whether to only synchronize
 *        to periodic advertising with certain types of Constant Tone Extension.
 *        If the periodic advertiser changes the type of the Constant Tone
 *        Extension after the Controller has synchronized with the periodic
 *        advertising, it shall remain synchronized.
 *        Flags:
 *        - 0x01: Do not sync to packets with an AoA Constant Tone Extension
 *        - 0x02: Do not sync to packets with an AoD Constant Tone Extension with 1 microsecond slots
 *        - 0x04: Do not sync to packets with an AoD Constant Tone Extension with 2 microseconds slots
 *        - 0x10: Do not sync to packets without a Constant Tone Extension
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_default_periodic_advertising_sync_transfer_parameters(uint8_t Mode,
                                                                            uint16_t Skip,
                                                                            uint16_t Sync_Timeout,
                                                                            uint8_t CTE_Type);
/**
 * @brief Read the current and maximum transmit power levels of the local
 *        Controller on the ACL connection identified by the Connection_Handle
 *        parameter and the PHY indicated by the PHY parameter.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param PHY PHY associated with the connection  (not necessarily the currently
 *        used one).
 *        Values:
 *        - 0x01: LE_1M_PHY
 *        - 0x02: LE_2M_PHY
 *        - 0x03: LE_CODED_PHY_S8
 *        - 0x04: LE_CODED_PHY_S2
 * @param[out] Current_Transmit_Power_Level Current TX power level (dBm).
 *             Values:
 *             - 127: NA
 *             - -127 ... 20
 * @param[out] Max_Transmit_Power_Level Maximum TX power level (dBm).
 *             Values:
 *             - -127 ... 20
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_enhanced_read_transmit_power_level(uint16_t Connection_Handle,
                                                     uint8_t PHY,
                                                     int8_t *Current_Transmit_Power_Level,
                                                     int8_t *Max_Transmit_Power_Level);
/**
 * @brief Read the transmit power level used by the remote Controller on the ACL
 *        connection that is identified by the Connection_Handle parameter and
 *        the PHY indicated by the PHY parameter. Initiate a Power Control
 *        Request procedure to obtain the remote transmit power level if no
 *        prior value is available or used.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param PHY PHY associated with the connection  (not necessarily the currently
 *        used one).
 *        Values:
 *        - 0x01: LE_1M_PHY
 *        - 0x02: LE_2M_PHY
 *        - 0x03: LE_CODED_PHY_S8
 *        - 0x04: LE_CODED_PHY_S2
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_read_remote_transmit_power_level(uint16_t Connection_Handle,
                                                   uint8_t PHY);
/**
 * @brief Set the path loss threshold reporting parameters for the ACL
 *        connection identified by the Connection_Handle parameter.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param High_Threshold High threshold for the path loss. Units: dB.
 *        Values:
 *        - 255: UNUSED
 *        - 0 ... 254
 * @param High_Hysteresis Hysteresis value for the high threshold. Units: dB.
 * @param Low_Threshold Low threshold for the path loss. Units: dB.
 * @param Low_Hysteresis Hysteresis value for the low threshold. Units: dB.
 * @param Min_Time_Spent Minimum time in number of connection events to be
 *        observed once the path crosses the threshold before an event is
 *        generated.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_path_loss_reporting_parameters(uint16_t Connection_Handle,
                                                     uint8_t High_Threshold,
                                                     uint8_t High_Hysteresis,
                                                     uint8_t Low_Threshold,
                                                     uint8_t Low_Hysteresis,
                                                     uint16_t Min_Time_Spent);
/**
 * @brief Enable or disable path loss reporting for the ACL connection
 *        identified by the Connection_Handle parameter. Initiate a new Power
 *        Control Request procedure to obtain the remote transmit power level if
 *        no prior value is available or used and no prior Power Control Request
 *        procedure has been initiated. Path loss reporting is disabled when the
 *        connection is first created.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Enable Enable (1) or disable (0) reportinig.
 *        Values:
 *        - 0x00: DISABLE
 *        - 0x01: ENABLE
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_path_loss_reporting_enable(uint16_t Connection_Handle,
                                                 uint8_t Enable);
/**
 * @brief Enable or disable the reporting of transmit power level changes in the
 *        local and remote Controllers for the ACL connection identified by the
 *        Connection_Handle parameter. Initiate a new Power Control Request
 *        procedure to obtain the remote transmit power level if Remote_Enable
 *        is 0x01, and no prior value is available or used, and no prior Power
 *        Control Request procedure has been initiated.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Local_Enable Enable (1) or disable (0) local transmit power reports.
 *        Values:
 *        - 0x00: DISABLE
 *        - 0x01: ENABLE
 * @param Remote_Enable Enable (1) or disable (0) remote transmit power reports.
 *        Values:
 *        - 0x00: DISABLE
 *        - 0x01: ENABLE
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_set_transmit_power_reporting_enable(uint16_t Connection_Handle,
                                                      uint8_t Local_Enable,
                                                      uint8_t Remote_Enable);
/**
 * @brief API used to send HCI ACL Data Packets to exchange data between the Host and Controller.
 *
 * @note The API name is only available in link layer only mode.
 *
 * @param      Connection_Handle  Connection handle for which the command is given. Range: 0x0000-0x0EFF (0x0F00 - 0x0FFF Reserved for future use)
 * @param      PB_Flag            Packet boundary flag
 * @param      BC_Flag            Broadcast flag
 * @param      Data_Length        Length of PDU data in octets.
 * @param[in]  PDU_Data           PDU data pointer
 *
 * @return  Error code
 */

tBleStatus hci_tx_acl_data(uint16_t Connection_Handle, uint8_t  PB_Flag, uint8_t  BC_Flag, uint16_t  Data_Length, uint8_t*  PDU_Data);
/**
 * @}
 */
/**
 * @}
 */

/**
 *@defgroup HCI_Test_Commands HCI Test Commands
 *@brief Standard HCI commands for testing.
 *@{
 */
/**
 * @brief This command is used to start a test where the DUT receives test
 *        reference packets at a fixed interval. The tester generates the test
 *        reference packets. (See Bluetooth Specification v.4.1, Vol. 2, Part E,
 *        7.8.28)
 * @param RX_Frequency
 *        Values:
 *        - 0x00 ... 0x27: N = (F - 2402) / 2.Frequency Range : 2402 MHz to 2480 MHz
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_receiver_test(uint8_t RX_Frequency);
/**
 * @brief This command is used to start a test where the DUT generates test
 *        reference packets at a fixed interval. The Controller shall transmit
 *        at maximum power. An LE Controller supporting the LE_Transmitter_Test
 *        command shall support Packet_Payload values 0x00, 0x01 and 0x02. An LE
 *        Controller may support other values of Packet_Payload. (See Bluetooth
 *        Specification v.4.1, Vol. 2, Part E, 7.8.29)
 * @param TX_Frequency N = (F - 2402) / 2
 *        Frequency Range : 2402 MHz to 2480 MHz
 *        Values:
 *        - 0x00 ... 0x27
 * @param Length_Of_Test_Data Length in bytes of payload data in each packet.
 *        Supported ranges:       - (0x00,0x25): BlueNRG-1 and BlueNRG-2 with
 *        BLE stack version < 2.1       - (0x00,0xFF): BlueNRG-2 with BLE stack
 *        version >= 2.1 and extended packet length.
 *        Values:
 *        - 0x00 ... 0xFF
 * @param Packet_Payload Content of the Payload of the test reference packets.
 *        0: PRBS9 sequence '11111111100000111101...' (in transmission order) 1:
 *        Repeated '11110000' (in transmission order) sequence 2: Repeated
 *        '10101010' (in transmission order) sequence 3: PRBS15 sequence 4:
 *        Repeated '11111111' (in transmission order) sequence 5: Repeated
 *        '00000000' (in transmission order) sequence 6: Repeated '00001111' (in
 *        transmission order) sequence 7: Repeated '01010101' (in transmission
 *        order) sequence
 *        Values:
 *        - 0x00: PRBS9
 *        - 0x01: Repeated '11110000'
 *        - 0x02: Repeated '10101010'
 *        - 0x03: PRBS15
 *        - 0x04: Repeated '11111111'
 *        - 0x05: Repeated '00000000'
 *        - 0x06: Repeated '00001111'
 *        - 0x07: Repeated '01010101'
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_transmitter_test(uint8_t TX_Frequency,
                                   uint8_t Length_Of_Test_Data,
                                   uint8_t Packet_Payload);
/**
 * @brief This command is used to stop any test which is in progress. The
 *        Number_Of_Packets for a transmitter test shall be reported as 0x0000.
 *        The Number_Of_Packets is an unsigned number and contains the number of
 *        received packets. (See Bluetooth Specification v.4.1, Vol. 2, Part E,
 *        7.8.30)
 * @param[out] Number_Of_Packets Number of packets received.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_test_end(uint16_t *Number_Of_Packets);
/**
 * @brief This command is used to start a test where the DUT receives test
 *        reference packets at a fixed interval. The tester generates the test
 *        reference packets.
 * @param RX_Channel Frequency Range : 2402 MHz to 2480 MHz N = (F - 2402) / 2.
 *        Values:
 *        - 0x00 ... 0x27: Frequency Range : 2402 MHz to 2480 MHz
 * @param PHY PHY to be used by the receiver.
 *        Values:
 *        - 0x01: LE_1M_PHY
 *        - 0x02: LE_2M_PHY
 *        - 0x03: LE_CODED_PHY
 * @param Modulation_index The Modulation_Index parameter specifies whether or
 *        not the Controller should assume the receiver has a stable modulation
 *        index.
 *        Values:
 *        - 0x00: Standard modulation index
 *        - 0x01: Stable modulation index
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_enhanced_receiver_test(uint8_t RX_Channel,
                                         uint8_t PHY,
                                         uint8_t Modulation_index);
/**
 * @brief This command is used to start a test where the DUT generates test
 *        reference packets at a fixed interval. The Controller shall transmit
 *        at maximum power. An LE Controller supporting the LE_Enhanced
 *        Transmitter_Test command shall support Packet_Payload values 0x00,
 *        0x01 and 0x02. An LE Controller supporting the LE Coded PHY shall also
 *        support Packet_Payload value 0x04. An LE Controller may support other
 *        values of Packet_Payload.
 * @param TX_Channel Frequency Range: 2402 MHz to 2480 MHz N = (F-2402) / 2
 *        Values:
 *        - 0x00 ... 0x27: Frequency Range: 2402 MHz to 2480 MHz
 * @param Length_Of_Test_Data
 *        Values:
 *        - 0x00 ... 0xFF: Length in bytes of payload data in each packet
 * @param Packet_Payload Content of the Payload of the test reference packets.
 *        0: PRBS9 sequence '11111111100000111101...' (in transmission order) 1:
 *        Repeated '11110000' (in transmission order) sequence 2: Repeated
 *        '10101010' (in transmission order) sequence 3: PRBS15 sequence 4:
 *        Repeated '11111111' (in transmission order) sequence 5: Repeated
 *        '00000000' (in transmission order) sequence 6: Repeated '00001111' (in
 *        transmission order) sequence 7: Repeated '01010101' (in transmission
 *        order) sequence
 *        Values:
 *        - 0x00: PRBS9
 *        - 0x01: Repeated '11110000'
 *        - 0x02: Repeated '10101010'
 *        - 0x03: PRBS15
 *        - 0x04: Repeated '11111111'
 *        - 0x05: Repeated '00000000'
 *        - 0x06: Repeated '00001111'
 *        - 0x07: Repeated '01010101'
 * @param PHY PHY to be used by the transmitter.
 *        Values:
 *        - 0x01: LE_1M_PHY
 *        - 0x02: LE_2M_PHY
 *        - 0x03: LE_CODED_PHY_S8
 *        - 0x04: LE_CODED_PHY_S2
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_enhanced_transmitter_test(uint8_t TX_Channel,
                                            uint8_t Length_Of_Test_Data,
                                            uint8_t Packet_Payload,
                                            uint8_t PHY);
/**
 * @brief This command is used to start a test where the DUT receives test
 *        reference packets at a fixed interval. The tester generates the test
 *        reference packets. The RX_Channel and PHY parameters specify the RF
 *        channel and PHY to be used by the receiver. If the Host sets the PHY
 *        parameter to a PHY that the Controller does not support, including a
 *        value that is reserved for future use, the Controller shall return the
 *        error code Unsupported Feature or Parameter Value (0x11). The
 *        Modulation_Index parameter specifies whether or not the Controller
 *        should assume the receiver has a stable modulation index. The
 *        Expected_CTE_Length and Expected_CTE_Type parameters specify the
 *        expected length and type of the Constant Tone Extensions in received
 *        test reference packets. When receiving on a PHY that allows Constant
 *        Tone Extensions, if the Constant Tone Extension in a received test
 *        reference packet does not match both of these, the DUT shall discard
 *        that packet. If Expected_CTE_Length is not zero and PHY specifies a
 *        PHY that does not allow Constant Tone Extensions, the Controller shall
 *        return the error code Command Disallowed (0x0C). If the Slot_Durations
 *        parameter is set to 0x01 and the Controller does not support 1
 *        microsecond switching and sampling, the Controller shall return the
 *        error code Unsupported Feature or Parameter Value (0x11).
 *        Slot_Durations, Switching_Pattern_Length, and Antenna_IDs[i] are only
 *        used when expecting an AoA Constant Tone Extension and shall be
 *        ignored when expecting an AoD Constant Tone Extension. If the
 *        Controller determines that any of the Antenna_IDs[i] values do not
 *        identify an antenna in the device's antenna array, it shall return the
 *        error code Unsupported Feature or Parameter Value (0x11). Note: Some
 *        Controllers may be unable to determine which values do or do not
 *        identify an antenna.
 * @param RX_Channel
 *        Values:
 *        - 0x00 ... 0x27: N = (F - 2402) / 2.Frequency Range : 2402 MHz to 2480 MHz
 * @param PHY PHY to be used by the receiver.
 *        Values:
 *        - 0x01: LE_1M_PHY
 *        - 0x02: LE_2M_PHY
 *        - 0x03: LE_CODED_PHY
 * @param Modulation_Index
 *        Values:
 *        - 0x00: Assume transmitter will have a standard modulation index
 *        - 0x01: Assume transmitter will have a stable modulation index
 * @param Expected_CTE_Length
 *        Values:
 *        - 0x00: No Constant Tone Extension expected (default)
 *        - 0x02 ... 0x14: Expected length of the Constant Tone Extension in 8 microseconds units.
 * @param Expected_CTE_Type
 *        Values:
 *        - 0x00: Expect AoA Constant Tone Extension
 *        - 0x01: Expect AoD Constant Tone Extension with 1 microsecond slots
 *        - 0x02: Expect AoD Constant Tone Extension with 2 microseconds slots
 * @param Slot_Durations Sampling rate used by the Controller.
 *        Values:
 *        - 0x01: SLOT_1us
 *        - 0x02: SLOT_2us
 * @param Switching_Pattern_Length
 *        Values:
 *        - 0x02 ... 0x4B: The number of Antenna IDs in the pattern.
 * @param Antenna_IDs List of Antenna IDs in the pattern
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_receiver_test_v3(uint8_t RX_Channel,
                                   uint8_t PHY,
                                   uint8_t Modulation_Index,
                                   uint8_t Expected_CTE_Length,
                                   uint8_t Expected_CTE_Type,
                                   uint8_t Slot_Durations,
                                   uint8_t Switching_Pattern_Length,
                                   uint8_t Antenna_IDs[]);
/**
 * @brief This command is used to start a test where the DUT generates test
 *        reference packets at a fixed interval. The Controller shall transmit
 *        at the power level indicated by the Transmit_Power_Level parameter.
 *        The TX_Channel and PHY parameters specify the RF channel and PHY to be
 *        used by the transmitter. If the Host sets the PHY parameter to a PHY
 *        that the Controller does not support, including a value that is
 *        reserved for future use, the Controller shall return the error code
 *        Unsupported Feature or Parameter Value (0x11). The Test_Data_Length
 *        and Packet_Payload parameters specify the length and contents of the
 *        Payload of the test reference packets. An LE Controller supporting the
 *        HCI_LE_Transmitter_Test command shall support Packet_Payload values
 *        0x00, 0x01 and 0x02. An LE Controller supporting the LE Coded PHY
 *        shall also support Packet_Payload value 0x04. An LE Controller may
 *        support other values of Packet_Payload. The CTE_Length and CTE_Type
 *        parameters specify the length and type of the Constant Tone Extension
 *        in the test reference packets. If the CTE_Type parameter is set to
 *        0x01 and the Controller does not support 1 microsecond switching, the
 *        Controller shall return the error code Unsupported Feature or
 *        Parameter Value (0x11). If CTE_Length is not zero and PHY specifies a
 *        PHY that does not allow Constant Tone Extensions, the Controller shall
 *        return the error code Command Disallowed (0x0C). The
 *        Switching_Pattern_Length and Antenna_IDs[i] parameters specify the
 *        antenna switching pattern. They are only used when transmitting an AoD
 *        Constant Tone Extension and shall be ignored when transmitting an AoA
 *        Constant Tone Extension. If the Controller determines that any of the
 *        Antenna_IDs[i] values do not identify an antenna in the device's
 *        antenna array, it shall return the error code Unsupported Feature or
 *        Parameter Value (0x11). Note: Some Controllers may be unable to
 *        determine which values do or do not identify an antenna. The
 *        Transmit_Power_Level parameter specifies the transmit power level to
 *        be used by the transmitter. If the parameter is set to a value other
 *        than 0x7E or 0x7F, then the Controller shall make the requested change
 *        or shall make the nearest change that it is capable of doing.
 * @param TX_Channel N = (F - 2402) / 2
 *        Frequency Range : 2402 MHz to 2480 MHz
 *        Values:
 *        - 0x00 ... 0x27
 * @param Test_Data_Length Length in bytes of payload data in each packet
 * @param Packet_Payload Content of the Payload of the test reference packets.
 *        0: PRBS9 sequence '11111111100000111101...' (in transmission order) 1:
 *        Repeated '11110000' (in transmission order) sequence 2: Repeated
 *        '10101010' (in transmission order) sequence 3: PRBS15 sequence 4:
 *        Repeated '11111111' (in transmission order) sequence 5: Repeated
 *        '00000000' (in transmission order) sequence 6: Repeated '00001111' (in
 *        transmission order) sequence 7: Repeated '01010101' (in transmission
 *        order) sequence
 *        Values:
 *        - 0x00: PRBS9
 *        - 0x01: Repeated '11110000'
 *        - 0x02: Repeated '10101010'
 *        - 0x03: PRBS15
 *        - 0x04: Repeated '11111111'
 *        - 0x05: Repeated '00000000'
 *        - 0x06: Repeated '00001111'
 *        - 0x07: Repeated '01010101'
 * @param PHY PHY to be used by the transmitter.
 *        Values:
 *        - 0x01: LE_1M_PHY
 *        - 0x02: LE_2M_PHY
 *        - 0x03: LE_CODED_PHY_S8
 *        - 0x04: LE_CODED_PHY_S2
 * @param CTE_Length
 *        Values:
 *        - 0x00: No Constant Tone Extension expected (default)
 *        - 0x02 ... 0x14: Expected length of the Constant Tone Extension in 8 microseconds units.
 * @param CTE_Type
 *        Values:
 *        - 0x00: Expect AoA Constant Tone Extension
 *        - 0x01: Expect AoD Constant Tone Extension with 1 microsecond slots
 *        - 0x02: Expect AoD Constant Tone Extension with 2 microseconds slots
 * @param Switching_Pattern_Length
 *        Values:
 *        - 0x02 ... 0x4B: The number of Antenna IDs in the pattern.
 * @param Antenna_IDs List of Antenna IDs in the pattern
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_transmitter_test_v3(uint8_t TX_Channel,
                                      uint8_t Test_Data_Length,
                                      uint8_t Packet_Payload,
                                      uint8_t PHY,
                                      uint8_t CTE_Length,
                                      uint8_t CTE_Type,
                                      uint8_t Switching_Pattern_Length,
                                      uint8_t Antenna_IDs[]);
/**
 * @brief This command is used to start a test where the DUT generates test
 *        reference packets at a fixed interval. The Controller shall transmit
 *        at the power level indicated by the Transmit_Power_Level parameter.
 *        The TX_Channel and PHY parameters specify the RF channel and PHY to be
 *        used by the transmitter. If the Host sets the PHY parameter to a PHY
 *        that the Controller does not support, including a value that is
 *        reserved for future use, the Controller shall return the error code
 *        Unsupported Feature or Parameter Value (0x11). The Test_Data_Length
 *        and Packet_Payload parameters specify the length and contents of the
 *        Payload of the test reference packets. An LE Controller supporting the
 *        HCI_LE_Transmitter_Test command shall support Packet_Payload values
 *        0x00, 0x01 and 0x02. An LE Controller supporting the LE Coded PHY
 *        shall also support Packet_Payload value 0x04. An LE Controller may
 *        support other values of Packet_Payload. The CTE_Length and CTE_Type
 *        parameters specify the length and type of the Constant Tone Extension
 *        in the test reference packets. If the CTE_Type parameter is set to
 *        0x01 and the Controller does not support 1 microsecond switching, the
 *        Controller shall return the error code Unsupported Feature or
 *        Parameter Value (0x11). If CTE_Length is not zero and PHY specifies a
 *        PHY that does not allow Constant Tone Extensions, the Controller shall
 *        return the error code Command Disallowed (0x0C). The
 *        Switching_Pattern_Length and Antenna_IDs[i] parameters specify the
 *        antenna switching pattern. They are only used when transmitting an AoD
 *        Constant Tone Extension and shall be ignored when transmitting an AoA
 *        Constant Tone Extension. If the Controller determines that any of the
 *        Antenna_IDs[i] values do not identify an antenna in the device's
 *        antenna array, it shall return the error code Unsupported Feature or
 *        Parameter Value (0x11). Note: Some Controllers may be unable to
 *        determine which values do or do not identify an antenna. The
 *        Transmit_Power_Level parameter specifies the transmit power level to
 *        be used by the transmitter. If the parameter is set to a value other
 *        than 0x7E or 0x7F, then the Controller shall make the requested change
 *        or shall make the nearest change that it is capable of doing.
 * @param TX_Channel N = (F - 2402) / 2
 *        Frequency Range : 2402 MHz to 2480 MHz
 *        Values:
 *        - 0x00 ... 0x27
 * @param Test_Data_Length Length in bytes of payload data in each packet
 * @param Packet_Payload Content of the Payload of the test reference packets.
 *        0: PRBS9 sequence '11111111100000111101...' (in transmission order) 1:
 *        Repeated '11110000' (in transmission order) sequence 2: Repeated
 *        '10101010' (in transmission order) sequence 3: PRBS15 sequence 4:
 *        Repeated '11111111' (in transmission order) sequence 5: Repeated
 *        '00000000' (in transmission order) sequence 6: Repeated '00001111' (in
 *        transmission order) sequence 7: Repeated '01010101' (in transmission
 *        order) sequence
 *        Values:
 *        - 0x00: PRBS9
 *        - 0x01: Repeated '11110000'
 *        - 0x02: Repeated '10101010'
 *        - 0x03: PRBS15
 *        - 0x04: Repeated '11111111'
 *        - 0x05: Repeated '00000000'
 *        - 0x06: Repeated '00001111'
 *        - 0x07: Repeated '01010101'
 * @param PHY PHY to be used by the transmitter.
 *        Values:
 *        - 0x01: LE_1M_PHY
 *        - 0x02: LE_2M_PHY
 *        - 0x03: LE_CODED_PHY_S8
 *        - 0x04: LE_CODED_PHY_S2
 * @param CTE_Length
 *        Values:
 *        - 0x00: No Constant Tone Extension expected (default)
 *        - 0x02 ... 0x14: Expected length of the Constant Tone Extension in 8 microseconds units.
 * @param CTE_Type
 *        Values:
 *        - 0x00: Expect AoA Constant Tone Extension
 *        - 0x01: Expect AoD Constant Tone Extension with 1 microsecond slots
 *        - 0x02: Expect AoD Constant Tone Extension with 2 microseconds slots
 * @param Switching_Pattern_Length
 *        Values:
 *        - 0x02 ... 0x4B: The number of Antenna IDs in the pattern.
 * @param Antenna_IDs List of Antenna IDs in the pattern
 * @param Transmit_Power_Level
 *        Values:
 *        - 126: Set transmitter to minimum transmit power level
 *        - 127: Set transmitter to maximum transmit power level
 *        - -127 ... 20: Set transmitter to the specified or the nearest transmit power level.
 * @retval Value indicating success or error code.
 */
tBleStatus hci_le_transmitter_test_v4(uint8_t TX_Channel,
                                      uint8_t Test_Data_Length,
                                      uint8_t Packet_Payload,
                                      uint8_t PHY,
                                      uint8_t CTE_Length,
                                      uint8_t CTE_Type,
                                      uint8_t Switching_Pattern_Length,
                                      uint8_t Antenna_IDs[],
                                      int8_t Transmit_Power_Level);
/**
 * @}
 */
/**
 * @}
 */

/**
 *@addtogroup HAL HAL
 *@{
 */
/**
 *@defgroup HAL_Commands HAL Commands
 *@brief HAL API layer.
 *@{
 */
/**
 * @brief This command returns the build number associated with the firmware
 *        version currently running
 * @param[out] Build_Number Build number of the firmware.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_hal_get_fw_build_number(uint16_t *Build_Number);
/**
 * @brief This command writes a value to a low level configure data structure.
 *        It is useful to setup directly some low level parameters for the
 *        system in the runtime.NOTE: This command shall not be called if a
 *        command different than Stack Init, HCI_RESET,
 *        ACI_HAL_WRITE_CONFIG_DATA or ACI_HAL_READ_CONFIG_DATA has already been
 *        called.
 * @param Offset Offset of the element in the configuration data structure which
 *        has to be written. The valid offsets are:  - 0x00: Bluetooth public
 *        address, Value length to be written: 6 bytes - 0x08: Encryption root
 *        key used to derive LTK and CSRK, Value length to be written: 16 bytes
 *        - 0x18: Identity root key used to derive LTK and CSRK, Value length to
 *        be written: 16 bytes - 0x2C: Link layer without host (for
 *        certification purposes), Value length to be written: 1 byte - 0x2E: If
 *        set, the stack uses this address as the static random address instead
 *        of the one stored in NVM. - 0xD0: Use debug key for Secure connection:
 *        1 byte - 0xD1: Set the maximum allowed parameter values for Data
 *        Length Extension: 8 bytes, 2 bytes for each of the following
 *        parameters:         supportedMaxTxOctets, supportedMaxTxTime,
 *        supportedMaxRxOctets, supportedMaxRxTime, in little-endian order.
 *        (default 251,2120,251,2120).
 *        Values:
 *        - 0x00: CONFIG_DATA_PUBADDR_OFFSET
 *        - 0x08: CONFIG_DATA_ER_OFFSET
 *        - 0x18: CONFIG_DATA_IR_OFFSET
 *        - 0x2C: LL_WITHOUT_HOST
 *        - 0x2E: CONFIG_DATA_STATIC_RANDOM_ADDRESS
 *        - 0xD0: CONFIG_DATA_DEBUG_KEY
 *        - 0xD1: CONFIG_DATA_DLE
 * @param Length Length of data to be written
 * @param Value Data to be written
 * @retval Value indicating success or error code.
 */
tBleStatus aci_hal_write_config_data(uint8_t Offset,
                                     uint8_t Length,
                                     uint8_t Value[]);
/**
 * @brief This command requests the value in the low level configure data
 *        structure. The number of read bytes changes for different Offset.
 * @param Offset Offset of the element in the configuration data structure which
 *        has to be read. The valid offsets are:  - 0x00: Bluetooth public
 *        address, Value length returned: 6 bytes - 0x08: Encryption root key
 *        used to derive LTK and CSRK, Value length returned: 16 bytes - 0x18:
 *        Identity root key used to derive LTK and CSRK, Value length returned:
 *        16 bytes - 0x2C: Link layer without host (for certification purposes),
 *        Value length returned: 1 byte - 0x80: The static random address stored
 *        in NVM. Value length returned: 6 bytes (read-only)
 *        Values:
 *        - 0x00: CONFIG_DATA_PUBADDR_OFFSET
 *        - 0x08: CONFIG_DATA_ER_OFFSET
 *        - 0x18: CONFIG_DATA_IR_OFFSET
 *        - 0x2C: LL_WITHOUT_HOST
 *        - 0x80: CONFIG_DATA_STORED_STATIC_RANDOM_ADDRESS
 * @param[out] Data_Length Length of Data in octets
 * @param[out] Data Data field associated with Offset parameter
 * @retval Value indicating success or error code.
 */
tBleStatus aci_hal_read_config_data(uint8_t Offset,
                                    uint8_t *Data_Length,
                                    uint8_t Data[]);
/**
 * @brief This command sets the TX power level of the device. By controlling the
 *        EN_HIGH_POWER and the PA_LEVEL, the combination of the 2 determines
 *        the output power level (dBm).  When the system starts up or reboots,
 *        the default TX power level will be used, which is the maximum value.
 *        Once this command is given, the output power will be changed
 *        instantly, regardless if there is Bluetooth communication going on or
 *        not. The system will keep the last received TX power level from the
 *        command, i.e. the 2nd command overwrites the previous TX power level.
 *        The new TX power level remains until another Set TX Power command, or
 *        the system reboots.
 * @param En_High_Power Enable High Power mode.  High power mode should be
 *        enabled only to reach the maximum output power.
 *        Values:
 *        - 0x00: Normal Power
 *        - 0x01: High Power
 * @param PA_Level Power amplifier output level. The output power is different
 *        depending on En_High_Power: if set to 0, the SMPS level is set to
 *        1.4V;  if set to 1, the SMPS level is set to 1.9V, which produces an
 *        higher output power. The real output power may also depend on PCB
 *        layout and associated components.
 *        Values:
 *        - 0: -54/-54 dBm
 *        - 1: -21/-19 dBm
 *        - 2: -20/-18 dBm
 *        - 3: -19/-17 dBm
 *        - 4: -17/-16 dBm
 *        - 5: -16/-15 dBm
 *        - 6: -15/-14 dBm
 *        - 7: -14/-13 dBm
 *        - 8: -13/-12 dBm
 *        - 9: -12/-11 dBm
 *        - 10: -11/-10 dBm
 *        - 11: -10/-9 dBm
 *        - 12: -9/-8 dBm
 *        - 13: -8/-7 dBm
 *        - 14: -7/-6 dBm
 *        - 15: -6/-5 dBm
 *        - 16: -6/-4 dBm
 *        - 17: -4/-3 dBm
 *        - 18: -3/-3 dBm
 *        - 19: -3/-2 dBm
 *        - 20: -2/-1 dBm
 *        - 21: -2/+0 dBm
 *        - 22: -1/+1 dBm
 *        - 23: -1/+2 dBm
 *        - 24: +0/+3 dBm
 *        - 25: +0/+8 dBm
 *        - 26: +1/+8 dBm
 *        - 27: +2/+8 dBm
 *        - 28: +3/+8 dBm
 *        - 29: +4/+8 dBm
 *        - 30: +5/+8 dBm
 *        - 31: +6/+8 dBm
 * @retval Value indicating success or error code.
 */
tBleStatus aci_hal_set_tx_power_level(uint8_t En_High_Power,
                                      uint8_t PA_Level);
/**
 * @brief This command returns the number of packets sent in Direct Test Mode.
 *        When the Direct TX test is started, a 32-bit counter is used to count
 *        how many packets have been transmitted.  This command can be used to
 *        check how many packets have been sent during the Direct TX test. The
 *        counter starts from 0 and counts upwards. The counter can wrap and
 *        start from 0 again.  The counter is not cleared until the next Direct
 *        TX test starts.
 * @param[out] Number_Of_Packets Number of packets sent during the last Direct
 *             TX test.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_hal_le_tx_test_packet_number(uint32_t *Number_Of_Packets);
/**
 * @brief This command starts a carrier frequency, i.e. a tone, on a specific
 *        channel. The frequency sine wave at the specific channel may be used
 *        for debugging purpose only. The channel ID is a parameter from 0x00 to
 *        0x27 for the 40 BLE channels, e.g. 0x00 for 2.402 GHz, 0x01 for 2.404
 *        GHz etc. This command should not be used when normal Bluetooth
 *        activities are ongoing. The tone should be stopped by @ref
 *        aci_hal_tone_stop command.
 * @param RF_Channel BLE Channel ID, from 0x00 to 0x27 meaning (2.402 + 2*0xXX)
 *        GHz.
 *        Values:
 *        - 0x00 ... 0x27
 * @param Offset Specify if the tone must be emitted with an offset from the
 *        channel center frequency.  If 0, the tone is emitted at the channel
 *        center frequency. If 1 or 2, the device will continuously emit the
 *        tone at the center frequency plus or minus 250 kHz respectively.
 *        Values:
 *        - 0x00: 0 kHz offset
 *        - 0x01: +250 kHz offset
 *        - 0x02: -250 kHz offset
 * @retval Value indicating success or error code.
 */
tBleStatus aci_hal_tone_start(uint8_t RF_Channel,
                              uint8_t Offset);
/**
 * @brief This command is used to stop the previously started @ref
 *        aci_hal_tone_start command.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_hal_tone_stop(void);
/**
 * @brief This command returns the status of the Bluetooth low energy links
 *        managed by the device.
 * @param Bank_index Index that identifies the link bank. Each bank is made by 8
 *        links. Set Bank_Index to 0 to retrieve the status of the first 8
 *        links, Bank_Index 1 to retrieve the status of the second 8 links and
 *        so on.
 *        Values:
 *        - 0x00 ... 0x15
 * @param[out] Link_Status Array of link status (8 links). Each link status is 1
 *             byte. - 0x00: Idle - 0x01: Advertising - 0x02: Connected as slave
 *             - 0x03: Scanning - 0x04: Initiating - 0x05: Connected as master -
 *             0x06: TX test mode - 0x07: RX test mode
 * @param[out] Link_Connection_Handle Array of connection handles (2 bytes) for
 *             8 links.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_hal_get_link_status(uint8_t Bank_index,
                                   uint8_t Link_Status[8],
                                   uint16_t Link_Connection_Handle[16 / 2]);
/**
 * @brief This command set the bitmask associated to @ref
 *        aci_hal_end_of_radio_activity_event.  Only the radio activities
 *        enabled in the mask will be reported to application by @ref
 *        aci_hal_end_of_radio_activity_event
 * @param Radio_Activity_Mask Bitmask of radio events
 *        Flags:
 *        - 0x0001: Idle
 *        - 0x0002: Advertising
 *        - 0x0004: Connection event slave
 *        - 0x0008: Scanning
 *        - 0x0010: Connection request
 *        - 0x0020: Connection event master
 *        - 0x0040: TX test mode
 *        - 0x0080: RX test mode
 * @retval Value indicating success or error code.
 */
tBleStatus aci_hal_set_radio_activity_mask(uint16_t Radio_Activity_Mask);
/**
 * @brief
 * @param Event_Mask Mask to enable/disable generation of HAL events
 *        Flags:
 *        - 0x00000000: No events specified (Default)
 *        - 0x00000001: ACI_HAL_SCAN_REQ_REPORT_EVENT
 * @retval Value indicating success or error code.
 */
tBleStatus aci_hal_set_event_mask(uint32_t Event_Mask);
/**
 * @brief This command is used to enable or disable the LE Power Control feature
 *        and procedure for a given PHY on the later established connections. It
 *        also provides the parameters that let the Controller initiate the LE
 *        Power Control procedure. In particular, the procedure will be
 *        initiated when the current (average) RSSI (say Curr_Avg_RSSI) gets: *
 *        Less than (RSSI_Target - RSSI_Hysteresis) and the Controller will
 *        request the peer to increase its TX power level for the given PHY by
 *        (RSSI_Target - Curr_Avg_RSSI). * Greater than (RSSI_Target +
 *        RSSI_Hysteresis) and the Controller will request the peer to decrease
 *        its TX power level for the given PHY by (Curr_Avg_RSSI - RSSI_Target).
 *        The Controller will start transmitting on the connections for which
 *        the power control is enabled and for the given PHY using the
 *        Initial_Tx_Power value. It will change its TX power based on the
 *        requests or feedbacks from the peer: * If the peer initiates an LE
 *        Power Control procedure and requests to increase or decrease the TX
 *        power of a given delta, the TX power will be increased or reduced by
 *        the requested delta within the acceptable limits. * If the peer
 *        reports that it can accept a TX power reduction of a given delta, the
 *        TX power will be reduced by the reported delta within the acceptable
 *        limits. If this command is not issued, the Controller will use the
 *        parameter default values.
 * @param Enable Enable (1) or disable (0) LE power control on following
 *        connections. Default: 1.
 *        Values:
 *        - 0x00: DISABLE
 *        - 0x01: ENABLE
 * @param PHY PHY on which the power control must be enabled or disabled.
 *        Values:
 *        - 0x01: LE_1M_PHY
 *        - 0x02: LE_2M_PHY
 *        - 0x03: LE_CODED_PHY_S8
 *        - 0x04: LE_CODED_PHY_S2
 * @param RSSI_Target Target RSSI in dBm. Default: -55 dBm.
 * @param RSSI_Hysteresis Hysteresis applied on the target RSSI in dB. Default:
 *        15 dB.
 * @param Initial_TX_Power Initial TX power in dBm. Default: max TX power
 *        supported by the platform.
 * @param RSSI_Filtering_Coefficient Coefficient used for the filtering of the
 *        RSSI samples and the calculation of the average RSSI. Allowed values
 *        are from 0 (fast moving average, low accuracy, max weight of last
 *        RSSI) to 4 (slow moving average, high accuracy, min weight of last
 *        RSSI). Default: 2.
 *        Values:
 *        - 0x00 ... 0x04
 * @retval Value indicating success or error code.
 */
tBleStatus aci_hal_set_le_power_control(uint8_t Enable,
                                        uint8_t PHY,
                                        int8_t RSSI_Target,
                                        uint8_t RSSI_Hysteresis,
                                        int8_t Initial_TX_Power,
                                        uint8_t RSSI_Filtering_Coefficient);
/**
 * @brief
 * @param Start_Address
 * @param Num_Bytes Length of Data in octets
 * @param Data
 * @retval Value indicating success or error code.
 */
tBleStatus aci_hal_write_radio_reg(uint32_t Start_Address,
                                   uint8_t Num_Bytes,
                                   uint8_t Data[]);
/**
 * @brief
 * @param Start_Address
 * @param Num_Bytes
 * @param[out] Data_Length Length of Data in octets
 * @param[out] Data
 * @retval Value indicating success or error code.
 */
tBleStatus aci_hal_read_radio_reg(uint32_t Start_Address,
                                  uint8_t Num_Bytes,
                                  uint8_t *Data_Length,
                                  uint8_t Data[]);
/**
 * @brief Set data pointer for legacy advertising data.
 * @param Data_Length
 * @param Data
 * @retval Value indicating success or error code.
 */
tBleStatus ll_set_legacy_advertising_data_ptr(uint8_t Data_Length,
                                              uint8_t * Data);
/**
 * @brief Set data pointer for legacy scan response data.
 * @param Data_Length
 * @param Data
 * @retval Value indicating success or error code.
 */
tBleStatus ll_set_legacy_scan_reponse_data_ptr(uint8_t Data_Length,
                                               uint8_t * Data);
/**
 * @brief Set data pointer for extended advertising data.
 * @param Advertising_Handle Used to identify an advertising set. This parameter
 *        is only meaningful if Extended Advertising Feature is enabled.
 *        Values:
 *        - 0x0000 ... 0x00EF
 * @param Operation If set to Unchanged data, just update the Advertising DID.
 *        Values:
 *        - 0x03: Complete data
 *        - 0x04: Unchanged data
 * @param Advertising_Data_Length Length of advertising data.
 * @param Advertising_Data Pointer to the buffer containing properly formatted
 *        advertising data (see Core v5.2 Vol 3, part C, chapter 11). Its
 *        content must not change, until an
 *        aci_hal_adv_scan_resp_data_update_event is received, which informs the
 *        application that the buffer is no more used by the Bluetooth stack.
 * @retval Value indicating success or error code.
 */
tBleStatus ll_set_advertising_data_ptr(uint16_t Advertising_Handle,
                                       uint8_t Operation,
                                       uint16_t Advertising_Data_Length,
                                       uint8_t Advertising_Data[]);
/**
 * @brief Set data pointer for extended scan response data.
 * @param Advertising_Handle Used to identify an advertising set. This parameter
 *        is only meaningful if Extended Advertising Feature is enabled.
 *        Values:
 *        - 0x0000 ... 0x00EF
 * @param Scan_Response_Data_Length Length of scan response data. If the
 *        advertising set uses scannable legacy advertising PDUs maximum length
 *        is 31 octets.
 * @param Scan_Response_Data Pointer to the buffer containing properly formatted
 *        scan response data (see Core v5.1 Vol 3, part C, chapter 11). Its
 *        content must not change, until an
 *        aci_hal_adv_scan_resp_data_update_event is received, which informs the
 *        application that the buffer is no more used by the Bluetooth stack.
 * @retval Value indicating success or error code.
 */
tBleStatus ll_set_scan_reponse_data_ptr(uint16_t Advertising_Handle,
                                        uint16_t Scan_Response_Data_Length,
                                        uint8_t Scan_Response_Data[]);
/**
 * @brief Retrieves info about an existing advertising set.
 * @param Advertising_Handle Used to identify an advertising set.
 *        Values:
 *        - 0x0000 ... 0x00EF
 * @param[out] Adv_Enabled If advertising is enabled for the given advertising
 *             handle.
 * @param[out] Periodic_Adv_Configured If periodic advertising has been
 *             configured for the given advertising handle.
 * @param[out] Advertising_Event_Properties Advertising event properties that
 *             have been previously set for the advertising set.
 * @retval Value indicating success or error code.
 */
tBleStatus ll_get_advertising_info(uint16_t Advertising_Handle,
                                   BOOL *Adv_Enabled,
                                   BOOL *Periodic_Adv_Configured,
                                   uint16_t *Advertising_Event_Properties);
/**
 * @brief Set data pointer for periodic extended advertising data.
 * @param Advertising_Handle Used to identify an advertising set. This parameter
 *        is only meaningful if Extended Advertising Feature is enabled.
 *        Values:
 *        - 0x0000 ... 0x00EF
 * @param Advertising_Data_Length Length of periodic advertising data.
 * @param Advertising_Data Pointer to the buffer containing properly formatted
 *        periodic advertising data (see Core v5.2 Vol 3, part C, chapter 11).
 *        Its content must not change, until an
 *        aci_hal_adv_scan_resp_data_update_event is received, which informs the
 *        application that the buffer is no more used by the Bluetooth stack.
 * @retval Value indicating success or error code.
 */
tBleStatus ll_set_periodic_advertising_data_ptr(uint16_t Advertising_Handle,
                                                uint16_t Advertising_Data_Length,
                                                uint8_t Advertising_Data[]);
/**
 * @brief Function to get the value of the last anchor point for the given
 *        connection.
 * @param Connection_Handle
 * @param[out] Event_Counter
 * @param[out] Anchor_Point
 * @retval Value indicating success or error code.
 */
tBleStatus aci_hal_get_anchor_point(uint16_t Connection_Handle,
                                    uint16_t *Event_Counter,
                                    uint32_t *Anchor_Point);
/**
 * @}
 */

/**
 *@addtogroup GAP GAP
 *@brief Generic Access Profile
 *@{
 */
/**
 *@defgroup GAP_Commands GAP Commands
 *@brief Commands for GAP layer
 *@{
 */
/**
 * @brief Set the IO capabilities of the device. This command cannot be sent
 *        during a pairing procedure.
 * @param IO_Capability IO capability of the device.
 *        Values:
 *        - 0x00: IO_CAP_DISPLAY_ONLY
 *        - 0x01: IO_CAP_DISPLAY_YES_NO
 *        - 0x02: IO_CAP_KEYBOARD_ONLY
 *        - 0x03: IO_CAP_NO_INPUT_NO_OUTPUT
 *        - 0x04: IO_CAP_KEYBOARD_DISPLAY
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_set_io_capability(uint8_t IO_Capability);
/**
 * @brief Set the authentication requirements for the device. If the command is
 *        given during pairing, the command returns  BLE_STATUS_NOT_ALLOWED.
 * @param Bonding_Mode Bonding mode. Only if bonding is enabled (0x01), the
 *        bonding information is stored in flash
 *        Values:
 *        - 0x00: NO_BONDING
 *        - 0x01: BONDING
 * @param MITM_Mode MITM mode.
 *        Values:
 *        - 0x00: MITM_PROTECTION_NOT_REQUIRED
 *        - 0x01: MITM_PROTECTION_REQUIRED
 * @param SC_Support LE Secure connections support. - 0x00: Secure Connections
 *        Pairing not supported - 0x01: Secure Connections Pairing supported but
 *        optional - 0x02: Secure Connections Pairing supported and mandatory
 *        (SC Only Mode)
 *        Values:
 *        - 0x00: SC_IS_NOT_SUPPORTED
 *        - 0x01: SC_IS_SUPPORTED
 *        - 0x02: SC_IS_MANDATORY
 * @param KeyPress_Notification_Support Keypress notification support
 *        Values:
 *        - 0x00: KEYPRESS_IS_NOT_SUPPORTED
 *        - 0x01: KEYPRESS_IS_SUPPORTED
 * @param Min_Encryption_Key_Size Minimum encryption key size to be used during
 *        pairing
 *        Values:
 *        - 7 ... 16
 * @param Max_Encryption_Key_Size Maximum encryption key size to be used during
 *        pairing
 *        Values:
 *        - 7 ... 16
 * @param Use_Fixed_Pin Use or not fixed pin. If set to 0x00, then during the
 *        pairing process the application will not be requested for a pin
 *        (Fixed_Pin will be used). If set to 0x01, then during pairing process
 *        if a passkey is required the application will be notified
 *        Values:
 *        - 0x00: USE_FIXED_PIN_FOR_PAIRING
 *        - 0x01: DONOT_USE_FIXED_PIN_FOR_PAIRING
 * @param Fixed_Pin Fixed pin to be used during pairing if MIMT protection is
 *        enabled. Any random value between 0 to 999999
 *        Values:
 *        - 0 ... 999999
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_set_authentication_requirement(uint8_t Bonding_Mode,
                                                  uint8_t MITM_Mode,
                                                  uint8_t SC_Support,
                                                  uint8_t KeyPress_Notification_Support,
                                                  uint8_t Min_Encryption_Key_Size,
                                                  uint8_t Max_Encryption_Key_Size,
                                                  uint8_t Use_Fixed_Pin,
                                                  uint32_t Fixed_Pin);
/**
 * @brief This command should be send by the host in response to @ref
 *        aci_gap_pass_key_req_event event. The command parameter contains the
 *        pass key which will be used during the pairing process.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Pass_Key Pass key that will be used during the pairing process.  Must
 *        be a six-digit decimal number.
 *        Values:
 *        - 0 ... 999999
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_pass_key_resp(uint16_t Connection_Handle,
                                 uint32_t Pass_Key);
/**
 * @brief Initialize the GAP layer. Register the GAP service with the GATT.
 *        Depending on the role, presence of standard GAP characteristics will
 *        be checked (Device Name, Appearance, Peripheral Preferred Connection
 *        Parameters).  WARNING: A section of the Flash memory is used by this
 *        procedure. When this section is empty, data are written inside. This
 *        normally happens once during the lifetime of the device, when the
 *        command is executed for the first time (unless the section is erased).
 *        Do not power off the device while this function is writing into Flash
 *        memory.
 * @param Role Bitmap of allowed roles.
 *        Flags:
 *        - 0x01: Peripheral
 *        - 0x02: Broadcaster
 *        - 0x04: Central
 *        - 0x08: Observer
 * @param Privacy_Type Specify if privacy is enabled or not and which one .
 *        Values:
 *        - 0x00: Privacy disabled
 *        - 0x01: Privacy host enabled
 *        - 0x02: Privacy controller enabled
 * @param Device_Name_Char_Len Length of the device name characteristic
 *        Values:
 *        - 0 ... 248
 * @param Identity_Address_Type Specify which address has to be used as Identity
 *        Address. 0x00: The public address is used as identity address 0x01:
 *        The static random address is used as identity address
 *        Values:
 *        - 0x00: Public Address
 *        - 0x01: Static Random Address
 * @param[out] Service_Handle Handle of the GAP service
 * @param[out] Dev_Name_Char_Handle Device Name Characteristic handle
 * @param[out] Appearance_Char_Handle Appearance Characteristic handle
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_init(uint8_t Role,
                        uint8_t Privacy_Type,
                        uint8_t Device_Name_Char_Len,
                        uint8_t Identity_Address_Type,
                        uint16_t *Service_Handle,
                        uint16_t *Dev_Name_Char_Handle,
                        uint16_t *Appearance_Char_Handle);
/**
 * @brief Send a slave security request to the master. This command has to be
 *        issued to notify the master of the security requirements of the slave.
 *        The master may encrypt the link, initiate the pairing procedure, or
 *        reject the request.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_slave_security_req(uint16_t Connection_Handle);
/**
 * @brief This command can be used to get the current security settings of the
 *        device.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param[out] Security_Mode Security mode.
 *             Values:
 *             - 0x01: Security Mode 1
 *             - 0x02: Security Mode 2
 * @param[out] Security_Level Security Level.
 *             Values:
 *             - 0x01: Security Level 1
 *             - 0x02: Security Level 2
 *             - 0x03: Security Level 3
 *             - 0x04: Security Level 4
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_get_security_level(uint16_t Connection_Handle,
                                      uint8_t *Security_Mode,
                                      uint8_t *Security_Level);
/**
 * @brief It allows masking events from the GAP. The default configuration is
 *        all the events masked.
 * @param GAP_Evt_Mask GAP event mask. Default: 0xFFFF.
 *        Flags:
 *        - 0x0000: No events
 *        - 0x0001: ACI_GAP_LIMITED_DISCOVERABLE_EVENT
 *        - 0x0002: ACI_GAP_PAIRING_COMPLETE_EVENT
 *        - 0x0004: ACI_GAP_PASS_KEY_REQ_EVENT
 *        - 0x0008: ACI_GAP_AUTHORIZATION_REQ_EVENT
 *        - 0x0010: ACI_GAP_SLAVE_SECURITY_INITIATED_EVENT
 *        - 0x0020: ACI_GAP_BOND_LOST_EVENT
 *        - 0x0080: ACI_GAP_PROC_COMPLETE_EVENT
 *        - 0x0100: ACI_L2CAP_CONNECTION_UPDATE_REQ_EVENT
 *        - 0x0200: ACI_L2CAP_CONNECTION_UPDATE_RESP_EVENT
 *        - 0x0400: ACI_L2CAP_PROC_TIMEOUT_EVENT
 *        - 0x0800: ACI_GAP_ADDR_NOT_RESOLVED_EVENT
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_set_event_mask(uint16_t GAP_Evt_Mask);
/**
 * @brief Command the controller to terminate the connection. A @ref
 *        hci_disconnection_complete_event event will be generated when the link
 *        is disconnected. It is important to leave an 100 ms blank window
 *        before sending any new command (including system hardware reset),
 *        since immediately after @ref hci_disconnection_complete_event event,
 *        system could save important information in non volatile memory.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Reason The reason for ending the connection.
 *        Values:
 *        - 0x05: Authentication Failure
 *        - 0x13: Remote User Terminated Connection
 *        - 0x14: Remote Device Terminated Connection due to Low Resources
 *        - 0x15: Remote Device Terminated Connection due to Power Off
 *        - 0x1A: Unsupported Remote Feature
 *        - 0x3B: Unacceptable Connection Parameters
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_terminate(uint16_t Connection_Handle,
                             uint8_t Reason);
/**
 * @brief Clear the security database. All the devices in the security database
 *        will be removed. ATTENTION: It is strongly recommended not to give
 *        this command during intense radio activity (e.g. during advertising or
 *        connection with short intervals, i.e. less than 30 ms, or during
 *        scanning), since it will trigger an erase of a Flash sector. After
 *        this command, all devices previously recorded in the bonding table and
 *        connected when command has been submitted will remain connected,
 *        preserving authentication and encryption of the link.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_clear_security_db(void);
/**
 * @brief Allows the security manager to complete the pairing procedure and re-
 *        bond with the master. This command should be given by the application
 *        when it receives the ACI_GAP_BOND_LOST_EVENT if it wants the re-
 *        bonding to happen successfully. If this command is not given on
 *        receiving the event, the bonding procedure will timeout.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_allow_rebond(uint16_t Connection_Handle);
/**
 * @brief Creates a direct connection to a device.
 * @param Initiating_PHY PHYs that will be used for initiating the connection.
 *        Flags:
 *        - 0x01: LE_1M_PHY_BIT
 *        - 0x04: LE_CODED_PHY_BIT
 * @param Peer_Address_Type The Peer_Address_Type parameter indicates the type
 *        of address used in the connectable advertisement sent by the peer. 0:
 *        Public Device Address or Public Identity Address 1: Random Device
 *        Address or Random (static) Identity Address
 *        Values:
 *        - 0x00: Public Address
 *        - 0x01: Random Address
 * @param Peer_Address Public Device Address, Random Device Address, Public
 *        Identity Address, or Random (static) Identity Address of the device to
 *        be connected.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_create_connection(uint8_t Initiating_PHY,
                                     uint8_t Peer_Address_Type,
                                     uint8_t Peer_Address[6]);
/**
 * @brief Terminate the specified GAP procedure. An @ref
 *        aci_gap_proc_complete_event event is generated when the procedure has
 *        been completed, with the procedure code set to the corresponding
 *        procedure.
 * @param Procedure_Code Code identifying the procedure.
 *        Values:
 *        - 0x00: GAP_LIMITED_DISCOVERY_PROC
 *        - 0x01: GAP_GENERAL_DISCOVERY_PROC
 *        - 0x02: GAP_AUTO_CONNECTION_ESTABLISHMENT_PROC
 *        - 0x03: GAP_GENERAL_CONNECTION_ESTABLISHMENT_PROC
 *        - 0x04: GAP_SELECTIVE_CONNECTION_ESTABLISHMENT_PROC
 *        - 0x05: GAP_OBSERVATION_PROC
 *        - 0x06: GAP_DIRECT_CONNECTION_ESTABLISHMENT_PROC
 *        - 0x07: GAP_NAME_DISCOVERY_PROC
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_terminate_proc(uint8_t Procedure_Code);
/**
 * @brief Start the connection update procedure (only when role is Master). A
 *        @ref hci_le_connection_update is called. On completion of the
 *        procedure, an @ref hci_le_connection_update_complete_event event is
 *        returned to the upper layer.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Conn_Interval_Min Minimum value for the connection event interval.
 *        This shall be less than or equal to Conn_Interval_Max. Time = N * 1.25
 *        msec.
 *        Values:
 *        - 0x0006 (7.50 ms)  ... 0x0C80 (4000.00 ms) 
 * @param Conn_Interval_Max Maximum value for the connection event interval.
 *        This shall be greater than or equal to Conn_Interval_Min. Time = N *
 *        1.25 msec.
 *        Values:
 *        - 0x0006 (7.50 ms)  ... 0x0C80 (4000.00 ms) 
 * @param Conn_Latency Slave latency for the connection in number of connection
 *        events.
 *        Values:
 *        - 0x0000 ... 0x01F3
 * @param Supervision_Timeout Supervision timeout for the LE Link. It shall be a
 *        multiple of 10 ms and larger than (1 + connSlaveLatency) *
 *        connInterval * 2. Time = N * 10 msec.
 *        Values:
 *        - 0x000A (100 ms)  ... 0x0C80 (32000 ms) 
 * @param Minimum_CE_Length Information parameter about the minimum length of
 *        connection needed for this LE connection. Time = N * 0.625 msec.
 * @param Maximum_CE_Length Information parameter about the maximum length of
 *        connection needed for this LE connection. Time = N * 0.625 msec.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_start_connection_update(uint16_t Connection_Handle,
                                           uint16_t Conn_Interval_Min,
                                           uint16_t Conn_Interval_Max,
                                           uint16_t Conn_Latency,
                                           uint16_t Supervision_Timeout,
                                           uint16_t Minimum_CE_Length,
                                           uint16_t Maximum_CE_Length);
/**
 * @brief Send the SM pairing request to start a pairing process. The
 *        authentication requirements and IO capabilities should be set before
 *        issuing this command using the @ref aci_gap_set_io_capability and @ref
 *        aci_gap_set_authentication_requirement commands. A @ref
 *        aci_gap_pairing_complete_event event is returned after the pairing
 *        process is completed.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Force_Rebond If 1, Pairing request will be sent even if the device was
 *        previously bonded,  otherwise pairing request is not sent.
 *        Values:
 *        - 0x00: NO
 *        - 0x01: YES
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_send_pairing_req(uint16_t Connection_Handle,
                                    uint8_t Force_Rebond);
/**
 * @brief This command tries to resolve the address provided with the IRKs
 *        present in its database. If the address is resolved successfully with
 *        any one of the IRKs present in the database, it returns success and
 *        also the corresponding public/static random address stored with the
 *        IRK in the database.
 * @param Address Address to be resolved
 * @param[out] Actual_Address The public or static random address of the peer
 *             device, distributed during pairing phase.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_resolve_private_addr(uint8_t Address[6],
                                        uint8_t Actual_Address[6]);
/**
 * @brief This command returns the identity addresses of the bonded devices.
 * @param Offset Index of the first record to be returned.
 * @param Max_Num_Of_Addresses Used to specify the maximum number of devices to
 *        be returned.
 * @param[out] Num_of_Addresses The number of bonded devices returned by this
 *             command.
 * @param[out] Bonded_Device_Entry See @ref Bonded_Device_Entry_t
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_get_bonded_devices(uint8_t Offset,
                                      uint8_t Max_Num_Of_Addresses,
                                      uint8_t *Num_of_Addresses,
                                      Bonded_Device_Entry_t Bonded_Device_Entry[]);
/**
 * @brief The command finds whether the device, whose address is specified in
 *        the command, is bonded. If the device is using a resolvable private
 *        address and it has been bonded, then the command will return
 *        BLE_STATUS_SUCCESS.
 * @param Peer_Address_Type Address type.
 *        Values:
 *        - 0x00: Public Device Address
 *        - 0x01: Random Device Address
 * @param Peer_Address Address used by the peer device while advertising
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_is_device_bonded(uint8_t Peer_Address_Type,
                                    uint8_t Peer_Address[6]);
/**
 * @brief This command allows the User to validate/confirm or not the Numeric
 *        Comparison value showed through the
 *        ACI_GAP_Numeric_Comparison_Value_Event.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Confirm_Yes_No 0 : The Numeric Values showed on both local and peer
 *        device are different! 1 : The Numeric Values showed on both local and
 *        peer device are equal!
 *        Values:
 *        - 0x00: No
 *        - 0x01: YES
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_numeric_comparison_value_confirm_yesno(uint16_t Connection_Handle,
                                                          uint8_t Confirm_Yes_No);
/**
 * @brief This command permits to signal to the Stack the input type detected
 *        during Passkey input.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Input_Type Passkey input type detected
 *        Values:
 *        - 0x00: Passkey entry started
 *        - 0x01: Passkey digit entered
 *        - 0x02: Passkey digit erased
 *        - 0x03: Passkey cleared
 *        - 0x04: Passkey entry completed
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_passkey_input(uint16_t Connection_Handle,
                                 uint8_t Input_Type);
/**
 * @brief This command is sent by the User to get (i.e. to extract from the
 *        Stack) the OOB data generated by the Stack itself. In a complete
 *        system (i.e. having an OOB channel fully handled) this command should
 *        be invoked by the OOB Channel manager to require the local OOB data
 *        (hence without user interaction) to be sent via OOB to the remote peer
 *        candidate device. The requested OOB data are returned in response to
 *        the incoming command. The OOB data are not generated on the fly, but
 *        they are already available in the Stack.
 * @param OOB_Data_Type OOB Data type. - 0x00: Legacy Privacy (LP) v.4.1 TK
 *        (Temporary Key) - 0x01: Secure Connections (SC) v.4.2 Random value r
 *        used for generation of Confirm - 0x02: Secure Connections (SC) v.4.2
 *        Confirm value C generated through AES-CMAC-128 based cryptographic
 *        function: C=f4(PKx, PKx, r, 0)
 *        Values:
 *        - 0x00: SM_TK
 *        - 0x01: SM_RANDOM_VALUE
 *        - 0x02: SM_CONFIRM_VALUE
 * @param[out] Address_Type Identity address type.
 *             Values:
 *             - 0x00: Public Identity Address
 *             - 0x01: Random (static) Identity Address
 * @param[out] Address Public or Random (static) address of this  device
 * @param[out] OOB_Data_Len Length of OOB Data carried by next data field
 * @param[out] OOB_Data OOB Data to be exported via OOB.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_get_oob_data(uint8_t OOB_Data_Type,
                                uint8_t *Address_Type,
                                uint8_t Address[6],
                                uint8_t *OOB_Data_Len,
                                uint8_t OOB_Data[16]);
/**
 * @brief This command is sent (by the User) to input the OOB data arrived via
 *        OOB communication. It may be sent to set either the OOB Authentication
 *        data of the Local device, or the data received via OOB by the Remote
 *        peer candidate device. It can be used with OOB_Data_Len set to 0 to
 *        generate OOB authentication data for Secure Connections. In a complete
 *        system (i.e. having an OOB channel fully handled) this command should
 *        be invoked by the OOB Channel manager when receiving the OOB data
 *        (hence without user interaction). Since the BLE stack v 2.x
 *        implementation supports just one entry for the Remote peer candidate
 *        list containing the OOB data, at every command invocation the data
 *        existing in that entry are overwritten.
 * @param Device_Type OOB Device type:  - 0x00: The Address information are
 *        ignored.    - OOB_Data_Len= 0x00: this triggers the automatic
 *        regeneration of OOB Authentication data (for Secure Connections only;
 *        a ECDH-Public Key must).    - OOB_Data_Len in [0..16]: the OOB_Data
 *        carried by the command will overwrite the current local Authentication
 *        OOB Data.  - 0x01: The Address information is used to search the entry
 *        of the Remote peer candidate list containing the OOB data for that
 *        specific remote device; if no entry exists, the a new entry is used,
 *        if available (current implementation supports just 1 entry in this
 *        list).    - OOB_Data_Len in [0..16]: the OOB_Data carried by the
 *        command overwrites (if present) the remote Authentication OOB Data.
 *        Values:
 *        - 0x00: Local device
 *        - 0x01: Remote device
 * @param Address_Type Identity address type.
 *        Values:
 *        - 0x00: Public Identity Address
 *        - 0x01: Random (static) Identity Address
 * @param Address Public or Random (static) address of the peer device
 * @param OOB_Data_Type OOB Data type. - 0x00: Legacy Privacy (LP) v.4.1 TK
 *        (Temporary Key) - 0x01: Secure Connections (SC) v.4.2 Random value r
 *        used for generation of Confirm - 0x02: Secure Connections (SC) v.4.2
 *        Confirm value C generated through AES-CMAC-128 based cryptographic
 *        function: C=f4(PKx, PKx, r, 0)
 *        Values:
 *        - 0x00: SM_TK
 *        - 0x01: SM_RANDOM_VALUE
 *        - 0x02: SM_CONFIRM_VALUE
 * @param OOB_Data_Len Length of OOB Data carried by next data field
 *        Values:
 *        - 0x00 ... 0x10
 * @param OOB_Data OOB Data to be exported via OOB.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_set_oob_data(uint8_t Device_Type,
                                uint8_t Address_Type,
                                uint8_t Address[6],
                                uint8_t OOB_Data_Type,
                                uint8_t OOB_Data_Len,
                                uint8_t OOB_Data[16]);
/**
 * @brief This command can be used to remove a specified device from the bonding
 *        table. ATTENTION: the device removed from the Bonding Table will
 *        preserve its connection and authentication, until explicit
 *        disconnection is requested by the user.
 * @param Peer_Identity_Address_Type Identity address type.
 *        Values:
 *        - 0x00: Public Identity Address
 *        - 0x01: Random (static) Identity Address
 * @param Peer_Identity_Address Public or Random (static) Identity address of
 *        the peer device
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_remove_bonded_device(uint8_t Peer_Identity_Address_Type,
                                        uint8_t Peer_Identity_Address[6]);
/**
 * @brief This commands configures the advertising parameters for the legacy
 *        advertising or for a given extended advertising set.
 * @param Advertising_Handle Used to identify an advertising set. This parameter
 *        is only meaningful if Extended Advertising Feature is enabled.
 *        Values:
 *        - 0x00 ... 0xEF
 * @param Discoverable_Mode Specifies the discoverable mode of the device.
 *        Values:
 *        - 0: Not Discoverable
 *        - 1: Limited Discoverable
 *        - 2: General Discoverable
 *        - 3: Broadcast
 * @param Advertising_Event_Properties The Advertising_Event_Properties
 *        parameter describes the type of advertising event that is being
 *        configured and its basic properties according to V5.1, Vol 2, Part E,
 *        section 7.8.53.
 *        Flags:
 *        - 0x0001: Connectable
 *        - 0x0002: Scannable
 *        - 0x0004: Directed
 *        - 0x0008: High Duty Cycle Directed Connectable
 *        - 0x0010: Legacy
 *        - 0x0020: Anonymous
 *        - 0x0040: Include TX Power
 * @param Primary_Advertising_Interval_Min Minimum advertising interval for
 *        undirected and low duty cycle directed advertising. Time = N * 0.625
 *        msec.
 *        Values:
 *        - 0x00000020 (20.000 ms)  ... 0x00FFFFFF (10485759.375 ms) 
 * @param Primary_Advertising_Interval_Max Maximum advertising interval for
 *        undirected and low duty cycle directed advertising. Time = N * 0.625
 *        msec.
 *        Values:
 *        - 0x00000020 (20.000 ms)  ... 0x00FFFFFF (10485759.375 ms) 
 * @param Primary_Advertising_Channel_Map It is a bit field that indicates the
 *        advertising channels that shall be used when transmitting advertising
 *        packets.
 *        Flags:
 *        - 0x01: CH_37
 *        - 0x02: CH_38
 *        - 0x04: CH_39
 * @param Peer_Address_Type The peer address type.
 *        Values:
 *        - 0x00: Public
 *        - 0x01: Random
 * @param Peer_Address Public Device Address, Random Device Address, Public
 *        Identity Address, or Random (static) Identity Address of the device to
 *        be connected.
 * @param Advertising_Filter_Policy Advertising Filter Policy. If Directed
 *        advertising is selected, the Peer_Address_Type and Peer_Address shall
 *        be valid and the Advertising_Filter_Policy parameter shall be ignored.
 *        0x00 Process scan and connection requests from all devices (i.e., the
 *        White List is not in use) 0x01 Process connection requests from all
 *        devices and scan requests only from devices that are in the White List
 *        0x02 Process scan requests from all devices and connection requests
 *        only from devices that are in the White List. 0x03 Process scan and
 *        connection requests only from devices in the White List. All other
 *        values Reserved for future use
 *        Values:
 *        - 0x00: Scan and Connection requests from any
 *        - 0x01: Connection requests from any, scan requests from White List only
 *        - 0x02: Scan requests from any, connection requests from White List only
 *        - 0x03: Scan and connection requests from White
List only
 * @param Advertising_Tx_Power The Advertising_Tx_Power parameter indicates the
 *        maximum power level at which the advertising packets are to be
 *        transmitted on the advertising channels. The Controller shall choose a
 *        power level lower than or equal to the one specified by the Host.
 *        (Units: dBm). This parameter is ignored if extended advertising is not
 *        enabled.
 *        Values:
 *        - 127: No preference
 *        - -127 ... 126
 * @param Primary_Advertising_PHY The Primary_Advertising_PHY parameter
 *        indicates the PHY on which the advertising packets are transmitted on
 *        the primary advertising channel. If legacy advertising PDUs are being
 *        used, the Primary_Advertising_PHY shall indicate the LE 1M PHY. This
 *        parameter is ignored if extended advertising is not enabled.
 *        Values:
 *        - 0x01: LE_1M_PHY
 *        - 0x03: LE_CODED_PHY
 * @param Secondary_Advertising_Max_Skip The Secondary_Advertising_Max_Skip
 *        parameter is the maximum number of advertising events that can be
 *        skipped before the AUX_ADV_IND can be sent. This parameter is ignored
 *        if extended advertising is not enabled. 0x00 AUX_ADV_IND shall be sent
 *        prior to the next advertising event 0x01-0xFF Maximum advertising
 *        events the Controller can skip before sending the AUX_ADV_IND packets
 *        on the secondary advertising channel
 * @param Secondary_Advertising_PHY The Secondary_Advertising_PHY parameter
 *        indicates the PHY on which the advertising packets are be transmitted
 *        on the secondary advertising channel. This parameter is ignored if
 *        extended advertising is not enabled.
 *        Values:
 *        - 0x01: LE_1M_PHY
 *        - 0x02: LE_2M_PHY
 *        - 0x03: LE_CODED_PHY
 * @param Advertising_SID The Advertising_SID parameter specifies the value to
 *        be transmitted in the Advertising SID subfield of the ADI field of the
 *        Extended Header of those advertising channel PDUs that have an ADI
 *        field. If the advertising set only uses PDUs that do not contain an
 *        ADI field, Advertising_SID is ignored. This parameter is ignored if
 *        extended advertising is not enabled.
 *        Values:
 *        - 0x00 ... 0x0F
 * @param Scan_Request_Notification_Enable The Scan_Request_Notification_Enable
 *        parameter indicates whether the Controller shall send notifications
 *        upon the receipt of a scan request PDU that is in response to an
 *        advertisement from the specified advertising set that contains its
 *        device address and is from a scanner that is allowed by the
 *        advertising filter policy. This parameter is ignored if extended
 *        advertising is not enabled.
 *        Values:
 *        - 0x00: Scan request notifications disabled
 *        - 0x01: Scan request notifications enabled
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_set_advertising_configuration(uint8_t Advertising_Handle,
                                                 uint8_t Discoverable_Mode,
                                                 uint16_t Advertising_Event_Properties,
                                                 uint32_t Primary_Advertising_Interval_Min,
                                                 uint32_t Primary_Advertising_Interval_Max,
                                                 uint8_t Primary_Advertising_Channel_Map,
                                                 uint8_t Peer_Address_Type,
                                                 uint8_t Peer_Address[6],
                                                 uint8_t Advertising_Filter_Policy,
                                                 int8_t Advertising_Tx_Power,
                                                 uint8_t Primary_Advertising_PHY,
                                                 uint8_t Secondary_Advertising_Max_Skip,
                                                 uint8_t Secondary_Advertising_PHY,
                                                 uint8_t Advertising_SID,
                                                 uint8_t Scan_Request_Notification_Enable);
/**
 * @brief The LE_Set_Extended_Advertising_Enable command is used to request the
 *        Controller to enable or disable one or more advertising sets using the
 *        advertising sets identified by the Advertising_Handle[i] parameter.
 *        The Controller manages the timing of advertisements in accordance with
 *        the advertising parameters given in the
 *        LE_Set_Extended_Advertising_Parameters command. Only Enable parameter
 *        is used if extended advertising feature is disabled through modular
 *        configuration (CONTROLLER_EXT_ADV_SCAN_ENABLED=0).
 * @param Enable It allows to enable or disable one or more advertising sets
 *        using the advertising sets identified by the Advertising_Handle[i]
 *        parameter.
 *        Values:
 *        - 0x00: Disable
 *        - 0x01: Enable
 * @param Number_of_Sets The Number_of_Sets parameter is the number of
 *        advertising sets contained in the parameter arrays. 0x00: Disable all
 *        advertising sets 0x01 to 0x3F: Number of advertising sets to enable or
 *        disable. Ignored if extended advertising feature is disabled through
 *        modular configuration (CONTROLLER_EXT_ADV_SCAN_ENABLED=0).
 *        Values:
 *        - 0x00: Disable all sets
 *        - 0x01 ... 0x3F
 * @param Advertising_Set_Parameters See @ref Advertising_Set_Parameters_t
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_set_advertising_enable(uint8_t Enable,
                                          uint8_t Number_of_Sets,
                                          Advertising_Set_Parameters_t Advertising_Set_Parameters[]);
/**
 * @brief The ACI_GAP_SET_SCAN_CONFIGURATION function configures the scan
 *        parameters for a given PHY. To configure more than one PHY, this
 *        function must be called more times.
 * @param Filter_Duplicates The Filter_Duplicates parameter controls whether the
 *        Link Layer should filter out duplicate advertising reports (filtering
 *        duplicates enabled) to the Host or if the Link Layer should generate
 *        advertising reports for each packet received (filtering duplicates
 *        disabled). See [Vol 6] Part B, Section 4.4.3.5.
 *        Values:
 *        - 0x00: Duplicate filtering disabled
 *        - 0x01: Duplicate filtering enabled
 *        - 0x02: Duplicate filtering enabled, reset for each scan period
 * @param Scanning_Filter_Policy 0x00 Accept all advertisement packets. Directed
 *        advertising packets which are not addressed for this device shall be
 *        ignored. 0x01 Ignore advertisement packets from devices not in the
 *        White List Only. Directed advertising packets which are not addressed
 *        for this device shall be ignored 0x02 Accept all undirected
 *        advertisement packets. Directed advertisement packets where initiator
 *        address is a RPA and  Directed advertisement packets addressed to this
 *        device shall be accepted. 0x03 Accept all undirected advertisement
 *        packets from devices that are in the White List.Directed advertisement
 *        packets where initiator address is RPA and Directed advertisement
 *        packets addressed to this device shall be accepted.
 *        Values:
 *        - 0x00: Accept All
 *        - 0x01: White List Only
 *        - 0x02: Accept All (use resolving list)
 *        - 0x03: White List Only (use resolving list)
 * @param Scanning_PHY PHY that is going to be configured. Only one bit can be
 *        set.
 *        Flags:
 *        - 0x01: LE_1M_PHY_BIT
 *        - 0x04: LE_CODED_PHY_BIT
 * @param Scan_Type The Scan_Type parameter specifies the type of scan to
 *        perform. 0: Passive Scanning. No scan request PDUs shall be sent. 1:
 *        Active Scanning. Scan request PDUs may be sent.
 *        Values:
 *        - 0x00: Passive Scanning
 *        - 0x01: Active Scanning
 * @param Scan_Interval Time interval from when the Controller started its last
 *        scan until it begins the subsequent scan on the primary advertising
 *        physical channel.  Time = N * 0.625 ms
 *        Values:
 *        - 0x0004 (2.500 ms)  ... 0xFFFF (40959.375 ms) 
 * @param Scan_Window Time interval from when the Controller started its last
 *        scan until it begins the subsequent scan on the primary advertising
 *        physical channel. Time = N * 0.625 msec.
 *        Values:
 *        - 0x0004 (2.500 ms)  ... 0xFFFF (40959.375 ms) 
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_set_scan_configuration(uint8_t Filter_Duplicates,
                                          uint8_t Scanning_Filter_Policy,
                                          uint8_t Scanning_PHY,
                                          uint8_t Scan_Type,
                                          uint16_t Scan_Interval,
                                          uint16_t Scan_Window);
/**
 * @brief This function configures the connection parameters. To configure more
 *        than one PHY, this function must be called more times.
 * @param Initiating_PHY PHY that is going to be configured. Only one bit can be
 *        set.
 *        Flags:
 *        - 0x01: LE_1M_PHY_BIT
 *        - 0x02: LE_2M_PHY_BIT
 *        - 0x04: LE_CODED_PHY_BIT
 * @param Conn_Interval_Min Minimum value for the connection event interval.
 *        This shall be less than or equal to Conn_Interval_Max. Time = N * 1.25
 *        msec.
 *        Values:
 *        - 0x0006 (7.50 ms)  ... 0x0C80 (4000.00 ms) 
 * @param Conn_Interval_Max Maximum value for the connection event interval.
 *        This shall be greater than or equal to Conn_Interval_Min. Time = N *
 *        1.25 msec.
 *        Values:
 *        - 0x0006 (7.50 ms)  ... 0x0C80 (4000.00 ms) 
 * @param Conn_Latency Slave latency for the connection in number of connection
 *        events.
 *        Values:
 *        - 0x0000 ... 0x01F3
 * @param Supervision_Timeout Supervision timeout for the LE Link. It shall be a
 *        multiple of 10 ms and larger than (1 + connSlaveLatency) *
 *        connInterval * 2. Time = N * 10 msec.
 *        Values:
 *        - 0x000A (100 ms)  ... 0x0C80 (32000 ms) 
 * @param Minimum_CE_Length Information parameter about the minimum length of
 *        connection needed for this LE connection. Time = N * 0.625 msec.
 * @param Maximum_CE_Length Information parameter about the maximum length of
 *        connection needed for this LE connection. Time = N * 0.625 msec.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_set_connection_configuration(uint8_t Initiating_PHY,
                                                uint16_t Conn_Interval_Min,
                                                uint16_t Conn_Interval_Max,
                                                uint16_t Conn_Latency,
                                                uint16_t Supervision_Timeout,
                                                uint16_t Minimum_CE_Length,
                                                uint16_t Maximum_CE_Length);
/**
 * @brief Starts a GAP procedure according to the procedure code.
 * @param Procedure_Code Procedure to be started.
 *        Values:
 *        - 0x00: GAP_LIMITED_DISCOVERY_PROC
 *        - 0x01: GAP_GENERAL_DISCOVERY_PROC
 *        - 0x02: GAP_AUTO_CONNECTION_ESTABLISHMENT_PROC
 *        - 0x03: GAP_GENERAL_CONNECTION_ESTABLISHMENT_PROC
 *        - 0x04: GAP_SELECTIVE_CONNECTION_ESTABLISHMENT_PROC
 *        - 0x05: GAP_OBSERVATION_PROC
 * @param PHYs PHYs that will be used for Scanning or Initiating .
 *        Flags:
 *        - 0x01: LE_1M_PHY_BIT
 *        - 0x04: LE_CODED_PHY_BIT
 * @param Duration Ignored. Reserved for future use.
 * @param Period Ignored. Reserved for future use.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_start_procedure(uint8_t Procedure_Code,
                                   uint8_t PHYs,
                                   uint16_t Duration,
                                   uint16_t Period);
/**
 * @brief Creates a direct connection to a device and read the name
 *        characteristic.
 * @param PHYs PHYs that will be used for initiating the connection.
 *        Flags:
 *        - 0x01: LE_1M_PHY_BIT
 *        - 0x04: LE_CODED_PHY_BIT
 * @param Peer_Address_Type The Peer_Address_Type parameter indicates the type
 *        of address used in the connectable advertisement sent by the peer. 0:
 *        Public Device Address or Public Identity Address 1: Random Device
 *        Address or Random (static) Identity Address
 *        Values:
 *        - 0x00: Public Address
 *        - 0x01: Random Address
 * @param Peer_Address Public Device Address, Random Device Address, Public
 *        Identity Address, or Random (static) Identity Address of the device to
 *        be connected.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_discover_name(uint8_t PHYs,
                                 uint8_t Peer_Address_Type,
                                 uint8_t Peer_Address[6]);
/**
 * @brief Add specific device addresses to the white and/or resolving list.
 * @param Lists Select in which list the device addresses will be added: white
 *        list, resolving list or both.
 *        Flags:
 *        - 0x01: Withe List
 *        - 0x02: Resolving List
 * @param Clear_Lists Clear the selected lists before adding the device
 *        addresses.
 *        Values:
 *        - 0x00: Do not clear
 *        - 0x01: Clear before adding
 * @param Num_of_List_Entries Number of devices that have to be added to the
 *        whitelist.
 *        Values:
 *        - 0x00 ... 0xFF
 * @param List_Entry See @ref List_Entry_t
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_add_devices_to_white_and_resolving_list(uint8_t Lists,
                                                           uint8_t Clear_Lists,
                                                           uint8_t Num_of_List_Entries,
                                                           List_Entry_t List_Entry[]);
/**
 * @brief Clear the specified lists and add all bonded devices.
 * @param Lists Select in which list the device addresses will be added: white
 *        list, resolving list or both.
 *        Flags:
 *        - 0x01: White List
 *        - 0x02: Resolving List
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_configure_white_and_resolving_list(uint8_t Lists);
/**
 * @brief The GAP_Set_Periodic_Advertising_Configuration command is used by the
 *        Host to set the parameters for periodic advertising. See
 *        hci_le_set_periodic_advertising_parameters().
 * @param Advertising_Handle It is used to identify an advertising set
 *        Values:
 *        - 0x00 ... 0xEF: Used to identify a periodic advertisement
 * @param Periodic_Advertising_Interval_Min Minimum advertising interval for
 *        periodic advertising. Time = N * 1.25 ms; Time Range: 7.5ms to
 *        81.91875 s.
 *        Values:
 *        - 0x0006 (7.50 ms)  ... 0xFFFF (NaN) : Minimum advertising interval for periodic advertising.
 * @param Periodic_Advertising_Interval_Max Maximum advertising interval for
 *        periodic advertising. Time = N * 1.25 ms; Time Range: 7.5ms to
 *        81.91875 s.
 *        Values:
 *        - 0x0006 (7.50 ms)  ... 0xFFFF (NaN) : Maximum advertising interval for periodic advertising.
 * @param Periodic_Advertising_Properties The Periodic_Advertising_Properties
 *        parameter indicates which fields should be included in the advertising
 *        packet.
 *        Flags:
 *        - 0x0040: Include TxPower in the advertising PDU
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_set_periodic_advertising_configuration(uint8_t Advertising_Handle,
                                                          uint16_t Periodic_Advertising_Interval_Min,
                                                          uint16_t Periodic_Advertising_Interval_Max,
                                                          uint16_t Periodic_Advertising_Properties);
/**
 * @brief The GAP_Set_Periodic_Advertising_Enable command is used to request the
 *        Controller to enable or disable the periodic advertising for the
 *        advertising set specified by the Advertising_Handle parameter
 *        (ordinary advertising is not affected). See
 *        hci_le_set_periodic_advertising_enable().
 * @param Enable It is used to request the Controller to enable or disable the
 *        periodic advertising for the advertising set specified by the
 *        Advertising_Handle parameter (ordinary advertising is not affected).
 *        Values:
 *        - 0x00: Periodic advertising is disabled (default)
 *        - 0x01: Periodic advertising is enabled
 * @param Advertising_Handle
 *        Values:
 *        - 0x00 ... 0xEF: Used to identify an advertising set
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_set_periodic_advertising_enable(uint8_t Enable,
                                                   uint8_t Advertising_Handle);
/**
 * @brief The AGP_Periodic_Advertising_Create_Sync command is used to
 *        synchronize with periodic advertising from an advertiser and begin
 *        receiving periodic advertising packets. See
 *        hci_le_periodic_advertising_create_sync().
 * @param Options The Options parameter is used to determine whether the
 *        Periodic Advertiser List is used and whether
 *        HCI_Periodic_Advertising_Report events for this periodic advertising
 *        train are initially enabled or disabled. If the Periodic Advertiser
 *        List is not used, the Advertising_SID, Advertiser Address_Type, and
 *        Advertiser Address parameters specify the periodic advertising device
 *        to listen to; otherwise they shall be ignored.
 *        Flags:
 *        - 0x01: ): Use the Advertising_SID, Advertising_Address_Type, and Advertising_
Address parameters to determine which advertiser to listen to. 1:Use the Periodic Advertiser List to determine which advertiser to listen
to.
 *        - 0x02: 0: Reporting initially enabled. 1: Reporting initially disabled.
 * @param Advertising_SID The Advertising_SID parameter, if used, specifies the
 *        value that must match the Advertising SID subfield in the ADI field of
 *        the received advertisement for it to be used to synchronize.
 *        Values:
 *        - 0x00 ... 0x0F: Advertising SID subfield in the ADI field used to identify the Periodic
Advertising
 * @param Advertising_Address_Type Advertising address type
 *        Values:
 *        - 0x00: Public Device Address
 *        - 0x01: Random Device Address
 * @param Advertiser_Address Public Device Address, Random Device Address,
 *        Public Identity Address, or Random (static) Identity Address of the
 *        advertiser
 * @param Skip The Skip parameter specifies the number of consecutive periodic
 *        advertising packets that the receiver may skip after successfully
 *        receiving a periodic advertising packet.
 *        Values:
 *        - 0x0000 ... 0x01F3: The number of periodic advertising packets that can be skipped after a
successful receive
 * @param Sync_Timeout The Skip parameter specifies the number of consecutive
 *        periodic advertising packets that the receiver may skip after
 *        successfully receiving a periodic advertising packet. Time = N*10 ms;
 *        Time Range: 100 ms to 163.84 s.
 *        Values:
 *        - 0x000A (100 ms)  ... 0x4000 (163840 ms) : Synchronization timeout for the periodic advertising
 * @param Sync_CTE_Type The Sync_CTE_Type parameter specifies whether to only
 *        synchronize to periodic advertising with certain types of Constant
 *        Tone Extension (a value of 0 indicates that the presence or absence of
 *        a Constant Tone Extension is irrelevant). If the periodic advertising
 *        has the wrong type of Constant Tone Extension then: - If bit 0 of
 *        Options is set, the Controller shall ignore this address and SID and
 *        continue to search for other periodic advertisements. - Otherwise, the
 *        Controller shall cancel the synchronization with the error code
 *        Unsupported Remote Feature/Unsupported LMP Feature (0x1A).
 *        Flags:
 *        - 0x01: Do not sync to packets with an AoA Constant Tone Extension
 *        - 0x02: Do not sync to packets with an AoD Constant Tone Extension with 1 microsecond
slots
 *        - 0x04: Do not sync to packets with an AoD Constant Tone Extension with 2 microseconds
slots
 *        - 0x08: Do not sync to packets with a type 3 Constant Tone Extension (currently
reserved for future use)
 *        - 0x10: Do not sync to packets without a Constant Tone Extension
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_periodic_advertising_create_sync(uint8_t Options,
                                                    uint8_t Advertising_SID,
                                                    uint8_t Advertising_Address_Type,
                                                    uint8_t Advertiser_Address[6],
                                                    uint16_t Skip,
                                                    uint16_t Sync_Timeout,
                                                    uint8_t Sync_CTE_Type);
/**
 * @brief The GAP_Periodic_Advertising_Create_Sync_Cancel command is used to
 *        cancel the GAP_Periodic_Advertising_Create_Sync command while it is
 *        pending. See hci_le_periodic_advertising_create_sync_cancel().
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_periodic_advertising_create_sync_cancel(void);
/**
 * @brief The GAP_Remove_Advertising_Set command is used to remove an
 *        advertising set from the Controller. If the advertising set
 *        corresponding to the Advertising_Handle parameter does not exist, then
 *        the Controller shall return the error code Unknown Advertising
 *        Identifier (0x42). If advertising on the advertising set is enabled,
 *        then the Controller shall return the error code Command Disallowed
 *        (0x0C).
 * @param Advertising_Handle It is used to identify an advertising set
 *        Values:
 *        - 0x00 ... 0xEF: Used to identify an advertising set
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_remove_advertising_set(uint8_t Advertising_Handle);
/**
 * @brief The GAP_Clear_Advertising_Sets command is used to remove all existing
 *        advertising sets from the Controller. If advertising is enabled on any
 *        advertising set, then the Controller shall return the error code
 *        Command Disallowed (0x0C). Note: All advertising sets are cleared on
 *        HCI reset.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_clear_advertising_sets(void);
/**
 * @brief The GAP_Periodic_Advertising_Terminate_Sync command is used to stop
 *        reception of the periodic advertising identified by the Sync_Handle
 *        parameter. See hci_le_periodic_advertising_terminate_sync().
 * @param Sync_Handle It is used to identify the periodic advertiser
 *        Values:
 *        - 0x0000 ... 0x0EFF: Sync_Handle to be used to identify the periodic advertiser
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_periodic_advertising_terminate_sync(uint16_t Sync_Handle);
/**
 * @brief The GAP_Add_Device_To_Periodic_Advertiser_List command is used to add
 *        a single device to the Periodic Advertiser list stored in the
 *        Controller. See hci_le_add_device_to_periodic_advertiser_list().
 * @param Advertiser_Address_Type Advertiser Address Type
 *        Values:
 *        - 0x00: Public Device Address or Public Identity Address
 *        - 0x01: Random Device Address or Random (static) Identity Address
 * @param Advertiser_Address Public Device Address, Random Device Address,
 *        Public Identity Address, or Random (static) Identity Address of the
 *        advertiser
 * @param Advertising_SID Advertising SID subfield in the ADI field used to
 *        identify the Periodic Advertising
 *        Values:
 *        - 0x00 ... 0x0F: Advertising SID subfield in the ADI field used to identify the Periodic
Advertising
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_add_device_to_periodic_advertiser_list(uint8_t Advertiser_Address_Type,
                                                          uint8_t Advertiser_Address[6],
                                                          uint8_t Advertising_SID);
/**
 * @brief The GAP_Remove_Device_From_Periodic_Advertiser_List command is used to
 *        remove one device from the list of Periodic Advertisers stored in the
 *        Controller. See hci_le_remove_device_from_periodic_advertising_list().
 * @param Advertiser_Address_Type Advertising Address type
 *        Values:
 *        - 0x00: Public Device Address or Public Identity Address
 *        - 0x01: Random Device Address or Random (static) Identity Address
 * @param Advertiser_Address Public Device Address, Random Device Address,
 *        Public Identity Address, or Random (static) Identity Address of the
 *        advertiser
 * @param Advertising_SID It is used to  identify the Periodic Advertising
 *        Values:
 *        - 0x00 ... 0x0F: Advertising SID subfield in the ADI field used to identify the Periodic
Advertising
All other values Reserved for future
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_remove_device_from_periodic_advertising_list(uint8_t Advertiser_Address_Type,
                                                                uint8_t Advertiser_Address[6],
                                                                uint8_t Advertising_SID);
/**
 * @brief The GAP_Clear_Periodic_Advertiser_List command is used to remove all
 *        devices from the list of Periodic Advertisers in the Controller. See
 *        hci_le_clear_periodic_advertiser_list().
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_clear_periodic_advertiser_list(void);
/**
 * @brief The GAP_Read_Periodic_Advertiser_List_Size command is used to read the
 *        total number of Periodic Advertiser list entries that can be stored in
 *        the Controller. Note: The number of entries that can be stored is not
 *        fixed and the Controller can change it at any time (e.g., because the
 *        memory used to store the list can also be used for other purposes).
 * @param[out] Periodic_Advertiser_List_Size Total number of Periodic Advertiser
 *             list entries that can be stored in the Controller
 *             Values:
 *             - 0x1F ... 0xFF: Total number of Periodic Advertiser list entries that can be stored in the
Controller
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_read_periodic_advertiser_list_size(uint8_t *Periodic_Advertiser_List_Size);
/**
 * @brief The ACI_GAP_Set_Periodic_Advertising_Receive_Enable command will
 *        enable or disable reports for the periodic advertising train
 *        identified by the Sync_Handle parameter. See
 *        hci_le_set_periodic_advertising_receive_enable().
 * @param Sync_Handle Sync_Handle identifying the periodic advertising train
 *        Values:
 *        - 0x0000 ... 0x0EFF: Sync_Handle identifying the periodic advertising train
 * @param Enable It determines whether reporting is enabled or disabled
 *        Values:
 *        - 0x00: Reporting disabled
 *        - 0x01: Reporting enabled
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_set_periodic_advertising_receive_enable(uint16_t Sync_Handle,
                                                           uint8_t Enable);
/**
 * @brief The ACI_GAP_Periodic_Advertising_Sync_Transfer command is used to
 *        instruct the Controller to send synchronization information about the
 *        periodic advertising train identified by the Sync_Handle parameter to
 *        a connected device. See hci_le_periodic_advertising_sync_transfer().
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Service_Data The Service_Data parameter is a value provided by the
 *        Host for use by the Host of the peer device. It is not used by the
 *        Controller.
 * @param Sync_Handle Sync handle that identifies the synchronization
 *        information about the periodic advertising train.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_periodic_advertising_sync_transfer(uint16_t Connection_Handle,
                                                      uint16_t Service_Data,
                                                      uint16_t Sync_Handle);
/**
 * @brief The ACI_GAP_Periodic_Advertising_Set_Info_Transfer command is used to
 *        instruct the Controller to send synchronization information about the
 *        periodic advertising in an advertising set to a connected device. See
 *        hci_le_periodic_advertising_set_info_transfer()
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Service_Data It is a value provided by the Host to identify the
 *        periodic advertising train to the peer device. It is not used by the
 *        Controller.
 * @param Advertising_Handle It is used to identify an advertising set
 *        Values:
 *        - 0x00 ... 0xEF
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_periodic_advertising_set_info_transfer(uint16_t Connection_Handle,
                                                          uint16_t Service_Data,
                                                          uint8_t Advertising_Handle);
/**
 * @brief The ACI_GAP_Set_Periodic_Advertising_Sync_Transfer_Parameters command
 *        is used to specify how the Controller will process periodic
 *        advertising synchronization information received from the device
 *        identified by the Connection_Handle parameter (the "transfer mode").
 *        See hci_le_set_periodic_advertising_sync_transfer_parameters().
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Mode The Mode parameter specifies the action to be taken when periodic
 *        advertising synchronization information is received. If Mode is 0x00,
 *        the Controller will ignore the information. Otherwise it will notify
 *        the Host and synchronize to the periodic advertising. Mode also
 *        specifies whether periodic advertising reports are initially enabled
 *        or disabled.
 *        Values:
 *        - 0x00: No attempt is made to synchronize to the periodic advertising and no HCI_LE_Periodic_Advertising_Sync_Transfer_Received event is sent to the Host.
 *        - 0x01: An HCI_LE_Periodic_Advertising_Sync_Transfer_Received event is sent to the Host. HCI_LE_Periodic_Advertising_Report events will be disabled.
 *        - 0x02: An HCI_LE_Periodic_Advertising_Sync_Transfer_Received event is sent to the Host. HCI_LE_Periodic_Advertising_Report events will be enabled.
 * @param Skip The Skip parameter specifies the number of consecutive periodic
 *        advertising packets that the receiver may skip after successfully
 *        receiving a periodic advertising packet.
 *        Values:
 *        - 0x0000 ... 0x01F3: The number of periodic advertising packets that can be skipped after a successful receive
 * @param Sync_Timeout The Skip parameter specifies the number of consecutive
 *        periodic advertising packets that the receiver may skip after
 *        successfully receiving a periodic advertising packet. Time = N*10 ms;
 *        Time Range: 100 ms to 163.84 s.
 *        Values:
 *        - 0x000A (100 ms)  ... 0x4000 (163840 ms) : Synchronization timeout for the periodic advertising
 * @param CTE_Type It specifies whether to only synchronize to periodic
 *        advertising with certain types of Constant Tone Extension. If the
 *        periodic advertiser changes the type of the Constant Tone Extension
 *        after the Controller has synchronized with the periodic advertising,
 *        it shall remain synchronized.
 *        Flags:
 *        - 0x01: Do not sync to packets with an AoA Constant Tone Extension
 *        - 0x02: Do not sync to packets with an AoD Constant Tone Extension with 1 microsecond slots
 *        - 0x04: Do not sync to packets with an AoD Constant Tone Extension with 2 microseconds slots
 *        - 0x10: Do not sync to packets without a Constant Tone Extension
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_set_periodic_advertising_sync_transfer_parameters(uint16_t Connection_Handle,
                                                                     uint8_t Mode,
                                                                     uint16_t Skip,
                                                                     uint16_t Sync_Timeout,
                                                                     uint8_t CTE_Type);
/**
 * @brief The ACI_GAP_Set_Default_Periodic_Advertising_Sync_Transfer_Parameters
 *        command is used to specify the initial value for the mode, skip,
 *        timeout, and Constant Tone Extension type to be used for all
 *        subsequent connections over the LE transport. See
 *        hci_le_set_default_periodic_advertising_sync_transfer_parameters().
 * @param Mode The Mode parameter specifies the initial action to be taken. If
 *        Mode is 0x00, the Controller will ignore the information. Otherwise it
 *        will notify the Host and synchronize to the periodic advertising. Mode
 *        also specifies whether periodic advertising reports are initially
 *        enabled or disabled.
 *        Values:
 *        - 0x00: No attempt is made to synchronize to the periodic advertising and no HCI_LE_Periodic_Advertising_Sync_Transfer_Received event is sent to the Host.
 *        - 0x01: An HCI_LE_Periodic_Advertising_Sync_Transfer_Received event is sent to the Host. HCI_LE_Periodic_Advertising_Report events will be disabled.
 *        - 0x02: An HCI_LE_Periodic_Advertising_Sync_Transfer_Received event is sent to the Host. HCI_LE_Periodic_Advertising_Report events will be enabled.
 * @param Skip The Skip parameter specifies the number of consecutive periodic
 *        advertising packets that the receiver may skip after successfully
 *        receiving a periodic advertising packet.
 *        Values:
 *        - 0x0000 ... 0x01F3: The number of periodic advertising packets that can be skipped after a successful receive
 * @param Sync_Timeout The Skip parameter specifies the number of consecutive
 *        periodic advertising packets that the receiver may skip after
 *        successfully receiving a periodic advertising packet. Time = N*10 ms;
 *        Time Range: 100 ms to 163.84 s.
 *        Values:
 *        - 0x000A (100 ms)  ... 0x4000 (163840 ms) : Synchronization timeout for the periodic advertising
 * @param CTE_Type The CTE_Type parameter specifies whether to only synchronize
 *        to periodic advertising with certain types of Constant Tone Extension.
 *        If the periodic advertiser changes the type of the Constant Tone
 *        Extension after the Controller has synchronized with the periodic
 *        advertising, it shall remain synchronized.
 *        Flags:
 *        - 0x01: Do not sync to packets with an AoA Constant Tone Extension
 *        - 0x02: Do not sync to packets with an AoD Constant Tone Extension with 1 microsecond slots
 *        - 0x04: Do not sync to packets with an AoD Constant Tone Extension with 2 microseconds slots
 *        - 0x10: Do not sync to packets without a Constant Tone Extension
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_set_default_periodic_advertising_sync_transfer_parameters(uint8_t Mode,
                                                                             uint16_t Skip,
                                                                             uint16_t Sync_Timeout,
                                                                             uint8_t CTE_Type);
/**
 * @brief The GAP_Set_Periodic_Advertising_Data command is used to set the data
 *        used in periodic advertising PDUs. See
 *        hci_le_set_periodic_advertising_data().
 * @param Advertising_Handle It is used to identify an advertising set
 *        Values:
 *        - 0x00 ... 0xEF: Used to identify an advertising set
 * @param Advertising_Data_Length The number of octets in the Advertising Data
 *        parameter
 *        Values:
 *        - 0 ... 252: The number of octets in the Advertising Data parameter
 * @param Advertising_Data Periodic advertising data formatted as defined in
 *        [Vol 3] Part C, Section 11. Note: This parameter has a variable
 *        length.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_set_periodic_advertising_data(uint8_t Advertising_Handle,
                                                 uint8_t Advertising_Data_Length,
                                                 uint8_t Advertising_Data[]);
/**
 * @brief The ACI_GAP_SET_ADVERTISING_DATA function is used to set the data in
 *        advertising PDUs.  If the device is in Limited Discoverable Mode,
 *        Flags data type in advertising data must have the flags set as
 *        described: - The LE Limited Discoverable Mode flag set to one. - The
 *        'BR/EDR Not Supported' flag set to one. - All other flags set to zero.
 *        If the device is in General Discoverable Mode, Flags data type in
 *        advertising data must have the flags set as described: - The LE
 *        General Discoverable Mode flag set to one. - The 'BR/EDR Not
 *        Supported' flag set to one. - All other flags set to zero.  If the
 *        device is in one of the other modes, Flags data type in advertising
 *        data must have the flags set as described: - The 'BR/EDR Not
 *        Supported' flag set to one. - All other flags set to zero.  If a
 *        device is sending non connectable events, Flags data type may be
 *        omitted, otherwise it must be present.
 * @param Advertising_Handle Used to identify an advertising set. This parameter
 *        is only meaningful if Extended Advertising Feature is enabled.
 *        Values:
 *        - 0x00 ... 0xEF
 * @param Operation If set to Unchanged data, just update the Advertising DID.
 *        Values:
 *        - 0x03: Complete data
 *        - 0x04: Unchanged data
 * @param Advertising_Data_Length Length of advertising data. For legacy PDUs
 *        which supports advertising data maximum value is 31 octets.
 * @param Advertising_Data Pointer to the buffer containing properly formatted
 *        advertising data (see Core v5.1 Vol 3, part C, chapter 11). Its
 *        content must not change, until an
 *        aci_hal_adv_scan_resp_data_update_event is received, which informs the
 *        application that the buffer is no more used by the Bluetooth stack.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_set_advertising_data(uint8_t Advertising_Handle,
                                        uint8_t Operation,
                                        uint16_t Advertising_Data_Length,
                                        uint8_t Advertising_Data[]);
/**
 * @brief The ACI_GAP_SET_SCAN_RESPONSE_DATA function configures the scan
 *        response data as requested by the application.
 * @param Advertising_Handle Used to identify an advertising set. This parameter
 *        is only meaningful if Extended Advertising Feature is enabled.
 *        Values:
 *        - 0x00 ... 0xEF
 * @param Scan_Response_Data_Length Length of scan response data. If the
 *        advertising set uses scannable legacy advertising PDUs maximum length
 *        is 31 octets.
 * @param Scan_Response_Data Pointer to the buffer containing properly formatted
 *        scan response data (see Core v5.1 Vol 3, part C, chapter 11). Its
 *        content must not change, until an
 *        aci_hal_adv_scan_resp_data_update_event is received, which informs the
 *        application that the buffer is no more used by the Bluetooth stack.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gap_set_scan_response_data(uint8_t Advertising_Handle,
                                          uint16_t Scan_Response_Data_Length,
                                          uint8_t Scan_Response_Data[]);
/**
 * @}
 */
/**
 * @}
 */

/**
 *@addtogroup GATT GATT
 *@brief Generic Attribute Profile
 *@{
 */
/**
 *@defgroup GATT_Commands GATT Commands
 *@brief Commands for GATT layer.
 *@{
 */
/**
 * @brief Adds the GATT service to the database.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_srv_init(void);
/**
 * @brief Masks events from the GATT. The default configuration is all the
 *        events unmasked (enabled).
 * @param GATT_Evt_Mask GATT/ATT event mask.
 *        Values:
 *        - 0x00000001: ACI_GATT_ATTRIBUTE_MODIFIED_EVENT
 *        - 0x00000002: ACI_GATT_PROC_TIMEOUT_EVENT
 *        - 0x00000004: ACI_ATT_EXCHANGE_MTU_RESP_EVENT
 *        - 0x00000008: ACI_ATT_FIND_INFO_RESP_EVENT
 *        - 0x00000010: ACI_ATT_FIND_BY_TYPE_VALUE_RESP_EVENT
 *        - 0x00000020: ACI_ATT_READ_BY_TYPE_RESP_EVENT
 *        - 0x00000040: ACI_ATT_READ_RESP_EVENT
 *        - 0x00000080: ACI_ATT_READ_BLOB_RESP_EVENT
 *        - 0x00000100: ACI_ATT_READ_MULTIPLE_RESP_EVENT
 *        - 0x00000200: ACI_ATT_READ_BY_GROUP_TYPE_RESP_EVENT
 *        - 0x00000800: ACI_ATT_PREPARE_WRITE_RESP_EVENT
 *        - 0x00001000: ACI_ATT_EXEC_WRITE_RESP_EVENT
 *        - 0x00002000: ACI_GATT_INDICATION_EVENT
 *        - 0x00004000: ACI_GATT_NOTIFICATION_EVENT
 *        - 0x00008000: ACI_GATT_ERROR_RESP_EVENT
 *        - 0x00010000: ACI_GATT_PROC_COMPLETE_EVENT
 *        - 0x00020000: ACI_GATT_DISC_READ_CHAR_BY_UUID_RESP_EVENT
 *        - 0x00040000: ACI_GATT_TX_POOL_AVAILABLE_EVENT
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_set_event_mask(uint32_t GATT_Evt_Mask);
/**
 * @brief Performs an ATT MTU exchange procedure. When the ATT MTU exchange
 *        procedure is completed, a @ref aci_att_exchange_mtu_resp_event event
 *        is generated. A @ref aci_gatt_clt_proc_complete_event event is also
 *        generated to indicate the end of the procedure.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_clt_exchange_config(uint16_t Connection_Handle);
/**
 * @brief Sends a Prepare Write Request. The Prepare Write Request is used to
 *        request the server to prepare to write the value of an attribute.  The
 *        responses of the procedure are given through the @ref
 *        aci_att_clt_prepare_write_resp_event event.  The end of the procedure
 *        is indicated by a @ref aci_gatt_clt_proc_complete_event.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Attr_Handle Handle of the attribute to be written
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param Val_Offset The offset of the first octet to be written
 *        Values:
 *        - 0 ... 511
 * @param Attribute_Val_Length Length of attribute value (maximum value is
 *        ATT_MTU - 5).
 * @param Attribute_Val The value of the attribute to be written
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_clt_prepare_write_req(uint16_t Connection_Handle,
                                          uint16_t Attr_Handle,
                                          uint16_t Val_Offset,
                                          uint16_t Attribute_Val_Length,
                                          uint8_t Attribute_Val[]);
/**
 * @brief Sends an Execute Write Request. The Execute Write Request is used to
 *        request the server to write or cancel the write of all the prepared
 *        values currently held in the prepare queue from this client.  The
 *        result of the procedure is given through the @ref
 *        aci_att_clt_exec_write_resp_event event.  The end of the procedure is
 *        indicated by a @ref aci_gatt_clt_proc_complete_event event.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Execute Execute or cancel writes.
 *        Values:
 *        - 0x00: Cancel all prepared writes
 *        - 0x01: Immediately write all pending prepared values
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_clt_execute_write_req(uint16_t Connection_Handle,
                                          uint8_t Execute);
/**
 * @brief Starts the GATT client procedure to discover all primary services on
 *        the server. The responses of the procedure are given through the @ref
 *        aci_att_clt_read_by_group_type_resp_event event.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_clt_disc_all_primary_services(uint16_t Connection_Handle);
/**
 * @brief Starts the procedure to discover the primary services of the specified
 *        UUID on the server. The responses of the procedure are given through
 *        the @ref aci_att_clt_find_by_type_value_resp_event event. The end of
 *        the procedure is indicated by a @ref aci_gatt_clt_proc_complete_event
 *        event.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param UUID_Type UUID type.
 *        Values:
 *        - 0x01: 16-bit UUID
 *        - 0x02: 128-bit UUID
 * @param UUID See @ref UUID_t
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_clt_disc_primary_service_by_uuid(uint16_t Connection_Handle,
                                                     uint8_t UUID_Type,
                                                     UUID_t *UUID);
/**
 * @brief Starts the procedure to find all included services. The responses of
 *        the procedure are given through the @ref
 *        aci_att_clt_read_by_type_resp_event event. The end of the procedure is
 *        indicated by a @ref aci_gatt_clt_proc_complete_event event.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Start_Handle Start attribute handle of the service
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param End_Handle End attribute handle of the service
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_clt_find_included_services(uint16_t Connection_Handle,
                                               uint16_t Start_Handle,
                                               uint16_t End_Handle);
/**
 * @brief Starts the procedure to discover all the characteristics of a given
 *        service. When the procedure is completed, a @ref
 *        aci_gatt_clt_proc_complete_event event is generated. Before procedure
 *        completion the response packets are given through @ref
 *        aci_att_clt_read_by_type_resp_event event.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Start_Handle Start attribute handle of the service
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param End_Handle End attribute handle of the service
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_clt_disc_all_char_of_service(uint16_t Connection_Handle,
                                                 uint16_t Start_Handle,
                                                 uint16_t End_Handle);
/**
 * @brief Starts the procedure to discover all the characteristics specified by
 *        a UUID. When the procedure is completed, a @ref
 *        aci_gatt_clt_proc_complete_event event is generated. Before procedure
 *        completion the response packets are given through @ref
 *        aci_gatt_clt_disc_read_char_by_uuid_resp_event event.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Start_Handle Start attribute handle of the service
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param End_Handle End attribute handle of the service
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param UUID_Type UUID type.
 *        Values:
 *        - 0x01: 16-bit UUID
 *        - 0x02: 128-bit UUID
 * @param UUID See @ref UUID_t
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_clt_disc_char_by_uuid(uint16_t Connection_Handle,
                                          uint16_t Start_Handle,
                                          uint16_t End_Handle,
                                          uint8_t UUID_Type,
                                          UUID_t *UUID);
/**
 * @brief Starts the procedure to discover all characteristic descriptors on the
 *        server. When the procedure is completed, a @ref
 *        aci_gatt_clt_proc_complete_event event is generated. Before procedure
 *        completion the response packets are given through @ref
 *        aci_att_clt_find_info_resp_event event.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Char_Handle Handle of the characteristic value
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param End_Handle End handle of the characteristic
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_clt_disc_all_char_desc(uint16_t Connection_Handle,
                                           uint16_t Char_Handle,
                                           uint16_t End_Handle);
/**
 * @brief Starts the procedure to read an attribute value. When the procedure is
 *        completed, a @ref aci_gatt_clt_proc_complete_event event is generated.
 *        Before procedure completion the response packet is given through @ref
 *        aci_att_clt_read_resp_event event.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Attr_Handle Handle of the attribute to be read
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_clt_read(uint16_t Connection_Handle,
                             uint16_t Attr_Handle);
/**
 * @brief Starts the procedure to read all the characteristics specified by the
 *        UUID. When the procedure is completed, a @ref
 *        aci_gatt_clt_proc_complete_event event is generated. Before procedure
 *        completion the response packets are given through @ref
 *        aci_gatt_clt_disc_read_char_by_uuid_resp_event event.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Start_Handle Starting handle of the range to be searched
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param End_Handle End handle of the range to be searched
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param UUID_Type UUID type.
 *        Values:
 *        - 0x01: 16-bit UUID
 *        - 0x02: 128-bit UUID
 * @param UUID See @ref UUID_t
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_clt_read_using_char_uuid(uint16_t Connection_Handle,
                                             uint16_t Start_Handle,
                                             uint16_t End_Handle,
                                             uint8_t UUID_Type,
                                             UUID_t *UUID);
/**
 * @brief Starts the procedure to read a long attribute value. the procedure is
 *        completed, a @ref aci_gatt_clt_proc_complete_event event is generated.
 *        Before procedure completion the response packets are given through
 *        @ref aci_att_clt_read_blob_resp_event event.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Attr_Handle Handle of the attribute to be read
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param Val_Offset Offset from which the value needs to be read
 *        Values:
 *        - 0 ... 511
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_clt_read_long(uint16_t Connection_Handle,
                                  uint16_t Attr_Handle,
                                  uint16_t Val_Offset);
/**
 * @brief Starts a procedure to read multiple characteristic values from a
 *        server. This sub-procedure is used to read multiple Characteristic
 *        Values from a server when the client knows the Characteristic Value
 *        Handles. When the procedure is completed, a @ref
 *        aci_gatt_clt_proc_complete_event event is generated. Before procedure
 *        completion the response packets are given through @ref
 *        aci_att_clt_read_multiple_resp_event event.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Number_of_Handles The number of handles for which the value has to be
 *        read. From 2 to (ATT_MTU-1)/2
 *        Values:
 *        - 0x02 ... 0xFF
 * @param Handle_Entry See @ref Handle_Entry_t
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_clt_read_multiple_char_value(uint16_t Connection_Handle,
                                                 uint8_t Number_of_Handles,
                                                 Handle_Entry_t Handle_Entry[]);
/**
 * @brief Starts the procedure to write a characteristic value without waiting
 *        for any response from the server. No events are generated after this
 *        command is executed. Writing attributes using this function is not
 *        considered reliable by the standard: packets may be discarded by the
 *        peer if too many write commands are received.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Attr_Handle Handle of the attribute to be written
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param Attribute_Val_Length Length of the value to be written (maximum value
 *        is ATT_MTU - 3)
 * @param Attribute_Val Value to be written
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_clt_write_without_resp(uint16_t Connection_Handle,
                                           uint16_t Attr_Handle,
                                           uint16_t Attribute_Val_Length,
                                           uint8_t Attribute_Val[]);
/**
 * @brief Starts a signed write without response from the server. The procedure
 *        is used to write a characteristic value with an authentication
 *        signature without waiting for any response from the server. It cannot
 *        be used when the link is encrypted.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Attr_Handle Handle of the attribute to be written
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param Attribute_Val_Length Length of the value to be written (up to ATT_MTU
 *        - 13)
 * @param Attribute_Val Value to be written
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_clt_signed_write_without_resp(uint16_t Connection_Handle,
                                                  uint16_t Attr_Handle,
                                                  uint16_t Attribute_Val_Length,
                                                  uint8_t Attribute_Val[]);
/**
 * @brief Allow application to confirm indication. This command has to be sent
 *        when the application receives the event @ref
 *        aci_gatt_clt_indication_event.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_clt_confirm_indication(uint16_t Connection_Handle);
/**
 * @brief Send an indication or notification for the provided attribute handle.
 *        The Flags parameter indicate what kind of message will be sent: -)
 *        0x00 Send a notification -) 0x02 Send an indication
 * @param Connection_Handle Connection handle to be used to identify the
 *        connection with the peer device.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Attr_Handle Handle of the attribute to be notified
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param Flags Select the notification type.
 *        Values:
 *        - 0x00: GATT_NOTIFICATION
 *        - 0x02: GATT_INDICATION
 * @param Val_Length Length of the Val field.
 * @param Val
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_srv_notify(uint16_t Connection_Handle,
                               uint16_t Attr_Handle,
                               uint8_t Flags,
                               uint16_t Val_Length,
                               uint8_t Val[]);
/**
 * @brief Updates an attribute value for that kind of attributes that have
 *        different values for each connection, i.e. the Client Characteristic
 *        Configuration Descriptors. WARNING: use of this function can affect
 *        interoperability. Do not use the function unless you are aware of what
 *        you are doing.
 * @param Connection_Handle Connection handle for which the attribute value will
 *        be written.
 * @param Attr_Handle Handle of the attribute
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param Value_Length Length of the attribute value in octets.
 * @param Value Attribute value.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_srv_write_multiple_instance_handle_value(uint16_t Connection_Handle,
                                                             uint16_t Attr_Handle,
                                                             uint16_t Value_Length,
                                                             uint8_t Value[]);
/**
 * @brief Adds a service to the GATT database. When a service is created, the
 *        host may reserve a range of handles for this service.
 * @param Service_p The pointer to the service definition.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_srv_add_service(ble_gatt_srv_def_t * Service_p);
/**
 * @brief Includes a service given by Included_Service_Handle to another service
 *        given by Service_Handle. Attribute server creates an Include
 *        definition attribute and returns the handle of this attribute.
 * @param Service_Handle Handle of the Service to which another service has to
 *        be included.
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param Included_Service_Handle Attribute Handle of the Service which has to
 *        be included in service
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_srv_include_service(uint16_t Service_Handle,
                                        uint16_t Included_Service_Handle);
/**
 * @brief Adds a characteristic to a service.
 * @param Char_p The pointer to the Characteristic definition.
 * @param Service_Handle Handle of the Service to which the characteristic will
 *        be added.
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_srv_add_char(ble_gatt_chr_def_t * Char_p,
                                 uint16_t Service_Handle);
/**
 * @brief Adds a characteristic descriptor to a characteristic.
 * @param Descr_p The pointer to the Descriptor definition.
 * @param Char_Handle The Characteristic handle.
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_srv_add_char_desc(ble_gatt_descr_def_t * Descr_p,
                                      uint16_t Char_Handle);
/**
 * @brief Deletes the specified service from the GATT server database.
 * @param Serv_Handle Handle of the service to be deleted
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_srv_rm_service(uint16_t Serv_Handle);
/**
 * @brief Deletes the include definition from the service.
 * @param Include_Handle Handle of the included service which has to be deleted
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_srv_rm_include_service(uint16_t Include_Handle);
/**
 * @brief Deletes the specified characteristic from the service.
 * @param Char_Handle Handle of the characteristic which has to be deleted
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_srv_rm_char(uint16_t Char_Handle);
/**
 * @brief This function retrieve the Attribute Handle assigned to the Service
 *        registered using the provided definition structure.
 * @param Serv_p The Service definition structure.
 * @return Attribute Handle of Service or BLE_ATT_INVALID_ATTR_HANDLE on error.
 */
uint16_t aci_gatt_srv_get_service_handle(ble_gatt_srv_def_t * Serv_p);
/**
 * @brief This function retrieve the Attribute Handle assigned to the Include
 *        Service.
 * @param Serv_Attr_Handle The Handle of the including Service.
 * @param Included_Srv_p The Included Service definition structure.
 * @return Attribute Handle of Service or BLE_ATT_INVALID_ATTR_HANDLE on error.
 */
uint16_t aci_gatt_srv_get_include_service_handle(uint16_t Serv_Attr_Handle,
                                                   ble_gatt_srv_def_t * Included_Srv_p);
/**
 * @brief This function retrieve the Attribute Handle assigned to the
 *        Characteristic registered using the provided definition structure.
 * @param Char_p The Characteristic definition structure.
 * @return Attribute Handle of Service or BLE_ATT_INVALID_ATTR_HANDLE on error.
 */
uint16_t aci_gatt_srv_get_char_decl_handle(ble_gatt_chr_def_t * Char_p);
/**
 * @brief This function retrieve the Attribute Handle assigned to the
 *        Characteristic Descriptor registered using the provided definition
 *        structure.
 * @param Descr_p The Characteristic Descriptor definition structure.
 * @return Attribute Handle of Service or BLE_ATT_INVALID_ATTR_HANDLE on error.
 */
uint16_t aci_gatt_srv_get_descriptor_handle(ble_gatt_descr_def_t * Descr_p);
/**
 * @brief Reads the value of the attribute handle specified from the local GATT
 *        database.
 * @param Attr_Handle Handle of the attribute to read
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param[out] Length Length of the attribute value
 * @param[out] Value Pointer to the Attribute Value.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_srv_read_handle_value(uint16_t Attr_Handle,
                                          uint16_t *Length,
                                          uint8_t * *Value);
/**
 * @brief Command to be given in response to aci_gatt_srv_read_event,
 *        aci_gatt_srv_write_event, aci_att_srv_prepare_write_req_event or
 *        aci_att_srv_exec_write_req_event. It ends the ATT transaction
 *        initiated by the remote client.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Attr_Handle Attribute handle for which the response command is issued.
 * @param Error_Code The reason why the request has generated an error response
 *        (ATT error codes)
 *        Values:
 *        - 0x01: Invalid handle
 *        - 0x02: Read not permitted
 *        - 0x03: Write not permitted
 *        - 0x04: Invalid PDU
 *        - 0x05: Insufficient authentication
 *        - 0x06: Request not supported
 *        - 0x07: Invalid offset
 *        - 0x08: Insufficient authorization
 *        - 0x09: Prepare queue full
 *        - 0x0A: Attribute not found
 *        - 0x0B: Attribute not long
 *        - 0x0C: Insufficient encryption key size
 *        - 0x0D: Invalid attribute value length
 *        - 0x0E: Unlikely error
 *        - 0x0F: Insufficient encryption
 *        - 0x10: Unsupported group type
 *        - 0x11: Insufficient resources
 * @param Val_Length Length of the Val field.
 * @param Val
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_srv_resp(uint16_t Connection_Handle,
                             uint16_t Attr_Handle,
                             uint8_t Error_Code,
                             uint16_t Val_Length,
                             uint8_t Val[]);
/**
 * @brief Starts the procedure to write an attribute (characteristic value or
 *        descriptor). When the procedure is completed, a @ref
 *        aci_gatt_clt_proc_complete_event event is generated.  Note: the buffer
 *        containing the value to be written must be kept valid until the @ref
 *        aci_gatt_clt_proc_complete_event is received
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Attr_Handle Handle of the attribute to be written
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param Attribute_Val_Length Length of the value to be written
 * @param Attribute_Val
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_clt_write(uint16_t Connection_Handle,
                              uint16_t Attr_Handle,
                              uint16_t Attribute_Val_Length,
                              uint8_t Attribute_Val[]);
/**
 * @brief This procedure is used to write an Attribute Value to a Server when
 *        the Client knows the Attribute Handle but the length of the Value is
 *        longer than what can be sent in a single Write Request Attribute
 *        Protocol message. The memory pointed by Write_Ops_p parameter must be
 *        kept valid while the procedure is running. It can be released when the
 *        aci_gatt_clt_proc_complete_event event is emitted indicating that the
 *        procedure is completed, or an error was received. During the
 *        procedure, aci_att_clt_prepare_write_resp_event and
 *        aci_att_clt_exec_write_resp_event events are raised.  Note: the buffer
 *        containing the value to be written must be kept valid until the @ref
 *        aci_gatt_clt_proc_complete_event is received.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Write_Ops_p The pointer to structure that holds the write
 *        informations.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_clt_write_long(uint16_t Connection_Handle,
                                   ble_gatt_clt_write_ops_t * Write_Ops_p);
/**
 * @brief Starts the procedure to write a characteristic reliably (a check is
 *        made on the written values). When the procedure is completed, a  @ref
 *        aci_gatt_clt_proc_complete_event event is generated. During the
 *        procedure, @ref aci_att_clt_prepare_write_resp_event and @ref
 *        aci_att_clt_exec_write_resp_event events are raised.  Note: the buffer
 *        containing the value to be written must be kept valid until the @ref
 *        aci_gatt_clt_proc_complete_event is received.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Num_Attrs The number of attributes to write, i.e. the number of
 *        elements in the list pointed by Write_Ops_p.
 * @param Write_Ops_p The pointer to the list of structures that hold the write
 *        informations.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_clt_write_char_reliable(uint16_t Connection_Handle,
                                            uint8_t Num_Attrs,
                                            ble_gatt_clt_write_ops_t * Write_Ops_p);
/**
 * @brief Read the value for that kind of attributes that have different values
 *        for each connection, i.e. the Client Characteristic Configuration
 *        Descriptors.
 * @param Connection_Handle Connection handle for which the attribute value will
 *        be read.
 * @param Attr_Handle Handle of the attribute
 *        Values:
 *        - 0x0001 ... 0xFFFF
 * @param[out] Value_Length
 * @param[out] Value Pointer to the buffer containing the value. Content may no
 *             more be valid after another call to this function or to
 *             BLE_STACK_Tick().
 * @retval Value indicating success or error code.
 */
tBleStatus aci_gatt_srv_read_multiple_instance_handle_value(uint16_t Connection_Handle,
                                                            uint16_t Attr_Handle,
                                                            uint16_t *Value_Length,
                                                            uint8_t * *Value);
/**
 * @}
 */

/**
 *@addtogroup L2CAP L2CAP
 *@brief Logical Link Control and Adaptation Protocol
 *@{
 */
/**
 *@defgroup L2CAP_Commands L2CAP Commands
 *@brief Commands for L2CAP layer.
 *@{
 */
/**
 * @brief Send an L2CAP connection parameter update request from the slave to
 *        the master. An @ref aci_l2cap_connection_update_resp_event event will
 *        be raised when the master will respond to the  request (accepts or
 *        rejects).
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Conn_Interval_Min Minimum value for the connection event interval.
 *        This shall be less than or equal to Conn_Interval_Max. Time = N * 1.25
 *        msec.
 *        Values:
 *        - 0x0006 (7.50 ms)  ... 0x0C80 (4000.00 ms) 
 * @param Conn_Interval_Max Maximum value for the connection event interval.
 *        This shall be greater than or equal to Conn_Interval_Min. Time = N *
 *        1.25 msec.
 *        Values:
 *        - 0x0006 (7.50 ms)  ... 0x0C80 (4000.00 ms) 
 * @param Slave_latency Slave latency for the connection in number of connection
 *        events.
 *        Values:
 *        - 0x0000 ... 0x01F3
 * @param Timeout_Multiplier Defines connection timeout parameter in the
 *        following manner: Timeout Multiplier * 10ms.
 *        Values:
 *        - 10 (100 ms)  ... 3200 (32000 ms) 
 * @retval Value indicating success or error code.
 */
tBleStatus aci_l2cap_connection_parameter_update_req(uint16_t Connection_Handle,
                                                     uint16_t Conn_Interval_Min,
                                                     uint16_t Conn_Interval_Max,
                                                     uint16_t Slave_latency,
                                                     uint16_t Timeout_Multiplier);
/**
 * @brief Accept or reject a connection update. This command should be sent in
 *        response to a @ref aci_l2cap_connection_update_req_event event from
 *        the controller. The accept parameter has to be set if the connection
 *        parameters given in the event are acceptable.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Conn_Interval_Min Minimum value for the connection event interval.
 *        This shall be less than or equal to Conn_Interval_Max. Time = N * 1.25
 *        msec.
 *        Values:
 *        - 0x0006 (7.50 ms)  ... 0x0C80 (4000.00 ms) 
 * @param Conn_Interval_Max Maximum value for the connection event interval.
 *        This shall be greater than or equal to Conn_Interval_Min. Time = N *
 *        1.25 msec.
 *        Values:
 *        - 0x0006 (7.50 ms)  ... 0x0C80 (4000.00 ms) 
 * @param Slave_latency Slave latency for the connection in number of connection
 *        events.
 *        Values:
 *        - 0x0000 ... 0x01F3
 * @param Timeout_Multiplier Defines connection timeout parameter in the
 *        following manner: Timeout Multiplier * 10ms.
 *        Values:
 *        - 10 (100 ms)  ... 3200 (32000 ms) 
 * @param Minimum_CE_Length Information parameter about the minimum length of
 *        connection needed for this LE connection. Time = N * 0.625 msec.
 * @param Maximum_CE_Length Information parameter about the maximum length of
 *        connection needed for this LE connection. Time = N * 0.625 msec.
 * @param Identifier Identifier received in ACI_L2CAP_Connection_Update_Req
 *        event.
 * @param Accept Specify if connection update parameters are acceptable or not.
 *        Values:
 *        - 0x00: Reject
 *        - 0x01: Accept
 * @retval Value indicating success or error code.
 */
tBleStatus aci_l2cap_connection_parameter_update_resp(uint16_t Connection_Handle,
                                                      uint16_t Conn_Interval_Min,
                                                      uint16_t Conn_Interval_Max,
                                                      uint16_t Slave_latency,
                                                      uint16_t Timeout_Multiplier,
                                                      uint16_t Minimum_CE_Length,
                                                      uint16_t Maximum_CE_Length,
                                                      uint8_t Identifier,
                                                      uint8_t Accept);
/**
 * @brief Command to be issued when the device is capable of receiving
 *        additional K-frames in LE Credit Based Flow Control mode.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param CID The local channel endpoint that identifies the L2CAP channel.
 * @param RX_Credits Additional number of K-frames that local L2CAP layer entity
 *        can currently receive from the peer.
 * @param CFC_Policy Policy to handle flow control. If 0, flow control is
 *        handled by application: credits must be sent using
 *        aci_l2cap_send_flow_control_credits(). If 1, flow control is handled
 *        automatically by the stack.
 *        Values:
 *        - 0x00: L2CAP_CFC_MANUAL
 *        - 0x01: L2CAP_CFC_AUTO
 * @param[out] RX_Credit_Balance Current number of K-frames that peer's L2CAP
 *             layer entity can send.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_l2cap_send_flow_control_credits(uint16_t Connection_Handle,
                                               uint16_t CID,
                                               uint16_t RX_Credits,
                                               uint8_t CFC_Policy,
                                               uint16_t *RX_Credit_Balance);
/**
 * @brief Command to terminate an L2CAP channel.
 * @param Connection_Handle
 * @param CID Local endpoint of the channel to be disconnected.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_l2cap_disconnect(uint16_t Connection_Handle,
                                uint16_t CID);
/**
 * @brief Create and configure an L2CAP channel between two devices using LE
 *        Credit Based Flow Control mode.
 * @param Connection_Handle Handle identifying the connection.
 * @param SPSM Simplified Protocol/Service Multiplexer
 *        Values:
 *        - 0x0001 ... 0x00FF
 * @param CID The local channel endpoint that identifies the L2CAP channel.
 *        Values:
 *        - 0x0001 ... 0x00FF
 * @param MTU The maximum SDU size (in octets) that the L2CAP layer entity
 *        sending the L2CAP_LE_CREDIT_BASED_CONNECTION_REQ can receive on this
 *        channel.
 *        Values:
 *        - 23 ... 65535
 * @param MPS The maximum PDU payload size (in octets) that the L2CAP layer
 *        entity sending the L2CAP_LE_CREDIT_BASED_CONNECTION_REQ is capable of
 *        receiving on this channel.
 *        Values:
 *        - 23 ... 65535
 * @param CFC_Policy Policy to handle flow control. If 0, flow control is
 *        handled by application: credits must be sent using
 *        aci_l2cap_send_flow_control_credits(). If 1, flow control is handled
 *        automatically by the stack.
 *        Values:
 *        - 0x00: L2CAP_CFC_MANUAL
 *        - 0x01: L2CAP_CFC_AUTO
 * @param RX_SDU_Buffer_Size Length of the buffer where received SDUs will be
 *        stored. Minimum value is MTU + 2.
 * @param[in] RX_SDU_Buffer Pointer to the buffer where SDUs will be stored.
 *            Size must be at least equal to MTU + 2 octets. This area is
 *            managed as a circular buffer. Use aci_l2cap_extract_sdu_data() to
 *            get the entire SDU.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_l2cap_cfc_connection_req(uint16_t Connection_Handle,
                                        uint16_t SPSM,
                                        uint16_t CID,
                                        uint16_t MTU,
                                        uint16_t MPS,
                                        uint8_t CFC_Policy,
                                        uint16_t RX_SDU_Buffer_Size,
                                        void * RX_SDU_Buffer);
/**
 * @brief Command to be sent to respond to a request to open an L2CAP channel
 *        using LE Credit based Flow Control (the request is notified through
 *        aci_l2cap_cfc_channel_connection_event()).
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param Identifier Identifier of the request.
 * @param CID The local channel endpoint that identifies the L2CAP channel.
 * @param MTU Simplified Protocol/Service Multiplexer
 *        Values:
 *        - 0x0001 ... 0x00FF
 * @param MPS The MPS field specifies the maximum PDU payload size (in octets)
 *        that the L2CAP layer entity sending the
 *        L2CAP_LE_CREDIT_BASED_CONNECTION_RSP is capable of receiving on this
 *        channel.
 *        Values:
 *        - 23 ... 65535
 * @param Result It indicates the outcome of the connection request. A result
 *        value of 0x0000 indicates success while a non-zero value indicates the
 *        connection request was refused.
 *        Values:
 *        - 0x0000: L2CAP_CONN_SUCCESSFUL
 *        - 0x0002: L2CAP_SPSM_NOT_SUPPORTED
 *        - 0x0004: L2CAP_NO_RESOURCE_AVAILABLE
 *        - 0x0005: L2CAP_INSUFFICIENT_AUTHENTICATION
 *        - 0x0006: L2CAP_INSUFFICIENT_AUTHORIZATION
 *        - 0x0007: L2CAP_INSUFFICIENT_ENCRYPTION_KEY_SIZE
 *        - 0x0008: L2CAP_INSUFFICIENT_ENCRYPTION
 *        - 0x0009: L2CAP_INVALID_SOURCE_CID
 *        - 0x000A: L2CAP_SOURCE_CID_ALREADY_ALLOCATED
 *        - 0x000B: L2CAP_UNACCEPTABLE_PARAMETERS
 * @param CFC_Policy Policy to handle flow control. If 0, flow control is
 *        handled by application: credits must be sent using
 *        aci_l2cap_send_flow_control_credits(). If 1, flow control is handled
 *        automatically by the stack.
 *        Values:
 *        - 0x00: L2CAP_CFC_MANUAL
 *        - 0x01: L2CAP_CFC_AUTO
 * @param RX_SDU_Buffer_Size Length of the buffer where received SDUs will be
 *        stored. Minimum value is MTU + 2.
 * @param[in] RX_SDU_Buffer Pointer to the buffer where SDUs will be stored.
 *            Size must be at least equal to MTU + 2 octets. This area is
 *            managed as a circular buffer. Use aci_l2cap_extract_sdu_data() to
 *            get the entire SDU.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_l2cap_cfc_connection_resp(uint16_t Connection_Handle,
                                         uint8_t Identifier,
                                         uint16_t CID,
                                         uint16_t MTU,
                                         uint16_t MPS,
                                         uint16_t Result,
                                         uint8_t CFC_Policy,
                                         uint16_t RX_SDU_Buffer_Size,
                                         void * RX_SDU_Buffer);
/**
 * @brief Function to be used to extract an SDU from receving buffer.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param CID The local channel endpoint that identifies the L2CAP channel.
 * @param SDU_Data_Buffer_Size
 * @param[in] SDU_Data_Buffer
 * @param[out] SDU_Length
 * @retval Value indicating success or error code.
 */
tBleStatus aci_l2cap_extract_sdu_data(uint16_t Connection_Handle,
                                      uint16_t CID,
                                      uint16_t SDU_Data_Buffer_Size,
                                      void * SDU_Data_Buffer,
                                      uint16_t *SDU_Length);
/**
 * @brief Function to be called to send an SDU using an  L2CAP channel in LE
 *        Credit Based Flow Control mode. An aci_l2cap_sdu_data_tx_event is
 *        raised when the SDU has been processed and buffer can be freed or
 *        reused by application.
 * @param Connection_Handle Connection handle that identifies the connection.
 *        Values:
 *        - 0x0000 ... 0x0EFF
 * @param CID The local channel endpoint that identifies the L2CAP channel.
 * @param SDU_Length Length of the SDU to be transmitted.
 * @param SDU_Data Data contained in the SDU to be transmitted. Data must be
 *        valid until the SDU is transmitted.
 * @retval Value indicating success or error code.
 */
tBleStatus aci_l2cap_transmit_sdu_data(uint16_t Connection_Handle,
                                       uint16_t CID,
                                       uint16_t SDU_Length,
                                       uint8_t SDU_Data[]);
/**
 * @}
 */
/**
 * @}
 */

#endif /* _BLUENRG_LP_API_H_ */
