/*
 * Copyright (c) 2009-2018 ARM Limited. All rights reserved.
 * 
 * SPDX-License-Identifier: Apache-2.0
 * 
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @file     BlueNRG_LP.h
 * @brief    CMSIS HeaderFile
 * @version  1.0
 * @date     19. September 2018
 * @note     Generated by SVDConv V3.3.18 on Wednesday, 19.09.2018 17:22:09
 *           from File 'BlueNRG_LP.svd',
 *           last modified on Wednesday, 19.09.2018 15:21:54
 */



/** @addtogroup 
  * @{
  */


/** @addtogroup BlueNRG_LP
  * @{
  */


#ifndef BLUENRG_LP_H
#define BLUENRG_LP_H

#ifdef __cplusplus
extern "C" {
#endif


/** @addtogroup Peripheral_interrupt_number_definition
  * @{
  */


/* =========================================================================================================================== */
/* ================                                Interrupt Number Definition                                ================ */
/* =========================================================================================================================== */

typedef enum {
/* =======================================  ARM Cortex-M0+ Specific Interrupt Numbers  ======================================= */
  Reset_IRQn                = -15,              /*!< -15  Reset Vector, invoked on Power up and warm reset                     */
  NonMaskableInt_IRQn       = -14,              /*!< -14  Non maskable Interrupt, cannot be stopped or preempted               */
  HardFault_IRQn            = -13,              /*!< -13  Hard Fault, all classes of Fault                                     */
  SVCall_IRQn               =  -5,              /*!< -5 System Service Call via SVC instruction                                */
  PendSV_IRQn               =  -2,              /*!< -2 Pendable request for system service                                    */
  SysTick_IRQn              =  -1,              /*!< -1 System Tick Timer                                                      */
/* =========================================  BlueNRG_LP Specific Interrupt Numbers  ========================================= */
  FLASH_IRQn                =   0,              /*!< 0  NVM interrupt                                                          */
  RCC_IRQn                  =   1,              /*!< 1  RCC interrupt                                                          */
  PVD_IRQn                  =   2,              /*!< 2  PVD interrupt                                                          */
  I2C1_IRQn                 =   3,              /*!< 3  I2C1 interrurpt                                                        */
  I2C2_IRQn                 =   4,              /*!< 4  I2C2 interrupt                                                         */
  SPI1_IRQn                 =   5,              /*!< 5  SPI1 interrupt                                                         */
  SPI2_IRQn                 =   6,              /*!< 6  SPI2 interrupt                                                         */
  SPI3_IRQn                 =   7,              /*!< 7  SPI3 interrupt                                                         */
  USART1_IRQn               =   8,              /*!< 8  USART interrupt                                                        */
  LPUART1_IRQn              =   9,              /*!< 9  Low Power UART interrupt                                               */
  TIM1_IRQn                 =  10,              /*!< 10 Timer 1 interrupt                                                      */
  RTC_IRQn                  =  11,              /*!< 11 RTC interrupt                                                          */
  ADC_IRQn                  =  12,              /*!< 12 ADC interrupt                                                          */
  PKA_IRQn                  =  13,              /*!< 13 PKA interrupt                                                          */
  UPCONV_IRQn               =  14,              /*!< 14 AHB_UP_CONVERTER interrupt                                             */
  GPIOA_IRQn                =  15,              /*!< 15 GPIOA interrupt                                                        */
  GPIOB_IRQn                =  16,              /*!< 16 GPIOB interrupt                                                        */
  DMA_IRQn                  =  17,              /*!< 17 DMA interrupt                                                          */
  BLE_TX_RX_IRQn            =  18,              /*!< 18 BLE Tx/Rx interrupt                                                    */
  BLE_AES_IRQn              =  19,              /*!< 19 BLE AES interrupt                                                      */
  BLE_ERROR_IRQn            =  20,              /*!< 20 BLE Error interrupt                                                    */
  RADIO_CTRL_IRQn           =  21,              /*!< 21 Radio Control interrupt                                                */
  MR_BLE_IRQn               =  22,              /*!< 22 RRM and Radio FSM interrupt                                            */
  CPU_WKUP_IRQn             =  23,              /*!< 23 CPU Wakeup interrupt                                                   */
  BLE_WKUP_IRQn             =  24,              /*!< 24 BLE Wakeup interrupt                                                   */
  BLE_SEQ_IRQn              =  25               /*!< 25 BLE RX/TX sequence interrupt                                           */
} IRQn_Type;



/* =========================================================================================================================== */
/* ================                           Processor and Core Peripheral Section                           ================ */
/* =========================================================================================================================== */

/* ==========================  Configuration of the ARM Cortex-M0+ Processor and Core Peripherals  =========================== */
/** @addtogroup Configuration_of_CMSIS
  * @{
  */
/**
  * @brief Configuration of the Cortex-M0+ Processor and Core Peripherals
  */

#define __CM0PLUS_REV                  1        /*!< CM0PLUS Core Revision r0p1                                                */
#define __NVIC_PRIO_BITS               2        /*!< Number of Bits used for Priority Levels                                   */
#define __Vendor_SysTickConfig         0        /*!< Set to 1 if different SysTick Config is used                              */
#define __VTOR_PRESENT                 1        /*!< Vector Table Offset Register supported                                    */
#define __MPU_PRESENT                  1        /*!< M0+ provides an MPU                                                       */
#define __FPU_PRESENT                  0        /*!< FPU not present                                                           */
/**
  * @}
  */


 /*!< Device Electronic Signature */
#define PACKAGE_BASE          ((uint32_t)0x10001EECU)        /*!< Package data register base address                    */
#define UID64_BASE            ((uint32_t)0x10001EF0U)        /*!< 64-bit Unique device Identification                   */
#define FLASHSIZE_BASE        ((uint32_t)0x40001014U)        /*!< Flash size data register base address                 */
#define RAMSIZE_BASE          ((uint32_t)0x48500090U)        /*!< RAM size data register base address                   */  
#define DEV_ID_BASE           ((uint32_t)0x40000000U)        /*!< Device version and cut version register base address  */
  
  
  
/** @} */ /* End of group Configuration_of_CMSIS */
  
#include "core_cm0plus.h"                       /*!< ARM Cortex-M0+ processor and core peripherals                             */
#include "system_util.h"                        /*!< BlueNRG_LP macros and typedefs System util                                */
  
#ifndef __IM                                    /*!< Fallback for older CMSIS versions                                         */
  #define __IM   __I
#endif
#ifndef __OM                                    /*!< Fallback for older CMSIS versions                                         */
  #define __OM   __O
#endif
#ifndef __IOM                                   /*!< Fallback for older CMSIS versions                                         */
  #define __IOM  __IO
#endif


/* ========================================  Start of section using anonymous unions  ======================================== */
#if defined (__CC_ARM)
  #pragma push
  #pragma anon_unions
#elif defined (__ICCARM__)
  #pragma language=extended
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic push
  #pragma clang diagnostic ignored "-Wc11-extensions"
  #pragma clang diagnostic ignored "-Wreserved-id-macro"
  #pragma clang diagnostic ignored "-Wgnu-anonymous-struct"
  #pragma clang diagnostic ignored "-Wnested-anon-types"
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning 586
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#else
  #warning Not supported compiler type
#endif


/* =========================================================================================================================== */
/* ================                            Device Specific Peripheral Section                             ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_peripherals
  * @{
  */



/* =========================================================================================================================== */
/* ================                                            DMA                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Direct memory access controller (DMA)
  */

typedef struct {                                /*!< DMA Structure                                                             */
  __IM  uint32_t  ISR;                          /*!< (@ 0x00000000) Interrupt status register                                  */
  __OM  uint32_t  IFCR;                         /*!< (@ 0x00000004) Interrupt flag clear register                              */
} DMA_TypeDef;                                 

typedef struct {
  __IO uint32_t CCR;         /*!< DMA channel x configuration register        */
  __IO uint32_t CNDTR;       /*!< DMA channel x number of data register       */
  __IO uint32_t CPAR;        /*!< DMA channel x peripheral address register   */
  __IO uint32_t CMAR;        /*!< DMA channel x memory address register       */
  __IM uint32_t RESERVED;
} DMA_Channel_TypeDef;




/* =========================================================================================================================== */
/* ================                                          DMAMUX                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Direct memory access Multiplexer (DMAMUX)
  */

/**
  * @brief DMA Multiplexer
  */
typedef struct {             /*!< DMAMUX Structure                                                                   */
  __IO uint32_t   CCR;       /*!< DMA Multiplexer Channel x Control Register    Address offset: 0x0004 * (channel x) */
} DMAMUX_Channel_TypeDef;

  
/* =========================================================================================================================== */
/* ================                                            CRC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Cyclic redundancy check calculation unit (CRC)
  */

typedef struct {                                /*!< CRC Structure                                                             */
  __IOM uint32_t  DR;                           /*!< (@ 0x00000000) Data register                                              */
  __IOM uint32_t  IDR;                          /*!< (@ 0x00000004) Independent data register                                  */
  __IOM uint32_t  CR;                           /*!< (@ 0x00000008) Control register                                           */
  __IM  uint32_t  RESERVED;
  __IOM uint32_t  INIT;                         /*!< (@ 0x00000010) Initial CRC value                                          */
  __IOM uint32_t  POL;                          /*!< (@ 0x00000014) Polynomial                                                 */
} CRC_TypeDef;                                  /*!< Size = 24 (0x18)                                                          */



/* =========================================================================================================================== */
/* ================                                           IWDG                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Independent watchdog (IWDG)
  */

typedef struct {                                /*!< IWDG Structure                                                            */
  __OM  uint32_t  KR;                           /*!< (@ 0x00000000) Key register                                               */
  __IOM uint32_t  PR;                           /*!< (@ 0x00000004) Prescaler register                                         */
  __IOM uint32_t  RLR;                          /*!< (@ 0x00000008) Reload register                                            */
  __IM  uint32_t  SR;                           /*!< (@ 0x0000000C) Status register                                            */
  __IOM uint32_t  WINR;                         /*!< (@ 0x00000010) Window register                                            */
} IWDG_TypeDef;                                 /*!< Size = 20 (0x14)                                                          */


/* =========================================================================================================================== */
/* ================                                            I2C                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Inter-integrated circuit (I2C)
  */

typedef struct {                                /*!< I2C Structure                                                             */
  __IOM uint32_t  CR1;                          /*!< (@ 0x00000000) Control register 1                                         */
  __IOM uint32_t  CR2;                          /*!< (@ 0x00000004) Control register 2                                         */
  __IOM uint32_t  OAR1;                         /*!< (@ 0x00000008) Own address register 1                                     */
  __IOM uint32_t  OAR2;                         /*!< (@ 0x0000000C) Own address register 2                                     */
  __IOM uint32_t  TIMINGR;                      /*!< (@ 0x00000010) Timing register                                            */
  __IOM uint32_t  TIMEOUTR;                     /*!< (@ 0x00000014) Status register 1                                          */
  __IOM uint32_t  ISR;                          /*!< (@ 0x00000018) Interrupt and Status register                              */
  __OM  uint32_t  ICR;                          /*!< (@ 0x0000001C) Interrupt clear register                                   */
  __IM  uint32_t  PECR;                         /*!< (@ 0x00000020) PEC register                                               */
  __IM  uint32_t  RXDR;                         /*!< (@ 0x00000024) Receive data register                                      */
  __IOM uint32_t  TXDR;                         /*!< (@ 0x00000028) Transmit data register                                     */
} I2C_TypeDef;                                  /*!< Size = 44 (0x2c)                                                          */



/* =========================================================================================================================== */
/* ================                                           FLASH                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief FLASH (FLASH)
  */

typedef struct {                                /*!< FLASH Structure                                                           */
  __IOM uint32_t  COMMAND;                      /*!< (@ 0x00000000) Command register                                           */
  __IOM uint32_t  CONFIG;                       /*!< (@ 0x00000004) Configuration register                                     */
  __IOM uint32_t  IRQSTAT;                      /*!< (@ 0x00000008) The interrupt status register shows the masked
                                                                    version of the interrupt raw register.                     */
  __IOM uint32_t  IRQMASK;                      /*!< (@ 0x0000000C) The mask bit in IRQMASK will mask the condition
                                                                    in the status register IRQSTAT and prevent
                                                                    the generation of the interrupt.                           */
  __IOM uint32_t  IRQRAW;                       /*!< (@ 0x00000010) The raw status register shows the unmasked condition
                                                                    of interrupt events.                                       */
  __IOM uint32_t  SIZE;                         /*!< (@ 0x00000014) SIZE register                                              */
  __IOM uint32_t  ADDRESS;                      /*!< (@ 0x00000018) Address register                                           */
  __IM  uint32_t  RESERVED[3];
  __IOM uint32_t  TIMETRIM1;                    /*!< (@ 0x00000028) Time trim registers 1                                      */
  __IOM uint32_t  TIMETRIM2;                    /*!< (@ 0x0000002C) Time trim registers 2                                      */
  __IOM uint32_t  TIMETRIM3;                    /*!< (@ 0x00000030) Time trim registers 3                                      */
  __IOM uint32_t  PAGEPROT0;                    /*!< (@ 0x00000034) Main Flash page protection register 0                      */ 
  __IOM uint32_t  PAGEPROT1;                    /*!< (@ 0x00000038) Main Flash page protection register 1                      */ 
  __IM  uint32_t  RESERVED1;
  __IOM uint32_t  DATA0;                        /*!< (@ 0x00000040) Data register 0                                            */
  __IOM uint32_t  DATA1;                        /*!< (@ 0x00000044) Data register 1                                            */
  __IOM uint32_t  DATA2;                        /*!< (@ 0x00000048) Data register 2                                            */
  __IOM uint32_t  DATA3;                        /*!< (@ 0x0000004C) Data register 3                                            */
} FLASH_TypeDef;                                /*!< Size = 80 (0x50)                                                          */



/* =========================================================================================================================== */
/* ================                                            SPI                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Serial peripheral interface/Inter-IC sound (SPI)
  */

typedef struct {                                /*!< SPI Structure                                                             */
  __IOM uint32_t  CR1;                          /*!< (@ 0x00000000) Control register 1                                         */
  __IOM uint32_t  CR2;                          /*!< (@ 0x00000004) Control register 2                                         */
  __IOM uint32_t  SR;                           /*!< (@ 0x00000008) Status register                                            */
  __IOM uint32_t  DR;                           /*!< (@ 0x0000000C) Data register                                              */
  __IOM uint32_t  CRCPR;                        /*!< (@ 0x00000010) CRC polynomial register                                    */
  __IM uint32_t   RXCRCR;                       /*!< (@ 0x00000014) RX CRC register                                            */
  __IM uint32_t   TXCRCR;                       /*!< (@ 0x00000018) TX CRC register                                            */
  __IOM uint32_t  I2SCFGR;                      /*!< (@ 0x0000001C) I2S configuration register                                 */
  __IOM uint32_t  I2SPR;                        /*!< (@ 0x00000020) I2S prescaler register                                     */
} SPI_TypeDef;                                  /*!< Size = 36 (0x24)                                                          */



/* =========================================================================================================================== */
/* ================                                            RCC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Reset and clock control (RCC)
  */

typedef struct {                                /*!< RCC Structure                                                             */
  __IOM uint32_t  CR;                           /*!< (@ 0x00000000) Clock control register                                     */
  __IOM uint32_t  ICSCR;                        /*!< (@ 0x00000004) Internal clock sources calibration register                */
  __IOM uint32_t  CFGR;                         /*!< (@ 0x00000008) Clock configuration register                               */
  __IOM uint32_t  CSSWCR;                       /*!< (@ 0x0000000C) Clocks Sources Software Calibration register               */
  __IM  uint32_t  RESERVED[2];
  __IOM uint32_t  CIER;                         /*!< (@ 0x00000018) Clock interrupt enable register                            */
  __IOM uint32_t  CIFR;                         /*!< (@ 0x0000001C) Clock interrupt flag register                              */
  __IOM uint32_t  CSCMDR;                       /*!< (@ 0x00000020) Clock Switch Command register                              */ 
  __IM  uint32_t  RESERVED1[3];
  __IOM uint32_t  AHBRSTR;                      /*!< (@ 0x00000030) AHB0 macro cells reset register                            */
  __IOM uint32_t  APB0RSTR;                     /*!< (@ 0x00000034) APB0 macro cells reset register                            */
  __IOM uint32_t  APB1RSTR;                     /*!< (@ 0x00000038) APB1 peripheral reset register 1                           */
  __IM  uint32_t  RESERVED2;
  __IOM uint32_t  APB2RSTR;                     /*!< (@ 0x00000040) APB2 peripheral reset register 2                           */
  __IM  uint32_t  RESERVED3[3];
  __IOM uint32_t  AHBENR;                       /*!< (@ 0x00000050) AHB0 macro cells clock enable register                     */
  __IOM uint32_t  APB0ENR;                      /*!< (@ 0x00000054) APB0 macro cells clock enable register                     */
  __IOM uint32_t  APB1ENR;                      /*!< (@ 0x00000058) APB1ENR1                                                   */
  __IM  uint32_t  RESERVED4;
  __IOM uint32_t  APB2ENR;                      /*!< (@ 0x00000060) APB2ENR                                                    */
  __IM  uint32_t  RESERVED5[12];
  __IOM uint32_t  CSR;                          /*!< (@ 0x00000094) CSR                                                        */
  __IOM uint32_t  RFSWHSECR;                    /*!< (@ 0x00000098) RF Software High Speed External register                   */
  __IM  uint32_t  RFHSECR;                      /*!< (@ 0x0000009C) RF High Speed External register                            */
} RCC_TypeDef;                                  /*!< Size = 160 (0xA0)                                                         */



/* =========================================================================================================================== */
/* ================                                            PWR                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Power control (PWR)
  */

typedef struct {                                /*!< PWR Structure                                                             */
  __IOM uint32_t  CR1;                          /*!< (@ 0x00000000) Power control register 1                                   */
  __IOM uint32_t  CR2;                          /*!< (@ 0x00000004) Power control register 2                                   */
  __IOM uint32_t  CR3;                          /*!< (@ 0x00000008) Power control register 3                                   */
  __IOM uint32_t  CR4;                          /*!< (@ 0x0000000C) Power control register 4                                   */
  __IOM uint32_t  SR1;                          /*!< (@ 0x00000010) Power status register 1                                    */
  __IM  uint32_t  SR2;                          /*!< (@ 0x00000014) Power status register 2                                    */
  __IM  uint32_t  RESERVED;
  __IOM uint32_t  CR5;                          /*!< (@ 0x0000001C) Power control register 5                                   */
  __IOM uint32_t  PUCRA;                        /*!< (@ 0x00000020) Power Port A pull-up control register                      */
  __IOM uint32_t  PDCRA;                        /*!< (@ 0x00000024) Power Port A pull-down control register                    */
  __IOM uint32_t  PUCRB;                        /*!< (@ 0x00000028) Power Port B pull-up control register                      */
  __IOM uint32_t  PDCRB;                        /*!< (@ 0x0000002C) Power Port B pull-down control register                    */
  __IOM uint32_t  CR6;                          /*!< (@ 0x00000030) Power control register 6                                   */
  __IOM uint32_t  CR7;                          /*!< (@ 0x00000034) Power control register 7                                   */
  __IOM  uint32_t SR3;                          /*!< (@ 0x00000038) Power status register 3                                    */
  __IM  uint32_t  RESERVED1;
  __IOM uint32_t  IOxCFG;                       /*!< (@ 0x00000040) IO DEEPSTOP drive configuration register                   */
  __IM  uint32_t  RESERVED2[16];
  __IOM uint32_t  DBGR;                         /*!< (@ 0x00000084) Debug register                                             */
  __IOM uint32_t  EXTSRR;                       /*!< (@ 0x00000088) Power status clear register                                */
  __IOM uint32_t  DBGSMPS;                      /*!< (@ 0x0000008C) This register drives some control signals for
                                                                    the SMPS                                                   */
  __IM  uint32_t  TRIMR;                        /*!< (@ 0x00000090) This register provides the trimming values applied
                                                                    by hardware according to the trimmingdone
                                                                    at EWS.                                                    */
  __IOM uint32_t  ENGTRIM;                      /*!< (@ 0x00000094) This register allows the software overloading
                                                                    the hardware trimming flashed at EWS.                      */
  __IM  uint32_t  DBG1;                         /*!< (@ 0x00000098) This register shows the current states of the
                                                                    FLASH FSM and SMPS FSM.                                    */
  __IM  uint32_t  DBG2;                         /*!< (@ 0x0000009C) This register shows the current states of the
                                                                    FLASH FSM and SMPS FSM.                                    */
} PWR_TypeDef;                                  /*!< Size = 160 (0xA0)                                                         */



/* =========================================================================================================================== */
/* ================                                          SYSCFG                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief System configuration controller (SYSCFG)
  */

typedef struct {                                /*!< SYSCFG Structure                                                          */
  __IM  uint32_t  DIE_ID;                       /*!< (@ 0x00000000) This register provides the device version and
                                                                    cut information.                                           */
  __IM  uint32_t  JTAG_ID;                      /*!< (@ 0x00000004) This register provides the JTAG ID of the BlueNRG-LP.      */
  __IOM uint32_t  I2C_FMP_CTRL;                 /*!< (@ 0x00000008) This register allows activating the Fast-mode
                                                                    Plus driving capability on I2C open-drain
                                                                    pads.                                                      */
  __IOM uint32_t  IO_DTR;                       /*!< (@ 0x0000000C) IO_DTR                                                     */
  __IOM uint32_t  IO_IBER;                      /*!< (@ 0x00000010) IO_IBER                                                    */
  __IOM uint32_t  IO_IEVR;                      /*!< (@ 0x00000014) I/O Interrupt polarity event register                      */
  __IOM uint32_t  IO_IER;                       /*!< (@ 0x00000018) I/O Interrupt Enable register                              */
  __IOM uint32_t  IO_ISCR;                      /*!< (@ 0x0000001C) I/O Interrupt Status and Clear register                    */
  __IOM uint32_t  PWRC_IER;                     /*!< (@ 0x00000020) This register allows control of the enable or
                                                                    mask on the interrupt sources of the Power
                                                                    Controller (PWRC) block.                                   */
  __IOM uint32_t  PWRC_ISCR;                    /*!< (@ 0x00000024) Power Controller Interrupt Status and Clear register       */
  __IOM uint32_t  GPIO_SWA_CTRL;                /*!< (@ 0x00000028) I/O analog switch control register                         */
  __IOM uint32_t  BLERXTX_DTR;                  /*!< (@ 0x0000002C) MR_BLE RX or TX sequence information 
                                                                    detection type register                                    */
  __IOM uint32_t  BLERXTX_IBER;                 /*!< (@ 0x00000030) MR_BLE RX or TX sequence information 
                                                                    detection type register                                    */
  __IOM uint32_t  BLERXTX_IEVR;                 /*!< (@ 0x00000034) MR_BLE RX or TX sequence information 
                                                                    detection event register                                   */
  __IOM uint32_t  BLERXTX_IER;                  /*!< (@ 0x00000038) MR_BLE RX or TX Interrupt Enable Register                  */
  __IOM uint32_t  BLERXTX_ISCR;                 /*!< (@ 0x0000003C) MR_BLE RX or TX sequence information detection 
                                                                    status and clear register                                  */
} SYSCFG_TypeDef;                               /*!< Size = 64 (0x40)                                                          */



/* =========================================================================================================================== */
/* ================                                            RNG                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Random number generator (RNG)
  */

typedef struct {                                /*!< RNG Structure                                                             */
  __IOM uint32_t  CR;                           /*!< (@ 0x00000000) Control register                                           */
  __IOM uint32_t  SR;                           /*!< (@ 0x00000004) Status register                                            */
  __IM  uint32_t  VAL;                          /*!< (@ 0x00000008) Data register                                              */
} RNG_TypeDef;                                  /*!< Size = 12 (0xC)                                                           */



/* =========================================================================================================================== */
/* ================                                           GPIO                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief General-purpose I/Os (GPIO)
  */

typedef struct {                                /*!< GPIO Structure                                                            */
  __IOM uint32_t  MODER;                        /*!< (@ 0x00000000) GPIO port mode register                                    */
  __IOM uint32_t  OTYPER;                       /*!< (@ 0x00000004) GPIO port output type register                             */
  __IOM uint32_t  OSPEEDR;                      /*!< (@ 0x00000008) GPIO port output speed register                            */
  __IOM uint32_t  PUPDR;                        /*!< (@ 0x0000000C) GPIO port pull-up/pull-down register                       */
  __IM  uint32_t  IDR;                          /*!< (@ 0x00000010) GPIO port input data register                              */
  __IOM uint32_t  ODR;                          /*!< (@ 0x00000014) GPIO port output data register                             */
  __OM  uint32_t  BSRR;                         /*!< (@ 0x00000018) GPIO port bit set/reset register                           */
  __IOM uint32_t  LCKR;                         /*!< (@ 0x0000001C) GPIO port configuration lock register                      */  
  __IOM uint32_t  AFR[2];                       /*!< (@ 0x00000020) GPIO alternate function register                           */
  __OM  uint32_t  BRR;                          /*!< (@ 0x00000028) GPIO bit reset register                                    */
} GPIO_TypeDef;                                 /*!< Size = 44 (0x2C)                                                          */



/* =========================================================================================================================== */
/* ================                                            TIM                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Advanced-timers (TIM)
  */

typedef struct {                                /*!< TIM Structure                                                             */
  __IOM uint32_t  CR1;                          /*!< (@ 0x00000000) Control register 1                                         */
  __IOM uint32_t  CR2;                          /*!< (@ 0x00000004) Control register 2                                         */
  __IOM uint32_t  SMCR;                         /*!< (@ 0x00000008) Slave mode control register                                */
  __IOM uint32_t  DIER;                         /*!< (@ 0x0000000C) Interrupt enable register                              */
  __IOM uint32_t  SR;                           /*!< (@ 0x00000010) Status register                                            */
  __OM  uint32_t  EGR;                          /*!< (@ 0x00000014) Event generation register                                  */
  __IOM uint32_t  CCMR1;                        /*!< (@ 0x00000018) Input capture and output compare mode register 1           */
  __IOM uint32_t  CCMR2;                        /*!< (@ 0x0000001C) Input capture and output compare mode register 2           */
  __IOM uint32_t  CCER;                         /*!< (@ 0x00000020) Capture/compare enable register                            */
  __IOM uint32_t  CNT;                          /*!< (@ 0x00000024) Counter                                                    */
  __IOM uint32_t  PSC;                          /*!< (@ 0x00000028) Prescaler                                                  */
  __IOM uint32_t  ARR;                          /*!< (@ 0x0000002C) Auto-reload register                                       */
  __IOM uint32_t  RCR;                          /*!< (@ 0x00000030) Repetition counter register                                */
  __IOM uint32_t  CCR1;                         /*!< (@ 0x00000034) Capture/compare register 1                                 */
  __IOM uint32_t  CCR2;                         /*!< (@ 0x00000038) Capture/compare register 2                                 */
  __IOM uint32_t  CCR3;                         /*!< (@ 0x0000003C) Capture/compare register 3                                 */
  __IOM uint32_t  CCR4;                         /*!< (@ 0x00000040) Capture/compare register 4                                 */
  __IOM uint32_t  BDTR;                         /*!< (@ 0x00000044) Break and dead-time register                               */
  __IM  uint32_t  RESERVED[3];  
  __IOM uint32_t  CCMR3;                        /*!< (@ 0x00000054) Output compare mode register 3                             */
  __IOM uint32_t  CCR5;                         /*!< (@ 0x00000058) Capture/compare register 4                                 */
  __IOM uint32_t  CCR6;                         /*!< (@ 0x0000005C) Capture/compare register 4                                 */
  __IOM uint32_t  AF1;                          /*!< (@ 0x00000060) TIM1 alternate function option register 1                  */
  __IOM uint32_t  AF2;                          /*!< (@ 0x00000064) TIM1 alternate function option register 2                  */
} TIM_TypeDef;                                  /*!< Size = 104 (0x68)                                                         */



/* =========================================================================================================================== */
/* ================                                           USART                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Universal synchronous asynchronous receiver transmitter (USART)
  */

typedef struct {                                /*!< USART Structure                                                           */
  __IOM uint32_t  CR1;                          /*!< (@ 0x00000000) Control register 1                                         */
  __IOM uint32_t  CR2;                          /*!< (@ 0x00000004) Control register 2                                         */
  __IOM uint32_t  CR3;                          /*!< (@ 0x00000008) Control register 3                                         */
  __IOM uint32_t  BRR;                          /*!< (@ 0x0000000C) Baud rate register                                         */
  __IOM uint32_t  GTPR;                         /*!< (@ 0x00000010) Guard time and prescaler register                          */
  __IOM uint32_t  RTOR;                         /*!< (@ 0x00000014) Receiver timeout register                                  */
  __IOM uint32_t  RQR;                          /*!< (@ 0x00000018) Request register                                           */
  __IM  uint32_t  ISR;                          /*!< (@ 0x0000001C) Interrupt & status register                                */
  __OM  uint32_t  ICR;                          /*!< (@ 0x00000020) Interrupt flag clear register                              */
  __IM  uint32_t  RDR;                          /*!< (@ 0x00000024) Receive data register                                      */
  __IOM uint32_t  TDR;                          /*!< (@ 0x00000028) Transmit data register                                     */
  __IOM uint32_t  PRESC;                        /*!< (@ 0x0000002C) Prescaler register                                         */
} USART_TypeDef;                                /*!< Size = 48 (0x30)                                                          */


/* =========================================================================================================================== */
/* ================                                            RTC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Real-time clock (RTC)
  */

typedef struct {                                /*!< RTC Structure                                                             */    
  __IOM uint32_t  TR;                           /*!< (@ 0x00000000) Time register                                              */
  __IOM uint32_t  DR;                           /*!< (@ 0x00000004) Date register                                              */
  __IOM uint32_t  CR;                           /*!< (@ 0x00000008) Control register                                           */
  __IOM uint32_t  ISR;                          /*!< (@ 0x0000000C) Initialization and status register                         */
  __IOM uint32_t  PRER;                         /*!< (@ 0x00000010) Prescaler register                                         */
  __IOM uint32_t  WUTR;                         /*!< (@ 0x00000014) Wakeup timer register                                      */
  __IM  uint32_t  RESERVED;
  __IOM uint32_t  ALRMAR;                       /*!< (@ 0x0000001C) Alarm A register                                           */
  __IM  uint32_t  RESERVED1;
  __OM  uint32_t  WPR;                          /*!< (@ 0x00000024) Write protection register                                  */
  __IM  uint32_t  SSR;                          /*!< (@ 0x00000028) Sub second register                                        */
  __OM  uint32_t  SHIFTR;                       /*!< (@ 0x0000002C) Shift control register                                     */
  __IM  uint32_t  RESERVED2[3];
  __IOM uint32_t  CALR;                         /*!< (@ 0x0000003C) Calibration register                                       */
  __IM  uint32_t  RESERVED3;
  __IOM uint32_t  ALRMASSR;                     /*!< (@ 0x00000044) Alarm A sub second register                                */
  __IM  uint32_t  RESERVED4[2];
  __IOM uint32_t  BKP0R;                        /*!< (@ 0x00000050) Backup register 0                                          */
  __IOM uint32_t  BKP1R;                        /*!< (@ 0x00000054) Backup register 1                                          */
} RTC_TypeDef;                                  /*!< Size = 88 (0x58)                                                          */



/* =========================================================================================================================== */
/* ================                                            PKA                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief PKA (PKA)
  */

typedef struct {                                /*!< PKA Structure                                                             */
  __IOM uint32_t  CSR;                          /*!< (@ 0x00000000) Command and status register                                */
  __IOM uint32_t  ISR;                          /*!< (@ 0x00000004) Interrupt register                                         */
  __IOM uint32_t  IEN;                          /*!< (@ 0x00000008) Interrupt enable register                                  */
} PKA_TypeDef;                                  /*!< Size = 12 (0x0C)                                                          */


  
/* =========================================================================================================================== */
/* ================                                            ADC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief ADC (ADC)
  */

typedef struct {                                /*!< ADC Structure                                                             */
  __IM  uint32_t  VERSION_ID;                   /*!< (@ 0x00000000) VERSION_ID register                                        */
  __IOM uint32_t  CONF;                         /*!< (@ 0x00000004) ADC configuration register                                 */
  __IOM uint32_t  CTRL;                         /*!< (@ 0x00000008) ADC control register                                       */
  __IOM uint32_t  OCM_CTRL;                     /*!< (@ 0x0000000C) Occasionnal mode control register                          */
  __IOM uint32_t  PGA_CONF;                     /*!< (@ 0x00000010) PGA configuration register                                 */
  __IOM uint32_t  SWITCH;                       /*!< (@ 0x00000014) ADC switch control for Input Selection                     */
  __IOM uint32_t  DF_CONF;                      /*!< (@ 0x00000018) Decimation filter configuration register                   */
  __IOM uint32_t  DS_CONF;                      /*!< (@ 0x0000001C) Downsampler configuration register                         */
  __IOM uint32_t  SEQ_1;                        /*!< (@ 0x00000020) ADC regular sequence configuration register 1              */
  __IOM uint32_t  SEQ_2;                        /*!< (@ 0x00000024) ADC regular sequence configuration register 2              */
  __IOM uint32_t  COMP_1;                       /*!< (@ 0x00000028) ADC Gain & offset correction values register 1             */
  __IOM uint32_t  COMP_2;                       /*!< (@ 0x0000002C) ADC Gain & offset correction values register 2             */
  __IOM uint32_t  COMP_3;                       /*!< (@ 0x00000030) ADC Gain & offset correction values register 3             */
  __IOM uint32_t  COMP_4;                       /*!< (@ 0x00000034) ADC Gain & offset correction values register 4             */
  __IOM uint32_t  COMP_SEL;                     /*!< (@ 0x00000038) ADC Gain & Offset selection values register                */
  __IOM uint32_t  WD_TH;                        /*!< (@ 0x0000003C) High/low limits for event monitoring a channel register    */
  __IOM uint32_t  WD_CONF;                      /*!< (@ 0x00000040) Channel selection for event monitoring register            */
  __IM  uint32_t  DS_DATAOUT;                   /*!< (@ 0x00000044) Downsampler Data output register                           */
  __IM  uint32_t  DF_DATAOUT;                   /*!< (@ 0x00000048) Decimation filter Data output register                     */
  __IOM uint32_t  IRQ_STATUS;                   /*!< (@ 0x0000004C) Interrupt Status register                                  */
  __IOM uint32_t  IRQ_ENABLE;                   /*!< (@ 0x00000050) Enable/disable Interrupts                                  */
  __IOM uint32_t  TIMER_CONF;                   /*!< (@ 0x00000054) Time to add after an LDO Enable or ADC Enable 
                                                                    to let the HW to be stable before using it                 */
} ADC_TypeDef;                                  /*!< Size = 88 (0x58)                                                          */



/* =========================================================================================================================== */
/* ================                                     AHBUPCONV                                             ================ */
/* =========================================================================================================================== */


/**
  * @brief AHBUPCONV (AHBUPCONV)
  */

typedef struct {                                /*!< AHBUPCONV structure                                                       */
  __IOM uint32_t  COMMAND;                      /*!< (@ 0x00000000) Command register                                           */
  __IM  uint32_t  STATUS;                       /*!< (@ 0x00000004) Status register                                            */
} AHBUPCONV_TypeDef;                            /*!< Size = 8 (0x8)                                                            */



/* =========================================================================================================================== */
/* ================                                     BLUE                                                  ================ */
/* =========================================================================================================================== */


/**
  * @brief BLUE Radio (BLUE)
  */

typedef struct {                                /*!< BLUE structure                                                            */
  __IM  uint32_t  CONTROLLERVERNUMREG;          /*!< (@ 0x00000000) Controller Version Number register                         */
  __IOM uint32_t  INTERRUPT1REG;                /*!< (@ 0x00000004) Interrupt1 register                                        */
  __IOM uint32_t  INTERRUPT2REG;                /*!< (@ 0x00000008) Interrupt2 register                                        */
  __IOM uint32_t  TIMEOUTDESTREG;               /*!< (@ 0x0000000C) TimeoutDest register                                       */
  __IOM uint32_t  TIMEOUTREG;                   /*!< (@ 0x00000010) Timeout register                                           */
  __IM  uint32_t  TIMERCAPTUREREG;              /*!< (@ 0x00000014) TimerCapture register                                      */
  __IOM uint32_t  CMDREG;                       /*!< (@ 0x00000018) Cmd register                                               */
  __IM  uint32_t  STATUSREG;                    /*!< (@ 0x0000001C) Status register                                            */
  __IM  uint32_t  INTERRUPT1ENABLEREG;          /*!< (@ 0x00000020) Interrupt1Enable register                                  */
  __IM  uint32_t  INTERRUPT1LATENCYREG;         /*!< (@ 0x00000024) Interrupt1Latency register                                 */
  __IOM uint32_t  MANAESKEY0REG;                /*!< (@ 0x00000028) ManAesKey0 register                                        */
  __IOM uint32_t  MANAESKEY1REG;                /*!< (@ 0x0000002C) ManAesKey1 register                                        */
  __IOM uint32_t  MANAESKEY2REG;                /*!< (@ 0x00000030) ManAesKey2 register                                        */
  __IOM uint32_t  MANAESKEY3REG;                /*!< (@ 0x00000034) ManAesKey3 register                                        */
  __IOM uint32_t  MANAESCLEARTEXT0REG;          /*!< (@ 0x00000038) ManAesClearText0 register                                  */
  __IOM uint32_t  MANAESCLEARTEXT1REG;          /*!< (@ 0x0000003C) ManAesClearText1 register                                  */
  __IOM uint32_t  MANAESCLEARTEXT2REG;          /*!< (@ 0x00000040) ManAesClearText2 register                                  */
  __IOM uint32_t  MANAESCLEARTEXT3REG;          /*!< (@ 0x00000044) ManAesClearText3 register                                  */
  __IM  uint32_t  MANAESCIPHERTEXT0REG;         /*!< (@ 0x00000048) ManAESCipherText0 register                                 */
  __IM  uint32_t  MANAESCIPHERTEXT1REG;         /*!< (@ 0x0000004C) ManAESCipherText1 register                                 */
  __IM  uint32_t  MANAESCIPHERTEXT2REG;         /*!< (@ 0x00000050) ManAESCipherText2 register                                 */
  __IM  uint32_t  MANAESCIPHERTEXT3REG;         /*!< (@ 0x00000054) ManAESCipherText3 register                                 */
  __IOM uint32_t  MANAESCMDREG;                 /*!< (@ 0x00000058) ManAESCmd register                                         */
  __IM  uint32_t  MANAESSTATREG;                /*!< (@ 0x0000005C) ManAESStat register                                        */
  __IOM uint32_t  AESLEPRIVPOINTERREG;          /*!< (@ 0x00000060) AesLePrivPointer register                                  */
  __IOM uint32_t  AESLEPRIVHASHREG;             /*!< (@ 0x00000064) AesLePrivHash register                                     */
  __IOM uint32_t  AESLEPRIVPRANDREG;            /*!< (@ 0x00000068) AesLePrivPrand register                                    */
  __IOM uint32_t  AESLEPRIVCMDREG;              /*!< (@ 0x0000006C) AesLePrivCmd register                                      */
  __IM  uint32_t  AESLEPRIVSTATREG;             /*!< (@ 0x00000070) AesLePrivStat register                                     */
  __IOM uint32_t  DEBUGCMDREG;                  /*!< (@ 0x00000074) DebugCmd register                                          */
  __IM  uint32_t  DEBUGSTATUSREG;               /*!< (@ 0x00000078) DebugStatus register                                       */
  __IM  uint32_t  RESERVED;
} BLUE_TypeDef;                                 /*!< Size = 128 (0x80)                                                         */



/* =========================================================================================================================== */
/* ================                                     RADIO_CTRL                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Radio Controller (RADIO_CTRL)
  */

typedef struct {                                /*!< Radio Control structure                                                   */
  __IM   uint32_t  RADIO_CONTROL_ID;            /*!< (@ 0x00000000) Radio Controller ID register                               */
  __IOM  uint32_t  CLK32COUNT_REG;              /*!< (@ 0x00000004) Window length register                                     */
  __IOM  uint32_t  CLK32PERIOD_REG;             /*!< (@ 0x00000008) Slow clock period register                                 */
  __IM   uint32_t  CLK32FREQUENCY_REG;          /*!< (@ 0x0000000C) Slow clock frequency register                              */
  __IOM  uint32_t  RADIO_CONTROL_IRQ_STATUS;    /*!< (@ 0x00000010) Radio Controller Interrupt Status register                 */
  __IOM  uint32_t  RADIO_CONTROL_IRQ_ENABLE;    /*!< (@ 0x00000014) Radio Controller Interrupt Control register                */
  __IM   uint32_t  RESERVED;
} RADIO_CTRL_TypeDef;                           /*!< Size = 28 (0x1C)                                                          */



/* =========================================================================================================================== */
/* ================                                     RRM                                                   ================ */
/* =========================================================================================================================== */


 /**
  * @brief RRM (RRM)
  */

typedef struct {                                /*!<  RRM structure                                                            */
  __IM   uint32_t  RRM_ID;		        /*!<  (@ 0x00) RRM_ID register                                                 */ 
  __IOM  uint32_t  RRM_CTRL;		        /*!<  (@ 0x04) RRM_CTRL register                                               */ 
  __IM   uint32_t  RESERVED[2];
  __IOM  uint32_t  UDRA_CTRL0;		        /*!<  (@ 0x10) UDRA_CTRL0 register                                             */ 
  __IOM  uint32_t  UDRA_IRQ_ENABLE;		/*!<  (@ 0x14) UDRA_IRQ_ENABLE register                                        */ 
  __IOM  uint32_t  UDRA_IRQ_STATUS;		/*!<  (@ 0x18) UDRA_IRQ_STATUS register                                        */ 
  __IM   uint32_t  UDRA_RADIO_CFG_PTR;		/*!<  (@ 0x1C) UDRA_RADIO_CFG_PTR register                                     */ 
  __IOM  uint32_t  SEMA_IRQ_ENABLE;		/*!<  (@ 0x20) SEMA_IRQ_ENABLE register                                        */ 
  __IM   uint32_t  SEMA_IRQ_STATUS;		/*!<  (@ 0x24) SEMA_IRQ_STATUS register                                        */ 
  __IOM  uint32_t  BLE_IRQ_ENABLE;		/*!<  (@ 0x28) BLE_IRQ_ENABLE register                                         */ 
  __IOM  uint32_t  BLE_IRQ_STATUS;		/*!<  (@ 0x2C) BLE_IRQ_STATUS register                                         */ 
  __IM   uint32_t  RESERVED1[12];
  __IOM  uint32_t  VP_CPU_CMD_BUS;		/*!<  (@ 0x60) VP_CPU_CMD_BUS register                                         */ 
  __IOM  uint32_t  VP_CPU_SEMA_BUS;		/*!<  (@ 0x64) VP_CPU_SEMA_BUS register                                        */ 
  __IOM  uint32_t  VP_CPU_IRQ_ENABLE;		/*!<  (@ 0x68) VP_CPU_IRQ_ENABLE register                                      */ 
  __IOM  uint32_t  VP_CPU_IRQ_STATUS;		/*!<  (@ 0x6C) VP_CPU_IRQ_STATUS register                                      */ 
  __IM   uint32_t  RESERVED2[36];
  __IOM  uint32_t  AA0_DIG_USR;		        /*!<  (@ 0x100+0x00) AA0_DIG_USR register                                      */ 
  __IOM  uint32_t  AA1_DIG_USR;		        /*!<  (@ 0x100+0x04) AA1_DIG_USR register                                      */ 
  __IOM  uint32_t  AA2_DIG_USR;		        /*!<  (@ 0x100+0x08) AA2_DIG_USR register                                      */ 
  __IOM  uint32_t  AA3_DIG_USR;		        /*!<  (@ 0x100+0x0C) AA3_DIG_USR register                                      */ 
  __IOM  uint32_t  DEM_MOD_DIG_USR;		/*!<  (@ 0x100+0x10) DEM_MOD_DIG_USR register                                  */ 
  __IOM  uint32_t  RADIO_FSM_USR;		/*!<  (@ 0x100+0x14) RADIO_FSM_USR register                                    */ 
  __IOM  uint32_t  PHYCTRL_DIG_USR;		/*!<  (@ 0x100+0x18) PHYCTRL_DIG_USR register                                  */ 
  __IM   uint32_t  RESERVED3[10];
  __IOM  uint32_t  AFC0_DIG_ENG;		/*!<  (@ 0x100+0x44) AFC0_DIG_ENG register                                     */ 
  __IOM  uint32_t  AFC1_DIG_ENG;		/*!<  (@ 0x100+0x48) AFC1_DIG_ENG register                                     */ 
  __IOM  uint32_t  AFC2_DIG_ENG;		/*!<  (@ 0x100+0x4C) AFC2_DIG_ENG register                                     */ 
  __IOM  uint32_t  AFC3_DIG_ENG;		/*!<  (@ 0x100+0x50) AFC3_DIG_ENG register                                     */
  __IOM  uint32_t  CR0_DIG_ENG;		        /*!<  (@ 0x100+0x54) CR0_DIG_ENG register                                      */ 
  __IM   uint32_t  RESERVED4[4];
  __IOM  uint32_t  CR0_LR;		        /*!<  (@ 0x100+0x68) CR0_LR register                                           */ 
  __IOM  uint32_t  VIT_CONF_DIG_ENG;		/*!<  (@ 0x100+0x6C) VIT_CONF_DIG_ENG register                                 */ 
  __IM   uint32_t  RESERVED5[5];
  __IOM  uint32_t  LR_PD_THR_DIG_ENG;		/*!<  (@ 0x100+0x84) LR_PD_THR_DIG_ENG register                                */ 
  __IOM  uint32_t  LR_RSSI_THR_DIG_ENG;		/*!<  (@ 0x100+0x88) LR_RSSI_THR_DIG_ENG register                              */ 
  __IOM  uint32_t  LR_AAC_THR_DIG_ENG;		/*!<  (@ 0x100+0x8C) LR_AAC_THR_DIG_ENG register                               */ 
  __IM   uint32_t  RESERVED6[19];
  __IOM  uint32_t  DTB0_DIG_ENG;		/*!<  (@ 0x100+0xDC) DTB0_DIG_ENG register                                     */ 
  __IM   uint32_t  RESERVED7[4];
  __IOM  uint32_t  DTB5_DIG_ENG;		/*!<  (@ 0x100+0xF0) DTB5_DIG_ENG register                                     */ 
  __IM   uint32_t  RESERVED8[16];
  __IOM  uint32_t  MOD0_DIG_TST;		/*!<  (@ 0x100+0x134) MOD0_DIG_TST register                                    */ 
  __IOM  uint32_t  MOD1_DIG_TST;		/*!<  (@ 0x100+0x138) MOD1_DIG_TST register                                    */ 
  __IOM  uint32_t  MOD2_DIG_TST;		/*!<  (@ 0x100+0x13C) MOD2_DIG_TST register                                    */ 
  __IOM  uint32_t  MOD3_DIG_TST;		/*!<  (@ 0x100+0x140) MOD3_DIG_TST register                                    */ 
  __IM   uint32_t  RESERVED9;
  __IOM  uint32_t  RXADC_ANA_USR;		/*!<  (@ 0x100+0x148) RXADC_ANA_USR register                                   */ 
  __IM   uint32_t  RESERVED10[2];
  __IOM  uint32_t  LDO_ANA_ENG;		        /*!<  (@ 0x100+0x154) LDO_ANA_ENG register                                     */ 
  __IM   uint32_t  RESERVED11[7];
  __IOM  uint32_t  CBIAS0_ANA_ENG;		/*!<  (@ 0x100+0x174) CBIAS0_ANA_ENG register                                  */ 
  __IOM  uint32_t  CBIAS1_ANA_ENG;		/*!<  (@ 0x100+0x178) CBIAS1_ANA_ENG register                                  */ 
  __IOM  uint32_t  CBIAS_ANA_TEST;		/*!<  (@ 0x100+0x17C) CBIAS_ANA_TEST register                                  */ 
  __IM   uint32_t  SYNTHCAL0_DIG_OUT;		/*!<  (@ 0x100+0x180) SYNTHCAL0_DIG_OUT register                               */ 
  __IM   uint32_t  SYNTHCAL1_DIG_OUT;		/*!<  (@ 0x100+0x184) SYNTHCAL1_DIG_OUT register                               */ 
  __IM   uint32_t  SYNTHCAL2_DIG_OUT;		/*!<  (@ 0x100+0x188) SYNTHCAL2_DIG_OUT register                               */ 
  __IM   uint32_t  SYNTHCAL3_DIG_OUT;		/*!<  (@ 0x100+0x18C) SYNTHCAL3_DIG_OUT register                               */ 
  __IM   uint32_t  SYNTHCAL4_DIG_OUT;		/*!<  (@ 0x100+0x190) SYNTHCAL4_DIG_OUT register                               */ 
  __IM   uint32_t  SYNTHCAL5_DIG_OUT;		/*!<  (@ 0x100+0x194) SYNTHCAL5_DIG_OUT register                               */ 
  __IM   uint32_t  FSM_STATUS_DIG_OUT;		/*!<  (@ 0x100+0x198) FSM_STATUS_DIG_OUT register                              */ 
  __IM   uint32_t  IRQ_STATUS_DIG_OUT;		/*!<  (@ 0x100+0x19C) IRQ_STATUS_DIG_OUT register                              */ 
  __IM   uint32_t  RESERVED12;
  __IM   uint32_t  RSSI0_DIG_OUT;		/*!<  (@ 0x100+0x1A4) RSSI0_DIG_OUT register                                   */ 
  __IM   uint32_t  RSSI1_DIG_OUT;		/*!<  (@ 0x100+0x1A8) RSSI1_DIG_OUT register                                   */ 
  __IM   uint32_t  AGC_DIG_OUT;		        /*!<  (@ 0x100+0x1AC) AGC_DIG_OUT register                                     */ 
  __IM   uint32_t  DEMOD_DIG_OUT;		/*!<  (@ 0x100+0x1B0) DEMOD_DIG_OUT register                                   */ 
  __IOM  uint32_t  AGC0_ANA_TST;		/*!<  (@ 0x100+0x1B4) AGC0_ANA_TST register                                    */ 
  __IOM  uint32_t  AGC1_ANA_TST;		/*!<  (@ 0x100+0x1B8) AGC1_ANA_TST register                                    */ 
  __IOM  uint32_t  AGC2_ANA_TST;		/*!<  (@ 0x100+0x1BC) AGC2_ANA_TST register                                    */ 
  __IOM  uint32_t  AGC0_DIG_ENG;		/*!<  (@ 0x100+0x1C0) AGC0_DIG_ENG register                                    */ 
  __IOM  uint32_t  AGC1_DIG_ENG;		/*!<  (@ 0x100+0x1C4) AGC1_DIG_ENG register                                    */ 
  __IOM  uint32_t  AGC2_DIG_ENG;		/*!<  (@ 0x100+0x1C8) AGC2_DIG_ENG register                                    */ 
  __IOM  uint32_t  AGC3_DIG_ENG;		/*!<  (@ 0x100+0x1CC) AGC3_DIG_ENG register                                    */ 
  __IOM  uint32_t  AGC4_DIG_ENG;		/*!<  (@ 0x100+0x1D0) AGC4_DIG_ENG register                                    */ 
  __IOM  uint32_t  AGC5_DIG_ENG;		/*!<  (@ 0x100+0x1D4) AGC5_DIG_ENG register                                    */ 
  __IOM  uint32_t  AGC6_DIG_ENG;		/*!<  (@ 0x100+0x1D8) AGC6_DIG_ENG register                                    */ 
  __IOM  uint32_t  AGC7_DIG_ENG;		/*!<  (@ 0x100+0x1DC) AGC7_DIG_ENG register                                    */ 
  __IOM  uint32_t  AGC8_DIG_ENG;		/*!<  (@ 0x100+0x1E0) AGC8_DIG_ENG register                                    */ 
  __IOM  uint32_t  AGC9_DIG_ENG;		/*!<  (@ 0x100+0x1E4) AGC9_DIG_ENG register                                    */ 
  __IOM  uint32_t  AGC10_DIG_ENG;		/*!<  (@ 0x100+0x1E8) AGC10_DIG_ENG register                                   */ 
  __IOM  uint32_t  AGC11_DIG_ENG;		/*!<  (@ 0x100+0x1EC) AGC11_DIG_ENG register                                   */ 
  __IOM  uint32_t  AGC12_DIG_ENG;		/*!<  (@ 0x100+0x1F0) AGC12_DIG_ENG register                                   */ 
  __IOM  uint32_t  AGC13_DIG_ENG;		/*!<  (@ 0x100+0x1F4) AGC13_DIG_ENG register                                   */ 
  __IOM  uint32_t  AGC14_DIG_ENG;		/*!<  (@ 0x100+0x1F8) AGC14_DIG_ENG register                                   */ 
  __IOM  uint32_t  AGC15_DIG_ENG;		/*!<  (@ 0x100+0x1FC) AGC15_DIG_ENG register                                   */ 
  __IOM  uint32_t  AGC16_DIG_ENG;		/*!<  (@ 0x100+0x200) AGC16_DIG_ENG register                                   */ 
  __IOM  uint32_t  AGC17_DIG_ENG;		/*!<  (@ 0x100+0x204) AGC17_DIG_ENG register                                   */ 
  __IOM  uint32_t  AGC18_DIG_ENG;		/*!<  (@ 0x100+0x208) AGC18_DIG_ENG register                                   */ 
  __IOM  uint32_t  AGC19_DIG_ENG;		/*!<  (@ 0x100+0x20C) AGC19_DIG_ENG register                                   */ 
  __IOM  uint32_t  AGC20_DIG_ENG;		/*!<  (@ 0x100+0x210) AGC20_DIG_ENG register                                   */ 
  __IM   uint32_t  RESERVED13[4];
  __IM   uint32_t  RXADC_HW_TRIM_OUT;           /*!<  (@ 0x100+0x224) RXADC_HW_TRIM_OUT register                               */ 
  __IM   uint32_t  CBIAS0_HW_TRIM_OUT;          /*!<  (@ 0x100+0x228) CBIAS0_HW_TRIM_OUT register                              */
  __IM   uint32_t  CBIAS1_HW_TRIM_OUT;          /*!<  (@ 0x100+0x22C) CBIAS1_HW_TRIM_OUT register                              */
  __IM   uint32_t  AGC_HW_TRIM_OUT;             /*!<  (@ 0x100+0x230) AGC_HW_TRIM_OUT register                                 */
  __IM   uint32_t  RESERVED14;
} RRM_TypeDef;                                  /*!< Size = 824 (0x338)                                                        */

  
  
/* =========================================================================================================================== */
/* ================                                     WAKEUP                                                ================ */
/* =========================================================================================================================== */


/**
  * @brief Wakeup (WAKEUP)
  */

typedef struct {                                /*!< Wakeup structure                                                          */
  __IM   uint32_t  WAKEUP_BLOCK_VERSION;        /*!< (@ 0x00000000) Wakeup block version register                              */
  __IM   uint32_t  RESERVED;
  __IOM  uint32_t  WAKEUP_OFFSET[2];            /*!< (@ 0x00000008) Wakeup offset_x register                                   */
  __IM   uint32_t  ABSOLUTE_TIME;               /*!< (@ 0x00000010) Absolute time register                                     */
  __IM   uint32_t  MINIMUM_PERIOD_LENGTH;       /*!< (@ 0x00000014) Minimum period length register                             */
  __IM   uint32_t  AVERAGE_PERIOD_LENGTH;       /*!< (@ 0x00000018) Average period length register                             */
  __IM   uint32_t  MAXIMUM_PERIOD_LENGTH;       /*!< (@ 0x0000001C) Maximum period length register                             */
  __IOM  uint32_t  STATISTICS_RESTART;          /*!< (@ 0x00000020) Statistics restart register                                */
  __IOM  uint32_t  BLUE_WAKEUP_TIME;            /*!< (@ 0x00000024) BLE wakeup time register                                   */
  __IOM  uint32_t  BLUE_SLEEP_REQUEST_MODE;     /*!< (@ 0x00000028) BLE sleep request mode register                            */
  __IOM  uint32_t  CM0_WAKEUP_TIME;             /*!< (@ 0x0000002C) CPU wakeup time register                                   */
  __IOM  uint32_t  CM0_SLEEP_REQUEST_MODE;      /*!< (@ 0x00000030) CPU sleep request mode register                            */
  __IM   uint32_t  RESERVED1[3];
  __IOM  uint32_t  WAKEUP_BLE_IRQ_ENABLE;       /*!< (@ 0x00000040) Wakeup BLE interrupt enable register                       */
  __IOM  uint32_t  WAKEUP_BLE_IRQ_STATUS;       /*!< (@ 0x00000044) Wakeup BLE interrupt status register                       */
  __IOM  uint32_t  WAKEUP_CM0_IRQ_ENABLE;       /*!< (@ 0x00000048) Wakeup CPU interrupt enable register                       */
  __IOM  uint32_t  WAKEUP_CM0_IRQ_STATUS;       /*!< (@ 0x0000004C) Wakeup CPU interrupt status register                       */
  __IM   uint32_t  RESERVED2;
} WAKEUP_TypeDef;                               /*!< Size = 84 (0x54)                                                          */


/** @} */ /* End of group Device_Peripheral_peripherals */


/* =========================================================================================================================== */
/* ================                          Device Specific Peripheral Address Map                           ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_peripheralAddr
  * @{
  */
#define NVM_BASE               (0x10040000U) /*!< Main FLASH base address */
#define SRAM_BASE              (0x20000000U) /*!< SRAM base address */
#define PERIPH_BASE            (0x40000000U) /*!< Peripheral base address */


/*!< Memory, OTP bytes */

/* Base addresses */
#define SYSTEM_MEMORY_BASE     (0x10000000U)   /*!< System Memory : 6KB (0x10000000 – 0x100017FF)  */
#define OTP_AREA_BASE          (0x10001800U)   /*!< OTP area : 1kB (0x10001800 – 0x10001BFF)       */

#define SRAM0_BASE             SRAM_BASE                 /*!< SRAM0 (16 KB) base address */
#define SRAM1_BASE            (SRAM_BASE + 0x00004000U)  /*!< SRAM1 (16 KB) base address       */
#define SRAM2_BASE            (SRAM_BASE + 0x00008000U)  /*!< SRAM2 (16 KB) base address       */
#define SRAM3_BASE            (SRAM_BASE + 0x0000C000U)  /*!< SRAM3 (16 KB) base address       */
  
/* End addresses */
#define SRAM0_END_ADDR         (0x20003FFFU)   /*!< RAM0  : 16KB (0x20000000 – 0x20003FFF)         */
#define SRAM1_END_ADDR         (0x20007FFFU)   /*!< RAM1  : 16KB (0x20000000 – 0x20007FFF)         */ 
#define SRAM2_END_ADDR         (0x2000BFFFU)   /*!< RAM2  : 16KB (0x20000000 – 0x2000BFFF)         */
#define SRAM3_END_ADDR         (0x2000FFFFU)   /*!< RAM3  : 16KB (0x20000000 – 0x2000FFFF)         */ 
 
#define SYSTEM_MEMORY_END_ADDR (0x100017FFU)   /*!< System Memory : 6KB (0x10000000 – 0x100017FF)   */
#define OTP_AREA_END_ADDR      (0x10001BFFU)   /*!< OTP area : 1KB (0x10001800 – 0x10001BFF)        */

/*!< Peripheral memory map */
#define APB0PERIPH_BASE        PERIPH_BASE
#define APB1PERIPH_BASE       (PERIPH_BASE + 0x01000000U)
#define AHBPERIPH_BASE        (PERIPH_BASE + 0x08000000U)
#define APB2PERIPH_BASE       (PERIPH_BASE + 0x20000000U)


/*!< APB0 peripherals */
#define SYSCFG_BASE        (APB0PERIPH_BASE + 0x0000U)
#define FLASH_BASE         (APB0PERIPH_BASE + 0x1000U)
#define TIM1_BASE          (APB0PERIPH_BASE + 0x2000U)
#define IWDG_BASE          (APB0PERIPH_BASE + 0x3000U)
#define RTC_BASE           (APB0PERIPH_BASE + 0x4000U)
#define AHBUPCONV_BASE     (APB0PERIPH_BASE + 0x5000U)

/*!< APB1 peripherals */
#define I2C1_BASE          (APB1PERIPH_BASE + 0x0000U)
#define I2C2_BASE          (APB1PERIPH_BASE + 0x1000U)
#define SPI1_BASE          (APB1PERIPH_BASE + 0x2000U)
#define SPI2_BASE          (APB1PERIPH_BASE + 0x3000U)
#define USART1_BASE        (APB1PERIPH_BASE + 0x4000U)  
#define LPUART1_BASE       (APB1PERIPH_BASE + 0x5000U)
#define ADC_BASE           (APB1PERIPH_BASE + 0x6000U)
#define SPI3_BASE          (APB1PERIPH_BASE + 0x7000U)

/*!< AHB peripherals */
#define GPIOA_BASE                 (AHBPERIPH_BASE + 0x000000UL)
#define GPIOB_BASE                 (AHBPERIPH_BASE + 0x100000UL)
#define CRC_BASE                   (AHBPERIPH_BASE + 0x200000UL)
#define PKA_BASE                   (AHBPERIPH_BASE + 0x300000UL)
#define PKA_RAM_BASE               (AHBPERIPH_BASE + 0x300400UL)  
#define RCC_BASE                   (AHBPERIPH_BASE + 0x400000UL)
#define PWR_BASE                   (AHBPERIPH_BASE + 0x500000UL)
#define RNG_BASE                   (AHBPERIPH_BASE + 0x600000UL)
#define DMA1_BASE                  (AHBPERIPH_BASE + 0x700000UL)
#define DMAMUX1_BASE               (AHBPERIPH_BASE + 0x800000UL)
  
#define DMA1_Channel1_BASE         (DMA1_BASE + 0x0008)
#define DMA1_Channel2_BASE         (DMA1_BASE + 0x001C)
#define DMA1_Channel3_BASE         (DMA1_BASE + 0x0030)
#define DMA1_Channel4_BASE         (DMA1_BASE + 0x0044)
#define DMA1_Channel5_BASE         (DMA1_BASE + 0x0058)
#define DMA1_Channel6_BASE         (DMA1_BASE + 0x006C)
#define DMA1_Channel7_BASE         (DMA1_BASE + 0x0080)
#define DMA1_Channel8_BASE         (DMA1_BASE + 0x0094)
  
#define DMAMUX1_Channel0_BASE      (DMAMUX1_BASE)
#define DMAMUX1_Channel1_BASE      (DMAMUX1_BASE + 0x00000004)
#define DMAMUX1_Channel2_BASE      (DMAMUX1_BASE + 0x00000008)
#define DMAMUX1_Channel3_BASE      (DMAMUX1_BASE + 0x0000000C)
#define DMAMUX1_Channel4_BASE      (DMAMUX1_BASE + 0x00000010)
#define DMAMUX1_Channel5_BASE      (DMAMUX1_BASE + 0x00000014)
#define DMAMUX1_Channel6_BASE      (DMAMUX1_BASE + 0x00000018)
#define DMAMUX1_Channel7_BASE      (DMAMUX1_BASE + 0x0000001C)

/*!< APB2 peripherals */
#define BLUE_BASE                  (APB2PERIPH_BASE + 0x0000U)
#define RADIO_CTRL_BASE            (APB2PERIPH_BASE + 0x1000U)
#define RRM_BASE                   (APB2PERIPH_BASE + 0x1400U)
#define WAKEUP_BASE                (APB2PERIPH_BASE + 0x1800U)
  
/** @} */ /* End of group Device_Peripheral_peripheralAddr */


/* =========================================================================================================================== */
/* ================                                  Peripheral declaration                                   ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_declaration
  * @{
  */


/* Peripherals available on APB0 bus */
#define SYSCFG                      ((SYSCFG_TypeDef*)           SYSCFG_BASE)
#define FLASH                       ((FLASH_TypeDef*)             FLASH_BASE)
#define TIM1                        ((TIM_TypeDef*)               TIM1_BASE)
#define IWDG                        ((IWDG_TypeDef*)               IWDG_BASE)
#define RTC                         ((RTC_TypeDef*)                 RTC_BASE)
#define AHBUPCONV                   ((AHBUPCONV_TypeDef*)     AHBUPCONV_BASE)

/* Peripherals available on APB1 bus */
#define I2C1                        ((I2C_TypeDef*)                I2C1_BASE)
#define I2C2                        ((I2C_TypeDef*)                I2C2_BASE)  
#define SPI1                        ((SPI_TypeDef*)                SPI1_BASE)
#define SPI2                        ((SPI_TypeDef*)                SPI2_BASE)
#define USART1                      ((USART_TypeDef*)            USART1_BASE)
#define LPUART1                     ((USART_TypeDef*)           LPUART1_BASE)
#define ADC                         ((ADC_TypeDef*)                 ADC_BASE)
#define SPI3                        ((SPI_TypeDef*)                SPI3_BASE)
  
/* Peripherals available on AHB bus */
#define GPIOA                       ((GPIO_TypeDef*)                                  GPIOA_BASE)
#define GPIOB                       ((GPIO_TypeDef*)                                  GPIOB_BASE)
#define CRC                         ((CRC_TypeDef*)                                     CRC_BASE)
#define PKA                         ((PKA_TypeDef*)                                     PKA_BASE)
#define RCC                         ((RCC_TypeDef*)                                     RCC_BASE)
#define PWR                         ((PWR_TypeDef*)                                     PWR_BASE)
#define RNG                         ((RNG_TypeDef*)                                     RNG_BASE)  
#define DMA1                        ((DMA_TypeDef*)                                    DMA1_BASE)
#define DMA1_Channel1               ((DMA_Channel_TypeDef *)                  DMA1_Channel1_BASE) 
#define DMA1_Channel2               ((DMA_Channel_TypeDef *)                  DMA1_Channel2_BASE) 
#define DMA1_Channel3               ((DMA_Channel_TypeDef *)                  DMA1_Channel3_BASE) 
#define DMA1_Channel4               ((DMA_Channel_TypeDef *)                  DMA1_Channel4_BASE) 
#define DMA1_Channel5               ((DMA_Channel_TypeDef *)                  DMA1_Channel5_BASE) 
#define DMA1_Channel6               ((DMA_Channel_TypeDef *)                  DMA1_Channel6_BASE) 
#define DMA1_Channel7               ((DMA_Channel_TypeDef *)                  DMA1_Channel7_BASE) 
#define DMA1_Channel8               ((DMA_Channel_TypeDef *)                  DMA1_Channel8_BASE) 
#define DMAMUX1                     ((DMAMUX_Channel_TypeDef *)                     DMAMUX1_BASE) 
#define DMAMUX1_Channel0            ((DMAMUX_Channel_TypeDef *)            DMAMUX1_Channel0_BASE) 
#define DMAMUX1_Channel1            ((DMAMUX_Channel_TypeDef *)            DMAMUX1_Channel1_BASE) 
#define DMAMUX1_Channel2            ((DMAMUX_Channel_TypeDef *)            DMAMUX1_Channel2_BASE) 
#define DMAMUX1_Channel3            ((DMAMUX_Channel_TypeDef *)            DMAMUX1_Channel3_BASE) 
#define DMAMUX1_Channel4            ((DMAMUX_Channel_TypeDef *)            DMAMUX1_Channel4_BASE) 
#define DMAMUX1_Channel5            ((DMAMUX_Channel_TypeDef *)            DMAMUX1_Channel5_BASE) 
#define DMAMUX1_Channel6            ((DMAMUX_Channel_TypeDef *)            DMAMUX1_Channel6_BASE) 
#define DMAMUX1_Channel7            ((DMAMUX_Channel_TypeDef *)            DMAMUX1_Channel7_BASE) 

/* Peripherals available on APB2 bus */
#define BLUE                        ((BLUE_TypeDef*)                BLUE_BASE)
#define RADIO_CTRL                  ((RADIO_CTRL_TypeDef*)    RADIO_CTRL_BASE)
#define RRM                         ((RRM_TypeDef*)                  RRM_BASE)
#define WAKEUP                      ((WAKEUP_TypeDef*)            WAKEUP_BASE)
  
/** @} */ /* End of group Device_Peripheral_declaration */

/* =========================================  End of section using anonymous unions  ========================================= */
#if defined (__CC_ARM)
  #pragma pop
#elif defined (__ICCARM__)
  /* leave anonymous unions enabled */
#elif (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic pop
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning restore
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#endif


/* =========================================================================================================================== */
/* ================                                Pos/Mask Peripheral Section                                ================ */
/* =========================================================================================================================== */


/** @addtogroup PosMask_peripherals
  * @{
  */

/* =========================================================================================================================== */ 
/*=====================                                    AHBUPCONV                                    ===================== */ 
/* =========================================================================================================================== */ 

/* =====================================================    COMMAND    ===================================================== */ 
#define AHBUPCONV_COMMAND_STALL_AUTO_CLEAR_Pos                             (5UL)		/*!<AHBUPCONV COMMAND: STALL_AUTO_CLEAR (Bit 5) */
#define AHBUPCONV_COMMAND_STALL_AUTO_CLEAR_Msk                             (0x20UL)		/*!< AHBUPCONV COMMAND: STALL_AUTO_CLEAR (Bitfield-Mask: 0x01) */
#define AHBUPCONV_COMMAND_STALL_AUTO_CLEAR                                 AHBUPCONV_COMMAND_STALL_AUTO_CLEAR_Msk
#define AHBUPCONV_COMMAND_STALL_IEN_Pos                                    (4UL)		/*!<AHBUPCONV COMMAND: STALL_IEN (Bit 4) */
#define AHBUPCONV_COMMAND_STALL_IEN_Msk                                    (0x10UL)		/*!< AHBUPCONV COMMAND: STALL_IEN (Bitfield-Mask: 0x01) */
#define AHBUPCONV_COMMAND_STALL_IEN                                        AHBUPCONV_COMMAND_STALL_IEN_Msk
#define AHBUPCONV_COMMAND_STALL_REQ_Pos                                    (3UL)		/*!<AHBUPCONV COMMAND: STALL_REQ (Bit 3) */
#define AHBUPCONV_COMMAND_STALL_REQ_Msk                                    (0x8UL)		/*!< AHBUPCONV COMMAND: STALL_REQ (Bitfield-Mask: 0x01) */
#define AHBUPCONV_COMMAND_STALL_REQ                                        AHBUPCONV_COMMAND_STALL_REQ_Msk
#define AHBUPCONV_COMMAND_ERROR_IEN_Pos                                    (2UL)		/*!<AHBUPCONV COMMAND: ERROR_IEN (Bit 2) */
#define AHBUPCONV_COMMAND_ERROR_IEN_Msk                                    (0x4UL)		/*!< AHBUPCONV COMMAND: ERROR_IEN (Bitfield-Mask: 0x01) */
#define AHBUPCONV_COMMAND_ERROR_IEN                                        AHBUPCONV_COMMAND_ERROR_IEN_Msk
#define AHBUPCONV_COMMAND_CLK_DIV_SEL_Pos                                  (0UL)		/*!<AHBUPCONV COMMAND: CLK_DIV_SEL (Bit 0) */
#define AHBUPCONV_COMMAND_CLK_DIV_SEL_Msk                                  (0x3UL)		/*!< AHBUPCONV COMMAND: CLK_DIV_SEL (Bitfield-Mask: 0x03) */
#define AHBUPCONV_COMMAND_CLK_DIV_SEL                                      AHBUPCONV_COMMAND_CLK_DIV_SEL_Msk
#define AHBUPCONV_COMMAND_CLK_DIV_SEL_0                                    (0x1U << AHBUPCONV_COMMAND_CLK_DIV_SEL_Pos)
#define AHBUPCONV_COMMAND_CLK_DIV_SEL_1                                    (0x2U << AHBUPCONV_COMMAND_CLK_DIV_SEL_Pos)

/* =====================================================    STATUS    ===================================================== */ 
#define AHBUPCONV_STATUS_ACTIVE_STALL_Pos                                  (3UL)		/*!<AHBUPCONV STATUS: ACTIVE_STALL (Bit 3) */
#define AHBUPCONV_STATUS_ACTIVE_STALL_Msk                                  (0x8UL)		/*!< AHBUPCONV STATUS: ACTIVE_STALL (Bitfield-Mask: 0x01) */
#define AHBUPCONV_STATUS_ACTIVE_STALL                                      AHBUPCONV_STATUS_ACTIVE_STALL_Msk
#define AHBUPCONV_STATUS_ERROR_STAT_Pos                                    (2UL)		/*!<AHBUPCONV STATUS: ERROR_STAT (Bit 2) */
#define AHBUPCONV_STATUS_ERROR_STAT_Msk                                    (0x4UL)		/*!< AHBUPCONV STATUS: ERROR_STAT (Bitfield-Mask: 0x01) */
#define AHBUPCONV_STATUS_ERROR_STAT                                        AHBUPCONV_STATUS_ERROR_STAT_Msk
#define AHBUPCONV_STATUS_CLK_DIV_SEL_STAT_Pos                              (0UL)		/*!<AHBUPCONV STATUS: CLK_DIV_SEL_STAT (Bit 0) */
#define AHBUPCONV_STATUS_CLK_DIV_SEL_STAT_Msk                              (0x3UL)		/*!< AHBUPCONV STATUS: CLK_DIV_SEL_STAT (Bitfield-Mask: 0x03) */
#define AHBUPCONV_STATUS_CLK_DIV_SEL_STAT                                  AHBUPCONV_STATUS_CLK_DIV_SEL_STAT_Msk
#define AHBUPCONV_STATUS_CLK_DIV_SEL_STAT_0                                (0x1U << AHBUPCONV_STATUS_CLK_DIV_SEL_STAT_Pos)
#define AHBUPCONV_STATUS_CLK_DIV_SEL_STAT_1                                (0x2U << AHBUPCONV_STATUS_CLK_DIV_SEL_STAT_Pos)

  
/* =========================================================================================================================== */ 
/*=====================                                       DMA                                       ===================== */ 
/* =========================================================================================================================== */ 

/* =====================================================    ISR    ===================================================== */ 
#define DMA_ISR_TEIF8_Pos                                                  (31UL)		/*!<DMA ISR: TEIF8 (Bit 31) */
#define DMA_ISR_TEIF8_Msk                                                  (0x80000000UL)		/*!< DMA ISR: TEIF8 (Bitfield-Mask: 0x01) */
#define DMA_ISR_TEIF8                                                      DMA_ISR_TEIF8_Msk
#define DMA_ISR_HTIF8_Pos                                                  (30UL)		/*!<DMA ISR: HTIF8 (Bit 30) */
#define DMA_ISR_HTIF8_Msk                                                  (0x40000000UL)		/*!< DMA ISR: HTIF8 (Bitfield-Mask: 0x01) */
#define DMA_ISR_HTIF8                                                      DMA_ISR_HTIF8_Msk
#define DMA_ISR_TCIF8_Pos                                                  (29UL)		/*!<DMA ISR: TCIF8 (Bit 29) */
#define DMA_ISR_TCIF8_Msk                                                  (0x20000000UL)		/*!< DMA ISR: TCIF8 (Bitfield-Mask: 0x01) */
#define DMA_ISR_TCIF8                                                      DMA_ISR_TCIF8_Msk
#define DMA_ISR_GIF8_Pos                                                   (28UL)		/*!<DMA ISR: GIF8 (Bit 28) */
#define DMA_ISR_GIF8_Msk                                                   (0x10000000UL)		/*!< DMA ISR: GIF8 (Bitfield-Mask: 0x01) */
#define DMA_ISR_GIF8                                                       DMA_ISR_GIF8_Msk
#define DMA_ISR_TEIF7_Pos                                                  (27UL)		/*!<DMA ISR: TEIF7 (Bit 27) */
#define DMA_ISR_TEIF7_Msk                                                  (0x8000000UL)		/*!< DMA ISR: TEIF7 (Bitfield-Mask: 0x01) */
#define DMA_ISR_TEIF7                                                      DMA_ISR_TEIF7_Msk
#define DMA_ISR_HTIF7_Pos                                                  (26UL)		/*!<DMA ISR: HTIF7 (Bit 26) */
#define DMA_ISR_HTIF7_Msk                                                  (0x4000000UL)		/*!< DMA ISR: HTIF7 (Bitfield-Mask: 0x01) */
#define DMA_ISR_HTIF7                                                      DMA_ISR_HTIF7_Msk
#define DMA_ISR_TCIF7_Pos                                                  (25UL)		/*!<DMA ISR: TCIF7 (Bit 25) */
#define DMA_ISR_TCIF7_Msk                                                  (0x2000000UL)		/*!< DMA ISR: TCIF7 (Bitfield-Mask: 0x01) */
#define DMA_ISR_TCIF7                                                      DMA_ISR_TCIF7_Msk
#define DMA_ISR_GIF7_Pos                                                   (24UL)		/*!<DMA ISR: GIF7 (Bit 24) */
#define DMA_ISR_GIF7_Msk                                                   (0x1000000UL)		/*!< DMA ISR: GIF7 (Bitfield-Mask: 0x01) */
#define DMA_ISR_GIF7                                                       DMA_ISR_GIF7_Msk
#define DMA_ISR_TEIF6_Pos                                                  (23UL)		/*!<DMA ISR: TEIF6 (Bit 23) */
#define DMA_ISR_TEIF6_Msk                                                  (0x800000UL)		/*!< DMA ISR: TEIF6 (Bitfield-Mask: 0x01) */
#define DMA_ISR_TEIF6                                                      DMA_ISR_TEIF6_Msk
#define DMA_ISR_HTIF6_Pos                                                  (22UL)		/*!<DMA ISR: HTIF6 (Bit 22) */
#define DMA_ISR_HTIF6_Msk                                                  (0x400000UL)		/*!< DMA ISR: HTIF6 (Bitfield-Mask: 0x01) */
#define DMA_ISR_HTIF6                                                      DMA_ISR_HTIF6_Msk
#define DMA_ISR_TCIF6_Pos                                                  (21UL)		/*!<DMA ISR: TCIF6 (Bit 21) */
#define DMA_ISR_TCIF6_Msk                                                  (0x200000UL)		/*!< DMA ISR: TCIF6 (Bitfield-Mask: 0x01) */
#define DMA_ISR_TCIF6                                                      DMA_ISR_TCIF6_Msk
#define DMA_ISR_GIF6_Pos                                                   (20UL)		/*!<DMA ISR: GIF6 (Bit 20) */
#define DMA_ISR_GIF6_Msk                                                   (0x100000UL)		/*!< DMA ISR: GIF6 (Bitfield-Mask: 0x01) */
#define DMA_ISR_GIF6                                                       DMA_ISR_GIF6_Msk
#define DMA_ISR_TEIF5_Pos                                                  (19UL)		/*!<DMA ISR: TEIF5 (Bit 19) */
#define DMA_ISR_TEIF5_Msk                                                  (0x80000UL)		/*!< DMA ISR: TEIF5 (Bitfield-Mask: 0x01) */
#define DMA_ISR_TEIF5                                                      DMA_ISR_TEIF5_Msk
#define DMA_ISR_HTIF5_Pos                                                  (18UL)		/*!<DMA ISR: HTIF5 (Bit 18) */
#define DMA_ISR_HTIF5_Msk                                                  (0x40000UL)		/*!< DMA ISR: HTIF5 (Bitfield-Mask: 0x01) */
#define DMA_ISR_HTIF5                                                      DMA_ISR_HTIF5_Msk
#define DMA_ISR_TCIF5_Pos                                                  (17UL)		/*!<DMA ISR: TCIF5 (Bit 17) */
#define DMA_ISR_TCIF5_Msk                                                  (0x20000UL)		/*!< DMA ISR: TCIF5 (Bitfield-Mask: 0x01) */
#define DMA_ISR_TCIF5                                                      DMA_ISR_TCIF5_Msk
#define DMA_ISR_GIF5_Pos                                                   (16UL)		/*!<DMA ISR: GIF5 (Bit 16) */
#define DMA_ISR_GIF5_Msk                                                   (0x10000UL)		/*!< DMA ISR: GIF5 (Bitfield-Mask: 0x01) */
#define DMA_ISR_GIF5                                                       DMA_ISR_GIF5_Msk
#define DMA_ISR_TEIF4_Pos                                                  (15UL)		/*!<DMA ISR: TEIF4 (Bit 15) */
#define DMA_ISR_TEIF4_Msk                                                  (0x8000UL)		/*!< DMA ISR: TEIF4 (Bitfield-Mask: 0x01) */
#define DMA_ISR_TEIF4                                                      DMA_ISR_TEIF4_Msk
#define DMA_ISR_HTIF4_Pos                                                  (14UL)		/*!<DMA ISR: HTIF4 (Bit 14) */
#define DMA_ISR_HTIF4_Msk                                                  (0x4000UL)		/*!< DMA ISR: HTIF4 (Bitfield-Mask: 0x01) */
#define DMA_ISR_HTIF4                                                      DMA_ISR_HTIF4_Msk
#define DMA_ISR_TCIF4_Pos                                                  (13UL)		/*!<DMA ISR: TCIF4 (Bit 13) */
#define DMA_ISR_TCIF4_Msk                                                  (0x2000UL)		/*!< DMA ISR: TCIF4 (Bitfield-Mask: 0x01) */
#define DMA_ISR_TCIF4                                                      DMA_ISR_TCIF4_Msk
#define DMA_ISR_GIF4_Pos                                                   (12UL)		/*!<DMA ISR: GIF4 (Bit 12) */
#define DMA_ISR_GIF4_Msk                                                   (0x1000UL)		/*!< DMA ISR: GIF4 (Bitfield-Mask: 0x01) */
#define DMA_ISR_GIF4                                                       DMA_ISR_GIF4_Msk
#define DMA_ISR_TEIF3_Pos                                                  (11UL)		/*!<DMA ISR: TEIF3 (Bit 11) */
#define DMA_ISR_TEIF3_Msk                                                  (0x800UL)		/*!< DMA ISR: TEIF3 (Bitfield-Mask: 0x01) */
#define DMA_ISR_TEIF3                                                      DMA_ISR_TEIF3_Msk
#define DMA_ISR_HTIF3_Pos                                                  (10UL)		/*!<DMA ISR: HTIF3 (Bit 10) */
#define DMA_ISR_HTIF3_Msk                                                  (0x400UL)		/*!< DMA ISR: HTIF3 (Bitfield-Mask: 0x01) */
#define DMA_ISR_HTIF3                                                      DMA_ISR_HTIF3_Msk
#define DMA_ISR_TCIF3_Pos                                                  (9UL)		/*!<DMA ISR: TCIF3 (Bit 9) */
#define DMA_ISR_TCIF3_Msk                                                  (0x200UL)		/*!< DMA ISR: TCIF3 (Bitfield-Mask: 0x01) */
#define DMA_ISR_TCIF3                                                      DMA_ISR_TCIF3_Msk
#define DMA_ISR_GIF3_Pos                                                   (8UL)		/*!<DMA ISR: GIF3 (Bit 8) */
#define DMA_ISR_GIF3_Msk                                                   (0x100UL)		/*!< DMA ISR: GIF3 (Bitfield-Mask: 0x01) */
#define DMA_ISR_GIF3                                                       DMA_ISR_GIF3_Msk
#define DMA_ISR_TEIF2_Pos                                                  (7UL)		/*!<DMA ISR: TEIF2 (Bit 7) */
#define DMA_ISR_TEIF2_Msk                                                  (0x80UL)		/*!< DMA ISR: TEIF2 (Bitfield-Mask: 0x01) */
#define DMA_ISR_TEIF2                                                      DMA_ISR_TEIF2_Msk
#define DMA_ISR_HTIF2_Pos                                                  (6UL)		/*!<DMA ISR: HTIF2 (Bit 6) */
#define DMA_ISR_HTIF2_Msk                                                  (0x40UL)		/*!< DMA ISR: HTIF2 (Bitfield-Mask: 0x01) */
#define DMA_ISR_HTIF2                                                      DMA_ISR_HTIF2_Msk
#define DMA_ISR_TCIF2_Pos                                                  (5UL)		/*!<DMA ISR: TCIF2 (Bit 5) */
#define DMA_ISR_TCIF2_Msk                                                  (0x20UL)		/*!< DMA ISR: TCIF2 (Bitfield-Mask: 0x01) */
#define DMA_ISR_TCIF2                                                      DMA_ISR_TCIF2_Msk
#define DMA_ISR_GIF2_Pos                                                   (4UL)		/*!<DMA ISR: GIF2 (Bit 4) */
#define DMA_ISR_GIF2_Msk                                                   (0x10UL)		/*!< DMA ISR: GIF2 (Bitfield-Mask: 0x01) */
#define DMA_ISR_GIF2                                                       DMA_ISR_GIF2_Msk
#define DMA_ISR_TEIF1_Pos                                                  (3UL)		/*!<DMA ISR: TEIF1 (Bit 3) */
#define DMA_ISR_TEIF1_Msk                                                  (0x8UL)		/*!< DMA ISR: TEIF1 (Bitfield-Mask: 0x01) */
#define DMA_ISR_TEIF1                                                      DMA_ISR_TEIF1_Msk
#define DMA_ISR_HTIF1_Pos                                                  (2UL)		/*!<DMA ISR: HTIF1 (Bit 2) */
#define DMA_ISR_HTIF1_Msk                                                  (0x4UL)		/*!< DMA ISR: HTIF1 (Bitfield-Mask: 0x01) */
#define DMA_ISR_HTIF1                                                      DMA_ISR_HTIF1_Msk
#define DMA_ISR_TCIF1_Pos                                                  (1UL)		/*!<DMA ISR: TCIF1 (Bit 1) */
#define DMA_ISR_TCIF1_Msk                                                  (0x2UL)		/*!< DMA ISR: TCIF1 (Bitfield-Mask: 0x01) */
#define DMA_ISR_TCIF1                                                      DMA_ISR_TCIF1_Msk
#define DMA_ISR_GIF1_Pos                                                   (0UL)		/*!<DMA ISR: GIF1 (Bit 0) */
#define DMA_ISR_GIF1_Msk                                                   (0x1UL)		/*!< DMA ISR: GIF1 (Bitfield-Mask: 0x01) */
#define DMA_ISR_GIF1                                                       DMA_ISR_GIF1_Msk

/* =====================================================    IFCR    ===================================================== */ 
#define DMA_IFCR_CTEIF8_Pos                                                (31UL)		/*!<DMA IFCR: CTEIF8 (Bit 31) */
#define DMA_IFCR_CTEIF8_Msk                                                (0x80000000UL)		/*!< DMA IFCR: CTEIF8 (Bitfield-Mask: 0x01) */
#define DMA_IFCR_CTEIF8                                                    DMA_IFCR_CTEIF8_Msk
#define DMA_IFCR_CHTIF8_Pos                                                (30UL)		/*!<DMA IFCR: CHTIF8 (Bit 30) */
#define DMA_IFCR_CHTIF8_Msk                                                (0x40000000UL)		/*!< DMA IFCR: CHTIF8 (Bitfield-Mask: 0x01) */
#define DMA_IFCR_CHTIF8                                                    DMA_IFCR_CHTIF8_Msk
#define DMA_IFCR_CTCIF8_Pos                                                (29UL)		/*!<DMA IFCR: CTCIF8 (Bit 29) */
#define DMA_IFCR_CTCIF8_Msk                                                (0x20000000UL)		/*!< DMA IFCR: CTCIF8 (Bitfield-Mask: 0x01) */
#define DMA_IFCR_CTCIF8                                                    DMA_IFCR_CTCIF8_Msk
#define DMA_IFCR_CGIF8_Pos                                                 (28UL)		/*!<DMA IFCR: CGIF8 (Bit 28) */
#define DMA_IFCR_CGIF8_Msk                                                 (0x10000000UL)		/*!< DMA IFCR: CGIF8 (Bitfield-Mask: 0x01) */
#define DMA_IFCR_CGIF8                                                     DMA_IFCR_CGIF8_Msk
#define DMA_IFCR_CTEIF7_Pos                                                (27UL)		/*!<DMA IFCR: CTEIF7 (Bit 27) */
#define DMA_IFCR_CTEIF7_Msk                                                (0x8000000UL)		/*!< DMA IFCR: CTEIF7 (Bitfield-Mask: 0x01) */
#define DMA_IFCR_CTEIF7                                                    DMA_IFCR_CTEIF7_Msk
#define DMA_IFCR_CHTIF7_Pos                                                (26UL)		/*!<DMA IFCR: CHTIF7 (Bit 26) */
#define DMA_IFCR_CHTIF7_Msk                                                (0x4000000UL)		/*!< DMA IFCR: CHTIF7 (Bitfield-Mask: 0x01) */
#define DMA_IFCR_CHTIF7                                                    DMA_IFCR_CHTIF7_Msk
#define DMA_IFCR_CTCIF7_Pos                                                (25UL)		/*!<DMA IFCR: CTCIF7 (Bit 25) */
#define DMA_IFCR_CTCIF7_Msk                                                (0x2000000UL)		/*!< DMA IFCR: CTCIF7 (Bitfield-Mask: 0x01) */
#define DMA_IFCR_CTCIF7                                                    DMA_IFCR_CTCIF7_Msk
#define DMA_IFCR_CGIF7_Pos                                                 (24UL)		/*!<DMA IFCR: CGIF7 (Bit 24) */
#define DMA_IFCR_CGIF7_Msk                                                 (0x1000000UL)		/*!< DMA IFCR: CGIF7 (Bitfield-Mask: 0x01) */
#define DMA_IFCR_CGIF7                                                     DMA_IFCR_CGIF7_Msk
#define DMA_IFCR_CTEIF6_Pos                                                (23UL)		/*!<DMA IFCR: CTEIF6 (Bit 23) */
#define DMA_IFCR_CTEIF6_Msk                                                (0x800000UL)		/*!< DMA IFCR: CTEIF6 (Bitfield-Mask: 0x01) */
#define DMA_IFCR_CTEIF6                                                    DMA_IFCR_CTEIF6_Msk
#define DMA_IFCR_CHTIF6_Pos                                                (22UL)		/*!<DMA IFCR: CHTIF6 (Bit 22) */
#define DMA_IFCR_CHTIF6_Msk                                                (0x400000UL)		/*!< DMA IFCR: CHTIF6 (Bitfield-Mask: 0x01) */
#define DMA_IFCR_CHTIF6                                                    DMA_IFCR_CHTIF6_Msk
#define DMA_IFCR_CTCIF6_Pos                                                (21UL)		/*!<DMA IFCR: CTCIF6 (Bit 21) */
#define DMA_IFCR_CTCIF6_Msk                                                (0x200000UL)		/*!< DMA IFCR: CTCIF6 (Bitfield-Mask: 0x01) */
#define DMA_IFCR_CTCIF6                                                    DMA_IFCR_CTCIF6_Msk
#define DMA_IFCR_CGIF6_Pos                                                 (20UL)		/*!<DMA IFCR: CGIF6 (Bit 20) */
#define DMA_IFCR_CGIF6_Msk                                                 (0x100000UL)		/*!< DMA IFCR: CGIF6 (Bitfield-Mask: 0x01) */
#define DMA_IFCR_CGIF6                                                     DMA_IFCR_CGIF6_Msk
#define DMA_IFCR_CTEIF5_Pos                                                (19UL)		/*!<DMA IFCR: CTEIF5 (Bit 19) */
#define DMA_IFCR_CTEIF5_Msk                                                (0x80000UL)		/*!< DMA IFCR: CTEIF5 (Bitfield-Mask: 0x01) */
#define DMA_IFCR_CTEIF5                                                    DMA_IFCR_CTEIF5_Msk
#define DMA_IFCR_CHTIF5_Pos                                                (18UL)		/*!<DMA IFCR: CHTIF5 (Bit 18) */
#define DMA_IFCR_CHTIF5_Msk                                                (0x40000UL)		/*!< DMA IFCR: CHTIF5 (Bitfield-Mask: 0x01) */
#define DMA_IFCR_CHTIF5                                                    DMA_IFCR_CHTIF5_Msk
#define DMA_IFCR_CTCIF5_Pos                                                (17UL)		/*!<DMA IFCR: CTCIF5 (Bit 17) */
#define DMA_IFCR_CTCIF5_Msk                                                (0x20000UL)		/*!< DMA IFCR: CTCIF5 (Bitfield-Mask: 0x01) */
#define DMA_IFCR_CTCIF5                                                    DMA_IFCR_CTCIF5_Msk
#define DMA_IFCR_CGIF5_Pos                                                 (16UL)		/*!<DMA IFCR: CGIF5 (Bit 16) */
#define DMA_IFCR_CGIF5_Msk                                                 (0x10000UL)		/*!< DMA IFCR: CGIF5 (Bitfield-Mask: 0x01) */
#define DMA_IFCR_CGIF5                                                     DMA_IFCR_CGIF5_Msk
#define DMA_IFCR_CTEIF4_Pos                                                (15UL)		/*!<DMA IFCR: CTEIF4 (Bit 15) */
#define DMA_IFCR_CTEIF4_Msk                                                (0x8000UL)		/*!< DMA IFCR: CTEIF4 (Bitfield-Mask: 0x01) */
#define DMA_IFCR_CTEIF4                                                    DMA_IFCR_CTEIF4_Msk
#define DMA_IFCR_CHTIF4_Pos                                                (14UL)		/*!<DMA IFCR: CHTIF4 (Bit 14) */
#define DMA_IFCR_CHTIF4_Msk                                                (0x4000UL)		/*!< DMA IFCR: CHTIF4 (Bitfield-Mask: 0x01) */
#define DMA_IFCR_CHTIF4                                                    DMA_IFCR_CHTIF4_Msk
#define DMA_IFCR_CTCIF4_Pos                                                (13UL)		/*!<DMA IFCR: CTCIF4 (Bit 13) */
#define DMA_IFCR_CTCIF4_Msk                                                (0x2000UL)		/*!< DMA IFCR: CTCIF4 (Bitfield-Mask: 0x01) */
#define DMA_IFCR_CTCIF4                                                    DMA_IFCR_CTCIF4_Msk
#define DMA_IFCR_CGIF4_Pos                                                 (12UL)		/*!<DMA IFCR: CGIF4 (Bit 12) */
#define DMA_IFCR_CGIF4_Msk                                                 (0x1000UL)		/*!< DMA IFCR: CGIF4 (Bitfield-Mask: 0x01) */
#define DMA_IFCR_CGIF4                                                     DMA_IFCR_CGIF4_Msk
#define DMA_IFCR_CTEIF3_Pos                                                (11UL)		/*!<DMA IFCR: CTEIF3 (Bit 11) */
#define DMA_IFCR_CTEIF3_Msk                                                (0x800UL)		/*!< DMA IFCR: CTEIF3 (Bitfield-Mask: 0x01) */
#define DMA_IFCR_CTEIF3                                                    DMA_IFCR_CTEIF3_Msk
#define DMA_IFCR_CHTIF3_Pos                                                (10UL)		/*!<DMA IFCR: CHTIF3 (Bit 10) */
#define DMA_IFCR_CHTIF3_Msk                                                (0x400UL)		/*!< DMA IFCR: CHTIF3 (Bitfield-Mask: 0x01) */
#define DMA_IFCR_CHTIF3                                                    DMA_IFCR_CHTIF3_Msk
#define DMA_IFCR_CTCIF3_Pos                                                (9UL)		/*!<DMA IFCR: CTCIF3 (Bit 9) */
#define DMA_IFCR_CTCIF3_Msk                                                (0x200UL)		/*!< DMA IFCR: CTCIF3 (Bitfield-Mask: 0x01) */
#define DMA_IFCR_CTCIF3                                                    DMA_IFCR_CTCIF3_Msk
#define DMA_IFCR_CGIF3_Pos                                                 (8UL)		/*!<DMA IFCR: CGIF3 (Bit 8) */
#define DMA_IFCR_CGIF3_Msk                                                 (0x100UL)		/*!< DMA IFCR: CGIF3 (Bitfield-Mask: 0x01) */
#define DMA_IFCR_CGIF3                                                     DMA_IFCR_CGIF3_Msk
#define DMA_IFCR_CTEIF2_Pos                                                (7UL)		/*!<DMA IFCR: CTEIF2 (Bit 7) */
#define DMA_IFCR_CTEIF2_Msk                                                (0x80UL)		/*!< DMA IFCR: CTEIF2 (Bitfield-Mask: 0x01) */
#define DMA_IFCR_CTEIF2                                                    DMA_IFCR_CTEIF2_Msk
#define DMA_IFCR_CHTIF2_Pos                                                (6UL)		/*!<DMA IFCR: CHTIF2 (Bit 6) */
#define DMA_IFCR_CHTIF2_Msk                                                (0x40UL)		/*!< DMA IFCR: CHTIF2 (Bitfield-Mask: 0x01) */
#define DMA_IFCR_CHTIF2                                                    DMA_IFCR_CHTIF2_Msk
#define DMA_IFCR_CTCIF2_Pos                                                (5UL)		/*!<DMA IFCR: CTCIF2 (Bit 5) */
#define DMA_IFCR_CTCIF2_Msk                                                (0x20UL)		/*!< DMA IFCR: CTCIF2 (Bitfield-Mask: 0x01) */
#define DMA_IFCR_CTCIF2                                                    DMA_IFCR_CTCIF2_Msk
#define DMA_IFCR_CGIF2_Pos                                                 (4UL)		/*!<DMA IFCR: CGIF2 (Bit 4) */
#define DMA_IFCR_CGIF2_Msk                                                 (0x10UL)		/*!< DMA IFCR: CGIF2 (Bitfield-Mask: 0x01) */
#define DMA_IFCR_CGIF2                                                     DMA_IFCR_CGIF2_Msk
#define DMA_IFCR_CTEIF1_Pos                                                (3UL)		/*!<DMA IFCR: CTEIF1 (Bit 3) */
#define DMA_IFCR_CTEIF1_Msk                                                (0x8UL)		/*!< DMA IFCR: CTEIF1 (Bitfield-Mask: 0x01) */
#define DMA_IFCR_CTEIF1                                                    DMA_IFCR_CTEIF1_Msk
#define DMA_IFCR_CHTIF1_Pos                                                (2UL)		/*!<DMA IFCR: CHTIF1 (Bit 2) */
#define DMA_IFCR_CHTIF1_Msk                                                (0x4UL)		/*!< DMA IFCR: CHTIF1 (Bitfield-Mask: 0x01) */
#define DMA_IFCR_CHTIF1                                                    DMA_IFCR_CHTIF1_Msk
#define DMA_IFCR_CTCIF1_Pos                                                (1UL)		/*!<DMA IFCR: CTCIF1 (Bit 1) */
#define DMA_IFCR_CTCIF1_Msk                                                (0x2UL)		/*!< DMA IFCR: CTCIF1 (Bitfield-Mask: 0x01) */
#define DMA_IFCR_CTCIF1                                                    DMA_IFCR_CTCIF1_Msk
#define DMA_IFCR_CGIF1_Pos                                                 (0UL)		/*!<DMA IFCR: CGIF1 (Bit 0) */
#define DMA_IFCR_CGIF1_Msk                                                 (0x1UL)		/*!< DMA IFCR: CGIF1 (Bitfield-Mask: 0x01) */
#define DMA_IFCR_CGIF1                                                     DMA_IFCR_CGIF1_Msk

/* =====================================================    CCR    ===================================================== */ 
#define DMA_CCR_MEM2MEM_Pos                                                (14UL)		/*!<DMA CCR: MEM2MEM (Bit 14) */
#define DMA_CCR_MEM2MEM_Msk                                                (0x4000UL)		/*!< DMA CCR: MEM2MEM (Bitfield-Mask: 0x01) */
#define DMA_CCR_MEM2MEM                                                    DMA_CCR_MEM2MEM_Msk
#define DMA_CCR_PL_Pos                                                     (12UL)		/*!<DMA CCR: PL (Bit 12) */
#define DMA_CCR_PL_Msk                                                     (0x3000UL)		/*!< DMA CCR: PL (Bitfield-Mask: 0x03) */
#define DMA_CCR_PL                                                         DMA_CCR_PL_Msk
#define DMA_CCR_PL_0                                                       (0x1U << DMA_CCR_PL_Pos)
#define DMA_CCR_PL_1                                                       (0x2U << DMA_CCR_PL_Pos)
#define DMA_CCR_MSIZE_Pos                                                  (10UL)		/*!<DMA CCR: MSIZE (Bit 10) */
#define DMA_CCR_MSIZE_Msk                                                  (0xc00UL)		/*!< DMA CCR: MSIZE (Bitfield-Mask: 0x03) */
#define DMA_CCR_MSIZE                                                      DMA_CCR_MSIZE_Msk
#define DMA_CCR_MSIZE_0                                                    (0x1U << DMA_CCR_MSIZE_Pos)
#define DMA_CCR_MSIZE_1                                                    (0x2U << DMA_CCR_MSIZE_Pos)
#define DMA_CCR_PSIZE_Pos                                                  (8UL)		/*!<DMA CCR: PSIZE (Bit 8) */
#define DMA_CCR_PSIZE_Msk                                                  (0x300UL)		/*!< DMA CCR: PSIZE (Bitfield-Mask: 0x03) */
#define DMA_CCR_PSIZE                                                      DMA_CCR_PSIZE_Msk
#define DMA_CCR_PSIZE_0                                                    (0x1U << DMA_CCR_PSIZE_Pos)
#define DMA_CCR_PSIZE_1                                                    (0x2U << DMA_CCR_PSIZE_Pos)
#define DMA_CCR_MINC_Pos                                                   (7UL)		/*!<DMA CCR: MINC (Bit 7) */
#define DMA_CCR_MINC_Msk                                                   (0x80UL)		/*!< DMA CCR: MINC (Bitfield-Mask: 0x01) */
#define DMA_CCR_MINC                                                       DMA_CCR_MINC_Msk
#define DMA_CCR_PINC_Pos                                                   (6UL)		/*!<DMA CCR: PINC (Bit 6) */
#define DMA_CCR_PINC_Msk                                                   (0x40UL)		/*!< DMA CCR: PINC (Bitfield-Mask: 0x01) */
#define DMA_CCR_PINC                                                       DMA_CCR_PINC_Msk
#define DMA_CCR_CIRC_Pos                                                   (5UL)		/*!<DMA CCR: CIRC (Bit 5) */
#define DMA_CCR_CIRC_Msk                                                   (0x20UL)		/*!< DMA CCR: CIRC (Bitfield-Mask: 0x01) */
#define DMA_CCR_CIRC                                                       DMA_CCR_CIRC_Msk
#define DMA_CCR_DIR_Pos                                                    (4UL)		/*!<DMA CCR: DIR (Bit 4) */
#define DMA_CCR_DIR_Msk                                                    (0x10UL)		/*!< DMA CCR: DIR (Bitfield-Mask: 0x01) */
#define DMA_CCR_DIR                                                        DMA_CCR_DIR_Msk
#define DMA_CCR_TEIE_Pos                                                   (3UL)		/*!<DMA CCR: TEIE (Bit 3) */
#define DMA_CCR_TEIE_Msk                                                   (0x8UL)		/*!< DMA CCR: TEIE (Bitfield-Mask: 0x01) */
#define DMA_CCR_TEIE                                                       DMA_CCR_TEIE_Msk
#define DMA_CCR_HTIE_Pos                                                   (2UL)		/*!<DMA CCR: HTIE (Bit 2) */
#define DMA_CCR_HTIE_Msk                                                   (0x4UL)		/*!< DMA CCR: HTIE (Bitfield-Mask: 0x01) */
#define DMA_CCR_HTIE                                                       DMA_CCR_HTIE_Msk
#define DMA_CCR_TCIE_Pos                                                   (1UL)		/*!<DMA CCR: TCIE (Bit 1) */
#define DMA_CCR_TCIE_Msk                                                   (0x2UL)		/*!< DMA CCR: TCIE (Bitfield-Mask: 0x01) */
#define DMA_CCR_TCIE                                                       DMA_CCR_TCIE_Msk
#define DMA_CCR_EN_Pos                                                     (0UL)		/*!<DMA CCR: EN (Bit 0) */
#define DMA_CCR_EN_Msk                                                     (0x1UL)		/*!< DMA CCR: EN (Bitfield-Mask: 0x01) */
#define DMA_CCR_EN                                                         DMA_CCR_EN_Msk

/* =====================================================    CNDTR    ===================================================== */ 
#define DMA_CNDTR_NDT_Pos                                                  (0UL)		/*!<DMA CNDTR: NDT (Bit 0) */
#define DMA_CNDTR_NDT_Msk                                                  (0xffffUL)		/*!< DMA CNDTR: NDT (Bitfield-Mask: 0xffff) */
#define DMA_CNDTR_NDT                                                      DMA_CNDTR_NDT_Msk
#define DMA_CNDTR_NDT_0                                                    (0x1U << DMA_CNDTR_NDT_Pos)
#define DMA_CNDTR_NDT_1                                                    (0x2U << DMA_CNDTR_NDT_Pos)
#define DMA_CNDTR_NDT_2                                                    (0x4U << DMA_CNDTR_NDT_Pos)
#define DMA_CNDTR_NDT_3                                                    (0x8U << DMA_CNDTR_NDT_Pos)
#define DMA_CNDTR_NDT_4                                                    (0x10U << DMA_CNDTR_NDT_Pos)
#define DMA_CNDTR_NDT_5                                                    (0x20U << DMA_CNDTR_NDT_Pos)
#define DMA_CNDTR_NDT_6                                                    (0x40U << DMA_CNDTR_NDT_Pos)
#define DMA_CNDTR_NDT_7                                                    (0x80U << DMA_CNDTR_NDT_Pos)
#define DMA_CNDTR_NDT_8                                                    (0x100U << DMA_CNDTR_NDT_Pos)
#define DMA_CNDTR_NDT_9                                                    (0x200U << DMA_CNDTR_NDT_Pos)
#define DMA_CNDTR_NDT_10                                                   (0x400U << DMA_CNDTR_NDT_Pos)
#define DMA_CNDTR_NDT_11                                                   (0x800U << DMA_CNDTR_NDT_Pos)
#define DMA_CNDTR_NDT_12                                                   (0x1000U << DMA_CNDTR_NDT_Pos)
#define DMA_CNDTR_NDT_13                                                   (0x2000U << DMA_CNDTR_NDT_Pos)
#define DMA_CNDTR_NDT_14                                                   (0x4000U << DMA_CNDTR_NDT_Pos)
#define DMA_CNDTR_NDT_15                                                   (0x8000U << DMA_CNDTR_NDT_Pos)

/* =====================================================    CPAR    ===================================================== */ 
#define DMA_CPAR_PA_Pos                                                    (0UL)		/*!<DMA CPAR: PA (Bit 0) */
#define DMA_CPAR_PA_Msk                                                    (0xffffffffUL)		/*!< DMA CPAR: PA (Bitfield-Mask: 0xffffffff) */
#define DMA_CPAR_PA                                                        DMA_CPAR_PA_Msk
#define DMA_CPAR_PA_0                                                      (0x1U << DMA_CPAR_PA_Pos)
#define DMA_CPAR_PA_1                                                      (0x2U << DMA_CPAR_PA_Pos)
#define DMA_CPAR_PA_2                                                      (0x4U << DMA_CPAR_PA_Pos)
#define DMA_CPAR_PA_3                                                      (0x8U << DMA_CPAR_PA_Pos)
#define DMA_CPAR_PA_4                                                      (0x10U << DMA_CPAR_PA_Pos)
#define DMA_CPAR_PA_5                                                      (0x20U << DMA_CPAR_PA_Pos)
#define DMA_CPAR_PA_6                                                      (0x40U << DMA_CPAR_PA_Pos)
#define DMA_CPAR_PA_7                                                      (0x80U << DMA_CPAR_PA_Pos)
#define DMA_CPAR_PA_8                                                      (0x100U << DMA_CPAR_PA_Pos)
#define DMA_CPAR_PA_9                                                      (0x200U << DMA_CPAR_PA_Pos)
#define DMA_CPAR_PA_10                                                     (0x400U << DMA_CPAR_PA_Pos)
#define DMA_CPAR_PA_11                                                     (0x800U << DMA_CPAR_PA_Pos)
#define DMA_CPAR_PA_12                                                     (0x1000U << DMA_CPAR_PA_Pos)
#define DMA_CPAR_PA_13                                                     (0x2000U << DMA_CPAR_PA_Pos)
#define DMA_CPAR_PA_14                                                     (0x4000U << DMA_CPAR_PA_Pos)
#define DMA_CPAR_PA_15                                                     (0x8000U << DMA_CPAR_PA_Pos)
#define DMA_CPAR_PA_16                                                     (0x10000U << DMA_CPAR_PA_Pos)
#define DMA_CPAR_PA_17                                                     (0x20000U << DMA_CPAR_PA_Pos)
#define DMA_CPAR_PA_18                                                     (0x40000U << DMA_CPAR_PA_Pos)
#define DMA_CPAR_PA_19                                                     (0x80000U << DMA_CPAR_PA_Pos)
#define DMA_CPAR_PA_20                                                     (0x100000U << DMA_CPAR_PA_Pos)
#define DMA_CPAR_PA_21                                                     (0x200000U << DMA_CPAR_PA_Pos)
#define DMA_CPAR_PA_22                                                     (0x400000U << DMA_CPAR_PA_Pos)
#define DMA_CPAR_PA_23                                                     (0x800000U << DMA_CPAR_PA_Pos)
#define DMA_CPAR_PA_24                                                     (0x1000000U << DMA_CPAR_PA_Pos)
#define DMA_CPAR_PA_25                                                     (0x2000000U << DMA_CPAR_PA_Pos)
#define DMA_CPAR_PA_26                                                     (0x4000000U << DMA_CPAR_PA_Pos)
#define DMA_CPAR_PA_27                                                     (0x8000000U << DMA_CPAR_PA_Pos)
#define DMA_CPAR_PA_28                                                     (0x10000000U << DMA_CPAR_PA_Pos)
#define DMA_CPAR_PA_29                                                     (0x20000000U << DMA_CPAR_PA_Pos)
#define DMA_CPAR_PA_30                                                     (0x40000000U << DMA_CPAR_PA_Pos)
#define DMA_CPAR_PA_31                                                     (0x80000000UL << DMA_CPAR_PA_Pos)

/* =====================================================    CMAR    ===================================================== */ 
#define DMA_CMAR_MA_Pos                                                    (0UL)		/*!<DMA CMAR: MA (Bit 0) */
#define DMA_CMAR_MA_Msk                                                    (0xffffffffUL)		/*!< DMA CMAR: MA (Bitfield-Mask: 0xffffffff) */
#define DMA_CMAR_MA                                                        DMA_CMAR_MA_Msk
#define DMA_CMAR_MA_0                                                      (0x1U << DMA_CMAR_MA_Pos)
#define DMA_CMAR_MA_1                                                      (0x2U << DMA_CMAR_MA_Pos)
#define DMA_CMAR_MA_2                                                      (0x4U << DMA_CMAR_MA_Pos)
#define DMA_CMAR_MA_3                                                      (0x8U << DMA_CMAR_MA_Pos)
#define DMA_CMAR_MA_4                                                      (0x10U << DMA_CMAR_MA_Pos)
#define DMA_CMAR_MA_5                                                      (0x20U << DMA_CMAR_MA_Pos)
#define DMA_CMAR_MA_6                                                      (0x40U << DMA_CMAR_MA_Pos)
#define DMA_CMAR_MA_7                                                      (0x80U << DMA_CMAR_MA_Pos)
#define DMA_CMAR_MA_8                                                      (0x100U << DMA_CMAR_MA_Pos)
#define DMA_CMAR_MA_9                                                      (0x200U << DMA_CMAR_MA_Pos)
#define DMA_CMAR_MA_10                                                     (0x400U << DMA_CMAR_MA_Pos)
#define DMA_CMAR_MA_11                                                     (0x800U << DMA_CMAR_MA_Pos)
#define DMA_CMAR_MA_12                                                     (0x1000U << DMA_CMAR_MA_Pos)
#define DMA_CMAR_MA_13                                                     (0x2000U << DMA_CMAR_MA_Pos)
#define DMA_CMAR_MA_14                                                     (0x4000U << DMA_CMAR_MA_Pos)
#define DMA_CMAR_MA_15                                                     (0x8000U << DMA_CMAR_MA_Pos)
#define DMA_CMAR_MA_16                                                     (0x10000U << DMA_CMAR_MA_Pos)
#define DMA_CMAR_MA_17                                                     (0x20000U << DMA_CMAR_MA_Pos)
#define DMA_CMAR_MA_18                                                     (0x40000U << DMA_CMAR_MA_Pos)
#define DMA_CMAR_MA_19                                                     (0x80000U << DMA_CMAR_MA_Pos)
#define DMA_CMAR_MA_20                                                     (0x100000U << DMA_CMAR_MA_Pos)
#define DMA_CMAR_MA_21                                                     (0x200000U << DMA_CMAR_MA_Pos)
#define DMA_CMAR_MA_22                                                     (0x400000U << DMA_CMAR_MA_Pos)
#define DMA_CMAR_MA_23                                                     (0x800000U << DMA_CMAR_MA_Pos)
#define DMA_CMAR_MA_24                                                     (0x1000000U << DMA_CMAR_MA_Pos)
#define DMA_CMAR_MA_25                                                     (0x2000000U << DMA_CMAR_MA_Pos)
#define DMA_CMAR_MA_26                                                     (0x4000000U << DMA_CMAR_MA_Pos)
#define DMA_CMAR_MA_27                                                     (0x8000000U << DMA_CMAR_MA_Pos)
#define DMA_CMAR_MA_28                                                     (0x10000000U << DMA_CMAR_MA_Pos)
#define DMA_CMAR_MA_29                                                     (0x20000000U << DMA_CMAR_MA_Pos)
#define DMA_CMAR_MA_30                                                     (0x40000000U << DMA_CMAR_MA_Pos)
#define DMA_CMAR_MA_31                                                     (0x80000000UL << DMA_CMAR_MA_Pos)


/* =========================================================================================================================== */ 
/*=====================                                      DMAMUX                                      ===================== */ 
/* =========================================================================================================================== */ 

/* =====================================================    CxCR    ===================================================== */ 
#define DMAMUX_CxCR_DMAREQ_ID_Pos                                          (0UL)		/*!<DMAMUX CxCR: DMAREQ_ID (Bit 0) */
#define DMAMUX_CxCR_DMAREQ_ID_Msk                                          (0x1fUL)		/*!< DMAMUX CxCR: DMAREQ_ID (Bitfield-Mask: 0x1f) */
#define DMAMUX_CxCR_DMAREQ_ID                                              DMAMUX_CxCR_DMAREQ_ID_Msk
#define DMAMUX_CxCR_DMAREQ_ID_0                                            (0x1U << DMAMUX_CxCR_DMAREQ_ID_Pos)
#define DMAMUX_CxCR_DMAREQ_ID_1                                            (0x2U << DMAMUX_CxCR_DMAREQ_ID_Pos)
#define DMAMUX_CxCR_DMAREQ_ID_2                                            (0x4U << DMAMUX_CxCR_DMAREQ_ID_Pos)
#define DMAMUX_CxCR_DMAREQ_ID_3                                            (0x8U << DMAMUX_CxCR_DMAREQ_ID_Pos)
#define DMAMUX_CxCR_DMAREQ_ID_4                                            (0x10U << DMAMUX_CxCR_DMAREQ_ID_Pos)


/* =========================================================================================================================== */ 
/*=====================                                       CRC                                       ===================== */ 
/* =========================================================================================================================== */ 

/* =====================================================    DR    ===================================================== */ 
#define CRC_DR_DR_Pos                                                      (0UL)		/*!<CRC DR: DR (Bit 0) */
#define CRC_DR_DR_Msk                                                      (0xffffffffUL)		/*!< CRC DR: DR (Bitfield-Mask: 0xffffffff) */
#define CRC_DR_DR                                                          CRC_DR_DR_Msk
#define CRC_DR_DR_0                                                        (0x1U << CRC_DR_DR_Pos)
#define CRC_DR_DR_1                                                        (0x2U << CRC_DR_DR_Pos)
#define CRC_DR_DR_2                                                        (0x4U << CRC_DR_DR_Pos)
#define CRC_DR_DR_3                                                        (0x8U << CRC_DR_DR_Pos)
#define CRC_DR_DR_4                                                        (0x10U << CRC_DR_DR_Pos)
#define CRC_DR_DR_5                                                        (0x20U << CRC_DR_DR_Pos)
#define CRC_DR_DR_6                                                        (0x40U << CRC_DR_DR_Pos)
#define CRC_DR_DR_7                                                        (0x80U << CRC_DR_DR_Pos)
#define CRC_DR_DR_8                                                        (0x100U << CRC_DR_DR_Pos)
#define CRC_DR_DR_9                                                        (0x200U << CRC_DR_DR_Pos)
#define CRC_DR_DR_10                                                       (0x400U << CRC_DR_DR_Pos)
#define CRC_DR_DR_11                                                       (0x800U << CRC_DR_DR_Pos)
#define CRC_DR_DR_12                                                       (0x1000U << CRC_DR_DR_Pos)
#define CRC_DR_DR_13                                                       (0x2000U << CRC_DR_DR_Pos)
#define CRC_DR_DR_14                                                       (0x4000U << CRC_DR_DR_Pos)
#define CRC_DR_DR_15                                                       (0x8000U << CRC_DR_DR_Pos)
#define CRC_DR_DR_16                                                       (0x10000U << CRC_DR_DR_Pos)
#define CRC_DR_DR_17                                                       (0x20000U << CRC_DR_DR_Pos)
#define CRC_DR_DR_18                                                       (0x40000U << CRC_DR_DR_Pos)
#define CRC_DR_DR_19                                                       (0x80000U << CRC_DR_DR_Pos)
#define CRC_DR_DR_20                                                       (0x100000U << CRC_DR_DR_Pos)
#define CRC_DR_DR_21                                                       (0x200000U << CRC_DR_DR_Pos)
#define CRC_DR_DR_22                                                       (0x400000U << CRC_DR_DR_Pos)
#define CRC_DR_DR_23                                                       (0x800000U << CRC_DR_DR_Pos)
#define CRC_DR_DR_24                                                       (0x1000000U << CRC_DR_DR_Pos)
#define CRC_DR_DR_25                                                       (0x2000000U << CRC_DR_DR_Pos)
#define CRC_DR_DR_26                                                       (0x4000000U << CRC_DR_DR_Pos)
#define CRC_DR_DR_27                                                       (0x8000000U << CRC_DR_DR_Pos)
#define CRC_DR_DR_28                                                       (0x10000000U << CRC_DR_DR_Pos)
#define CRC_DR_DR_29                                                       (0x20000000U << CRC_DR_DR_Pos)
#define CRC_DR_DR_30                                                       (0x40000000U << CRC_DR_DR_Pos)
#define CRC_DR_DR_31                                                       (0x80000000UL << CRC_DR_DR_Pos)

/* =====================================================    IDR    ===================================================== */ 
#define CRC_IDR_IDR_Pos                                                    (0UL)		/*!<CRC IDR: IDR (Bit 0) */
#define CRC_IDR_IDR_Msk                                                    (0xffffffffUL)		/*!< CRC IDR: IDR (Bitfield-Mask: 0xffffffff) */
#define CRC_IDR_IDR                                                        CRC_IDR_IDR_Msk
#define CRC_IDR_IDR_0                                                      (0x1U << CRC_IDR_IDR_Pos)
#define CRC_IDR_IDR_1                                                      (0x2U << CRC_IDR_IDR_Pos)
#define CRC_IDR_IDR_2                                                      (0x4U << CRC_IDR_IDR_Pos)
#define CRC_IDR_IDR_3                                                      (0x8U << CRC_IDR_IDR_Pos)
#define CRC_IDR_IDR_4                                                      (0x10U << CRC_IDR_IDR_Pos)
#define CRC_IDR_IDR_5                                                      (0x20U << CRC_IDR_IDR_Pos)
#define CRC_IDR_IDR_6                                                      (0x40U << CRC_IDR_IDR_Pos)
#define CRC_IDR_IDR_7                                                      (0x80U << CRC_IDR_IDR_Pos)
#define CRC_IDR_IDR_8                                                      (0x100U << CRC_IDR_IDR_Pos)
#define CRC_IDR_IDR_9                                                      (0x200U << CRC_IDR_IDR_Pos)
#define CRC_IDR_IDR_10                                                     (0x400U << CRC_IDR_IDR_Pos)
#define CRC_IDR_IDR_11                                                     (0x800U << CRC_IDR_IDR_Pos)
#define CRC_IDR_IDR_12                                                     (0x1000U << CRC_IDR_IDR_Pos)
#define CRC_IDR_IDR_13                                                     (0x2000U << CRC_IDR_IDR_Pos)
#define CRC_IDR_IDR_14                                                     (0x4000U << CRC_IDR_IDR_Pos)
#define CRC_IDR_IDR_15                                                     (0x8000U << CRC_IDR_IDR_Pos)
#define CRC_IDR_IDR_16                                                     (0x10000U << CRC_IDR_IDR_Pos)
#define CRC_IDR_IDR_17                                                     (0x20000U << CRC_IDR_IDR_Pos)
#define CRC_IDR_IDR_18                                                     (0x40000U << CRC_IDR_IDR_Pos)
#define CRC_IDR_IDR_19                                                     (0x80000U << CRC_IDR_IDR_Pos)
#define CRC_IDR_IDR_20                                                     (0x100000U << CRC_IDR_IDR_Pos)
#define CRC_IDR_IDR_21                                                     (0x200000U << CRC_IDR_IDR_Pos)
#define CRC_IDR_IDR_22                                                     (0x400000U << CRC_IDR_IDR_Pos)
#define CRC_IDR_IDR_23                                                     (0x800000U << CRC_IDR_IDR_Pos)
#define CRC_IDR_IDR_24                                                     (0x1000000U << CRC_IDR_IDR_Pos)
#define CRC_IDR_IDR_25                                                     (0x2000000U << CRC_IDR_IDR_Pos)
#define CRC_IDR_IDR_26                                                     (0x4000000U << CRC_IDR_IDR_Pos)
#define CRC_IDR_IDR_27                                                     (0x8000000U << CRC_IDR_IDR_Pos)
#define CRC_IDR_IDR_28                                                     (0x10000000U << CRC_IDR_IDR_Pos)
#define CRC_IDR_IDR_29                                                     (0x20000000U << CRC_IDR_IDR_Pos)
#define CRC_IDR_IDR_30                                                     (0x40000000U << CRC_IDR_IDR_Pos)
#define CRC_IDR_IDR_31                                                     (0x80000000UL << CRC_IDR_IDR_Pos)

/* =====================================================    CR    ===================================================== */ 
#define CRC_CR_REV_OUT_Pos                                                 (7UL)		/*!<CRC CR: REV_OUT (Bit 7) */
#define CRC_CR_REV_OUT_Msk                                                 (0x80UL)		/*!< CRC CR: REV_OUT (Bitfield-Mask: 0x01) */
#define CRC_CR_REV_OUT                                                     CRC_CR_REV_OUT_Msk
#define CRC_CR_REV_IN_Pos                                                  (5UL)		/*!<CRC CR: REV_IN (Bit 5) */
#define CRC_CR_REV_IN_Msk                                                  (0x60UL)		/*!< CRC CR: REV_IN (Bitfield-Mask: 0x03) */
#define CRC_CR_REV_IN                                                      CRC_CR_REV_IN_Msk
#define CRC_CR_REV_IN_0                                                    (0x1U << CRC_CR_REV_IN_Pos)
#define CRC_CR_REV_IN_1                                                    (0x2U << CRC_CR_REV_IN_Pos)
#define CRC_CR_POLYSIZE_Pos                                                (3UL)		/*!<CRC CR: POLYSIZE (Bit 3) */
#define CRC_CR_POLYSIZE_Msk                                                (0x18UL)		/*!< CRC CR: POLYSIZE (Bitfield-Mask: 0x03) */
#define CRC_CR_POLYSIZE                                                    CRC_CR_POLYSIZE_Msk
#define CRC_CR_POLYSIZE_0                                                  (0x1U << CRC_CR_POLYSIZE_Pos)
#define CRC_CR_POLYSIZE_1                                                  (0x2U << CRC_CR_POLYSIZE_Pos)
#define CRC_CR_RESET_Pos                                                   (0UL)		/*!<CRC CR: RESET (Bit 0) */
#define CRC_CR_RESET_Msk                                                   (0x1UL)		/*!< CRC CR: RESET (Bitfield-Mask: 0x01) */
#define CRC_CR_RESET                                                       CRC_CR_RESET_Msk

/* =====================================================    INIT    ===================================================== */ 
#define CRC_INIT_CRC_INIT_Pos                                              (0UL)		/*!<CRC INIT: CRC_INIT (Bit 0) */
#define CRC_INIT_CRC_INIT_Msk                                              (0xffffffffUL)		/*!< CRC INIT: CRC_INIT (Bitfield-Mask: 0xffffffff) */
#define CRC_INIT_CRC_INIT                                                  CRC_INIT_CRC_INIT_Msk
#define CRC_INIT_CRC_INIT_0                                                (0x1U << CRC_INIT_CRC_INIT_Pos)
#define CRC_INIT_CRC_INIT_1                                                (0x2U << CRC_INIT_CRC_INIT_Pos)
#define CRC_INIT_CRC_INIT_2                                                (0x4U << CRC_INIT_CRC_INIT_Pos)
#define CRC_INIT_CRC_INIT_3                                                (0x8U << CRC_INIT_CRC_INIT_Pos)
#define CRC_INIT_CRC_INIT_4                                                (0x10U << CRC_INIT_CRC_INIT_Pos)
#define CRC_INIT_CRC_INIT_5                                                (0x20U << CRC_INIT_CRC_INIT_Pos)
#define CRC_INIT_CRC_INIT_6                                                (0x40U << CRC_INIT_CRC_INIT_Pos)
#define CRC_INIT_CRC_INIT_7                                                (0x80U << CRC_INIT_CRC_INIT_Pos)
#define CRC_INIT_CRC_INIT_8                                                (0x100U << CRC_INIT_CRC_INIT_Pos)
#define CRC_INIT_CRC_INIT_9                                                (0x200U << CRC_INIT_CRC_INIT_Pos)
#define CRC_INIT_CRC_INIT_10                                               (0x400U << CRC_INIT_CRC_INIT_Pos)
#define CRC_INIT_CRC_INIT_11                                               (0x800U << CRC_INIT_CRC_INIT_Pos)
#define CRC_INIT_CRC_INIT_12                                               (0x1000U << CRC_INIT_CRC_INIT_Pos)
#define CRC_INIT_CRC_INIT_13                                               (0x2000U << CRC_INIT_CRC_INIT_Pos)
#define CRC_INIT_CRC_INIT_14                                               (0x4000U << CRC_INIT_CRC_INIT_Pos)
#define CRC_INIT_CRC_INIT_15                                               (0x8000U << CRC_INIT_CRC_INIT_Pos)
#define CRC_INIT_CRC_INIT_16                                               (0x10000U << CRC_INIT_CRC_INIT_Pos)
#define CRC_INIT_CRC_INIT_17                                               (0x20000U << CRC_INIT_CRC_INIT_Pos)
#define CRC_INIT_CRC_INIT_18                                               (0x40000U << CRC_INIT_CRC_INIT_Pos)
#define CRC_INIT_CRC_INIT_19                                               (0x80000U << CRC_INIT_CRC_INIT_Pos)
#define CRC_INIT_CRC_INIT_20                                               (0x100000U << CRC_INIT_CRC_INIT_Pos)
#define CRC_INIT_CRC_INIT_21                                               (0x200000U << CRC_INIT_CRC_INIT_Pos)
#define CRC_INIT_CRC_INIT_22                                               (0x400000U << CRC_INIT_CRC_INIT_Pos)
#define CRC_INIT_CRC_INIT_23                                               (0x800000U << CRC_INIT_CRC_INIT_Pos)
#define CRC_INIT_CRC_INIT_24                                               (0x1000000U << CRC_INIT_CRC_INIT_Pos)
#define CRC_INIT_CRC_INIT_25                                               (0x2000000U << CRC_INIT_CRC_INIT_Pos)
#define CRC_INIT_CRC_INIT_26                                               (0x4000000U << CRC_INIT_CRC_INIT_Pos)
#define CRC_INIT_CRC_INIT_27                                               (0x8000000U << CRC_INIT_CRC_INIT_Pos)
#define CRC_INIT_CRC_INIT_28                                               (0x10000000U << CRC_INIT_CRC_INIT_Pos)
#define CRC_INIT_CRC_INIT_29                                               (0x20000000U << CRC_INIT_CRC_INIT_Pos)
#define CRC_INIT_CRC_INIT_30                                               (0x40000000U << CRC_INIT_CRC_INIT_Pos)
#define CRC_INIT_CRC_INIT_31                                               (0x80000000UL << CRC_INIT_CRC_INIT_Pos)

/* =====================================================    POL    ===================================================== */ 
#define CRC_POL_POL_Pos                                                    (0UL)		/*!<CRC POL: POL (Bit 0) */
#define CRC_POL_POL_Msk                                                    (0xffffffffUL)		/*!< CRC POL: POL (Bitfield-Mask: 0xffffffff) */
#define CRC_POL_POL                                                        CRC_POL_POL_Msk
#define CRC_POL_POL_0                                                      (0x1U << CRC_POL_POL_Pos)
#define CRC_POL_POL_1                                                      (0x2U << CRC_POL_POL_Pos)
#define CRC_POL_POL_2                                                      (0x4U << CRC_POL_POL_Pos)
#define CRC_POL_POL_3                                                      (0x8U << CRC_POL_POL_Pos)
#define CRC_POL_POL_4                                                      (0x10U << CRC_POL_POL_Pos)
#define CRC_POL_POL_5                                                      (0x20U << CRC_POL_POL_Pos)
#define CRC_POL_POL_6                                                      (0x40U << CRC_POL_POL_Pos)
#define CRC_POL_POL_7                                                      (0x80U << CRC_POL_POL_Pos)
#define CRC_POL_POL_8                                                      (0x100U << CRC_POL_POL_Pos)
#define CRC_POL_POL_9                                                      (0x200U << CRC_POL_POL_Pos)
#define CRC_POL_POL_10                                                     (0x400U << CRC_POL_POL_Pos)
#define CRC_POL_POL_11                                                     (0x800U << CRC_POL_POL_Pos)
#define CRC_POL_POL_12                                                     (0x1000U << CRC_POL_POL_Pos)
#define CRC_POL_POL_13                                                     (0x2000U << CRC_POL_POL_Pos)
#define CRC_POL_POL_14                                                     (0x4000U << CRC_POL_POL_Pos)
#define CRC_POL_POL_15                                                     (0x8000U << CRC_POL_POL_Pos)
#define CRC_POL_POL_16                                                     (0x10000U << CRC_POL_POL_Pos)
#define CRC_POL_POL_17                                                     (0x20000U << CRC_POL_POL_Pos)
#define CRC_POL_POL_18                                                     (0x40000U << CRC_POL_POL_Pos)
#define CRC_POL_POL_19                                                     (0x80000U << CRC_POL_POL_Pos)
#define CRC_POL_POL_20                                                     (0x100000U << CRC_POL_POL_Pos)
#define CRC_POL_POL_21                                                     (0x200000U << CRC_POL_POL_Pos)
#define CRC_POL_POL_22                                                     (0x400000U << CRC_POL_POL_Pos)
#define CRC_POL_POL_23                                                     (0x800000U << CRC_POL_POL_Pos)
#define CRC_POL_POL_24                                                     (0x1000000U << CRC_POL_POL_Pos)
#define CRC_POL_POL_25                                                     (0x2000000U << CRC_POL_POL_Pos)
#define CRC_POL_POL_26                                                     (0x4000000U << CRC_POL_POL_Pos)
#define CRC_POL_POL_27                                                     (0x8000000U << CRC_POL_POL_Pos)
#define CRC_POL_POL_28                                                     (0x10000000U << CRC_POL_POL_Pos)
#define CRC_POL_POL_29                                                     (0x20000000U << CRC_POL_POL_Pos)
#define CRC_POL_POL_30                                                     (0x40000000U << CRC_POL_POL_Pos)
#define CRC_POL_POL_31                                                     (0x80000000UL << CRC_POL_POL_Pos)


/* =========================================================================================================================== */
/* ================                                           IWDG                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  KR  =========================================================== */
#define IWDG_KR_KEY_Pos                   (0UL)                     /*!< IWDG KR: KEY (Bit 0)                                  */
#define IWDG_KR_KEY_Msk                   (0xffffUL)                /*!< IWDG KR: KEY (Bitfield-Mask: 0xffff)                  */
#define IWDG_KR_KEY                       IWDG_KR_KEY_Msk
#define IWDG_KR_KEY_0                     (0x1U << IWDG_KR_KEY_Pos)
#define IWDG_KR_KEY_1                     (0x2U << IWDG_KR_KEY_Pos)
#define IWDG_KR_KEY_2                     (0x4U << IWDG_KR_KEY_Pos)
#define IWDG_KR_KEY_3                     (0x8U << IWDG_KR_KEY_Pos)
#define IWDG_KR_KEY_4                     (0x10U << IWDG_KR_KEY_Pos)
#define IWDG_KR_KEY_5                     (0x20U << IWDG_KR_KEY_Pos)
#define IWDG_KR_KEY_6                     (0x40U << IWDG_KR_KEY_Pos)
#define IWDG_KR_KEY_7                     (0x80U << IWDG_KR_KEY_Pos)
#define IWDG_KR_KEY_8                     (0x100U << IWDG_KR_KEY_Pos)
#define IWDG_KR_KEY_9                     (0x200U << IWDG_KR_KEY_Pos)
#define IWDG_KR_KEY_10                    (0x400U << IWDG_KR_KEY_Pos)
#define IWDG_KR_KEY_11                    (0x800U << IWDG_KR_KEY_Pos)
#define IWDG_KR_KEY_12                    (0x1000U << IWDG_KR_KEY_Pos)
#define IWDG_KR_KEY_13                    (0x2000U << IWDG_KR_KEY_Pos)
#define IWDG_KR_KEY_14                    (0x4000U << IWDG_KR_KEY_Pos)
#define IWDG_KR_KEY_15                    (0x8000U << IWDG_KR_KEY_Pos)
  
/* ==========================================================  PR  =========================================================== */
#define IWDG_PR_PR_Pos                    (0UL)                     /*!< IWDG PR: PR (Bit 0)                                   */
#define IWDG_PR_PR_Msk                    (0x7UL)                   /*!< IWDG PR: PR (Bitfield-Mask: 0x07)                     */
#define IWDG_PR_PR                        IWDG_PR_PR_Msk
#define IWDG_PR_PR_0                      (0x1U << IWDG_PR_PR_Pos)
#define IWDG_PR_PR_1                      (0x2U << IWDG_PR_PR_Pos)
#define IWDG_PR_PR_2                      (0x4U << IWDG_PR_PR_Pos)
  
/* ==========================================================  RLR  ========================================================== */
#define IWDG_RLR_RL_Pos                   (0UL)                     /*!< IWDG RLR: RL (Bit 0)                                  */
#define IWDG_RLR_RL_Msk                   (0xfffUL)                 /*!< IWDG RLR: RL (Bitfield-Mask: 0xfff)                   */
#define IWDG_RLR_RL                       IWDG_RLR_RL_Msk
#define IWDG_RLR_RL_0                     (0x1U << IWDG_RLR_RL_Pos)
#define IWDG_RLR_RL_1                     (0x2U << IWDG_RLR_RL_Pos)
#define IWDG_RLR_RL_2                     (0x4U << IWDG_RLR_RL_Pos)
#define IWDG_RLR_RL_3                     (0x8U << IWDG_RLR_RL_Pos)
#define IWDG_RLR_RL_4                     (0x10U << IWDG_RLR_RL_Pos)
#define IWDG_RLR_RL_5                     (0x20U << IWDG_RLR_RL_Pos)
#define IWDG_RLR_RL_6                     (0x40U << IWDG_RLR_RL_Pos)
#define IWDG_RLR_RL_7                     (0x80U << IWDG_RLR_RL_Pos)
#define IWDG_RLR_RL_8                     (0x100U << IWDG_RLR_RL_Pos)
#define IWDG_RLR_RL_9                     (0x200U << IWDG_RLR_RL_Pos)
#define IWDG_RLR_RL_10                    (0x400U << IWDG_RLR_RL_Pos)
#define IWDG_RLR_RL_11                    (0x800U << IWDG_RLR_RL_Pos)
  
/* ==========================================================  SR  =========================================================== */
#define IWDG_SR_WVU_Pos                   (2UL)                     /*!< IWDG SR: WVU (Bit 2)                                  */
#define IWDG_SR_WVU_Msk                   (0x4UL)                   /*!< IWDG SR: WVU (Bitfield-Mask: 0x01)                    */
#define IWDG_SR_WVU                       IWDG_SR_WVU_Msk
#define IWDG_SR_RVU_Pos                   (1UL)                     /*!< IWDG SR: RVU (Bit 1)                                  */
#define IWDG_SR_RVU_Msk                   (0x2UL)                   /*!< IWDG SR: RVU (Bitfield-Mask: 0x01)                    */
#define IWDG_SR_RVU                       IWDG_SR_RVU_Msk
#define IWDG_SR_PVU_Pos                   (0UL)                     /*!< IWDG SR: PVU (Bit 0)                                  */
#define IWDG_SR_PVU_Msk                   (0x1UL)                   /*!< IWDG SR: PVU (Bitfield-Mask: 0x01)                    */
#define IWDG_SR_PVU                       IWDG_SR_PVU_Msk

/* =========================================================  WINR  ========================================================== */
#define IWDG_WINR_WIN_Pos                 (0UL)                     /*!< IWDG WINR: WIN (Bit 0)                                */
#define IWDG_WINR_WIN_Msk                 (0xfffUL)                 /*!< IWDG WINR: WIN (Bitfield-Mask: 0xfff)                 */
#define IWDG_WINR_WIN                     IWDG_WINR_WIN_Msk
#define IWDG_WINR_WIN_0                   (0x1U << IWDG_WINR_WIN_Pos)
#define IWDG_WINR_WIN_1                   (0x2U << IWDG_WINR_WIN_Pos)
#define IWDG_WINR_WIN_2                   (0x4U << IWDG_WINR_WIN_Pos)
#define IWDG_WINR_WIN_3                   (0x8U << IWDG_WINR_WIN_Pos)
#define IWDG_WINR_WIN_4                   (0x10U << IWDG_WINR_WIN_Pos)
#define IWDG_WINR_WIN_5                   (0x20U << IWDG_WINR_WIN_Pos)
#define IWDG_WINR_WIN_6                   (0x40U << IWDG_WINR_WIN_Pos)
#define IWDG_WINR_WIN_7                   (0x80U << IWDG_WINR_WIN_Pos)
#define IWDG_WINR_WIN_8                   (0x100U << IWDG_WINR_WIN_Pos)
#define IWDG_WINR_WIN_9                   (0x200U << IWDG_WINR_WIN_Pos)
#define IWDG_WINR_WIN_10                  (0x400U << IWDG_WINR_WIN_Pos)
#define IWDG_WINR_WIN_11                  (0x800U << IWDG_WINR_WIN_Pos)


/* =========================================================================================================================== */ 
/*=====================                                       I2C                                       ===================== */ 
/* =========================================================================================================================== */ 

/* =====================================================    CR1    ===================================================== */ 
#define I2C_CR1_PECEN_Pos                                                  (23UL)		/*!<I2C CR1: PECEN (Bit 23) */
#define I2C_CR1_PECEN_Msk                                                  (0x800000UL)		/*!< I2C CR1: PECEN (Bitfield-Mask: 0x01) */
#define I2C_CR1_PECEN                                                      I2C_CR1_PECEN_Msk
#define I2C_CR1_ALERTEN_Pos                                                (22UL)		/*!<I2C CR1: ALERTEN (Bit 22) */
#define I2C_CR1_ALERTEN_Msk                                                (0x400000UL)		/*!< I2C CR1: ALERTEN (Bitfield-Mask: 0x01) */
#define I2C_CR1_ALERTEN                                                    I2C_CR1_ALERTEN_Msk
#define I2C_CR1_SMBDEN_Pos                                                 (21UL)		/*!<I2C CR1: SMBDEN (Bit 21) */
#define I2C_CR1_SMBDEN_Msk                                                 (0x200000UL)		/*!< I2C CR1: SMBDEN (Bitfield-Mask: 0x01) */
#define I2C_CR1_SMBDEN                                                     I2C_CR1_SMBDEN_Msk
#define I2C_CR1_SMBHEN_Pos                                                 (20UL)		/*!<I2C CR1: SMBHEN (Bit 20) */
#define I2C_CR1_SMBHEN_Msk                                                 (0x100000UL)		/*!< I2C CR1: SMBHEN (Bitfield-Mask: 0x01) */
#define I2C_CR1_SMBHEN                                                     I2C_CR1_SMBHEN_Msk
#define I2C_CR1_GCEN_Pos                                                   (19UL)		/*!<I2C CR1: GCEN (Bit 19) */
#define I2C_CR1_GCEN_Msk                                                   (0x80000UL)		/*!< I2C CR1: GCEN (Bitfield-Mask: 0x01) */
#define I2C_CR1_GCEN                                                       I2C_CR1_GCEN_Msk
#define I2C_CR1_NOSTRETCH_Pos                                              (17UL)		/*!<I2C CR1: NOSTRETCH (Bit 17) */
#define I2C_CR1_NOSTRETCH_Msk                                              (0x20000UL)		/*!< I2C CR1: NOSTRETCH (Bitfield-Mask: 0x01) */
#define I2C_CR1_NOSTRETCH                                                  I2C_CR1_NOSTRETCH_Msk
#define I2C_CR1_SBC_Pos                                                    (16UL)		/*!<I2C CR1: SBC (Bit 16) */
#define I2C_CR1_SBC_Msk                                                    (0x10000UL)		/*!< I2C CR1: SBC (Bitfield-Mask: 0x01) */
#define I2C_CR1_SBC                                                        I2C_CR1_SBC_Msk
#define I2C_CR1_RXDMAEN_Pos                                                (15UL)		/*!<I2C CR1: RXDMAEN (Bit 15) */
#define I2C_CR1_RXDMAEN_Msk                                                (0x8000UL)		/*!< I2C CR1: RXDMAEN (Bitfield-Mask: 0x01) */
#define I2C_CR1_RXDMAEN                                                    I2C_CR1_RXDMAEN_Msk
#define I2C_CR1_TXDMAEN_Pos                                                (14UL)		/*!<I2C CR1: TXDMAEN (Bit 14) */
#define I2C_CR1_TXDMAEN_Msk                                                (0x4000UL)		/*!< I2C CR1: TXDMAEN (Bitfield-Mask: 0x01) */
#define I2C_CR1_TXDMAEN                                                    I2C_CR1_TXDMAEN_Msk
#define I2C_CR1_ANFOFF_Pos                                                 (12UL)		/*!<I2C CR1: ANFOFF (Bit 12) */
#define I2C_CR1_ANFOFF_Msk                                                 (0x1000UL)		/*!< I2C CR1: ANFOFF (Bitfield-Mask: 0x01) */
#define I2C_CR1_ANFOFF                                                     I2C_CR1_ANFOFF_Msk
#define I2C_CR1_DNF_Pos                                                    (8UL)		/*!<I2C CR1: DNF (Bit 8) */
#define I2C_CR1_DNF_Msk                                                    (0xf00UL)		/*!< I2C CR1: DNF (Bitfield-Mask: 0x0f) */
#define I2C_CR1_DNF                                                        I2C_CR1_DNF_Msk
#define I2C_CR1_DNF_0                                                      (0x1U << I2C_CR1_DNF_Pos)
#define I2C_CR1_DNF_1                                                      (0x2U << I2C_CR1_DNF_Pos)
#define I2C_CR1_DNF_2                                                      (0x4U << I2C_CR1_DNF_Pos)
#define I2C_CR1_DNF_3                                                      (0x8U << I2C_CR1_DNF_Pos)
#define I2C_CR1_ERRIE_Pos                                                  (7UL)		/*!<I2C CR1: ERRIE (Bit 7) */
#define I2C_CR1_ERRIE_Msk                                                  (0x80UL)		/*!< I2C CR1: ERRIE (Bitfield-Mask: 0x01) */
#define I2C_CR1_ERRIE                                                      I2C_CR1_ERRIE_Msk
#define I2C_CR1_TCIE_Pos                                                   (6UL)		/*!<I2C CR1: TCIE (Bit 6) */
#define I2C_CR1_TCIE_Msk                                                   (0x40UL)		/*!< I2C CR1: TCIE (Bitfield-Mask: 0x01) */
#define I2C_CR1_TCIE                                                       I2C_CR1_TCIE_Msk
#define I2C_CR1_STOPIE_Pos                                                 (5UL)		/*!<I2C CR1: STOPIE (Bit 5) */
#define I2C_CR1_STOPIE_Msk                                                 (0x20UL)		/*!< I2C CR1: STOPIE (Bitfield-Mask: 0x01) */
#define I2C_CR1_STOPIE                                                     I2C_CR1_STOPIE_Msk
#define I2C_CR1_NACKIE_Pos                                                 (4UL)		/*!<I2C CR1: NACKIE (Bit 4) */
#define I2C_CR1_NACKIE_Msk                                                 (0x10UL)		/*!< I2C CR1: NACKIE (Bitfield-Mask: 0x01) */
#define I2C_CR1_NACKIE                                                     I2C_CR1_NACKIE_Msk
#define I2C_CR1_ADDRIE_Pos                                                 (3UL)		/*!<I2C CR1: ADDRIE (Bit 3) */
#define I2C_CR1_ADDRIE_Msk                                                 (0x8UL)		/*!< I2C CR1: ADDRIE (Bitfield-Mask: 0x01) */
#define I2C_CR1_ADDRIE                                                     I2C_CR1_ADDRIE_Msk
#define I2C_CR1_RXIE_Pos                                                   (2UL)		/*!<I2C CR1: RXIE (Bit 2) */
#define I2C_CR1_RXIE_Msk                                                   (0x4UL)		/*!< I2C CR1: RXIE (Bitfield-Mask: 0x01) */
#define I2C_CR1_RXIE                                                       I2C_CR1_RXIE_Msk
#define I2C_CR1_TXIE_Pos                                                   (1UL)		/*!<I2C CR1: TXIE (Bit 1) */
#define I2C_CR1_TXIE_Msk                                                   (0x2UL)		/*!< I2C CR1: TXIE (Bitfield-Mask: 0x01) */
#define I2C_CR1_TXIE                                                       I2C_CR1_TXIE_Msk
#define I2C_CR1_PE_Pos                                                     (0UL)		/*!<I2C CR1: PE (Bit 0) */
#define I2C_CR1_PE_Msk                                                     (0x1UL)		/*!< I2C CR1: PE (Bitfield-Mask: 0x01) */
#define I2C_CR1_PE                                                         I2C_CR1_PE_Msk

/* =====================================================    CR2    ===================================================== */ 
#define I2C_CR2_PECBYTE_Pos                                                (26UL)		/*!<I2C CR2: PECBYTE (Bit 26) */
#define I2C_CR2_PECBYTE_Msk                                                (0x4000000UL)		/*!< I2C CR2: PECBYTE (Bitfield-Mask: 0x01) */
#define I2C_CR2_PECBYTE                                                    I2C_CR2_PECBYTE_Msk
#define I2C_CR2_AUTOEND_Pos                                                (25UL)		/*!<I2C CR2: AUTOEND (Bit 25) */
#define I2C_CR2_AUTOEND_Msk                                                (0x2000000UL)		/*!< I2C CR2: AUTOEND (Bitfield-Mask: 0x01) */
#define I2C_CR2_AUTOEND                                                    I2C_CR2_AUTOEND_Msk
#define I2C_CR2_RELOAD_Pos                                                 (24UL)		/*!<I2C CR2: RELOAD (Bit 24) */
#define I2C_CR2_RELOAD_Msk                                                 (0x1000000UL)		/*!< I2C CR2: RELOAD (Bitfield-Mask: 0x01) */
#define I2C_CR2_RELOAD                                                     I2C_CR2_RELOAD_Msk
#define I2C_CR2_NBYTES_Pos                                                 (16UL)		/*!<I2C CR2: NBYTES (Bit 16) */
#define I2C_CR2_NBYTES_Msk                                                 (0xff0000UL)		/*!< I2C CR2: NBYTES (Bitfield-Mask: 0xff) */
#define I2C_CR2_NBYTES                                                     I2C_CR2_NBYTES_Msk
#define I2C_CR2_NBYTES_0                                                   (0x1U << I2C_CR2_NBYTES_Pos)
#define I2C_CR2_NBYTES_1                                                   (0x2U << I2C_CR2_NBYTES_Pos)
#define I2C_CR2_NBYTES_2                                                   (0x4U << I2C_CR2_NBYTES_Pos)
#define I2C_CR2_NBYTES_3                                                   (0x8U << I2C_CR2_NBYTES_Pos)
#define I2C_CR2_NBYTES_4                                                   (0x10U << I2C_CR2_NBYTES_Pos)
#define I2C_CR2_NBYTES_5                                                   (0x20U << I2C_CR2_NBYTES_Pos)
#define I2C_CR2_NBYTES_6                                                   (0x40U << I2C_CR2_NBYTES_Pos)
#define I2C_CR2_NBYTES_7                                                   (0x80U << I2C_CR2_NBYTES_Pos)
#define I2C_CR2_NACK_Pos                                                   (15UL)		/*!<I2C CR2: NACK (Bit 15) */
#define I2C_CR2_NACK_Msk                                                   (0x8000UL)		/*!< I2C CR2: NACK (Bitfield-Mask: 0x01) */
#define I2C_CR2_NACK                                                       I2C_CR2_NACK_Msk
#define I2C_CR2_STOP_Pos                                                   (14UL)		/*!<I2C CR2: STOP (Bit 14) */
#define I2C_CR2_STOP_Msk                                                   (0x4000UL)		/*!< I2C CR2: STOP (Bitfield-Mask: 0x01) */
#define I2C_CR2_STOP                                                       I2C_CR2_STOP_Msk
#define I2C_CR2_START_Pos                                                  (13UL)		/*!<I2C CR2: START (Bit 13) */
#define I2C_CR2_START_Msk                                                  (0x2000UL)		/*!< I2C CR2: START (Bitfield-Mask: 0x01) */
#define I2C_CR2_START                                                      I2C_CR2_START_Msk
#define I2C_CR2_HEAD10R_Pos                                                (12UL)		/*!<I2C CR2: HEAD10R (Bit 12) */
#define I2C_CR2_HEAD10R_Msk                                                (0x1000UL)		/*!< I2C CR2: HEAD10R (Bitfield-Mask: 0x01) */
#define I2C_CR2_HEAD10R                                                    I2C_CR2_HEAD10R_Msk
#define I2C_CR2_ADD10_Pos                                                  (11UL)		/*!<I2C CR2: ADD10 (Bit 11) */
#define I2C_CR2_ADD10_Msk                                                  (0x800UL)		/*!< I2C CR2: ADD10 (Bitfield-Mask: 0x01) */
#define I2C_CR2_ADD10                                                      I2C_CR2_ADD10_Msk
#define I2C_CR2_RD_WRN_Pos                                                 (10UL)		/*!<I2C CR2: RD_WRN (Bit 10) */
#define I2C_CR2_RD_WRN_Msk                                                 (0x400UL)		/*!< I2C CR2: RD_WRN (Bitfield-Mask: 0x01) */
#define I2C_CR2_RD_WRN                                                     I2C_CR2_RD_WRN_Msk
#define I2C_CR2_SADD_Pos                                                   (0UL)		/*!<I2C CR2: SADD (Bit 0) */
#define I2C_CR2_SADD_Msk                                                   (0x3ffUL)		/*!< I2C CR2: SADD (Bitfield-Mask: 0x3ff) */
#define I2C_CR2_SADD                                                       I2C_CR2_SADD_Msk
#define I2C_CR2_SADD_0                                                     (0x1U << I2C_CR2_SADD_Pos)
#define I2C_CR2_SADD_1                                                     (0x2U << I2C_CR2_SADD_Pos)
#define I2C_CR2_SADD_2                                                     (0x4U << I2C_CR2_SADD_Pos)
#define I2C_CR2_SADD_3                                                     (0x8U << I2C_CR2_SADD_Pos)
#define I2C_CR2_SADD_4                                                     (0x10U << I2C_CR2_SADD_Pos)
#define I2C_CR2_SADD_5                                                     (0x20U << I2C_CR2_SADD_Pos)
#define I2C_CR2_SADD_6                                                     (0x40U << I2C_CR2_SADD_Pos)
#define I2C_CR2_SADD_7                                                     (0x80U << I2C_CR2_SADD_Pos)
#define I2C_CR2_SADD_8                                                     (0x100U << I2C_CR2_SADD_Pos)
#define I2C_CR2_SADD_9                                                     (0x200U << I2C_CR2_SADD_Pos)

/* =====================================================    OAR1    ===================================================== */ 
#define I2C_OAR1_OA1EN_Pos                                                 (15UL)		/*!<I2C OAR1: OA1EN (Bit 15) */
#define I2C_OAR1_OA1EN_Msk                                                 (0x8000UL)		/*!< I2C OAR1: OA1EN (Bitfield-Mask: 0x01) */
#define I2C_OAR1_OA1EN                                                     I2C_OAR1_OA1EN_Msk
#define I2C_OAR1_OA1MODE_Pos                                               (10UL)		/*!<I2C OAR1: OA1MODE (Bit 10) */
#define I2C_OAR1_OA1MODE_Msk                                               (0x400UL)		/*!< I2C OAR1: OA1MODE (Bitfield-Mask: 0x01) */
#define I2C_OAR1_OA1MODE                                                   I2C_OAR1_OA1MODE_Msk
#define I2C_OAR1_OA1_Pos                                                   (0UL)		/*!<I2C OAR1: OA1 (Bit 0) */
#define I2C_OAR1_OA1_Msk                                                   (0x3ffUL)		/*!< I2C OAR1: OA1 (Bitfield-Mask: 0x3ff) */
#define I2C_OAR1_OA1                                                       I2C_OAR1_OA1_Msk
#define I2C_OAR1_OA1_0                                                     (0x1U << I2C_OAR1_OA1_Pos)
#define I2C_OAR1_OA1_1                                                     (0x2U << I2C_OAR1_OA1_Pos)
#define I2C_OAR1_OA1_2                                                     (0x4U << I2C_OAR1_OA1_Pos)
#define I2C_OAR1_OA1_3                                                     (0x8U << I2C_OAR1_OA1_Pos)
#define I2C_OAR1_OA1_4                                                     (0x10U << I2C_OAR1_OA1_Pos)
#define I2C_OAR1_OA1_5                                                     (0x20U << I2C_OAR1_OA1_Pos)
#define I2C_OAR1_OA1_6                                                     (0x40U << I2C_OAR1_OA1_Pos)
#define I2C_OAR1_OA1_7                                                     (0x80U << I2C_OAR1_OA1_Pos)
#define I2C_OAR1_OA1_8                                                     (0x100U << I2C_OAR1_OA1_Pos)
#define I2C_OAR1_OA1_9                                                     (0x200U << I2C_OAR1_OA1_Pos)

/* =====================================================    OAR2    ===================================================== */ 
#define I2C_OAR2_OA2EN_Pos                                                 (15UL)		/*!<I2C OAR2: OA2EN (Bit 15) */
#define I2C_OAR2_OA2EN_Msk                                                 (0x8000UL)		/*!< I2C OAR2: OA2EN (Bitfield-Mask: 0x01) */
#define I2C_OAR2_OA2EN                                                     I2C_OAR2_OA2EN_Msk
#define I2C_OAR2_OA2MSK_Pos                                                (8UL)		/*!<I2C OAR2: OA2MSK (Bit 8) */
#define I2C_OAR2_OA2MSK_Msk                                                (0x700UL)		/*!< I2C OAR2: OA2MSK (Bitfield-Mask: 0x07) */
#define I2C_OAR2_OA2MSK                                                    I2C_OAR2_OA2MSK_Msk
#define I2C_OAR2_OA2MSK_0                                                  (0x1U << I2C_OAR2_OA2MSK_Pos)
#define I2C_OAR2_OA2MSK_1                                                  (0x2U << I2C_OAR2_OA2MSK_Pos)
#define I2C_OAR2_OA2MSK_2                                                  (0x4U << I2C_OAR2_OA2MSK_Pos)
#define I2C_OAR2_OA2_Pos                                                   (1UL)		/*!<I2C OAR2: OA2 (Bit 1) */
#define I2C_OAR2_OA2_Msk                                                   (0xfeUL)		/*!< I2C OAR2: OA2 (Bitfield-Mask: 0x7f) */
#define I2C_OAR2_OA2                                                       I2C_OAR2_OA2_Msk
#define I2C_OAR2_OA2_0                                                     (0x1U << I2C_OAR2_OA2_Pos)
#define I2C_OAR2_OA2_1                                                     (0x2U << I2C_OAR2_OA2_Pos)
#define I2C_OAR2_OA2_2                                                     (0x4U << I2C_OAR2_OA2_Pos)
#define I2C_OAR2_OA2_3                                                     (0x8U << I2C_OAR2_OA2_Pos)
#define I2C_OAR2_OA2_4                                                     (0x10U << I2C_OAR2_OA2_Pos)
#define I2C_OAR2_OA2_5                                                     (0x20U << I2C_OAR2_OA2_Pos)
#define I2C_OAR2_OA2_6                                                     (0x40U << I2C_OAR2_OA2_Pos)

/* =====================================================    TIMINGR    ===================================================== */ 
#define I2C_TIMINGR_PRESC_Pos                                              (28UL)		/*!<I2C TIMINGR: PRESC (Bit 28) */
#define I2C_TIMINGR_PRESC_Msk                                              (0xf0000000UL)		/*!< I2C TIMINGR: PRESC (Bitfield-Mask: 0x0f) */
#define I2C_TIMINGR_PRESC                                                  I2C_TIMINGR_PRESC_Msk
#define I2C_TIMINGR_PRESC_0                                                (0x1U << I2C_TIMINGR_PRESC_Pos)
#define I2C_TIMINGR_PRESC_1                                                (0x2U << I2C_TIMINGR_PRESC_Pos)
#define I2C_TIMINGR_PRESC_2                                                (0x4U << I2C_TIMINGR_PRESC_Pos)
#define I2C_TIMINGR_PRESC_3                                                (0x8U << I2C_TIMINGR_PRESC_Pos)
#define I2C_TIMINGR_SCLDEL_Pos                                             (20UL)		/*!<I2C TIMINGR: SCLDEL (Bit 20) */
#define I2C_TIMINGR_SCLDEL_Msk                                             (0xf00000UL)		/*!< I2C TIMINGR: SCLDEL (Bitfield-Mask: 0x0f) */
#define I2C_TIMINGR_SCLDEL                                                 I2C_TIMINGR_SCLDEL_Msk
#define I2C_TIMINGR_SCLDEL_0                                               (0x1U << I2C_TIMINGR_SCLDEL_Pos)
#define I2C_TIMINGR_SCLDEL_1                                               (0x2U << I2C_TIMINGR_SCLDEL_Pos)
#define I2C_TIMINGR_SCLDEL_2                                               (0x4U << I2C_TIMINGR_SCLDEL_Pos)
#define I2C_TIMINGR_SCLDEL_3                                               (0x8U << I2C_TIMINGR_SCLDEL_Pos)
#define I2C_TIMINGR_SDADEL_Pos                                             (16UL)		/*!<I2C TIMINGR: SDADEL (Bit 16) */
#define I2C_TIMINGR_SDADEL_Msk                                             (0xf0000UL)		/*!< I2C TIMINGR: SDADEL (Bitfield-Mask: 0x0f) */
#define I2C_TIMINGR_SDADEL                                                 I2C_TIMINGR_SDADEL_Msk
#define I2C_TIMINGR_SDADEL_0                                               (0x1U << I2C_TIMINGR_SDADEL_Pos)
#define I2C_TIMINGR_SDADEL_1                                               (0x2U << I2C_TIMINGR_SDADEL_Pos)
#define I2C_TIMINGR_SDADEL_2                                               (0x4U << I2C_TIMINGR_SDADEL_Pos)
#define I2C_TIMINGR_SDADEL_3                                               (0x8U << I2C_TIMINGR_SDADEL_Pos)
#define I2C_TIMINGR_SCLH_Pos                                               (8UL)		/*!<I2C TIMINGR: SCLH (Bit 8) */
#define I2C_TIMINGR_SCLH_Msk                                               (0xff00UL)		/*!< I2C TIMINGR: SCLH (Bitfield-Mask: 0xff) */
#define I2C_TIMINGR_SCLH                                                   I2C_TIMINGR_SCLH_Msk
#define I2C_TIMINGR_SCLH_0                                                 (0x1U << I2C_TIMINGR_SCLH_Pos)
#define I2C_TIMINGR_SCLH_1                                                 (0x2U << I2C_TIMINGR_SCLH_Pos)
#define I2C_TIMINGR_SCLH_2                                                 (0x4U << I2C_TIMINGR_SCLH_Pos)
#define I2C_TIMINGR_SCLH_3                                                 (0x8U << I2C_TIMINGR_SCLH_Pos)
#define I2C_TIMINGR_SCLH_4                                                 (0x10U << I2C_TIMINGR_SCLH_Pos)
#define I2C_TIMINGR_SCLH_5                                                 (0x20U << I2C_TIMINGR_SCLH_Pos)
#define I2C_TIMINGR_SCLH_6                                                 (0x40U << I2C_TIMINGR_SCLH_Pos)
#define I2C_TIMINGR_SCLH_7                                                 (0x80U << I2C_TIMINGR_SCLH_Pos)
#define I2C_TIMINGR_SCLL_Pos                                               (0UL)		/*!<I2C TIMINGR: SCLL (Bit 0) */
#define I2C_TIMINGR_SCLL_Msk                                               (0xffUL)		/*!< I2C TIMINGR: SCLL (Bitfield-Mask: 0xff) */
#define I2C_TIMINGR_SCLL                                                   I2C_TIMINGR_SCLL_Msk
#define I2C_TIMINGR_SCLL_0                                                 (0x1U << I2C_TIMINGR_SCLL_Pos)
#define I2C_TIMINGR_SCLL_1                                                 (0x2U << I2C_TIMINGR_SCLL_Pos)
#define I2C_TIMINGR_SCLL_2                                                 (0x4U << I2C_TIMINGR_SCLL_Pos)
#define I2C_TIMINGR_SCLL_3                                                 (0x8U << I2C_TIMINGR_SCLL_Pos)
#define I2C_TIMINGR_SCLL_4                                                 (0x10U << I2C_TIMINGR_SCLL_Pos)
#define I2C_TIMINGR_SCLL_5                                                 (0x20U << I2C_TIMINGR_SCLL_Pos)
#define I2C_TIMINGR_SCLL_6                                                 (0x40U << I2C_TIMINGR_SCLL_Pos)
#define I2C_TIMINGR_SCLL_7                                                 (0x80U << I2C_TIMINGR_SCLL_Pos)

/* =====================================================    TIMEOUTR    ===================================================== */ 
#define I2C_TIMEOUTR_TEXTEN_Pos                                            (31UL)		/*!<I2C TIMEOUTR: TEXTEN (Bit 31) */
#define I2C_TIMEOUTR_TEXTEN_Msk                                            (0x80000000UL)		/*!< I2C TIMEOUTR: TEXTEN (Bitfield-Mask: 0x01) */
#define I2C_TIMEOUTR_TEXTEN                                                I2C_TIMEOUTR_TEXTEN_Msk
#define I2C_TIMEOUTR_TIMEOUTB_Pos                                          (16UL)		/*!<I2C TIMEOUTR: TIMEOUTB (Bit 16) */
#define I2C_TIMEOUTR_TIMEOUTB_Msk                                          (0xfff0000UL)		/*!< I2C TIMEOUTR: TIMEOUTB (Bitfield-Mask: 0xfff) */
#define I2C_TIMEOUTR_TIMEOUTB                                              I2C_TIMEOUTR_TIMEOUTB_Msk
#define I2C_TIMEOUTR_TIMEOUTB_0                                            (0x1U << I2C_TIMEOUTR_TIMEOUTB_Pos)
#define I2C_TIMEOUTR_TIMEOUTB_1                                            (0x2U << I2C_TIMEOUTR_TIMEOUTB_Pos)
#define I2C_TIMEOUTR_TIMEOUTB_2                                            (0x4U << I2C_TIMEOUTR_TIMEOUTB_Pos)
#define I2C_TIMEOUTR_TIMEOUTB_3                                            (0x8U << I2C_TIMEOUTR_TIMEOUTB_Pos)
#define I2C_TIMEOUTR_TIMEOUTB_4                                            (0x10U << I2C_TIMEOUTR_TIMEOUTB_Pos)
#define I2C_TIMEOUTR_TIMEOUTB_5                                            (0x20U << I2C_TIMEOUTR_TIMEOUTB_Pos)
#define I2C_TIMEOUTR_TIMEOUTB_6                                            (0x40U << I2C_TIMEOUTR_TIMEOUTB_Pos)
#define I2C_TIMEOUTR_TIMEOUTB_7                                            (0x80U << I2C_TIMEOUTR_TIMEOUTB_Pos)
#define I2C_TIMEOUTR_TIMEOUTB_8                                            (0x100U << I2C_TIMEOUTR_TIMEOUTB_Pos)
#define I2C_TIMEOUTR_TIMEOUTB_9                                            (0x200U << I2C_TIMEOUTR_TIMEOUTB_Pos)
#define I2C_TIMEOUTR_TIMEOUTB_10                                           (0x400U << I2C_TIMEOUTR_TIMEOUTB_Pos)
#define I2C_TIMEOUTR_TIMEOUTB_11                                           (0x800U << I2C_TIMEOUTR_TIMEOUTB_Pos)
#define I2C_TIMEOUTR_TIMOUTEN_Pos                                          (15UL)		/*!<I2C TIMEOUTR: TIMOUTEN (Bit 15) */
#define I2C_TIMEOUTR_TIMOUTEN_Msk                                          (0x8000UL)		/*!< I2C TIMEOUTR: TIMOUTEN (Bitfield-Mask: 0x01) */
#define I2C_TIMEOUTR_TIMOUTEN                                              I2C_TIMEOUTR_TIMOUTEN_Msk
#define I2C_TIMEOUTR_TIDLE_Pos                                             (12UL)		/*!<I2C TIMEOUTR: TIDLE (Bit 12) */
#define I2C_TIMEOUTR_TIDLE_Msk                                             (0x1000UL)		/*!< I2C TIMEOUTR: TIDLE (Bitfield-Mask: 0x01) */
#define I2C_TIMEOUTR_TIDLE                                                 I2C_TIMEOUTR_TIDLE_Msk
#define I2C_TIMEOUTR_TIMEOUTA_Pos                                          (0UL)		/*!<I2C TIMEOUTR: TIMEOUTA (Bit 0) */
#define I2C_TIMEOUTR_TIMEOUTA_Msk                                          (0xfffUL)		/*!< I2C TIMEOUTR: TIMEOUTA (Bitfield-Mask: 0xfff) */
#define I2C_TIMEOUTR_TIMEOUTA                                              I2C_TIMEOUTR_TIMEOUTA_Msk
#define I2C_TIMEOUTR_TIMEOUTA_0                                            (0x1U << I2C_TIMEOUTR_TIMEOUTA_Pos)
#define I2C_TIMEOUTR_TIMEOUTA_1                                            (0x2U << I2C_TIMEOUTR_TIMEOUTA_Pos)
#define I2C_TIMEOUTR_TIMEOUTA_2                                            (0x4U << I2C_TIMEOUTR_TIMEOUTA_Pos)
#define I2C_TIMEOUTR_TIMEOUTA_3                                            (0x8U << I2C_TIMEOUTR_TIMEOUTA_Pos)
#define I2C_TIMEOUTR_TIMEOUTA_4                                            (0x10U << I2C_TIMEOUTR_TIMEOUTA_Pos)
#define I2C_TIMEOUTR_TIMEOUTA_5                                            (0x20U << I2C_TIMEOUTR_TIMEOUTA_Pos)
#define I2C_TIMEOUTR_TIMEOUTA_6                                            (0x40U << I2C_TIMEOUTR_TIMEOUTA_Pos)
#define I2C_TIMEOUTR_TIMEOUTA_7                                            (0x80U << I2C_TIMEOUTR_TIMEOUTA_Pos)
#define I2C_TIMEOUTR_TIMEOUTA_8                                            (0x100U << I2C_TIMEOUTR_TIMEOUTA_Pos)
#define I2C_TIMEOUTR_TIMEOUTA_9                                            (0x200U << I2C_TIMEOUTR_TIMEOUTA_Pos)
#define I2C_TIMEOUTR_TIMEOUTA_10                                           (0x400U << I2C_TIMEOUTR_TIMEOUTA_Pos)
#define I2C_TIMEOUTR_TIMEOUTA_11                                           (0x800U << I2C_TIMEOUTR_TIMEOUTA_Pos)

/* =====================================================    ISR    ===================================================== */ 
#define I2C_ISR_ADDCODE_Pos                                                (17UL)		/*!<I2C ISR: ADDCODE (Bit 17) */
#define I2C_ISR_ADDCODE_Msk                                                (0xfe0000UL)		/*!< I2C ISR: ADDCODE (Bitfield-Mask: 0x7f) */
#define I2C_ISR_ADDCODE                                                    I2C_ISR_ADDCODE_Msk
#define I2C_ISR_ADDCODE_0                                                  (0x1U << I2C_ISR_ADDCODE_Pos)
#define I2C_ISR_ADDCODE_1                                                  (0x2U << I2C_ISR_ADDCODE_Pos)
#define I2C_ISR_ADDCODE_2                                                  (0x4U << I2C_ISR_ADDCODE_Pos)
#define I2C_ISR_ADDCODE_3                                                  (0x8U << I2C_ISR_ADDCODE_Pos)
#define I2C_ISR_ADDCODE_4                                                  (0x10U << I2C_ISR_ADDCODE_Pos)
#define I2C_ISR_ADDCODE_5                                                  (0x20U << I2C_ISR_ADDCODE_Pos)
#define I2C_ISR_ADDCODE_6                                                  (0x40U << I2C_ISR_ADDCODE_Pos)
#define I2C_ISR_DIR_Pos                                                    (16UL)		/*!<I2C ISR: DIR (Bit 16) */
#define I2C_ISR_DIR_Msk                                                    (0x10000UL)		/*!< I2C ISR: DIR (Bitfield-Mask: 0x01) */
#define I2C_ISR_DIR                                                        I2C_ISR_DIR_Msk
#define I2C_ISR_BUSY_Pos                                                   (15UL)		/*!<I2C ISR: BUSY (Bit 15) */
#define I2C_ISR_BUSY_Msk                                                   (0x8000UL)		/*!< I2C ISR: BUSY (Bitfield-Mask: 0x01) */
#define I2C_ISR_BUSY                                                       I2C_ISR_BUSY_Msk
#define I2C_ISR_ALERT_Pos                                                  (13UL)		/*!<I2C ISR: ALERT (Bit 13) */
#define I2C_ISR_ALERT_Msk                                                  (0x2000UL)		/*!< I2C ISR: ALERT (Bitfield-Mask: 0x01) */
#define I2C_ISR_ALERT                                                      I2C_ISR_ALERT_Msk
#define I2C_ISR_TIMEOUT_Pos                                                (12UL)		/*!<I2C ISR: TIMEOUT (Bit 12) */
#define I2C_ISR_TIMEOUT_Msk                                                (0x1000UL)		/*!< I2C ISR: TIMEOUT (Bitfield-Mask: 0x01) */
#define I2C_ISR_TIMEOUT                                                    I2C_ISR_TIMEOUT_Msk
#define I2C_ISR_PECERR_Pos                                                 (11UL)		/*!<I2C ISR: PECERR (Bit 11) */
#define I2C_ISR_PECERR_Msk                                                 (0x800UL)		/*!< I2C ISR: PECERR (Bitfield-Mask: 0x01) */
#define I2C_ISR_PECERR                                                     I2C_ISR_PECERR_Msk
#define I2C_ISR_OVR_Pos                                                    (10UL)		/*!<I2C ISR: OVR (Bit 10) */
#define I2C_ISR_OVR_Msk                                                    (0x400UL)		/*!< I2C ISR: OVR (Bitfield-Mask: 0x01) */
#define I2C_ISR_OVR                                                        I2C_ISR_OVR_Msk
#define I2C_ISR_ARLO_Pos                                                   (9UL)		/*!<I2C ISR: ARLO (Bit 9) */
#define I2C_ISR_ARLO_Msk                                                   (0x200UL)		/*!< I2C ISR: ARLO (Bitfield-Mask: 0x01) */
#define I2C_ISR_ARLO                                                       I2C_ISR_ARLO_Msk
#define I2C_ISR_BERR_Pos                                                   (8UL)		/*!<I2C ISR: BERR (Bit 8) */
#define I2C_ISR_BERR_Msk                                                   (0x100UL)		/*!< I2C ISR: BERR (Bitfield-Mask: 0x01) */
#define I2C_ISR_BERR                                                       I2C_ISR_BERR_Msk
#define I2C_ISR_TCR_Pos                                                    (7UL)		/*!<I2C ISR: TCR (Bit 7) */
#define I2C_ISR_TCR_Msk                                                    (0x80UL)		/*!< I2C ISR: TCR (Bitfield-Mask: 0x01) */
#define I2C_ISR_TCR                                                        I2C_ISR_TCR_Msk
#define I2C_ISR_TC_Pos                                                     (6UL)		/*!<I2C ISR: TC (Bit 6) */
#define I2C_ISR_TC_Msk                                                     (0x40UL)		/*!< I2C ISR: TC (Bitfield-Mask: 0x01) */
#define I2C_ISR_TC                                                         I2C_ISR_TC_Msk
#define I2C_ISR_STOPF_Pos                                                  (5UL)		/*!<I2C ISR: STOPF (Bit 5) */
#define I2C_ISR_STOPF_Msk                                                  (0x20UL)		/*!< I2C ISR: STOPF (Bitfield-Mask: 0x01) */
#define I2C_ISR_STOPF                                                      I2C_ISR_STOPF_Msk
#define I2C_ISR_NACKF_Pos                                                  (4UL)		/*!<I2C ISR: NACKF (Bit 4) */
#define I2C_ISR_NACKF_Msk                                                  (0x10UL)		/*!< I2C ISR: NACKF (Bitfield-Mask: 0x01) */
#define I2C_ISR_NACKF                                                      I2C_ISR_NACKF_Msk
#define I2C_ISR_ADDR_Pos                                                   (3UL)		/*!<I2C ISR: ADDR (Bit 3) */
#define I2C_ISR_ADDR_Msk                                                   (0x8UL)		/*!< I2C ISR: ADDR (Bitfield-Mask: 0x01) */
#define I2C_ISR_ADDR                                                       I2C_ISR_ADDR_Msk
#define I2C_ISR_RXNE_Pos                                                   (2UL)		/*!<I2C ISR: RXNE (Bit 2) */
#define I2C_ISR_RXNE_Msk                                                   (0x4UL)		/*!< I2C ISR: RXNE (Bitfield-Mask: 0x01) */
#define I2C_ISR_RXNE                                                       I2C_ISR_RXNE_Msk
#define I2C_ISR_TXIS_Pos                                                   (1UL)		/*!<I2C ISR: TXIS (Bit 1) */
#define I2C_ISR_TXIS_Msk                                                   (0x2UL)		/*!< I2C ISR: TXIS (Bitfield-Mask: 0x01) */
#define I2C_ISR_TXIS                                                       I2C_ISR_TXIS_Msk
#define I2C_ISR_TXE_Pos                                                    (0UL)		/*!<I2C ISR: TXE (Bit 0) */
#define I2C_ISR_TXE_Msk                                                    (0x1UL)		/*!< I2C ISR: TXE (Bitfield-Mask: 0x01) */
#define I2C_ISR_TXE                                                        I2C_ISR_TXE_Msk

/* =====================================================    ICR    ===================================================== */ 
#define I2C_ICR_ALERTCF_Pos                                                (13UL)		/*!<I2C ICR: ALERTCF (Bit 13) */
#define I2C_ICR_ALERTCF_Msk                                                (0x2000UL)		/*!< I2C ICR: ALERTCF (Bitfield-Mask: 0x01) */
#define I2C_ICR_ALERTCF                                                    I2C_ICR_ALERTCF_Msk
#define I2C_ICR_TIMOUTCF_Pos                                               (12UL)		/*!<I2C ICR: TIMOUTCF (Bit 12) */
#define I2C_ICR_TIMOUTCF_Msk                                               (0x1000UL)		/*!< I2C ICR: TIMOUTCF (Bitfield-Mask: 0x01) */
#define I2C_ICR_TIMOUTCF                                                   I2C_ICR_TIMOUTCF_Msk
#define I2C_ICR_PECCF_Pos                                                  (11UL)		/*!<I2C ICR: PECCF (Bit 11) */
#define I2C_ICR_PECCF_Msk                                                  (0x800UL)		/*!< I2C ICR: PECCF (Bitfield-Mask: 0x01) */
#define I2C_ICR_PECCF                                                      I2C_ICR_PECCF_Msk
#define I2C_ICR_OVRCF_Pos                                                  (10UL)		/*!<I2C ICR: OVRCF (Bit 10) */
#define I2C_ICR_OVRCF_Msk                                                  (0x400UL)		/*!< I2C ICR: OVRCF (Bitfield-Mask: 0x01) */
#define I2C_ICR_OVRCF                                                      I2C_ICR_OVRCF_Msk
#define I2C_ICR_ARLOCF_Pos                                                 (9UL)		/*!<I2C ICR: ARLOCF (Bit 9) */
#define I2C_ICR_ARLOCF_Msk                                                 (0x200UL)		/*!< I2C ICR: ARLOCF (Bitfield-Mask: 0x01) */
#define I2C_ICR_ARLOCF                                                     I2C_ICR_ARLOCF_Msk
#define I2C_ICR_BERRCF_Pos                                                 (8UL)		/*!<I2C ICR: BERRCF (Bit 8) */
#define I2C_ICR_BERRCF_Msk                                                 (0x100UL)		/*!< I2C ICR: BERRCF (Bitfield-Mask: 0x01) */
#define I2C_ICR_BERRCF                                                     I2C_ICR_BERRCF_Msk
#define I2C_ICR_STOPCF_Pos                                                 (5UL)		/*!<I2C ICR: STOPCF (Bit 5) */
#define I2C_ICR_STOPCF_Msk                                                 (0x20UL)		/*!< I2C ICR: STOPCF (Bitfield-Mask: 0x01) */
#define I2C_ICR_STOPCF                                                     I2C_ICR_STOPCF_Msk
#define I2C_ICR_NACKCF_Pos                                                 (4UL)		/*!<I2C ICR: NACKCF (Bit 4) */
#define I2C_ICR_NACKCF_Msk                                                 (0x10UL)		/*!< I2C ICR: NACKCF (Bitfield-Mask: 0x01) */
#define I2C_ICR_NACKCF                                                     I2C_ICR_NACKCF_Msk
#define I2C_ICR_ADDRCF_Pos                                                 (3UL)		/*!<I2C ICR: ADDRCF (Bit 3) */
#define I2C_ICR_ADDRCF_Msk                                                 (0x8UL)		/*!< I2C ICR: ADDRCF (Bitfield-Mask: 0x01) */
#define I2C_ICR_ADDRCF                                                     I2C_ICR_ADDRCF_Msk

/* =====================================================    PECR    ===================================================== */ 
#define I2C_PECR_PEC_Pos                                                   (0UL)		/*!<I2C PECR: PEC (Bit 0) */
#define I2C_PECR_PEC_Msk                                                   (0xffUL)		/*!< I2C PECR: PEC (Bitfield-Mask: 0xff) */
#define I2C_PECR_PEC                                                       I2C_PECR_PEC_Msk
#define I2C_PECR_PEC_0                                                     (0x1U << I2C_PECR_PEC_Pos)
#define I2C_PECR_PEC_1                                                     (0x2U << I2C_PECR_PEC_Pos)
#define I2C_PECR_PEC_2                                                     (0x4U << I2C_PECR_PEC_Pos)
#define I2C_PECR_PEC_3                                                     (0x8U << I2C_PECR_PEC_Pos)
#define I2C_PECR_PEC_4                                                     (0x10U << I2C_PECR_PEC_Pos)
#define I2C_PECR_PEC_5                                                     (0x20U << I2C_PECR_PEC_Pos)
#define I2C_PECR_PEC_6                                                     (0x40U << I2C_PECR_PEC_Pos)
#define I2C_PECR_PEC_7                                                     (0x80U << I2C_PECR_PEC_Pos)

/* =====================================================    RXDR    ===================================================== */ 
#define I2C_RXDR_RXDATA_Pos                                                (0UL)		/*!<I2C RXDR: RXDATA (Bit 0) */
#define I2C_RXDR_RXDATA_Msk                                                (0xffUL)		/*!< I2C RXDR: RXDATA (Bitfield-Mask: 0xff) */
#define I2C_RXDR_RXDATA                                                    I2C_RXDR_RXDATA_Msk
#define I2C_RXDR_RXDATA_0                                                  (0x1U << I2C_RXDR_RXDATA_Pos)
#define I2C_RXDR_RXDATA_1                                                  (0x2U << I2C_RXDR_RXDATA_Pos)
#define I2C_RXDR_RXDATA_2                                                  (0x4U << I2C_RXDR_RXDATA_Pos)
#define I2C_RXDR_RXDATA_3                                                  (0x8U << I2C_RXDR_RXDATA_Pos)
#define I2C_RXDR_RXDATA_4                                                  (0x10U << I2C_RXDR_RXDATA_Pos)
#define I2C_RXDR_RXDATA_5                                                  (0x20U << I2C_RXDR_RXDATA_Pos)
#define I2C_RXDR_RXDATA_6                                                  (0x40U << I2C_RXDR_RXDATA_Pos)
#define I2C_RXDR_RXDATA_7                                                  (0x80U << I2C_RXDR_RXDATA_Pos)

/* =====================================================    TXDR    ===================================================== */ 
#define I2C_TXDR_TXDATA_Pos                                                (0UL)		/*!<I2C TXDR: TXDATA (Bit 0) */
#define I2C_TXDR_TXDATA_Msk                                                (0xffUL)		/*!< I2C TXDR: TXDATA (Bitfield-Mask: 0xff) */
#define I2C_TXDR_TXDATA                                                    I2C_TXDR_TXDATA_Msk
#define I2C_TXDR_TXDATA_0                                                  (0x1U << I2C_TXDR_TXDATA_Pos)
#define I2C_TXDR_TXDATA_1                                                  (0x2U << I2C_TXDR_TXDATA_Pos)
#define I2C_TXDR_TXDATA_2                                                  (0x4U << I2C_TXDR_TXDATA_Pos)
#define I2C_TXDR_TXDATA_3                                                  (0x8U << I2C_TXDR_TXDATA_Pos)
#define I2C_TXDR_TXDATA_4                                                  (0x10U << I2C_TXDR_TXDATA_Pos)
#define I2C_TXDR_TXDATA_5                                                  (0x20U << I2C_TXDR_TXDATA_Pos)
#define I2C_TXDR_TXDATA_6                                                  (0x40U << I2C_TXDR_TXDATA_Pos)
#define I2C_TXDR_TXDATA_7                                                  (0x80U << I2C_TXDR_TXDATA_Pos)


/* =========================================================================================================================== */ 
/*=====================                                      FLASH                                      ===================== */ 
/* =========================================================================================================================== */ 

/* =====================================================    COMMAND    ===================================================== */ 
#define FLASH_COMMAND_COMMAND_Pos                                          (0UL)		/*!<FLASH COMMAND: COMMAND (Bit 0) */
#define FLASH_COMMAND_COMMAND_Msk                                          (0xffUL)		/*!< FLASH COMMAND: COMMAND (Bitfield-Mask: 0xff) */
#define FLASH_COMMAND_COMMAND                                              FLASH_COMMAND_COMMAND_Msk
#define FLASH_COMMAND_COMMAND_0                                            (0x1U << FLASH_COMMAND_COMMAND_Pos)
#define FLASH_COMMAND_COMMAND_1                                            (0x2U << FLASH_COMMAND_COMMAND_Pos)
#define FLASH_COMMAND_COMMAND_2                                            (0x4U << FLASH_COMMAND_COMMAND_Pos)
#define FLASH_COMMAND_COMMAND_3                                            (0x8U << FLASH_COMMAND_COMMAND_Pos)
#define FLASH_COMMAND_COMMAND_4                                            (0x10U << FLASH_COMMAND_COMMAND_Pos)
#define FLASH_COMMAND_COMMAND_5                                            (0x20U << FLASH_COMMAND_COMMAND_Pos)
#define FLASH_COMMAND_COMMAND_6                                            (0x40U << FLASH_COMMAND_COMMAND_Pos)
#define FLASH_COMMAND_COMMAND_7                                            (0x80U << FLASH_COMMAND_COMMAND_Pos)

/* =====================================================    CONFIG    ===================================================== */ 
#define FLASH_CONFIG_WAIT_STATES_Pos                                       (4UL)		/*!<FLASH CONFIG: WAIT_STATES (Bit 4) */
#define FLASH_CONFIG_WAIT_STATES_Msk                                       (0x30UL)		/*!< FLASH CONFIG: WAIT_STATES (Bitfield-Mask: 0x03) */
#define FLASH_CONFIG_WAIT_STATES                                           FLASH_CONFIG_WAIT_STATES_Msk
#define FLASH_CONFIG_WAIT_STATES_0                                         (0x1U << FLASH_CONFIG_WAIT_STATES_Pos)
#define FLASH_CONFIG_WAIT_STATES_1                                         (0x2U << FLASH_CONFIG_WAIT_STATES_Pos)
#define FLASH_CONFIG_PREMAP_Pos                                            (3UL)		/*!<FLASH CONFIG: PREMAP (Bit 3) */
#define FLASH_CONFIG_PREMAP_Msk                                            (0x8UL)		/*!< FLASH CONFIG: PREMAP (Bitfield-Mask: 0x01) */
#define FLASH_CONFIG_PREMAP                                                FLASH_CONFIG_PREMAP_Msk
#define FLASH_CONFIG_DIS_GROUP_WRITE_Pos                                   (2UL)		/*!<FLASH CONFIG: DIS_GROUP_WRITE (Bit 2) */
#define FLASH_CONFIG_DIS_GROUP_WRITE_Msk                                   (0x4UL)		/*!< FLASH CONFIG: DIS_GROUP_WRITE (Bitfield-Mask: 0x01) */
#define FLASH_CONFIG_DIS_GROUP_WRITE                                       FLASH_CONFIG_DIS_GROUP_WRITE_Msk
#define FLASH_CONFIG_REMAP_Pos                                             (1UL)		/*!<FLASH CONFIG: REMAP (Bit 1) */
#define FLASH_CONFIG_REMAP_Msk                                             (0x2UL)		/*!< FLASH CONFIG: REMAP (Bitfield-Mask: 0x01) */
#define FLASH_CONFIG_REMAP                                                 FLASH_CONFIG_REMAP_Msk

/* =====================================================    IRQSTAT    ===================================================== */ 
#define FLASH_IRQSTAT_READOK_MIS_Pos                                       (4UL)		/*!<FLASH IRQSTAT: READOK_MIS (Bit 4) */
#define FLASH_IRQSTAT_READOK_MIS_Msk                                       (0x10UL)		/*!< FLASH IRQSTAT: READOK_MIS (Bitfield-Mask: 0x01) */
#define FLASH_IRQSTAT_READOK_MIS                                           FLASH_IRQSTAT_READOK_MIS_Msk
#define FLASH_IRQSTAT_ILLCMD_MIS_Pos                                       (3UL)		/*!<FLASH IRQSTAT: ILLCMD_MIS (Bit 3) */
#define FLASH_IRQSTAT_ILLCMD_MIS_Msk                                       (0x8UL)		/*!< FLASH IRQSTAT: ILLCMD_MIS (Bitfield-Mask: 0x01) */
#define FLASH_IRQSTAT_ILLCMD_MIS                                           FLASH_IRQSTAT_ILLCMD_MIS_Msk
#define FLASH_IRQSTAT_CMDERR_MIS_Pos                                       (2UL)		/*!<FLASH IRQSTAT: CMDERR_MIS (Bit 2) */
#define FLASH_IRQSTAT_CMDERR_MIS_Msk                                       (0x4UL)		/*!< FLASH IRQSTAT: CMDERR_MIS (Bitfield-Mask: 0x01) */
#define FLASH_IRQSTAT_CMDERR_MIS                                           FLASH_IRQSTAT_CMDERR_MIS_Msk
#define FLASH_IRQSTAT_CMDSTART_MIS_Pos                                     (1UL)		/*!<FLASH IRQSTAT: CMDSTART_MIS (Bit 1) */
#define FLASH_IRQSTAT_CMDSTART_MIS_Msk                                     (0x2UL)		/*!< FLASH IRQSTAT: CMDSTART_MIS (Bitfield-Mask: 0x01) */
#define FLASH_IRQSTAT_CMDSTART_MIS                                         FLASH_IRQSTAT_CMDSTART_MIS_Msk
#define FLASH_IRQSTAT_CMDDONE_MIS_Pos                                      (0UL)		/*!<FLASH IRQSTAT: CMDDONE_MIS (Bit 0) */
#define FLASH_IRQSTAT_CMDDONE_MIS_Msk                                      (0x1UL)		/*!< FLASH IRQSTAT: CMDDONE_MIS (Bitfield-Mask: 0x01) */
#define FLASH_IRQSTAT_CMDDONE_MIS                                          FLASH_IRQSTAT_CMDDONE_MIS_Msk

/* =====================================================    IRQMASK    ===================================================== */ 
#define FLASH_IRQMASK_READOKM_Pos                                          (4UL)		/*!<FLASH IRQMASK: READOKM (Bit 4) */
#define FLASH_IRQMASK_READOKM_Msk                                          (0x10UL)		/*!< FLASH IRQMASK: READOKM (Bitfield-Mask: 0x01) */
#define FLASH_IRQMASK_READOKM                                              FLASH_IRQMASK_READOKM_Msk
#define FLASH_IRQMASK_ILLCMDM_Pos                                          (3UL)		/*!<FLASH IRQMASK: ILLCMDM (Bit 3) */
#define FLASH_IRQMASK_ILLCMDM_Msk                                          (0x8UL)		/*!< FLASH IRQMASK: ILLCMDM (Bitfield-Mask: 0x01) */
#define FLASH_IRQMASK_ILLCMDM                                              FLASH_IRQMASK_ILLCMDM_Msk
#define FLASH_IRQMASK_CMDERRM_Pos                                          (2UL)		/*!<FLASH IRQMASK: CMDERRM (Bit 2) */
#define FLASH_IRQMASK_CMDERRM_Msk                                          (0x4UL)		/*!< FLASH IRQMASK: CMDERRM (Bitfield-Mask: 0x01) */
#define FLASH_IRQMASK_CMDERRM                                              FLASH_IRQMASK_CMDERRM_Msk
#define FLASH_IRQMASK_CMDSTARTM_Pos                                        (1UL)		/*!<FLASH IRQMASK: CMDSTARTM (Bit 1) */
#define FLASH_IRQMASK_CMDSTARTM_Msk                                        (0x2UL)		/*!< FLASH IRQMASK: CMDSTARTM (Bitfield-Mask: 0x01) */
#define FLASH_IRQMASK_CMDSTARTM                                            FLASH_IRQMASK_CMDSTARTM_Msk
#define FLASH_IRQMASK_CMDDONEM_Pos                                         (0UL)		/*!<FLASH IRQMASK: CMDDONEM (Bit 0) */
#define FLASH_IRQMASK_CMDDONEM_Msk                                         (0x1UL)		/*!< FLASH IRQMASK: CMDDONEM (Bitfield-Mask: 0x01) */
#define FLASH_IRQMASK_CMDDONEM                                             FLASH_IRQMASK_CMDDONEM_Msk

/* =====================================================    IRQRAW    ===================================================== */ 
#define FLASH_IRQRAW_READOK_RIS_Pos                                        (4UL)		/*!<FLASH IRQRAW: READOK_RIS (Bit 4) */
#define FLASH_IRQRAW_READOK_RIS_Msk                                        (0x10UL)		/*!< FLASH IRQRAW: READOK_RIS (Bitfield-Mask: 0x01) */
#define FLASH_IRQRAW_READOK_RIS                                            FLASH_IRQRAW_READOK_RIS_Msk
#define FLASH_IRQRAW_ILLCMD_RIS_Pos                                        (3UL)		/*!<FLASH IRQRAW: ILLCMD_RIS (Bit 3) */
#define FLASH_IRQRAW_ILLCMD_RIS_Msk                                        (0x8UL)		/*!< FLASH IRQRAW: ILLCMD_RIS (Bitfield-Mask: 0x01) */
#define FLASH_IRQRAW_ILLCMD_RIS                                            FLASH_IRQRAW_ILLCMD_RIS_Msk
#define FLASH_IRQRAW_CMDERR_RIS_Pos                                        (2UL)		/*!<FLASH IRQRAW: CMDERR_RIS (Bit 2) */
#define FLASH_IRQRAW_CMDERR_RIS_Msk                                        (0x4UL)		/*!< FLASH IRQRAW: CMDERR_RIS (Bitfield-Mask: 0x01) */
#define FLASH_IRQRAW_CMDERR_RIS                                            FLASH_IRQRAW_CMDERR_RIS_Msk
#define FLASH_IRQRAW_CMDSTART_RIS_Pos                                      (1UL)		/*!<FLASH IRQRAW: CMDSTART_RIS (Bit 1) */
#define FLASH_IRQRAW_CMDSTART_RIS_Msk                                      (0x2UL)		/*!< FLASH IRQRAW: CMDSTART_RIS (Bitfield-Mask: 0x01) */
#define FLASH_IRQRAW_CMDSTART_RIS                                          FLASH_IRQRAW_CMDSTART_RIS_Msk
#define FLASH_IRQRAW_CMDDONE_RIS_Pos                                       (0UL)		/*!<FLASH IRQRAW: CMDDONE_RIS (Bit 0) */
#define FLASH_IRQRAW_CMDDONE_RIS_Msk                                       (0x1UL)		/*!< FLASH IRQRAW: CMDDONE_RIS (Bitfield-Mask: 0x01) */
#define FLASH_IRQRAW_CMDDONE_RIS                                           FLASH_IRQRAW_CMDDONE_RIS_Msk

/* =====================================================    FLASH_SIZE    ===================================================== */ 
#define FLASH_FLASH_SIZE_SWD_DISABLE_Pos                                   (20UL)		/*!<FLASH FLASH_SIZE: SWD_DISABLE (Bit 20) */
#define FLASH_FLASH_SIZE_SWD_DISABLE_Msk                                   (0x100000UL)		/*!< FLASH FLASH_SIZE: SWD_DISABLE (Bitfield-Mask: 0x01) */
#define FLASH_FLASH_SIZE_SWD_DISABLE                                       FLASH_FLASH_SIZE_SWD_DISABLE_Msk
#define FLASH_FLASH_SIZE_FLASH_SECURE_Pos                                  (19UL)		/*!<FLASH FLASH_SIZE: FLASH_SECURE (Bit 19) */
#define FLASH_FLASH_SIZE_FLASH_SECURE_Msk                                  (0x80000UL)		/*!< FLASH FLASH_SIZE: FLASH_SECURE (Bitfield-Mask: 0x01) */
#define FLASH_FLASH_SIZE_FLASH_SECURE                                      FLASH_FLASH_SIZE_FLASH_SECURE_Msk
#define FLASH_FLASH_SIZE_RAM_SIZE_Pos                                      (17UL)		/*!<FLASH FLASH_SIZE: RAM_SIZE (Bit 17) */
#define FLASH_FLASH_SIZE_RAM_SIZE_Msk                                      (0x60000UL)		/*!< FLASH FLASH_SIZE: RAM_SIZE (Bitfield-Mask: 0x03) */
#define FLASH_FLASH_SIZE_RAM_SIZE                                          FLASH_FLASH_SIZE_RAM_SIZE_Msk
#define FLASH_FLASH_SIZE_RAM_SIZE_0                                        (0x1U << FLASH_FLASH_SIZE_RAM_SIZE_Pos)
#define FLASH_FLASH_SIZE_RAM_SIZE_1                                        (0x2U << FLASH_FLASH_SIZE_RAM_SIZE_Pos)
#define FLASH_FLASH_SIZE_FLASH_SIZE_Pos                                    (0UL)		/*!<FLASH FLASH_SIZE: FLASH_SIZE (Bit 0) */
#define FLASH_FLASH_SIZE_FLASH_SIZE_Msk                                    (0xffffUL)		/*!< FLASH FLASH_SIZE: FLASH_SIZE (Bitfield-Mask: 0xffff) */
#define FLASH_FLASH_SIZE_FLASH_SIZE                                        FLASH_FLASH_SIZE_FLASH_SIZE_Msk
#define FLASH_FLASH_SIZE_FLASH_SIZE_0                                      (0x1U << FLASH_FLASH_SIZE_FLASH_SIZE_Pos)
#define FLASH_FLASH_SIZE_FLASH_SIZE_1                                      (0x2U << FLASH_FLASH_SIZE_FLASH_SIZE_Pos)
#define FLASH_FLASH_SIZE_FLASH_SIZE_2                                      (0x4U << FLASH_FLASH_SIZE_FLASH_SIZE_Pos)
#define FLASH_FLASH_SIZE_FLASH_SIZE_3                                      (0x8U << FLASH_FLASH_SIZE_FLASH_SIZE_Pos)
#define FLASH_FLASH_SIZE_FLASH_SIZE_4                                      (0x10U << FLASH_FLASH_SIZE_FLASH_SIZE_Pos)
#define FLASH_FLASH_SIZE_FLASH_SIZE_5                                      (0x20U << FLASH_FLASH_SIZE_FLASH_SIZE_Pos)
#define FLASH_FLASH_SIZE_FLASH_SIZE_6                                      (0x40U << FLASH_FLASH_SIZE_FLASH_SIZE_Pos)
#define FLASH_FLASH_SIZE_FLASH_SIZE_7                                      (0x80U << FLASH_FLASH_SIZE_FLASH_SIZE_Pos)
#define FLASH_FLASH_SIZE_FLASH_SIZE_8                                      (0x100U << FLASH_FLASH_SIZE_FLASH_SIZE_Pos)
#define FLASH_FLASH_SIZE_FLASH_SIZE_9                                      (0x200U << FLASH_FLASH_SIZE_FLASH_SIZE_Pos)
#define FLASH_FLASH_SIZE_FLASH_SIZE_10                                     (0x400U << FLASH_FLASH_SIZE_FLASH_SIZE_Pos)
#define FLASH_FLASH_SIZE_FLASH_SIZE_11                                     (0x800U << FLASH_FLASH_SIZE_FLASH_SIZE_Pos)
#define FLASH_FLASH_SIZE_FLASH_SIZE_12                                     (0x1000U << FLASH_FLASH_SIZE_FLASH_SIZE_Pos)
#define FLASH_FLASH_SIZE_FLASH_SIZE_13                                     (0x2000U << FLASH_FLASH_SIZE_FLASH_SIZE_Pos)
#define FLASH_FLASH_SIZE_FLASH_SIZE_14                                     (0x4000U << FLASH_FLASH_SIZE_FLASH_SIZE_Pos)
#define FLASH_FLASH_SIZE_FLASH_SIZE_15                                     (0x8000U << FLASH_FLASH_SIZE_FLASH_SIZE_Pos)

/* =====================================================    ADDRESS    ===================================================== */ 
#define FLASH_ADDRESS_XADDR_Pos                                            (6UL)		/*!<FLASH ADDRESS: XADDR (Bit 6) */
#define FLASH_ADDRESS_XADDR_Msk                                            (0xffc0UL)		/*!< FLASH ADDRESS: XADDR (Bitfield-Mask: 0x3ff) */
#define FLASH_ADDRESS_XADDR                                                FLASH_ADDRESS_XADDR_Msk
#define FLASH_ADDRESS_XADDR_0                                              (0x1U << FLASH_ADDRESS_XADDR_Pos)
#define FLASH_ADDRESS_XADDR_1                                              (0x2U << FLASH_ADDRESS_XADDR_Pos)
#define FLASH_ADDRESS_XADDR_2                                              (0x4U << FLASH_ADDRESS_XADDR_Pos)
#define FLASH_ADDRESS_XADDR_3                                              (0x8U << FLASH_ADDRESS_XADDR_Pos)
#define FLASH_ADDRESS_XADDR_4                                              (0x10U << FLASH_ADDRESS_XADDR_Pos)
#define FLASH_ADDRESS_XADDR_5                                              (0x20U << FLASH_ADDRESS_XADDR_Pos)
#define FLASH_ADDRESS_XADDR_6                                              (0x40U << FLASH_ADDRESS_XADDR_Pos)
#define FLASH_ADDRESS_XADDR_7                                              (0x80U << FLASH_ADDRESS_XADDR_Pos)
#define FLASH_ADDRESS_XADDR_8                                              (0x100U << FLASH_ADDRESS_XADDR_Pos)
#define FLASH_ADDRESS_XADDR_9                                              (0x200U << FLASH_ADDRESS_XADDR_Pos)
#define FLASH_ADDRESS_YADDR_Pos                                            (0UL)		/*!<FLASH ADDRESS: YADDR (Bit 0) */
#define FLASH_ADDRESS_YADDR_Msk                                            (0x3fUL)		/*!< FLASH ADDRESS: YADDR (Bitfield-Mask: 0x3f) */
#define FLASH_ADDRESS_YADDR                                                FLASH_ADDRESS_YADDR_Msk
#define FLASH_ADDRESS_YADDR_0                                              (0x1U << FLASH_ADDRESS_YADDR_Pos)
#define FLASH_ADDRESS_YADDR_1                                              (0x2U << FLASH_ADDRESS_YADDR_Pos)
#define FLASH_ADDRESS_YADDR_2                                              (0x4U << FLASH_ADDRESS_YADDR_Pos)
#define FLASH_ADDRESS_YADDR_3                                              (0x8U << FLASH_ADDRESS_YADDR_Pos)
#define FLASH_ADDRESS_YADDR_4                                              (0x10U << FLASH_ADDRESS_YADDR_Pos)
#define FLASH_ADDRESS_YADDR_5                                              (0x20U << FLASH_ADDRESS_YADDR_Pos)

/* =====================================================    TIMETRIM1    ===================================================== */ 
#define FLASH_TIMETRIM1_T_RCV_Pos                                          (24UL)		/*!<FLASH TIMETRIM1: T_RCV (Bit 24) */
#define FLASH_TIMETRIM1_T_RCV_Msk                                          (0xff000000UL)		/*!< FLASH TIMETRIM1: T_RCV (Bitfield-Mask: 0xff) */
#define FLASH_TIMETRIM1_T_RCV                                              FLASH_TIMETRIM1_T_RCV_Msk
#define FLASH_TIMETRIM1_T_RCV_0                                            (0x1U << FLASH_TIMETRIM1_T_RCV_Pos)
#define FLASH_TIMETRIM1_T_RCV_1                                            (0x2U << FLASH_TIMETRIM1_T_RCV_Pos)
#define FLASH_TIMETRIM1_T_RCV_2                                            (0x4U << FLASH_TIMETRIM1_T_RCV_Pos)
#define FLASH_TIMETRIM1_T_RCV_3                                            (0x8U << FLASH_TIMETRIM1_T_RCV_Pos)
#define FLASH_TIMETRIM1_T_RCV_4                                            (0x10U << FLASH_TIMETRIM1_T_RCV_Pos)
#define FLASH_TIMETRIM1_T_RCV_5                                            (0x20U << FLASH_TIMETRIM1_T_RCV_Pos)
#define FLASH_TIMETRIM1_T_RCV_6                                            (0x40U << FLASH_TIMETRIM1_T_RCV_Pos)
#define FLASH_TIMETRIM1_T_RCV_7                                            (0x80U << FLASH_TIMETRIM1_T_RCV_Pos)
#define FLASH_TIMETRIM1_T_NVH_Pos                                          (16UL)		/*!<FLASH TIMETRIM1: T_NVH (Bit 16) */
#define FLASH_TIMETRIM1_T_NVH_Msk                                          (0xff0000UL)		/*!< FLASH TIMETRIM1: T_NVH (Bitfield-Mask: 0xff) */
#define FLASH_TIMETRIM1_T_NVH                                              FLASH_TIMETRIM1_T_NVH_Msk
#define FLASH_TIMETRIM1_T_NVH_0                                            (0x1U << FLASH_TIMETRIM1_T_NVH_Pos)
#define FLASH_TIMETRIM1_T_NVH_1                                            (0x2U << FLASH_TIMETRIM1_T_NVH_Pos)
#define FLASH_TIMETRIM1_T_NVH_2                                            (0x4U << FLASH_TIMETRIM1_T_NVH_Pos)
#define FLASH_TIMETRIM1_T_NVH_3                                            (0x8U << FLASH_TIMETRIM1_T_NVH_Pos)
#define FLASH_TIMETRIM1_T_NVH_4                                            (0x10U << FLASH_TIMETRIM1_T_NVH_Pos)
#define FLASH_TIMETRIM1_T_NVH_5                                            (0x20U << FLASH_TIMETRIM1_T_NVH_Pos)
#define FLASH_TIMETRIM1_T_NVH_6                                            (0x40U << FLASH_TIMETRIM1_T_NVH_Pos)
#define FLASH_TIMETRIM1_T_NVH_7                                            (0x80U << FLASH_TIMETRIM1_T_NVH_Pos)
#define FLASH_TIMETRIM1_T_ME_Pos                                           (8UL)		/*!<FLASH TIMETRIM1: T_ME (Bit 8) */
#define FLASH_TIMETRIM1_T_ME_Msk                                           (0xff00UL)		/*!< FLASH TIMETRIM1: T_ME (Bitfield-Mask: 0xff) */
#define FLASH_TIMETRIM1_T_ME                                               FLASH_TIMETRIM1_T_ME_Msk
#define FLASH_TIMETRIM1_T_ME_0                                             (0x1U << FLASH_TIMETRIM1_T_ME_Pos)
#define FLASH_TIMETRIM1_T_ME_1                                             (0x2U << FLASH_TIMETRIM1_T_ME_Pos)
#define FLASH_TIMETRIM1_T_ME_2                                             (0x4U << FLASH_TIMETRIM1_T_ME_Pos)
#define FLASH_TIMETRIM1_T_ME_3                                             (0x8U << FLASH_TIMETRIM1_T_ME_Pos)
#define FLASH_TIMETRIM1_T_ME_4                                             (0x10U << FLASH_TIMETRIM1_T_ME_Pos)
#define FLASH_TIMETRIM1_T_ME_5                                             (0x20U << FLASH_TIMETRIM1_T_ME_Pos)
#define FLASH_TIMETRIM1_T_ME_6                                             (0x40U << FLASH_TIMETRIM1_T_ME_Pos)
#define FLASH_TIMETRIM1_T_ME_7                                             (0x80U << FLASH_TIMETRIM1_T_ME_Pos)
#define FLASH_TIMETRIM1_T_ERASE_Pos                                        (0UL)		/*!<FLASH TIMETRIM1: T_ERASE (Bit 0) */
#define FLASH_TIMETRIM1_T_ERASE_Msk                                        (0xffUL)		/*!< FLASH TIMETRIM1: T_ERASE (Bitfield-Mask: 0xff) */
#define FLASH_TIMETRIM1_T_ERASE                                            FLASH_TIMETRIM1_T_ERASE_Msk
#define FLASH_TIMETRIM1_T_ERASE_0                                          (0x1U << FLASH_TIMETRIM1_T_ERASE_Pos)
#define FLASH_TIMETRIM1_T_ERASE_1                                          (0x2U << FLASH_TIMETRIM1_T_ERASE_Pos)
#define FLASH_TIMETRIM1_T_ERASE_2                                          (0x4U << FLASH_TIMETRIM1_T_ERASE_Pos)
#define FLASH_TIMETRIM1_T_ERASE_3                                          (0x8U << FLASH_TIMETRIM1_T_ERASE_Pos)
#define FLASH_TIMETRIM1_T_ERASE_4                                          (0x10U << FLASH_TIMETRIM1_T_ERASE_Pos)
#define FLASH_TIMETRIM1_T_ERASE_5                                          (0x20U << FLASH_TIMETRIM1_T_ERASE_Pos)
#define FLASH_TIMETRIM1_T_ERASE_6                                          (0x40U << FLASH_TIMETRIM1_T_ERASE_Pos)
#define FLASH_TIMETRIM1_T_ERASE_7                                          (0x80U << FLASH_TIMETRIM1_T_ERASE_Pos)

/* =====================================================    TIMETRIM2    ===================================================== */ 
#define FLASH_TIMETRIM2_T_PGS_Pos                                          (24UL)		/*!<FLASH TIMETRIM2: T_PGS (Bit 24) */
#define FLASH_TIMETRIM2_T_PGS_Msk                                          (0xff000000UL)		/*!< FLASH TIMETRIM2: T_PGS (Bitfield-Mask: 0xff) */
#define FLASH_TIMETRIM2_T_PGS                                              FLASH_TIMETRIM2_T_PGS_Msk
#define FLASH_TIMETRIM2_T_PGS_0                                            (0x1U << FLASH_TIMETRIM2_T_PGS_Pos)
#define FLASH_TIMETRIM2_T_PGS_1                                            (0x2U << FLASH_TIMETRIM2_T_PGS_Pos)
#define FLASH_TIMETRIM2_T_PGS_2                                            (0x4U << FLASH_TIMETRIM2_T_PGS_Pos)
#define FLASH_TIMETRIM2_T_PGS_3                                            (0x8U << FLASH_TIMETRIM2_T_PGS_Pos)
#define FLASH_TIMETRIM2_T_PGS_4                                            (0x10U << FLASH_TIMETRIM2_T_PGS_Pos)
#define FLASH_TIMETRIM2_T_PGS_5                                            (0x20U << FLASH_TIMETRIM2_T_PGS_Pos)
#define FLASH_TIMETRIM2_T_PGS_6                                            (0x40U << FLASH_TIMETRIM2_T_PGS_Pos)
#define FLASH_TIMETRIM2_T_PGS_7                                            (0x80U << FLASH_TIMETRIM2_T_PGS_Pos)
#define FLASH_TIMETRIM2_T_PROG_Pos                                         (16UL)		/*!<FLASH TIMETRIM2: T_PROG (Bit 16) */
#define FLASH_TIMETRIM2_T_PROG_Msk                                         (0xff0000UL)		/*!< FLASH TIMETRIM2: T_PROG (Bitfield-Mask: 0xff) */
#define FLASH_TIMETRIM2_T_PROG                                             FLASH_TIMETRIM2_T_PROG_Msk
#define FLASH_TIMETRIM2_T_PROG_0                                           (0x1U << FLASH_TIMETRIM2_T_PROG_Pos)
#define FLASH_TIMETRIM2_T_PROG_1                                           (0x2U << FLASH_TIMETRIM2_T_PROG_Pos)
#define FLASH_TIMETRIM2_T_PROG_2                                           (0x4U << FLASH_TIMETRIM2_T_PROG_Pos)
#define FLASH_TIMETRIM2_T_PROG_3                                           (0x8U << FLASH_TIMETRIM2_T_PROG_Pos)
#define FLASH_TIMETRIM2_T_PROG_4                                           (0x10U << FLASH_TIMETRIM2_T_PROG_Pos)
#define FLASH_TIMETRIM2_T_PROG_5                                           (0x20U << FLASH_TIMETRIM2_T_PROG_Pos)
#define FLASH_TIMETRIM2_T_PROG_6                                           (0x40U << FLASH_TIMETRIM2_T_PROG_Pos)
#define FLASH_TIMETRIM2_T_PROG_7                                           (0x80U << FLASH_TIMETRIM2_T_PROG_Pos)
#define FLASH_TIMETRIM2_T_NVH1_Pos                                         (8UL)		/*!<FLASH TIMETRIM2: T_NVH1 (Bit 8) */
#define FLASH_TIMETRIM2_T_NVH1_Msk                                         (0xff00UL)		/*!< FLASH TIMETRIM2: T_NVH1 (Bitfield-Mask: 0xff) */
#define FLASH_TIMETRIM2_T_NVH1                                             FLASH_TIMETRIM2_T_NVH1_Msk
#define FLASH_TIMETRIM2_T_NVH1_0                                           (0x1U << FLASH_TIMETRIM2_T_NVH1_Pos)
#define FLASH_TIMETRIM2_T_NVH1_1                                           (0x2U << FLASH_TIMETRIM2_T_NVH1_Pos)
#define FLASH_TIMETRIM2_T_NVH1_2                                           (0x4U << FLASH_TIMETRIM2_T_NVH1_Pos)
#define FLASH_TIMETRIM2_T_NVH1_3                                           (0x8U << FLASH_TIMETRIM2_T_NVH1_Pos)
#define FLASH_TIMETRIM2_T_NVH1_4                                           (0x10U << FLASH_TIMETRIM2_T_NVH1_Pos)
#define FLASH_TIMETRIM2_T_NVH1_5                                           (0x20U << FLASH_TIMETRIM2_T_NVH1_Pos)
#define FLASH_TIMETRIM2_T_NVH1_6                                           (0x40U << FLASH_TIMETRIM2_T_NVH1_Pos)
#define FLASH_TIMETRIM2_T_NVH1_7                                           (0x80U << FLASH_TIMETRIM2_T_NVH1_Pos)
#define FLASH_TIMETRIM2_T_NVS_Pos                                          (0UL)		/*!<FLASH TIMETRIM2: T_NVS (Bit 0) */
#define FLASH_TIMETRIM2_T_NVS_Msk                                          (0xffUL)		/*!< FLASH TIMETRIM2: T_NVS (Bitfield-Mask: 0xff) */
#define FLASH_TIMETRIM2_T_NVS                                              FLASH_TIMETRIM2_T_NVS_Msk
#define FLASH_TIMETRIM2_T_NVS_0                                            (0x1U << FLASH_TIMETRIM2_T_NVS_Pos)
#define FLASH_TIMETRIM2_T_NVS_1                                            (0x2U << FLASH_TIMETRIM2_T_NVS_Pos)
#define FLASH_TIMETRIM2_T_NVS_2                                            (0x4U << FLASH_TIMETRIM2_T_NVS_Pos)
#define FLASH_TIMETRIM2_T_NVS_3                                            (0x8U << FLASH_TIMETRIM2_T_NVS_Pos)
#define FLASH_TIMETRIM2_T_NVS_4                                            (0x10U << FLASH_TIMETRIM2_T_NVS_Pos)
#define FLASH_TIMETRIM2_T_NVS_5                                            (0x20U << FLASH_TIMETRIM2_T_NVS_Pos)
#define FLASH_TIMETRIM2_T_NVS_6                                            (0x40U << FLASH_TIMETRIM2_T_NVS_Pos)
#define FLASH_TIMETRIM2_T_NVS_7                                            (0x80U << FLASH_TIMETRIM2_T_NVS_Pos)

/* =====================================================    TIMETRIM3    ===================================================== */ 
#define FLASH_TIMETRIM3_T_WK_Pos                                           (0UL)		/*!<FLASH TIMETRIM3: T_WK (Bit 0) */
#define FLASH_TIMETRIM3_T_WK_Msk                                           (0xffUL)		/*!< FLASH TIMETRIM3: T_WK (Bitfield-Mask: 0xff) */
#define FLASH_TIMETRIM3_T_WK                                               FLASH_TIMETRIM3_T_WK_Msk
#define FLASH_TIMETRIM3_T_WK_0                                             (0x1U << FLASH_TIMETRIM3_T_WK_Pos)
#define FLASH_TIMETRIM3_T_WK_1                                             (0x2U << FLASH_TIMETRIM3_T_WK_Pos)
#define FLASH_TIMETRIM3_T_WK_2                                             (0x4U << FLASH_TIMETRIM3_T_WK_Pos)
#define FLASH_TIMETRIM3_T_WK_3                                             (0x8U << FLASH_TIMETRIM3_T_WK_Pos)
#define FLASH_TIMETRIM3_T_WK_4                                             (0x10U << FLASH_TIMETRIM3_T_WK_Pos)
#define FLASH_TIMETRIM3_T_WK_5                                             (0x20U << FLASH_TIMETRIM3_T_WK_Pos)
#define FLASH_TIMETRIM3_T_WK_6                                             (0x40U << FLASH_TIMETRIM3_T_WK_Pos)
#define FLASH_TIMETRIM3_T_WK_7                                             (0x80U << FLASH_TIMETRIM3_T_WK_Pos)

/* =====================================================    PAGEPROT0    ===================================================== */ 
#define FLASH_PAGEPROT0_SEG1_Pos                                           (16UL)		/*!<FLASH PAGEPROT0: SEG1 (Bit 16) */
#define FLASH_PAGEPROT0_SEG1_Msk                                           (0xffff0000UL)		/*!< FLASH PAGEPROT0: SEG1 (Bitfield-Mask: 0xffff) */
#define FLASH_PAGEPROT0_SEG1                                               FLASH_PAGEPROT0_SEG1_Msk
#define FLASH_PAGEPROT0_SEG1_0                                             (0x1U << FLASH_PAGEPROT0_SEG1_Pos)
#define FLASH_PAGEPROT0_SEG1_1                                             (0x2U << FLASH_PAGEPROT0_SEG1_Pos)
#define FLASH_PAGEPROT0_SEG1_2                                             (0x4U << FLASH_PAGEPROT0_SEG1_Pos)
#define FLASH_PAGEPROT0_SEG1_3                                             (0x8U << FLASH_PAGEPROT0_SEG1_Pos)
#define FLASH_PAGEPROT0_SEG1_4                                             (0x10U << FLASH_PAGEPROT0_SEG1_Pos)
#define FLASH_PAGEPROT0_SEG1_5                                             (0x20U << FLASH_PAGEPROT0_SEG1_Pos)
#define FLASH_PAGEPROT0_SEG1_6                                             (0x40U << FLASH_PAGEPROT0_SEG1_Pos)
#define FLASH_PAGEPROT0_SEG1_7                                             (0x80U << FLASH_PAGEPROT0_SEG1_Pos)
#define FLASH_PAGEPROT0_SEG1_8                                             (0x100U << FLASH_PAGEPROT0_SEG1_Pos)
#define FLASH_PAGEPROT0_SEG1_9                                             (0x200U << FLASH_PAGEPROT0_SEG1_Pos)
#define FLASH_PAGEPROT0_SEG1_10                                            (0x400U << FLASH_PAGEPROT0_SEG1_Pos)
#define FLASH_PAGEPROT0_SEG1_11                                            (0x800U << FLASH_PAGEPROT0_SEG1_Pos)
#define FLASH_PAGEPROT0_SEG1_12                                            (0x1000U << FLASH_PAGEPROT0_SEG1_Pos)
#define FLASH_PAGEPROT0_SEG1_13                                            (0x2000U << FLASH_PAGEPROT0_SEG1_Pos)
#define FLASH_PAGEPROT0_SEG1_14                                            (0x4000U << FLASH_PAGEPROT0_SEG1_Pos)
#define FLASH_PAGEPROT0_SEG1_15                                            (0x8000U << FLASH_PAGEPROT0_SEG1_Pos)
#define FLASH_PAGEPROT0_SEG0_Pos                                           (0UL)		/*!<FLASH PAGEPROT0: SEG0 (Bit 0) */
#define FLASH_PAGEPROT0_SEG0_Msk                                           (0xffffUL)		/*!< FLASH PAGEPROT0: SEG0 (Bitfield-Mask: 0xffff) */
#define FLASH_PAGEPROT0_SEG0                                               FLASH_PAGEPROT0_SEG0_Msk
#define FLASH_PAGEPROT0_SEG0_0                                             (0x1U << FLASH_PAGEPROT0_SEG0_Pos)
#define FLASH_PAGEPROT0_SEG0_1                                             (0x2U << FLASH_PAGEPROT0_SEG0_Pos)
#define FLASH_PAGEPROT0_SEG0_2                                             (0x4U << FLASH_PAGEPROT0_SEG0_Pos)
#define FLASH_PAGEPROT0_SEG0_3                                             (0x8U << FLASH_PAGEPROT0_SEG0_Pos)
#define FLASH_PAGEPROT0_SEG0_4                                             (0x10U << FLASH_PAGEPROT0_SEG0_Pos)
#define FLASH_PAGEPROT0_SEG0_5                                             (0x20U << FLASH_PAGEPROT0_SEG0_Pos)
#define FLASH_PAGEPROT0_SEG0_6                                             (0x40U << FLASH_PAGEPROT0_SEG0_Pos)
#define FLASH_PAGEPROT0_SEG0_7                                             (0x80U << FLASH_PAGEPROT0_SEG0_Pos)
#define FLASH_PAGEPROT0_SEG0_8                                             (0x100U << FLASH_PAGEPROT0_SEG0_Pos)
#define FLASH_PAGEPROT0_SEG0_9                                             (0x200U << FLASH_PAGEPROT0_SEG0_Pos)
#define FLASH_PAGEPROT0_SEG0_10                                            (0x400U << FLASH_PAGEPROT0_SEG0_Pos)
#define FLASH_PAGEPROT0_SEG0_11                                            (0x800U << FLASH_PAGEPROT0_SEG0_Pos)
#define FLASH_PAGEPROT0_SEG0_12                                            (0x1000U << FLASH_PAGEPROT0_SEG0_Pos)
#define FLASH_PAGEPROT0_SEG0_13                                            (0x2000U << FLASH_PAGEPROT0_SEG0_Pos)
#define FLASH_PAGEPROT0_SEG0_14                                            (0x4000U << FLASH_PAGEPROT0_SEG0_Pos)
#define FLASH_PAGEPROT0_SEG0_15                                            (0x8000U << FLASH_PAGEPROT0_SEG0_Pos)

/* =====================================================    PAGEPROT1    ===================================================== */ 
#define FLASH_PAGEPROT1_SEG3_Pos                                           (16UL)		/*!<FLASH PAGEPROT1: SEG3 (Bit 16) */
#define FLASH_PAGEPROT1_SEG3_Msk                                           (0xffff0000UL)		/*!< FLASH PAGEPROT1: SEG3 (Bitfield-Mask: 0xffff) */
#define FLASH_PAGEPROT1_SEG3                                               FLASH_PAGEPROT1_SEG3_Msk
#define FLASH_PAGEPROT1_SEG3_0                                             (0x1U << FLASH_PAGEPROT1_SEG3_Pos)
#define FLASH_PAGEPROT1_SEG3_1                                             (0x2U << FLASH_PAGEPROT1_SEG3_Pos)
#define FLASH_PAGEPROT1_SEG3_2                                             (0x4U << FLASH_PAGEPROT1_SEG3_Pos)
#define FLASH_PAGEPROT1_SEG3_3                                             (0x8U << FLASH_PAGEPROT1_SEG3_Pos)
#define FLASH_PAGEPROT1_SEG3_4                                             (0x10U << FLASH_PAGEPROT1_SEG3_Pos)
#define FLASH_PAGEPROT1_SEG3_5                                             (0x20U << FLASH_PAGEPROT1_SEG3_Pos)
#define FLASH_PAGEPROT1_SEG3_6                                             (0x40U << FLASH_PAGEPROT1_SEG3_Pos)
#define FLASH_PAGEPROT1_SEG3_7                                             (0x80U << FLASH_PAGEPROT1_SEG3_Pos)
#define FLASH_PAGEPROT1_SEG3_8                                             (0x100U << FLASH_PAGEPROT1_SEG3_Pos)
#define FLASH_PAGEPROT1_SEG3_9                                             (0x200U << FLASH_PAGEPROT1_SEG3_Pos)
#define FLASH_PAGEPROT1_SEG3_10                                            (0x400U << FLASH_PAGEPROT1_SEG3_Pos)
#define FLASH_PAGEPROT1_SEG3_11                                            (0x800U << FLASH_PAGEPROT1_SEG3_Pos)
#define FLASH_PAGEPROT1_SEG3_12                                            (0x1000U << FLASH_PAGEPROT1_SEG3_Pos)
#define FLASH_PAGEPROT1_SEG3_13                                            (0x2000U << FLASH_PAGEPROT1_SEG3_Pos)
#define FLASH_PAGEPROT1_SEG3_14                                            (0x4000U << FLASH_PAGEPROT1_SEG3_Pos)
#define FLASH_PAGEPROT1_SEG3_15                                            (0x8000U << FLASH_PAGEPROT1_SEG3_Pos)
#define FLASH_PAGEPROT1_SEG2_Pos                                           (0UL)		/*!<FLASH PAGEPROT1: SEG2 (Bit 0) */
#define FLASH_PAGEPROT1_SEG2_Msk                                           (0xffffUL)		/*!< FLASH PAGEPROT1: SEG2 (Bitfield-Mask: 0xffff) */
#define FLASH_PAGEPROT1_SEG2                                               FLASH_PAGEPROT1_SEG2_Msk
#define FLASH_PAGEPROT1_SEG2_0                                             (0x1U << FLASH_PAGEPROT1_SEG2_Pos)
#define FLASH_PAGEPROT1_SEG2_1                                             (0x2U << FLASH_PAGEPROT1_SEG2_Pos)
#define FLASH_PAGEPROT1_SEG2_2                                             (0x4U << FLASH_PAGEPROT1_SEG2_Pos)
#define FLASH_PAGEPROT1_SEG2_3                                             (0x8U << FLASH_PAGEPROT1_SEG2_Pos)
#define FLASH_PAGEPROT1_SEG2_4                                             (0x10U << FLASH_PAGEPROT1_SEG2_Pos)
#define FLASH_PAGEPROT1_SEG2_5                                             (0x20U << FLASH_PAGEPROT1_SEG2_Pos)
#define FLASH_PAGEPROT1_SEG2_6                                             (0x40U << FLASH_PAGEPROT1_SEG2_Pos)
#define FLASH_PAGEPROT1_SEG2_7                                             (0x80U << FLASH_PAGEPROT1_SEG2_Pos)
#define FLASH_PAGEPROT1_SEG2_8                                             (0x100U << FLASH_PAGEPROT1_SEG2_Pos)
#define FLASH_PAGEPROT1_SEG2_9                                             (0x200U << FLASH_PAGEPROT1_SEG2_Pos)
#define FLASH_PAGEPROT1_SEG2_10                                            (0x400U << FLASH_PAGEPROT1_SEG2_Pos)
#define FLASH_PAGEPROT1_SEG2_11                                            (0x800U << FLASH_PAGEPROT1_SEG2_Pos)
#define FLASH_PAGEPROT1_SEG2_12                                            (0x1000U << FLASH_PAGEPROT1_SEG2_Pos)
#define FLASH_PAGEPROT1_SEG2_13                                            (0x2000U << FLASH_PAGEPROT1_SEG2_Pos)
#define FLASH_PAGEPROT1_SEG2_14                                            (0x4000U << FLASH_PAGEPROT1_SEG2_Pos)
#define FLASH_PAGEPROT1_SEG2_15                                            (0x8000U << FLASH_PAGEPROT1_SEG2_Pos)

/* =====================================================    DATA0    ===================================================== */ 
#define FLASH_DATA0_DATA0_Pos                                              (0UL)		/*!<FLASH DATA0: DATA0 (Bit 0) */
#define FLASH_DATA0_DATA0_Msk                                              (0xffffffffUL)		/*!< FLASH DATA0: DATA0 (Bitfield-Mask: 0xffffffff) */
#define FLASH_DATA0_DATA0                                                  FLASH_DATA0_DATA0_Msk
#define FLASH_DATA0_DATA0_0                                                (0x1U << FLASH_DATA0_DATA0_Pos)
#define FLASH_DATA0_DATA0_1                                                (0x2U << FLASH_DATA0_DATA0_Pos)
#define FLASH_DATA0_DATA0_2                                                (0x4U << FLASH_DATA0_DATA0_Pos)
#define FLASH_DATA0_DATA0_3                                                (0x8U << FLASH_DATA0_DATA0_Pos)
#define FLASH_DATA0_DATA0_4                                                (0x10U << FLASH_DATA0_DATA0_Pos)
#define FLASH_DATA0_DATA0_5                                                (0x20U << FLASH_DATA0_DATA0_Pos)
#define FLASH_DATA0_DATA0_6                                                (0x40U << FLASH_DATA0_DATA0_Pos)
#define FLASH_DATA0_DATA0_7                                                (0x80U << FLASH_DATA0_DATA0_Pos)
#define FLASH_DATA0_DATA0_8                                                (0x100U << FLASH_DATA0_DATA0_Pos)
#define FLASH_DATA0_DATA0_9                                                (0x200U << FLASH_DATA0_DATA0_Pos)
#define FLASH_DATA0_DATA0_10                                               (0x400U << FLASH_DATA0_DATA0_Pos)
#define FLASH_DATA0_DATA0_11                                               (0x800U << FLASH_DATA0_DATA0_Pos)
#define FLASH_DATA0_DATA0_12                                               (0x1000U << FLASH_DATA0_DATA0_Pos)
#define FLASH_DATA0_DATA0_13                                               (0x2000U << FLASH_DATA0_DATA0_Pos)
#define FLASH_DATA0_DATA0_14                                               (0x4000U << FLASH_DATA0_DATA0_Pos)
#define FLASH_DATA0_DATA0_15                                               (0x8000U << FLASH_DATA0_DATA0_Pos)
#define FLASH_DATA0_DATA0_16                                               (0x10000U << FLASH_DATA0_DATA0_Pos)
#define FLASH_DATA0_DATA0_17                                               (0x20000U << FLASH_DATA0_DATA0_Pos)
#define FLASH_DATA0_DATA0_18                                               (0x40000U << FLASH_DATA0_DATA0_Pos)
#define FLASH_DATA0_DATA0_19                                               (0x80000U << FLASH_DATA0_DATA0_Pos)
#define FLASH_DATA0_DATA0_20                                               (0x100000U << FLASH_DATA0_DATA0_Pos)
#define FLASH_DATA0_DATA0_21                                               (0x200000U << FLASH_DATA0_DATA0_Pos)
#define FLASH_DATA0_DATA0_22                                               (0x400000U << FLASH_DATA0_DATA0_Pos)
#define FLASH_DATA0_DATA0_23                                               (0x800000U << FLASH_DATA0_DATA0_Pos)
#define FLASH_DATA0_DATA0_24                                               (0x1000000U << FLASH_DATA0_DATA0_Pos)
#define FLASH_DATA0_DATA0_25                                               (0x2000000U << FLASH_DATA0_DATA0_Pos)
#define FLASH_DATA0_DATA0_26                                               (0x4000000U << FLASH_DATA0_DATA0_Pos)
#define FLASH_DATA0_DATA0_27                                               (0x8000000U << FLASH_DATA0_DATA0_Pos)
#define FLASH_DATA0_DATA0_28                                               (0x10000000U << FLASH_DATA0_DATA0_Pos)
#define FLASH_DATA0_DATA0_29                                               (0x20000000U << FLASH_DATA0_DATA0_Pos)
#define FLASH_DATA0_DATA0_30                                               (0x40000000U << FLASH_DATA0_DATA0_Pos)
#define FLASH_DATA0_DATA0_31                                               (0x80000000UL << FLASH_DATA0_DATA0_Pos)

/* =====================================================    DATA1    ===================================================== */ 
#define FLASH_DATA1_DATA1_Pos                                              (0UL)		/*!<FLASH DATA1: DATA1 (Bit 0) */
#define FLASH_DATA1_DATA1_Msk                                              (0xffffffffUL)		/*!< FLASH DATA1: DATA1 (Bitfield-Mask: 0xffffffff) */
#define FLASH_DATA1_DATA1                                                  FLASH_DATA1_DATA1_Msk
#define FLASH_DATA1_DATA1_0                                                (0x1U << FLASH_DATA1_DATA1_Pos)
#define FLASH_DATA1_DATA1_1                                                (0x2U << FLASH_DATA1_DATA1_Pos)
#define FLASH_DATA1_DATA1_2                                                (0x4U << FLASH_DATA1_DATA1_Pos)
#define FLASH_DATA1_DATA1_3                                                (0x8U << FLASH_DATA1_DATA1_Pos)
#define FLASH_DATA1_DATA1_4                                                (0x10U << FLASH_DATA1_DATA1_Pos)
#define FLASH_DATA1_DATA1_5                                                (0x20U << FLASH_DATA1_DATA1_Pos)
#define FLASH_DATA1_DATA1_6                                                (0x40U << FLASH_DATA1_DATA1_Pos)
#define FLASH_DATA1_DATA1_7                                                (0x80U << FLASH_DATA1_DATA1_Pos)
#define FLASH_DATA1_DATA1_8                                                (0x100U << FLASH_DATA1_DATA1_Pos)
#define FLASH_DATA1_DATA1_9                                                (0x200U << FLASH_DATA1_DATA1_Pos)
#define FLASH_DATA1_DATA1_10                                               (0x400U << FLASH_DATA1_DATA1_Pos)
#define FLASH_DATA1_DATA1_11                                               (0x800U << FLASH_DATA1_DATA1_Pos)
#define FLASH_DATA1_DATA1_12                                               (0x1000U << FLASH_DATA1_DATA1_Pos)
#define FLASH_DATA1_DATA1_13                                               (0x2000U << FLASH_DATA1_DATA1_Pos)
#define FLASH_DATA1_DATA1_14                                               (0x4000U << FLASH_DATA1_DATA1_Pos)
#define FLASH_DATA1_DATA1_15                                               (0x8000U << FLASH_DATA1_DATA1_Pos)
#define FLASH_DATA1_DATA1_16                                               (0x10000U << FLASH_DATA1_DATA1_Pos)
#define FLASH_DATA1_DATA1_17                                               (0x20000U << FLASH_DATA1_DATA1_Pos)
#define FLASH_DATA1_DATA1_18                                               (0x40000U << FLASH_DATA1_DATA1_Pos)
#define FLASH_DATA1_DATA1_19                                               (0x80000U << FLASH_DATA1_DATA1_Pos)
#define FLASH_DATA1_DATA1_20                                               (0x100000U << FLASH_DATA1_DATA1_Pos)
#define FLASH_DATA1_DATA1_21                                               (0x200000U << FLASH_DATA1_DATA1_Pos)
#define FLASH_DATA1_DATA1_22                                               (0x400000U << FLASH_DATA1_DATA1_Pos)
#define FLASH_DATA1_DATA1_23                                               (0x800000U << FLASH_DATA1_DATA1_Pos)
#define FLASH_DATA1_DATA1_24                                               (0x1000000U << FLASH_DATA1_DATA1_Pos)
#define FLASH_DATA1_DATA1_25                                               (0x2000000U << FLASH_DATA1_DATA1_Pos)
#define FLASH_DATA1_DATA1_26                                               (0x4000000U << FLASH_DATA1_DATA1_Pos)
#define FLASH_DATA1_DATA1_27                                               (0x8000000U << FLASH_DATA1_DATA1_Pos)
#define FLASH_DATA1_DATA1_28                                               (0x10000000U << FLASH_DATA1_DATA1_Pos)
#define FLASH_DATA1_DATA1_29                                               (0x20000000U << FLASH_DATA1_DATA1_Pos)
#define FLASH_DATA1_DATA1_30                                               (0x40000000U << FLASH_DATA1_DATA1_Pos)
#define FLASH_DATA1_DATA1_31                                               (0x80000000UL << FLASH_DATA1_DATA1_Pos)

/* =====================================================    DATA2    ===================================================== */ 
#define FLASH_DATA2_DATA2_Pos                                              (0UL)		/*!<FLASH DATA2: DATA2 (Bit 0) */
#define FLASH_DATA2_DATA2_Msk                                              (0xffffffffUL)		/*!< FLASH DATA2: DATA2 (Bitfield-Mask: 0xffffffff) */
#define FLASH_DATA2_DATA2                                                  FLASH_DATA2_DATA2_Msk
#define FLASH_DATA2_DATA2_0                                                (0x1U << FLASH_DATA2_DATA2_Pos)
#define FLASH_DATA2_DATA2_1                                                (0x2U << FLASH_DATA2_DATA2_Pos)
#define FLASH_DATA2_DATA2_2                                                (0x4U << FLASH_DATA2_DATA2_Pos)
#define FLASH_DATA2_DATA2_3                                                (0x8U << FLASH_DATA2_DATA2_Pos)
#define FLASH_DATA2_DATA2_4                                                (0x10U << FLASH_DATA2_DATA2_Pos)
#define FLASH_DATA2_DATA2_5                                                (0x20U << FLASH_DATA2_DATA2_Pos)
#define FLASH_DATA2_DATA2_6                                                (0x40U << FLASH_DATA2_DATA2_Pos)
#define FLASH_DATA2_DATA2_7                                                (0x80U << FLASH_DATA2_DATA2_Pos)
#define FLASH_DATA2_DATA2_8                                                (0x100U << FLASH_DATA2_DATA2_Pos)
#define FLASH_DATA2_DATA2_9                                                (0x200U << FLASH_DATA2_DATA2_Pos)
#define FLASH_DATA2_DATA2_10                                               (0x400U << FLASH_DATA2_DATA2_Pos)
#define FLASH_DATA2_DATA2_11                                               (0x800U << FLASH_DATA2_DATA2_Pos)
#define FLASH_DATA2_DATA2_12                                               (0x1000U << FLASH_DATA2_DATA2_Pos)
#define FLASH_DATA2_DATA2_13                                               (0x2000U << FLASH_DATA2_DATA2_Pos)
#define FLASH_DATA2_DATA2_14                                               (0x4000U << FLASH_DATA2_DATA2_Pos)
#define FLASH_DATA2_DATA2_15                                               (0x8000U << FLASH_DATA2_DATA2_Pos)
#define FLASH_DATA2_DATA2_16                                               (0x10000U << FLASH_DATA2_DATA2_Pos)
#define FLASH_DATA2_DATA2_17                                               (0x20000U << FLASH_DATA2_DATA2_Pos)
#define FLASH_DATA2_DATA2_18                                               (0x40000U << FLASH_DATA2_DATA2_Pos)
#define FLASH_DATA2_DATA2_19                                               (0x80000U << FLASH_DATA2_DATA2_Pos)
#define FLASH_DATA2_DATA2_20                                               (0x100000U << FLASH_DATA2_DATA2_Pos)
#define FLASH_DATA2_DATA2_21                                               (0x200000U << FLASH_DATA2_DATA2_Pos)
#define FLASH_DATA2_DATA2_22                                               (0x400000U << FLASH_DATA2_DATA2_Pos)
#define FLASH_DATA2_DATA2_23                                               (0x800000U << FLASH_DATA2_DATA2_Pos)
#define FLASH_DATA2_DATA2_24                                               (0x1000000U << FLASH_DATA2_DATA2_Pos)
#define FLASH_DATA2_DATA2_25                                               (0x2000000U << FLASH_DATA2_DATA2_Pos)
#define FLASH_DATA2_DATA2_26                                               (0x4000000U << FLASH_DATA2_DATA2_Pos)
#define FLASH_DATA2_DATA2_27                                               (0x8000000U << FLASH_DATA2_DATA2_Pos)
#define FLASH_DATA2_DATA2_28                                               (0x10000000U << FLASH_DATA2_DATA2_Pos)
#define FLASH_DATA2_DATA2_29                                               (0x20000000U << FLASH_DATA2_DATA2_Pos)
#define FLASH_DATA2_DATA2_30                                               (0x40000000U << FLASH_DATA2_DATA2_Pos)
#define FLASH_DATA2_DATA2_31                                               (0x80000000UL << FLASH_DATA2_DATA2_Pos)

/* =====================================================    DATA3    ===================================================== */ 
#define FLASH_DATA3_DATA3_Pos                                              (0UL)		/*!<FLASH DATA3: DATA3 (Bit 0) */
#define FLASH_DATA3_DATA3_Msk                                              (0xffffffffUL)		/*!< FLASH DATA3: DATA3 (Bitfield-Mask: 0xffffffff) */
#define FLASH_DATA3_DATA3                                                  FLASH_DATA3_DATA3_Msk
#define FLASH_DATA3_DATA3_0                                                (0x1U << FLASH_DATA3_DATA3_Pos)
#define FLASH_DATA3_DATA3_1                                                (0x2U << FLASH_DATA3_DATA3_Pos)
#define FLASH_DATA3_DATA3_2                                                (0x4U << FLASH_DATA3_DATA3_Pos)
#define FLASH_DATA3_DATA3_3                                                (0x8U << FLASH_DATA3_DATA3_Pos)
#define FLASH_DATA3_DATA3_4                                                (0x10U << FLASH_DATA3_DATA3_Pos)
#define FLASH_DATA3_DATA3_5                                                (0x20U << FLASH_DATA3_DATA3_Pos)
#define FLASH_DATA3_DATA3_6                                                (0x40U << FLASH_DATA3_DATA3_Pos)
#define FLASH_DATA3_DATA3_7                                                (0x80U << FLASH_DATA3_DATA3_Pos)
#define FLASH_DATA3_DATA3_8                                                (0x100U << FLASH_DATA3_DATA3_Pos)
#define FLASH_DATA3_DATA3_9                                                (0x200U << FLASH_DATA3_DATA3_Pos)
#define FLASH_DATA3_DATA3_10                                               (0x400U << FLASH_DATA3_DATA3_Pos)
#define FLASH_DATA3_DATA3_11                                               (0x800U << FLASH_DATA3_DATA3_Pos)
#define FLASH_DATA3_DATA3_12                                               (0x1000U << FLASH_DATA3_DATA3_Pos)
#define FLASH_DATA3_DATA3_13                                               (0x2000U << FLASH_DATA3_DATA3_Pos)
#define FLASH_DATA3_DATA3_14                                               (0x4000U << FLASH_DATA3_DATA3_Pos)
#define FLASH_DATA3_DATA3_15                                               (0x8000U << FLASH_DATA3_DATA3_Pos)
#define FLASH_DATA3_DATA3_16                                               (0x10000U << FLASH_DATA3_DATA3_Pos)
#define FLASH_DATA3_DATA3_17                                               (0x20000U << FLASH_DATA3_DATA3_Pos)
#define FLASH_DATA3_DATA3_18                                               (0x40000U << FLASH_DATA3_DATA3_Pos)
#define FLASH_DATA3_DATA3_19                                               (0x80000U << FLASH_DATA3_DATA3_Pos)
#define FLASH_DATA3_DATA3_20                                               (0x100000U << FLASH_DATA3_DATA3_Pos)
#define FLASH_DATA3_DATA3_21                                               (0x200000U << FLASH_DATA3_DATA3_Pos)
#define FLASH_DATA3_DATA3_22                                               (0x400000U << FLASH_DATA3_DATA3_Pos)
#define FLASH_DATA3_DATA3_23                                               (0x800000U << FLASH_DATA3_DATA3_Pos)
#define FLASH_DATA3_DATA3_24                                               (0x1000000U << FLASH_DATA3_DATA3_Pos)
#define FLASH_DATA3_DATA3_25                                               (0x2000000U << FLASH_DATA3_DATA3_Pos)
#define FLASH_DATA3_DATA3_26                                               (0x4000000U << FLASH_DATA3_DATA3_Pos)
#define FLASH_DATA3_DATA3_27                                               (0x8000000U << FLASH_DATA3_DATA3_Pos)
#define FLASH_DATA3_DATA3_28                                               (0x10000000U << FLASH_DATA3_DATA3_Pos)
#define FLASH_DATA3_DATA3_29                                               (0x20000000U << FLASH_DATA3_DATA3_Pos)
#define FLASH_DATA3_DATA3_30                                               (0x40000000U << FLASH_DATA3_DATA3_Pos)
#define FLASH_DATA3_DATA3_31                                               (0x80000000UL << FLASH_DATA3_DATA3_Pos)


/* =========================================================================================================================== */ 
/*=====================                                       SPI                                       ===================== */ 
/* =========================================================================================================================== */ 

/* =====================================================    CR1    ===================================================== */ 
#define SPI_CR1_BIDIMODE_Pos                                               (15UL)		/*!<SPI CR1: BIDIMODE (Bit 15) */
#define SPI_CR1_BIDIMODE_Msk                                               (0x8000UL)		/*!< SPI CR1: BIDIMODE (Bitfield-Mask: 0x01) */
#define SPI_CR1_BIDIMODE                                                   SPI_CR1_BIDIMODE_Msk
#define SPI_CR1_BIDIOE_Pos                                                 (14UL)		/*!<SPI CR1: BIDIOE (Bit 14) */
#define SPI_CR1_BIDIOE_Msk                                                 (0x4000UL)		/*!< SPI CR1: BIDIOE (Bitfield-Mask: 0x01) */
#define SPI_CR1_BIDIOE                                                     SPI_CR1_BIDIOE_Msk
#define SPI_CR1_CRCEN_Pos                                                  (13UL)		/*!<SPI CR1: CRCEN (Bit 13) */
#define SPI_CR1_CRCEN_Msk                                                  (0x2000UL)		/*!< SPI CR1: CRCEN (Bitfield-Mask: 0x01) */
#define SPI_CR1_CRCEN                                                      SPI_CR1_CRCEN_Msk
#define SPI_CR1_CRCNEXT_Pos                                                (12UL)		/*!<SPI CR1: CRCNEXT (Bit 12) */
#define SPI_CR1_CRCNEXT_Msk                                                (0x1000UL)		/*!< SPI CR1: CRCNEXT (Bitfield-Mask: 0x01) */
#define SPI_CR1_CRCNEXT                                                    SPI_CR1_CRCNEXT_Msk
#define SPI_CR1_CRCL_Pos                                                   (11UL)		/*!<SPI CR1: CRCL (Bit 11) */
#define SPI_CR1_CRCL_Msk                                                   (0x800UL)		/*!< SPI CR1: CRCL (Bitfield-Mask: 0x01) */
#define SPI_CR1_CRCL                                                       SPI_CR1_CRCL_Msk
#define SPI_CR1_RXONLY_Pos                                                 (10UL)		/*!<SPI CR1: RXONLY (Bit 10) */
#define SPI_CR1_RXONLY_Msk                                                 (0x400UL)		/*!< SPI CR1: RXONLY (Bitfield-Mask: 0x01) */
#define SPI_CR1_RXONLY                                                     SPI_CR1_RXONLY_Msk
#define SPI_CR1_SSM_Pos                                                    (9UL)		/*!<SPI CR1: SSM (Bit 9) */
#define SPI_CR1_SSM_Msk                                                    (0x200UL)		/*!< SPI CR1: SSM (Bitfield-Mask: 0x01) */
#define SPI_CR1_SSM                                                        SPI_CR1_SSM_Msk
#define SPI_CR1_SSI_Pos                                                    (8UL)		/*!<SPI CR1: SSI (Bit 8) */
#define SPI_CR1_SSI_Msk                                                    (0x100UL)		/*!< SPI CR1: SSI (Bitfield-Mask: 0x01) */
#define SPI_CR1_SSI                                                        SPI_CR1_SSI_Msk
#define SPI_CR1_LSBFIRST_Pos                                               (7UL)		/*!<SPI CR1: LSBFIRST (Bit 7) */
#define SPI_CR1_LSBFIRST_Msk                                               (0x80UL)		/*!< SPI CR1: LSBFIRST (Bitfield-Mask: 0x01) */
#define SPI_CR1_LSBFIRST                                                   SPI_CR1_LSBFIRST_Msk
#define SPI_CR1_SPE_Pos                                                    (6UL)		/*!<SPI CR1: SPE (Bit 6) */
#define SPI_CR1_SPE_Msk                                                    (0x40UL)		/*!< SPI CR1: SPE (Bitfield-Mask: 0x01) */
#define SPI_CR1_SPE                                                        SPI_CR1_SPE_Msk
#define SPI_CR1_BR_Pos                                                     (3UL)		/*!<SPI CR1: BR (Bit 3) */
#define SPI_CR1_BR_Msk                                                     (0x38UL)		/*!< SPI CR1: BR (Bitfield-Mask: 0x07) */
#define SPI_CR1_BR                                                         SPI_CR1_BR_Msk
#define SPI_CR1_BR_0                                                       (0x1U << SPI_CR1_BR_Pos)
#define SPI_CR1_BR_1                                                       (0x2U << SPI_CR1_BR_Pos)
#define SPI_CR1_BR_2                                                       (0x4U << SPI_CR1_BR_Pos)
#define SPI_CR1_MSTR_Pos                                                   (2UL)		/*!<SPI CR1: MSTR (Bit 2) */
#define SPI_CR1_MSTR_Msk                                                   (0x4UL)		/*!< SPI CR1: MSTR (Bitfield-Mask: 0x01) */
#define SPI_CR1_MSTR                                                       SPI_CR1_MSTR_Msk
#define SPI_CR1_CPOL_Pos                                                   (1UL)		/*!<SPI CR1: CPOL (Bit 1) */
#define SPI_CR1_CPOL_Msk                                                   (0x2UL)		/*!< SPI CR1: CPOL (Bitfield-Mask: 0x01) */
#define SPI_CR1_CPOL                                                       SPI_CR1_CPOL_Msk
#define SPI_CR1_CPHA_Pos                                                   (0UL)		/*!<SPI CR1: CPHA (Bit 0) */
#define SPI_CR1_CPHA_Msk                                                   (0x1UL)		/*!< SPI CR1: CPHA (Bitfield-Mask: 0x01) */
#define SPI_CR1_CPHA                                                       SPI_CR1_CPHA_Msk

/* =====================================================    CR2    ===================================================== */ 
#define SPI_CR2_LDMATX_Pos                                                 (14UL)		/*!<SPI CR2: LDMATX (Bit 14) */
#define SPI_CR2_LDMATX_Msk                                                 (0x4000UL)		/*!< SPI CR2: LDMATX (Bitfield-Mask: 0x01) */
#define SPI_CR2_LDMATX                                                     SPI_CR2_LDMATX_Msk
#define SPI_CR2_LDMARX_Pos                                                 (13UL)		/*!<SPI CR2: LDMARX (Bit 13) */
#define SPI_CR2_LDMARX_Msk                                                 (0x2000UL)		/*!< SPI CR2: LDMARX (Bitfield-Mask: 0x01) */
#define SPI_CR2_LDMARX                                                     SPI_CR2_LDMARX_Msk
#define SPI_CR2_FRXTH_Pos                                                  (12UL)		/*!<SPI CR2: FRXTH (Bit 12) */
#define SPI_CR2_FRXTH_Msk                                                  (0x1000UL)		/*!< SPI CR2: FRXTH (Bitfield-Mask: 0x01) */
#define SPI_CR2_FRXTH                                                      SPI_CR2_FRXTH_Msk
#define SPI_CR2_DS_Pos                                                     (8UL)		/*!<SPI CR2: DS (Bit 8) */
#define SPI_CR2_DS_Msk                                                     (0xf00UL)		/*!< SPI CR2: DS (Bitfield-Mask: 0x0f) */
#define SPI_CR2_DS                                                         SPI_CR2_DS_Msk
#define SPI_CR2_DS_0                                                       (0x1U << SPI_CR2_DS_Pos)
#define SPI_CR2_DS_1                                                       (0x2U << SPI_CR2_DS_Pos)
#define SPI_CR2_DS_2                                                       (0x4U << SPI_CR2_DS_Pos)
#define SPI_CR2_DS_3                                                       (0x8U << SPI_CR2_DS_Pos)
#define SPI_CR2_TXEIE_Pos                                                  (7UL)		/*!<SPI CR2: TXEIE (Bit 7) */
#define SPI_CR2_TXEIE_Msk                                                  (0x80UL)		/*!< SPI CR2: TXEIE (Bitfield-Mask: 0x01) */
#define SPI_CR2_TXEIE                                                      SPI_CR2_TXEIE_Msk
#define SPI_CR2_RXNEIE_Pos                                                 (6UL)		/*!<SPI CR2: RXNEIE (Bit 6) */
#define SPI_CR2_RXNEIE_Msk                                                 (0x40UL)		/*!< SPI CR2: RXNEIE (Bitfield-Mask: 0x01) */
#define SPI_CR2_RXNEIE                                                     SPI_CR2_RXNEIE_Msk
#define SPI_CR2_ERRIE_Pos                                                  (5UL)		/*!<SPI CR2: ERRIE (Bit 5) */
#define SPI_CR2_ERRIE_Msk                                                  (0x20UL)		/*!< SPI CR2: ERRIE (Bitfield-Mask: 0x01) */
#define SPI_CR2_ERRIE                                                      SPI_CR2_ERRIE_Msk
#define SPI_CR2_FRF_Pos                                                    (4UL)		/*!<SPI CR2: FRF (Bit 4) */
#define SPI_CR2_FRF_Msk                                                    (0x10UL)		/*!< SPI CR2: FRF (Bitfield-Mask: 0x01) */
#define SPI_CR2_FRF                                                        SPI_CR2_FRF_Msk
#define SPI_CR2_NSSP_Pos                                                   (3UL)		/*!<SPI CR2: NSSP (Bit 3) */
#define SPI_CR2_NSSP_Msk                                                   (0x8UL)		/*!< SPI CR2: NSSP (Bitfield-Mask: 0x01) */
#define SPI_CR2_NSSP                                                       SPI_CR2_NSSP_Msk
#define SPI_CR2_SSOE_Pos                                                   (2UL)		/*!<SPI CR2: SSOE (Bit 2) */
#define SPI_CR2_SSOE_Msk                                                   (0x4UL)		/*!< SPI CR2: SSOE (Bitfield-Mask: 0x01) */
#define SPI_CR2_SSOE                                                       SPI_CR2_SSOE_Msk
#define SPI_CR2_TXDMAEN_Pos                                                (1UL)		/*!<SPI CR2: TXDMAEN (Bit 1) */
#define SPI_CR2_TXDMAEN_Msk                                                (0x2UL)		/*!< SPI CR2: TXDMAEN (Bitfield-Mask: 0x01) */
#define SPI_CR2_TXDMAEN                                                    SPI_CR2_TXDMAEN_Msk
#define SPI_CR2_RXDMAEN_Pos                                                (0UL)		/*!<SPI CR2: RXDMAEN (Bit 0) */
#define SPI_CR2_RXDMAEN_Msk                                                (0x1UL)		/*!< SPI CR2: RXDMAEN (Bitfield-Mask: 0x01) */
#define SPI_CR2_RXDMAEN                                                    SPI_CR2_RXDMAEN_Msk

/* =====================================================    SR    ===================================================== */ 
#define SPI_SR_FTLVL_Pos                                                   (11UL)		/*!<SPI SR: FTLVL (Bit 11) */
#define SPI_SR_FTLVL_Msk                                                   (0x1800UL)		/*!< SPI SR: FTLVL (Bitfield-Mask: 0x03) */
#define SPI_SR_FTLVL                                                       SPI_SR_FTLVL_Msk
#define SPI_SR_FTLVL_0                                                     (0x1U << SPI_SR_FTLVL_Pos)
#define SPI_SR_FTLVL_1                                                     (0x2U << SPI_SR_FTLVL_Pos)
#define SPI_SR_FRLVL_Pos                                                   (9UL)		/*!<SPI SR: FRLVL (Bit 9) */
#define SPI_SR_FRLVL_Msk                                                   (0x600UL)		/*!< SPI SR: FRLVL (Bitfield-Mask: 0x03) */
#define SPI_SR_FRLVL                                                       SPI_SR_FRLVL_Msk
#define SPI_SR_FRLVL_0                                                     (0x1U << SPI_SR_FRLVL_Pos)
#define SPI_SR_FRLVL_1                                                     (0x2U << SPI_SR_FRLVL_Pos)
#define SPI_SR_FRE_Pos                                                     (8UL)		/*!<SPI SR: FRE (Bit 8) */
#define SPI_SR_FRE_Msk                                                     (0x100UL)		/*!< SPI SR: FRE (Bitfield-Mask: 0x01) */
#define SPI_SR_FRE                                                         SPI_SR_FRE_Msk
#define SPI_SR_BSY_Pos                                                     (7UL)		/*!<SPI SR: BSY (Bit 7) */
#define SPI_SR_BSY_Msk                                                     (0x80UL)		/*!< SPI SR: BSY (Bitfield-Mask: 0x01) */
#define SPI_SR_BSY                                                         SPI_SR_BSY_Msk
#define SPI_SR_OVR_Pos                                                     (6UL)		/*!<SPI SR: OVR (Bit 6) */
#define SPI_SR_OVR_Msk                                                     (0x40UL)		/*!< SPI SR: OVR (Bitfield-Mask: 0x01) */
#define SPI_SR_OVR                                                         SPI_SR_OVR_Msk
#define SPI_SR_MODF_Pos                                                    (5UL)		/*!<SPI SR: MODF (Bit 5) */
#define SPI_SR_MODF_Msk                                                    (0x20UL)		/*!< SPI SR: MODF (Bitfield-Mask: 0x01) */
#define SPI_SR_MODF                                                        SPI_SR_MODF_Msk
#define SPI_SR_CRCERR_Pos                                                  (4UL)		/*!<SPI SR: CRCERR (Bit 4) */
#define SPI_SR_CRCERR_Msk                                                  (0x10UL)		/*!< SPI SR: CRCERR (Bitfield-Mask: 0x01) */
#define SPI_SR_CRCERR                                                      SPI_SR_CRCERR_Msk
#define SPI_SR_UDR_Pos                                                     (3UL)		/*!<SPI SR: UDR (Bit 3) */
#define SPI_SR_UDR_Msk                                                     (0x8UL)		/*!< SPI SR: UDR (Bitfield-Mask: 0x01) */
#define SPI_SR_UDR                                                         SPI_SR_UDR_Msk
#define SPI_SR_CHSIDE_Pos                                                  (2UL)		/*!<SPI SR: CHSIDE (Bit 2) */
#define SPI_SR_CHSIDE_Msk                                                  (0x4UL)		/*!< SPI SR: CHSIDE (Bitfield-Mask: 0x01) */
#define SPI_SR_CHSIDE                                                      SPI_SR_CHSIDE_Msk
#define SPI_SR_TXE_Pos                                                     (1UL)		/*!<SPI SR: TXE (Bit 1) */
#define SPI_SR_TXE_Msk                                                     (0x2UL)		/*!< SPI SR: TXE (Bitfield-Mask: 0x01) */
#define SPI_SR_TXE                                                         SPI_SR_TXE_Msk
#define SPI_SR_RXNE_Pos                                                    (0UL)		/*!<SPI SR: RXNE (Bit 0) */
#define SPI_SR_RXNE_Msk                                                    (0x1UL)		/*!< SPI SR: RXNE (Bitfield-Mask: 0x01) */
#define SPI_SR_RXNE                                                        SPI_SR_RXNE_Msk

/* =====================================================    DR    ===================================================== */ 
#define SPI_DR_DR_Pos                                                      (0UL)		/*!<SPI DR: DR (Bit 0) */
#define SPI_DR_DR_Msk                                                      (0xffffUL)		/*!< SPI DR: DR (Bitfield-Mask: 0xffff) */
#define SPI_DR_DR                                                          SPI_DR_DR_Msk
#define SPI_DR_DR_0                                                        (0x1U << SPI_DR_DR_Pos)
#define SPI_DR_DR_1                                                        (0x2U << SPI_DR_DR_Pos)
#define SPI_DR_DR_2                                                        (0x4U << SPI_DR_DR_Pos)
#define SPI_DR_DR_3                                                        (0x8U << SPI_DR_DR_Pos)
#define SPI_DR_DR_4                                                        (0x10U << SPI_DR_DR_Pos)
#define SPI_DR_DR_5                                                        (0x20U << SPI_DR_DR_Pos)
#define SPI_DR_DR_6                                                        (0x40U << SPI_DR_DR_Pos)
#define SPI_DR_DR_7                                                        (0x80U << SPI_DR_DR_Pos)
#define SPI_DR_DR_8                                                        (0x100U << SPI_DR_DR_Pos)
#define SPI_DR_DR_9                                                        (0x200U << SPI_DR_DR_Pos)
#define SPI_DR_DR_10                                                       (0x400U << SPI_DR_DR_Pos)
#define SPI_DR_DR_11                                                       (0x800U << SPI_DR_DR_Pos)
#define SPI_DR_DR_12                                                       (0x1000U << SPI_DR_DR_Pos)
#define SPI_DR_DR_13                                                       (0x2000U << SPI_DR_DR_Pos)
#define SPI_DR_DR_14                                                       (0x4000U << SPI_DR_DR_Pos)
#define SPI_DR_DR_15                                                       (0x8000U << SPI_DR_DR_Pos)

/* =====================================================    CRCPR    ===================================================== */ 
#define SPI_CRCPR_CRCPOLY_Pos                                              (0UL)		/*!<SPI CRCPR: CRCPOLY (Bit 0) */
#define SPI_CRCPR_CRCPOLY_Msk                                              (0xffffUL)		/*!< SPI CRCPR: CRCPOLY (Bitfield-Mask: 0xffff) */
#define SPI_CRCPR_CRCPOLY                                                  SPI_CRCPR_CRCPOLY_Msk
#define SPI_CRCPR_CRCPOLY_0                                                (0x1U << SPI_CRCPR_CRCPOLY_Pos)
#define SPI_CRCPR_CRCPOLY_1                                                (0x2U << SPI_CRCPR_CRCPOLY_Pos)
#define SPI_CRCPR_CRCPOLY_2                                                (0x4U << SPI_CRCPR_CRCPOLY_Pos)
#define SPI_CRCPR_CRCPOLY_3                                                (0x8U << SPI_CRCPR_CRCPOLY_Pos)
#define SPI_CRCPR_CRCPOLY_4                                                (0x10U << SPI_CRCPR_CRCPOLY_Pos)
#define SPI_CRCPR_CRCPOLY_5                                                (0x20U << SPI_CRCPR_CRCPOLY_Pos)
#define SPI_CRCPR_CRCPOLY_6                                                (0x40U << SPI_CRCPR_CRCPOLY_Pos)
#define SPI_CRCPR_CRCPOLY_7                                                (0x80U << SPI_CRCPR_CRCPOLY_Pos)
#define SPI_CRCPR_CRCPOLY_8                                                (0x100U << SPI_CRCPR_CRCPOLY_Pos)
#define SPI_CRCPR_CRCPOLY_9                                                (0x200U << SPI_CRCPR_CRCPOLY_Pos)
#define SPI_CRCPR_CRCPOLY_10                                               (0x400U << SPI_CRCPR_CRCPOLY_Pos)
#define SPI_CRCPR_CRCPOLY_11                                               (0x800U << SPI_CRCPR_CRCPOLY_Pos)
#define SPI_CRCPR_CRCPOLY_12                                               (0x1000U << SPI_CRCPR_CRCPOLY_Pos)
#define SPI_CRCPR_CRCPOLY_13                                               (0x2000U << SPI_CRCPR_CRCPOLY_Pos)
#define SPI_CRCPR_CRCPOLY_14                                               (0x4000U << SPI_CRCPR_CRCPOLY_Pos)
#define SPI_CRCPR_CRCPOLY_15                                               (0x8000U << SPI_CRCPR_CRCPOLY_Pos)

/* =====================================================    RXCRCR    ===================================================== */ 
#define SPI_RXCRCR_RXCRC_Pos                                               (0UL)		/*!<SPI RXCRCR: RXCRC (Bit 0) */
#define SPI_RXCRCR_RXCRC_Msk                                               (0xffffUL)		/*!< SPI RXCRCR: RXCRC (Bitfield-Mask: 0xffff) */
#define SPI_RXCRCR_RXCRC                                                   SPI_RXCRCR_RXCRC_Msk
#define SPI_RXCRCR_RXCRC_0                                                 (0x1U << SPI_RXCRCR_RXCRC_Pos)
#define SPI_RXCRCR_RXCRC_1                                                 (0x2U << SPI_RXCRCR_RXCRC_Pos)
#define SPI_RXCRCR_RXCRC_2                                                 (0x4U << SPI_RXCRCR_RXCRC_Pos)
#define SPI_RXCRCR_RXCRC_3                                                 (0x8U << SPI_RXCRCR_RXCRC_Pos)
#define SPI_RXCRCR_RXCRC_4                                                 (0x10U << SPI_RXCRCR_RXCRC_Pos)
#define SPI_RXCRCR_RXCRC_5                                                 (0x20U << SPI_RXCRCR_RXCRC_Pos)
#define SPI_RXCRCR_RXCRC_6                                                 (0x40U << SPI_RXCRCR_RXCRC_Pos)
#define SPI_RXCRCR_RXCRC_7                                                 (0x80U << SPI_RXCRCR_RXCRC_Pos)
#define SPI_RXCRCR_RXCRC_8                                                 (0x100U << SPI_RXCRCR_RXCRC_Pos)
#define SPI_RXCRCR_RXCRC_9                                                 (0x200U << SPI_RXCRCR_RXCRC_Pos)
#define SPI_RXCRCR_RXCRC_10                                                (0x400U << SPI_RXCRCR_RXCRC_Pos)
#define SPI_RXCRCR_RXCRC_11                                                (0x800U << SPI_RXCRCR_RXCRC_Pos)
#define SPI_RXCRCR_RXCRC_12                                                (0x1000U << SPI_RXCRCR_RXCRC_Pos)
#define SPI_RXCRCR_RXCRC_13                                                (0x2000U << SPI_RXCRCR_RXCRC_Pos)
#define SPI_RXCRCR_RXCRC_14                                                (0x4000U << SPI_RXCRCR_RXCRC_Pos)
#define SPI_RXCRCR_RXCRC_15                                                (0x8000U << SPI_RXCRCR_RXCRC_Pos)

/* =====================================================    TXCRCR    ===================================================== */ 
#define SPI_TXCRCR_TXCRC_Pos                                               (0UL)		/*!<SPI TXCRCR: TXCRC (Bit 0) */
#define SPI_TXCRCR_TXCRC_Msk                                               (0xffffUL)		/*!< SPI TXCRCR: TXCRC (Bitfield-Mask: 0xffff) */
#define SPI_TXCRCR_TXCRC                                                   SPI_TXCRCR_TXCRC_Msk
#define SPI_TXCRCR_TXCRC_0                                                 (0x1U << SPI_TXCRCR_TXCRC_Pos)
#define SPI_TXCRCR_TXCRC_1                                                 (0x2U << SPI_TXCRCR_TXCRC_Pos)
#define SPI_TXCRCR_TXCRC_2                                                 (0x4U << SPI_TXCRCR_TXCRC_Pos)
#define SPI_TXCRCR_TXCRC_3                                                 (0x8U << SPI_TXCRCR_TXCRC_Pos)
#define SPI_TXCRCR_TXCRC_4                                                 (0x10U << SPI_TXCRCR_TXCRC_Pos)
#define SPI_TXCRCR_TXCRC_5                                                 (0x20U << SPI_TXCRCR_TXCRC_Pos)
#define SPI_TXCRCR_TXCRC_6                                                 (0x40U << SPI_TXCRCR_TXCRC_Pos)
#define SPI_TXCRCR_TXCRC_7                                                 (0x80U << SPI_TXCRCR_TXCRC_Pos)
#define SPI_TXCRCR_TXCRC_8                                                 (0x100U << SPI_TXCRCR_TXCRC_Pos)
#define SPI_TXCRCR_TXCRC_9                                                 (0x200U << SPI_TXCRCR_TXCRC_Pos)
#define SPI_TXCRCR_TXCRC_10                                                (0x400U << SPI_TXCRCR_TXCRC_Pos)
#define SPI_TXCRCR_TXCRC_11                                                (0x800U << SPI_TXCRCR_TXCRC_Pos)
#define SPI_TXCRCR_TXCRC_12                                                (0x1000U << SPI_TXCRCR_TXCRC_Pos)
#define SPI_TXCRCR_TXCRC_13                                                (0x2000U << SPI_TXCRCR_TXCRC_Pos)
#define SPI_TXCRCR_TXCRC_14                                                (0x4000U << SPI_TXCRCR_TXCRC_Pos)
#define SPI_TXCRCR_TXCRC_15                                                (0x8000U << SPI_TXCRCR_TXCRC_Pos)

/* =====================================================    I2SCFGR    ===================================================== */ 
#define SPI_I2SCFGR_ASTRTEN_Pos                                            (12UL)   /*!<SPI I2SCFGR: ASTRTEN (Bit 12) */
#define SPI_I2SCFGR_ASTRTEN_Msk                                            (0x1000UL)    /*!< SPI I2SCFGR: ASTRTEN (Bitfield-Mask: 0x01) */
#define SPI_I2SCFGR_ASTRTEN                                                SPI_I2SCFGR_ASTRTEN_Msk
#define SPI_I2SCFGR_I2SMOD_Pos                                             (11UL)   /*!<SPI I2SCFGR: I2SMOD (Bit 11) */
#define SPI_I2SCFGR_I2SMOD_Msk                                             (0x800UL)    /*!< SPI I2SCFGR: I2SMOD (Bitfield-Mask: 0x01) */
#define SPI_I2SCFGR_I2SMOD                                                 SPI_I2SCFGR_I2SMOD_Msk
#define SPI_I2SCFGR_I2SE_Pos                                               (10UL)		/*!<SPI I2SCFGR: I2SE (Bit 10) */
#define SPI_I2SCFGR_I2SE_Msk                                               (0x400UL)		/*!< SPI I2SCFGR: I2SE (Bitfield-Mask: 0x01) */
#define SPI_I2SCFGR_I2SE                                                   SPI_I2SCFGR_I2SE_Msk
#define SPI_I2SCFGR_I2SCFG_Pos                                             (8UL)		/*!<SPI I2SCFGR: I2SCFG (Bit 8) */
#define SPI_I2SCFGR_I2SCFG_Msk                                             (0x300UL)		/*!< SPI I2SCFGR: I2SCFG (Bitfield-Mask: 0x03) */
#define SPI_I2SCFGR_I2SCFG                                                 SPI_I2SCFGR_I2SCFG_Msk
#define SPI_I2SCFGR_I2SCFG_0                                               (0x1U << SPI_I2SCFGR_I2SCFG_Pos)
#define SPI_I2SCFGR_I2SCFG_1                                               (0x2U << SPI_I2SCFGR_I2SCFG_Pos)
#define SPI_I2SCFGR_PCMSYNC_Pos                                            (7UL)		/*!<SPI I2SCFGR: PCMSYNC (Bit 7) */
#define SPI_I2SCFGR_PCMSYNC_Msk                                            (0x80UL)		/*!< SPI I2SCFGR: PCMSYNC (Bitfield-Mask: 0x01) */
#define SPI_I2SCFGR_PCMSYNC                                                SPI_I2SCFGR_PCMSYNC_Msk
#define SPI_I2SCFGR_I2SSTD_Pos                                             (4UL)		/*!<SPI I2SCFGR: I2SSTD (Bit 4) */
#define SPI_I2SCFGR_I2SSTD_Msk                                             (0x30UL)		/*!< SPI I2SCFGR: I2SSTD (Bitfield-Mask: 0x03) */
#define SPI_I2SCFGR_I2SSTD                                                 SPI_I2SCFGR_I2SSTD_Msk
#define SPI_I2SCFGR_I2SSTD_0                                               (0x1U << SPI_I2SCFGR_I2SSTD_Pos)
#define SPI_I2SCFGR_I2SSTD_1                                               (0x2U << SPI_I2SCFGR_I2SSTD_Pos)
#define SPI_I2SCFGR_CKPOL_Pos                                              (3UL)		/*!<SPI I2SCFGR: CKPOL (Bit 3) */
#define SPI_I2SCFGR_CKPOL_Msk                                              (0x8UL)		/*!< SPI I2SCFGR: CKPOL (Bitfield-Mask: 0x01) */
#define SPI_I2SCFGR_CKPOL                                                  SPI_I2SCFGR_CKPOL_Msk
#define SPI_I2SCFGR_DATLEN_Pos                                             (1UL)		/*!<SPI I2SCFGR: DATLEN (Bit 1) */
#define SPI_I2SCFGR_DATLEN_Msk                                             (0x6UL)		/*!< SPI I2SCFGR: DATLEN (Bitfield-Mask: 0x03) */
#define SPI_I2SCFGR_DATLEN                                                 SPI_I2SCFGR_DATLEN_Msk
#define SPI_I2SCFGR_DATLEN_0                                               (0x1U << SPI_I2SCFGR_DATLEN_Pos)
#define SPI_I2SCFGR_DATLEN_1                                               (0x2U << SPI_I2SCFGR_DATLEN_Pos)
#define SPI_I2SCFGR_CHLEN_Pos                                              (0UL)		/*!<SPI I2SCFGR: CHLEN (Bit 0) */
#define SPI_I2SCFGR_CHLEN_Msk                                              (0x1UL)		/*!< SPI I2SCFGR: CHLEN (Bitfield-Mask: 0x01) */
#define SPI_I2SCFGR_CHLEN                                                  SPI_I2SCFGR_CHLEN_Msk

/* =====================================================    I2SPR    ===================================================== */ 
#define SPI_I2SPR_MCKOE_Pos                                                (9UL)		/*!<SPI I2SPR: MCKOE (Bit 9) */
#define SPI_I2SPR_MCKOE_Msk                                                (0x200UL)		/*!< SPI I2SPR: MCKOE (Bitfield-Mask: 0x01) */
#define SPI_I2SPR_MCKOE                                                    SPI_I2SPR_MCKOE_Msk
#define SPI_I2SPR_ODD_Pos                                                  (8UL)		/*!<SPI I2SPR: ODD (Bit 8) */
#define SPI_I2SPR_ODD_Msk                                                  (0x100UL)		/*!< SPI I2SPR: ODD (Bitfield-Mask: 0x01) */
#define SPI_I2SPR_ODD                                                      SPI_I2SPR_ODD_Msk
#define SPI_I2SPR_I2SDIV_Pos                                               (0UL)		/*!<SPI I2SPR: I2SDIV (Bit 0) */
#define SPI_I2SPR_I2SDIV_Msk                                               (0xffUL)		/*!< SPI I2SPR: I2SDIV (Bitfield-Mask: 0xff) */
#define SPI_I2SPR_I2SDIV                                                   SPI_I2SPR_I2SDIV_Msk
#define SPI_I2SPR_I2SDIV_0                                                 (0x1U << SPI_I2SPR_I2SDIV_Pos)
#define SPI_I2SPR_I2SDIV_1                                                 (0x2U << SPI_I2SPR_I2SDIV_Pos)
#define SPI_I2SPR_I2SDIV_2                                                 (0x4U << SPI_I2SPR_I2SDIV_Pos)
#define SPI_I2SPR_I2SDIV_3                                                 (0x8U << SPI_I2SPR_I2SDIV_Pos)
#define SPI_I2SPR_I2SDIV_4                                                 (0x10U << SPI_I2SPR_I2SDIV_Pos)
#define SPI_I2SPR_I2SDIV_5                                                 (0x20U << SPI_I2SPR_I2SDIV_Pos)
#define SPI_I2SPR_I2SDIV_6                                                 (0x40U << SPI_I2SPR_I2SDIV_Pos)
#define SPI_I2SPR_I2SDIV_7                                                 (0x80U << SPI_I2SPR_I2SDIV_Pos)

  
/* =========================================================================================================================== */ 
/*=====================                                       RCC                                       ===================== */ 
/* =========================================================================================================================== */ 

/* =====================================================    CR    ===================================================== */ 
#define RCC_CR_HSERDY_Pos                                                  (17UL)		/*!<RCC CR: HSERDY (Bit 17) */
#define RCC_CR_HSERDY_Msk                                                  (0x20000UL)		/*!< RCC CR: HSERDY (Bitfield-Mask: 0x01) */
#define RCC_CR_HSERDY                                                      RCC_CR_HSERDY_Msk
#define RCC_CR_HSEON_Pos                                                   (16UL)		/*!<RCC CR: HSEON (Bit 16) */
#define RCC_CR_HSEON_Msk                                                   (0x10000UL)		/*!< RCC CR: HSEON (Bitfield-Mask: 0x01) */
#define RCC_CR_HSEON                                                       RCC_CR_HSEON_Msk
#define RCC_CR_FMRAT_Pos                                                   (15UL)		/*!<RCC CR: FMRAT (Bit 15) */
#define RCC_CR_FMRAT_Msk                                                   (0x8000UL)		/*!< RCC CR: FMRAT (Bitfield-Mask: 0x01) */
#define RCC_CR_FMRAT                                                       RCC_CR_FMRAT_Msk
#define RCC_CR_HSIPLLRDY_Pos                                               (14UL)		/*!<RCC CR: HSIPLLRDY (Bit 14) */
#define RCC_CR_HSIPLLRDY_Msk                                               (0x4000UL)		/*!< RCC CR: HSIPLLRDY (Bitfield-Mask: 0x01) */
#define RCC_CR_HSIPLLRDY                                                   RCC_CR_HSIPLLRDY_Msk
#define RCC_CR_HSIPLLON_Pos                                                (13UL)		/*!<RCC CR: HSIPLLON (Bit 13) */
#define RCC_CR_HSIPLLON_Msk                                                (0x2000UL)		/*!< RCC CR: HSIPLLON (Bitfield-Mask: 0x01) */
#define RCC_CR_HSIPLLON                                                    RCC_CR_HSIPLLON_Msk
#define RCC_CR_HSEPLLBUFON_Pos                                             (12UL)		/*!<RCC CR: HSEPLLBUFON (Bit 12) */
#define RCC_CR_HSEPLLBUFON_Msk                                             (0x1000UL)		/*!< RCC CR: HSEPLLBUFON (Bitfield-Mask: 0x01) */
#define RCC_CR_HSEPLLBUFON                                                 RCC_CR_HSEPLLBUFON_Msk
#define RCC_CR_HSIRDY_Pos                                                  (10UL)		/*!<RCC CR: HSIRDY (Bit 10) */
#define RCC_CR_HSIRDY_Msk                                                  (0x400UL)		/*!< RCC CR: HSIRDY (Bitfield-Mask: 0x01) */
#define RCC_CR_HSIRDY                                                      RCC_CR_HSIRDY_Msk
#define RCC_CR_LOCKDET_NSTOP_Pos                                           (7UL)		/*!<RCC CR: LOCKDET_NSTOP (Bit 7) */
#define RCC_CR_LOCKDET_NSTOP_Msk                                           (0x380UL)		/*!< RCC CR: LOCKDET_NSTOP (Bitfield-Mask: 0x07) */
#define RCC_CR_LOCKDET_NSTOP                                               RCC_CR_LOCKDET_NSTOP_Msk
#define RCC_CR_LOCKDET_NSTOP_0                                             (0x1U << RCC_CR_LOCKDET_NSTOP_Pos)
#define RCC_CR_LOCKDET_NSTOP_1                                             (0x2U << RCC_CR_LOCKDET_NSTOP_Pos)
#define RCC_CR_LOCKDET_NSTOP_2                                             (0x4U << RCC_CR_LOCKDET_NSTOP_Pos)
#define RCC_CR_LSEBYP_Pos                                                  (6UL)		/*!<RCC CR: LSEBYP (Bit 6) */
#define RCC_CR_LSEBYP_Msk                                                  (0x40UL)		/*!< RCC CR: LSEBYP (Bitfield-Mask: 0x01) */
#define RCC_CR_LSEBYP                                                      RCC_CR_LSEBYP_Msk
#define RCC_CR_LSERDY_Pos                                                  (5UL)		/*!<RCC CR: LSERDY (Bit 5) */
#define RCC_CR_LSERDY_Msk                                                  (0x20UL)		/*!< RCC CR: LSERDY (Bitfield-Mask: 0x01) */
#define RCC_CR_LSERDY                                                      RCC_CR_LSERDY_Msk
#define RCC_CR_LSEON_Pos                                                   (4UL)		/*!<RCC CR: LSEON (Bit 4) */
#define RCC_CR_LSEON_Msk                                                   (0x10UL)		/*!< RCC CR: LSEON (Bitfield-Mask: 0x01) */
#define RCC_CR_LSEON                                                       RCC_CR_LSEON_Msk
#define RCC_CR_LSIRDY_Pos                                                  (3UL)		/*!<RCC CR: LSIRDY (Bit 3) */
#define RCC_CR_LSIRDY_Msk                                                  (0x8UL)		/*!< RCC CR: LSIRDY (Bitfield-Mask: 0x01) */
#define RCC_CR_LSIRDY                                                      RCC_CR_LSIRDY_Msk
#define RCC_CR_LSION_Pos                                                   (2UL)		/*!<RCC CR: LSION (Bit 2) */
#define RCC_CR_LSION_Msk                                                   (0x4UL)		/*!< RCC CR: LSION (Bitfield-Mask: 0x01) */
#define RCC_CR_LSION                                                       RCC_CR_LSION_Msk

/* =====================================================    ICSCR    ===================================================== */ 
#define RCC_ICSCR_HSITRIM_Pos                                              (24UL)		/*!<RCC ICSCR: HSITRIM (Bit 24) */
#define RCC_ICSCR_HSITRIM_Msk                                              (0x3f000000UL)		/*!< RCC ICSCR: HSITRIM (Bitfield-Mask: 0x3f) */
#define RCC_ICSCR_HSITRIM                                                  RCC_ICSCR_HSITRIM_Msk
#define RCC_ICSCR_HSITRIM_0                                                (0x1U << RCC_ICSCR_HSITRIM_Pos)
#define RCC_ICSCR_HSITRIM_1                                                (0x2U << RCC_ICSCR_HSITRIM_Pos)
#define RCC_ICSCR_HSITRIM_2                                                (0x4U << RCC_ICSCR_HSITRIM_Pos)
#define RCC_ICSCR_HSITRIM_3                                                (0x8U << RCC_ICSCR_HSITRIM_Pos)
#define RCC_ICSCR_HSITRIM_4                                                (0x10U << RCC_ICSCR_HSITRIM_Pos)
#define RCC_ICSCR_HSITRIM_5                                                (0x20U << RCC_ICSCR_HSITRIM_Pos)
#define RCC_ICSCR_LSIBW_Pos                                                (2UL)		/*!<RCC ICSCR: LSIBW (Bit 2) */
#define RCC_ICSCR_LSIBW_Msk                                                (0x3cUL)		/*!< RCC ICSCR: LSIBW (Bitfield-Mask: 0x0f) */
#define RCC_ICSCR_LSIBW                                                    RCC_ICSCR_LSIBW_Msk
#define RCC_ICSCR_LSIBW_0                                                  (0x1U << RCC_ICSCR_LSIBW_Pos)
#define RCC_ICSCR_LSIBW_1                                                  (0x2U << RCC_ICSCR_LSIBW_Pos)
#define RCC_ICSCR_LSIBW_2                                                  (0x4U << RCC_ICSCR_LSIBW_Pos)
#define RCC_ICSCR_LSIBW_3                                                  (0x8U << RCC_ICSCR_LSIBW_Pos)
#define RCC_ICSCR_LSITRIMOK_Pos                                            (1UL)		/*!<RCC ICSCR: LSITRIMOK (Bit 1) */
#define RCC_ICSCR_LSITRIMOK_Msk                                            (0x2UL)		/*!< RCC ICSCR: LSITRIMOK (Bitfield-Mask: 0x01) */
#define RCC_ICSCR_LSITRIMOK                                                RCC_ICSCR_LSITRIMOK_Msk
#define RCC_ICSCR_LSITRIMEN_Pos                                            (0UL)		/*!<RCC ICSCR: LSITRIMEN (Bit 0) */
#define RCC_ICSCR_LSITRIMEN_Msk                                            (0x1UL)		/*!< RCC ICSCR: LSITRIMEN (Bitfield-Mask: 0x01) */
#define RCC_ICSCR_LSITRIMEN                                                RCC_ICSCR_LSITRIMEN_Msk

/* =====================================================    CFGR    ===================================================== */ 
#define RCC_CFGR_CCOPRE_Pos                                                (29UL)		/*!<RCC CFGR: CCOPRE (Bit 29) */
#define RCC_CFGR_CCOPRE_Msk                                                (0xe0000000UL)		/*!< RCC CFGR: CCOPRE (Bitfield-Mask: 0x07) */
#define RCC_CFGR_CCOPRE                                                    RCC_CFGR_CCOPRE_Msk
#define RCC_CFGR_CCOPRE_0                                                  (0x1U << RCC_CFGR_CCOPRE_Pos)
#define RCC_CFGR_CCOPRE_1                                                  (0x2U << RCC_CFGR_CCOPRE_Pos)
#define RCC_CFGR_CCOPRE_2                                                  (0x4U << RCC_CFGR_CCOPRE_Pos)
#define RCC_CFGR_MCOSEL_Pos                                                (26UL)		/*!<RCC CFGR: MCOSEL (Bit 26) */
#define RCC_CFGR_MCOSEL_Msk                                                (0x1c000000UL)		/*!< RCC CFGR: MCOSEL (Bitfield-Mask: 0x07) */
#define RCC_CFGR_MCOSEL                                                    RCC_CFGR_MCOSEL_Msk
#define RCC_CFGR_MCOSEL_0                                                  (0x1U << RCC_CFGR_MCOSEL_Pos)
#define RCC_CFGR_MCOSEL_1                                                  (0x2U << RCC_CFGR_MCOSEL_Pos)
#define RCC_CFGR_MCOSEL_2                                                  (0x4U << RCC_CFGR_MCOSEL_Pos)
#define RCC_CFGR_LCOSEL_Pos                                                (24UL)		/*!<RCC CFGR: LCOSEL (Bit 24) */
#define RCC_CFGR_LCOSEL_Msk                                                (0x3000000UL)		/*!< RCC CFGR: LCOSEL (Bitfield-Mask: 0x03) */
#define RCC_CFGR_LCOSEL                                                    RCC_CFGR_LCOSEL_Msk
#define RCC_CFGR_LCOSEL_0                                                  (0x1U << RCC_CFGR_LCOSEL_Pos)
#define RCC_CFGR_LCOSEL_1                                                  (0x2U << RCC_CFGR_LCOSEL_Pos)
#define RCC_CFGR_SPI2I2SCLKSEL_Pos                                         (23UL)		/*!<RCC CFGR: SPI2I2SCLKSEL (Bit 23) */
#define RCC_CFGR_SPI2I2SCLKSEL_Msk                                         (0x800000UL)		/*!< RCC CFGR: SPI2I2SCLKSEL (Bitfield-Mask: 0x01) */
#define RCC_CFGR_SPI2I2SCLKSEL                                             RCC_CFGR_SPI2I2SCLKSEL_Msk
#define RCC_CFGR_SPI3I2SCLKSEL_Pos                                         (22UL)		/*!<RCC CFGR: SPI3I2SCLKSEL (Bit 22) */
#define RCC_CFGR_SPI3I2SCLKSEL_Msk                                         (0x400000UL)		/*!< RCC CFGR: SPI3I2SCLKSEL (Bitfield-Mask: 0x01) */
#define RCC_CFGR_SPI3I2SCLKSEL                                             RCC_CFGR_SPI3I2SCLKSEL_Msk
#define RCC_CFGR_IOBOOSTEN_Pos                                             (17UL)		/*!<RCC CFGR: IOBOOSTEN (Bit 17) */
#define RCC_CFGR_IOBOOSTEN_Msk                                             (0x20000UL)		/*!< RCC CFGR: IOBOOSTEN (Bitfield-Mask: 0x01) */
#define RCC_CFGR_IOBOOSTEN                                                 RCC_CFGR_IOBOOSTEN_Msk
#define RCC_CFGR_CLKSLOWSEL_Pos                                            (15UL)		/*!<RCC CFGR: CLKSLOWSEL (Bit 15) */
#define RCC_CFGR_CLKSLOWSEL_Msk                                            (0x18000UL)		/*!< RCC CFGR: CLKSLOWSEL (Bitfield-Mask: 0x03) */
#define RCC_CFGR_CLKSLOWSEL                                                RCC_CFGR_CLKSLOWSEL_Msk
#define RCC_CFGR_CLKSLOWSEL_0                                              (0x1U << RCC_CFGR_CLKSLOWSEL_Pos)
#define RCC_CFGR_CLKSLOWSEL_1                                              (0x2U << RCC_CFGR_CLKSLOWSEL_Pos)
#define RCC_CFGR_SMPSDIV_Pos                                               (12UL)		/*!<RCC CFGR: SMPSDIV (Bit 12) */
#define RCC_CFGR_SMPSDIV_Msk                                               (0x1000UL)		/*!< RCC CFGR: SMPSDIV (Bitfield-Mask: 0x01) */
#define RCC_CFGR_SMPSDIV                                                   RCC_CFGR_SMPSDIV_Msk
#define RCC_CFGR_ANADIV_Pos                                                (10UL)		/*!<RCC CFGR: ANADIV (Bit 10) */
#define RCC_CFGR_ANADIV_Msk                                                (0xc00UL)		/*!< RCC CFGR: ANADIV (Bitfield-Mask: 0x03) */
#define RCC_CFGR_ANADIV                                                    RCC_CFGR_ANADIV_Msk
#define RCC_CFGR_ANADIV_0                                                  (0x1U << RCC_CFGR_ANADIV_Pos)
#define RCC_CFGR_ANADIV_1                                                  (0x2U << RCC_CFGR_ANADIV_Pos)
#define RCC_CFGR_CLKSYSDIV_Pos                                             (5UL)		/*!<RCC CFGR: CLKSYSDIV (Bit 5) */
#define RCC_CFGR_CLKSYSDIV_Msk                                             (0xe0UL)		/*!< RCC CFGR: CLKSYSDIV (Bitfield-Mask: 0x07) */
#define RCC_CFGR_CLKSYSDIV                                                 RCC_CFGR_CLKSYSDIV_Msk
#define RCC_CFGR_CLKSYSDIV_0                                               (0x1U << RCC_CFGR_CLKSYSDIV_Pos)
#define RCC_CFGR_CLKSYSDIV_1                                               (0x2U << RCC_CFGR_CLKSYSDIV_Pos)
#define RCC_CFGR_CLKSYSDIV_2                                               (0x4U << RCC_CFGR_CLKSYSDIV_Pos)
#define RCC_CFGR_STOPHSI_Pos                                               (2UL)		/*!<RCC CFGR: STOPHSI (Bit 2) */
#define RCC_CFGR_STOPHSI_Msk                                               (0x4UL)		/*!< RCC CFGR: STOPHSI (Bitfield-Mask: 0x01) */
#define RCC_CFGR_STOPHSI                                                   RCC_CFGR_STOPHSI_Msk
#define RCC_CFGR_HSESEL_Pos                                                (1UL)		/*!<RCC CFGR: HSESEL (Bit 1) */
#define RCC_CFGR_HSESEL_Msk                                                (0x2UL)		/*!< RCC CFGR: HSESEL (Bitfield-Mask: 0x01) */
#define RCC_CFGR_HSESEL                                                    RCC_CFGR_HSESEL_Msk
#define RCC_CFGR_SMPSINV_Pos                                               (0UL)		/*!<RCC CFGR: SMPSINV (Bit 0) */
#define RCC_CFGR_SMPSINV_Msk                                               (0x1UL)		/*!< RCC CFGR: SMPSINV (Bitfield-Mask: 0x01) */
#define RCC_CFGR_SMPSINV                                                   RCC_CFGR_SMPSINV_Msk

/* =====================================================    CSSWCR    ===================================================== */ 
#define RCC_CSSWCR_HSITRIMSW_Pos                                           (24UL)		/*!<RCC CSSWCR: HSITRIMSW (Bit 24) */
#define RCC_CSSWCR_HSITRIMSW_Msk                                           (0x3f000000UL)		/*!< RCC CSSWCR: HSITRIMSW (Bitfield-Mask: 0x3f) */
#define RCC_CSSWCR_HSITRIMSW                                               RCC_CSSWCR_HSITRIMSW_Msk
#define RCC_CSSWCR_HSITRIMSW_0                                             (0x1U << RCC_CSSWCR_HSITRIMSW_Pos)
#define RCC_CSSWCR_HSITRIMSW_1                                             (0x2U << RCC_CSSWCR_HSITRIMSW_Pos)
#define RCC_CSSWCR_HSITRIMSW_2                                             (0x4U << RCC_CSSWCR_HSITRIMSW_Pos)
#define RCC_CSSWCR_HSITRIMSW_3                                             (0x8U << RCC_CSSWCR_HSITRIMSW_Pos)
#define RCC_CSSWCR_HSITRIMSW_4                                             (0x10U << RCC_CSSWCR_HSITRIMSW_Pos)
#define RCC_CSSWCR_HSITRIMSW_5                                             (0x20U << RCC_CSSWCR_HSITRIMSW_Pos)
#define RCC_CSSWCR_HSISWTRIMEN_Pos                                         (23UL)		/*!<RCC CSSWCR: HSISWTRIMEN (Bit 23) */
#define RCC_CSSWCR_HSISWTRIMEN_Msk                                         (0x800000UL)		/*!< RCC CSSWCR: HSISWTRIMEN (Bitfield-Mask: 0x01) */
#define RCC_CSSWCR_HSISWTRIMEN                                             RCC_CSSWCR_HSISWTRIMEN_Msk
#define RCC_CSSWCR_LSEDRV_Pos                                              (5UL)		/*!<RCC CSSWCR: LSEDRV (Bit 5) */
#define RCC_CSSWCR_LSEDRV_Msk                                              (0x60UL)		/*!< RCC CSSWCR: LSEDRV (Bitfield-Mask: 0x03) */
#define RCC_CSSWCR_LSEDRV                                                  RCC_CSSWCR_LSEDRV_Msk
#define RCC_CSSWCR_LSEDRV_0                                                (0x1U << RCC_CSSWCR_LSEDRV_Pos)
#define RCC_CSSWCR_LSEDRV_1                                                (0x2U << RCC_CSSWCR_LSEDRV_Pos)
#define RCC_CSSWCR_LSISWBW_Pos                                             (1UL)		/*!<RCC CSSWCR: LSISWBW (Bit 1) */
#define RCC_CSSWCR_LSISWBW_Msk                                             (0x1eUL)		/*!< RCC CSSWCR: LSISWBW (Bitfield-Mask: 0x0f) */
#define RCC_CSSWCR_LSISWBW                                                 RCC_CSSWCR_LSISWBW_Msk
#define RCC_CSSWCR_LSISWBW_0                                               (0x1U << RCC_CSSWCR_LSISWBW_Pos)
#define RCC_CSSWCR_LSISWBW_1                                               (0x2U << RCC_CSSWCR_LSISWBW_Pos)
#define RCC_CSSWCR_LSISWBW_2                                               (0x4U << RCC_CSSWCR_LSISWBW_Pos)
#define RCC_CSSWCR_LSISWBW_3                                               (0x8U << RCC_CSSWCR_LSISWBW_Pos)
#define RCC_CSSWCR_LSISWTRIMEN_Pos                                         (0UL)		/*!<RCC CSSWCR: LSISWTRIMEN (Bit 0) */
#define RCC_CSSWCR_LSISWTRIMEN_Msk                                         (0x1UL)		/*!< RCC CSSWCR: LSISWTRIMEN (Bitfield-Mask: 0x01) */
#define RCC_CSSWCR_LSISWTRIMEN                                             RCC_CSSWCR_LSISWTRIMEN_Msk

/* =====================================================    CIER    ===================================================== */ 
#define RCC_CIER_WDGRSTIE_Pos                                              (8UL)		/*!<RCC CIER: WDGRSTIE (Bit 8) */
#define RCC_CIER_WDGRSTIE_Msk                                              (0x100UL)		/*!< RCC CIER: WDGRSTIE (Bitfield-Mask: 0x01) */
#define RCC_CIER_WDGRSTIE                                                  RCC_CIER_WDGRSTIE_Msk
#define RCC_CIER_RTCRSTIE_Pos                                              (7UL)		/*!<RCC CIER: RTCRSTIE (Bit 7) */
#define RCC_CIER_RTCRSTIE_Msk                                              (0x80UL)		/*!< RCC CIER: RTCRSTIE (Bitfield-Mask: 0x01) */
#define RCC_CIER_RTCRSTIE                                                  RCC_CIER_RTCRSTIE_Msk
#define RCC_CIER_HSIPLLUNLOCKDETIE_Pos                                     (6UL)		/*!<RCC CIER: HSIPLLUNLOCKDETIE (Bit 6) */
#define RCC_CIER_HSIPLLUNLOCKDETIE_Msk                                     (0x40UL)		/*!< RCC CIER: HSIPLLUNLOCKDETIE (Bitfield-Mask: 0x01) */
#define RCC_CIER_HSIPLLUNLOCKDETIE                                         RCC_CIER_HSIPLLUNLOCKDETIE_Msk
#define RCC_CIER_HSIPLLRDYIE_Pos                                           (5UL)		/*!<RCC CIER: HSIPLLRDYIE (Bit 5) */
#define RCC_CIER_HSIPLLRDYIE_Msk                                           (0x20UL)		/*!< RCC CIER: HSIPLLRDYIE (Bitfield-Mask: 0x01) */
#define RCC_CIER_HSIPLLRDYIE                                               RCC_CIER_HSIPLLRDYIE_Msk
#define RCC_CIER_HSERDYIE_Pos                                              (4UL)		/*!<RCC CIER: HSERDYIE (Bit 4) */
#define RCC_CIER_HSERDYIE_Msk                                              (0x10UL)		/*!< RCC CIER: HSERDYIE (Bitfield-Mask: 0x01) */
#define RCC_CIER_HSERDYIE                                                  RCC_CIER_HSERDYIE_Msk
#define RCC_CIER_HSIRDYIE_Pos                                              (3UL)		/*!<RCC CIER: HSIRDYIE (Bit 3) */
#define RCC_CIER_HSIRDYIE_Msk                                              (0x8UL)		/*!< RCC CIER: HSIRDYIE (Bitfield-Mask: 0x01) */
#define RCC_CIER_HSIRDYIE                                                  RCC_CIER_HSIRDYIE_Msk
#define RCC_CIER_LSERDYIE_Pos                                              (1UL)		/*!<RCC CIER: LSERDYIE (Bit 1) */
#define RCC_CIER_LSERDYIE_Msk                                              (0x2UL)		/*!< RCC CIER: LSERDYIE (Bitfield-Mask: 0x01) */
#define RCC_CIER_LSERDYIE                                                  RCC_CIER_LSERDYIE_Msk
#define RCC_CIER_LSIRDYIE_Pos                                              (0UL)		/*!<RCC CIER: LSIRDYIE (Bit 0) */
#define RCC_CIER_LSIRDYIE_Msk                                              (0x1UL)		/*!< RCC CIER: LSIRDYIE (Bitfield-Mask: 0x01) */
#define RCC_CIER_LSIRDYIE                                                  RCC_CIER_LSIRDYIE_Msk

/* =====================================================    CIFR    ===================================================== */ 
#define RCC_CIFR_WDGRSTF_Pos                                               (8UL)		/*!<RCC CIFR: WDGRSTF (Bit 8) */
#define RCC_CIFR_WDGRSTF_Msk                                               (0x100UL)		/*!< RCC CIFR: WDGRSTF (Bitfield-Mask: 0x01) */
#define RCC_CIFR_WDGRSTF                                                   RCC_CIFR_WDGRSTF_Msk
#define RCC_CIFR_RTCRSTF_Pos                                               (7UL)		/*!<RCC CIFR: RTCRSTF (Bit 7) */
#define RCC_CIFR_RTCRSTF_Msk                                               (0x80UL)		/*!< RCC CIFR: RTCRSTF (Bitfield-Mask: 0x01) */
#define RCC_CIFR_RTCRSTF                                                   RCC_CIFR_RTCRSTF_Msk
#define RCC_CIFR_HSIPLLUNLOCKDETF_Pos                                      (6UL)		/*!<RCC CIFR: HSIPLLUNLOCKDETF (Bit 6) */
#define RCC_CIFR_HSIPLLUNLOCKDETF_Msk                                      (0x40UL)		/*!< RCC CIFR: HSIPLLUNLOCKDETF (Bitfield-Mask: 0x01) */
#define RCC_CIFR_HSIPLLUNLOCKDETF                                          RCC_CIFR_HSIPLLUNLOCKDETF_Msk
#define RCC_CIFR_HSIPLLRDYF_Pos                                            (5UL)		/*!<RCC CIFR: HSIPLLRDYF (Bit 5) */
#define RCC_CIFR_HSIPLLRDYF_Msk                                            (0x20UL)		/*!< RCC CIFR: HSIPLLRDYF (Bitfield-Mask: 0x01) */
#define RCC_CIFR_HSIPLLRDYF                                                RCC_CIFR_HSIPLLRDYF_Msk
#define RCC_CIFR_HSERDYF_Pos                                               (4UL)		/*!<RCC CIFR: HSERDYF (Bit 4) */
#define RCC_CIFR_HSERDYF_Msk                                               (0x10UL)		/*!< RCC CIFR: HSERDYF (Bitfield-Mask: 0x01) */
#define RCC_CIFR_HSERDYF                                                   RCC_CIFR_HSERDYF_Msk
#define RCC_CIFR_HSIRDYF_Pos                                               (3UL)		/*!<RCC CIFR: HSIRDYF (Bit 3) */
#define RCC_CIFR_HSIRDYF_Msk                                               (0x8UL)		/*!< RCC CIFR: HSIRDYF (Bitfield-Mask: 0x01) */
#define RCC_CIFR_HSIRDYF                                                   RCC_CIFR_HSIRDYF_Msk
#define RCC_CIFR_LSERDYF_Pos                                               (1UL)		/*!<RCC CIFR: LSERDYF (Bit 1) */
#define RCC_CIFR_LSERDYF_Msk                                               (0x2UL)		/*!< RCC CIFR: LSERDYF (Bitfield-Mask: 0x01) */
#define RCC_CIFR_LSERDYF                                                   RCC_CIFR_LSERDYF_Msk
#define RCC_CIFR_LSIRDYF_Pos                                               (0UL)		/*!<RCC CIFR: LSIRDYF (Bit 0) */
#define RCC_CIFR_LSIRDYF_Msk                                               (0x1UL)		/*!< RCC CIFR: LSIRDYF (Bitfield-Mask: 0x01) */
#define RCC_CIFR_LSIRDYF                                                   RCC_CIFR_LSIRDYF_Msk

/* =====================================================    CSCMDR    ===================================================== */ 
#define RCC_CSCMDR_EOFSEQ_IRQ_Pos                                          (7UL)		/*!<RCC CSCMDR: EOFSEQ_IRQ (Bit 7) */
#define RCC_CSCMDR_EOFSEQ_IRQ_Msk                                          (0x80UL)		/*!< RCC CSCMDR: EOFSEQ_IRQ (Bitfield-Mask: 0x01) */
#define RCC_CSCMDR_EOFSEQ_IRQ                                              RCC_CSCMDR_EOFSEQ_IRQ_Msk
#define RCC_CSCMDR_EOFSEQ_IE_Pos                                           (6UL)		/*!<RCC CSCMDR: EOFSEQ_IE (Bit 6) */
#define RCC_CSCMDR_EOFSEQ_IE_Msk                                           (0x40UL)		/*!< RCC CSCMDR: EOFSEQ_IE (Bitfield-Mask: 0x01) */
#define RCC_CSCMDR_EOFSEQ_IE                                               RCC_CSCMDR_EOFSEQ_IE_Msk
#define RCC_CSCMDR_STATUS_Pos                                              (4UL)		/*!<RCC CSCMDR: STATUS (Bit 4) */
#define RCC_CSCMDR_STATUS_Msk                                              (0x30UL)		/*!< RCC CSCMDR: STATUS (Bitfield-Mask: 0x03) */
#define RCC_CSCMDR_STATUS                                                  RCC_CSCMDR_STATUS_Msk
#define RCC_CSCMDR_STATUS_0                                                (0x1U << RCC_CSCMDR_STATUS_Pos)
#define RCC_CSCMDR_STATUS_1                                                (0x2U << RCC_CSCMDR_STATUS_Pos)
#define RCC_CSCMDR_CLKSYSDIV_REQ_Pos                                       (1UL)		/*!<RCC CSCMDR: CLKSYSDIV_REQ (Bit 1) */
#define RCC_CSCMDR_CLKSYSDIV_REQ_Msk                                       (0xeUL)		/*!< RCC CSCMDR: CLKSYSDIV_REQ (Bitfield-Mask: 0x07) */
#define RCC_CSCMDR_CLKSYSDIV_REQ                                           RCC_CSCMDR_CLKSYSDIV_REQ_Msk
#define RCC_CSCMDR_CLKSYSDIV_REQ_0                                         (0x1U << RCC_CSCMDR_CLKSYSDIV_REQ_Pos)
#define RCC_CSCMDR_CLKSYSDIV_REQ_1                                         (0x2U << RCC_CSCMDR_CLKSYSDIV_REQ_Pos)
#define RCC_CSCMDR_CLKSYSDIV_REQ_2                                         (0x4U << RCC_CSCMDR_CLKSYSDIV_REQ_Pos)
#define RCC_CSCMDR_REQUEST_Pos                                             (0UL)		/*!<RCC CSCMDR: REQUEST (Bit 0) */
#define RCC_CSCMDR_REQUEST_Msk                                             (0x1UL)		/*!< RCC CSCMDR: REQUEST (Bitfield-Mask: 0x01) */
#define RCC_CSCMDR_REQUEST                                                 RCC_CSCMDR_REQUEST_Msk

/* =====================================================    AHBRSTR    ===================================================== */ 
#define RCC_AHBRSTR_RNGRST_Pos                                             (18UL)		/*!<RCC AHBRSTR: RNGRST (Bit 18) */
#define RCC_AHBRSTR_RNGRST_Msk                                             (0x40000UL)		/*!< RCC AHBRSTR: RNGRST (Bitfield-Mask: 0x01) */
#define RCC_AHBRSTR_RNGRST                                                 RCC_AHBRSTR_RNGRST_Msk
#define RCC_AHBRSTR_PKARST_Pos                                             (16UL)		/*!<RCC AHBRSTR: PKARST (Bit 16) */
#define RCC_AHBRSTR_PKARST_Msk                                             (0x10000UL)		/*!< RCC AHBRSTR: PKARST (Bitfield-Mask: 0x01) */
#define RCC_AHBRSTR_PKARST                                                 RCC_AHBRSTR_PKARST_Msk
#define RCC_AHBRSTR_CRCRST_Pos                                             (12UL)		/*!<RCC AHBRSTR: CRCRST (Bit 12) */
#define RCC_AHBRSTR_CRCRST_Msk                                             (0x1000UL)		/*!< RCC AHBRSTR: CRCRST (Bitfield-Mask: 0x01) */
#define RCC_AHBRSTR_CRCRST                                                 RCC_AHBRSTR_CRCRST_Msk
#define RCC_AHBRSTR_GPIOBRST_Pos                                           (3UL)		/*!<RCC AHBRSTR: GPIOBRST (Bit 3) */
#define RCC_AHBRSTR_GPIOBRST_Msk                                           (0x8UL)		/*!< RCC AHBRSTR: GPIOBRST (Bitfield-Mask: 0x01) */
#define RCC_AHBRSTR_GPIOBRST                                               RCC_AHBRSTR_GPIOBRST_Msk
#define RCC_AHBRSTR_GPIOARST_Pos                                           (2UL)		/*!<RCC AHBRSTR: GPIOARST (Bit 2) */
#define RCC_AHBRSTR_GPIOARST_Msk                                           (0x4UL)		/*!< RCC AHBRSTR: GPIOARST (Bitfield-Mask: 0x01) */
#define RCC_AHBRSTR_GPIOARST                                               RCC_AHBRSTR_GPIOARST_Msk
#define RCC_AHBRSTR_DMARST_Pos                                             (0UL)		/*!<RCC AHBRSTR: DMARST (Bit 0) */
#define RCC_AHBRSTR_DMARST_Msk                                             (0x1UL)		/*!< RCC AHBRSTR: DMARST (Bitfield-Mask: 0x01) */
#define RCC_AHBRSTR_DMARST                                                 RCC_AHBRSTR_DMARST_Msk

/* =====================================================    APB0RSTR    ===================================================== */ 
#define RCC_APB0RSTR_WDGRST_Pos                                            (14UL)		/*!<RCC APB0RSTR: WDGRST (Bit 14) */
#define RCC_APB0RSTR_WDGRST_Msk                                            (0x4000UL)		/*!< RCC APB0RSTR: WDGRST (Bitfield-Mask: 0x01) */
#define RCC_APB0RSTR_WDGRST                                                RCC_APB0RSTR_WDGRST_Msk
#define RCC_APB0RSTR_RTCRST_Pos                                            (12UL)		/*!<RCC APB0RSTR: RTCRST (Bit 12) */
#define RCC_APB0RSTR_RTCRST_Msk                                            (0x1000UL)		/*!< RCC APB0RSTR: RTCRST (Bitfield-Mask: 0x01) */
#define RCC_APB0RSTR_RTCRST                                                RCC_APB0RSTR_RTCRST_Msk
#define RCC_APB0RSTR_SYSCFGRST_Pos                                         (8UL)		/*!<RCC APB0RSTR: SYSCFGRST (Bit 8) */
#define RCC_APB0RSTR_SYSCFGRST_Msk                                         (0x100UL)		/*!< RCC APB0RSTR: SYSCFGRST (Bitfield-Mask: 0x01) */
#define RCC_APB0RSTR_SYSCFGRST                                             RCC_APB0RSTR_SYSCFGRST_Msk
#define RCC_APB0RSTR_TIM1RST_Pos                                           (0UL)		/*!<RCC APB0RSTR: TIM1RST (Bit 0) */
#define RCC_APB0RSTR_TIM1RST_Msk                                           (0x1UL)		/*!< RCC APB0RSTR: TIM1RST (Bitfield-Mask: 0x01) */
#define RCC_APB0RSTR_TIM1RST                                               RCC_APB0RSTR_TIM1RST_Msk

/* =====================================================    APB1RSTR    ===================================================== */ 
#define RCC_APB1RSTR_I2C2RST_Pos                                           (23UL)		/*!<RCC APB1RSTR: I2C2RST (Bit 23) */
#define RCC_APB1RSTR_I2C2RST_Msk                                           (0x800000UL)		/*!< RCC APB1RSTR: I2C2RST (Bitfield-Mask: 0x01) */
#define RCC_APB1RSTR_I2C2RST                                               RCC_APB1RSTR_I2C2RST_Msk
#define RCC_APB1RSTR_I2C1RST_Pos                                           (21UL)		/*!<RCC APB1RSTR: I2C1RST (Bit 21) */
#define RCC_APB1RSTR_I2C1RST_Msk                                           (0x200000UL)		/*!< RCC APB1RSTR: I2C1RST (Bitfield-Mask: 0x01) */
#define RCC_APB1RSTR_I2C1RST                                               RCC_APB1RSTR_I2C1RST_Msk
#define RCC_APB1RSTR_SPI3RST_Pos                                           (14UL)		/*!<RCC APB1RSTR: SPI3RST (Bit 14) */
#define RCC_APB1RSTR_SPI3RST_Msk                                           (0x4000UL)		/*!< RCC APB1RSTR: SPI3RST (Bitfield-Mask: 0x01) */
#define RCC_APB1RSTR_SPI3RST                                               RCC_APB1RSTR_SPI3RST_Msk
#define RCC_APB1RSTR_SPI2RST_Pos                                           (12UL)		/*!<RCC APB1RSTR: SPI2RST (Bit 12) */
#define RCC_APB1RSTR_SPI2RST_Msk                                           (0x1000UL)		/*!< RCC APB1RSTR: SPI2RST (Bitfield-Mask: 0x01) */
#define RCC_APB1RSTR_SPI2RST                                               RCC_APB1RSTR_SPI2RST_Msk
#define RCC_APB1RSTR_USARTRST_Pos                                          (10UL)		/*!<RCC APB1RSTR: USARTRST (Bit 10) */
#define RCC_APB1RSTR_USARTRST_Msk                                          (0x400UL)		/*!< RCC APB1RSTR: USARTRST (Bitfield-Mask: 0x01) */
#define RCC_APB1RSTR_USARTRST                                              RCC_APB1RSTR_USARTRST_Msk
#define RCC_APB1RSTR_LPUARTRST_Pos                                         (8UL)		/*!<RCC APB1RSTR: LPUARTRST (Bit 8) */
#define RCC_APB1RSTR_LPUARTRST_Msk                                         (0x100UL)		/*!< RCC APB1RSTR: LPUARTRST (Bitfield-Mask: 0x01) */
#define RCC_APB1RSTR_LPUARTRST                                             RCC_APB1RSTR_LPUARTRST_Msk
#define RCC_APB1RSTR_ADCRST_Pos                                            (4UL)		/*!<RCC APB1RSTR: ADCRST (Bit 4) */
#define RCC_APB1RSTR_ADCRST_Msk                                            (0x10UL)		/*!< RCC APB1RSTR: ADCRST (Bitfield-Mask: 0x01) */
#define RCC_APB1RSTR_ADCRST                                                RCC_APB1RSTR_ADCRST_Msk
#define RCC_APB1RSTR_SPI1RST_Pos                                           (0UL)		/*!<RCC APB1RSTR: SPI1RST (Bit 0) */
#define RCC_APB1RSTR_SPI1RST_Msk                                           (0x1UL)		/*!< RCC APB1RSTR: SPI1RST (Bitfield-Mask: 0x01) */
#define RCC_APB1RSTR_SPI1RST                                               RCC_APB1RSTR_SPI1RST_Msk

/* =====================================================    APB2RSTR    ===================================================== */ 
#define RCC_APB2RSTR_MRBLERST_Pos                                          (0UL)		/*!<RCC APB2RSTR: MRBLERST (Bit 0) */
#define RCC_APB2RSTR_MRBLERST_Msk                                          (0x1UL)		/*!< RCC APB2RSTR: MRBLERST (Bitfield-Mask: 0x01) */
#define RCC_APB2RSTR_MRBLERST                                              RCC_APB2RSTR_MRBLERST_Msk

/* =====================================================    AHBENR    ===================================================== */ 
#define RCC_AHBENR_RNGEN_Pos                                               (18UL)		/*!<RCC AHBENR: RNGEN (Bit 18) */
#define RCC_AHBENR_RNGEN_Msk                                               (0x40000UL)		/*!< RCC AHBENR: RNGEN (Bitfield-Mask: 0x01) */
#define RCC_AHBENR_RNGEN                                                   RCC_AHBENR_RNGEN_Msk
#define RCC_AHBENR_PKAEN_Pos                                               (16UL)		/*!<RCC AHBENR: PKAEN (Bit 16) */
#define RCC_AHBENR_PKAEN_Msk                                               (0x10000UL)		/*!< RCC AHBENR: PKAEN (Bitfield-Mask: 0x01) */
#define RCC_AHBENR_PKAEN                                                   RCC_AHBENR_PKAEN_Msk
#define RCC_AHBENR_CRCEN_Pos                                               (12UL)		/*!<RCC AHBENR: CRCEN (Bit 12) */
#define RCC_AHBENR_CRCEN_Msk                                               (0x1000UL)		/*!< RCC AHBENR: CRCEN (Bitfield-Mask: 0x01) */
#define RCC_AHBENR_CRCEN                                                   RCC_AHBENR_CRCEN_Msk
#define RCC_AHBENR_GPIOBEN_Pos                                             (3UL)		/*!<RCC AHBENR: GPIOBEN (Bit 3) */
#define RCC_AHBENR_GPIOBEN_Msk                                             (0x8UL)		/*!< RCC AHBENR: GPIOBEN (Bitfield-Mask: 0x01) */
#define RCC_AHBENR_GPIOBEN                                                 RCC_AHBENR_GPIOBEN_Msk
#define RCC_AHBENR_GPIOAEN_Pos                                             (2UL)		/*!<RCC AHBENR: GPIOAEN (Bit 2) */
#define RCC_AHBENR_GPIOAEN_Msk                                             (0x4UL)		/*!< RCC AHBENR: GPIOAEN (Bitfield-Mask: 0x01) */
#define RCC_AHBENR_GPIOAEN                                                 RCC_AHBENR_GPIOAEN_Msk
#define RCC_AHBENR_DMAEN_Pos                                               (0UL)		/*!<RCC AHBENR: DMAEN (Bit 0) */
#define RCC_AHBENR_DMAEN_Msk                                               (0x1UL)		/*!< RCC AHBENR: DMAEN (Bitfield-Mask: 0x01) */
#define RCC_AHBENR_DMAEN                                                   RCC_AHBENR_DMAEN_Msk

/* =====================================================    APB0ENR    ===================================================== */ 
#define RCC_APB0ENR_WDGEN_Pos                                              (14UL)		/*!<RCC APB0ENR: WDGEN (Bit 14) */
#define RCC_APB0ENR_WDGEN_Msk                                              (0x4000UL)		/*!< RCC APB0ENR: WDGEN (Bitfield-Mask: 0x01) */
#define RCC_APB0ENR_WDGEN                                                  RCC_APB0ENR_WDGEN_Msk
#define RCC_APB0ENR_RTCEN_Pos                                              (12UL)		/*!<RCC APB0ENR: RTCEN (Bit 12) */
#define RCC_APB0ENR_RTCEN_Msk                                              (0x1000UL)		/*!< RCC APB0ENR: RTCEN (Bitfield-Mask: 0x01) */
#define RCC_APB0ENR_RTCEN                                                  RCC_APB0ENR_RTCEN_Msk
#define RCC_APB0ENR_SYSCFGEN_Pos                                           (8UL)		/*!<RCC APB0ENR: SYSCFGEN (Bit 8) */
#define RCC_APB0ENR_SYSCFGEN_Msk                                           (0x100UL)		/*!< RCC APB0ENR: SYSCFGEN (Bitfield-Mask: 0x01) */
#define RCC_APB0ENR_SYSCFGEN                                               RCC_APB0ENR_SYSCFGEN_Msk
#define RCC_APB0ENR_TIM1EN_Pos                                             (0UL)		/*!<RCC APB0ENR: TIM1EN (Bit 0) */
#define RCC_APB0ENR_TIM1EN_Msk                                             (0x1UL)		/*!< RCC APB0ENR: TIM1EN (Bitfield-Mask: 0x01) */
#define RCC_APB0ENR_TIM1EN                                                 RCC_APB0ENR_TIM1EN_Msk

/* =====================================================    APB1ENR    ===================================================== */ 
#define RCC_APB1ENR_I2C2EN_Pos                                             (23UL)		/*!<RCC APB1ENR: I2C2EN (Bit 23) */
#define RCC_APB1ENR_I2C2EN_Msk                                             (0x800000UL)		/*!< RCC APB1ENR: I2C2EN (Bitfield-Mask: 0x01) */
#define RCC_APB1ENR_I2C2EN                                                 RCC_APB1ENR_I2C2EN_Msk
#define RCC_APB1ENR_I2C1EN_Pos                                             (21UL)		/*!<RCC APB1ENR: I2C1EN (Bit 21) */
#define RCC_APB1ENR_I2C1EN_Msk                                             (0x200000UL)		/*!< RCC APB1ENR: I2C1EN (Bitfield-Mask: 0x01) */
#define RCC_APB1ENR_I2C1EN                                                 RCC_APB1ENR_I2C1EN_Msk
#define RCC_APB1ENR_SPI3EN_Pos                                             (14UL)		/*!<RCC APB1ENR: SPI3EN (Bit 14) */
#define RCC_APB1ENR_SPI3EN_Msk                                             (0x4000UL)		/*!< RCC APB1ENR: SPI3EN (Bitfield-Mask: 0x01) */
#define RCC_APB1ENR_SPI3EN                                                 RCC_APB1ENR_SPI3EN_Msk
#define RCC_APB1ENR_SPI2EN_Pos                                             (12UL)		/*!<RCC APB1ENR: SPI2EN (Bit 12) */
#define RCC_APB1ENR_SPI2EN_Msk                                             (0x1000UL)		/*!< RCC APB1ENR: SPI2EN (Bitfield-Mask: 0x01) */
#define RCC_APB1ENR_SPI2EN                                                 RCC_APB1ENR_SPI2EN_Msk
#define RCC_APB1ENR_USARTEN_Pos                                            (10UL)		/*!<RCC APB1ENR: USARTEN (Bit 10) */
#define RCC_APB1ENR_USARTEN_Msk                                            (0x400UL)		/*!< RCC APB1ENR: USARTEN (Bitfield-Mask: 0x01) */
#define RCC_APB1ENR_USARTEN                                                RCC_APB1ENR_USARTEN_Msk
#define RCC_APB1ENR_LPUARTEN_Pos                                           (8UL)		/*!<RCC APB1ENR: LPUARTEN (Bit 8) */
#define RCC_APB1ENR_LPUARTEN_Msk                                           (0x100UL)		/*!< RCC APB1ENR: LPUARTEN (Bitfield-Mask: 0x01) */
#define RCC_APB1ENR_LPUARTEN                                               RCC_APB1ENR_LPUARTEN_Msk
#define RCC_APB1ENR_ADCANAEN_Pos                                           (5UL)		/*!<RCC APB1ENR: ADCANAEN (Bit 5) */
#define RCC_APB1ENR_ADCANAEN_Msk                                           (0x20UL)		/*!< RCC APB1ENR: ADCANAEN (Bitfield-Mask: 0x01) */
#define RCC_APB1ENR_ADCANAEN                                               RCC_APB1ENR_ADCANAEN_Msk
#define RCC_APB1ENR_ADCDIGEN_Pos                                           (4UL)		/*!<RCC APB1ENR: ADCDIGEN (Bit 4) */
#define RCC_APB1ENR_ADCDIGEN_Msk                                           (0x10UL)		/*!< RCC APB1ENR: ADCDIGEN (Bitfield-Mask: 0x01) */
#define RCC_APB1ENR_ADCDIGEN                                               RCC_APB1ENR_ADCDIGEN_Msk
#define RCC_APB1ENR_SPI1EN_Pos                                             (0UL)		/*!<RCC APB1ENR: SPI1EN (Bit 0) */
#define RCC_APB1ENR_SPI1EN_Msk                                             (0x1UL)		/*!< RCC APB1ENR: SPI1EN (Bitfield-Mask: 0x01) */
#define RCC_APB1ENR_SPI1EN                                                 RCC_APB1ENR_SPI1EN_Msk

/* =====================================================    APB2ENR    ===================================================== */ 
#define RCC_APB2ENR_CLKBLEDIV_Pos                                          (1UL)		/*!<RCC APB2ENR: CLKBLEDIV (Bit 1) */
#define RCC_APB2ENR_CLKBLEDIV_Msk                                          (0x6UL)		/*!< RCC APB2ENR: CLKBLEDIV (Bitfield-Mask: 0x03) */
#define RCC_APB2ENR_CLKBLEDIV                                              RCC_APB2ENR_CLKBLEDIV_Msk
#define RCC_APB2ENR_CLKBLEDIV_0                                            (0x1U << RCC_APB2ENR_CLKBLEDIV_Pos)
#define RCC_APB2ENR_CLKBLEDIV_1                                            (0x2U << RCC_APB2ENR_CLKBLEDIV_Pos)
#define RCC_APB2ENR_MRBLEEN_Pos                                            (0UL)		/*!<RCC APB2ENR: MRBLEEN (Bit 0) */
#define RCC_APB2ENR_MRBLEEN_Msk                                            (0x1UL)		/*!< RCC APB2ENR: MRBLEEN (Bitfield-Mask: 0x01) */
#define RCC_APB2ENR_MRBLEEN                                                RCC_APB2ENR_MRBLEEN_Msk

/* =====================================================    CSR    ===================================================== */ 
#define RCC_CSR_LOCKUPRSTF_Pos                                             (30UL)		/*!<RCC CSR: LOCKUPRSTF (Bit 30) */
#define RCC_CSR_LOCKUPRSTF_Msk                                             (0x40000000UL)		/*!< RCC CSR: LOCKUPRSTF (Bitfield-Mask: 0x01) */
#define RCC_CSR_LOCKUPRSTF                                                 RCC_CSR_LOCKUPRSTF_Msk
#define RCC_CSR_WDGRSTF_Pos                                                (29UL)		/*!<RCC CSR: WDGRSTF (Bit 29) */
#define RCC_CSR_WDGRSTF_Msk                                                (0x20000000UL)		/*!< RCC CSR: WDGRSTF (Bitfield-Mask: 0x01) */
#define RCC_CSR_WDGRSTF                                                    RCC_CSR_WDGRSTF_Msk
#define RCC_CSR_SFTRSTF_Pos                                                (28UL)		/*!<RCC CSR: SFTRSTF (Bit 28) */
#define RCC_CSR_SFTRSTF_Msk                                                (0x10000000UL)		/*!< RCC CSR: SFTRSTF (Bitfield-Mask: 0x01) */
#define RCC_CSR_SFTRSTF                                                    RCC_CSR_SFTRSTF_Msk
#define RCC_CSR_PORRSTF_Pos                                                (27UL)		/*!<RCC CSR: PORRSTF (Bit 27) */
#define RCC_CSR_PORRSTF_Msk                                                (0x8000000UL)		/*!< RCC CSR: PORRSTF (Bitfield-Mask: 0x01) */
#define RCC_CSR_PORRSTF                                                    RCC_CSR_PORRSTF_Msk
#define RCC_CSR_PADRSTF_Pos                                                (26UL)		/*!<RCC CSR: PADRSTF (Bit 26) */
#define RCC_CSR_PADRSTF_Msk                                                (0x4000000UL)		/*!< RCC CSR: PADRSTF (Bitfield-Mask: 0x01) */
#define RCC_CSR_PADRSTF                                                    RCC_CSR_PADRSTF_Msk
#define RCC_CSR_RMVF_Pos                                                   (23UL)		/*!<RCC CSR: RMVF (Bit 23) */
#define RCC_CSR_RMVF_Msk                                                   (0x800000UL)		/*!< RCC CSR: RMVF (Bitfield-Mask: 0x01) */
#define RCC_CSR_RMVF                                                       RCC_CSR_RMVF_Msk

/* =====================================================    RFSWHSECR    ===================================================== */ 
#define RCC_RFSWHSECR_SWXOTUNE_Pos                                         (8UL)		/*!<RCC RFSWHSECR: SWXOTUNE (Bit 8) */
#define RCC_RFSWHSECR_SWXOTUNE_Msk                                         (0x3f00UL)		/*!< RCC RFSWHSECR: SWXOTUNE (Bitfield-Mask: 0x3f) */
#define RCC_RFSWHSECR_SWXOTUNE                                             RCC_RFSWHSECR_SWXOTUNE_Msk
#define RCC_RFSWHSECR_SWXOTUNE_0                                           (0x1U << RCC_RFSWHSECR_SWXOTUNE_Pos)
#define RCC_RFSWHSECR_SWXOTUNE_1                                           (0x2U << RCC_RFSWHSECR_SWXOTUNE_Pos)
#define RCC_RFSWHSECR_SWXOTUNE_2                                           (0x4U << RCC_RFSWHSECR_SWXOTUNE_Pos)
#define RCC_RFSWHSECR_SWXOTUNE_3                                           (0x8U << RCC_RFSWHSECR_SWXOTUNE_Pos)
#define RCC_RFSWHSECR_SWXOTUNE_4                                           (0x10U << RCC_RFSWHSECR_SWXOTUNE_Pos)
#define RCC_RFSWHSECR_SWXOTUNE_5                                           (0x20U << RCC_RFSWHSECR_SWXOTUNE_Pos)
#define RCC_RFSWHSECR_SWXOTUNEEN_Pos                                       (7UL)		/*!<RCC RFSWHSECR: SWXOTUNEEN (Bit 7) */
#define RCC_RFSWHSECR_SWXOTUNEEN_Msk                                       (0x80UL)		/*!< RCC RFSWHSECR: SWXOTUNEEN (Bitfield-Mask: 0x01) */
#define RCC_RFSWHSECR_SWXOTUNEEN                                           RCC_RFSWHSECR_SWXOTUNEEN_Msk
#define RCC_RFSWHSECR_GMC_Pos                                              (4UL)		/*!<RCC RFSWHSECR: GMC (Bit 4) */
#define RCC_RFSWHSECR_GMC_Msk                                              (0x70UL)		/*!< RCC RFSWHSECR: GMC (Bitfield-Mask: 0x07) */
#define RCC_RFSWHSECR_GMC                                                  RCC_RFSWHSECR_GMC_Msk
#define RCC_RFSWHSECR_GMC_0                                                (0x1U << RCC_RFSWHSECR_GMC_Pos)
#define RCC_RFSWHSECR_GMC_1                                                (0x2U << RCC_RFSWHSECR_GMC_Pos)
#define RCC_RFSWHSECR_GMC_2                                                (0x4U << RCC_RFSWHSECR_GMC_Pos)
#define RCC_RFSWHSECR_SATRG_Pos                                            (3UL)		/*!<RCC RFSWHSECR: SATRG (Bit 3) */
#define RCC_RFSWHSECR_SATRG_Msk                                            (0x8UL)		/*!< RCC RFSWHSECR: SATRG (Bitfield-Mask: 0x01) */
#define RCC_RFSWHSECR_SATRG                                                RCC_RFSWHSECR_SATRG_Msk

/* =====================================================    RFHSECR    ===================================================== */ 
#define RCC_RFHSECR_XOTUNE_Pos                                             (0UL)		/*!<RCC RFHSECR: XOTUNE (Bit 0) */
#define RCC_RFHSECR_XOTUNE_Msk                                             (0x3fUL)		/*!< RCC RFHSECR: XOTUNE (Bitfield-Mask: 0x3f) */
#define RCC_RFHSECR_XOTUNE                                                 RCC_RFHSECR_XOTUNE_Msk
#define RCC_RFHSECR_XOTUNE_0                                               (0x1U << RCC_RFHSECR_XOTUNE_Pos)
#define RCC_RFHSECR_XOTUNE_1                                               (0x2U << RCC_RFHSECR_XOTUNE_Pos)
#define RCC_RFHSECR_XOTUNE_2                                               (0x4U << RCC_RFHSECR_XOTUNE_Pos)
#define RCC_RFHSECR_XOTUNE_3                                               (0x8U << RCC_RFHSECR_XOTUNE_Pos)
#define RCC_RFHSECR_XOTUNE_4                                               (0x10U << RCC_RFHSECR_XOTUNE_Pos)
#define RCC_RFHSECR_XOTUNE_5                                               (0x20U << RCC_RFHSECR_XOTUNE_Pos)
  

/* =========================================================================================================================== */ 
/*=====================                                       PWR                                       ===================== */ 
/* =========================================================================================================================== */ 

/* =====================================================    CR1    ===================================================== */ 
#define PWR_CR1_APC_Pos                                                    (4UL)		/*!<PWR CR1: APC (Bit 4) */
#define PWR_CR1_APC_Msk                                                    (0x10UL)		/*!< PWR CR1: APC (Bitfield-Mask: 0x01) */
#define PWR_CR1_APC                                                        PWR_CR1_APC_Msk
#define PWR_CR1_ENSDNBOR_Pos                                               (1UL)		/*!<PWR CR1: ENSDNBOR (Bit 1) */
#define PWR_CR1_ENSDNBOR_Msk                                               (0x2UL)		/*!< PWR CR1: ENSDNBOR (Bitfield-Mask: 0x01) */
#define PWR_CR1_ENSDNBOR                                                   PWR_CR1_ENSDNBOR_Msk
#define PWR_CR1_LPMS_Pos                                                   (0UL)		/*!<PWR CR1: LPMS (Bit 0) */
#define PWR_CR1_LPMS_Msk                                                   (0x1UL)		/*!< PWR CR1: LPMS (Bitfield-Mask: 0x01) */
#define PWR_CR1_LPMS                                                       PWR_CR1_LPMS_Msk

/* =====================================================    CR2    ===================================================== */ 
#define PWR_CR2_LSILPMUFEN_Pos                                             (10UL)		/*!<PWR CR2: LSILPMUFEN (Bit 10) */
#define PWR_CR2_LSILPMUFEN_Msk                                             (0x400UL)		/*!< PWR CR2: LSILPMUFEN (Bitfield-Mask: 0x01) */
#define PWR_CR2_LSILPMUFEN                                                 PWR_CR2_LSILPMUFEN_Msk
#define PWR_CR2_ENTS_Pos                                                   (9UL)		/*!<PWR CR2: ENTS (Bit 9) */
#define PWR_CR2_ENTS_Msk                                                   (0x200UL)		/*!< PWR CR2: ENTS (Bitfield-Mask: 0x01) */
#define PWR_CR2_ENTS                                                       PWR_CR2_ENTS_Msk
#define PWR_CR2_SCALEMR_Pos                                                (8UL)		/*!<PWR CR2: SCALEMR (Bit 8) */
#define PWR_CR2_SCALEMR_Msk                                                (0x100UL)		/*!< PWR CR2: SCALEMR (Bitfield-Mask: 0x01) */
#define PWR_CR2_SCALEMR                                                    PWR_CR2_SCALEMR_Msk
#define PWR_CR2_RAMRET3_Pos                                                (7UL)		/*!<PWR CR2: RAMRET3 (Bit 7) */
#define PWR_CR2_RAMRET3_Msk                                                (0x80UL)		/*!< PWR CR2: RAMRET3 (Bitfield-Mask: 0x01) */
#define PWR_CR2_RAMRET3                                                    PWR_CR2_RAMRET3_Msk
#define PWR_CR2_RAMRET2_Pos                                                (6UL)		/*!<PWR CR2: RAMRET2 (Bit 6) */
#define PWR_CR2_RAMRET2_Msk                                                (0x40UL)		/*!< PWR CR2: RAMRET2 (Bitfield-Mask: 0x01) */
#define PWR_CR2_RAMRET2                                                    PWR_CR2_RAMRET2_Msk
#define PWR_CR2_RAMRET1_Pos                                                (5UL)		/*!<PWR CR2: RAMRET1 (Bit 5) */
#define PWR_CR2_RAMRET1_Msk                                                (0x20UL)		/*!< PWR CR2: RAMRET1 (Bitfield-Mask: 0x01) */
#define PWR_CR2_RAMRET1                                                    PWR_CR2_RAMRET1_Msk
#define PWR_CR2_PVDLS_Pos                                                  (1UL)		/*!<PWR CR2: PVDLS (Bit 1) */
#define PWR_CR2_PVDLS_Msk                                                  (0xeUL)		/*!< PWR CR2: PVDLS (Bitfield-Mask: 0x07) */
#define PWR_CR2_PVDLS                                                      PWR_CR2_PVDLS_Msk
#define PWR_CR2_PVDLS_0                                                    (0x1U << PWR_CR2_PVDLS_Pos)
#define PWR_CR2_PVDLS_1                                                    (0x2U << PWR_CR2_PVDLS_Pos)
#define PWR_CR2_PVDLS_2                                                    (0x4U << PWR_CR2_PVDLS_Pos)
#define PWR_CR2_PVDE_Pos                                                   (0UL)		/*!<PWR CR2: PVDE (Bit 0) */
#define PWR_CR2_PVDE_Msk                                                   (0x1UL)		/*!< PWR CR2: PVDE (Bitfield-Mask: 0x01) */
#define PWR_CR2_PVDE                                                       PWR_CR2_PVDE_Msk

/* =====================================================    CR3    ===================================================== */ 
#define PWR_CR3_EIWL_Pos                                                   (15UL)		/*!<PWR CR3: EIWL (Bit 15) */
#define PWR_CR3_EIWL_Msk                                                   (0x8000UL)		/*!< PWR CR3: EIWL (Bitfield-Mask: 0x01) */
#define PWR_CR3_EIWL                                                       PWR_CR3_EIWL_Msk
#define PWR_CR3_EWBLEHCPU_Pos                                              (13UL)		/*!<PWR CR3: EWBLEHCPU (Bit 13) */
#define PWR_CR3_EWBLEHCPU_Msk                                              (0x2000UL)		/*!< PWR CR3: EWBLEHCPU (Bitfield-Mask: 0x01) */
#define PWR_CR3_EWBLEHCPU                                                  PWR_CR3_EWBLEHCPU_Msk
#define PWR_CR3_EWBLE_Pos                                                  (12UL)		/*!<PWR CR3: EWBLE (Bit 12) */
#define PWR_CR3_EWBLE_Msk                                                  (0x1000UL)		/*!< PWR CR3: EWBLE (Bitfield-Mask: 0x01) */
#define PWR_CR3_EWBLE                                                      PWR_CR3_EWBLE_Msk
#define PWR_CR3_EWU11_Pos                                                  (11UL)		/*!<PWR CR3: EWU11 (Bit 11) */
#define PWR_CR3_EWU11_Msk                                                  (0x800UL)		/*!< PWR CR3: EWU11 (Bitfield-Mask: 0x01) */
#define PWR_CR3_EWU11                                                      PWR_CR3_EWU11_Msk
#define PWR_CR3_EWU10_Pos                                                  (10UL)		/*!<PWR CR3: EWU10 (Bit 10) */
#define PWR_CR3_EWU10_Msk                                                  (0x400UL)		/*!< PWR CR3: EWU10 (Bitfield-Mask: 0x01) */
#define PWR_CR3_EWU10                                                      PWR_CR3_EWU10_Msk
#define PWR_CR3_EWU9_Pos                                                   (9UL)		/*!<PWR CR3: EWU9 (Bit 9) */
#define PWR_CR3_EWU9_Msk                                                   (0x200UL)		/*!< PWR CR3: EWU9 (Bitfield-Mask: 0x01) */
#define PWR_CR3_EWU9                                                       PWR_CR3_EWU9_Msk
#define PWR_CR3_EWU8_Pos                                                   (8UL)		/*!<PWR CR3: EWU8 (Bit 8) */
#define PWR_CR3_EWU8_Msk                                                   (0x100UL)		/*!< PWR CR3: EWU8 (Bitfield-Mask: 0x01) */
#define PWR_CR3_EWU8                                                       PWR_CR3_EWU8_Msk
#define PWR_CR3_EWU7_Pos                                                   (7UL)		/*!<PWR CR3: EWU7 (Bit 7) */
#define PWR_CR3_EWU7_Msk                                                   (0x80UL)		/*!< PWR CR3: EWU7 (Bitfield-Mask: 0x01) */
#define PWR_CR3_EWU7                                                       PWR_CR3_EWU7_Msk
#define PWR_CR3_EWU6_Pos                                                   (6UL)		/*!<PWR CR3: EWU6 (Bit 6) */
#define PWR_CR3_EWU6_Msk                                                   (0x40UL)		/*!< PWR CR3: EWU6 (Bitfield-Mask: 0x01) */
#define PWR_CR3_EWU6                                                       PWR_CR3_EWU6_Msk
#define PWR_CR3_EWU5_Pos                                                   (5UL)		/*!<PWR CR3: EWU5 (Bit 5) */
#define PWR_CR3_EWU5_Msk                                                   (0x20UL)		/*!< PWR CR3: EWU5 (Bitfield-Mask: 0x01) */
#define PWR_CR3_EWU5                                                       PWR_CR3_EWU5_Msk
#define PWR_CR3_EWU4_Pos                                                   (4UL)		/*!<PWR CR3: EWU4 (Bit 4) */
#define PWR_CR3_EWU4_Msk                                                   (0x10UL)		/*!< PWR CR3: EWU4 (Bitfield-Mask: 0x01) */
#define PWR_CR3_EWU4                                                       PWR_CR3_EWU4_Msk
#define PWR_CR3_EWU3_Pos                                                   (3UL)		/*!<PWR CR3: EWU3 (Bit 3) */
#define PWR_CR3_EWU3_Msk                                                   (0x8UL)		/*!< PWR CR3: EWU3 (Bitfield-Mask: 0x01) */
#define PWR_CR3_EWU3                                                       PWR_CR3_EWU3_Msk
#define PWR_CR3_EWU2_Pos                                                   (2UL)		/*!<PWR CR3: EWU2 (Bit 2) */
#define PWR_CR3_EWU2_Msk                                                   (0x4UL)		/*!< PWR CR3: EWU2 (Bitfield-Mask: 0x01) */
#define PWR_CR3_EWU2                                                       PWR_CR3_EWU2_Msk
#define PWR_CR3_EWU1_Pos                                                   (1UL)		/*!<PWR CR3: EWU1 (Bit 1) */
#define PWR_CR3_EWU1_Msk                                                   (0x2UL)		/*!< PWR CR3: EWU1 (Bitfield-Mask: 0x01) */
#define PWR_CR3_EWU1                                                       PWR_CR3_EWU1_Msk
#define PWR_CR3_EWU0_Pos                                                   (0UL)		/*!<PWR CR3: EWU0 (Bit 0) */
#define PWR_CR3_EWU0_Msk                                                   (0x1UL)		/*!< PWR CR3: EWU0 (Bitfield-Mask: 0x01) */
#define PWR_CR3_EWU0                                                       PWR_CR3_EWU0_Msk

/* =====================================================    CR4    ===================================================== */ 
#define PWR_CR4_WUP11_Pos                                                  (11UL)		/*!<PWR CR4: WUP11 (Bit 11) */
#define PWR_CR4_WUP11_Msk                                                  (0x800UL)		/*!< PWR CR4: WUP11 (Bitfield-Mask: 0x01) */
#define PWR_CR4_WUP11                                                      PWR_CR4_WUP11_Msk
#define PWR_CR4_WUP10_Pos                                                  (10UL)		/*!<PWR CR4: WUP10 (Bit 10) */
#define PWR_CR4_WUP10_Msk                                                  (0x400UL)		/*!< PWR CR4: WUP10 (Bitfield-Mask: 0x01) */
#define PWR_CR4_WUP10                                                      PWR_CR4_WUP10_Msk
#define PWR_CR4_WUP9_Pos                                                   (9UL)		/*!<PWR CR4: WUP9 (Bit 9) */
#define PWR_CR4_WUP9_Msk                                                   (0x200UL)		/*!< PWR CR4: WUP9 (Bitfield-Mask: 0x01) */
#define PWR_CR4_WUP9                                                       PWR_CR4_WUP9_Msk
#define PWR_CR4_WUP8_Pos                                                   (8UL)		/*!<PWR CR4: WUP8 (Bit 8) */
#define PWR_CR4_WUP8_Msk                                                   (0x100UL)		/*!< PWR CR4: WUP8 (Bitfield-Mask: 0x01) */
#define PWR_CR4_WUP8                                                       PWR_CR4_WUP8_Msk
#define PWR_CR4_WUP7_Pos                                                   (7UL)		/*!<PWR CR4: WUP7 (Bit 7) */
#define PWR_CR4_WUP7_Msk                                                   (0x80UL)		/*!< PWR CR4: WUP7 (Bitfield-Mask: 0x01) */
#define PWR_CR4_WUP7                                                       PWR_CR4_WUP7_Msk
#define PWR_CR4_WUP6_Pos                                                   (6UL)		/*!<PWR CR4: WUP6 (Bit 6) */
#define PWR_CR4_WUP6_Msk                                                   (0x40UL)		/*!< PWR CR4: WUP6 (Bitfield-Mask: 0x01) */
#define PWR_CR4_WUP6                                                       PWR_CR4_WUP6_Msk
#define PWR_CR4_WUP5_Pos                                                   (5UL)		/*!<PWR CR4: WUP5 (Bit 5) */
#define PWR_CR4_WUP5_Msk                                                   (0x20UL)		/*!< PWR CR4: WUP5 (Bitfield-Mask: 0x01) */
#define PWR_CR4_WUP5                                                       PWR_CR4_WUP5_Msk
#define PWR_CR4_WUP4_Pos                                                   (4UL)		/*!<PWR CR4: WUP4 (Bit 4) */
#define PWR_CR4_WUP4_Msk                                                   (0x10UL)		/*!< PWR CR4: WUP4 (Bitfield-Mask: 0x01) */
#define PWR_CR4_WUP4                                                       PWR_CR4_WUP4_Msk
#define PWR_CR4_WUP3_Pos                                                   (3UL)		/*!<PWR CR4: WUP3 (Bit 3) */
#define PWR_CR4_WUP3_Msk                                                   (0x8UL)		/*!< PWR CR4: WUP3 (Bitfield-Mask: 0x01) */
#define PWR_CR4_WUP3                                                       PWR_CR4_WUP3_Msk
#define PWR_CR4_WUP2_Pos                                                   (2UL)		/*!<PWR CR4: WUP2 (Bit 2) */
#define PWR_CR4_WUP2_Msk                                                   (0x4UL)		/*!< PWR CR4: WUP2 (Bitfield-Mask: 0x01) */
#define PWR_CR4_WUP2                                                       PWR_CR4_WUP2_Msk
#define PWR_CR4_WUP1_Pos                                                   (1UL)		/*!<PWR CR4: WUP1 (Bit 1) */
#define PWR_CR4_WUP1_Msk                                                   (0x2UL)		/*!< PWR CR4: WUP1 (Bitfield-Mask: 0x01) */
#define PWR_CR4_WUP1                                                       PWR_CR4_WUP1_Msk
#define PWR_CR4_WUP0_Pos                                                   (0UL)		/*!<PWR CR4: WUP0 (Bit 0) */
#define PWR_CR4_WUP0_Msk                                                   (0x1UL)		/*!< PWR CR4: WUP0 (Bitfield-Mask: 0x01) */
#define PWR_CR4_WUP0                                                       PWR_CR4_WUP0_Msk

/* =====================================================    SR1    ===================================================== */ 
#define PWR_SR1_IWUF_Pos                                                   (15UL)		/*!<PWR SR1: IWUF (Bit 15) */
#define PWR_SR1_IWUF_Msk                                                   (0x8000UL)		/*!< PWR SR1: IWUF (Bitfield-Mask: 0x01) */
#define PWR_SR1_IWUF                                                       PWR_SR1_IWUF_Msk
#define PWR_SR1_WBLEHCPUF_Pos                                              (13UL)		/*!<PWR SR1: WBLEHCPUF (Bit 13) */
#define PWR_SR1_WBLEHCPUF_Msk                                              (0x2000UL)		/*!< PWR SR1: WBLEHCPUF (Bitfield-Mask: 0x01) */
#define PWR_SR1_WBLEHCPUF                                                  PWR_SR1_WBLEHCPUF_Msk
#define PWR_SR1_WBLEF_Pos                                                  (12UL)		/*!<PWR SR1: WBLEF (Bit 12) */
#define PWR_SR1_WBLEF_Msk                                                  (0x1000UL)		/*!< PWR SR1: WBLEF (Bitfield-Mask: 0x01) */
#define PWR_SR1_WBLEF                                                      PWR_SR1_WBLEF_Msk
#define PWR_SR1_WUF11_Pos                                                  (11UL)		/*!<PWR SR1: WUF11 (Bit 11) */
#define PWR_SR1_WUF11_Msk                                                  (0x800UL)		/*!< PWR SR1: WUF11 (Bitfield-Mask: 0x01) */
#define PWR_SR1_WUF11                                                      PWR_SR1_WUF11_Msk
#define PWR_SR1_WUF10_Pos                                                  (10UL)		/*!<PWR SR1: WUF10 (Bit 10) */
#define PWR_SR1_WUF10_Msk                                                  (0x400UL)		/*!< PWR SR1: WUF10 (Bitfield-Mask: 0x01) */
#define PWR_SR1_WUF10                                                      PWR_SR1_WUF10_Msk
#define PWR_SR1_WUF9_Pos                                                   (9UL)		/*!<PWR SR1: WUF9 (Bit 9) */
#define PWR_SR1_WUF9_Msk                                                   (0x200UL)		/*!< PWR SR1: WUF9 (Bitfield-Mask: 0x01) */
#define PWR_SR1_WUF9                                                       PWR_SR1_WUF9_Msk
#define PWR_SR1_WUF8_Pos                                                   (8UL)		/*!<PWR SR1: WUF8 (Bit 8) */
#define PWR_SR1_WUF8_Msk                                                   (0x100UL)		/*!< PWR SR1: WUF8 (Bitfield-Mask: 0x01) */
#define PWR_SR1_WUF8                                                       PWR_SR1_WUF8_Msk
#define PWR_SR1_WUF7_Pos                                                   (7UL)		/*!<PWR SR1: WUF7 (Bit 7) */
#define PWR_SR1_WUF7_Msk                                                   (0x80UL)		/*!< PWR SR1: WUF7 (Bitfield-Mask: 0x01) */
#define PWR_SR1_WUF7                                                       PWR_SR1_WUF7_Msk
#define PWR_SR1_WUF6_Pos                                                   (6UL)		/*!<PWR SR1: WUF6 (Bit 6) */
#define PWR_SR1_WUF6_Msk                                                   (0x40UL)		/*!< PWR SR1: WUF6 (Bitfield-Mask: 0x01) */
#define PWR_SR1_WUF6                                                       PWR_SR1_WUF6_Msk
#define PWR_SR1_WUF5_Pos                                                   (5UL)		/*!<PWR SR1: WUF5 (Bit 5) */
#define PWR_SR1_WUF5_Msk                                                   (0x20UL)		/*!< PWR SR1: WUF5 (Bitfield-Mask: 0x01) */
#define PWR_SR1_WUF5                                                       PWR_SR1_WUF5_Msk
#define PWR_SR1_WUF4_Pos                                                   (4UL)		/*!<PWR SR1: WUF4 (Bit 4) */
#define PWR_SR1_WUF4_Msk                                                   (0x10UL)		/*!< PWR SR1: WUF4 (Bitfield-Mask: 0x01) */
#define PWR_SR1_WUF4                                                       PWR_SR1_WUF4_Msk
#define PWR_SR1_WUF3_Pos                                                   (3UL)		/*!<PWR SR1: WUF3 (Bit 3) */
#define PWR_SR1_WUF3_Msk                                                   (0x8UL)		/*!< PWR SR1: WUF3 (Bitfield-Mask: 0x01) */
#define PWR_SR1_WUF3                                                       PWR_SR1_WUF3_Msk
#define PWR_SR1_WUF2_Pos                                                   (2UL)		/*!<PWR SR1: WUF2 (Bit 2) */
#define PWR_SR1_WUF2_Msk                                                   (0x4UL)		/*!< PWR SR1: WUF2 (Bitfield-Mask: 0x01) */
#define PWR_SR1_WUF2                                                       PWR_SR1_WUF2_Msk
#define PWR_SR1_WUF1_Pos                                                   (1UL)		/*!<PWR SR1: WUF1 (Bit 1) */
#define PWR_SR1_WUF1_Msk                                                   (0x2UL)		/*!< PWR SR1: WUF1 (Bitfield-Mask: 0x01) */
#define PWR_SR1_WUF1                                                       PWR_SR1_WUF1_Msk
#define PWR_SR1_WUF0_Pos                                                   (0UL)		/*!<PWR SR1: WUF0 (Bit 0) */
#define PWR_SR1_WUF0_Msk                                                   (0x1UL)		/*!< PWR SR1: WUF0 (Bitfield-Mask: 0x01) */
#define PWR_SR1_WUF0                                                       PWR_SR1_WUF0_Msk

/* =====================================================    SR2    ===================================================== */ 
#define PWR_SR2_IOBOOTVAL_Pos                                              (12UL)		/*!<PWR SR2: IOBOOTVAL (Bit 12) */
#define PWR_SR2_IOBOOTVAL_Msk                                              (0xf000UL)		/*!< PWR SR2: IOBOOTVAL (Bitfield-Mask: 0x0f) */
#define PWR_SR2_IOBOOTVAL                                                  PWR_SR2_IOBOOTVAL_Msk
#define PWR_SR2_IOBOOTVAL_0                                                (0x1U << PWR_SR2_IOBOOTVAL_Pos)
#define PWR_SR2_IOBOOTVAL_1                                                (0x2U << PWR_SR2_IOBOOTVAL_Pos)
#define PWR_SR2_IOBOOTVAL_2                                                (0x4U << PWR_SR2_IOBOOTVAL_Pos)
#define PWR_SR2_IOBOOTVAL_3                                                (0x8U << PWR_SR2_IOBOOTVAL_Pos)
#define PWR_SR2_PVDO_Pos                                                   (11UL)		/*!<PWR SR2: PVDO (Bit 11) */
#define PWR_SR2_PVDO_Msk                                                   (0x800UL)		/*!< PWR SR2: PVDO (Bitfield-Mask: 0x01) */
#define PWR_SR2_PVDO                                                       PWR_SR2_PVDO_Msk
#define PWR_SR2_REGMS_Pos                                                  (9UL)		/*!<PWR SR2: REGMS (Bit 9) */
#define PWR_SR2_REGMS_Msk                                                  (0x200UL)		/*!< PWR SR2: REGMS (Bitfield-Mask: 0x01) */
#define PWR_SR2_REGMS                                                      PWR_SR2_REGMS_Msk
#define PWR_SR2_REGLPS_Pos                                                 (8UL)		/*!<PWR SR2: REGLPS (Bit 8) */
#define PWR_SR2_REGLPS_Msk                                                 (0x100UL)		/*!< PWR SR2: REGLPS (Bitfield-Mask: 0x01) */
#define PWR_SR2_REGLPS                                                     PWR_SR2_REGLPS_Msk
#define PWR_SR2_SMPSRDY_Pos                                                (2UL)		/*!<PWR SR2: SMPSRDY (Bit 2) */
#define PWR_SR2_SMPSRDY_Msk                                                (0x4UL)		/*!< PWR SR2: SMPSRDY (Bitfield-Mask: 0x01) */
#define PWR_SR2_SMPSRDY                                                    PWR_SR2_SMPSRDY_Msk
#define PWR_SR2_SMPSENR_Pos                                                (1UL)		/*!<PWR SR2: SMPSENR (Bit 1) */
#define PWR_SR2_SMPSENR_Msk                                                (0x2UL)		/*!< PWR SR2: SMPSENR (Bitfield-Mask: 0x01) */
#define PWR_SR2_SMPSENR                                                    PWR_SR2_SMPSENR_Msk
#define PWR_SR2_SMPSBYPR_Pos                                               (0UL)		/*!<PWR SR2: SMPSBYPR (Bit 0) */
#define PWR_SR2_SMPSBYPR_Msk                                               (0x1UL)		/*!< PWR SR2: SMPSBYPR (Bitfield-Mask: 0x01) */
#define PWR_SR2_SMPSBYPR                                                   PWR_SR2_SMPSBYPR_Msk

/* =====================================================    CR5    ===================================================== */ 
#define PWR_CR5_CLKDETR_DISABLE_Pos                                        (12UL)		/*!<PWR CR5: CLKDETR_DISABLE (Bit 12) */
#define PWR_CR5_CLKDETR_DISABLE_Msk                                        (0x1000UL)		/*!< PWR CR5: CLKDETR_DISABLE (Bitfield-Mask: 0x01) */
#define PWR_CR5_CLKDETR_DISABLE                                            PWR_CR5_CLKDETR_DISABLE_Msk
#define PWR_CR5_SMPS_ENA_DCM_Pos                                           (11UL)		/*!<PWR CR5: SMPS_ENA_DCM (Bit 11) */
#define PWR_CR5_SMPS_ENA_DCM_Msk                                           (0x800UL)		/*!< PWR CR5: SMPS_ENA_DCM (Bitfield-Mask: 0x01) */
#define PWR_CR5_SMPS_ENA_DCM                                               PWR_CR5_SMPS_ENA_DCM_Msk
#define PWR_CR5_NOSMPS_Pos                                                 (10UL)		/*!<PWR CR5: NOSMPS (Bit 10) */
#define PWR_CR5_NOSMPS_Msk                                                 (0x400UL)		/*!< PWR CR5: NOSMPS (Bitfield-Mask: 0x01) */
#define PWR_CR5_NOSMPS                                                     PWR_CR5_NOSMPS_Msk
#define PWR_CR5_SMPSFBYP_Pos                                               (9UL)		/*!<PWR CR5: SMPSFBYP (Bit 9) */
#define PWR_CR5_SMPSFBYP_Msk                                               (0x200UL)		/*!< PWR CR5: SMPSFBYP (Bitfield-Mask: 0x01) */
#define PWR_CR5_SMPSFBYP                                                   PWR_CR5_SMPSFBYP_Msk
#define PWR_CR5_SMPSLPOPEN_Pos                                             (8UL)		/*!<PWR CR5: SMPSLPOPEN (Bit 8) */
#define PWR_CR5_SMPSLPOPEN_Msk                                             (0x100UL)		/*!< PWR CR5: SMPSLPOPEN (Bitfield-Mask: 0x01) */
#define PWR_CR5_SMPSLPOPEN                                                 PWR_CR5_SMPSLPOPEN_Msk
#define PWR_CR5_SMPSFRDY_Pos                                               (7UL)		/*!<PWR CR5: SMPSFRDY (Bit 7) */
#define PWR_CR5_SMPSFRDY_Msk                                               (0x80UL)		/*!< PWR CR5: SMPSFRDY (Bitfield-Mask: 0x01) */
#define PWR_CR5_SMPSFRDY                                                   PWR_CR5_SMPSFRDY_Msk
#define PWR_CR5_SMPSBOMSEL_Pos                                             (4UL)		/*!<PWR CR5: SMPSBOMSEL (Bit 4) */
#define PWR_CR5_SMPSBOMSEL_Msk                                             (0x30UL)		/*!< PWR CR5: SMPSBOMSEL (Bitfield-Mask: 0x03) */
#define PWR_CR5_SMPSBOMSEL                                                 PWR_CR5_SMPSBOMSEL_Msk
#define PWR_CR5_SMPSBOMSEL_0                                               (0x1U << PWR_CR5_SMPSBOMSEL_Pos)
#define PWR_CR5_SMPSBOMSEL_1                                               (0x2U << PWR_CR5_SMPSBOMSEL_Pos)
#define PWR_CR5_SMPSLVL_Pos                                                (0UL)		/*!<PWR CR5: SMPSLVL (Bit 0) */
#define PWR_CR5_SMPSLVL_Msk                                                (0xfUL)		/*!< PWR CR5: SMPSLVL (Bitfield-Mask: 0x0f) */
#define PWR_CR5_SMPSLVL                                                    PWR_CR5_SMPSLVL_Msk
#define PWR_CR5_SMPSLVL_0                                                  (0x1U << PWR_CR5_SMPSLVL_Pos)
#define PWR_CR5_SMPSLVL_1                                                  (0x2U << PWR_CR5_SMPSLVL_Pos)
#define PWR_CR5_SMPSLVL_2                                                  (0x4U << PWR_CR5_SMPSLVL_Pos)
#define PWR_CR5_SMPSLVL_3                                                  (0x8U << PWR_CR5_SMPSLVL_Pos)

/* =====================================================    PUCRA    ===================================================== */ 
#define PWR_PUCRA_PA15_Pos                                                 (15UL)		/*!<PWR PUCRA: PA15 (Bit 15) */
#define PWR_PUCRA_PA15_Msk                                                 (0x8000UL)		/*!< PWR PUCRA: PA15 (Bitfield-Mask: 0x01) */
#define PWR_PUCRA_PA15                                                     PWR_PUCRA_PA15_Msk
#define PWR_PUCRA_PA14_Pos                                                 (14UL)		/*!<PWR PUCRA: PA14 (Bit 14) */
#define PWR_PUCRA_PA14_Msk                                                 (0x4000UL)		/*!< PWR PUCRA: PA14 (Bitfield-Mask: 0x01) */
#define PWR_PUCRA_PA14                                                     PWR_PUCRA_PA14_Msk
#define PWR_PUCRA_PA13_Pos                                                 (13UL)		/*!<PWR PUCRA: PA13 (Bit 13) */
#define PWR_PUCRA_PA13_Msk                                                 (0x2000UL)		/*!< PWR PUCRA: PA13 (Bitfield-Mask: 0x01) */
#define PWR_PUCRA_PA13                                                     PWR_PUCRA_PA13_Msk
#define PWR_PUCRA_PA12_Pos                                                 (12UL)		/*!<PWR PUCRA: PA12 (Bit 12) */
#define PWR_PUCRA_PA12_Msk                                                 (0x1000UL)		/*!< PWR PUCRA: PA12 (Bitfield-Mask: 0x01) */
#define PWR_PUCRA_PA12                                                     PWR_PUCRA_PA12_Msk
#define PWR_PUCRA_PA11_Pos                                                 (11UL)		/*!<PWR PUCRA: PA11 (Bit 11) */
#define PWR_PUCRA_PA11_Msk                                                 (0x800UL)		/*!< PWR PUCRA: PA11 (Bitfield-Mask: 0x01) */
#define PWR_PUCRA_PA11                                                     PWR_PUCRA_PA11_Msk
#define PWR_PUCRA_PA10_Pos                                                 (10UL)		/*!<PWR PUCRA: PA10 (Bit 10) */
#define PWR_PUCRA_PA10_Msk                                                 (0x400UL)		/*!< PWR PUCRA: PA10 (Bitfield-Mask: 0x01) */
#define PWR_PUCRA_PA10                                                     PWR_PUCRA_PA10_Msk
#define PWR_PUCRA_PA9_Pos                                                  (9UL)		/*!<PWR PUCRA: PA9 (Bit 9) */
#define PWR_PUCRA_PA9_Msk                                                  (0x200UL)		/*!< PWR PUCRA: PA9 (Bitfield-Mask: 0x01) */
#define PWR_PUCRA_PA9                                                      PWR_PUCRA_PA9_Msk
#define PWR_PUCRA_PA8_Pos                                                  (8UL)		/*!<PWR PUCRA: PA8 (Bit 8) */
#define PWR_PUCRA_PA8_Msk                                                  (0x100UL)		/*!< PWR PUCRA: PA8 (Bitfield-Mask: 0x01) */
#define PWR_PUCRA_PA8                                                      PWR_PUCRA_PA8_Msk
#define PWR_PUCRA_PA7_Pos                                                  (7UL)		/*!<PWR PUCRA: PA7 (Bit 7) */
#define PWR_PUCRA_PA7_Msk                                                  (0x80UL)		/*!< PWR PUCRA: PA7 (Bitfield-Mask: 0x01) */
#define PWR_PUCRA_PA7                                                      PWR_PUCRA_PA7_Msk
#define PWR_PUCRA_PA6_Pos                                                  (6UL)		/*!<PWR PUCRA: PA6 (Bit 6) */
#define PWR_PUCRA_PA6_Msk                                                  (0x40UL)		/*!< PWR PUCRA: PA6 (Bitfield-Mask: 0x01) */
#define PWR_PUCRA_PA6                                                      PWR_PUCRA_PA6_Msk
#define PWR_PUCRA_PA5_Pos                                                  (5UL)		/*!<PWR PUCRA: PA5 (Bit 5) */
#define PWR_PUCRA_PA5_Msk                                                  (0x20UL)		/*!< PWR PUCRA: PA5 (Bitfield-Mask: 0x01) */
#define PWR_PUCRA_PA5                                                      PWR_PUCRA_PA5_Msk
#define PWR_PUCRA_PA4_Pos                                                  (4UL)		/*!<PWR PUCRA: PA4 (Bit 4) */
#define PWR_PUCRA_PA4_Msk                                                  (0x10UL)		/*!< PWR PUCRA: PA4 (Bitfield-Mask: 0x01) */
#define PWR_PUCRA_PA4                                                      PWR_PUCRA_PA4_Msk
#define PWR_PUCRA_PA3_Pos                                                  (3UL)		/*!<PWR PUCRA: PA3 (Bit 3) */
#define PWR_PUCRA_PA3_Msk                                                  (0x8UL)		/*!< PWR PUCRA: PA3 (Bitfield-Mask: 0x01) */
#define PWR_PUCRA_PA3                                                      PWR_PUCRA_PA3_Msk
#define PWR_PUCRA_PA2_Pos                                                  (2UL)		/*!<PWR PUCRA: PA2 (Bit 2) */
#define PWR_PUCRA_PA2_Msk                                                  (0x4UL)		/*!< PWR PUCRA: PA2 (Bitfield-Mask: 0x01) */
#define PWR_PUCRA_PA2                                                      PWR_PUCRA_PA2_Msk
#define PWR_PUCRA_PA1_Pos                                                  (1UL)		/*!<PWR PUCRA: PA1 (Bit 1) */
#define PWR_PUCRA_PA1_Msk                                                  (0x2UL)		/*!< PWR PUCRA: PA1 (Bitfield-Mask: 0x01) */
#define PWR_PUCRA_PA1                                                      PWR_PUCRA_PA1_Msk
#define PWR_PUCRA_PA0_Pos                                                  (0UL)		/*!<PWR PUCRA: PA0 (Bit 0) */
#define PWR_PUCRA_PA0_Msk                                                  (0x1UL)		/*!< PWR PUCRA: PA0 (Bitfield-Mask: 0x01) */
#define PWR_PUCRA_PA0                                                      PWR_PUCRA_PA0_Msk

/* =====================================================    PDCRA    ===================================================== */ 
#define PWR_PDCRA_PA15_Pos                                                 (15UL)		/*!<PWR PDCRA: PA15 (Bit 15) */
#define PWR_PDCRA_PA15_Msk                                                 (0x8000UL)		/*!< PWR PDCRA: PA15 (Bitfield-Mask: 0x01) */
#define PWR_PDCRA_PA15                                                     PWR_PDCRA_PA15_Msk
#define PWR_PDCRA_PA14_Pos                                                 (14UL)		/*!<PWR PDCRA: PA14 (Bit 14) */
#define PWR_PDCRA_PA14_Msk                                                 (0x4000UL)		/*!< PWR PDCRA: PA14 (Bitfield-Mask: 0x01) */
#define PWR_PDCRA_PA14                                                     PWR_PDCRA_PA14_Msk
#define PWR_PDCRA_PA13_Pos                                                 (13UL)		/*!<PWR PDCRA: PA13 (Bit 13) */
#define PWR_PDCRA_PA13_Msk                                                 (0x2000UL)		/*!< PWR PDCRA: PA13 (Bitfield-Mask: 0x01) */
#define PWR_PDCRA_PA13                                                     PWR_PDCRA_PA13_Msk
#define PWR_PDCRA_PA12_Pos                                                 (12UL)		/*!<PWR PDCRA: PA12 (Bit 12) */
#define PWR_PDCRA_PA12_Msk                                                 (0x1000UL)		/*!< PWR PDCRA: PA12 (Bitfield-Mask: 0x01) */
#define PWR_PDCRA_PA12                                                     PWR_PDCRA_PA12_Msk
#define PWR_PDCRA_PA11_Pos                                                 (11UL)		/*!<PWR PDCRA: PA11 (Bit 11) */
#define PWR_PDCRA_PA11_Msk                                                 (0x800UL)		/*!< PWR PDCRA: PA11 (Bitfield-Mask: 0x01) */
#define PWR_PDCRA_PA11                                                     PWR_PDCRA_PA11_Msk
#define PWR_PDCRA_PA10_Pos                                                 (10UL)		/*!<PWR PDCRA: PA10 (Bit 10) */
#define PWR_PDCRA_PA10_Msk                                                 (0x400UL)		/*!< PWR PDCRA: PA10 (Bitfield-Mask: 0x01) */
#define PWR_PDCRA_PA10                                                     PWR_PDCRA_PA10_Msk
#define PWR_PDCRA_PA9_Pos                                                  (9UL)		/*!<PWR PDCRA: PA9 (Bit 9) */
#define PWR_PDCRA_PA9_Msk                                                  (0x200UL)		/*!< PWR PDCRA: PA9 (Bitfield-Mask: 0x01) */
#define PWR_PDCRA_PA9                                                      PWR_PDCRA_PA9_Msk
#define PWR_PDCRA_PA8_Pos                                                  (8UL)		/*!<PWR PDCRA: PA8 (Bit 8) */
#define PWR_PDCRA_PA8_Msk                                                  (0x100UL)		/*!< PWR PDCRA: PA8 (Bitfield-Mask: 0x01) */
#define PWR_PDCRA_PA8                                                      PWR_PDCRA_PA8_Msk
#define PWR_PDCRA_PA7_Pos                                                  (7UL)		/*!<PWR PDCRA: PA7 (Bit 7) */
#define PWR_PDCRA_PA7_Msk                                                  (0x80UL)		/*!< PWR PDCRA: PA7 (Bitfield-Mask: 0x01) */
#define PWR_PDCRA_PA7                                                      PWR_PDCRA_PA7_Msk
#define PWR_PDCRA_PA6_Pos                                                  (6UL)		/*!<PWR PDCRA: PA6 (Bit 6) */
#define PWR_PDCRA_PA6_Msk                                                  (0x40UL)		/*!< PWR PDCRA: PA6 (Bitfield-Mask: 0x01) */
#define PWR_PDCRA_PA6                                                      PWR_PDCRA_PA6_Msk
#define PWR_PDCRA_PA5_Pos                                                  (5UL)		/*!<PWR PDCRA: PA5 (Bit 5) */
#define PWR_PDCRA_PA5_Msk                                                  (0x20UL)		/*!< PWR PDCRA: PA5 (Bitfield-Mask: 0x01) */
#define PWR_PDCRA_PA5                                                      PWR_PDCRA_PA5_Msk
#define PWR_PDCRA_PA4_Pos                                                  (4UL)		/*!<PWR PDCRA: PA4 (Bit 4) */
#define PWR_PDCRA_PA4_Msk                                                  (0x10UL)		/*!< PWR PDCRA: PA4 (Bitfield-Mask: 0x01) */
#define PWR_PDCRA_PA4                                                      PWR_PDCRA_PA4_Msk
#define PWR_PDCRA_PA3_Pos                                                  (3UL)		/*!<PWR PDCRA: PA3 (Bit 3) */
#define PWR_PDCRA_PA3_Msk                                                  (0x8UL)		/*!< PWR PDCRA: PA3 (Bitfield-Mask: 0x01) */
#define PWR_PDCRA_PA3                                                      PWR_PDCRA_PA3_Msk
#define PWR_PDCRA_PA2_Pos                                                  (2UL)		/*!<PWR PDCRA: PA2 (Bit 2) */
#define PWR_PDCRA_PA2_Msk                                                  (0x4UL)		/*!< PWR PDCRA: PA2 (Bitfield-Mask: 0x01) */
#define PWR_PDCRA_PA2                                                      PWR_PDCRA_PA2_Msk
#define PWR_PDCRA_PA1_Pos                                                  (1UL)		/*!<PWR PDCRA: PA1 (Bit 1) */
#define PWR_PDCRA_PA1_Msk                                                  (0x2UL)		/*!< PWR PDCRA: PA1 (Bitfield-Mask: 0x01) */
#define PWR_PDCRA_PA1                                                      PWR_PDCRA_PA1_Msk
#define PWR_PDCRA_PA0_Pos                                                  (0UL)		/*!<PWR PDCRA: PA0 (Bit 0) */
#define PWR_PDCRA_PA0_Msk                                                  (0x1UL)		/*!< PWR PDCRA: PA0 (Bitfield-Mask: 0x01) */
#define PWR_PDCRA_PA0                                                      PWR_PDCRA_PA0_Msk

/* =====================================================    PUCRB    ===================================================== */ 
#define PWR_PUCRB_PB15_Pos                                                 (15UL)		/*!<PWR PUCRB: PB15 (Bit 15) */
#define PWR_PUCRB_PB15_Msk                                                 (0x8000UL)		/*!< PWR PUCRB: PB15 (Bitfield-Mask: 0x01) */
#define PWR_PUCRB_PB15                                                     PWR_PUCRB_PB15_Msk
#define PWR_PUCRB_PB14_Pos                                                 (14UL)		/*!<PWR PUCRB: PB14 (Bit 14) */
#define PWR_PUCRB_PB14_Msk                                                 (0x4000UL)		/*!< PWR PUCRB: PB14 (Bitfield-Mask: 0x01) */
#define PWR_PUCRB_PB14                                                     PWR_PUCRB_PB14_Msk
#define PWR_PUCRB_PB13_Pos                                                 (13UL)		/*!<PWR PUCRB: PB13 (Bit 13) */
#define PWR_PUCRB_PB13_Msk                                                 (0x2000UL)		/*!< PWR PUCRB: PB13 (Bitfield-Mask: 0x01) */
#define PWR_PUCRB_PB13                                                     PWR_PUCRB_PB13_Msk
#define PWR_PUCRB_PB12_Pos                                                 (12UL)		/*!<PWR PUCRB: PB12 (Bit 12) */
#define PWR_PUCRB_PB12_Msk                                                 (0x1000UL)		/*!< PWR PUCRB: PB12 (Bitfield-Mask: 0x01) */
#define PWR_PUCRB_PB12                                                     PWR_PUCRB_PB12_Msk
#define PWR_PUCRB_PB11_Pos                                                 (11UL)		/*!<PWR PUCRB: PB11 (Bit 11) */
#define PWR_PUCRB_PB11_Msk                                                 (0x800UL)		/*!< PWR PUCRB: PB11 (Bitfield-Mask: 0x01) */
#define PWR_PUCRB_PB11                                                     PWR_PUCRB_PB11_Msk
#define PWR_PUCRB_PB10_Pos                                                 (10UL)		/*!<PWR PUCRB: PB10 (Bit 10) */
#define PWR_PUCRB_PB10_Msk                                                 (0x400UL)		/*!< PWR PUCRB: PB10 (Bitfield-Mask: 0x01) */
#define PWR_PUCRB_PB10                                                     PWR_PUCRB_PB10_Msk
#define PWR_PUCRB_PB9_Pos                                                  (9UL)		/*!<PWR PUCRB: PB9 (Bit 9) */
#define PWR_PUCRB_PB9_Msk                                                  (0x200UL)		/*!< PWR PUCRB: PB9 (Bitfield-Mask: 0x01) */
#define PWR_PUCRB_PB9                                                      PWR_PUCRB_PB9_Msk
#define PWR_PUCRB_PB8_Pos                                                  (8UL)		/*!<PWR PUCRB: PB8 (Bit 8) */
#define PWR_PUCRB_PB8_Msk                                                  (0x100UL)		/*!< PWR PUCRB: PB8 (Bitfield-Mask: 0x01) */
#define PWR_PUCRB_PB8                                                      PWR_PUCRB_PB8_Msk
#define PWR_PUCRB_PB7_Pos                                                  (7UL)		/*!<PWR PUCRB: PB7 (Bit 7) */
#define PWR_PUCRB_PB7_Msk                                                  (0x80UL)		/*!< PWR PUCRB: PB7 (Bitfield-Mask: 0x01) */
#define PWR_PUCRB_PB7                                                      PWR_PUCRB_PB7_Msk
#define PWR_PUCRB_PB6_Pos                                                  (6UL)		/*!<PWR PUCRB: PB6 (Bit 6) */
#define PWR_PUCRB_PB6_Msk                                                  (0x40UL)		/*!< PWR PUCRB: PB6 (Bitfield-Mask: 0x01) */
#define PWR_PUCRB_PB6                                                      PWR_PUCRB_PB6_Msk
#define PWR_PUCRB_PB5_Pos                                                  (5UL)		/*!<PWR PUCRB: PB5 (Bit 5) */
#define PWR_PUCRB_PB5_Msk                                                  (0x20UL)		/*!< PWR PUCRB: PB5 (Bitfield-Mask: 0x01) */
#define PWR_PUCRB_PB5                                                      PWR_PUCRB_PB5_Msk
#define PWR_PUCRB_PB4_Pos                                                  (4UL)		/*!<PWR PUCRB: PB4 (Bit 4) */
#define PWR_PUCRB_PB4_Msk                                                  (0x10UL)		/*!< PWR PUCRB: PB4 (Bitfield-Mask: 0x01) */
#define PWR_PUCRB_PB4                                                      PWR_PUCRB_PB4_Msk
#define PWR_PUCRB_PB3_Pos                                                  (3UL)		/*!<PWR PUCRB: PB3 (Bit 3) */
#define PWR_PUCRB_PB3_Msk                                                  (0x8UL)		/*!< PWR PUCRB: PB3 (Bitfield-Mask: 0x01) */
#define PWR_PUCRB_PB3                                                      PWR_PUCRB_PB3_Msk
#define PWR_PUCRB_PB2_Pos                                                  (2UL)		/*!<PWR PUCRB: PB2 (Bit 2) */
#define PWR_PUCRB_PB2_Msk                                                  (0x4UL)		/*!< PWR PUCRB: PB2 (Bitfield-Mask: 0x01) */
#define PWR_PUCRB_PB2                                                      PWR_PUCRB_PB2_Msk
#define PWR_PUCRB_PB1_Pos                                                  (1UL)		/*!<PWR PUCRB: PB1 (Bit 1) */
#define PWR_PUCRB_PB1_Msk                                                  (0x2UL)		/*!< PWR PUCRB: PB1 (Bitfield-Mask: 0x01) */
#define PWR_PUCRB_PB1                                                      PWR_PUCRB_PB1_Msk
#define PWR_PUCRB_PB0_Pos                                                  (0UL)		/*!<PWR PUCRB: PB0 (Bit 0) */
#define PWR_PUCRB_PB0_Msk                                                  (0x1UL)		/*!< PWR PUCRB: PB0 (Bitfield-Mask: 0x01) */
#define PWR_PUCRB_PB0                                                      PWR_PUCRB_PB0_Msk

/* =====================================================    PDCRB    ===================================================== */ 
#define PWR_PDCRB_PB15_Pos                                                 (15UL)		/*!<PWR PDCRB: PB15 (Bit 15) */
#define PWR_PDCRB_PB15_Msk                                                 (0x8000UL)		/*!< PWR PDCRB: PB15 (Bitfield-Mask: 0x01) */
#define PWR_PDCRB_PB15                                                     PWR_PDCRB_PB15_Msk
#define PWR_PDCRB_PB14_Pos                                                 (14UL)		/*!<PWR PDCRB: PB14 (Bit 14) */
#define PWR_PDCRB_PB14_Msk                                                 (0x4000UL)		/*!< PWR PDCRB: PB14 (Bitfield-Mask: 0x01) */
#define PWR_PDCRB_PB14                                                     PWR_PDCRB_PB14_Msk
#define PWR_PDCRB_PB13_Pos                                                 (13UL)		/*!<PWR PDCRB: PB13 (Bit 13) */
#define PWR_PDCRB_PB13_Msk                                                 (0x2000UL)		/*!< PWR PDCRB: PB13 (Bitfield-Mask: 0x01) */
#define PWR_PDCRB_PB13                                                     PWR_PDCRB_PB13_Msk
#define PWR_PDCRB_PB12_Pos                                                 (12UL)		/*!<PWR PDCRB: PB12 (Bit 12) */
#define PWR_PDCRB_PB12_Msk                                                 (0x1000UL)		/*!< PWR PDCRB: PB12 (Bitfield-Mask: 0x01) */
#define PWR_PDCRB_PB12                                                     PWR_PDCRB_PB12_Msk
#define PWR_PDCRB_PB11_Pos                                                 (11UL)		/*!<PWR PDCRB: PB11 (Bit 11) */
#define PWR_PDCRB_PB11_Msk                                                 (0x800UL)		/*!< PWR PDCRB: PB11 (Bitfield-Mask: 0x01) */
#define PWR_PDCRB_PB11                                                     PWR_PDCRB_PB11_Msk
#define PWR_PDCRB_PB10_Pos                                                 (10UL)		/*!<PWR PDCRB: PB10 (Bit 10) */
#define PWR_PDCRB_PB10_Msk                                                 (0x400UL)		/*!< PWR PDCRB: PB10 (Bitfield-Mask: 0x01) */
#define PWR_PDCRB_PB10                                                     PWR_PDCRB_PB10_Msk
#define PWR_PDCRB_PB9_Pos                                                  (9UL)		/*!<PWR PDCRB: PB9 (Bit 9) */
#define PWR_PDCRB_PB9_Msk                                                  (0x200UL)		/*!< PWR PDCRB: PB9 (Bitfield-Mask: 0x01) */
#define PWR_PDCRB_PB9                                                      PWR_PDCRB_PB9_Msk
#define PWR_PDCRB_PB8_Pos                                                  (8UL)		/*!<PWR PDCRB: PB8 (Bit 8) */
#define PWR_PDCRB_PB8_Msk                                                  (0x100UL)		/*!< PWR PDCRB: PB8 (Bitfield-Mask: 0x01) */
#define PWR_PDCRB_PB8                                                      PWR_PDCRB_PB8_Msk
#define PWR_PDCRB_PB7_Pos                                                  (7UL)		/*!<PWR PDCRB: PB7 (Bit 7) */
#define PWR_PDCRB_PB7_Msk                                                  (0x80UL)		/*!< PWR PDCRB: PB7 (Bitfield-Mask: 0x01) */
#define PWR_PDCRB_PB7                                                      PWR_PDCRB_PB7_Msk
#define PWR_PDCRB_PB6_Pos                                                  (6UL)		/*!<PWR PDCRB: PB6 (Bit 6) */
#define PWR_PDCRB_PB6_Msk                                                  (0x40UL)		/*!< PWR PDCRB: PB6 (Bitfield-Mask: 0x01) */
#define PWR_PDCRB_PB6                                                      PWR_PDCRB_PB6_Msk
#define PWR_PDCRB_PB5_Pos                                                  (5UL)		/*!<PWR PDCRB: PB5 (Bit 5) */
#define PWR_PDCRB_PB5_Msk                                                  (0x20UL)		/*!< PWR PDCRB: PB5 (Bitfield-Mask: 0x01) */
#define PWR_PDCRB_PB5                                                      PWR_PDCRB_PB5_Msk
#define PWR_PDCRB_PB4_Pos                                                  (4UL)		/*!<PWR PDCRB: PB4 (Bit 4) */
#define PWR_PDCRB_PB4_Msk                                                  (0x10UL)		/*!< PWR PDCRB: PB4 (Bitfield-Mask: 0x01) */
#define PWR_PDCRB_PB4                                                      PWR_PDCRB_PB4_Msk
#define PWR_PDCRB_PB3_Pos                                                  (3UL)		/*!<PWR PDCRB: PB3 (Bit 3) */
#define PWR_PDCRB_PB3_Msk                                                  (0x8UL)		/*!< PWR PDCRB: PB3 (Bitfield-Mask: 0x01) */
#define PWR_PDCRB_PB3                                                      PWR_PDCRB_PB3_Msk
#define PWR_PDCRB_PB2_Pos                                                  (2UL)		/*!<PWR PDCRB: PB2 (Bit 2) */
#define PWR_PDCRB_PB2_Msk                                                  (0x4UL)		/*!< PWR PDCRB: PB2 (Bitfield-Mask: 0x01) */
#define PWR_PDCRB_PB2                                                      PWR_PDCRB_PB2_Msk
#define PWR_PDCRB_PB1_Pos                                                  (1UL)		/*!<PWR PDCRB: PB1 (Bit 1) */
#define PWR_PDCRB_PB1_Msk                                                  (0x2UL)		/*!< PWR PDCRB: PB1 (Bitfield-Mask: 0x01) */
#define PWR_PDCRB_PB1                                                      PWR_PDCRB_PB1_Msk
#define PWR_PDCRB_PB0_Pos                                                  (0UL)		/*!<PWR PDCRB: PB0 (Bit 0) */
#define PWR_PDCRB_PB0_Msk                                                  (0x1UL)		/*!< PWR PDCRB: PB0 (Bitfield-Mask: 0x01) */
#define PWR_PDCRB_PB0                                                      PWR_PDCRB_PB0_Msk

/* =====================================================    CR6    ===================================================== */ 
#define PWR_CR6_EWU27_Pos                                                  (15UL)		/*!<PWR CR6: EWU27 (Bit 15) */
#define PWR_CR6_EWU27_Msk                                                  (0x8000UL)		/*!< PWR CR6: EWU27 (Bitfield-Mask: 0x01) */
#define PWR_CR6_EWU27                                                      PWR_CR6_EWU27_Msk
#define PWR_CR6_EWU26_Pos                                                  (14UL)		/*!<PWR CR6: EWU26 (Bit 14) */
#define PWR_CR6_EWU26_Msk                                                  (0x4000UL)		/*!< PWR CR6: EWU26 (Bitfield-Mask: 0x01) */
#define PWR_CR6_EWU26                                                      PWR_CR6_EWU26_Msk
#define PWR_CR6_EWU25_Pos                                                  (13UL)		/*!<PWR CR6: EWU25 (Bit 13) */
#define PWR_CR6_EWU25_Msk                                                  (0x2000UL)		/*!< PWR CR6: EWU25 (Bitfield-Mask: 0x01) */
#define PWR_CR6_EWU25                                                      PWR_CR6_EWU25_Msk
#define PWR_CR6_EWU24_Pos                                                  (12UL)		/*!<PWR CR6: EWU24 (Bit 12) */
#define PWR_CR6_EWU24_Msk                                                  (0x1000UL)		/*!< PWR CR6: EWU24 (Bitfield-Mask: 0x01) */
#define PWR_CR6_EWU24                                                      PWR_CR6_EWU24_Msk
#define PWR_CR6_EWU23_Pos                                                  (11UL)		/*!<PWR CR6: EWU23 (Bit 11) */
#define PWR_CR6_EWU23_Msk                                                  (0x800UL)		/*!< PWR CR6: EWU23 (Bitfield-Mask: 0x01) */
#define PWR_CR6_EWU23                                                      PWR_CR6_EWU23_Msk
#define PWR_CR6_EWU22_Pos                                                  (10UL)		/*!<PWR CR6: EWU22 (Bit 10) */
#define PWR_CR6_EWU22_Msk                                                  (0x400UL)		/*!< PWR CR6: EWU22 (Bitfield-Mask: 0x01) */
#define PWR_CR6_EWU22                                                      PWR_CR6_EWU22_Msk
#define PWR_CR6_EWU21_Pos                                                  (9UL)		/*!<PWR CR6: EWU21 (Bit 9) */
#define PWR_CR6_EWU21_Msk                                                  (0x200UL)		/*!< PWR CR6: EWU21 (Bitfield-Mask: 0x01) */
#define PWR_CR6_EWU21                                                      PWR_CR6_EWU21_Msk
#define PWR_CR6_EWU20_Pos                                                  (8UL)		/*!<PWR CR6: EWU20 (Bit 8) */
#define PWR_CR6_EWU20_Msk                                                  (0x100UL)		/*!< PWR CR6: EWU20 (Bitfield-Mask: 0x01) */
#define PWR_CR6_EWU20                                                      PWR_CR6_EWU20_Msk
#define PWR_CR6_EWU19_Pos                                                  (7UL)		/*!<PWR CR6: EWU19 (Bit 7) */
#define PWR_CR6_EWU19_Msk                                                  (0x80UL)		/*!< PWR CR6: EWU19 (Bitfield-Mask: 0x01) */
#define PWR_CR6_EWU19                                                      PWR_CR6_EWU19_Msk
#define PWR_CR6_EWU18_Pos                                                  (6UL)		/*!<PWR CR6: EWU18 (Bit 6) */
#define PWR_CR6_EWU18_Msk                                                  (0x40UL)		/*!< PWR CR6: EWU18 (Bitfield-Mask: 0x01) */
#define PWR_CR6_EWU18                                                      PWR_CR6_EWU18_Msk
#define PWR_CR6_EWU17_Pos                                                  (5UL)		/*!<PWR CR6: EWU17 (Bit 5) */
#define PWR_CR6_EWU17_Msk                                                  (0x20UL)		/*!< PWR CR6: EWU17 (Bitfield-Mask: 0x01) */
#define PWR_CR6_EWU17                                                      PWR_CR6_EWU17_Msk
#define PWR_CR6_EWU16_Pos                                                  (4UL)		/*!<PWR CR6: EWU16 (Bit 4) */
#define PWR_CR6_EWU16_Msk                                                  (0x10UL)		/*!< PWR CR6: EWU16 (Bitfield-Mask: 0x01) */
#define PWR_CR6_EWU16                                                      PWR_CR6_EWU16_Msk
#define PWR_CR6_EWU15_Pos                                                  (3UL)		/*!<PWR CR6: EWU15 (Bit 3) */
#define PWR_CR6_EWU15_Msk                                                  (0x8UL)		/*!< PWR CR6: EWU15 (Bitfield-Mask: 0x01) */
#define PWR_CR6_EWU15                                                      PWR_CR6_EWU15_Msk
#define PWR_CR6_EWU14_Pos                                                  (2UL)		/*!<PWR CR6: EWU14 (Bit 2) */
#define PWR_CR6_EWU14_Msk                                                  (0x4UL)		/*!< PWR CR6: EWU14 (Bitfield-Mask: 0x01) */
#define PWR_CR6_EWU14                                                      PWR_CR6_EWU14_Msk
#define PWR_CR6_EWU13_Pos                                                  (1UL)		/*!<PWR CR6: EWU13 (Bit 1) */
#define PWR_CR6_EWU13_Msk                                                  (0x2UL)		/*!< PWR CR6: EWU13 (Bitfield-Mask: 0x01) */
#define PWR_CR6_EWU13                                                      PWR_CR6_EWU13_Msk
#define PWR_CR6_EWU12_Pos                                                  (0UL)		/*!<PWR CR6: EWU12 (Bit 0) */
#define PWR_CR6_EWU12_Msk                                                  (0x1UL)		/*!< PWR CR6: EWU12 (Bitfield-Mask: 0x01) */
#define PWR_CR6_EWU12                                                      PWR_CR6_EWU12_Msk

/* =====================================================    CR7    ===================================================== */ 
#define PWR_CR7_WUP27_Pos                                                  (15UL)		/*!<PWR CR7: WUP27 (Bit 15) */
#define PWR_CR7_WUP27_Msk                                                  (0x8000UL)		/*!< PWR CR7: WUP27 (Bitfield-Mask: 0x01) */
#define PWR_CR7_WUP27                                                      PWR_CR7_WUP27_Msk
#define PWR_CR7_WUP26_Pos                                                  (14UL)		/*!<PWR CR7: WUP26 (Bit 14) */
#define PWR_CR7_WUP26_Msk                                                  (0x4000UL)		/*!< PWR CR7: WUP26 (Bitfield-Mask: 0x01) */
#define PWR_CR7_WUP26                                                      PWR_CR7_WUP26_Msk
#define PWR_CR7_WUP25_Pos                                                  (13UL)		/*!<PWR CR7: WUP25 (Bit 13) */
#define PWR_CR7_WUP25_Msk                                                  (0x2000UL)		/*!< PWR CR7: WUP25 (Bitfield-Mask: 0x01) */
#define PWR_CR7_WUP25                                                      PWR_CR7_WUP25_Msk
#define PWR_CR7_WUP24_Pos                                                  (12UL)		/*!<PWR CR7: WUP24 (Bit 12) */
#define PWR_CR7_WUP24_Msk                                                  (0x1000UL)		/*!< PWR CR7: WUP24 (Bitfield-Mask: 0x01) */
#define PWR_CR7_WUP24                                                      PWR_CR7_WUP24_Msk
#define PWR_CR7_WUP23_Pos                                                  (11UL)		/*!<PWR CR7: WUP23 (Bit 11) */
#define PWR_CR7_WUP23_Msk                                                  (0x800UL)		/*!< PWR CR7: WUP23 (Bitfield-Mask: 0x01) */
#define PWR_CR7_WUP23                                                      PWR_CR7_WUP23_Msk
#define PWR_CR7_WUP22_Pos                                                  (10UL)		/*!<PWR CR7: WUP22 (Bit 10) */
#define PWR_CR7_WUP22_Msk                                                  (0x400UL)		/*!< PWR CR7: WUP22 (Bitfield-Mask: 0x01) */
#define PWR_CR7_WUP22                                                      PWR_CR7_WUP22_Msk
#define PWR_CR7_WUP21_Pos                                                  (9UL)		/*!<PWR CR7: WUP21 (Bit 9) */
#define PWR_CR7_WUP21_Msk                                                  (0x200UL)		/*!< PWR CR7: WUP21 (Bitfield-Mask: 0x01) */
#define PWR_CR7_WUP21                                                      PWR_CR7_WUP21_Msk
#define PWR_CR7_WUP20_Pos                                                  (8UL)		/*!<PWR CR7: WUP20 (Bit 8) */
#define PWR_CR7_WUP20_Msk                                                  (0x100UL)		/*!< PWR CR7: WUP20 (Bitfield-Mask: 0x01) */
#define PWR_CR7_WUP20                                                      PWR_CR7_WUP20_Msk
#define PWR_CR7_WUP19_Pos                                                  (7UL)		/*!<PWR CR7: WUP19 (Bit 7) */
#define PWR_CR7_WUP19_Msk                                                  (0x80UL)		/*!< PWR CR7: WUP19 (Bitfield-Mask: 0x01) */
#define PWR_CR7_WUP19                                                      PWR_CR7_WUP19_Msk
#define PWR_CR7_WUP18_Pos                                                  (6UL)		/*!<PWR CR7: WUP18 (Bit 6) */
#define PWR_CR7_WUP18_Msk                                                  (0x40UL)		/*!< PWR CR7: WUP18 (Bitfield-Mask: 0x01) */
#define PWR_CR7_WUP18                                                      PWR_CR7_WUP18_Msk
#define PWR_CR7_WUP17_Pos                                                  (5UL)		/*!<PWR CR7: WUP17 (Bit 5) */
#define PWR_CR7_WUP17_Msk                                                  (0x20UL)		/*!< PWR CR7: WUP17 (Bitfield-Mask: 0x01) */
#define PWR_CR7_WUP17                                                      PWR_CR7_WUP17_Msk
#define PWR_CR7_WUP16_Pos                                                  (4UL)		/*!<PWR CR7: WUP16 (Bit 4) */
#define PWR_CR7_WUP16_Msk                                                  (0x10UL)		/*!< PWR CR7: WUP16 (Bitfield-Mask: 0x01) */
#define PWR_CR7_WUP16                                                      PWR_CR7_WUP16_Msk
#define PWR_CR7_WUP15_Pos                                                  (3UL)		/*!<PWR CR7: WUP15 (Bit 3) */
#define PWR_CR7_WUP15_Msk                                                  (0x8UL)		/*!< PWR CR7: WUP15 (Bitfield-Mask: 0x01) */
#define PWR_CR7_WUP15                                                      PWR_CR7_WUP15_Msk
#define PWR_CR7_WUP14_Pos                                                  (2UL)		/*!<PWR CR7: WUP14 (Bit 2) */
#define PWR_CR7_WUP14_Msk                                                  (0x4UL)		/*!< PWR CR7: WUP14 (Bitfield-Mask: 0x01) */
#define PWR_CR7_WUP14                                                      PWR_CR7_WUP14_Msk
#define PWR_CR7_WUP13_Pos                                                  (1UL)		/*!<PWR CR7: WUP13 (Bit 1) */
#define PWR_CR7_WUP13_Msk                                                  (0x2UL)		/*!< PWR CR7: WUP13 (Bitfield-Mask: 0x01) */
#define PWR_CR7_WUP13                                                      PWR_CR7_WUP13_Msk
#define PWR_CR7_WUP12_Pos                                                  (0UL)		/*!<PWR CR7: WUP12 (Bit 0) */
#define PWR_CR7_WUP12_Msk                                                  (0x1UL)		/*!< PWR CR7: WUP12 (Bitfield-Mask: 0x01) */
#define PWR_CR7_WUP12                                                      PWR_CR7_WUP12_Msk

/* =====================================================    SR3    ===================================================== */ 
#define PWR_SR3_WUF27_Pos                                                  (15UL)		/*!<PWR SR3: WUF27 (Bit 15) */
#define PWR_SR3_WUF27_Msk                                                  (0x8000UL)		/*!< PWR SR3: WUF27 (Bitfield-Mask: 0x01) */
#define PWR_SR3_WUF27                                                      PWR_SR3_WUF27_Msk
#define PWR_SR3_WUF26_Pos                                                  (14UL)		/*!<PWR SR3: WUF26 (Bit 14) */
#define PWR_SR3_WUF26_Msk                                                  (0x4000UL)		/*!< PWR SR3: WUF26 (Bitfield-Mask: 0x01) */
#define PWR_SR3_WUF26                                                      PWR_SR3_WUF26_Msk
#define PWR_SR3_WUF25_Pos                                                  (13UL)		/*!<PWR SR3: WUF25 (Bit 13) */
#define PWR_SR3_WUF25_Msk                                                  (0x2000UL)		/*!< PWR SR3: WUF25 (Bitfield-Mask: 0x01) */
#define PWR_SR3_WUF25                                                      PWR_SR3_WUF25_Msk
#define PWR_SR3_WUF24_Pos                                                  (12UL)		/*!<PWR SR3: WUF24 (Bit 12) */
#define PWR_SR3_WUF24_Msk                                                  (0x1000UL)		/*!< PWR SR3: WUF24 (Bitfield-Mask: 0x01) */
#define PWR_SR3_WUF24                                                      PWR_SR3_WUF24_Msk
#define PWR_SR3_WUF23_Pos                                                  (11UL)		/*!<PWR SR3: WUF23 (Bit 11) */
#define PWR_SR3_WUF23_Msk                                                  (0x800UL)		/*!< PWR SR3: WUF23 (Bitfield-Mask: 0x01) */
#define PWR_SR3_WUF23                                                      PWR_SR3_WUF23_Msk
#define PWR_SR3_WUF22_Pos                                                  (10UL)		/*!<PWR SR3: WUF22 (Bit 10) */
#define PWR_SR3_WUF22_Msk                                                  (0x400UL)		/*!< PWR SR3: WUF22 (Bitfield-Mask: 0x01) */
#define PWR_SR3_WUF22                                                      PWR_SR3_WUF22_Msk
#define PWR_SR3_WUF21_Pos                                                  (9UL)		/*!<PWR SR3: WUF21 (Bit 9) */
#define PWR_SR3_WUF21_Msk                                                  (0x200UL)		/*!< PWR SR3: WUF21 (Bitfield-Mask: 0x01) */
#define PWR_SR3_WUF21                                                      PWR_SR3_WUF21_Msk
#define PWR_SR3_WUF20_Pos                                                  (8UL)		/*!<PWR SR3: WUF20 (Bit 8) */
#define PWR_SR3_WUF20_Msk                                                  (0x100UL)		/*!< PWR SR3: WUF20 (Bitfield-Mask: 0x01) */
#define PWR_SR3_WUF20                                                      PWR_SR3_WUF20_Msk
#define PWR_SR3_WUF19_Pos                                                  (7UL)		/*!<PWR SR3: WUF19 (Bit 7) */
#define PWR_SR3_WUF19_Msk                                                  (0x80UL)		/*!< PWR SR3: WUF19 (Bitfield-Mask: 0x01) */
#define PWR_SR3_WUF19                                                      PWR_SR3_WUF19_Msk
#define PWR_SR3_WUF18_Pos                                                  (6UL)		/*!<PWR SR3: WUF18 (Bit 6) */
#define PWR_SR3_WUF18_Msk                                                  (0x40UL)		/*!< PWR SR3: WUF18 (Bitfield-Mask: 0x01) */
#define PWR_SR3_WUF18                                                      PWR_SR3_WUF18_Msk
#define PWR_SR3_WUF17_Pos                                                  (5UL)		/*!<PWR SR3: WUF17 (Bit 5) */
#define PWR_SR3_WUF17_Msk                                                  (0x20UL)		/*!< PWR SR3: WUF17 (Bitfield-Mask: 0x01) */
#define PWR_SR3_WUF17                                                      PWR_SR3_WUF17_Msk
#define PWR_SR3_WUF16_Pos                                                  (4UL)		/*!<PWR SR3: WUF16 (Bit 4) */
#define PWR_SR3_WUF16_Msk                                                  (0x10UL)		/*!< PWR SR3: WUF16 (Bitfield-Mask: 0x01) */
#define PWR_SR3_WUF16                                                      PWR_SR3_WUF16_Msk
#define PWR_SR3_WUF15_Pos                                                  (3UL)		/*!<PWR SR3: WUF15 (Bit 3) */
#define PWR_SR3_WUF15_Msk                                                  (0x8UL)		/*!< PWR SR3: WUF15 (Bitfield-Mask: 0x01) */
#define PWR_SR3_WUF15                                                      PWR_SR3_WUF15_Msk
#define PWR_SR3_WUF14_Pos                                                  (2UL)		/*!<PWR SR3: WUF14 (Bit 2) */
#define PWR_SR3_WUF14_Msk                                                  (0x4UL)		/*!< PWR SR3: WUF14 (Bitfield-Mask: 0x01) */
#define PWR_SR3_WUF14                                                      PWR_SR3_WUF14_Msk
#define PWR_SR3_WUF13_Pos                                                  (1UL)		/*!<PWR SR3: WUF13 (Bit 1) */
#define PWR_SR3_WUF13_Msk                                                  (0x2UL)		/*!< PWR SR3: WUF13 (Bitfield-Mask: 0x01) */
#define PWR_SR3_WUF13                                                      PWR_SR3_WUF13_Msk
#define PWR_SR3_WUF12_Pos                                                  (0UL)		/*!<PWR SR3: WUF12 (Bit 0) */
#define PWR_SR3_WUF12_Msk                                                  (0x1UL)		/*!< PWR SR3: WUF12 (Bitfield-Mask: 0x01) */
#define PWR_SR3_WUF12                                                      PWR_SR3_WUF12_Msk

/* =====================================================    IOxCFG    ===================================================== */ 
#define PWR_IOxCFG_IOCFG7_Pos                                              (14UL)		/*!<PWR IOxCFG: IOCFG7 (Bit 14) */
#define PWR_IOxCFG_IOCFG7_Msk                                              (0xc000UL)		/*!< PWR IOxCFG: IOCFG7 (Bitfield-Mask: 0x03) */
#define PWR_IOxCFG_IOCFG7                                                  PWR_IOxCFG_IOCFG7_Msk
#define PWR_IOxCFG_IOCFG7_0                                                (0x1U << PWR_IOxCFG_IOCFG7_Pos)
#define PWR_IOxCFG_IOCFG7_1                                                (0x2U << PWR_IOxCFG_IOCFG7_Pos)
#define PWR_IOxCFG_IOCFG6_Pos                                              (12UL)		/*!<PWR IOxCFG: IOCFG6 (Bit 12) */
#define PWR_IOxCFG_IOCFG6_Msk                                              (0x3000UL)		/*!< PWR IOxCFG: IOCFG6 (Bitfield-Mask: 0x03) */
#define PWR_IOxCFG_IOCFG6                                                  PWR_IOxCFG_IOCFG6_Msk
#define PWR_IOxCFG_IOCFG6_0                                                (0x1U << PWR_IOxCFG_IOCFG6_Pos)
#define PWR_IOxCFG_IOCFG6_1                                                (0x2U << PWR_IOxCFG_IOCFG6_Pos)
#define PWR_IOxCFG_IOCFG5_Pos                                              (10UL)		/*!<PWR IOxCFG: IOCFG5 (Bit 10) */
#define PWR_IOxCFG_IOCFG5_Msk                                              (0xc00UL)		/*!< PWR IOxCFG: IOCFG5 (Bitfield-Mask: 0x03) */
#define PWR_IOxCFG_IOCFG5                                                  PWR_IOxCFG_IOCFG5_Msk
#define PWR_IOxCFG_IOCFG5_0                                                (0x1U << PWR_IOxCFG_IOCFG5_Pos)
#define PWR_IOxCFG_IOCFG5_1                                                (0x2U << PWR_IOxCFG_IOCFG5_Pos)
#define PWR_IOxCFG_IOCFG4_Pos                                              (8UL)		/*!<PWR IOxCFG: IOCFG4 (Bit 8) */
#define PWR_IOxCFG_IOCFG4_Msk                                              (0x300UL)		/*!< PWR IOxCFG: IOCFG4 (Bitfield-Mask: 0x03) */
#define PWR_IOxCFG_IOCFG4                                                  PWR_IOxCFG_IOCFG4_Msk
#define PWR_IOxCFG_IOCFG4_0                                                (0x1U << PWR_IOxCFG_IOCFG4_Pos)
#define PWR_IOxCFG_IOCFG4_1                                                (0x2U << PWR_IOxCFG_IOCFG4_Pos)
#define PWR_IOxCFG_IOCFG3_Pos                                              (6UL)		/*!<PWR IOxCFG: IOCFG3 (Bit 6) */
#define PWR_IOxCFG_IOCFG3_Msk                                              (0xc0UL)		/*!< PWR IOxCFG: IOCFG3 (Bitfield-Mask: 0x03) */
#define PWR_IOxCFG_IOCFG3                                                  PWR_IOxCFG_IOCFG3_Msk
#define PWR_IOxCFG_IOCFG3_0                                                (0x1U << PWR_IOxCFG_IOCFG3_Pos)
#define PWR_IOxCFG_IOCFG3_1                                                (0x2U << PWR_IOxCFG_IOCFG3_Pos)
#define PWR_IOxCFG_IOCFG2_Pos                                              (4UL)		/*!<PWR IOxCFG: IOCFG2 (Bit 4) */
#define PWR_IOxCFG_IOCFG2_Msk                                              (0x30UL)		/*!< PWR IOxCFG: IOCFG2 (Bitfield-Mask: 0x03) */
#define PWR_IOxCFG_IOCFG2                                                  PWR_IOxCFG_IOCFG2_Msk
#define PWR_IOxCFG_IOCFG2_0                                                (0x1U << PWR_IOxCFG_IOCFG2_Pos)
#define PWR_IOxCFG_IOCFG2_1                                                (0x2U << PWR_IOxCFG_IOCFG2_Pos)
#define PWR_IOxCFG_IOCFG1_Pos                                              (2UL)		/*!<PWR IOxCFG: IOCFG1 (Bit 2) */
#define PWR_IOxCFG_IOCFG1_Msk                                              (0xcUL)		/*!< PWR IOxCFG: IOCFG1 (Bitfield-Mask: 0x03) */
#define PWR_IOxCFG_IOCFG1                                                  PWR_IOxCFG_IOCFG1_Msk
#define PWR_IOxCFG_IOCFG1_0                                                (0x1U << PWR_IOxCFG_IOCFG1_Pos)
#define PWR_IOxCFG_IOCFG1_1                                                (0x2U << PWR_IOxCFG_IOCFG1_Pos)
#define PWR_IOxCFG_IOCFG0_Pos                                              (0UL)		/*!<PWR IOxCFG: IOCFG0 (Bit 0) */
#define PWR_IOxCFG_IOCFG0_Msk                                              (0x3UL)		/*!< PWR IOxCFG: IOCFG0 (Bitfield-Mask: 0x03) */
#define PWR_IOxCFG_IOCFG0                                                  PWR_IOxCFG_IOCFG0_Msk
#define PWR_IOxCFG_IOCFG0_0                                                (0x1U << PWR_IOxCFG_IOCFG0_Pos)
#define PWR_IOxCFG_IOCFG0_1                                                (0x2U << PWR_IOxCFG_IOCFG0_Pos)

/* =====================================================    DBGR    ===================================================== */ 
#define PWR_DBGR_DEEPSTOP2_Pos                                             (0UL)		/*!<PWR DBGR: DEEPSTOP2 (Bit 0) */
#define PWR_DBGR_DEEPSTOP2_Msk                                             (0x1UL)		/*!< PWR DBGR: DEEPSTOP2 (Bitfield-Mask: 0x01) */
#define PWR_DBGR_DEEPSTOP2                                                 PWR_DBGR_DEEPSTOP2_Msk

/* =====================================================    EXTSRR    ===================================================== */ 
#define PWR_EXTSRR_RFPHASEF_Pos                                            (10UL)		/*!<PWR EXTSRR: RFPHASEF (Bit 10) */
#define PWR_EXTSRR_RFPHASEF_Msk                                            (0x400UL)		/*!< PWR EXTSRR: RFPHASEF (Bitfield-Mask: 0x01) */
#define PWR_EXTSRR_RFPHASEF                                                PWR_EXTSRR_RFPHASEF_Msk
#define PWR_EXTSRR_DEEPSTOPF_Pos                                           (9UL)		/*!<PWR EXTSRR: DEEPSTOPF (Bit 9) */
#define PWR_EXTSRR_DEEPSTOPF_Msk                                           (0x200UL)		/*!< PWR EXTSRR: DEEPSTOPF (Bitfield-Mask: 0x01) */
#define PWR_EXTSRR_DEEPSTOPF                                               PWR_EXTSRR_DEEPSTOPF_Msk

/* =====================================================    DBGSMPS    ===================================================== */ 
#define PWR_DBGSMPS_TEST_OL_Pos                                            (11UL)		/*!<PWR DBGSMPS: TEST_OL (Bit 11) */
#define PWR_DBGSMPS_TEST_OL_Msk                                            (0x800UL)		/*!< PWR DBGSMPS: TEST_OL (Bitfield-Mask: 0x01) */
#define PWR_DBGSMPS_TEST_OL                                                PWR_DBGSMPS_TEST_OL_Msk
#define PWR_DBGSMPS_DIS_BIG_MOS_Pos                                        (10UL)		/*!<PWR DBGSMPS: DIS_BIG_MOS (Bit 10) */
#define PWR_DBGSMPS_DIS_BIG_MOS_Msk                                        (0x400UL)		/*!< PWR DBGSMPS: DIS_BIG_MOS (Bitfield-Mask: 0x01) */
#define PWR_DBGSMPS_DIS_BIG_MOS                                            PWR_DBGSMPS_DIS_BIG_MOS_Msk
#define PWR_DBGSMPS_CTLRES_RAMP_Pos                                        (9UL)		/*!<PWR DBGSMPS: CTLRES_RAMP (Bit 9) */
#define PWR_DBGSMPS_CTLRES_RAMP_Msk                                        (0x200UL)		/*!< PWR DBGSMPS: CTLRES_RAMP (Bitfield-Mask: 0x01) */
#define PWR_DBGSMPS_CTLRES_RAMP                                            PWR_DBGSMPS_CTLRES_RAMP_Msk
#define PWR_DBGSMPS_TESTILIM_Pos                                           (8UL)		/*!<PWR DBGSMPS: TESTILIM (Bit 8) */
#define PWR_DBGSMPS_TESTILIM_Msk                                           (0x100UL)		/*!< PWR DBGSMPS: TESTILIM (Bitfield-Mask: 0x01) */
#define PWR_DBGSMPS_TESTILIM                                               PWR_DBGSMPS_TESTILIM_Msk
#define PWR_DBGSMPS_NO_STUP_Pos                                            (7UL)		/*!<PWR DBGSMPS: NO_STUP (Bit 7) */
#define PWR_DBGSMPS_NO_STUP_Msk                                            (0x80UL)		/*!< PWR DBGSMPS: NO_STUP (Bitfield-Mask: 0x01) */
#define PWR_DBGSMPS_NO_STUP                                                PWR_DBGSMPS_NO_STUP_Msk
#define PWR_DBGSMPS_HOT_STUP_Pos                                           (6UL)		/*!<PWR DBGSMPS: HOT_STUP (Bit 6) */
#define PWR_DBGSMPS_HOT_STUP_Msk                                           (0x40UL)		/*!< PWR DBGSMPS: HOT_STUP (Bitfield-Mask: 0x01) */
#define PWR_DBGSMPS_HOT_STUP                                               PWR_DBGSMPS_HOT_STUP_Msk
#define PWR_DBGSMPS_TESTKEL_Pos                                            (4UL)		/*!<PWR DBGSMPS: TESTKEL (Bit 4) */
#define PWR_DBGSMPS_TESTKEL_Msk                                            (0x30UL)		/*!< PWR DBGSMPS: TESTKEL (Bitfield-Mask: 0x03) */
#define PWR_DBGSMPS_TESTKEL                                                PWR_DBGSMPS_TESTKEL_Msk
#define PWR_DBGSMPS_TESTKEL_0                                              (0x1U << PWR_DBGSMPS_TESTKEL_Pos)
#define PWR_DBGSMPS_TESTKEL_1                                              (0x2U << PWR_DBGSMPS_TESTKEL_Pos)
#define PWR_DBGSMPS_TESTDIG_Pos                                            (0UL)		/*!<PWR DBGSMPS: TESTDIG (Bit 0) */
#define PWR_DBGSMPS_TESTDIG_Msk                                            (0xfUL)		/*!< PWR DBGSMPS: TESTDIG (Bitfield-Mask: 0x0f) */
#define PWR_DBGSMPS_TESTDIG                                                PWR_DBGSMPS_TESTDIG_Msk
#define PWR_DBGSMPS_TESTDIG_0                                              (0x1U << PWR_DBGSMPS_TESTDIG_Pos)
#define PWR_DBGSMPS_TESTDIG_1                                              (0x2U << PWR_DBGSMPS_TESTDIG_Pos)
#define PWR_DBGSMPS_TESTDIG_2                                              (0x4U << PWR_DBGSMPS_TESTDIG_Pos)
#define PWR_DBGSMPS_TESTDIG_3                                              (0x8U << PWR_DBGSMPS_TESTDIG_Pos)

/* =====================================================    TRIMR    ===================================================== */ 
#define PWR_TRIMR_RAM_SIZE_Pos                                             (12UL)		/*!<PWR TRIMR: RAM_SIZE (Bit 12) */
#define PWR_TRIMR_RAM_SIZE_Msk                                             (0x3000UL)		/*!< PWR TRIMR: RAM_SIZE (Bitfield-Mask: 0x03) */
#define PWR_TRIMR_RAM_SIZE                                                 PWR_TRIMR_RAM_SIZE_Msk
#define PWR_TRIMR_RAM_SIZE_0                                               (0x1U << PWR_TRIMR_RAM_SIZE_Pos)
#define PWR_TRIMR_RAM_SIZE_1                                               (0x2U << PWR_TRIMR_RAM_SIZE_Pos)
#define PWR_TRIMR_SMPS_TRIM_Pos                                            (8UL)		/*!<PWR TRIMR: SMPS_TRIM (Bit 8) */
#define PWR_TRIMR_SMPS_TRIM_Msk                                            (0x700UL)		/*!< PWR TRIMR: SMPS_TRIM (Bitfield-Mask: 0x07) */
#define PWR_TRIMR_SMPS_TRIM                                                PWR_TRIMR_SMPS_TRIM_Msk
#define PWR_TRIMR_SMPS_TRIM_0                                              (0x1U << PWR_TRIMR_SMPS_TRIM_Pos)
#define PWR_TRIMR_SMPS_TRIM_1                                              (0x2U << PWR_TRIMR_SMPS_TRIM_Pos)
#define PWR_TRIMR_SMPS_TRIM_2                                              (0x4U << PWR_TRIMR_SMPS_TRIM_Pos)
#define PWR_TRIMR_TRIM_MR_Pos                                              (4UL)		/*!<PWR TRIMR: TRIM_MR (Bit 4) */
#define PWR_TRIMR_TRIM_MR_Msk                                              (0xf0UL)		/*!< PWR TRIMR: TRIM_MR (Bitfield-Mask: 0x0f) */
#define PWR_TRIMR_TRIM_MR                                                  PWR_TRIMR_TRIM_MR_Msk
#define PWR_TRIMR_TRIM_MR_0                                                (0x1U << PWR_TRIMR_TRIM_MR_Pos)
#define PWR_TRIMR_TRIM_MR_1                                                (0x2U << PWR_TRIMR_TRIM_MR_Pos)
#define PWR_TRIMR_TRIM_MR_2                                                (0x4U << PWR_TRIMR_TRIM_MR_Pos)
#define PWR_TRIMR_TRIM_MR_3                                                (0x8U << PWR_TRIMR_TRIM_MR_Pos)
#define PWR_TRIMR_TRIM_LSI_LPMU_Pos                                        (0UL)		/*!<PWR TRIMR: TRIM_LSI_LPMU (Bit 0) */
#define PWR_TRIMR_TRIM_LSI_LPMU_Msk                                        (0xfUL)		/*!< PWR TRIMR: TRIM_LSI_LPMU (Bitfield-Mask: 0x0f) */
#define PWR_TRIMR_TRIM_LSI_LPMU                                            PWR_TRIMR_TRIM_LSI_LPMU_Msk
#define PWR_TRIMR_TRIM_LSI_LPMU_0                                          (0x1U << PWR_TRIMR_TRIM_LSI_LPMU_Pos)
#define PWR_TRIMR_TRIM_LSI_LPMU_1                                          (0x2U << PWR_TRIMR_TRIM_LSI_LPMU_Pos)
#define PWR_TRIMR_TRIM_LSI_LPMU_2                                          (0x4U << PWR_TRIMR_TRIM_LSI_LPMU_Pos)
#define PWR_TRIMR_TRIM_LSI_LPMU_3                                          (0x8U << PWR_TRIMR_TRIM_LSI_LPMU_Pos)

/* =====================================================    ENGTRIM    ===================================================== */ 
#define PWR_ENGTRIM_SMPS_TRIM_Pos                                          (11UL)		/*!<PWR ENGTRIM: SMPS_TRIM (Bit 11) */
#define PWR_ENGTRIM_SMPS_TRIM_Msk                                          (0x3800UL)		/*!< PWR ENGTRIM: SMPS_TRIM (Bitfield-Mask: 0x07) */
#define PWR_ENGTRIM_SMPS_TRIM                                              PWR_ENGTRIM_SMPS_TRIM_Msk
#define PWR_ENGTRIM_SMPS_TRIM_0                                            (0x1U << PWR_ENGTRIM_SMPS_TRIM_Pos)
#define PWR_ENGTRIM_SMPS_TRIM_1                                            (0x2U << PWR_ENGTRIM_SMPS_TRIM_Pos)
#define PWR_ENGTRIM_SMPS_TRIM_2                                            (0x4U << PWR_ENGTRIM_SMPS_TRIM_Pos)
#define PWR_ENGTRIM_SMPSTRIMEN_Pos                                         (10UL)		/*!<PWR ENGTRIM: SMPSTRIMEN (Bit 10) */
#define PWR_ENGTRIM_SMPSTRIMEN_Msk                                         (0x400UL)		/*!< PWR ENGTRIM: SMPSTRIMEN (Bitfield-Mask: 0x01) */
#define PWR_ENGTRIM_SMPSTRIMEN                                             PWR_ENGTRIM_SMPSTRIMEN_Msk
#define PWR_ENGTRIM_TRIM_MR_Pos                                            (6UL)		/*!<PWR ENGTRIM: TRIM_MR (Bit 6) */
#define PWR_ENGTRIM_TRIM_MR_Msk                                            (0x3c0UL)		/*!< PWR ENGTRIM: TRIM_MR (Bitfield-Mask: 0x0f) */
#define PWR_ENGTRIM_TRIM_MR                                                PWR_ENGTRIM_TRIM_MR_Msk
#define PWR_ENGTRIM_TRIM_MR_0                                              (0x1U << PWR_ENGTRIM_TRIM_MR_Pos)
#define PWR_ENGTRIM_TRIM_MR_1                                              (0x2U << PWR_ENGTRIM_TRIM_MR_Pos)
#define PWR_ENGTRIM_TRIM_MR_2                                              (0x4U << PWR_ENGTRIM_TRIM_MR_Pos)
#define PWR_ENGTRIM_TRIM_MR_3                                              (0x8U << PWR_ENGTRIM_TRIM_MR_Pos)
#define PWR_ENGTRIM_TRIMMREN_Pos                                           (5UL)		/*!<PWR ENGTRIM: TRIMMREN (Bit 5) */
#define PWR_ENGTRIM_TRIMMREN_Msk                                           (0x20UL)		/*!< PWR ENGTRIM: TRIMMREN (Bitfield-Mask: 0x01) */
#define PWR_ENGTRIM_TRIMMREN                                               PWR_ENGTRIM_TRIMMREN_Msk
#define PWR_ENGTRIM_TRIM_LSI_LPMU_Pos                                      (1UL)		/*!<PWR ENGTRIM: TRIM_LSI_LPMU (Bit 1) */
#define PWR_ENGTRIM_TRIM_LSI_LPMU_Msk                                      (0x1eUL)		/*!< PWR ENGTRIM: TRIM_LSI_LPMU (Bitfield-Mask: 0x0f) */
#define PWR_ENGTRIM_TRIM_LSI_LPMU                                          PWR_ENGTRIM_TRIM_LSI_LPMU_Msk
#define PWR_ENGTRIM_TRIM_LSI_LPMU_0                                        (0x1U << PWR_ENGTRIM_TRIM_LSI_LPMU_Pos)
#define PWR_ENGTRIM_TRIM_LSI_LPMU_1                                        (0x2U << PWR_ENGTRIM_TRIM_LSI_LPMU_Pos)
#define PWR_ENGTRIM_TRIM_LSI_LPMU_2                                        (0x4U << PWR_ENGTRIM_TRIM_LSI_LPMU_Pos)
#define PWR_ENGTRIM_TRIM_LSI_LPMU_3                                        (0x8U << PWR_ENGTRIM_TRIM_LSI_LPMU_Pos)
#define PWR_ENGTRIM_TRIMLSILPMUEN_Pos                                      (0UL)		/*!<PWR ENGTRIM: TRIMLSILPMUEN (Bit 0) */
#define PWR_ENGTRIM_TRIMLSILPMUEN_Msk                                      (0x1UL)		/*!< PWR ENGTRIM: TRIMLSILPMUEN (Bitfield-Mask: 0x01) */
#define PWR_ENGTRIM_TRIMLSILPMUEN                                          PWR_ENGTRIM_TRIMLSILPMUEN_Msk

/* =====================================================    DBG1    ===================================================== */ 
#define PWR_DBG1_FLASH_FSM_STATE_Pos                                       (8UL)		/*!<PWR DBG1: FLASH_FSM_STATE (Bit 8) */
#define PWR_DBG1_FLASH_FSM_STATE_Msk                                       (0x700UL)		/*!< PWR DBG1: FLASH_FSM_STATE (Bitfield-Mask: 0x07) */
#define PWR_DBG1_FLASH_FSM_STATE                                           PWR_DBG1_FLASH_FSM_STATE_Msk
#define PWR_DBG1_FLASH_FSM_STATE_0                                         (0x1U << PWR_DBG1_FLASH_FSM_STATE_Pos)
#define PWR_DBG1_FLASH_FSM_STATE_1                                         (0x2U << PWR_DBG1_FLASH_FSM_STATE_Pos)
#define PWR_DBG1_FLASH_FSM_STATE_2                                         (0x4U << PWR_DBG1_FLASH_FSM_STATE_Pos)
#define PWR_DBG1_SMPS_FSM_STATE_Pos                                        (0UL)		/*!<PWR DBG1: SMPS_FSM_STATE (Bit 0) */
#define PWR_DBG1_SMPS_FSM_STATE_Msk                                        (0x7UL)		/*!< PWR DBG1: SMPS_FSM_STATE (Bitfield-Mask: 0x07) */
#define PWR_DBG1_SMPS_FSM_STATE                                            PWR_DBG1_SMPS_FSM_STATE_Msk
#define PWR_DBG1_SMPS_FSM_STATE_0                                          (0x1U << PWR_DBG1_SMPS_FSM_STATE_Pos)
#define PWR_DBG1_SMPS_FSM_STATE_1                                          (0x2U << PWR_DBG1_SMPS_FSM_STATE_Pos)
#define PWR_DBG1_SMPS_FSM_STATE_2                                          (0x4U << PWR_DBG1_SMPS_FSM_STATE_Pos)

/* =====================================================    DBG2    ===================================================== */ 
#define PWR_DBG2_RAM_FSM_STATE_Pos                                         (8UL)		/*!<PWR DBG2: RAM_FSM_STATE (Bit 8) */
#define PWR_DBG2_RAM_FSM_STATE_Msk                                         (0x300UL)		/*!< PWR DBG2: RAM_FSM_STATE (Bitfield-Mask: 0x03) */
#define PWR_DBG2_RAM_FSM_STATE                                             PWR_DBG2_RAM_FSM_STATE_Msk
#define PWR_DBG2_RAM_FSM_STATE_0                                           (0x1U << PWR_DBG2_RAM_FSM_STATE_Pos)
#define PWR_DBG2_RAM_FSM_STATE_1                                           (0x2U << PWR_DBG2_RAM_FSM_STATE_Pos)
#define PWR_DBG2_PMU_FSM_STATE_Pos                                         (0UL)		/*!<PWR DBG2: PMU_FSM_STATE (Bit 0) */
#define PWR_DBG2_PMU_FSM_STATE_Msk                                         (0xfUL)		/*!< PWR DBG2: PMU_FSM_STATE (Bitfield-Mask: 0x0f) */
#define PWR_DBG2_PMU_FSM_STATE                                             PWR_DBG2_PMU_FSM_STATE_Msk
#define PWR_DBG2_PMU_FSM_STATE_0                                           (0x1U << PWR_DBG2_PMU_FSM_STATE_Pos)
#define PWR_DBG2_PMU_FSM_STATE_1                                           (0x2U << PWR_DBG2_PMU_FSM_STATE_Pos)
#define PWR_DBG2_PMU_FSM_STATE_2                                           (0x4U << PWR_DBG2_PMU_FSM_STATE_Pos)
#define PWR_DBG2_PMU_FSM_STATE_3                                           (0x8U << PWR_DBG2_PMU_FSM_STATE_Pos)


/* =========================================================================================================================== */ 
/*=====================                                      SYSCFG                                      ===================== */ 
/* =========================================================================================================================== */ 

/* =====================================================    DIE_ID    ===================================================== */ 
#define SYSCFG_DIE_ID_PRODUCT_Pos                                          (8UL)		/*!<SYSCFG DIE_ID: PRODUCT (Bit 8) */
#define SYSCFG_DIE_ID_PRODUCT_Msk                                          (0xf00UL)		/*!< SYSCFG DIE_ID: PRODUCT (Bitfield-Mask: 0x0f) */
#define SYSCFG_DIE_ID_PRODUCT                                              SYSCFG_DIE_ID_PRODUCT_Msk
#define SYSCFG_DIE_ID_PRODUCT_0                                            (0x1U << SYSCFG_DIE_ID_PRODUCT_Pos)
#define SYSCFG_DIE_ID_PRODUCT_1                                            (0x2U << SYSCFG_DIE_ID_PRODUCT_Pos)
#define SYSCFG_DIE_ID_PRODUCT_2                                            (0x4U << SYSCFG_DIE_ID_PRODUCT_Pos)
#define SYSCFG_DIE_ID_PRODUCT_3                                            (0x8U << SYSCFG_DIE_ID_PRODUCT_Pos)
#define SYSCFG_DIE_ID_VERSION_Pos                                          (4UL)		/*!<SYSCFG DIE_ID: VERSION (Bit 4) */
#define SYSCFG_DIE_ID_VERSION_Msk                                          (0xf0UL)		/*!< SYSCFG DIE_ID: VERSION (Bitfield-Mask: 0x0f) */
#define SYSCFG_DIE_ID_VERSION                                              SYSCFG_DIE_ID_VERSION_Msk
#define SYSCFG_DIE_ID_VERSION_0                                            (0x1U << SYSCFG_DIE_ID_VERSION_Pos)
#define SYSCFG_DIE_ID_VERSION_1                                            (0x2U << SYSCFG_DIE_ID_VERSION_Pos)
#define SYSCFG_DIE_ID_VERSION_2                                            (0x4U << SYSCFG_DIE_ID_VERSION_Pos)
#define SYSCFG_DIE_ID_VERSION_3                                            (0x8U << SYSCFG_DIE_ID_VERSION_Pos)
#define SYSCFG_DIE_ID_REVISION_Pos                                         (0UL)		/*!<SYSCFG DIE_ID: REVISION (Bit 0) */
#define SYSCFG_DIE_ID_REVISION_Msk                                         (0xfUL)		/*!< SYSCFG DIE_ID: REVISION (Bitfield-Mask: 0x0f) */
#define SYSCFG_DIE_ID_REVISION                                             SYSCFG_DIE_ID_REVISION_Msk
#define SYSCFG_DIE_ID_REVISION_0                                           (0x1U << SYSCFG_DIE_ID_REVISION_Pos)
#define SYSCFG_DIE_ID_REVISION_1                                           (0x2U << SYSCFG_DIE_ID_REVISION_Pos)
#define SYSCFG_DIE_ID_REVISION_2                                           (0x4U << SYSCFG_DIE_ID_REVISION_Pos)
#define SYSCFG_DIE_ID_REVISION_3                                           (0x8U << SYSCFG_DIE_ID_REVISION_Pos)

/* =====================================================    JTAG_ID    ===================================================== */ 
#define SYSCFG_JTAG_ID_VERSION_NUMBER_Pos                                  (28UL)		/*!<SYSCFG JTAG_ID: VERSION_NUMBER (Bit 28) */
#define SYSCFG_JTAG_ID_VERSION_NUMBER_Msk                                  (0xf0000000UL)		/*!< SYSCFG JTAG_ID: VERSION_NUMBER (Bitfield-Mask: 0x0f) */
#define SYSCFG_JTAG_ID_VERSION_NUMBER                                      SYSCFG_JTAG_ID_VERSION_NUMBER_Msk
#define SYSCFG_JTAG_ID_VERSION_NUMBER_0                                    (0x1U << SYSCFG_JTAG_ID_VERSION_NUMBER_Pos)
#define SYSCFG_JTAG_ID_VERSION_NUMBER_1                                    (0x2U << SYSCFG_JTAG_ID_VERSION_NUMBER_Pos)
#define SYSCFG_JTAG_ID_VERSION_NUMBER_2                                    (0x4U << SYSCFG_JTAG_ID_VERSION_NUMBER_Pos)
#define SYSCFG_JTAG_ID_VERSION_NUMBER_3                                    (0x8U << SYSCFG_JTAG_ID_VERSION_NUMBER_Pos)
#define SYSCFG_JTAG_ID_PART_NUMBER_Pos                                     (12UL)		/*!<SYSCFG JTAG_ID: PART_NUMBER (Bit 12) */
#define SYSCFG_JTAG_ID_PART_NUMBER_Msk                                     (0xffff000UL)		/*!< SYSCFG JTAG_ID: PART_NUMBER (Bitfield-Mask: 0xffff) */
#define SYSCFG_JTAG_ID_PART_NUMBER                                         SYSCFG_JTAG_ID_PART_NUMBER_Msk
#define SYSCFG_JTAG_ID_PART_NUMBER_0                                       (0x1U << SYSCFG_JTAG_ID_PART_NUMBER_Pos)
#define SYSCFG_JTAG_ID_PART_NUMBER_1                                       (0x2U << SYSCFG_JTAG_ID_PART_NUMBER_Pos)
#define SYSCFG_JTAG_ID_PART_NUMBER_2                                       (0x4U << SYSCFG_JTAG_ID_PART_NUMBER_Pos)
#define SYSCFG_JTAG_ID_PART_NUMBER_3                                       (0x8U << SYSCFG_JTAG_ID_PART_NUMBER_Pos)
#define SYSCFG_JTAG_ID_PART_NUMBER_4                                       (0x10U << SYSCFG_JTAG_ID_PART_NUMBER_Pos)
#define SYSCFG_JTAG_ID_PART_NUMBER_5                                       (0x20U << SYSCFG_JTAG_ID_PART_NUMBER_Pos)
#define SYSCFG_JTAG_ID_PART_NUMBER_6                                       (0x40U << SYSCFG_JTAG_ID_PART_NUMBER_Pos)
#define SYSCFG_JTAG_ID_PART_NUMBER_7                                       (0x80U << SYSCFG_JTAG_ID_PART_NUMBER_Pos)
#define SYSCFG_JTAG_ID_PART_NUMBER_8                                       (0x100U << SYSCFG_JTAG_ID_PART_NUMBER_Pos)
#define SYSCFG_JTAG_ID_PART_NUMBER_9                                       (0x200U << SYSCFG_JTAG_ID_PART_NUMBER_Pos)
#define SYSCFG_JTAG_ID_PART_NUMBER_10                                      (0x400U << SYSCFG_JTAG_ID_PART_NUMBER_Pos)
#define SYSCFG_JTAG_ID_PART_NUMBER_11                                      (0x800U << SYSCFG_JTAG_ID_PART_NUMBER_Pos)
#define SYSCFG_JTAG_ID_PART_NUMBER_12                                      (0x1000U << SYSCFG_JTAG_ID_PART_NUMBER_Pos)
#define SYSCFG_JTAG_ID_PART_NUMBER_13                                      (0x2000U << SYSCFG_JTAG_ID_PART_NUMBER_Pos)
#define SYSCFG_JTAG_ID_PART_NUMBER_14                                      (0x4000U << SYSCFG_JTAG_ID_PART_NUMBER_Pos)
#define SYSCFG_JTAG_ID_PART_NUMBER_15                                      (0x8000U << SYSCFG_JTAG_ID_PART_NUMBER_Pos)
#define SYSCFG_JTAG_ID_MANUF_ID_Pos                                        (1UL)		/*!<SYSCFG JTAG_ID: MANUF_ID (Bit 1) */
#define SYSCFG_JTAG_ID_MANUF_ID_Msk                                        (0xffeUL)		/*!< SYSCFG JTAG_ID: MANUF_ID (Bitfield-Mask: 0x7ff) */
#define SYSCFG_JTAG_ID_MANUF_ID                                            SYSCFG_JTAG_ID_MANUF_ID_Msk
#define SYSCFG_JTAG_ID_MANUF_ID_0                                          (0x1U << SYSCFG_JTAG_ID_MANUF_ID_Pos)
#define SYSCFG_JTAG_ID_MANUF_ID_1                                          (0x2U << SYSCFG_JTAG_ID_MANUF_ID_Pos)
#define SYSCFG_JTAG_ID_MANUF_ID_2                                          (0x4U << SYSCFG_JTAG_ID_MANUF_ID_Pos)
#define SYSCFG_JTAG_ID_MANUF_ID_3                                          (0x8U << SYSCFG_JTAG_ID_MANUF_ID_Pos)
#define SYSCFG_JTAG_ID_MANUF_ID_4                                          (0x10U << SYSCFG_JTAG_ID_MANUF_ID_Pos)
#define SYSCFG_JTAG_ID_MANUF_ID_5                                          (0x20U << SYSCFG_JTAG_ID_MANUF_ID_Pos)
#define SYSCFG_JTAG_ID_MANUF_ID_6                                          (0x40U << SYSCFG_JTAG_ID_MANUF_ID_Pos)
#define SYSCFG_JTAG_ID_MANUF_ID_7                                          (0x80U << SYSCFG_JTAG_ID_MANUF_ID_Pos)
#define SYSCFG_JTAG_ID_MANUF_ID_8                                          (0x100U << SYSCFG_JTAG_ID_MANUF_ID_Pos)
#define SYSCFG_JTAG_ID_MANUF_ID_9                                          (0x200U << SYSCFG_JTAG_ID_MANUF_ID_Pos)
#define SYSCFG_JTAG_ID_MANUF_ID_10                                         (0x400U << SYSCFG_JTAG_ID_MANUF_ID_Pos)

/* =====================================================    I2C_FMP_CTRL    ===================================================== */ 
#define SYSCFG_I2C_FMP_CTRL_I2C2_PB7_FMP_Pos                               (3UL)		/*!<SYSCFG I2C_FMP_CTRL: I2C2_PB7_FMP (Bit 3) */
#define SYSCFG_I2C_FMP_CTRL_I2C2_PB7_FMP_Msk                               (0x8UL)		/*!< SYSCFG I2C_FMP_CTRL: I2C2_PB7_FMP (Bitfield-Mask: 0x01) */
#define SYSCFG_I2C_FMP_CTRL_I2C2_PB7_FMP                                   SYSCFG_I2C_FMP_CTRL_I2C2_PB7_FMP_Msk
#define SYSCFG_I2C_FMP_CTRL_I2C2_PB6_FMP_Pos                               (2UL)		/*!<SYSCFG I2C_FMP_CTRL: I2C2_PB6_FMP (Bit 2) */
#define SYSCFG_I2C_FMP_CTRL_I2C2_PB6_FMP_Msk                               (0x4UL)		/*!< SYSCFG I2C_FMP_CTRL: I2C2_PB6_FMP (Bitfield-Mask: 0x01) */
#define SYSCFG_I2C_FMP_CTRL_I2C2_PB6_FMP                                   SYSCFG_I2C_FMP_CTRL_I2C2_PB6_FMP_Msk
#define SYSCFG_I2C_FMP_CTRL_I2C1_PA1_FMP_Pos                               (1UL)		/*!<SYSCFG I2C_FMP_CTRL: I2C1_PA1_FMP (Bit 1) */
#define SYSCFG_I2C_FMP_CTRL_I2C1_PA1_FMP_Msk                               (0x2UL)		/*!< SYSCFG I2C_FMP_CTRL: I2C1_PA1_FMP (Bitfield-Mask: 0x01) */
#define SYSCFG_I2C_FMP_CTRL_I2C1_PA1_FMP                                   SYSCFG_I2C_FMP_CTRL_I2C1_PA1_FMP_Msk
#define SYSCFG_I2C_FMP_CTRL_I2C1_PA0_FMP_Pos                               (0UL)		/*!<SYSCFG I2C_FMP_CTRL: I2C1_PA0_FMP (Bit 0) */
#define SYSCFG_I2C_FMP_CTRL_I2C1_PA0_FMP_Msk                               (0x1UL)		/*!< SYSCFG I2C_FMP_CTRL: I2C1_PA0_FMP (Bitfield-Mask: 0x01) */
#define SYSCFG_I2C_FMP_CTRL_I2C1_PA0_FMP                                   SYSCFG_I2C_FMP_CTRL_I2C1_PA0_FMP_Msk

/* =====================================================    IO_DTR    ===================================================== */ 
#define SYSCFG_IO_DTR_PB15_DT_Pos                                          (31UL)		/*!<SYSCFG IO_DTR: PB15_DT (Bit 31) */
#define SYSCFG_IO_DTR_PB15_DT_Msk                                          (0x80000000UL)		/*!< SYSCFG IO_DTR: PB15_DT (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_DTR_PB15_DT                                              SYSCFG_IO_DTR_PB15_DT_Msk
#define SYSCFG_IO_DTR_PB14_DT_Pos                                          (30UL)		/*!<SYSCFG IO_DTR: PB14_DT (Bit 30) */
#define SYSCFG_IO_DTR_PB14_DT_Msk                                          (0x40000000UL)		/*!< SYSCFG IO_DTR: PB14_DT (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_DTR_PB14_DT                                              SYSCFG_IO_DTR_PB14_DT_Msk
#define SYSCFG_IO_DTR_PB13_DT_Pos                                          (29UL)		/*!<SYSCFG IO_DTR: PB13_DT (Bit 29) */
#define SYSCFG_IO_DTR_PB13_DT_Msk                                          (0x20000000UL)		/*!< SYSCFG IO_DTR: PB13_DT (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_DTR_PB13_DT                                              SYSCFG_IO_DTR_PB13_DT_Msk
#define SYSCFG_IO_DTR_PB12_DT_Pos                                          (28UL)		/*!<SYSCFG IO_DTR: PB12_DT (Bit 28) */
#define SYSCFG_IO_DTR_PB12_DT_Msk                                          (0x10000000UL)		/*!< SYSCFG IO_DTR: PB12_DT (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_DTR_PB12_DT                                              SYSCFG_IO_DTR_PB12_DT_Msk
#define SYSCFG_IO_DTR_PB11_DT_Pos                                          (27UL)		/*!<SYSCFG IO_DTR: PB11_DT (Bit 27) */
#define SYSCFG_IO_DTR_PB11_DT_Msk                                          (0x8000000UL)		/*!< SYSCFG IO_DTR: PB11_DT (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_DTR_PB11_DT                                              SYSCFG_IO_DTR_PB11_DT_Msk
#define SYSCFG_IO_DTR_PB10_DT_Pos                                          (26UL)		/*!<SYSCFG IO_DTR: PB10_DT (Bit 26) */
#define SYSCFG_IO_DTR_PB10_DT_Msk                                          (0x4000000UL)		/*!< SYSCFG IO_DTR: PB10_DT (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_DTR_PB10_DT                                              SYSCFG_IO_DTR_PB10_DT_Msk
#define SYSCFG_IO_DTR_PB9_DT_Pos                                           (25UL)		/*!<SYSCFG IO_DTR: PB9_DT (Bit 25) */
#define SYSCFG_IO_DTR_PB9_DT_Msk                                           (0x2000000UL)		/*!< SYSCFG IO_DTR: PB9_DT (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_DTR_PB9_DT                                               SYSCFG_IO_DTR_PB9_DT_Msk
#define SYSCFG_IO_DTR_PB8_DT_Pos                                           (24UL)		/*!<SYSCFG IO_DTR: PB8_DT (Bit 24) */
#define SYSCFG_IO_DTR_PB8_DT_Msk                                           (0x1000000UL)		/*!< SYSCFG IO_DTR: PB8_DT (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_DTR_PB8_DT                                               SYSCFG_IO_DTR_PB8_DT_Msk
#define SYSCFG_IO_DTR_PB7_DT_Pos                                           (23UL)		/*!<SYSCFG IO_DTR: PB7_DT (Bit 23) */
#define SYSCFG_IO_DTR_PB7_DT_Msk                                           (0x800000UL)		/*!< SYSCFG IO_DTR: PB7_DT (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_DTR_PB7_DT                                               SYSCFG_IO_DTR_PB7_DT_Msk
#define SYSCFG_IO_DTR_PB6_DT_Pos                                           (22UL)		/*!<SYSCFG IO_DTR: PB6_DT (Bit 22) */
#define SYSCFG_IO_DTR_PB6_DT_Msk                                           (0x400000UL)		/*!< SYSCFG IO_DTR: PB6_DT (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_DTR_PB6_DT                                               SYSCFG_IO_DTR_PB6_DT_Msk
#define SYSCFG_IO_DTR_PB5_DT_Pos                                           (21UL)		/*!<SYSCFG IO_DTR: PB5_DT (Bit 21) */
#define SYSCFG_IO_DTR_PB5_DT_Msk                                           (0x200000UL)		/*!< SYSCFG IO_DTR: PB5_DT (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_DTR_PB5_DT                                               SYSCFG_IO_DTR_PB5_DT_Msk
#define SYSCFG_IO_DTR_PB4_DT_Pos                                           (20UL)		/*!<SYSCFG IO_DTR: PB4_DT (Bit 20) */
#define SYSCFG_IO_DTR_PB4_DT_Msk                                           (0x100000UL)		/*!< SYSCFG IO_DTR: PB4_DT (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_DTR_PB4_DT                                               SYSCFG_IO_DTR_PB4_DT_Msk
#define SYSCFG_IO_DTR_PB3_DT_Pos                                           (19UL)		/*!<SYSCFG IO_DTR: PB3_DT (Bit 19) */
#define SYSCFG_IO_DTR_PB3_DT_Msk                                           (0x80000UL)		/*!< SYSCFG IO_DTR: PB3_DT (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_DTR_PB3_DT                                               SYSCFG_IO_DTR_PB3_DT_Msk
#define SYSCFG_IO_DTR_PB2_DT_Pos                                           (18UL)		/*!<SYSCFG IO_DTR: PB2_DT (Bit 18) */
#define SYSCFG_IO_DTR_PB2_DT_Msk                                           (0x40000UL)		/*!< SYSCFG IO_DTR: PB2_DT (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_DTR_PB2_DT                                               SYSCFG_IO_DTR_PB2_DT_Msk
#define SYSCFG_IO_DTR_PB1_DT_Pos                                           (17UL)		/*!<SYSCFG IO_DTR: PB1_DT (Bit 17) */
#define SYSCFG_IO_DTR_PB1_DT_Msk                                           (0x20000UL)		/*!< SYSCFG IO_DTR: PB1_DT (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_DTR_PB1_DT                                               SYSCFG_IO_DTR_PB1_DT_Msk
#define SYSCFG_IO_DTR_PB0_DT_Pos                                           (16UL)		/*!<SYSCFG IO_DTR: PB0_DT (Bit 16) */
#define SYSCFG_IO_DTR_PB0_DT_Msk                                           (0x10000UL)		/*!< SYSCFG IO_DTR: PB0_DT (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_DTR_PB0_DT                                               SYSCFG_IO_DTR_PB0_DT_Msk
#define SYSCFG_IO_DTR_PA15_DT_Pos                                          (15UL)		/*!<SYSCFG IO_DTR: PA15_DT (Bit 15) */
#define SYSCFG_IO_DTR_PA15_DT_Msk                                          (0x8000UL)		/*!< SYSCFG IO_DTR: PA15_DT (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_DTR_PA15_DT                                              SYSCFG_IO_DTR_PA15_DT_Msk
#define SYSCFG_IO_DTR_PA14_DT_Pos                                          (14UL)		/*!<SYSCFG IO_DTR: PA14_DT (Bit 14) */
#define SYSCFG_IO_DTR_PA14_DT_Msk                                          (0x4000UL)		/*!< SYSCFG IO_DTR: PA14_DT (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_DTR_PA14_DT                                              SYSCFG_IO_DTR_PA14_DT_Msk
#define SYSCFG_IO_DTR_PA13_DT_Pos                                          (13UL)		/*!<SYSCFG IO_DTR: PA13_DT (Bit 13) */
#define SYSCFG_IO_DTR_PA13_DT_Msk                                          (0x2000UL)		/*!< SYSCFG IO_DTR: PA13_DT (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_DTR_PA13_DT                                              SYSCFG_IO_DTR_PA13_DT_Msk
#define SYSCFG_IO_DTR_PA12_DT_Pos                                          (12UL)		/*!<SYSCFG IO_DTR: PA12_DT (Bit 12) */
#define SYSCFG_IO_DTR_PA12_DT_Msk                                          (0x1000UL)		/*!< SYSCFG IO_DTR: PA12_DT (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_DTR_PA12_DT                                              SYSCFG_IO_DTR_PA12_DT_Msk
#define SYSCFG_IO_DTR_PA11_DT_Pos                                          (11UL)		/*!<SYSCFG IO_DTR: PA11_DT (Bit 11) */
#define SYSCFG_IO_DTR_PA11_DT_Msk                                          (0x800UL)		/*!< SYSCFG IO_DTR: PA11_DT (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_DTR_PA11_DT                                              SYSCFG_IO_DTR_PA11_DT_Msk
#define SYSCFG_IO_DTR_PA10_DT_Pos                                          (10UL)		/*!<SYSCFG IO_DTR: PA10_DT (Bit 10) */
#define SYSCFG_IO_DTR_PA10_DT_Msk                                          (0x400UL)		/*!< SYSCFG IO_DTR: PA10_DT (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_DTR_PA10_DT                                              SYSCFG_IO_DTR_PA10_DT_Msk
#define SYSCFG_IO_DTR_PA9_DT_Pos                                           (9UL)		/*!<SYSCFG IO_DTR: PA9_DT (Bit 9) */
#define SYSCFG_IO_DTR_PA9_DT_Msk                                           (0x200UL)		/*!< SYSCFG IO_DTR: PA9_DT (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_DTR_PA9_DT                                               SYSCFG_IO_DTR_PA9_DT_Msk
#define SYSCFG_IO_DTR_PA8_DT_Pos                                           (8UL)		/*!<SYSCFG IO_DTR: PA8_DT (Bit 8) */
#define SYSCFG_IO_DTR_PA8_DT_Msk                                           (0x100UL)		/*!< SYSCFG IO_DTR: PA8_DT (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_DTR_PA8_DT                                               SYSCFG_IO_DTR_PA8_DT_Msk
#define SYSCFG_IO_DTR_PA7_DT_Pos                                           (7UL)		/*!<SYSCFG IO_DTR: PA7_DT (Bit 7) */
#define SYSCFG_IO_DTR_PA7_DT_Msk                                           (0x80UL)		/*!< SYSCFG IO_DTR: PA7_DT (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_DTR_PA7_DT                                               SYSCFG_IO_DTR_PA7_DT_Msk
#define SYSCFG_IO_DTR_PA6_DT_Pos                                           (6UL)		/*!<SYSCFG IO_DTR: PA6_DT (Bit 6) */
#define SYSCFG_IO_DTR_PA6_DT_Msk                                           (0x40UL)		/*!< SYSCFG IO_DTR: PA6_DT (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_DTR_PA6_DT                                               SYSCFG_IO_DTR_PA6_DT_Msk
#define SYSCFG_IO_DTR_PA5_DT_Pos                                           (5UL)		/*!<SYSCFG IO_DTR: PA5_DT (Bit 5) */
#define SYSCFG_IO_DTR_PA5_DT_Msk                                           (0x20UL)		/*!< SYSCFG IO_DTR: PA5_DT (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_DTR_PA5_DT                                               SYSCFG_IO_DTR_PA5_DT_Msk
#define SYSCFG_IO_DTR_PA4_DT_Pos                                           (4UL)		/*!<SYSCFG IO_DTR: PA4_DT (Bit 4) */
#define SYSCFG_IO_DTR_PA4_DT_Msk                                           (0x10UL)		/*!< SYSCFG IO_DTR: PA4_DT (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_DTR_PA4_DT                                               SYSCFG_IO_DTR_PA4_DT_Msk
#define SYSCFG_IO_DTR_PA3_DT_Pos                                           (3UL)		/*!<SYSCFG IO_DTR: PA3_DT (Bit 3) */
#define SYSCFG_IO_DTR_PA3_DT_Msk                                           (0x8UL)		/*!< SYSCFG IO_DTR: PA3_DT (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_DTR_PA3_DT                                               SYSCFG_IO_DTR_PA3_DT_Msk
#define SYSCFG_IO_DTR_PA2_DT_Pos                                           (2UL)		/*!<SYSCFG IO_DTR: PA2_DT (Bit 2) */
#define SYSCFG_IO_DTR_PA2_DT_Msk                                           (0x4UL)		/*!< SYSCFG IO_DTR: PA2_DT (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_DTR_PA2_DT                                               SYSCFG_IO_DTR_PA2_DT_Msk
#define SYSCFG_IO_DTR_PA1_DT_Pos                                           (1UL)		/*!<SYSCFG IO_DTR: PA1_DT (Bit 1) */
#define SYSCFG_IO_DTR_PA1_DT_Msk                                           (0x2UL)		/*!< SYSCFG IO_DTR: PA1_DT (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_DTR_PA1_DT                                               SYSCFG_IO_DTR_PA1_DT_Msk
#define SYSCFG_IO_DTR_PA0_DT_Pos                                           (0UL)		/*!<SYSCFG IO_DTR: PA0_DT (Bit 0) */
#define SYSCFG_IO_DTR_PA0_DT_Msk                                           (0x1UL)		/*!< SYSCFG IO_DTR: PA0_DT (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_DTR_PA0_DT                                               SYSCFG_IO_DTR_PA0_DT_Msk

/* =====================================================    IO_IBER    ===================================================== */ 
#define SYSCFG_IO_IBER_PB15_IBE_Pos                                        (31UL)		/*!<SYSCFG IO_IBER: PB15_IBE (Bit 31) */
#define SYSCFG_IO_IBER_PB15_IBE_Msk                                        (0x80000000UL)		/*!< SYSCFG IO_IBER: PB15_IBE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IBER_PB15_IBE                                            SYSCFG_IO_IBER_PB15_IBE_Msk
#define SYSCFG_IO_IBER_PB14_IBE_Pos                                        (30UL)		/*!<SYSCFG IO_IBER: PB14_IBE (Bit 30) */
#define SYSCFG_IO_IBER_PB14_IBE_Msk                                        (0x40000000UL)		/*!< SYSCFG IO_IBER: PB14_IBE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IBER_PB14_IBE                                            SYSCFG_IO_IBER_PB14_IBE_Msk
#define SYSCFG_IO_IBER_PB13_IBE_Pos                                        (29UL)		/*!<SYSCFG IO_IBER: PB13_IBE (Bit 29) */
#define SYSCFG_IO_IBER_PB13_IBE_Msk                                        (0x20000000UL)		/*!< SYSCFG IO_IBER: PB13_IBE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IBER_PB13_IBE                                            SYSCFG_IO_IBER_PB13_IBE_Msk
#define SYSCFG_IO_IBER_PB12_IBE_Pos                                        (28UL)		/*!<SYSCFG IO_IBER: PB12_IBE (Bit 28) */
#define SYSCFG_IO_IBER_PB12_IBE_Msk                                        (0x10000000UL)		/*!< SYSCFG IO_IBER: PB12_IBE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IBER_PB12_IBE                                            SYSCFG_IO_IBER_PB12_IBE_Msk
#define SYSCFG_IO_IBER_PB11_IBE_Pos                                        (27UL)		/*!<SYSCFG IO_IBER: PB11_IBE (Bit 27) */
#define SYSCFG_IO_IBER_PB11_IBE_Msk                                        (0x8000000UL)		/*!< SYSCFG IO_IBER: PB11_IBE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IBER_PB11_IBE                                            SYSCFG_IO_IBER_PB11_IBE_Msk
#define SYSCFG_IO_IBER_PB10_IBE_Pos                                        (26UL)		/*!<SYSCFG IO_IBER: PB10_IBE (Bit 26) */
#define SYSCFG_IO_IBER_PB10_IBE_Msk                                        (0x4000000UL)		/*!< SYSCFG IO_IBER: PB10_IBE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IBER_PB10_IBE                                            SYSCFG_IO_IBER_PB10_IBE_Msk
#define SYSCFG_IO_IBER_PB9_IBE_Pos                                         (25UL)		/*!<SYSCFG IO_IBER: PB9_IBE (Bit 25) */
#define SYSCFG_IO_IBER_PB9_IBE_Msk                                         (0x2000000UL)		/*!< SYSCFG IO_IBER: PB9_IBE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IBER_PB9_IBE                                             SYSCFG_IO_IBER_PB9_IBE_Msk
#define SYSCFG_IO_IBER_PB8_IBE_Pos                                         (24UL)		/*!<SYSCFG IO_IBER: PB8_IBE (Bit 24) */
#define SYSCFG_IO_IBER_PB8_IBE_Msk                                         (0x1000000UL)		/*!< SYSCFG IO_IBER: PB8_IBE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IBER_PB8_IBE                                             SYSCFG_IO_IBER_PB8_IBE_Msk
#define SYSCFG_IO_IBER_PB7_IBE_Pos                                         (23UL)		/*!<SYSCFG IO_IBER: PB7_IBE (Bit 23) */
#define SYSCFG_IO_IBER_PB7_IBE_Msk                                         (0x800000UL)		/*!< SYSCFG IO_IBER: PB7_IBE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IBER_PB7_IBE                                             SYSCFG_IO_IBER_PB7_IBE_Msk
#define SYSCFG_IO_IBER_PB6_IBE_Pos                                         (22UL)		/*!<SYSCFG IO_IBER: PB6_IBE (Bit 22) */
#define SYSCFG_IO_IBER_PB6_IBE_Msk                                         (0x400000UL)		/*!< SYSCFG IO_IBER: PB6_IBE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IBER_PB6_IBE                                             SYSCFG_IO_IBER_PB6_IBE_Msk
#define SYSCFG_IO_IBER_PB5_IBE_Pos                                         (21UL)		/*!<SYSCFG IO_IBER: PB5_IBE (Bit 21) */
#define SYSCFG_IO_IBER_PB5_IBE_Msk                                         (0x200000UL)		/*!< SYSCFG IO_IBER: PB5_IBE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IBER_PB5_IBE                                             SYSCFG_IO_IBER_PB5_IBE_Msk
#define SYSCFG_IO_IBER_PB4_IBE_Pos                                         (20UL)		/*!<SYSCFG IO_IBER: PB4_IBE (Bit 20) */
#define SYSCFG_IO_IBER_PB4_IBE_Msk                                         (0x100000UL)		/*!< SYSCFG IO_IBER: PB4_IBE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IBER_PB4_IBE                                             SYSCFG_IO_IBER_PB4_IBE_Msk
#define SYSCFG_IO_IBER_PB3_IBE_Pos                                         (19UL)		/*!<SYSCFG IO_IBER: PB3_IBE (Bit 19) */
#define SYSCFG_IO_IBER_PB3_IBE_Msk                                         (0x80000UL)		/*!< SYSCFG IO_IBER: PB3_IBE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IBER_PB3_IBE                                             SYSCFG_IO_IBER_PB3_IBE_Msk
#define SYSCFG_IO_IBER_PB2_IBE_Pos                                         (18UL)		/*!<SYSCFG IO_IBER: PB2_IBE (Bit 18) */
#define SYSCFG_IO_IBER_PB2_IBE_Msk                                         (0x40000UL)		/*!< SYSCFG IO_IBER: PB2_IBE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IBER_PB2_IBE                                             SYSCFG_IO_IBER_PB2_IBE_Msk
#define SYSCFG_IO_IBER_PB1_IBE_Pos                                         (17UL)		/*!<SYSCFG IO_IBER: PB1_IBE (Bit 17) */
#define SYSCFG_IO_IBER_PB1_IBE_Msk                                         (0x20000UL)		/*!< SYSCFG IO_IBER: PB1_IBE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IBER_PB1_IBE                                             SYSCFG_IO_IBER_PB1_IBE_Msk
#define SYSCFG_IO_IBER_PB0_IBE_Pos                                         (16UL)		/*!<SYSCFG IO_IBER: PB0_IBE (Bit 16) */
#define SYSCFG_IO_IBER_PB0_IBE_Msk                                         (0x10000UL)		/*!< SYSCFG IO_IBER: PB0_IBE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IBER_PB0_IBE                                             SYSCFG_IO_IBER_PB0_IBE_Msk
#define SYSCFG_IO_IBER_PA15_IBE_Pos                                        (15UL)		/*!<SYSCFG IO_IBER: PA15_IBE (Bit 15) */
#define SYSCFG_IO_IBER_PA15_IBE_Msk                                        (0x8000UL)		/*!< SYSCFG IO_IBER: PA15_IBE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IBER_PA15_IBE                                            SYSCFG_IO_IBER_PA15_IBE_Msk
#define SYSCFG_IO_IBER_PA14_IBE_Pos                                        (14UL)		/*!<SYSCFG IO_IBER: PA14_IBE (Bit 14) */
#define SYSCFG_IO_IBER_PA14_IBE_Msk                                        (0x4000UL)		/*!< SYSCFG IO_IBER: PA14_IBE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IBER_PA14_IBE                                            SYSCFG_IO_IBER_PA14_IBE_Msk
#define SYSCFG_IO_IBER_PA13_IBE_Pos                                        (13UL)		/*!<SYSCFG IO_IBER: PA13_IBE (Bit 13) */
#define SYSCFG_IO_IBER_PA13_IBE_Msk                                        (0x2000UL)		/*!< SYSCFG IO_IBER: PA13_IBE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IBER_PA13_IBE                                            SYSCFG_IO_IBER_PA13_IBE_Msk
#define SYSCFG_IO_IBER_PA12_IBE_Pos                                        (12UL)		/*!<SYSCFG IO_IBER: PA12_IBE (Bit 12) */
#define SYSCFG_IO_IBER_PA12_IBE_Msk                                        (0x1000UL)		/*!< SYSCFG IO_IBER: PA12_IBE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IBER_PA12_IBE                                            SYSCFG_IO_IBER_PA12_IBE_Msk
#define SYSCFG_IO_IBER_PA11_IBE_Pos                                        (11UL)		/*!<SYSCFG IO_IBER: PA11_IBE (Bit 11) */
#define SYSCFG_IO_IBER_PA11_IBE_Msk                                        (0x800UL)		/*!< SYSCFG IO_IBER: PA11_IBE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IBER_PA11_IBE                                            SYSCFG_IO_IBER_PA11_IBE_Msk
#define SYSCFG_IO_IBER_PA10_IBE_Pos                                        (10UL)		/*!<SYSCFG IO_IBER: PA10_IBE (Bit 10) */
#define SYSCFG_IO_IBER_PA10_IBE_Msk                                        (0x400UL)		/*!< SYSCFG IO_IBER: PA10_IBE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IBER_PA10_IBE                                            SYSCFG_IO_IBER_PA10_IBE_Msk
#define SYSCFG_IO_IBER_PA9_IBE_Pos                                         (9UL)		/*!<SYSCFG IO_IBER: PA9_IBE (Bit 9) */
#define SYSCFG_IO_IBER_PA9_IBE_Msk                                         (0x200UL)		/*!< SYSCFG IO_IBER: PA9_IBE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IBER_PA9_IBE                                             SYSCFG_IO_IBER_PA9_IBE_Msk
#define SYSCFG_IO_IBER_PA8_IBE_Pos                                         (8UL)		/*!<SYSCFG IO_IBER: PA8_IBE (Bit 8) */
#define SYSCFG_IO_IBER_PA8_IBE_Msk                                         (0x100UL)		/*!< SYSCFG IO_IBER: PA8_IBE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IBER_PA8_IBE                                             SYSCFG_IO_IBER_PA8_IBE_Msk
#define SYSCFG_IO_IBER_PA7_IBE_Pos                                         (7UL)		/*!<SYSCFG IO_IBER: PA7_IBE (Bit 7) */
#define SYSCFG_IO_IBER_PA7_IBE_Msk                                         (0x80UL)		/*!< SYSCFG IO_IBER: PA7_IBE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IBER_PA7_IBE                                             SYSCFG_IO_IBER_PA7_IBE_Msk
#define SYSCFG_IO_IBER_PA6_IBE_Pos                                         (6UL)		/*!<SYSCFG IO_IBER: PA6_IBE (Bit 6) */
#define SYSCFG_IO_IBER_PA6_IBE_Msk                                         (0x40UL)		/*!< SYSCFG IO_IBER: PA6_IBE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IBER_PA6_IBE                                             SYSCFG_IO_IBER_PA6_IBE_Msk
#define SYSCFG_IO_IBER_PA5_IBE_Pos                                         (5UL)		/*!<SYSCFG IO_IBER: PA5_IBE (Bit 5) */
#define SYSCFG_IO_IBER_PA5_IBE_Msk                                         (0x20UL)		/*!< SYSCFG IO_IBER: PA5_IBE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IBER_PA5_IBE                                             SYSCFG_IO_IBER_PA5_IBE_Msk
#define SYSCFG_IO_IBER_PA4_IBE_Pos                                         (4UL)		/*!<SYSCFG IO_IBER: PA4_IBE (Bit 4) */
#define SYSCFG_IO_IBER_PA4_IBE_Msk                                         (0x10UL)		/*!< SYSCFG IO_IBER: PA4_IBE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IBER_PA4_IBE                                             SYSCFG_IO_IBER_PA4_IBE_Msk
#define SYSCFG_IO_IBER_PA3_IBE_Pos                                         (3UL)		/*!<SYSCFG IO_IBER: PA3_IBE (Bit 3) */
#define SYSCFG_IO_IBER_PA3_IBE_Msk                                         (0x8UL)		/*!< SYSCFG IO_IBER: PA3_IBE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IBER_PA3_IBE                                             SYSCFG_IO_IBER_PA3_IBE_Msk
#define SYSCFG_IO_IBER_PA2_IBE_Pos                                         (2UL)		/*!<SYSCFG IO_IBER: PA2_IBE (Bit 2) */
#define SYSCFG_IO_IBER_PA2_IBE_Msk                                         (0x4UL)		/*!< SYSCFG IO_IBER: PA2_IBE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IBER_PA2_IBE                                             SYSCFG_IO_IBER_PA2_IBE_Msk
#define SYSCFG_IO_IBER_PA1_IBE_Pos                                         (1UL)		/*!<SYSCFG IO_IBER: PA1_IBE (Bit 1) */
#define SYSCFG_IO_IBER_PA1_IBE_Msk                                         (0x2UL)		/*!< SYSCFG IO_IBER: PA1_IBE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IBER_PA1_IBE                                             SYSCFG_IO_IBER_PA1_IBE_Msk
#define SYSCFG_IO_IBER_PA0_IBE_Pos                                         (0UL)		/*!<SYSCFG IO_IBER: PA0_IBE (Bit 0) */
#define SYSCFG_IO_IBER_PA0_IBE_Msk                                         (0x1UL)		/*!< SYSCFG IO_IBER: PA0_IBE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IBER_PA0_IBE                                             SYSCFG_IO_IBER_PA0_IBE_Msk

/* =====================================================    IO_IEVR    ===================================================== */ 
#define SYSCFG_IO_IEVR_PB15_IEV_Pos                                        (31UL)		/*!<SYSCFG IO_IEVR: PB15_IEV (Bit 31) */
#define SYSCFG_IO_IEVR_PB15_IEV_Msk                                        (0x80000000UL)		/*!< SYSCFG IO_IEVR: PB15_IEV (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IEVR_PB15_IEV                                            SYSCFG_IO_IEVR_PB15_IEV_Msk
#define SYSCFG_IO_IEVR_PB14_IEV_Pos                                        (30UL)		/*!<SYSCFG IO_IEVR: PB14_IEV (Bit 30) */
#define SYSCFG_IO_IEVR_PB14_IEV_Msk                                        (0x40000000UL)		/*!< SYSCFG IO_IEVR: PB14_IEV (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IEVR_PB14_IEV                                            SYSCFG_IO_IEVR_PB14_IEV_Msk
#define SYSCFG_IO_IEVR_PB13_IEV_Pos                                        (29UL)		/*!<SYSCFG IO_IEVR: PB13_IEV (Bit 29) */
#define SYSCFG_IO_IEVR_PB13_IEV_Msk                                        (0x20000000UL)		/*!< SYSCFG IO_IEVR: PB13_IEV (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IEVR_PB13_IEV                                            SYSCFG_IO_IEVR_PB13_IEV_Msk
#define SYSCFG_IO_IEVR_PB12_IEV_Pos                                        (28UL)		/*!<SYSCFG IO_IEVR: PB12_IEV (Bit 28) */
#define SYSCFG_IO_IEVR_PB12_IEV_Msk                                        (0x10000000UL)		/*!< SYSCFG IO_IEVR: PB12_IEV (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IEVR_PB12_IEV                                            SYSCFG_IO_IEVR_PB12_IEV_Msk
#define SYSCFG_IO_IEVR_PB11_IEV_Pos                                        (27UL)		/*!<SYSCFG IO_IEVR: PB11_IEV (Bit 27) */
#define SYSCFG_IO_IEVR_PB11_IEV_Msk                                        (0x8000000UL)		/*!< SYSCFG IO_IEVR: PB11_IEV (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IEVR_PB11_IEV                                            SYSCFG_IO_IEVR_PB11_IEV_Msk
#define SYSCFG_IO_IEVR_PB10_IEV_Pos                                        (26UL)		/*!<SYSCFG IO_IEVR: PB10_IEV (Bit 26) */
#define SYSCFG_IO_IEVR_PB10_IEV_Msk                                        (0x4000000UL)		/*!< SYSCFG IO_IEVR: PB10_IEV (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IEVR_PB10_IEV                                            SYSCFG_IO_IEVR_PB10_IEV_Msk
#define SYSCFG_IO_IEVR_PB9_IEV_Pos                                         (25UL)		/*!<SYSCFG IO_IEVR: PB9_IEV (Bit 25) */
#define SYSCFG_IO_IEVR_PB9_IEV_Msk                                         (0x2000000UL)		/*!< SYSCFG IO_IEVR: PB9_IEV (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IEVR_PB9_IEV                                             SYSCFG_IO_IEVR_PB9_IEV_Msk
#define SYSCFG_IO_IEVR_PB8_IEV_Pos                                         (24UL)		/*!<SYSCFG IO_IEVR: PB8_IEV (Bit 24) */
#define SYSCFG_IO_IEVR_PB8_IEV_Msk                                         (0x1000000UL)		/*!< SYSCFG IO_IEVR: PB8_IEV (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IEVR_PB8_IEV                                             SYSCFG_IO_IEVR_PB8_IEV_Msk
#define SYSCFG_IO_IEVR_PB7_IEV_Pos                                         (23UL)		/*!<SYSCFG IO_IEVR: PB7_IEV (Bit 23) */
#define SYSCFG_IO_IEVR_PB7_IEV_Msk                                         (0x800000UL)		/*!< SYSCFG IO_IEVR: PB7_IEV (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IEVR_PB7_IEV                                             SYSCFG_IO_IEVR_PB7_IEV_Msk
#define SYSCFG_IO_IEVR_PB6_IEV_Pos                                         (22UL)		/*!<SYSCFG IO_IEVR: PB6_IEV (Bit 22) */
#define SYSCFG_IO_IEVR_PB6_IEV_Msk                                         (0x400000UL)		/*!< SYSCFG IO_IEVR: PB6_IEV (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IEVR_PB6_IEV                                             SYSCFG_IO_IEVR_PB6_IEV_Msk
#define SYSCFG_IO_IEVR_PB5_IEV_Pos                                         (21UL)		/*!<SYSCFG IO_IEVR: PB5_IEV (Bit 21) */
#define SYSCFG_IO_IEVR_PB5_IEV_Msk                                         (0x200000UL)		/*!< SYSCFG IO_IEVR: PB5_IEV (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IEVR_PB5_IEV                                             SYSCFG_IO_IEVR_PB5_IEV_Msk
#define SYSCFG_IO_IEVR_PB4_IEV_Pos                                         (20UL)		/*!<SYSCFG IO_IEVR: PB4_IEV (Bit 20) */
#define SYSCFG_IO_IEVR_PB4_IEV_Msk                                         (0x100000UL)		/*!< SYSCFG IO_IEVR: PB4_IEV (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IEVR_PB4_IEV                                             SYSCFG_IO_IEVR_PB4_IEV_Msk
#define SYSCFG_IO_IEVR_PB3_IEV_Pos                                         (19UL)		/*!<SYSCFG IO_IEVR: PB3_IEV (Bit 19) */
#define SYSCFG_IO_IEVR_PB3_IEV_Msk                                         (0x80000UL)		/*!< SYSCFG IO_IEVR: PB3_IEV (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IEVR_PB3_IEV                                             SYSCFG_IO_IEVR_PB3_IEV_Msk
#define SYSCFG_IO_IEVR_PB2_IEV_Pos                                         (18UL)		/*!<SYSCFG IO_IEVR: PB2_IEV (Bit 18) */
#define SYSCFG_IO_IEVR_PB2_IEV_Msk                                         (0x40000UL)		/*!< SYSCFG IO_IEVR: PB2_IEV (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IEVR_PB2_IEV                                             SYSCFG_IO_IEVR_PB2_IEV_Msk
#define SYSCFG_IO_IEVR_PB1_IEV_Pos                                         (17UL)		/*!<SYSCFG IO_IEVR: PB1_IEV (Bit 17) */
#define SYSCFG_IO_IEVR_PB1_IEV_Msk                                         (0x20000UL)		/*!< SYSCFG IO_IEVR: PB1_IEV (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IEVR_PB1_IEV                                             SYSCFG_IO_IEVR_PB1_IEV_Msk
#define SYSCFG_IO_IEVR_PB0_IEV_Pos                                         (16UL)		/*!<SYSCFG IO_IEVR: PB0_IEV (Bit 16) */
#define SYSCFG_IO_IEVR_PB0_IEV_Msk                                         (0x10000UL)		/*!< SYSCFG IO_IEVR: PB0_IEV (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IEVR_PB0_IEV                                             SYSCFG_IO_IEVR_PB0_IEV_Msk
#define SYSCFG_IO_IEVR_PA15_IEV_Pos                                        (15UL)		/*!<SYSCFG IO_IEVR: PA15_IEV (Bit 15) */
#define SYSCFG_IO_IEVR_PA15_IEV_Msk                                        (0x8000UL)		/*!< SYSCFG IO_IEVR: PA15_IEV (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IEVR_PA15_IEV                                            SYSCFG_IO_IEVR_PA15_IEV_Msk
#define SYSCFG_IO_IEVR_PA14_IEV_Pos                                        (14UL)		/*!<SYSCFG IO_IEVR: PA14_IEV (Bit 14) */
#define SYSCFG_IO_IEVR_PA14_IEV_Msk                                        (0x4000UL)		/*!< SYSCFG IO_IEVR: PA14_IEV (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IEVR_PA14_IEV                                            SYSCFG_IO_IEVR_PA14_IEV_Msk
#define SYSCFG_IO_IEVR_PA13_IEV_Pos                                        (13UL)		/*!<SYSCFG IO_IEVR: PA13_IEV (Bit 13) */
#define SYSCFG_IO_IEVR_PA13_IEV_Msk                                        (0x2000UL)		/*!< SYSCFG IO_IEVR: PA13_IEV (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IEVR_PA13_IEV                                            SYSCFG_IO_IEVR_PA13_IEV_Msk
#define SYSCFG_IO_IEVR_PA12_IEV_Pos                                        (12UL)		/*!<SYSCFG IO_IEVR: PA12_IEV (Bit 12) */
#define SYSCFG_IO_IEVR_PA12_IEV_Msk                                        (0x1000UL)		/*!< SYSCFG IO_IEVR: PA12_IEV (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IEVR_PA12_IEV                                            SYSCFG_IO_IEVR_PA12_IEV_Msk
#define SYSCFG_IO_IEVR_PA11_IEV_Pos                                        (11UL)		/*!<SYSCFG IO_IEVR: PA11_IEV (Bit 11) */
#define SYSCFG_IO_IEVR_PA11_IEV_Msk                                        (0x800UL)		/*!< SYSCFG IO_IEVR: PA11_IEV (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IEVR_PA11_IEV                                            SYSCFG_IO_IEVR_PA11_IEV_Msk
#define SYSCFG_IO_IEVR_PA10_IEV_Pos                                        (10UL)		/*!<SYSCFG IO_IEVR: PA10_IEV (Bit 10) */
#define SYSCFG_IO_IEVR_PA10_IEV_Msk                                        (0x400UL)		/*!< SYSCFG IO_IEVR: PA10_IEV (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IEVR_PA10_IEV                                            SYSCFG_IO_IEVR_PA10_IEV_Msk
#define SYSCFG_IO_IEVR_PA9_IEV_Pos                                         (9UL)		/*!<SYSCFG IO_IEVR: PA9_IEV (Bit 9) */
#define SYSCFG_IO_IEVR_PA9_IEV_Msk                                         (0x200UL)		/*!< SYSCFG IO_IEVR: PA9_IEV (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IEVR_PA9_IEV                                             SYSCFG_IO_IEVR_PA9_IEV_Msk
#define SYSCFG_IO_IEVR_PA8_IEV_Pos                                         (8UL)		/*!<SYSCFG IO_IEVR: PA8_IEV (Bit 8) */
#define SYSCFG_IO_IEVR_PA8_IEV_Msk                                         (0x100UL)		/*!< SYSCFG IO_IEVR: PA8_IEV (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IEVR_PA8_IEV                                             SYSCFG_IO_IEVR_PA8_IEV_Msk
#define SYSCFG_IO_IEVR_PA7_IEV_Pos                                         (7UL)		/*!<SYSCFG IO_IEVR: PA7_IEV (Bit 7) */
#define SYSCFG_IO_IEVR_PA7_IEV_Msk                                         (0x80UL)		/*!< SYSCFG IO_IEVR: PA7_IEV (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IEVR_PA7_IEV                                             SYSCFG_IO_IEVR_PA7_IEV_Msk
#define SYSCFG_IO_IEVR_PA6_IEV_Pos                                         (6UL)		/*!<SYSCFG IO_IEVR: PA6_IEV (Bit 6) */
#define SYSCFG_IO_IEVR_PA6_IEV_Msk                                         (0x40UL)		/*!< SYSCFG IO_IEVR: PA6_IEV (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IEVR_PA6_IEV                                             SYSCFG_IO_IEVR_PA6_IEV_Msk
#define SYSCFG_IO_IEVR_PA5_IEV_Pos                                         (5UL)		/*!<SYSCFG IO_IEVR: PA5_IEV (Bit 5) */
#define SYSCFG_IO_IEVR_PA5_IEV_Msk                                         (0x20UL)		/*!< SYSCFG IO_IEVR: PA5_IEV (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IEVR_PA5_IEV                                             SYSCFG_IO_IEVR_PA5_IEV_Msk
#define SYSCFG_IO_IEVR_PA4_IEV_Pos                                         (4UL)		/*!<SYSCFG IO_IEVR: PA4_IEV (Bit 4) */
#define SYSCFG_IO_IEVR_PA4_IEV_Msk                                         (0x10UL)		/*!< SYSCFG IO_IEVR: PA4_IEV (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IEVR_PA4_IEV                                             SYSCFG_IO_IEVR_PA4_IEV_Msk
#define SYSCFG_IO_IEVR_PA3_IEV_Pos                                         (3UL)		/*!<SYSCFG IO_IEVR: PA3_IEV (Bit 3) */
#define SYSCFG_IO_IEVR_PA3_IEV_Msk                                         (0x8UL)		/*!< SYSCFG IO_IEVR: PA3_IEV (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IEVR_PA3_IEV                                             SYSCFG_IO_IEVR_PA3_IEV_Msk
#define SYSCFG_IO_IEVR_PA2_IEV_Pos                                         (2UL)		/*!<SYSCFG IO_IEVR: PA2_IEV (Bit 2) */
#define SYSCFG_IO_IEVR_PA2_IEV_Msk                                         (0x4UL)		/*!< SYSCFG IO_IEVR: PA2_IEV (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IEVR_PA2_IEV                                             SYSCFG_IO_IEVR_PA2_IEV_Msk
#define SYSCFG_IO_IEVR_PA1_IEV_Pos                                         (1UL)		/*!<SYSCFG IO_IEVR: PA1_IEV (Bit 1) */
#define SYSCFG_IO_IEVR_PA1_IEV_Msk                                         (0x2UL)		/*!< SYSCFG IO_IEVR: PA1_IEV (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IEVR_PA1_IEV                                             SYSCFG_IO_IEVR_PA1_IEV_Msk
#define SYSCFG_IO_IEVR_PA0_IEV_Pos                                         (0UL)		/*!<SYSCFG IO_IEVR: PA0_IEV (Bit 0) */
#define SYSCFG_IO_IEVR_PA0_IEV_Msk                                         (0x1UL)		/*!< SYSCFG IO_IEVR: PA0_IEV (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IEVR_PA0_IEV                                             SYSCFG_IO_IEVR_PA0_IEV_Msk

/* =====================================================    IO_IER    ===================================================== */ 
#define SYSCFG_IO_IER_PB15_IE_Pos                                          (31UL)		/*!<SYSCFG IO_IER: PB15_IE (Bit 31) */
#define SYSCFG_IO_IER_PB15_IE_Msk                                          (0x80000000UL)		/*!< SYSCFG IO_IER: PB15_IE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IER_PB15_IE                                              SYSCFG_IO_IER_PB15_IE_Msk
#define SYSCFG_IO_IER_PB14_IE_Pos                                          (30UL)		/*!<SYSCFG IO_IER: PB14_IE (Bit 30) */
#define SYSCFG_IO_IER_PB14_IE_Msk                                          (0x40000000UL)		/*!< SYSCFG IO_IER: PB14_IE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IER_PB14_IE                                              SYSCFG_IO_IER_PB14_IE_Msk
#define SYSCFG_IO_IER_PB13_IE_Pos                                          (29UL)		/*!<SYSCFG IO_IER: PB13_IE (Bit 29) */
#define SYSCFG_IO_IER_PB13_IE_Msk                                          (0x20000000UL)		/*!< SYSCFG IO_IER: PB13_IE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IER_PB13_IE                                              SYSCFG_IO_IER_PB13_IE_Msk
#define SYSCFG_IO_IER_PB12_IE_Pos                                          (28UL)		/*!<SYSCFG IO_IER: PB12_IE (Bit 28) */
#define SYSCFG_IO_IER_PB12_IE_Msk                                          (0x10000000UL)		/*!< SYSCFG IO_IER: PB12_IE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IER_PB12_IE                                              SYSCFG_IO_IER_PB12_IE_Msk
#define SYSCFG_IO_IER_PB11_IE_Pos                                          (27UL)		/*!<SYSCFG IO_IER: PB11_IE (Bit 27) */
#define SYSCFG_IO_IER_PB11_IE_Msk                                          (0x8000000UL)		/*!< SYSCFG IO_IER: PB11_IE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IER_PB11_IE                                              SYSCFG_IO_IER_PB11_IE_Msk
#define SYSCFG_IO_IER_PB10_IE_Pos                                          (26UL)		/*!<SYSCFG IO_IER: PB10_IE (Bit 26) */
#define SYSCFG_IO_IER_PB10_IE_Msk                                          (0x4000000UL)		/*!< SYSCFG IO_IER: PB10_IE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IER_PB10_IE                                              SYSCFG_IO_IER_PB10_IE_Msk
#define SYSCFG_IO_IER_PB9_IE_Pos                                           (25UL)		/*!<SYSCFG IO_IER: PB9_IE (Bit 25) */
#define SYSCFG_IO_IER_PB9_IE_Msk                                           (0x2000000UL)		/*!< SYSCFG IO_IER: PB9_IE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IER_PB9_IE                                               SYSCFG_IO_IER_PB9_IE_Msk
#define SYSCFG_IO_IER_PB8_IE_Pos                                           (24UL)		/*!<SYSCFG IO_IER: PB8_IE (Bit 24) */
#define SYSCFG_IO_IER_PB8_IE_Msk                                           (0x1000000UL)		/*!< SYSCFG IO_IER: PB8_IE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IER_PB8_IE                                               SYSCFG_IO_IER_PB8_IE_Msk
#define SYSCFG_IO_IER_PB7_IE_Pos                                           (23UL)		/*!<SYSCFG IO_IER: PB7_IE (Bit 23) */
#define SYSCFG_IO_IER_PB7_IE_Msk                                           (0x800000UL)		/*!< SYSCFG IO_IER: PB7_IE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IER_PB7_IE                                               SYSCFG_IO_IER_PB7_IE_Msk
#define SYSCFG_IO_IER_PB6_IE_Pos                                           (22UL)		/*!<SYSCFG IO_IER: PB6_IE (Bit 22) */
#define SYSCFG_IO_IER_PB6_IE_Msk                                           (0x400000UL)		/*!< SYSCFG IO_IER: PB6_IE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IER_PB6_IE                                               SYSCFG_IO_IER_PB6_IE_Msk
#define SYSCFG_IO_IER_PB5_IE_Pos                                           (21UL)		/*!<SYSCFG IO_IER: PB5_IE (Bit 21) */
#define SYSCFG_IO_IER_PB5_IE_Msk                                           (0x200000UL)		/*!< SYSCFG IO_IER: PB5_IE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IER_PB5_IE                                               SYSCFG_IO_IER_PB5_IE_Msk
#define SYSCFG_IO_IER_PB4_IE_Pos                                           (20UL)		/*!<SYSCFG IO_IER: PB4_IE (Bit 20) */
#define SYSCFG_IO_IER_PB4_IE_Msk                                           (0x100000UL)		/*!< SYSCFG IO_IER: PB4_IE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IER_PB4_IE                                               SYSCFG_IO_IER_PB4_IE_Msk
#define SYSCFG_IO_IER_PB3_IE_Pos                                           (19UL)		/*!<SYSCFG IO_IER: PB3_IE (Bit 19) */
#define SYSCFG_IO_IER_PB3_IE_Msk                                           (0x80000UL)		/*!< SYSCFG IO_IER: PB3_IE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IER_PB3_IE                                               SYSCFG_IO_IER_PB3_IE_Msk
#define SYSCFG_IO_IER_PB2_IE_Pos                                           (18UL)		/*!<SYSCFG IO_IER: PB2_IE (Bit 18) */
#define SYSCFG_IO_IER_PB2_IE_Msk                                           (0x40000UL)		/*!< SYSCFG IO_IER: PB2_IE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IER_PB2_IE                                               SYSCFG_IO_IER_PB2_IE_Msk
#define SYSCFG_IO_IER_PB1_IE_Pos                                           (17UL)		/*!<SYSCFG IO_IER: PB1_IE (Bit 17) */
#define SYSCFG_IO_IER_PB1_IE_Msk                                           (0x20000UL)		/*!< SYSCFG IO_IER: PB1_IE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IER_PB1_IE                                               SYSCFG_IO_IER_PB1_IE_Msk
#define SYSCFG_IO_IER_PB0_IE_Pos                                           (16UL)		/*!<SYSCFG IO_IER: PB0_IE (Bit 16) */
#define SYSCFG_IO_IER_PB0_IE_Msk                                           (0x10000UL)		/*!< SYSCFG IO_IER: PB0_IE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IER_PB0_IE                                               SYSCFG_IO_IER_PB0_IE_Msk
#define SYSCFG_IO_IER_PA15_IE_Pos                                          (15UL)		/*!<SYSCFG IO_IER: PA15_IE (Bit 15) */
#define SYSCFG_IO_IER_PA15_IE_Msk                                          (0x8000UL)		/*!< SYSCFG IO_IER: PA15_IE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IER_PA15_IE                                              SYSCFG_IO_IER_PA15_IE_Msk
#define SYSCFG_IO_IER_PA14_IE_Pos                                          (14UL)		/*!<SYSCFG IO_IER: PA14_IE (Bit 14) */
#define SYSCFG_IO_IER_PA14_IE_Msk                                          (0x4000UL)		/*!< SYSCFG IO_IER: PA14_IE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IER_PA14_IE                                              SYSCFG_IO_IER_PA14_IE_Msk
#define SYSCFG_IO_IER_PA13_IE_Pos                                          (13UL)		/*!<SYSCFG IO_IER: PA13_IE (Bit 13) */
#define SYSCFG_IO_IER_PA13_IE_Msk                                          (0x2000UL)		/*!< SYSCFG IO_IER: PA13_IE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IER_PA13_IE                                              SYSCFG_IO_IER_PA13_IE_Msk
#define SYSCFG_IO_IER_PA12_IE_Pos                                          (12UL)		/*!<SYSCFG IO_IER: PA12_IE (Bit 12) */
#define SYSCFG_IO_IER_PA12_IE_Msk                                          (0x1000UL)		/*!< SYSCFG IO_IER: PA12_IE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IER_PA12_IE                                              SYSCFG_IO_IER_PA12_IE_Msk
#define SYSCFG_IO_IER_PA11_IE_Pos                                          (11UL)		/*!<SYSCFG IO_IER: PA11_IE (Bit 11) */
#define SYSCFG_IO_IER_PA11_IE_Msk                                          (0x800UL)		/*!< SYSCFG IO_IER: PA11_IE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IER_PA11_IE                                              SYSCFG_IO_IER_PA11_IE_Msk
#define SYSCFG_IO_IER_PA10_IE_Pos                                          (10UL)		/*!<SYSCFG IO_IER: PA10_IE (Bit 10) */
#define SYSCFG_IO_IER_PA10_IE_Msk                                          (0x400UL)		/*!< SYSCFG IO_IER: PA10_IE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IER_PA10_IE                                              SYSCFG_IO_IER_PA10_IE_Msk
#define SYSCFG_IO_IER_PA9_IE_Pos                                           (9UL)		/*!<SYSCFG IO_IER: PA9_IE (Bit 9) */
#define SYSCFG_IO_IER_PA9_IE_Msk                                           (0x200UL)		/*!< SYSCFG IO_IER: PA9_IE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IER_PA9_IE                                               SYSCFG_IO_IER_PA9_IE_Msk
#define SYSCFG_IO_IER_PA8_IE_Pos                                           (8UL)		/*!<SYSCFG IO_IER: PA8_IE (Bit 8) */
#define SYSCFG_IO_IER_PA8_IE_Msk                                           (0x100UL)		/*!< SYSCFG IO_IER: PA8_IE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IER_PA8_IE                                               SYSCFG_IO_IER_PA8_IE_Msk
#define SYSCFG_IO_IER_PA7_IE_Pos                                           (7UL)		/*!<SYSCFG IO_IER: PA7_IE (Bit 7) */
#define SYSCFG_IO_IER_PA7_IE_Msk                                           (0x80UL)		/*!< SYSCFG IO_IER: PA7_IE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IER_PA7_IE                                               SYSCFG_IO_IER_PA7_IE_Msk
#define SYSCFG_IO_IER_PA6_IE_Pos                                           (6UL)		/*!<SYSCFG IO_IER: PA6_IE (Bit 6) */
#define SYSCFG_IO_IER_PA6_IE_Msk                                           (0x40UL)		/*!< SYSCFG IO_IER: PA6_IE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IER_PA6_IE                                               SYSCFG_IO_IER_PA6_IE_Msk
#define SYSCFG_IO_IER_PA5_IE_Pos                                           (5UL)		/*!<SYSCFG IO_IER: PA5_IE (Bit 5) */
#define SYSCFG_IO_IER_PA5_IE_Msk                                           (0x20UL)		/*!< SYSCFG IO_IER: PA5_IE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IER_PA5_IE                                               SYSCFG_IO_IER_PA5_IE_Msk
#define SYSCFG_IO_IER_PA4_IE_Pos                                           (4UL)		/*!<SYSCFG IO_IER: PA4_IE (Bit 4) */
#define SYSCFG_IO_IER_PA4_IE_Msk                                           (0x10UL)		/*!< SYSCFG IO_IER: PA4_IE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IER_PA4_IE                                               SYSCFG_IO_IER_PA4_IE_Msk
#define SYSCFG_IO_IER_PA3_IE_Pos                                           (3UL)		/*!<SYSCFG IO_IER: PA3_IE (Bit 3) */
#define SYSCFG_IO_IER_PA3_IE_Msk                                           (0x8UL)		/*!< SYSCFG IO_IER: PA3_IE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IER_PA3_IE                                               SYSCFG_IO_IER_PA3_IE_Msk
#define SYSCFG_IO_IER_PA2_IE_Pos                                           (2UL)		/*!<SYSCFG IO_IER: PA2_IE (Bit 2) */
#define SYSCFG_IO_IER_PA2_IE_Msk                                           (0x4UL)		/*!< SYSCFG IO_IER: PA2_IE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IER_PA2_IE                                               SYSCFG_IO_IER_PA2_IE_Msk
#define SYSCFG_IO_IER_PA1_IE_Pos                                           (1UL)		/*!<SYSCFG IO_IER: PA1_IE (Bit 1) */
#define SYSCFG_IO_IER_PA1_IE_Msk                                           (0x2UL)		/*!< SYSCFG IO_IER: PA1_IE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IER_PA1_IE                                               SYSCFG_IO_IER_PA1_IE_Msk
#define SYSCFG_IO_IER_PA0_IE_Pos                                           (0UL)		/*!<SYSCFG IO_IER: PA0_IE (Bit 0) */
#define SYSCFG_IO_IER_PA0_IE_Msk                                           (0x1UL)		/*!< SYSCFG IO_IER: PA0_IE (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_IER_PA0_IE                                               SYSCFG_IO_IER_PA0_IE_Msk

/* =====================================================    IO_ISCR    ===================================================== */ 
#define SYSCFG_IO_ISCR_PB15_ISC_Pos                                        (31UL)		/*!<SYSCFG IO_ISCR: PB15_ISC (Bit 31) */
#define SYSCFG_IO_ISCR_PB15_ISC_Msk                                        (0x80000000UL)		/*!< SYSCFG IO_ISCR: PB15_ISC (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_ISCR_PB15_ISC                                            SYSCFG_IO_ISCR_PB15_ISC_Msk
#define SYSCFG_IO_ISCR_PB14_ISC_Pos                                        (30UL)		/*!<SYSCFG IO_ISCR: PB14_ISC (Bit 30) */
#define SYSCFG_IO_ISCR_PB14_ISC_Msk                                        (0x40000000UL)		/*!< SYSCFG IO_ISCR: PB14_ISC (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_ISCR_PB14_ISC                                            SYSCFG_IO_ISCR_PB14_ISC_Msk
#define SYSCFG_IO_ISCR_PB13_ISC_Pos                                        (29UL)		/*!<SYSCFG IO_ISCR: PB13_ISC (Bit 29) */
#define SYSCFG_IO_ISCR_PB13_ISC_Msk                                        (0x20000000UL)		/*!< SYSCFG IO_ISCR: PB13_ISC (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_ISCR_PB13_ISC                                            SYSCFG_IO_ISCR_PB13_ISC_Msk
#define SYSCFG_IO_ISCR_PB12_ISC_Pos                                        (28UL)		/*!<SYSCFG IO_ISCR: PB12_ISC (Bit 28) */
#define SYSCFG_IO_ISCR_PB12_ISC_Msk                                        (0x10000000UL)		/*!< SYSCFG IO_ISCR: PB12_ISC (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_ISCR_PB12_ISC                                            SYSCFG_IO_ISCR_PB12_ISC_Msk
#define SYSCFG_IO_ISCR_PB11_ISC_Pos                                        (27UL)		/*!<SYSCFG IO_ISCR: PB11_ISC (Bit 27) */
#define SYSCFG_IO_ISCR_PB11_ISC_Msk                                        (0x8000000UL)		/*!< SYSCFG IO_ISCR: PB11_ISC (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_ISCR_PB11_ISC                                            SYSCFG_IO_ISCR_PB11_ISC_Msk
#define SYSCFG_IO_ISCR_PB10_ISC_Pos                                        (26UL)		/*!<SYSCFG IO_ISCR: PB10_ISC (Bit 26) */
#define SYSCFG_IO_ISCR_PB10_ISC_Msk                                        (0x4000000UL)		/*!< SYSCFG IO_ISCR: PB10_ISC (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_ISCR_PB10_ISC                                            SYSCFG_IO_ISCR_PB10_ISC_Msk
#define SYSCFG_IO_ISCR_PB9_ISC_Pos                                         (25UL)		/*!<SYSCFG IO_ISCR: PB9_ISC (Bit 25) */
#define SYSCFG_IO_ISCR_PB9_ISC_Msk                                         (0x2000000UL)		/*!< SYSCFG IO_ISCR: PB9_ISC (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_ISCR_PB9_ISC                                             SYSCFG_IO_ISCR_PB9_ISC_Msk
#define SYSCFG_IO_ISCR_PB8_ISC_Pos                                         (24UL)		/*!<SYSCFG IO_ISCR: PB8_ISC (Bit 24) */
#define SYSCFG_IO_ISCR_PB8_ISC_Msk                                         (0x1000000UL)		/*!< SYSCFG IO_ISCR: PB8_ISC (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_ISCR_PB8_ISC                                             SYSCFG_IO_ISCR_PB8_ISC_Msk
#define SYSCFG_IO_ISCR_PB7_ISC_Pos                                         (23UL)		/*!<SYSCFG IO_ISCR: PB7_ISC (Bit 23) */
#define SYSCFG_IO_ISCR_PB7_ISC_Msk                                         (0x800000UL)		/*!< SYSCFG IO_ISCR: PB7_ISC (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_ISCR_PB7_ISC                                             SYSCFG_IO_ISCR_PB7_ISC_Msk
#define SYSCFG_IO_ISCR_PB6_ISC_Pos                                         (22UL)		/*!<SYSCFG IO_ISCR: PB6_ISC (Bit 22) */
#define SYSCFG_IO_ISCR_PB6_ISC_Msk                                         (0x400000UL)		/*!< SYSCFG IO_ISCR: PB6_ISC (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_ISCR_PB6_ISC                                             SYSCFG_IO_ISCR_PB6_ISC_Msk
#define SYSCFG_IO_ISCR_PB5_ISC_Pos                                         (21UL)		/*!<SYSCFG IO_ISCR: PB5_ISC (Bit 21) */
#define SYSCFG_IO_ISCR_PB5_ISC_Msk                                         (0x200000UL)		/*!< SYSCFG IO_ISCR: PB5_ISC (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_ISCR_PB5_ISC                                             SYSCFG_IO_ISCR_PB5_ISC_Msk
#define SYSCFG_IO_ISCR_PB4_ISC_Pos                                         (20UL)		/*!<SYSCFG IO_ISCR: PB4_ISC (Bit 20) */
#define SYSCFG_IO_ISCR_PB4_ISC_Msk                                         (0x100000UL)		/*!< SYSCFG IO_ISCR: PB4_ISC (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_ISCR_PB4_ISC                                             SYSCFG_IO_ISCR_PB4_ISC_Msk
#define SYSCFG_IO_ISCR_PB3_ISC_Pos                                         (19UL)		/*!<SYSCFG IO_ISCR: PB3_ISC (Bit 19) */
#define SYSCFG_IO_ISCR_PB3_ISC_Msk                                         (0x80000UL)		/*!< SYSCFG IO_ISCR: PB3_ISC (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_ISCR_PB3_ISC                                             SYSCFG_IO_ISCR_PB3_ISC_Msk
#define SYSCFG_IO_ISCR_PB2_ISC_Pos                                         (18UL)		/*!<SYSCFG IO_ISCR: PB2_ISC (Bit 18) */
#define SYSCFG_IO_ISCR_PB2_ISC_Msk                                         (0x40000UL)		/*!< SYSCFG IO_ISCR: PB2_ISC (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_ISCR_PB2_ISC                                             SYSCFG_IO_ISCR_PB2_ISC_Msk
#define SYSCFG_IO_ISCR_PB1_ISC_Pos                                         (17UL)		/*!<SYSCFG IO_ISCR: PB1_ISC (Bit 17) */
#define SYSCFG_IO_ISCR_PB1_ISC_Msk                                         (0x20000UL)		/*!< SYSCFG IO_ISCR: PB1_ISC (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_ISCR_PB1_ISC                                             SYSCFG_IO_ISCR_PB1_ISC_Msk
#define SYSCFG_IO_ISCR_PB0_ISC_Pos                                         (16UL)		/*!<SYSCFG IO_ISCR: PB0_ISC (Bit 16) */
#define SYSCFG_IO_ISCR_PB0_ISC_Msk                                         (0x10000UL)		/*!< SYSCFG IO_ISCR: PB0_ISC (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_ISCR_PB0_ISC                                             SYSCFG_IO_ISCR_PB0_ISC_Msk
#define SYSCFG_IO_ISCR_PA15_ISC_Pos                                        (15UL)		/*!<SYSCFG IO_ISCR: PA15_ISC (Bit 15) */
#define SYSCFG_IO_ISCR_PA15_ISC_Msk                                        (0x8000UL)		/*!< SYSCFG IO_ISCR: PA15_ISC (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_ISCR_PA15_ISC                                            SYSCFG_IO_ISCR_PA15_ISC_Msk
#define SYSCFG_IO_ISCR_PA14_ISC_Pos                                        (14UL)		/*!<SYSCFG IO_ISCR: PA14_ISC (Bit 14) */
#define SYSCFG_IO_ISCR_PA14_ISC_Msk                                        (0x4000UL)		/*!< SYSCFG IO_ISCR: PA14_ISC (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_ISCR_PA14_ISC                                            SYSCFG_IO_ISCR_PA14_ISC_Msk
#define SYSCFG_IO_ISCR_PA13_ISC_Pos                                        (13UL)		/*!<SYSCFG IO_ISCR: PA13_ISC (Bit 13) */
#define SYSCFG_IO_ISCR_PA13_ISC_Msk                                        (0x2000UL)		/*!< SYSCFG IO_ISCR: PA13_ISC (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_ISCR_PA13_ISC                                            SYSCFG_IO_ISCR_PA13_ISC_Msk
#define SYSCFG_IO_ISCR_PA12_ISC_Pos                                        (12UL)		/*!<SYSCFG IO_ISCR: PA12_ISC (Bit 12) */
#define SYSCFG_IO_ISCR_PA12_ISC_Msk                                        (0x1000UL)		/*!< SYSCFG IO_ISCR: PA12_ISC (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_ISCR_PA12_ISC                                            SYSCFG_IO_ISCR_PA12_ISC_Msk
#define SYSCFG_IO_ISCR_PA11_ISC_Pos                                        (11UL)		/*!<SYSCFG IO_ISCR: PA11_ISC (Bit 11) */
#define SYSCFG_IO_ISCR_PA11_ISC_Msk                                        (0x800UL)		/*!< SYSCFG IO_ISCR: PA11_ISC (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_ISCR_PA11_ISC                                            SYSCFG_IO_ISCR_PA11_ISC_Msk
#define SYSCFG_IO_ISCR_PA10_ISC_Pos                                        (10UL)		/*!<SYSCFG IO_ISCR: PA10_ISC (Bit 10) */
#define SYSCFG_IO_ISCR_PA10_ISC_Msk                                        (0x400UL)		/*!< SYSCFG IO_ISCR: PA10_ISC (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_ISCR_PA10_ISC                                            SYSCFG_IO_ISCR_PA10_ISC_Msk
#define SYSCFG_IO_ISCR_PA9_ISC_Pos                                         (9UL)		/*!<SYSCFG IO_ISCR: PA9_ISC (Bit 9) */
#define SYSCFG_IO_ISCR_PA9_ISC_Msk                                         (0x200UL)		/*!< SYSCFG IO_ISCR: PA9_ISC (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_ISCR_PA9_ISC                                             SYSCFG_IO_ISCR_PA9_ISC_Msk
#define SYSCFG_IO_ISCR_PA8_ISC_Pos                                         (8UL)		/*!<SYSCFG IO_ISCR: PA8_ISC (Bit 8) */
#define SYSCFG_IO_ISCR_PA8_ISC_Msk                                         (0x100UL)		/*!< SYSCFG IO_ISCR: PA8_ISC (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_ISCR_PA8_ISC                                             SYSCFG_IO_ISCR_PA8_ISC_Msk
#define SYSCFG_IO_ISCR_PA7_ISC_Pos                                         (7UL)		/*!<SYSCFG IO_ISCR: PA7_ISC (Bit 7) */
#define SYSCFG_IO_ISCR_PA7_ISC_Msk                                         (0x80UL)		/*!< SYSCFG IO_ISCR: PA7_ISC (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_ISCR_PA7_ISC                                             SYSCFG_IO_ISCR_PA7_ISC_Msk
#define SYSCFG_IO_ISCR_PA6_ISC_Pos                                         (6UL)		/*!<SYSCFG IO_ISCR: PA6_ISC (Bit 6) */
#define SYSCFG_IO_ISCR_PA6_ISC_Msk                                         (0x40UL)		/*!< SYSCFG IO_ISCR: PA6_ISC (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_ISCR_PA6_ISC                                             SYSCFG_IO_ISCR_PA6_ISC_Msk
#define SYSCFG_IO_ISCR_PA5_ISC_Pos                                         (5UL)		/*!<SYSCFG IO_ISCR: PA5_ISC (Bit 5) */
#define SYSCFG_IO_ISCR_PA5_ISC_Msk                                         (0x20UL)		/*!< SYSCFG IO_ISCR: PA5_ISC (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_ISCR_PA5_ISC                                             SYSCFG_IO_ISCR_PA5_ISC_Msk
#define SYSCFG_IO_ISCR_PA4_ISC_Pos                                         (4UL)		/*!<SYSCFG IO_ISCR: PA4_ISC (Bit 4) */
#define SYSCFG_IO_ISCR_PA4_ISC_Msk                                         (0x10UL)		/*!< SYSCFG IO_ISCR: PA4_ISC (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_ISCR_PA4_ISC                                             SYSCFG_IO_ISCR_PA4_ISC_Msk
#define SYSCFG_IO_ISCR_PA3_ISC_Pos                                         (3UL)		/*!<SYSCFG IO_ISCR: PA3_ISC (Bit 3) */
#define SYSCFG_IO_ISCR_PA3_ISC_Msk                                         (0x8UL)		/*!< SYSCFG IO_ISCR: PA3_ISC (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_ISCR_PA3_ISC                                             SYSCFG_IO_ISCR_PA3_ISC_Msk
#define SYSCFG_IO_ISCR_PA2_ISC_Pos                                         (2UL)		/*!<SYSCFG IO_ISCR: PA2_ISC (Bit 2) */
#define SYSCFG_IO_ISCR_PA2_ISC_Msk                                         (0x4UL)		/*!< SYSCFG IO_ISCR: PA2_ISC (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_ISCR_PA2_ISC                                             SYSCFG_IO_ISCR_PA2_ISC_Msk
#define SYSCFG_IO_ISCR_PA1_ISC_Pos                                         (1UL)		/*!<SYSCFG IO_ISCR: PA1_ISC (Bit 1) */
#define SYSCFG_IO_ISCR_PA1_ISC_Msk                                         (0x2UL)		/*!< SYSCFG IO_ISCR: PA1_ISC (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_ISCR_PA1_ISC                                             SYSCFG_IO_ISCR_PA1_ISC_Msk
#define SYSCFG_IO_ISCR_PA0_ISC_Pos                                         (0UL)		/*!<SYSCFG IO_ISCR: PA0_ISC (Bit 0) */
#define SYSCFG_IO_ISCR_PA0_ISC_Msk                                         (0x1UL)		/*!< SYSCFG IO_ISCR: PA0_ISC (Bitfield-Mask: 0x01) */
#define SYSCFG_IO_ISCR_PA0_ISC                                             SYSCFG_IO_ISCR_PA0_ISC_Msk

/* =====================================================    PWRC_IER    ===================================================== */ 
#define SYSCFG_PWRC_IER_WKUP_IE_Pos                                        (2UL)		/*!<SYSCFG PWRC_IER: WKUP_IE (Bit 2) */
#define SYSCFG_PWRC_IER_WKUP_IE_Msk                                        (0x4UL)		/*!< SYSCFG PWRC_IER: WKUP_IE (Bitfield-Mask: 0x01) */
#define SYSCFG_PWRC_IER_WKUP_IE                                            SYSCFG_PWRC_IER_WKUP_IE_Msk
#define SYSCFG_PWRC_IER_PVD_IE_Pos                                         (1UL)		/*!<SYSCFG PWRC_IER: PVD_IE (Bit 1) */
#define SYSCFG_PWRC_IER_PVD_IE_Msk                                         (0x2UL)		/*!< SYSCFG PWRC_IER: PVD_IE (Bitfield-Mask: 0x01) */
#define SYSCFG_PWRC_IER_PVD_IE                                             SYSCFG_PWRC_IER_PVD_IE_Msk

/* =====================================================    PWRC_ISCR    ===================================================== */ 
#define SYSCFG_PWRC_ISCR_WKUP_ISC_Pos                                      (2UL)		/*!<SYSCFG PWRC_ISCR: WKUP_ISC (Bit 2) */
#define SYSCFG_PWRC_ISCR_WKUP_ISC_Msk                                      (0x4UL)		/*!< SYSCFG PWRC_ISCR: WKUP_ISC (Bitfield-Mask: 0x01) */
#define SYSCFG_PWRC_ISCR_WKUP_ISC                                          SYSCFG_PWRC_ISCR_WKUP_ISC_Msk
#define SYSCFG_PWRC_ISCR_PVD_ISC_Pos                                       (1UL)		/*!<SYSCFG PWRC_ISCR: PVD_ISC (Bit 1) */
#define SYSCFG_PWRC_ISCR_PVD_ISC_Msk                                       (0x2UL)		/*!< SYSCFG PWRC_ISCR: PVD_ISC (Bitfield-Mask: 0x01) */
#define SYSCFG_PWRC_ISCR_PVD_ISC                                           SYSCFG_PWRC_ISCR_PVD_ISC_Msk

/* =====================================================    GPIO_SWA_CTRL    ===================================================== */ 
#define SYSCFG_GPIO_SWA_CTRL_PGACAP_nVIN0_Pos                              (1UL)		/*!<SYSCFG GPIO_SWA_CTRL: PGACAP_nVIN0 (Bit 1) */
#define SYSCFG_GPIO_SWA_CTRL_PGACAP_nVIN0_Msk                              (0x2UL)		/*!< SYSCFG GPIO_SWA_CTRL: PGACAP_nVIN0 (Bitfield-Mask: 0x01) */
#define SYSCFG_GPIO_SWA_CTRL_PGACAP_nVIN0                                  SYSCFG_GPIO_SWA_CTRL_PGACAP_nVIN0_Msk
#define SYSCFG_GPIO_SWA_CTRL_ATB1_nPVD_Pos                                 (0UL)		/*!<SYSCFG GPIO_SWA_CTRL: ATB1_nPVD (Bit 0) */
#define SYSCFG_GPIO_SWA_CTRL_ATB1_nPVD_Msk                                 (0x1UL)		/*!< SYSCFG GPIO_SWA_CTRL: ATB1_nPVD (Bitfield-Mask: 0x01) */
#define SYSCFG_GPIO_SWA_CTRL_ATB1_nPVD                                     SYSCFG_GPIO_SWA_CTRL_ATB1_nPVD_Msk

/* =====================================================    BLERXTX_DTR    ===================================================== */ 
#define SYSCFG_BLERXTX_DTR_RX_DT_Pos                                       (1UL)		/*!<SYSCFG BLERXTX_DTR: RX_DT (Bit 1) */
#define SYSCFG_BLERXTX_DTR_RX_DT_Msk                                       (0x2UL)		/*!< SYSCFG BLERXTX_DTR: RX_DT (Bitfield-Mask: 0x01) */
#define SYSCFG_BLERXTX_DTR_RX_DT                                           SYSCFG_BLERXTX_DTR_RX_DT_Msk
#define SYSCFG_BLERXTX_DTR_TX_DT_Pos                                       (0UL)		/*!<SYSCFG BLERXTX_DTR: TX_DT (Bit 0) */
#define SYSCFG_BLERXTX_DTR_TX_DT_Msk                                       (0x1UL)		/*!< SYSCFG BLERXTX_DTR: TX_DT (Bitfield-Mask: 0x01) */
#define SYSCFG_BLERXTX_DTR_TX_DT                                           SYSCFG_BLERXTX_DTR_TX_DT_Msk

/* =====================================================    BLERXTX_IBER    ===================================================== */ 
#define SYSCFG_BLERXTX_IBER_RX_IBE_Pos                                     (1UL)		/*!<SYSCFG BLERXTX_IBER: RX_IBE (Bit 1) */
#define SYSCFG_BLERXTX_IBER_RX_IBE_Msk                                     (0x2UL)		/*!< SYSCFG BLERXTX_IBER: RX_IBE (Bitfield-Mask: 0x01) */
#define SYSCFG_BLERXTX_IBER_RX_IBE                                         SYSCFG_BLERXTX_IBER_RX_IBE_Msk
#define SYSCFG_BLERXTX_IBER_TX_IBE_Pos                                     (0UL)		/*!<SYSCFG BLERXTX_IBER: TX_IBE (Bit 0) */
#define SYSCFG_BLERXTX_IBER_TX_IBE_Msk                                     (0x1UL)		/*!< SYSCFG BLERXTX_IBER: TX_IBE (Bitfield-Mask: 0x01) */
#define SYSCFG_BLERXTX_IBER_TX_IBE                                         SYSCFG_BLERXTX_IBER_TX_IBE_Msk

/* =====================================================    BLERXTX_IEVR    ===================================================== */ 
#define SYSCFG_BLERXTX_IEVR_RX_IEV_Pos                                     (1UL)		/*!<SYSCFG BLERXTX_IEVR: RX_IEV (Bit 1) */
#define SYSCFG_BLERXTX_IEVR_RX_IEV_Msk                                     (0x2UL)		/*!< SYSCFG BLERXTX_IEVR: RX_IEV (Bitfield-Mask: 0x01) */
#define SYSCFG_BLERXTX_IEVR_RX_IEV                                         SYSCFG_BLERXTX_IEVR_RX_IEV_Msk
#define SYSCFG_BLERXTX_IEVR_TX_IEV_Pos                                     (0UL)		/*!<SYSCFG BLERXTX_IEVR: TX_IEV (Bit 0) */
#define SYSCFG_BLERXTX_IEVR_TX_IEV_Msk                                     (0x1UL)		/*!< SYSCFG BLERXTX_IEVR: TX_IEV (Bitfield-Mask: 0x01) */
#define SYSCFG_BLERXTX_IEVR_TX_IEV                                         SYSCFG_BLERXTX_IEVR_TX_IEV_Msk

/* =====================================================    BLERXTX_IER    ===================================================== */ 
#define SYSCFG_BLERXTX_IER_RX_IE_Pos                                       (1UL)		/*!<SYSCFG BLERXTX_IER: RX_IE (Bit 1) */
#define SYSCFG_BLERXTX_IER_RX_IE_Msk                                       (0x2UL)		/*!< SYSCFG BLERXTX_IER: RX_IE (Bitfield-Mask: 0x01) */
#define SYSCFG_BLERXTX_IER_RX_IE                                           SYSCFG_BLERXTX_IER_RX_IE_Msk
#define SYSCFG_BLERXTX_IER_TX_IE_Pos                                       (0UL)		/*!<SYSCFG BLERXTX_IER: TX_IE (Bit 0) */
#define SYSCFG_BLERXTX_IER_TX_IE_Msk                                       (0x1UL)		/*!< SYSCFG BLERXTX_IER: TX_IE (Bitfield-Mask: 0x01) */
#define SYSCFG_BLERXTX_IER_TX_IE                                           SYSCFG_BLERXTX_IER_TX_IE_Msk

/* =====================================================    BLERXTX_ISCR    ===================================================== */ 
#define SYSCFG_BLERXTX_ISCR_RX_ISC_Pos                                     (1UL)		/*!<SYSCFG BLERXTX_ISCR: RX_ISC (Bit 1) */
#define SYSCFG_BLERXTX_ISCR_RX_ISC_Msk                                     (0x2UL)		/*!< SYSCFG BLERXTX_ISCR: RX_ISC (Bitfield-Mask: 0x01) */
#define SYSCFG_BLERXTX_ISCR_RX_ISC                                         SYSCFG_BLERXTX_ISCR_RX_ISC_Msk
#define SYSCFG_BLERXTX_ISCR_TX_ISC_Pos                                     (0UL)		/*!<SYSCFG BLERXTX_ISCR: TX_ISC (Bit 0) */
#define SYSCFG_BLERXTX_ISCR_TX_ISC_Msk                                     (0x1UL)		/*!< SYSCFG BLERXTX_ISCR: TX_ISC (Bitfield-Mask: 0x01) */
#define SYSCFG_BLERXTX_ISCR_TX_ISC                                         SYSCFG_BLERXTX_ISCR_TX_ISC_Msk
  

/* =========================================================================================================================== */ 
/*=====================                                       RNG                                       ===================== */ 
/* =========================================================================================================================== */ 

/* =====================================================    CR    ===================================================== */ 
#define RNG_CR_TST_CLK_Pos                                                 (3UL)		/*!<RNG CR: TST_CLK (Bit 3) */
#define RNG_CR_TST_CLK_Msk                                                 (0x8UL)		/*!< RNG CR: TST_CLK (Bitfield-Mask: 0x01) */
#define RNG_CR_TST_CLK                                                     RNG_CR_TST_CLK_Msk
#define RNG_CR_RNG_DIS_Pos                                                 (2UL)		/*!<RNG CR: RNG_DIS (Bit 2) */
#define RNG_CR_RNG_DIS_Msk                                                 (0x4UL)		/*!< RNG CR: RNG_DIS (Bitfield-Mask: 0x01) */
#define RNG_CR_RNG_DIS                                                     RNG_CR_RNG_DIS_Msk

/* =====================================================    SR    ===================================================== */ 
#define RNG_SR_FAULT_Pos                                                   (2UL)		/*!<RNG SR: FAULT (Bit 2) */
#define RNG_SR_FAULT_Msk                                                   (0x4UL)		/*!< RNG SR: FAULT (Bitfield-Mask: 0x01) */
#define RNG_SR_FAULT                                                       RNG_SR_FAULT_Msk
#define RNG_SR_REVCLK_Pos                                                  (1UL)		/*!<RNG SR: REVCLK (Bit 1) */
#define RNG_SR_REVCLK_Msk                                                  (0x2UL)		/*!< RNG SR: REVCLK (Bitfield-Mask: 0x01) */
#define RNG_SR_REVCLK                                                      RNG_SR_REVCLK_Msk
#define RNG_SR_RNGRDY_Pos                                                  (0UL)		/*!<RNG SR: RNGRDY (Bit 0) */
#define RNG_SR_RNGRDY_Msk                                                  (0x1UL)		/*!< RNG SR: RNGRDY (Bitfield-Mask: 0x01) */
#define RNG_SR_RNGRDY                                                      RNG_SR_RNGRDY_Msk

/* =====================================================    VAL    ===================================================== */ 
#define RNG_VAL_RANDOM_VALUE_Pos                                           (0UL)		/*!<RNG VAL: RANDOM_VALUE (Bit 0) */
#define RNG_VAL_RANDOM_VALUE_Msk                                           (0xffffUL)		/*!< RNG VAL: RANDOM_VALUE (Bitfield-Mask: 0xffff) */
#define RNG_VAL_RANDOM_VALUE                                               RNG_VAL_RANDOM_VALUE_Msk
#define RNG_VAL_RANDOM_VALUE_0                                             (0x1U << RNG_VAL_RANDOM_VALUE_Pos)
#define RNG_VAL_RANDOM_VALUE_1                                             (0x2U << RNG_VAL_RANDOM_VALUE_Pos)
#define RNG_VAL_RANDOM_VALUE_2                                             (0x4U << RNG_VAL_RANDOM_VALUE_Pos)
#define RNG_VAL_RANDOM_VALUE_3                                             (0x8U << RNG_VAL_RANDOM_VALUE_Pos)
#define RNG_VAL_RANDOM_VALUE_4                                             (0x10U << RNG_VAL_RANDOM_VALUE_Pos)
#define RNG_VAL_RANDOM_VALUE_5                                             (0x20U << RNG_VAL_RANDOM_VALUE_Pos)
#define RNG_VAL_RANDOM_VALUE_6                                             (0x40U << RNG_VAL_RANDOM_VALUE_Pos)
#define RNG_VAL_RANDOM_VALUE_7                                             (0x80U << RNG_VAL_RANDOM_VALUE_Pos)
#define RNG_VAL_RANDOM_VALUE_8                                             (0x100U << RNG_VAL_RANDOM_VALUE_Pos)
#define RNG_VAL_RANDOM_VALUE_9                                             (0x200U << RNG_VAL_RANDOM_VALUE_Pos)
#define RNG_VAL_RANDOM_VALUE_10                                            (0x400U << RNG_VAL_RANDOM_VALUE_Pos)
#define RNG_VAL_RANDOM_VALUE_11                                            (0x800U << RNG_VAL_RANDOM_VALUE_Pos)
#define RNG_VAL_RANDOM_VALUE_12                                            (0x1000U << RNG_VAL_RANDOM_VALUE_Pos)
#define RNG_VAL_RANDOM_VALUE_13                                            (0x2000U << RNG_VAL_RANDOM_VALUE_Pos)
#define RNG_VAL_RANDOM_VALUE_14                                            (0x4000U << RNG_VAL_RANDOM_VALUE_Pos)
#define RNG_VAL_RANDOM_VALUE_15                                            (0x8000U << RNG_VAL_RANDOM_VALUE_Pos)


/* =========================================================================================================================== */ 
/*=====================                                       GPIO                                       ===================== */ 
/* =========================================================================================================================== */ 

/* =====================================================    MODER    ===================================================== */ 
#define GPIO_MODER_MODE15_Pos                                              (30UL)		/*!<GPIO MODER: MODE15 (Bit 30) */
#define GPIO_MODER_MODE15_Msk                                              (0xc0000000UL)		/*!< GPIO MODER: MODE15 (Bitfield-Mask: 0x03) */
#define GPIO_MODER_MODE15                                                  GPIO_MODER_MODE15_Msk
#define GPIO_MODER_MODE15_0                                                (0x1U << GPIO_MODER_MODE15_Pos)
#define GPIO_MODER_MODE15_1                                                (0x2U << GPIO_MODER_MODE15_Pos)
#define GPIO_MODER_MODE14_Pos                                              (28UL)		/*!<GPIO MODER: MODE14 (Bit 28) */
#define GPIO_MODER_MODE14_Msk                                              (0x30000000UL)		/*!< GPIO MODER: MODE14 (Bitfield-Mask: 0x03) */
#define GPIO_MODER_MODE14                                                  GPIO_MODER_MODE14_Msk
#define GPIO_MODER_MODE14_0                                                (0x1U << GPIO_MODER_MODE14_Pos)
#define GPIO_MODER_MODE14_1                                                (0x2U << GPIO_MODER_MODE14_Pos)
#define GPIO_MODER_MODE13_Pos                                              (26UL)		/*!<GPIO MODER: MODE13 (Bit 26) */
#define GPIO_MODER_MODE13_Msk                                              (0xc000000UL)		/*!< GPIO MODER: MODE13 (Bitfield-Mask: 0x03) */
#define GPIO_MODER_MODE13                                                  GPIO_MODER_MODE13_Msk
#define GPIO_MODER_MODE13_0                                                (0x1U << GPIO_MODER_MODE13_Pos)
#define GPIO_MODER_MODE13_1                                                (0x2U << GPIO_MODER_MODE13_Pos)
#define GPIO_MODER_MODE12_Pos                                              (24UL)		/*!<GPIO MODER: MODE12 (Bit 24) */
#define GPIO_MODER_MODE12_Msk                                              (0x3000000UL)		/*!< GPIO MODER: MODE12 (Bitfield-Mask: 0x03) */
#define GPIO_MODER_MODE12                                                  GPIO_MODER_MODE12_Msk
#define GPIO_MODER_MODE12_0                                                (0x1U << GPIO_MODER_MODE12_Pos)
#define GPIO_MODER_MODE12_1                                                (0x2U << GPIO_MODER_MODE12_Pos)
#define GPIO_MODER_MODE11_Pos                                              (22UL)		/*!<GPIO MODER: MODE11 (Bit 22) */
#define GPIO_MODER_MODE11_Msk                                              (0xc00000UL)		/*!< GPIO MODER: MODE11 (Bitfield-Mask: 0x03) */
#define GPIO_MODER_MODE11                                                  GPIO_MODER_MODE11_Msk
#define GPIO_MODER_MODE11_0                                                (0x1U << GPIO_MODER_MODE11_Pos)
#define GPIO_MODER_MODE11_1                                                (0x2U << GPIO_MODER_MODE11_Pos)
#define GPIO_MODER_MODE10_Pos                                              (20UL)		/*!<GPIO MODER: MODE10 (Bit 20) */
#define GPIO_MODER_MODE10_Msk                                              (0x300000UL)		/*!< GPIO MODER: MODE10 (Bitfield-Mask: 0x03) */
#define GPIO_MODER_MODE10                                                  GPIO_MODER_MODE10_Msk
#define GPIO_MODER_MODE10_0                                                (0x1U << GPIO_MODER_MODE10_Pos)
#define GPIO_MODER_MODE10_1                                                (0x2U << GPIO_MODER_MODE10_Pos)
#define GPIO_MODER_MODE9_Pos                                               (18UL)		/*!<GPIO MODER: MODE9 (Bit 18) */
#define GPIO_MODER_MODE9_Msk                                               (0xc0000UL)		/*!< GPIO MODER: MODE9 (Bitfield-Mask: 0x03) */
#define GPIO_MODER_MODE9                                                   GPIO_MODER_MODE9_Msk
#define GPIO_MODER_MODE9_0                                                 (0x1U << GPIO_MODER_MODE9_Pos)
#define GPIO_MODER_MODE9_1                                                 (0x2U << GPIO_MODER_MODE9_Pos)
#define GPIO_MODER_MODE8_Pos                                               (16UL)		/*!<GPIO MODER: MODE8 (Bit 16) */
#define GPIO_MODER_MODE8_Msk                                               (0x30000UL)		/*!< GPIO MODER: MODE8 (Bitfield-Mask: 0x03) */
#define GPIO_MODER_MODE8                                                   GPIO_MODER_MODE8_Msk
#define GPIO_MODER_MODE8_0                                                 (0x1U << GPIO_MODER_MODE8_Pos)
#define GPIO_MODER_MODE8_1                                                 (0x2U << GPIO_MODER_MODE8_Pos)
#define GPIO_MODER_MODE7_Pos                                               (14UL)		/*!<GPIO MODER: MODE7 (Bit 14) */
#define GPIO_MODER_MODE7_Msk                                               (0xc000UL)		/*!< GPIO MODER: MODE7 (Bitfield-Mask: 0x03) */
#define GPIO_MODER_MODE7                                                   GPIO_MODER_MODE7_Msk
#define GPIO_MODER_MODE7_0                                                 (0x1U << GPIO_MODER_MODE7_Pos)
#define GPIO_MODER_MODE7_1                                                 (0x2U << GPIO_MODER_MODE7_Pos)
#define GPIO_MODER_MODE6_Pos                                               (12UL)		/*!<GPIO MODER: MODE6 (Bit 12) */
#define GPIO_MODER_MODE6_Msk                                               (0x3000UL)		/*!< GPIO MODER: MODE6 (Bitfield-Mask: 0x03) */
#define GPIO_MODER_MODE6                                                   GPIO_MODER_MODE6_Msk
#define GPIO_MODER_MODE6_0                                                 (0x1U << GPIO_MODER_MODE6_Pos)
#define GPIO_MODER_MODE6_1                                                 (0x2U << GPIO_MODER_MODE6_Pos)
#define GPIO_MODER_MODE5_Pos                                               (10UL)		/*!<GPIO MODER: MODE5 (Bit 10) */
#define GPIO_MODER_MODE5_Msk                                               (0xc00UL)		/*!< GPIO MODER: MODE5 (Bitfield-Mask: 0x03) */
#define GPIO_MODER_MODE5                                                   GPIO_MODER_MODE5_Msk
#define GPIO_MODER_MODE5_0                                                 (0x1U << GPIO_MODER_MODE5_Pos)
#define GPIO_MODER_MODE5_1                                                 (0x2U << GPIO_MODER_MODE5_Pos)
#define GPIO_MODER_MODE4_Pos                                               (8UL)		/*!<GPIO MODER: MODE4 (Bit 8) */
#define GPIO_MODER_MODE4_Msk                                               (0x300UL)		/*!< GPIO MODER: MODE4 (Bitfield-Mask: 0x03) */
#define GPIO_MODER_MODE4                                                   GPIO_MODER_MODE4_Msk
#define GPIO_MODER_MODE4_0                                                 (0x1U << GPIO_MODER_MODE4_Pos)
#define GPIO_MODER_MODE4_1                                                 (0x2U << GPIO_MODER_MODE4_Pos)
#define GPIO_MODER_MODE3_Pos                                               (6UL)		/*!<GPIO MODER: MODE3 (Bit 6) */
#define GPIO_MODER_MODE3_Msk                                               (0xc0UL)		/*!< GPIO MODER: MODE3 (Bitfield-Mask: 0x03) */
#define GPIO_MODER_MODE3                                                   GPIO_MODER_MODE3_Msk
#define GPIO_MODER_MODE3_0                                                 (0x1U << GPIO_MODER_MODE3_Pos)
#define GPIO_MODER_MODE3_1                                                 (0x2U << GPIO_MODER_MODE3_Pos)
#define GPIO_MODER_MODE2_Pos                                               (4UL)		/*!<GPIO MODER: MODE2 (Bit 4) */
#define GPIO_MODER_MODE2_Msk                                               (0x30UL)		/*!< GPIO MODER: MODE2 (Bitfield-Mask: 0x03) */
#define GPIO_MODER_MODE2                                                   GPIO_MODER_MODE2_Msk
#define GPIO_MODER_MODE2_0                                                 (0x1U << GPIO_MODER_MODE2_Pos)
#define GPIO_MODER_MODE2_1                                                 (0x2U << GPIO_MODER_MODE2_Pos)
#define GPIO_MODER_MODE1_Pos                                               (2UL)		/*!<GPIO MODER: MODE1 (Bit 2) */
#define GPIO_MODER_MODE1_Msk                                               (0xcUL)		/*!< GPIO MODER: MODE1 (Bitfield-Mask: 0x03) */
#define GPIO_MODER_MODE1                                                   GPIO_MODER_MODE1_Msk
#define GPIO_MODER_MODE1_0                                                 (0x1U << GPIO_MODER_MODE1_Pos)
#define GPIO_MODER_MODE1_1                                                 (0x2U << GPIO_MODER_MODE1_Pos)
#define GPIO_MODER_MODE0_Pos                                               (0UL)		/*!<GPIO MODER: MODE0 (Bit 0) */
#define GPIO_MODER_MODE0_Msk                                               (0x3UL)		/*!< GPIO MODER: MODE0 (Bitfield-Mask: 0x03) */
#define GPIO_MODER_MODE0                                                   GPIO_MODER_MODE0_Msk
#define GPIO_MODER_MODE0_0                                                 (0x1U << GPIO_MODER_MODE0_Pos)
#define GPIO_MODER_MODE0_1                                                 (0x2U << GPIO_MODER_MODE0_Pos)

/* =====================================================    OTYPER    ===================================================== */ 
#define GPIO_OTYPER_OT15_Pos                                               (15UL)		/*!<GPIO OTYPER: OT15 (Bit 15) */
#define GPIO_OTYPER_OT15_Msk                                               (0x8000UL)		/*!< GPIO OTYPER: OT15 (Bitfield-Mask: 0x01) */
#define GPIO_OTYPER_OT15                                                   GPIO_OTYPER_OT15_Msk
#define GPIO_OTYPER_OT14_Pos                                               (14UL)		/*!<GPIO OTYPER: OT14 (Bit 14) */
#define GPIO_OTYPER_OT14_Msk                                               (0x4000UL)		/*!< GPIO OTYPER: OT14 (Bitfield-Mask: 0x01) */
#define GPIO_OTYPER_OT14                                                   GPIO_OTYPER_OT14_Msk
#define GPIO_OTYPER_OT13_Pos                                               (13UL)		/*!<GPIO OTYPER: OT13 (Bit 13) */
#define GPIO_OTYPER_OT13_Msk                                               (0x2000UL)		/*!< GPIO OTYPER: OT13 (Bitfield-Mask: 0x01) */
#define GPIO_OTYPER_OT13                                                   GPIO_OTYPER_OT13_Msk
#define GPIO_OTYPER_OT12_Pos                                               (12UL)		/*!<GPIO OTYPER: OT12 (Bit 12) */
#define GPIO_OTYPER_OT12_Msk                                               (0x1000UL)		/*!< GPIO OTYPER: OT12 (Bitfield-Mask: 0x01) */
#define GPIO_OTYPER_OT12                                                   GPIO_OTYPER_OT12_Msk
#define GPIO_OTYPER_OT11_Pos                                               (11UL)		/*!<GPIO OTYPER: OT11 (Bit 11) */
#define GPIO_OTYPER_OT11_Msk                                               (0x800UL)		/*!< GPIO OTYPER: OT11 (Bitfield-Mask: 0x01) */
#define GPIO_OTYPER_OT11                                                   GPIO_OTYPER_OT11_Msk
#define GPIO_OTYPER_OT10_Pos                                               (10UL)		/*!<GPIO OTYPER: OT10 (Bit 10) */
#define GPIO_OTYPER_OT10_Msk                                               (0x400UL)		/*!< GPIO OTYPER: OT10 (Bitfield-Mask: 0x01) */
#define GPIO_OTYPER_OT10                                                   GPIO_OTYPER_OT10_Msk
#define GPIO_OTYPER_OT9_Pos                                                (9UL)		/*!<GPIO OTYPER: OT9 (Bit 9) */
#define GPIO_OTYPER_OT9_Msk                                                (0x200UL)		/*!< GPIO OTYPER: OT9 (Bitfield-Mask: 0x01) */
#define GPIO_OTYPER_OT9                                                    GPIO_OTYPER_OT9_Msk
#define GPIO_OTYPER_OT8_Pos                                                (8UL)		/*!<GPIO OTYPER: OT8 (Bit 8) */
#define GPIO_OTYPER_OT8_Msk                                                (0x100UL)		/*!< GPIO OTYPER: OT8 (Bitfield-Mask: 0x01) */
#define GPIO_OTYPER_OT8                                                    GPIO_OTYPER_OT8_Msk
#define GPIO_OTYPER_OT7_Pos                                                (7UL)		/*!<GPIO OTYPER: OT7 (Bit 7) */
#define GPIO_OTYPER_OT7_Msk                                                (0x80UL)		/*!< GPIO OTYPER: OT7 (Bitfield-Mask: 0x01) */
#define GPIO_OTYPER_OT7                                                    GPIO_OTYPER_OT7_Msk
#define GPIO_OTYPER_OT6_Pos                                                (6UL)		/*!<GPIO OTYPER: OT6 (Bit 6) */
#define GPIO_OTYPER_OT6_Msk                                                (0x40UL)		/*!< GPIO OTYPER: OT6 (Bitfield-Mask: 0x01) */
#define GPIO_OTYPER_OT6                                                    GPIO_OTYPER_OT6_Msk
#define GPIO_OTYPER_OT5_Pos                                                (5UL)		/*!<GPIO OTYPER: OT5 (Bit 5) */
#define GPIO_OTYPER_OT5_Msk                                                (0x20UL)		/*!< GPIO OTYPER: OT5 (Bitfield-Mask: 0x01) */
#define GPIO_OTYPER_OT5                                                    GPIO_OTYPER_OT5_Msk
#define GPIO_OTYPER_OT4_Pos                                                (4UL)		/*!<GPIO OTYPER: OT4 (Bit 4) */
#define GPIO_OTYPER_OT4_Msk                                                (0x10UL)		/*!< GPIO OTYPER: OT4 (Bitfield-Mask: 0x01) */
#define GPIO_OTYPER_OT4                                                    GPIO_OTYPER_OT4_Msk
#define GPIO_OTYPER_OT3_Pos                                                (3UL)		/*!<GPIO OTYPER: OT3 (Bit 3) */
#define GPIO_OTYPER_OT3_Msk                                                (0x8UL)		/*!< GPIO OTYPER: OT3 (Bitfield-Mask: 0x01) */
#define GPIO_OTYPER_OT3                                                    GPIO_OTYPER_OT3_Msk
#define GPIO_OTYPER_OT2_Pos                                                (2UL)		/*!<GPIO OTYPER: OT2 (Bit 2) */
#define GPIO_OTYPER_OT2_Msk                                                (0x4UL)		/*!< GPIO OTYPER: OT2 (Bitfield-Mask: 0x01) */
#define GPIO_OTYPER_OT2                                                    GPIO_OTYPER_OT2_Msk
#define GPIO_OTYPER_OT1_Pos                                                (1UL)		/*!<GPIO OTYPER: OT1 (Bit 1) */
#define GPIO_OTYPER_OT1_Msk                                                (0x2UL)		/*!< GPIO OTYPER: OT1 (Bitfield-Mask: 0x01) */
#define GPIO_OTYPER_OT1                                                    GPIO_OTYPER_OT1_Msk
#define GPIO_OTYPER_OT0_Pos                                                (0UL)		/*!<GPIO OTYPER: OT0 (Bit 0) */
#define GPIO_OTYPER_OT0_Msk                                                (0x1UL)		/*!< GPIO OTYPER: OT0 (Bitfield-Mask: 0x01) */
#define GPIO_OTYPER_OT0                                                    GPIO_OTYPER_OT0_Msk

/* =====================================================    OSPEEDR    ===================================================== */ 
#define GPIO_OSPEEDR_OSPEED15_Pos                                          (30UL)		/*!<GPIO OSPEEDR: OSPEED15 (Bit 30) */
#define GPIO_OSPEEDR_OSPEED15_Msk                                          (0xc0000000UL)		/*!< GPIO OSPEEDR: OSPEED15 (Bitfield-Mask: 0x03) */
#define GPIO_OSPEEDR_OSPEED15                                              GPIO_OSPEEDR_OSPEED15_Msk
#define GPIO_OSPEEDR_OSPEED15_0                                            (0x1U << GPIO_OSPEEDR_OSPEED15_Pos)
#define GPIO_OSPEEDR_OSPEED15_1                                            (0x2U << GPIO_OSPEEDR_OSPEED15_Pos)
#define GPIO_OSPEEDR_OSPEED14_Pos                                          (28UL)		/*!<GPIO OSPEEDR: OSPEED14 (Bit 28) */
#define GPIO_OSPEEDR_OSPEED14_Msk                                          (0x30000000UL)		/*!< GPIO OSPEEDR: OSPEED14 (Bitfield-Mask: 0x03) */
#define GPIO_OSPEEDR_OSPEED14                                              GPIO_OSPEEDR_OSPEED14_Msk
#define GPIO_OSPEEDR_OSPEED14_0                                            (0x1U << GPIO_OSPEEDR_OSPEED14_Pos)
#define GPIO_OSPEEDR_OSPEED14_1                                            (0x2U << GPIO_OSPEEDR_OSPEED14_Pos)
#define GPIO_OSPEEDR_OSPEED13_Pos                                          (26UL)		/*!<GPIO OSPEEDR: OSPEED13 (Bit 26) */
#define GPIO_OSPEEDR_OSPEED13_Msk                                          (0xc000000UL)		/*!< GPIO OSPEEDR: OSPEED13 (Bitfield-Mask: 0x03) */
#define GPIO_OSPEEDR_OSPEED13                                              GPIO_OSPEEDR_OSPEED13_Msk
#define GPIO_OSPEEDR_OSPEED13_0                                            (0x1U << GPIO_OSPEEDR_OSPEED13_Pos)
#define GPIO_OSPEEDR_OSPEED13_1                                            (0x2U << GPIO_OSPEEDR_OSPEED13_Pos)
#define GPIO_OSPEEDR_OSPEED12_Pos                                          (24UL)		/*!<GPIO OSPEEDR: OSPEED12 (Bit 24) */
#define GPIO_OSPEEDR_OSPEED12_Msk                                          (0x3000000UL)		/*!< GPIO OSPEEDR: OSPEED12 (Bitfield-Mask: 0x03) */
#define GPIO_OSPEEDR_OSPEED12                                              GPIO_OSPEEDR_OSPEED12_Msk
#define GPIO_OSPEEDR_OSPEED12_0                                            (0x1U << GPIO_OSPEEDR_OSPEED12_Pos)
#define GPIO_OSPEEDR_OSPEED12_1                                            (0x2U << GPIO_OSPEEDR_OSPEED12_Pos)
#define GPIO_OSPEEDR_OSPEED11_Pos                                          (22UL)		/*!<GPIO OSPEEDR: OSPEED11 (Bit 22) */
#define GPIO_OSPEEDR_OSPEED11_Msk                                          (0xc00000UL)		/*!< GPIO OSPEEDR: OSPEED11 (Bitfield-Mask: 0x03) */
#define GPIO_OSPEEDR_OSPEED11                                              GPIO_OSPEEDR_OSPEED11_Msk
#define GPIO_OSPEEDR_OSPEED11_0                                            (0x1U << GPIO_OSPEEDR_OSPEED11_Pos)
#define GPIO_OSPEEDR_OSPEED11_1                                            (0x2U << GPIO_OSPEEDR_OSPEED11_Pos)
#define GPIO_OSPEEDR_OSPEED10_Pos                                          (20UL)		/*!<GPIO OSPEEDR: OSPEED10 (Bit 20) */
#define GPIO_OSPEEDR_OSPEED10_Msk                                          (0x300000UL)		/*!< GPIO OSPEEDR: OSPEED10 (Bitfield-Mask: 0x03) */
#define GPIO_OSPEEDR_OSPEED10                                              GPIO_OSPEEDR_OSPEED10_Msk
#define GPIO_OSPEEDR_OSPEED10_0                                            (0x1U << GPIO_OSPEEDR_OSPEED10_Pos)
#define GPIO_OSPEEDR_OSPEED10_1                                            (0x2U << GPIO_OSPEEDR_OSPEED10_Pos)
#define GPIO_OSPEEDR_OSPEED9_Pos                                           (18UL)		/*!<GPIO OSPEEDR: OSPEED9 (Bit 18) */
#define GPIO_OSPEEDR_OSPEED9_Msk                                           (0xc0000UL)		/*!< GPIO OSPEEDR: OSPEED9 (Bitfield-Mask: 0x03) */
#define GPIO_OSPEEDR_OSPEED9                                               GPIO_OSPEEDR_OSPEED9_Msk
#define GPIO_OSPEEDR_OSPEED9_0                                             (0x1U << GPIO_OSPEEDR_OSPEED9_Pos)
#define GPIO_OSPEEDR_OSPEED9_1                                             (0x2U << GPIO_OSPEEDR_OSPEED9_Pos)
#define GPIO_OSPEEDR_OSPEED8_Pos                                           (16UL)		/*!<GPIO OSPEEDR: OSPEED8 (Bit 16) */
#define GPIO_OSPEEDR_OSPEED8_Msk                                           (0x30000UL)		/*!< GPIO OSPEEDR: OSPEED8 (Bitfield-Mask: 0x03) */
#define GPIO_OSPEEDR_OSPEED8                                               GPIO_OSPEEDR_OSPEED8_Msk
#define GPIO_OSPEEDR_OSPEED8_0                                             (0x1U << GPIO_OSPEEDR_OSPEED8_Pos)
#define GPIO_OSPEEDR_OSPEED8_1                                             (0x2U << GPIO_OSPEEDR_OSPEED8_Pos)
#define GPIO_OSPEEDR_OSPEED7_Pos                                           (14UL)		/*!<GPIO OSPEEDR: OSPEED7 (Bit 14) */
#define GPIO_OSPEEDR_OSPEED7_Msk                                           (0xc000UL)		/*!< GPIO OSPEEDR: OSPEED7 (Bitfield-Mask: 0x03) */
#define GPIO_OSPEEDR_OSPEED7                                               GPIO_OSPEEDR_OSPEED7_Msk
#define GPIO_OSPEEDR_OSPEED7_0                                             (0x1U << GPIO_OSPEEDR_OSPEED7_Pos)
#define GPIO_OSPEEDR_OSPEED7_1                                             (0x2U << GPIO_OSPEEDR_OSPEED7_Pos)
#define GPIO_OSPEEDR_OSPEED6_Pos                                           (12UL)		/*!<GPIO OSPEEDR: OSPEED6 (Bit 12) */
#define GPIO_OSPEEDR_OSPEED6_Msk                                           (0x3000UL)		/*!< GPIO OSPEEDR: OSPEED6 (Bitfield-Mask: 0x03) */
#define GPIO_OSPEEDR_OSPEED6                                               GPIO_OSPEEDR_OSPEED6_Msk
#define GPIO_OSPEEDR_OSPEED6_0                                             (0x1U << GPIO_OSPEEDR_OSPEED6_Pos)
#define GPIO_OSPEEDR_OSPEED6_1                                             (0x2U << GPIO_OSPEEDR_OSPEED6_Pos)
#define GPIO_OSPEEDR_OSPEED5_Pos                                           (10UL)		/*!<GPIO OSPEEDR: OSPEED5 (Bit 10) */
#define GPIO_OSPEEDR_OSPEED5_Msk                                           (0xc00UL)		/*!< GPIO OSPEEDR: OSPEED5 (Bitfield-Mask: 0x03) */
#define GPIO_OSPEEDR_OSPEED5                                               GPIO_OSPEEDR_OSPEED5_Msk
#define GPIO_OSPEEDR_OSPEED5_0                                             (0x1U << GPIO_OSPEEDR_OSPEED5_Pos)
#define GPIO_OSPEEDR_OSPEED5_1                                             (0x2U << GPIO_OSPEEDR_OSPEED5_Pos)
#define GPIO_OSPEEDR_OSPEED4_Pos                                           (8UL)		/*!<GPIO OSPEEDR: OSPEED4 (Bit 8) */
#define GPIO_OSPEEDR_OSPEED4_Msk                                           (0x300UL)		/*!< GPIO OSPEEDR: OSPEED4 (Bitfield-Mask: 0x03) */
#define GPIO_OSPEEDR_OSPEED4                                               GPIO_OSPEEDR_OSPEED4_Msk
#define GPIO_OSPEEDR_OSPEED4_0                                             (0x1U << GPIO_OSPEEDR_OSPEED4_Pos)
#define GPIO_OSPEEDR_OSPEED4_1                                             (0x2U << GPIO_OSPEEDR_OSPEED4_Pos)
#define GPIO_OSPEEDR_OSPEED3_Pos                                           (6UL)		/*!<GPIO OSPEEDR: OSPEED3 (Bit 6) */
#define GPIO_OSPEEDR_OSPEED3_Msk                                           (0xc0UL)		/*!< GPIO OSPEEDR: OSPEED3 (Bitfield-Mask: 0x03) */
#define GPIO_OSPEEDR_OSPEED3                                               GPIO_OSPEEDR_OSPEED3_Msk
#define GPIO_OSPEEDR_OSPEED3_0                                             (0x1U << GPIO_OSPEEDR_OSPEED3_Pos)
#define GPIO_OSPEEDR_OSPEED3_1                                             (0x2U << GPIO_OSPEEDR_OSPEED3_Pos)
#define GPIO_OSPEEDR_OSPEED2_Pos                                           (4UL)		/*!<GPIO OSPEEDR: OSPEED2 (Bit 4) */
#define GPIO_OSPEEDR_OSPEED2_Msk                                           (0x30UL)		/*!< GPIO OSPEEDR: OSPEED2 (Bitfield-Mask: 0x03) */
#define GPIO_OSPEEDR_OSPEED2                                               GPIO_OSPEEDR_OSPEED2_Msk
#define GPIO_OSPEEDR_OSPEED2_0                                             (0x1U << GPIO_OSPEEDR_OSPEED2_Pos)
#define GPIO_OSPEEDR_OSPEED2_1                                             (0x2U << GPIO_OSPEEDR_OSPEED2_Pos)
#define GPIO_OSPEEDR_OSPEED1_Pos                                           (2UL)		/*!<GPIO OSPEEDR: OSPEED1 (Bit 2) */
#define GPIO_OSPEEDR_OSPEED1_Msk                                           (0xcUL)		/*!< GPIO OSPEEDR: OSPEED1 (Bitfield-Mask: 0x03) */
#define GPIO_OSPEEDR_OSPEED1                                               GPIO_OSPEEDR_OSPEED1_Msk
#define GPIO_OSPEEDR_OSPEED1_0                                             (0x1U << GPIO_OSPEEDR_OSPEED1_Pos)
#define GPIO_OSPEEDR_OSPEED1_1                                             (0x2U << GPIO_OSPEEDR_OSPEED1_Pos)
#define GPIO_OSPEEDR_OSPEED0_Pos                                           (0UL)		/*!<GPIO OSPEEDR: OSPEED0 (Bit 0) */
#define GPIO_OSPEEDR_OSPEED0_Msk                                           (0x3UL)		/*!< GPIO OSPEEDR: OSPEED0 (Bitfield-Mask: 0x03) */
#define GPIO_OSPEEDR_OSPEED0                                               GPIO_OSPEEDR_OSPEED0_Msk
#define GPIO_OSPEEDR_OSPEED0_0                                             (0x1U << GPIO_OSPEEDR_OSPEED0_Pos)
#define GPIO_OSPEEDR_OSPEED0_1                                             (0x2U << GPIO_OSPEEDR_OSPEED0_Pos)

/* =====================================================    PUPDR    ===================================================== */ 
#define GPIO_PUPDR_PUPD15_Pos                                              (30UL)		/*!<GPIO PUPDR: PUPD15 (Bit 30) */
#define GPIO_PUPDR_PUPD15_Msk                                              (0xc0000000UL)		/*!< GPIO PUPDR: PUPD15 (Bitfield-Mask: 0x03) */
#define GPIO_PUPDR_PUPD15                                                  GPIO_PUPDR_PUPD15_Msk
#define GPIO_PUPDR_PUPD15_0                                                (0x1U << GPIO_PUPDR_PUPD15_Pos)
#define GPIO_PUPDR_PUPD15_1                                                (0x2U << GPIO_PUPDR_PUPD15_Pos)
#define GPIO_PUPDR_PUPD14_Pos                                              (28UL)		/*!<GPIO PUPDR: PUPD14 (Bit 28) */
#define GPIO_PUPDR_PUPD14_Msk                                              (0x30000000UL)		/*!< GPIO PUPDR: PUPD14 (Bitfield-Mask: 0x03) */
#define GPIO_PUPDR_PUPD14                                                  GPIO_PUPDR_PUPD14_Msk
#define GPIO_PUPDR_PUPD14_0                                                (0x1U << GPIO_PUPDR_PUPD14_Pos)
#define GPIO_PUPDR_PUPD14_1                                                (0x2U << GPIO_PUPDR_PUPD14_Pos)
#define GPIO_PUPDR_PUPD13_Pos                                              (26UL)		/*!<GPIO PUPDR: PUPD13 (Bit 26) */
#define GPIO_PUPDR_PUPD13_Msk                                              (0xc000000UL)		/*!< GPIO PUPDR: PUPD13 (Bitfield-Mask: 0x03) */
#define GPIO_PUPDR_PUPD13                                                  GPIO_PUPDR_PUPD13_Msk
#define GPIO_PUPDR_PUPD13_0                                                (0x1U << GPIO_PUPDR_PUPD13_Pos)
#define GPIO_PUPDR_PUPD13_1                                                (0x2U << GPIO_PUPDR_PUPD13_Pos)
#define GPIO_PUPDR_PUPD12_Pos                                              (24UL)		/*!<GPIO PUPDR: PUPD12 (Bit 24) */
#define GPIO_PUPDR_PUPD12_Msk                                              (0x3000000UL)		/*!< GPIO PUPDR: PUPD12 (Bitfield-Mask: 0x03) */
#define GPIO_PUPDR_PUPD12                                                  GPIO_PUPDR_PUPD12_Msk
#define GPIO_PUPDR_PUPD12_0                                                (0x1U << GPIO_PUPDR_PUPD12_Pos)
#define GPIO_PUPDR_PUPD12_1                                                (0x2U << GPIO_PUPDR_PUPD12_Pos)
#define GPIO_PUPDR_PUPD11_Pos                                              (22UL)		/*!<GPIO PUPDR: PUPD11 (Bit 22) */
#define GPIO_PUPDR_PUPD11_Msk                                              (0xc00000UL)		/*!< GPIO PUPDR: PUPD11 (Bitfield-Mask: 0x03) */
#define GPIO_PUPDR_PUPD11                                                  GPIO_PUPDR_PUPD11_Msk
#define GPIO_PUPDR_PUPD11_0                                                (0x1U << GPIO_PUPDR_PUPD11_Pos)
#define GPIO_PUPDR_PUPD11_1                                                (0x2U << GPIO_PUPDR_PUPD11_Pos)
#define GPIO_PUPDR_PUPD10_Pos                                              (20UL)		/*!<GPIO PUPDR: PUPD10 (Bit 20) */
#define GPIO_PUPDR_PUPD10_Msk                                              (0x300000UL)		/*!< GPIO PUPDR: PUPD10 (Bitfield-Mask: 0x03) */
#define GPIO_PUPDR_PUPD10                                                  GPIO_PUPDR_PUPD10_Msk
#define GPIO_PUPDR_PUPD10_0                                                (0x1U << GPIO_PUPDR_PUPD10_Pos)
#define GPIO_PUPDR_PUPD10_1                                                (0x2U << GPIO_PUPDR_PUPD10_Pos)
#define GPIO_PUPDR_PUPD9_Pos                                               (18UL)		/*!<GPIO PUPDR: PUPD9 (Bit 18) */
#define GPIO_PUPDR_PUPD9_Msk                                               (0xc0000UL)		/*!< GPIO PUPDR: PUPD9 (Bitfield-Mask: 0x03) */
#define GPIO_PUPDR_PUPD9                                                   GPIO_PUPDR_PUPD9_Msk
#define GPIO_PUPDR_PUPD9_0                                                 (0x1U << GPIO_PUPDR_PUPD9_Pos)
#define GPIO_PUPDR_PUPD9_1                                                 (0x2U << GPIO_PUPDR_PUPD9_Pos)
#define GPIO_PUPDR_PUPD8_Pos                                               (16UL)		/*!<GPIO PUPDR: PUPD8 (Bit 16) */
#define GPIO_PUPDR_PUPD8_Msk                                               (0x30000UL)		/*!< GPIO PUPDR: PUPD8 (Bitfield-Mask: 0x03) */
#define GPIO_PUPDR_PUPD8                                                   GPIO_PUPDR_PUPD8_Msk
#define GPIO_PUPDR_PUPD8_0                                                 (0x1U << GPIO_PUPDR_PUPD8_Pos)
#define GPIO_PUPDR_PUPD8_1                                                 (0x2U << GPIO_PUPDR_PUPD8_Pos)
#define GPIO_PUPDR_PUPD7_Pos                                               (14UL)		/*!<GPIO PUPDR: PUPD7 (Bit 14) */
#define GPIO_PUPDR_PUPD7_Msk                                               (0xc000UL)		/*!< GPIO PUPDR: PUPD7 (Bitfield-Mask: 0x03) */
#define GPIO_PUPDR_PUPD7                                                   GPIO_PUPDR_PUPD7_Msk
#define GPIO_PUPDR_PUPD7_0                                                 (0x1U << GPIO_PUPDR_PUPD7_Pos)
#define GPIO_PUPDR_PUPD7_1                                                 (0x2U << GPIO_PUPDR_PUPD7_Pos)
#define GPIO_PUPDR_PUPD6_Pos                                               (12UL)		/*!<GPIO PUPDR: PUPD6 (Bit 12) */
#define GPIO_PUPDR_PUPD6_Msk                                               (0x3000UL)		/*!< GPIO PUPDR: PUPD6 (Bitfield-Mask: 0x03) */
#define GPIO_PUPDR_PUPD6                                                   GPIO_PUPDR_PUPD6_Msk
#define GPIO_PUPDR_PUPD6_0                                                 (0x1U << GPIO_PUPDR_PUPD6_Pos)
#define GPIO_PUPDR_PUPD6_1                                                 (0x2U << GPIO_PUPDR_PUPD6_Pos)
#define GPIO_PUPDR_PUPD5_Pos                                               (10UL)		/*!<GPIO PUPDR: PUPD5 (Bit 10) */
#define GPIO_PUPDR_PUPD5_Msk                                               (0xc00UL)		/*!< GPIO PUPDR: PUPD5 (Bitfield-Mask: 0x03) */
#define GPIO_PUPDR_PUPD5                                                   GPIO_PUPDR_PUPD5_Msk
#define GPIO_PUPDR_PUPD5_0                                                 (0x1U << GPIO_PUPDR_PUPD5_Pos)
#define GPIO_PUPDR_PUPD5_1                                                 (0x2U << GPIO_PUPDR_PUPD5_Pos)
#define GPIO_PUPDR_PUPD4_Pos                                               (8UL)		/*!<GPIO PUPDR: PUPD4 (Bit 8) */
#define GPIO_PUPDR_PUPD4_Msk                                               (0x300UL)		/*!< GPIO PUPDR: PUPD4 (Bitfield-Mask: 0x03) */
#define GPIO_PUPDR_PUPD4                                                   GPIO_PUPDR_PUPD4_Msk
#define GPIO_PUPDR_PUPD4_0                                                 (0x1U << GPIO_PUPDR_PUPD4_Pos)
#define GPIO_PUPDR_PUPD4_1                                                 (0x2U << GPIO_PUPDR_PUPD4_Pos)
#define GPIO_PUPDR_PUPD3_Pos                                               (6UL)		/*!<GPIO PUPDR: PUPD3 (Bit 6) */
#define GPIO_PUPDR_PUPD3_Msk                                               (0xc0UL)		/*!< GPIO PUPDR: PUPD3 (Bitfield-Mask: 0x03) */
#define GPIO_PUPDR_PUPD3                                                   GPIO_PUPDR_PUPD3_Msk
#define GPIO_PUPDR_PUPD3_0                                                 (0x1U << GPIO_PUPDR_PUPD3_Pos)
#define GPIO_PUPDR_PUPD3_1                                                 (0x2U << GPIO_PUPDR_PUPD3_Pos)
#define GPIO_PUPDR_PUPD2_Pos                                               (4UL)		/*!<GPIO PUPDR: PUPD2 (Bit 4) */
#define GPIO_PUPDR_PUPD2_Msk                                               (0x30UL)		/*!< GPIO PUPDR: PUPD2 (Bitfield-Mask: 0x03) */
#define GPIO_PUPDR_PUPD2                                                   GPIO_PUPDR_PUPD2_Msk
#define GPIO_PUPDR_PUPD2_0                                                 (0x1U << GPIO_PUPDR_PUPD2_Pos)
#define GPIO_PUPDR_PUPD2_1                                                 (0x2U << GPIO_PUPDR_PUPD2_Pos)
#define GPIO_PUPDR_PUPD1_Pos                                               (2UL)		/*!<GPIO PUPDR: PUPD1 (Bit 2) */
#define GPIO_PUPDR_PUPD1_Msk                                               (0xcUL)		/*!< GPIO PUPDR: PUPD1 (Bitfield-Mask: 0x03) */
#define GPIO_PUPDR_PUPD1                                                   GPIO_PUPDR_PUPD1_Msk
#define GPIO_PUPDR_PUPD1_0                                                 (0x1U << GPIO_PUPDR_PUPD1_Pos)
#define GPIO_PUPDR_PUPD1_1                                                 (0x2U << GPIO_PUPDR_PUPD1_Pos)
#define GPIO_PUPDR_PUPD0_Pos                                               (0UL)		/*!<GPIO PUPDR: PUPD0 (Bit 0) */
#define GPIO_PUPDR_PUPD0_Msk                                               (0x3UL)		/*!< GPIO PUPDR: PUPD0 (Bitfield-Mask: 0x03) */
#define GPIO_PUPDR_PUPD0                                                   GPIO_PUPDR_PUPD0_Msk
#define GPIO_PUPDR_PUPD0_0                                                 (0x1U << GPIO_PUPDR_PUPD0_Pos)
#define GPIO_PUPDR_PUPD0_1                                                 (0x2U << GPIO_PUPDR_PUPD0_Pos)

/* =====================================================    IDR    ===================================================== */ 
#define GPIO_IDR_ID15_Pos                                                  (15UL)		/*!<GPIO IDR: ID15 (Bit 15) */
#define GPIO_IDR_ID15_Msk                                                  (0x8000UL)		/*!< GPIO IDR: ID15 (Bitfield-Mask: 0x01) */
#define GPIO_IDR_ID15                                                      GPIO_IDR_ID15_Msk
#define GPIO_IDR_ID14_Pos                                                  (14UL)		/*!<GPIO IDR: ID14 (Bit 14) */
#define GPIO_IDR_ID14_Msk                                                  (0x4000UL)		/*!< GPIO IDR: ID14 (Bitfield-Mask: 0x01) */
#define GPIO_IDR_ID14                                                      GPIO_IDR_ID14_Msk
#define GPIO_IDR_ID13_Pos                                                  (13UL)		/*!<GPIO IDR: ID13 (Bit 13) */
#define GPIO_IDR_ID13_Msk                                                  (0x2000UL)		/*!< GPIO IDR: ID13 (Bitfield-Mask: 0x01) */
#define GPIO_IDR_ID13                                                      GPIO_IDR_ID13_Msk
#define GPIO_IDR_ID12_Pos                                                  (12UL)		/*!<GPIO IDR: ID12 (Bit 12) */
#define GPIO_IDR_ID12_Msk                                                  (0x1000UL)		/*!< GPIO IDR: ID12 (Bitfield-Mask: 0x01) */
#define GPIO_IDR_ID12                                                      GPIO_IDR_ID12_Msk
#define GPIO_IDR_ID11_Pos                                                  (11UL)		/*!<GPIO IDR: ID11 (Bit 11) */
#define GPIO_IDR_ID11_Msk                                                  (0x800UL)		/*!< GPIO IDR: ID11 (Bitfield-Mask: 0x01) */
#define GPIO_IDR_ID11                                                      GPIO_IDR_ID11_Msk
#define GPIO_IDR_ID10_Pos                                                  (10UL)		/*!<GPIO IDR: ID10 (Bit 10) */
#define GPIO_IDR_ID10_Msk                                                  (0x400UL)		/*!< GPIO IDR: ID10 (Bitfield-Mask: 0x01) */
#define GPIO_IDR_ID10                                                      GPIO_IDR_ID10_Msk
#define GPIO_IDR_ID9_Pos                                                   (9UL)		/*!<GPIO IDR: ID9 (Bit 9) */
#define GPIO_IDR_ID9_Msk                                                   (0x200UL)		/*!< GPIO IDR: ID9 (Bitfield-Mask: 0x01) */
#define GPIO_IDR_ID9                                                       GPIO_IDR_ID9_Msk
#define GPIO_IDR_ID8_Pos                                                   (8UL)		/*!<GPIO IDR: ID8 (Bit 8) */
#define GPIO_IDR_ID8_Msk                                                   (0x100UL)		/*!< GPIO IDR: ID8 (Bitfield-Mask: 0x01) */
#define GPIO_IDR_ID8                                                       GPIO_IDR_ID8_Msk
#define GPIO_IDR_ID7_Pos                                                   (7UL)		/*!<GPIO IDR: ID7 (Bit 7) */
#define GPIO_IDR_ID7_Msk                                                   (0x80UL)		/*!< GPIO IDR: ID7 (Bitfield-Mask: 0x01) */
#define GPIO_IDR_ID7                                                       GPIO_IDR_ID7_Msk
#define GPIO_IDR_ID6_Pos                                                   (6UL)		/*!<GPIO IDR: ID6 (Bit 6) */
#define GPIO_IDR_ID6_Msk                                                   (0x40UL)		/*!< GPIO IDR: ID6 (Bitfield-Mask: 0x01) */
#define GPIO_IDR_ID6                                                       GPIO_IDR_ID6_Msk
#define GPIO_IDR_ID5_Pos                                                   (5UL)		/*!<GPIO IDR: ID5 (Bit 5) */
#define GPIO_IDR_ID5_Msk                                                   (0x20UL)		/*!< GPIO IDR: ID5 (Bitfield-Mask: 0x01) */
#define GPIO_IDR_ID5                                                       GPIO_IDR_ID5_Msk
#define GPIO_IDR_ID4_Pos                                                   (4UL)		/*!<GPIO IDR: ID4 (Bit 4) */
#define GPIO_IDR_ID4_Msk                                                   (0x10UL)		/*!< GPIO IDR: ID4 (Bitfield-Mask: 0x01) */
#define GPIO_IDR_ID4                                                       GPIO_IDR_ID4_Msk
#define GPIO_IDR_ID3_Pos                                                   (3UL)		/*!<GPIO IDR: ID3 (Bit 3) */
#define GPIO_IDR_ID3_Msk                                                   (0x8UL)		/*!< GPIO IDR: ID3 (Bitfield-Mask: 0x01) */
#define GPIO_IDR_ID3                                                       GPIO_IDR_ID3_Msk
#define GPIO_IDR_ID2_Pos                                                   (2UL)		/*!<GPIO IDR: ID2 (Bit 2) */
#define GPIO_IDR_ID2_Msk                                                   (0x4UL)		/*!< GPIO IDR: ID2 (Bitfield-Mask: 0x01) */
#define GPIO_IDR_ID2                                                       GPIO_IDR_ID2_Msk
#define GPIO_IDR_ID1_Pos                                                   (1UL)		/*!<GPIO IDR: ID1 (Bit 1) */
#define GPIO_IDR_ID1_Msk                                                   (0x2UL)		/*!< GPIO IDR: ID1 (Bitfield-Mask: 0x01) */
#define GPIO_IDR_ID1                                                       GPIO_IDR_ID1_Msk
#define GPIO_IDR_ID0_Pos                                                   (0UL)		/*!<GPIO IDR: ID0 (Bit 0) */
#define GPIO_IDR_ID0_Msk                                                   (0x1UL)		/*!< GPIO IDR: ID0 (Bitfield-Mask: 0x01) */
#define GPIO_IDR_ID0                                                       GPIO_IDR_ID0_Msk

/* =====================================================    ODR    ===================================================== */ 
#define GPIO_ODR_OD15_Pos                                                  (15UL)		/*!<GPIO ODR: OD15 (Bit 15) */
#define GPIO_ODR_OD15_Msk                                                  (0x8000UL)		/*!< GPIO ODR: OD15 (Bitfield-Mask: 0x01) */
#define GPIO_ODR_OD15                                                      GPIO_ODR_OD15_Msk
#define GPIO_ODR_OD14_Pos                                                  (14UL)		/*!<GPIO ODR: OD14 (Bit 14) */
#define GPIO_ODR_OD14_Msk                                                  (0x4000UL)		/*!< GPIO ODR: OD14 (Bitfield-Mask: 0x01) */
#define GPIO_ODR_OD14                                                      GPIO_ODR_OD14_Msk
#define GPIO_ODR_OD13_Pos                                                  (13UL)		/*!<GPIO ODR: OD13 (Bit 13) */
#define GPIO_ODR_OD13_Msk                                                  (0x2000UL)		/*!< GPIO ODR: OD13 (Bitfield-Mask: 0x01) */
#define GPIO_ODR_OD13                                                      GPIO_ODR_OD13_Msk
#define GPIO_ODR_OD12_Pos                                                  (12UL)		/*!<GPIO ODR: OD12 (Bit 12) */
#define GPIO_ODR_OD12_Msk                                                  (0x1000UL)		/*!< GPIO ODR: OD12 (Bitfield-Mask: 0x01) */
#define GPIO_ODR_OD12                                                      GPIO_ODR_OD12_Msk
#define GPIO_ODR_OD11_Pos                                                  (11UL)		/*!<GPIO ODR: OD11 (Bit 11) */
#define GPIO_ODR_OD11_Msk                                                  (0x800UL)		/*!< GPIO ODR: OD11 (Bitfield-Mask: 0x01) */
#define GPIO_ODR_OD11                                                      GPIO_ODR_OD11_Msk
#define GPIO_ODR_OD10_Pos                                                  (10UL)		/*!<GPIO ODR: OD10 (Bit 10) */
#define GPIO_ODR_OD10_Msk                                                  (0x400UL)		/*!< GPIO ODR: OD10 (Bitfield-Mask: 0x01) */
#define GPIO_ODR_OD10                                                      GPIO_ODR_OD10_Msk
#define GPIO_ODR_OD9_Pos                                                   (9UL)		/*!<GPIO ODR: OD9 (Bit 9) */
#define GPIO_ODR_OD9_Msk                                                   (0x200UL)		/*!< GPIO ODR: OD9 (Bitfield-Mask: 0x01) */
#define GPIO_ODR_OD9                                                       GPIO_ODR_OD9_Msk
#define GPIO_ODR_OD8_Pos                                                   (8UL)		/*!<GPIO ODR: OD8 (Bit 8) */
#define GPIO_ODR_OD8_Msk                                                   (0x100UL)		/*!< GPIO ODR: OD8 (Bitfield-Mask: 0x01) */
#define GPIO_ODR_OD8                                                       GPIO_ODR_OD8_Msk
#define GPIO_ODR_OD7_Pos                                                   (7UL)		/*!<GPIO ODR: OD7 (Bit 7) */
#define GPIO_ODR_OD7_Msk                                                   (0x80UL)		/*!< GPIO ODR: OD7 (Bitfield-Mask: 0x01) */
#define GPIO_ODR_OD7                                                       GPIO_ODR_OD7_Msk
#define GPIO_ODR_OD6_Pos                                                   (6UL)		/*!<GPIO ODR: OD6 (Bit 6) */
#define GPIO_ODR_OD6_Msk                                                   (0x40UL)		/*!< GPIO ODR: OD6 (Bitfield-Mask: 0x01) */
#define GPIO_ODR_OD6                                                       GPIO_ODR_OD6_Msk
#define GPIO_ODR_OD5_Pos                                                   (5UL)		/*!<GPIO ODR: OD5 (Bit 5) */
#define GPIO_ODR_OD5_Msk                                                   (0x20UL)		/*!< GPIO ODR: OD5 (Bitfield-Mask: 0x01) */
#define GPIO_ODR_OD5                                                       GPIO_ODR_OD5_Msk
#define GPIO_ODR_OD4_Pos                                                   (4UL)		/*!<GPIO ODR: OD4 (Bit 4) */
#define GPIO_ODR_OD4_Msk                                                   (0x10UL)		/*!< GPIO ODR: OD4 (Bitfield-Mask: 0x01) */
#define GPIO_ODR_OD4                                                       GPIO_ODR_OD4_Msk
#define GPIO_ODR_OD3_Pos                                                   (3UL)		/*!<GPIO ODR: OD3 (Bit 3) */
#define GPIO_ODR_OD3_Msk                                                   (0x8UL)		/*!< GPIO ODR: OD3 (Bitfield-Mask: 0x01) */
#define GPIO_ODR_OD3                                                       GPIO_ODR_OD3_Msk
#define GPIO_ODR_OD2_Pos                                                   (2UL)		/*!<GPIO ODR: OD2 (Bit 2) */
#define GPIO_ODR_OD2_Msk                                                   (0x4UL)		/*!< GPIO ODR: OD2 (Bitfield-Mask: 0x01) */
#define GPIO_ODR_OD2                                                       GPIO_ODR_OD2_Msk
#define GPIO_ODR_OD1_Pos                                                   (1UL)		/*!<GPIO ODR: OD1 (Bit 1) */
#define GPIO_ODR_OD1_Msk                                                   (0x2UL)		/*!< GPIO ODR: OD1 (Bitfield-Mask: 0x01) */
#define GPIO_ODR_OD1                                                       GPIO_ODR_OD1_Msk
#define GPIO_ODR_OD0_Pos                                                   (0UL)		/*!<GPIO ODR: OD0 (Bit 0) */
#define GPIO_ODR_OD0_Msk                                                   (0x1UL)		/*!< GPIO ODR: OD0 (Bitfield-Mask: 0x01) */
#define GPIO_ODR_OD0                                                       GPIO_ODR_OD0_Msk

/* =====================================================    BSRR    ===================================================== */ 
#define GPIO_BSRR_BR15_Pos                                                 (31UL)		/*!<GPIO BSRR: BR15 (Bit 31) */
#define GPIO_BSRR_BR15_Msk                                                 (0x80000000UL)		/*!< GPIO BSRR: BR15 (Bitfield-Mask: 0x01) */
#define GPIO_BSRR_BR15                                                     GPIO_BSRR_BR15_Msk
#define GPIO_BSRR_BR14_Pos                                                 (30UL)		/*!<GPIO BSRR: BR14 (Bit 30) */
#define GPIO_BSRR_BR14_Msk                                                 (0x40000000UL)		/*!< GPIO BSRR: BR14 (Bitfield-Mask: 0x01) */
#define GPIO_BSRR_BR14                                                     GPIO_BSRR_BR14_Msk
#define GPIO_BSRR_BR13_Pos                                                 (29UL)		/*!<GPIO BSRR: BR13 (Bit 29) */
#define GPIO_BSRR_BR13_Msk                                                 (0x20000000UL)		/*!< GPIO BSRR: BR13 (Bitfield-Mask: 0x01) */
#define GPIO_BSRR_BR13                                                     GPIO_BSRR_BR13_Msk
#define GPIO_BSRR_BR12_Pos                                                 (28UL)		/*!<GPIO BSRR: BR12 (Bit 28) */
#define GPIO_BSRR_BR12_Msk                                                 (0x10000000UL)		/*!< GPIO BSRR: BR12 (Bitfield-Mask: 0x01) */
#define GPIO_BSRR_BR12                                                     GPIO_BSRR_BR12_Msk
#define GPIO_BSRR_BR11_Pos                                                 (27UL)		/*!<GPIO BSRR: BR11 (Bit 27) */
#define GPIO_BSRR_BR11_Msk                                                 (0x8000000UL)		/*!< GPIO BSRR: BR11 (Bitfield-Mask: 0x01) */
#define GPIO_BSRR_BR11                                                     GPIO_BSRR_BR11_Msk
#define GPIO_BSRR_BR10_Pos                                                 (26UL)		/*!<GPIO BSRR: BR10 (Bit 26) */
#define GPIO_BSRR_BR10_Msk                                                 (0x4000000UL)		/*!< GPIO BSRR: BR10 (Bitfield-Mask: 0x01) */
#define GPIO_BSRR_BR10                                                     GPIO_BSRR_BR10_Msk
#define GPIO_BSRR_BR9_Pos                                                  (25UL)		/*!<GPIO BSRR: BR9 (Bit 25) */
#define GPIO_BSRR_BR9_Msk                                                  (0x2000000UL)		/*!< GPIO BSRR: BR9 (Bitfield-Mask: 0x01) */
#define GPIO_BSRR_BR9                                                      GPIO_BSRR_BR9_Msk
#define GPIO_BSRR_BR8_Pos                                                  (24UL)		/*!<GPIO BSRR: BR8 (Bit 24) */
#define GPIO_BSRR_BR8_Msk                                                  (0x1000000UL)		/*!< GPIO BSRR: BR8 (Bitfield-Mask: 0x01) */
#define GPIO_BSRR_BR8                                                      GPIO_BSRR_BR8_Msk
#define GPIO_BSRR_BR7_Pos                                                  (23UL)		/*!<GPIO BSRR: BR7 (Bit 23) */
#define GPIO_BSRR_BR7_Msk                                                  (0x800000UL)		/*!< GPIO BSRR: BR7 (Bitfield-Mask: 0x01) */
#define GPIO_BSRR_BR7                                                      GPIO_BSRR_BR7_Msk
#define GPIO_BSRR_BR6_Pos                                                  (22UL)		/*!<GPIO BSRR: BR6 (Bit 22) */
#define GPIO_BSRR_BR6_Msk                                                  (0x400000UL)		/*!< GPIO BSRR: BR6 (Bitfield-Mask: 0x01) */
#define GPIO_BSRR_BR6                                                      GPIO_BSRR_BR6_Msk
#define GPIO_BSRR_BR5_Pos                                                  (21UL)		/*!<GPIO BSRR: BR5 (Bit 21) */
#define GPIO_BSRR_BR5_Msk                                                  (0x200000UL)		/*!< GPIO BSRR: BR5 (Bitfield-Mask: 0x01) */
#define GPIO_BSRR_BR5                                                      GPIO_BSRR_BR5_Msk
#define GPIO_BSRR_BR4_Pos                                                  (20UL)		/*!<GPIO BSRR: BR4 (Bit 20) */
#define GPIO_BSRR_BR4_Msk                                                  (0x100000UL)		/*!< GPIO BSRR: BR4 (Bitfield-Mask: 0x01) */
#define GPIO_BSRR_BR4                                                      GPIO_BSRR_BR4_Msk
#define GPIO_BSRR_BR3_Pos                                                  (19UL)		/*!<GPIO BSRR: BR3 (Bit 19) */
#define GPIO_BSRR_BR3_Msk                                                  (0x80000UL)		/*!< GPIO BSRR: BR3 (Bitfield-Mask: 0x01) */
#define GPIO_BSRR_BR3                                                      GPIO_BSRR_BR3_Msk
#define GPIO_BSRR_BR2_Pos                                                  (18UL)		/*!<GPIO BSRR: BR2 (Bit 18) */
#define GPIO_BSRR_BR2_Msk                                                  (0x40000UL)		/*!< GPIO BSRR: BR2 (Bitfield-Mask: 0x01) */
#define GPIO_BSRR_BR2                                                      GPIO_BSRR_BR2_Msk
#define GPIO_BSRR_BR1_Pos                                                  (17UL)		/*!<GPIO BSRR: BR1 (Bit 17) */
#define GPIO_BSRR_BR1_Msk                                                  (0x20000UL)		/*!< GPIO BSRR: BR1 (Bitfield-Mask: 0x01) */
#define GPIO_BSRR_BR1                                                      GPIO_BSRR_BR1_Msk
#define GPIO_BSRR_BR0_Pos                                                  (16UL)		/*!<GPIO BSRR: BR0 (Bit 16) */
#define GPIO_BSRR_BR0_Msk                                                  (0x10000UL)		/*!< GPIO BSRR: BR0 (Bitfield-Mask: 0x01) */
#define GPIO_BSRR_BR0                                                      GPIO_BSRR_BR0_Msk
#define GPIO_BSRR_BS15_Pos                                                 (15UL)		/*!<GPIO BSRR: BS15 (Bit 15) */
#define GPIO_BSRR_BS15_Msk                                                 (0x8000UL)		/*!< GPIO BSRR: BS15 (Bitfield-Mask: 0x01) */
#define GPIO_BSRR_BS15                                                     GPIO_BSRR_BS15_Msk
#define GPIO_BSRR_BS14_Pos                                                 (14UL)		/*!<GPIO BSRR: BS14 (Bit 14) */
#define GPIO_BSRR_BS14_Msk                                                 (0x4000UL)		/*!< GPIO BSRR: BS14 (Bitfield-Mask: 0x01) */
#define GPIO_BSRR_BS14                                                     GPIO_BSRR_BS14_Msk
#define GPIO_BSRR_BS13_Pos                                                 (13UL)		/*!<GPIO BSRR: BS13 (Bit 13) */
#define GPIO_BSRR_BS13_Msk                                                 (0x2000UL)		/*!< GPIO BSRR: BS13 (Bitfield-Mask: 0x01) */
#define GPIO_BSRR_BS13                                                     GPIO_BSRR_BS13_Msk
#define GPIO_BSRR_BS12_Pos                                                 (12UL)		/*!<GPIO BSRR: BS12 (Bit 12) */
#define GPIO_BSRR_BS12_Msk                                                 (0x1000UL)		/*!< GPIO BSRR: BS12 (Bitfield-Mask: 0x01) */
#define GPIO_BSRR_BS12                                                     GPIO_BSRR_BS12_Msk
#define GPIO_BSRR_BS11_Pos                                                 (11UL)		/*!<GPIO BSRR: BS11 (Bit 11) */
#define GPIO_BSRR_BS11_Msk                                                 (0x800UL)		/*!< GPIO BSRR: BS11 (Bitfield-Mask: 0x01) */
#define GPIO_BSRR_BS11                                                     GPIO_BSRR_BS11_Msk
#define GPIO_BSRR_BS10_Pos                                                 (10UL)		/*!<GPIO BSRR: BS10 (Bit 10) */
#define GPIO_BSRR_BS10_Msk                                                 (0x400UL)		/*!< GPIO BSRR: BS10 (Bitfield-Mask: 0x01) */
#define GPIO_BSRR_BS10                                                     GPIO_BSRR_BS10_Msk
#define GPIO_BSRR_BS9_Pos                                                  (9UL)		/*!<GPIO BSRR: BS9 (Bit 9) */
#define GPIO_BSRR_BS9_Msk                                                  (0x200UL)		/*!< GPIO BSRR: BS9 (Bitfield-Mask: 0x01) */
#define GPIO_BSRR_BS9                                                      GPIO_BSRR_BS9_Msk
#define GPIO_BSRR_BS8_Pos                                                  (8UL)		/*!<GPIO BSRR: BS8 (Bit 8) */
#define GPIO_BSRR_BS8_Msk                                                  (0x100UL)		/*!< GPIO BSRR: BS8 (Bitfield-Mask: 0x01) */
#define GPIO_BSRR_BS8                                                      GPIO_BSRR_BS8_Msk
#define GPIO_BSRR_BS7_Pos                                                  (7UL)		/*!<GPIO BSRR: BS7 (Bit 7) */
#define GPIO_BSRR_BS7_Msk                                                  (0x80UL)		/*!< GPIO BSRR: BS7 (Bitfield-Mask: 0x01) */
#define GPIO_BSRR_BS7                                                      GPIO_BSRR_BS7_Msk
#define GPIO_BSRR_BS6_Pos                                                  (6UL)		/*!<GPIO BSRR: BS6 (Bit 6) */
#define GPIO_BSRR_BS6_Msk                                                  (0x40UL)		/*!< GPIO BSRR: BS6 (Bitfield-Mask: 0x01) */
#define GPIO_BSRR_BS6                                                      GPIO_BSRR_BS6_Msk
#define GPIO_BSRR_BS5_Pos                                                  (5UL)		/*!<GPIO BSRR: BS5 (Bit 5) */
#define GPIO_BSRR_BS5_Msk                                                  (0x20UL)		/*!< GPIO BSRR: BS5 (Bitfield-Mask: 0x01) */
#define GPIO_BSRR_BS5                                                      GPIO_BSRR_BS5_Msk
#define GPIO_BSRR_BS4_Pos                                                  (4UL)		/*!<GPIO BSRR: BS4 (Bit 4) */
#define GPIO_BSRR_BS4_Msk                                                  (0x10UL)		/*!< GPIO BSRR: BS4 (Bitfield-Mask: 0x01) */
#define GPIO_BSRR_BS4                                                      GPIO_BSRR_BS4_Msk
#define GPIO_BSRR_BS3_Pos                                                  (3UL)		/*!<GPIO BSRR: BS3 (Bit 3) */
#define GPIO_BSRR_BS3_Msk                                                  (0x8UL)		/*!< GPIO BSRR: BS3 (Bitfield-Mask: 0x01) */
#define GPIO_BSRR_BS3                                                      GPIO_BSRR_BS3_Msk
#define GPIO_BSRR_BS2_Pos                                                  (2UL)		/*!<GPIO BSRR: BS2 (Bit 2) */
#define GPIO_BSRR_BS2_Msk                                                  (0x4UL)		/*!< GPIO BSRR: BS2 (Bitfield-Mask: 0x01) */
#define GPIO_BSRR_BS2                                                      GPIO_BSRR_BS2_Msk
#define GPIO_BSRR_BS1_Pos                                                  (1UL)		/*!<GPIO BSRR: BS1 (Bit 1) */
#define GPIO_BSRR_BS1_Msk                                                  (0x2UL)		/*!< GPIO BSRR: BS1 (Bitfield-Mask: 0x01) */
#define GPIO_BSRR_BS1                                                      GPIO_BSRR_BS1_Msk
#define GPIO_BSRR_BS0_Pos                                                  (0UL)		/*!<GPIO BSRR: BS0 (Bit 0) */
#define GPIO_BSRR_BS0_Msk                                                  (0x1UL)		/*!< GPIO BSRR: BS0 (Bitfield-Mask: 0x01) */
#define GPIO_BSRR_BS0                                                      GPIO_BSRR_BS0_Msk

/* =====================================================    LCKR    ===================================================== */ 
#define GPIO_LCKR_LCKK_Pos                                                 (16UL)		/*!<GPIO LCKR: LCKK (Bit 16) */
#define GPIO_LCKR_LCKK_Msk                                                 (0x10000UL)		/*!< GPIO LCKR: LCKK (Bitfield-Mask: 0x01) */
#define GPIO_LCKR_LCKK                                                     GPIO_LCKR_LCKK_Msk
#define GPIO_LCKR_LCK15_Pos                                                (15UL)		/*!<GPIO LCKR: LCK15 (Bit 15) */
#define GPIO_LCKR_LCK15_Msk                                                (0x8000UL)		/*!< GPIO LCKR: LCK15 (Bitfield-Mask: 0x01) */
#define GPIO_LCKR_LCK15                                                    GPIO_LCKR_LCK15_Msk
#define GPIO_LCKR_LCK14_Pos                                                (14UL)		/*!<GPIO LCKR: LCK14 (Bit 14) */
#define GPIO_LCKR_LCK14_Msk                                                (0x4000UL)		/*!< GPIO LCKR: LCK14 (Bitfield-Mask: 0x01) */
#define GPIO_LCKR_LCK14                                                    GPIO_LCKR_LCK14_Msk
#define GPIO_LCKR_LCK13_Pos                                                (13UL)		/*!<GPIO LCKR: LCK13 (Bit 13) */
#define GPIO_LCKR_LCK13_Msk                                                (0x2000UL)		/*!< GPIO LCKR: LCK13 (Bitfield-Mask: 0x01) */
#define GPIO_LCKR_LCK13                                                    GPIO_LCKR_LCK13_Msk
#define GPIO_LCKR_LCK12_Pos                                                (12UL)		/*!<GPIO LCKR: LCK12 (Bit 12) */
#define GPIO_LCKR_LCK12_Msk                                                (0x1000UL)		/*!< GPIO LCKR: LCK12 (Bitfield-Mask: 0x01) */
#define GPIO_LCKR_LCK12                                                    GPIO_LCKR_LCK12_Msk
#define GPIO_LCKR_LCK11_Pos                                                (11UL)		/*!<GPIO LCKR: LCK11 (Bit 11) */
#define GPIO_LCKR_LCK11_Msk                                                (0x800UL)		/*!< GPIO LCKR: LCK11 (Bitfield-Mask: 0x01) */
#define GPIO_LCKR_LCK11                                                    GPIO_LCKR_LCK11_Msk
#define GPIO_LCKR_LCK10_Pos                                                (10UL)		/*!<GPIO LCKR: LCK10 (Bit 10) */
#define GPIO_LCKR_LCK10_Msk                                                (0x400UL)		/*!< GPIO LCKR: LCK10 (Bitfield-Mask: 0x01) */
#define GPIO_LCKR_LCK10                                                    GPIO_LCKR_LCK10_Msk
#define GPIO_LCKR_LCK9_Pos                                                 (9UL)		/*!<GPIO LCKR: LCK9 (Bit 9) */
#define GPIO_LCKR_LCK9_Msk                                                 (0x200UL)		/*!< GPIO LCKR: LCK9 (Bitfield-Mask: 0x01) */
#define GPIO_LCKR_LCK9                                                     GPIO_LCKR_LCK9_Msk
#define GPIO_LCKR_LCK8_Pos                                                 (8UL)		/*!<GPIO LCKR: LCK8 (Bit 8) */
#define GPIO_LCKR_LCK8_Msk                                                 (0x100UL)		/*!< GPIO LCKR: LCK8 (Bitfield-Mask: 0x01) */
#define GPIO_LCKR_LCK8                                                     GPIO_LCKR_LCK8_Msk
#define GPIO_LCKR_LCK7_Pos                                                 (7UL)		/*!<GPIO LCKR: LCK7 (Bit 7) */
#define GPIO_LCKR_LCK7_Msk                                                 (0x80UL)		/*!< GPIO LCKR: LCK7 (Bitfield-Mask: 0x01) */
#define GPIO_LCKR_LCK7                                                     GPIO_LCKR_LCK7_Msk
#define GPIO_LCKR_LCK6_Pos                                                 (6UL)		/*!<GPIO LCKR: LCK6 (Bit 6) */
#define GPIO_LCKR_LCK6_Msk                                                 (0x40UL)		/*!< GPIO LCKR: LCK6 (Bitfield-Mask: 0x01) */
#define GPIO_LCKR_LCK6                                                     GPIO_LCKR_LCK6_Msk
#define GPIO_LCKR_LCK5_Pos                                                 (5UL)		/*!<GPIO LCKR: LCK5 (Bit 5) */
#define GPIO_LCKR_LCK5_Msk                                                 (0x20UL)		/*!< GPIO LCKR: LCK5 (Bitfield-Mask: 0x01) */
#define GPIO_LCKR_LCK5                                                     GPIO_LCKR_LCK5_Msk
#define GPIO_LCKR_LCK4_Pos                                                 (4UL)		/*!<GPIO LCKR: LCK4 (Bit 4) */
#define GPIO_LCKR_LCK4_Msk                                                 (0x10UL)		/*!< GPIO LCKR: LCK4 (Bitfield-Mask: 0x01) */
#define GPIO_LCKR_LCK4                                                     GPIO_LCKR_LCK4_Msk
#define GPIO_LCKR_LCK3_Pos                                                 (3UL)		/*!<GPIO LCKR: LCK3 (Bit 3) */
#define GPIO_LCKR_LCK3_Msk                                                 (0x8UL)		/*!< GPIO LCKR: LCK3 (Bitfield-Mask: 0x01) */
#define GPIO_LCKR_LCK3                                                     GPIO_LCKR_LCK3_Msk
#define GPIO_LCKR_LCK2_Pos                                                 (2UL)		/*!<GPIO LCKR: LCK2 (Bit 2) */
#define GPIO_LCKR_LCK2_Msk                                                 (0x4UL)		/*!< GPIO LCKR: LCK2 (Bitfield-Mask: 0x01) */
#define GPIO_LCKR_LCK2                                                     GPIO_LCKR_LCK2_Msk
#define GPIO_LCKR_LCK1_Pos                                                 (1UL)		/*!<GPIO LCKR: LCK1 (Bit 1) */
#define GPIO_LCKR_LCK1_Msk                                                 (0x2UL)		/*!< GPIO LCKR: LCK1 (Bitfield-Mask: 0x01) */
#define GPIO_LCKR_LCK1                                                     GPIO_LCKR_LCK1_Msk
#define GPIO_LCKR_LCK0_Pos                                                 (0UL)		/*!<GPIO LCKR: LCK0 (Bit 0) */
#define GPIO_LCKR_LCK0_Msk                                                 (0x1UL)		/*!< GPIO LCKR: LCK0 (Bitfield-Mask: 0x01) */
#define GPIO_LCKR_LCK0                                                     GPIO_LCKR_LCK0_Msk

/* =====================================================    AFRL    ===================================================== */ 
#define GPIO_AFRL_AFSEL7_Pos                                               (28UL)		/*!<GPIO AFRL: AFSEL7 (Bit 28) */
#define GPIO_AFRL_AFSEL7_Msk                                               (0xf0000000UL)		/*!< GPIO AFRL: AFSEL7 (Bitfield-Mask: 0x0f) */
#define GPIO_AFRL_AFSEL7                                                   GPIO_AFRL_AFSEL7_Msk
#define GPIO_AFRL_AFSEL7_0                                                 (0x1U << GPIO_AFRL_AFSEL7_Pos)
#define GPIO_AFRL_AFSEL7_1                                                 (0x2U << GPIO_AFRL_AFSEL7_Pos)
#define GPIO_AFRL_AFSEL7_2                                                 (0x4U << GPIO_AFRL_AFSEL7_Pos)
#define GPIO_AFRL_AFSEL7_3                                                 (0x8U << GPIO_AFRL_AFSEL7_Pos)
#define GPIO_AFRL_AFSEL6_Pos                                               (24UL)		/*!<GPIO AFRL: AFSEL6 (Bit 24) */
#define GPIO_AFRL_AFSEL6_Msk                                               (0xf000000UL)		/*!< GPIO AFRL: AFSEL6 (Bitfield-Mask: 0x0f) */
#define GPIO_AFRL_AFSEL6                                                   GPIO_AFRL_AFSEL6_Msk
#define GPIO_AFRL_AFSEL6_0                                                 (0x1U << GPIO_AFRL_AFSEL6_Pos)
#define GPIO_AFRL_AFSEL6_1                                                 (0x2U << GPIO_AFRL_AFSEL6_Pos)
#define GPIO_AFRL_AFSEL6_2                                                 (0x4U << GPIO_AFRL_AFSEL6_Pos)
#define GPIO_AFRL_AFSEL6_3                                                 (0x8U << GPIO_AFRL_AFSEL6_Pos)
#define GPIO_AFRL_AFSEL5_Pos                                               (20UL)		/*!<GPIO AFRL: AFSEL5 (Bit 20) */
#define GPIO_AFRL_AFSEL5_Msk                                               (0xf00000UL)		/*!< GPIO AFRL: AFSEL5 (Bitfield-Mask: 0x0f) */
#define GPIO_AFRL_AFSEL5                                                   GPIO_AFRL_AFSEL5_Msk
#define GPIO_AFRL_AFSEL5_0                                                 (0x1U << GPIO_AFRL_AFSEL5_Pos)
#define GPIO_AFRL_AFSEL5_1                                                 (0x2U << GPIO_AFRL_AFSEL5_Pos)
#define GPIO_AFRL_AFSEL5_2                                                 (0x4U << GPIO_AFRL_AFSEL5_Pos)
#define GPIO_AFRL_AFSEL5_3                                                 (0x8U << GPIO_AFRL_AFSEL5_Pos)
#define GPIO_AFRL_AFSEL4_Pos                                               (16UL)		/*!<GPIO AFRL: AFSEL4 (Bit 16) */
#define GPIO_AFRL_AFSEL4_Msk                                               (0xf0000UL)		/*!< GPIO AFRL: AFSEL4 (Bitfield-Mask: 0x0f) */
#define GPIO_AFRL_AFSEL4                                                   GPIO_AFRL_AFSEL4_Msk
#define GPIO_AFRL_AFSEL4_0                                                 (0x1U << GPIO_AFRL_AFSEL4_Pos)
#define GPIO_AFRL_AFSEL4_1                                                 (0x2U << GPIO_AFRL_AFSEL4_Pos)
#define GPIO_AFRL_AFSEL4_2                                                 (0x4U << GPIO_AFRL_AFSEL4_Pos)
#define GPIO_AFRL_AFSEL4_3                                                 (0x8U << GPIO_AFRL_AFSEL4_Pos)
#define GPIO_AFRL_AFSEL3_Pos                                               (12UL)		/*!<GPIO AFRL: AFSEL3 (Bit 12) */
#define GPIO_AFRL_AFSEL3_Msk                                               (0xf000UL)		/*!< GPIO AFRL: AFSEL3 (Bitfield-Mask: 0x0f) */
#define GPIO_AFRL_AFSEL3                                                   GPIO_AFRL_AFSEL3_Msk
#define GPIO_AFRL_AFSEL3_0                                                 (0x1U << GPIO_AFRL_AFSEL3_Pos)
#define GPIO_AFRL_AFSEL3_1                                                 (0x2U << GPIO_AFRL_AFSEL3_Pos)
#define GPIO_AFRL_AFSEL3_2                                                 (0x4U << GPIO_AFRL_AFSEL3_Pos)
#define GPIO_AFRL_AFSEL3_3                                                 (0x8U << GPIO_AFRL_AFSEL3_Pos)
#define GPIO_AFRL_AFSEL2_Pos                                               (8UL)		/*!<GPIO AFRL: AFSEL2 (Bit 8) */
#define GPIO_AFRL_AFSEL2_Msk                                               (0xf00UL)		/*!< GPIO AFRL: AFSEL2 (Bitfield-Mask: 0x0f) */
#define GPIO_AFRL_AFSEL2                                                   GPIO_AFRL_AFSEL2_Msk
#define GPIO_AFRL_AFSEL2_0                                                 (0x1U << GPIO_AFRL_AFSEL2_Pos)
#define GPIO_AFRL_AFSEL2_1                                                 (0x2U << GPIO_AFRL_AFSEL2_Pos)
#define GPIO_AFRL_AFSEL2_2                                                 (0x4U << GPIO_AFRL_AFSEL2_Pos)
#define GPIO_AFRL_AFSEL2_3                                                 (0x8U << GPIO_AFRL_AFSEL2_Pos)
#define GPIO_AFRL_AFSEL1_Pos                                               (4UL)		/*!<GPIO AFRL: AFSEL1 (Bit 4) */
#define GPIO_AFRL_AFSEL1_Msk                                               (0xf0UL)		/*!< GPIO AFRL: AFSEL1 (Bitfield-Mask: 0x0f) */
#define GPIO_AFRL_AFSEL1                                                   GPIO_AFRL_AFSEL1_Msk
#define GPIO_AFRL_AFSEL1_0                                                 (0x1U << GPIO_AFRL_AFSEL1_Pos)
#define GPIO_AFRL_AFSEL1_1                                                 (0x2U << GPIO_AFRL_AFSEL1_Pos)
#define GPIO_AFRL_AFSEL1_2                                                 (0x4U << GPIO_AFRL_AFSEL1_Pos)
#define GPIO_AFRL_AFSEL1_3                                                 (0x8U << GPIO_AFRL_AFSEL1_Pos)
#define GPIO_AFRL_AFSEL0_Pos                                               (0UL)		/*!<GPIO AFRL: AFSEL0 (Bit 0) */
#define GPIO_AFRL_AFSEL0_Msk                                               (0xfUL)		/*!< GPIO AFRL: AFSEL0 (Bitfield-Mask: 0x0f) */
#define GPIO_AFRL_AFSEL0                                                   GPIO_AFRL_AFSEL0_Msk
#define GPIO_AFRL_AFSEL0_0                                                 (0x1U << GPIO_AFRL_AFSEL0_Pos)
#define GPIO_AFRL_AFSEL0_1                                                 (0x2U << GPIO_AFRL_AFSEL0_Pos)
#define GPIO_AFRL_AFSEL0_2                                                 (0x4U << GPIO_AFRL_AFSEL0_Pos)
#define GPIO_AFRL_AFSEL0_3                                                 (0x8U << GPIO_AFRL_AFSEL0_Pos)

/* =====================================================    AFRH    ===================================================== */ 
#define GPIO_AFRH_AFSEL15_Pos                                              (28UL)		/*!<GPIO AFRH: AFSEL15 (Bit 28) */
#define GPIO_AFRH_AFSEL15_Msk                                              (0xf0000000UL)		/*!< GPIO AFRH: AFSEL15 (Bitfield-Mask: 0x0f) */
#define GPIO_AFRH_AFSEL15                                                  GPIO_AFRH_AFSEL15_Msk
#define GPIO_AFRH_AFSEL15_0                                                (0x1U << GPIO_AFRH_AFSEL15_Pos)
#define GPIO_AFRH_AFSEL15_1                                                (0x2U << GPIO_AFRH_AFSEL15_Pos)
#define GPIO_AFRH_AFSEL15_2                                                (0x4U << GPIO_AFRH_AFSEL15_Pos)
#define GPIO_AFRH_AFSEL15_3                                                (0x8U << GPIO_AFRH_AFSEL15_Pos)
#define GPIO_AFRH_AFSEL14_Pos                                              (24UL)		/*!<GPIO AFRH: AFSEL14 (Bit 24) */
#define GPIO_AFRH_AFSEL14_Msk                                              (0xf000000UL)		/*!< GPIO AFRH: AFSEL14 (Bitfield-Mask: 0x0f) */
#define GPIO_AFRH_AFSEL14                                                  GPIO_AFRH_AFSEL14_Msk
#define GPIO_AFRH_AFSEL14_0                                                (0x1U << GPIO_AFRH_AFSEL14_Pos)
#define GPIO_AFRH_AFSEL14_1                                                (0x2U << GPIO_AFRH_AFSEL14_Pos)
#define GPIO_AFRH_AFSEL14_2                                                (0x4U << GPIO_AFRH_AFSEL14_Pos)
#define GPIO_AFRH_AFSEL14_3                                                (0x8U << GPIO_AFRH_AFSEL14_Pos)
#define GPIO_AFRH_AFSEL13_Pos                                              (20UL)		/*!<GPIO AFRH: AFSEL13 (Bit 20) */
#define GPIO_AFRH_AFSEL13_Msk                                              (0xf00000UL)		/*!< GPIO AFRH: AFSEL13 (Bitfield-Mask: 0x0f) */
#define GPIO_AFRH_AFSEL13                                                  GPIO_AFRH_AFSEL13_Msk
#define GPIO_AFRH_AFSEL13_0                                                (0x1U << GPIO_AFRH_AFSEL13_Pos)
#define GPIO_AFRH_AFSEL13_1                                                (0x2U << GPIO_AFRH_AFSEL13_Pos)
#define GPIO_AFRH_AFSEL13_2                                                (0x4U << GPIO_AFRH_AFSEL13_Pos)
#define GPIO_AFRH_AFSEL13_3                                                (0x8U << GPIO_AFRH_AFSEL13_Pos)
#define GPIO_AFRH_AFSEL12_Pos                                              (16UL)		/*!<GPIO AFRH: AFSEL12 (Bit 16) */
#define GPIO_AFRH_AFSEL12_Msk                                              (0xf0000UL)		/*!< GPIO AFRH: AFSEL12 (Bitfield-Mask: 0x0f) */
#define GPIO_AFRH_AFSEL12                                                  GPIO_AFRH_AFSEL12_Msk
#define GPIO_AFRH_AFSEL12_0                                                (0x1U << GPIO_AFRH_AFSEL12_Pos)
#define GPIO_AFRH_AFSEL12_1                                                (0x2U << GPIO_AFRH_AFSEL12_Pos)
#define GPIO_AFRH_AFSEL12_2                                                (0x4U << GPIO_AFRH_AFSEL12_Pos)
#define GPIO_AFRH_AFSEL12_3                                                (0x8U << GPIO_AFRH_AFSEL12_Pos)
#define GPIO_AFRH_AFSEL11_Pos                                              (12UL)		/*!<GPIO AFRH: AFSEL11 (Bit 12) */
#define GPIO_AFRH_AFSEL11_Msk                                              (0xf000UL)		/*!< GPIO AFRH: AFSEL11 (Bitfield-Mask: 0x0f) */
#define GPIO_AFRH_AFSEL11                                                  GPIO_AFRH_AFSEL11_Msk
#define GPIO_AFRH_AFSEL11_0                                                (0x1U << GPIO_AFRH_AFSEL11_Pos)
#define GPIO_AFRH_AFSEL11_1                                                (0x2U << GPIO_AFRH_AFSEL11_Pos)
#define GPIO_AFRH_AFSEL11_2                                                (0x4U << GPIO_AFRH_AFSEL11_Pos)
#define GPIO_AFRH_AFSEL11_3                                                (0x8U << GPIO_AFRH_AFSEL11_Pos)
#define GPIO_AFRH_AFSEL10_Pos                                              (8UL)		/*!<GPIO AFRH: AFSEL10 (Bit 8) */
#define GPIO_AFRH_AFSEL10_Msk                                              (0xf00UL)		/*!< GPIO AFRH: AFSEL10 (Bitfield-Mask: 0x0f) */
#define GPIO_AFRH_AFSEL10                                                  GPIO_AFRH_AFSEL10_Msk
#define GPIO_AFRH_AFSEL10_0                                                (0x1U << GPIO_AFRH_AFSEL10_Pos)
#define GPIO_AFRH_AFSEL10_1                                                (0x2U << GPIO_AFRH_AFSEL10_Pos)
#define GPIO_AFRH_AFSEL10_2                                                (0x4U << GPIO_AFRH_AFSEL10_Pos)
#define GPIO_AFRH_AFSEL10_3                                                (0x8U << GPIO_AFRH_AFSEL10_Pos)
#define GPIO_AFRH_AFSEL9_Pos                                               (4UL)		/*!<GPIO AFRH: AFSEL9 (Bit 4) */
#define GPIO_AFRH_AFSEL9_Msk                                               (0xf0UL)		/*!< GPIO AFRH: AFSEL9 (Bitfield-Mask: 0x0f) */
#define GPIO_AFRH_AFSEL9                                                   GPIO_AFRH_AFSEL9_Msk
#define GPIO_AFRH_AFSEL9_0                                                 (0x1U << GPIO_AFRH_AFSEL9_Pos)
#define GPIO_AFRH_AFSEL9_1                                                 (0x2U << GPIO_AFRH_AFSEL9_Pos)
#define GPIO_AFRH_AFSEL9_2                                                 (0x4U << GPIO_AFRH_AFSEL9_Pos)
#define GPIO_AFRH_AFSEL9_3                                                 (0x8U << GPIO_AFRH_AFSEL9_Pos)
#define GPIO_AFRH_AFSEL8_Pos                                               (0UL)		/*!<GPIO AFRH: AFSEL8 (Bit 0) */
#define GPIO_AFRH_AFSEL8_Msk                                               (0xfUL)		/*!< GPIO AFRH: AFSEL8 (Bitfield-Mask: 0x0f) */
#define GPIO_AFRH_AFSEL8                                                   GPIO_AFRH_AFSEL8_Msk
#define GPIO_AFRH_AFSEL8_0                                                 (0x1U << GPIO_AFRH_AFSEL8_Pos)
#define GPIO_AFRH_AFSEL8_1                                                 (0x2U << GPIO_AFRH_AFSEL8_Pos)
#define GPIO_AFRH_AFSEL8_2                                                 (0x4U << GPIO_AFRH_AFSEL8_Pos)
#define GPIO_AFRH_AFSEL8_3                                                 (0x8U << GPIO_AFRH_AFSEL8_Pos)

/* =====================================================    BRR    ===================================================== */ 
#define GPIO_BRR_BR15_Pos                                                  (15UL)		/*!<GPIO BRR: BR15 (Bit 15) */
#define GPIO_BRR_BR15_Msk                                                  (0x8000UL)		/*!< GPIO BRR: BR15 (Bitfield-Mask: 0x01) */
#define GPIO_BRR_BR15                                                      GPIO_BRR_BR15_Msk
#define GPIO_BRR_BR14_Pos                                                  (14UL)		/*!<GPIO BRR: BR14 (Bit 14) */
#define GPIO_BRR_BR14_Msk                                                  (0x4000UL)		/*!< GPIO BRR: BR14 (Bitfield-Mask: 0x01) */
#define GPIO_BRR_BR14                                                      GPIO_BRR_BR14_Msk
#define GPIO_BRR_BR13_Pos                                                  (13UL)		/*!<GPIO BRR: BR13 (Bit 13) */
#define GPIO_BRR_BR13_Msk                                                  (0x2000UL)		/*!< GPIO BRR: BR13 (Bitfield-Mask: 0x01) */
#define GPIO_BRR_BR13                                                      GPIO_BRR_BR13_Msk
#define GPIO_BRR_BR12_Pos                                                  (12UL)		/*!<GPIO BRR: BR12 (Bit 12) */
#define GPIO_BRR_BR12_Msk                                                  (0x1000UL)		/*!< GPIO BRR: BR12 (Bitfield-Mask: 0x01) */
#define GPIO_BRR_BR12                                                      GPIO_BRR_BR12_Msk
#define GPIO_BRR_BR11_Pos                                                  (11UL)		/*!<GPIO BRR: BR11 (Bit 11) */
#define GPIO_BRR_BR11_Msk                                                  (0x800UL)		/*!< GPIO BRR: BR11 (Bitfield-Mask: 0x01) */
#define GPIO_BRR_BR11                                                      GPIO_BRR_BR11_Msk
#define GPIO_BRR_BR10_Pos                                                  (10UL)		/*!<GPIO BRR: BR10 (Bit 10) */
#define GPIO_BRR_BR10_Msk                                                  (0x400UL)		/*!< GPIO BRR: BR10 (Bitfield-Mask: 0x01) */
#define GPIO_BRR_BR10                                                      GPIO_BRR_BR10_Msk
#define GPIO_BRR_BR9_Pos                                                   (9UL)		/*!<GPIO BRR: BR9 (Bit 9) */
#define GPIO_BRR_BR9_Msk                                                   (0x200UL)		/*!< GPIO BRR: BR9 (Bitfield-Mask: 0x01) */
#define GPIO_BRR_BR9                                                       GPIO_BRR_BR9_Msk
#define GPIO_BRR_BR8_Pos                                                   (8UL)		/*!<GPIO BRR: BR8 (Bit 8) */
#define GPIO_BRR_BR8_Msk                                                   (0x100UL)		/*!< GPIO BRR: BR8 (Bitfield-Mask: 0x01) */
#define GPIO_BRR_BR8                                                       GPIO_BRR_BR8_Msk
#define GPIO_BRR_BR7_Pos                                                   (7UL)		/*!<GPIO BRR: BR7 (Bit 7) */
#define GPIO_BRR_BR7_Msk                                                   (0x80UL)		/*!< GPIO BRR: BR7 (Bitfield-Mask: 0x01) */
#define GPIO_BRR_BR7                                                       GPIO_BRR_BR7_Msk
#define GPIO_BRR_BR6_Pos                                                   (6UL)		/*!<GPIO BRR: BR6 (Bit 6) */
#define GPIO_BRR_BR6_Msk                                                   (0x40UL)		/*!< GPIO BRR: BR6 (Bitfield-Mask: 0x01) */
#define GPIO_BRR_BR6                                                       GPIO_BRR_BR6_Msk
#define GPIO_BRR_BR5_Pos                                                   (5UL)		/*!<GPIO BRR: BR5 (Bit 5) */
#define GPIO_BRR_BR5_Msk                                                   (0x20UL)		/*!< GPIO BRR: BR5 (Bitfield-Mask: 0x01) */
#define GPIO_BRR_BR5                                                       GPIO_BRR_BR5_Msk
#define GPIO_BRR_BR4_Pos                                                   (4UL)		/*!<GPIO BRR: BR4 (Bit 4) */
#define GPIO_BRR_BR4_Msk                                                   (0x10UL)		/*!< GPIO BRR: BR4 (Bitfield-Mask: 0x01) */
#define GPIO_BRR_BR4                                                       GPIO_BRR_BR4_Msk
#define GPIO_BRR_BR3_Pos                                                   (3UL)		/*!<GPIO BRR: BR3 (Bit 3) */
#define GPIO_BRR_BR3_Msk                                                   (0x8UL)		/*!< GPIO BRR: BR3 (Bitfield-Mask: 0x01) */
#define GPIO_BRR_BR3                                                       GPIO_BRR_BR3_Msk
#define GPIO_BRR_BR2_Pos                                                   (2UL)		/*!<GPIO BRR: BR2 (Bit 2) */
#define GPIO_BRR_BR2_Msk                                                   (0x4UL)		/*!< GPIO BRR: BR2 (Bitfield-Mask: 0x01) */
#define GPIO_BRR_BR2                                                       GPIO_BRR_BR2_Msk
#define GPIO_BRR_BR1_Pos                                                   (1UL)		/*!<GPIO BRR: BR1 (Bit 1) */
#define GPIO_BRR_BR1_Msk                                                   (0x2UL)		/*!< GPIO BRR: BR1 (Bitfield-Mask: 0x01) */
#define GPIO_BRR_BR1                                                       GPIO_BRR_BR1_Msk
#define GPIO_BRR_BR0_Pos                                                   (0UL)		/*!<GPIO BRR: BR0 (Bit 0) */
#define GPIO_BRR_BR0_Msk                                                   (0x1UL)		/*!< GPIO BRR: BR0 (Bitfield-Mask: 0x01) */
#define GPIO_BRR_BR0                                                       GPIO_BRR_BR0_Msk
  

/* =========================================================================================================================== */ 
/*=====================                                       TIM                                       ===================== */ 
/* =========================================================================================================================== */ 

/* =====================================================    CR1    ===================================================== */ 
#define TIM_CR1_UIFREMAP_Pos                                               (11UL)		/*!<TIM CR1: UIFREMAP (Bit 11) */
#define TIM_CR1_UIFREMAP_Msk                                               (0x800UL)		/*!< TIM CR1: UIFREMAP (Bitfield-Mask: 0x01) */
#define TIM_CR1_UIFREMAP                                                   TIM_CR1_UIFREMAP_Msk
#define TIM_CR1_CKD_Pos                                                    (8UL)		/*!<TIM CR1: CKD (Bit 8) */
#define TIM_CR1_CKD_Msk                                                    (0x300UL)		/*!< TIM CR1: CKD (Bitfield-Mask: 0x03) */
#define TIM_CR1_CKD                                                        TIM_CR1_CKD_Msk
#define TIM_CR1_CKD_0                                                      (0x1U << TIM_CR1_CKD_Pos)
#define TIM_CR1_CKD_1                                                      (0x2U << TIM_CR1_CKD_Pos)
#define TIM_CR1_ARPE_Pos                                                   (7UL)		/*!<TIM CR1: ARPE (Bit 7) */
#define TIM_CR1_ARPE_Msk                                                   (0x80UL)		/*!< TIM CR1: ARPE (Bitfield-Mask: 0x01) */
#define TIM_CR1_ARPE                                                       TIM_CR1_ARPE_Msk
#define TIM_CR1_CMS_Pos                                                    (5UL)		/*!<TIM CR1: CMS (Bit 5) */
#define TIM_CR1_CMS_Msk                                                    (0x60UL)		/*!< TIM CR1: CMS (Bitfield-Mask: 0x03) */
#define TIM_CR1_CMS                                                        TIM_CR1_CMS_Msk
#define TIM_CR1_CMS_0                                                      (0x1U << TIM_CR1_CMS_Pos)
#define TIM_CR1_CMS_1                                                      (0x2U << TIM_CR1_CMS_Pos)
#define TIM_CR1_DIR_Pos                                                    (4UL)		/*!<TIM CR1: DIR (Bit 4) */
#define TIM_CR1_DIR_Msk                                                    (0x10UL)		/*!< TIM CR1: DIR (Bitfield-Mask: 0x01) */
#define TIM_CR1_DIR                                                        TIM_CR1_DIR_Msk
#define TIM_CR1_OPM_Pos                                                    (3UL)		/*!<TIM CR1: OPM (Bit 3) */
#define TIM_CR1_OPM_Msk                                                    (0x8UL)		/*!< TIM CR1: OPM (Bitfield-Mask: 0x01) */
#define TIM_CR1_OPM                                                        TIM_CR1_OPM_Msk
#define TIM_CR1_URS_Pos                                                    (2UL)		/*!<TIM CR1: URS (Bit 2) */
#define TIM_CR1_URS_Msk                                                    (0x4UL)		/*!< TIM CR1: URS (Bitfield-Mask: 0x01) */
#define TIM_CR1_URS                                                        TIM_CR1_URS_Msk
#define TIM_CR1_UDIS_Pos                                                   (1UL)		/*!<TIM CR1: UDIS (Bit 1) */
#define TIM_CR1_UDIS_Msk                                                   (0x2UL)		/*!< TIM CR1: UDIS (Bitfield-Mask: 0x01) */
#define TIM_CR1_UDIS                                                       TIM_CR1_UDIS_Msk
#define TIM_CR1_CEN_Pos                                                    (0UL)		/*!<TIM CR1: CEN (Bit 0) */
#define TIM_CR1_CEN_Msk                                                    (0x1UL)		/*!< TIM CR1: CEN (Bitfield-Mask: 0x01) */
#define TIM_CR1_CEN                                                        TIM_CR1_CEN_Msk

/* =====================================================    CR2    ===================================================== */ 
#define TIM_CR2_OIS6_Pos                                                   (18UL)		/*!<TIM CR2: OIS6 (Bit 18) */
#define TIM_CR2_OIS6_Msk                                                   (0x40000UL)		/*!< TIM CR2: OIS6 (Bitfield-Mask: 0x01) */
#define TIM_CR2_OIS6                                                       TIM_CR2_OIS6_Msk
#define TIM_CR2_OIS5_Pos                                                   (16UL)		/*!<TIM CR2: OIS5 (Bit 16) */
#define TIM_CR2_OIS5_Msk                                                   (0x10000UL)		/*!< TIM CR2: OIS5 (Bitfield-Mask: 0x01) */
#define TIM_CR2_OIS5                                                       TIM_CR2_OIS5_Msk
#define TIM_CR2_OIS4_Pos                                                   (14UL)		/*!<TIM CR2: OIS4 (Bit 14) */
#define TIM_CR2_OIS4_Msk                                                   (0x4000UL)		/*!< TIM CR2: OIS4 (Bitfield-Mask: 0x01) */
#define TIM_CR2_OIS4                                                       TIM_CR2_OIS4_Msk
#define TIM_CR2_OIS3N_Pos                                                  (13UL)		/*!<TIM CR2: OIS3N (Bit 13) */
#define TIM_CR2_OIS3N_Msk                                                  (0x2000UL)		/*!< TIM CR2: OIS3N (Bitfield-Mask: 0x01) */
#define TIM_CR2_OIS3N                                                      TIM_CR2_OIS3N_Msk
#define TIM_CR2_OIS3_Pos                                                   (12UL)		/*!<TIM CR2: OIS3 (Bit 12) */
#define TIM_CR2_OIS3_Msk                                                   (0x1000UL)		/*!< TIM CR2: OIS3 (Bitfield-Mask: 0x01) */
#define TIM_CR2_OIS3                                                       TIM_CR2_OIS3_Msk
#define TIM_CR2_OIS2N_Pos                                                  (11UL)		/*!<TIM CR2: OIS2N (Bit 11) */
#define TIM_CR2_OIS2N_Msk                                                  (0x800UL)		/*!< TIM CR2: OIS2N (Bitfield-Mask: 0x01) */
#define TIM_CR2_OIS2N                                                      TIM_CR2_OIS2N_Msk
#define TIM_CR2_OIS2_Pos                                                   (10UL)		/*!<TIM CR2: OIS2 (Bit 10) */
#define TIM_CR2_OIS2_Msk                                                   (0x400UL)		/*!< TIM CR2: OIS2 (Bitfield-Mask: 0x01) */
#define TIM_CR2_OIS2                                                       TIM_CR2_OIS2_Msk
#define TIM_CR2_OIS1N_Pos                                                  (9UL)		/*!<TIM CR2: OIS1N (Bit 9) */
#define TIM_CR2_OIS1N_Msk                                                  (0x200UL)		/*!< TIM CR2: OIS1N (Bitfield-Mask: 0x01) */
#define TIM_CR2_OIS1N                                                      TIM_CR2_OIS1N_Msk
#define TIM_CR2_OIS1_Pos                                                   (8UL)		/*!<TIM CR2: OIS1 (Bit 8) */
#define TIM_CR2_OIS1_Msk                                                   (0x100UL)		/*!< TIM CR2: OIS1 (Bitfield-Mask: 0x01) */
#define TIM_CR2_OIS1                                                       TIM_CR2_OIS1_Msk
#define TIM_CR2_TI1S_Pos                                                   (7UL)		/*!<TIM CR2: TI1S (Bit 7) */
#define TIM_CR2_TI1S_Msk                                                   (0x80UL)		/*!< TIM CR2: TI1S (Bitfield-Mask: 0x01) */
#define TIM_CR2_TI1S                                                       TIM_CR2_TI1S_Msk
#define TIM_CR2_CCUS_Pos                                                   (2UL)		/*!<TIM CR2: CCUS (Bit 2) */
#define TIM_CR2_CCUS_Msk                                                   (0x4UL)		/*!< TIM CR2: CCUS (Bitfield-Mask: 0x01) */
#define TIM_CR2_CCUS                                                       TIM_CR2_CCUS_Msk
#define TIM_CR2_CCPC_Pos                                                   (0UL)		/*!<TIM CR2: CCPC (Bit 0) */
#define TIM_CR2_CCPC_Msk                                                   (0x1UL)		/*!< TIM CR2: CCPC (Bitfield-Mask: 0x01) */
#define TIM_CR2_CCPC                                                       TIM_CR2_CCPC_Msk

/* =====================================================    SMCR    ===================================================== */ 
#define TIM_SMCR_ETP_Pos                                                   (15UL)		/*!<TIM SMCR: ETP (Bit 15) */
#define TIM_SMCR_ETP_Msk                                                   (0x8000UL)		/*!< TIM SMCR: ETP (Bitfield-Mask: 0x01) */
#define TIM_SMCR_ETP                                                       TIM_SMCR_ETP_Msk
#define TIM_SMCR_ECE_Pos                                                   (14UL)		/*!<TIM SMCR: ECE (Bit 14) */
#define TIM_SMCR_ECE_Msk                                                   (0x4000UL)		/*!< TIM SMCR: ECE (Bitfield-Mask: 0x01) */
#define TIM_SMCR_ECE                                                       TIM_SMCR_ECE_Msk
#define TIM_SMCR_ETPS_Pos                                                  (12UL)		/*!<TIM SMCR: ETPS (Bit 12) */
#define TIM_SMCR_ETPS_Msk                                                  (0x3000UL)		/*!< TIM SMCR: ETPS (Bitfield-Mask: 0x03) */
#define TIM_SMCR_ETPS                                                      TIM_SMCR_ETPS_Msk
#define TIM_SMCR_ETPS_0                                                    (0x1U << TIM_SMCR_ETPS_Pos)
#define TIM_SMCR_ETPS_1                                                    (0x2U << TIM_SMCR_ETPS_Pos)
#define TIM_SMCR_ETF_Pos                                                   (8UL)		/*!<TIM SMCR: ETF (Bit 8) */
#define TIM_SMCR_ETF_Msk                                                   (0xf00UL)		/*!< TIM SMCR: ETF (Bitfield-Mask: 0x0f) */
#define TIM_SMCR_ETF                                                       TIM_SMCR_ETF_Msk
#define TIM_SMCR_ETF_0                                                     (0x1U << TIM_SMCR_ETF_Pos)
#define TIM_SMCR_ETF_1                                                     (0x2U << TIM_SMCR_ETF_Pos)
#define TIM_SMCR_ETF_2                                                     (0x4U << TIM_SMCR_ETF_Pos)
#define TIM_SMCR_ETF_3                                                     (0x8U << TIM_SMCR_ETF_Pos)
#define TIM_SMCR_TS_Pos                                                    (4UL)		/*!<TIM SMCR: TS (Bit 4) */
#define TIM_SMCR_TS_Msk                                                    (0x70UL)		/*!< TIM SMCR: TS (Bitfield-Mask: 0x07) */
#define TIM_SMCR_TS                                                        TIM_SMCR_TS_Msk
#define TIM_SMCR_TS_0                                                      (0x1U << TIM_SMCR_TS_Pos)
#define TIM_SMCR_TS_1                                                      (0x2U << TIM_SMCR_TS_Pos)
#define TIM_SMCR_TS_2                                                      (0x4U << TIM_SMCR_TS_Pos)
#define TIM_SMCR_OCCS_Pos                                                  (3UL)		/*!<TIM SMCR: OCCS (Bit 3) */
#define TIM_SMCR_OCCS_Msk                                                  (0x8UL)		/*!< TIM SMCR: OCCS (Bitfield-Mask: 0x01) */
#define TIM_SMCR_OCCS                                                      TIM_SMCR_OCCS_Msk
#define TIM_SMCR_SMS_Pos                                                   (0UL)		/*!<TIM SMCR: SMS (Bit 0) */
#define TIM_SMCR_SMS_Msk                                                   (0x10007UL)		/*!< TIM SMCR: SMS (Bitfield-Mask: 0x10007) */
#define TIM_SMCR_SMS                                                       TIM_SMCR_SMS_Msk
#define TIM_SMCR_SMS_0                                                     (0x1U << TIM_SMCR_SMS_Pos)
#define TIM_SMCR_SMS_1                                                     (0x2U << TIM_SMCR_SMS_Pos)
#define TIM_SMCR_SMS_2                                                     (0x4U << TIM_SMCR_SMS_Pos)
#define TIM_SMCR_SMS_3                                                     (0x10000U << TIM_SMCR_SMS_Pos)

/* =====================================================    DIER    ===================================================== */ 
#define TIM_DIER_BIE_Pos                                                   (7UL)		/*!<TIM DIER: BIE (Bit 7) */
#define TIM_DIER_BIE_Msk                                                   (0x80UL)		/*!< TIM DIER: BIE (Bitfield-Mask: 0x01) */
#define TIM_DIER_BIE                                                       TIM_DIER_BIE_Msk
#define TIM_DIER_TIE_Pos                                                   (6UL)		/*!<TIM DIER: TIE (Bit 6) */
#define TIM_DIER_TIE_Msk                                                   (0x40UL)		/*!< TIM DIER: TIE (Bitfield-Mask: 0x01) */
#define TIM_DIER_TIE                                                       TIM_DIER_TIE_Msk
#define TIM_DIER_COMIE_Pos                                                 (5UL)		/*!<TIM DIER: COMIE (Bit 5) */
#define TIM_DIER_COMIE_Msk                                                 (0x20UL)		/*!< TIM DIER: COMIE (Bitfield-Mask: 0x01) */
#define TIM_DIER_COMIE                                                     TIM_DIER_COMIE_Msk
#define TIM_DIER_CC4IE_Pos                                                 (4UL)		/*!<TIM DIER: CC4IE (Bit 4) */
#define TIM_DIER_CC4IE_Msk                                                 (0x10UL)		/*!< TIM DIER: CC4IE (Bitfield-Mask: 0x01) */
#define TIM_DIER_CC4IE                                                     TIM_DIER_CC4IE_Msk
#define TIM_DIER_CC3IE_Pos                                                 (3UL)		/*!<TIM DIER: CC3IE (Bit 3) */
#define TIM_DIER_CC3IE_Msk                                                 (0x8UL)		/*!< TIM DIER: CC3IE (Bitfield-Mask: 0x01) */
#define TIM_DIER_CC3IE                                                     TIM_DIER_CC3IE_Msk
#define TIM_DIER_CC2IE_Pos                                                 (2UL)		/*!<TIM DIER: CC2IE (Bit 2) */
#define TIM_DIER_CC2IE_Msk                                                 (0x4UL)		/*!< TIM DIER: CC2IE (Bitfield-Mask: 0x01) */
#define TIM_DIER_CC2IE                                                     TIM_DIER_CC2IE_Msk
#define TIM_DIER_CC1IE_Pos                                                 (1UL)		/*!<TIM DIER: CC1IE (Bit 1) */
#define TIM_DIER_CC1IE_Msk                                                 (0x2UL)		/*!< TIM DIER: CC1IE (Bitfield-Mask: 0x01) */
#define TIM_DIER_CC1IE                                                     TIM_DIER_CC1IE_Msk
#define TIM_DIER_UIE_Pos                                                   (0UL)		/*!<TIM DIER: UIE (Bit 0) */
#define TIM_DIER_UIE_Msk                                                   (0x1UL)		/*!< TIM DIER: UIE (Bitfield-Mask: 0x01) */
#define TIM_DIER_UIE                                                       TIM_DIER_UIE_Msk

/* =====================================================    SR    ===================================================== */ 
#define TIM_SR_CC6IF_Pos                                                   (17UL)		/*!<TIM SR: CC6IF (Bit 17) */
#define TIM_SR_CC6IF_Msk                                                   (0x20000UL)		/*!< TIM SR: CC6IF (Bitfield-Mask: 0x01) */
#define TIM_SR_CC6IF                                                       TIM_SR_CC6IF_Msk
#define TIM_SR_CC5IF_Pos                                                   (16UL)		/*!<TIM SR: CC5IF (Bit 16) */
#define TIM_SR_CC5IF_Msk                                                   (0x10000UL)		/*!< TIM SR: CC5IF (Bitfield-Mask: 0x01) */
#define TIM_SR_CC5IF                                                       TIM_SR_CC5IF_Msk
#define TIM_SR_CC4OF_Pos                                                   (12UL)		/*!<TIM SR: CC4OF (Bit 12) */
#define TIM_SR_CC4OF_Msk                                                   (0x1000UL)		/*!< TIM SR: CC4OF (Bitfield-Mask: 0x01) */
#define TIM_SR_CC4OF                                                       TIM_SR_CC4OF_Msk
#define TIM_SR_CC3OF_Pos                                                   (11UL)		/*!<TIM SR: CC3OF (Bit 11) */
#define TIM_SR_CC3OF_Msk                                                   (0x800UL)		/*!< TIM SR: CC3OF (Bitfield-Mask: 0x01) */
#define TIM_SR_CC3OF                                                       TIM_SR_CC3OF_Msk
#define TIM_SR_CC2OF_Pos                                                   (10UL)		/*!<TIM SR: CC2OF (Bit 10) */
#define TIM_SR_CC2OF_Msk                                                   (0x400UL)		/*!< TIM SR: CC2OF (Bitfield-Mask: 0x01) */
#define TIM_SR_CC2OF                                                       TIM_SR_CC2OF_Msk
#define TIM_SR_CC1OF_Pos                                                   (9UL)		/*!<TIM SR: CC1OF (Bit 9) */
#define TIM_SR_CC1OF_Msk                                                   (0x200UL)		/*!< TIM SR: CC1OF (Bitfield-Mask: 0x01) */
#define TIM_SR_CC1OF                                                       TIM_SR_CC1OF_Msk
#define TIM_SR_B2IF_Pos                                                    (8UL)		/*!<TIM SR: B2IF (Bit 8) */
#define TIM_SR_B2IF_Msk                                                    (0x100UL)		/*!< TIM SR: B2IF (Bitfield-Mask: 0x01) */
#define TIM_SR_B2IF                                                        TIM_SR_B2IF_Msk
#define TIM_SR_BIF_Pos                                                     (7UL)		/*!<TIM SR: BIF (Bit 7) */
#define TIM_SR_BIF_Msk                                                     (0x80UL)		/*!< TIM SR: BIF (Bitfield-Mask: 0x01) */
#define TIM_SR_BIF                                                         TIM_SR_BIF_Msk
#define TIM_SR_TIF_Pos                                                     (6UL)		/*!<TIM SR: TIF (Bit 6) */
#define TIM_SR_TIF_Msk                                                     (0x40UL)		/*!< TIM SR: TIF (Bitfield-Mask: 0x01) */
#define TIM_SR_TIF                                                         TIM_SR_TIF_Msk
#define TIM_SR_COMIF_Pos                                                   (5UL)		/*!<TIM SR: COMIF (Bit 5) */
#define TIM_SR_COMIF_Msk                                                   (0x20UL)		/*!< TIM SR: COMIF (Bitfield-Mask: 0x01) */
#define TIM_SR_COMIF                                                       TIM_SR_COMIF_Msk
#define TIM_SR_CC4IF_Pos                                                   (4UL)		/*!<TIM SR: CC4IF (Bit 4) */
#define TIM_SR_CC4IF_Msk                                                   (0x10UL)		/*!< TIM SR: CC4IF (Bitfield-Mask: 0x01) */
#define TIM_SR_CC4IF                                                       TIM_SR_CC4IF_Msk
#define TIM_SR_CC3IF_Pos                                                   (3UL)		/*!<TIM SR: CC3IF (Bit 3) */
#define TIM_SR_CC3IF_Msk                                                   (0x8UL)		/*!< TIM SR: CC3IF (Bitfield-Mask: 0x01) */
#define TIM_SR_CC3IF                                                       TIM_SR_CC3IF_Msk
#define TIM_SR_CC2IF_Pos                                                   (2UL)		/*!<TIM SR: CC2IF (Bit 2) */
#define TIM_SR_CC2IF_Msk                                                   (0x4UL)		/*!< TIM SR: CC2IF (Bitfield-Mask: 0x01) */
#define TIM_SR_CC2IF                                                       TIM_SR_CC2IF_Msk
#define TIM_SR_CC1IF_Pos                                                   (1UL)		/*!<TIM SR: CC1IF (Bit 1) */
#define TIM_SR_CC1IF_Msk                                                   (0x2UL)		/*!< TIM SR: CC1IF (Bitfield-Mask: 0x01) */
#define TIM_SR_CC1IF                                                       TIM_SR_CC1IF_Msk
#define TIM_SR_UIF_Pos                                                     (0UL)		/*!<TIM SR: UIF (Bit 0) */
#define TIM_SR_UIF_Msk                                                     (0x1UL)		/*!< TIM SR: UIF (Bitfield-Mask: 0x01) */
#define TIM_SR_UIF                                                         TIM_SR_UIF_Msk

/* =====================================================    EGR    ===================================================== */ 
#define TIM_EGR_B2G_Pos                                                    (8UL)		/*!<TIM EGR: B2G (Bit 8) */
#define TIM_EGR_B2G_Msk                                                    (0x100UL)		/*!< TIM EGR: B2G (Bitfield-Mask: 0x01) */
#define TIM_EGR_B2G                                                        TIM_EGR_B2G_Msk
#define TIM_EGR_BG_Pos                                                     (7UL)		/*!<TIM EGR: BG (Bit 7) */
#define TIM_EGR_BG_Msk                                                     (0x80UL)		/*!< TIM EGR: BG (Bitfield-Mask: 0x01) */
#define TIM_EGR_BG                                                         TIM_EGR_BG_Msk
#define TIM_EGR_TG_Pos                                                     (6UL)		/*!<TIM EGR: TG (Bit 6) */
#define TIM_EGR_TG_Msk                                                     (0x40UL)		/*!< TIM EGR: TG (Bitfield-Mask: 0x01) */
#define TIM_EGR_TG                                                         TIM_EGR_TG_Msk
#define TIM_EGR_COMG_Pos                                                   (5UL)		/*!<TIM EGR: COMG (Bit 5) */
#define TIM_EGR_COMG_Msk                                                   (0x20UL)		/*!< TIM EGR: COMG (Bitfield-Mask: 0x01) */
#define TIM_EGR_COMG                                                       TIM_EGR_COMG_Msk
#define TIM_EGR_CC4G_Pos                                                   (4UL)		/*!<TIM EGR: CC4G (Bit 4) */
#define TIM_EGR_CC4G_Msk                                                   (0x10UL)		/*!< TIM EGR: CC4G (Bitfield-Mask: 0x01) */
#define TIM_EGR_CC4G                                                       TIM_EGR_CC4G_Msk
#define TIM_EGR_CC3G_Pos                                                   (3UL)		/*!<TIM EGR: CC3G (Bit 3) */
#define TIM_EGR_CC3G_Msk                                                   (0x8UL)		/*!< TIM EGR: CC3G (Bitfield-Mask: 0x01) */
#define TIM_EGR_CC3G                                                       TIM_EGR_CC3G_Msk
#define TIM_EGR_CC2G_Pos                                                   (2UL)		/*!<TIM EGR: CC2G (Bit 2) */
#define TIM_EGR_CC2G_Msk                                                   (0x4UL)		/*!< TIM EGR: CC2G (Bitfield-Mask: 0x01) */
#define TIM_EGR_CC2G                                                       TIM_EGR_CC2G_Msk
#define TIM_EGR_CC1G_Pos                                                   (1UL)		/*!<TIM EGR: CC1G (Bit 1) */
#define TIM_EGR_CC1G_Msk                                                   (0x2UL)		/*!< TIM EGR: CC1G (Bitfield-Mask: 0x01) */
#define TIM_EGR_CC1G                                                       TIM_EGR_CC1G_Msk
#define TIM_EGR_UG_Pos                                                     (0UL)		/*!<TIM EGR: UG (Bit 0) */
#define TIM_EGR_UG_Msk                                                     (0x1UL)		/*!< TIM EGR: UG (Bitfield-Mask: 0x01) */
#define TIM_EGR_UG                                                         TIM_EGR_UG_Msk

/* =====================================================    CCMR1    ===================================================== */ 
#define TIM_CCMR1_OC2CE_Pos                                                (15UL)		/*!<TIM CCMR1: OC2CE (Bit 15) */
#define TIM_CCMR1_OC2CE_Msk                                                (0x8000UL)		/*!< TIM CCMR1: OC2CE (Bitfield-Mask: 0x01) */
#define TIM_CCMR1_OC2CE                                                    TIM_CCMR1_OC2CE_Msk
#define TIM_CCMR1_OC2M_Pos                                                 (12UL)		/*!<TIM CCMR1: OC2M (Bit 12) */
#define TIM_CCMR1_OC2M_Msk                                                 (0x1007000UL)		/*!< TIM CCMR1: OC2M (Bitfield-Mask: 0x1007) */
#define TIM_CCMR1_OC2M                                                     TIM_CCMR1_OC2M_Msk
#define TIM_CCMR1_OC2M_0                                                   (0x1U << TIM_CCMR1_OC2M_Pos)
#define TIM_CCMR1_OC2M_1                                                   (0x2U << TIM_CCMR1_OC2M_Pos)
#define TIM_CCMR1_OC2M_2                                                   (0x4U << TIM_CCMR1_OC2M_Pos)
#define TIM_CCMR1_OC2M_3                                                   (0x1000U << TIM_CCMR1_OC2M_Pos)
#define TIM_CCMR1_OC2PE_Pos                                                (11UL)		/*!<TIM CCMR1: OC2PE (Bit 11) */
#define TIM_CCMR1_OC2PE_Msk                                                (0x800UL)		/*!< TIM CCMR1: OC2PE (Bitfield-Mask: 0x01) */
#define TIM_CCMR1_OC2PE                                                    TIM_CCMR1_OC2PE_Msk
#define TIM_CCMR1_OC2FE_Pos                                                (10UL)		/*!<TIM CCMR1: OC2FE (Bit 10) */
#define TIM_CCMR1_OC2FE_Msk                                                (0x400UL)		/*!< TIM CCMR1: OC2FE (Bitfield-Mask: 0x01) */
#define TIM_CCMR1_OC2FE                                                    TIM_CCMR1_OC2FE_Msk
#define TIM_CCMR1_CC2S_Pos                                                 (8UL)		/*!<TIM CCMR1: CC2S (Bit 8) */
#define TIM_CCMR1_CC2S_Msk                                                 (0x300UL)		/*!< TIM CCMR1: CC2S (Bitfield-Mask: 0x03) */
#define TIM_CCMR1_CC2S                                                     TIM_CCMR1_CC2S_Msk
#define TIM_CCMR1_CC2S_0                                                   (0x1U << TIM_CCMR1_CC2S_Pos)
#define TIM_CCMR1_CC2S_1                                                   (0x2U << TIM_CCMR1_CC2S_Pos)
#define TIM_CCMR1_OC1CE_Pos                                                (7UL)		/*!<TIM CCMR1: OC1CE (Bit 7) */
#define TIM_CCMR1_OC1CE_Msk                                                (0x80UL)		/*!< TIM CCMR1: OC1CE (Bitfield-Mask: 0x01) */
#define TIM_CCMR1_OC1CE                                                    TIM_CCMR1_OC1CE_Msk
#define TIM_CCMR1_OC1M_Pos                                                 (4UL)		/*!<TIM CCMR1: OC1M (Bit 4) */
#define TIM_CCMR1_OC1M_Msk                                                 (0x10070UL)		/*!< TIM CCMR1: OC1M (Bitfield-Mask: 0x1007) */
#define TIM_CCMR1_OC1M                                                     TIM_CCMR1_OC1M_Msk
#define TIM_CCMR1_OC1M_0                                                   (0x1U << TIM_CCMR1_OC1M_Pos)
#define TIM_CCMR1_OC1M_1                                                   (0x2U << TIM_CCMR1_OC1M_Pos)
#define TIM_CCMR1_OC1M_2                                                   (0x4U << TIM_CCMR1_OC1M_Pos)
#define TIM_CCMR1_OC1M_3                                                   (0x1000U << TIM_CCMR1_OC1M_Pos)
#define TIM_CCMR1_OC1PE_Pos                                                (3UL)		/*!<TIM CCMR1: OC1PE (Bit 3) */
#define TIM_CCMR1_OC1PE_Msk                                                (0x8UL)		/*!< TIM CCMR1: OC1PE (Bitfield-Mask: 0x01) */
#define TIM_CCMR1_OC1PE                                                    TIM_CCMR1_OC1PE_Msk
#define TIM_CCMR1_OC1FE_Pos                                                (2UL)		/*!<TIM CCMR1: OC1FE (Bit 2) */
#define TIM_CCMR1_OC1FE_Msk                                                (0x4UL)		/*!< TIM CCMR1: OC1FE (Bitfield-Mask: 0x01) */
#define TIM_CCMR1_OC1FE                                                    TIM_CCMR1_OC1FE_Msk
#define TIM_CCMR1_CC1S_Pos                                                 (0UL)		/*!<TIM CCMR1: CC1S (Bit 0) */
#define TIM_CCMR1_CC1S_Msk                                                 (0x3UL)		/*!< TIM CCMR1: CC1S (Bitfield-Mask: 0x03) */
#define TIM_CCMR1_CC1S                                                     TIM_CCMR1_CC1S_Msk
#define TIM_CCMR1_CC1S_0                                                   (0x1U << TIM_CCMR1_CC1S_Pos)
#define TIM_CCMR1_CC1S_1                                                   (0x2U << TIM_CCMR1_CC1S_Pos)

/* =====================================================    CCMR1    ===================================================== */ 
#define TIM_CCMR1_IC2F_Pos                                                 (12UL)		/*!<TIM CCMR1: IC2F (Bit 12) */
#define TIM_CCMR1_IC2F_Msk                                                 (0xf000UL)		/*!< TIM CCMR1: IC2F (Bitfield-Mask: 0x0f) */
#define TIM_CCMR1_IC2F                                                     TIM_CCMR1_IC2F_Msk
#define TIM_CCMR1_IC2F_0                                                   (0x1U << TIM_CCMR1_IC2F_Pos)
#define TIM_CCMR1_IC2F_1                                                   (0x2U << TIM_CCMR1_IC2F_Pos)
#define TIM_CCMR1_IC2F_2                                                   (0x4U << TIM_CCMR1_IC2F_Pos)
#define TIM_CCMR1_IC2F_3                                                   (0x8U << TIM_CCMR1_IC2F_Pos)
#define TIM_CCMR1_IC2PSC_Pos                                               (10UL)		/*!<TIM CCMR1: IC2PSC (Bit 10) */
#define TIM_CCMR1_IC2PSC_Msk                                               (0xc00UL)		/*!< TIM CCMR1: IC2PSC (Bitfield-Mask: 0x03) */
#define TIM_CCMR1_IC2PSC                                                   TIM_CCMR1_IC2PSC_Msk
#define TIM_CCMR1_IC2PSC_0                                                 (0x1U << TIM_CCMR1_IC2PSC_Pos)
#define TIM_CCMR1_IC2PSC_1                                                 (0x2U << TIM_CCMR1_IC2PSC_Pos)
#define TIM_CCMR1_CC2S_Pos                                                 (8UL)		/*!<TIM CCMR1: CC2S (Bit 8) */
#define TIM_CCMR1_CC2S_Msk                                                 (0x300UL)		/*!< TIM CCMR1: CC2S (Bitfield-Mask: 0x03) */
#define TIM_CCMR1_CC2S                                                     TIM_CCMR1_CC2S_Msk
#define TIM_CCMR1_CC2S_0                                                   (0x1U << TIM_CCMR1_CC2S_Pos)
#define TIM_CCMR1_CC2S_1                                                   (0x2U << TIM_CCMR1_CC2S_Pos)
#define TIM_CCMR1_IC1F_Pos                                                 (4UL)		/*!<TIM CCMR1: IC1F (Bit 4) */
#define TIM_CCMR1_IC1F_Msk                                                 (0xf0UL)		/*!< TIM CCMR1: IC1F (Bitfield-Mask: 0x0f) */
#define TIM_CCMR1_IC1F                                                     TIM_CCMR1_IC1F_Msk
#define TIM_CCMR1_IC1F_0                                                   (0x1U << TIM_CCMR1_IC1F_Pos)
#define TIM_CCMR1_IC1F_1                                                   (0x2U << TIM_CCMR1_IC1F_Pos)
#define TIM_CCMR1_IC1F_2                                                   (0x4U << TIM_CCMR1_IC1F_Pos)
#define TIM_CCMR1_IC1F_3                                                   (0x8U << TIM_CCMR1_IC1F_Pos)
#define TIM_CCMR1_IC1PSC_Pos                                               (2UL)		/*!<TIM CCMR1: IC1PSC (Bit 2) */
#define TIM_CCMR1_IC1PSC_Msk                                               (0xcUL)		/*!< TIM CCMR1: IC1PSC (Bitfield-Mask: 0x03) */
#define TIM_CCMR1_IC1PSC                                                   TIM_CCMR1_IC1PSC_Msk
#define TIM_CCMR1_IC1PSC_0                                                 (0x1U << TIM_CCMR1_IC1PSC_Pos)
#define TIM_CCMR1_IC1PSC_1                                                 (0x2U << TIM_CCMR1_IC1PSC_Pos)
#define TIM_CCMR1_CC1S_Pos                                                 (0UL)		/*!<TIM CCMR1: CC1S (Bit 0) */
#define TIM_CCMR1_CC1S_Msk                                                 (0x3UL)		/*!< TIM CCMR1: CC1S (Bitfield-Mask: 0x03) */
#define TIM_CCMR1_CC1S                                                     TIM_CCMR1_CC1S_Msk
#define TIM_CCMR1_CC1S_0                                                   (0x1U << TIM_CCMR1_CC1S_Pos)
#define TIM_CCMR1_CC1S_1                                                   (0x2U << TIM_CCMR1_CC1S_Pos)

/* =====================================================    CCMR2    ===================================================== */ 
#define TIM_CCMR2_OC4CE_Pos                                                (15UL)		/*!<TIM CCMR2: OC4CE (Bit 15) */
#define TIM_CCMR2_OC4CE_Msk                                                (0x8000UL)		/*!< TIM CCMR2: OC4CE (Bitfield-Mask: 0x01) */
#define TIM_CCMR2_OC4CE                                                    TIM_CCMR2_OC4CE_Msk
#define TIM_CCMR2_OC4M_Pos                                                 (12UL)		/*!<TIM CCMR2: OC4M (Bit 12) */
#define TIM_CCMR2_OC4M_Msk                                                 (0x1007000UL)		/*!< TIM CCMR2: OC4M (Bitfield-Mask: 0x1007) */
#define TIM_CCMR2_OC4M                                                     TIM_CCMR2_OC4M_Msk
#define TIM_CCMR2_OC4M_0                                                   (0x1U << TIM_CCMR2_OC4M_Pos)
#define TIM_CCMR2_OC4M_1                                                   (0x2U << TIM_CCMR2_OC4M_Pos)
#define TIM_CCMR2_OC4M_2                                                   (0x4U << TIM_CCMR2_OC4M_Pos)
#define TIM_CCMR2_OC4M_3                                                   (0x1000U << TIM_CCMR2_OC4M_Pos)
#define TIM_CCMR2_OC4PE_Pos                                                (11UL)		/*!<TIM CCMR2: OC4PE (Bit 11) */
#define TIM_CCMR2_OC4PE_Msk                                                (0x800UL)		/*!< TIM CCMR2: OC4PE (Bitfield-Mask: 0x01) */
#define TIM_CCMR2_OC4PE                                                    TIM_CCMR2_OC4PE_Msk
#define TIM_CCMR2_OC4FE_Pos                                                (10UL)		/*!<TIM CCMR2: OC4FE (Bit 10) */
#define TIM_CCMR2_OC4FE_Msk                                                (0x400UL)		/*!< TIM CCMR2: OC4FE (Bitfield-Mask: 0x01) */
#define TIM_CCMR2_OC4FE                                                    TIM_CCMR2_OC4FE_Msk
#define TIM_CCMR2_CC4S_Pos                                                 (8UL)		/*!<TIM CCMR2: CC4S (Bit 8) */
#define TIM_CCMR2_CC4S_Msk                                                 (0x300UL)		/*!< TIM CCMR2: CC4S (Bitfield-Mask: 0x03) */
#define TIM_CCMR2_CC4S                                                     TIM_CCMR2_CC4S_Msk
#define TIM_CCMR2_CC4S_0                                                   (0x1U << TIM_CCMR2_CC4S_Pos)
#define TIM_CCMR2_CC4S_1                                                   (0x2U << TIM_CCMR2_CC4S_Pos)
#define TIM_CCMR2_OC3CE_Pos                                                (7UL)		/*!<TIM CCMR2: OC3CE (Bit 7) */
#define TIM_CCMR2_OC3CE_Msk                                                (0x80UL)		/*!< TIM CCMR2: OC3CE (Bitfield-Mask: 0x01) */
#define TIM_CCMR2_OC3CE                                                    TIM_CCMR2_OC3CE_Msk
#define TIM_CCMR2_OC3M_Pos                                                 (4UL)		/*!<TIM CCMR2: OC3M (Bit 4) */
#define TIM_CCMR2_OC3M_Msk                                                 (0x10070UL)		/*!< TIM CCMR2: OC3M (Bitfield-Mask: 0x1007) */
#define TIM_CCMR2_OC3M                                                     TIM_CCMR2_OC3M_Msk
#define TIM_CCMR2_OC3M_0                                                   (0x1U << TIM_CCMR2_OC3M_Pos)
#define TIM_CCMR2_OC3M_1                                                   (0x2U << TIM_CCMR2_OC3M_Pos)
#define TIM_CCMR2_OC3M_2                                                   (0x4U << TIM_CCMR2_OC3M_Pos)
#define TIM_CCMR2_OC3M_3                                                   (0x1000U << TIM_CCMR2_OC3M_Pos)
#define TIM_CCMR2_OC3PE_Pos                                                (3UL)		/*!<TIM CCMR2: OC3PE (Bit 3) */
#define TIM_CCMR2_OC3PE_Msk                                                (0x8UL)		/*!< TIM CCMR2: OC3PE (Bitfield-Mask: 0x01) */
#define TIM_CCMR2_OC3PE                                                    TIM_CCMR2_OC3PE_Msk
#define TIM_CCMR2_OC3FE_Pos                                                (2UL)		/*!<TIM CCMR2: OC3FE (Bit 2) */
#define TIM_CCMR2_OC3FE_Msk                                                (0x4UL)		/*!< TIM CCMR2: OC3FE (Bitfield-Mask: 0x01) */
#define TIM_CCMR2_OC3FE                                                    TIM_CCMR2_OC3FE_Msk
#define TIM_CCMR2_CC3S_Pos                                                 (0UL)		/*!<TIM CCMR2: CC3S (Bit 0) */
#define TIM_CCMR2_CC3S_Msk                                                 (0x3UL)		/*!< TIM CCMR2: CC3S (Bitfield-Mask: 0x03) */
#define TIM_CCMR2_CC3S                                                     TIM_CCMR2_CC3S_Msk
#define TIM_CCMR2_CC3S_0                                                   (0x1U << TIM_CCMR2_CC3S_Pos)
#define TIM_CCMR2_CC3S_1                                                   (0x2U << TIM_CCMR2_CC3S_Pos)

/* =====================================================    CCMR2    ===================================================== */ 
#define TIM_CCMR2_IC4F_Pos                                                 (12UL)		/*!<TIM CCMR2: IC4F (Bit 12) */
#define TIM_CCMR2_IC4F_Msk                                                 (0xf000UL)		/*!< TIM CCMR2: IC4F (Bitfield-Mask: 0x0f) */
#define TIM_CCMR2_IC4F                                                     TIM_CCMR2_IC4F_Msk
#define TIM_CCMR2_IC4F_0                                                   (0x1U << TIM_CCMR2_IC4F_Pos)
#define TIM_CCMR2_IC4F_1                                                   (0x2U << TIM_CCMR2_IC4F_Pos)
#define TIM_CCMR2_IC4F_2                                                   (0x4U << TIM_CCMR2_IC4F_Pos)
#define TIM_CCMR2_IC4F_3                                                   (0x8U << TIM_CCMR2_IC4F_Pos)
#define TIM_CCMR2_IC4PSC_Pos                                               (10UL)		/*!<TIM CCMR2: IC4PSC (Bit 10) */
#define TIM_CCMR2_IC4PSC_Msk                                               (0xc00UL)		/*!< TIM CCMR2: IC4PSC (Bitfield-Mask: 0x03) */
#define TIM_CCMR2_IC4PSC                                                   TIM_CCMR2_IC4PSC_Msk
#define TIM_CCMR2_IC4PSC_0                                                 (0x1U << TIM_CCMR2_IC4PSC_Pos)
#define TIM_CCMR2_IC4PSC_1                                                 (0x2U << TIM_CCMR2_IC4PSC_Pos)
#define TIM_CCMR2_CC4S_Pos                                                 (8UL)		/*!<TIM CCMR2: CC4S (Bit 8) */
#define TIM_CCMR2_CC4S_Msk                                                 (0x300UL)		/*!< TIM CCMR2: CC4S (Bitfield-Mask: 0x03) */
#define TIM_CCMR2_CC4S                                                     TIM_CCMR2_CC4S_Msk
#define TIM_CCMR2_CC4S_0                                                   (0x1U << TIM_CCMR2_CC4S_Pos)
#define TIM_CCMR2_CC4S_1                                                   (0x2U << TIM_CCMR2_CC4S_Pos)
#define TIM_CCMR2_IC3F_Pos                                                 (4UL)		/*!<TIM CCMR2: IC3F (Bit 4) */
#define TIM_CCMR2_IC3F_Msk                                                 (0xf0UL)		/*!< TIM CCMR2: IC3F (Bitfield-Mask: 0x0f) */
#define TIM_CCMR2_IC3F                                                     TIM_CCMR2_IC3F_Msk
#define TIM_CCMR2_IC3F_0                                                   (0x1U << TIM_CCMR2_IC3F_Pos)
#define TIM_CCMR2_IC3F_1                                                   (0x2U << TIM_CCMR2_IC3F_Pos)
#define TIM_CCMR2_IC3F_2                                                   (0x4U << TIM_CCMR2_IC3F_Pos)
#define TIM_CCMR2_IC3F_3                                                   (0x8U << TIM_CCMR2_IC3F_Pos)
#define TIM_CCMR2_IC3PSC_Pos                                               (2UL)		/*!<TIM CCMR2: IC3PSC (Bit 2) */
#define TIM_CCMR2_IC3PSC_Msk                                               (0xcUL)		/*!< TIM CCMR2: IC3PSC (Bitfield-Mask: 0x03) */
#define TIM_CCMR2_IC3PSC                                                   TIM_CCMR2_IC3PSC_Msk
#define TIM_CCMR2_IC3PSC_0                                                 (0x1U << TIM_CCMR2_IC3PSC_Pos)
#define TIM_CCMR2_IC3PSC_1                                                 (0x2U << TIM_CCMR2_IC3PSC_Pos)
#define TIM_CCMR2_CC3S_Pos                                                 (0UL)		/*!<TIM CCMR2: CC3S (Bit 0) */
#define TIM_CCMR2_CC3S_Msk                                                 (0x3UL)		/*!< TIM CCMR2: CC3S (Bitfield-Mask: 0x03) */
#define TIM_CCMR2_CC3S                                                     TIM_CCMR2_CC3S_Msk
#define TIM_CCMR2_CC3S_0                                                   (0x1U << TIM_CCMR2_CC3S_Pos)
#define TIM_CCMR2_CC3S_1                                                   (0x2U << TIM_CCMR2_CC3S_Pos)

/* =====================================================    CCER    ===================================================== */ 
#define TIM_CCER_CC6P_Pos                                                  (21UL)		/*!<TIM CCER: CC6P (Bit 21) */
#define TIM_CCER_CC6P_Msk                                                  (0x200000UL)		/*!< TIM CCER: CC6P (Bitfield-Mask: 0x01) */
#define TIM_CCER_CC6P                                                      TIM_CCER_CC6P_Msk
#define TIM_CCER_CC6E_Pos                                                  (20UL)		/*!<TIM CCER: CC6E (Bit 20) */
#define TIM_CCER_CC6E_Msk                                                  (0x100000UL)		/*!< TIM CCER: CC6E (Bitfield-Mask: 0x01) */
#define TIM_CCER_CC6E                                                      TIM_CCER_CC6E_Msk
#define TIM_CCER_CC5P_Pos                                                  (17UL)		/*!<TIM CCER: CC5P (Bit 17) */
#define TIM_CCER_CC5P_Msk                                                  (0x20000UL)		/*!< TIM CCER: CC5P (Bitfield-Mask: 0x01) */
#define TIM_CCER_CC5P                                                      TIM_CCER_CC5P_Msk
#define TIM_CCER_CC5E_Pos                                                  (16UL)		/*!<TIM CCER: CC5E (Bit 16) */
#define TIM_CCER_CC5E_Msk                                                  (0x10000UL)		/*!< TIM CCER: CC5E (Bitfield-Mask: 0x01) */
#define TIM_CCER_CC5E                                                      TIM_CCER_CC5E_Msk
#define TIM_CCER_CC4NP_Pos                                                 (15UL)		/*!<TIM CCER: CC4NP (Bit 15) */
#define TIM_CCER_CC4NP_Msk                                                 (0x8000UL)		/*!< TIM CCER: CC4NP (Bitfield-Mask: 0x01) */
#define TIM_CCER_CC4NP                                                     TIM_CCER_CC4NP_Msk
#define TIM_CCER_CC4NE_Pos                                                 (14UL)		/*!<TIM CCER: CC4NE (Bit 14) */
#define TIM_CCER_CC4NE_Msk                                                 (0x4000UL)		/*!< TIM CCER: CC4NE (Bitfield-Mask: 0x01) */
#define TIM_CCER_CC4NE                                                     TIM_CCER_CC4NE_Msk
#define TIM_CCER_CC4P_Pos                                                  (13UL)		/*!<TIM CCER: CC4P (Bit 13) */
#define TIM_CCER_CC4P_Msk                                                  (0x2000UL)		/*!< TIM CCER: CC4P (Bitfield-Mask: 0x01) */
#define TIM_CCER_CC4P                                                      TIM_CCER_CC4P_Msk
#define TIM_CCER_CC4E_Pos                                                  (12UL)		/*!<TIM CCER: CC4E (Bit 12) */
#define TIM_CCER_CC4E_Msk                                                  (0x1000UL)		/*!< TIM CCER: CC4E (Bitfield-Mask: 0x01) */
#define TIM_CCER_CC4E                                                      TIM_CCER_CC4E_Msk
#define TIM_CCER_CC3NP_Pos                                                 (11UL)		/*!<TIM CCER: CC3NP (Bit 11) */
#define TIM_CCER_CC3NP_Msk                                                 (0x800UL)		/*!< TIM CCER: CC3NP (Bitfield-Mask: 0x01) */
#define TIM_CCER_CC3NP                                                     TIM_CCER_CC3NP_Msk
#define TIM_CCER_CC3NE_Pos                                                 (10UL)		/*!<TIM CCER: CC3NE (Bit 10) */
#define TIM_CCER_CC3NE_Msk                                                 (0x400UL)		/*!< TIM CCER: CC3NE (Bitfield-Mask: 0x01) */
#define TIM_CCER_CC3NE                                                     TIM_CCER_CC3NE_Msk
#define TIM_CCER_CC3P_Pos                                                  (9UL)		/*!<TIM CCER: CC3P (Bit 9) */
#define TIM_CCER_CC3P_Msk                                                  (0x200UL)		/*!< TIM CCER: CC3P (Bitfield-Mask: 0x01) */
#define TIM_CCER_CC3P                                                      TIM_CCER_CC3P_Msk
#define TIM_CCER_CC3E_Pos                                                  (8UL)		/*!<TIM CCER: CC3E (Bit 8) */
#define TIM_CCER_CC3E_Msk                                                  (0x100UL)		/*!< TIM CCER: CC3E (Bitfield-Mask: 0x01) */
#define TIM_CCER_CC3E                                                      TIM_CCER_CC3E_Msk
#define TIM_CCER_CC2NP_Pos                                                 (7UL)		/*!<TIM CCER: CC2NP (Bit 7) */
#define TIM_CCER_CC2NP_Msk                                                 (0x80UL)		/*!< TIM CCER: CC2NP (Bitfield-Mask: 0x01) */
#define TIM_CCER_CC2NP                                                     TIM_CCER_CC2NP_Msk
#define TIM_CCER_CC2NE_Pos                                                 (6UL)		/*!<TIM CCER: CC2NE (Bit 6) */
#define TIM_CCER_CC2NE_Msk                                                 (0x40UL)		/*!< TIM CCER: CC2NE (Bitfield-Mask: 0x01) */
#define TIM_CCER_CC2NE                                                     TIM_CCER_CC2NE_Msk
#define TIM_CCER_CC2P_Pos                                                  (5UL)		/*!<TIM CCER: CC2P (Bit 5) */
#define TIM_CCER_CC2P_Msk                                                  (0x20UL)		/*!< TIM CCER: CC2P (Bitfield-Mask: 0x01) */
#define TIM_CCER_CC2P                                                      TIM_CCER_CC2P_Msk
#define TIM_CCER_CC2E_Pos                                                  (4UL)		/*!<TIM CCER: CC2E (Bit 4) */
#define TIM_CCER_CC2E_Msk                                                  (0x10UL)		/*!< TIM CCER: CC2E (Bitfield-Mask: 0x01) */
#define TIM_CCER_CC2E                                                      TIM_CCER_CC2E_Msk
#define TIM_CCER_CC1NP_Pos                                                 (3UL)		/*!<TIM CCER: CC1NP (Bit 3) */
#define TIM_CCER_CC1NP_Msk                                                 (0x8UL)		/*!< TIM CCER: CC1NP (Bitfield-Mask: 0x01) */
#define TIM_CCER_CC1NP                                                     TIM_CCER_CC1NP_Msk
#define TIM_CCER_CC1NE_Pos                                                 (2UL)		/*!<TIM CCER: CC1NE (Bit 2) */
#define TIM_CCER_CC1NE_Msk                                                 (0x4UL)		/*!< TIM CCER: CC1NE (Bitfield-Mask: 0x01) */
#define TIM_CCER_CC1NE                                                     TIM_CCER_CC1NE_Msk
#define TIM_CCER_CC1P_Pos                                                  (1UL)		/*!<TIM CCER: CC1P (Bit 1) */
#define TIM_CCER_CC1P_Msk                                                  (0x2UL)		/*!< TIM CCER: CC1P (Bitfield-Mask: 0x01) */
#define TIM_CCER_CC1P                                                      TIM_CCER_CC1P_Msk
#define TIM_CCER_CC1E_Pos                                                  (0UL)		/*!<TIM CCER: CC1E (Bit 0) */
#define TIM_CCER_CC1E_Msk                                                  (0x1UL)		/*!< TIM CCER: CC1E (Bitfield-Mask: 0x01) */
#define TIM_CCER_CC1E                                                      TIM_CCER_CC1E_Msk

/* =====================================================    CNT    ===================================================== */ 
#define TIM_CNT_UIFCPY_Pos                                                 (31UL)		/*!<TIM CNT: UIFCPY (Bit 31) */
#define TIM_CNT_UIFCPY_Msk                                                 (0x80000000UL)		/*!< TIM CNT: UIFCPY (Bitfield-Mask: 0x01) */
#define TIM_CNT_UIFCPY                                                     TIM_CNT_UIFCPY_Msk
#define TIM_CNT_CNT_Pos                                                    (0UL)		/*!<TIM CNT: CNT (Bit 0) */
#define TIM_CNT_CNT_Msk                                                    (0xffffUL)		/*!< TIM CNT: CNT (Bitfield-Mask: 0xffff) */
#define TIM_CNT_CNT                                                        TIM_CNT_CNT_Msk
#define TIM_CNT_CNT_0                                                      (0x1U << TIM_CNT_CNT_Pos)
#define TIM_CNT_CNT_1                                                      (0x2U << TIM_CNT_CNT_Pos)
#define TIM_CNT_CNT_2                                                      (0x4U << TIM_CNT_CNT_Pos)
#define TIM_CNT_CNT_3                                                      (0x8U << TIM_CNT_CNT_Pos)
#define TIM_CNT_CNT_4                                                      (0x10U << TIM_CNT_CNT_Pos)
#define TIM_CNT_CNT_5                                                      (0x20U << TIM_CNT_CNT_Pos)
#define TIM_CNT_CNT_6                                                      (0x40U << TIM_CNT_CNT_Pos)
#define TIM_CNT_CNT_7                                                      (0x80U << TIM_CNT_CNT_Pos)
#define TIM_CNT_CNT_8                                                      (0x100U << TIM_CNT_CNT_Pos)
#define TIM_CNT_CNT_9                                                      (0x200U << TIM_CNT_CNT_Pos)
#define TIM_CNT_CNT_10                                                     (0x400U << TIM_CNT_CNT_Pos)
#define TIM_CNT_CNT_11                                                     (0x800U << TIM_CNT_CNT_Pos)
#define TIM_CNT_CNT_12                                                     (0x1000U << TIM_CNT_CNT_Pos)
#define TIM_CNT_CNT_13                                                     (0x2000U << TIM_CNT_CNT_Pos)
#define TIM_CNT_CNT_14                                                     (0x4000U << TIM_CNT_CNT_Pos)
#define TIM_CNT_CNT_15                                                     (0x8000U << TIM_CNT_CNT_Pos)

/* =====================================================    PSC    ===================================================== */ 
#define TIM_PSC_PSC_Pos                                                    (0UL)		/*!<TIM PSC: PSC (Bit 0) */
#define TIM_PSC_PSC_Msk                                                    (0xffffUL)		/*!< TIM PSC: PSC (Bitfield-Mask: 0xffff) */
#define TIM_PSC_PSC                                                        TIM_PSC_PSC_Msk
#define TIM_PSC_PSC_0                                                      (0x1U << TIM_PSC_PSC_Pos)
#define TIM_PSC_PSC_1                                                      (0x2U << TIM_PSC_PSC_Pos)
#define TIM_PSC_PSC_2                                                      (0x4U << TIM_PSC_PSC_Pos)
#define TIM_PSC_PSC_3                                                      (0x8U << TIM_PSC_PSC_Pos)
#define TIM_PSC_PSC_4                                                      (0x10U << TIM_PSC_PSC_Pos)
#define TIM_PSC_PSC_5                                                      (0x20U << TIM_PSC_PSC_Pos)
#define TIM_PSC_PSC_6                                                      (0x40U << TIM_PSC_PSC_Pos)
#define TIM_PSC_PSC_7                                                      (0x80U << TIM_PSC_PSC_Pos)
#define TIM_PSC_PSC_8                                                      (0x100U << TIM_PSC_PSC_Pos)
#define TIM_PSC_PSC_9                                                      (0x200U << TIM_PSC_PSC_Pos)
#define TIM_PSC_PSC_10                                                     (0x400U << TIM_PSC_PSC_Pos)
#define TIM_PSC_PSC_11                                                     (0x800U << TIM_PSC_PSC_Pos)
#define TIM_PSC_PSC_12                                                     (0x1000U << TIM_PSC_PSC_Pos)
#define TIM_PSC_PSC_13                                                     (0x2000U << TIM_PSC_PSC_Pos)
#define TIM_PSC_PSC_14                                                     (0x4000U << TIM_PSC_PSC_Pos)
#define TIM_PSC_PSC_15                                                     (0x8000U << TIM_PSC_PSC_Pos)

/* =====================================================    ARR    ===================================================== */ 
#define TIM_ARR_ARR_Pos                                                    (0UL)		/*!<TIM ARR: ARR (Bit 0) */
#define TIM_ARR_ARR_Msk                                                    (0xffffUL)		/*!< TIM ARR: ARR (Bitfield-Mask: 0xffff) */
#define TIM_ARR_ARR                                                        TIM_ARR_ARR_Msk
#define TIM_ARR_ARR_0                                                      (0x1U << TIM_ARR_ARR_Pos)
#define TIM_ARR_ARR_1                                                      (0x2U << TIM_ARR_ARR_Pos)
#define TIM_ARR_ARR_2                                                      (0x4U << TIM_ARR_ARR_Pos)
#define TIM_ARR_ARR_3                                                      (0x8U << TIM_ARR_ARR_Pos)
#define TIM_ARR_ARR_4                                                      (0x10U << TIM_ARR_ARR_Pos)
#define TIM_ARR_ARR_5                                                      (0x20U << TIM_ARR_ARR_Pos)
#define TIM_ARR_ARR_6                                                      (0x40U << TIM_ARR_ARR_Pos)
#define TIM_ARR_ARR_7                                                      (0x80U << TIM_ARR_ARR_Pos)
#define TIM_ARR_ARR_8                                                      (0x100U << TIM_ARR_ARR_Pos)
#define TIM_ARR_ARR_9                                                      (0x200U << TIM_ARR_ARR_Pos)
#define TIM_ARR_ARR_10                                                     (0x400U << TIM_ARR_ARR_Pos)
#define TIM_ARR_ARR_11                                                     (0x800U << TIM_ARR_ARR_Pos)
#define TIM_ARR_ARR_12                                                     (0x1000U << TIM_ARR_ARR_Pos)
#define TIM_ARR_ARR_13                                                     (0x2000U << TIM_ARR_ARR_Pos)
#define TIM_ARR_ARR_14                                                     (0x4000U << TIM_ARR_ARR_Pos)
#define TIM_ARR_ARR_15                                                     (0x8000U << TIM_ARR_ARR_Pos)

/* =====================================================    RCR    ===================================================== */ 
#define TIM_RCR_REP_Pos                                                    (0UL)		/*!<TIM RCR: REP (Bit 0) */
#define TIM_RCR_REP_Msk                                                    (0xffffUL)		/*!< TIM RCR: REP (Bitfield-Mask: 0xffff) */
#define TIM_RCR_REP                                                        TIM_RCR_REP_Msk
#define TIM_RCR_REP_0                                                      (0x1U << TIM_RCR_REP_Pos)
#define TIM_RCR_REP_1                                                      (0x2U << TIM_RCR_REP_Pos)
#define TIM_RCR_REP_2                                                      (0x4U << TIM_RCR_REP_Pos)
#define TIM_RCR_REP_3                                                      (0x8U << TIM_RCR_REP_Pos)
#define TIM_RCR_REP_4                                                      (0x10U << TIM_RCR_REP_Pos)
#define TIM_RCR_REP_5                                                      (0x20U << TIM_RCR_REP_Pos)
#define TIM_RCR_REP_6                                                      (0x40U << TIM_RCR_REP_Pos)
#define TIM_RCR_REP_7                                                      (0x80U << TIM_RCR_REP_Pos)
#define TIM_RCR_REP_8                                                      (0x100U << TIM_RCR_REP_Pos)
#define TIM_RCR_REP_9                                                      (0x200U << TIM_RCR_REP_Pos)
#define TIM_RCR_REP_10                                                     (0x400U << TIM_RCR_REP_Pos)
#define TIM_RCR_REP_11                                                     (0x800U << TIM_RCR_REP_Pos)
#define TIM_RCR_REP_12                                                     (0x1000U << TIM_RCR_REP_Pos)
#define TIM_RCR_REP_13                                                     (0x2000U << TIM_RCR_REP_Pos)
#define TIM_RCR_REP_14                                                     (0x4000U << TIM_RCR_REP_Pos)
#define TIM_RCR_REP_15                                                     (0x8000U << TIM_RCR_REP_Pos)

/* =====================================================    CCR1    ===================================================== */ 
#define TIM_CCR1_CCR1_Pos                                                  (0UL)		/*!<TIM CCR1: CCR1 (Bit 0) */
#define TIM_CCR1_CCR1_Msk                                                  (0xffffUL)		/*!< TIM CCR1: CCR1 (Bitfield-Mask: 0xffff) */
#define TIM_CCR1_CCR1                                                      TIM_CCR1_CCR1_Msk
#define TIM_CCR1_CCR1_0                                                    (0x1U << TIM_CCR1_CCR1_Pos)
#define TIM_CCR1_CCR1_1                                                    (0x2U << TIM_CCR1_CCR1_Pos)
#define TIM_CCR1_CCR1_2                                                    (0x4U << TIM_CCR1_CCR1_Pos)
#define TIM_CCR1_CCR1_3                                                    (0x8U << TIM_CCR1_CCR1_Pos)
#define TIM_CCR1_CCR1_4                                                    (0x10U << TIM_CCR1_CCR1_Pos)
#define TIM_CCR1_CCR1_5                                                    (0x20U << TIM_CCR1_CCR1_Pos)
#define TIM_CCR1_CCR1_6                                                    (0x40U << TIM_CCR1_CCR1_Pos)
#define TIM_CCR1_CCR1_7                                                    (0x80U << TIM_CCR1_CCR1_Pos)
#define TIM_CCR1_CCR1_8                                                    (0x100U << TIM_CCR1_CCR1_Pos)
#define TIM_CCR1_CCR1_9                                                    (0x200U << TIM_CCR1_CCR1_Pos)
#define TIM_CCR1_CCR1_10                                                   (0x400U << TIM_CCR1_CCR1_Pos)
#define TIM_CCR1_CCR1_11                                                   (0x800U << TIM_CCR1_CCR1_Pos)
#define TIM_CCR1_CCR1_12                                                   (0x1000U << TIM_CCR1_CCR1_Pos)
#define TIM_CCR1_CCR1_13                                                   (0x2000U << TIM_CCR1_CCR1_Pos)
#define TIM_CCR1_CCR1_14                                                   (0x4000U << TIM_CCR1_CCR1_Pos)
#define TIM_CCR1_CCR1_15                                                   (0x8000U << TIM_CCR1_CCR1_Pos)

/* =====================================================    CCR2    ===================================================== */ 
#define TIM_CCR2_CCR2_Pos                                                  (0UL)		/*!<TIM CCR2: CCR2 (Bit 0) */
#define TIM_CCR2_CCR2_Msk                                                  (0xffffUL)		/*!< TIM CCR2: CCR2 (Bitfield-Mask: 0xffff) */
#define TIM_CCR2_CCR2                                                      TIM_CCR2_CCR2_Msk
#define TIM_CCR2_CCR2_0                                                    (0x1U << TIM_CCR2_CCR2_Pos)
#define TIM_CCR2_CCR2_1                                                    (0x2U << TIM_CCR2_CCR2_Pos)
#define TIM_CCR2_CCR2_2                                                    (0x4U << TIM_CCR2_CCR2_Pos)
#define TIM_CCR2_CCR2_3                                                    (0x8U << TIM_CCR2_CCR2_Pos)
#define TIM_CCR2_CCR2_4                                                    (0x10U << TIM_CCR2_CCR2_Pos)
#define TIM_CCR2_CCR2_5                                                    (0x20U << TIM_CCR2_CCR2_Pos)
#define TIM_CCR2_CCR2_6                                                    (0x40U << TIM_CCR2_CCR2_Pos)
#define TIM_CCR2_CCR2_7                                                    (0x80U << TIM_CCR2_CCR2_Pos)
#define TIM_CCR2_CCR2_8                                                    (0x100U << TIM_CCR2_CCR2_Pos)
#define TIM_CCR2_CCR2_9                                                    (0x200U << TIM_CCR2_CCR2_Pos)
#define TIM_CCR2_CCR2_10                                                   (0x400U << TIM_CCR2_CCR2_Pos)
#define TIM_CCR2_CCR2_11                                                   (0x800U << TIM_CCR2_CCR2_Pos)
#define TIM_CCR2_CCR2_12                                                   (0x1000U << TIM_CCR2_CCR2_Pos)
#define TIM_CCR2_CCR2_13                                                   (0x2000U << TIM_CCR2_CCR2_Pos)
#define TIM_CCR2_CCR2_14                                                   (0x4000U << TIM_CCR2_CCR2_Pos)
#define TIM_CCR2_CCR2_15                                                   (0x8000U << TIM_CCR2_CCR2_Pos)

/* =====================================================    CCR3    ===================================================== */ 
#define TIM_CCR3_CCR3_Pos                                                  (0UL)		/*!<TIM CCR3: CCR3 (Bit 0) */
#define TIM_CCR3_CCR3_Msk                                                  (0xffffUL)		/*!< TIM CCR3: CCR3 (Bitfield-Mask: 0xffff) */
#define TIM_CCR3_CCR3                                                      TIM_CCR3_CCR3_Msk
#define TIM_CCR3_CCR3_0                                                    (0x1U << TIM_CCR3_CCR3_Pos)
#define TIM_CCR3_CCR3_1                                                    (0x2U << TIM_CCR3_CCR3_Pos)
#define TIM_CCR3_CCR3_2                                                    (0x4U << TIM_CCR3_CCR3_Pos)
#define TIM_CCR3_CCR3_3                                                    (0x8U << TIM_CCR3_CCR3_Pos)
#define TIM_CCR3_CCR3_4                                                    (0x10U << TIM_CCR3_CCR3_Pos)
#define TIM_CCR3_CCR3_5                                                    (0x20U << TIM_CCR3_CCR3_Pos)
#define TIM_CCR3_CCR3_6                                                    (0x40U << TIM_CCR3_CCR3_Pos)
#define TIM_CCR3_CCR3_7                                                    (0x80U << TIM_CCR3_CCR3_Pos)
#define TIM_CCR3_CCR3_8                                                    (0x100U << TIM_CCR3_CCR3_Pos)
#define TIM_CCR3_CCR3_9                                                    (0x200U << TIM_CCR3_CCR3_Pos)
#define TIM_CCR3_CCR3_10                                                   (0x400U << TIM_CCR3_CCR3_Pos)
#define TIM_CCR3_CCR3_11                                                   (0x800U << TIM_CCR3_CCR3_Pos)
#define TIM_CCR3_CCR3_12                                                   (0x1000U << TIM_CCR3_CCR3_Pos)
#define TIM_CCR3_CCR3_13                                                   (0x2000U << TIM_CCR3_CCR3_Pos)
#define TIM_CCR3_CCR3_14                                                   (0x4000U << TIM_CCR3_CCR3_Pos)
#define TIM_CCR3_CCR3_15                                                   (0x8000U << TIM_CCR3_CCR3_Pos)

/* =====================================================    CCR4    ===================================================== */ 
#define TIM_CCR4_CCR4_Pos                                                  (0UL)		/*!<TIM CCR4: CCR4 (Bit 0) */
#define TIM_CCR4_CCR4_Msk                                                  (0xffffUL)		/*!< TIM CCR4: CCR4 (Bitfield-Mask: 0xffff) */
#define TIM_CCR4_CCR4                                                      TIM_CCR4_CCR4_Msk
#define TIM_CCR4_CCR4_0                                                    (0x1U << TIM_CCR4_CCR4_Pos)
#define TIM_CCR4_CCR4_1                                                    (0x2U << TIM_CCR4_CCR4_Pos)
#define TIM_CCR4_CCR4_2                                                    (0x4U << TIM_CCR4_CCR4_Pos)
#define TIM_CCR4_CCR4_3                                                    (0x8U << TIM_CCR4_CCR4_Pos)
#define TIM_CCR4_CCR4_4                                                    (0x10U << TIM_CCR4_CCR4_Pos)
#define TIM_CCR4_CCR4_5                                                    (0x20U << TIM_CCR4_CCR4_Pos)
#define TIM_CCR4_CCR4_6                                                    (0x40U << TIM_CCR4_CCR4_Pos)
#define TIM_CCR4_CCR4_7                                                    (0x80U << TIM_CCR4_CCR4_Pos)
#define TIM_CCR4_CCR4_8                                                    (0x100U << TIM_CCR4_CCR4_Pos)
#define TIM_CCR4_CCR4_9                                                    (0x200U << TIM_CCR4_CCR4_Pos)
#define TIM_CCR4_CCR4_10                                                   (0x400U << TIM_CCR4_CCR4_Pos)
#define TIM_CCR4_CCR4_11                                                   (0x800U << TIM_CCR4_CCR4_Pos)
#define TIM_CCR4_CCR4_12                                                   (0x1000U << TIM_CCR4_CCR4_Pos)
#define TIM_CCR4_CCR4_13                                                   (0x2000U << TIM_CCR4_CCR4_Pos)
#define TIM_CCR4_CCR4_14                                                   (0x4000U << TIM_CCR4_CCR4_Pos)
#define TIM_CCR4_CCR4_15                                                   (0x8000U << TIM_CCR4_CCR4_Pos)

/* =====================================================    BDTR    ===================================================== */ 
#define TIM_BDTR_BK2P_Pos                                                  (25UL)		/*!<TIM BDTR: BK2P (Bit 25) */
#define TIM_BDTR_BK2P_Msk                                                  (0x2000000UL)		/*!< TIM BDTR: BK2P (Bitfield-Mask: 0x01) */
#define TIM_BDTR_BK2P                                                      TIM_BDTR_BK2P_Msk
#define TIM_BDTR_BK2E_Pos                                                  (24UL)		/*!<TIM BDTR: BK2E (Bit 24) */
#define TIM_BDTR_BK2E_Msk                                                  (0x1000000UL)		/*!< TIM BDTR: BK2E (Bitfield-Mask: 0x01) */
#define TIM_BDTR_BK2E                                                      TIM_BDTR_BK2E_Msk
#define TIM_BDTR_BK2F_Pos                                                  (20UL)		/*!<TIM BDTR: BK2F (Bit 20) */
#define TIM_BDTR_BK2F_Msk                                                  (0xf00000UL)		/*!< TIM BDTR: BK2F (Bitfield-Mask: 0x0f) */
#define TIM_BDTR_BK2F                                                      TIM_BDTR_BK2F_Msk
#define TIM_BDTR_BK2F_0                                                    (0x1U << TIM_BDTR_BK2F_Pos)
#define TIM_BDTR_BK2F_1                                                    (0x2U << TIM_BDTR_BK2F_Pos)
#define TIM_BDTR_BK2F_2                                                    (0x4U << TIM_BDTR_BK2F_Pos)
#define TIM_BDTR_BK2F_3                                                    (0x8U << TIM_BDTR_BK2F_Pos)
#define TIM_BDTR_BKF_Pos                                                   (16UL)		/*!<TIM BDTR: BKF (Bit 16) */
#define TIM_BDTR_BKF_Msk                                                   (0xf0000UL)		/*!< TIM BDTR: BKF (Bitfield-Mask: 0x0f) */
#define TIM_BDTR_BKF                                                       TIM_BDTR_BKF_Msk
#define TIM_BDTR_BKF_0                                                     (0x1U << TIM_BDTR_BKF_Pos)
#define TIM_BDTR_BKF_1                                                     (0x2U << TIM_BDTR_BKF_Pos)
#define TIM_BDTR_BKF_2                                                     (0x4U << TIM_BDTR_BKF_Pos)
#define TIM_BDTR_BKF_3                                                     (0x8U << TIM_BDTR_BKF_Pos)
#define TIM_BDTR_MOE_Pos                                                   (15UL)		/*!<TIM BDTR: MOE (Bit 15) */
#define TIM_BDTR_MOE_Msk                                                   (0x8000UL)		/*!< TIM BDTR: MOE (Bitfield-Mask: 0x01) */
#define TIM_BDTR_MOE                                                       TIM_BDTR_MOE_Msk
#define TIM_BDTR_AOE_Pos                                                   (14UL)		/*!<TIM BDTR: AOE (Bit 14) */
#define TIM_BDTR_AOE_Msk                                                   (0x4000UL)		/*!< TIM BDTR: AOE (Bitfield-Mask: 0x01) */
#define TIM_BDTR_AOE                                                       TIM_BDTR_AOE_Msk
#define TIM_BDTR_BKP_Pos                                                   (13UL)		/*!<TIM BDTR: BKP (Bit 13) */
#define TIM_BDTR_BKP_Msk                                                   (0x2000UL)		/*!< TIM BDTR: BKP (Bitfield-Mask: 0x01) */
#define TIM_BDTR_BKP                                                       TIM_BDTR_BKP_Msk
#define TIM_BDTR_BKE_Pos                                                   (12UL)		/*!<TIM BDTR: BKE (Bit 12) */
#define TIM_BDTR_BKE_Msk                                                   (0x1000UL)		/*!< TIM BDTR: BKE (Bitfield-Mask: 0x01) */
#define TIM_BDTR_BKE                                                       TIM_BDTR_BKE_Msk
#define TIM_BDTR_OSSR_Pos                                                  (11UL)		/*!<TIM BDTR: OSSR (Bit 11) */
#define TIM_BDTR_OSSR_Msk                                                  (0x800UL)		/*!< TIM BDTR: OSSR (Bitfield-Mask: 0x01) */
#define TIM_BDTR_OSSR                                                      TIM_BDTR_OSSR_Msk
#define TIM_BDTR_OSSI_Pos                                                  (10UL)		/*!<TIM BDTR: OSSI (Bit 10) */
#define TIM_BDTR_OSSI_Msk                                                  (0x400UL)		/*!< TIM BDTR: OSSI (Bitfield-Mask: 0x01) */
#define TIM_BDTR_OSSI                                                      TIM_BDTR_OSSI_Msk
#define TIM_BDTR_LOCK_Pos                                                  (8UL)		/*!<TIM BDTR: LOCK (Bit 8) */
#define TIM_BDTR_LOCK_Msk                                                  (0x300UL)		/*!< TIM BDTR: LOCK (Bitfield-Mask: 0x03) */
#define TIM_BDTR_LOCK                                                      TIM_BDTR_LOCK_Msk
#define TIM_BDTR_LOCK_0                                                    (0x1U << TIM_BDTR_LOCK_Pos)
#define TIM_BDTR_LOCK_1                                                    (0x2U << TIM_BDTR_LOCK_Pos)
#define TIM_BDTR_DTG_Pos                                                   (0UL)		/*!<TIM BDTR: DTG (Bit 0) */
#define TIM_BDTR_DTG_Msk                                                   (0xffUL)		/*!< TIM BDTR: DTG (Bitfield-Mask: 0xff) */
#define TIM_BDTR_DTG                                                       TIM_BDTR_DTG_Msk
#define TIM_BDTR_DTG_0                                                     (0x1U << TIM_BDTR_DTG_Pos)
#define TIM_BDTR_DTG_1                                                     (0x2U << TIM_BDTR_DTG_Pos)
#define TIM_BDTR_DTG_2                                                     (0x4U << TIM_BDTR_DTG_Pos)
#define TIM_BDTR_DTG_3                                                     (0x8U << TIM_BDTR_DTG_Pos)
#define TIM_BDTR_DTG_4                                                     (0x10U << TIM_BDTR_DTG_Pos)
#define TIM_BDTR_DTG_5                                                     (0x20U << TIM_BDTR_DTG_Pos)
#define TIM_BDTR_DTG_6                                                     (0x40U << TIM_BDTR_DTG_Pos)
#define TIM_BDTR_DTG_7                                                     (0x80U << TIM_BDTR_DTG_Pos)

/* =====================================================    CCMR3    ===================================================== */ 
#define TIM_CCMR3_OC6CE_Pos                                                (15UL)		/*!<TIM CCMR3: OC6CE (Bit 15) */
#define TIM_CCMR3_OC6CE_Msk                                                (0x8000UL)		/*!< TIM CCMR3: OC6CE (Bitfield-Mask: 0x01) */
#define TIM_CCMR3_OC6CE                                                    TIM_CCMR3_OC6CE_Msk
#define TIM_CCMR3_OC6M_Pos                                                 (12UL)		/*!<TIM CCMR3: OC6M (Bit 12) */
#define TIM_CCMR3_OC6M_Msk                                                 (0x1007000UL)		/*!< TIM CCMR3: OC6M (Bitfield-Mask: 0x1007) */
#define TIM_CCMR3_OC6M                                                     TIM_CCMR3_OC6M_Msk
#define TIM_CCMR3_OC6M_0                                                   (0x1U << TIM_CCMR3_OC6M_Pos)
#define TIM_CCMR3_OC6M_1                                                   (0x2U << TIM_CCMR3_OC6M_Pos)
#define TIM_CCMR3_OC6M_2                                                   (0x4U << TIM_CCMR3_OC6M_Pos)
#define TIM_CCMR3_OC6M_3                                                   (0x1000U << TIM_CCMR3_OC6M_Pos)
#define TIM_CCMR3_OC6PE_Pos                                                (11UL)		/*!<TIM CCMR3: OC6PE (Bit 11) */
#define TIM_CCMR3_OC6PE_Msk                                                (0x800UL)		/*!< TIM CCMR3: OC6PE (Bitfield-Mask: 0x01) */
#define TIM_CCMR3_OC6PE                                                    TIM_CCMR3_OC6PE_Msk
#define TIM_CCMR3_OC6FE_Pos                                                (10UL)		/*!<TIM CCMR3: OC6FE (Bit 10) */
#define TIM_CCMR3_OC6FE_Msk                                                (0x400UL)		/*!< TIM CCMR3: OC6FE (Bitfield-Mask: 0x01) */
#define TIM_CCMR3_OC6FE                                                    TIM_CCMR3_OC6FE_Msk
#define TIM_CCMR3_OC5CE_Pos                                                (7UL)		/*!<TIM CCMR3: OC5CE (Bit 7) */
#define TIM_CCMR3_OC5CE_Msk                                                (0x80UL)		/*!< TIM CCMR3: OC5CE (Bitfield-Mask: 0x01) */
#define TIM_CCMR3_OC5CE                                                    TIM_CCMR3_OC5CE_Msk
#define TIM_CCMR3_OC5M_Pos                                                 (4UL)		/*!<TIM CCMR3: OC5M (Bit 4) */
#define TIM_CCMR3_OC5M_Msk                                                 (0x10070UL)		/*!< TIM CCMR3: OC5M (Bitfield-Mask: 0x1007) */
#define TIM_CCMR3_OC5M                                                     TIM_CCMR3_OC5M_Msk
#define TIM_CCMR3_OC5M_0                                                   (0x1U << TIM_CCMR3_OC5M_Pos)
#define TIM_CCMR3_OC5M_1                                                   (0x2U << TIM_CCMR3_OC5M_Pos)
#define TIM_CCMR3_OC5M_2                                                   (0x4U << TIM_CCMR3_OC5M_Pos)
#define TIM_CCMR3_OC5M_3                                                   (0x1000U << TIM_CCMR3_OC5M_Pos)
#define TIM_CCMR3_OC5PE_Pos                                                (3UL)		/*!<TIM CCMR3: OC5PE (Bit 3) */
#define TIM_CCMR3_OC5PE_Msk                                                (0x8UL)		/*!< TIM CCMR3: OC5PE (Bitfield-Mask: 0x01) */
#define TIM_CCMR3_OC5PE                                                    TIM_CCMR3_OC5PE_Msk
#define TIM_CCMR3_OC5FE_Pos                                                (2UL)		/*!<TIM CCMR3: OC5FE (Bit 2) */
#define TIM_CCMR3_OC5FE_Msk                                                (0x4UL)		/*!< TIM CCMR3: OC5FE (Bitfield-Mask: 0x01) */
#define TIM_CCMR3_OC5FE                                                    TIM_CCMR3_OC5FE_Msk

/* =====================================================    CCR5    ===================================================== */ 
#define TIM_CCR5_GC5C3_Pos                                                 (31UL)		/*!<TIM CCR5: GC5C3 (Bit 31) */
#define TIM_CCR5_GC5C3_Msk                                                 (0x80000000UL)		/*!< TIM CCR5: GC5C3 (Bitfield-Mask: 0x01) */
#define TIM_CCR5_GC5C3                                                     TIM_CCR5_GC5C3_Msk
#define TIM_CCR5_GC5C2_Pos                                                 (30UL)		/*!<TIM CCR5: GC5C2 (Bit 30) */
#define TIM_CCR5_GC5C2_Msk                                                 (0x40000000UL)		/*!< TIM CCR5: GC5C2 (Bitfield-Mask: 0x01) */
#define TIM_CCR5_GC5C2                                                     TIM_CCR5_GC5C2_Msk
#define TIM_CCR5_GC5C1_Pos                                                 (29UL)		/*!<TIM CCR5: GC5C1 (Bit 29) */
#define TIM_CCR5_GC5C1_Msk                                                 (0x20000000UL)		/*!< TIM CCR5: GC5C1 (Bitfield-Mask: 0x01) */
#define TIM_CCR5_GC5C1                                                     TIM_CCR5_GC5C1_Msk
#define TIM_CCR5_CCR5_Pos                                                  (0UL)		/*!<TIM CCR5: CCR5 (Bit 0) */
#define TIM_CCR5_CCR5_Msk                                                  (0xffffUL)		/*!< TIM CCR5: CCR5 (Bitfield-Mask: 0xffff) */
#define TIM_CCR5_CCR5                                                      TIM_CCR5_CCR5_Msk
#define TIM_CCR5_CCR5_0                                                    (0x1U << TIM_CCR5_CCR5_Pos)
#define TIM_CCR5_CCR5_1                                                    (0x2U << TIM_CCR5_CCR5_Pos)
#define TIM_CCR5_CCR5_2                                                    (0x4U << TIM_CCR5_CCR5_Pos)
#define TIM_CCR5_CCR5_3                                                    (0x8U << TIM_CCR5_CCR5_Pos)
#define TIM_CCR5_CCR5_4                                                    (0x10U << TIM_CCR5_CCR5_Pos)
#define TIM_CCR5_CCR5_5                                                    (0x20U << TIM_CCR5_CCR5_Pos)
#define TIM_CCR5_CCR5_6                                                    (0x40U << TIM_CCR5_CCR5_Pos)
#define TIM_CCR5_CCR5_7                                                    (0x80U << TIM_CCR5_CCR5_Pos)
#define TIM_CCR5_CCR5_8                                                    (0x100U << TIM_CCR5_CCR5_Pos)
#define TIM_CCR5_CCR5_9                                                    (0x200U << TIM_CCR5_CCR5_Pos)
#define TIM_CCR5_CCR5_10                                                   (0x400U << TIM_CCR5_CCR5_Pos)
#define TIM_CCR5_CCR5_11                                                   (0x800U << TIM_CCR5_CCR5_Pos)
#define TIM_CCR5_CCR5_12                                                   (0x1000U << TIM_CCR5_CCR5_Pos)
#define TIM_CCR5_CCR5_13                                                   (0x2000U << TIM_CCR5_CCR5_Pos)
#define TIM_CCR5_CCR5_14                                                   (0x4000U << TIM_CCR5_CCR5_Pos)
#define TIM_CCR5_CCR5_15                                                   (0x8000U << TIM_CCR5_CCR5_Pos)

/* =====================================================    CCR6    ===================================================== */ 
#define TIM_CCR6_CCR6_Pos                                                  (0UL)		/*!<TIM CCR6: CCR6 (Bit 0) */
#define TIM_CCR6_CCR6_Msk                                                  (0xffffUL)		/*!< TIM CCR6: CCR6 (Bitfield-Mask: 0xffff) */
#define TIM_CCR6_CCR6                                                      TIM_CCR6_CCR6_Msk
#define TIM_CCR6_CCR6_0                                                    (0x1U << TIM_CCR6_CCR6_Pos)
#define TIM_CCR6_CCR6_1                                                    (0x2U << TIM_CCR6_CCR6_Pos)
#define TIM_CCR6_CCR6_2                                                    (0x4U << TIM_CCR6_CCR6_Pos)
#define TIM_CCR6_CCR6_3                                                    (0x8U << TIM_CCR6_CCR6_Pos)
#define TIM_CCR6_CCR6_4                                                    (0x10U << TIM_CCR6_CCR6_Pos)
#define TIM_CCR6_CCR6_5                                                    (0x20U << TIM_CCR6_CCR6_Pos)
#define TIM_CCR6_CCR6_6                                                    (0x40U << TIM_CCR6_CCR6_Pos)
#define TIM_CCR6_CCR6_7                                                    (0x80U << TIM_CCR6_CCR6_Pos)
#define TIM_CCR6_CCR6_8                                                    (0x100U << TIM_CCR6_CCR6_Pos)
#define TIM_CCR6_CCR6_9                                                    (0x200U << TIM_CCR6_CCR6_Pos)
#define TIM_CCR6_CCR6_10                                                   (0x400U << TIM_CCR6_CCR6_Pos)
#define TIM_CCR6_CCR6_11                                                   (0x800U << TIM_CCR6_CCR6_Pos)
#define TIM_CCR6_CCR6_12                                                   (0x1000U << TIM_CCR6_CCR6_Pos)
#define TIM_CCR6_CCR6_13                                                   (0x2000U << TIM_CCR6_CCR6_Pos)
#define TIM_CCR6_CCR6_14                                                   (0x4000U << TIM_CCR6_CCR6_Pos)
#define TIM_CCR6_CCR6_15                                                   (0x8000U << TIM_CCR6_CCR6_Pos)

/* =====================================================    AF1    ===================================================== */ 
#define TIM_AF1_BKCMP2P_Pos                                                (11UL)		/*!<TIM AF1: BKCMP2P (Bit 11) */
#define TIM_AF1_BKCMP2P_Msk                                                (0x800UL)		/*!< TIM AF1: BKCMP2P (Bitfield-Mask: 0x01) */
#define TIM_AF1_BKCMP2P                                                    TIM_AF1_BKCMP2P_Msk
#define TIM_AF1_BKCMP1P_Pos                                                (10UL)		/*!<TIM AF1: BKCMP1P (Bit 10) */
#define TIM_AF1_BKCMP1P_Msk                                                (0x400UL)		/*!< TIM AF1: BKCMP1P (Bitfield-Mask: 0x01) */
#define TIM_AF1_BKCMP1P                                                    TIM_AF1_BKCMP1P_Msk
#define TIM_AF1_BKINP_Pos                                                  (9UL)		/*!<TIM AF1: BKINP (Bit 9) */
#define TIM_AF1_BKINP_Msk                                                  (0x200UL)		/*!< TIM AF1: BKINP (Bitfield-Mask: 0x01) */
#define TIM_AF1_BKINP                                                      TIM_AF1_BKINP_Msk
#define TIM_AF1_BKCMP2E_Pos                                                (2UL)		/*!<TIM AF1: BKCMP2E (Bit 2) */
#define TIM_AF1_BKCMP2E_Msk                                                (0x4UL)		/*!< TIM AF1: BKCMP2E (Bitfield-Mask: 0x01) */
#define TIM_AF1_BKCMP2E                                                    TIM_AF1_BKCMP2E_Msk
#define TIM_AF1_BKCMP1E_Pos                                                (1UL)		/*!<TIM AF1: BKCMP1E (Bit 1) */
#define TIM_AF1_BKCMP1E_Msk                                                (0x2UL)		/*!< TIM AF1: BKCMP1E (Bitfield-Mask: 0x01) */
#define TIM_AF1_BKCMP1E                                                    TIM_AF1_BKCMP1E_Msk
#define TIM_AF1_BKINE_Pos                                                  (0UL)		/*!<TIM AF1: BKINE (Bit 0) */
#define TIM_AF1_BKINE_Msk                                                  (0x1UL)		/*!< TIM AF1: BKINE (Bitfield-Mask: 0x01) */
#define TIM_AF1_BKINE                                                      TIM_AF1_BKINE_Msk

/* =====================================================    AF2    ===================================================== */ 
#define TIM_AF2_BK2CMP2P_Pos                                               (11UL)		/*!<TIM AF2: BK2CMP2P (Bit 11) */
#define TIM_AF2_BK2CMP2P_Msk                                               (0x800UL)		/*!< TIM AF2: BK2CMP2P (Bitfield-Mask: 0x01) */
#define TIM_AF2_BK2CMP2P                                                   TIM_AF2_BK2CMP2P_Msk
#define TIM_AF2_BK2CMP1P_Pos                                               (10UL)		/*!<TIM AF2: BK2CMP1P (Bit 10) */
#define TIM_AF2_BK2CMP1P_Msk                                               (0x400UL)		/*!< TIM AF2: BK2CMP1P (Bitfield-Mask: 0x01) */
#define TIM_AF2_BK2CMP1P                                                   TIM_AF2_BK2CMP1P_Msk
#define TIM_AF2_BK2INP_Pos                                                 (9UL)		/*!<TIM AF2: BK2INP (Bit 9) */
#define TIM_AF2_BK2INP_Msk                                                 (0x200UL)		/*!< TIM AF2: BK2INP (Bitfield-Mask: 0x01) */
#define TIM_AF2_BK2INP                                                     TIM_AF2_BK2INP_Msk
#define TIM_AF2_BK2CMP2E_Pos                                               (2UL)		/*!<TIM AF2: BK2CMP2E (Bit 2) */
#define TIM_AF2_BK2CMP2E_Msk                                               (0x4UL)		/*!< TIM AF2: BK2CMP2E (Bitfield-Mask: 0x01) */
#define TIM_AF2_BK2CMP2E                                                   TIM_AF2_BK2CMP2E_Msk
#define TIM_AF2_BK2CMP1E_Pos                                               (1UL)		/*!<TIM AF2: BK2CMP1E (Bit 1) */
#define TIM_AF2_BK2CMP1E_Msk                                               (0x2UL)		/*!< TIM AF2: BK2CMP1E (Bitfield-Mask: 0x01) */
#define TIM_AF2_BK2CMP1E                                                   TIM_AF2_BK2CMP1E_Msk
#define TIM_AF2_BK2INE_Pos                                                 (0UL)		/*!<TIM AF2: BK2INE (Bit 0) */
#define TIM_AF2_BK2INE_Msk                                                 (0x1UL)		/*!< TIM AF2: BK2INE (Bitfield-Mask: 0x01) */
#define TIM_AF2_BK2INE                                                     TIM_AF2_BK2INE_Msk


/* =========================================================================================================================== */ 
/*=====================                                      USART                                      ===================== */ 
/* =========================================================================================================================== */ 

/* =====================================================    CR1    ===================================================== */ 
#define USART_CR1_RXFFIE_Pos                                               (31UL)		/*!<USART CR1: RXFFIE (Bit 31) */
#define USART_CR1_RXFFIE_Msk                                               (0x80000000UL)		/*!< USART CR1: RXFFIE (Bitfield-Mask: 0x01) */
#define USART_CR1_RXFFIE                                                   USART_CR1_RXFFIE_Msk
#define USART_CR1_TXFEIE_Pos                                               (30UL)		/*!<USART CR1: TXFEIE (Bit 30) */
#define USART_CR1_TXFEIE_Msk                                               (0x40000000UL)		/*!< USART CR1: TXFEIE (Bitfield-Mask: 0x01) */
#define USART_CR1_TXFEIE                                                   USART_CR1_TXFEIE_Msk
#define USART_CR1_FIFOEN_Pos                                               (29UL)		/*!<USART CR1: FIFOEN (Bit 29) */
#define USART_CR1_FIFOEN_Msk                                               (0x20000000UL)		/*!< USART CR1: FIFOEN (Bitfield-Mask: 0x01) */
#define USART_CR1_FIFOEN                                                   USART_CR1_FIFOEN_Msk
#define USART_CR1_EOBIE_Pos                                                (27UL)		/*!<USART CR1: EOBIE (Bit 27) */
#define USART_CR1_EOBIE_Msk                                                (0x8000000UL)		/*!< USART CR1: EOBIE (Bitfield-Mask: 0x01) */
#define USART_CR1_EOBIE                                                    USART_CR1_EOBIE_Msk
#define USART_CR1_RTOIE_Pos                                                (26UL)		/*!<USART CR1: RTOIE (Bit 26) */
#define USART_CR1_RTOIE_Msk                                                (0x4000000UL)		/*!< USART CR1: RTOIE (Bitfield-Mask: 0x01) */
#define USART_CR1_RTOIE                                                    USART_CR1_RTOIE_Msk
#define USART_CR1_DEAT_Pos                                                 (21UL)		/*!<USART CR1: DEAT (Bit 21) */
#define USART_CR1_DEAT_Msk                                                 (0x3e00000UL)		/*!< USART CR1: DEAT (Bitfield-Mask: 0x1f) */
#define USART_CR1_DEAT                                                     USART_CR1_DEAT_Msk
#define USART_CR1_DEAT_0                                                   (0x1U << USART_CR1_DEAT_Pos)
#define USART_CR1_DEAT_1                                                   (0x2U << USART_CR1_DEAT_Pos)
#define USART_CR1_DEAT_2                                                   (0x4U << USART_CR1_DEAT_Pos)
#define USART_CR1_DEAT_3                                                   (0x8U << USART_CR1_DEAT_Pos)
#define USART_CR1_DEAT_4                                                   (0x10U << USART_CR1_DEAT_Pos)
#define USART_CR1_DEDT_Pos                                                 (16UL)		/*!<USART CR1: DEDT (Bit 16) */
#define USART_CR1_DEDT_Msk                                                 (0x1f0000UL)		/*!< USART CR1: DEDT (Bitfield-Mask: 0x1f) */
#define USART_CR1_DEDT                                                     USART_CR1_DEDT_Msk
#define USART_CR1_DEDT_0                                                   (0x1U << USART_CR1_DEDT_Pos)
#define USART_CR1_DEDT_1                                                   (0x2U << USART_CR1_DEDT_Pos)
#define USART_CR1_DEDT_2                                                   (0x4U << USART_CR1_DEDT_Pos)
#define USART_CR1_DEDT_3                                                   (0x8U << USART_CR1_DEDT_Pos)
#define USART_CR1_DEDT_4                                                   (0x10U << USART_CR1_DEDT_Pos)
#define USART_CR1_OVER8_Pos                                                (15UL)		/*!<USART CR1: OVER8 (Bit 15) */
#define USART_CR1_OVER8_Msk                                                (0x8000UL)		/*!< USART CR1: OVER8 (Bitfield-Mask: 0x01) */
#define USART_CR1_OVER8                                                    USART_CR1_OVER8_Msk
#define USART_CR1_CMIE_Pos                                                 (14UL)		/*!<USART CR1: CMIE (Bit 14) */
#define USART_CR1_CMIE_Msk                                                 (0x4000UL)		/*!< USART CR1: CMIE (Bitfield-Mask: 0x01) */
#define USART_CR1_CMIE                                                     USART_CR1_CMIE_Msk
#define USART_CR1_MME_Pos                                                  (13UL)		/*!<USART CR1: MME (Bit 13) */
#define USART_CR1_MME_Msk                                                  (0x2000UL)		/*!< USART CR1: MME (Bitfield-Mask: 0x01) */
#define USART_CR1_MME                                                      USART_CR1_MME_Msk
#define USART_CR1_M_Pos                                                    (12UL)		/*!<USART CR1: M (Bit 12) */
#define USART_CR1_M_Msk                                                    (0x10001000UL)		/*!< USART CR1: M (Bitfield-Mask: 0x10001) */
#define USART_CR1_M                                                        USART_CR1_M_Msk
#define USART_CR1_M_0                                                      (0x1U << USART_CR1_M_Pos)
#define USART_CR1_M_1                                                      (0x10000U << USART_CR1_M_Pos)
#define USART_CR1_WAKE_Pos                                                 (11UL)		/*!<USART CR1: WAKE (Bit 11) */
#define USART_CR1_WAKE_Msk                                                 (0x800UL)		/*!< USART CR1: WAKE (Bitfield-Mask: 0x01) */
#define USART_CR1_WAKE                                                     USART_CR1_WAKE_Msk
#define USART_CR1_PCE_Pos                                                  (10UL)		/*!<USART CR1: PCE (Bit 10) */
#define USART_CR1_PCE_Msk                                                  (0x400UL)		/*!< USART CR1: PCE (Bitfield-Mask: 0x01) */
#define USART_CR1_PCE                                                      USART_CR1_PCE_Msk
#define USART_CR1_PS_Pos                                                   (9UL)		/*!<USART CR1: PS (Bit 9) */
#define USART_CR1_PS_Msk                                                   (0x200UL)		/*!< USART CR1: PS (Bitfield-Mask: 0x01) */
#define USART_CR1_PS                                                       USART_CR1_PS_Msk
#define USART_CR1_PEIE_Pos                                                 (8UL)		/*!<USART CR1: PEIE (Bit 8) */
#define USART_CR1_PEIE_Msk                                                 (0x100UL)		/*!< USART CR1: PEIE (Bitfield-Mask: 0x01) */
#define USART_CR1_PEIE                                                     USART_CR1_PEIE_Msk
#define USART_CR1_TXEIE_TXFNFIE_Pos                                        (7UL)		/*!<USART CR1: TXEIE_TXFNFIE (Bit 7) */
#define USART_CR1_TXEIE_TXFNFIE_Msk                                        (0x80UL)		/*!< USART CR1: TXEIE_TXFNFIE (Bitfield-Mask: 0x01) */
#define USART_CR1_TXEIE_TXFNFIE                                            USART_CR1_TXEIE_TXFNFIE_Msk
#define USART_CR1_TCIE_Pos                                                 (6UL)		/*!<USART CR1: TCIE (Bit 6) */
#define USART_CR1_TCIE_Msk                                                 (0x40UL)		/*!< USART CR1: TCIE (Bitfield-Mask: 0x01) */
#define USART_CR1_TCIE                                                     USART_CR1_TCIE_Msk
#define USART_CR1_RXNEIE_RXFNEIE_Pos                                       (5UL)		/*!<USART CR1: RXNEIE_RXFNEIE (Bit 5) */
#define USART_CR1_RXNEIE_RXFNEIE_Msk                                       (0x20UL)		/*!< USART CR1: RXNEIE_RXFNEIE (Bitfield-Mask: 0x01) */
#define USART_CR1_RXNEIE_RXFNEIE                                           USART_CR1_RXNEIE_RXFNEIE_Msk
#define USART_CR1_IDLEIE_Pos                                               (4UL)		/*!<USART CR1: IDLEIE (Bit 4) */
#define USART_CR1_IDLEIE_Msk                                               (0x10UL)		/*!< USART CR1: IDLEIE (Bitfield-Mask: 0x01) */
#define USART_CR1_IDLEIE                                                   USART_CR1_IDLEIE_Msk
#define USART_CR1_TE_Pos                                                   (3UL)		/*!<USART CR1: TE (Bit 3) */
#define USART_CR1_TE_Msk                                                   (0x8UL)		/*!< USART CR1: TE (Bitfield-Mask: 0x01) */
#define USART_CR1_TE                                                       USART_CR1_TE_Msk
#define USART_CR1_RE_Pos                                                   (2UL)		/*!<USART CR1: RE (Bit 2) */
#define USART_CR1_RE_Msk                                                   (0x4UL)		/*!< USART CR1: RE (Bitfield-Mask: 0x01) */
#define USART_CR1_RE                                                       USART_CR1_RE_Msk
#define USART_CR1_UE_Pos                                                   (0UL)		/*!<USART CR1: UE (Bit 0) */
#define USART_CR1_UE_Msk                                                   (0x1UL)		/*!< USART CR1: UE (Bitfield-Mask: 0x01) */
#define USART_CR1_UE                                                       USART_CR1_UE_Msk

/* =====================================================    CR2    ===================================================== */ 
#define USART_CR2_ADD_Pos                                                  (24UL)		/*!<USART CR2: ADD (Bit 24) */
#define USART_CR2_ADD_Msk                                                  (0xff000000UL)		/*!< USART CR2: ADD (Bitfield-Mask: 0xff) */
#define USART_CR2_ADD                                                      USART_CR2_ADD_Msk
#define USART_CR2_ADD_0                                                    (0x1U << USART_CR2_ADD_Pos)
#define USART_CR2_ADD_1                                                    (0x2U << USART_CR2_ADD_Pos)
#define USART_CR2_ADD_2                                                    (0x4U << USART_CR2_ADD_Pos)
#define USART_CR2_ADD_3                                                    (0x8U << USART_CR2_ADD_Pos)
#define USART_CR2_ADD_4                                                    (0x10U << USART_CR2_ADD_Pos)
#define USART_CR2_ADD_5                                                    (0x20U << USART_CR2_ADD_Pos)
#define USART_CR2_ADD_6                                                    (0x40U << USART_CR2_ADD_Pos)
#define USART_CR2_ADD_7                                                    (0x80U << USART_CR2_ADD_Pos)
#define USART_CR2_RTOEN_Pos                                                (23UL)		/*!<USART CR2: RTOEN (Bit 23) */
#define USART_CR2_RTOEN_Msk                                                (0x800000UL)		/*!< USART CR2: RTOEN (Bitfield-Mask: 0x01) */
#define USART_CR2_RTOEN                                                    USART_CR2_RTOEN_Msk
#define USART_CR2_ABRMODE_Pos                                              (21UL)		/*!<USART CR2: ABRMODE (Bit 21) */
#define USART_CR2_ABRMODE_Msk                                              (0x600000UL)		/*!< USART CR2: ABRMODE (Bitfield-Mask: 0x03) */
#define USART_CR2_ABRMODE                                                  USART_CR2_ABRMODE_Msk
#define USART_CR2_ABRMODE_0                                                (0x1U << USART_CR2_ABRMODE_Pos)
#define USART_CR2_ABRMODE_1                                                (0x2U << USART_CR2_ABRMODE_Pos)
#define USART_CR2_ABREN_Pos                                                (20UL)		/*!<USART CR2: ABREN (Bit 20) */
#define USART_CR2_ABREN_Msk                                                (0x100000UL)		/*!< USART CR2: ABREN (Bitfield-Mask: 0x01) */
#define USART_CR2_ABREN                                                    USART_CR2_ABREN_Msk
#define USART_CR2_MSBFIRST_Pos                                             (19UL)		/*!<USART CR2: MSBFIRST (Bit 19) */
#define USART_CR2_MSBFIRST_Msk                                             (0x80000UL)		/*!< USART CR2: MSBFIRST (Bitfield-Mask: 0x01) */
#define USART_CR2_MSBFIRST                                                 USART_CR2_MSBFIRST_Msk
#define USART_CR2_DATAINV_Pos                                              (18UL)		/*!<USART CR2: DATAINV (Bit 18) */
#define USART_CR2_DATAINV_Msk                                              (0x40000UL)		/*!< USART CR2: DATAINV (Bitfield-Mask: 0x01) */
#define USART_CR2_DATAINV                                                  USART_CR2_DATAINV_Msk
#define USART_CR2_TXINV_Pos                                                (17UL)		/*!<USART CR2: TXINV (Bit 17) */
#define USART_CR2_TXINV_Msk                                                (0x20000UL)		/*!< USART CR2: TXINV (Bitfield-Mask: 0x01) */
#define USART_CR2_TXINV                                                    USART_CR2_TXINV_Msk
#define USART_CR2_RXINV_Pos                                                (16UL)		/*!<USART CR2: RXINV (Bit 16) */
#define USART_CR2_RXINV_Msk                                                (0x10000UL)		/*!< USART CR2: RXINV (Bitfield-Mask: 0x01) */
#define USART_CR2_RXINV                                                    USART_CR2_RXINV_Msk
#define USART_CR2_SWAP_Pos                                                 (15UL)		/*!<USART CR2: SWAP (Bit 15) */
#define USART_CR2_SWAP_Msk                                                 (0x8000UL)		/*!< USART CR2: SWAP (Bitfield-Mask: 0x01) */
#define USART_CR2_SWAP                                                     USART_CR2_SWAP_Msk
#define USART_CR2_LINEN_Pos                                                (14UL)		/*!<USART CR2: LINEN (Bit 14) */
#define USART_CR2_LINEN_Msk                                                (0x4000UL)		/*!< USART CR2: LINEN (Bitfield-Mask: 0x01) */
#define USART_CR2_LINEN                                                    USART_CR2_LINEN_Msk
#define USART_CR2_STOP_Pos                                                 (12UL)		/*!<USART CR2: STOP (Bit 12) */
#define USART_CR2_STOP_Msk                                                 (0x3000UL)		/*!< USART CR2: STOP (Bitfield-Mask: 0x03) */
#define USART_CR2_STOP                                                     USART_CR2_STOP_Msk
#define USART_CR2_STOP_0                                                   (0x1U << USART_CR2_STOP_Pos)
#define USART_CR2_STOP_1                                                   (0x2U << USART_CR2_STOP_Pos)
#define USART_CR2_CLKEN_Pos                                                (11UL)		/*!<USART CR2: CLKEN (Bit 11) */
#define USART_CR2_CLKEN_Msk                                                (0x800UL)		/*!< USART CR2: CLKEN (Bitfield-Mask: 0x01) */
#define USART_CR2_CLKEN                                                    USART_CR2_CLKEN_Msk
#define USART_CR2_CPOL_Pos                                                 (10UL)		/*!<USART CR2: CPOL (Bit 10) */
#define USART_CR2_CPOL_Msk                                                 (0x400UL)		/*!< USART CR2: CPOL (Bitfield-Mask: 0x01) */
#define USART_CR2_CPOL                                                     USART_CR2_CPOL_Msk
#define USART_CR2_CPHA_Pos                                                 (9UL)		/*!<USART CR2: CPHA (Bit 9) */
#define USART_CR2_CPHA_Msk                                                 (0x200UL)		/*!< USART CR2: CPHA (Bitfield-Mask: 0x01) */
#define USART_CR2_CPHA                                                     USART_CR2_CPHA_Msk
#define USART_CR2_LBCL_Pos                                                 (8UL)		/*!<USART CR2: LBCL (Bit 8) */
#define USART_CR2_LBCL_Msk                                                 (0x100UL)		/*!< USART CR2: LBCL (Bitfield-Mask: 0x01) */
#define USART_CR2_LBCL                                                     USART_CR2_LBCL_Msk
#define USART_CR2_LBDIE_Pos                                                (6UL)		/*!<USART CR2: LBDIE (Bit 6) */
#define USART_CR2_LBDIE_Msk                                                (0x40UL)		/*!< USART CR2: LBDIE (Bitfield-Mask: 0x01) */
#define USART_CR2_LBDIE                                                    USART_CR2_LBDIE_Msk
#define USART_CR2_LBDL_Pos                                                 (5UL)		/*!<USART CR2: LBDL (Bit 5) */
#define USART_CR2_LBDL_Msk                                                 (0x20UL)		/*!< USART CR2: LBDL (Bitfield-Mask: 0x01) */
#define USART_CR2_LBDL                                                     USART_CR2_LBDL_Msk
#define USART_CR2_ADDM7_Pos                                                (4UL)		/*!<USART CR2: ADDM7 (Bit 4) */
#define USART_CR2_ADDM7_Msk                                                (0x10UL)		/*!< USART CR2: ADDM7 (Bitfield-Mask: 0x01) */
#define USART_CR2_ADDM7                                                    USART_CR2_ADDM7_Msk
#define USART_CR2_DIS_NSS_Pos                                              (3UL)		/*!<USART CR2: DIS_NSS (Bit 3) */
#define USART_CR2_DIS_NSS_Msk                                              (0x8UL)		/*!< USART CR2: DIS_NSS (Bitfield-Mask: 0x01) */
#define USART_CR2_DIS_NSS                                                  USART_CR2_DIS_NSS_Msk
#define USART_CR2_SLVEN_Pos                                                (0UL)		/*!<USART CR2: SLVEN (Bit 0) */
#define USART_CR2_SLVEN_Msk                                                (0x1UL)		/*!< USART CR2: SLVEN (Bitfield-Mask: 0x01) */
#define USART_CR2_SLVEN                                                    USART_CR2_SLVEN_Msk

/* =====================================================    CR3    ===================================================== */ 
#define USART_CR3_TXFTCFG_Pos                                              (29UL)		/*!<USART CR3: TXFTCFG (Bit 29) */
#define USART_CR3_TXFTCFG_Msk                                              (0xe0000000UL)		/*!< USART CR3: TXFTCFG (Bitfield-Mask: 0x07) */
#define USART_CR3_TXFTCFG                                                  USART_CR3_TXFTCFG_Msk
#define USART_CR3_TXFTCFG_0                                                (0x1U << USART_CR3_TXFTCFG_Pos)
#define USART_CR3_TXFTCFG_1                                                (0x2U << USART_CR3_TXFTCFG_Pos)
#define USART_CR3_TXFTCFG_2                                                (0x4U << USART_CR3_TXFTCFG_Pos)
#define USART_CR3_RXFTIE_Pos                                               (28UL)		/*!<USART CR3: RXFTIE (Bit 28) */
#define USART_CR3_RXFTIE_Msk                                               (0x10000000UL)		/*!< USART CR3: RXFTIE (Bitfield-Mask: 0x01) */
#define USART_CR3_RXFTIE                                                   USART_CR3_RXFTIE_Msk
#define USART_CR3_RXFTCFG_Pos                                              (25UL)		/*!<USART CR3: RXFTCFG (Bit 25) */
#define USART_CR3_RXFTCFG_Msk                                              (0xe000000UL)		/*!< USART CR3: RXFTCFG (Bitfield-Mask: 0x07) */
#define USART_CR3_RXFTCFG                                                  USART_CR3_RXFTCFG_Msk
#define USART_CR3_RXFTCFG_0                                                (0x1U << USART_CR3_RXFTCFG_Pos)
#define USART_CR3_RXFTCFG_1                                                (0x2U << USART_CR3_RXFTCFG_Pos)
#define USART_CR3_RXFTCFG_2                                                (0x4U << USART_CR3_RXFTCFG_Pos)
#define USART_CR3_TCBGTIE_Pos                                              (24UL)		/*!<USART CR3: TCBGTIE (Bit 24) */
#define USART_CR3_TCBGTIE_Msk                                              (0x1000000UL)		/*!< USART CR3: TCBGTIE (Bitfield-Mask: 0x01) */
#define USART_CR3_TCBGTIE                                                  USART_CR3_TCBGTIE_Msk
#define USART_CR3_TXFTIE_Pos                                               (23UL)		/*!<USART CR3: TXFTIE (Bit 23) */
#define USART_CR3_TXFTIE_Msk                                               (0x800000UL)		/*!< USART CR3: TXFTIE (Bitfield-Mask: 0x01) */
#define USART_CR3_TXFTIE                                                   USART_CR3_TXFTIE_Msk
#define USART_CR3_SCARCNT_Pos                                              (17UL)		/*!<USART CR3: SCARCNT (Bit 17) */
#define USART_CR3_SCARCNT_Msk                                              (0xe0000UL)		/*!< USART CR3: SCARCNT (Bitfield-Mask: 0x07) */
#define USART_CR3_SCARCNT                                                  USART_CR3_SCARCNT_Msk
#define USART_CR3_SCARCNT_0                                                (0x1U << USART_CR3_SCARCNT_Pos)
#define USART_CR3_SCARCNT_1                                                (0x2U << USART_CR3_SCARCNT_Pos)
#define USART_CR3_SCARCNT_2                                                (0x4U << USART_CR3_SCARCNT_Pos)
#define USART_CR3_DEP_Pos                                                  (15UL)		/*!<USART CR3: DEP (Bit 15) */
#define USART_CR3_DEP_Msk                                                  (0x8000UL)		/*!< USART CR3: DEP (Bitfield-Mask: 0x01) */
#define USART_CR3_DEP                                                      USART_CR3_DEP_Msk
#define USART_CR3_DEM_Pos                                                  (14UL)		/*!<USART CR3: DEM (Bit 14) */
#define USART_CR3_DEM_Msk                                                  (0x4000UL)		/*!< USART CR3: DEM (Bitfield-Mask: 0x01) */
#define USART_CR3_DEM                                                      USART_CR3_DEM_Msk
#define USART_CR3_DDRE_Pos                                                 (13UL)		/*!<USART CR3: DDRE (Bit 13) */
#define USART_CR3_DDRE_Msk                                                 (0x2000UL)		/*!< USART CR3: DDRE (Bitfield-Mask: 0x01) */
#define USART_CR3_DDRE                                                     USART_CR3_DDRE_Msk
#define USART_CR3_OVRDIS_Pos                                               (12UL)		/*!<USART CR3: OVRDIS (Bit 12) */
#define USART_CR3_OVRDIS_Msk                                               (0x1000UL)		/*!< USART CR3: OVRDIS (Bitfield-Mask: 0x01) */
#define USART_CR3_OVRDIS                                                   USART_CR3_OVRDIS_Msk
#define USART_CR3_ONEBIT_Pos                                               (11UL)		/*!<USART CR3: ONEBIT (Bit 11) */
#define USART_CR3_ONEBIT_Msk                                               (0x800UL)		/*!< USART CR3: ONEBIT (Bitfield-Mask: 0x01) */
#define USART_CR3_ONEBIT                                                   USART_CR3_ONEBIT_Msk
#define USART_CR3_CTSIE_Pos                                                (10UL)		/*!<USART CR3: CTSIE (Bit 10) */
#define USART_CR3_CTSIE_Msk                                                (0x400UL)		/*!< USART CR3: CTSIE (Bitfield-Mask: 0x01) */
#define USART_CR3_CTSIE                                                    USART_CR3_CTSIE_Msk
#define USART_CR3_CTSE_Pos                                                 (9UL)		/*!<USART CR3: CTSE (Bit 9) */
#define USART_CR3_CTSE_Msk                                                 (0x200UL)		/*!< USART CR3: CTSE (Bitfield-Mask: 0x01) */
#define USART_CR3_CTSE                                                     USART_CR3_CTSE_Msk
#define USART_CR3_RTSE_Pos                                                 (8UL)		/*!<USART CR3: RTSE (Bit 8) */
#define USART_CR3_RTSE_Msk                                                 (0x100UL)		/*!< USART CR3: RTSE (Bitfield-Mask: 0x01) */
#define USART_CR3_RTSE                                                     USART_CR3_RTSE_Msk
#define USART_CR3_DMAT_Pos                                                 (7UL)		/*!<USART CR3: DMAT (Bit 7) */
#define USART_CR3_DMAT_Msk                                                 (0x80UL)		/*!< USART CR3: DMAT (Bitfield-Mask: 0x01) */
#define USART_CR3_DMAT                                                     USART_CR3_DMAT_Msk
#define USART_CR3_DMAR_Pos                                                 (6UL)		/*!<USART CR3: DMAR (Bit 6) */
#define USART_CR3_DMAR_Msk                                                 (0x40UL)		/*!< USART CR3: DMAR (Bitfield-Mask: 0x01) */
#define USART_CR3_DMAR                                                     USART_CR3_DMAR_Msk
#define USART_CR3_SCEN_Pos                                                 (5UL)		/*!<USART CR3: SCEN (Bit 5) */
#define USART_CR3_SCEN_Msk                                                 (0x20UL)		/*!< USART CR3: SCEN (Bitfield-Mask: 0x01) */
#define USART_CR3_SCEN                                                     USART_CR3_SCEN_Msk
#define USART_CR3_NACK_Pos                                                 (4UL)		/*!<USART CR3: NACK (Bit 4) */
#define USART_CR3_NACK_Msk                                                 (0x10UL)		/*!< USART CR3: NACK (Bitfield-Mask: 0x01) */
#define USART_CR3_NACK                                                     USART_CR3_NACK_Msk
#define USART_CR3_HDSEL_Pos                                                (3UL)		/*!<USART CR3: HDSEL (Bit 3) */
#define USART_CR3_HDSEL_Msk                                                (0x8UL)		/*!< USART CR3: HDSEL (Bitfield-Mask: 0x01) */
#define USART_CR3_HDSEL                                                    USART_CR3_HDSEL_Msk
#define USART_CR3_IRLP_Pos                                                 (2UL)		/*!<USART CR3: IRLP (Bit 2) */
#define USART_CR3_IRLP_Msk                                                 (0x4UL)		/*!< USART CR3: IRLP (Bitfield-Mask: 0x01) */
#define USART_CR3_IRLP                                                     USART_CR3_IRLP_Msk
#define USART_CR3_IREN_Pos                                                 (1UL)		/*!<USART CR3: IREN (Bit 1) */
#define USART_CR3_IREN_Msk                                                 (0x2UL)		/*!< USART CR3: IREN (Bitfield-Mask: 0x01) */
#define USART_CR3_IREN                                                     USART_CR3_IREN_Msk
#define USART_CR3_EIE_Pos                                                  (0UL)		/*!<USART CR3: EIE (Bit 0) */
#define USART_CR3_EIE_Msk                                                  (0x1UL)		/*!< USART CR3: EIE (Bitfield-Mask: 0x01) */
#define USART_CR3_EIE                                                      USART_CR3_EIE_Msk

/* =====================================================    BRR    ===================================================== */ 
#define USART_BRR_BRR_Pos                                                  (0UL)		/*!<USART BRR: BRR (Bit 0) */
#define USART_BRR_BRR_Msk                                                  (0xfffffUL)		/*!< USART BRR: BRR (Bitfield-Mask: 0xfffff) */
#define USART_BRR_BRR                                                      USART_BRR_BRR_Msk
#define USART_BRR_BRR_0                                                    (0x1U << USART_BRR_BRR_Pos)
#define USART_BRR_BRR_1                                                    (0x2U << USART_BRR_BRR_Pos)
#define USART_BRR_BRR_2                                                    (0x4U << USART_BRR_BRR_Pos)
#define USART_BRR_BRR_3                                                    (0x8U << USART_BRR_BRR_Pos)
#define USART_BRR_BRR_4                                                    (0x10U << USART_BRR_BRR_Pos)
#define USART_BRR_BRR_5                                                    (0x20U << USART_BRR_BRR_Pos)
#define USART_BRR_BRR_6                                                    (0x40U << USART_BRR_BRR_Pos)
#define USART_BRR_BRR_7                                                    (0x80U << USART_BRR_BRR_Pos)
#define USART_BRR_BRR_8                                                    (0x100U << USART_BRR_BRR_Pos)
#define USART_BRR_BRR_9                                                    (0x200U << USART_BRR_BRR_Pos)
#define USART_BRR_BRR_10                                                   (0x400U << USART_BRR_BRR_Pos)
#define USART_BRR_BRR_11                                                   (0x800U << USART_BRR_BRR_Pos)
#define USART_BRR_BRR_12                                                   (0x1000U << USART_BRR_BRR_Pos)
#define USART_BRR_BRR_13                                                   (0x2000U << USART_BRR_BRR_Pos)
#define USART_BRR_BRR_14                                                   (0x4000U << USART_BRR_BRR_Pos)
#define USART_BRR_BRR_15                                                   (0x8000U << USART_BRR_BRR_Pos)
#define USART_BRR_BRR_16                                                   (0x10000U << USART_BRR_BRR_Pos)
#define USART_BRR_BRR_17                                                   (0x20000U << USART_BRR_BRR_Pos)
#define USART_BRR_BRR_18                                                   (0x40000U << USART_BRR_BRR_Pos)
#define USART_BRR_BRR_19                                                   (0x80000U << USART_BRR_BRR_Pos)

/* =====================================================    GTPR    ===================================================== */ 
#define USART_GTPR_GT_Pos                                                  (8UL)		/*!<USART GTPR: GT (Bit 8) */
#define USART_GTPR_GT_Msk                                                  (0xff00UL)		/*!< USART GTPR: GT (Bitfield-Mask: 0xff) */
#define USART_GTPR_GT                                                      USART_GTPR_GT_Msk
#define USART_GTPR_GT_0                                                    (0x1U << USART_GTPR_GT_Pos)
#define USART_GTPR_GT_1                                                    (0x2U << USART_GTPR_GT_Pos)
#define USART_GTPR_GT_2                                                    (0x4U << USART_GTPR_GT_Pos)
#define USART_GTPR_GT_3                                                    (0x8U << USART_GTPR_GT_Pos)
#define USART_GTPR_GT_4                                                    (0x10U << USART_GTPR_GT_Pos)
#define USART_GTPR_GT_5                                                    (0x20U << USART_GTPR_GT_Pos)
#define USART_GTPR_GT_6                                                    (0x40U << USART_GTPR_GT_Pos)
#define USART_GTPR_GT_7                                                    (0x80U << USART_GTPR_GT_Pos)
#define USART_GTPR_PSC_Pos                                                 (0UL)		/*!<USART GTPR: PSC (Bit 0) */
#define USART_GTPR_PSC_Msk                                                 (0xffUL)		/*!< USART GTPR: PSC (Bitfield-Mask: 0xff) */
#define USART_GTPR_PSC                                                     USART_GTPR_PSC_Msk
#define USART_GTPR_PSC_0                                                   (0x1U << USART_GTPR_PSC_Pos)
#define USART_GTPR_PSC_1                                                   (0x2U << USART_GTPR_PSC_Pos)
#define USART_GTPR_PSC_2                                                   (0x4U << USART_GTPR_PSC_Pos)
#define USART_GTPR_PSC_3                                                   (0x8U << USART_GTPR_PSC_Pos)
#define USART_GTPR_PSC_4                                                   (0x10U << USART_GTPR_PSC_Pos)
#define USART_GTPR_PSC_5                                                   (0x20U << USART_GTPR_PSC_Pos)
#define USART_GTPR_PSC_6                                                   (0x40U << USART_GTPR_PSC_Pos)
#define USART_GTPR_PSC_7                                                   (0x80U << USART_GTPR_PSC_Pos)

/* =====================================================    RTOR    ===================================================== */ 
#define USART_RTOR_BLEN_Pos                                                (24UL)		/*!<USART RTOR: BLEN (Bit 24) */
#define USART_RTOR_BLEN_Msk                                                (0xff000000UL)		/*!< USART RTOR: BLEN (Bitfield-Mask: 0xff) */
#define USART_RTOR_BLEN                                                    USART_RTOR_BLEN_Msk
#define USART_RTOR_BLEN_0                                                  (0x1U << USART_RTOR_BLEN_Pos)
#define USART_RTOR_BLEN_1                                                  (0x2U << USART_RTOR_BLEN_Pos)
#define USART_RTOR_BLEN_2                                                  (0x4U << USART_RTOR_BLEN_Pos)
#define USART_RTOR_BLEN_3                                                  (0x8U << USART_RTOR_BLEN_Pos)
#define USART_RTOR_BLEN_4                                                  (0x10U << USART_RTOR_BLEN_Pos)
#define USART_RTOR_BLEN_5                                                  (0x20U << USART_RTOR_BLEN_Pos)
#define USART_RTOR_BLEN_6                                                  (0x40U << USART_RTOR_BLEN_Pos)
#define USART_RTOR_BLEN_7                                                  (0x80U << USART_RTOR_BLEN_Pos)
#define USART_RTOR_RTO_Pos                                                 (0UL)		/*!<USART RTOR: RTO (Bit 0) */
#define USART_RTOR_RTO_Msk                                                 (0xffffffUL)		/*!< USART RTOR: RTO (Bitfield-Mask: 0xffffff) */
#define USART_RTOR_RTO                                                     USART_RTOR_RTO_Msk
#define USART_RTOR_RTO_0                                                   (0x1U << USART_RTOR_RTO_Pos)
#define USART_RTOR_RTO_1                                                   (0x2U << USART_RTOR_RTO_Pos)
#define USART_RTOR_RTO_2                                                   (0x4U << USART_RTOR_RTO_Pos)
#define USART_RTOR_RTO_3                                                   (0x8U << USART_RTOR_RTO_Pos)
#define USART_RTOR_RTO_4                                                   (0x10U << USART_RTOR_RTO_Pos)
#define USART_RTOR_RTO_5                                                   (0x20U << USART_RTOR_RTO_Pos)
#define USART_RTOR_RTO_6                                                   (0x40U << USART_RTOR_RTO_Pos)
#define USART_RTOR_RTO_7                                                   (0x80U << USART_RTOR_RTO_Pos)
#define USART_RTOR_RTO_8                                                   (0x100U << USART_RTOR_RTO_Pos)
#define USART_RTOR_RTO_9                                                   (0x200U << USART_RTOR_RTO_Pos)
#define USART_RTOR_RTO_10                                                  (0x400U << USART_RTOR_RTO_Pos)
#define USART_RTOR_RTO_11                                                  (0x800U << USART_RTOR_RTO_Pos)
#define USART_RTOR_RTO_12                                                  (0x1000U << USART_RTOR_RTO_Pos)
#define USART_RTOR_RTO_13                                                  (0x2000U << USART_RTOR_RTO_Pos)
#define USART_RTOR_RTO_14                                                  (0x4000U << USART_RTOR_RTO_Pos)
#define USART_RTOR_RTO_15                                                  (0x8000U << USART_RTOR_RTO_Pos)
#define USART_RTOR_RTO_16                                                  (0x10000U << USART_RTOR_RTO_Pos)
#define USART_RTOR_RTO_17                                                  (0x20000U << USART_RTOR_RTO_Pos)
#define USART_RTOR_RTO_18                                                  (0x40000U << USART_RTOR_RTO_Pos)
#define USART_RTOR_RTO_19                                                  (0x80000U << USART_RTOR_RTO_Pos)
#define USART_RTOR_RTO_20                                                  (0x100000U << USART_RTOR_RTO_Pos)
#define USART_RTOR_RTO_21                                                  (0x200000U << USART_RTOR_RTO_Pos)
#define USART_RTOR_RTO_22                                                  (0x400000U << USART_RTOR_RTO_Pos)
#define USART_RTOR_RTO_23                                                  (0x800000U << USART_RTOR_RTO_Pos)

/* =====================================================    RQR    ===================================================== */ 
#define USART_RQR_TXFRQ_Pos                                                (4UL)		/*!<USART RQR: TXFRQ (Bit 4) */
#define USART_RQR_TXFRQ_Msk                                                (0x10UL)		/*!< USART RQR: TXFRQ (Bitfield-Mask: 0x01) */
#define USART_RQR_TXFRQ                                                    USART_RQR_TXFRQ_Msk
#define USART_RQR_RXFRQ_Pos                                                (3UL)		/*!<USART RQR: RXFRQ (Bit 3) */
#define USART_RQR_RXFRQ_Msk                                                (0x8UL)		/*!< USART RQR: RXFRQ (Bitfield-Mask: 0x01) */
#define USART_RQR_RXFRQ                                                    USART_RQR_RXFRQ_Msk
#define USART_RQR_MMRQ_Pos                                                 (2UL)		/*!<USART RQR: MMRQ (Bit 2) */
#define USART_RQR_MMRQ_Msk                                                 (0x4UL)		/*!< USART RQR: MMRQ (Bitfield-Mask: 0x01) */
#define USART_RQR_MMRQ                                                     USART_RQR_MMRQ_Msk
#define USART_RQR_SBKRQ_Pos                                                (1UL)		/*!<USART RQR: SBKRQ (Bit 1) */
#define USART_RQR_SBKRQ_Msk                                                (0x2UL)		/*!< USART RQR: SBKRQ (Bitfield-Mask: 0x01) */
#define USART_RQR_SBKRQ                                                    USART_RQR_SBKRQ_Msk
#define USART_RQR_ABRRQ_Pos                                                (0UL)		/*!<USART RQR: ABRRQ (Bit 0) */
#define USART_RQR_ABRRQ_Msk                                                (0x1UL)		/*!< USART RQR: ABRRQ (Bitfield-Mask: 0x01) */
#define USART_RQR_ABRRQ                                                    USART_RQR_ABRRQ_Msk

/* =====================================================    ISR    ===================================================== */ 
#define USART_ISR_TXFT_Pos                                                 (27UL)		/*!<USART ISR: TXFT (Bit 27) */
#define USART_ISR_TXFT_Msk                                                 (0x8000000UL)		/*!< USART ISR: TXFT (Bitfield-Mask: 0x01) */
#define USART_ISR_TXFT                                                     USART_ISR_TXFT_Msk
#define USART_ISR_RXFT_Pos                                                 (26UL)		/*!<USART ISR: RXFT (Bit 26) */
#define USART_ISR_RXFT_Msk                                                 (0x4000000UL)		/*!< USART ISR: RXFT (Bitfield-Mask: 0x01) */
#define USART_ISR_RXFT                                                     USART_ISR_RXFT_Msk
#define USART_ISR_TCBGT_Pos                                                (25UL)		/*!<USART ISR: TCBGT (Bit 25) */
#define USART_ISR_TCBGT_Msk                                                (0x2000000UL)		/*!< USART ISR: TCBGT (Bitfield-Mask: 0x01) */
#define USART_ISR_TCBGT                                                    USART_ISR_TCBGT_Msk
#define USART_ISR_RXFF_Pos                                                 (24UL)		/*!<USART ISR: RXFF (Bit 24) */
#define USART_ISR_RXFF_Msk                                                 (0x1000000UL)		/*!< USART ISR: RXFF (Bitfield-Mask: 0x01) */
#define USART_ISR_RXFF                                                     USART_ISR_RXFF_Msk
#define USART_ISR_TXFE_Pos                                                 (23UL)		/*!<USART ISR: TXFE (Bit 23) */
#define USART_ISR_TXFE_Msk                                                 (0x800000UL)		/*!< USART ISR: TXFE (Bitfield-Mask: 0x01) */
#define USART_ISR_TXFE                                                     USART_ISR_TXFE_Msk
#define USART_ISR_REACK_Pos                                                (22UL)		/*!<USART ISR: REACK (Bit 22) */
#define USART_ISR_REACK_Msk                                                (0x400000UL)		/*!< USART ISR: REACK (Bitfield-Mask: 0x01) */
#define USART_ISR_REACK                                                    USART_ISR_REACK_Msk
#define USART_ISR_TEACK_Pos                                                (21UL)		/*!<USART ISR: TEACK (Bit 21) */
#define USART_ISR_TEACK_Msk                                                (0x200000UL)		/*!< USART ISR: TEACK (Bitfield-Mask: 0x01) */
#define USART_ISR_TEACK                                                    USART_ISR_TEACK_Msk
#define USART_ISR_RWU_Pos                                                  (19UL)		/*!<USART ISR: RWU (Bit 19) */
#define USART_ISR_RWU_Msk                                                  (0x80000UL)		/*!< USART ISR: RWU (Bitfield-Mask: 0x01) */
#define USART_ISR_RWU                                                      USART_ISR_RWU_Msk
#define USART_ISR_SBKF_Pos                                                 (18UL)		/*!<USART ISR: SBKF (Bit 18) */
#define USART_ISR_SBKF_Msk                                                 (0x40000UL)		/*!< USART ISR: SBKF (Bitfield-Mask: 0x01) */
#define USART_ISR_SBKF                                                     USART_ISR_SBKF_Msk
#define USART_ISR_CMF_Pos                                                  (17UL)		/*!<USART ISR: CMF (Bit 17) */
#define USART_ISR_CMF_Msk                                                  (0x20000UL)		/*!< USART ISR: CMF (Bitfield-Mask: 0x01) */
#define USART_ISR_CMF                                                      USART_ISR_CMF_Msk
#define USART_ISR_BUSY_Pos                                                 (16UL)		/*!<USART ISR: BUSY (Bit 16) */
#define USART_ISR_BUSY_Msk                                                 (0x10000UL)		/*!< USART ISR: BUSY (Bitfield-Mask: 0x01) */
#define USART_ISR_BUSY                                                     USART_ISR_BUSY_Msk
#define USART_ISR_ABRF_Pos                                                 (15UL)		/*!<USART ISR: ABRF (Bit 15) */
#define USART_ISR_ABRF_Msk                                                 (0x8000UL)		/*!< USART ISR: ABRF (Bitfield-Mask: 0x01) */
#define USART_ISR_ABRF                                                     USART_ISR_ABRF_Msk
#define USART_ISR_ABRE_Pos                                                 (14UL)		/*!<USART ISR: ABRE (Bit 14) */
#define USART_ISR_ABRE_Msk                                                 (0x4000UL)		/*!< USART ISR: ABRE (Bitfield-Mask: 0x01) */
#define USART_ISR_ABRE                                                     USART_ISR_ABRE_Msk
#define USART_ISR_UDR_Pos                                                  (13UL)		/*!<USART ISR: UDR (Bit 13) */
#define USART_ISR_UDR_Msk                                                  (0x2000UL)		/*!< USART ISR: UDR (Bitfield-Mask: 0x01) */
#define USART_ISR_UDR                                                      USART_ISR_UDR_Msk
#define USART_ISR_EOBF_Pos                                                 (12UL)		/*!<USART ISR: EOBF (Bit 12) */
#define USART_ISR_EOBF_Msk                                                 (0x1000UL)		/*!< USART ISR: EOBF (Bitfield-Mask: 0x01) */
#define USART_ISR_EOBF                                                     USART_ISR_EOBF_Msk
#define USART_ISR_RTOF_Pos                                                 (11UL)		/*!<USART ISR: RTOF (Bit 11) */
#define USART_ISR_RTOF_Msk                                                 (0x800UL)		/*!< USART ISR: RTOF (Bitfield-Mask: 0x01) */
#define USART_ISR_RTOF                                                     USART_ISR_RTOF_Msk
#define USART_ISR_CTS_Pos                                                  (10UL)		/*!<USART ISR: CTS (Bit 10) */
#define USART_ISR_CTS_Msk                                                  (0x400UL)		/*!< USART ISR: CTS (Bitfield-Mask: 0x01) */
#define USART_ISR_CTS                                                      USART_ISR_CTS_Msk
#define USART_ISR_CTSIF_Pos                                                (9UL)		/*!<USART ISR: CTSIF (Bit 9) */
#define USART_ISR_CTSIF_Msk                                                (0x200UL)		/*!< USART ISR: CTSIF (Bitfield-Mask: 0x01) */
#define USART_ISR_CTSIF                                                    USART_ISR_CTSIF_Msk
#define USART_ISR_LBDF_Pos                                                 (8UL)		/*!<USART ISR: LBDF (Bit 8) */
#define USART_ISR_LBDF_Msk                                                 (0x100UL)		/*!< USART ISR: LBDF (Bitfield-Mask: 0x01) */
#define USART_ISR_LBDF                                                     USART_ISR_LBDF_Msk
#define USART_ISR_TXE_TXFNF_Pos                                            (7UL)		/*!<USART ISR: TXE_TXFNF (Bit 7) */
#define USART_ISR_TXE_TXFNF_Msk                                            (0x80UL)		/*!< USART ISR: TXE_TXFNF (Bitfield-Mask: 0x01) */
#define USART_ISR_TXE_TXFNF                                                USART_ISR_TXE_TXFNF_Msk
#define USART_ISR_TC_Pos                                                   (6UL)		/*!<USART ISR: TC (Bit 6) */
#define USART_ISR_TC_Msk                                                   (0x40UL)		/*!< USART ISR: TC (Bitfield-Mask: 0x01) */
#define USART_ISR_TC                                                       USART_ISR_TC_Msk
#define USART_ISR_RXNE_RXFNE_Pos                                           (5UL)		/*!<USART ISR: RXNE_RXFNE (Bit 5) */
#define USART_ISR_RXNE_RXFNE_Msk                                           (0x20UL)		/*!< USART ISR: RXNE_RXFNE (Bitfield-Mask: 0x01) */
#define USART_ISR_RXNE_RXFNE                                               USART_ISR_RXNE_RXFNE_Msk
#define USART_ISR_IDLE_Pos                                                 (4UL)		/*!<USART ISR: IDLE (Bit 4) */
#define USART_ISR_IDLE_Msk                                                 (0x10UL)		/*!< USART ISR: IDLE (Bitfield-Mask: 0x01) */
#define USART_ISR_IDLE                                                     USART_ISR_IDLE_Msk
#define USART_ISR_ORE_Pos                                                  (3UL)		/*!<USART ISR: ORE (Bit 3) */
#define USART_ISR_ORE_Msk                                                  (0x8UL)		/*!< USART ISR: ORE (Bitfield-Mask: 0x01) */
#define USART_ISR_ORE                                                      USART_ISR_ORE_Msk
#define USART_ISR_NE_Pos                                                   (2UL)		/*!<USART ISR: NE (Bit 2) */
#define USART_ISR_NE_Msk                                                   (0x4UL)		/*!< USART ISR: NE (Bitfield-Mask: 0x01) */
#define USART_ISR_NE                                                       USART_ISR_NE_Msk
#define USART_ISR_FE_Pos                                                   (1UL)		/*!<USART ISR: FE (Bit 1) */
#define USART_ISR_FE_Msk                                                   (0x2UL)		/*!< USART ISR: FE (Bitfield-Mask: 0x01) */
#define USART_ISR_FE                                                       USART_ISR_FE_Msk
#define USART_ISR_PE_Pos                                                   (0UL)		/*!<USART ISR: PE (Bit 0) */
#define USART_ISR_PE_Msk                                                   (0x1UL)		/*!< USART ISR: PE (Bitfield-Mask: 0x01) */
#define USART_ISR_PE                                                       USART_ISR_PE_Msk

/* =====================================================    ICR    ===================================================== */ 
#define USART_ICR_CMCF_Pos                                                 (17UL)		/*!<USART ICR: CMCF (Bit 17) */
#define USART_ICR_CMCF_Msk                                                 (0x20000UL)		/*!< USART ICR: CMCF (Bitfield-Mask: 0x01) */
#define USART_ICR_CMCF                                                     USART_ICR_CMCF_Msk
#define USART_ICR_UDRCF_Pos                                                (13UL)		/*!<USART ICR: UDRCF (Bit 13) */
#define USART_ICR_UDRCF_Msk                                                (0x2000UL)		/*!< USART ICR: UDRCF (Bitfield-Mask: 0x01) */
#define USART_ICR_UDRCF                                                    USART_ICR_UDRCF_Msk
#define USART_ICR_EOBCF_Pos                                                (12UL)		/*!<USART ICR: EOBCF (Bit 12) */
#define USART_ICR_EOBCF_Msk                                                (0x1000UL)		/*!< USART ICR: EOBCF (Bitfield-Mask: 0x01) */
#define USART_ICR_EOBCF                                                    USART_ICR_EOBCF_Msk
#define USART_ICR_RTOCF_Pos                                                (11UL)		/*!<USART ICR: RTOCF (Bit 11) */
#define USART_ICR_RTOCF_Msk                                                (0x800UL)		/*!< USART ICR: RTOCF (Bitfield-Mask: 0x01) */
#define USART_ICR_RTOCF                                                    USART_ICR_RTOCF_Msk
#define USART_ICR_CTSCF_Pos                                                (9UL)		/*!<USART ICR: CTSCF (Bit 9) */
#define USART_ICR_CTSCF_Msk                                                (0x200UL)		/*!< USART ICR: CTSCF (Bitfield-Mask: 0x01) */
#define USART_ICR_CTSCF                                                    USART_ICR_CTSCF_Msk
#define USART_ICR_LBDCF_Pos                                                (8UL)		/*!<USART ICR: LBDCF (Bit 8) */
#define USART_ICR_LBDCF_Msk                                                (0x100UL)		/*!< USART ICR: LBDCF (Bitfield-Mask: 0x01) */
#define USART_ICR_LBDCF                                                    USART_ICR_LBDCF_Msk
#define USART_ICR_TCBGTCF_Pos                                              (7UL)		/*!<USART ICR: TCBGTCF (Bit 7) */
#define USART_ICR_TCBGTCF_Msk                                              (0x80UL)		/*!< USART ICR: TCBGTCF (Bitfield-Mask: 0x01) */
#define USART_ICR_TCBGTCF                                                  USART_ICR_TCBGTCF_Msk
#define USART_ICR_TCCF_Pos                                                 (6UL)		/*!<USART ICR: TCCF (Bit 6) */
#define USART_ICR_TCCF_Msk                                                 (0x40UL)		/*!< USART ICR: TCCF (Bitfield-Mask: 0x01) */
#define USART_ICR_TCCF                                                     USART_ICR_TCCF_Msk
#define USART_ICR_TXFECF_Pos                                               (5UL)		/*!<USART ICR: TXFECF (Bit 5) */
#define USART_ICR_TXFECF_Msk                                               (0x20UL)		/*!< USART ICR: TXFECF (Bitfield-Mask: 0x01) */
#define USART_ICR_TXFECF                                                   USART_ICR_TXFECF_Msk
#define USART_ICR_IDLECF_Pos                                               (4UL)		/*!<USART ICR: IDLECF (Bit 4) */
#define USART_ICR_IDLECF_Msk                                               (0x10UL)		/*!< USART ICR: IDLECF (Bitfield-Mask: 0x01) */
#define USART_ICR_IDLECF                                                   USART_ICR_IDLECF_Msk
#define USART_ICR_ORECF_Pos                                                (3UL)		/*!<USART ICR: ORECF (Bit 3) */
#define USART_ICR_ORECF_Msk                                                (0x8UL)		/*!< USART ICR: ORECF (Bitfield-Mask: 0x01) */
#define USART_ICR_ORECF                                                    USART_ICR_ORECF_Msk
#define USART_ICR_NECF_Pos                                                 (2UL)		/*!<USART ICR: NECF (Bit 2) */
#define USART_ICR_NECF_Msk                                                 (0x4UL)		/*!< USART ICR: NECF (Bitfield-Mask: 0x01) */
#define USART_ICR_NECF                                                     USART_ICR_NECF_Msk
#define USART_ICR_FECF_Pos                                                 (1UL)		/*!<USART ICR: FECF (Bit 1) */
#define USART_ICR_FECF_Msk                                                 (0x2UL)		/*!< USART ICR: FECF (Bitfield-Mask: 0x01) */
#define USART_ICR_FECF                                                     USART_ICR_FECF_Msk
#define USART_ICR_PECF_Pos                                                 (0UL)		/*!<USART ICR: PECF (Bit 0) */
#define USART_ICR_PECF_Msk                                                 (0x1UL)		/*!< USART ICR: PECF (Bitfield-Mask: 0x01) */
#define USART_ICR_PECF                                                     USART_ICR_PECF_Msk

/* =====================================================    RDR    ===================================================== */ 
#define USART_RDR_RDR_Pos                                                  (0UL)		/*!<USART RDR: RDR (Bit 0) */
#define USART_RDR_RDR_Msk                                                  (0x1ffUL)		/*!< USART RDR: RDR (Bitfield-Mask: 0x1ff) */
#define USART_RDR_RDR                                                      USART_RDR_RDR_Msk
#define USART_RDR_RDR_0                                                    (0x1U << USART_RDR_RDR_Pos)
#define USART_RDR_RDR_1                                                    (0x2U << USART_RDR_RDR_Pos)
#define USART_RDR_RDR_2                                                    (0x4U << USART_RDR_RDR_Pos)
#define USART_RDR_RDR_3                                                    (0x8U << USART_RDR_RDR_Pos)
#define USART_RDR_RDR_4                                                    (0x10U << USART_RDR_RDR_Pos)
#define USART_RDR_RDR_5                                                    (0x20U << USART_RDR_RDR_Pos)
#define USART_RDR_RDR_6                                                    (0x40U << USART_RDR_RDR_Pos)
#define USART_RDR_RDR_7                                                    (0x80U << USART_RDR_RDR_Pos)
#define USART_RDR_RDR_8                                                    (0x100U << USART_RDR_RDR_Pos)

/* =====================================================    TDR    ===================================================== */ 
#define USART_TDR_TDR_Pos                                                  (0UL)		/*!<USART TDR: TDR (Bit 0) */
#define USART_TDR_TDR_Msk                                                  (0x1ffUL)		/*!< USART TDR: TDR (Bitfield-Mask: 0x1ff) */
#define USART_TDR_TDR                                                      USART_TDR_TDR_Msk
#define USART_TDR_TDR_0                                                    (0x1U << USART_TDR_TDR_Pos)
#define USART_TDR_TDR_1                                                    (0x2U << USART_TDR_TDR_Pos)
#define USART_TDR_TDR_2                                                    (0x4U << USART_TDR_TDR_Pos)
#define USART_TDR_TDR_3                                                    (0x8U << USART_TDR_TDR_Pos)
#define USART_TDR_TDR_4                                                    (0x10U << USART_TDR_TDR_Pos)
#define USART_TDR_TDR_5                                                    (0x20U << USART_TDR_TDR_Pos)
#define USART_TDR_TDR_6                                                    (0x40U << USART_TDR_TDR_Pos)
#define USART_TDR_TDR_7                                                    (0x80U << USART_TDR_TDR_Pos)
#define USART_TDR_TDR_8                                                    (0x100U << USART_TDR_TDR_Pos)

/* =====================================================    PRESC    ===================================================== */ 
#define USART_PRESC_PRESCALER_Pos                                          (0UL)		/*!<USART PRESC: PRESCALER (Bit 0) */
#define USART_PRESC_PRESCALER_Msk                                          (0xfUL)		/*!< USART PRESC: PRESCALER (Bitfield-Mask: 0x0f) */
#define USART_PRESC_PRESCALER                                              USART_PRESC_PRESCALER_Msk
#define USART_PRESC_PRESCALER_0                                            (0x1U << USART_PRESC_PRESCALER_Pos)
#define USART_PRESC_PRESCALER_1                                            (0x2U << USART_PRESC_PRESCALER_Pos)
#define USART_PRESC_PRESCALER_2                                            (0x4U << USART_PRESC_PRESCALER_Pos)
#define USART_PRESC_PRESCALER_3                                            (0x8U << USART_PRESC_PRESCALER_Pos)


/* =========================================================================================================================== */ 
/*=====================                                       RTC                                       ===================== */ 
/* =========================================================================================================================== */ 

/* =====================================================    TR    ===================================================== */ 
#define RTC_TR_PM_Pos                                                      (22UL)		/*!<RTC TR: PM (Bit 22) */
#define RTC_TR_PM_Msk                                                      (0x400000UL)		/*!< RTC TR: PM (Bitfield-Mask: 0x01) */
#define RTC_TR_PM                                                          RTC_TR_PM_Msk
#define RTC_TR_HT_Pos                                                      (20UL)		/*!<RTC TR: HT (Bit 20) */
#define RTC_TR_HT_Msk                                                      (0x300000UL)		/*!< RTC TR: HT (Bitfield-Mask: 0x03) */
#define RTC_TR_HT                                                          RTC_TR_HT_Msk
#define RTC_TR_HT_0                                                        (0x1U << RTC_TR_HT_Pos)
#define RTC_TR_HT_1                                                        (0x2U << RTC_TR_HT_Pos)
#define RTC_TR_HU_Pos                                                      (16UL)		/*!<RTC TR: HU (Bit 16) */
#define RTC_TR_HU_Msk                                                      (0xf0000UL)		/*!< RTC TR: HU (Bitfield-Mask: 0x0f) */
#define RTC_TR_HU                                                          RTC_TR_HU_Msk
#define RTC_TR_HU_0                                                        (0x1U << RTC_TR_HU_Pos)
#define RTC_TR_HU_1                                                        (0x2U << RTC_TR_HU_Pos)
#define RTC_TR_HU_2                                                        (0x4U << RTC_TR_HU_Pos)
#define RTC_TR_HU_3                                                        (0x8U << RTC_TR_HU_Pos)
#define RTC_TR_MNT_Pos                                                     (12UL)		/*!<RTC TR: MNT (Bit 12) */
#define RTC_TR_MNT_Msk                                                     (0x7000UL)		/*!< RTC TR: MNT (Bitfield-Mask: 0x07) */
#define RTC_TR_MNT                                                         RTC_TR_MNT_Msk
#define RTC_TR_MNT_0                                                       (0x1U << RTC_TR_MNT_Pos)
#define RTC_TR_MNT_1                                                       (0x2U << RTC_TR_MNT_Pos)
#define RTC_TR_MNT_2                                                       (0x4U << RTC_TR_MNT_Pos)
#define RTC_TR_MNU_Pos                                                     (8UL)		/*!<RTC TR: MNU (Bit 8) */
#define RTC_TR_MNU_Msk                                                     (0xf00UL)		/*!< RTC TR: MNU (Bitfield-Mask: 0x0f) */
#define RTC_TR_MNU                                                         RTC_TR_MNU_Msk
#define RTC_TR_MNU_0                                                       (0x1U << RTC_TR_MNU_Pos)
#define RTC_TR_MNU_1                                                       (0x2U << RTC_TR_MNU_Pos)
#define RTC_TR_MNU_2                                                       (0x4U << RTC_TR_MNU_Pos)
#define RTC_TR_MNU_3                                                       (0x8U << RTC_TR_MNU_Pos)
#define RTC_TR_ST_Pos                                                      (4UL)		/*!<RTC TR: ST (Bit 4) */
#define RTC_TR_ST_Msk                                                      (0x70UL)		/*!< RTC TR: ST (Bitfield-Mask: 0x07) */
#define RTC_TR_ST                                                          RTC_TR_ST_Msk
#define RTC_TR_ST_0                                                        (0x1U << RTC_TR_ST_Pos)
#define RTC_TR_ST_1                                                        (0x2U << RTC_TR_ST_Pos)
#define RTC_TR_ST_2                                                        (0x4U << RTC_TR_ST_Pos)
#define RTC_TR_SU_Pos                                                      (0UL)		/*!<RTC TR: SU (Bit 0) */
#define RTC_TR_SU_Msk                                                      (0xfUL)		/*!< RTC TR: SU (Bitfield-Mask: 0x0f) */
#define RTC_TR_SU                                                          RTC_TR_SU_Msk
#define RTC_TR_SU_0                                                        (0x1U << RTC_TR_SU_Pos)
#define RTC_TR_SU_1                                                        (0x2U << RTC_TR_SU_Pos)
#define RTC_TR_SU_2                                                        (0x4U << RTC_TR_SU_Pos)
#define RTC_TR_SU_3                                                        (0x8U << RTC_TR_SU_Pos)

/* =====================================================    DR    ===================================================== */ 
#define RTC_DR_YT_Pos                                                      (20UL)		/*!<RTC DR: YT (Bit 20) */
#define RTC_DR_YT_Msk                                                      (0xf00000UL)		/*!< RTC DR: YT (Bitfield-Mask: 0x0f) */
#define RTC_DR_YT                                                          RTC_DR_YT_Msk
#define RTC_DR_YT_0                                                        (0x1U << RTC_DR_YT_Pos)
#define RTC_DR_YT_1                                                        (0x2U << RTC_DR_YT_Pos)
#define RTC_DR_YT_2                                                        (0x4U << RTC_DR_YT_Pos)
#define RTC_DR_YT_3                                                        (0x8U << RTC_DR_YT_Pos)
#define RTC_DR_YU_Pos                                                      (16UL)		/*!<RTC DR: YU (Bit 16) */
#define RTC_DR_YU_Msk                                                      (0xf0000UL)		/*!< RTC DR: YU (Bitfield-Mask: 0x0f) */
#define RTC_DR_YU                                                          RTC_DR_YU_Msk
#define RTC_DR_YU_0                                                        (0x1U << RTC_DR_YU_Pos)
#define RTC_DR_YU_1                                                        (0x2U << RTC_DR_YU_Pos)
#define RTC_DR_YU_2                                                        (0x4U << RTC_DR_YU_Pos)
#define RTC_DR_YU_3                                                        (0x8U << RTC_DR_YU_Pos)
#define RTC_DR_WDU_Pos                                                     (13UL)		/*!<RTC DR: WDU (Bit 13) */
#define RTC_DR_WDU_Msk                                                     (0xe000UL)		/*!< RTC DR: WDU (Bitfield-Mask: 0x07) */
#define RTC_DR_WDU                                                         RTC_DR_WDU_Msk
#define RTC_DR_WDU_0                                                       (0x1U << RTC_DR_WDU_Pos)
#define RTC_DR_WDU_1                                                       (0x2U << RTC_DR_WDU_Pos)
#define RTC_DR_WDU_2                                                       (0x4U << RTC_DR_WDU_Pos)
#define RTC_DR_MT_Pos                                                      (12UL)		/*!<RTC DR: MT (Bit 12) */
#define RTC_DR_MT_Msk                                                      (0x1000UL)		/*!< RTC DR: MT (Bitfield-Mask: 0x01) */
#define RTC_DR_MT                                                          RTC_DR_MT_Msk
#define RTC_DR_MU_Pos                                                      (8UL)		/*!<RTC DR: MU (Bit 8) */
#define RTC_DR_MU_Msk                                                      (0xf00UL)		/*!< RTC DR: MU (Bitfield-Mask: 0x0f) */
#define RTC_DR_MU                                                          RTC_DR_MU_Msk
#define RTC_DR_MU_0                                                        (0x1U << RTC_DR_MU_Pos)
#define RTC_DR_MU_1                                                        (0x2U << RTC_DR_MU_Pos)
#define RTC_DR_MU_2                                                        (0x4U << RTC_DR_MU_Pos)
#define RTC_DR_MU_3                                                        (0x8U << RTC_DR_MU_Pos)
#define RTC_DR_DT_Pos                                                      (4UL)		/*!<RTC DR: DT (Bit 4) */
#define RTC_DR_DT_Msk                                                      (0x30UL)		/*!< RTC DR: DT (Bitfield-Mask: 0x03) */
#define RTC_DR_DT                                                          RTC_DR_DT_Msk
#define RTC_DR_DT_0                                                        (0x1U << RTC_DR_DT_Pos)
#define RTC_DR_DT_1                                                        (0x2U << RTC_DR_DT_Pos)
#define RTC_DR_DU_Pos                                                      (0UL)		/*!<RTC DR: DU (Bit 0) */
#define RTC_DR_DU_Msk                                                      (0xfUL)		/*!< RTC DR: DU (Bitfield-Mask: 0x0f) */
#define RTC_DR_DU                                                          RTC_DR_DU_Msk
#define RTC_DR_DU_0                                                        (0x1U << RTC_DR_DU_Pos)
#define RTC_DR_DU_1                                                        (0x2U << RTC_DR_DU_Pos)
#define RTC_DR_DU_2                                                        (0x4U << RTC_DR_DU_Pos)
#define RTC_DR_DU_3                                                        (0x8U << RTC_DR_DU_Pos)

/* =====================================================    CR    ===================================================== */ 
#define RTC_CR_COE_Pos                                                     (23UL)		/*!<RTC CR: COE (Bit 23) */
#define RTC_CR_COE_Msk                                                     (0x800000UL)		/*!< RTC CR: COE (Bitfield-Mask: 0x01) */
#define RTC_CR_COE                                                         RTC_CR_COE_Msk
#define RTC_CR_OSEL_Pos                                                    (21UL)		/*!<RTC CR: OSEL (Bit 21) */
#define RTC_CR_OSEL_Msk                                                    (0x600000UL)		/*!< RTC CR: OSEL (Bitfield-Mask: 0x03) */
#define RTC_CR_OSEL                                                        RTC_CR_OSEL_Msk
#define RTC_CR_OSEL_0                                                      (0x1U << RTC_CR_OSEL_Pos)
#define RTC_CR_OSEL_1                                                      (0x2U << RTC_CR_OSEL_Pos)
#define RTC_CR_POL_Pos                                                     (20UL)		/*!<RTC CR: POL (Bit 20) */
#define RTC_CR_POL_Msk                                                     (0x100000UL)		/*!< RTC CR: POL (Bitfield-Mask: 0x01) */
#define RTC_CR_POL                                                         RTC_CR_POL_Msk
#define RTC_CR_COSEL_Pos                                                   (19UL)		/*!<RTC CR: COSEL (Bit 19) */
#define RTC_CR_COSEL_Msk                                                   (0x80000UL)		/*!< RTC CR: COSEL (Bitfield-Mask: 0x01) */
#define RTC_CR_COSEL                                                       RTC_CR_COSEL_Msk
#define RTC_CR_BKP_Pos                                                     (18UL)		/*!<RTC CR: BKP (Bit 18) */
#define RTC_CR_BKP_Msk                                                     (0x40000UL)		/*!< RTC CR: BKP (Bitfield-Mask: 0x01) */
#define RTC_CR_BKP                                                         RTC_CR_BKP_Msk
#define RTC_CR_SUB1H_Pos                                                   (17UL)		/*!<RTC CR: SUB1H (Bit 17) */
#define RTC_CR_SUB1H_Msk                                                   (0x20000UL)		/*!< RTC CR: SUB1H (Bitfield-Mask: 0x01) */
#define RTC_CR_SUB1H                                                       RTC_CR_SUB1H_Msk
#define RTC_CR_ADD1H_Pos                                                   (16UL)		/*!<RTC CR: ADD1H (Bit 16) */
#define RTC_CR_ADD1H_Msk                                                   (0x10000UL)		/*!< RTC CR: ADD1H (Bitfield-Mask: 0x01) */
#define RTC_CR_ADD1H                                                       RTC_CR_ADD1H_Msk
#define RTC_CR_WUTIE_Pos                                                   (14UL)		/*!<RTC CR: WUTIE (Bit 14) */
#define RTC_CR_WUTIE_Msk                                                   (0x4000UL)		/*!< RTC CR: WUTIE (Bitfield-Mask: 0x01) */
#define RTC_CR_WUTIE                                                       RTC_CR_WUTIE_Msk
#define RTC_CR_ALRAIE_Pos                                                  (12UL)		/*!<RTC CR: ALRAIE (Bit 12) */
#define RTC_CR_ALRAIE_Msk                                                  (0x1000UL)		/*!< RTC CR: ALRAIE (Bitfield-Mask: 0x01) */
#define RTC_CR_ALRAIE                                                      RTC_CR_ALRAIE_Msk
#define RTC_CR_WUTE_Pos                                                    (10UL)		/*!<RTC CR: WUTE (Bit 10) */
#define RTC_CR_WUTE_Msk                                                    (0x400UL)		/*!< RTC CR: WUTE (Bitfield-Mask: 0x01) */
#define RTC_CR_WUTE                                                        RTC_CR_WUTE_Msk
#define RTC_CR_ALRAE_Pos                                                   (8UL)		/*!<RTC CR: ALRAE (Bit 8) */
#define RTC_CR_ALRAE_Msk                                                   (0x100UL)		/*!< RTC CR: ALRAE (Bitfield-Mask: 0x01) */
#define RTC_CR_ALRAE                                                       RTC_CR_ALRAE_Msk
#define RTC_CR_FMT_Pos                                                     (6UL)		/*!<RTC CR: FMT (Bit 6) */
#define RTC_CR_FMT_Msk                                                     (0x40UL)		/*!< RTC CR: FMT (Bitfield-Mask: 0x01) */
#define RTC_CR_FMT                                                         RTC_CR_FMT_Msk
#define RTC_CR_BYPSHAD_Pos                                                 (5UL)		/*!<RTC CR: BYPSHAD (Bit 5) */
#define RTC_CR_BYPSHAD_Msk                                                 (0x20UL)		/*!< RTC CR: BYPSHAD (Bitfield-Mask: 0x01) */
#define RTC_CR_BYPSHAD                                                     RTC_CR_BYPSHAD_Msk
#define RTC_CR_WUCKSEL_Pos                                                 (0UL)		/*!<RTC CR: WUCKSEL (Bit 0) */
#define RTC_CR_WUCKSEL_Msk                                                 (0x7UL)		/*!< RTC CR: WUCKSEL (Bitfield-Mask: 0x07) */
#define RTC_CR_WUCKSEL                                                     RTC_CR_WUCKSEL_Msk
#define RTC_CR_WUCKSEL_0                                                   (0x1U << RTC_CR_WUCKSEL_Pos)
#define RTC_CR_WUCKSEL_1                                                   (0x2U << RTC_CR_WUCKSEL_Pos)
#define RTC_CR_WUCKSEL_2                                                   (0x4U << RTC_CR_WUCKSEL_Pos)

/* =====================================================    ISR    ===================================================== */ 
#define RTC_ISR_RECALPF_Pos                                                (16UL)		/*!<RTC ISR: RECALPF (Bit 16) */
#define RTC_ISR_RECALPF_Msk                                                (0x10000UL)		/*!< RTC ISR: RECALPF (Bitfield-Mask: 0x01) */
#define RTC_ISR_RECALPF                                                    RTC_ISR_RECALPF_Msk
#define RTC_ISR_WUTF_Pos                                                   (10UL)		/*!<RTC ISR: WUTF (Bit 10) */
#define RTC_ISR_WUTF_Msk                                                   (0x400UL)		/*!< RTC ISR: WUTF (Bitfield-Mask: 0x01) */
#define RTC_ISR_WUTF                                                       RTC_ISR_WUTF_Msk
#define RTC_ISR_ALRAF_Pos                                                  (8UL)		/*!<RTC ISR: ALRAF (Bit 8) */
#define RTC_ISR_ALRAF_Msk                                                  (0x100UL)		/*!< RTC ISR: ALRAF (Bitfield-Mask: 0x01) */
#define RTC_ISR_ALRAF                                                      RTC_ISR_ALRAF_Msk
#define RTC_ISR_INIT_Pos                                                   (7UL)		/*!<RTC ISR: INIT (Bit 7) */
#define RTC_ISR_INIT_Msk                                                   (0x80UL)		/*!< RTC ISR: INIT (Bitfield-Mask: 0x01) */
#define RTC_ISR_INIT                                                       RTC_ISR_INIT_Msk
#define RTC_ISR_INITF_Pos                                                  (6UL)		/*!<RTC ISR: INITF (Bit 6) */
#define RTC_ISR_INITF_Msk                                                  (0x40UL)		/*!< RTC ISR: INITF (Bitfield-Mask: 0x01) */
#define RTC_ISR_INITF                                                      RTC_ISR_INITF_Msk
#define RTC_ISR_RSF_Pos                                                    (5UL)		/*!<RTC ISR: RSF (Bit 5) */
#define RTC_ISR_RSF_Msk                                                    (0x20UL)		/*!< RTC ISR: RSF (Bitfield-Mask: 0x01) */
#define RTC_ISR_RSF                                                        RTC_ISR_RSF_Msk
#define RTC_ISR_INITS_Pos                                                  (4UL)		/*!<RTC ISR: INITS (Bit 4) */
#define RTC_ISR_INITS_Msk                                                  (0x10UL)		/*!< RTC ISR: INITS (Bitfield-Mask: 0x01) */
#define RTC_ISR_INITS                                                      RTC_ISR_INITS_Msk
#define RTC_ISR_SHPF_Pos                                                   (3UL)		/*!<RTC ISR: SHPF (Bit 3) */
#define RTC_ISR_SHPF_Msk                                                   (0x8UL)		/*!< RTC ISR: SHPF (Bitfield-Mask: 0x01) */
#define RTC_ISR_SHPF                                                       RTC_ISR_SHPF_Msk
#define RTC_ISR_WUTWF_Pos                                                  (2UL)		/*!<RTC ISR: WUTWF (Bit 2) */
#define RTC_ISR_WUTWF_Msk                                                  (0x4UL)		/*!< RTC ISR: WUTWF (Bitfield-Mask: 0x01) */
#define RTC_ISR_WUTWF                                                      RTC_ISR_WUTWF_Msk
#define RTC_ISR_ALRAWF_Pos                                                 (0UL)		/*!<RTC ISR: ALRAWF (Bit 0) */
#define RTC_ISR_ALRAWF_Msk                                                 (0x1UL)		/*!< RTC ISR: ALRAWF (Bitfield-Mask: 0x01) */
#define RTC_ISR_ALRAWF                                                     RTC_ISR_ALRAWF_Msk

/* =====================================================    PRER    ===================================================== */ 
#define RTC_PRER_PREDIV_A_Pos                                              (16UL)		/*!<RTC PRER: PREDIV_A (Bit 16) */
#define RTC_PRER_PREDIV_A_Msk                                              (0x7f0000UL)		/*!< RTC PRER: PREDIV_A (Bitfield-Mask: 0x7f) */
#define RTC_PRER_PREDIV_A                                                  RTC_PRER_PREDIV_A_Msk
#define RTC_PRER_PREDIV_A_0                                                (0x1U << RTC_PRER_PREDIV_A_Pos)
#define RTC_PRER_PREDIV_A_1                                                (0x2U << RTC_PRER_PREDIV_A_Pos)
#define RTC_PRER_PREDIV_A_2                                                (0x4U << RTC_PRER_PREDIV_A_Pos)
#define RTC_PRER_PREDIV_A_3                                                (0x8U << RTC_PRER_PREDIV_A_Pos)
#define RTC_PRER_PREDIV_A_4                                                (0x10U << RTC_PRER_PREDIV_A_Pos)
#define RTC_PRER_PREDIV_A_5                                                (0x20U << RTC_PRER_PREDIV_A_Pos)
#define RTC_PRER_PREDIV_A_6                                                (0x40U << RTC_PRER_PREDIV_A_Pos)
#define RTC_PRER_PREDIV_S_Pos                                              (0UL)		/*!<RTC PRER: PREDIV_S (Bit 0) */
#define RTC_PRER_PREDIV_S_Msk                                              (0x7fffUL)		/*!< RTC PRER: PREDIV_S (Bitfield-Mask: 0x7fff) */
#define RTC_PRER_PREDIV_S                                                  RTC_PRER_PREDIV_S_Msk
#define RTC_PRER_PREDIV_S_0                                                (0x1U << RTC_PRER_PREDIV_S_Pos)
#define RTC_PRER_PREDIV_S_1                                                (0x2U << RTC_PRER_PREDIV_S_Pos)
#define RTC_PRER_PREDIV_S_2                                                (0x4U << RTC_PRER_PREDIV_S_Pos)
#define RTC_PRER_PREDIV_S_3                                                (0x8U << RTC_PRER_PREDIV_S_Pos)
#define RTC_PRER_PREDIV_S_4                                                (0x10U << RTC_PRER_PREDIV_S_Pos)
#define RTC_PRER_PREDIV_S_5                                                (0x20U << RTC_PRER_PREDIV_S_Pos)
#define RTC_PRER_PREDIV_S_6                                                (0x40U << RTC_PRER_PREDIV_S_Pos)
#define RTC_PRER_PREDIV_S_7                                                (0x80U << RTC_PRER_PREDIV_S_Pos)
#define RTC_PRER_PREDIV_S_8                                                (0x100U << RTC_PRER_PREDIV_S_Pos)
#define RTC_PRER_PREDIV_S_9                                                (0x200U << RTC_PRER_PREDIV_S_Pos)
#define RTC_PRER_PREDIV_S_10                                               (0x400U << RTC_PRER_PREDIV_S_Pos)
#define RTC_PRER_PREDIV_S_11                                               (0x800U << RTC_PRER_PREDIV_S_Pos)
#define RTC_PRER_PREDIV_S_12                                               (0x1000U << RTC_PRER_PREDIV_S_Pos)
#define RTC_PRER_PREDIV_S_13                                               (0x2000U << RTC_PRER_PREDIV_S_Pos)
#define RTC_PRER_PREDIV_S_14                                               (0x4000U << RTC_PRER_PREDIV_S_Pos)

/* =====================================================    WUTR    ===================================================== */ 
#define RTC_WUTR_WUT_Pos                                                   (0UL)		/*!<RTC WUTR: WUT (Bit 0) */
#define RTC_WUTR_WUT_Msk                                                   (0xffffUL)		/*!< RTC WUTR: WUT (Bitfield-Mask: 0xffff) */
#define RTC_WUTR_WUT                                                       RTC_WUTR_WUT_Msk
#define RTC_WUTR_WUT_0                                                     (0x1U << RTC_WUTR_WUT_Pos)
#define RTC_WUTR_WUT_1                                                     (0x2U << RTC_WUTR_WUT_Pos)
#define RTC_WUTR_WUT_2                                                     (0x4U << RTC_WUTR_WUT_Pos)
#define RTC_WUTR_WUT_3                                                     (0x8U << RTC_WUTR_WUT_Pos)
#define RTC_WUTR_WUT_4                                                     (0x10U << RTC_WUTR_WUT_Pos)
#define RTC_WUTR_WUT_5                                                     (0x20U << RTC_WUTR_WUT_Pos)
#define RTC_WUTR_WUT_6                                                     (0x40U << RTC_WUTR_WUT_Pos)
#define RTC_WUTR_WUT_7                                                     (0x80U << RTC_WUTR_WUT_Pos)
#define RTC_WUTR_WUT_8                                                     (0x100U << RTC_WUTR_WUT_Pos)
#define RTC_WUTR_WUT_9                                                     (0x200U << RTC_WUTR_WUT_Pos)
#define RTC_WUTR_WUT_10                                                    (0x400U << RTC_WUTR_WUT_Pos)
#define RTC_WUTR_WUT_11                                                    (0x800U << RTC_WUTR_WUT_Pos)
#define RTC_WUTR_WUT_12                                                    (0x1000U << RTC_WUTR_WUT_Pos)
#define RTC_WUTR_WUT_13                                                    (0x2000U << RTC_WUTR_WUT_Pos)
#define RTC_WUTR_WUT_14                                                    (0x4000U << RTC_WUTR_WUT_Pos)
#define RTC_WUTR_WUT_15                                                    (0x8000U << RTC_WUTR_WUT_Pos)

/* =====================================================    ALRMAR    ===================================================== */ 
#define RTC_ALRMAR_MSK4_Pos                                                (31UL)		/*!<RTC ALRMAR: MSK4 (Bit 31) */
#define RTC_ALRMAR_MSK4_Msk                                                (0x80000000UL)		/*!< RTC ALRMAR: MSK4 (Bitfield-Mask: 0x01) */
#define RTC_ALRMAR_MSK4                                                    RTC_ALRMAR_MSK4_Msk
#define RTC_ALRMAR_WDSEL_Pos                                               (30UL)		/*!<RTC ALRMAR: WDSEL (Bit 30) */
#define RTC_ALRMAR_WDSEL_Msk                                               (0x40000000UL)		/*!< RTC ALRMAR: WDSEL (Bitfield-Mask: 0x01) */
#define RTC_ALRMAR_WDSEL                                                   RTC_ALRMAR_WDSEL_Msk
#define RTC_ALRMAR_DT_Pos                                                  (28UL)		/*!<RTC ALRMAR: DT (Bit 28) */
#define RTC_ALRMAR_DT_Msk                                                  (0x30000000UL)		/*!< RTC ALRMAR: DT (Bitfield-Mask: 0x03) */
#define RTC_ALRMAR_DT                                                      RTC_ALRMAR_DT_Msk
#define RTC_ALRMAR_DT_0                                                    (0x1U << RTC_ALRMAR_DT_Pos)
#define RTC_ALRMAR_DT_1                                                    (0x2U << RTC_ALRMAR_DT_Pos)
#define RTC_ALRMAR_DU_Pos                                                  (24UL)		/*!<RTC ALRMAR: DU (Bit 24) */
#define RTC_ALRMAR_DU_Msk                                                  (0xf000000UL)		/*!< RTC ALRMAR: DU (Bitfield-Mask: 0x0f) */
#define RTC_ALRMAR_DU                                                      RTC_ALRMAR_DU_Msk
#define RTC_ALRMAR_DU_0                                                    (0x1U << RTC_ALRMAR_DU_Pos)
#define RTC_ALRMAR_DU_1                                                    (0x2U << RTC_ALRMAR_DU_Pos)
#define RTC_ALRMAR_DU_2                                                    (0x4U << RTC_ALRMAR_DU_Pos)
#define RTC_ALRMAR_DU_3                                                    (0x8U << RTC_ALRMAR_DU_Pos)
#define RTC_ALRMAR_MSK3_Pos                                                (23UL)		/*!<RTC ALRMAR: MSK3 (Bit 23) */
#define RTC_ALRMAR_MSK3_Msk                                                (0x800000UL)		/*!< RTC ALRMAR: MSK3 (Bitfield-Mask: 0x01) */
#define RTC_ALRMAR_MSK3                                                    RTC_ALRMAR_MSK3_Msk
#define RTC_ALRMAR_PM_Pos                                                  (22UL)		/*!<RTC ALRMAR: PM (Bit 22) */
#define RTC_ALRMAR_PM_Msk                                                  (0x400000UL)		/*!< RTC ALRMAR: PM (Bitfield-Mask: 0x01) */
#define RTC_ALRMAR_PM                                                      RTC_ALRMAR_PM_Msk
#define RTC_ALRMAR_HT_Pos                                                  (20UL)		/*!<RTC ALRMAR: HT (Bit 20) */
#define RTC_ALRMAR_HT_Msk                                                  (0x300000UL)		/*!< RTC ALRMAR: HT (Bitfield-Mask: 0x03) */
#define RTC_ALRMAR_HT                                                      RTC_ALRMAR_HT_Msk
#define RTC_ALRMAR_HT_0                                                    (0x1U << RTC_ALRMAR_HT_Pos)
#define RTC_ALRMAR_HT_1                                                    (0x2U << RTC_ALRMAR_HT_Pos)
#define RTC_ALRMAR_HU_Pos                                                  (16UL)		/*!<RTC ALRMAR: HU (Bit 16) */
#define RTC_ALRMAR_HU_Msk                                                  (0xf0000UL)		/*!< RTC ALRMAR: HU (Bitfield-Mask: 0x0f) */
#define RTC_ALRMAR_HU                                                      RTC_ALRMAR_HU_Msk
#define RTC_ALRMAR_HU_0                                                    (0x1U << RTC_ALRMAR_HU_Pos)
#define RTC_ALRMAR_HU_1                                                    (0x2U << RTC_ALRMAR_HU_Pos)
#define RTC_ALRMAR_HU_2                                                    (0x4U << RTC_ALRMAR_HU_Pos)
#define RTC_ALRMAR_HU_3                                                    (0x8U << RTC_ALRMAR_HU_Pos)
#define RTC_ALRMAR_MSK2_Pos                                                (15UL)		/*!<RTC ALRMAR: MSK2 (Bit 15) */
#define RTC_ALRMAR_MSK2_Msk                                                (0x8000UL)		/*!< RTC ALRMAR: MSK2 (Bitfield-Mask: 0x01) */
#define RTC_ALRMAR_MSK2                                                    RTC_ALRMAR_MSK2_Msk
#define RTC_ALRMAR_MNT_Pos                                                 (12UL)		/*!<RTC ALRMAR: MNT (Bit 12) */
#define RTC_ALRMAR_MNT_Msk                                                 (0x7000UL)		/*!< RTC ALRMAR: MNT (Bitfield-Mask: 0x07) */
#define RTC_ALRMAR_MNT                                                     RTC_ALRMAR_MNT_Msk
#define RTC_ALRMAR_MNT_0                                                   (0x1U << RTC_ALRMAR_MNT_Pos)
#define RTC_ALRMAR_MNT_1                                                   (0x2U << RTC_ALRMAR_MNT_Pos)
#define RTC_ALRMAR_MNT_2                                                   (0x4U << RTC_ALRMAR_MNT_Pos)
#define RTC_ALRMAR_MNU_Pos                                                 (8UL)		/*!<RTC ALRMAR: MNU (Bit 8) */
#define RTC_ALRMAR_MNU_Msk                                                 (0xf00UL)		/*!< RTC ALRMAR: MNU (Bitfield-Mask: 0x0f) */
#define RTC_ALRMAR_MNU                                                     RTC_ALRMAR_MNU_Msk
#define RTC_ALRMAR_MNU_0                                                   (0x1U << RTC_ALRMAR_MNU_Pos)
#define RTC_ALRMAR_MNU_1                                                   (0x2U << RTC_ALRMAR_MNU_Pos)
#define RTC_ALRMAR_MNU_2                                                   (0x4U << RTC_ALRMAR_MNU_Pos)
#define RTC_ALRMAR_MNU_3                                                   (0x8U << RTC_ALRMAR_MNU_Pos)
#define RTC_ALRMAR_MSK1_Pos                                                (7UL)		/*!<RTC ALRMAR: MSK1 (Bit 7) */
#define RTC_ALRMAR_MSK1_Msk                                                (0x80UL)		/*!< RTC ALRMAR: MSK1 (Bitfield-Mask: 0x01) */
#define RTC_ALRMAR_MSK1                                                    RTC_ALRMAR_MSK1_Msk
#define RTC_ALRMAR_ST_Pos                                                  (4UL)		/*!<RTC ALRMAR: ST (Bit 4) */
#define RTC_ALRMAR_ST_Msk                                                  (0x70UL)		/*!< RTC ALRMAR: ST (Bitfield-Mask: 0x07) */
#define RTC_ALRMAR_ST                                                      RTC_ALRMAR_ST_Msk
#define RTC_ALRMAR_ST_0                                                    (0x1U << RTC_ALRMAR_ST_Pos)
#define RTC_ALRMAR_ST_1                                                    (0x2U << RTC_ALRMAR_ST_Pos)
#define RTC_ALRMAR_ST_2                                                    (0x4U << RTC_ALRMAR_ST_Pos)
#define RTC_ALRMAR_SU_Pos                                                  (0UL)		/*!<RTC ALRMAR: SU (Bit 0) */
#define RTC_ALRMAR_SU_Msk                                                  (0xfUL)		/*!< RTC ALRMAR: SU (Bitfield-Mask: 0x0f) */
#define RTC_ALRMAR_SU                                                      RTC_ALRMAR_SU_Msk
#define RTC_ALRMAR_SU_0                                                    (0x1U << RTC_ALRMAR_SU_Pos)
#define RTC_ALRMAR_SU_1                                                    (0x2U << RTC_ALRMAR_SU_Pos)
#define RTC_ALRMAR_SU_2                                                    (0x4U << RTC_ALRMAR_SU_Pos)
#define RTC_ALRMAR_SU_3                                                    (0x8U << RTC_ALRMAR_SU_Pos)

/* =====================================================    WPR    ===================================================== */ 
#define RTC_WPR_KEY_Pos                                                    (0UL)		/*!<RTC WPR: KEY (Bit 0) */
#define RTC_WPR_KEY_Msk                                                    (0xffUL)		/*!< RTC WPR: KEY (Bitfield-Mask: 0xff) */
#define RTC_WPR_KEY                                                        RTC_WPR_KEY_Msk
#define RTC_WPR_KEY_0                                                      (0x1U << RTC_WPR_KEY_Pos)
#define RTC_WPR_KEY_1                                                      (0x2U << RTC_WPR_KEY_Pos)
#define RTC_WPR_KEY_2                                                      (0x4U << RTC_WPR_KEY_Pos)
#define RTC_WPR_KEY_3                                                      (0x8U << RTC_WPR_KEY_Pos)
#define RTC_WPR_KEY_4                                                      (0x10U << RTC_WPR_KEY_Pos)
#define RTC_WPR_KEY_5                                                      (0x20U << RTC_WPR_KEY_Pos)
#define RTC_WPR_KEY_6                                                      (0x40U << RTC_WPR_KEY_Pos)
#define RTC_WPR_KEY_7                                                      (0x80U << RTC_WPR_KEY_Pos)

/* =====================================================    SSR    ===================================================== */ 
#define RTC_SSR_SS_Pos                                                     (0UL)		/*!<RTC SSR: SS (Bit 0) */
#define RTC_SSR_SS_Msk                                                     (0xffffUL)		/*!< RTC SSR: SS (Bitfield-Mask: 0xffff) */
#define RTC_SSR_SS                                                         RTC_SSR_SS_Msk
#define RTC_SSR_SS_0                                                       (0x1U << RTC_SSR_SS_Pos)
#define RTC_SSR_SS_1                                                       (0x2U << RTC_SSR_SS_Pos)
#define RTC_SSR_SS_2                                                       (0x4U << RTC_SSR_SS_Pos)
#define RTC_SSR_SS_3                                                       (0x8U << RTC_SSR_SS_Pos)
#define RTC_SSR_SS_4                                                       (0x10U << RTC_SSR_SS_Pos)
#define RTC_SSR_SS_5                                                       (0x20U << RTC_SSR_SS_Pos)
#define RTC_SSR_SS_6                                                       (0x40U << RTC_SSR_SS_Pos)
#define RTC_SSR_SS_7                                                       (0x80U << RTC_SSR_SS_Pos)
#define RTC_SSR_SS_8                                                       (0x100U << RTC_SSR_SS_Pos)
#define RTC_SSR_SS_9                                                       (0x200U << RTC_SSR_SS_Pos)
#define RTC_SSR_SS_10                                                      (0x400U << RTC_SSR_SS_Pos)
#define RTC_SSR_SS_11                                                      (0x800U << RTC_SSR_SS_Pos)
#define RTC_SSR_SS_12                                                      (0x1000U << RTC_SSR_SS_Pos)
#define RTC_SSR_SS_13                                                      (0x2000U << RTC_SSR_SS_Pos)
#define RTC_SSR_SS_14                                                      (0x4000U << RTC_SSR_SS_Pos)
#define RTC_SSR_SS_15                                                      (0x8000U << RTC_SSR_SS_Pos)

/* =====================================================    SHIFTR    ===================================================== */ 
#define RTC_SHIFTR_ADD1S_Pos                                               (31UL)		/*!<RTC SHIFTR: ADD1S (Bit 31) */
#define RTC_SHIFTR_ADD1S_Msk                                               (0x80000000UL)		/*!< RTC SHIFTR: ADD1S (Bitfield-Mask: 0x01) */
#define RTC_SHIFTR_ADD1S                                                   RTC_SHIFTR_ADD1S_Msk
#define RTC_SHIFTR_SUBFS_Pos                                               (0UL)		/*!<RTC SHIFTR: SUBFS (Bit 0) */
#define RTC_SHIFTR_SUBFS_Msk                                               (0x7fffUL)		/*!< RTC SHIFTR: SUBFS (Bitfield-Mask: 0x7fff) */
#define RTC_SHIFTR_SUBFS                                                   RTC_SHIFTR_SUBFS_Msk
#define RTC_SHIFTR_SUBFS_0                                                 (0x1U << RTC_SHIFTR_SUBFS_Pos)
#define RTC_SHIFTR_SUBFS_1                                                 (0x2U << RTC_SHIFTR_SUBFS_Pos)
#define RTC_SHIFTR_SUBFS_2                                                 (0x4U << RTC_SHIFTR_SUBFS_Pos)
#define RTC_SHIFTR_SUBFS_3                                                 (0x8U << RTC_SHIFTR_SUBFS_Pos)
#define RTC_SHIFTR_SUBFS_4                                                 (0x10U << RTC_SHIFTR_SUBFS_Pos)
#define RTC_SHIFTR_SUBFS_5                                                 (0x20U << RTC_SHIFTR_SUBFS_Pos)
#define RTC_SHIFTR_SUBFS_6                                                 (0x40U << RTC_SHIFTR_SUBFS_Pos)
#define RTC_SHIFTR_SUBFS_7                                                 (0x80U << RTC_SHIFTR_SUBFS_Pos)
#define RTC_SHIFTR_SUBFS_8                                                 (0x100U << RTC_SHIFTR_SUBFS_Pos)
#define RTC_SHIFTR_SUBFS_9                                                 (0x200U << RTC_SHIFTR_SUBFS_Pos)
#define RTC_SHIFTR_SUBFS_10                                                (0x400U << RTC_SHIFTR_SUBFS_Pos)
#define RTC_SHIFTR_SUBFS_11                                                (0x800U << RTC_SHIFTR_SUBFS_Pos)
#define RTC_SHIFTR_SUBFS_12                                                (0x1000U << RTC_SHIFTR_SUBFS_Pos)
#define RTC_SHIFTR_SUBFS_13                                                (0x2000U << RTC_SHIFTR_SUBFS_Pos)
#define RTC_SHIFTR_SUBFS_14                                                (0x4000U << RTC_SHIFTR_SUBFS_Pos)

/* =====================================================    CALR    ===================================================== */ 
#define RTC_CALR_CALP_Pos                                                  (15UL)		/*!<RTC CALR: CALP (Bit 15) */
#define RTC_CALR_CALP_Msk                                                  (0x8000UL)		/*!< RTC CALR: CALP (Bitfield-Mask: 0x01) */
#define RTC_CALR_CALP                                                      RTC_CALR_CALP_Msk
#define RTC_CALR_CALW8_Pos                                                 (14UL)		/*!<RTC CALR: CALW8 (Bit 14) */
#define RTC_CALR_CALW8_Msk                                                 (0x4000UL)		/*!< RTC CALR: CALW8 (Bitfield-Mask: 0x01) */
#define RTC_CALR_CALW8                                                     RTC_CALR_CALW8_Msk
#define RTC_CALR_CALW16_Pos                                                (13UL)		/*!<RTC CALR: CALW16 (Bit 13) */
#define RTC_CALR_CALW16_Msk                                                (0x2000UL)		/*!< RTC CALR: CALW16 (Bitfield-Mask: 0x01) */
#define RTC_CALR_CALW16                                                    RTC_CALR_CALW16_Msk
#define RTC_CALR_CALM_Pos                                                  (0UL)		/*!<RTC CALR: CALM (Bit 0) */
#define RTC_CALR_CALM_Msk                                                  (0x1ffUL)		/*!< RTC CALR: CALM (Bitfield-Mask: 0x1ff) */
#define RTC_CALR_CALM                                                      RTC_CALR_CALM_Msk
#define RTC_CALR_CALM_0                                                    (0x1U << RTC_CALR_CALM_Pos)
#define RTC_CALR_CALM_1                                                    (0x2U << RTC_CALR_CALM_Pos)
#define RTC_CALR_CALM_2                                                    (0x4U << RTC_CALR_CALM_Pos)
#define RTC_CALR_CALM_3                                                    (0x8U << RTC_CALR_CALM_Pos)
#define RTC_CALR_CALM_4                                                    (0x10U << RTC_CALR_CALM_Pos)
#define RTC_CALR_CALM_5                                                    (0x20U << RTC_CALR_CALM_Pos)
#define RTC_CALR_CALM_6                                                    (0x40U << RTC_CALR_CALM_Pos)
#define RTC_CALR_CALM_7                                                    (0x80U << RTC_CALR_CALM_Pos)
#define RTC_CALR_CALM_8                                                    (0x100U << RTC_CALR_CALM_Pos)

/* =====================================================    ALRMASSR    ===================================================== */ 
#define RTC_ALRMASSR_MASKSS_Pos                                            (24UL)		/*!<RTC ALRMASSR: MASKSS (Bit 24) */
#define RTC_ALRMASSR_MASKSS_Msk                                            (0xf000000UL)		/*!< RTC ALRMASSR: MASKSS (Bitfield-Mask: 0x0f) */
#define RTC_ALRMASSR_MASKSS                                                RTC_ALRMASSR_MASKSS_Msk
#define RTC_ALRMASSR_MASKSS_0                                              (0x1U << RTC_ALRMASSR_MASKSS_Pos)
#define RTC_ALRMASSR_MASKSS_1                                              (0x2U << RTC_ALRMASSR_MASKSS_Pos)
#define RTC_ALRMASSR_MASKSS_2                                              (0x4U << RTC_ALRMASSR_MASKSS_Pos)
#define RTC_ALRMASSR_MASKSS_3                                              (0x8U << RTC_ALRMASSR_MASKSS_Pos)
#define RTC_ALRMASSR_SS_Pos                                                (0UL)		/*!<RTC ALRMASSR: SS (Bit 0) */
#define RTC_ALRMASSR_SS_Msk                                                (0x7fffUL)		/*!< RTC ALRMASSR: SS (Bitfield-Mask: 0x7fff) */
#define RTC_ALRMASSR_SS                                                    RTC_ALRMASSR_SS_Msk
#define RTC_ALRMASSR_SS_0                                                  (0x1U << RTC_ALRMASSR_SS_Pos)
#define RTC_ALRMASSR_SS_1                                                  (0x2U << RTC_ALRMASSR_SS_Pos)
#define RTC_ALRMASSR_SS_2                                                  (0x4U << RTC_ALRMASSR_SS_Pos)
#define RTC_ALRMASSR_SS_3                                                  (0x8U << RTC_ALRMASSR_SS_Pos)
#define RTC_ALRMASSR_SS_4                                                  (0x10U << RTC_ALRMASSR_SS_Pos)
#define RTC_ALRMASSR_SS_5                                                  (0x20U << RTC_ALRMASSR_SS_Pos)
#define RTC_ALRMASSR_SS_6                                                  (0x40U << RTC_ALRMASSR_SS_Pos)
#define RTC_ALRMASSR_SS_7                                                  (0x80U << RTC_ALRMASSR_SS_Pos)
#define RTC_ALRMASSR_SS_8                                                  (0x100U << RTC_ALRMASSR_SS_Pos)
#define RTC_ALRMASSR_SS_9                                                  (0x200U << RTC_ALRMASSR_SS_Pos)
#define RTC_ALRMASSR_SS_10                                                 (0x400U << RTC_ALRMASSR_SS_Pos)
#define RTC_ALRMASSR_SS_11                                                 (0x800U << RTC_ALRMASSR_SS_Pos)
#define RTC_ALRMASSR_SS_12                                                 (0x1000U << RTC_ALRMASSR_SS_Pos)
#define RTC_ALRMASSR_SS_13                                                 (0x2000U << RTC_ALRMASSR_SS_Pos)
#define RTC_ALRMASSR_SS_14                                                 (0x4000U << RTC_ALRMASSR_SS_Pos)

/* =====================================================    BKP0R    ===================================================== */ 
#define RTC_BKP0R_BKP_Pos                                                  (0UL)		/*!<RTC BKP0R: BKP (Bit 0) */
#define RTC_BKP0R_BKP_Msk                                                  (0xffffffffUL)		/*!< RTC BKP0R: BKP (Bitfield-Mask: 0xffffffff) */
#define RTC_BKP0R_BKP                                                      RTC_BKP0R_BKP_Msk
#define RTC_BKP0R_BKP_0                                                    (0x1U << RTC_BKP0R_BKP_Pos)
#define RTC_BKP0R_BKP_1                                                    (0x2U << RTC_BKP0R_BKP_Pos)
#define RTC_BKP0R_BKP_2                                                    (0x4U << RTC_BKP0R_BKP_Pos)
#define RTC_BKP0R_BKP_3                                                    (0x8U << RTC_BKP0R_BKP_Pos)
#define RTC_BKP0R_BKP_4                                                    (0x10U << RTC_BKP0R_BKP_Pos)
#define RTC_BKP0R_BKP_5                                                    (0x20U << RTC_BKP0R_BKP_Pos)
#define RTC_BKP0R_BKP_6                                                    (0x40U << RTC_BKP0R_BKP_Pos)
#define RTC_BKP0R_BKP_7                                                    (0x80U << RTC_BKP0R_BKP_Pos)
#define RTC_BKP0R_BKP_8                                                    (0x100U << RTC_BKP0R_BKP_Pos)
#define RTC_BKP0R_BKP_9                                                    (0x200U << RTC_BKP0R_BKP_Pos)
#define RTC_BKP0R_BKP_10                                                   (0x400U << RTC_BKP0R_BKP_Pos)
#define RTC_BKP0R_BKP_11                                                   (0x800U << RTC_BKP0R_BKP_Pos)
#define RTC_BKP0R_BKP_12                                                   (0x1000U << RTC_BKP0R_BKP_Pos)
#define RTC_BKP0R_BKP_13                                                   (0x2000U << RTC_BKP0R_BKP_Pos)
#define RTC_BKP0R_BKP_14                                                   (0x4000U << RTC_BKP0R_BKP_Pos)
#define RTC_BKP0R_BKP_15                                                   (0x8000U << RTC_BKP0R_BKP_Pos)
#define RTC_BKP0R_BKP_16                                                   (0x10000U << RTC_BKP0R_BKP_Pos)
#define RTC_BKP0R_BKP_17                                                   (0x20000U << RTC_BKP0R_BKP_Pos)
#define RTC_BKP0R_BKP_18                                                   (0x40000U << RTC_BKP0R_BKP_Pos)
#define RTC_BKP0R_BKP_19                                                   (0x80000U << RTC_BKP0R_BKP_Pos)
#define RTC_BKP0R_BKP_20                                                   (0x100000U << RTC_BKP0R_BKP_Pos)
#define RTC_BKP0R_BKP_21                                                   (0x200000U << RTC_BKP0R_BKP_Pos)
#define RTC_BKP0R_BKP_22                                                   (0x400000U << RTC_BKP0R_BKP_Pos)
#define RTC_BKP0R_BKP_23                                                   (0x800000U << RTC_BKP0R_BKP_Pos)
#define RTC_BKP0R_BKP_24                                                   (0x1000000U << RTC_BKP0R_BKP_Pos)
#define RTC_BKP0R_BKP_25                                                   (0x2000000U << RTC_BKP0R_BKP_Pos)
#define RTC_BKP0R_BKP_26                                                   (0x4000000U << RTC_BKP0R_BKP_Pos)
#define RTC_BKP0R_BKP_27                                                   (0x8000000U << RTC_BKP0R_BKP_Pos)
#define RTC_BKP0R_BKP_28                                                   (0x10000000U << RTC_BKP0R_BKP_Pos)
#define RTC_BKP0R_BKP_29                                                   (0x20000000U << RTC_BKP0R_BKP_Pos)
#define RTC_BKP0R_BKP_30                                                   (0x40000000U << RTC_BKP0R_BKP_Pos)
#define RTC_BKP0R_BKP_31                                                   (0x80000000UL << RTC_BKP0R_BKP_Pos)

/* =====================================================    BKP1R    ===================================================== */ 
#define RTC_BKP1R_BKP_Pos                                                  (0UL)		/*!<RTC BKP1R: BKP (Bit 0) */
#define RTC_BKP1R_BKP_Msk                                                  (0xffffffffUL)		/*!< RTC BKP1R: BKP (Bitfield-Mask: 0xffffffff) */
#define RTC_BKP1R_BKP                                                      RTC_BKP1R_BKP_Msk
#define RTC_BKP1R_BKP_0                                                    (0x1U << RTC_BKP1R_BKP_Pos)
#define RTC_BKP1R_BKP_1                                                    (0x2U << RTC_BKP1R_BKP_Pos)
#define RTC_BKP1R_BKP_2                                                    (0x4U << RTC_BKP1R_BKP_Pos)
#define RTC_BKP1R_BKP_3                                                    (0x8U << RTC_BKP1R_BKP_Pos)
#define RTC_BKP1R_BKP_4                                                    (0x10U << RTC_BKP1R_BKP_Pos)
#define RTC_BKP1R_BKP_5                                                    (0x20U << RTC_BKP1R_BKP_Pos)
#define RTC_BKP1R_BKP_6                                                    (0x40U << RTC_BKP1R_BKP_Pos)
#define RTC_BKP1R_BKP_7                                                    (0x80U << RTC_BKP1R_BKP_Pos)
#define RTC_BKP1R_BKP_8                                                    (0x100U << RTC_BKP1R_BKP_Pos)
#define RTC_BKP1R_BKP_9                                                    (0x200U << RTC_BKP1R_BKP_Pos)
#define RTC_BKP1R_BKP_10                                                   (0x400U << RTC_BKP1R_BKP_Pos)
#define RTC_BKP1R_BKP_11                                                   (0x800U << RTC_BKP1R_BKP_Pos)
#define RTC_BKP1R_BKP_12                                                   (0x1000U << RTC_BKP1R_BKP_Pos)
#define RTC_BKP1R_BKP_13                                                   (0x2000U << RTC_BKP1R_BKP_Pos)
#define RTC_BKP1R_BKP_14                                                   (0x4000U << RTC_BKP1R_BKP_Pos)
#define RTC_BKP1R_BKP_15                                                   (0x8000U << RTC_BKP1R_BKP_Pos)
#define RTC_BKP1R_BKP_16                                                   (0x10000U << RTC_BKP1R_BKP_Pos)
#define RTC_BKP1R_BKP_17                                                   (0x20000U << RTC_BKP1R_BKP_Pos)
#define RTC_BKP1R_BKP_18                                                   (0x40000U << RTC_BKP1R_BKP_Pos)
#define RTC_BKP1R_BKP_19                                                   (0x80000U << RTC_BKP1R_BKP_Pos)
#define RTC_BKP1R_BKP_20                                                   (0x100000U << RTC_BKP1R_BKP_Pos)
#define RTC_BKP1R_BKP_21                                                   (0x200000U << RTC_BKP1R_BKP_Pos)
#define RTC_BKP1R_BKP_22                                                   (0x400000U << RTC_BKP1R_BKP_Pos)
#define RTC_BKP1R_BKP_23                                                   (0x800000U << RTC_BKP1R_BKP_Pos)
#define RTC_BKP1R_BKP_24                                                   (0x1000000U << RTC_BKP1R_BKP_Pos)
#define RTC_BKP1R_BKP_25                                                   (0x2000000U << RTC_BKP1R_BKP_Pos)
#define RTC_BKP1R_BKP_26                                                   (0x4000000U << RTC_BKP1R_BKP_Pos)
#define RTC_BKP1R_BKP_27                                                   (0x8000000U << RTC_BKP1R_BKP_Pos)
#define RTC_BKP1R_BKP_28                                                   (0x10000000U << RTC_BKP1R_BKP_Pos)
#define RTC_BKP1R_BKP_29                                                   (0x20000000U << RTC_BKP1R_BKP_Pos)
#define RTC_BKP1R_BKP_30                                                   (0x40000000U << RTC_BKP1R_BKP_Pos)
#define RTC_BKP1R_BKP_31                                                   (0x80000000UL << RTC_BKP1R_BKP_Pos)

/******************** Number of backup registers ******************************/
#define RTC_BKP_NUMBER                 (2U)

/* =========================================================================================================================== */
/* ================                                            PKA                                            ================ */
/* =========================================================================================================================== */

/* =====================================================    CSR    ===================================================== */ 
#define PKA_CSR_SFT_RST_Pos                                                (7UL)		/*!<PKA CSR: SFT_RST (Bit 7) */
#define PKA_CSR_SFT_RST_Msk                                                (0x80UL)		/*!< PKA CSR: SFT_RST (Bitfield-Mask: 0x01) */
#define PKA_CSR_SFT_RST                                                    PKA_CSR_SFT_RST_Msk
#define PKA_CSR_READY_Pos                                                  (1UL)		/*!<PKA CSR: READY (Bit 1) */
#define PKA_CSR_READY_Msk                                                  (0x2UL)		/*!< PKA CSR: READY (Bitfield-Mask: 0x01) */
#define PKA_CSR_READY                                                      PKA_CSR_READY_Msk
#define PKA_CSR_GO_Pos                                                     (0UL)		/*!<PKA CSR: GO (Bit 0) */
#define PKA_CSR_GO_Msk                                                     (0x1UL)		/*!< PKA CSR: GO (Bitfield-Mask: 0x01) */
#define PKA_CSR_GO                                                         PKA_CSR_GO_Msk

/* =====================================================    ISR    ===================================================== */ 
#define PKA_ISR_ADD_ERR_Pos                                                (3UL)		/*!<PKA ISR: ADD_ERR (Bit 3) */
#define PKA_ISR_ADD_ERR_Msk                                                (0x8UL)		/*!< PKA ISR: ADD_ERR (Bitfield-Mask: 0x01) */
#define PKA_ISR_ADD_ERR                                                    PKA_ISR_ADD_ERR_Msk
#define PKA_ISR_RAM_ERR_Pos                                                (2UL)		/*!<PKA ISR: RAM_ERR (Bit 2) */
#define PKA_ISR_RAM_ERR_Msk                                                (0x4UL)		/*!< PKA ISR: RAM_ERR (Bitfield-Mask: 0x01) */
#define PKA_ISR_RAM_ERR                                                    PKA_ISR_RAM_ERR_Msk
#define PKA_ISR_PROC_END_Pos                                               (0UL)		/*!<PKA ISR: PROC_END (Bit 0) */
#define PKA_ISR_PROC_END_Msk                                               (0x1UL)		/*!< PKA ISR: PROC_END (Bitfield-Mask: 0x01) */
#define PKA_ISR_PROC_END                                                   PKA_ISR_PROC_END_Msk

/* =====================================================    IEN    ===================================================== */ 
#define PKA_IEN_ADDERR_EN_Pos                                              (3UL)		/*!<PKA IEN: ADDERR_EN (Bit 3) */
#define PKA_IEN_ADDERR_EN_Msk                                              (0x8UL)		/*!< PKA IEN: ADDERR_EN (Bitfield-Mask: 0x01) */
#define PKA_IEN_ADDERR_EN                                                  PKA_IEN_ADDERR_EN_Msk
#define PKA_IEN_RAMERR_EN_Pos                                              (2UL)		/*!<PKA IEN: RAMERR_EN (Bit 2) */
#define PKA_IEN_RAMERR_EN_Msk                                              (0x4UL)		/*!< PKA IEN: RAMERR_EN (Bitfield-Mask: 0x01) */
#define PKA_IEN_RAMERR_EN                                                  PKA_IEN_RAMERR_EN_Msk
#define PKA_IEN_READY_EN_Pos                                               (0UL)		/*!<PKA IEN: READY_EN (Bit 0) */
#define PKA_IEN_READY_EN_Msk                                               (0x1UL)		/*!< PKA IEN: READY_EN (Bitfield-Mask: 0x01) */
#define PKA_IEN_READY_EN                                                   PKA_IEN_READY_EN_Msk


/* =========================================================================================================================== */ 
/*=====================                                       ADC                                       ===================== */ 
/* =========================================================================================================================== */ 

/* =====================================================    VERSION_ID    ===================================================== */ 
#define ADC_VERSION_ID_VERSION_ID_Pos                                      (0UL)		/*!<ADC VERSION_ID: VERSION_ID (Bit 0) */
#define ADC_VERSION_ID_VERSION_ID_Msk                                      (0xffUL)		/*!< ADC VERSION_ID: VERSION_ID (Bitfield-Mask: 0xff) */
#define ADC_VERSION_ID_VERSION_ID                                          ADC_VERSION_ID_VERSION_ID_Msk
#define ADC_VERSION_ID_VERSION_ID_0                                        (0x1U << ADC_VERSION_ID_VERSION_ID_Pos)
#define ADC_VERSION_ID_VERSION_ID_1                                        (0x2U << ADC_VERSION_ID_VERSION_ID_Pos)
#define ADC_VERSION_ID_VERSION_ID_2                                        (0x4U << ADC_VERSION_ID_VERSION_ID_Pos)
#define ADC_VERSION_ID_VERSION_ID_3                                        (0x8U << ADC_VERSION_ID_VERSION_ID_Pos)
#define ADC_VERSION_ID_VERSION_ID_4                                        (0x10U << ADC_VERSION_ID_VERSION_ID_Pos)
#define ADC_VERSION_ID_VERSION_ID_5                                        (0x20U << ADC_VERSION_ID_VERSION_ID_Pos)
#define ADC_VERSION_ID_VERSION_ID_6                                        (0x40U << ADC_VERSION_ID_VERSION_ID_Pos)
#define ADC_VERSION_ID_VERSION_ID_7                                        (0x80U << ADC_VERSION_ID_VERSION_ID_Pos)

/* =====================================================    CONF    ===================================================== */ 
#define ADC_CONF_VBIAS_PRECH_FORCE_Pos                                     (20UL)		/*!<ADC CONF: VBIAS_PRECH_FORCE (Bit 20) */
#define ADC_CONF_VBIAS_PRECH_FORCE_Msk                                     (0x100000UL)		/*!< ADC CONF: VBIAS_PRECH_FORCE (Bitfield-Mask: 0x01) */
#define ADC_CONF_VBIAS_PRECH_FORCE                                         ADC_CONF_VBIAS_PRECH_FORCE_Msk
#define ADC_CONF_ADC_CONT_1V2_Pos                                          (19UL)		/*!<ADC CONF: ADC_CONT_1V2 (Bit 19) */
#define ADC_CONF_ADC_CONT_1V2_Msk                                          (0x80000UL)		/*!< ADC CONF: ADC_CONT_1V2 (Bitfield-Mask: 0x01) */
#define ADC_CONF_ADC_CONT_1V2                                              ADC_CONF_ADC_CONT_1V2_Msk
#define ADC_CONF_BIT_INVERT_DIFF_Pos                                       (18UL)		/*!<ADC CONF: BIT_INVERT_DIFF (Bit 18) */
#define ADC_CONF_BIT_INVERT_DIFF_Msk                                       (0x40000UL)		/*!< ADC CONF: BIT_INVERT_DIFF (Bitfield-Mask: 0x01) */
#define ADC_CONF_BIT_INVERT_DIFF                                           ADC_CONF_BIT_INVERT_DIFF_Msk
#define ADC_CONF_BIT_INVERT_SN_Pos                                         (17UL)		/*!<ADC CONF: BIT_INVERT_SN (Bit 17) */
#define ADC_CONF_BIT_INVERT_SN_Msk                                         (0x20000UL)		/*!< ADC CONF: BIT_INVERT_SN (Bitfield-Mask: 0x01) */
#define ADC_CONF_BIT_INVERT_SN                                             ADC_CONF_BIT_INVERT_SN_Msk
#define ADC_CONF_OVR_DF_CFG_Pos                                            (16UL)		/*!<ADC CONF: OVR_DF_CFG (Bit 16) */
#define ADC_CONF_OVR_DF_CFG_Msk                                            (0x10000UL)		/*!< ADC CONF: OVR_DF_CFG (Bitfield-Mask: 0x01) */
#define ADC_CONF_OVR_DF_CFG                                                ADC_CONF_OVR_DF_CFG_Msk
#define ADC_CONF_OVR_DS_CFG_Pos                                            (15UL)		/*!<ADC CONF: OVR_DS_CFG (Bit 15) */
#define ADC_CONF_OVR_DS_CFG_Msk                                            (0x8000UL)		/*!< ADC CONF: OVR_DS_CFG (Bitfield-Mask: 0x01) */
#define ADC_CONF_OVR_DS_CFG                                                ADC_CONF_OVR_DS_CFG_Msk
#define ADC_CONF_DMA_DF_ENA_Pos                                            (14UL)		/*!<ADC CONF: DMA_DF_ENA (Bit 14) */
#define ADC_CONF_DMA_DF_ENA_Msk                                            (0x4000UL)		/*!< ADC CONF: DMA_DF_ENA (Bitfield-Mask: 0x01) */
#define ADC_CONF_DMA_DF_ENA                                                ADC_CONF_DMA_DF_ENA_Msk
#define ADC_CONF_DMA_DS_ENA_Pos                                            (13UL)		/*!<ADC CONF: DMA_DS_ENA (Bit 13) */
#define ADC_CONF_DMA_DS_ENA_Msk                                            (0x2000UL)		/*!< ADC CONF: DMA_DS_ENA (Bitfield-Mask: 0x01) */
#define ADC_CONF_DMA_DS_ENA                                                ADC_CONF_DMA_DS_ENA_Msk
#define ADC_CONF_SAMPLE_RATE_Pos                                           (11UL)		/*!<ADC CONF: SAMPLE_RATE (Bit 11) */
#define ADC_CONF_SAMPLE_RATE_Msk                                           (0x1800UL)		/*!< ADC CONF: SAMPLE_RATE (Bitfield-Mask: 0x03) */
#define ADC_CONF_SAMPLE_RATE                                               ADC_CONF_SAMPLE_RATE_Msk
#define ADC_CONF_SAMPLE_RATE_0                                             (0x1U << ADC_CONF_SAMPLE_RATE_Pos)
#define ADC_CONF_SAMPLE_RATE_1                                             (0x2U << ADC_CONF_SAMPLE_RATE_Pos)
#define ADC_CONF_OP_MODE_Pos                                               (7UL)		/*!<ADC CONF: OP_MODE (Bit 7) */
#define ADC_CONF_OP_MODE_Msk                                               (0x180UL)		/*!< ADC CONF: OP_MODE (Bitfield-Mask: 0x03) */
#define ADC_CONF_OP_MODE                                                   ADC_CONF_OP_MODE_Msk
#define ADC_CONF_OP_MODE_0                                                 (0x1U << ADC_CONF_OP_MODE_Pos)
#define ADC_CONF_OP_MODE_1                                                 (0x2U << ADC_CONF_OP_MODE_Pos)
#define ADC_CONF_SMPS_SYNCHRO_ENA_Pos                                      (6UL)		/*!<ADC CONF: SMPS_SYNCHRO_ENA (Bit 6) */
#define ADC_CONF_SMPS_SYNCHRO_ENA_Msk                                      (0x40UL)		/*!< ADC CONF: SMPS_SYNCHRO_ENA (Bitfield-Mask: 0x01) */
#define ADC_CONF_SMPS_SYNCHRO_ENA                                          ADC_CONF_SMPS_SYNCHRO_ENA_Msk
#define ADC_CONF_SEQ_LEN_Pos                                               (2UL)		/*!<ADC CONF: SEQ_LEN (Bit 2) */
#define ADC_CONF_SEQ_LEN_Msk                                               (0x3cUL)		/*!< ADC CONF: SEQ_LEN (Bitfield-Mask: 0x0f) */
#define ADC_CONF_SEQ_LEN                                                   ADC_CONF_SEQ_LEN_Msk
#define ADC_CONF_SEQ_LEN_0                                                 (0x1U << ADC_CONF_SEQ_LEN_Pos)
#define ADC_CONF_SEQ_LEN_1                                                 (0x2U << ADC_CONF_SEQ_LEN_Pos)
#define ADC_CONF_SEQ_LEN_2                                                 (0x4U << ADC_CONF_SEQ_LEN_Pos)
#define ADC_CONF_SEQ_LEN_3                                                 (0x8U << ADC_CONF_SEQ_LEN_Pos)
#define ADC_CONF_SEQUENCE_Pos                                              (1UL)		/*!<ADC CONF: SEQUENCE (Bit 1) */
#define ADC_CONF_SEQUENCE_Msk                                              (0x2UL)		/*!< ADC CONF: SEQUENCE (Bitfield-Mask: 0x01) */
#define ADC_CONF_SEQUENCE                                                  ADC_CONF_SEQUENCE_Msk
#define ADC_CONF_CONT_Pos                                                  (0UL)		/*!<ADC CONF: CONT (Bit 0) */
#define ADC_CONF_CONT_Msk                                                  (0x1UL)		/*!< ADC CONF: CONT (Bitfield-Mask: 0x01) */
#define ADC_CONF_CONT                                                      ADC_CONF_CONT_Msk

/* =====================================================    CTRL    ===================================================== */ 
#define ADC_CTRL_ADC_LDO_ENA_Pos                                           (5UL)		/*!<ADC CTRL: ADC_LDO_ENA (Bit 5) */
#define ADC_CTRL_ADC_LDO_ENA_Msk                                           (0x20UL)		/*!< ADC CTRL: ADC_LDO_ENA (Bitfield-Mask: 0x01) */
#define ADC_CTRL_ADC_LDO_ENA                                               ADC_CTRL_ADC_LDO_ENA_Msk
#define ADC_CTRL_DIG_AUD_MODE_Pos                                          (3UL)		/*!<ADC CTRL: DIG_AUD_MODE (Bit 3) */
#define ADC_CTRL_DIG_AUD_MODE_Msk                                          (0x8UL)		/*!< ADC CTRL: DIG_AUD_MODE (Bitfield-Mask: 0x01) */
#define ADC_CTRL_DIG_AUD_MODE                                              ADC_CTRL_DIG_AUD_MODE_Msk
#define ADC_CTRL_STOP_OP_MODE_Pos                                          (2UL)		/*!<ADC CTRL: STOP_OP_MODE (Bit 2) */
#define ADC_CTRL_STOP_OP_MODE_Msk                                          (0x4UL)		/*!< ADC CTRL: STOP_OP_MODE (Bitfield-Mask: 0x01) */
#define ADC_CTRL_STOP_OP_MODE                                              ADC_CTRL_STOP_OP_MODE_Msk
#define ADC_CTRL_START_CONV_Pos                                            (1UL)		/*!<ADC CTRL: START_CONV (Bit 1) */
#define ADC_CTRL_START_CONV_Msk                                            (0x2UL)		/*!< ADC CTRL: START_CONV (Bitfield-Mask: 0x01) */
#define ADC_CTRL_START_CONV                                                ADC_CTRL_START_CONV_Msk
#define ADC_CTRL_ADC_ON_OFF_Pos                                            (0UL)		/*!<ADC CTRL: ADC_ON_OFF (Bit 0) */
#define ADC_CTRL_ADC_ON_OFF_Msk                                            (0x1UL)		/*!< ADC CTRL: ADC_ON_OFF (Bitfield-Mask: 0x01) */
#define ADC_CTRL_ADC_ON_OFF                                                ADC_CTRL_ADC_ON_OFF_Msk

/* =====================================================    OCM_CTRL    ===================================================== */ 
#define ADC_OCM_CTRL_OCM_ENA_Pos                                           (1UL)		/*!<ADC OCM_CTRL: OCM_ENA (Bit 1) */
#define ADC_OCM_CTRL_OCM_ENA_Msk                                           (0x2UL)		/*!< ADC OCM_CTRL: OCM_ENA (Bitfield-Mask: 0x01) */
#define ADC_OCM_CTRL_OCM_ENA                                               ADC_OCM_CTRL_OCM_ENA_Msk
#define ADC_OCM_CTRL_OCM_SRC_Pos                                           (0UL)		/*!<ADC OCM_CTRL: OCM_SRC (Bit 0) */
#define ADC_OCM_CTRL_OCM_SRC_Msk                                           (0x1UL)		/*!< ADC OCM_CTRL: OCM_SRC (Bitfield-Mask: 0x01) */
#define ADC_OCM_CTRL_OCM_SRC                                               ADC_OCM_CTRL_OCM_SRC_Msk

/* =====================================================    PGA_CONF    ===================================================== */ 
#define ADC_PGA_CONF_PGA_BIAS_Pos                                          (4UL)		/*!<ADC PGA_CONF: PGA_BIAS (Bit 4) */
#define ADC_PGA_CONF_PGA_BIAS_Msk                                          (0x70UL)		/*!< ADC PGA_CONF: PGA_BIAS (Bitfield-Mask: 0x07) */
#define ADC_PGA_CONF_PGA_BIAS                                              ADC_PGA_CONF_PGA_BIAS_Msk
#define ADC_PGA_CONF_PGA_BIAS_0                                            (0x1U << ADC_PGA_CONF_PGA_BIAS_Pos)
#define ADC_PGA_CONF_PGA_BIAS_1                                            (0x2U << ADC_PGA_CONF_PGA_BIAS_Pos)
#define ADC_PGA_CONF_PGA_BIAS_2                                            (0x4U << ADC_PGA_CONF_PGA_BIAS_Pos)
#define ADC_PGA_CONF_PGA_GAIN_Pos                                          (0UL)		/*!<ADC PGA_CONF: PGA_GAIN (Bit 0) */
#define ADC_PGA_CONF_PGA_GAIN_Msk                                          (0xfUL)		/*!< ADC PGA_CONF: PGA_GAIN (Bitfield-Mask: 0x0f) */
#define ADC_PGA_CONF_PGA_GAIN                                              ADC_PGA_CONF_PGA_GAIN_Msk
#define ADC_PGA_CONF_PGA_GAIN_0                                            (0x1U << ADC_PGA_CONF_PGA_GAIN_Pos)
#define ADC_PGA_CONF_PGA_GAIN_1                                            (0x2U << ADC_PGA_CONF_PGA_GAIN_Pos)
#define ADC_PGA_CONF_PGA_GAIN_2                                            (0x4U << ADC_PGA_CONF_PGA_GAIN_Pos)
#define ADC_PGA_CONF_PGA_GAIN_3                                            (0x8U << ADC_PGA_CONF_PGA_GAIN_Pos)

/* =====================================================    SWITCH    ===================================================== */ 
#define ADC_SWITCH_SE_VIN_7_Pos                                            (14UL)		/*!<ADC SWITCH: SE_VIN_7 (Bit 14) */
#define ADC_SWITCH_SE_VIN_7_Msk                                            (0xc000UL)		/*!< ADC SWITCH: SE_VIN_7 (Bitfield-Mask: 0x03) */
#define ADC_SWITCH_SE_VIN_7                                                ADC_SWITCH_SE_VIN_7_Msk
#define ADC_SWITCH_SE_VIN_7_0                                              (0x1U << ADC_SWITCH_SE_VIN_7_Pos)
#define ADC_SWITCH_SE_VIN_7_1                                              (0x2U << ADC_SWITCH_SE_VIN_7_Pos)
#define ADC_SWITCH_SE_VIN_6_Pos                                            (12UL)		/*!<ADC SWITCH: SE_VIN_6 (Bit 12) */
#define ADC_SWITCH_SE_VIN_6_Msk                                            (0x3000UL)		/*!< ADC SWITCH: SE_VIN_6 (Bitfield-Mask: 0x03) */
#define ADC_SWITCH_SE_VIN_6                                                ADC_SWITCH_SE_VIN_6_Msk
#define ADC_SWITCH_SE_VIN_6_0                                              (0x1U << ADC_SWITCH_SE_VIN_6_Pos)
#define ADC_SWITCH_SE_VIN_6_1                                              (0x2U << ADC_SWITCH_SE_VIN_6_Pos)
#define ADC_SWITCH_SE_VIN_5_Pos                                            (10UL)		/*!<ADC SWITCH: SE_VIN_5 (Bit 10) */
#define ADC_SWITCH_SE_VIN_5_Msk                                            (0xc00UL)		/*!< ADC SWITCH: SE_VIN_5 (Bitfield-Mask: 0x03) */
#define ADC_SWITCH_SE_VIN_5                                                ADC_SWITCH_SE_VIN_5_Msk
#define ADC_SWITCH_SE_VIN_5_0                                              (0x1U << ADC_SWITCH_SE_VIN_5_Pos)
#define ADC_SWITCH_SE_VIN_5_1                                              (0x2U << ADC_SWITCH_SE_VIN_5_Pos)
#define ADC_SWITCH_SE_VIN_4_Pos                                            (8UL)		/*!<ADC SWITCH: SE_VIN_4 (Bit 8) */
#define ADC_SWITCH_SE_VIN_4_Msk                                            (0x300UL)		/*!< ADC SWITCH: SE_VIN_4 (Bitfield-Mask: 0x03) */
#define ADC_SWITCH_SE_VIN_4                                                ADC_SWITCH_SE_VIN_4_Msk
#define ADC_SWITCH_SE_VIN_4_0                                              (0x1U << ADC_SWITCH_SE_VIN_4_Pos)
#define ADC_SWITCH_SE_VIN_4_1                                              (0x2U << ADC_SWITCH_SE_VIN_4_Pos)
#define ADC_SWITCH_SE_VIN_3_Pos                                            (6UL)		/*!<ADC SWITCH: SE_VIN_3 (Bit 6) */
#define ADC_SWITCH_SE_VIN_3_Msk                                            (0xc0UL)		/*!< ADC SWITCH: SE_VIN_3 (Bitfield-Mask: 0x03) */
#define ADC_SWITCH_SE_VIN_3                                                ADC_SWITCH_SE_VIN_3_Msk
#define ADC_SWITCH_SE_VIN_3_0                                              (0x1U << ADC_SWITCH_SE_VIN_3_Pos)
#define ADC_SWITCH_SE_VIN_3_1                                              (0x2U << ADC_SWITCH_SE_VIN_3_Pos)
#define ADC_SWITCH_SE_VIN_2_Pos                                            (4UL)		/*!<ADC SWITCH: SE_VIN_2 (Bit 4) */
#define ADC_SWITCH_SE_VIN_2_Msk                                            (0x30UL)		/*!< ADC SWITCH: SE_VIN_2 (Bitfield-Mask: 0x03) */
#define ADC_SWITCH_SE_VIN_2                                                ADC_SWITCH_SE_VIN_2_Msk
#define ADC_SWITCH_SE_VIN_2_0                                              (0x1U << ADC_SWITCH_SE_VIN_2_Pos)
#define ADC_SWITCH_SE_VIN_2_1                                              (0x2U << ADC_SWITCH_SE_VIN_2_Pos)
#define ADC_SWITCH_SE_VIN_1_Pos                                            (2UL)		/*!<ADC SWITCH: SE_VIN_1 (Bit 2) */
#define ADC_SWITCH_SE_VIN_1_Msk                                            (0xcUL)		/*!< ADC SWITCH: SE_VIN_1 (Bitfield-Mask: 0x03) */
#define ADC_SWITCH_SE_VIN_1                                                ADC_SWITCH_SE_VIN_1_Msk
#define ADC_SWITCH_SE_VIN_1_0                                              (0x1U << ADC_SWITCH_SE_VIN_1_Pos)
#define ADC_SWITCH_SE_VIN_1_1                                              (0x2U << ADC_SWITCH_SE_VIN_1_Pos)
#define ADC_SWITCH_SE_VIN_0_Pos                                            (0UL)		/*!<ADC SWITCH: SE_VIN_0 (Bit 0) */
#define ADC_SWITCH_SE_VIN_0_Msk                                            (0x3UL)		/*!< ADC SWITCH: SE_VIN_0 (Bitfield-Mask: 0x03) */
#define ADC_SWITCH_SE_VIN_0                                                ADC_SWITCH_SE_VIN_0_Msk
#define ADC_SWITCH_SE_VIN_0_0                                              (0x1U << ADC_SWITCH_SE_VIN_0_Pos)
#define ADC_SWITCH_SE_VIN_0_1                                              (0x2U << ADC_SWITCH_SE_VIN_0_Pos)

/* =====================================================    DF_CONF    ===================================================== */ 
#define ADC_DF_CONF_DF_HALF_D_EN_Pos                                       (17UL)		/*!<ADC DF_CONF: DF_HALF_D_EN (Bit 17) */
#define ADC_DF_CONF_DF_HALF_D_EN_Msk                                       (0x20000UL)		/*!< ADC DF_CONF: DF_HALF_D_EN (Bitfield-Mask: 0x01) */
#define ADC_DF_CONF_DF_HALF_D_EN                                           ADC_DF_CONF_DF_HALF_D_EN_Msk
#define ADC_DF_CONF_DF_HPF_EN_Pos                                          (16UL)		/*!<ADC DF_CONF: DF_HPF_EN (Bit 16) */
#define ADC_DF_CONF_DF_HPF_EN_Msk                                          (0x10000UL)		/*!< ADC DF_CONF: DF_HPF_EN (Bitfield-Mask: 0x01) */
#define ADC_DF_CONF_DF_HPF_EN                                              ADC_DF_CONF_DF_HPF_EN_Msk
#define ADC_DF_CONF_DF_MICROL_RN_Pos                                       (15UL)		/*!<ADC DF_CONF: DF_MICROL_RN (Bit 15) */
#define ADC_DF_CONF_DF_MICROL_RN_Msk                                       (0x8000UL)		/*!< ADC DF_CONF: DF_MICROL_RN (Bitfield-Mask: 0x01) */
#define ADC_DF_CONF_DF_MICROL_RN                                           ADC_DF_CONF_DF_MICROL_RN_Msk
#define ADC_DF_CONF_PDM_RATE_Pos                                           (11UL)		/*!<ADC DF_CONF: PDM_RATE (Bit 11) */
#define ADC_DF_CONF_PDM_RATE_Msk                                           (0x7800UL)		/*!< ADC DF_CONF: PDM_RATE (Bitfield-Mask: 0x0f) */
#define ADC_DF_CONF_PDM_RATE                                               ADC_DF_CONF_PDM_RATE_Msk
#define ADC_DF_CONF_PDM_RATE_0                                             (0x1U << ADC_DF_CONF_PDM_RATE_Pos)
#define ADC_DF_CONF_PDM_RATE_1                                             (0x2U << ADC_DF_CONF_PDM_RATE_Pos)
#define ADC_DF_CONF_PDM_RATE_2                                             (0x4U << ADC_DF_CONF_PDM_RATE_Pos)
#define ADC_DF_CONF_PDM_RATE_3                                             (0x8U << ADC_DF_CONF_PDM_RATE_Pos)
#define ADC_DF_CONF_DF_O_S2U_Pos                                           (10UL)		/*!<ADC DF_CONF: DF_O_S2U (Bit 10) */
#define ADC_DF_CONF_DF_O_S2U_Msk                                           (0x400UL)		/*!< ADC DF_CONF: DF_O_S2U (Bitfield-Mask: 0x01) */
#define ADC_DF_CONF_DF_O_S2U                                               ADC_DF_CONF_DF_O_S2U_Msk
#define ADC_DF_CONF_DF_I_U2S_Pos                                           (9UL)		/*!<ADC DF_CONF: DF_I_U2S (Bit 9) */
#define ADC_DF_CONF_DF_I_U2S_Msk                                           (0x200UL)		/*!< ADC DF_CONF: DF_I_U2S (Bitfield-Mask: 0x01) */
#define ADC_DF_CONF_DF_I_U2S                                               ADC_DF_CONF_DF_I_U2S_Msk
#define ADC_DF_CONF_DF_ITP1P2_Pos                                          (8UL)		/*!<ADC DF_CONF: DF_ITP1P2 (Bit 8) */
#define ADC_DF_CONF_DF_ITP1P2_Msk                                          (0x100UL)		/*!< ADC DF_CONF: DF_ITP1P2 (Bitfield-Mask: 0x01) */
#define ADC_DF_CONF_DF_ITP1P2                                              ADC_DF_CONF_DF_ITP1P2_Msk
#define ADC_DF_CONF_DF_CIC_DHF_Pos                                         (7UL)		/*!<ADC DF_CONF: DF_CIC_DHF (Bit 7) */
#define ADC_DF_CONF_DF_CIC_DHF_Msk                                         (0x80UL)		/*!< ADC DF_CONF: DF_CIC_DHF (Bitfield-Mask: 0x01) */
#define ADC_DF_CONF_DF_CIC_DHF                                             ADC_DF_CONF_DF_CIC_DHF_Msk
#define ADC_DF_CONF_DF_CIC_DEC_FACTOR_Pos                                  (0UL)		/*!<ADC DF_CONF: DF_CIC_DEC_FACTOR (Bit 0) */
#define ADC_DF_CONF_DF_CIC_DEC_FACTOR_Msk                                  (0x7fUL)		/*!< ADC DF_CONF: DF_CIC_DEC_FACTOR (Bitfield-Mask: 0x7f) */
#define ADC_DF_CONF_DF_CIC_DEC_FACTOR                                      ADC_DF_CONF_DF_CIC_DEC_FACTOR_Msk
#define ADC_DF_CONF_DF_CIC_DEC_FACTOR_0                                    (0x1U << ADC_DF_CONF_DF_CIC_DEC_FACTOR_Pos)
#define ADC_DF_CONF_DF_CIC_DEC_FACTOR_1                                    (0x2U << ADC_DF_CONF_DF_CIC_DEC_FACTOR_Pos)
#define ADC_DF_CONF_DF_CIC_DEC_FACTOR_2                                    (0x4U << ADC_DF_CONF_DF_CIC_DEC_FACTOR_Pos)
#define ADC_DF_CONF_DF_CIC_DEC_FACTOR_3                                    (0x8U << ADC_DF_CONF_DF_CIC_DEC_FACTOR_Pos)
#define ADC_DF_CONF_DF_CIC_DEC_FACTOR_4                                    (0x10U << ADC_DF_CONF_DF_CIC_DEC_FACTOR_Pos)
#define ADC_DF_CONF_DF_CIC_DEC_FACTOR_5                                    (0x20U << ADC_DF_CONF_DF_CIC_DEC_FACTOR_Pos)
#define ADC_DF_CONF_DF_CIC_DEC_FACTOR_6                                    (0x40U << ADC_DF_CONF_DF_CIC_DEC_FACTOR_Pos)

/* =====================================================    DS_CONF    ===================================================== */ 
#define ADC_DS_CONF_DS_WIDTH_Pos                                           (3UL)		/*!<ADC DS_CONF: DS_WIDTH (Bit 3) */
#define ADC_DS_CONF_DS_WIDTH_Msk                                           (0x38UL)		/*!< ADC DS_CONF: DS_WIDTH (Bitfield-Mask: 0x07) */
#define ADC_DS_CONF_DS_WIDTH                                               ADC_DS_CONF_DS_WIDTH_Msk
#define ADC_DS_CONF_DS_WIDTH_0                                             (0x1U << ADC_DS_CONF_DS_WIDTH_Pos)
#define ADC_DS_CONF_DS_WIDTH_1                                             (0x2U << ADC_DS_CONF_DS_WIDTH_Pos)
#define ADC_DS_CONF_DS_WIDTH_2                                             (0x4U << ADC_DS_CONF_DS_WIDTH_Pos)
#define ADC_DS_CONF_DS_RATIO_Pos                                           (0UL)		/*!<ADC DS_CONF: DS_RATIO (Bit 0) */
#define ADC_DS_CONF_DS_RATIO_Msk                                           (0x7UL)		/*!< ADC DS_CONF: DS_RATIO (Bitfield-Mask: 0x07) */
#define ADC_DS_CONF_DS_RATIO                                               ADC_DS_CONF_DS_RATIO_Msk
#define ADC_DS_CONF_DS_RATIO_0                                             (0x1U << ADC_DS_CONF_DS_RATIO_Pos)
#define ADC_DS_CONF_DS_RATIO_1                                             (0x2U << ADC_DS_CONF_DS_RATIO_Pos)
#define ADC_DS_CONF_DS_RATIO_2                                             (0x4U << ADC_DS_CONF_DS_RATIO_Pos)

/* =====================================================    SEQ_1    ===================================================== */ 
#define ADC_SEQ_1_SEQ7_Pos                                                 (28UL)		/*!<ADC SEQ_1: SEQ7 (Bit 28) */
#define ADC_SEQ_1_SEQ7_Msk                                                 (0xf0000000UL)		/*!< ADC SEQ_1: SEQ7 (Bitfield-Mask: 0x0f) */
#define ADC_SEQ_1_SEQ7                                                     ADC_SEQ_1_SEQ7_Msk
#define ADC_SEQ_1_SEQ7_0                                                   (0x1U << ADC_SEQ_1_SEQ7_Pos)
#define ADC_SEQ_1_SEQ7_1                                                   (0x2U << ADC_SEQ_1_SEQ7_Pos)
#define ADC_SEQ_1_SEQ7_2                                                   (0x4U << ADC_SEQ_1_SEQ7_Pos)
#define ADC_SEQ_1_SEQ7_3                                                   (0x8U << ADC_SEQ_1_SEQ7_Pos)
#define ADC_SEQ_1_SEQ6_Pos                                                 (24UL)		/*!<ADC SEQ_1: SEQ6 (Bit 24) */
#define ADC_SEQ_1_SEQ6_Msk                                                 (0xf000000UL)		/*!< ADC SEQ_1: SEQ6 (Bitfield-Mask: 0x0f) */
#define ADC_SEQ_1_SEQ6                                                     ADC_SEQ_1_SEQ6_Msk
#define ADC_SEQ_1_SEQ6_0                                                   (0x1U << ADC_SEQ_1_SEQ6_Pos)
#define ADC_SEQ_1_SEQ6_1                                                   (0x2U << ADC_SEQ_1_SEQ6_Pos)
#define ADC_SEQ_1_SEQ6_2                                                   (0x4U << ADC_SEQ_1_SEQ6_Pos)
#define ADC_SEQ_1_SEQ6_3                                                   (0x8U << ADC_SEQ_1_SEQ6_Pos)
#define ADC_SEQ_1_SEQ5_Pos                                                 (20UL)		/*!<ADC SEQ_1: SEQ5 (Bit 20) */
#define ADC_SEQ_1_SEQ5_Msk                                                 (0xf00000UL)		/*!< ADC SEQ_1: SEQ5 (Bitfield-Mask: 0x0f) */
#define ADC_SEQ_1_SEQ5                                                     ADC_SEQ_1_SEQ5_Msk
#define ADC_SEQ_1_SEQ5_0                                                   (0x1U << ADC_SEQ_1_SEQ5_Pos)
#define ADC_SEQ_1_SEQ5_1                                                   (0x2U << ADC_SEQ_1_SEQ5_Pos)
#define ADC_SEQ_1_SEQ5_2                                                   (0x4U << ADC_SEQ_1_SEQ5_Pos)
#define ADC_SEQ_1_SEQ5_3                                                   (0x8U << ADC_SEQ_1_SEQ5_Pos)
#define ADC_SEQ_1_SEQ4_Pos                                                 (16UL)		/*!<ADC SEQ_1: SEQ4 (Bit 16) */
#define ADC_SEQ_1_SEQ4_Msk                                                 (0xf0000UL)		/*!< ADC SEQ_1: SEQ4 (Bitfield-Mask: 0x0f) */
#define ADC_SEQ_1_SEQ4                                                     ADC_SEQ_1_SEQ4_Msk
#define ADC_SEQ_1_SEQ4_0                                                   (0x1U << ADC_SEQ_1_SEQ4_Pos)
#define ADC_SEQ_1_SEQ4_1                                                   (0x2U << ADC_SEQ_1_SEQ4_Pos)
#define ADC_SEQ_1_SEQ4_2                                                   (0x4U << ADC_SEQ_1_SEQ4_Pos)
#define ADC_SEQ_1_SEQ4_3                                                   (0x8U << ADC_SEQ_1_SEQ4_Pos)
#define ADC_SEQ_1_SEQ3_Pos                                                 (12UL)		/*!<ADC SEQ_1: SEQ3 (Bit 12) */
#define ADC_SEQ_1_SEQ3_Msk                                                 (0xf000UL)		/*!< ADC SEQ_1: SEQ3 (Bitfield-Mask: 0x0f) */
#define ADC_SEQ_1_SEQ3                                                     ADC_SEQ_1_SEQ3_Msk
#define ADC_SEQ_1_SEQ3_0                                                   (0x1U << ADC_SEQ_1_SEQ3_Pos)
#define ADC_SEQ_1_SEQ3_1                                                   (0x2U << ADC_SEQ_1_SEQ3_Pos)
#define ADC_SEQ_1_SEQ3_2                                                   (0x4U << ADC_SEQ_1_SEQ3_Pos)
#define ADC_SEQ_1_SEQ3_3                                                   (0x8U << ADC_SEQ_1_SEQ3_Pos)
#define ADC_SEQ_1_SEQ2_Pos                                                 (8UL)		/*!<ADC SEQ_1: SEQ2 (Bit 8) */
#define ADC_SEQ_1_SEQ2_Msk                                                 (0xf00UL)		/*!< ADC SEQ_1: SEQ2 (Bitfield-Mask: 0x0f) */
#define ADC_SEQ_1_SEQ2                                                     ADC_SEQ_1_SEQ2_Msk
#define ADC_SEQ_1_SEQ2_0                                                   (0x1U << ADC_SEQ_1_SEQ2_Pos)
#define ADC_SEQ_1_SEQ2_1                                                   (0x2U << ADC_SEQ_1_SEQ2_Pos)
#define ADC_SEQ_1_SEQ2_2                                                   (0x4U << ADC_SEQ_1_SEQ2_Pos)
#define ADC_SEQ_1_SEQ2_3                                                   (0x8U << ADC_SEQ_1_SEQ2_Pos)
#define ADC_SEQ_1_SEQ1_Pos                                                 (4UL)		/*!<ADC SEQ_1: SEQ1 (Bit 4) */
#define ADC_SEQ_1_SEQ1_Msk                                                 (0xf0UL)		/*!< ADC SEQ_1: SEQ1 (Bitfield-Mask: 0x0f) */
#define ADC_SEQ_1_SEQ1                                                     ADC_SEQ_1_SEQ1_Msk
#define ADC_SEQ_1_SEQ1_0                                                   (0x1U << ADC_SEQ_1_SEQ1_Pos)
#define ADC_SEQ_1_SEQ1_1                                                   (0x2U << ADC_SEQ_1_SEQ1_Pos)
#define ADC_SEQ_1_SEQ1_2                                                   (0x4U << ADC_SEQ_1_SEQ1_Pos)
#define ADC_SEQ_1_SEQ1_3                                                   (0x8U << ADC_SEQ_1_SEQ1_Pos)
#define ADC_SEQ_1_SEQ0_Pos                                                 (0UL)		/*!<ADC SEQ_1: SEQ0 (Bit 0) */
#define ADC_SEQ_1_SEQ0_Msk                                                 (0xfUL)		/*!< ADC SEQ_1: SEQ0 (Bitfield-Mask: 0x0f) */
#define ADC_SEQ_1_SEQ0                                                     ADC_SEQ_1_SEQ0_Msk
#define ADC_SEQ_1_SEQ0_0                                                   (0x1U << ADC_SEQ_1_SEQ0_Pos)
#define ADC_SEQ_1_SEQ0_1                                                   (0x2U << ADC_SEQ_1_SEQ0_Pos)
#define ADC_SEQ_1_SEQ0_2                                                   (0x4U << ADC_SEQ_1_SEQ0_Pos)
#define ADC_SEQ_1_SEQ0_3                                                   (0x8U << ADC_SEQ_1_SEQ0_Pos)

/* =====================================================    SEQ_2    ===================================================== */ 
#define ADC_SEQ_2_SEQ15_Pos                                                (28UL)		/*!<ADC SEQ_2: SEQ15 (Bit 28) */
#define ADC_SEQ_2_SEQ15_Msk                                                (0xf0000000UL)		/*!< ADC SEQ_2: SEQ15 (Bitfield-Mask: 0x0f) */
#define ADC_SEQ_2_SEQ15                                                    ADC_SEQ_2_SEQ15_Msk
#define ADC_SEQ_2_SEQ15_0                                                  (0x1U << ADC_SEQ_2_SEQ15_Pos)
#define ADC_SEQ_2_SEQ15_1                                                  (0x2U << ADC_SEQ_2_SEQ15_Pos)
#define ADC_SEQ_2_SEQ15_2                                                  (0x4U << ADC_SEQ_2_SEQ15_Pos)
#define ADC_SEQ_2_SEQ15_3                                                  (0x8U << ADC_SEQ_2_SEQ15_Pos)
#define ADC_SEQ_2_SEQ14_Pos                                                (24UL)		/*!<ADC SEQ_2: SEQ14 (Bit 24) */
#define ADC_SEQ_2_SEQ14_Msk                                                (0xf000000UL)		/*!< ADC SEQ_2: SEQ14 (Bitfield-Mask: 0x0f) */
#define ADC_SEQ_2_SEQ14                                                    ADC_SEQ_2_SEQ14_Msk
#define ADC_SEQ_2_SEQ14_0                                                  (0x1U << ADC_SEQ_2_SEQ14_Pos)
#define ADC_SEQ_2_SEQ14_1                                                  (0x2U << ADC_SEQ_2_SEQ14_Pos)
#define ADC_SEQ_2_SEQ14_2                                                  (0x4U << ADC_SEQ_2_SEQ14_Pos)
#define ADC_SEQ_2_SEQ14_3                                                  (0x8U << ADC_SEQ_2_SEQ14_Pos)
#define ADC_SEQ_2_SEQ13_Pos                                                (20UL)		/*!<ADC SEQ_2: SEQ13 (Bit 20) */
#define ADC_SEQ_2_SEQ13_Msk                                                (0xf00000UL)		/*!< ADC SEQ_2: SEQ13 (Bitfield-Mask: 0x0f) */
#define ADC_SEQ_2_SEQ13                                                    ADC_SEQ_2_SEQ13_Msk
#define ADC_SEQ_2_SEQ13_0                                                  (0x1U << ADC_SEQ_2_SEQ13_Pos)
#define ADC_SEQ_2_SEQ13_1                                                  (0x2U << ADC_SEQ_2_SEQ13_Pos)
#define ADC_SEQ_2_SEQ13_2                                                  (0x4U << ADC_SEQ_2_SEQ13_Pos)
#define ADC_SEQ_2_SEQ13_3                                                  (0x8U << ADC_SEQ_2_SEQ13_Pos)
#define ADC_SEQ_2_SEQ12_Pos                                                (16UL)		/*!<ADC SEQ_2: SEQ12 (Bit 16) */
#define ADC_SEQ_2_SEQ12_Msk                                                (0xf0000UL)		/*!< ADC SEQ_2: SEQ12 (Bitfield-Mask: 0x0f) */
#define ADC_SEQ_2_SEQ12                                                    ADC_SEQ_2_SEQ12_Msk
#define ADC_SEQ_2_SEQ12_0                                                  (0x1U << ADC_SEQ_2_SEQ12_Pos)
#define ADC_SEQ_2_SEQ12_1                                                  (0x2U << ADC_SEQ_2_SEQ12_Pos)
#define ADC_SEQ_2_SEQ12_2                                                  (0x4U << ADC_SEQ_2_SEQ12_Pos)
#define ADC_SEQ_2_SEQ12_3                                                  (0x8U << ADC_SEQ_2_SEQ12_Pos)
#define ADC_SEQ_2_SEQ11_Pos                                                (12UL)		/*!<ADC SEQ_2: SEQ11 (Bit 12) */
#define ADC_SEQ_2_SEQ11_Msk                                                (0xf000UL)		/*!< ADC SEQ_2: SEQ11 (Bitfield-Mask: 0x0f) */
#define ADC_SEQ_2_SEQ11                                                    ADC_SEQ_2_SEQ11_Msk
#define ADC_SEQ_2_SEQ11_0                                                  (0x1U << ADC_SEQ_2_SEQ11_Pos)
#define ADC_SEQ_2_SEQ11_1                                                  (0x2U << ADC_SEQ_2_SEQ11_Pos)
#define ADC_SEQ_2_SEQ11_2                                                  (0x4U << ADC_SEQ_2_SEQ11_Pos)
#define ADC_SEQ_2_SEQ11_3                                                  (0x8U << ADC_SEQ_2_SEQ11_Pos)
#define ADC_SEQ_2_SEQ10_Pos                                                (8UL)		/*!<ADC SEQ_2: SEQ10 (Bit 8) */
#define ADC_SEQ_2_SEQ10_Msk                                                (0xf00UL)		/*!< ADC SEQ_2: SEQ10 (Bitfield-Mask: 0x0f) */
#define ADC_SEQ_2_SEQ10                                                    ADC_SEQ_2_SEQ10_Msk
#define ADC_SEQ_2_SEQ10_0                                                  (0x1U << ADC_SEQ_2_SEQ10_Pos)
#define ADC_SEQ_2_SEQ10_1                                                  (0x2U << ADC_SEQ_2_SEQ10_Pos)
#define ADC_SEQ_2_SEQ10_2                                                  (0x4U << ADC_SEQ_2_SEQ10_Pos)
#define ADC_SEQ_2_SEQ10_3                                                  (0x8U << ADC_SEQ_2_SEQ10_Pos)
#define ADC_SEQ_2_SEQ9_Pos                                                 (4UL)		/*!<ADC SEQ_2: SEQ9 (Bit 4) */
#define ADC_SEQ_2_SEQ9_Msk                                                 (0xf0UL)		/*!< ADC SEQ_2: SEQ9 (Bitfield-Mask: 0x0f) */
#define ADC_SEQ_2_SEQ9                                                     ADC_SEQ_2_SEQ9_Msk
#define ADC_SEQ_2_SEQ9_0                                                   (0x1U << ADC_SEQ_2_SEQ9_Pos)
#define ADC_SEQ_2_SEQ9_1                                                   (0x2U << ADC_SEQ_2_SEQ9_Pos)
#define ADC_SEQ_2_SEQ9_2                                                   (0x4U << ADC_SEQ_2_SEQ9_Pos)
#define ADC_SEQ_2_SEQ9_3                                                   (0x8U << ADC_SEQ_2_SEQ9_Pos)
#define ADC_SEQ_2_SEQ8_Pos                                                 (0UL)		/*!<ADC SEQ_2: SEQ8 (Bit 0) */
#define ADC_SEQ_2_SEQ8_Msk                                                 (0xfUL)		/*!< ADC SEQ_2: SEQ8 (Bitfield-Mask: 0x0f) */
#define ADC_SEQ_2_SEQ8                                                     ADC_SEQ_2_SEQ8_Msk
#define ADC_SEQ_2_SEQ8_0                                                   (0x1U << ADC_SEQ_2_SEQ8_Pos)
#define ADC_SEQ_2_SEQ8_1                                                   (0x2U << ADC_SEQ_2_SEQ8_Pos)
#define ADC_SEQ_2_SEQ8_2                                                   (0x4U << ADC_SEQ_2_SEQ8_Pos)
#define ADC_SEQ_2_SEQ8_3                                                   (0x8U << ADC_SEQ_2_SEQ8_Pos)

/* =====================================================    COMP_1    ===================================================== */ 
#define ADC_COMP_1_OFFSET1_Pos                                             (12UL)		/*!<ADC COMP_1: OFFSET1 (Bit 12) */
#define ADC_COMP_1_OFFSET1_Msk                                             (0x7f000UL)		/*!< ADC COMP_1: OFFSET1 (Bitfield-Mask: 0x7f) */
#define ADC_COMP_1_OFFSET1                                                 ADC_COMP_1_OFFSET1_Msk
#define ADC_COMP_1_OFFSET1_0                                               (0x1U << ADC_COMP_1_OFFSET1_Pos)
#define ADC_COMP_1_OFFSET1_1                                               (0x2U << ADC_COMP_1_OFFSET1_Pos)
#define ADC_COMP_1_OFFSET1_2                                               (0x4U << ADC_COMP_1_OFFSET1_Pos)
#define ADC_COMP_1_OFFSET1_3                                               (0x8U << ADC_COMP_1_OFFSET1_Pos)
#define ADC_COMP_1_OFFSET1_4                                               (0x10U << ADC_COMP_1_OFFSET1_Pos)
#define ADC_COMP_1_OFFSET1_5                                               (0x20U << ADC_COMP_1_OFFSET1_Pos)
#define ADC_COMP_1_OFFSET1_6                                               (0x40U << ADC_COMP_1_OFFSET1_Pos)
#define ADC_COMP_1_GAIN1_Pos                                               (0UL)		/*!<ADC COMP_1: GAIN1 (Bit 0) */
#define ADC_COMP_1_GAIN1_Msk                                               (0xfffUL)		/*!< ADC COMP_1: GAIN1 (Bitfield-Mask: 0xfff) */
#define ADC_COMP_1_GAIN1                                                   ADC_COMP_1_GAIN1_Msk
#define ADC_COMP_1_GAIN1_0                                                 (0x1U << ADC_COMP_1_GAIN1_Pos)
#define ADC_COMP_1_GAIN1_1                                                 (0x2U << ADC_COMP_1_GAIN1_Pos)
#define ADC_COMP_1_GAIN1_2                                                 (0x4U << ADC_COMP_1_GAIN1_Pos)
#define ADC_COMP_1_GAIN1_3                                                 (0x8U << ADC_COMP_1_GAIN1_Pos)
#define ADC_COMP_1_GAIN1_4                                                 (0x10U << ADC_COMP_1_GAIN1_Pos)
#define ADC_COMP_1_GAIN1_5                                                 (0x20U << ADC_COMP_1_GAIN1_Pos)
#define ADC_COMP_1_GAIN1_6                                                 (0x40U << ADC_COMP_1_GAIN1_Pos)
#define ADC_COMP_1_GAIN1_7                                                 (0x80U << ADC_COMP_1_GAIN1_Pos)
#define ADC_COMP_1_GAIN1_8                                                 (0x100U << ADC_COMP_1_GAIN1_Pos)
#define ADC_COMP_1_GAIN1_9                                                 (0x200U << ADC_COMP_1_GAIN1_Pos)
#define ADC_COMP_1_GAIN1_10                                                (0x400U << ADC_COMP_1_GAIN1_Pos)
#define ADC_COMP_1_GAIN1_11                                                (0x800U << ADC_COMP_1_GAIN1_Pos)

/* =====================================================    COMP_2    ===================================================== */ 
#define ADC_COMP_2_OFFSET2_Pos                                             (12UL)		/*!<ADC COMP_2: OFFSET2 (Bit 12) */
#define ADC_COMP_2_OFFSET2_Msk                                             (0x7f000UL)		/*!< ADC COMP_2: OFFSET2 (Bitfield-Mask: 0x7f) */
#define ADC_COMP_2_OFFSET2                                                 ADC_COMP_2_OFFSET2_Msk
#define ADC_COMP_2_OFFSET2_0                                               (0x1U << ADC_COMP_2_OFFSET2_Pos)
#define ADC_COMP_2_OFFSET2_1                                               (0x2U << ADC_COMP_2_OFFSET2_Pos)
#define ADC_COMP_2_OFFSET2_2                                               (0x4U << ADC_COMP_2_OFFSET2_Pos)
#define ADC_COMP_2_OFFSET2_3                                               (0x8U << ADC_COMP_2_OFFSET2_Pos)
#define ADC_COMP_2_OFFSET2_4                                               (0x10U << ADC_COMP_2_OFFSET2_Pos)
#define ADC_COMP_2_OFFSET2_5                                               (0x20U << ADC_COMP_2_OFFSET2_Pos)
#define ADC_COMP_2_OFFSET2_6                                               (0x40U << ADC_COMP_2_OFFSET2_Pos)
#define ADC_COMP_2_GAIN2_Pos                                               (0UL)		/*!<ADC COMP_2: GAIN2 (Bit 0) */
#define ADC_COMP_2_GAIN2_Msk                                               (0xfffUL)		/*!< ADC COMP_2: GAIN2 (Bitfield-Mask: 0xfff) */
#define ADC_COMP_2_GAIN2                                                   ADC_COMP_2_GAIN2_Msk
#define ADC_COMP_2_GAIN2_0                                                 (0x1U << ADC_COMP_2_GAIN2_Pos)
#define ADC_COMP_2_GAIN2_1                                                 (0x2U << ADC_COMP_2_GAIN2_Pos)
#define ADC_COMP_2_GAIN2_2                                                 (0x4U << ADC_COMP_2_GAIN2_Pos)
#define ADC_COMP_2_GAIN2_3                                                 (0x8U << ADC_COMP_2_GAIN2_Pos)
#define ADC_COMP_2_GAIN2_4                                                 (0x10U << ADC_COMP_2_GAIN2_Pos)
#define ADC_COMP_2_GAIN2_5                                                 (0x20U << ADC_COMP_2_GAIN2_Pos)
#define ADC_COMP_2_GAIN2_6                                                 (0x40U << ADC_COMP_2_GAIN2_Pos)
#define ADC_COMP_2_GAIN2_7                                                 (0x80U << ADC_COMP_2_GAIN2_Pos)
#define ADC_COMP_2_GAIN2_8                                                 (0x100U << ADC_COMP_2_GAIN2_Pos)
#define ADC_COMP_2_GAIN2_9                                                 (0x200U << ADC_COMP_2_GAIN2_Pos)
#define ADC_COMP_2_GAIN2_10                                                (0x400U << ADC_COMP_2_GAIN2_Pos)
#define ADC_COMP_2_GAIN2_11                                                (0x800U << ADC_COMP_2_GAIN2_Pos)

/* =====================================================    COMP_3    ===================================================== */ 
#define ADC_COMP_3_OFFSET3_Pos                                             (12UL)		/*!<ADC COMP_3: OFFSET3 (Bit 12) */
#define ADC_COMP_3_OFFSET3_Msk                                             (0x7f000UL)		/*!< ADC COMP_3: OFFSET3 (Bitfield-Mask: 0x7f) */
#define ADC_COMP_3_OFFSET3                                                 ADC_COMP_3_OFFSET3_Msk
#define ADC_COMP_3_OFFSET3_0                                               (0x1U << ADC_COMP_3_OFFSET3_Pos)
#define ADC_COMP_3_OFFSET3_1                                               (0x2U << ADC_COMP_3_OFFSET3_Pos)
#define ADC_COMP_3_OFFSET3_2                                               (0x4U << ADC_COMP_3_OFFSET3_Pos)
#define ADC_COMP_3_OFFSET3_3                                               (0x8U << ADC_COMP_3_OFFSET3_Pos)
#define ADC_COMP_3_OFFSET3_4                                               (0x10U << ADC_COMP_3_OFFSET3_Pos)
#define ADC_COMP_3_OFFSET3_5                                               (0x20U << ADC_COMP_3_OFFSET3_Pos)
#define ADC_COMP_3_OFFSET3_6                                               (0x40U << ADC_COMP_3_OFFSET3_Pos)
#define ADC_COMP_3_GAIN3_Pos                                               (0UL)		/*!<ADC COMP_3: GAIN3 (Bit 0) */
#define ADC_COMP_3_GAIN3_Msk                                               (0xfffUL)		/*!< ADC COMP_3: GAIN3 (Bitfield-Mask: 0xfff) */
#define ADC_COMP_3_GAIN3                                                   ADC_COMP_3_GAIN3_Msk
#define ADC_COMP_3_GAIN3_0                                                 (0x1U << ADC_COMP_3_GAIN3_Pos)
#define ADC_COMP_3_GAIN3_1                                                 (0x2U << ADC_COMP_3_GAIN3_Pos)
#define ADC_COMP_3_GAIN3_2                                                 (0x4U << ADC_COMP_3_GAIN3_Pos)
#define ADC_COMP_3_GAIN3_3                                                 (0x8U << ADC_COMP_3_GAIN3_Pos)
#define ADC_COMP_3_GAIN3_4                                                 (0x10U << ADC_COMP_3_GAIN3_Pos)
#define ADC_COMP_3_GAIN3_5                                                 (0x20U << ADC_COMP_3_GAIN3_Pos)
#define ADC_COMP_3_GAIN3_6                                                 (0x40U << ADC_COMP_3_GAIN3_Pos)
#define ADC_COMP_3_GAIN3_7                                                 (0x80U << ADC_COMP_3_GAIN3_Pos)
#define ADC_COMP_3_GAIN3_8                                                 (0x100U << ADC_COMP_3_GAIN3_Pos)
#define ADC_COMP_3_GAIN3_9                                                 (0x200U << ADC_COMP_3_GAIN3_Pos)
#define ADC_COMP_3_GAIN3_10                                                (0x400U << ADC_COMP_3_GAIN3_Pos)
#define ADC_COMP_3_GAIN3_11                                                (0x800U << ADC_COMP_3_GAIN3_Pos)

/* =====================================================    COMP_4    ===================================================== */ 
#define ADC_COMP_4_OFFSET4_Pos                                             (12UL)		/*!<ADC COMP_4: OFFSET4 (Bit 12) */
#define ADC_COMP_4_OFFSET4_Msk                                             (0x7f000UL)		/*!< ADC COMP_4: OFFSET4 (Bitfield-Mask: 0x7f) */
#define ADC_COMP_4_OFFSET4                                                 ADC_COMP_4_OFFSET4_Msk
#define ADC_COMP_4_OFFSET4_0                                               (0x1U << ADC_COMP_4_OFFSET4_Pos)
#define ADC_COMP_4_OFFSET4_1                                               (0x2U << ADC_COMP_4_OFFSET4_Pos)
#define ADC_COMP_4_OFFSET4_2                                               (0x4U << ADC_COMP_4_OFFSET4_Pos)
#define ADC_COMP_4_OFFSET4_3                                               (0x8U << ADC_COMP_4_OFFSET4_Pos)
#define ADC_COMP_4_OFFSET4_4                                               (0x10U << ADC_COMP_4_OFFSET4_Pos)
#define ADC_COMP_4_OFFSET4_5                                               (0x20U << ADC_COMP_4_OFFSET4_Pos)
#define ADC_COMP_4_OFFSET4_6                                               (0x40U << ADC_COMP_4_OFFSET4_Pos)
#define ADC_COMP_4_GAIN4_Pos                                               (0UL)		/*!<ADC COMP_4: GAIN4 (Bit 0) */
#define ADC_COMP_4_GAIN4_Msk                                               (0xfffUL)		/*!< ADC COMP_4: GAIN4 (Bitfield-Mask: 0xfff) */
#define ADC_COMP_4_GAIN4                                                   ADC_COMP_4_GAIN4_Msk
#define ADC_COMP_4_GAIN4_0                                                 (0x1U << ADC_COMP_4_GAIN4_Pos)
#define ADC_COMP_4_GAIN4_1                                                 (0x2U << ADC_COMP_4_GAIN4_Pos)
#define ADC_COMP_4_GAIN4_2                                                 (0x4U << ADC_COMP_4_GAIN4_Pos)
#define ADC_COMP_4_GAIN4_3                                                 (0x8U << ADC_COMP_4_GAIN4_Pos)
#define ADC_COMP_4_GAIN4_4                                                 (0x10U << ADC_COMP_4_GAIN4_Pos)
#define ADC_COMP_4_GAIN4_5                                                 (0x20U << ADC_COMP_4_GAIN4_Pos)
#define ADC_COMP_4_GAIN4_6                                                 (0x40U << ADC_COMP_4_GAIN4_Pos)
#define ADC_COMP_4_GAIN4_7                                                 (0x80U << ADC_COMP_4_GAIN4_Pos)
#define ADC_COMP_4_GAIN4_8                                                 (0x100U << ADC_COMP_4_GAIN4_Pos)
#define ADC_COMP_4_GAIN4_9                                                 (0x200U << ADC_COMP_4_GAIN4_Pos)
#define ADC_COMP_4_GAIN4_10                                                (0x400U << ADC_COMP_4_GAIN4_Pos)
#define ADC_COMP_4_GAIN4_11                                                (0x800U << ADC_COMP_4_GAIN4_Pos)

/* =====================================================    COMP_SEL    ===================================================== */ 
#define ADC_COMP_SEL_OFFSET_GAIN8_Pos                                      (16UL)		/*!<ADC COMP_SEL: OFFSET_GAIN8 (Bit 16) */
#define ADC_COMP_SEL_OFFSET_GAIN8_Msk                                      (0x30000UL)		/*!< ADC COMP_SEL: OFFSET_GAIN8 (Bitfield-Mask: 0x03) */
#define ADC_COMP_SEL_OFFSET_GAIN8                                          ADC_COMP_SEL_OFFSET_GAIN8_Msk
#define ADC_COMP_SEL_OFFSET_GAIN8_0                                        (0x1U << ADC_COMP_SEL_OFFSET_GAIN8_Pos)
#define ADC_COMP_SEL_OFFSET_GAIN8_1                                        (0x2U << ADC_COMP_SEL_OFFSET_GAIN8_Pos)
#define ADC_COMP_SEL_OFFSET_GAIN7_Pos                                      (14UL)		/*!<ADC COMP_SEL: OFFSET_GAIN7 (Bit 14) */
#define ADC_COMP_SEL_OFFSET_GAIN7_Msk                                      (0xc000UL)		/*!< ADC COMP_SEL: OFFSET_GAIN7 (Bitfield-Mask: 0x03) */
#define ADC_COMP_SEL_OFFSET_GAIN7                                          ADC_COMP_SEL_OFFSET_GAIN7_Msk
#define ADC_COMP_SEL_OFFSET_GAIN7_0                                        (0x1U << ADC_COMP_SEL_OFFSET_GAIN7_Pos)
#define ADC_COMP_SEL_OFFSET_GAIN7_1                                        (0x2U << ADC_COMP_SEL_OFFSET_GAIN7_Pos)
#define ADC_COMP_SEL_OFFSET_GAIN6_Pos                                      (12UL)		/*!<ADC COMP_SEL: OFFSET_GAIN6 (Bit 12) */
#define ADC_COMP_SEL_OFFSET_GAIN6_Msk                                      (0x3000UL)		/*!< ADC COMP_SEL: OFFSET_GAIN6 (Bitfield-Mask: 0x03) */
#define ADC_COMP_SEL_OFFSET_GAIN6                                          ADC_COMP_SEL_OFFSET_GAIN6_Msk
#define ADC_COMP_SEL_OFFSET_GAIN6_0                                        (0x1U << ADC_COMP_SEL_OFFSET_GAIN6_Pos)
#define ADC_COMP_SEL_OFFSET_GAIN6_1                                        (0x2U << ADC_COMP_SEL_OFFSET_GAIN6_Pos)
#define ADC_COMP_SEL_OFFSET_GAIN5_Pos                                      (10UL)		/*!<ADC COMP_SEL: OFFSET_GAIN5 (Bit 10) */
#define ADC_COMP_SEL_OFFSET_GAIN5_Msk                                      (0xc00UL)		/*!< ADC COMP_SEL: OFFSET_GAIN5 (Bitfield-Mask: 0x03) */
#define ADC_COMP_SEL_OFFSET_GAIN5                                          ADC_COMP_SEL_OFFSET_GAIN5_Msk
#define ADC_COMP_SEL_OFFSET_GAIN5_0                                        (0x1U << ADC_COMP_SEL_OFFSET_GAIN5_Pos)
#define ADC_COMP_SEL_OFFSET_GAIN5_1                                        (0x2U << ADC_COMP_SEL_OFFSET_GAIN5_Pos)
#define ADC_COMP_SEL_OFFSET_GAIN4_Pos                                      (8UL)		/*!<ADC COMP_SEL: OFFSET_GAIN4 (Bit 8) */
#define ADC_COMP_SEL_OFFSET_GAIN4_Msk                                      (0x300UL)		/*!< ADC COMP_SEL: OFFSET_GAIN4 (Bitfield-Mask: 0x03) */
#define ADC_COMP_SEL_OFFSET_GAIN4                                          ADC_COMP_SEL_OFFSET_GAIN4_Msk
#define ADC_COMP_SEL_OFFSET_GAIN4_0                                        (0x1U << ADC_COMP_SEL_OFFSET_GAIN4_Pos)
#define ADC_COMP_SEL_OFFSET_GAIN4_1                                        (0x2U << ADC_COMP_SEL_OFFSET_GAIN4_Pos)
#define ADC_COMP_SEL_OFFSET_GAIN3_Pos                                      (6UL)		/*!<ADC COMP_SEL: OFFSET_GAIN3 (Bit 6) */
#define ADC_COMP_SEL_OFFSET_GAIN3_Msk                                      (0xc0UL)		/*!< ADC COMP_SEL: OFFSET_GAIN3 (Bitfield-Mask: 0x03) */
#define ADC_COMP_SEL_OFFSET_GAIN3                                          ADC_COMP_SEL_OFFSET_GAIN3_Msk
#define ADC_COMP_SEL_OFFSET_GAIN3_0                                        (0x1U << ADC_COMP_SEL_OFFSET_GAIN3_Pos)
#define ADC_COMP_SEL_OFFSET_GAIN3_1                                        (0x2U << ADC_COMP_SEL_OFFSET_GAIN3_Pos)
#define ADC_COMP_SEL_OFFSET_GAIN2_Pos                                      (4UL)		/*!<ADC COMP_SEL: OFFSET_GAIN2 (Bit 4) */
#define ADC_COMP_SEL_OFFSET_GAIN2_Msk                                      (0x30UL)		/*!< ADC COMP_SEL: OFFSET_GAIN2 (Bitfield-Mask: 0x03) */
#define ADC_COMP_SEL_OFFSET_GAIN2                                          ADC_COMP_SEL_OFFSET_GAIN2_Msk
#define ADC_COMP_SEL_OFFSET_GAIN2_0                                        (0x1U << ADC_COMP_SEL_OFFSET_GAIN2_Pos)
#define ADC_COMP_SEL_OFFSET_GAIN2_1                                        (0x2U << ADC_COMP_SEL_OFFSET_GAIN2_Pos)
#define ADC_COMP_SEL_OFFSET_GAIN1_Pos                                      (2UL)		/*!<ADC COMP_SEL: OFFSET_GAIN1 (Bit 2) */
#define ADC_COMP_SEL_OFFSET_GAIN1_Msk                                      (0xcUL)		/*!< ADC COMP_SEL: OFFSET_GAIN1 (Bitfield-Mask: 0x03) */
#define ADC_COMP_SEL_OFFSET_GAIN1                                          ADC_COMP_SEL_OFFSET_GAIN1_Msk
#define ADC_COMP_SEL_OFFSET_GAIN1_0                                        (0x1U << ADC_COMP_SEL_OFFSET_GAIN1_Pos)
#define ADC_COMP_SEL_OFFSET_GAIN1_1                                        (0x2U << ADC_COMP_SEL_OFFSET_GAIN1_Pos)
#define ADC_COMP_SEL_OFFSET_GAIN0_Pos                                      (0UL)		/*!<ADC COMP_SEL: OFFSET_GAIN0 (Bit 0) */
#define ADC_COMP_SEL_OFFSET_GAIN0_Msk                                      (0x3UL)		/*!< ADC COMP_SEL: OFFSET_GAIN0 (Bitfield-Mask: 0x03) */
#define ADC_COMP_SEL_OFFSET_GAIN0                                          ADC_COMP_SEL_OFFSET_GAIN0_Msk
#define ADC_COMP_SEL_OFFSET_GAIN0_0                                        (0x1U << ADC_COMP_SEL_OFFSET_GAIN0_Pos)
#define ADC_COMP_SEL_OFFSET_GAIN0_1                                        (0x2U << ADC_COMP_SEL_OFFSET_GAIN0_Pos)

/* =====================================================    WD_TH    ===================================================== */ 
#define ADC_WD_TH_WD_HT_Pos                                                (16UL)		/*!<ADC WD_TH: WD_HT (Bit 16) */
#define ADC_WD_TH_WD_HT_Msk                                                (0xfff0000UL)		/*!< ADC WD_TH: WD_HT (Bitfield-Mask: 0xfff) */
#define ADC_WD_TH_WD_HT                                                    ADC_WD_TH_WD_HT_Msk
#define ADC_WD_TH_WD_HT_0                                                  (0x1U << ADC_WD_TH_WD_HT_Pos)
#define ADC_WD_TH_WD_HT_1                                                  (0x2U << ADC_WD_TH_WD_HT_Pos)
#define ADC_WD_TH_WD_HT_2                                                  (0x4U << ADC_WD_TH_WD_HT_Pos)
#define ADC_WD_TH_WD_HT_3                                                  (0x8U << ADC_WD_TH_WD_HT_Pos)
#define ADC_WD_TH_WD_HT_4                                                  (0x10U << ADC_WD_TH_WD_HT_Pos)
#define ADC_WD_TH_WD_HT_5                                                  (0x20U << ADC_WD_TH_WD_HT_Pos)
#define ADC_WD_TH_WD_HT_6                                                  (0x40U << ADC_WD_TH_WD_HT_Pos)
#define ADC_WD_TH_WD_HT_7                                                  (0x80U << ADC_WD_TH_WD_HT_Pos)
#define ADC_WD_TH_WD_HT_8                                                  (0x100U << ADC_WD_TH_WD_HT_Pos)
#define ADC_WD_TH_WD_HT_9                                                  (0x200U << ADC_WD_TH_WD_HT_Pos)
#define ADC_WD_TH_WD_HT_10                                                 (0x400U << ADC_WD_TH_WD_HT_Pos)
#define ADC_WD_TH_WD_HT_11                                                 (0x800U << ADC_WD_TH_WD_HT_Pos)
#define ADC_WD_TH_WD_LT_Pos                                                (0UL)		/*!<ADC WD_TH: WD_LT (Bit 0) */
#define ADC_WD_TH_WD_LT_Msk                                                (0xfffUL)		/*!< ADC WD_TH: WD_LT (Bitfield-Mask: 0xfff) */
#define ADC_WD_TH_WD_LT                                                    ADC_WD_TH_WD_LT_Msk
#define ADC_WD_TH_WD_LT_0                                                  (0x1U << ADC_WD_TH_WD_LT_Pos)
#define ADC_WD_TH_WD_LT_1                                                  (0x2U << ADC_WD_TH_WD_LT_Pos)
#define ADC_WD_TH_WD_LT_2                                                  (0x4U << ADC_WD_TH_WD_LT_Pos)
#define ADC_WD_TH_WD_LT_3                                                  (0x8U << ADC_WD_TH_WD_LT_Pos)
#define ADC_WD_TH_WD_LT_4                                                  (0x10U << ADC_WD_TH_WD_LT_Pos)
#define ADC_WD_TH_WD_LT_5                                                  (0x20U << ADC_WD_TH_WD_LT_Pos)
#define ADC_WD_TH_WD_LT_6                                                  (0x40U << ADC_WD_TH_WD_LT_Pos)
#define ADC_WD_TH_WD_LT_7                                                  (0x80U << ADC_WD_TH_WD_LT_Pos)
#define ADC_WD_TH_WD_LT_8                                                  (0x100U << ADC_WD_TH_WD_LT_Pos)
#define ADC_WD_TH_WD_LT_9                                                  (0x200U << ADC_WD_TH_WD_LT_Pos)
#define ADC_WD_TH_WD_LT_10                                                 (0x400U << ADC_WD_TH_WD_LT_Pos)
#define ADC_WD_TH_WD_LT_11                                                 (0x800U << ADC_WD_TH_WD_LT_Pos)

/* =====================================================    WD_CONF    ===================================================== */ 
#define ADC_WD_CONF_AWD_CHX_Pos                                            (0UL)		/*!<ADC WD_CONF: AWD_CHX (Bit 0) */
#define ADC_WD_CONF_AWD_CHX_Msk                                            (0xffffUL)		/*!< ADC WD_CONF: AWD_CHX (Bitfield-Mask: 0xffff) */
#define ADC_WD_CONF_AWD_CHX                                                ADC_WD_CONF_AWD_CHX_Msk
#define ADC_WD_CONF_AWD_CHX_0                                              (0x1U << ADC_WD_CONF_AWD_CHX_Pos)
#define ADC_WD_CONF_AWD_CHX_1                                              (0x2U << ADC_WD_CONF_AWD_CHX_Pos)
#define ADC_WD_CONF_AWD_CHX_2                                              (0x4U << ADC_WD_CONF_AWD_CHX_Pos)
#define ADC_WD_CONF_AWD_CHX_3                                              (0x8U << ADC_WD_CONF_AWD_CHX_Pos)
#define ADC_WD_CONF_AWD_CHX_4                                              (0x10U << ADC_WD_CONF_AWD_CHX_Pos)
#define ADC_WD_CONF_AWD_CHX_5                                              (0x20U << ADC_WD_CONF_AWD_CHX_Pos)
#define ADC_WD_CONF_AWD_CHX_6                                              (0x40U << ADC_WD_CONF_AWD_CHX_Pos)
#define ADC_WD_CONF_AWD_CHX_7                                              (0x80U << ADC_WD_CONF_AWD_CHX_Pos)
#define ADC_WD_CONF_AWD_CHX_8                                              (0x100U << ADC_WD_CONF_AWD_CHX_Pos)
#define ADC_WD_CONF_AWD_CHX_9                                              (0x200U << ADC_WD_CONF_AWD_CHX_Pos)
#define ADC_WD_CONF_AWD_CHX_10                                             (0x400U << ADC_WD_CONF_AWD_CHX_Pos)
#define ADC_WD_CONF_AWD_CHX_11                                             (0x800U << ADC_WD_CONF_AWD_CHX_Pos)
#define ADC_WD_CONF_AWD_CHX_12                                             (0x1000U << ADC_WD_CONF_AWD_CHX_Pos)
#define ADC_WD_CONF_AWD_CHX_13                                             (0x2000U << ADC_WD_CONF_AWD_CHX_Pos)
#define ADC_WD_CONF_AWD_CHX_14                                             (0x4000U << ADC_WD_CONF_AWD_CHX_Pos)
#define ADC_WD_CONF_AWD_CHX_15                                             (0x8000U << ADC_WD_CONF_AWD_CHX_Pos)

/* =====================================================    DS_DATAOUT    ===================================================== */ 
#define ADC_DS_DATAOUT_DS_DATA_Pos                                         (0UL)		/*!<ADC DS_DATAOUT: DS_DATA (Bit 0) */
#define ADC_DS_DATAOUT_DS_DATA_Msk                                         (0xffffUL)		/*!< ADC DS_DATAOUT: DS_DATA (Bitfield-Mask: 0xffff) */
#define ADC_DS_DATAOUT_DS_DATA                                             ADC_DS_DATAOUT_DS_DATA_Msk
#define ADC_DS_DATAOUT_DS_DATA_0                                           (0x1U << ADC_DS_DATAOUT_DS_DATA_Pos)
#define ADC_DS_DATAOUT_DS_DATA_1                                           (0x2U << ADC_DS_DATAOUT_DS_DATA_Pos)
#define ADC_DS_DATAOUT_DS_DATA_2                                           (0x4U << ADC_DS_DATAOUT_DS_DATA_Pos)
#define ADC_DS_DATAOUT_DS_DATA_3                                           (0x8U << ADC_DS_DATAOUT_DS_DATA_Pos)
#define ADC_DS_DATAOUT_DS_DATA_4                                           (0x10U << ADC_DS_DATAOUT_DS_DATA_Pos)
#define ADC_DS_DATAOUT_DS_DATA_5                                           (0x20U << ADC_DS_DATAOUT_DS_DATA_Pos)
#define ADC_DS_DATAOUT_DS_DATA_6                                           (0x40U << ADC_DS_DATAOUT_DS_DATA_Pos)
#define ADC_DS_DATAOUT_DS_DATA_7                                           (0x80U << ADC_DS_DATAOUT_DS_DATA_Pos)
#define ADC_DS_DATAOUT_DS_DATA_8                                           (0x100U << ADC_DS_DATAOUT_DS_DATA_Pos)
#define ADC_DS_DATAOUT_DS_DATA_9                                           (0x200U << ADC_DS_DATAOUT_DS_DATA_Pos)
#define ADC_DS_DATAOUT_DS_DATA_10                                          (0x400U << ADC_DS_DATAOUT_DS_DATA_Pos)
#define ADC_DS_DATAOUT_DS_DATA_11                                          (0x800U << ADC_DS_DATAOUT_DS_DATA_Pos)
#define ADC_DS_DATAOUT_DS_DATA_12                                          (0x1000U << ADC_DS_DATAOUT_DS_DATA_Pos)
#define ADC_DS_DATAOUT_DS_DATA_13                                          (0x2000U << ADC_DS_DATAOUT_DS_DATA_Pos)
#define ADC_DS_DATAOUT_DS_DATA_14                                          (0x4000U << ADC_DS_DATAOUT_DS_DATA_Pos)
#define ADC_DS_DATAOUT_DS_DATA_15                                          (0x8000U << ADC_DS_DATAOUT_DS_DATA_Pos)

/* =====================================================    DF_DATAOUT    ===================================================== */ 
#define ADC_DF_DATAOUT_DF_DATA_Pos                                         (0UL)		/*!<ADC DF_DATAOUT: DF_DATA (Bit 0) */
#define ADC_DF_DATAOUT_DF_DATA_Msk                                         (0xffffUL)		/*!< ADC DF_DATAOUT: DF_DATA (Bitfield-Mask: 0xffff) */
#define ADC_DF_DATAOUT_DF_DATA                                             ADC_DF_DATAOUT_DF_DATA_Msk
#define ADC_DF_DATAOUT_DF_DATA_0                                           (0x1U << ADC_DF_DATAOUT_DF_DATA_Pos)
#define ADC_DF_DATAOUT_DF_DATA_1                                           (0x2U << ADC_DF_DATAOUT_DF_DATA_Pos)
#define ADC_DF_DATAOUT_DF_DATA_2                                           (0x4U << ADC_DF_DATAOUT_DF_DATA_Pos)
#define ADC_DF_DATAOUT_DF_DATA_3                                           (0x8U << ADC_DF_DATAOUT_DF_DATA_Pos)
#define ADC_DF_DATAOUT_DF_DATA_4                                           (0x10U << ADC_DF_DATAOUT_DF_DATA_Pos)
#define ADC_DF_DATAOUT_DF_DATA_5                                           (0x20U << ADC_DF_DATAOUT_DF_DATA_Pos)
#define ADC_DF_DATAOUT_DF_DATA_6                                           (0x40U << ADC_DF_DATAOUT_DF_DATA_Pos)
#define ADC_DF_DATAOUT_DF_DATA_7                                           (0x80U << ADC_DF_DATAOUT_DF_DATA_Pos)
#define ADC_DF_DATAOUT_DF_DATA_8                                           (0x100U << ADC_DF_DATAOUT_DF_DATA_Pos)
#define ADC_DF_DATAOUT_DF_DATA_9                                           (0x200U << ADC_DF_DATAOUT_DF_DATA_Pos)
#define ADC_DF_DATAOUT_DF_DATA_10                                          (0x400U << ADC_DF_DATAOUT_DF_DATA_Pos)
#define ADC_DF_DATAOUT_DF_DATA_11                                          (0x800U << ADC_DF_DATAOUT_DF_DATA_Pos)
#define ADC_DF_DATAOUT_DF_DATA_12                                          (0x1000U << ADC_DF_DATAOUT_DF_DATA_Pos)
#define ADC_DF_DATAOUT_DF_DATA_13                                          (0x2000U << ADC_DF_DATAOUT_DF_DATA_Pos)
#define ADC_DF_DATAOUT_DF_DATA_14                                          (0x4000U << ADC_DF_DATAOUT_DF_DATA_Pos)
#define ADC_DF_DATAOUT_DF_DATA_15                                          (0x8000U << ADC_DF_DATAOUT_DF_DATA_Pos)

/* =====================================================    IRQ_STATUS    ===================================================== */ 
#define ADC_IRQ_STATUS_DF_OVRFL_IRQ_Pos                                    (7UL)		/*!<ADC IRQ_STATUS: DF_OVRFL_IRQ (Bit 7) */
#define ADC_IRQ_STATUS_DF_OVRFL_IRQ_Msk                                    (0x80UL)		/*!< ADC IRQ_STATUS: DF_OVRFL_IRQ (Bitfield-Mask: 0x01) */
#define ADC_IRQ_STATUS_DF_OVRFL_IRQ                                        ADC_IRQ_STATUS_DF_OVRFL_IRQ_Msk
#define ADC_IRQ_STATUS_OVR_DF_IRQ_Pos                                      (6UL)		/*!<ADC IRQ_STATUS: OVR_DF_IRQ (Bit 6) */
#define ADC_IRQ_STATUS_OVR_DF_IRQ_Msk                                      (0x40UL)		/*!< ADC IRQ_STATUS: OVR_DF_IRQ (Bitfield-Mask: 0x01) */
#define ADC_IRQ_STATUS_OVR_DF_IRQ                                          ADC_IRQ_STATUS_OVR_DF_IRQ_Msk
#define ADC_IRQ_STATUS_OVR_DS_IRQ_Pos                                      (5UL)		/*!<ADC IRQ_STATUS: OVR_DS_IRQ (Bit 5) */
#define ADC_IRQ_STATUS_OVR_DS_IRQ_Msk                                      (0x20UL)		/*!< ADC IRQ_STATUS: OVR_DS_IRQ (Bitfield-Mask: 0x01) */
#define ADC_IRQ_STATUS_OVR_DS_IRQ                                          ADC_IRQ_STATUS_OVR_DS_IRQ_Msk
#define ADC_IRQ_STATUS_AWD_IRQ_Pos                                         (4UL)		/*!<ADC IRQ_STATUS: AWD_IRQ (Bit 4) */
#define ADC_IRQ_STATUS_AWD_IRQ_Msk                                         (0x10UL)		/*!< ADC IRQ_STATUS: AWD_IRQ (Bitfield-Mask: 0x01) */
#define ADC_IRQ_STATUS_AWD_IRQ                                             ADC_IRQ_STATUS_AWD_IRQ_Msk
#define ADC_IRQ_STATUS_EOS_IRQ_Pos                                         (3UL)		/*!<ADC IRQ_STATUS: EOS_IRQ (Bit 3) */
#define ADC_IRQ_STATUS_EOS_IRQ_Msk                                         (0x8UL)		/*!< ADC IRQ_STATUS: EOS_IRQ (Bitfield-Mask: 0x01) */
#define ADC_IRQ_STATUS_EOS_IRQ                                             ADC_IRQ_STATUS_EOS_IRQ_Msk
#define ADC_IRQ_STATUS_EODF_IRQ_Pos                                        (2UL)		/*!<ADC IRQ_STATUS: EODF_IRQ (Bit 2) */
#define ADC_IRQ_STATUS_EODF_IRQ_Msk                                        (0x4UL)		/*!< ADC IRQ_STATUS: EODF_IRQ (Bitfield-Mask: 0x01) */
#define ADC_IRQ_STATUS_EODF_IRQ                                            ADC_IRQ_STATUS_EODF_IRQ_Msk
#define ADC_IRQ_STATUS_EODS_IRQ_Pos                                        (1UL)		/*!<ADC IRQ_STATUS: EODS_IRQ (Bit 1) */
#define ADC_IRQ_STATUS_EODS_IRQ_Msk                                        (0x2UL)		/*!< ADC IRQ_STATUS: EODS_IRQ (Bitfield-Mask: 0x01) */
#define ADC_IRQ_STATUS_EODS_IRQ                                            ADC_IRQ_STATUS_EODS_IRQ_Msk
#define ADC_IRQ_STATUS_EOC_IRQ_Pos                                         (0UL)		/*!<ADC IRQ_STATUS: EOC_IRQ (Bit 0) */
#define ADC_IRQ_STATUS_EOC_IRQ_Msk                                         (0x1UL)		/*!< ADC IRQ_STATUS: EOC_IRQ (Bitfield-Mask: 0x01) */
#define ADC_IRQ_STATUS_EOC_IRQ                                             ADC_IRQ_STATUS_EOC_IRQ_Msk

/* =====================================================    IRQ_ENABLE    ===================================================== */ 
#define ADC_IRQ_ENABLE_DF_OVRFL_IRQ_ENA_Pos                                (7UL)		/*!<ADC IRQ_ENABLE: DF_OVRFL_IRQ_ENA (Bit 7) */
#define ADC_IRQ_ENABLE_DF_OVRFL_IRQ_ENA_Msk                                (0x80UL)		/*!< ADC IRQ_ENABLE: DF_OVRFL_IRQ_ENA (Bitfield-Mask: 0x01) */
#define ADC_IRQ_ENABLE_DF_OVRFL_IRQ_ENA                                    ADC_IRQ_ENABLE_DF_OVRFL_IRQ_ENA_Msk
#define ADC_IRQ_ENABLE_OVR_DF_IRQ_ENA_Pos                                  (6UL)		/*!<ADC IRQ_ENABLE: OVR_DF_IRQ_ENA (Bit 6) */
#define ADC_IRQ_ENABLE_OVR_DF_IRQ_ENA_Msk                                  (0x40UL)		/*!< ADC IRQ_ENABLE: OVR_DF_IRQ_ENA (Bitfield-Mask: 0x01) */
#define ADC_IRQ_ENABLE_OVR_DF_IRQ_ENA                                      ADC_IRQ_ENABLE_OVR_DF_IRQ_ENA_Msk
#define ADC_IRQ_ENABLE_OVR_DS_IRQ_ENA_Pos                                  (5UL)		/*!<ADC IRQ_ENABLE: OVR_DS_IRQ_ENA (Bit 5) */
#define ADC_IRQ_ENABLE_OVR_DS_IRQ_ENA_Msk                                  (0x20UL)		/*!< ADC IRQ_ENABLE: OVR_DS_IRQ_ENA (Bitfield-Mask: 0x01) */
#define ADC_IRQ_ENABLE_OVR_DS_IRQ_ENA                                      ADC_IRQ_ENABLE_OVR_DS_IRQ_ENA_Msk
#define ADC_IRQ_ENABLE_AWD_IRQ_ENA_Pos                                     (4UL)		/*!<ADC IRQ_ENABLE: AWD_IRQ_ENA (Bit 4) */
#define ADC_IRQ_ENABLE_AWD_IRQ_ENA_Msk                                     (0x10UL)		/*!< ADC IRQ_ENABLE: AWD_IRQ_ENA (Bitfield-Mask: 0x01) */
#define ADC_IRQ_ENABLE_AWD_IRQ_ENA                                         ADC_IRQ_ENABLE_AWD_IRQ_ENA_Msk
#define ADC_IRQ_ENABLE_EOS_IRQ_ENA_Pos                                     (3UL)		/*!<ADC IRQ_ENABLE: EOS_IRQ_ENA (Bit 3) */
#define ADC_IRQ_ENABLE_EOS_IRQ_ENA_Msk                                     (0x8UL)		/*!< ADC IRQ_ENABLE: EOS_IRQ_ENA (Bitfield-Mask: 0x01) */
#define ADC_IRQ_ENABLE_EOS_IRQ_ENA                                         ADC_IRQ_ENABLE_EOS_IRQ_ENA_Msk
#define ADC_IRQ_ENABLE_EODF_IRQ_ENA_Pos                                    (2UL)		/*!<ADC IRQ_ENABLE: EODF_IRQ_ENA (Bit 2) */
#define ADC_IRQ_ENABLE_EODF_IRQ_ENA_Msk                                    (0x4UL)		/*!< ADC IRQ_ENABLE: EODF_IRQ_ENA (Bitfield-Mask: 0x01) */
#define ADC_IRQ_ENABLE_EODF_IRQ_ENA                                        ADC_IRQ_ENABLE_EODF_IRQ_ENA_Msk
#define ADC_IRQ_ENABLE_EODS_IRQ_ENA_Pos                                    (1UL)		/*!<ADC IRQ_ENABLE: EODS_IRQ_ENA (Bit 1) */
#define ADC_IRQ_ENABLE_EODS_IRQ_ENA_Msk                                    (0x2UL)		/*!< ADC IRQ_ENABLE: EODS_IRQ_ENA (Bitfield-Mask: 0x01) */
#define ADC_IRQ_ENABLE_EODS_IRQ_ENA                                        ADC_IRQ_ENABLE_EODS_IRQ_ENA_Msk
#define ADC_IRQ_ENABLE_EOC_IRQ_ENA_Pos                                     (0UL)		/*!<ADC IRQ_ENABLE: EOC_IRQ_ENA (Bit 0) */
#define ADC_IRQ_ENABLE_EOC_IRQ_ENA_Msk                                     (0x1UL)		/*!< ADC IRQ_ENABLE: EOC_IRQ_ENA (Bitfield-Mask: 0x01) */
#define ADC_IRQ_ENABLE_EOC_IRQ_ENA                                         ADC_IRQ_ENABLE_EOC_IRQ_ENA_Msk

/* =====================================================    TIMER_CONF    ===================================================== */ 
#define ADC_TIMER_CONF_PRECH_DELAY_SEL_Pos                                 (16UL)		/*!<ADC TIMER_CONF: PRECH_DELAY_SEL (Bit 16) */
#define ADC_TIMER_CONF_PRECH_DELAY_SEL_Msk                                 (0x10000UL)		/*!< ADC TIMER_CONF: PRECH_DELAY_SEL (Bitfield-Mask: 0x01) */
#define ADC_TIMER_CONF_PRECH_DELAY_SEL                                     ADC_TIMER_CONF_PRECH_DELAY_SEL_Msk
#define ADC_TIMER_CONF_VBIAS_PRECH_DELAY_Pos                               (8UL)		/*!<ADC TIMER_CONF: VBIAS_PRECH_DELAY (Bit 8) */
#define ADC_TIMER_CONF_VBIAS_PRECH_DELAY_Msk                               (0xff00UL)		/*!< ADC TIMER_CONF: VBIAS_PRECH_DELAY (Bitfield-Mask: 0xff) */
#define ADC_TIMER_CONF_VBIAS_PRECH_DELAY                                   ADC_TIMER_CONF_VBIAS_PRECH_DELAY_Msk
#define ADC_TIMER_CONF_VBIAS_PRECH_DELAY_0                                 (0x1U << ADC_TIMER_CONF_VBIAS_PRECH_DELAY_Pos)
#define ADC_TIMER_CONF_VBIAS_PRECH_DELAY_1                                 (0x2U << ADC_TIMER_CONF_VBIAS_PRECH_DELAY_Pos)
#define ADC_TIMER_CONF_VBIAS_PRECH_DELAY_2                                 (0x4U << ADC_TIMER_CONF_VBIAS_PRECH_DELAY_Pos)
#define ADC_TIMER_CONF_VBIAS_PRECH_DELAY_3                                 (0x8U << ADC_TIMER_CONF_VBIAS_PRECH_DELAY_Pos)
#define ADC_TIMER_CONF_VBIAS_PRECH_DELAY_4                                 (0x10U << ADC_TIMER_CONF_VBIAS_PRECH_DELAY_Pos)
#define ADC_TIMER_CONF_VBIAS_PRECH_DELAY_5                                 (0x20U << ADC_TIMER_CONF_VBIAS_PRECH_DELAY_Pos)
#define ADC_TIMER_CONF_VBIAS_PRECH_DELAY_6                                 (0x40U << ADC_TIMER_CONF_VBIAS_PRECH_DELAY_Pos)
#define ADC_TIMER_CONF_VBIAS_PRECH_DELAY_7                                 (0x80U << ADC_TIMER_CONF_VBIAS_PRECH_DELAY_Pos)
#define ADC_TIMER_CONF_ADC_LDO_DELAY_Pos                                   (0UL)		/*!<ADC TIMER_CONF: ADC_LDO_DELAY (Bit 0) */
#define ADC_TIMER_CONF_ADC_LDO_DELAY_Msk                                   (0xffUL)		/*!< ADC TIMER_CONF: ADC_LDO_DELAY (Bitfield-Mask: 0xff) */
#define ADC_TIMER_CONF_ADC_LDO_DELAY                                       ADC_TIMER_CONF_ADC_LDO_DELAY_Msk
#define ADC_TIMER_CONF_ADC_LDO_DELAY_0                                     (0x1U << ADC_TIMER_CONF_ADC_LDO_DELAY_Pos)
#define ADC_TIMER_CONF_ADC_LDO_DELAY_1                                     (0x2U << ADC_TIMER_CONF_ADC_LDO_DELAY_Pos)
#define ADC_TIMER_CONF_ADC_LDO_DELAY_2                                     (0x4U << ADC_TIMER_CONF_ADC_LDO_DELAY_Pos)
#define ADC_TIMER_CONF_ADC_LDO_DELAY_3                                     (0x8U << ADC_TIMER_CONF_ADC_LDO_DELAY_Pos)
#define ADC_TIMER_CONF_ADC_LDO_DELAY_4                                     (0x10U << ADC_TIMER_CONF_ADC_LDO_DELAY_Pos)
#define ADC_TIMER_CONF_ADC_LDO_DELAY_5                                     (0x20U << ADC_TIMER_CONF_ADC_LDO_DELAY_Pos)
#define ADC_TIMER_CONF_ADC_LDO_DELAY_6                                     (0x40U << ADC_TIMER_CONF_ADC_LDO_DELAY_Pos)
#define ADC_TIMER_CONF_ADC_LDO_DELAY_7                                     (0x80U << ADC_TIMER_CONF_ADC_LDO_DELAY_Pos)


/* =========================================================================================================================== */
/* ================                                     BLUE                                                  ================ */
/* =========================================================================================================================== */


/* ===============================================   CONTROLLERVERNUMREG   =============================================== */
#define BLUE_CONTROLLERVERNUMREG_SUBVERNUM_Pos                             (0UL)   /*!< BLUE CONTROLLERVERNUMREG: SUBVERNUM (Bit 0) */
#define BLUE_CONTROLLERVERNUMREG_SUBVERNUM_Msk                             (0x000000ffUL)  /*!< BLUE CONTROLLERVERNUMREG: SUBVERNUM (Bitfield-Mask: 0xff) */
#define BLUE_CONTROLLERVERNUMREG_SUBVERNUM                                 BLUE_CONTROLLERVERNUMREG_SUBVERNUM_Msk
#define BLUE_CONTROLLERVERNUMREG_SUBVERNUM_0                               (0x01 << BLUE_CONTROLLERVERNUMREG_SUBVERNUM_Pos)   /*!<0x00000001 */
#define BLUE_CONTROLLERVERNUMREG_SUBVERNUM_1                               (0x02 << BLUE_CONTROLLERVERNUMREG_SUBVERNUM_Pos)   /*!<0x00000002 */
#define BLUE_CONTROLLERVERNUMREG_SUBVERNUM_2                               (0x04 << BLUE_CONTROLLERVERNUMREG_SUBVERNUM_Pos)   /*!<0x00000004 */
#define BLUE_CONTROLLERVERNUMREG_SUBVERNUM_3                               (0x08 << BLUE_CONTROLLERVERNUMREG_SUBVERNUM_Pos)   /*!<0x00000008 */
#define BLUE_CONTROLLERVERNUMREG_SUBVERNUM_4                               (0x10 << BLUE_CONTROLLERVERNUMREG_SUBVERNUM_Pos)   /*!<0x00000010 */
#define BLUE_CONTROLLERVERNUMREG_SUBVERNUM_5                               (0x20 << BLUE_CONTROLLERVERNUMREG_SUBVERNUM_Pos)   /*!<0x00000020 */
#define BLUE_CONTROLLERVERNUMREG_SUBVERNUM_6                               (0x40 << BLUE_CONTROLLERVERNUMREG_SUBVERNUM_Pos)   /*!<0x00000040 */
#define BLUE_CONTROLLERVERNUMREG_SUBVERNUM_7                               (0x80 << BLUE_CONTROLLERVERNUMREG_SUBVERNUM_Pos)   /*!<0x00000080 */
#define BLUE_CONTROLLERVERNUMREG_VERNUM_Pos                                (8UL)   /*!< BLUE CONTROLLERVERNUMREG: VERNUM (Bit 8) */
#define BLUE_CONTROLLERVERNUMREG_VERNUM_Msk                                (0x0000ff00UL)  /*!< BLUE CONTROLLERVERNUMREG: VERNUM (Bitfield-Mask: 0xff) */
#define BLUE_CONTROLLERVERNUMREG_VERNUM                                    BLUE_CONTROLLERVERNUMREG_VERNUM_Msk
#define BLUE_CONTROLLERVERNUMREG_VERNUM_0                                  (0x01 << BLUE_CONTROLLERVERNUMREG_VERNUM_Pos)   /*!<0x00000100 */
#define BLUE_CONTROLLERVERNUMREG_VERNUM_1                                  (0x02 << BLUE_CONTROLLERVERNUMREG_VERNUM_Pos)   /*!<0x00000200 */
#define BLUE_CONTROLLERVERNUMREG_VERNUM_2                                  (0x04 << BLUE_CONTROLLERVERNUMREG_VERNUM_Pos)   /*!<0x00000400 */
#define BLUE_CONTROLLERVERNUMREG_VERNUM_3                                  (0x08 << BLUE_CONTROLLERVERNUMREG_VERNUM_Pos)   /*!<0x00000800 */
#define BLUE_CONTROLLERVERNUMREG_VERNUM_4                                  (0x10 << BLUE_CONTROLLERVERNUMREG_VERNUM_Pos)   /*!<0x00001000 */
#define BLUE_CONTROLLERVERNUMREG_VERNUM_5                                  (0x20 << BLUE_CONTROLLERVERNUMREG_VERNUM_Pos)   /*!<0x00002000 */
#define BLUE_CONTROLLERVERNUMREG_VERNUM_6                                  (0x40 << BLUE_CONTROLLERVERNUMREG_VERNUM_Pos)   /*!<0x00004000 */
#define BLUE_CONTROLLERVERNUMREG_VERNUM_7                                  (0x80 << BLUE_CONTROLLERVERNUMREG_VERNUM_Pos)   /*!<0x00008000 */
#define BLUE_CONTROLLERVERNUMREG_TYP_Pos                                   (16UL)   /*!< BLUE CONTROLLERVERNUMREG: TYP (Bit 16) */
#define BLUE_CONTROLLERVERNUMREG_TYP_Msk                                   (0x00ff0000UL)  /*!< BLUE CONTROLLERVERNUMREG: TYP (Bitfield-Mask: 0xff) */
#define BLUE_CONTROLLERVERNUMREG_TYP                                       BLUE_CONTROLLERVERNUMREG_TYP_Msk
#define BLUE_CONTROLLERVERNUMREG_TYP_0                                     (0x01 << BLUE_CONTROLLERVERNUMREG_TYP_Pos)   /*!<0x00010000 */
#define BLUE_CONTROLLERVERNUMREG_TYP_1                                     (0x02 << BLUE_CONTROLLERVERNUMREG_TYP_Pos)   /*!<0x00020000 */
#define BLUE_CONTROLLERVERNUMREG_TYP_2                                     (0x04 << BLUE_CONTROLLERVERNUMREG_TYP_Pos)   /*!<0x00040000 */
#define BLUE_CONTROLLERVERNUMREG_TYP_3                                     (0x08 << BLUE_CONTROLLERVERNUMREG_TYP_Pos)   /*!<0x00080000 */
#define BLUE_CONTROLLERVERNUMREG_TYP_4                                     (0x10 << BLUE_CONTROLLERVERNUMREG_TYP_Pos)   /*!<0x00100000 */
#define BLUE_CONTROLLERVERNUMREG_TYP_5                                     (0x20 << BLUE_CONTROLLERVERNUMREG_TYP_Pos)   /*!<0x00200000 */
#define BLUE_CONTROLLERVERNUMREG_TYP_6                                     (0x40 << BLUE_CONTROLLERVERNUMREG_TYP_Pos)   /*!<0x00400000 */
#define BLUE_CONTROLLERVERNUMREG_TYP_7                                     (0x80 << BLUE_CONTROLLERVERNUMREG_TYP_Pos)   /*!<0x00800000 */

/* ===============================================   INTERRUPT1REG   =============================================== */

#define BLUE_INTERRUPT1REG_ADDPOINTERROR_Pos                               (4UL)   /*!< BLUE INTERRUPT1REG: ADDPOINTERROR (Bit 4) */
#define BLUE_INTERRUPT1REG_ADDPOINTERROR_Msk                               (0x00000010UL)  /*!< BLUE INTERRUPT1REG: ADDPOINTERROR (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1REG_ADDPOINTERROR                                   BLUE_INTERRUPT1REG_ADDPOINTERROR_Msk
#define BLUE_INTERRUPT1REG_RXOVERFLOWERROR_Pos                             (5UL)   /*!< BLUE INTERRUPT1REG: RXOVERFLOWERROR (Bit 5) */
#define BLUE_INTERRUPT1REG_RXOVERFLOWERROR_Msk                             (0x00000020UL)  /*!< BLUE INTERRUPT1REG: RXOVERFLOWERROR (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1REG_RXOVERFLOWERROR                                 BLUE_INTERRUPT1REG_RXOVERFLOWERROR_Msk
#define BLUE_INTERRUPT1REG_SEQDONE_Pos                                     (7UL)   /*!< BLUE INTERRUPT1REG: SEQDONE (Bit 7) */
#define BLUE_INTERRUPT1REG_SEQDONE_Msk                                     (0x00000080UL)  /*!< BLUE INTERRUPT1REG: SEQDONE (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1REG_SEQDONE                                         BLUE_INTERRUPT1REG_SEQDONE_Msk
#define BLUE_INTERRUPT1REG_TXERROR_0_Pos                                   (8UL)   /*!< BLUE INTERRUPT1REG: TXERROR_0 (Bit 8) */
#define BLUE_INTERRUPT1REG_TXERROR_0_Msk                                   (0x00000100UL)  /*!< BLUE INTERRUPT1REG: TXERROR_0 (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1REG_TXERROR_0                                       BLUE_INTERRUPT1REG_TXERROR_0_Msk
#define BLUE_INTERRUPT1REG_TXERROR_1_Pos                                   (9UL)   /*!< BLUE INTERRUPT1REG: TXERROR_1 (Bit 9) */
#define BLUE_INTERRUPT1REG_TXERROR_1_Msk                                   (0x00000200UL)  /*!< BLUE INTERRUPT1REG: TXERROR_1 (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1REG_TXERROR_1                                       BLUE_INTERRUPT1REG_TXERROR_1_Msk
#define BLUE_INTERRUPT1REG_TXERROR_2_Pos                                   (10UL)   /*!< BLUE INTERRUPT1REG: TXERROR_2 (Bit 10) */
#define BLUE_INTERRUPT1REG_TXERROR_2_Msk                                   (0x00000400UL)  /*!< BLUE INTERRUPT1REG: TXERROR_2 (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1REG_TXERROR_2                                       BLUE_INTERRUPT1REG_TXERROR_2_Msk
#define BLUE_INTERRUPT1REG_TXERROR_3_Pos                                   (11UL)   /*!< BLUE INTERRUPT1REG: TXERROR_3 (Bit 11) */
#define BLUE_INTERRUPT1REG_TXERROR_3_Msk                                   (0x00000800UL)  /*!< BLUE INTERRUPT1REG: TXERROR_3 (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1REG_TXERROR_3                                       BLUE_INTERRUPT1REG_TXERROR_3_Msk
#define BLUE_INTERRUPT1REG_TXERROR_4_Pos                                   (12UL)   /*!< BLUE INTERRUPT1REG: TXERROR_4 (Bit 12) */
#define BLUE_INTERRUPT1REG_TXERROR_4_Msk                                   (0x00001000UL)  /*!< BLUE INTERRUPT1REG: TXERROR_4 (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1REG_TXERROR_4                                       BLUE_INTERRUPT1REG_TXERROR_4_Msk
#define BLUE_INTERRUPT1REG_ENCERROR_Pos                                    (13UL)   /*!< BLUE INTERRUPT1REG: ENCERROR (Bit 13) */
#define BLUE_INTERRUPT1REG_ENCERROR_Msk                                    (0x00002000UL)  /*!< BLUE INTERRUPT1REG: ENCERROR (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1REG_ENCERROR                                        BLUE_INTERRUPT1REG_ENCERROR_Msk
#define BLUE_INTERRUPT1REG_ALLTABLEREADYERROR_Pos                          (14UL)   /*!< BLUE INTERRUPT1REG: ALLTABLEREADYERROR (Bit 14) */
#define BLUE_INTERRUPT1REG_ALLTABLEREADYERROR_Msk                          (0x00004000UL)  /*!< BLUE INTERRUPT1REG: ALLTABLEREADYERROR (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1REG_ALLTABLEREADYERROR                              BLUE_INTERRUPT1REG_ALLTABLEREADYERROR_Msk
#define BLUE_INTERRUPT1REG_TXDATAREADYERROR_Pos                            (15UL)   /*!< BLUE INTERRUPT1REG: TXDATAREADYERROR (Bit 15) */
#define BLUE_INTERRUPT1REG_TXDATAREADYERROR_Msk                            (0x00008000UL)  /*!< BLUE INTERRUPT1REG: TXDATAREADYERROR (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1REG_TXDATAREADYERROR                                BLUE_INTERRUPT1REG_TXDATAREADYERROR_Msk
#define BLUE_INTERRUPT1REG_NOACTIVELERROR_Pos                              (16UL)   /*!< BLUE INTERRUPT1REG: NOACTIVELERROR (Bit 16) */
#define BLUE_INTERRUPT1REG_NOACTIVELERROR_Msk                              (0x00010000UL)  /*!< BLUE INTERRUPT1REG: NOACTIVELERROR (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1REG_NOACTIVELERROR                                  BLUE_INTERRUPT1REG_NOACTIVELERROR_Msk
#define BLUE_INTERRUPT1REG_INITDELAYERROR_Pos                              (17UL)   /*!< BLUE INTERRUPT1REG: INITDELAYERROR (Bit 17) */
#define BLUE_INTERRUPT1REG_INITDELAYERROR_Msk                              (0x00020000UL)  /*!< BLUE INTERRUPT1REG: INITDELAYERROR (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1REG_INITDELAYERROR                                  BLUE_INTERRUPT1REG_INITDELAYERROR_Msk
#define BLUE_INTERRUPT1REG_RCVLENGTHERROR_Pos                              (18UL)   /*!< BLUE INTERRUPT1REG: RCVLENGTHERROR (Bit 18) */
#define BLUE_INTERRUPT1REG_RCVLENGTHERROR_Msk                              (0x00040000UL)  /*!< BLUE INTERRUPT1REG: RCVLENGTHERROR (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1REG_RCVLENGTHERROR                                  BLUE_INTERRUPT1REG_RCVLENGTHERROR_Msk
#define BLUE_INTERRUPT1REG_SEMATIMEOUTERROR_Pos                            (19UL)   /*!< BLUE INTERRUPT1REG: SEMATIMEOUTERROR (Bit 19) */
#define BLUE_INTERRUPT1REG_SEMATIMEOUTERROR_Msk                            (0x00080000UL)  /*!< BLUE INTERRUPT1REG: SEMATIMEOUTERROR (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1REG_SEMATIMEOUTERROR                                BLUE_INTERRUPT1REG_SEMATIMEOUTERROR_Msk
#define BLUE_INTERRUPT1REG_SEMAWASPREEMPT_Pos                              (20UL)   /*!< BLUE INTERRUPT1REG: SEMAWASPREEMPT (Bit 20) */
#define BLUE_INTERRUPT1REG_SEMAWASPREEMPT_Msk                              (0x00100000UL)  /*!< BLUE INTERRUPT1REG: SEMAWASPREEMPT (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1REG_SEMAWASPREEMPT                                  BLUE_INTERRUPT1REG_SEMAWASPREEMPT_Msk
#define BLUE_INTERRUPT1REG_TXRXSKIP_Pos                                    (21UL)   /*!< BLUE INTERRUPT1REG: TXRXSKIP (Bit 21) */
#define BLUE_INTERRUPT1REG_TXRXSKIP_Msk                                    (0x00200000UL)  /*!< BLUE INTERRUPT1REG: TXRXSKIP (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1REG_TXRXSKIP                                        BLUE_INTERRUPT1REG_TXRXSKIP_Msk
#define BLUE_INTERRUPT1REG_ACTIVE2ERROR_Pos                                (22UL)   /*!< BLUE INTERRUPT1REG: ACTIVE2ERROR (Bit 22) */
#define BLUE_INTERRUPT1REG_ACTIVE2ERROR_Msk                                (0x00400000UL)  /*!< BLUE INTERRUPT1REG: ACTIVE2ERROR (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1REG_ACTIVE2ERROR                                    BLUE_INTERRUPT1REG_ACTIVE2ERROR_Msk
#define BLUE_INTERRUPT1REG_CONFIGERROR_Pos                                 (23UL)   /*!< BLUE INTERRUPT1REG: CONFIGERROR (Bit 23) */
#define BLUE_INTERRUPT1REG_CONFIGERROR_Msk                                 (0x00800000UL)  /*!< BLUE INTERRUPT1REG: CONFIGERROR (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1REG_CONFIGERROR                                     BLUE_INTERRUPT1REG_CONFIGERROR_Msk
#define BLUE_INTERRUPT1REG_TXOK_Pos                                        (24UL)   /*!< BLUE INTERRUPT1REG: TXOK (Bit 24) */
#define BLUE_INTERRUPT1REG_TXOK_Msk                                        (0x01000000UL)  /*!< BLUE INTERRUPT1REG: TXOK (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1REG_TXOK                                            BLUE_INTERRUPT1REG_TXOK_Msk
#define BLUE_INTERRUPT1REG_DONE_Pos                                        (25UL)   /*!< BLUE INTERRUPT1REG: DONE (Bit 25) */
#define BLUE_INTERRUPT1REG_DONE_Msk                                        (0x02000000UL)  /*!< BLUE INTERRUPT1REG: DONE (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1REG_DONE                                            BLUE_INTERRUPT1REG_DONE_Msk
#define BLUE_INTERRUPT1REG_RCVTIMEOUT_Pos                                  (26UL)   /*!< BLUE INTERRUPT1REG: RCVTIMEOUT (Bit 26) */
#define BLUE_INTERRUPT1REG_RCVTIMEOUT_Msk                                  (0x04000000UL)  /*!< BLUE INTERRUPT1REG: RCVTIMEOUT (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1REG_RCVTIMEOUT                                      BLUE_INTERRUPT1REG_RCVTIMEOUT_Msk
#define BLUE_INTERRUPT1REG_RCVNOMD_Pos                                     (27UL)   /*!< BLUE INTERRUPT1REG: RCVNOMD (Bit 27) */
#define BLUE_INTERRUPT1REG_RCVNOMD_Msk                                     (0x08000000UL)  /*!< BLUE INTERRUPT1REG: RCVNOMD (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1REG_RCVNOMD                                         BLUE_INTERRUPT1REG_RCVNOMD_Msk
#define BLUE_INTERRUPT1REG_RCVCMD_Pos                                      (28UL)   /*!< BLUE INTERRUPT1REG: RCVCMD (Bit 28) */
#define BLUE_INTERRUPT1REG_RCVCMD_Msk                                      (0x10000000UL)  /*!< BLUE INTERRUPT1REG: RCVCMD (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1REG_RCVCMD                                          BLUE_INTERRUPT1REG_RCVCMD_Msk
#define BLUE_INTERRUPT1REG_TIMECAPTURETRIG_Pos                             (29UL)   /*!< BLUE INTERRUPT1REG: TIMECAPTURETRIG (Bit 29) */
#define BLUE_INTERRUPT1REG_TIMECAPTURETRIG_Msk                             (0x20000000UL)  /*!< BLUE INTERRUPT1REG: TIMECAPTURETRIG (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1REG_TIMECAPTURETRIG                                 BLUE_INTERRUPT1REG_TIMECAPTURETRIG_Msk
#define BLUE_INTERRUPT1REG_RCVCRCERR_Pos                                   (30UL)   /*!< BLUE INTERRUPT1REG: RCVCRCERR (Bit 30) */
#define BLUE_INTERRUPT1REG_RCVCRCERR_Msk                                   (0x40000000UL)  /*!< BLUE INTERRUPT1REG: RCVCRCERR (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1REG_RCVCRCERR                                       BLUE_INTERRUPT1REG_RCVCRCERR_Msk
#define BLUE_INTERRUPT1REG_RCVOK_Pos                                       (31UL)   /*!< BLUE INTERRUPT1REG: RCVOK (Bit 31) */
#define BLUE_INTERRUPT1REG_RCVOK_Msk                                       (0x80000000UL)  /*!< BLUE INTERRUPT1REG: RCVOK (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1REG_RCVOK                                           BLUE_INTERRUPT1REG_RCVOK_Msk
#define BLUE_INTERRUPT1REG_ALL_Pos                                         (0UL)
//#define BLUE_INTERRUPT1REG_ALL_Msk                                         (0xffffffffUL)
#define BLUE_INTERRUPT1REG_ALL_Msk                                         (BLUE_INTERRUPT1REG_ADDPOINTERROR | BLUE_INTERRUPT1REG_RXOVERFLOWERROR | BLUE_INTERRUPT1REG_SEQDONE | BLUE_INTERRUPT1REG_TXERROR_0 | BLUE_INTERRUPT1REG_TXERROR_1 | BLUE_INTERRUPT1REG_TXERROR_2 | BLUE_INTERRUPT1REG_TXERROR_3 | BLUE_INTERRUPT1REG_TXERROR_4 | BLUE_INTERRUPT1REG_ENCERROR | BLUE_INTERRUPT1REG_ALLTABLEREADYERROR | BLUE_INTERRUPT1REG_TXDATAREADYERROR | BLUE_INTERRUPT1REG_NOACTIVELERROR | BLUE_INTERRUPT1REG_INITDELAYERROR | BLUE_INTERRUPT1REG_RCVLENGTHERROR | BLUE_INTERRUPT1REG_SEMATIMEOUTERROR | BLUE_INTERRUPT1REG_SEMAWASPREEMPT | BLUE_INTERRUPT1REG_TXRXSKIP | BLUE_INTERRUPT1REG_ACTIVE2ERROR | BLUE_INTERRUPT1REG_CONFIGERROR | BLUE_INTERRUPT1REG_TXOK | BLUE_INTERRUPT1REG_DONE | BLUE_INTERRUPT1REG_RCVTIMEOUT | BLUE_INTERRUPT1REG_RCVNOMD | BLUE_INTERRUPT1REG_RCVCMD | BLUE_INTERRUPT1REG_TIMECAPTURETRIG | BLUE_INTERRUPT1REG_RCVCRCERR | BLUE_INTERRUPT1REG_RCVOK )
#define BLUE_INTERRUPT1REG_ALL                                             BLUE_INTERRUPT1REG_ALL_Msk

/* ===============================================   INTERRUPT2REG   =============================================== */
#define BLUE_INTERRUPT2REG_AESMANENCINT_Pos                                (0UL)   /*!< BLUE INTERRUPT2REG: AESMANENCINT (Bit 0) */
#define BLUE_INTERRUPT2REG_AESMANENCINT_Msk                                (0x00000001UL)  /*!< BLUE INTERRUPT2REG: AESMANENCINT (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT2REG_AESMANENCINT                                    BLUE_INTERRUPT2REG_AESMANENCINT_Msk
#define BLUE_INTERRUPT2REG_AESLEPRIVINT_Pos                                (1UL)   /*!< BLUE INTERRUPT2REG: AESLEPRIVINT (Bit 1) */
#define BLUE_INTERRUPT2REG_AESLEPRIVINT_Msk                                (0x00000002UL)  /*!< BLUE INTERRUPT2REG: AESLEPRIVINT (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT2REG_AESLEPRIVINT                                    BLUE_INTERRUPT2REG_AESLEPRIVINT_Msk

/* ===============================================   TIMEOUTDESTREG   =============================================== */
#define BLUE_TIMEOUTDESTREG_DESTINATION_Pos                                (0UL)   /*!< BLUE TIMEOUTDESTREG: DESTINATION (Bit 0) */
#define BLUE_TIMEOUTDESTREG_DESTINATION_Msk                                (0x00000003UL)  /*!< BLUE TIMEOUTDESTREG: DESTINATION (Bitfield-Mask: 0x3) */
#define BLUE_TIMEOUTDESTREG_DESTINATION                                    BLUE_TIMEOUTDESTREG_DESTINATION_Msk
#define BLUE_TIMEOUTDESTREG_DESTINATION_0                                  (0x1 << BLUE_TIMEOUTDESTREG_DESTINATION_Pos)   /*!<0x00000001 */
#define BLUE_TIMEOUTDESTREG_DESTINATION_1                                  (0x2 << BLUE_TIMEOUTDESTREG_DESTINATION_Pos)   /*!<0x00000002 */

/* ===============================================   TIMEOUTREG   =============================================== */
#define BLUE_TIMEOUTREG_TIMEOUT_Pos                                        (0UL)   /*!< BLUE TIMEOUTREG: TIMEOUT (Bit 0) */
#define BLUE_TIMEOUTREG_TIMEOUT_Msk                                        (0xffffffffUL)  /*!< BLUE TIMEOUTREG: TIMEOUT (Bitfield-Mask: 0xffffffffL) */
#define BLUE_TIMEOUTREG_TIMEOUT                                            BLUE_TIMEOUTREG_TIMEOUT_Msk
#define BLUE_TIMEOUTREG_TIMEOUT_0                                          (0x00000001 << BLUE_TIMEOUTREG_TIMEOUT_Pos)   /*!<0x00000001 */
#define BLUE_TIMEOUTREG_TIMEOUT_1                                          (0x00000002 << BLUE_TIMEOUTREG_TIMEOUT_Pos)   /*!<0x00000002 */
#define BLUE_TIMEOUTREG_TIMEOUT_2                                          (0x00000004 << BLUE_TIMEOUTREG_TIMEOUT_Pos)   /*!<0x00000004 */
#define BLUE_TIMEOUTREG_TIMEOUT_3                                          (0x00000008 << BLUE_TIMEOUTREG_TIMEOUT_Pos)   /*!<0x00000008 */
#define BLUE_TIMEOUTREG_TIMEOUT_4                                          (0x00000010 << BLUE_TIMEOUTREG_TIMEOUT_Pos)   /*!<0x00000010 */
#define BLUE_TIMEOUTREG_TIMEOUT_5                                          (0x00000020 << BLUE_TIMEOUTREG_TIMEOUT_Pos)   /*!<0x00000020 */
#define BLUE_TIMEOUTREG_TIMEOUT_6                                          (0x00000040 << BLUE_TIMEOUTREG_TIMEOUT_Pos)   /*!<0x00000040 */
#define BLUE_TIMEOUTREG_TIMEOUT_7                                          (0x00000080 << BLUE_TIMEOUTREG_TIMEOUT_Pos)   /*!<0x00000080 */
#define BLUE_TIMEOUTREG_TIMEOUT_8                                          (0x00000100 << BLUE_TIMEOUTREG_TIMEOUT_Pos)   /*!<0x00000100 */
#define BLUE_TIMEOUTREG_TIMEOUT_9                                          (0x00000200 << BLUE_TIMEOUTREG_TIMEOUT_Pos)   /*!<0x00000200 */
#define BLUE_TIMEOUTREG_TIMEOUT_10                                         (0x00000400 << BLUE_TIMEOUTREG_TIMEOUT_Pos)   /*!<0x00000400 */
#define BLUE_TIMEOUTREG_TIMEOUT_11                                         (0x00000800 << BLUE_TIMEOUTREG_TIMEOUT_Pos)   /*!<0x00000800 */
#define BLUE_TIMEOUTREG_TIMEOUT_12                                         (0x00001000 << BLUE_TIMEOUTREG_TIMEOUT_Pos)   /*!<0x00001000 */
#define BLUE_TIMEOUTREG_TIMEOUT_13                                         (0x00002000 << BLUE_TIMEOUTREG_TIMEOUT_Pos)   /*!<0x00002000 */
#define BLUE_TIMEOUTREG_TIMEOUT_14                                         (0x00004000 << BLUE_TIMEOUTREG_TIMEOUT_Pos)   /*!<0x00004000 */
#define BLUE_TIMEOUTREG_TIMEOUT_15                                         (0x00008000 << BLUE_TIMEOUTREG_TIMEOUT_Pos)   /*!<0x00008000 */
#define BLUE_TIMEOUTREG_TIMEOUT_16                                         (0x00010000 << BLUE_TIMEOUTREG_TIMEOUT_Pos)   /*!<0x00010000 */
#define BLUE_TIMEOUTREG_TIMEOUT_17                                         (0x00020000 << BLUE_TIMEOUTREG_TIMEOUT_Pos)   /*!<0x00020000 */
#define BLUE_TIMEOUTREG_TIMEOUT_18                                         (0x00040000 << BLUE_TIMEOUTREG_TIMEOUT_Pos)   /*!<0x00040000 */
#define BLUE_TIMEOUTREG_TIMEOUT_19                                         (0x00080000 << BLUE_TIMEOUTREG_TIMEOUT_Pos)   /*!<0x00080000 */
#define BLUE_TIMEOUTREG_TIMEOUT_20                                         (0x00100000 << BLUE_TIMEOUTREG_TIMEOUT_Pos)   /*!<0x00100000 */
#define BLUE_TIMEOUTREG_TIMEOUT_21                                         (0x00200000 << BLUE_TIMEOUTREG_TIMEOUT_Pos)   /*!<0x00200000 */
#define BLUE_TIMEOUTREG_TIMEOUT_22                                         (0x00400000 << BLUE_TIMEOUTREG_TIMEOUT_Pos)   /*!<0x00400000 */
#define BLUE_TIMEOUTREG_TIMEOUT_23                                         (0x00800000 << BLUE_TIMEOUTREG_TIMEOUT_Pos)   /*!<0x00800000 */
#define BLUE_TIMEOUTREG_TIMEOUT_24                                         (0x01000000 << BLUE_TIMEOUTREG_TIMEOUT_Pos)   /*!<0x01000000 */
#define BLUE_TIMEOUTREG_TIMEOUT_25                                         (0x02000000 << BLUE_TIMEOUTREG_TIMEOUT_Pos)   /*!<0x02000000 */
#define BLUE_TIMEOUTREG_TIMEOUT_26                                         (0x04000000 << BLUE_TIMEOUTREG_TIMEOUT_Pos)   /*!<0x04000000 */
#define BLUE_TIMEOUTREG_TIMEOUT_27                                         (0x08000000 << BLUE_TIMEOUTREG_TIMEOUT_Pos)   /*!<0x08000000 */
#define BLUE_TIMEOUTREG_TIMEOUT_28                                         (0x10000000 << BLUE_TIMEOUTREG_TIMEOUT_Pos)   /*!<0x10000000 */
#define BLUE_TIMEOUTREG_TIMEOUT_29                                         (0x20000000 << BLUE_TIMEOUTREG_TIMEOUT_Pos)   /*!<0x20000000 */
#define BLUE_TIMEOUTREG_TIMEOUT_30                                         (0x40000000 << BLUE_TIMEOUTREG_TIMEOUT_Pos)   /*!<0x40000000 */
#define BLUE_TIMEOUTREG_TIMEOUT_31                                         (0x80000000 << BLUE_TIMEOUTREG_TIMEOUT_Pos)   /*!<0x80000000 */

/* ===============================================   TIMERCAPTUREREG   =============================================== */
#define BLUE_TIMERCAPTUREREG_TIMERCAPTURE_Pos                              (0UL)   /*!< BLUE TIMERCAPTUREREG: TIMERCAPTURE (Bit 0) */
#define BLUE_TIMERCAPTUREREG_TIMERCAPTURE_Msk                              (0xffffffffUL)  /*!< BLUE TIMERCAPTUREREG: TIMERCAPTURE (Bitfield-Mask: 0xffffffffL) */
#define BLUE_TIMERCAPTUREREG_TIMERCAPTURE                                  BLUE_TIMERCAPTUREREG_TIMERCAPTURE_Msk
#define BLUE_TIMERCAPTUREREG_TIMERCAPTURE_0                                (0x00000001 << BLUE_TIMERCAPTUREREG_TIMERCAPTURE_Pos)   /*!<0x00000001 */
#define BLUE_TIMERCAPTUREREG_TIMERCAPTURE_1                                (0x00000002 << BLUE_TIMERCAPTUREREG_TIMERCAPTURE_Pos)   /*!<0x00000002 */
#define BLUE_TIMERCAPTUREREG_TIMERCAPTURE_2                                (0x00000004 << BLUE_TIMERCAPTUREREG_TIMERCAPTURE_Pos)   /*!<0x00000004 */
#define BLUE_TIMERCAPTUREREG_TIMERCAPTURE_3                                (0x00000008 << BLUE_TIMERCAPTUREREG_TIMERCAPTURE_Pos)   /*!<0x00000008 */
#define BLUE_TIMERCAPTUREREG_TIMERCAPTURE_4                                (0x00000010 << BLUE_TIMERCAPTUREREG_TIMERCAPTURE_Pos)   /*!<0x00000010 */
#define BLUE_TIMERCAPTUREREG_TIMERCAPTURE_5                                (0x00000020 << BLUE_TIMERCAPTUREREG_TIMERCAPTURE_Pos)   /*!<0x00000020 */
#define BLUE_TIMERCAPTUREREG_TIMERCAPTURE_6                                (0x00000040 << BLUE_TIMERCAPTUREREG_TIMERCAPTURE_Pos)   /*!<0x00000040 */
#define BLUE_TIMERCAPTUREREG_TIMERCAPTURE_7                                (0x00000080 << BLUE_TIMERCAPTUREREG_TIMERCAPTURE_Pos)   /*!<0x00000080 */
#define BLUE_TIMERCAPTUREREG_TIMERCAPTURE_8                                (0x00000100 << BLUE_TIMERCAPTUREREG_TIMERCAPTURE_Pos)   /*!<0x00000100 */
#define BLUE_TIMERCAPTUREREG_TIMERCAPTURE_9                                (0x00000200 << BLUE_TIMERCAPTUREREG_TIMERCAPTURE_Pos)   /*!<0x00000200 */
#define BLUE_TIMERCAPTUREREG_TIMERCAPTURE_10                               (0x00000400 << BLUE_TIMERCAPTUREREG_TIMERCAPTURE_Pos)   /*!<0x00000400 */
#define BLUE_TIMERCAPTUREREG_TIMERCAPTURE_11                               (0x00000800 << BLUE_TIMERCAPTUREREG_TIMERCAPTURE_Pos)   /*!<0x00000800 */
#define BLUE_TIMERCAPTUREREG_TIMERCAPTURE_12                               (0x00001000 << BLUE_TIMERCAPTUREREG_TIMERCAPTURE_Pos)   /*!<0x00001000 */
#define BLUE_TIMERCAPTUREREG_TIMERCAPTURE_13                               (0x00002000 << BLUE_TIMERCAPTUREREG_TIMERCAPTURE_Pos)   /*!<0x00002000 */
#define BLUE_TIMERCAPTUREREG_TIMERCAPTURE_14                               (0x00004000 << BLUE_TIMERCAPTUREREG_TIMERCAPTURE_Pos)   /*!<0x00004000 */
#define BLUE_TIMERCAPTUREREG_TIMERCAPTURE_15                               (0x00008000 << BLUE_TIMERCAPTUREREG_TIMERCAPTURE_Pos)   /*!<0x00008000 */
#define BLUE_TIMERCAPTUREREG_TIMERCAPTURE_16                               (0x00010000 << BLUE_TIMERCAPTUREREG_TIMERCAPTURE_Pos)   /*!<0x00010000 */
#define BLUE_TIMERCAPTUREREG_TIMERCAPTURE_17                               (0x00020000 << BLUE_TIMERCAPTUREREG_TIMERCAPTURE_Pos)   /*!<0x00020000 */
#define BLUE_TIMERCAPTUREREG_TIMERCAPTURE_18                               (0x00040000 << BLUE_TIMERCAPTUREREG_TIMERCAPTURE_Pos)   /*!<0x00040000 */
#define BLUE_TIMERCAPTUREREG_TIMERCAPTURE_19                               (0x00080000 << BLUE_TIMERCAPTUREREG_TIMERCAPTURE_Pos)   /*!<0x00080000 */
#define BLUE_TIMERCAPTUREREG_TIMERCAPTURE_20                               (0x00100000 << BLUE_TIMERCAPTUREREG_TIMERCAPTURE_Pos)   /*!<0x00100000 */
#define BLUE_TIMERCAPTUREREG_TIMERCAPTURE_21                               (0x00200000 << BLUE_TIMERCAPTUREREG_TIMERCAPTURE_Pos)   /*!<0x00200000 */
#define BLUE_TIMERCAPTUREREG_TIMERCAPTURE_22                               (0x00400000 << BLUE_TIMERCAPTUREREG_TIMERCAPTURE_Pos)   /*!<0x00400000 */
#define BLUE_TIMERCAPTUREREG_TIMERCAPTURE_23                               (0x00800000 << BLUE_TIMERCAPTUREREG_TIMERCAPTURE_Pos)   /*!<0x00800000 */
#define BLUE_TIMERCAPTUREREG_TIMERCAPTURE_24                               (0x01000000 << BLUE_TIMERCAPTUREREG_TIMERCAPTURE_Pos)   /*!<0x01000000 */
#define BLUE_TIMERCAPTUREREG_TIMERCAPTURE_25                               (0x02000000 << BLUE_TIMERCAPTUREREG_TIMERCAPTURE_Pos)   /*!<0x02000000 */
#define BLUE_TIMERCAPTUREREG_TIMERCAPTURE_26                               (0x04000000 << BLUE_TIMERCAPTUREREG_TIMERCAPTURE_Pos)   /*!<0x04000000 */
#define BLUE_TIMERCAPTUREREG_TIMERCAPTURE_27                               (0x08000000 << BLUE_TIMERCAPTUREREG_TIMERCAPTURE_Pos)   /*!<0x08000000 */
#define BLUE_TIMERCAPTUREREG_TIMERCAPTURE_28                               (0x10000000 << BLUE_TIMERCAPTUREREG_TIMERCAPTURE_Pos)   /*!<0x10000000 */
#define BLUE_TIMERCAPTUREREG_TIMERCAPTURE_29                               (0x20000000 << BLUE_TIMERCAPTUREREG_TIMERCAPTURE_Pos)   /*!<0x20000000 */
#define BLUE_TIMERCAPTUREREG_TIMERCAPTURE_30                               (0x40000000 << BLUE_TIMERCAPTUREREG_TIMERCAPTURE_Pos)   /*!<0x40000000 */
#define BLUE_TIMERCAPTUREREG_TIMERCAPTURE_31                               (0x80000000 << BLUE_TIMERCAPTUREREG_TIMERCAPTURE_Pos)   /*!<0x80000000 */

/* ===============================================   CMDREG   =============================================== */
#define BLUE_CMDREG_TXRXSKIP_Pos                                           (0UL)   /*!< BLUE CMDREG: TXRXSKIP (Bit 0) */
#define BLUE_CMDREG_TXRXSKIP_Msk                                           (0x00000001UL)  /*!< BLUE CMDREG: TXRXSKIP (Bitfield-Mask: 0x1) */
#define BLUE_CMDREG_TXRXSKIP                                               BLUE_CMDREG_TXRXSKIP_Msk
#define BLUE_CMDREG_LOCKAHBWRITEBACKEN_Pos                                 (1UL)   /*!< BLUE CMDREG: LOCKAHBWRITEBACKEN (Bit 1) */
#define BLUE_CMDREG_LOCKAHBWRITEBACKEN_Msk                                 (0x00000002UL)  /*!< BLUE CMDREG: LOCKAHBWRITEBACKEN (Bitfield-Mask: 0x1) */
#define BLUE_CMDREG_LOCKAHBWRITEBACKEN                                     BLUE_CMDREG_LOCKAHBWRITEBACKEN_Msk
#define BLUE_CMDREG_LOCKAHBFIRSTINITEN_Pos                                 (2UL)   /*!< BLUE CMDREG: LOCKAHBFIRSTINITEN (Bit 2) */
#define BLUE_CMDREG_LOCKAHBFIRSTINITEN_Msk                                 (0x00000004UL)  /*!< BLUE CMDREG: LOCKAHBFIRSTINITEN (Bitfield-Mask: 0x1) */
#define BLUE_CMDREG_LOCKAHBFIRSTINITEN                                     BLUE_CMDREG_LOCKAHBFIRSTINITEN_Msk
#define BLUE_CMDREG_CLEARSEMAREQ_Pos                                       (3UL)   /*!< BLUE CMDREG: CLEARSEMAREQ (Bit 3) */
#define BLUE_CMDREG_CLEARSEMAREQ_Msk                                       (0x00000008UL)  /*!< BLUE CMDREG: CLEARSEMAREQ (Bitfield-Mask: 0x1) */
#define BLUE_CMDREG_CLEARSEMAREQ                                           BLUE_CMDREG_CLEARSEMAREQ_Msk

/* ===============================================   STATUSREG   =============================================== */
#define BLUE_STATUSREG_AESONFLYBUSY_Pos                                    (0UL)   /*!< BLUE STATUSREG: AESONFLYBUSY (Bit 0) */
#define BLUE_STATUSREG_AESONFLYBUSY_Msk                                    (0x00000001UL)  /*!< BLUE STATUSREG: AESONFLYBUSY (Bitfield-Mask: 0x1) */
#define BLUE_STATUSREG_AESONFLYBUSY                                        BLUE_STATUSREG_AESONFLYBUSY_Msk
#define BLUE_STATUSREG_NOT_SUPPORTED_FEATURE_Pos                           (3UL)   /*!< BLUE STATUSREG: NOT_SUPPORTED_FEATURE (Bit 3) */
#define BLUE_STATUSREG_NOT_SUPPORTED_FEATURE_Msk                           (0x00000008UL)  /*!< BLUE STATUSREG: NOT_SUPPORTED_FEATURE (Bitfield-Mask: 0x1) */
#define BLUE_STATUSREG_NOT_SUPPORTED_FEATURE                               BLUE_STATUSREG_NOT_SUPPORTED_FEATURE_Msk
#define BLUE_STATUSREG_ADDPOINTERROR_Pos                                   (4UL)   /*!< BLUE STATUSREG: ADDPOINTERROR (Bit 4) */
#define BLUE_STATUSREG_ADDPOINTERROR_Msk                                   (0x00000010UL)  /*!< BLUE STATUSREG: ADDPOINTERROR (Bitfield-Mask: 0x1) */
#define BLUE_STATUSREG_ADDPOINTERROR                                       BLUE_STATUSREG_ADDPOINTERROR_Msk
#define BLUE_STATUSREG_RXOVERFLOWERROR_Pos                                 (5UL)   /*!< BLUE STATUSREG: RXOVERFLOWERROR (Bit 5) */
#define BLUE_STATUSREG_RXOVERFLOWERROR_Msk                                 (0x00000020UL)  /*!< BLUE STATUSREG: RXOVERFLOWERROR (Bitfield-Mask: 0x1) */
#define BLUE_STATUSREG_RXOVERFLOWERROR                                     BLUE_STATUSREG_RXOVERFLOWERROR_Msk
#define BLUE_STATUSREG_PREVTRANSMIT_Pos                                    (6UL)   /*!< BLUE STATUSREG: PREVTRANSMIT (Bit 6) */
#define BLUE_STATUSREG_PREVTRANSMIT_Msk                                    (0x00000040UL)  /*!< BLUE STATUSREG: PREVTRANSMIT (Bitfield-Mask: 0x1) */
#define BLUE_STATUSREG_PREVTRANSMIT                                        BLUE_STATUSREG_PREVTRANSMIT_Msk
#define BLUE_STATUSREG_SEQDONE_Pos                                         (7UL)   /*!< BLUE STATUSREG: SEQDONE (Bit 7) */
#define BLUE_STATUSREG_SEQDONE_Msk                                         (0x00000080UL)  /*!< BLUE STATUSREG: SEQDONE (Bitfield-Mask: 0x1) */
#define BLUE_STATUSREG_SEQDONE                                             BLUE_STATUSREG_SEQDONE_Msk
#define BLUE_STATUSREG_TXERROR_0_Pos                                       (8UL)   /*!< BLUE STATUSREG: TXERROR_0 (Bit 8) */
#define BLUE_STATUSREG_TXERROR_0_Msk                                       (0x00000100UL)  /*!< BLUE STATUSREG: TXERROR_0 (Bitfield-Mask: 0x1) */
#define BLUE_STATUSREG_TXERROR_0                                           BLUE_STATUSREG_TXERROR_0_Msk
#define BLUE_STATUSREG_TXERROR_1_Pos                                       (9UL)   /*!< BLUE STATUSREG: TXERROR_1 (Bit 9) */
#define BLUE_STATUSREG_TXERROR_1_Msk                                       (0x00000200UL)  /*!< BLUE STATUSREG: TXERROR_1 (Bitfield-Mask: 0x1) */
#define BLUE_STATUSREG_TXERROR_1                                           BLUE_STATUSREG_TXERROR_1_Msk
#define BLUE_STATUSREG_TXERROR_2_Pos                                       (10UL)   /*!< BLUE STATUSREG: TXERROR_2 (Bit 10) */
#define BLUE_STATUSREG_TXERROR_2_Msk                                       (0x00000400UL)  /*!< BLUE STATUSREG: TXERROR_2 (Bitfield-Mask: 0x1) */
#define BLUE_STATUSREG_TXERROR_2                                           BLUE_STATUSREG_TXERROR_2_Msk
#define BLUE_STATUSREG_TXERROR_3_Pos                                       (11UL)   /*!< BLUE STATUSREG: TXERROR_3 (Bit 11) */
#define BLUE_STATUSREG_TXERROR_3_Msk                                       (0x00000800UL)  /*!< BLUE STATUSREG: TXERROR_3 (Bitfield-Mask: 0x1) */
#define BLUE_STATUSREG_TXERROR_3                                           BLUE_STATUSREG_TXERROR_3_Msk
#define BLUE_STATUSREG_TXERROR_4_Pos                                       (12UL)   /*!< BLUE STATUSREG: TXERROR_4 (Bit 12) */
#define BLUE_STATUSREG_TXERROR_4_Msk                                       (0x00001000UL)  /*!< BLUE STATUSREG: TXERROR_4 (Bitfield-Mask: 0x1) */
#define BLUE_STATUSREG_TXERROR_4                                           BLUE_STATUSREG_TXERROR_4_Msk
#define BLUE_STATUSREG_ENCERROR_Pos                                        (13UL)   /*!< BLUE STATUSREG: ENCERROR (Bit 13) */
#define BLUE_STATUSREG_ENCERROR_Msk                                        (0x00002000UL)  /*!< BLUE STATUSREG: ENCERROR (Bitfield-Mask: 0x1) */
#define BLUE_STATUSREG_ENCERROR                                            BLUE_STATUSREG_ENCERROR_Msk
#define BLUE_STATUSREG_ALLTABLEREADYERROR_Pos                              (14UL)   /*!< BLUE STATUSREG: ALLTABLEREADYERROR (Bit 14) */
#define BLUE_STATUSREG_ALLTABLEREADYERROR_Msk                              (0x00004000UL)  /*!< BLUE STATUSREG: ALLTABLEREADYERROR (Bitfield-Mask: 0x1) */
#define BLUE_STATUSREG_ALLTABLEREADYERROR                                  BLUE_STATUSREG_ALLTABLEREADYERROR_Msk
#define BLUE_STATUSREG_TXDATAREADYERROR_Pos                                (15UL)   /*!< BLUE STATUSREG: TXDATAREADYERROR (Bit 15) */
#define BLUE_STATUSREG_TXDATAREADYERROR_Msk                                (0x00008000UL)  /*!< BLUE STATUSREG: TXDATAREADYERROR (Bitfield-Mask: 0x1) */
#define BLUE_STATUSREG_TXDATAREADYERROR                                    BLUE_STATUSREG_TXDATAREADYERROR_Msk
#define BLUE_STATUSREG_NOACTIVELERROR_Pos                                  (16UL)   /*!< BLUE STATUSREG: NOACTIVELERROR (Bit 16) */
#define BLUE_STATUSREG_NOACTIVELERROR_Msk                                  (0x00010000UL)  /*!< BLUE STATUSREG: NOACTIVELERROR (Bitfield-Mask: 0x1) */
#define BLUE_STATUSREG_NOACTIVELERROR                                      BLUE_STATUSREG_NOACTIVELERROR_Msk
#define BLUE_STATUSREG_INITDELAYERROR_Pos                                  (17UL)   /*!< BLUE STATUSREG: INITDELAYERROR (Bit 17) */
#define BLUE_STATUSREG_INITDELAYERROR_Msk                                  (0x00020000UL)  /*!< BLUE STATUSREG: INITDELAYERROR (Bitfield-Mask: 0x1) */
#define BLUE_STATUSREG_INITDELAYERROR                                      BLUE_STATUSREG_INITDELAYERROR_Msk
#define BLUE_STATUSREG_RCVLENGTHERROR_Pos                                  (18UL)   /*!< BLUE STATUSREG: RCVLENGTHERROR (Bit 18) */
#define BLUE_STATUSREG_RCVLENGTHERROR_Msk                                  (0x00040000UL)  /*!< BLUE STATUSREG: RCVLENGTHERROR (Bitfield-Mask: 0x1) */
#define BLUE_STATUSREG_RCVLENGTHERROR                                      BLUE_STATUSREG_RCVLENGTHERROR_Msk
#define BLUE_STATUSREG_SEMATIMEOUTERROR_Pos                                (19UL)   /*!< BLUE STATUSREG: SEMATIMEOUTERROR (Bit 19) */
#define BLUE_STATUSREG_SEMATIMEOUTERROR_Msk                                (0x00080000UL)  /*!< BLUE STATUSREG: SEMATIMEOUTERROR (Bitfield-Mask: 0x1) */
#define BLUE_STATUSREG_SEMATIMEOUTERROR                                    BLUE_STATUSREG_SEMATIMEOUTERROR_Msk
#define BLUE_STATUSREG_SEMAWASPREEMPT_Pos                                  (20UL)   /*!< BLUE STATUSREG: SEMAWASPREEMPT (Bit 20) */
#define BLUE_STATUSREG_SEMAWASPREEMPT_Msk                                  (0x00100000UL)  /*!< BLUE STATUSREG: SEMAWASPREEMPT (Bitfield-Mask: 0x1) */
#define BLUE_STATUSREG_SEMAWASPREEMPT                                      BLUE_STATUSREG_SEMAWASPREEMPT_Msk
#define BLUE_STATUSREG_TXRXSKIP_Pos                                        (21UL)   /*!< BLUE STATUSREG: TXRXSKIP (Bit 21) */
#define BLUE_STATUSREG_TXRXSKIP_Msk                                        (0x00200000UL)  /*!< BLUE STATUSREG: TXRXSKIP (Bitfield-Mask: 0x1) */
#define BLUE_STATUSREG_TXRXSKIP                                            BLUE_STATUSREG_TXRXSKIP_Msk
#define BLUE_STATUSREG_ACTIVE2ERROR_Pos                                    (22UL)   /*!< BLUE STATUSREG: ACTIVE2ERROR (Bit 22) */
#define BLUE_STATUSREG_ACTIVE2ERROR_Msk                                    (0x00400000UL)  /*!< BLUE STATUSREG: ACTIVE2ERROR (Bitfield-Mask: 0x1) */
#define BLUE_STATUSREG_ACTIVE2ERROR                                        BLUE_STATUSREG_ACTIVE2ERROR_Msk
#define BLUE_STATUSREG_CONFIGERROR_Pos                                     (23UL)   /*!< BLUE STATUSREG: CONFIGERROR (Bit 23) */
#define BLUE_STATUSREG_CONFIGERROR_Msk                                     (0x00800000UL)  /*!< BLUE STATUSREG: CONFIGERROR (Bitfield-Mask: 0x1) */
#define BLUE_STATUSREG_CONFIGERROR                                         BLUE_STATUSREG_CONFIGERROR_Msk
#define BLUE_STATUSREG_TXOK_Pos                                            (24UL)   /*!< BLUE STATUSREG: TXOK (Bit 24) */
#define BLUE_STATUSREG_TXOK_Msk                                            (0x01000000UL)  /*!< BLUE STATUSREG: TXOK (Bitfield-Mask: 0x1) */
#define BLUE_STATUSREG_TXOK                                                BLUE_STATUSREG_TXOK_Msk
#define BLUE_STATUSREG_DONE_Pos                                            (25UL)   /*!< BLUE STATUSREG: DONE (Bit 25) */
#define BLUE_STATUSREG_DONE_Msk                                            (0x02000000UL)  /*!< BLUE STATUSREG: DONE (Bitfield-Mask: 0x1) */
#define BLUE_STATUSREG_DONE                                                BLUE_STATUSREG_DONE_Msk
#define BLUE_STATUSREG_RCVTIMEOUT_Pos                                      (26UL)   /*!< BLUE STATUSREG: RCVTIMEOUT (Bit 26) */
#define BLUE_STATUSREG_RCVTIMEOUT_Msk                                      (0x04000000UL)  /*!< BLUE STATUSREG: RCVTIMEOUT (Bitfield-Mask: 0x1) */
#define BLUE_STATUSREG_RCVTIMEOUT                                          BLUE_STATUSREG_RCVTIMEOUT_Msk
#define BLUE_STATUSREG_RCVNOMD_Pos                                         (27UL)   /*!< BLUE STATUSREG: RCVNOMD (Bit 27) */
#define BLUE_STATUSREG_RCVNOMD_Msk                                         (0x08000000UL)  /*!< BLUE STATUSREG: RCVNOMD (Bitfield-Mask: 0x1) */
#define BLUE_STATUSREG_RCVNOMD                                             BLUE_STATUSREG_RCVNOMD_Msk
#define BLUE_STATUSREG_RCVCMD_Pos                                          (28UL)   /*!< BLUE STATUSREG: RCVCMD (Bit 28) */
#define BLUE_STATUSREG_RCVCMD_Msk                                          (0x10000000UL)  /*!< BLUE STATUSREG: RCVCMD (Bitfield-Mask: 0x1) */
#define BLUE_STATUSREG_RCVCMD                                              BLUE_STATUSREG_RCVCMD_Msk
#define BLUE_STATUSREG_TIMECAPTURETRIG_Pos                                 (29UL)   /*!< BLUE STATUSREG: TIMECAPTURETRIG (Bit 29) */
#define BLUE_STATUSREG_TIMECAPTURETRIG_Msk                                 (0x20000000UL)  /*!< BLUE STATUSREG: TIMECAPTURETRIG (Bitfield-Mask: 0x1) */
#define BLUE_STATUSREG_TIMECAPTURETRIG                                     BLUE_STATUSREG_TIMECAPTURETRIG_Msk
#define BLUE_STATUSREG_RCVCRCERR_Pos                                       (30UL)   /*!< BLUE STATUSREG: RCVCRCERR (Bit 30) */
#define BLUE_STATUSREG_RCVCRCERR_Msk                                       (0x40000000UL)  /*!< BLUE STATUSREG: RCVCRCERR (Bitfield-Mask: 0x1) */
#define BLUE_STATUSREG_RCVCRCERR                                           BLUE_STATUSREG_RCVCRCERR_Msk
#define BLUE_STATUSREG_RCVOK_Pos                                           (31UL)   /*!< BLUE STATUSREG: RCVOK (Bit 31) */
#define BLUE_STATUSREG_RCVOK_Msk                                           (0x80000000UL)  /*!< BLUE STATUSREG: RCVOK (Bitfield-Mask: 0x1) */
#define BLUE_STATUSREG_RCVOK                                               BLUE_STATUSREG_RCVOK_Msk

/* ===============================================   INTERRUPT1ENABLEREG   =============================================== */
#define BLUE_INTERRUPT1ENABLEREG_ADDPOINTERROR_Pos                         (4UL)   /*!< BLUE INTERRUPT1ENABLEREG: ADDPOINTERROR (Bit 4) */
#define BLUE_INTERRUPT1ENABLEREG_ADDPOINTERROR_Msk                         (0x00000010UL)  /*!< BLUE INTERRUPT1ENABLEREG: ADDPOINTERROR (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1ENABLEREG_ADDPOINTERROR                             BLUE_INTERRUPT1ENABLEREG_ADDPOINTERROR_Msk
#define BLUE_INTERRUPT1ENABLEREG_RXOVERFLOWERROR_Pos                       (5UL)   /*!< BLUE INTERRUPT1ENABLEREG: RXOVERFLOWERROR (Bit 5) */
#define BLUE_INTERRUPT1ENABLEREG_RXOVERFLOWERROR_Msk                       (0x00000020UL)  /*!< BLUE INTERRUPT1ENABLEREG: RXOVERFLOWERROR (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1ENABLEREG_RXOVERFLOWERROR                           BLUE_INTERRUPT1ENABLEREG_RXOVERFLOWERROR_Msk
#define BLUE_INTERRUPT1ENABLEREG_SEQDONE_Pos                               (7UL)   /*!< BLUE INTERRUPT1ENABLEREG: SEQDONE (Bit 7) */
#define BLUE_INTERRUPT1ENABLEREG_SEQDONE_Msk                               (0x00000080UL)  /*!< BLUE INTERRUPT1ENABLEREG: SEQDONE (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1ENABLEREG_SEQDONE                                   BLUE_INTERRUPT1ENABLEREG_SEQDONE_Msk
#define BLUE_INTERRUPT1ENABLEREG_TXERROR_0_Pos                             (8UL)   /*!< BLUE INTERRUPT1ENABLEREG: TXERROR_0 (Bit 8) */
#define BLUE_INTERRUPT1ENABLEREG_TXERROR_0_Msk                             (0x00000100UL)  /*!< BLUE INTERRUPT1ENABLEREG: TXERROR_0 (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1ENABLEREG_TXERROR_0                                 BLUE_INTERRUPT1ENABLEREG_TXERROR_0_Msk
#define BLUE_INTERRUPT1ENABLEREG_TXERROR_1_Pos                             (9UL)   /*!< BLUE INTERRUPT1ENABLEREG: TXERROR_1 (Bit 9) */
#define BLUE_INTERRUPT1ENABLEREG_TXERROR_1_Msk                             (0x00000200UL)  /*!< BLUE INTERRUPT1ENABLEREG: TXERROR_1 (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1ENABLEREG_TXERROR_1                                 BLUE_INTERRUPT1ENABLEREG_TXERROR_1_Msk
#define BLUE_INTERRUPT1ENABLEREG_TXERROR_2_Pos                             (10UL)   /*!< BLUE INTERRUPT1ENABLEREG: TXERROR_2 (Bit 10) */
#define BLUE_INTERRUPT1ENABLEREG_TXERROR_2_Msk                             (0x00000400UL)  /*!< BLUE INTERRUPT1ENABLEREG: TXERROR_2 (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1ENABLEREG_TXERROR_2                                 BLUE_INTERRUPT1ENABLEREG_TXERROR_2_Msk
#define BLUE_INTERRUPT1ENABLEREG_TXERROR_3_Pos                             (11UL)   /*!< BLUE INTERRUPT1ENABLEREG: TXERROR_3 (Bit 11) */
#define BLUE_INTERRUPT1ENABLEREG_TXERROR_3_Msk                             (0x00000800UL)  /*!< BLUE INTERRUPT1ENABLEREG: TXERROR_3 (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1ENABLEREG_TXERROR_3                                 BLUE_INTERRUPT1ENABLEREG_TXERROR_3_Msk
#define BLUE_INTERRUPT1ENABLEREG_TXERROR_4_Pos                             (12UL)   /*!< BLUE INTERRUPT1ENABLEREG: TXERROR_4 (Bit 12) */
#define BLUE_INTERRUPT1ENABLEREG_TXERROR_4_Msk                             (0x00001000UL)  /*!< BLUE INTERRUPT1ENABLEREG: TXERROR_4 (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1ENABLEREG_TXERROR_4                                 BLUE_INTERRUPT1ENABLEREG_TXERROR_4_Msk
#define BLUE_INTERRUPT1ENABLEREG_ENCERROR_Pos                              (13UL)   /*!< BLUE INTERRUPT1ENABLEREG: ENCERROR (Bit 13) */
#define BLUE_INTERRUPT1ENABLEREG_ENCERROR_Msk                              (0x00002000UL)  /*!< BLUE INTERRUPT1ENABLEREG: ENCERROR (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1ENABLEREG_ENCERROR                                  BLUE_INTERRUPT1ENABLEREG_ENCERROR_Msk
#define BLUE_INTERRUPT1ENABLEREG_ALLTABLEREADYERROR_Pos                    (14UL)   /*!< BLUE INTERRUPT1ENABLEREG: ALLTABLEREADYERROR (Bit 14) */
#define BLUE_INTERRUPT1ENABLEREG_ALLTABLEREADYERROR_Msk                    (0x00004000UL)  /*!< BLUE INTERRUPT1ENABLEREG: ALLTABLEREADYERROR (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1ENABLEREG_ALLTABLEREADYERROR                        BLUE_INTERRUPT1ENABLEREG_ALLTABLEREADYERROR_Msk
#define BLUE_INTERRUPT1ENABLEREG_TXDATAREADYERROR_Pos                      (15UL)   /*!< BLUE INTERRUPT1ENABLEREG: TXDATAREADYERROR (Bit 15) */
#define BLUE_INTERRUPT1ENABLEREG_TXDATAREADYERROR_Msk                      (0x00008000UL)  /*!< BLUE INTERRUPT1ENABLEREG: TXDATAREADYERROR (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1ENABLEREG_TXDATAREADYERROR                          BLUE_INTERRUPT1ENABLEREG_TXDATAREADYERROR_Msk
#define BLUE_INTERRUPT1ENABLEREG_NOACTIVELERROR_Pos                        (16UL)   /*!< BLUE INTERRUPT1ENABLEREG: NOACTIVELERROR (Bit 16) */
#define BLUE_INTERRUPT1ENABLEREG_NOACTIVELERROR_Msk                        (0x00010000UL)  /*!< BLUE INTERRUPT1ENABLEREG: NOACTIVELERROR (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1ENABLEREG_NOACTIVELERROR                            BLUE_INTERRUPT1ENABLEREG_NOACTIVELERROR_Msk
#define BLUE_INTERRUPT1ENABLEREG_INITDELAYERROR_Pos                        (17UL)   /*!< BLUE INTERRUPT1ENABLEREG: INITDELAYERROR (Bit 17) */
#define BLUE_INTERRUPT1ENABLEREG_INITDELAYERROR_Msk                        (0x00020000UL)  /*!< BLUE INTERRUPT1ENABLEREG: INITDELAYERROR (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1ENABLEREG_INITDELAYERROR                            BLUE_INTERRUPT1ENABLEREG_INITDELAYERROR_Msk
#define BLUE_INTERRUPT1ENABLEREG_RCVLENGTHERROR_Pos                        (18UL)   /*!< BLUE INTERRUPT1ENABLEREG: RCVLENGTHERROR (Bit 18) */
#define BLUE_INTERRUPT1ENABLEREG_RCVLENGTHERROR_Msk                        (0x00040000UL)  /*!< BLUE INTERRUPT1ENABLEREG: RCVLENGTHERROR (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1ENABLEREG_RCVLENGTHERROR                            BLUE_INTERRUPT1ENABLEREG_RCVLENGTHERROR_Msk
#define BLUE_INTERRUPT1ENABLEREG_SEMATIMEOUTERROR_Pos                      (19UL)   /*!< BLUE INTERRUPT1ENABLEREG: SEMATIMEOUTERROR (Bit 19) */
#define BLUE_INTERRUPT1ENABLEREG_SEMATIMEOUTERROR_Msk                      (0x00080000UL)  /*!< BLUE INTERRUPT1ENABLEREG: SEMATIMEOUTERROR (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1ENABLEREG_SEMATIMEOUTERROR                          BLUE_INTERRUPT1ENABLEREG_SEMATIMEOUTERROR_Msk
#define BLUE_INTERRUPT1ENABLEREG_SEMAWASPREEMPT_Pos                        (20UL)   /*!< BLUE INTERRUPT1ENABLEREG: SEMAWASPREEMPT (Bit 20) */
#define BLUE_INTERRUPT1ENABLEREG_SEMAWASPREEMPT_Msk                        (0x00100000UL)  /*!< BLUE INTERRUPT1ENABLEREG: SEMAWASPREEMPT (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1ENABLEREG_SEMAWASPREEMPT                            BLUE_INTERRUPT1ENABLEREG_SEMAWASPREEMPT_Msk
#define BLUE_INTERRUPT1ENABLEREG_TXRXSKIP_Pos                              (21UL)   /*!< BLUE INTERRUPT1ENABLEREG: TXRXSKIP (Bit 21) */
#define BLUE_INTERRUPT1ENABLEREG_TXRXSKIP_Msk                              (0x00200000UL)  /*!< BLUE INTERRUPT1ENABLEREG: TXRXSKIP (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1ENABLEREG_TXRXSKIP                                  BLUE_INTERRUPT1ENABLEREG_TXRXSKIP_Msk
#define BLUE_INTERRUPT1ENABLEREG_ACTIVE2ERROR_Pos                          (22UL)   /*!< BLUE INTERRUPT1ENABLEREG: ACTIVE2ERROR (Bit 22) */
#define BLUE_INTERRUPT1ENABLEREG_ACTIVE2ERROR_Msk                          (0x00400000UL)  /*!< BLUE INTERRUPT1ENABLEREG: ACTIVE2ERROR (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1ENABLEREG_ACTIVE2ERROR                              BLUE_INTERRUPT1ENABLEREG_ACTIVE2ERROR_Msk
#define BLUE_INTERRUPT1ENABLEREG_CONFIGERROR_Pos                           (23UL)   /*!< BLUE INTERRUPT1ENABLEREG: CONFIGERROR (Bit 23) */
#define BLUE_INTERRUPT1ENABLEREG_CONFIGERROR_Msk                           (0x00800000UL)  /*!< BLUE INTERRUPT1ENABLEREG: CONFIGERROR (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1ENABLEREG_CONFIGERROR                               BLUE_INTERRUPT1ENABLEREG_CONFIGERROR_Msk
#define BLUE_INTERRUPT1ENABLEREG_TXOK_Pos                                  (24UL)   /*!< BLUE INTERRUPT1ENABLEREG: TXOK (Bit 24) */
#define BLUE_INTERRUPT1ENABLEREG_TXOK_Msk                                  (0x01000000UL)  /*!< BLUE INTERRUPT1ENABLEREG: TXOK (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1ENABLEREG_TXOK                                      BLUE_INTERRUPT1ENABLEREG_TXOK_Msk
#define BLUE_INTERRUPT1ENABLEREG_DONE_Pos                                  (25UL)   /*!< BLUE INTERRUPT1ENABLEREG: DONE (Bit 25) */
#define BLUE_INTERRUPT1ENABLEREG_DONE_Msk                                  (0x02000000UL)  /*!< BLUE INTERRUPT1ENABLEREG: DONE (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1ENABLEREG_DONE                                      BLUE_INTERRUPT1ENABLEREG_DONE_Msk
#define BLUE_INTERRUPT1ENABLEREG_RCVTIMEOUT_Pos                            (26UL)   /*!< BLUE INTERRUPT1ENABLEREG: RCVTIMEOUT (Bit 26) */
#define BLUE_INTERRUPT1ENABLEREG_RCVTIMEOUT_Msk                            (0x04000000UL)  /*!< BLUE INTERRUPT1ENABLEREG: RCVTIMEOUT (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1ENABLEREG_RCVTIMEOUT                                BLUE_INTERRUPT1ENABLEREG_RCVTIMEOUT_Msk
#define BLUE_INTERRUPT1ENABLEREG_RCVNOMD_Pos                               (27UL)   /*!< BLUE INTERRUPT1ENABLEREG: RCVNOMD (Bit 27) */
#define BLUE_INTERRUPT1ENABLEREG_RCVNOMD_Msk                               (0x08000000UL)  /*!< BLUE INTERRUPT1ENABLEREG: RCVNOMD (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1ENABLEREG_RCVNOMD                                   BLUE_INTERRUPT1ENABLEREG_RCVNOMD_Msk
#define BLUE_INTERRUPT1ENABLEREG_RCVCMD_Pos                                (28UL)   /*!< BLUE INTERRUPT1ENABLEREG: RCVCMD (Bit 28) */
#define BLUE_INTERRUPT1ENABLEREG_RCVCMD_Msk                                (0x10000000UL)  /*!< BLUE INTERRUPT1ENABLEREG: RCVCMD (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1ENABLEREG_RCVCMD                                    BLUE_INTERRUPT1ENABLEREG_RCVCMD_Msk
#define BLUE_INTERRUPT1ENABLEREG_TIMECAPTURETRIG_Pos                       (29UL)   /*!< BLUE INTERRUPT1ENABLEREG: TIMECAPTURETRIG (Bit 29) */
#define BLUE_INTERRUPT1ENABLEREG_TIMECAPTURETRIG_Msk                       (0x20000000UL)  /*!< BLUE INTERRUPT1ENABLEREG: TIMECAPTURETRIG (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1ENABLEREG_TIMECAPTURETRIG                           BLUE_INTERRUPT1ENABLEREG_TIMECAPTURETRIG_Msk
#define BLUE_INTERRUPT1ENABLEREG_RCVCRCERR_Pos                             (30UL)   /*!< BLUE INTERRUPT1ENABLEREG: RCVCRCERR (Bit 30) */
#define BLUE_INTERRUPT1ENABLEREG_RCVCRCERR_Msk                             (0x40000000UL)  /*!< BLUE INTERRUPT1ENABLEREG: RCVCRCERR (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1ENABLEREG_RCVCRCERR                                 BLUE_INTERRUPT1ENABLEREG_RCVCRCERR_Msk
#define BLUE_INTERRUPT1ENABLEREG_RCVOK_Pos                                 (31UL)   /*!< BLUE INTERRUPT1ENABLEREG: RCVOK (Bit 31) */
#define BLUE_INTERRUPT1ENABLEREG_RCVOK_Msk                                 (0x80000000UL)  /*!< BLUE INTERRUPT1ENABLEREG: RCVOK (Bitfield-Mask: 0x1) */
#define BLUE_INTERRUPT1ENABLEREG_RCVOK                                     BLUE_INTERRUPT1ENABLEREG_RCVOK_Msk

/* ===============================================   INTERRUPT1LATENCYREG   =============================================== */
#define BLUE_INTERRUPT1LATENCYREG_INTERRUPT1LATENCY_Pos                    (0UL)   /*!< BLUE INTERRUPT1LATENCYREG: INTERRUPT1LATENCY (Bit 0) */
#define BLUE_INTERRUPT1LATENCYREG_INTERRUPT1LATENCY_Msk                    (0x000000ffUL)  /*!< BLUE INTERRUPT1LATENCYREG: INTERRUPT1LATENCY (Bitfield-Mask: 0xff) */
#define BLUE_INTERRUPT1LATENCYREG_INTERRUPT1LATENCY                        BLUE_INTERRUPT1LATENCYREG_INTERRUPT1LATENCY_Msk
#define BLUE_INTERRUPT1LATENCYREG_INTERRUPT1LATENCY_0                      (0x01 << BLUE_INTERRUPT1LATENCYREG_INTERRUPT1LATENCY_Pos)   /*!<0x00000001 */
#define BLUE_INTERRUPT1LATENCYREG_INTERRUPT1LATENCY_1                      (0x02 << BLUE_INTERRUPT1LATENCYREG_INTERRUPT1LATENCY_Pos)   /*!<0x00000002 */
#define BLUE_INTERRUPT1LATENCYREG_INTERRUPT1LATENCY_2                      (0x04 << BLUE_INTERRUPT1LATENCYREG_INTERRUPT1LATENCY_Pos)   /*!<0x00000004 */
#define BLUE_INTERRUPT1LATENCYREG_INTERRUPT1LATENCY_3                      (0x08 << BLUE_INTERRUPT1LATENCYREG_INTERRUPT1LATENCY_Pos)   /*!<0x00000008 */
#define BLUE_INTERRUPT1LATENCYREG_INTERRUPT1LATENCY_4                      (0x10 << BLUE_INTERRUPT1LATENCYREG_INTERRUPT1LATENCY_Pos)   /*!<0x00000010 */
#define BLUE_INTERRUPT1LATENCYREG_INTERRUPT1LATENCY_5                      (0x20 << BLUE_INTERRUPT1LATENCYREG_INTERRUPT1LATENCY_Pos)   /*!<0x00000020 */
#define BLUE_INTERRUPT1LATENCYREG_INTERRUPT1LATENCY_6                      (0x40 << BLUE_INTERRUPT1LATENCYREG_INTERRUPT1LATENCY_Pos)   /*!<0x00000040 */
#define BLUE_INTERRUPT1LATENCYREG_INTERRUPT1LATENCY_7                      (0x80 << BLUE_INTERRUPT1LATENCYREG_INTERRUPT1LATENCY_Pos)   /*!<0x00000080 */

/* ===============================================   MANAESKEY0REG   =============================================== */
#define BLUE_MANAESKEY0REG_MANAESKEY_31_0_Pos                              (0UL)   /*!< BLUE MANAESKEY0REG: MANAESKEY_31_0 (Bit 0) */
#define BLUE_MANAESKEY0REG_MANAESKEY_31_0_Msk                              (0xffffffffUL)  /*!< BLUE MANAESKEY0REG: MANAESKEY_31_0 (Bitfield-Mask: 0xffffffffL) */
#define BLUE_MANAESKEY0REG_MANAESKEY_31_0                                  BLUE_MANAESKEY0REG_MANAESKEY_31_0_Msk
#define BLUE_MANAESKEY0REG_MANAESKEY_31_0_0                                (0x00000001 << BLUE_MANAESKEY0REG_MANAESKEY_31_0_Pos)   /*!<0x00000001 */
#define BLUE_MANAESKEY0REG_MANAESKEY_31_0_1                                (0x00000002 << BLUE_MANAESKEY0REG_MANAESKEY_31_0_Pos)   /*!<0x00000002 */
#define BLUE_MANAESKEY0REG_MANAESKEY_31_0_2                                (0x00000004 << BLUE_MANAESKEY0REG_MANAESKEY_31_0_Pos)   /*!<0x00000004 */
#define BLUE_MANAESKEY0REG_MANAESKEY_31_0_3                                (0x00000008 << BLUE_MANAESKEY0REG_MANAESKEY_31_0_Pos)   /*!<0x00000008 */
#define BLUE_MANAESKEY0REG_MANAESKEY_31_0_4                                (0x00000010 << BLUE_MANAESKEY0REG_MANAESKEY_31_0_Pos)   /*!<0x00000010 */
#define BLUE_MANAESKEY0REG_MANAESKEY_31_0_5                                (0x00000020 << BLUE_MANAESKEY0REG_MANAESKEY_31_0_Pos)   /*!<0x00000020 */
#define BLUE_MANAESKEY0REG_MANAESKEY_31_0_6                                (0x00000040 << BLUE_MANAESKEY0REG_MANAESKEY_31_0_Pos)   /*!<0x00000040 */
#define BLUE_MANAESKEY0REG_MANAESKEY_31_0_7                                (0x00000080 << BLUE_MANAESKEY0REG_MANAESKEY_31_0_Pos)   /*!<0x00000080 */
#define BLUE_MANAESKEY0REG_MANAESKEY_31_0_8                                (0x00000100 << BLUE_MANAESKEY0REG_MANAESKEY_31_0_Pos)   /*!<0x00000100 */
#define BLUE_MANAESKEY0REG_MANAESKEY_31_0_9                                (0x00000200 << BLUE_MANAESKEY0REG_MANAESKEY_31_0_Pos)   /*!<0x00000200 */
#define BLUE_MANAESKEY0REG_MANAESKEY_31_0_10                               (0x00000400 << BLUE_MANAESKEY0REG_MANAESKEY_31_0_Pos)   /*!<0x00000400 */
#define BLUE_MANAESKEY0REG_MANAESKEY_31_0_11                               (0x00000800 << BLUE_MANAESKEY0REG_MANAESKEY_31_0_Pos)   /*!<0x00000800 */
#define BLUE_MANAESKEY0REG_MANAESKEY_31_0_12                               (0x00001000 << BLUE_MANAESKEY0REG_MANAESKEY_31_0_Pos)   /*!<0x00001000 */
#define BLUE_MANAESKEY0REG_MANAESKEY_31_0_13                               (0x00002000 << BLUE_MANAESKEY0REG_MANAESKEY_31_0_Pos)   /*!<0x00002000 */
#define BLUE_MANAESKEY0REG_MANAESKEY_31_0_14                               (0x00004000 << BLUE_MANAESKEY0REG_MANAESKEY_31_0_Pos)   /*!<0x00004000 */
#define BLUE_MANAESKEY0REG_MANAESKEY_31_0_15                               (0x00008000 << BLUE_MANAESKEY0REG_MANAESKEY_31_0_Pos)   /*!<0x00008000 */
#define BLUE_MANAESKEY0REG_MANAESKEY_31_0_16                               (0x00010000 << BLUE_MANAESKEY0REG_MANAESKEY_31_0_Pos)   /*!<0x00010000 */
#define BLUE_MANAESKEY0REG_MANAESKEY_31_0_17                               (0x00020000 << BLUE_MANAESKEY0REG_MANAESKEY_31_0_Pos)   /*!<0x00020000 */
#define BLUE_MANAESKEY0REG_MANAESKEY_31_0_18                               (0x00040000 << BLUE_MANAESKEY0REG_MANAESKEY_31_0_Pos)   /*!<0x00040000 */
#define BLUE_MANAESKEY0REG_MANAESKEY_31_0_19                               (0x00080000 << BLUE_MANAESKEY0REG_MANAESKEY_31_0_Pos)   /*!<0x00080000 */
#define BLUE_MANAESKEY0REG_MANAESKEY_31_0_20                               (0x00100000 << BLUE_MANAESKEY0REG_MANAESKEY_31_0_Pos)   /*!<0x00100000 */
#define BLUE_MANAESKEY0REG_MANAESKEY_31_0_21                               (0x00200000 << BLUE_MANAESKEY0REG_MANAESKEY_31_0_Pos)   /*!<0x00200000 */
#define BLUE_MANAESKEY0REG_MANAESKEY_31_0_22                               (0x00400000 << BLUE_MANAESKEY0REG_MANAESKEY_31_0_Pos)   /*!<0x00400000 */
#define BLUE_MANAESKEY0REG_MANAESKEY_31_0_23                               (0x00800000 << BLUE_MANAESKEY0REG_MANAESKEY_31_0_Pos)   /*!<0x00800000 */
#define BLUE_MANAESKEY0REG_MANAESKEY_31_0_24                               (0x01000000 << BLUE_MANAESKEY0REG_MANAESKEY_31_0_Pos)   /*!<0x01000000 */
#define BLUE_MANAESKEY0REG_MANAESKEY_31_0_25                               (0x02000000 << BLUE_MANAESKEY0REG_MANAESKEY_31_0_Pos)   /*!<0x02000000 */
#define BLUE_MANAESKEY0REG_MANAESKEY_31_0_26                               (0x04000000 << BLUE_MANAESKEY0REG_MANAESKEY_31_0_Pos)   /*!<0x04000000 */
#define BLUE_MANAESKEY0REG_MANAESKEY_31_0_27                               (0x08000000 << BLUE_MANAESKEY0REG_MANAESKEY_31_0_Pos)   /*!<0x08000000 */
#define BLUE_MANAESKEY0REG_MANAESKEY_31_0_28                               (0x10000000 << BLUE_MANAESKEY0REG_MANAESKEY_31_0_Pos)   /*!<0x10000000 */
#define BLUE_MANAESKEY0REG_MANAESKEY_31_0_29                               (0x20000000 << BLUE_MANAESKEY0REG_MANAESKEY_31_0_Pos)   /*!<0x20000000 */
#define BLUE_MANAESKEY0REG_MANAESKEY_31_0_30                               (0x40000000 << BLUE_MANAESKEY0REG_MANAESKEY_31_0_Pos)   /*!<0x40000000 */
#define BLUE_MANAESKEY0REG_MANAESKEY_31_0_31                               (0x80000000 << BLUE_MANAESKEY0REG_MANAESKEY_31_0_Pos)   /*!<0x80000000 */

/* ===============================================   MANAESKEY1REG   =============================================== */
#define BLUE_MANAESKEY1REG_MANAESKEY_63_32_Pos                             (0UL)   /*!< BLUE MANAESKEY1REG: MANAESKEY_63_32 (Bit 0) */
#define BLUE_MANAESKEY1REG_MANAESKEY_63_32_Msk                             (0xffffffffUL)  /*!< BLUE MANAESKEY1REG: MANAESKEY_63_32 (Bitfield-Mask: 0xffffffffL) */
#define BLUE_MANAESKEY1REG_MANAESKEY_63_32                                 BLUE_MANAESKEY1REG_MANAESKEY_63_32_Msk
#define BLUE_MANAESKEY1REG_MANAESKEY_63_32_0                               (0x00000001 << BLUE_MANAESKEY1REG_MANAESKEY_63_32_Pos)   /*!<0x00000001 */
#define BLUE_MANAESKEY1REG_MANAESKEY_63_32_1                               (0x00000002 << BLUE_MANAESKEY1REG_MANAESKEY_63_32_Pos)   /*!<0x00000002 */
#define BLUE_MANAESKEY1REG_MANAESKEY_63_32_2                               (0x00000004 << BLUE_MANAESKEY1REG_MANAESKEY_63_32_Pos)   /*!<0x00000004 */
#define BLUE_MANAESKEY1REG_MANAESKEY_63_32_3                               (0x00000008 << BLUE_MANAESKEY1REG_MANAESKEY_63_32_Pos)   /*!<0x00000008 */
#define BLUE_MANAESKEY1REG_MANAESKEY_63_32_4                               (0x00000010 << BLUE_MANAESKEY1REG_MANAESKEY_63_32_Pos)   /*!<0x00000010 */
#define BLUE_MANAESKEY1REG_MANAESKEY_63_32_5                               (0x00000020 << BLUE_MANAESKEY1REG_MANAESKEY_63_32_Pos)   /*!<0x00000020 */
#define BLUE_MANAESKEY1REG_MANAESKEY_63_32_6                               (0x00000040 << BLUE_MANAESKEY1REG_MANAESKEY_63_32_Pos)   /*!<0x00000040 */
#define BLUE_MANAESKEY1REG_MANAESKEY_63_32_7                               (0x00000080 << BLUE_MANAESKEY1REG_MANAESKEY_63_32_Pos)   /*!<0x00000080 */
#define BLUE_MANAESKEY1REG_MANAESKEY_63_32_8                               (0x00000100 << BLUE_MANAESKEY1REG_MANAESKEY_63_32_Pos)   /*!<0x00000100 */
#define BLUE_MANAESKEY1REG_MANAESKEY_63_32_9                               (0x00000200 << BLUE_MANAESKEY1REG_MANAESKEY_63_32_Pos)   /*!<0x00000200 */
#define BLUE_MANAESKEY1REG_MANAESKEY_63_32_10                              (0x00000400 << BLUE_MANAESKEY1REG_MANAESKEY_63_32_Pos)   /*!<0x00000400 */
#define BLUE_MANAESKEY1REG_MANAESKEY_63_32_11                              (0x00000800 << BLUE_MANAESKEY1REG_MANAESKEY_63_32_Pos)   /*!<0x00000800 */
#define BLUE_MANAESKEY1REG_MANAESKEY_63_32_12                              (0x00001000 << BLUE_MANAESKEY1REG_MANAESKEY_63_32_Pos)   /*!<0x00001000 */
#define BLUE_MANAESKEY1REG_MANAESKEY_63_32_13                              (0x00002000 << BLUE_MANAESKEY1REG_MANAESKEY_63_32_Pos)   /*!<0x00002000 */
#define BLUE_MANAESKEY1REG_MANAESKEY_63_32_14                              (0x00004000 << BLUE_MANAESKEY1REG_MANAESKEY_63_32_Pos)   /*!<0x00004000 */
#define BLUE_MANAESKEY1REG_MANAESKEY_63_32_15                              (0x00008000 << BLUE_MANAESKEY1REG_MANAESKEY_63_32_Pos)   /*!<0x00008000 */
#define BLUE_MANAESKEY1REG_MANAESKEY_63_32_16                              (0x00010000 << BLUE_MANAESKEY1REG_MANAESKEY_63_32_Pos)   /*!<0x00010000 */
#define BLUE_MANAESKEY1REG_MANAESKEY_63_32_17                              (0x00020000 << BLUE_MANAESKEY1REG_MANAESKEY_63_32_Pos)   /*!<0x00020000 */
#define BLUE_MANAESKEY1REG_MANAESKEY_63_32_18                              (0x00040000 << BLUE_MANAESKEY1REG_MANAESKEY_63_32_Pos)   /*!<0x00040000 */
#define BLUE_MANAESKEY1REG_MANAESKEY_63_32_19                              (0x00080000 << BLUE_MANAESKEY1REG_MANAESKEY_63_32_Pos)   /*!<0x00080000 */
#define BLUE_MANAESKEY1REG_MANAESKEY_63_32_20                              (0x00100000 << BLUE_MANAESKEY1REG_MANAESKEY_63_32_Pos)   /*!<0x00100000 */
#define BLUE_MANAESKEY1REG_MANAESKEY_63_32_21                              (0x00200000 << BLUE_MANAESKEY1REG_MANAESKEY_63_32_Pos)   /*!<0x00200000 */
#define BLUE_MANAESKEY1REG_MANAESKEY_63_32_22                              (0x00400000 << BLUE_MANAESKEY1REG_MANAESKEY_63_32_Pos)   /*!<0x00400000 */
#define BLUE_MANAESKEY1REG_MANAESKEY_63_32_23                              (0x00800000 << BLUE_MANAESKEY1REG_MANAESKEY_63_32_Pos)   /*!<0x00800000 */
#define BLUE_MANAESKEY1REG_MANAESKEY_63_32_24                              (0x01000000 << BLUE_MANAESKEY1REG_MANAESKEY_63_32_Pos)   /*!<0x01000000 */
#define BLUE_MANAESKEY1REG_MANAESKEY_63_32_25                              (0x02000000 << BLUE_MANAESKEY1REG_MANAESKEY_63_32_Pos)   /*!<0x02000000 */
#define BLUE_MANAESKEY1REG_MANAESKEY_63_32_26                              (0x04000000 << BLUE_MANAESKEY1REG_MANAESKEY_63_32_Pos)   /*!<0x04000000 */
#define BLUE_MANAESKEY1REG_MANAESKEY_63_32_27                              (0x08000000 << BLUE_MANAESKEY1REG_MANAESKEY_63_32_Pos)   /*!<0x08000000 */
#define BLUE_MANAESKEY1REG_MANAESKEY_63_32_28                              (0x10000000 << BLUE_MANAESKEY1REG_MANAESKEY_63_32_Pos)   /*!<0x10000000 */
#define BLUE_MANAESKEY1REG_MANAESKEY_63_32_29                              (0x20000000 << BLUE_MANAESKEY1REG_MANAESKEY_63_32_Pos)   /*!<0x20000000 */
#define BLUE_MANAESKEY1REG_MANAESKEY_63_32_30                              (0x40000000 << BLUE_MANAESKEY1REG_MANAESKEY_63_32_Pos)   /*!<0x40000000 */
#define BLUE_MANAESKEY1REG_MANAESKEY_63_32_31                              (0x80000000 << BLUE_MANAESKEY1REG_MANAESKEY_63_32_Pos)   /*!<0x80000000 */

/* ===============================================   MANAESKEY2REG   =============================================== */
#define BLUE_MANAESKEY2REG_MANAESKEY_95_64_Pos                             (0UL)   /*!< BLUE MANAESKEY2REG: MANAESKEY_95_64 (Bit 0) */
#define BLUE_MANAESKEY2REG_MANAESKEY_95_64_Msk                             (0xffffffffUL)  /*!< BLUE MANAESKEY2REG: MANAESKEY_95_64 (Bitfield-Mask: 0xffffffffL) */
#define BLUE_MANAESKEY2REG_MANAESKEY_95_64                                 BLUE_MANAESKEY2REG_MANAESKEY_95_64_Msk
#define BLUE_MANAESKEY2REG_MANAESKEY_95_64_0                               (0x00000001 << BLUE_MANAESKEY2REG_MANAESKEY_95_64_Pos)   /*!<0x00000001 */
#define BLUE_MANAESKEY2REG_MANAESKEY_95_64_1                               (0x00000002 << BLUE_MANAESKEY2REG_MANAESKEY_95_64_Pos)   /*!<0x00000002 */
#define BLUE_MANAESKEY2REG_MANAESKEY_95_64_2                               (0x00000004 << BLUE_MANAESKEY2REG_MANAESKEY_95_64_Pos)   /*!<0x00000004 */
#define BLUE_MANAESKEY2REG_MANAESKEY_95_64_3                               (0x00000008 << BLUE_MANAESKEY2REG_MANAESKEY_95_64_Pos)   /*!<0x00000008 */
#define BLUE_MANAESKEY2REG_MANAESKEY_95_64_4                               (0x00000010 << BLUE_MANAESKEY2REG_MANAESKEY_95_64_Pos)   /*!<0x00000010 */
#define BLUE_MANAESKEY2REG_MANAESKEY_95_64_5                               (0x00000020 << BLUE_MANAESKEY2REG_MANAESKEY_95_64_Pos)   /*!<0x00000020 */
#define BLUE_MANAESKEY2REG_MANAESKEY_95_64_6                               (0x00000040 << BLUE_MANAESKEY2REG_MANAESKEY_95_64_Pos)   /*!<0x00000040 */
#define BLUE_MANAESKEY2REG_MANAESKEY_95_64_7                               (0x00000080 << BLUE_MANAESKEY2REG_MANAESKEY_95_64_Pos)   /*!<0x00000080 */
#define BLUE_MANAESKEY2REG_MANAESKEY_95_64_8                               (0x00000100 << BLUE_MANAESKEY2REG_MANAESKEY_95_64_Pos)   /*!<0x00000100 */
#define BLUE_MANAESKEY2REG_MANAESKEY_95_64_9                               (0x00000200 << BLUE_MANAESKEY2REG_MANAESKEY_95_64_Pos)   /*!<0x00000200 */
#define BLUE_MANAESKEY2REG_MANAESKEY_95_64_10                              (0x00000400 << BLUE_MANAESKEY2REG_MANAESKEY_95_64_Pos)   /*!<0x00000400 */
#define BLUE_MANAESKEY2REG_MANAESKEY_95_64_11                              (0x00000800 << BLUE_MANAESKEY2REG_MANAESKEY_95_64_Pos)   /*!<0x00000800 */
#define BLUE_MANAESKEY2REG_MANAESKEY_95_64_12                              (0x00001000 << BLUE_MANAESKEY2REG_MANAESKEY_95_64_Pos)   /*!<0x00001000 */
#define BLUE_MANAESKEY2REG_MANAESKEY_95_64_13                              (0x00002000 << BLUE_MANAESKEY2REG_MANAESKEY_95_64_Pos)   /*!<0x00002000 */
#define BLUE_MANAESKEY2REG_MANAESKEY_95_64_14                              (0x00004000 << BLUE_MANAESKEY2REG_MANAESKEY_95_64_Pos)   /*!<0x00004000 */
#define BLUE_MANAESKEY2REG_MANAESKEY_95_64_15                              (0x00008000 << BLUE_MANAESKEY2REG_MANAESKEY_95_64_Pos)   /*!<0x00008000 */
#define BLUE_MANAESKEY2REG_MANAESKEY_95_64_16                              (0x00010000 << BLUE_MANAESKEY2REG_MANAESKEY_95_64_Pos)   /*!<0x00010000 */
#define BLUE_MANAESKEY2REG_MANAESKEY_95_64_17                              (0x00020000 << BLUE_MANAESKEY2REG_MANAESKEY_95_64_Pos)   /*!<0x00020000 */
#define BLUE_MANAESKEY2REG_MANAESKEY_95_64_18                              (0x00040000 << BLUE_MANAESKEY2REG_MANAESKEY_95_64_Pos)   /*!<0x00040000 */
#define BLUE_MANAESKEY2REG_MANAESKEY_95_64_19                              (0x00080000 << BLUE_MANAESKEY2REG_MANAESKEY_95_64_Pos)   /*!<0x00080000 */
#define BLUE_MANAESKEY2REG_MANAESKEY_95_64_20                              (0x00100000 << BLUE_MANAESKEY2REG_MANAESKEY_95_64_Pos)   /*!<0x00100000 */
#define BLUE_MANAESKEY2REG_MANAESKEY_95_64_21                              (0x00200000 << BLUE_MANAESKEY2REG_MANAESKEY_95_64_Pos)   /*!<0x00200000 */
#define BLUE_MANAESKEY2REG_MANAESKEY_95_64_22                              (0x00400000 << BLUE_MANAESKEY2REG_MANAESKEY_95_64_Pos)   /*!<0x00400000 */
#define BLUE_MANAESKEY2REG_MANAESKEY_95_64_23                              (0x00800000 << BLUE_MANAESKEY2REG_MANAESKEY_95_64_Pos)   /*!<0x00800000 */
#define BLUE_MANAESKEY2REG_MANAESKEY_95_64_24                              (0x01000000 << BLUE_MANAESKEY2REG_MANAESKEY_95_64_Pos)   /*!<0x01000000 */
#define BLUE_MANAESKEY2REG_MANAESKEY_95_64_25                              (0x02000000 << BLUE_MANAESKEY2REG_MANAESKEY_95_64_Pos)   /*!<0x02000000 */
#define BLUE_MANAESKEY2REG_MANAESKEY_95_64_26                              (0x04000000 << BLUE_MANAESKEY2REG_MANAESKEY_95_64_Pos)   /*!<0x04000000 */
#define BLUE_MANAESKEY2REG_MANAESKEY_95_64_27                              (0x08000000 << BLUE_MANAESKEY2REG_MANAESKEY_95_64_Pos)   /*!<0x08000000 */
#define BLUE_MANAESKEY2REG_MANAESKEY_95_64_28                              (0x10000000 << BLUE_MANAESKEY2REG_MANAESKEY_95_64_Pos)   /*!<0x10000000 */
#define BLUE_MANAESKEY2REG_MANAESKEY_95_64_29                              (0x20000000 << BLUE_MANAESKEY2REG_MANAESKEY_95_64_Pos)   /*!<0x20000000 */
#define BLUE_MANAESKEY2REG_MANAESKEY_95_64_30                              (0x40000000 << BLUE_MANAESKEY2REG_MANAESKEY_95_64_Pos)   /*!<0x40000000 */
#define BLUE_MANAESKEY2REG_MANAESKEY_95_64_31                              (0x80000000 << BLUE_MANAESKEY2REG_MANAESKEY_95_64_Pos)   /*!<0x80000000 */

/* ===============================================   MANAESKEY3REG   =============================================== */
#define BLUE_MANAESKEY3REG_MANAESKEY_127_96_Pos                            (0UL)   /*!< BLUE MANAESKEY3REG: MANAESKEY_127_96 (Bit 0) */
#define BLUE_MANAESKEY3REG_MANAESKEY_127_96_Msk                            (0xffffffffUL)  /*!< BLUE MANAESKEY3REG: MANAESKEY_127_96 (Bitfield-Mask: 0xffffffffL) */
#define BLUE_MANAESKEY3REG_MANAESKEY_127_96                                BLUE_MANAESKEY3REG_MANAESKEY_127_96_Msk
#define BLUE_MANAESKEY3REG_MANAESKEY_127_96_0                              (0x00000001 << BLUE_MANAESKEY3REG_MANAESKEY_127_96_Pos)   /*!<0x00000001 */
#define BLUE_MANAESKEY3REG_MANAESKEY_127_96_1                              (0x00000002 << BLUE_MANAESKEY3REG_MANAESKEY_127_96_Pos)   /*!<0x00000002 */
#define BLUE_MANAESKEY3REG_MANAESKEY_127_96_2                              (0x00000004 << BLUE_MANAESKEY3REG_MANAESKEY_127_96_Pos)   /*!<0x00000004 */
#define BLUE_MANAESKEY3REG_MANAESKEY_127_96_3                              (0x00000008 << BLUE_MANAESKEY3REG_MANAESKEY_127_96_Pos)   /*!<0x00000008 */
#define BLUE_MANAESKEY3REG_MANAESKEY_127_96_4                              (0x00000010 << BLUE_MANAESKEY3REG_MANAESKEY_127_96_Pos)   /*!<0x00000010 */
#define BLUE_MANAESKEY3REG_MANAESKEY_127_96_5                              (0x00000020 << BLUE_MANAESKEY3REG_MANAESKEY_127_96_Pos)   /*!<0x00000020 */
#define BLUE_MANAESKEY3REG_MANAESKEY_127_96_6                              (0x00000040 << BLUE_MANAESKEY3REG_MANAESKEY_127_96_Pos)   /*!<0x00000040 */
#define BLUE_MANAESKEY3REG_MANAESKEY_127_96_7                              (0x00000080 << BLUE_MANAESKEY3REG_MANAESKEY_127_96_Pos)   /*!<0x00000080 */
#define BLUE_MANAESKEY3REG_MANAESKEY_127_96_8                              (0x00000100 << BLUE_MANAESKEY3REG_MANAESKEY_127_96_Pos)   /*!<0x00000100 */
#define BLUE_MANAESKEY3REG_MANAESKEY_127_96_9                              (0x00000200 << BLUE_MANAESKEY3REG_MANAESKEY_127_96_Pos)   /*!<0x00000200 */
#define BLUE_MANAESKEY3REG_MANAESKEY_127_96_10                             (0x00000400 << BLUE_MANAESKEY3REG_MANAESKEY_127_96_Pos)   /*!<0x00000400 */
#define BLUE_MANAESKEY3REG_MANAESKEY_127_96_11                             (0x00000800 << BLUE_MANAESKEY3REG_MANAESKEY_127_96_Pos)   /*!<0x00000800 */
#define BLUE_MANAESKEY3REG_MANAESKEY_127_96_12                             (0x00001000 << BLUE_MANAESKEY3REG_MANAESKEY_127_96_Pos)   /*!<0x00001000 */
#define BLUE_MANAESKEY3REG_MANAESKEY_127_96_13                             (0x00002000 << BLUE_MANAESKEY3REG_MANAESKEY_127_96_Pos)   /*!<0x00002000 */
#define BLUE_MANAESKEY3REG_MANAESKEY_127_96_14                             (0x00004000 << BLUE_MANAESKEY3REG_MANAESKEY_127_96_Pos)   /*!<0x00004000 */
#define BLUE_MANAESKEY3REG_MANAESKEY_127_96_15                             (0x00008000 << BLUE_MANAESKEY3REG_MANAESKEY_127_96_Pos)   /*!<0x00008000 */
#define BLUE_MANAESKEY3REG_MANAESKEY_127_96_16                             (0x00010000 << BLUE_MANAESKEY3REG_MANAESKEY_127_96_Pos)   /*!<0x00010000 */
#define BLUE_MANAESKEY3REG_MANAESKEY_127_96_17                             (0x00020000 << BLUE_MANAESKEY3REG_MANAESKEY_127_96_Pos)   /*!<0x00020000 */
#define BLUE_MANAESKEY3REG_MANAESKEY_127_96_18                             (0x00040000 << BLUE_MANAESKEY3REG_MANAESKEY_127_96_Pos)   /*!<0x00040000 */
#define BLUE_MANAESKEY3REG_MANAESKEY_127_96_19                             (0x00080000 << BLUE_MANAESKEY3REG_MANAESKEY_127_96_Pos)   /*!<0x00080000 */
#define BLUE_MANAESKEY3REG_MANAESKEY_127_96_20                             (0x00100000 << BLUE_MANAESKEY3REG_MANAESKEY_127_96_Pos)   /*!<0x00100000 */
#define BLUE_MANAESKEY3REG_MANAESKEY_127_96_21                             (0x00200000 << BLUE_MANAESKEY3REG_MANAESKEY_127_96_Pos)   /*!<0x00200000 */
#define BLUE_MANAESKEY3REG_MANAESKEY_127_96_22                             (0x00400000 << BLUE_MANAESKEY3REG_MANAESKEY_127_96_Pos)   /*!<0x00400000 */
#define BLUE_MANAESKEY3REG_MANAESKEY_127_96_23                             (0x00800000 << BLUE_MANAESKEY3REG_MANAESKEY_127_96_Pos)   /*!<0x00800000 */
#define BLUE_MANAESKEY3REG_MANAESKEY_127_96_24                             (0x01000000 << BLUE_MANAESKEY3REG_MANAESKEY_127_96_Pos)   /*!<0x01000000 */
#define BLUE_MANAESKEY3REG_MANAESKEY_127_96_25                             (0x02000000 << BLUE_MANAESKEY3REG_MANAESKEY_127_96_Pos)   /*!<0x02000000 */
#define BLUE_MANAESKEY3REG_MANAESKEY_127_96_26                             (0x04000000 << BLUE_MANAESKEY3REG_MANAESKEY_127_96_Pos)   /*!<0x04000000 */
#define BLUE_MANAESKEY3REG_MANAESKEY_127_96_27                             (0x08000000 << BLUE_MANAESKEY3REG_MANAESKEY_127_96_Pos)   /*!<0x08000000 */
#define BLUE_MANAESKEY3REG_MANAESKEY_127_96_28                             (0x10000000 << BLUE_MANAESKEY3REG_MANAESKEY_127_96_Pos)   /*!<0x10000000 */
#define BLUE_MANAESKEY3REG_MANAESKEY_127_96_29                             (0x20000000 << BLUE_MANAESKEY3REG_MANAESKEY_127_96_Pos)   /*!<0x20000000 */
#define BLUE_MANAESKEY3REG_MANAESKEY_127_96_30                             (0x40000000 << BLUE_MANAESKEY3REG_MANAESKEY_127_96_Pos)   /*!<0x40000000 */
#define BLUE_MANAESKEY3REG_MANAESKEY_127_96_31                             (0x80000000 << BLUE_MANAESKEY3REG_MANAESKEY_127_96_Pos)   /*!<0x80000000 */

/* ===============================================   MANAESCLEARTEXT0REG   =============================================== */
#define BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_Pos                        (0UL)   /*!< BLUE MANAESCLEARTEXT0REG: AES_CLEAR_31_0 (Bit 0) */
#define BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_Msk                        (0xffffffffUL)  /*!< BLUE MANAESCLEARTEXT0REG: AES_CLEAR_31_0 (Bitfield-Mask: 0xffffffffL) */
#define BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0                            BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_Msk
#define BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_0                          (0x00000001 << BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_Pos)   /*!<0x00000001 */
#define BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_1                          (0x00000002 << BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_Pos)   /*!<0x00000002 */
#define BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_2                          (0x00000004 << BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_Pos)   /*!<0x00000004 */
#define BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_3                          (0x00000008 << BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_Pos)   /*!<0x00000008 */
#define BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_4                          (0x00000010 << BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_Pos)   /*!<0x00000010 */
#define BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_5                          (0x00000020 << BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_Pos)   /*!<0x00000020 */
#define BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_6                          (0x00000040 << BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_Pos)   /*!<0x00000040 */
#define BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_7                          (0x00000080 << BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_Pos)   /*!<0x00000080 */
#define BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_8                          (0x00000100 << BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_Pos)   /*!<0x00000100 */
#define BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_9                          (0x00000200 << BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_Pos)   /*!<0x00000200 */
#define BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_10                         (0x00000400 << BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_Pos)   /*!<0x00000400 */
#define BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_11                         (0x00000800 << BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_Pos)   /*!<0x00000800 */
#define BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_12                         (0x00001000 << BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_Pos)   /*!<0x00001000 */
#define BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_13                         (0x00002000 << BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_Pos)   /*!<0x00002000 */
#define BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_14                         (0x00004000 << BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_Pos)   /*!<0x00004000 */
#define BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_15                         (0x00008000 << BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_Pos)   /*!<0x00008000 */
#define BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_16                         (0x00010000 << BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_Pos)   /*!<0x00010000 */
#define BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_17                         (0x00020000 << BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_Pos)   /*!<0x00020000 */
#define BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_18                         (0x00040000 << BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_Pos)   /*!<0x00040000 */
#define BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_19                         (0x00080000 << BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_Pos)   /*!<0x00080000 */
#define BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_20                         (0x00100000 << BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_Pos)   /*!<0x00100000 */
#define BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_21                         (0x00200000 << BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_Pos)   /*!<0x00200000 */
#define BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_22                         (0x00400000 << BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_Pos)   /*!<0x00400000 */
#define BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_23                         (0x00800000 << BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_Pos)   /*!<0x00800000 */
#define BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_24                         (0x01000000 << BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_Pos)   /*!<0x01000000 */
#define BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_25                         (0x02000000 << BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_Pos)   /*!<0x02000000 */
#define BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_26                         (0x04000000 << BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_Pos)   /*!<0x04000000 */
#define BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_27                         (0x08000000 << BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_Pos)   /*!<0x08000000 */
#define BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_28                         (0x10000000 << BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_Pos)   /*!<0x10000000 */
#define BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_29                         (0x20000000 << BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_Pos)   /*!<0x20000000 */
#define BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_30                         (0x40000000 << BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_Pos)   /*!<0x40000000 */
#define BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_31                         (0x80000000 << BLUE_MANAESCLEARTEXT0REG_AES_CLEAR_31_0_Pos)   /*!<0x80000000 */

/* ===============================================   MANAESCLEARTEXT1REG   =============================================== */
#define BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_Pos                       (0UL)   /*!< BLUE MANAESCLEARTEXT1REG: AES_CLEAR_63_32 (Bit 0) */
#define BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_Msk                       (0xffffffffUL)  /*!< BLUE MANAESCLEARTEXT1REG: AES_CLEAR_63_32 (Bitfield-Mask: 0xffffffffL) */
#define BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32                           BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_Msk
#define BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_0                         (0x00000001 << BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_Pos)   /*!<0x00000001 */
#define BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_1                         (0x00000002 << BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_Pos)   /*!<0x00000002 */
#define BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_2                         (0x00000004 << BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_Pos)   /*!<0x00000004 */
#define BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_3                         (0x00000008 << BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_Pos)   /*!<0x00000008 */
#define BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_4                         (0x00000010 << BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_Pos)   /*!<0x00000010 */
#define BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_5                         (0x00000020 << BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_Pos)   /*!<0x00000020 */
#define BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_6                         (0x00000040 << BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_Pos)   /*!<0x00000040 */
#define BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_7                         (0x00000080 << BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_Pos)   /*!<0x00000080 */
#define BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_8                         (0x00000100 << BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_Pos)   /*!<0x00000100 */
#define BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_9                         (0x00000200 << BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_Pos)   /*!<0x00000200 */
#define BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_10                        (0x00000400 << BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_Pos)   /*!<0x00000400 */
#define BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_11                        (0x00000800 << BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_Pos)   /*!<0x00000800 */
#define BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_12                        (0x00001000 << BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_Pos)   /*!<0x00001000 */
#define BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_13                        (0x00002000 << BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_Pos)   /*!<0x00002000 */
#define BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_14                        (0x00004000 << BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_Pos)   /*!<0x00004000 */
#define BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_15                        (0x00008000 << BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_Pos)   /*!<0x00008000 */
#define BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_16                        (0x00010000 << BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_Pos)   /*!<0x00010000 */
#define BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_17                        (0x00020000 << BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_Pos)   /*!<0x00020000 */
#define BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_18                        (0x00040000 << BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_Pos)   /*!<0x00040000 */
#define BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_19                        (0x00080000 << BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_Pos)   /*!<0x00080000 */
#define BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_20                        (0x00100000 << BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_Pos)   /*!<0x00100000 */
#define BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_21                        (0x00200000 << BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_Pos)   /*!<0x00200000 */
#define BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_22                        (0x00400000 << BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_Pos)   /*!<0x00400000 */
#define BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_23                        (0x00800000 << BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_Pos)   /*!<0x00800000 */
#define BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_24                        (0x01000000 << BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_Pos)   /*!<0x01000000 */
#define BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_25                        (0x02000000 << BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_Pos)   /*!<0x02000000 */
#define BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_26                        (0x04000000 << BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_Pos)   /*!<0x04000000 */
#define BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_27                        (0x08000000 << BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_Pos)   /*!<0x08000000 */
#define BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_28                        (0x10000000 << BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_Pos)   /*!<0x10000000 */
#define BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_29                        (0x20000000 << BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_Pos)   /*!<0x20000000 */
#define BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_30                        (0x40000000 << BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_Pos)   /*!<0x40000000 */
#define BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_31                        (0x80000000 << BLUE_MANAESCLEARTEXT1REG_AES_CLEAR_63_32_Pos)   /*!<0x80000000 */

/* ===============================================   MANAESCLEARTEXT2REG   =============================================== */
#define BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_Pos                       (0UL)   /*!< BLUE MANAESCLEARTEXT2REG: AES_CLEAR_95_64 (Bit 0) */
#define BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_Msk                       (0xffffffffUL)  /*!< BLUE MANAESCLEARTEXT2REG: AES_CLEAR_95_64 (Bitfield-Mask: 0xffffffffL) */
#define BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64                           BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_Msk
#define BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_0                         (0x00000001 << BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_Pos)   /*!<0x00000001 */
#define BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_1                         (0x00000002 << BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_Pos)   /*!<0x00000002 */
#define BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_2                         (0x00000004 << BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_Pos)   /*!<0x00000004 */
#define BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_3                         (0x00000008 << BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_Pos)   /*!<0x00000008 */
#define BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_4                         (0x00000010 << BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_Pos)   /*!<0x00000010 */
#define BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_5                         (0x00000020 << BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_Pos)   /*!<0x00000020 */
#define BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_6                         (0x00000040 << BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_Pos)   /*!<0x00000040 */
#define BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_7                         (0x00000080 << BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_Pos)   /*!<0x00000080 */
#define BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_8                         (0x00000100 << BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_Pos)   /*!<0x00000100 */
#define BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_9                         (0x00000200 << BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_Pos)   /*!<0x00000200 */
#define BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_10                        (0x00000400 << BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_Pos)   /*!<0x00000400 */
#define BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_11                        (0x00000800 << BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_Pos)   /*!<0x00000800 */
#define BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_12                        (0x00001000 << BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_Pos)   /*!<0x00001000 */
#define BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_13                        (0x00002000 << BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_Pos)   /*!<0x00002000 */
#define BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_14                        (0x00004000 << BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_Pos)   /*!<0x00004000 */
#define BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_15                        (0x00008000 << BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_Pos)   /*!<0x00008000 */
#define BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_16                        (0x00010000 << BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_Pos)   /*!<0x00010000 */
#define BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_17                        (0x00020000 << BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_Pos)   /*!<0x00020000 */
#define BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_18                        (0x00040000 << BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_Pos)   /*!<0x00040000 */
#define BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_19                        (0x00080000 << BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_Pos)   /*!<0x00080000 */
#define BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_20                        (0x00100000 << BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_Pos)   /*!<0x00100000 */
#define BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_21                        (0x00200000 << BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_Pos)   /*!<0x00200000 */
#define BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_22                        (0x00400000 << BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_Pos)   /*!<0x00400000 */
#define BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_23                        (0x00800000 << BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_Pos)   /*!<0x00800000 */
#define BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_24                        (0x01000000 << BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_Pos)   /*!<0x01000000 */
#define BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_25                        (0x02000000 << BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_Pos)   /*!<0x02000000 */
#define BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_26                        (0x04000000 << BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_Pos)   /*!<0x04000000 */
#define BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_27                        (0x08000000 << BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_Pos)   /*!<0x08000000 */
#define BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_28                        (0x10000000 << BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_Pos)   /*!<0x10000000 */
#define BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_29                        (0x20000000 << BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_Pos)   /*!<0x20000000 */
#define BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_30                        (0x40000000 << BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_Pos)   /*!<0x40000000 */
#define BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_31                        (0x80000000 << BLUE_MANAESCLEARTEXT2REG_AES_CLEAR_95_64_Pos)   /*!<0x80000000 */

/* ===============================================   MANAESCLEARTEXT3REG   =============================================== */
#define BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_Pos                      (0UL)   /*!< BLUE MANAESCLEARTEXT3REG: AES_CLEAR_127_96 (Bit 0) */
#define BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_Msk                      (0xffffffffUL)  /*!< BLUE MANAESCLEARTEXT3REG: AES_CLEAR_127_96 (Bitfield-Mask: 0xffffffffL) */
#define BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96                          BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_Msk
#define BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_0                        (0x00000001 << BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_Pos)   /*!<0x00000001 */
#define BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_1                        (0x00000002 << BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_Pos)   /*!<0x00000002 */
#define BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_2                        (0x00000004 << BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_Pos)   /*!<0x00000004 */
#define BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_3                        (0x00000008 << BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_Pos)   /*!<0x00000008 */
#define BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_4                        (0x00000010 << BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_Pos)   /*!<0x00000010 */
#define BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_5                        (0x00000020 << BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_Pos)   /*!<0x00000020 */
#define BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_6                        (0x00000040 << BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_Pos)   /*!<0x00000040 */
#define BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_7                        (0x00000080 << BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_Pos)   /*!<0x00000080 */
#define BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_8                        (0x00000100 << BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_Pos)   /*!<0x00000100 */
#define BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_9                        (0x00000200 << BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_Pos)   /*!<0x00000200 */
#define BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_10                       (0x00000400 << BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_Pos)   /*!<0x00000400 */
#define BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_11                       (0x00000800 << BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_Pos)   /*!<0x00000800 */
#define BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_12                       (0x00001000 << BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_Pos)   /*!<0x00001000 */
#define BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_13                       (0x00002000 << BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_Pos)   /*!<0x00002000 */
#define BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_14                       (0x00004000 << BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_Pos)   /*!<0x00004000 */
#define BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_15                       (0x00008000 << BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_Pos)   /*!<0x00008000 */
#define BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_16                       (0x00010000 << BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_Pos)   /*!<0x00010000 */
#define BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_17                       (0x00020000 << BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_Pos)   /*!<0x00020000 */
#define BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_18                       (0x00040000 << BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_Pos)   /*!<0x00040000 */
#define BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_19                       (0x00080000 << BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_Pos)   /*!<0x00080000 */
#define BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_20                       (0x00100000 << BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_Pos)   /*!<0x00100000 */
#define BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_21                       (0x00200000 << BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_Pos)   /*!<0x00200000 */
#define BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_22                       (0x00400000 << BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_Pos)   /*!<0x00400000 */
#define BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_23                       (0x00800000 << BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_Pos)   /*!<0x00800000 */
#define BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_24                       (0x01000000 << BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_Pos)   /*!<0x01000000 */
#define BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_25                       (0x02000000 << BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_Pos)   /*!<0x02000000 */
#define BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_26                       (0x04000000 << BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_Pos)   /*!<0x04000000 */
#define BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_27                       (0x08000000 << BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_Pos)   /*!<0x08000000 */
#define BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_28                       (0x10000000 << BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_Pos)   /*!<0x10000000 */
#define BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_29                       (0x20000000 << BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_Pos)   /*!<0x20000000 */
#define BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_30                       (0x40000000 << BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_Pos)   /*!<0x40000000 */
#define BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_31                       (0x80000000 << BLUE_MANAESCLEARTEXT3REG_AES_CLEAR_127_96_Pos)   /*!<0x80000000 */

/* ===============================================   MANAESCIPHERTEXT0REG   =============================================== */
#define BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_Pos                      (0UL)   /*!< BLUE MANAESCIPHERTEXT0REG: AES_CIPHER_31_0 (Bit 0) */
#define BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_Msk                      (0xffffffffUL)  /*!< BLUE MANAESCIPHERTEXT0REG: AES_CIPHER_31_0 (Bitfield-Mask: 0xffffffffL) */
#define BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0                          BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_Msk
#define BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_0                        (0x00000001 << BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_Pos)   /*!<0x00000001 */
#define BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_1                        (0x00000002 << BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_Pos)   /*!<0x00000002 */
#define BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_2                        (0x00000004 << BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_Pos)   /*!<0x00000004 */
#define BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_3                        (0x00000008 << BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_Pos)   /*!<0x00000008 */
#define BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_4                        (0x00000010 << BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_Pos)   /*!<0x00000010 */
#define BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_5                        (0x00000020 << BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_Pos)   /*!<0x00000020 */
#define BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_6                        (0x00000040 << BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_Pos)   /*!<0x00000040 */
#define BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_7                        (0x00000080 << BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_Pos)   /*!<0x00000080 */
#define BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_8                        (0x00000100 << BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_Pos)   /*!<0x00000100 */
#define BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_9                        (0x00000200 << BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_Pos)   /*!<0x00000200 */
#define BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_10                       (0x00000400 << BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_Pos)   /*!<0x00000400 */
#define BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_11                       (0x00000800 << BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_Pos)   /*!<0x00000800 */
#define BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_12                       (0x00001000 << BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_Pos)   /*!<0x00001000 */
#define BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_13                       (0x00002000 << BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_Pos)   /*!<0x00002000 */
#define BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_14                       (0x00004000 << BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_Pos)   /*!<0x00004000 */
#define BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_15                       (0x00008000 << BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_Pos)   /*!<0x00008000 */
#define BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_16                       (0x00010000 << BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_Pos)   /*!<0x00010000 */
#define BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_17                       (0x00020000 << BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_Pos)   /*!<0x00020000 */
#define BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_18                       (0x00040000 << BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_Pos)   /*!<0x00040000 */
#define BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_19                       (0x00080000 << BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_Pos)   /*!<0x00080000 */
#define BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_20                       (0x00100000 << BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_Pos)   /*!<0x00100000 */
#define BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_21                       (0x00200000 << BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_Pos)   /*!<0x00200000 */
#define BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_22                       (0x00400000 << BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_Pos)   /*!<0x00400000 */
#define BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_23                       (0x00800000 << BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_Pos)   /*!<0x00800000 */
#define BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_24                       (0x01000000 << BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_Pos)   /*!<0x01000000 */
#define BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_25                       (0x02000000 << BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_Pos)   /*!<0x02000000 */
#define BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_26                       (0x04000000 << BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_Pos)   /*!<0x04000000 */
#define BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_27                       (0x08000000 << BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_Pos)   /*!<0x08000000 */
#define BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_28                       (0x10000000 << BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_Pos)   /*!<0x10000000 */
#define BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_29                       (0x20000000 << BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_Pos)   /*!<0x20000000 */
#define BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_30                       (0x40000000 << BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_Pos)   /*!<0x40000000 */
#define BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_31                       (0x80000000 << BLUE_MANAESCIPHERTEXT0REG_AES_CIPHER_31_0_Pos)   /*!<0x80000000 */

/* ===============================================   MANAESCIPHERTEXT1REG   =============================================== */
#define BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_Pos                     (0UL)   /*!< BLUE MANAESCIPHERTEXT1REG: AES_CIPHER_63_32 (Bit 0) */
#define BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_Msk                     (0xffffffffUL)  /*!< BLUE MANAESCIPHERTEXT1REG: AES_CIPHER_63_32 (Bitfield-Mask: 0xffffffffL) */
#define BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32                         BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_Msk
#define BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_0                       (0x00000001 << BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_Pos)   /*!<0x00000001 */
#define BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_1                       (0x00000002 << BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_Pos)   /*!<0x00000002 */
#define BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_2                       (0x00000004 << BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_Pos)   /*!<0x00000004 */
#define BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_3                       (0x00000008 << BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_Pos)   /*!<0x00000008 */
#define BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_4                       (0x00000010 << BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_Pos)   /*!<0x00000010 */
#define BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_5                       (0x00000020 << BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_Pos)   /*!<0x00000020 */
#define BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_6                       (0x00000040 << BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_Pos)   /*!<0x00000040 */
#define BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_7                       (0x00000080 << BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_Pos)   /*!<0x00000080 */
#define BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_8                       (0x00000100 << BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_Pos)   /*!<0x00000100 */
#define BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_9                       (0x00000200 << BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_Pos)   /*!<0x00000200 */
#define BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_10                      (0x00000400 << BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_Pos)   /*!<0x00000400 */
#define BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_11                      (0x00000800 << BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_Pos)   /*!<0x00000800 */
#define BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_12                      (0x00001000 << BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_Pos)   /*!<0x00001000 */
#define BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_13                      (0x00002000 << BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_Pos)   /*!<0x00002000 */
#define BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_14                      (0x00004000 << BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_Pos)   /*!<0x00004000 */
#define BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_15                      (0x00008000 << BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_Pos)   /*!<0x00008000 */
#define BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_16                      (0x00010000 << BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_Pos)   /*!<0x00010000 */
#define BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_17                      (0x00020000 << BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_Pos)   /*!<0x00020000 */
#define BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_18                      (0x00040000 << BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_Pos)   /*!<0x00040000 */
#define BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_19                      (0x00080000 << BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_Pos)   /*!<0x00080000 */
#define BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_20                      (0x00100000 << BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_Pos)   /*!<0x00100000 */
#define BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_21                      (0x00200000 << BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_Pos)   /*!<0x00200000 */
#define BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_22                      (0x00400000 << BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_Pos)   /*!<0x00400000 */
#define BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_23                      (0x00800000 << BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_Pos)   /*!<0x00800000 */
#define BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_24                      (0x01000000 << BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_Pos)   /*!<0x01000000 */
#define BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_25                      (0x02000000 << BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_Pos)   /*!<0x02000000 */
#define BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_26                      (0x04000000 << BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_Pos)   /*!<0x04000000 */
#define BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_27                      (0x08000000 << BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_Pos)   /*!<0x08000000 */
#define BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_28                      (0x10000000 << BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_Pos)   /*!<0x10000000 */
#define BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_29                      (0x20000000 << BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_Pos)   /*!<0x20000000 */
#define BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_30                      (0x40000000 << BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_Pos)   /*!<0x40000000 */
#define BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_31                      (0x80000000 << BLUE_MANAESCIPHERTEXT1REG_AES_CIPHER_63_32_Pos)   /*!<0x80000000 */

/* ===============================================   MANAESCIPHERTEXT2REG   =============================================== */
#define BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_Pos                     (0UL)   /*!< BLUE MANAESCIPHERTEXT2REG: AES_CIPHER_95_64 (Bit 0) */
#define BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_Msk                     (0xffffffffUL)  /*!< BLUE MANAESCIPHERTEXT2REG: AES_CIPHER_95_64 (Bitfield-Mask: 0xffffffffL) */
#define BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64                         BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_Msk
#define BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_0                       (0x00000001 << BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_Pos)   /*!<0x00000001 */
#define BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_1                       (0x00000002 << BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_Pos)   /*!<0x00000002 */
#define BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_2                       (0x00000004 << BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_Pos)   /*!<0x00000004 */
#define BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_3                       (0x00000008 << BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_Pos)   /*!<0x00000008 */
#define BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_4                       (0x00000010 << BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_Pos)   /*!<0x00000010 */
#define BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_5                       (0x00000020 << BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_Pos)   /*!<0x00000020 */
#define BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_6                       (0x00000040 << BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_Pos)   /*!<0x00000040 */
#define BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_7                       (0x00000080 << BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_Pos)   /*!<0x00000080 */
#define BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_8                       (0x00000100 << BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_Pos)   /*!<0x00000100 */
#define BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_9                       (0x00000200 << BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_Pos)   /*!<0x00000200 */
#define BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_10                      (0x00000400 << BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_Pos)   /*!<0x00000400 */
#define BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_11                      (0x00000800 << BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_Pos)   /*!<0x00000800 */
#define BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_12                      (0x00001000 << BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_Pos)   /*!<0x00001000 */
#define BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_13                      (0x00002000 << BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_Pos)   /*!<0x00002000 */
#define BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_14                      (0x00004000 << BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_Pos)   /*!<0x00004000 */
#define BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_15                      (0x00008000 << BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_Pos)   /*!<0x00008000 */
#define BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_16                      (0x00010000 << BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_Pos)   /*!<0x00010000 */
#define BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_17                      (0x00020000 << BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_Pos)   /*!<0x00020000 */
#define BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_18                      (0x00040000 << BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_Pos)   /*!<0x00040000 */
#define BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_19                      (0x00080000 << BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_Pos)   /*!<0x00080000 */
#define BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_20                      (0x00100000 << BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_Pos)   /*!<0x00100000 */
#define BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_21                      (0x00200000 << BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_Pos)   /*!<0x00200000 */
#define BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_22                      (0x00400000 << BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_Pos)   /*!<0x00400000 */
#define BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_23                      (0x00800000 << BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_Pos)   /*!<0x00800000 */
#define BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_24                      (0x01000000 << BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_Pos)   /*!<0x01000000 */
#define BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_25                      (0x02000000 << BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_Pos)   /*!<0x02000000 */
#define BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_26                      (0x04000000 << BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_Pos)   /*!<0x04000000 */
#define BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_27                      (0x08000000 << BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_Pos)   /*!<0x08000000 */
#define BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_28                      (0x10000000 << BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_Pos)   /*!<0x10000000 */
#define BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_29                      (0x20000000 << BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_Pos)   /*!<0x20000000 */
#define BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_30                      (0x40000000 << BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_Pos)   /*!<0x40000000 */
#define BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_31                      (0x80000000 << BLUE_MANAESCIPHERTEXT2REG_AES_CIPHER_95_64_Pos)   /*!<0x80000000 */

/* ===============================================   MANAESCIPHERTEXT3REG   =============================================== */
#define BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_Pos                    (0UL)   /*!< BLUE MANAESCIPHERTEXT3REG: AES_CIPHER_127_96 (Bit 0) */
#define BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_Msk                    (0xffffffffUL)  /*!< BLUE MANAESCIPHERTEXT3REG: AES_CIPHER_127_96 (Bitfield-Mask: 0xffffffffL) */
#define BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96                        BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_Msk
#define BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_0                      (0x00000001 << BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_Pos)   /*!<0x00000001 */
#define BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_1                      (0x00000002 << BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_Pos)   /*!<0x00000002 */
#define BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_2                      (0x00000004 << BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_Pos)   /*!<0x00000004 */
#define BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_3                      (0x00000008 << BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_Pos)   /*!<0x00000008 */
#define BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_4                      (0x00000010 << BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_Pos)   /*!<0x00000010 */
#define BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_5                      (0x00000020 << BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_Pos)   /*!<0x00000020 */
#define BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_6                      (0x00000040 << BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_Pos)   /*!<0x00000040 */
#define BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_7                      (0x00000080 << BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_Pos)   /*!<0x00000080 */
#define BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_8                      (0x00000100 << BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_Pos)   /*!<0x00000100 */
#define BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_9                      (0x00000200 << BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_Pos)   /*!<0x00000200 */
#define BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_10                     (0x00000400 << BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_Pos)   /*!<0x00000400 */
#define BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_11                     (0x00000800 << BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_Pos)   /*!<0x00000800 */
#define BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_12                     (0x00001000 << BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_Pos)   /*!<0x00001000 */
#define BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_13                     (0x00002000 << BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_Pos)   /*!<0x00002000 */
#define BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_14                     (0x00004000 << BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_Pos)   /*!<0x00004000 */
#define BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_15                     (0x00008000 << BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_Pos)   /*!<0x00008000 */
#define BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_16                     (0x00010000 << BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_Pos)   /*!<0x00010000 */
#define BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_17                     (0x00020000 << BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_Pos)   /*!<0x00020000 */
#define BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_18                     (0x00040000 << BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_Pos)   /*!<0x00040000 */
#define BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_19                     (0x00080000 << BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_Pos)   /*!<0x00080000 */
#define BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_20                     (0x00100000 << BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_Pos)   /*!<0x00100000 */
#define BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_21                     (0x00200000 << BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_Pos)   /*!<0x00200000 */
#define BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_22                     (0x00400000 << BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_Pos)   /*!<0x00400000 */
#define BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_23                     (0x00800000 << BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_Pos)   /*!<0x00800000 */
#define BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_24                     (0x01000000 << BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_Pos)   /*!<0x01000000 */
#define BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_25                     (0x02000000 << BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_Pos)   /*!<0x02000000 */
#define BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_26                     (0x04000000 << BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_Pos)   /*!<0x04000000 */
#define BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_27                     (0x08000000 << BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_Pos)   /*!<0x08000000 */
#define BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_28                     (0x10000000 << BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_Pos)   /*!<0x10000000 */
#define BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_29                     (0x20000000 << BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_Pos)   /*!<0x20000000 */
#define BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_30                     (0x40000000 << BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_Pos)   /*!<0x40000000 */
#define BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_31                     (0x80000000 << BLUE_MANAESCIPHERTEXT3REG_AES_CIPHER_127_96_Pos)   /*!<0x80000000 */

/* ===============================================   MANAESCMDREG   =============================================== */
#define BLUE_MANAESCMDREG_START_Pos                                        (0UL)   /*!< BLUE MANAESCMDREG: START (Bit 0) */
#define BLUE_MANAESCMDREG_START_Msk                                        (0x00000001UL)  /*!< BLUE MANAESCMDREG: START (Bitfield-Mask: 0x1) */
#define BLUE_MANAESCMDREG_START                                            BLUE_MANAESCMDREG_START_Msk
#define BLUE_MANAESCMDREG_INTENA_Pos                                       (1UL)   /*!< BLUE MANAESCMDREG: INTENA (Bit 1) */
#define BLUE_MANAESCMDREG_INTENA_Msk                                       (0x00000002UL)  /*!< BLUE MANAESCMDREG: INTENA (Bitfield-Mask: 0x1) */
#define BLUE_MANAESCMDREG_INTENA                                           BLUE_MANAESCMDREG_INTENA_Msk

/* ===============================================   MANAESSTATREG   =============================================== */
#define BLUE_MANAESSTATREG_BUSY_Pos                                        (0UL)   /*!< BLUE MANAESSTATREG: BUSY (Bit 0) */
#define BLUE_MANAESSTATREG_BUSY_Msk                                        (0x00000001UL)  /*!< BLUE MANAESSTATREG: BUSY (Bitfield-Mask: 0x1) */
#define BLUE_MANAESSTATREG_BUSY                                            BLUE_MANAESSTATREG_BUSY_Msk

/* ===============================================   AESLEPRIVPOINTERREG   =============================================== */
#define BLUE_AESLEPRIVPOINTERREG_POINTER_Pos                               (0UL)   /*!< BLUE AESLEPRIVPOINTERREG: POINTER (Bit 0) */
#define BLUE_AESLEPRIVPOINTERREG_POINTER_Msk                               (0x00ffffffUL)  /*!< BLUE AESLEPRIVPOINTERREG: POINTER (Bitfield-Mask: 0xffffff) */
#define BLUE_AESLEPRIVPOINTERREG_POINTER                                   BLUE_AESLEPRIVPOINTERREG_POINTER_Msk
#define BLUE_AESLEPRIVPOINTERREG_POINTER_0                                 (0x000001 << BLUE_AESLEPRIVPOINTERREG_POINTER_Pos)   /*!<0x00000001 */
#define BLUE_AESLEPRIVPOINTERREG_POINTER_1                                 (0x000002 << BLUE_AESLEPRIVPOINTERREG_POINTER_Pos)   /*!<0x00000002 */
#define BLUE_AESLEPRIVPOINTERREG_POINTER_2                                 (0x000004 << BLUE_AESLEPRIVPOINTERREG_POINTER_Pos)   /*!<0x00000004 */
#define BLUE_AESLEPRIVPOINTERREG_POINTER_3                                 (0x000008 << BLUE_AESLEPRIVPOINTERREG_POINTER_Pos)   /*!<0x00000008 */
#define BLUE_AESLEPRIVPOINTERREG_POINTER_4                                 (0x000010 << BLUE_AESLEPRIVPOINTERREG_POINTER_Pos)   /*!<0x00000010 */
#define BLUE_AESLEPRIVPOINTERREG_POINTER_5                                 (0x000020 << BLUE_AESLEPRIVPOINTERREG_POINTER_Pos)   /*!<0x00000020 */
#define BLUE_AESLEPRIVPOINTERREG_POINTER_6                                 (0x000040 << BLUE_AESLEPRIVPOINTERREG_POINTER_Pos)   /*!<0x00000040 */
#define BLUE_AESLEPRIVPOINTERREG_POINTER_7                                 (0x000080 << BLUE_AESLEPRIVPOINTERREG_POINTER_Pos)   /*!<0x00000080 */
#define BLUE_AESLEPRIVPOINTERREG_POINTER_8                                 (0x000100 << BLUE_AESLEPRIVPOINTERREG_POINTER_Pos)   /*!<0x00000100 */
#define BLUE_AESLEPRIVPOINTERREG_POINTER_9                                 (0x000200 << BLUE_AESLEPRIVPOINTERREG_POINTER_Pos)   /*!<0x00000200 */
#define BLUE_AESLEPRIVPOINTERREG_POINTER_10                                (0x000400 << BLUE_AESLEPRIVPOINTERREG_POINTER_Pos)   /*!<0x00000400 */
#define BLUE_AESLEPRIVPOINTERREG_POINTER_11                                (0x000800 << BLUE_AESLEPRIVPOINTERREG_POINTER_Pos)   /*!<0x00000800 */
#define BLUE_AESLEPRIVPOINTERREG_POINTER_12                                (0x001000 << BLUE_AESLEPRIVPOINTERREG_POINTER_Pos)   /*!<0x00001000 */
#define BLUE_AESLEPRIVPOINTERREG_POINTER_13                                (0x002000 << BLUE_AESLEPRIVPOINTERREG_POINTER_Pos)   /*!<0x00002000 */
#define BLUE_AESLEPRIVPOINTERREG_POINTER_14                                (0x004000 << BLUE_AESLEPRIVPOINTERREG_POINTER_Pos)   /*!<0x00004000 */
#define BLUE_AESLEPRIVPOINTERREG_POINTER_15                                (0x008000 << BLUE_AESLEPRIVPOINTERREG_POINTER_Pos)   /*!<0x00008000 */
#define BLUE_AESLEPRIVPOINTERREG_POINTER_16                                (0x010000 << BLUE_AESLEPRIVPOINTERREG_POINTER_Pos)   /*!<0x00010000 */
#define BLUE_AESLEPRIVPOINTERREG_POINTER_17                                (0x020000 << BLUE_AESLEPRIVPOINTERREG_POINTER_Pos)   /*!<0x00020000 */
#define BLUE_AESLEPRIVPOINTERREG_POINTER_18                                (0x040000 << BLUE_AESLEPRIVPOINTERREG_POINTER_Pos)   /*!<0x00040000 */
#define BLUE_AESLEPRIVPOINTERREG_POINTER_19                                (0x080000 << BLUE_AESLEPRIVPOINTERREG_POINTER_Pos)   /*!<0x00080000 */
#define BLUE_AESLEPRIVPOINTERREG_POINTER_20                                (0x100000 << BLUE_AESLEPRIVPOINTERREG_POINTER_Pos)   /*!<0x00100000 */
#define BLUE_AESLEPRIVPOINTERREG_POINTER_21                                (0x200000 << BLUE_AESLEPRIVPOINTERREG_POINTER_Pos)   /*!<0x00200000 */
#define BLUE_AESLEPRIVPOINTERREG_POINTER_22                                (0x400000 << BLUE_AESLEPRIVPOINTERREG_POINTER_Pos)   /*!<0x00400000 */
#define BLUE_AESLEPRIVPOINTERREG_POINTER_23                                (0x800000 << BLUE_AESLEPRIVPOINTERREG_POINTER_Pos)   /*!<0x00800000 */

/* ===============================================   AESLEPRIVHASHREG   =============================================== */
#define BLUE_AESLEPRIVHASHREG_HASH_Pos                                     (0UL)   /*!< BLUE AESLEPRIVHASHREG: HASH (Bit 0) */
#define BLUE_AESLEPRIVHASHREG_HASH_Msk                                     (0x00ffffffUL)  /*!< BLUE AESLEPRIVHASHREG: HASH (Bitfield-Mask: 0xffffff) */
#define BLUE_AESLEPRIVHASHREG_HASH                                         BLUE_AESLEPRIVHASHREG_HASH_Msk
#define BLUE_AESLEPRIVHASHREG_HASH_0                                       (0x000001 << BLUE_AESLEPRIVHASHREG_HASH_Pos)   /*!<0x00000001 */
#define BLUE_AESLEPRIVHASHREG_HASH_1                                       (0x000002 << BLUE_AESLEPRIVHASHREG_HASH_Pos)   /*!<0x00000002 */
#define BLUE_AESLEPRIVHASHREG_HASH_2                                       (0x000004 << BLUE_AESLEPRIVHASHREG_HASH_Pos)   /*!<0x00000004 */
#define BLUE_AESLEPRIVHASHREG_HASH_3                                       (0x000008 << BLUE_AESLEPRIVHASHREG_HASH_Pos)   /*!<0x00000008 */
#define BLUE_AESLEPRIVHASHREG_HASH_4                                       (0x000010 << BLUE_AESLEPRIVHASHREG_HASH_Pos)   /*!<0x00000010 */
#define BLUE_AESLEPRIVHASHREG_HASH_5                                       (0x000020 << BLUE_AESLEPRIVHASHREG_HASH_Pos)   /*!<0x00000020 */
#define BLUE_AESLEPRIVHASHREG_HASH_6                                       (0x000040 << BLUE_AESLEPRIVHASHREG_HASH_Pos)   /*!<0x00000040 */
#define BLUE_AESLEPRIVHASHREG_HASH_7                                       (0x000080 << BLUE_AESLEPRIVHASHREG_HASH_Pos)   /*!<0x00000080 */
#define BLUE_AESLEPRIVHASHREG_HASH_8                                       (0x000100 << BLUE_AESLEPRIVHASHREG_HASH_Pos)   /*!<0x00000100 */
#define BLUE_AESLEPRIVHASHREG_HASH_9                                       (0x000200 << BLUE_AESLEPRIVHASHREG_HASH_Pos)   /*!<0x00000200 */
#define BLUE_AESLEPRIVHASHREG_HASH_10                                      (0x000400 << BLUE_AESLEPRIVHASHREG_HASH_Pos)   /*!<0x00000400 */
#define BLUE_AESLEPRIVHASHREG_HASH_11                                      (0x000800 << BLUE_AESLEPRIVHASHREG_HASH_Pos)   /*!<0x00000800 */
#define BLUE_AESLEPRIVHASHREG_HASH_12                                      (0x001000 << BLUE_AESLEPRIVHASHREG_HASH_Pos)   /*!<0x00001000 */
#define BLUE_AESLEPRIVHASHREG_HASH_13                                      (0x002000 << BLUE_AESLEPRIVHASHREG_HASH_Pos)   /*!<0x00002000 */
#define BLUE_AESLEPRIVHASHREG_HASH_14                                      (0x004000 << BLUE_AESLEPRIVHASHREG_HASH_Pos)   /*!<0x00004000 */
#define BLUE_AESLEPRIVHASHREG_HASH_15                                      (0x008000 << BLUE_AESLEPRIVHASHREG_HASH_Pos)   /*!<0x00008000 */
#define BLUE_AESLEPRIVHASHREG_HASH_16                                      (0x010000 << BLUE_AESLEPRIVHASHREG_HASH_Pos)   /*!<0x00010000 */
#define BLUE_AESLEPRIVHASHREG_HASH_17                                      (0x020000 << BLUE_AESLEPRIVHASHREG_HASH_Pos)   /*!<0x00020000 */
#define BLUE_AESLEPRIVHASHREG_HASH_18                                      (0x040000 << BLUE_AESLEPRIVHASHREG_HASH_Pos)   /*!<0x00040000 */
#define BLUE_AESLEPRIVHASHREG_HASH_19                                      (0x080000 << BLUE_AESLEPRIVHASHREG_HASH_Pos)   /*!<0x00080000 */
#define BLUE_AESLEPRIVHASHREG_HASH_20                                      (0x100000 << BLUE_AESLEPRIVHASHREG_HASH_Pos)   /*!<0x00100000 */
#define BLUE_AESLEPRIVHASHREG_HASH_21                                      (0x200000 << BLUE_AESLEPRIVHASHREG_HASH_Pos)   /*!<0x00200000 */
#define BLUE_AESLEPRIVHASHREG_HASH_22                                      (0x400000 << BLUE_AESLEPRIVHASHREG_HASH_Pos)   /*!<0x00400000 */
#define BLUE_AESLEPRIVHASHREG_HASH_23                                      (0x800000 << BLUE_AESLEPRIVHASHREG_HASH_Pos)   /*!<0x00800000 */

/* ===============================================   AESLEPRIVPRANDREG   =============================================== */
#define BLUE_AESLEPRIVPRANDREG_PRAND_Pos                                   (0UL)   /*!< BLUE AESLEPRIVPRANDREG: PRAND (Bit 0) */
#define BLUE_AESLEPRIVPRANDREG_PRAND_Msk                                   (0x00ffffffUL)  /*!< BLUE AESLEPRIVPRANDREG: PRAND (Bitfield-Mask: 0xffffff) */
#define BLUE_AESLEPRIVPRANDREG_PRAND                                       BLUE_AESLEPRIVPRANDREG_PRAND_Msk
#define BLUE_AESLEPRIVPRANDREG_PRAND_0                                     (0x000001 << BLUE_AESLEPRIVPRANDREG_PRAND_Pos)   /*!<0x00000001 */
#define BLUE_AESLEPRIVPRANDREG_PRAND_1                                     (0x000002 << BLUE_AESLEPRIVPRANDREG_PRAND_Pos)   /*!<0x00000002 */
#define BLUE_AESLEPRIVPRANDREG_PRAND_2                                     (0x000004 << BLUE_AESLEPRIVPRANDREG_PRAND_Pos)   /*!<0x00000004 */
#define BLUE_AESLEPRIVPRANDREG_PRAND_3                                     (0x000008 << BLUE_AESLEPRIVPRANDREG_PRAND_Pos)   /*!<0x00000008 */
#define BLUE_AESLEPRIVPRANDREG_PRAND_4                                     (0x000010 << BLUE_AESLEPRIVPRANDREG_PRAND_Pos)   /*!<0x00000010 */
#define BLUE_AESLEPRIVPRANDREG_PRAND_5                                     (0x000020 << BLUE_AESLEPRIVPRANDREG_PRAND_Pos)   /*!<0x00000020 */
#define BLUE_AESLEPRIVPRANDREG_PRAND_6                                     (0x000040 << BLUE_AESLEPRIVPRANDREG_PRAND_Pos)   /*!<0x00000040 */
#define BLUE_AESLEPRIVPRANDREG_PRAND_7                                     (0x000080 << BLUE_AESLEPRIVPRANDREG_PRAND_Pos)   /*!<0x00000080 */
#define BLUE_AESLEPRIVPRANDREG_PRAND_8                                     (0x000100 << BLUE_AESLEPRIVPRANDREG_PRAND_Pos)   /*!<0x00000100 */
#define BLUE_AESLEPRIVPRANDREG_PRAND_9                                     (0x000200 << BLUE_AESLEPRIVPRANDREG_PRAND_Pos)   /*!<0x00000200 */
#define BLUE_AESLEPRIVPRANDREG_PRAND_10                                    (0x000400 << BLUE_AESLEPRIVPRANDREG_PRAND_Pos)   /*!<0x00000400 */
#define BLUE_AESLEPRIVPRANDREG_PRAND_11                                    (0x000800 << BLUE_AESLEPRIVPRANDREG_PRAND_Pos)   /*!<0x00000800 */
#define BLUE_AESLEPRIVPRANDREG_PRAND_12                                    (0x001000 << BLUE_AESLEPRIVPRANDREG_PRAND_Pos)   /*!<0x00001000 */
#define BLUE_AESLEPRIVPRANDREG_PRAND_13                                    (0x002000 << BLUE_AESLEPRIVPRANDREG_PRAND_Pos)   /*!<0x00002000 */
#define BLUE_AESLEPRIVPRANDREG_PRAND_14                                    (0x004000 << BLUE_AESLEPRIVPRANDREG_PRAND_Pos)   /*!<0x00004000 */
#define BLUE_AESLEPRIVPRANDREG_PRAND_15                                    (0x008000 << BLUE_AESLEPRIVPRANDREG_PRAND_Pos)   /*!<0x00008000 */
#define BLUE_AESLEPRIVPRANDREG_PRAND_16                                    (0x010000 << BLUE_AESLEPRIVPRANDREG_PRAND_Pos)   /*!<0x00010000 */
#define BLUE_AESLEPRIVPRANDREG_PRAND_17                                    (0x020000 << BLUE_AESLEPRIVPRANDREG_PRAND_Pos)   /*!<0x00020000 */
#define BLUE_AESLEPRIVPRANDREG_PRAND_18                                    (0x040000 << BLUE_AESLEPRIVPRANDREG_PRAND_Pos)   /*!<0x00040000 */
#define BLUE_AESLEPRIVPRANDREG_PRAND_19                                    (0x080000 << BLUE_AESLEPRIVPRANDREG_PRAND_Pos)   /*!<0x00080000 */
#define BLUE_AESLEPRIVPRANDREG_PRAND_20                                    (0x100000 << BLUE_AESLEPRIVPRANDREG_PRAND_Pos)   /*!<0x00100000 */
#define BLUE_AESLEPRIVPRANDREG_PRAND_21                                    (0x200000 << BLUE_AESLEPRIVPRANDREG_PRAND_Pos)   /*!<0x00200000 */
#define BLUE_AESLEPRIVPRANDREG_PRAND_22                                    (0x400000 << BLUE_AESLEPRIVPRANDREG_PRAND_Pos)   /*!<0x00400000 */
#define BLUE_AESLEPRIVPRANDREG_PRAND_23                                    (0x800000 << BLUE_AESLEPRIVPRANDREG_PRAND_Pos)   /*!<0x00800000 */

/* ===============================================   AESLEPRIVCMDREG   =============================================== */
#define BLUE_AESLEPRIVCMDREG_START_Pos                                     (0UL)   /*!< BLUE AESLEPRIVCMDREG: START (Bit 0) */
#define BLUE_AESLEPRIVCMDREG_START_Msk                                     (0x00000001UL)  /*!< BLUE AESLEPRIVCMDREG: START (Bitfield-Mask: 0x1) */
#define BLUE_AESLEPRIVCMDREG_START                                         BLUE_AESLEPRIVCMDREG_START_Msk
#define BLUE_AESLEPRIVCMDREG_INTENA_Pos                                    (1UL)   /*!< BLUE AESLEPRIVCMDREG: INTENA (Bit 1) */
#define BLUE_AESLEPRIVCMDREG_INTENA_Msk                                    (0x00000002UL)  /*!< BLUE AESLEPRIVCMDREG: INTENA (Bitfield-Mask: 0x1) */
#define BLUE_AESLEPRIVCMDREG_INTENA                                        BLUE_AESLEPRIVCMDREG_INTENA_Msk
#define BLUE_AESLEPRIVCMDREG_NBKEYS_Pos                                    (2UL)   /*!< BLUE AESLEPRIVCMDREG: NBKEYS (Bit 2) */
#define BLUE_AESLEPRIVCMDREG_NBKEYS_Msk                                    (0x000003fcUL)  /*!< BLUE AESLEPRIVCMDREG: NBKEYS (Bitfield-Mask: 0xff) */
#define BLUE_AESLEPRIVCMDREG_NBKEYS                                        BLUE_AESLEPRIVCMDREG_NBKEYS_Msk
#define BLUE_AESLEPRIVCMDREG_NBKEYS_0                                      (0x01 << BLUE_AESLEPRIVCMDREG_NBKEYS_Pos)   /*!<0x00000004 */
#define BLUE_AESLEPRIVCMDREG_NBKEYS_1                                      (0x02 << BLUE_AESLEPRIVCMDREG_NBKEYS_Pos)   /*!<0x00000008 */
#define BLUE_AESLEPRIVCMDREG_NBKEYS_2                                      (0x04 << BLUE_AESLEPRIVCMDREG_NBKEYS_Pos)   /*!<0x00000010 */
#define BLUE_AESLEPRIVCMDREG_NBKEYS_3                                      (0x08 << BLUE_AESLEPRIVCMDREG_NBKEYS_Pos)   /*!<0x00000020 */
#define BLUE_AESLEPRIVCMDREG_NBKEYS_4                                      (0x10 << BLUE_AESLEPRIVCMDREG_NBKEYS_Pos)   /*!<0x00000040 */
#define BLUE_AESLEPRIVCMDREG_NBKEYS_5                                      (0x20 << BLUE_AESLEPRIVCMDREG_NBKEYS_Pos)   /*!<0x00000080 */
#define BLUE_AESLEPRIVCMDREG_NBKEYS_6                                      (0x40 << BLUE_AESLEPRIVCMDREG_NBKEYS_Pos)   /*!<0x00000100 */
#define BLUE_AESLEPRIVCMDREG_NBKEYS_7                                      (0x80 << BLUE_AESLEPRIVCMDREG_NBKEYS_Pos)   /*!<0x00000200 */

/* ===============================================   AESLEPRIVSTATREG   =============================================== */
#define BLUE_AESLEPRIVSTATREG_BUSY_Pos                                     (0UL)   /*!< BLUE AESLEPRIVSTATREG: BUSY (Bit 0) */
#define BLUE_AESLEPRIVSTATREG_BUSY_Msk                                     (0x00000001UL)  /*!< BLUE AESLEPRIVSTATREG: BUSY (Bitfield-Mask: 0x1) */
#define BLUE_AESLEPRIVSTATREG_BUSY                                         BLUE_AESLEPRIVSTATREG_BUSY_Msk
#define BLUE_AESLEPRIVSTATREG_KEYFND_Pos                                   (1UL)   /*!< BLUE AESLEPRIVSTATREG: KEYFND (Bit 1) */
#define BLUE_AESLEPRIVSTATREG_KEYFND_Msk                                   (0x00000002UL)  /*!< BLUE AESLEPRIVSTATREG: KEYFND (Bitfield-Mask: 0x1) */
#define BLUE_AESLEPRIVSTATREG_KEYFND                                       BLUE_AESLEPRIVSTATREG_KEYFND_Msk
#define BLUE_AESLEPRIVSTATREG_KEYFNDINDEX_Pos                              (2UL)   /*!< BLUE AESLEPRIVSTATREG: KEYFNDINDEX (Bit 2) */
#define BLUE_AESLEPRIVSTATREG_KEYFNDINDEX_Msk                              (0x000003fcUL)  /*!< BLUE AESLEPRIVSTATREG: KEYFNDINDEX (Bitfield-Mask: 0xff) */
#define BLUE_AESLEPRIVSTATREG_KEYFNDINDEX                                  BLUE_AESLEPRIVSTATREG_KEYFNDINDEX_Msk
#define BLUE_AESLEPRIVSTATREG_KEYFNDINDEX_0                                (0x01 << BLUE_AESLEPRIVSTATREG_KEYFNDINDEX_Pos)   /*!<0x00000004 */
#define BLUE_AESLEPRIVSTATREG_KEYFNDINDEX_1                                (0x02 << BLUE_AESLEPRIVSTATREG_KEYFNDINDEX_Pos)   /*!<0x00000008 */
#define BLUE_AESLEPRIVSTATREG_KEYFNDINDEX_2                                (0x04 << BLUE_AESLEPRIVSTATREG_KEYFNDINDEX_Pos)   /*!<0x00000010 */
#define BLUE_AESLEPRIVSTATREG_KEYFNDINDEX_3                                (0x08 << BLUE_AESLEPRIVSTATREG_KEYFNDINDEX_Pos)   /*!<0x00000020 */
#define BLUE_AESLEPRIVSTATREG_KEYFNDINDEX_4                                (0x10 << BLUE_AESLEPRIVSTATREG_KEYFNDINDEX_Pos)   /*!<0x00000040 */
#define BLUE_AESLEPRIVSTATREG_KEYFNDINDEX_5                                (0x20 << BLUE_AESLEPRIVSTATREG_KEYFNDINDEX_Pos)   /*!<0x00000080 */
#define BLUE_AESLEPRIVSTATREG_KEYFNDINDEX_6                                (0x40 << BLUE_AESLEPRIVSTATREG_KEYFNDINDEX_Pos)   /*!<0x00000100 */
#define BLUE_AESLEPRIVSTATREG_KEYFNDINDEX_7                                (0x80 << BLUE_AESLEPRIVSTATREG_KEYFNDINDEX_Pos)   /*!<0x00000200 */

/* ===============================================   DEBUGCMDREG   =============================================== */
#define BLUE_DEBUGCMDREG_CLEARDEBUGINT_Pos                                 (0UL)   /*!< BLUE DEBUGCMDREG: CLEARDEBUGINT (Bit 0) */
#define BLUE_DEBUGCMDREG_CLEARDEBUGINT_Msk                                 (0x00000001UL)  /*!< BLUE DEBUGCMDREG: CLEARDEBUGINT (Bitfield-Mask: 0x1) */
#define BLUE_DEBUGCMDREG_CLEARDEBUGINT                                     BLUE_DEBUGCMDREG_CLEARDEBUGINT_Msk
#define BLUE_DEBUGCMDREG_SEQDEBUGMODE_Pos                                  (1UL)   /*!< BLUE DEBUGCMDREG: SEQDEBUGMODE (Bit 1) */
#define BLUE_DEBUGCMDREG_SEQDEBUGMODE_Msk                                  (0x00000002UL)  /*!< BLUE DEBUGCMDREG: SEQDEBUGMODE (Bitfield-Mask: 0x1) */
#define BLUE_DEBUGCMDREG_SEQDEBUGMODE                                      BLUE_DEBUGCMDREG_SEQDEBUGMODE_Msk
#define BLUE_DEBUGCMDREG_SEQDEBUGBUSSEL_Pos                                (2UL)   /*!< BLUE DEBUGCMDREG: SEQDEBUGBUSSEL (Bit 2) */
#define BLUE_DEBUGCMDREG_SEQDEBUGBUSSEL_Msk                                (0x0000003cUL)  /*!< BLUE DEBUGCMDREG: SEQDEBUGBUSSEL (Bitfield-Mask: 0xf) */
#define BLUE_DEBUGCMDREG_SEQDEBUGBUSSEL                                    BLUE_DEBUGCMDREG_SEQDEBUGBUSSEL_Msk
#define BLUE_DEBUGCMDREG_SEQDEBUGBUSSEL_0                                  (0x1 << BLUE_DEBUGCMDREG_SEQDEBUGBUSSEL_Pos)   /*!<0x00000004 */
#define BLUE_DEBUGCMDREG_SEQDEBUGBUSSEL_1                                  (0x2 << BLUE_DEBUGCMDREG_SEQDEBUGBUSSEL_Pos)   /*!<0x00000008 */
#define BLUE_DEBUGCMDREG_SEQDEBUGBUSSEL_2                                  (0x4 << BLUE_DEBUGCMDREG_SEQDEBUGBUSSEL_Pos)   /*!<0x00000010 */
#define BLUE_DEBUGCMDREG_SEQDEBUGBUSSEL_3                                  (0x8 << BLUE_DEBUGCMDREG_SEQDEBUGBUSSEL_Pos)   /*!<0x00000020 */
#define BLUE_DEBUGCMDREG_AESDEBUGMODE_Pos                                  (16UL)   /*!< BLUE DEBUGCMDREG: AESDEBUGMODE (Bit 16) */
#define BLUE_DEBUGCMDREG_AESDEBUGMODE_Msk                                  (0x000f0000UL)  /*!< BLUE DEBUGCMDREG: AESDEBUGMODE (Bitfield-Mask: 0xf) */
#define BLUE_DEBUGCMDREG_AESDEBUGMODE                                      BLUE_DEBUGCMDREG_AESDEBUGMODE_Msk
#define BLUE_DEBUGCMDREG_AESDEBUGMODE_0                                    (0x1 << BLUE_DEBUGCMDREG_AESDEBUGMODE_Pos)   /*!<0x00010000 */
#define BLUE_DEBUGCMDREG_AESDEBUGMODE_1                                    (0x2 << BLUE_DEBUGCMDREG_AESDEBUGMODE_Pos)   /*!<0x00020000 */
#define BLUE_DEBUGCMDREG_AESDEBUGMODE_2                                    (0x4 << BLUE_DEBUGCMDREG_AESDEBUGMODE_Pos)   /*!<0x00040000 */
#define BLUE_DEBUGCMDREG_AESDEBUGMODE_3                                    (0x8 << BLUE_DEBUGCMDREG_AESDEBUGMODE_Pos)   /*!<0x00080000 */

/* ===============================================   DEBUGSTATUSREG   =============================================== */
#define BLUE_DEBUGSTATUSREG_SEQERROR_0_Pos                                 (0UL)   /*!< BLUE DEBUGSTATUSREG: SEQERROR_0 (Bit 0) */
#define BLUE_DEBUGSTATUSREG_SEQERROR_0_Msk                                 (0x00000001UL)  /*!< BLUE DEBUGSTATUSREG: SEQERROR_0 (Bitfield-Mask: 0x1) */
#define BLUE_DEBUGSTATUSREG_SEQERROR_0                                     BLUE_DEBUGSTATUSREG_SEQERROR_0_Msk
#define BLUE_DEBUGSTATUSREG_SEQERROR_1_Pos                                 (1UL)   /*!< BLUE DEBUGSTATUSREG: SEQERROR_1 (Bit 1) */
#define BLUE_DEBUGSTATUSREG_SEQERROR_1_Msk                                 (0x00000002UL)  /*!< BLUE DEBUGSTATUSREG: SEQERROR_1 (Bitfield-Mask: 0x1) */
#define BLUE_DEBUGSTATUSREG_SEQERROR_1                                     BLUE_DEBUGSTATUSREG_SEQERROR_1_Msk
#define BLUE_DEBUGSTATUSREG_SEQERROR_2_Pos                                 (2UL)   /*!< BLUE DEBUGSTATUSREG: SEQERROR_2 (Bit 2) */
#define BLUE_DEBUGSTATUSREG_SEQERROR_2_Msk                                 (0x00000004UL)  /*!< BLUE DEBUGSTATUSREG: SEQERROR_2 (Bitfield-Mask: 0x1) */
#define BLUE_DEBUGSTATUSREG_SEQERROR_2                                     BLUE_DEBUGSTATUSREG_SEQERROR_2_Msk
#define BLUE_DEBUGSTATUSREG_SEQERROR_3_Pos                                 (3UL)   /*!< BLUE DEBUGSTATUSREG: SEQERROR_3 (Bit 3) */
#define BLUE_DEBUGSTATUSREG_SEQERROR_3_Msk                                 (0x00000008UL)  /*!< BLUE DEBUGSTATUSREG: SEQERROR_3 (Bitfield-Mask: 0x1) */
#define BLUE_DEBUGSTATUSREG_SEQERROR_3                                     BLUE_DEBUGSTATUSREG_SEQERROR_3_Msk
#define BLUE_DEBUGSTATUSREG_SEQERROR_4_Pos                                 (4UL)   /*!< BLUE DEBUGSTATUSREG: SEQERROR_4 (Bit 4) */
#define BLUE_DEBUGSTATUSREG_SEQERROR_4_Msk                                 (0x00000010UL)  /*!< BLUE DEBUGSTATUSREG: SEQERROR_4 (Bitfield-Mask: 0x1) */
#define BLUE_DEBUGSTATUSREG_SEQERROR_4                                     BLUE_DEBUGSTATUSREG_SEQERROR_4_Msk
#define BLUE_DEBUGSTATUSREG_SEQERROR_5_Pos                                 (5UL)   /*!< BLUE DEBUGSTATUSREG: SEQERROR_5 (Bit 5) */
#define BLUE_DEBUGSTATUSREG_SEQERROR_5_Msk                                 (0x00000020UL)  /*!< BLUE DEBUGSTATUSREG: SEQERROR_5 (Bitfield-Mask: 0x1) */
#define BLUE_DEBUGSTATUSREG_SEQERROR_5                                     BLUE_DEBUGSTATUSREG_SEQERROR_5_Msk
#define BLUE_DEBUGSTATUSREG_AESDBG_0_Pos                                   (16UL)   /*!< BLUE DEBUGSTATUSREG: AESDBG_0 (Bit 16) */
#define BLUE_DEBUGSTATUSREG_AESDBG_0_Msk                                   (0x00010000UL)  /*!< BLUE DEBUGSTATUSREG: AESDBG_0 (Bitfield-Mask: 0x1) */
#define BLUE_DEBUGSTATUSREG_AESDBG_0                                       BLUE_DEBUGSTATUSREG_AESDBG_0_Msk
#define BLUE_DEBUGSTATUSREG_AESDBG_1_Pos                                   (17UL)   /*!< BLUE DEBUGSTATUSREG: AESDBG_1 (Bit 17) */
#define BLUE_DEBUGSTATUSREG_AESDBG_1_Msk                                   (0x00020000UL)  /*!< BLUE DEBUGSTATUSREG: AESDBG_1 (Bitfield-Mask: 0x1) */
#define BLUE_DEBUGSTATUSREG_AESDBG_1                                       BLUE_DEBUGSTATUSREG_AESDBG_1_Msk
#define BLUE_DEBUGSTATUSREG_AESDBG_2_Pos                                   (18UL)   /*!< BLUE DEBUGSTATUSREG: AESDBG_2 (Bit 18) */
#define BLUE_DEBUGSTATUSREG_AESDBG_2_Msk                                   (0x00040000UL)  /*!< BLUE DEBUGSTATUSREG: AESDBG_2 (Bitfield-Mask: 0x1) */
#define BLUE_DEBUGSTATUSREG_AESDBG_2                                       BLUE_DEBUGSTATUSREG_AESDBG_2_Msk
#define BLUE_DEBUGSTATUSREG_AESDBG_3_Pos                                   (19UL)   /*!< BLUE DEBUGSTATUSREG: AESDBG_3 (Bit 19) */
#define BLUE_DEBUGSTATUSREG_AESDBG_3_Msk                                   (0x00080000UL)  /*!< BLUE DEBUGSTATUSREG: AESDBG_3 (Bitfield-Mask: 0x1) */
#define BLUE_DEBUGSTATUSREG_AESDBG_3                                       BLUE_DEBUGSTATUSREG_AESDBG_3_Msk





/* =========================================================================================================================== */
/* ================                                     WAKEUP                                                ================ */
/* =========================================================================================================================== */


/* ===============================================   WAKEUP_BLOCK_VERSION   =============================================== */
#define WAKEUP_WAKEUP_BLOCK_VERSION_SUB_VERSION_Pos                        (0UL)   /*!< WAKEUP WAKEUP_BLOCK_VERSION: SUB_VERSION (Bit 0) */
#define WAKEUP_WAKEUP_BLOCK_VERSION_SUB_VERSION_Msk                        (0x000000ffUL)  /*!< WAKEUP WAKEUP_BLOCK_VERSION: SUB_VERSION (Bitfield-Mask: 0xff) */
#define WAKEUP_WAKEUP_BLOCK_VERSION_SUB_VERSION                            WAKEUP_WAKEUP_BLOCK_VERSION_SUB_VERSION_Msk
#define WAKEUP_WAKEUP_BLOCK_VERSION_SUB_VERSION_0                          (0x01 << WAKEUP_WAKEUP_BLOCK_VERSION_SUB_VERSION_Pos)   /*!<0x00000001 */
#define WAKEUP_WAKEUP_BLOCK_VERSION_SUB_VERSION_1                          (0x02 << WAKEUP_WAKEUP_BLOCK_VERSION_SUB_VERSION_Pos)   /*!<0x00000002 */
#define WAKEUP_WAKEUP_BLOCK_VERSION_SUB_VERSION_2                          (0x04 << WAKEUP_WAKEUP_BLOCK_VERSION_SUB_VERSION_Pos)   /*!<0x00000004 */
#define WAKEUP_WAKEUP_BLOCK_VERSION_SUB_VERSION_3                          (0x08 << WAKEUP_WAKEUP_BLOCK_VERSION_SUB_VERSION_Pos)   /*!<0x00000008 */
#define WAKEUP_WAKEUP_BLOCK_VERSION_SUB_VERSION_4                          (0x10 << WAKEUP_WAKEUP_BLOCK_VERSION_SUB_VERSION_Pos)   /*!<0x00000010 */
#define WAKEUP_WAKEUP_BLOCK_VERSION_SUB_VERSION_5                          (0x20 << WAKEUP_WAKEUP_BLOCK_VERSION_SUB_VERSION_Pos)   /*!<0x00000020 */
#define WAKEUP_WAKEUP_BLOCK_VERSION_SUB_VERSION_6                          (0x40 << WAKEUP_WAKEUP_BLOCK_VERSION_SUB_VERSION_Pos)   /*!<0x00000040 */
#define WAKEUP_WAKEUP_BLOCK_VERSION_SUB_VERSION_7                          (0x80 << WAKEUP_WAKEUP_BLOCK_VERSION_SUB_VERSION_Pos)   /*!<0x00000080 */
#define WAKEUP_WAKEUP_BLOCK_VERSION_VERSION_NUMBER_Pos                     (8UL)   /*!< WAKEUP WAKEUP_BLOCK_VERSION: VERSION_NUMBER (Bit 8) */
#define WAKEUP_WAKEUP_BLOCK_VERSION_VERSION_NUMBER_Msk                     (0x0000ff00UL)  /*!< WAKEUP WAKEUP_BLOCK_VERSION: VERSION_NUMBER (Bitfield-Mask: 0xff) */
#define WAKEUP_WAKEUP_BLOCK_VERSION_VERSION_NUMBER                         WAKEUP_WAKEUP_BLOCK_VERSION_VERSION_NUMBER_Msk
#define WAKEUP_WAKEUP_BLOCK_VERSION_VERSION_NUMBER_0                       (0x01 << WAKEUP_WAKEUP_BLOCK_VERSION_VERSION_NUMBER_Pos)   /*!<0x00000100 */
#define WAKEUP_WAKEUP_BLOCK_VERSION_VERSION_NUMBER_1                       (0x02 << WAKEUP_WAKEUP_BLOCK_VERSION_VERSION_NUMBER_Pos)   /*!<0x00000200 */
#define WAKEUP_WAKEUP_BLOCK_VERSION_VERSION_NUMBER_2                       (0x04 << WAKEUP_WAKEUP_BLOCK_VERSION_VERSION_NUMBER_Pos)   /*!<0x00000400 */
#define WAKEUP_WAKEUP_BLOCK_VERSION_VERSION_NUMBER_3                       (0x08 << WAKEUP_WAKEUP_BLOCK_VERSION_VERSION_NUMBER_Pos)   /*!<0x00000800 */
#define WAKEUP_WAKEUP_BLOCK_VERSION_VERSION_NUMBER_4                       (0x10 << WAKEUP_WAKEUP_BLOCK_VERSION_VERSION_NUMBER_Pos)   /*!<0x00001000 */
#define WAKEUP_WAKEUP_BLOCK_VERSION_VERSION_NUMBER_5                       (0x20 << WAKEUP_WAKEUP_BLOCK_VERSION_VERSION_NUMBER_Pos)   /*!<0x00002000 */
#define WAKEUP_WAKEUP_BLOCK_VERSION_VERSION_NUMBER_6                       (0x40 << WAKEUP_WAKEUP_BLOCK_VERSION_VERSION_NUMBER_Pos)   /*!<0x00004000 */
#define WAKEUP_WAKEUP_BLOCK_VERSION_VERSION_NUMBER_7                       (0x80 << WAKEUP_WAKEUP_BLOCK_VERSION_VERSION_NUMBER_Pos)   /*!<0x00008000 */

/* ===============================================   WAKEUP_OFFSET_1   =============================================== */
#define WAKEUP_WAKEUP_OFFSET_1_MODE0_Pos                                   (0UL)   /*!< WAKEUP WAKEUP_OFFSET_1: MODE0 (Bit 0) */
#define WAKEUP_WAKEUP_OFFSET_1_MODE0_Msk                                   (0x000000ffUL)  /*!< WAKEUP WAKEUP_OFFSET_1: MODE0 (Bitfield-Mask: 0xff) */
#define WAKEUP_WAKEUP_OFFSET_1_MODE0                                       WAKEUP_WAKEUP_OFFSET_1_MODE0_Msk
#define WAKEUP_WAKEUP_OFFSET_1_MODE0_0                                     (0x01 << WAKEUP_WAKEUP_OFFSET_1_MODE0_Pos)   /*!<0x00000001 */
#define WAKEUP_WAKEUP_OFFSET_1_MODE0_1                                     (0x02 << WAKEUP_WAKEUP_OFFSET_1_MODE0_Pos)   /*!<0x00000002 */
#define WAKEUP_WAKEUP_OFFSET_1_MODE0_2                                     (0x04 << WAKEUP_WAKEUP_OFFSET_1_MODE0_Pos)   /*!<0x00000004 */
#define WAKEUP_WAKEUP_OFFSET_1_MODE0_3                                     (0x08 << WAKEUP_WAKEUP_OFFSET_1_MODE0_Pos)   /*!<0x00000008 */
#define WAKEUP_WAKEUP_OFFSET_1_MODE0_4                                     (0x10 << WAKEUP_WAKEUP_OFFSET_1_MODE0_Pos)   /*!<0x00000010 */
#define WAKEUP_WAKEUP_OFFSET_1_MODE0_5                                     (0x20 << WAKEUP_WAKEUP_OFFSET_1_MODE0_Pos)   /*!<0x00000020 */
#define WAKEUP_WAKEUP_OFFSET_1_MODE0_6                                     (0x40 << WAKEUP_WAKEUP_OFFSET_1_MODE0_Pos)   /*!<0x00000040 */
#define WAKEUP_WAKEUP_OFFSET_1_MODE0_7                                     (0x80 << WAKEUP_WAKEUP_OFFSET_1_MODE0_Pos)   /*!<0x00000080 */
#define WAKEUP_WAKEUP_OFFSET_1_MODE1_Pos                                   (8UL)   /*!< WAKEUP WAKEUP_OFFSET_1: MODE1 (Bit 8) */
#define WAKEUP_WAKEUP_OFFSET_1_MODE1_Msk                                   (0x0000ff00UL)  /*!< WAKEUP WAKEUP_OFFSET_1: MODE1 (Bitfield-Mask: 0xff) */
#define WAKEUP_WAKEUP_OFFSET_1_MODE1                                       WAKEUP_WAKEUP_OFFSET_1_MODE1_Msk
#define WAKEUP_WAKEUP_OFFSET_1_MODE1_0                                     (0x01 << WAKEUP_WAKEUP_OFFSET_1_MODE1_Pos)   /*!<0x00000100 */
#define WAKEUP_WAKEUP_OFFSET_1_MODE1_1                                     (0x02 << WAKEUP_WAKEUP_OFFSET_1_MODE1_Pos)   /*!<0x00000200 */
#define WAKEUP_WAKEUP_OFFSET_1_MODE1_2                                     (0x04 << WAKEUP_WAKEUP_OFFSET_1_MODE1_Pos)   /*!<0x00000400 */
#define WAKEUP_WAKEUP_OFFSET_1_MODE1_3                                     (0x08 << WAKEUP_WAKEUP_OFFSET_1_MODE1_Pos)   /*!<0x00000800 */
#define WAKEUP_WAKEUP_OFFSET_1_MODE1_4                                     (0x10 << WAKEUP_WAKEUP_OFFSET_1_MODE1_Pos)   /*!<0x00001000 */
#define WAKEUP_WAKEUP_OFFSET_1_MODE1_5                                     (0x20 << WAKEUP_WAKEUP_OFFSET_1_MODE1_Pos)   /*!<0x00002000 */
#define WAKEUP_WAKEUP_OFFSET_1_MODE1_6                                     (0x40 << WAKEUP_WAKEUP_OFFSET_1_MODE1_Pos)   /*!<0x00004000 */
#define WAKEUP_WAKEUP_OFFSET_1_MODE1_7                                     (0x80 << WAKEUP_WAKEUP_OFFSET_1_MODE1_Pos)   /*!<0x00008000 */
#define WAKEUP_WAKEUP_OFFSET_1_MODE2_Pos                                   (16UL)   /*!< WAKEUP WAKEUP_OFFSET_1: MODE2 (Bit 16) */
#define WAKEUP_WAKEUP_OFFSET_1_MODE2_Msk                                   (0x00ff0000UL)  /*!< WAKEUP WAKEUP_OFFSET_1: MODE2 (Bitfield-Mask: 0xff) */
#define WAKEUP_WAKEUP_OFFSET_1_MODE2                                       WAKEUP_WAKEUP_OFFSET_1_MODE2_Msk
#define WAKEUP_WAKEUP_OFFSET_1_MODE2_0                                     (0x01 << WAKEUP_WAKEUP_OFFSET_1_MODE2_Pos)   /*!<0x00010000 */
#define WAKEUP_WAKEUP_OFFSET_1_MODE2_1                                     (0x02 << WAKEUP_WAKEUP_OFFSET_1_MODE2_Pos)   /*!<0x00020000 */
#define WAKEUP_WAKEUP_OFFSET_1_MODE2_2                                     (0x04 << WAKEUP_WAKEUP_OFFSET_1_MODE2_Pos)   /*!<0x00040000 */
#define WAKEUP_WAKEUP_OFFSET_1_MODE2_3                                     (0x08 << WAKEUP_WAKEUP_OFFSET_1_MODE2_Pos)   /*!<0x00080000 */
#define WAKEUP_WAKEUP_OFFSET_1_MODE2_4                                     (0x10 << WAKEUP_WAKEUP_OFFSET_1_MODE2_Pos)   /*!<0x00100000 */
#define WAKEUP_WAKEUP_OFFSET_1_MODE2_5                                     (0x20 << WAKEUP_WAKEUP_OFFSET_1_MODE2_Pos)   /*!<0x00200000 */
#define WAKEUP_WAKEUP_OFFSET_1_MODE2_6                                     (0x40 << WAKEUP_WAKEUP_OFFSET_1_MODE2_Pos)   /*!<0x00400000 */
#define WAKEUP_WAKEUP_OFFSET_1_MODE2_7                                     (0x80 << WAKEUP_WAKEUP_OFFSET_1_MODE2_Pos)   /*!<0x00800000 */
#define WAKEUP_WAKEUP_OFFSET_1_MODE3_Pos                                   (24UL)   /*!< WAKEUP WAKEUP_OFFSET_1: MODE3 (Bit 24) */
#define WAKEUP_WAKEUP_OFFSET_1_MODE3_Msk                                   (0xff000000UL)  /*!< WAKEUP WAKEUP_OFFSET_1: MODE3 (Bitfield-Mask: 0xff) */
#define WAKEUP_WAKEUP_OFFSET_1_MODE3                                       WAKEUP_WAKEUP_OFFSET_1_MODE3_Msk
#define WAKEUP_WAKEUP_OFFSET_1_MODE3_0                                     (0x01 << WAKEUP_WAKEUP_OFFSET_1_MODE3_Pos)   /*!<0x01000000 */
#define WAKEUP_WAKEUP_OFFSET_1_MODE3_1                                     (0x02 << WAKEUP_WAKEUP_OFFSET_1_MODE3_Pos)   /*!<0x02000000 */
#define WAKEUP_WAKEUP_OFFSET_1_MODE3_2                                     (0x04 << WAKEUP_WAKEUP_OFFSET_1_MODE3_Pos)   /*!<0x04000000 */
#define WAKEUP_WAKEUP_OFFSET_1_MODE3_3                                     (0x08 << WAKEUP_WAKEUP_OFFSET_1_MODE3_Pos)   /*!<0x08000000 */
#define WAKEUP_WAKEUP_OFFSET_1_MODE3_4                                     (0x10 << WAKEUP_WAKEUP_OFFSET_1_MODE3_Pos)   /*!<0x10000000 */
#define WAKEUP_WAKEUP_OFFSET_1_MODE3_5                                     (0x20 << WAKEUP_WAKEUP_OFFSET_1_MODE3_Pos)   /*!<0x20000000 */
#define WAKEUP_WAKEUP_OFFSET_1_MODE3_6                                     (0x40 << WAKEUP_WAKEUP_OFFSET_1_MODE3_Pos)   /*!<0x40000000 */
#define WAKEUP_WAKEUP_OFFSET_1_MODE3_7                                     (0x80 << WAKEUP_WAKEUP_OFFSET_1_MODE3_Pos)   /*!<0x80000000 */

/* ===============================================   WAKEUP_OFFSET_2   =============================================== */
#define WAKEUP_WAKEUP_OFFSET_2_MODE4_Pos                                   (0UL)   /*!< WAKEUP WAKEUP_OFFSET_2: MODE4 (Bit 0) */
#define WAKEUP_WAKEUP_OFFSET_2_MODE4_Msk                                   (0x000000ffUL)  /*!< WAKEUP WAKEUP_OFFSET_2: MODE4 (Bitfield-Mask: 0xff) */
#define WAKEUP_WAKEUP_OFFSET_2_MODE4                                       WAKEUP_WAKEUP_OFFSET_2_MODE4_Msk
#define WAKEUP_WAKEUP_OFFSET_2_MODE4_0                                     (0x01 << WAKEUP_WAKEUP_OFFSET_2_MODE4_Pos)   /*!<0x00000001 */
#define WAKEUP_WAKEUP_OFFSET_2_MODE4_1                                     (0x02 << WAKEUP_WAKEUP_OFFSET_2_MODE4_Pos)   /*!<0x00000002 */
#define WAKEUP_WAKEUP_OFFSET_2_MODE4_2                                     (0x04 << WAKEUP_WAKEUP_OFFSET_2_MODE4_Pos)   /*!<0x00000004 */
#define WAKEUP_WAKEUP_OFFSET_2_MODE4_3                                     (0x08 << WAKEUP_WAKEUP_OFFSET_2_MODE4_Pos)   /*!<0x00000008 */
#define WAKEUP_WAKEUP_OFFSET_2_MODE4_4                                     (0x10 << WAKEUP_WAKEUP_OFFSET_2_MODE4_Pos)   /*!<0x00000010 */
#define WAKEUP_WAKEUP_OFFSET_2_MODE4_5                                     (0x20 << WAKEUP_WAKEUP_OFFSET_2_MODE4_Pos)   /*!<0x00000020 */
#define WAKEUP_WAKEUP_OFFSET_2_MODE4_6                                     (0x40 << WAKEUP_WAKEUP_OFFSET_2_MODE4_Pos)   /*!<0x00000040 */
#define WAKEUP_WAKEUP_OFFSET_2_MODE4_7                                     (0x80 << WAKEUP_WAKEUP_OFFSET_2_MODE4_Pos)   /*!<0x00000080 */
#define WAKEUP_WAKEUP_OFFSET_2_MODE5_Pos                                   (8UL)   /*!< WAKEUP WAKEUP_OFFSET_2: MODE5 (Bit 8) */
#define WAKEUP_WAKEUP_OFFSET_2_MODE5_Msk                                   (0x0000ff00UL)  /*!< WAKEUP WAKEUP_OFFSET_2: MODE5 (Bitfield-Mask: 0xff) */
#define WAKEUP_WAKEUP_OFFSET_2_MODE5                                       WAKEUP_WAKEUP_OFFSET_2_MODE5_Msk
#define WAKEUP_WAKEUP_OFFSET_2_MODE5_0                                     (0x01 << WAKEUP_WAKEUP_OFFSET_2_MODE5_Pos)   /*!<0x00000100 */
#define WAKEUP_WAKEUP_OFFSET_2_MODE5_1                                     (0x02 << WAKEUP_WAKEUP_OFFSET_2_MODE5_Pos)   /*!<0x00000200 */
#define WAKEUP_WAKEUP_OFFSET_2_MODE5_2                                     (0x04 << WAKEUP_WAKEUP_OFFSET_2_MODE5_Pos)   /*!<0x00000400 */
#define WAKEUP_WAKEUP_OFFSET_2_MODE5_3                                     (0x08 << WAKEUP_WAKEUP_OFFSET_2_MODE5_Pos)   /*!<0x00000800 */
#define WAKEUP_WAKEUP_OFFSET_2_MODE5_4                                     (0x10 << WAKEUP_WAKEUP_OFFSET_2_MODE5_Pos)   /*!<0x00001000 */
#define WAKEUP_WAKEUP_OFFSET_2_MODE5_5                                     (0x20 << WAKEUP_WAKEUP_OFFSET_2_MODE5_Pos)   /*!<0x00002000 */
#define WAKEUP_WAKEUP_OFFSET_2_MODE5_6                                     (0x40 << WAKEUP_WAKEUP_OFFSET_2_MODE5_Pos)   /*!<0x00004000 */
#define WAKEUP_WAKEUP_OFFSET_2_MODE5_7                                     (0x80 << WAKEUP_WAKEUP_OFFSET_2_MODE5_Pos)   /*!<0x00008000 */
#define WAKEUP_WAKEUP_OFFSET_2_MODE6_Pos                                   (16UL)   /*!< WAKEUP WAKEUP_OFFSET_2: MODE6 (Bit 16) */
#define WAKEUP_WAKEUP_OFFSET_2_MODE6_Msk                                   (0x00ff0000UL)  /*!< WAKEUP WAKEUP_OFFSET_2: MODE6 (Bitfield-Mask: 0xff) */
#define WAKEUP_WAKEUP_OFFSET_2_MODE6                                       WAKEUP_WAKEUP_OFFSET_2_MODE6_Msk
#define WAKEUP_WAKEUP_OFFSET_2_MODE6_0                                     (0x01 << WAKEUP_WAKEUP_OFFSET_2_MODE6_Pos)   /*!<0x00010000 */
#define WAKEUP_WAKEUP_OFFSET_2_MODE6_1                                     (0x02 << WAKEUP_WAKEUP_OFFSET_2_MODE6_Pos)   /*!<0x00020000 */
#define WAKEUP_WAKEUP_OFFSET_2_MODE6_2                                     (0x04 << WAKEUP_WAKEUP_OFFSET_2_MODE6_Pos)   /*!<0x00040000 */
#define WAKEUP_WAKEUP_OFFSET_2_MODE6_3                                     (0x08 << WAKEUP_WAKEUP_OFFSET_2_MODE6_Pos)   /*!<0x00080000 */
#define WAKEUP_WAKEUP_OFFSET_2_MODE6_4                                     (0x10 << WAKEUP_WAKEUP_OFFSET_2_MODE6_Pos)   /*!<0x00100000 */
#define WAKEUP_WAKEUP_OFFSET_2_MODE6_5                                     (0x20 << WAKEUP_WAKEUP_OFFSET_2_MODE6_Pos)   /*!<0x00200000 */
#define WAKEUP_WAKEUP_OFFSET_2_MODE6_6                                     (0x40 << WAKEUP_WAKEUP_OFFSET_2_MODE6_Pos)   /*!<0x00400000 */
#define WAKEUP_WAKEUP_OFFSET_2_MODE6_7                                     (0x80 << WAKEUP_WAKEUP_OFFSET_2_MODE6_Pos)   /*!<0x00800000 */
#define WAKEUP_WAKEUP_OFFSET_2_MODE7_Pos                                   (24UL)   /*!< WAKEUP WAKEUP_OFFSET_2: MODE7 (Bit 24) */
#define WAKEUP_WAKEUP_OFFSET_2_MODE7_Msk                                   (0xff000000UL)  /*!< WAKEUP WAKEUP_OFFSET_2: MODE7 (Bitfield-Mask: 0xff) */
#define WAKEUP_WAKEUP_OFFSET_2_MODE7                                       WAKEUP_WAKEUP_OFFSET_2_MODE7_Msk
#define WAKEUP_WAKEUP_OFFSET_2_MODE7_0                                     (0x01 << WAKEUP_WAKEUP_OFFSET_2_MODE7_Pos)   /*!<0x01000000 */
#define WAKEUP_WAKEUP_OFFSET_2_MODE7_1                                     (0x02 << WAKEUP_WAKEUP_OFFSET_2_MODE7_Pos)   /*!<0x02000000 */
#define WAKEUP_WAKEUP_OFFSET_2_MODE7_2                                     (0x04 << WAKEUP_WAKEUP_OFFSET_2_MODE7_Pos)   /*!<0x04000000 */
#define WAKEUP_WAKEUP_OFFSET_2_MODE7_3                                     (0x08 << WAKEUP_WAKEUP_OFFSET_2_MODE7_Pos)   /*!<0x08000000 */
#define WAKEUP_WAKEUP_OFFSET_2_MODE7_4                                     (0x10 << WAKEUP_WAKEUP_OFFSET_2_MODE7_Pos)   /*!<0x10000000 */
#define WAKEUP_WAKEUP_OFFSET_2_MODE7_5                                     (0x20 << WAKEUP_WAKEUP_OFFSET_2_MODE7_Pos)   /*!<0x20000000 */
#define WAKEUP_WAKEUP_OFFSET_2_MODE7_6                                     (0x40 << WAKEUP_WAKEUP_OFFSET_2_MODE7_Pos)   /*!<0x40000000 */
#define WAKEUP_WAKEUP_OFFSET_2_MODE7_7                                     (0x80 << WAKEUP_WAKEUP_OFFSET_2_MODE7_Pos)   /*!<0x80000000 */

/* ===============================================   ABSOLUTE_TIME   =============================================== */
#define WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_Pos                             (0UL)   /*!< WAKEUP ABSOLUTE_TIME: ABSOLUTE_TIME (Bit 0) */
#define WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_Msk                             (0xffffffffUL)  /*!< WAKEUP ABSOLUTE_TIME: ABSOLUTE_TIME (Bitfield-Mask: 0xffffffffL) */
#define WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME                                 WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_Msk
#define WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_0                               (0x00000001 << WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_Pos)   /*!<0x00000001 */
#define WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_1                               (0x00000002 << WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_Pos)   /*!<0x00000002 */
#define WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_2                               (0x00000004 << WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_Pos)   /*!<0x00000004 */
#define WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_3                               (0x00000008 << WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_Pos)   /*!<0x00000008 */
#define WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_4                               (0x00000010 << WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_Pos)   /*!<0x00000010 */
#define WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_5                               (0x00000020 << WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_Pos)   /*!<0x00000020 */
#define WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_6                               (0x00000040 << WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_Pos)   /*!<0x00000040 */
#define WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_7                               (0x00000080 << WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_Pos)   /*!<0x00000080 */
#define WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_8                               (0x00000100 << WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_Pos)   /*!<0x00000100 */
#define WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_9                               (0x00000200 << WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_Pos)   /*!<0x00000200 */
#define WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_10                              (0x00000400 << WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_Pos)   /*!<0x00000400 */
#define WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_11                              (0x00000800 << WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_Pos)   /*!<0x00000800 */
#define WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_12                              (0x00001000 << WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_Pos)   /*!<0x00001000 */
#define WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_13                              (0x00002000 << WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_Pos)   /*!<0x00002000 */
#define WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_14                              (0x00004000 << WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_Pos)   /*!<0x00004000 */
#define WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_15                              (0x00008000 << WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_Pos)   /*!<0x00008000 */
#define WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_16                              (0x00010000 << WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_Pos)   /*!<0x00010000 */
#define WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_17                              (0x00020000 << WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_Pos)   /*!<0x00020000 */
#define WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_18                              (0x00040000 << WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_Pos)   /*!<0x00040000 */
#define WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_19                              (0x00080000 << WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_Pos)   /*!<0x00080000 */
#define WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_20                              (0x00100000 << WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_Pos)   /*!<0x00100000 */
#define WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_21                              (0x00200000 << WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_Pos)   /*!<0x00200000 */
#define WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_22                              (0x00400000 << WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_Pos)   /*!<0x00400000 */
#define WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_23                              (0x00800000 << WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_Pos)   /*!<0x00800000 */
#define WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_24                              (0x01000000 << WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_Pos)   /*!<0x01000000 */
#define WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_25                              (0x02000000 << WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_Pos)   /*!<0x02000000 */
#define WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_26                              (0x04000000 << WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_Pos)   /*!<0x04000000 */
#define WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_27                              (0x08000000 << WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_Pos)   /*!<0x08000000 */
#define WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_28                              (0x10000000 << WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_Pos)   /*!<0x10000000 */
#define WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_29                              (0x20000000 << WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_Pos)   /*!<0x20000000 */
#define WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_30                              (0x40000000 << WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_Pos)   /*!<0x40000000 */
#define WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_31                              (0x80000000 << WAKEUP_ABSOLUTE_TIME_ABSOLUTE_TIME_Pos)   /*!<0x80000000 */

/* ===============================================   MINIMUM_PERIOD_LENGTH   =============================================== */
#define WAKEUP_MINIMUM_PERIOD_LENGTH_LENGTH_Pos                            (4UL)   /*!< WAKEUP MINIMUM_PERIOD_LENGTH: LENGTH (Bit 4) */
#define WAKEUP_MINIMUM_PERIOD_LENGTH_LENGTH_Msk                            (0x00003ff0UL)  /*!< WAKEUP MINIMUM_PERIOD_LENGTH: LENGTH (Bitfield-Mask: 0x3ff) */
#define WAKEUP_MINIMUM_PERIOD_LENGTH_LENGTH                                WAKEUP_MINIMUM_PERIOD_LENGTH_LENGTH_Msk
#define WAKEUP_MINIMUM_PERIOD_LENGTH_LENGTH_0                              (0x01 << WAKEUP_MINIMUM_PERIOD_LENGTH_LENGTH_Pos)   /*!<0x00000010 */
#define WAKEUP_MINIMUM_PERIOD_LENGTH_LENGTH_1                              (0x02 << WAKEUP_MINIMUM_PERIOD_LENGTH_LENGTH_Pos)   /*!<0x00000020 */
#define WAKEUP_MINIMUM_PERIOD_LENGTH_LENGTH_2                              (0x04 << WAKEUP_MINIMUM_PERIOD_LENGTH_LENGTH_Pos)   /*!<0x00000040 */
#define WAKEUP_MINIMUM_PERIOD_LENGTH_LENGTH_3                              (0x08 << WAKEUP_MINIMUM_PERIOD_LENGTH_LENGTH_Pos)   /*!<0x00000080 */
#define WAKEUP_MINIMUM_PERIOD_LENGTH_LENGTH_4                              (0x10 << WAKEUP_MINIMUM_PERIOD_LENGTH_LENGTH_Pos)   /*!<0x00000100 */
#define WAKEUP_MINIMUM_PERIOD_LENGTH_LENGTH_5                              (0x20 << WAKEUP_MINIMUM_PERIOD_LENGTH_LENGTH_Pos)   /*!<0x00000200 */
#define WAKEUP_MINIMUM_PERIOD_LENGTH_LENGTH_6                              (0x40 << WAKEUP_MINIMUM_PERIOD_LENGTH_LENGTH_Pos)   /*!<0x00000400 */
#define WAKEUP_MINIMUM_PERIOD_LENGTH_LENGTH_7                              (0x80 << WAKEUP_MINIMUM_PERIOD_LENGTH_LENGTH_Pos)   /*!<0x00000800 */
#define WAKEUP_MINIMUM_PERIOD_LENGTH_LENGTH_8                              (0x100 << WAKEUP_MINIMUM_PERIOD_LENGTH_LENGTH_Pos)   /*!<0x00001000 */
#define WAKEUP_MINIMUM_PERIOD_LENGTH_LENGTH_9                              (0x200 << WAKEUP_MINIMUM_PERIOD_LENGTH_LENGTH_Pos)   /*!<0x00002000 */

/* ===============================================   AVERAGE_PERIOD_LENGTH   =============================================== */
#define WAKEUP_AVERAGE_PERIOD_LENGTH_LENGTH_FRACT_Pos                      (0UL)   /*!< WAKEUP AVERAGE_PERIOD_LENGTH: LENGTH_FRACT (Bit 0) */
#define WAKEUP_AVERAGE_PERIOD_LENGTH_LENGTH_FRACT_Msk                      (0x0000000fUL)  /*!< WAKEUP AVERAGE_PERIOD_LENGTH: LENGTH_FRACT (Bitfield-Mask: 0xf) */
#define WAKEUP_AVERAGE_PERIOD_LENGTH_LENGTH_FRACT                          WAKEUP_AVERAGE_PERIOD_LENGTH_LENGTH_FRACT_Msk
#define WAKEUP_AVERAGE_PERIOD_LENGTH_LENGTH_FRACT_0                        (0x1 << WAKEUP_AVERAGE_PERIOD_LENGTH_LENGTH_FRACT_Pos)   /*!<0x00000001 */
#define WAKEUP_AVERAGE_PERIOD_LENGTH_LENGTH_FRACT_1                        (0x2 << WAKEUP_AVERAGE_PERIOD_LENGTH_LENGTH_FRACT_Pos)   /*!<0x00000002 */
#define WAKEUP_AVERAGE_PERIOD_LENGTH_LENGTH_FRACT_2                        (0x4 << WAKEUP_AVERAGE_PERIOD_LENGTH_LENGTH_FRACT_Pos)   /*!<0x00000004 */
#define WAKEUP_AVERAGE_PERIOD_LENGTH_LENGTH_FRACT_3                        (0x8 << WAKEUP_AVERAGE_PERIOD_LENGTH_LENGTH_FRACT_Pos)   /*!<0x00000008 */
#define WAKEUP_AVERAGE_PERIOD_LENGTH_LENGTH_INT_Pos                        (4UL)   /*!< WAKEUP AVERAGE_PERIOD_LENGTH: LENGTH_INT (Bit 4) */
#define WAKEUP_AVERAGE_PERIOD_LENGTH_LENGTH_INT_Msk                        (0x00003ff0UL)  /*!< WAKEUP AVERAGE_PERIOD_LENGTH: LENGTH_INT (Bitfield-Mask: 0x3ff) */
#define WAKEUP_AVERAGE_PERIOD_LENGTH_LENGTH_INT                            WAKEUP_AVERAGE_PERIOD_LENGTH_LENGTH_INT_Msk
#define WAKEUP_AVERAGE_PERIOD_LENGTH_LENGTH_INT_0                          (0x01 << WAKEUP_AVERAGE_PERIOD_LENGTH_LENGTH_INT_Pos)   /*!<0x00000010 */
#define WAKEUP_AVERAGE_PERIOD_LENGTH_LENGTH_INT_1                          (0x02 << WAKEUP_AVERAGE_PERIOD_LENGTH_LENGTH_INT_Pos)   /*!<0x00000020 */
#define WAKEUP_AVERAGE_PERIOD_LENGTH_LENGTH_INT_2                          (0x04 << WAKEUP_AVERAGE_PERIOD_LENGTH_LENGTH_INT_Pos)   /*!<0x00000040 */
#define WAKEUP_AVERAGE_PERIOD_LENGTH_LENGTH_INT_3                          (0x08 << WAKEUP_AVERAGE_PERIOD_LENGTH_LENGTH_INT_Pos)   /*!<0x00000080 */
#define WAKEUP_AVERAGE_PERIOD_LENGTH_LENGTH_INT_4                          (0x10 << WAKEUP_AVERAGE_PERIOD_LENGTH_LENGTH_INT_Pos)   /*!<0x00000100 */
#define WAKEUP_AVERAGE_PERIOD_LENGTH_LENGTH_INT_5                          (0x20 << WAKEUP_AVERAGE_PERIOD_LENGTH_LENGTH_INT_Pos)   /*!<0x00000200 */
#define WAKEUP_AVERAGE_PERIOD_LENGTH_LENGTH_INT_6                          (0x40 << WAKEUP_AVERAGE_PERIOD_LENGTH_LENGTH_INT_Pos)   /*!<0x00000400 */
#define WAKEUP_AVERAGE_PERIOD_LENGTH_LENGTH_INT_7                          (0x80 << WAKEUP_AVERAGE_PERIOD_LENGTH_LENGTH_INT_Pos)   /*!<0x00000800 */
#define WAKEUP_AVERAGE_PERIOD_LENGTH_LENGTH_INT_8                          (0x100 << WAKEUP_AVERAGE_PERIOD_LENGTH_LENGTH_INT_Pos)   /*!<0x00001000 */
#define WAKEUP_AVERAGE_PERIOD_LENGTH_LENGTH_INT_9                          (0x200 << WAKEUP_AVERAGE_PERIOD_LENGTH_LENGTH_INT_Pos)   /*!<0x00002000 */
#define WAKEUP_AVERAGE_PERIOD_LENGTH_AVERAGE_COUNT_Pos                     (24UL)   /*!< WAKEUP AVERAGE_PERIOD_LENGTH: AVERAGE_COUNT (Bit 24) */
#define WAKEUP_AVERAGE_PERIOD_LENGTH_AVERAGE_COUNT_Msk                     (0xff000000UL)  /*!< WAKEUP AVERAGE_PERIOD_LENGTH: AVERAGE_COUNT (Bitfield-Mask: 0xff) */
#define WAKEUP_AVERAGE_PERIOD_LENGTH_AVERAGE_COUNT                         WAKEUP_AVERAGE_PERIOD_LENGTH_AVERAGE_COUNT_Msk
#define WAKEUP_AVERAGE_PERIOD_LENGTH_AVERAGE_COUNT_0                       (0x01 << WAKEUP_AVERAGE_PERIOD_LENGTH_AVERAGE_COUNT_Pos)   /*!<0x01000000 */
#define WAKEUP_AVERAGE_PERIOD_LENGTH_AVERAGE_COUNT_1                       (0x02 << WAKEUP_AVERAGE_PERIOD_LENGTH_AVERAGE_COUNT_Pos)   /*!<0x02000000 */
#define WAKEUP_AVERAGE_PERIOD_LENGTH_AVERAGE_COUNT_2                       (0x04 << WAKEUP_AVERAGE_PERIOD_LENGTH_AVERAGE_COUNT_Pos)   /*!<0x04000000 */
#define WAKEUP_AVERAGE_PERIOD_LENGTH_AVERAGE_COUNT_3                       (0x08 << WAKEUP_AVERAGE_PERIOD_LENGTH_AVERAGE_COUNT_Pos)   /*!<0x08000000 */
#define WAKEUP_AVERAGE_PERIOD_LENGTH_AVERAGE_COUNT_4                       (0x10 << WAKEUP_AVERAGE_PERIOD_LENGTH_AVERAGE_COUNT_Pos)   /*!<0x10000000 */
#define WAKEUP_AVERAGE_PERIOD_LENGTH_AVERAGE_COUNT_5                       (0x20 << WAKEUP_AVERAGE_PERIOD_LENGTH_AVERAGE_COUNT_Pos)   /*!<0x20000000 */
#define WAKEUP_AVERAGE_PERIOD_LENGTH_AVERAGE_COUNT_6                       (0x40 << WAKEUP_AVERAGE_PERIOD_LENGTH_AVERAGE_COUNT_Pos)   /*!<0x40000000 */
#define WAKEUP_AVERAGE_PERIOD_LENGTH_AVERAGE_COUNT_7                       (0x80 << WAKEUP_AVERAGE_PERIOD_LENGTH_AVERAGE_COUNT_Pos)   /*!<0x80000000 */

/* ===============================================   MAXIMUM_PERIOD_LENGTH   =============================================== */
#define WAKEUP_MAXIMUM_PERIOD_LEN