# Data Structures and Algorithms

## Lists
  * Linked List
  * Doubly Linked List
  * Skip List
  
## Arrays
  * Circular Array
  * ArrayList
  * Sorted Array
      * Merge Sort 
      * Bubble Sort
      * Quick Sort
      * Insertion Sort
      * Selection Sort
  * Associative array
  
## Stacks
  * Arrayed Stack
  * Circular Stack
  * Linked Stack
  
## Queues
  * Arrayed Queue
  * Linked Queue
  * Circular Queue
  * Priority Queue
  * Deque
  
## Heaps
  * Arrayed Heap
  * Linked Heap
  * Min Heap
  * Max Heap
     * Heap Sort
  
## Trees 
  * Binary Tree
     * Preorder Traversal
     * Post order traversal
     * In Order Traversal
     * Depth Frist Search
     * Breadth First Search
  * Self Balancing Binary Tree
  * B-Tree
  * AVL Tree
  * Splay Tree
  * Red Balck Tree
  
## Hashtables
  * Hashtable
     * Separate chaining
     * Open addressing
     * Dynamic resizing
  * Hash-Set
  
## Graphs
  * Undirected Graph
  * Directed Graph
     * Preorder Traversal
     * Post order traversal
     * In Order Traversal
     * Depth Frist Search
     * Breadth First Search
     
# Design Paterns

## Creational Patterns

 * Abstract Factory	
 * Builder	
 * Dependency Injection	
 * Factory Method	
 * Lazy Initialization	
 * Multiton	
 * Object Pool	
 * Prototype	Specify
 * Resource Acquisition is Initialization 
 * Singleton
 
 ## Structural Patterns
 
 * Adapter, Wrapper, or Translator
 * Bridge	
 * Composite	
 * Decorator	
 * Extension Object	
 * Facade	
 * Flyweight
 * Front Controller
 * Marker	
 * Module	
 * Proxy	
 * Twin
 
 ## Behavioral patterns
 
 * Blackboard	
 * Chain of responsibility	
 * Command	
 * Interpreter	
 * Iterator	
 * Mediator	
 * Memento	
 * Null object	
 * Observer or Publish/subscribe	
 * Servant	
 * Specification	
 * State	
 * Strategy	
 * Template method	
 * Visitor
 
 ## Concurrency Patterns
 
 * Active Object	
 * Balking	
 * Binding properties	
 * Compute kernel	
 * Double-checked locking	
 * Event-based asynchronous	
 * Guarded suspension	
 * Join	
 * Lock	
 * Messaging design pattern 
 * Monitor object
 * Reactor
 * Read-write lock	
 * Scheduler	
 * Thread pool	
 * Thread-specific storage
