# Contributing Guidelines for ASCII-Converter 👨‍💻

## 👨‍💻 Prerequisite Skills to Contribute

- [Git](https://git-scm.com/)
- [Basic JavaScript](https://developer.mozilla.org/en-US/docs/Web/JavaScript)
- [NodeJS](https://nodejs.org/)

### Contribute in Documents

- [Markdown](https://www.markdownguide.org/basic-syntax/)

---

## 💥 How to Contribute

[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat-square)](https://github.com/hafeez25/ASCII-Converter/pulls)
[![Open Source Love](https://badges.frapsoft.com/os/v1/open-source.png?v=103)](https://github.com/hafeez25/ASCII-Converter/)

- Take a look at the existing [Issues](https://github.com/hafeez25/ASCII-Converter/issues) or [create a new issue](https://github.com/hafeez25/ASCII-Converter/issues/new/choose)!
- [Fork the Repo](https://github.com/hafeez25/ASCII-Converter/fork). Then, create a branch for any issue that you are working on. Finally, commit your work.
- Create a **[Pull Request](https://github.com/hafeez25/ASCII-Converter/compare)** (_PR_), which will be promptly reviewed and given suggestions for improvements by the community.
- Add screenshots or screen captures to your Pull Request to help us understand the effects of the changes proposed in your PR.

---

## ⭐ HOW TO MAKE A PULL REQUEST:

**1.** Start by making a Fork of the [**ASCII-Converter**](https://github.com/hafeez25/ASCII-Converter) repository. Click on the <a href="https://github.com/hafeez25/ASCII-Converter/fork"><img src="https://i.imgur.com/G4z1kEe.png" height="21" width="21"></a>Fork symbol at the top right corner.

**2.** Clone your new fork of the repository in the terminal/CLI on your computer with the following command:

```bash
git clone https://github.com/<your-github-username>/ASCII-Converter
```

**3.** Navigate to the newly created LinkFree project directory:

```bash
cd ASCII-Converter
```

**4.** Create a new branch:

```bash
git checkout -b YourBranchName
```

⚠️ **Make sure** not to commit `package.json` or `package-lock.json` file

⚠️ **Make sure** not to run the commands `git add .` or `git add *`. Instead, stage your changes for each file/folder

**5.** Add those changes to the branch you just created using the git add command:

```bash
git add .
```

- After git add command see status with git status command:

```bash
git status
```

**6.** Now commit those changes using the git commit command::

```bash
git commit -m "<your_commit_message>"
```

**7.** Push your local commits to the remote repository:

```bash
git push origin YourBranchName
```

**8.** Create a [Pull Request](https://help.github.com/en/github/collaborating-with-issues-and-pull-requests/creating-a-pull-request)!

**9.** **Congratulations!** You've made your first contribution to [**ASCII-Converter**](https://github.com/hafeez25/ASCII-Converter/graphs/contributors)! 🙌🏼

**_:trophy: After this, the maintainers will review the PR and will merge it if it helps move the YourQuotes project forward. Otherwise, it will be given constructive feedback and suggestions for the changes needed to add the PR to the codebase._**

---

## Style Guide for Git Commit Messages :memo:

**How you can add more value to your contribution logs:**

- Use the present tense. (Example: "Add feature" instead of "Added feature")
- Use the imperative mood. (Example: "Move item to...", instead of "Moves item to...")
- Limit the first line (also called the Subject Line) to _50 characters or less_.
- Capitalize the Subject Line.
- Separate subject from body with a blank line.
- Do not end the subject line with a period.
- Wrap the body at _72 characters_.
- Use the body to explain the _what_, _why_, _vs_, and _how_.
- Reference [Issues](https://github.com/hafeez25/ASCII-Converter/issues) and [Pull Requests](https://github.com/hafeez25/ASCII-Converter/pulls) liberally after the first line.

---

## 💥 Issues

In order to discuss changes, you are welcome to [open an issue](https://github.com/hafeez25/ASCII-Converter/issues/new/choose) about what you would like to contribute. Enhancements are always encouraged and appreciated.

## All the best! 🥇

[![built with love](https://forthebadge.com/images/badges/built-with-love.svg)](https://github.com/hafeez25/ASCII-Converter)
