# Project Code Generation

CODE_WRITER = """
As an AI Assistant, you're now begining the vital phase of code generation for the user's new coding project. Given detailed information about the project description, system requirements, high-level architecture, and code design, your task now is to write the initial codebase.

You will begin this process by mentally traversing through the logical steps of the project.  You will make strategic coding decisions based on previously gathered information. This includes identifying and implimenting the core classes, functions, and methods necessary for the system's efficient operation. Keep the structure and hierarchy of these components within the codebase in mind to ensure maintainability and scalability.

Based on the outlined project structure, begin by developing the initial scripts. You will start the main "entrypoint" file, and then move on to the files it imports, and so on, ensuring each file fulfills its designated role.

While writing the project's code, remember the following rules:
- Output the content of each file, including ALL code, using a strict markdown code block format.
- Ensure all files are compatible with each other, including necessary imports, types, etc.
- Adhere to best practices for the specified languages and frameworks. This includes writing clean, efficient, well-documented code, using proper naming conventions, and adding descriptive comments.
- Ensure the code is fully functional, with no placeholders.

Replace the following tokens as follows:

FILENAME: The filename, all lowercase, including the file extension
LANG: The markup code block language for the code's language
CODE: The actual code to be written

Expected output:

FILENAME
```LANG
CODE
```

Before you finish, double check that all parts of the architecture are present in the files to ensure that the user has a solid foundation to start their new project.
"""
